// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accesscontextmanager

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	accesscontextmanagerpb "google.golang.org/genproto/googleapis/identity/accesscontextmanager/v1"
	longrunningpb "google.golang.org/genproto/googleapis/longrunning"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListAccessPolicies         []gax.CallOption
	GetAccessPolicy            []gax.CallOption
	CreateAccessPolicy         []gax.CallOption
	UpdateAccessPolicy         []gax.CallOption
	DeleteAccessPolicy         []gax.CallOption
	ListAccessLevels           []gax.CallOption
	GetAccessLevel             []gax.CallOption
	CreateAccessLevel          []gax.CallOption
	UpdateAccessLevel          []gax.CallOption
	DeleteAccessLevel          []gax.CallOption
	ReplaceAccessLevels        []gax.CallOption
	ListServicePerimeters      []gax.CallOption
	GetServicePerimeter        []gax.CallOption
	CreateServicePerimeter     []gax.CallOption
	UpdateServicePerimeter     []gax.CallOption
	DeleteServicePerimeter     []gax.CallOption
	ReplaceServicePerimeters   []gax.CallOption
	CommitServicePerimeters    []gax.CallOption
	ListGcpUserAccessBindings  []gax.CallOption
	GetGcpUserAccessBinding    []gax.CallOption
	CreateGcpUserAccessBinding []gax.CallOption
	UpdateGcpUserAccessBinding []gax.CallOption
	DeleteGcpUserAccessBinding []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("accesscontextmanager.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("accesscontextmanager.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://accesscontextmanager.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListAccessPolicies:         []gax.CallOption{},
		GetAccessPolicy:            []gax.CallOption{},
		CreateAccessPolicy:         []gax.CallOption{},
		UpdateAccessPolicy:         []gax.CallOption{},
		DeleteAccessPolicy:         []gax.CallOption{},
		ListAccessLevels:           []gax.CallOption{},
		GetAccessLevel:             []gax.CallOption{},
		CreateAccessLevel:          []gax.CallOption{},
		UpdateAccessLevel:          []gax.CallOption{},
		DeleteAccessLevel:          []gax.CallOption{},
		ReplaceAccessLevels:        []gax.CallOption{},
		ListServicePerimeters:      []gax.CallOption{},
		GetServicePerimeter:        []gax.CallOption{},
		CreateServicePerimeter:     []gax.CallOption{},
		UpdateServicePerimeter:     []gax.CallOption{},
		DeleteServicePerimeter:     []gax.CallOption{},
		ReplaceServicePerimeters:   []gax.CallOption{},
		CommitServicePerimeters:    []gax.CallOption{},
		ListGcpUserAccessBindings:  []gax.CallOption{},
		GetGcpUserAccessBinding:    []gax.CallOption{},
		CreateGcpUserAccessBinding: []gax.CallOption{},
		UpdateGcpUserAccessBinding: []gax.CallOption{},
		DeleteGcpUserAccessBinding: []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Access Context Manager API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListAccessPolicies(context.Context, *accesscontextmanagerpb.ListAccessPoliciesRequest, ...gax.CallOption) *AccessPolicyIterator
	GetAccessPolicy(context.Context, *accesscontextmanagerpb.GetAccessPolicyRequest, ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error)
	CreateAccessPolicy(context.Context, *accesscontextmanagerpb.AccessPolicy, ...gax.CallOption) (*CreateAccessPolicyOperation, error)
	CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation
	UpdateAccessPolicy(context.Context, *accesscontextmanagerpb.UpdateAccessPolicyRequest, ...gax.CallOption) (*UpdateAccessPolicyOperation, error)
	UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation
	DeleteAccessPolicy(context.Context, *accesscontextmanagerpb.DeleteAccessPolicyRequest, ...gax.CallOption) (*DeleteAccessPolicyOperation, error)
	DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation
	ListAccessLevels(context.Context, *accesscontextmanagerpb.ListAccessLevelsRequest, ...gax.CallOption) *AccessLevelIterator
	GetAccessLevel(context.Context, *accesscontextmanagerpb.GetAccessLevelRequest, ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error)
	CreateAccessLevel(context.Context, *accesscontextmanagerpb.CreateAccessLevelRequest, ...gax.CallOption) (*CreateAccessLevelOperation, error)
	CreateAccessLevelOperation(name string) *CreateAccessLevelOperation
	UpdateAccessLevel(context.Context, *accesscontextmanagerpb.UpdateAccessLevelRequest, ...gax.CallOption) (*UpdateAccessLevelOperation, error)
	UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation
	DeleteAccessLevel(context.Context, *accesscontextmanagerpb.DeleteAccessLevelRequest, ...gax.CallOption) (*DeleteAccessLevelOperation, error)
	DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation
	ReplaceAccessLevels(context.Context, *accesscontextmanagerpb.ReplaceAccessLevelsRequest, ...gax.CallOption) (*ReplaceAccessLevelsOperation, error)
	ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation
	ListServicePerimeters(context.Context, *accesscontextmanagerpb.ListServicePerimetersRequest, ...gax.CallOption) *ServicePerimeterIterator
	GetServicePerimeter(context.Context, *accesscontextmanagerpb.GetServicePerimeterRequest, ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error)
	CreateServicePerimeter(context.Context, *accesscontextmanagerpb.CreateServicePerimeterRequest, ...gax.CallOption) (*CreateServicePerimeterOperation, error)
	CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation
	UpdateServicePerimeter(context.Context, *accesscontextmanagerpb.UpdateServicePerimeterRequest, ...gax.CallOption) (*UpdateServicePerimeterOperation, error)
	UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation
	DeleteServicePerimeter(context.Context, *accesscontextmanagerpb.DeleteServicePerimeterRequest, ...gax.CallOption) (*DeleteServicePerimeterOperation, error)
	DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation
	ReplaceServicePerimeters(context.Context, *accesscontextmanagerpb.ReplaceServicePerimetersRequest, ...gax.CallOption) (*ReplaceServicePerimetersOperation, error)
	ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation
	CommitServicePerimeters(context.Context, *accesscontextmanagerpb.CommitServicePerimetersRequest, ...gax.CallOption) (*CommitServicePerimetersOperation, error)
	CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation
	ListGcpUserAccessBindings(context.Context, *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, ...gax.CallOption) *GcpUserAccessBindingIterator
	GetGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error)
	CreateGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error)
	CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation
	UpdateGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error)
	UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation
	DeleteGcpUserAccessBinding(context.Context, *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error)
	DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation
}

// Client is a client for interacting with Access Context Manager API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// API for setting [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] and [Service
// Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
// for Google Cloud Projects. Each organization has one [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] containing the
// [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
// and [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
// applicable to all resources in the organization.
// AccessPolicies
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListAccessPolicies list all [AccessPolicies]
// [google.identity.accesscontextmanager.v1.AccessPolicy] under a
// container.
func (c *Client) ListAccessPolicies(ctx context.Context, req *accesscontextmanagerpb.ListAccessPoliciesRequest, opts ...gax.CallOption) *AccessPolicyIterator {
	return c.internalClient.ListAccessPolicies(ctx, req, opts...)
}

// GetAccessPolicy get an [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] by name.
func (c *Client) GetAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.GetAccessPolicyRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	return c.internalClient.GetAccessPolicy(ctx, req, opts...)
}

// CreateAccessPolicy create an AccessPolicy. Fails if this organization already has a
// AccessPolicy. The longrunning Operation will have a successful status
// once the AccessPolicy has propagated to long-lasting storage.
// Syntactic and basic semantic errors will be returned in metadata as a
// BadRequest proto.
func (c *Client) CreateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.AccessPolicy, opts ...gax.CallOption) (*CreateAccessPolicyOperation, error) {
	return c.internalClient.CreateAccessPolicy(ctx, req, opts...)
}

// CreateAccessPolicyOperation returns a new CreateAccessPolicyOperation from a given name.
// The name must be that of a previously created CreateAccessPolicyOperation, possibly from a different process.
func (c *Client) CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation {
	return c.internalClient.CreateAccessPolicyOperation(name)
}

// UpdateAccessPolicy update an [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
// longrunning Operation from this RPC will have a successful status once the
// changes to the [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] have propagated
// to long-lasting storage. Syntactic and basic semantic errors will be
// returned in metadata as a BadRequest proto.
func (c *Client) UpdateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessPolicyRequest, opts ...gax.CallOption) (*UpdateAccessPolicyOperation, error) {
	return c.internalClient.UpdateAccessPolicy(ctx, req, opts...)
}

// UpdateAccessPolicyOperation returns a new UpdateAccessPolicyOperation from a given name.
// The name must be that of a previously created UpdateAccessPolicyOperation, possibly from a different process.
func (c *Client) UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation {
	return c.internalClient.UpdateAccessPolicyOperation(name)
}

// DeleteAccessPolicy delete an [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] by resource
// name. The longrunning Operation will have a successful status once the
// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy]
// has been removed from long-lasting storage.
func (c *Client) DeleteAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessPolicyRequest, opts ...gax.CallOption) (*DeleteAccessPolicyOperation, error) {
	return c.internalClient.DeleteAccessPolicy(ctx, req, opts...)
}

// DeleteAccessPolicyOperation returns a new DeleteAccessPolicyOperation from a given name.
// The name must be that of a previously created DeleteAccessPolicyOperation, possibly from a different process.
func (c *Client) DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation {
	return c.internalClient.DeleteAccessPolicyOperation(name)
}

// ListAccessLevels list all [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
// policy.
func (c *Client) ListAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ListAccessLevelsRequest, opts ...gax.CallOption) *AccessLevelIterator {
	return c.internalClient.ListAccessLevels(ctx, req, opts...)
}

// GetAccessLevel get an [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
// name.
func (c *Client) GetAccessLevel(ctx context.Context, req *accesscontextmanagerpb.GetAccessLevelRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	return c.internalClient.GetAccessLevel(ctx, req, opts...)
}

// CreateAccessLevel create an [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
// operation from this RPC will have a successful status once the [Access
// Level] [google.identity.accesscontextmanager.v1.AccessLevel] has
// propagated to long-lasting storage. [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] containing
// errors will result in an error response for the first error encountered.
func (c *Client) CreateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.CreateAccessLevelRequest, opts ...gax.CallOption) (*CreateAccessLevelOperation, error) {
	return c.internalClient.CreateAccessLevel(ctx, req, opts...)
}

// CreateAccessLevelOperation returns a new CreateAccessLevelOperation from a given name.
// The name must be that of a previously created CreateAccessLevelOperation, possibly from a different process.
func (c *Client) CreateAccessLevelOperation(name string) *CreateAccessLevelOperation {
	return c.internalClient.CreateAccessLevelOperation(name)
}

// UpdateAccessLevel update an [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel]. The longrunning
// operation from this RPC will have a successful status once the changes to
// the [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel] have propagated
// to long-lasting storage. [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] containing
// errors will result in an error response for the first error encountered.
func (c *Client) UpdateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessLevelRequest, opts ...gax.CallOption) (*UpdateAccessLevelOperation, error) {
	return c.internalClient.UpdateAccessLevel(ctx, req, opts...)
}

// UpdateAccessLevelOperation returns a new UpdateAccessLevelOperation from a given name.
// The name must be that of a previously created UpdateAccessLevelOperation, possibly from a different process.
func (c *Client) UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation {
	return c.internalClient.UpdateAccessLevelOperation(name)
}

// DeleteAccessLevel delete an [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel] by resource
// name. The longrunning operation from this RPC will have a successful status
// once the [Access Level]
// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
// from long-lasting storage.
func (c *Client) DeleteAccessLevel(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessLevelRequest, opts ...gax.CallOption) (*DeleteAccessLevelOperation, error) {
	return c.internalClient.DeleteAccessLevel(ctx, req, opts...)
}

// DeleteAccessLevelOperation returns a new DeleteAccessLevelOperation from a given name.
// The name must be that of a previously created DeleteAccessLevelOperation, possibly from a different process.
func (c *Client) DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation {
	return c.internalClient.DeleteAccessLevelOperation(name)
}

// ReplaceAccessLevels replace all existing [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] in an [Access
// Policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
// the [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
// is done atomically. The longrunning operation from this RPC will have a
// successful status once all replacements have propagated to long-lasting
// storage. Replacements containing errors will result in an error response
// for the first error encountered.  Replacement will be cancelled on error,
// existing [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] will not be
// affected. Operation.response field will contain
// ReplaceAccessLevelsResponse. Removing [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
// [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] will result in
// error.
func (c *Client) ReplaceAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ReplaceAccessLevelsRequest, opts ...gax.CallOption) (*ReplaceAccessLevelsOperation, error) {
	return c.internalClient.ReplaceAccessLevels(ctx, req, opts...)
}

// ReplaceAccessLevelsOperation returns a new ReplaceAccessLevelsOperation from a given name.
// The name must be that of a previously created ReplaceAccessLevelsOperation, possibly from a different process.
func (c *Client) ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation {
	return c.internalClient.ReplaceAccessLevelsOperation(name)
}

// ListServicePerimeters list all [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
// access policy.
func (c *Client) ListServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ListServicePerimetersRequest, opts ...gax.CallOption) *ServicePerimeterIterator {
	return c.internalClient.ListServicePerimeters(ctx, req, opts...)
}

// GetServicePerimeter get a [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
// name.
func (c *Client) GetServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.GetServicePerimeterRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	return c.internalClient.GetServicePerimeter(ctx, req, opts...)
}

// CreateServicePerimeter create a [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// longrunning operation from this RPC will have a successful status once the
// [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] has
// propagated to long-lasting storage. [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
// errors will result in an error response for the first error encountered.
func (c *Client) CreateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.CreateServicePerimeterRequest, opts ...gax.CallOption) (*CreateServicePerimeterOperation, error) {
	return c.internalClient.CreateServicePerimeter(ctx, req, opts...)
}

// CreateServicePerimeterOperation returns a new CreateServicePerimeterOperation from a given name.
// The name must be that of a previously created CreateServicePerimeterOperation, possibly from a different process.
func (c *Client) CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation {
	return c.internalClient.CreateServicePerimeterOperation(name)
}

// UpdateServicePerimeter update a [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
// longrunning operation from this RPC will have a successful status once the
// changes to the [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] have
// propagated to long-lasting storage. [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] containing
// errors will result in an error response for the first error encountered.
func (c *Client) UpdateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.UpdateServicePerimeterRequest, opts ...gax.CallOption) (*UpdateServicePerimeterOperation, error) {
	return c.internalClient.UpdateServicePerimeter(ctx, req, opts...)
}

// UpdateServicePerimeterOperation returns a new UpdateServicePerimeterOperation from a given name.
// The name must be that of a previously created UpdateServicePerimeterOperation, possibly from a different process.
func (c *Client) UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation {
	return c.internalClient.UpdateServicePerimeterOperation(name)
}

// DeleteServicePerimeter delete a [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] by resource
// name. The longrunning operation from this RPC will have a successful status
// once the [Service Perimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] has been
// removed from long-lasting storage.
func (c *Client) DeleteServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.DeleteServicePerimeterRequest, opts ...gax.CallOption) (*DeleteServicePerimeterOperation, error) {
	return c.internalClient.DeleteServicePerimeter(ctx, req, opts...)
}

// DeleteServicePerimeterOperation returns a new DeleteServicePerimeterOperation from a given name.
// The name must be that of a previously created DeleteServicePerimeterOperation, possibly from a different process.
func (c *Client) DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation {
	return c.internalClient.DeleteServicePerimeterOperation(name)
}

// ReplaceServicePerimeters replace all existing [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
// [Access Policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
// with the [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided.
// This is done atomically. The longrunning operation from this
// RPC will have a successful status once all replacements have propagated to
// long-lasting storage. Replacements containing errors will result in an
// error response for the first error encountered. Replacement will be
// cancelled on error, existing [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] will not be
// affected. Operation.response field will contain
// ReplaceServicePerimetersResponse.
func (c *Client) ReplaceServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ReplaceServicePerimetersRequest, opts ...gax.CallOption) (*ReplaceServicePerimetersOperation, error) {
	return c.internalClient.ReplaceServicePerimeters(ctx, req, opts...)
}

// ReplaceServicePerimetersOperation returns a new ReplaceServicePerimetersOperation from a given name.
// The name must be that of a previously created ReplaceServicePerimetersOperation, possibly from a different process.
func (c *Client) ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation {
	return c.internalClient.ReplaceServicePerimetersOperation(name)
}

// CommitServicePerimeters commit the dry-run spec for all the [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
// [Access Policy][google.identity.accesscontextmanager.v1.AccessPolicy].
// A commit operation on a Service Perimeter involves copying its spec field
// to that Service Perimeter’s status field. Only [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
// use_explicit_dry_run_spec field set to true are affected by a commit
// operation. The longrunning operation from this RPC will have a successful
// status once the dry-run specs for all the [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
// committed. If a commit fails, it will cause the longrunning operation to
// return an error response and the entire commit operation will be cancelled.
// When successful, Operation.response field will contain
// CommitServicePerimetersResponse. The dry_run and the spec fields will
// be cleared after a successful commit operation.
func (c *Client) CommitServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.CommitServicePerimetersRequest, opts ...gax.CallOption) (*CommitServicePerimetersOperation, error) {
	return c.internalClient.CommitServicePerimeters(ctx, req, opts...)
}

// CommitServicePerimetersOperation returns a new CommitServicePerimetersOperation from a given name.
// The name must be that of a previously created CommitServicePerimetersOperation, possibly from a different process.
func (c *Client) CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation {
	return c.internalClient.CommitServicePerimetersOperation(name)
}

// ListGcpUserAccessBindings lists all [GcpUserAccessBindings]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
// Google Cloud organization.
func (c *Client) ListGcpUserAccessBindings(ctx context.Context, req *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, opts ...gax.CallOption) *GcpUserAccessBindingIterator {
	return c.internalClient.ListGcpUserAccessBindings(ctx, req, opts...)
}

// GetGcpUserAccessBinding gets the [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
// the given name.
func (c *Client) GetGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	return c.internalClient.GetGcpUserAccessBinding(ctx, req, opts...)
}

// CreateGcpUserAccessBinding creates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
// client specifies a [name]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name (at http://google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name)],
// the server will ignore it. Fails if a resource already exists with the same
// [group_key]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
// Completion of this long-running operation does not necessarily signify that
// the new binding is deployed onto all affected users, which may take more
// time.
func (c *Client) CreateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error) {
	return c.internalClient.CreateGcpUserAccessBinding(ctx, req, opts...)
}

// CreateGcpUserAccessBindingOperation returns a new CreateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created CreateGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation {
	return c.internalClient.CreateGcpUserAccessBindingOperation(name)
}

// UpdateGcpUserAccessBinding updates a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the changed binding is deployed onto all affected users, which may take
// more time.
func (c *Client) UpdateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error) {
	return c.internalClient.UpdateGcpUserAccessBinding(ctx, req, opts...)
}

// UpdateGcpUserAccessBindingOperation returns a new UpdateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created UpdateGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation {
	return c.internalClient.UpdateGcpUserAccessBindingOperation(name)
}

// DeleteGcpUserAccessBinding deletes a [GcpUserAccessBinding]
// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
// Completion of this long-running operation does not necessarily signify that
// the binding deletion is deployed onto all affected users, which may take
// more time.
func (c *Client) DeleteGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, opts ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error) {
	return c.internalClient.DeleteGcpUserAccessBinding(ctx, req, opts...)
}

// DeleteGcpUserAccessBindingOperation returns a new DeleteGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created DeleteGcpUserAccessBindingOperation, possibly from a different process.
func (c *Client) DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation {
	return c.internalClient.DeleteGcpUserAccessBindingOperation(name)
}

// gRPCClient is a client for interacting with Access Context Manager API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client accesscontextmanagerpb.AccessContextManagerClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewClient creates a new access context manager client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// API for setting [Access Levels]
// [google.identity.accesscontextmanager.v1.AccessLevel] and [Service
// Perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
// for Google Cloud Projects. Each organization has one [AccessPolicy]
// [google.identity.accesscontextmanager.v1.AccessPolicy] containing the
// [Access Levels] [google.identity.accesscontextmanager.v1.AccessLevel]
// and [Service Perimeters]
// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
// [AccessPolicy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
// applicable to all resources in the organization.
// AccessPolicies
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		disableDeadlines: disableDeadlines,
		client:           accesscontextmanagerpb.NewAccessContextManagerClient(connPool),
		CallOptions:      &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *gRPCClient) ListAccessPolicies(ctx context.Context, req *accesscontextmanagerpb.ListAccessPoliciesRequest, opts ...gax.CallOption) *AccessPolicyIterator {
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append((*c.CallOptions).ListAccessPolicies[0:len((*c.CallOptions).ListAccessPolicies):len((*c.CallOptions).ListAccessPolicies)], opts...)
	it := &AccessPolicyIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessPoliciesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessPolicy, string, error) {
		resp := &accesscontextmanagerpb.ListAccessPoliciesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListAccessPolicies(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccessPolicies(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.GetAccessPolicyRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAccessPolicy[0:len((*c.CallOptions).GetAccessPolicy):len((*c.CallOptions).GetAccessPolicy)], opts...)
	var resp *accesscontextmanagerpb.AccessPolicy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetAccessPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.AccessPolicy, opts ...gax.CallOption) (*CreateAccessPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	ctx = insertMetadata(ctx, c.xGoogMetadata)
	opts = append((*c.CallOptions).CreateAccessPolicy[0:len((*c.CallOptions).CreateAccessPolicy):len((*c.CallOptions).CreateAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateAccessPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessPolicyRequest, opts ...gax.CallOption) (*UpdateAccessPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "policy.name", url.QueryEscape(req.GetPolicy().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAccessPolicy[0:len((*c.CallOptions).UpdateAccessPolicy):len((*c.CallOptions).UpdateAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateAccessPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteAccessPolicy(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessPolicyRequest, opts ...gax.CallOption) (*DeleteAccessPolicyOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAccessPolicy[0:len((*c.CallOptions).DeleteAccessPolicy):len((*c.CallOptions).DeleteAccessPolicy)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteAccessPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ListAccessLevelsRequest, opts ...gax.CallOption) *AccessLevelIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAccessLevels[0:len((*c.CallOptions).ListAccessLevels):len((*c.CallOptions).ListAccessLevels)], opts...)
	it := &AccessLevelIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListAccessLevelsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.AccessLevel, string, error) {
		resp := &accesscontextmanagerpb.ListAccessLevelsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListAccessLevels(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetAccessLevels(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetAccessLevel(ctx context.Context, req *accesscontextmanagerpb.GetAccessLevelRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAccessLevel[0:len((*c.CallOptions).GetAccessLevel):len((*c.CallOptions).GetAccessLevel)], opts...)
	var resp *accesscontextmanagerpb.AccessLevel
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetAccessLevel(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.CreateAccessLevelRequest, opts ...gax.CallOption) (*CreateAccessLevelOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAccessLevel[0:len((*c.CallOptions).CreateAccessLevel):len((*c.CallOptions).CreateAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateAccessLevel(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateAccessLevel(ctx context.Context, req *accesscontextmanagerpb.UpdateAccessLevelRequest, opts ...gax.CallOption) (*UpdateAccessLevelOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "access_level.name", url.QueryEscape(req.GetAccessLevel().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAccessLevel[0:len((*c.CallOptions).UpdateAccessLevel):len((*c.CallOptions).UpdateAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateAccessLevel(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteAccessLevel(ctx context.Context, req *accesscontextmanagerpb.DeleteAccessLevelRequest, opts ...gax.CallOption) (*DeleteAccessLevelOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAccessLevel[0:len((*c.CallOptions).DeleteAccessLevel):len((*c.CallOptions).DeleteAccessLevel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteAccessLevel(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReplaceAccessLevels(ctx context.Context, req *accesscontextmanagerpb.ReplaceAccessLevelsRequest, opts ...gax.CallOption) (*ReplaceAccessLevelsOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ReplaceAccessLevels[0:len((*c.CallOptions).ReplaceAccessLevels):len((*c.CallOptions).ReplaceAccessLevels)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ReplaceAccessLevels(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReplaceAccessLevelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ListServicePerimetersRequest, opts ...gax.CallOption) *ServicePerimeterIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListServicePerimeters[0:len((*c.CallOptions).ListServicePerimeters):len((*c.CallOptions).ListServicePerimeters)], opts...)
	it := &ServicePerimeterIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListServicePerimetersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.ServicePerimeter, string, error) {
		resp := &accesscontextmanagerpb.ListServicePerimetersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListServicePerimeters(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetServicePerimeters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.GetServicePerimeterRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetServicePerimeter[0:len((*c.CallOptions).GetServicePerimeter):len((*c.CallOptions).GetServicePerimeter)], opts...)
	var resp *accesscontextmanagerpb.ServicePerimeter
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetServicePerimeter(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.CreateServicePerimeterRequest, opts ...gax.CallOption) (*CreateServicePerimeterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateServicePerimeter[0:len((*c.CallOptions).CreateServicePerimeter):len((*c.CallOptions).CreateServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateServicePerimeter(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.UpdateServicePerimeterRequest, opts ...gax.CallOption) (*UpdateServicePerimeterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "service_perimeter.name", url.QueryEscape(req.GetServicePerimeter().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateServicePerimeter[0:len((*c.CallOptions).UpdateServicePerimeter):len((*c.CallOptions).UpdateServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateServicePerimeter(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteServicePerimeter(ctx context.Context, req *accesscontextmanagerpb.DeleteServicePerimeterRequest, opts ...gax.CallOption) (*DeleteServicePerimeterOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteServicePerimeter[0:len((*c.CallOptions).DeleteServicePerimeter):len((*c.CallOptions).DeleteServicePerimeter)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteServicePerimeter(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ReplaceServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.ReplaceServicePerimetersRequest, opts ...gax.CallOption) (*ReplaceServicePerimetersOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ReplaceServicePerimeters[0:len((*c.CallOptions).ReplaceServicePerimeters):len((*c.CallOptions).ReplaceServicePerimeters)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ReplaceServicePerimeters(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReplaceServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CommitServicePerimeters(ctx context.Context, req *accesscontextmanagerpb.CommitServicePerimetersRequest, opts ...gax.CallOption) (*CommitServicePerimetersOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CommitServicePerimeters[0:len((*c.CallOptions).CommitServicePerimeters):len((*c.CallOptions).CommitServicePerimeters)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CommitServicePerimeters(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CommitServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListGcpUserAccessBindings(ctx context.Context, req *accesscontextmanagerpb.ListGcpUserAccessBindingsRequest, opts ...gax.CallOption) *GcpUserAccessBindingIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListGcpUserAccessBindings[0:len((*c.CallOptions).ListGcpUserAccessBindings):len((*c.CallOptions).ListGcpUserAccessBindings)], opts...)
	it := &GcpUserAccessBindingIterator{}
	req = proto.Clone(req).(*accesscontextmanagerpb.ListGcpUserAccessBindingsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*accesscontextmanagerpb.GcpUserAccessBinding, string, error) {
		resp := &accesscontextmanagerpb.ListGcpUserAccessBindingsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListGcpUserAccessBindings(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetGcpUserAccessBindings(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.GetGcpUserAccessBindingRequest, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetGcpUserAccessBinding[0:len((*c.CallOptions).GetGcpUserAccessBinding):len((*c.CallOptions).GetGcpUserAccessBinding)], opts...)
	var resp *accesscontextmanagerpb.GcpUserAccessBinding
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetGcpUserAccessBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.CreateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*CreateGcpUserAccessBindingOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateGcpUserAccessBinding[0:len((*c.CallOptions).CreateGcpUserAccessBinding):len((*c.CallOptions).CreateGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateGcpUserAccessBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) UpdateGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.UpdateGcpUserAccessBindingRequest, opts ...gax.CallOption) (*UpdateGcpUserAccessBindingOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "gcp_user_access_binding.name", url.QueryEscape(req.GetGcpUserAccessBinding().GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateGcpUserAccessBinding[0:len((*c.CallOptions).UpdateGcpUserAccessBinding):len((*c.CallOptions).UpdateGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.UpdateGcpUserAccessBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteGcpUserAccessBinding(ctx context.Context, req *accesscontextmanagerpb.DeleteGcpUserAccessBindingRequest, opts ...gax.CallOption) (*DeleteGcpUserAccessBindingOperation, error) {
	if _, ok := ctx.Deadline(); !ok && !c.disableDeadlines {
		cctx, cancel := context.WithTimeout(ctx, 60000*time.Millisecond)
		defer cancel()
		ctx = cctx
	}
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteGcpUserAccessBinding[0:len((*c.CallOptions).DeleteGcpUserAccessBinding):len((*c.CallOptions).DeleteGcpUserAccessBinding)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.DeleteGcpUserAccessBinding(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

// CommitServicePerimetersOperation manages a long-running operation from CommitServicePerimeters.
type CommitServicePerimetersOperation struct {
	lro *longrunning.Operation
}

// CommitServicePerimetersOperation returns a new CommitServicePerimetersOperation from a given name.
// The name must be that of a previously created CommitServicePerimetersOperation, possibly from a different process.
func (c *gRPCClient) CommitServicePerimetersOperation(name string) *CommitServicePerimetersOperation {
	return &CommitServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CommitServicePerimetersOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.CommitServicePerimetersResponse, error) {
	var resp accesscontextmanagerpb.CommitServicePerimetersResponse
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CommitServicePerimetersOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.CommitServicePerimetersResponse, error) {
	var resp accesscontextmanagerpb.CommitServicePerimetersResponse
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CommitServicePerimetersOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CommitServicePerimetersOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CommitServicePerimetersOperation) Name() string {
	return op.lro.Name()
}

// CreateAccessLevelOperation manages a long-running operation from CreateAccessLevel.
type CreateAccessLevelOperation struct {
	lro *longrunning.Operation
}

// CreateAccessLevelOperation returns a new CreateAccessLevelOperation from a given name.
// The name must be that of a previously created CreateAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) CreateAccessLevelOperation(name string) *CreateAccessLevelOperation {
	return &CreateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAccessLevelOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	var resp accesscontextmanagerpb.AccessLevel
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAccessLevelOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	var resp accesscontextmanagerpb.AccessLevel
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAccessLevelOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAccessLevelOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAccessLevelOperation) Name() string {
	return op.lro.Name()
}

// CreateAccessPolicyOperation manages a long-running operation from CreateAccessPolicy.
type CreateAccessPolicyOperation struct {
	lro *longrunning.Operation
}

// CreateAccessPolicyOperation returns a new CreateAccessPolicyOperation from a given name.
// The name must be that of a previously created CreateAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) CreateAccessPolicyOperation(name string) *CreateAccessPolicyOperation {
	return &CreateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateAccessPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	var resp accesscontextmanagerpb.AccessPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateAccessPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	var resp accesscontextmanagerpb.AccessPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateAccessPolicyOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateAccessPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateAccessPolicyOperation) Name() string {
	return op.lro.Name()
}

// CreateGcpUserAccessBindingOperation manages a long-running operation from CreateGcpUserAccessBinding.
type CreateGcpUserAccessBindingOperation struct {
	lro *longrunning.Operation
}

// CreateGcpUserAccessBindingOperation returns a new CreateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created CreateGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) CreateGcpUserAccessBindingOperation(name string) *CreateGcpUserAccessBindingOperation {
	return &CreateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateGcpUserAccessBindingOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	var resp accesscontextmanagerpb.GcpUserAccessBinding
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateGcpUserAccessBindingOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	var resp accesscontextmanagerpb.GcpUserAccessBinding
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateGcpUserAccessBindingOperation) Metadata() (*accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata, error) {
	var meta accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateGcpUserAccessBindingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateGcpUserAccessBindingOperation) Name() string {
	return op.lro.Name()
}

// CreateServicePerimeterOperation manages a long-running operation from CreateServicePerimeter.
type CreateServicePerimeterOperation struct {
	lro *longrunning.Operation
}

// CreateServicePerimeterOperation returns a new CreateServicePerimeterOperation from a given name.
// The name must be that of a previously created CreateServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) CreateServicePerimeterOperation(name string) *CreateServicePerimeterOperation {
	return &CreateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *CreateServicePerimeterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	var resp accesscontextmanagerpb.ServicePerimeter
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *CreateServicePerimeterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	var resp accesscontextmanagerpb.ServicePerimeter
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *CreateServicePerimeterOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *CreateServicePerimeterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *CreateServicePerimeterOperation) Name() string {
	return op.lro.Name()
}

// DeleteAccessLevelOperation manages a long-running operation from DeleteAccessLevel.
type DeleteAccessLevelOperation struct {
	lro *longrunning.Operation
}

// DeleteAccessLevelOperation returns a new DeleteAccessLevelOperation from a given name.
// The name must be that of a previously created DeleteAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) DeleteAccessLevelOperation(name string) *DeleteAccessLevelOperation {
	return &DeleteAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAccessLevelOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAccessLevelOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAccessLevelOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAccessLevelOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAccessLevelOperation) Name() string {
	return op.lro.Name()
}

// DeleteAccessPolicyOperation manages a long-running operation from DeleteAccessPolicy.
type DeleteAccessPolicyOperation struct {
	lro *longrunning.Operation
}

// DeleteAccessPolicyOperation returns a new DeleteAccessPolicyOperation from a given name.
// The name must be that of a previously created DeleteAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) DeleteAccessPolicyOperation(name string) *DeleteAccessPolicyOperation {
	return &DeleteAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteAccessPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteAccessPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteAccessPolicyOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteAccessPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteAccessPolicyOperation) Name() string {
	return op.lro.Name()
}

// DeleteGcpUserAccessBindingOperation manages a long-running operation from DeleteGcpUserAccessBinding.
type DeleteGcpUserAccessBindingOperation struct {
	lro *longrunning.Operation
}

// DeleteGcpUserAccessBindingOperation returns a new DeleteGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created DeleteGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) DeleteGcpUserAccessBindingOperation(name string) *DeleteGcpUserAccessBindingOperation {
	return &DeleteGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteGcpUserAccessBindingOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteGcpUserAccessBindingOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteGcpUserAccessBindingOperation) Metadata() (*accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata, error) {
	var meta accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteGcpUserAccessBindingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteGcpUserAccessBindingOperation) Name() string {
	return op.lro.Name()
}

// DeleteServicePerimeterOperation manages a long-running operation from DeleteServicePerimeter.
type DeleteServicePerimeterOperation struct {
	lro *longrunning.Operation
}

// DeleteServicePerimeterOperation returns a new DeleteServicePerimeterOperation from a given name.
// The name must be that of a previously created DeleteServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) DeleteServicePerimeterOperation(name string) *DeleteServicePerimeterOperation {
	return &DeleteServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *DeleteServicePerimeterOperation) Wait(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.WaitWithInterval(ctx, nil, time.Minute, opts...)
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *DeleteServicePerimeterOperation) Poll(ctx context.Context, opts ...gax.CallOption) error {
	return op.lro.Poll(ctx, nil, opts...)
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *DeleteServicePerimeterOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *DeleteServicePerimeterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *DeleteServicePerimeterOperation) Name() string {
	return op.lro.Name()
}

// ReplaceAccessLevelsOperation manages a long-running operation from ReplaceAccessLevels.
type ReplaceAccessLevelsOperation struct {
	lro *longrunning.Operation
}

// ReplaceAccessLevelsOperation returns a new ReplaceAccessLevelsOperation from a given name.
// The name must be that of a previously created ReplaceAccessLevelsOperation, possibly from a different process.
func (c *gRPCClient) ReplaceAccessLevelsOperation(name string) *ReplaceAccessLevelsOperation {
	return &ReplaceAccessLevelsOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ReplaceAccessLevelsOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ReplaceAccessLevelsResponse, error) {
	var resp accesscontextmanagerpb.ReplaceAccessLevelsResponse
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ReplaceAccessLevelsOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ReplaceAccessLevelsResponse, error) {
	var resp accesscontextmanagerpb.ReplaceAccessLevelsResponse
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ReplaceAccessLevelsOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ReplaceAccessLevelsOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ReplaceAccessLevelsOperation) Name() string {
	return op.lro.Name()
}

// ReplaceServicePerimetersOperation manages a long-running operation from ReplaceServicePerimeters.
type ReplaceServicePerimetersOperation struct {
	lro *longrunning.Operation
}

// ReplaceServicePerimetersOperation returns a new ReplaceServicePerimetersOperation from a given name.
// The name must be that of a previously created ReplaceServicePerimetersOperation, possibly from a different process.
func (c *gRPCClient) ReplaceServicePerimetersOperation(name string) *ReplaceServicePerimetersOperation {
	return &ReplaceServicePerimetersOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *ReplaceServicePerimetersOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ReplaceServicePerimetersResponse, error) {
	var resp accesscontextmanagerpb.ReplaceServicePerimetersResponse
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *ReplaceServicePerimetersOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ReplaceServicePerimetersResponse, error) {
	var resp accesscontextmanagerpb.ReplaceServicePerimetersResponse
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *ReplaceServicePerimetersOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *ReplaceServicePerimetersOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *ReplaceServicePerimetersOperation) Name() string {
	return op.lro.Name()
}

// UpdateAccessLevelOperation manages a long-running operation from UpdateAccessLevel.
type UpdateAccessLevelOperation struct {
	lro *longrunning.Operation
}

// UpdateAccessLevelOperation returns a new UpdateAccessLevelOperation from a given name.
// The name must be that of a previously created UpdateAccessLevelOperation, possibly from a different process.
func (c *gRPCClient) UpdateAccessLevelOperation(name string) *UpdateAccessLevelOperation {
	return &UpdateAccessLevelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAccessLevelOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	var resp accesscontextmanagerpb.AccessLevel
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAccessLevelOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessLevel, error) {
	var resp accesscontextmanagerpb.AccessLevel
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAccessLevelOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAccessLevelOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAccessLevelOperation) Name() string {
	return op.lro.Name()
}

// UpdateAccessPolicyOperation manages a long-running operation from UpdateAccessPolicy.
type UpdateAccessPolicyOperation struct {
	lro *longrunning.Operation
}

// UpdateAccessPolicyOperation returns a new UpdateAccessPolicyOperation from a given name.
// The name must be that of a previously created UpdateAccessPolicyOperation, possibly from a different process.
func (c *gRPCClient) UpdateAccessPolicyOperation(name string) *UpdateAccessPolicyOperation {
	return &UpdateAccessPolicyOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateAccessPolicyOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	var resp accesscontextmanagerpb.AccessPolicy
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateAccessPolicyOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.AccessPolicy, error) {
	var resp accesscontextmanagerpb.AccessPolicy
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateAccessPolicyOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateAccessPolicyOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateAccessPolicyOperation) Name() string {
	return op.lro.Name()
}

// UpdateGcpUserAccessBindingOperation manages a long-running operation from UpdateGcpUserAccessBinding.
type UpdateGcpUserAccessBindingOperation struct {
	lro *longrunning.Operation
}

// UpdateGcpUserAccessBindingOperation returns a new UpdateGcpUserAccessBindingOperation from a given name.
// The name must be that of a previously created UpdateGcpUserAccessBindingOperation, possibly from a different process.
func (c *gRPCClient) UpdateGcpUserAccessBindingOperation(name string) *UpdateGcpUserAccessBindingOperation {
	return &UpdateGcpUserAccessBindingOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateGcpUserAccessBindingOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	var resp accesscontextmanagerpb.GcpUserAccessBinding
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateGcpUserAccessBindingOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	var resp accesscontextmanagerpb.GcpUserAccessBinding
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateGcpUserAccessBindingOperation) Metadata() (*accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata, error) {
	var meta accesscontextmanagerpb.GcpUserAccessBindingOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateGcpUserAccessBindingOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateGcpUserAccessBindingOperation) Name() string {
	return op.lro.Name()
}

// UpdateServicePerimeterOperation manages a long-running operation from UpdateServicePerimeter.
type UpdateServicePerimeterOperation struct {
	lro *longrunning.Operation
}

// UpdateServicePerimeterOperation returns a new UpdateServicePerimeterOperation from a given name.
// The name must be that of a previously created UpdateServicePerimeterOperation, possibly from a different process.
func (c *gRPCClient) UpdateServicePerimeterOperation(name string) *UpdateServicePerimeterOperation {
	return &UpdateServicePerimeterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// Wait blocks until the long-running operation is completed, returning the response and any errors encountered.
//
// See documentation of Poll for error-handling information.
func (op *UpdateServicePerimeterOperation) Wait(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	var resp accesscontextmanagerpb.ServicePerimeter
	if err := op.lro.WaitWithInterval(ctx, &resp, time.Minute, opts...); err != nil {
		return nil, err
	}
	return &resp, nil
}

// Poll fetches the latest state of the long-running operation.
//
// Poll also fetches the latest metadata, which can be retrieved by Metadata.
//
// If Poll fails, the error is returned and op is unmodified. If Poll succeeds and
// the operation has completed with failure, the error is returned and op.Done will return true.
// If Poll succeeds and the operation has completed successfully,
// op.Done will return true, and the response of the operation is returned.
// If Poll succeeds and the operation has not completed, the returned response and error are both nil.
func (op *UpdateServicePerimeterOperation) Poll(ctx context.Context, opts ...gax.CallOption) (*accesscontextmanagerpb.ServicePerimeter, error) {
	var resp accesscontextmanagerpb.ServicePerimeter
	if err := op.lro.Poll(ctx, &resp, opts...); err != nil {
		return nil, err
	}
	if !op.Done() {
		return nil, nil
	}
	return &resp, nil
}

// Metadata returns metadata associated with the long-running operation.
// Metadata itself does not contact the server, but Poll does.
// To get the latest metadata, call this method after a successful call to Poll.
// If the metadata is not available, the returned metadata and error are both nil.
func (op *UpdateServicePerimeterOperation) Metadata() (*accesscontextmanagerpb.AccessContextManagerOperationMetadata, error) {
	var meta accesscontextmanagerpb.AccessContextManagerOperationMetadata
	if err := op.lro.Metadata(&meta); err == longrunning.ErrNoMetadata {
		return nil, nil
	} else if err != nil {
		return nil, err
	}
	return &meta, nil
}

// Done reports whether the long-running operation has completed.
func (op *UpdateServicePerimeterOperation) Done() bool {
	return op.lro.Done()
}

// Name returns the name of the long-running operation.
// The name is assigned by the server and is unique within the service from which the operation is created.
func (op *UpdateServicePerimeterOperation) Name() string {
	return op.lro.Name()
}

// AccessLevelIterator manages a stream of *accesscontextmanagerpb.AccessLevel.
type AccessLevelIterator struct {
	items    []*accesscontextmanagerpb.AccessLevel
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*accesscontextmanagerpb.AccessLevel, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AccessLevelIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AccessLevelIterator) Next() (*accesscontextmanagerpb.AccessLevel, error) {
	var item *accesscontextmanagerpb.AccessLevel
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AccessLevelIterator) bufLen() int {
	return len(it.items)
}

func (it *AccessLevelIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// AccessPolicyIterator manages a stream of *accesscontextmanagerpb.AccessPolicy.
type AccessPolicyIterator struct {
	items    []*accesscontextmanagerpb.AccessPolicy
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*accesscontextmanagerpb.AccessPolicy, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AccessPolicyIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AccessPolicyIterator) Next() (*accesscontextmanagerpb.AccessPolicy, error) {
	var item *accesscontextmanagerpb.AccessPolicy
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AccessPolicyIterator) bufLen() int {
	return len(it.items)
}

func (it *AccessPolicyIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// GcpUserAccessBindingIterator manages a stream of *accesscontextmanagerpb.GcpUserAccessBinding.
type GcpUserAccessBindingIterator struct {
	items    []*accesscontextmanagerpb.GcpUserAccessBinding
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*accesscontextmanagerpb.GcpUserAccessBinding, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *GcpUserAccessBindingIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *GcpUserAccessBindingIterator) Next() (*accesscontextmanagerpb.GcpUserAccessBinding, error) {
	var item *accesscontextmanagerpb.GcpUserAccessBinding
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *GcpUserAccessBindingIterator) bufLen() int {
	return len(it.items)
}

func (it *GcpUserAccessBindingIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}

// ServicePerimeterIterator manages a stream of *accesscontextmanagerpb.ServicePerimeter.
type ServicePerimeterIterator struct {
	items    []*accesscontextmanagerpb.ServicePerimeter
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*accesscontextmanagerpb.ServicePerimeter, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ServicePerimeterIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ServicePerimeterIterator) Next() (*accesscontextmanagerpb.ServicePerimeter, error) {
	var item *accesscontextmanagerpb.ServicePerimeter
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ServicePerimeterIterator) bufLen() int {
	return len(it.items)
}

func (it *ServicePerimeterIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
