// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package service

import (
	"context"
	"fmt"
	"math"
	"net/url"

	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	servicepb "google.golang.org/genproto/googleapis/cloud/orchestration/airflow/service/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newImageVersionsClientHook clientHook

// ImageVersionsCallOptions contains the retry settings for each method of ImageVersionsClient.
type ImageVersionsCallOptions struct {
	ListImageVersions []gax.CallOption
}

func defaultImageVersionsGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("composer.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("composer.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://composer.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultImageVersionsCallOptions() *ImageVersionsCallOptions {
	return &ImageVersionsCallOptions{
		ListImageVersions: []gax.CallOption{},
	}
}

// internalImageVersionsClient is an interface that defines the methods available from Cloud Composer API.
type internalImageVersionsClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListImageVersions(context.Context, *servicepb.ListImageVersionsRequest, ...gax.CallOption) *ImageVersionIterator
}

// ImageVersionsClient is a client for interacting with Cloud Composer API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Readonly service to query available ImageVersions.
type ImageVersionsClient struct {
	// The internal transport-dependent client.
	internalClient internalImageVersionsClient

	// The call options for this service.
	CallOptions *ImageVersionsCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ImageVersionsClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ImageVersionsClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *ImageVersionsClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListImageVersions list ImageVersions for provided location.
func (c *ImageVersionsClient) ListImageVersions(ctx context.Context, req *servicepb.ListImageVersionsRequest, opts ...gax.CallOption) *ImageVersionIterator {
	return c.internalClient.ListImageVersions(ctx, req, opts...)
}

// imageVersionsGRPCClient is a client for interacting with Cloud Composer API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type imageVersionsGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing ImageVersionsClient
	CallOptions **ImageVersionsCallOptions

	// The gRPC API client.
	imageVersionsClient servicepb.ImageVersionsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewImageVersionsClient creates a new image versions client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Readonly service to query available ImageVersions.
func NewImageVersionsClient(ctx context.Context, opts ...option.ClientOption) (*ImageVersionsClient, error) {
	clientOpts := defaultImageVersionsGRPCClientOptions()
	if newImageVersionsClientHook != nil {
		hookOpts, err := newImageVersionsClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ImageVersionsClient{CallOptions: defaultImageVersionsCallOptions()}

	c := &imageVersionsGRPCClient{
		connPool:            connPool,
		disableDeadlines:    disableDeadlines,
		imageVersionsClient: servicepb.NewImageVersionsClient(connPool),
		CallOptions:         &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *imageVersionsGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *imageVersionsGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *imageVersionsGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *imageVersionsGRPCClient) ListImageVersions(ctx context.Context, req *servicepb.ListImageVersionsRequest, opts ...gax.CallOption) *ImageVersionIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListImageVersions[0:len((*c.CallOptions).ListImageVersions):len((*c.CallOptions).ListImageVersions)], opts...)
	it := &ImageVersionIterator{}
	req = proto.Clone(req).(*servicepb.ListImageVersionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*servicepb.ImageVersion, string, error) {
		resp := &servicepb.ListImageVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.imageVersionsClient.ListImageVersions(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetImageVersions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ImageVersionIterator manages a stream of *servicepb.ImageVersion.
type ImageVersionIterator struct {
	items    []*servicepb.ImageVersion
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*servicepb.ImageVersion, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *ImageVersionIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *ImageVersionIterator) Next() (*servicepb.ImageVersion, error) {
	var item *servicepb.ImageVersion
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *ImageVersionIterator) bufLen() int {
	return len(it.items)
}

func (it *ImageVersionIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
