// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1p2beta1/asset_service.proto

package asset

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
)

var ContentType_name = map[int32]string{
	0: "CONTENT_TYPE_UNSPECIFIED",
	1: "RESOURCE",
	2: "IAM_POLICY",
}

var ContentType_value = map[string]int32{
	"CONTENT_TYPE_UNSPECIFIED": 0,
	"RESOURCE":                 1,
	"IAM_POLICY":               2,
}

func (x ContentType) String() string {
	return proto.EnumName(ContentType_name, int32(x))
}

func (ContentType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{0}
}

// Create asset feed request.
type CreateFeedRequest struct {
	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id")", or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// Required. The feed details. The field `name` must be empty and it will be generated
	// in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed                 *Feed    `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFeedRequest) Reset()         { *m = CreateFeedRequest{} }
func (m *CreateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFeedRequest) ProtoMessage()    {}
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{0}
}

func (m *CreateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFeedRequest.Unmarshal(m, b)
}
func (m *CreateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFeedRequest.Marshal(b, m, deterministic)
}
func (m *CreateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFeedRequest.Merge(m, src)
}
func (m *CreateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFeedRequest.Size(m)
}
func (m *CreateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFeedRequest proto.InternalMessageInfo

func (m *CreateFeedRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFeedRequest) GetFeedId() string {
	if m != nil {
		return m.FeedId
	}
	return ""
}

func (m *CreateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	// Required. The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFeedRequest) Reset()         { *m = GetFeedRequest{} }
func (m *GetFeedRequest) String() string { return proto.CompactTextString(m) }
func (*GetFeedRequest) ProtoMessage()    {}
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{1}
}

func (m *GetFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFeedRequest.Unmarshal(m, b)
}
func (m *GetFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFeedRequest.Marshal(b, m, deterministic)
}
func (m *GetFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFeedRequest.Merge(m, src)
}
func (m *GetFeedRequest) XXX_Size() int {
	return xxx_messageInfo_GetFeedRequest.Size(m)
}
func (m *GetFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFeedRequest proto.InternalMessageInfo

func (m *GetFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsRequest) Reset()         { *m = ListFeedsRequest{} }
func (m *ListFeedsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFeedsRequest) ProtoMessage()    {}
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{2}
}

func (m *ListFeedsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsRequest.Unmarshal(m, b)
}
func (m *ListFeedsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsRequest.Marshal(b, m, deterministic)
}
func (m *ListFeedsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsRequest.Merge(m, src)
}
func (m *ListFeedsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFeedsRequest.Size(m)
}
func (m *ListFeedsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsRequest proto.InternalMessageInfo

func (m *ListFeedsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	// A list of feeds.
	Feeds                []*Feed  `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFeedsResponse) Reset()         { *m = ListFeedsResponse{} }
func (m *ListFeedsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFeedsResponse) ProtoMessage()    {}
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{3}
}

func (m *ListFeedsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFeedsResponse.Unmarshal(m, b)
}
func (m *ListFeedsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFeedsResponse.Marshal(b, m, deterministic)
}
func (m *ListFeedsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFeedsResponse.Merge(m, src)
}
func (m *ListFeedsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFeedsResponse.Size(m)
}
func (m *ListFeedsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFeedsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFeedsResponse proto.InternalMessageInfo

func (m *ListFeedsResponse) GetFeeds() []*Feed {
	if m != nil {
		return m.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	// Required. The new values of feed details. It must match an existing feed and the
	// field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Required. Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFeedRequest) Reset()         { *m = UpdateFeedRequest{} }
func (m *UpdateFeedRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFeedRequest) ProtoMessage()    {}
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{4}
}

func (m *UpdateFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFeedRequest.Unmarshal(m, b)
}
func (m *UpdateFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFeedRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFeedRequest.Merge(m, src)
}
func (m *UpdateFeedRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFeedRequest.Size(m)
}
func (m *UpdateFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFeedRequest proto.InternalMessageInfo

func (m *UpdateFeedRequest) GetFeed() *Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *UpdateFeedRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	// Required. The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteFeedRequest) Reset()         { *m = DeleteFeedRequest{} }
func (m *DeleteFeedRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteFeedRequest) ProtoMessage()    {}
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{5}
}

func (m *DeleteFeedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteFeedRequest.Unmarshal(m, b)
}
func (m *DeleteFeedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteFeedRequest.Marshal(b, m, deterministic)
}
func (m *DeleteFeedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteFeedRequest.Merge(m, src)
}
func (m *DeleteFeedRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteFeedRequest.Size(m)
}
func (m *DeleteFeedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteFeedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteFeedRequest proto.InternalMessageInfo

func (m *DeleteFeedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	// Asset export destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{6}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// A Cloud Storage location.
type GcsDestination struct {
	// Required.
	//
	// Types that are valid to be assigned to ObjectUri:
	//	*GcsDestination_Uri
	ObjectUri            isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{7}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (m *GcsDestination) GetUri() string {
	if x, ok := m.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GcsDestination) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GcsDestination_Uri)(nil),
	}
}

// A Cloud Pubsub destination.
type PubsubDestination struct {
	// The name of the Cloud Pub/Sub topic to publish to.
	// For example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic                string   `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PubsubDestination) Reset()         { *m = PubsubDestination{} }
func (m *PubsubDestination) String() string { return proto.CompactTextString(m) }
func (*PubsubDestination) ProtoMessage()    {}
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{8}
}

func (m *PubsubDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PubsubDestination.Unmarshal(m, b)
}
func (m *PubsubDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PubsubDestination.Marshal(b, m, deterministic)
}
func (m *PubsubDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PubsubDestination.Merge(m, src)
}
func (m *PubsubDestination) XXX_Size() int {
	return xxx_messageInfo_PubsubDestination.Size(m)
}
func (m *PubsubDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_PubsubDestination.DiscardUnknown(m)
}

var xxx_messageInfo_PubsubDestination proto.InternalMessageInfo

func (m *PubsubDestination) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	// Asset feed destination.
	//
	// Types that are valid to be assigned to Destination:
	//	*FeedOutputConfig_PubsubDestination
	Destination          isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *FeedOutputConfig) Reset()         { *m = FeedOutputConfig{} }
func (m *FeedOutputConfig) String() string { return proto.CompactTextString(m) }
func (*FeedOutputConfig) ProtoMessage()    {}
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{9}
}

func (m *FeedOutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FeedOutputConfig.Unmarshal(m, b)
}
func (m *FeedOutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FeedOutputConfig.Marshal(b, m, deterministic)
}
func (m *FeedOutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FeedOutputConfig.Merge(m, src)
}
func (m *FeedOutputConfig) XXX_Size() int {
	return xxx_messageInfo_FeedOutputConfig.Size(m)
}
func (m *FeedOutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FeedOutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FeedOutputConfig proto.InternalMessageInfo

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := m.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*FeedOutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Cloud Pub/Sub topics.
type Feed struct {
	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed. For
	// example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more info.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed.
	// For example:
	// "compute.googleapis.com/Disk" See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/resource-manager/docs/cloud-asset-inventory/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1p2beta1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig     *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Feed) Reset()         { *m = Feed{} }
func (m *Feed) String() string { return proto.CompactTextString(m) }
func (*Feed) ProtoMessage()    {}
func (*Feed) Descriptor() ([]byte, []int) {
	return fileDescriptor_266ed218574f68b8, []int{10}
}

func (m *Feed) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Feed.Unmarshal(m, b)
}
func (m *Feed) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Feed.Marshal(b, m, deterministic)
}
func (m *Feed) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Feed.Merge(m, src)
}
func (m *Feed) XXX_Size() int {
	return xxx_messageInfo_Feed.Size(m)
}
func (m *Feed) XXX_DiscardUnknown() {
	xxx_messageInfo_Feed.DiscardUnknown(m)
}

var xxx_messageInfo_Feed proto.InternalMessageInfo

func (m *Feed) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Feed) GetAssetNames() []string {
	if m != nil {
		return m.AssetNames
	}
	return nil
}

func (m *Feed) GetAssetTypes() []string {
	if m != nil {
		return m.AssetTypes
	}
	return nil
}

func (m *Feed) GetContentType() ContentType {
	if m != nil {
		return m.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (m *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if m != nil {
		return m.FeedOutputConfig
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.asset.v1p2beta1.ContentType", ContentType_name, ContentType_value)
	proto.RegisterType((*CreateFeedRequest)(nil), "google.cloud.asset.v1p2beta1.CreateFeedRequest")
	proto.RegisterType((*GetFeedRequest)(nil), "google.cloud.asset.v1p2beta1.GetFeedRequest")
	proto.RegisterType((*ListFeedsRequest)(nil), "google.cloud.asset.v1p2beta1.ListFeedsRequest")
	proto.RegisterType((*ListFeedsResponse)(nil), "google.cloud.asset.v1p2beta1.ListFeedsResponse")
	proto.RegisterType((*UpdateFeedRequest)(nil), "google.cloud.asset.v1p2beta1.UpdateFeedRequest")
	proto.RegisterType((*DeleteFeedRequest)(nil), "google.cloud.asset.v1p2beta1.DeleteFeedRequest")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.asset.v1p2beta1.OutputConfig")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.asset.v1p2beta1.GcsDestination")
	proto.RegisterType((*PubsubDestination)(nil), "google.cloud.asset.v1p2beta1.PubsubDestination")
	proto.RegisterType((*FeedOutputConfig)(nil), "google.cloud.asset.v1p2beta1.FeedOutputConfig")
	proto.RegisterType((*Feed)(nil), "google.cloud.asset.v1p2beta1.Feed")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1p2beta1/asset_service.proto", fileDescriptor_266ed218574f68b8)
}

var fileDescriptor_266ed218574f68b8 = []byte{
	// 1084 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xbf, 0x6f, 0x23, 0x45,
	0x14, 0xce, 0xd8, 0xb9, 0x1c, 0x79, 0x0e, 0xc1, 0x1e, 0x21, 0xce, 0xe7, 0xcb, 0x11, 0x6b, 0x91,
	0x20, 0xb1, 0x8e, 0x5d, 0x62, 0x28, 0x50, 0x4e, 0x48, 0xac, 0x1d, 0x27, 0xb1, 0x94, 0x1f, 0x96,
	0x93, 0x80, 0x0e, 0x45, 0x32, 0xeb, 0xf5, 0x78, 0xb3, 0x9c, 0xbd, 0xb3, 0xec, 0xcc, 0x26, 0x3a,
	0xa2, 0x34, 0x5c, 0x85, 0x10, 0x05, 0x3f, 0x24, 0x1a, 0x6a, 0x0a, 0xfe, 0x02, 0x3a, 0xfa, 0x2b,
	0xa1, 0x4b, 0x75, 0x05, 0x15, 0x7f, 0x02, 0x15, 0x9a, 0x99, 0x75, 0xbc, 0x5e, 0x1f, 0xb6, 0x05,
	0x95, 0x3d, 0xef, 0xbd, 0x6f, 0xe6, 0xfb, 0xde, 0x9b, 0x79, 0x6f, 0xe1, 0x1d, 0x87, 0x52, 0xa7,
	0x47, 0x0c, 0xbb, 0x47, 0xc3, 0x8e, 0x61, 0x31, 0x46, 0xb8, 0x71, 0xbe, 0xe1, 0x97, 0xdb, 0x84,
	0x5b, 0x1b, 0x6a, 0xdd, 0x62, 0x24, 0x38, 0x77, 0x6d, 0xa2, 0xfb, 0x01, 0xe5, 0x14, 0xaf, 0x28,
	0x84, 0x2e, 0x11, 0xba, 0x8c, 0xd0, 0x6f, 0x10, 0x85, 0xc8, 0x6b, 0x58, 0xbe, 0x6b, 0x58, 0x9e,
	0x47, 0xb9, 0xc5, 0x5d, 0xea, 0x31, 0x85, 0x2d, 0xdc, 0x89, 0x79, 0xed, 0x9e, 0x4b, 0x3c, 0x1e,
	0x39, 0x56, 0x63, 0x8e, 0xae, 0x4b, 0x7a, 0x9d, 0x56, 0x9b, 0x9c, 0x59, 0xe7, 0x2e, 0x0d, 0xa2,
	0x80, 0xbb, 0xb1, 0x80, 0x80, 0x30, 0x1a, 0x06, 0x03, 0x42, 0x85, 0xf5, 0xe9, 0x12, 0x06, 0xe7,
	0xbf, 0x11, 0x85, 0xf6, 0xa8, 0xe7, 0x04, 0xa1, 0xe7, 0xb9, 0x9e, 0x63, 0x50, 0x9f, 0x04, 0x23,
	0x24, 0xef, 0x45, 0x41, 0x72, 0xd5, 0x0e, 0xbb, 0x06, 0xe9, 0xfb, 0xfc, 0x49, 0xe4, 0x2c, 0x26,
	0x9d, 0x8a, 0x6d, 0xdf, 0x62, 0x8f, 0x13, 0x52, 0x6e, 0x22, 0xb8, 0xdb, 0x27, 0x8c, 0x5b, 0x7d,
	0x5f, 0x05, 0x68, 0x5f, 0x23, 0xc8, 0x55, 0x03, 0x62, 0x71, 0xb2, 0x4d, 0x48, 0xa7, 0x49, 0x3e,
	0x0f, 0x09, 0xe3, 0xf8, 0x1e, 0x2c, 0xf8, 0x56, 0x40, 0x3c, 0x9e, 0x47, 0x45, 0xb4, 0xb6, 0x58,
	0x49, 0x3f, 0x37, 0x53, 0xcd, 0xc8, 0x84, 0x57, 0xe0, 0x76, 0x97, 0x90, 0x4e, 0xcb, 0xed, 0xe4,
	0x53, 0x31, 0xaf, 0xb0, 0xd5, 0x3b, 0xf8, 0x21, 0xcc, 0x8b, 0x7f, 0xf9, 0x74, 0x11, 0xad, 0x65,
	0xca, 0x9a, 0x3e, 0xa9, 0x40, 0xba, 0x38, 0x53, 0xc1, 0x25, 0x48, 0xdb, 0x83, 0xe5, 0x1d, 0xc2,
	0xe3, 0x4c, 0x36, 0x61, 0xde, 0xb3, 0xfa, 0x24, 0xe2, 0xf1, 0xe6, 0x73, 0x33, 0xf5, 0xb7, 0x59,
	0x84, 0xd7, 0xe5, 0x76, 0x6a, 0x37, 0x75, 0x80, 0xe5, 0xbb, 0x4c, 0xb7, 0x69, 0xdf, 0x90, 0x60,
	0x89, 0xd1, 0x0c, 0xc8, 0xee, 0xb9, 0x4c, 0x6e, 0xc7, 0x66, 0x51, 0xa6, 0xed, 0x43, 0x2e, 0x06,
	0x60, 0x3e, 0xf5, 0x18, 0xc1, 0xef, 0xc3, 0x2d, 0xc1, 0x8d, 0xe5, 0x51, 0x31, 0x3d, 0x9b, 0xa2,
	0xa6, 0x02, 0x68, 0xdf, 0x21, 0xc8, 0x9d, 0xf8, 0x9d, 0x44, 0x6e, 0x07, 0x09, 0x42, 0xff, 0x21,
	0x41, 0xf8, 0x43, 0xc8, 0x84, 0x72, 0x47, 0x59, 0x64, 0x99, 0xff, 0x4c, 0xb9, 0x30, 0xd8, 0x63,
	0x50, 0x65, 0x7d, 0x5b, 0xdc, 0x83, 0x7d, 0x8b, 0x3d, 0x56, 0x58, 0x50, 0x18, 0x61, 0xd0, 0x0e,
	0x21, 0xb7, 0x45, 0x7a, 0x64, 0x94, 0xd3, 0xff, 0xc9, 0xf2, 0x39, 0x2c, 0x1d, 0x86, 0xdc, 0x0f,
	0x79, 0x95, 0x7a, 0x5d, 0xd7, 0xc1, 0x1f, 0xc3, 0x2b, 0x8e, 0xcd, 0x5a, 0x1d, 0xc2, 0xb8, 0xeb,
	0xc9, 0xbb, 0x1c, 0x49, 0x7d, 0x30, 0x59, 0xea, 0x8e, 0xcd, 0xb6, 0x86, 0x98, 0xdd, 0xb9, 0xe6,
	0xb2, 0x33, 0x62, 0xa9, 0xbc, 0x0c, 0x99, 0xd8, 0xa6, 0x5a, 0x19, 0x96, 0x47, 0x21, 0x18, 0x43,
	0x3a, 0x0c, 0x5c, 0x25, 0x62, 0x77, 0xae, 0x29, 0x16, 0x95, 0x25, 0x00, 0xda, 0xfe, 0x8c, 0xd8,
	0xbc, 0x15, 0x06, 0xae, 0xb6, 0x0e, 0xb9, 0x46, 0xd8, 0x66, 0x61, 0x3b, 0x0e, 0x7b, 0x15, 0x6e,
	0x71, 0xea, 0xbb, 0xb6, 0x02, 0x36, 0xd5, 0x42, 0x7b, 0x8a, 0x20, 0x2b, 0x54, 0x8e, 0x68, 0xfb,
	0x14, 0xb0, 0x2f, 0xf1, 0x2f, 0x90, 0x67, 0x4c, 0x96, 0x37, 0x76, 0xee, 0xee, 0x5c, 0x33, 0xe7,
	0x27, 0x8d, 0x49, 0x91, 0x3f, 0xa7, 0x61, 0x5e, 0xb0, 0xc0, 0x77, 0x46, 0x2a, 0xa4, 0x6e, 0x84,
	0x30, 0xe0, 0x55, 0xc8, 0xa8, 0xc6, 0x28, 0x56, 0x2c, 0x9f, 0x2a, 0xa6, 0xd7, 0x16, 0x9b, 0x20,
	0x4d, 0x07, 0xc2, 0x32, 0x0c, 0xe0, 0x4f, 0x7c, 0xc2, 0xf2, 0xe9, 0x58, 0xc0, 0xb1, 0xb0, 0xe0,
	0x3d, 0x58, 0xb2, 0xa9, 0xc7, 0x89, 0xa7, 0x42, 0xf2, 0xf3, 0x45, 0xb4, 0xb6, 0x5c, 0x5e, 0x9f,
	0x2c, 0xa7, 0xaa, 0x10, 0x62, 0x87, 0x66, 0xc6, 0x1e, 0x2e, 0xb0, 0x05, 0x58, 0x76, 0x07, 0x2a,
	0xf3, 0xd6, 0xb2, 0x65, 0xe2, 0xf2, 0xb7, 0x64, 0x8a, 0xf4, 0xe9, 0x97, 0x3d, 0x9e, 0x6e, 0x25,
	0x33, 0xdb, 0x4d, 0x98, 0x37, 0xbf, 0x45, 0x7f, 0x99, 0xdf, 0xa0, 0x69, 0xd7, 0x13, 0xaf, 0xfa,
	0x01, 0x15, 0x95, 0x67, 0xc6, 0x65, 0xf4, 0xef, 0xca, 0x90, 0x0f, 0xd3, 0xb8, 0x14, 0x3f, 0x57,
	0xf8, 0x7e, 0x97, 0xf6, 0x3a, 0x24, 0x10, 0x6b, 0xf9, 0x27, 0xe1, 0x5e, 0xa7, 0x81, 0x63, 0x79,
	0xee, 0x17, 0xaa, 0x1f, 0x1b, 0x97, 0xf1, 0xe5, 0x68, 0x68, 0x11, 0x95, 0xea, 0x90, 0x89, 0xa5,
	0x04, 0xaf, 0x40, 0xbe, 0x7a, 0x78, 0x70, 0x5c, 0x3b, 0x38, 0x6e, 0x1d, 0x3f, 0x6a, 0xd4, 0x5a,
	0x27, 0x07, 0x47, 0x8d, 0x5a, 0xb5, 0xbe, 0x5d, 0xaf, 0x6d, 0x65, 0xe7, 0xf0, 0x12, 0xbc, 0xd4,
	0xac, 0x1d, 0x1d, 0x9e, 0x34, 0xab, 0xb5, 0x2c, 0xc2, 0xcb, 0x00, 0x75, 0x73, 0xbf, 0xd5, 0x38,
	0xdc, 0xab, 0x57, 0x1f, 0x65, 0x53, 0xe5, 0xdf, 0x16, 0x60, 0xc9, 0x14, 0xaa, 0x8e, 0xd4, 0xa8,
	0xc3, 0x3f, 0x20, 0x80, 0x61, 0x8f, 0xc6, 0x53, 0x2e, 0xda, 0x58, 0x37, 0x2f, 0xcc, 0xd0, 0x63,
	0xb4, 0x8d, 0x6b, 0x33, 0xea, 0x82, 0x5f, 0xfe, 0xf1, 0xe7, 0xf7, 0x29, 0x4d, 0xbb, 0x1f, 0x1b,
	0x5b, 0x97, 0xca, 0xf3, 0x41, 0xc9, 0x28, 0x45, 0xc2, 0x37, 0x51, 0x09, 0x7f, 0x85, 0xe0, 0x76,
	0xd4, 0xad, 0xf1, 0xb4, 0xb7, 0x3d, 0xd2, 0xd4, 0x67, 0x22, 0xf4, 0xe0, 0xda, 0x94, 0x17, 0x5c,
	0xd2, 0x59, 0xc5, 0x23, 0x74, 0x84, 0x5d, 0x90, 0x89, 0x8a, 0x50, 0xba, 0xc2, 0x3f, 0x21, 0x58,
	0xbc, 0x69, 0xdd, 0x78, 0xca, 0x3d, 0x4b, 0x0e, 0x85, 0x82, 0x31, 0x73, 0xbc, 0x9a, 0x09, 0x9a,
	0x3e, 0x9a, 0xad, 0x04, 0xbd, 0xb1, 0x6c, 0xe1, 0x1f, 0x11, 0xc0, 0x70, 0x12, 0x4c, 0xab, 0xe0,
	0xd8, 0xcc, 0x98, 0x29, 0x61, 0xef, 0x5d, 0x9b, 0x72, 0x46, 0x48, 0x46, 0x6f, 0x95, 0xb5, 0x38,
	0x23, 0x61, 0xd7, 0xc7, 0xb2, 0x26, 0x8a, 0xf8, 0x14, 0x01, 0x0c, 0xe7, 0xc1, 0x34, 0x66, 0x63,
	0x93, 0xa3, 0xf0, 0xda, 0xd8, 0xec, 0xa9, 0x89, 0x0f, 0x94, 0x44, 0xf9, 0x4a, 0x93, 0xcb, 0x57,
	0xd8, 0x7f, 0x66, 0xde, 0xfd, 0xd7, 0xd7, 0xfc, 0xbb, 0xa9, 0x9f, 0x71, 0xee, 0xb3, 0x4d, 0xc3,
	0xb8, 0xb8, 0xb8, 0x48, 0x3e, 0x75, 0x2b, 0xe4, 0x67, 0xea, 0x6b, 0xeb, 0x6d, 0xbf, 0x67, 0xf1,
	0x2e, 0x0d, 0xfa, 0x95, 0x5f, 0x11, 0x14, 0x6d, 0xda, 0x9f, 0xa8, 0xa5, 0x92, 0x8b, 0xbf, 0xb1,
	0x86, 0x60, 0xdf, 0x40, 0x9f, 0x98, 0x11, 0xc4, 0xa1, 0x3d, 0xcb, 0x73, 0x74, 0x1a, 0x38, 0x86,
	0x43, 0x3c, 0xa9, 0xcd, 0x18, 0x1e, 0xfc, 0xe2, 0xaf, 0xbb, 0x87, 0x72, 0xfd, 0x4b, 0x6a, 0x65,
	0x47, 0xed, 0x51, 0x95, 0xc7, 0xca, 0x53, 0xf4, 0x8f, 0x36, 0xfc, 0x72, 0x45, 0x04, 0x3d, 0x1b,
	0xb8, 0x4f, 0xa5, 0xfb, 0x54, 0xba, 0x4f, 0x6f, 0xdc, 0xed, 0x05, 0x79, 0xd6, 0xbb, 0xff, 0x04,
	0x00, 0x00, 0xff, 0xff, 0x05, 0x30, 0xf7, 0x65, 0x0b, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p2beta1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*empty.Empty, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) CreateFeed(ctx context.Context, req *CreateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) GetFeed(ctx context.Context, req *GetFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (*UnimplementedAssetServiceServer) ListFeeds(ctx context.Context, req *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateFeed(ctx context.Context, req *UpdateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteFeed(ctx context.Context, req *DeleteFeedRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p2beta1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p2beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p2beta1/asset_service.proto",
}
