// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/chromeos/moblab/v1beta1/build_service.proto

package moblab

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for listing builds.
// NEXT_TAG: 7
type ListBuildsRequest struct {
	// Required. The full resource name of the model. The model id is the same as
	// the build target id for non-unified builds.
	// For example,
	// 'buildTargets/octopus/models/bobba'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of builds to return in a page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListBuilds` call. Provide this to
	// retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter that specifies value constraints of fields. For example, the
	// filter can be set as "filter='milestone=milestones/80'" to only select
	// builds in milestone 80.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Read mask that specifies which Build fields to return. If empty, all Build
	// fields will be returned.
	// Valid fields: name, milestone, build_version.
	// For example, if the read_mask is set as "read_mask='milestone'", the
	// ListBuilds will return a list of Builds object with only the milestone
	// field.
	ReadMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
	// Optional. The operation that groups by all the Build fields specified in the read
	// mask. The group_by field should be the same as the read_mask field in
	// convention of SQL.
	GroupBy              *field_mask.FieldMask `protobuf:"bytes,6,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListBuildsRequest) Reset()         { *m = ListBuildsRequest{} }
func (m *ListBuildsRequest) String() string { return proto.CompactTextString(m) }
func (*ListBuildsRequest) ProtoMessage()    {}
func (*ListBuildsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{0}
}

func (m *ListBuildsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsRequest.Unmarshal(m, b)
}
func (m *ListBuildsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsRequest.Marshal(b, m, deterministic)
}
func (m *ListBuildsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsRequest.Merge(m, src)
}
func (m *ListBuildsRequest) XXX_Size() int {
	return xxx_messageInfo_ListBuildsRequest.Size(m)
}
func (m *ListBuildsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsRequest proto.InternalMessageInfo

func (m *ListBuildsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListBuildsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBuildsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListBuildsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListBuildsRequest) GetReadMask() *field_mask.FieldMask {
	if m != nil {
		return m.ReadMask
	}
	return nil
}

func (m *ListBuildsRequest) GetGroupBy() *field_mask.FieldMask {
	if m != nil {
		return m.GroupBy
	}
	return nil
}

// Response message for listing builds.
// NEXT_TAG: 4
type ListBuildsResponse struct {
	// The list of builds.
	Builds []*Build `protobuf:"bytes,1,rep,name=builds,proto3" json:"builds,omitempty"`
	// Token to retrieve the next page of builds. If this field is omitted, there
	// are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of builds.
	TotalSize            int32    `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBuildsResponse) Reset()         { *m = ListBuildsResponse{} }
func (m *ListBuildsResponse) String() string { return proto.CompactTextString(m) }
func (*ListBuildsResponse) ProtoMessage()    {}
func (*ListBuildsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{1}
}

func (m *ListBuildsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBuildsResponse.Unmarshal(m, b)
}
func (m *ListBuildsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBuildsResponse.Marshal(b, m, deterministic)
}
func (m *ListBuildsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBuildsResponse.Merge(m, src)
}
func (m *ListBuildsResponse) XXX_Size() int {
	return xxx_messageInfo_ListBuildsResponse.Size(m)
}
func (m *ListBuildsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBuildsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBuildsResponse proto.InternalMessageInfo

func (m *ListBuildsResponse) GetBuilds() []*Build {
	if m != nil {
		return m.Builds
	}
	return nil
}

func (m *ListBuildsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListBuildsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for checking if the build artifact is staged.
type CheckBuildStageStatusRequest struct {
	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckBuildStageStatusRequest) Reset()         { *m = CheckBuildStageStatusRequest{} }
func (m *CheckBuildStageStatusRequest) String() string { return proto.CompactTextString(m) }
func (*CheckBuildStageStatusRequest) ProtoMessage()    {}
func (*CheckBuildStageStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{2}
}

func (m *CheckBuildStageStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Unmarshal(m, b)
}
func (m *CheckBuildStageStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Marshal(b, m, deterministic)
}
func (m *CheckBuildStageStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckBuildStageStatusRequest.Merge(m, src)
}
func (m *CheckBuildStageStatusRequest) XXX_Size() int {
	return xxx_messageInfo_CheckBuildStageStatusRequest.Size(m)
}
func (m *CheckBuildStageStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckBuildStageStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckBuildStageStatusRequest proto.InternalMessageInfo

func (m *CheckBuildStageStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for checking the stage status of a build artifact.
// NEXT_TAG: 4
type CheckBuildStageStatusResponse struct {
	// The status to represent if the build is staged or not.
	IsBuildStaged bool `protobuf:"varint,1,opt,name=is_build_staged,json=isBuildStaged,proto3" json:"is_build_staged,omitempty"`
	// The staged build artifact in the destination bucket.
	StagedBuildArtifact *BuildArtifact `protobuf:"bytes,2,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	// The source build artifact in the source bucket.
	SourceBuildArtifact  *BuildArtifact `protobuf:"bytes,3,opt,name=source_build_artifact,json=sourceBuildArtifact,proto3" json:"source_build_artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *CheckBuildStageStatusResponse) Reset()         { *m = CheckBuildStageStatusResponse{} }
func (m *CheckBuildStageStatusResponse) String() string { return proto.CompactTextString(m) }
func (*CheckBuildStageStatusResponse) ProtoMessage()    {}
func (*CheckBuildStageStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{3}
}

func (m *CheckBuildStageStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Unmarshal(m, b)
}
func (m *CheckBuildStageStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Marshal(b, m, deterministic)
}
func (m *CheckBuildStageStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckBuildStageStatusResponse.Merge(m, src)
}
func (m *CheckBuildStageStatusResponse) XXX_Size() int {
	return xxx_messageInfo_CheckBuildStageStatusResponse.Size(m)
}
func (m *CheckBuildStageStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckBuildStageStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckBuildStageStatusResponse proto.InternalMessageInfo

func (m *CheckBuildStageStatusResponse) GetIsBuildStaged() bool {
	if m != nil {
		return m.IsBuildStaged
	}
	return false
}

func (m *CheckBuildStageStatusResponse) GetStagedBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.StagedBuildArtifact
	}
	return nil
}

func (m *CheckBuildStageStatusResponse) GetSourceBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.SourceBuildArtifact
	}
	return nil
}

// Request message for staging a build artifact.
type StageBuildRequest struct {
	// Required. The full resource name of the build artifact.
	// For example,
	// 'buildTargets/octopus/models/bobba/builds/12607.6.0/artifacts/chromeos-moblab-peng-staging'.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StageBuildRequest) Reset()         { *m = StageBuildRequest{} }
func (m *StageBuildRequest) String() string { return proto.CompactTextString(m) }
func (*StageBuildRequest) ProtoMessage()    {}
func (*StageBuildRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{4}
}

func (m *StageBuildRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildRequest.Unmarshal(m, b)
}
func (m *StageBuildRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildRequest.Marshal(b, m, deterministic)
}
func (m *StageBuildRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildRequest.Merge(m, src)
}
func (m *StageBuildRequest) XXX_Size() int {
	return xxx_messageInfo_StageBuildRequest.Size(m)
}
func (m *StageBuildRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildRequest proto.InternalMessageInfo

func (m *StageBuildRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for staging a build artifact.
type StageBuildResponse struct {
	// The staged build in the destination bucket.
	StagedBuildArtifact  *BuildArtifact `protobuf:"bytes,1,opt,name=staged_build_artifact,json=stagedBuildArtifact,proto3" json:"staged_build_artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StageBuildResponse) Reset()         { *m = StageBuildResponse{} }
func (m *StageBuildResponse) String() string { return proto.CompactTextString(m) }
func (*StageBuildResponse) ProtoMessage()    {}
func (*StageBuildResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{5}
}

func (m *StageBuildResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildResponse.Unmarshal(m, b)
}
func (m *StageBuildResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildResponse.Marshal(b, m, deterministic)
}
func (m *StageBuildResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildResponse.Merge(m, src)
}
func (m *StageBuildResponse) XXX_Size() int {
	return xxx_messageInfo_StageBuildResponse.Size(m)
}
func (m *StageBuildResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildResponse proto.InternalMessageInfo

func (m *StageBuildResponse) GetStagedBuildArtifact() *BuildArtifact {
	if m != nil {
		return m.StagedBuildArtifact
	}
	return nil
}

// Metadata message for staging a build artifact.
// NEXT_TAG: 4
type StageBuildMetadata struct {
	// Approximate percentage of progress, e.g. "50" means 50%.
	ProgressPercent float32 `protobuf:"fixed32,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Build stage start time.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Build stage end time.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StageBuildMetadata) Reset()         { *m = StageBuildMetadata{} }
func (m *StageBuildMetadata) String() string { return proto.CompactTextString(m) }
func (*StageBuildMetadata) ProtoMessage()    {}
func (*StageBuildMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_14f08d110278057f, []int{6}
}

func (m *StageBuildMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StageBuildMetadata.Unmarshal(m, b)
}
func (m *StageBuildMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StageBuildMetadata.Marshal(b, m, deterministic)
}
func (m *StageBuildMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StageBuildMetadata.Merge(m, src)
}
func (m *StageBuildMetadata) XXX_Size() int {
	return xxx_messageInfo_StageBuildMetadata.Size(m)
}
func (m *StageBuildMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StageBuildMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StageBuildMetadata proto.InternalMessageInfo

func (m *StageBuildMetadata) GetProgressPercent() float32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *StageBuildMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StageBuildMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func init() {
	proto.RegisterType((*ListBuildsRequest)(nil), "google.chromeos.moblab.v1beta1.ListBuildsRequest")
	proto.RegisterType((*ListBuildsResponse)(nil), "google.chromeos.moblab.v1beta1.ListBuildsResponse")
	proto.RegisterType((*CheckBuildStageStatusRequest)(nil), "google.chromeos.moblab.v1beta1.CheckBuildStageStatusRequest")
	proto.RegisterType((*CheckBuildStageStatusResponse)(nil), "google.chromeos.moblab.v1beta1.CheckBuildStageStatusResponse")
	proto.RegisterType((*StageBuildRequest)(nil), "google.chromeos.moblab.v1beta1.StageBuildRequest")
	proto.RegisterType((*StageBuildResponse)(nil), "google.chromeos.moblab.v1beta1.StageBuildResponse")
	proto.RegisterType((*StageBuildMetadata)(nil), "google.chromeos.moblab.v1beta1.StageBuildMetadata")
}

func init() {
	proto.RegisterFile("google/chromeos/moblab/v1beta1/build_service.proto", fileDescriptor_14f08d110278057f)
}

var fileDescriptor_14f08d110278057f = []byte{
	// 893 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0xd8, 0x8d, 0x1b, 0xbf, 0x50, 0x85, 0x0c, 0xaa, 0x30, 0xa6, 0x01, 0x6b, 0xab, 0x56,
	0x26, 0x55, 0x77, 0x89, 0x2b, 0x0e, 0x84, 0xe6, 0xb0, 0x6e, 0x45, 0x39, 0x10, 0x11, 0xb6, 0x39,
	0x21, 0x24, 0x6b, 0xbc, 0x9e, 0x6c, 0x46, 0xd9, 0x9d, 0x59, 0x66, 0xc6, 0x81, 0x16, 0x21, 0x04,
	0x77, 0x4e, 0xdc, 0xf8, 0x16, 0x1c, 0xca, 0x87, 0xe8, 0x95, 0x5b, 0x2f, 0xf4, 0x80, 0xc4, 0x77,
	0xe0, 0x84, 0xe6, 0xcf, 0xda, 0x9b, 0xe6, 0x8f, 0x4b, 0x9b, 0xe3, 0xbc, 0x79, 0xbf, 0x79, 0xef,
	0xf7, 0x7b, 0x7f, 0x76, 0x61, 0x90, 0x09, 0x91, 0xe5, 0x34, 0x4a, 0x0f, 0xa4, 0x28, 0xa8, 0x50,
	0x51, 0x21, 0xc6, 0x39, 0x19, 0x47, 0x47, 0x9b, 0x63, 0xaa, 0xc9, 0x66, 0x34, 0x9e, 0xb2, 0x7c,
	0x32, 0x52, 0x54, 0x1e, 0xb1, 0x94, 0x86, 0xa5, 0x14, 0x5a, 0xe0, 0xf7, 0x1c, 0x26, 0xac, 0x30,
	0xa1, 0xc3, 0x84, 0x1e, 0xd3, 0xbd, 0xe6, 0xdf, 0x24, 0x25, 0x8b, 0x08, 0xe7, 0x42, 0x13, 0xcd,
	0x04, 0x57, 0x0e, 0xdd, 0x7d, 0xbb, 0x76, 0x9b, 0xe6, 0x8c, 0x72, 0xed, 0x2f, 0xde, 0xaf, 0x5d,
	0xec, 0x33, 0x9a, 0x4f, 0x46, 0x63, 0x7a, 0x40, 0x8e, 0x98, 0x90, 0xde, 0xe1, 0x9d, 0x9a, 0x83,
	0xa4, 0x4a, 0x4c, 0x65, 0x95, 0x52, 0x37, 0x5c, 0x40, 0xa3, 0x72, 0xaf, 0x92, 0xb8, 0xee, 0xfd,
	0x73, 0xc1, 0x33, 0x39, 0xe5, 0x9c, 0xf1, 0x2c, 0x12, 0x25, 0x95, 0xc7, 0x32, 0xed, 0x79, 0x27,
	0x7b, 0x1a, 0x4f, 0xf7, 0x7d, 0x56, 0x05, 0x51, 0x87, 0x2f, 0xa4, 0x3c, 0xf3, 0xd0, 0xac, 0xa0,
	0x4a, 0x93, 0xa2, 0x74, 0x0e, 0xc1, 0x93, 0x06, 0xac, 0x7d, 0xce, 0x94, 0x1e, 0x1a, 0x19, 0x55,
	0x42, 0xbf, 0x99, 0x52, 0xa5, 0xf1, 0x3d, 0x68, 0x95, 0x44, 0x52, 0xae, 0x3b, 0xa8, 0x87, 0xfa,
	0xed, 0xe1, 0xad, 0xe7, 0x71, 0xe3, 0xdf, 0xf8, 0x06, 0x5c, 0xaf, 0xd2, 0xf7, 0x82, 0xba, 0xd7,
	0x49, 0xc9, 0x54, 0x98, 0x8a, 0x22, 0xda, 0x11, 0x13, 0x9a, 0x27, 0x1e, 0x8a, 0x7b, 0xd0, 0x2e,
	0x49, 0x46, 0x47, 0x8a, 0x3d, 0xa6, 0x9d, 0x46, 0x0f, 0xf5, 0x97, 0x86, 0xcd, 0xe7, 0x31, 0x4a,
	0x96, 0x8d, 0xf5, 0x21, 0x7b, 0x4c, 0x71, 0x00, 0x60, 0x3d, 0xb4, 0x38, 0xa4, 0xbc, 0xd3, 0xb4,
	0xa1, 0xac, 0x8b, 0x05, 0xee, 0x19, 0x2b, 0x7e, 0x17, 0x5a, 0xfb, 0x2c, 0xd7, 0x54, 0x76, 0x2e,
	0xcd, 0xef, 0xbd, 0x09, 0xdf, 0x85, 0xb6, 0xa4, 0xc4, 0x31, 0xee, 0x2c, 0xf5, 0x50, 0x7f, 0x65,
	0x50, 0x29, 0x1d, 0x56, 0x94, 0xc3, 0x4f, 0x8d, 0x28, 0x3b, 0x44, 0x1d, 0xfa, 0xf0, 0x06, 0x61,
	0x8e, 0x78, 0x0b, 0x96, 0x33, 0x29, 0xa6, 0xe5, 0x68, 0xfc, 0xa8, 0xd3, 0x7a, 0x39, 0xf0, 0x65,
	0x0b, 0x18, 0x3e, 0x0a, 0x7e, 0x43, 0x80, 0xeb, 0xba, 0xa9, 0x52, 0x70, 0x45, 0xf1, 0x36, 0xb4,
	0x6c, 0x43, 0xaa, 0x0e, 0xea, 0x35, 0xfb, 0x2b, 0x83, 0x1b, 0xe1, 0xf9, 0xad, 0x18, 0x5a, 0x7c,
	0xe2, 0x41, 0xf8, 0x26, 0xac, 0x72, 0xfa, 0x9d, 0x1e, 0xd5, 0x54, 0x31, 0xc2, 0xb5, 0x93, 0x2b,
	0xc6, 0xbc, 0x3b, 0x13, 0x65, 0x1d, 0x40, 0x0b, 0x4d, 0x72, 0xa7, 0xad, 0x11, 0x6e, 0x29, 0x69,
	0x5b, 0x8b, 0xd1, 0x35, 0xc8, 0xe0, 0xda, 0xbd, 0x03, 0x9a, 0x1e, 0xda, 0xc7, 0x1f, 0x6a, 0x23,
	0xb7, 0x26, 0x7a, 0x3a, 0x2b, 0xef, 0x03, 0xb8, 0xc4, 0x49, 0x41, 0x7d, 0x71, 0xef, 0xd8, 0xe2,
	0xde, 0x86, 0x5b, 0xe7, 0x17, 0xd7, 0x3e, 0x16, 0x4b, 0xcd, 0xf6, 0x49, 0xaa, 0x13, 0xfb, 0x40,
	0xf0, 0x4b, 0x03, 0xd6, 0xcf, 0x88, 0xe4, 0x05, 0xb9, 0x09, 0xab, 0x4c, 0x8d, 0xfc, 0x90, 0x9a,
	0xfb, 0x89, 0x8d, 0xba, 0x9c, 0x5c, 0x61, 0x6a, 0x0e, 0x9a, 0x60, 0x02, 0x57, 0xdd, 0xb5, 0xf7,
	0x25, 0x3e, 0x90, 0xe5, 0xbf, 0x32, 0xb8, 0xfd, 0x52, 0x3a, 0xce, 0xb2, 0x7b, 0xcb, 0xbd, 0x75,
	0xcc, 0x68, 0x43, 0xd8, 0x19, 0x7b, 0x31, 0x44, 0xf3, 0xd5, 0x42, 0xd8, 0xb7, 0x8e, 0x19, 0x83,
	0xaf, 0x61, 0xcd, 0xf2, 0x71, 0x55, 0xbd, 0x68, 0xb5, 0xbf, 0x05, 0x5c, 0x7f, 0xdd, 0x2b, 0x7c,
	0xa6, 0x72, 0xe8, 0xa2, 0x94, 0x0b, 0x7e, 0x47, 0xf5, 0xc8, 0x3b, 0x54, 0x93, 0x09, 0xd1, 0x04,
	0x7f, 0x00, 0x6f, 0x96, 0x52, 0x64, 0x92, 0x2a, 0x35, 0x2a, 0xa9, 0x4c, 0xab, 0x7d, 0xd1, 0x48,
	0x56, 0x2b, 0xfb, 0xae, 0x33, 0xe3, 0x8f, 0x01, 0x94, 0x26, 0x52, 0x8f, 0xcc, 0xfe, 0xf1, 0x35,
	0x3d, 0x39, 0x6c, 0x7b, 0xd5, 0x72, 0x4a, 0xda, 0xd6, 0xdb, 0x9c, 0xf1, 0x47, 0xb0, 0x4c, 0xf9,
	0xc4, 0x01, 0x9b, 0x0b, 0x81, 0x97, 0x29, 0x9f, 0x98, 0xd3, 0xe0, 0xc9, 0x12, 0xbc, 0xe1, 0x1a,
	0xcc, 0x7d, 0x1a, 0xf0, 0x1f, 0x08, 0x60, 0x3e, 0xb1, 0x78, 0x73, 0x91, 0x2e, 0x27, 0xb6, 0x62,
	0x77, 0xf0, 0x7f, 0x20, 0xae, 0x3a, 0x41, 0xfc, 0x2c, 0xf6, 0xfb, 0xf0, 0xe7, 0x3f, 0xff, 0xfe,
	0xb5, 0x31, 0xc0, 0x1f, 0xce, 0x56, 0xfe, 0xf7, 0xce, 0xbe, 0x6d, 0xcb, 0xb6, 0x47, 0x64, 0x46,
	0xb5, 0x8a, 0x36, 0xa2, 0xc2, 0x2c, 0x51, 0x15, 0x6d, 0xfc, 0x10, 0xf9, 0xa5, 0xf0, 0x0f, 0x82,
	0xab, 0xa7, 0x0e, 0x19, 0xbe, 0xbb, 0x28, 0xa1, 0xf3, 0xb6, 0x40, 0x77, 0xfb, 0x15, 0xd1, 0x9e,
	0xd9, 0x97, 0xcf, 0x62, 0xdb, 0x96, 0x96, 0xd7, 0x7d, 0x3c, 0x9c, 0xf3, 0x32, 0xd6, 0xb3, 0x58,
	0x79, 0x52, 0xd1, 0x46, 0x54, 0xf5, 0xa9, 0xa1, 0xba, 0x95, 0x9a, 0x50, 0xf8, 0x2f, 0x04, 0x30,
	0xef, 0xb3, 0xc5, 0x25, 0x3a, 0x31, 0x6b, 0xdd, 0xf5, 0x0a, 0x52, 0xfb, 0x6e, 0x86, 0x5f, 0x54,
	0xdf, 0xcd, 0xe0, 0xc7, 0xa7, 0x71, 0xff, 0xd4, 0x21, 0x3a, 0xa5, 0xbd, 0xeb, 0xf4, 0x1e, 0x04,
	0xaf, 0x47, 0xcf, 0x0e, 0xd5, 0x16, 0xda, 0xe8, 0xf6, 0x9e, 0xc6, 0xeb, 0xe7, 0x0e, 0xfe, 0xf0,
	0x27, 0x04, 0x41, 0x2a, 0x8a, 0x05, 0xd4, 0x87, 0x6b, 0xf5, 0xde, 0xde, 0x35, 0x73, 0xf0, 0x19,
	0xda, 0x45, 0x5f, 0xdd, 0xf7, 0xb0, 0x4c, 0xe4, 0x84, 0x67, 0xa1, 0x90, 0x59, 0x94, 0x51, 0x6e,
	0xe7, 0x24, 0x9a, 0x07, 0x3a, 0xeb, 0x2f, 0xe4, 0x13, 0x77, 0x1c, 0xb7, 0x2c, 0xe0, 0xce, 0x7f,
	0x01, 0x00, 0x00, 0xff, 0xff, 0xd1, 0x66, 0xb5, 0x85, 0x7c, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BuildServiceClient is the client API for BuildService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BuildServiceClient interface {
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. If any of objects has already
	// been copied, it will overwrite the previous objects. Operation <response:
	// [StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//            metadata: [StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type buildServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBuildServiceClient(cc grpc.ClientConnInterface) BuildServiceClient {
	return &buildServiceClient{cc}
}

func (c *buildServiceClient) ListBuilds(ctx context.Context, in *ListBuildsRequest, opts ...grpc.CallOption) (*ListBuildsResponse, error) {
	out := new(ListBuildsResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) CheckBuildStageStatus(ctx context.Context, in *CheckBuildStageStatusRequest, opts ...grpc.CallOption) (*CheckBuildStageStatusResponse, error) {
	out := new(CheckBuildStageStatusResponse)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *buildServiceClient) StageBuild(ctx context.Context, in *StageBuildRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.chromeos.moblab.v1beta1.BuildService/StageBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BuildServiceServer is the server API for BuildService service.
type BuildServiceServer interface {
	// Lists all builds for the given build target and model in descending order
	// for the milestones and build versions.
	ListBuilds(context.Context, *ListBuildsRequest) (*ListBuildsResponse, error)
	// Checks the stage status for a given build artifact in a partner Google
	// Cloud Storage bucket.
	CheckBuildStageStatus(context.Context, *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error)
	// Stages a given build artifact from a internal Google Cloud Storage bucket
	// to a partner Google Cloud Storage bucket. If any of objects has already
	// been copied, it will overwrite the previous objects. Operation <response:
	// [StageBuildResponse][google.chromeos.moblab.v1beta1.StageBuildResponse],
	//            metadata: [StageBuildMetadata][google.chromeos.moblab.v1beta1.StageBuildMetadata]>
	StageBuild(context.Context, *StageBuildRequest) (*longrunning.Operation, error)
}

// UnimplementedBuildServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBuildServiceServer struct {
}

func (*UnimplementedBuildServiceServer) ListBuilds(ctx context.Context, req *ListBuildsRequest) (*ListBuildsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBuilds not implemented")
}
func (*UnimplementedBuildServiceServer) CheckBuildStageStatus(ctx context.Context, req *CheckBuildStageStatusRequest) (*CheckBuildStageStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckBuildStageStatus not implemented")
}
func (*UnimplementedBuildServiceServer) StageBuild(ctx context.Context, req *StageBuildRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StageBuild not implemented")
}

func RegisterBuildServiceServer(s *grpc.Server, srv BuildServiceServer) {
	s.RegisterService(&_BuildService_serviceDesc, srv)
}

func _BuildService_ListBuilds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBuildsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).ListBuilds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/ListBuilds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).ListBuilds(ctx, req.(*ListBuildsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_CheckBuildStageStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckBuildStageStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/CheckBuildStageStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).CheckBuildStageStatus(ctx, req.(*CheckBuildStageStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BuildService_StageBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StageBuildRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BuildServiceServer).StageBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.chromeos.moblab.v1beta1.BuildService/StageBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BuildServiceServer).StageBuild(ctx, req.(*StageBuildRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BuildService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.chromeos.moblab.v1beta1.BuildService",
	HandlerType: (*BuildServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListBuilds",
			Handler:    _BuildService_ListBuilds_Handler,
		},
		{
			MethodName: "CheckBuildStageStatus",
			Handler:    _BuildService_CheckBuildStageStatus_Handler,
		},
		{
			MethodName: "StageBuild",
			Handler:    _BuildService_StageBuild_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/chromeos/moblab/v1beta1/build_service.proto",
}
