// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.18.1
// source: google/apps/drive/labels/v2/requests.proto

package labels

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Resource view that can be applied to label responses. The default value
// `LABEL_VIEW_BASIC` implies the field mask:
// `name,id,revision_id,label_type,properties.*`\
type LabelView int32

const (
	// Implies the field mask:
	// `name,id,revision_id,label_type,properties.*`
	LabelView_LABEL_VIEW_BASIC LabelView = 0
	// All possible fields.
	LabelView_LABEL_VIEW_FULL LabelView = 1
)

// Enum value maps for LabelView.
var (
	LabelView_name = map[int32]string{
		0: "LABEL_VIEW_BASIC",
		1: "LABEL_VIEW_FULL",
	}
	LabelView_value = map[string]int32{
		"LABEL_VIEW_BASIC": 0,
		"LABEL_VIEW_FULL":  1,
	}
)

func (x LabelView) Enum() *LabelView {
	p := new(LabelView)
	*p = x
	return p
}

func (x LabelView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_apps_drive_labels_v2_requests_proto_enumTypes[0].Descriptor()
}

func (LabelView) Type() protoreflect.EnumType {
	return &file_google_apps_drive_labels_v2_requests_proto_enumTypes[0]
}

func (x LabelView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LabelView.Descriptor instead.
func (LabelView) EnumDescriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_requests_proto_rawDescGZIP(), []int{0}
}

// Request to get a label by resource name.
type GetLabelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Label resource name.
	//
	// May be any of:
	//
	// * `labels/{id}` (equivalent to labels/{id}@latest)
	// * `labels/{id}@latest`
	// * `labels/{id}@published`
	// * `labels/{id}@{revision_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` in order to use the user's admin credentials. The server
	// verifies that the user is an admin for the label before allowing access.
	UseAdminAccess bool `protobuf:"varint,2,opt,name=use_admin_access,json=useAdminAccess,proto3" json:"use_admin_access,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language are used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// When specified, only certain fields belonging to the indicated view are
	// returned.
	View LabelView `protobuf:"varint,4,opt,name=view,proto3,enum=google.apps.drive.labels.v2.LabelView" json:"view,omitempty"`
}

func (x *GetLabelRequest) Reset() {
	*x = GetLabelRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelRequest) ProtoMessage() {}

func (x *GetLabelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelRequest.ProtoReflect.Descriptor instead.
func (*GetLabelRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_requests_proto_rawDescGZIP(), []int{0}
}

func (x *GetLabelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetLabelRequest) GetUseAdminAccess() bool {
	if x != nil {
		return x.UseAdminAccess
	}
	return false
}

func (x *GetLabelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetLabelRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

// Request to list labels available to the current user.
type ListLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Access:
	//
	//	*ListLabelsRequest_UseAdminAccess
	//	*ListLabelsRequest_MinimumRole
	Access isListLabelsRequest_Access `protobuf_oneof:"access"`
	// Whether to include only published labels in the results.
	//
	//   - When `true`, only the current published label revisions are returned.
	//     Disabled labels are included. Returned label resource names
	//     reference the published revision (`labels/{id}/{revision_id}`).
	//   - When `false`, the current label revisions are returned, which might not
	//     be published. Returned label resource names don't reference a specific
	//     revision (`labels/{id}`).
	PublishedOnly bool `protobuf:"varint,1,opt,name=published_only,json=publishedOnly,proto3" json:"published_only,omitempty"`
	// The BCP-47 language code to use for evaluating localized field labels.
	// When not specified, values in the default configured language are used.
	LanguageCode string `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Maximum number of labels to return per page. Default: 50. Max: 200.
	PageSize int32 `protobuf:"varint,6,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token of the page to return.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// When specified, only certain fields belonging to the indicated view are
	// returned.
	View LabelView `protobuf:"varint,8,opt,name=view,proto3,enum=google.apps.drive.labels.v2.LabelView" json:"view,omitempty"`
}

func (x *ListLabelsRequest) Reset() {
	*x = ListLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsRequest) ProtoMessage() {}

func (x *ListLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListLabelsRequest) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_requests_proto_rawDescGZIP(), []int{1}
}

func (m *ListLabelsRequest) GetAccess() isListLabelsRequest_Access {
	if m != nil {
		return m.Access
	}
	return nil
}

func (x *ListLabelsRequest) GetUseAdminAccess() bool {
	if x, ok := x.GetAccess().(*ListLabelsRequest_UseAdminAccess); ok {
		return x.UseAdminAccess
	}
	return false
}

func (x *ListLabelsRequest) GetMinimumRole() LabelPermission_LabelRole {
	if x, ok := x.GetAccess().(*ListLabelsRequest_MinimumRole); ok {
		return x.MinimumRole
	}
	return LabelPermission_LABEL_ROLE_UNSPECIFIED
}

func (x *ListLabelsRequest) GetPublishedOnly() bool {
	if x != nil {
		return x.PublishedOnly
	}
	return false
}

func (x *ListLabelsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListLabelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLabelsRequest) GetView() LabelView {
	if x != nil {
		return x.View
	}
	return LabelView_LABEL_VIEW_BASIC
}

type isListLabelsRequest_Access interface {
	isListLabelsRequest_Access()
}

type ListLabelsRequest_UseAdminAccess struct {
	// Set to `true` in order to use the user's admin credentials. This will
	// return all Labels within the customer.
	UseAdminAccess bool `protobuf:"varint,3,opt,name=use_admin_access,json=useAdminAccess,proto3,oneof"`
}

type ListLabelsRequest_MinimumRole struct {
	// Specifies the level of access the user must have on the returned Labels.
	// The minimum role a user must have on a label.
	// Defaults to `READER`.
	MinimumRole LabelPermission_LabelRole `protobuf:"varint,4,opt,name=minimum_role,json=minimumRole,proto3,enum=google.apps.drive.labels.v2.LabelPermission_LabelRole,oneof"`
}

func (*ListLabelsRequest_UseAdminAccess) isListLabelsRequest_Access() {}

func (*ListLabelsRequest_MinimumRole) isListLabelsRequest_Access() {}

// Response for listing Labels.
type ListLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Labels.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// The token of the next page in the response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLabelsResponse) Reset() {
	*x = ListLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsResponse) ProtoMessage() {}

func (x *ListLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_apps_drive_labels_v2_requests_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListLabelsResponse) Descriptor() ([]byte, []int) {
	return file_google_apps_drive_labels_v2_requests_proto_rawDescGZIP(), []int{2}
}

func (x *ListLabelsResponse) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ListLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_apps_drive_labels_v2_requests_proto protoreflect.FileDescriptor

var file_google_apps_drive_labels_v2_requests_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f,
	0x76, 0x32, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64, 0x72, 0x69, 0x76,
	0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xda, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x72,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e,
	0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23,
	0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e,
	0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22,
	0xea, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x0e, 0x75, 0x73, 0x65, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x5b, 0x0a, 0x0c, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x72, 0x6f, 0x6c,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x6f, 0x6c, 0x65, 0x48,
	0x00, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x75, 0x6d, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x25,
	0x0a, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x3a, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70,
	0x70, 0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x22, 0x78, 0x0a, 0x12,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73,
	0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x36, 0x0a, 0x09, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x56,
	0x69, 0x65, 0x77, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x41, 0x42, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45,
	0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x41, 0x42,
	0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x01, 0x42, 0x7c,
	0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x73, 0x2e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x2e, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2e, 0x76,
	0x32, 0x42, 0x0d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x64,
	0x72, 0x69, 0x76, 0x65, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x2f, 0x76, 0x32, 0x3b, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0xa2, 0x02, 0x04, 0x44, 0x4c, 0x42, 0x4c, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_apps_drive_labels_v2_requests_proto_rawDescOnce sync.Once
	file_google_apps_drive_labels_v2_requests_proto_rawDescData = file_google_apps_drive_labels_v2_requests_proto_rawDesc
)

func file_google_apps_drive_labels_v2_requests_proto_rawDescGZIP() []byte {
	file_google_apps_drive_labels_v2_requests_proto_rawDescOnce.Do(func() {
		file_google_apps_drive_labels_v2_requests_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_apps_drive_labels_v2_requests_proto_rawDescData)
	})
	return file_google_apps_drive_labels_v2_requests_proto_rawDescData
}

var file_google_apps_drive_labels_v2_requests_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_apps_drive_labels_v2_requests_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_apps_drive_labels_v2_requests_proto_goTypes = []interface{}{
	(LabelView)(0),                 // 0: google.apps.drive.labels.v2.LabelView
	(*GetLabelRequest)(nil),        // 1: google.apps.drive.labels.v2.GetLabelRequest
	(*ListLabelsRequest)(nil),      // 2: google.apps.drive.labels.v2.ListLabelsRequest
	(*ListLabelsResponse)(nil),     // 3: google.apps.drive.labels.v2.ListLabelsResponse
	(LabelPermission_LabelRole)(0), // 4: google.apps.drive.labels.v2.LabelPermission.LabelRole
	(*Label)(nil),                  // 5: google.apps.drive.labels.v2.Label
}
var file_google_apps_drive_labels_v2_requests_proto_depIdxs = []int32{
	0, // 0: google.apps.drive.labels.v2.GetLabelRequest.view:type_name -> google.apps.drive.labels.v2.LabelView
	4, // 1: google.apps.drive.labels.v2.ListLabelsRequest.minimum_role:type_name -> google.apps.drive.labels.v2.LabelPermission.LabelRole
	0, // 2: google.apps.drive.labels.v2.ListLabelsRequest.view:type_name -> google.apps.drive.labels.v2.LabelView
	5, // 3: google.apps.drive.labels.v2.ListLabelsResponse.labels:type_name -> google.apps.drive.labels.v2.Label
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_apps_drive_labels_v2_requests_proto_init() }
func file_google_apps_drive_labels_v2_requests_proto_init() {
	if File_google_apps_drive_labels_v2_requests_proto != nil {
		return
	}
	file_google_apps_drive_labels_v2_label_proto_init()
	file_google_apps_drive_labels_v2_label_permission_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_apps_drive_labels_v2_requests_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLabelRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_requests_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_apps_drive_labels_v2_requests_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_apps_drive_labels_v2_requests_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ListLabelsRequest_UseAdminAccess)(nil),
		(*ListLabelsRequest_MinimumRole)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_apps_drive_labels_v2_requests_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_apps_drive_labels_v2_requests_proto_goTypes,
		DependencyIndexes: file_google_apps_drive_labels_v2_requests_proto_depIdxs,
		EnumInfos:         file_google_apps_drive_labels_v2_requests_proto_enumTypes,
		MessageInfos:      file_google_apps_drive_labels_v2_requests_proto_msgTypes,
	}.Build()
	File_google_apps_drive_labels_v2_requests_proto = out.File
	file_google_apps_drive_labels_v2_requests_proto_rawDesc = nil
	file_google_apps_drive_labels_v2_requests_proto_goTypes = nil
	file_google_apps_drive_labels_v2_requests_proto_depIdxs = nil
}
