// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.18.1
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

package vmwareengine

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum State defines possible states of private clouds.
type PrivateCloud_State int32

const (
	// The default value. This value should never be used.
	PrivateCloud_STATE_UNSPECIFIED PrivateCloud_State = 0
	// The private cloud is ready.
	PrivateCloud_ACTIVE PrivateCloud_State = 1
	// The private cloud is being created.
	PrivateCloud_CREATING PrivateCloud_State = 2
	// The private cloud is being updated.
	PrivateCloud_UPDATING PrivateCloud_State = 3
	// The private cloud is in failed state.
	PrivateCloud_FAILED PrivateCloud_State = 5
	// The private cloud is scheduled for deletion. The deletion process can be
	// cancelled by using the corresponding undelete method.
	PrivateCloud_DELETED PrivateCloud_State = 6
	// The private cloud is irreversibly deleted and is being removed from the
	// system.
	PrivateCloud_PURGING PrivateCloud_State = 7
)

// Enum value maps for PrivateCloud_State.
var (
	PrivateCloud_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		5: "FAILED",
		6: "DELETED",
		7: "PURGING",
	}
	PrivateCloud_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"FAILED":            5,
		"DELETED":           6,
		"PURGING":           7,
	}
)

func (x PrivateCloud_State) Enum() *PrivateCloud_State {
	p := new(PrivateCloud_State)
	*p = x
	return p
}

func (x PrivateCloud_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrivateCloud_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[0].Descriptor()
}

func (PrivateCloud_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[0]
}

func (x PrivateCloud_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrivateCloud_State.Descriptor instead.
func (PrivateCloud_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{2, 0}
}

// Enum State defines possible states of private cloud clusters.
type Cluster_State int32

const (
	// The default value. This value should never be used.
	Cluster_STATE_UNSPECIFIED Cluster_State = 0
	// The Cluster is operational and can be used by the user.
	Cluster_ACTIVE Cluster_State = 1
	// The Cluster is being deployed.
	Cluster_CREATING Cluster_State = 2
	// Adding or removing of a node to the cluster, any other cluster specific
	// updates.
	Cluster_UPDATING Cluster_State = 3
	// The Cluster is being deleted.
	Cluster_DELETING Cluster_State = 4
	// The Cluster is undergoing maintenance, for example: a failed node is
	// getting replaced.
	Cluster_REPAIRING Cluster_State = 5
)

// Enum value maps for Cluster_State.
var (
	Cluster_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
		5: "REPAIRING",
	}
	Cluster_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
		"REPAIRING":         5,
	}
)

func (x Cluster_State) Enum() *Cluster_State {
	p := new(Cluster_State)
	*p = x
	return p
}

func (x Cluster_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[1].Descriptor()
}

func (Cluster_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[1]
}

func (x Cluster_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_State.Descriptor instead.
func (Cluster_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{10, 0}
}

// Defines possible states of subnets.
type Subnet_State int32

const (
	// The default value. This value should never be used.
	Subnet_STATE_UNSPECIFIED Subnet_State = 0
	// The subnet is ready.
	Subnet_ACTIVE Subnet_State = 1
	// The subnet is being created.
	Subnet_CREATING Subnet_State = 2
	// The subnet is being updated.
	Subnet_UPDATING Subnet_State = 3
	// The subnet is being deleted.
	Subnet_DELETING Subnet_State = 4
)

// Enum value maps for Subnet_State.
var (
	Subnet_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
		3: "UPDATING",
		4: "DELETING",
	}
	Subnet_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x Subnet_State) Enum() *Subnet_State {
	p := new(Subnet_State)
	*p = x
	return p
}

func (x Subnet_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subnet_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[2].Descriptor()
}

func (Subnet_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[2]
}

func (x Subnet_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subnet_State.Descriptor instead.
func (Subnet_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{17, 0}
}

// State of HCX activation key
type HcxActivationKey_State int32

const (
	// Unspecified state.
	HcxActivationKey_STATE_UNSPECIFIED HcxActivationKey_State = 0
	// State of a newly generated activation key.
	HcxActivationKey_AVAILABLE HcxActivationKey_State = 1
	// State of key when it has been used to activate HCX appliance.
	HcxActivationKey_CONSUMED HcxActivationKey_State = 2
	// State of key when it is being created.
	HcxActivationKey_CREATING HcxActivationKey_State = 3
)

// Enum value maps for HcxActivationKey_State.
var (
	HcxActivationKey_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "AVAILABLE",
		2: "CONSUMED",
		3: "CREATING",
	}
	HcxActivationKey_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"AVAILABLE":         1,
		"CONSUMED":          2,
		"CREATING":          3,
	}
)

func (x HcxActivationKey_State) Enum() *HcxActivationKey_State {
	p := new(HcxActivationKey_State)
	*p = x
	return p
}

func (x HcxActivationKey_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HcxActivationKey_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[3].Descriptor()
}

func (HcxActivationKey_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[3]
}

func (x HcxActivationKey_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HcxActivationKey_State.Descriptor instead.
func (HcxActivationKey_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{31, 0}
}

// State of the appliance
type Hcx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Hcx_STATE_UNSPECIFIED Hcx_State = 0
	// The appliance is operational and can be used.
	Hcx_ACTIVE Hcx_State = 1
	// The appliance is being deployed.
	Hcx_CREATING Hcx_State = 2
)

// Enum value maps for Hcx_State.
var (
	Hcx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Hcx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Hcx_State) Enum() *Hcx_State {
	p := new(Hcx_State)
	*p = x
	return p
}

func (x Hcx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Hcx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[4].Descriptor()
}

func (Hcx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[4]
}

func (x Hcx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Hcx_State.Descriptor instead.
func (Hcx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{35, 0}
}

// State of the appliance
type Nsx_State int32

const (
	// Unspecified appliance state. This is the default value.
	Nsx_STATE_UNSPECIFIED Nsx_State = 0
	// The appliance is operational and can be used.
	Nsx_ACTIVE Nsx_State = 1
	// The appliance is being deployed.
	Nsx_CREATING Nsx_State = 2
)

// Enum value maps for Nsx_State.
var (
	Nsx_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Nsx_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Nsx_State) Enum() *Nsx_State {
	p := new(Nsx_State)
	*p = x
	return p
}

func (x Nsx_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Nsx_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[5].Descriptor()
}

func (Nsx_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[5]
}

func (x Nsx_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Nsx_State.Descriptor instead.
func (Nsx_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{36, 0}
}

// State of the appliance
type Vcenter_State int32

const (
	// Unspecified appliance state. This is the default value.
	Vcenter_STATE_UNSPECIFIED Vcenter_State = 0
	// The appliance is operational and can be used.
	Vcenter_ACTIVE Vcenter_State = 1
	// The appliance is being deployed.
	Vcenter_CREATING Vcenter_State = 2
)

// Enum value maps for Vcenter_State.
var (
	Vcenter_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "CREATING",
	}
	Vcenter_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"CREATING":          2,
	}
)

func (x Vcenter_State) Enum() *Vcenter_State {
	p := new(Vcenter_State)
	*p = x
	return p
}

func (x Vcenter_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Vcenter_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[6].Descriptor()
}

func (Vcenter_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[6]
}

func (x Vcenter_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Vcenter_State.Descriptor instead.
func (Vcenter_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{37, 0}
}

// Enum State defines possible states of a network policy controlled
// service.
type NetworkPolicy_NetworkService_State int32

const (
	// Unspecified service state. This is the default value.
	NetworkPolicy_NetworkService_STATE_UNSPECIFIED NetworkPolicy_NetworkService_State = 0
	// Service is not provisioned.
	NetworkPolicy_NetworkService_UNPROVISIONED NetworkPolicy_NetworkService_State = 1
	// Service is in the process of being provisioned/deprovisioned.
	NetworkPolicy_NetworkService_RECONCILING NetworkPolicy_NetworkService_State = 2
	// Service is active.
	NetworkPolicy_NetworkService_ACTIVE NetworkPolicy_NetworkService_State = 3
)

// Enum value maps for NetworkPolicy_NetworkService_State.
var (
	NetworkPolicy_NetworkService_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNPROVISIONED",
		2: "RECONCILING",
		3: "ACTIVE",
	}
	NetworkPolicy_NetworkService_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNPROVISIONED":     1,
		"RECONCILING":       2,
		"ACTIVE":            3,
	}
)

func (x NetworkPolicy_NetworkService_State) Enum() *NetworkPolicy_NetworkService_State {
	p := new(NetworkPolicy_NetworkService_State)
	*p = x
	return p
}

func (x NetworkPolicy_NetworkService_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkPolicy_NetworkService_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[7].Descriptor()
}

func (NetworkPolicy_NetworkService_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[7]
}

func (x NetworkPolicy_NetworkService_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkPolicy_NetworkService_State.Descriptor instead.
func (NetworkPolicy_NetworkService_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{38, 0, 0}
}

// Enum State defines possible states of VMware Engine network.
type VmwareEngineNetwork_State int32

const (
	// The default value. This value is used if the state is omitted.
	VmwareEngineNetwork_STATE_UNSPECIFIED VmwareEngineNetwork_State = 0
	// The VMware Engine network is being created.
	VmwareEngineNetwork_CREATING VmwareEngineNetwork_State = 1
	// The VMware Engine network is ready.
	VmwareEngineNetwork_ACTIVE VmwareEngineNetwork_State = 2
	// The VMware Engine network is being updated.
	VmwareEngineNetwork_UPDATING VmwareEngineNetwork_State = 3
	// The VMware Engine network is being deleted.
	VmwareEngineNetwork_DELETING VmwareEngineNetwork_State = 4
)

// Enum value maps for VmwareEngineNetwork_State.
var (
	VmwareEngineNetwork_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	VmwareEngineNetwork_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x VmwareEngineNetwork_State) Enum() *VmwareEngineNetwork_State {
	p := new(VmwareEngineNetwork_State)
	*p = x
	return p
}

func (x VmwareEngineNetwork_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[8].Descriptor()
}

func (VmwareEngineNetwork_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[8]
}

func (x VmwareEngineNetwork_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_State.Descriptor instead.
func (VmwareEngineNetwork_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45, 0}
}

// Enum Type defines possible types of VMware Engine network.
type VmwareEngineNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_Type = 0
	// Network type used by private clouds created in projects without a network
	// of type `STANDARD`. This network type is no longer used for new VMware
	// Engine private cloud deployments.
	VmwareEngineNetwork_LEGACY VmwareEngineNetwork_Type = 1
)

// Enum value maps for VmwareEngineNetwork_Type.
var (
	VmwareEngineNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "LEGACY",
	}
	VmwareEngineNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"LEGACY":           1,
	}
)

func (x VmwareEngineNetwork_Type) Enum() *VmwareEngineNetwork_Type {
	p := new(VmwareEngineNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[9].Descriptor()
}

func (VmwareEngineNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[9]
}

func (x VmwareEngineNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45, 1}
}

// Enum Type defines possible types of a VMware Engine network controlled
// service.
type VmwareEngineNetwork_VpcNetwork_Type int32

const (
	// The default value. This value should never be used.
	VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED VmwareEngineNetwork_VpcNetwork_Type = 0
	// VPC network that will be peered with a consumer VPC network or the
	// intranet VPC of another VMware Engine network. Access a private cloud
	// through Compute Engine VMs on a peered VPC network or an on-premises
	// resource connected to a peered consumer VPC network.
	VmwareEngineNetwork_VpcNetwork_INTRANET VmwareEngineNetwork_VpcNetwork_Type = 1
	// VPC network used for internet access to and from a private cloud.
	VmwareEngineNetwork_VpcNetwork_INTERNET VmwareEngineNetwork_VpcNetwork_Type = 2
	// VPC network used for access to Google Cloud services like
	// Cloud Storage.
	VmwareEngineNetwork_VpcNetwork_GOOGLE_CLOUD VmwareEngineNetwork_VpcNetwork_Type = 3
)

// Enum value maps for VmwareEngineNetwork_VpcNetwork_Type.
var (
	VmwareEngineNetwork_VpcNetwork_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INTRANET",
		2: "INTERNET",
		3: "GOOGLE_CLOUD",
	}
	VmwareEngineNetwork_VpcNetwork_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INTRANET":         1,
		"INTERNET":         2,
		"GOOGLE_CLOUD":     3,
	}
)

func (x VmwareEngineNetwork_VpcNetwork_Type) Enum() *VmwareEngineNetwork_VpcNetwork_Type {
	p := new(VmwareEngineNetwork_VpcNetwork_Type)
	*p = x
	return p
}

func (x VmwareEngineNetwork_VpcNetwork_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareEngineNetwork_VpcNetwork_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[10].Descriptor()
}

func (VmwareEngineNetwork_VpcNetwork_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes[10]
}

func (x VmwareEngineNetwork_VpcNetwork_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork_Type.Descriptor instead.
func (VmwareEngineNetwork_VpcNetwork_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45, 0, 0}
}

// Network configuration in the consumer project
// with which the peering has to be done.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Management CIDR used by VMware management appliances.
	ManagementCidr string `protobuf:"bytes,4,opt,name=management_cidr,json=managementCidr,proto3" json:"management_cidr,omitempty"`
	// Optional. The relative resource name of the VMware Engine network attached
	// to the private cloud. Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,5,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,6,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
	// Output only. The IP address layout version of the management IP address
	// range. Possible versions include:
	// * `managementIpAddressLayoutVersion=1`: Indicates the legacy IP address
	// layout used by some existing private clouds. This is no longer supported
	// for new private clouds as it does not support all features.
	// * `managementIpAddressLayoutVersion=2`: Indicates the latest IP address
	// layout used by all newly created private clouds. This version supports all
	// current features.
	ManagementIpAddressLayoutVersion int32 `protobuf:"varint,8,opt,name=management_ip_address_layout_version,json=managementIpAddressLayoutVersion,proto3" json:"management_ip_address_layout_version,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkConfig) GetManagementCidr() string {
	if x != nil {
		return x.ManagementCidr
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkConfig) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

func (x *NetworkConfig) GetManagementIpAddressLayoutVersion() int32 {
	if x != nil {
		return x.ManagementIpAddressLayoutVersion
	}
	return 0
}

// Information about the type and number of nodes associated with the cluster.
type NodeTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The number of nodes of this type in the cluster
	NodeCount int32 `protobuf:"varint,1,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Optional. Customized number of cores available to each node of the type.
	// This number must always be one of `nodeType.availableCustomCoreCounts`.
	// If zero is provided max value from `nodeType.availableCustomCoreCounts`
	// will be used.
	CustomCoreCount int32 `protobuf:"varint,2,opt,name=custom_core_count,json=customCoreCount,proto3" json:"custom_core_count,omitempty"`
}

func (x *NodeTypeConfig) Reset() {
	*x = NodeTypeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeTypeConfig) ProtoMessage() {}

func (x *NodeTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeTypeConfig.ProtoReflect.Descriptor instead.
func (*NodeTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{1}
}

func (x *NodeTypeConfig) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *NodeTypeConfig) GetCustomCoreCount() int32 {
	if x != nil {
		return x.CustomCoreCount
	}
	return 0
}

// Represents a private cloud resource. Private clouds are zonal resources.
type PrivateCloud struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this private cloud.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Time when the resource was scheduled for deletion.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Output only. Time when the resource will be irreversibly deleted.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. State of the resource. New values may be added to this enum
	// when appropriate.
	State PrivateCloud_State `protobuf:"varint,8,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.PrivateCloud_State" json:"state,omitempty"`
	// Required. Network configuration of the private cloud.
	NetworkConfig *NetworkConfig `protobuf:"bytes,9,opt,name=network_config,json=networkConfig,proto3" json:"network_config,omitempty"`
	// Input only. The management cluster for this private cloud.
	// This field is required during creation of the private cloud to provide
	// details for the default cluster.
	//
	// The following fields can't be changed after private cloud creation:
	// `ManagementCluster.clusterId`, `ManagementCluster.nodeTypeId`.
	ManagementCluster *PrivateCloud_ManagementCluster `protobuf:"bytes,10,opt,name=management_cluster,json=managementCluster,proto3" json:"management_cluster,omitempty"`
	// User-provided description for this private cloud.
	Description string `protobuf:"bytes,11,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. HCX appliance.
	Hcx *Hcx `protobuf:"bytes,17,opt,name=hcx,proto3" json:"hcx,omitempty"`
	// Output only. NSX appliance.
	Nsx *Nsx `protobuf:"bytes,18,opt,name=nsx,proto3" json:"nsx,omitempty"`
	// Output only. Vcenter appliance.
	Vcenter *Vcenter `protobuf:"bytes,19,opt,name=vcenter,proto3" json:"vcenter,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,20,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *PrivateCloud) Reset() {
	*x = PrivateCloud{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateCloud) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud) ProtoMessage() {}

func (x *PrivateCloud) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud.ProtoReflect.Descriptor instead.
func (*PrivateCloud) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{2}
}

func (x *PrivateCloud) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PrivateCloud) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PrivateCloud) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PrivateCloud) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *PrivateCloud) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *PrivateCloud) GetState() PrivateCloud_State {
	if x != nil {
		return x.State
	}
	return PrivateCloud_STATE_UNSPECIFIED
}

func (x *PrivateCloud) GetNetworkConfig() *NetworkConfig {
	if x != nil {
		return x.NetworkConfig
	}
	return nil
}

func (x *PrivateCloud) GetManagementCluster() *PrivateCloud_ManagementCluster {
	if x != nil {
		return x.ManagementCluster
	}
	return nil
}

func (x *PrivateCloud) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PrivateCloud) GetHcx() *Hcx {
	if x != nil {
		return x.Hcx
	}
	return nil
}

func (x *PrivateCloud) GetNsx() *Nsx {
	if x != nil {
		return x.Nsx
	}
	return nil
}

func (x *PrivateCloud) GetVcenter() *Vcenter {
	if x != nil {
		return x.Vcenter
	}
	return nil
}

func (x *PrivateCloud) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Request message for [VmwareEngine.ListPrivateClouds][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds]
type ListPrivateCloudsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to be queried for
	// clusters. Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of private clouds to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPrivateClouds` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPrivateClouds` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison operator, and the
	// value that you want to use for filtering. The value must be a string, a
	// number, or a boolean. The comparison operator must be `=`, `!=`, `>`, or
	// `<`.
	//
	// For example, if you are filtering a list of private clouds, you can exclude
	// the ones named `example-pc` by specifying `name != "example-pc"`.
	//
	// You can also filter nested fields. For example, you could specify
	// `networkConfig.managementCidr = "192.168.0.0/24"` to include private clouds
	// only if they have a matching address in their network configuration.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-pc")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you can
	// include `AND` and `OR` expressions explicitly. For example:
	// ```
	// (name = "private-cloud-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "private-cloud-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results are
	// ordered by `name` in ascending order. You can also sort results in
	// descending order based on the `name` value using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPrivateCloudsRequest) Reset() {
	*x = ListPrivateCloudsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateCloudsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateCloudsRequest) ProtoMessage() {}

func (x *ListPrivateCloudsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateCloudsRequest.ProtoReflect.Descriptor instead.
func (*ListPrivateCloudsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{3}
}

func (x *ListPrivateCloudsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrivateCloudsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPrivateCloudsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [VmwareEngine.ListPrivateClouds][google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds]
type ListPrivateCloudsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of private clouds.
	PrivateClouds []*PrivateCloud `protobuf:"bytes,1,rep,name=private_clouds,json=privateClouds,proto3" json:"private_clouds,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPrivateCloudsResponse) Reset() {
	*x = ListPrivateCloudsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPrivateCloudsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrivateCloudsResponse) ProtoMessage() {}

func (x *ListPrivateCloudsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrivateCloudsResponse.ProtoReflect.Descriptor instead.
func (*ListPrivateCloudsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{4}
}

func (x *ListPrivateCloudsResponse) GetPrivateClouds() []*PrivateCloud {
	if x != nil {
		return x.PrivateClouds
	}
	return nil
}

func (x *ListPrivateCloudsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPrivateCloudsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [VmwareEngine.GetPrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud]
type GetPrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPrivateCloudRequest) Reset() {
	*x = GetPrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPrivateCloudRequest) ProtoMessage() {}

func (x *GetPrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*GetPrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{5}
}

func (x *GetPrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [VmwareEngine.CreatePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud]
type CreatePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to create the new
	// private cloud in. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the private cloud to be created.
	// This identifier must be unique among each `PrivateCloud` within the parent
	// and becomes the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	PrivateCloudId string `protobuf:"bytes,2,opt,name=private_cloud_id,json=privateCloudId,proto3" json:"private_cloud_id,omitempty"`
	// Required. The initial description of the new private cloud.
	PrivateCloud *PrivateCloud `protobuf:"bytes,3,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed; false
	// otherwise.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreatePrivateCloudRequest) Reset() {
	*x = CreatePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePrivateCloudRequest) ProtoMessage() {}

func (x *CreatePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*CreatePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{6}
}

func (x *CreatePrivateCloudRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetPrivateCloudId() string {
	if x != nil {
		return x.PrivateCloudId
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetPrivateCloud() *PrivateCloud {
	if x != nil {
		return x.PrivateCloud
	}
	return nil
}

func (x *CreatePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreatePrivateCloudRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for [VmwareEngine.UpdatePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud]
type UpdatePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Private cloud description.
	PrivateCloud *PrivateCloud `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// `PrivateCloud` resource by the update. The fields specified in `updateMask`
	// are relative to the resource, not the full request. A field will be
	// overwritten if it is in the mask. If the user does not provide a mask then
	// all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdatePrivateCloudRequest) Reset() {
	*x = UpdatePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePrivateCloudRequest) ProtoMessage() {}

func (x *UpdatePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*UpdatePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{7}
}

func (x *UpdatePrivateCloudRequest) GetPrivateCloud() *PrivateCloud {
	if x != nil {
		return x.PrivateCloud
	}
	return nil
}

func (x *UpdatePrivateCloudRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.DeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud]
type DeletePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, cascade delete is enabled and all children of this private
	// cloud resource are also deleted. When this flag is set to false, the
	// private cloud will not be deleted if there are any children other than the
	// management cluster. The management cluster is always deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. Time delay of the deletion specified in hours. The default value
	// is `3`. Specifying a non-zero value for this field changes the value of
	// `PrivateCloud.state` to `DELETED` and sets `expire_time` to the planned
	// deletion time. Deletion can be cancelled before `expire_time` elapses using
	// [VmwareEngine.UndeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud]. Specifying a value of `0` for
	// this field instead begins the deletion process and ceases billing
	// immediately. During the final deletion process, the value of
	// `PrivateCloud.state` becomes `PURGING`.
	DelayHours *int32 `protobuf:"varint,4,opt,name=delay_hours,json=delayHours,proto3,oneof" json:"delay_hours,omitempty"`
}

func (x *DeletePrivateCloudRequest) Reset() {
	*x = DeletePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePrivateCloudRequest) ProtoMessage() {}

func (x *DeletePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*DeletePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{8}
}

func (x *DeletePrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeletePrivateCloudRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeletePrivateCloudRequest) GetDelayHours() int32 {
	if x != nil && x.DelayHours != nil {
		return *x.DelayHours
	}
	return 0
}

// Request message for [VmwareEngine.UndeletePrivateCloud][google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud]
type UndeletePrivateCloudRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud scheduled for deletion.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UndeletePrivateCloudRequest) Reset() {
	*x = UndeletePrivateCloudRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeletePrivateCloudRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeletePrivateCloudRequest) ProtoMessage() {}

func (x *UndeletePrivateCloudRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeletePrivateCloudRequest.ProtoReflect.Descriptor instead.
func (*UndeletePrivateCloudRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{9}
}

func (x *UndeletePrivateCloudRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UndeletePrivateCloudRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A cluster in a private cloud.
type Cluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this cluster.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the resource.
	State Cluster_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Cluster_State" json:"state,omitempty"`
	// Output only. True if the cluster is a management cluster; false otherwise.
	// There can only be one management cluster in a private cloud
	// and it has to be the first one.
	Management bool `protobuf:"varint,7,opt,name=management,proto3" json:"management,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,14,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is canonical
	// identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,16,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{10}
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Cluster) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Cluster) GetState() Cluster_State {
	if x != nil {
		return x.State
	}
	return Cluster_STATE_UNSPECIFIED
}

func (x *Cluster) GetManagement() bool {
	if x != nil {
		return x.Management
	}
	return false
}

func (x *Cluster) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Cluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

// Request message for [VmwareEngine.ListClusters][google.cloud.vmwareengine.v1.VmwareEngine.ListClusters]
type ListClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to query for clusters.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of clusters to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListClusters` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListClusters`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-cluster")
	// (nodeCount = "3")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you can
	// include `AND` and `OR` expressions explicitly. For example:
	// ```
	// (name = "example-cluster-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-cluster-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results are
	// ordered by `name` in ascending order. You can also sort results in
	// descending order based on the `name` value using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListClustersRequest) Reset() {
	*x = ListClustersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersRequest) ProtoMessage() {}

func (x *ListClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersRequest.ProtoReflect.Descriptor instead.
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{11}
}

func (x *ListClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListClustersRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [VmwareEngine.ListClusters][google.cloud.vmwareengine.v1.VmwareEngine.ListClusters]
type ListClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of private cloud clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListClustersResponse) Reset() {
	*x = ListClustersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListClustersResponse) ProtoMessage() {}

func (x *ListClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListClustersResponse.ProtoReflect.Descriptor instead.
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{12}
}

func (x *ListClustersResponse) GetClusters() []*Cluster {
	if x != nil {
		return x.Clusters
	}
	return nil
}

func (x *ListClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListClustersResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [VmwareEngine.GetCluster][google.cloud.vmwareengine.v1.VmwareEngine.GetCluster]
type GetClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cluster resource name to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetClusterRequest) Reset() {
	*x = GetClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetClusterRequest) ProtoMessage() {}

func (x *GetClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetClusterRequest.ProtoReflect.Descriptor instead.
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{13}
}

func (x *GetClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [VmwareEngine.CreateCluster][google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster]
type CreateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to create a new cluster
	// in. Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the new `Cluster`.
	// This identifier must be unique among clusters within the parent and becomes
	// the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The initial description of the new cluster.
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed; false
	// otherwise.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateClusterRequest) Reset() {
	*x = CreateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateClusterRequest) ProtoMessage() {}

func (x *CreateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{14}
}

func (x *CreateClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateClusterRequest) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *CreateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *CreateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for [VmwareEngine.UpdateCluster][google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster]
type UpdateClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// `Cluster` resource by the update. The fields specified in the `updateMask`
	// are relative to the resource, not the full request. A field will be
	// overwritten if it is in the mask. If the user does not provide a mask then
	// all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The description of the cluster.
	Cluster *Cluster `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that
	// zero UUID is not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. True if you want the request to be validated and not executed; false
	// otherwise.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateClusterRequest) Reset() {
	*x = UpdateClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateClusterRequest) ProtoMessage() {}

func (x *UpdateClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateClusterRequest.ProtoReflect.Descriptor instead.
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateClusterRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateClusterRequest) GetCluster() *Cluster {
	if x != nil {
		return x.Cluster
	}
	return nil
}

func (x *UpdateClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateClusterRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for [VmwareEngine.DeleteCluster][google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster]
type DeleteClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the cluster to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud/clusters/my-cluster`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteClusterRequest) Reset() {
	*x = DeleteClusterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteClusterRequest) ProtoMessage() {}

func (x *DeleteClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Subnet in a private cloud. Either `management` subnets (such as vMotion) that
// are read-only, or `userDefined`, which can also be updated.
type Subnet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this subnet.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud/subnets/my-subnet`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The IP address range of the subnet in CIDR format '10.0.0.0/24'.
	IpCidrRange string `protobuf:"bytes,7,opt,name=ip_cidr_range,json=ipCidrRange,proto3" json:"ip_cidr_range,omitempty"`
	// The IP address of the gateway of this subnet.
	// Must fall within the IP prefix defined above.
	GatewayIp string `protobuf:"bytes,8,opt,name=gateway_ip,json=gatewayIp,proto3" json:"gateway_ip,omitempty"`
	// Output only. The type of the subnet. For example "management" or "userDefined".
	Type string `protobuf:"bytes,11,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The state of the resource.
	State Subnet_State `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Subnet_State" json:"state,omitempty"`
}

func (x *Subnet) Reset() {
	*x = Subnet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subnet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subnet) ProtoMessage() {}

func (x *Subnet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subnet.ProtoReflect.Descriptor instead.
func (*Subnet) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{17}
}

func (x *Subnet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subnet) GetIpCidrRange() string {
	if x != nil {
		return x.IpCidrRange
	}
	return ""
}

func (x *Subnet) GetGatewayIp() string {
	if x != nil {
		return x.GatewayIp
	}
	return ""
}

func (x *Subnet) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Subnet) GetState() Subnet_State {
	if x != nil {
		return x.State
	}
	return Subnet_STATE_UNSPECIFIED
}

// Request message for [VmwareEngine.ListSubnets][google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets]
type ListSubnetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to be queried for
	// subnets.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of subnets to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSubnetsRequest` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListSubnetsRequest` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSubnetsRequest) Reset() {
	*x = ListSubnetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubnetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubnetsRequest) ProtoMessage() {}

func (x *ListSubnetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubnetsRequest.ProtoReflect.Descriptor instead.
func (*ListSubnetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{18}
}

func (x *ListSubnetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSubnetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSubnetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for [VmwareEngine.ListSubnets][google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets]
type ListSubnetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of subnets.
	Subnets []*Subnet `protobuf:"bytes,1,rep,name=subnets,proto3" json:"subnets,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSubnetsResponse) Reset() {
	*x = ListSubnetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSubnetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSubnetsResponse) ProtoMessage() {}

func (x *ListSubnetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSubnetsResponse.ProtoReflect.Descriptor instead.
func (*ListSubnetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{19}
}

func (x *ListSubnetsResponse) GetSubnets() []*Subnet {
	if x != nil {
		return x.Subnets
	}
	return nil
}

func (x *ListSubnetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. True if the user has requested cancellation
	// of the operation; false otherwise.
	// Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{20}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Describes node type.
type NodeType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this node type.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-proj/locations/us-west1-a/nodeTypes/standard-72`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The canonical identifier of the node type
	// (corresponds to the `NodeType`). For example: standard-72.
	NodeTypeId string `protobuf:"bytes,2,opt,name=node_type_id,json=nodeTypeId,proto3" json:"node_type_id,omitempty"`
	// Output only. The friendly name for this node type.
	// For example: ve1-standard-72
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. The total number of virtual CPUs in a single node.
	VirtualCpuCount int32 `protobuf:"varint,4,opt,name=virtual_cpu_count,json=virtualCpuCount,proto3" json:"virtual_cpu_count,omitempty"`
	// Output only. The total number of CPU cores in a single node.
	TotalCoreCount int32 `protobuf:"varint,5,opt,name=total_core_count,json=totalCoreCount,proto3" json:"total_core_count,omitempty"`
	// Output only. The amount of physical memory available, defined in GB.
	MemoryGb int32 `protobuf:"varint,7,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	// Output only. The amount of storage available, defined in GB.
	DiskSizeGb int32 `protobuf:"varint,8,opt,name=disk_size_gb,json=diskSizeGb,proto3" json:"disk_size_gb,omitempty"`
	// Output only. List of possible values of custom core count.
	AvailableCustomCoreCounts []int32 `protobuf:"varint,11,rep,packed,name=available_custom_core_counts,json=availableCustomCoreCounts,proto3" json:"available_custom_core_counts,omitempty"`
}

func (x *NodeType) Reset() {
	*x = NodeType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NodeType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeType) ProtoMessage() {}

func (x *NodeType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeType.ProtoReflect.Descriptor instead.
func (*NodeType) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{21}
}

func (x *NodeType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NodeType) GetNodeTypeId() string {
	if x != nil {
		return x.NodeTypeId
	}
	return ""
}

func (x *NodeType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NodeType) GetVirtualCpuCount() int32 {
	if x != nil {
		return x.VirtualCpuCount
	}
	return 0
}

func (x *NodeType) GetTotalCoreCount() int32 {
	if x != nil {
		return x.TotalCoreCount
	}
	return 0
}

func (x *NodeType) GetMemoryGb() int32 {
	if x != nil {
		return x.MemoryGb
	}
	return 0
}

func (x *NodeType) GetDiskSizeGb() int32 {
	if x != nil {
		return x.DiskSizeGb
	}
	return 0
}

func (x *NodeType) GetAvailableCustomCoreCounts() []int32 {
	if x != nil {
		return x.AvailableCustomCoreCounts
	}
	return nil
}

// Request message for [VmwareEngine.ListNodeTypes][google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes]
type ListNodeTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to be queried for node types.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of node types to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListNodeTypes` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListNodeTypes` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of node types, you can
	// exclude the ones named `standard-72` by specifying
	// `name != "standard-72"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "standard-72")
	// (virtual_cpu_count > 2)
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "standard-96") AND
	// (virtual_cpu_count > 2) OR
	// (name = "standard-72")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListNodeTypesRequest) Reset() {
	*x = ListNodeTypesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodeTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodeTypesRequest) ProtoMessage() {}

func (x *ListNodeTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodeTypesRequest.ProtoReflect.Descriptor instead.
func (*ListNodeTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{22}
}

func (x *ListNodeTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNodeTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNodeTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNodeTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for [VmwareEngine.ListNodeTypes][google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes]
type ListNodeTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Node Types.
	NodeTypes []*NodeType `protobuf:"bytes,1,rep,name=node_types,json=nodeTypes,proto3" json:"node_types,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNodeTypesResponse) Reset() {
	*x = ListNodeTypesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNodeTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNodeTypesResponse) ProtoMessage() {}

func (x *ListNodeTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNodeTypesResponse.ProtoReflect.Descriptor instead.
func (*ListNodeTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{23}
}

func (x *ListNodeTypesResponse) GetNodeTypes() []*NodeType {
	if x != nil {
		return x.NodeTypes
	}
	return nil
}

func (x *ListNodeTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNodeTypesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [VmwareEngine.GetNodeType][google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType]
type GetNodeTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the node type to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-proj/locations/us-west1-a/nodeTypes/standard-72`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNodeTypeRequest) Reset() {
	*x = GetNodeTypeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNodeTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNodeTypeRequest) ProtoMessage() {}

func (x *GetNodeTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNodeTypeRequest.ProtoReflect.Descriptor instead.
func (*GetNodeTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{24}
}

func (x *GetNodeTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Credentials for a private cloud.
type Credentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Initial username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Initial password.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *Credentials) Reset() {
	*x = Credentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Credentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Credentials) ProtoMessage() {}

func (x *Credentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Credentials.ProtoReflect.Descriptor instead.
func (*Credentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{25}
}

func (x *Credentials) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *Credentials) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// Request message for [VmwareEngine.ShowNsxCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials]
type ShowNsxCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for credentials.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
}

func (x *ShowNsxCredentialsRequest) Reset() {
	*x = ShowNsxCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowNsxCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowNsxCredentialsRequest) ProtoMessage() {}

func (x *ShowNsxCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowNsxCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ShowNsxCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{26}
}

func (x *ShowNsxCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

// Request message for [VmwareEngine.ShowVcenterCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials]
type ShowVcenterCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for credentials.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
}

func (x *ShowVcenterCredentialsRequest) Reset() {
	*x = ShowVcenterCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ShowVcenterCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShowVcenterCredentialsRequest) ProtoMessage() {}

func (x *ShowVcenterCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShowVcenterCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ShowVcenterCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{27}
}

func (x *ShowVcenterCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

// Request message for [VmwareEngine.ResetNsxCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials]
type ResetNsxCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to reset credentials for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResetNsxCredentialsRequest) Reset() {
	*x = ResetNsxCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetNsxCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetNsxCredentialsRequest) ProtoMessage() {}

func (x *ResetNsxCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetNsxCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ResetNsxCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{28}
}

func (x *ResetNsxCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

func (x *ResetNsxCredentialsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.ResetVcenterCredentials][google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials]
type ResetVcenterCredentialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to reset credentials for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1-a/privateClouds/my-cloud`
	PrivateCloud string `protobuf:"bytes,1,opt,name=private_cloud,json=privateCloud,proto3" json:"private_cloud,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *ResetVcenterCredentialsRequest) Reset() {
	*x = ResetVcenterCredentialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResetVcenterCredentialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResetVcenterCredentialsRequest) ProtoMessage() {}

func (x *ResetVcenterCredentialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResetVcenterCredentialsRequest.ProtoReflect.Descriptor instead.
func (*ResetVcenterCredentialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{29}
}

func (x *ResetVcenterCredentialsRequest) GetPrivateCloud() string {
	if x != nil {
		return x.PrivateCloud
	}
	return ""
}

func (x *ResetVcenterCredentialsRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
type ListHcxActivationKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of HCX activation keys.
	HcxActivationKeys []*HcxActivationKey `protobuf:"bytes,1,rep,name=hcx_activation_keys,json=hcxActivationKeys,proto3" json:"hcx_activation_keys,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListHcxActivationKeysResponse) Reset() {
	*x = ListHcxActivationKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcxActivationKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcxActivationKeysResponse) ProtoMessage() {}

func (x *ListHcxActivationKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcxActivationKeysResponse.ProtoReflect.Descriptor instead.
func (*ListHcxActivationKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{30}
}

func (x *ListHcxActivationKeysResponse) GetHcxActivationKeys() []*HcxActivationKey {
	if x != nil {
		return x.HcxActivationKeys
	}
	return nil
}

func (x *ListHcxActivationKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListHcxActivationKeysResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// HCX activation key. A default key is created during
// private cloud provisioning, but this behavior is subject to change
// and you should always verify active keys.
// Use [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys] to retrieve existing keys
// and [VmwareEngine.CreateHcxActivationKey][google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey] to create new ones.
type HcxActivationKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this HcxActivationKey.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1/privateClouds/my-cloud/hcxActivationKeys/my-key`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of HCX activation key.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. State of HCX activation key.
	State HcxActivationKey_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.HcxActivationKey_State" json:"state,omitempty"`
	// Output only. HCX activation key.
	ActivationKey string `protobuf:"bytes,4,opt,name=activation_key,json=activationKey,proto3" json:"activation_key,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,5,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *HcxActivationKey) Reset() {
	*x = HcxActivationKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HcxActivationKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HcxActivationKey) ProtoMessage() {}

func (x *HcxActivationKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HcxActivationKey.ProtoReflect.Descriptor instead.
func (*HcxActivationKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{31}
}

func (x *HcxActivationKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HcxActivationKey) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *HcxActivationKey) GetState() HcxActivationKey_State {
	if x != nil {
		return x.State
	}
	return HcxActivationKey_STATE_UNSPECIFIED
}

func (x *HcxActivationKey) GetActivationKey() string {
	if x != nil {
		return x.ActivationKey
	}
	return ""
}

func (x *HcxActivationKey) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// Request message for [VmwareEngine.ListHcxActivationKeys][google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys]
type ListHcxActivationKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud
	// to be queried for HCX activation keys.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of HCX activation keys to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListHcxActivationKeys` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListHcxActivationKeys` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListHcxActivationKeysRequest) Reset() {
	*x = ListHcxActivationKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListHcxActivationKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHcxActivationKeysRequest) ProtoMessage() {}

func (x *ListHcxActivationKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHcxActivationKeysRequest.ProtoReflect.Descriptor instead.
func (*ListHcxActivationKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{32}
}

func (x *ListHcxActivationKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHcxActivationKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHcxActivationKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for [VmwareEngine.GetHcxActivationKeys][]
type GetHcxActivationKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the HCX activation key to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-west1/privateClouds/my-cloud/hcxActivationKeys/my-key`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHcxActivationKeyRequest) Reset() {
	*x = GetHcxActivationKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetHcxActivationKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHcxActivationKeyRequest) ProtoMessage() {}

func (x *GetHcxActivationKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHcxActivationKeyRequest.ProtoReflect.Descriptor instead.
func (*GetHcxActivationKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{33}
}

func (x *GetHcxActivationKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [VmwareEngine.CreateHcxActivationKey][google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey]
type CreateHcxActivationKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the private cloud to create the key for.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/privateClouds/my-cloud`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The initial description of a new HCX activation key. When
	// creating a new key, this field must be an empty object.
	HcxActivationKey *HcxActivationKey `protobuf:"bytes,2,opt,name=hcx_activation_key,json=hcxActivationKey,proto3" json:"hcx_activation_key,omitempty"`
	// Required. The user-provided identifier of the `HcxActivationKey` to be
	// created. This identifier must be unique among `HcxActivationKey` resources
	// within the parent and becomes the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	HcxActivationKeyId string `protobuf:"bytes,3,opt,name=hcx_activation_key_id,json=hcxActivationKeyId,proto3" json:"hcx_activation_key_id,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateHcxActivationKeyRequest) Reset() {
	*x = CreateHcxActivationKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateHcxActivationKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHcxActivationKeyRequest) ProtoMessage() {}

func (x *CreateHcxActivationKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHcxActivationKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateHcxActivationKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{34}
}

func (x *CreateHcxActivationKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateHcxActivationKeyRequest) GetHcxActivationKey() *HcxActivationKey {
	if x != nil {
		return x.HcxActivationKey
	}
	return nil
}

func (x *CreateHcxActivationKeyRequest) GetHcxActivationKeyId() string {
	if x != nil {
		return x.HcxActivationKeyId
	}
	return ""
}

func (x *CreateHcxActivationKeyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Details about a HCX Cloud Manager appliance.
type Hcx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Hcx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Hcx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Hcx) Reset() {
	*x = Hcx{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Hcx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Hcx) ProtoMessage() {}

func (x *Hcx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Hcx.ProtoReflect.Descriptor instead.
func (*Hcx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{35}
}

func (x *Hcx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Hcx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Hcx) GetState() Hcx_State {
	if x != nil {
		return x.State
	}
	return Hcx_STATE_UNSPECIFIED
}

func (x *Hcx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a NSX Manager appliance.
type Nsx struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Nsx_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Nsx_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Nsx) Reset() {
	*x = Nsx{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Nsx) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Nsx) ProtoMessage() {}

func (x *Nsx) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Nsx.ProtoReflect.Descriptor instead.
func (*Nsx) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{36}
}

func (x *Nsx) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Nsx) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Nsx) GetState() Nsx_State {
	if x != nil {
		return x.State
	}
	return Nsx_STATE_UNSPECIFIED
}

func (x *Nsx) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Details about a vCenter Server management appliance.
type Vcenter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Internal IP address of the appliance.
	InternalIp string `protobuf:"bytes,2,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Version of the appliance.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of the appliance.
	State Vcenter_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.Vcenter_State" json:"state,omitempty"`
	// Fully qualified domain name of the appliance.
	Fqdn string `protobuf:"bytes,6,opt,name=fqdn,proto3" json:"fqdn,omitempty"`
}

func (x *Vcenter) Reset() {
	*x = Vcenter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Vcenter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Vcenter) ProtoMessage() {}

func (x *Vcenter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Vcenter.ProtoReflect.Descriptor instead.
func (*Vcenter) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{37}
}

func (x *Vcenter) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *Vcenter) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Vcenter) GetState() Vcenter_State {
	if x != nil {
		return x.State
	}
	return Vcenter_STATE_UNSPECIFIED
}

func (x *Vcenter) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

// Represents a network policy resource. Network policies are regional
// resources. You can use a network policy to enable or disable internet access
// and external IP access. Network policies are associated with a VMware Engine
// network, which might span across regions. For a given region, a network
// policy applies to all private clouds in the VMware Engine network associated
// with the policy.
type NetworkPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of this network policy.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Network service that allows VMware workloads to access the internet.
	InternetAccess *NetworkPolicy_NetworkService `protobuf:"bytes,6,opt,name=internet_access,json=internetAccess,proto3" json:"internet_access,omitempty"`
	// Network service that allows External IP addresses to be assigned to VMware
	// workloads. This service can only be enabled when `internet_access` is also
	// enabled.
	ExternalIp *NetworkPolicy_NetworkService `protobuf:"bytes,7,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Required. IP address range in CIDR notation used to create internet access
	// and external IP access. An RFC 1918 CIDR block, with a "/26" prefix, is
	// required. The range cannot overlap with any prefixes either in the consumer
	// VPC network or in use by the private clouds attached to that VPC network.
	EdgeServicesCidr string `protobuf:"bytes,9,opt,name=edge_services_cidr,json=edgeServicesCidr,proto3" json:"edge_services_cidr,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,10,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The relative resource name of the VMware Engine network.
	// Specify the name in the following form:
	// `projects/{project}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	// where `{project}` can either be a project number or a project ID.
	VmwareEngineNetwork string `protobuf:"bytes,12,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. User-provided description for this network policy.
	Description string `protobuf:"bytes,13,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The canonical name of the VMware Engine network in the form:
	// `projects/{project_number}/locations/{location}/vmwareEngineNetworks/{vmware_engine_network_id}`
	VmwareEngineNetworkCanonical string `protobuf:"bytes,14,opt,name=vmware_engine_network_canonical,json=vmwareEngineNetworkCanonical,proto3" json:"vmware_engine_network_canonical,omitempty"`
}

func (x *NetworkPolicy) Reset() {
	*x = NetworkPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy) ProtoMessage() {}

func (x *NetworkPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy.ProtoReflect.Descriptor instead.
func (*NetworkPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{38}
}

func (x *NetworkPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NetworkPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NetworkPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NetworkPolicy) GetInternetAccess() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.InternetAccess
	}
	return nil
}

func (x *NetworkPolicy) GetExternalIp() *NetworkPolicy_NetworkService {
	if x != nil {
		return x.ExternalIp
	}
	return nil
}

func (x *NetworkPolicy) GetEdgeServicesCidr() string {
	if x != nil {
		return x.EdgeServicesCidr
	}
	return ""
}

func (x *NetworkPolicy) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetwork() string {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return ""
}

func (x *NetworkPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *NetworkPolicy) GetVmwareEngineNetworkCanonical() string {
	if x != nil {
		return x.VmwareEngineNetworkCanonical
	}
	return ""
}

// Request message for [VmwareEngine.ListNetworkPolicies][google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies]
type ListNetworkPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location (region) to query for
	// network policies. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names. For
	// example: `projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of network policies to return in one page.
	// The service may return fewer than this value.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListNetworkPolicies` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListNetworkPolicies` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of network policies, you can
	// exclude the ones named `example-policy` by specifying
	// `name != "example-policy"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-policy")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "example-policy-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-policy-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results
	// are ordered by `name` in ascending order.
	// You can also sort results in descending order based on the `name` value
	// using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListNetworkPoliciesRequest) Reset() {
	*x = ListNetworkPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkPoliciesRequest) ProtoMessage() {}

func (x *ListNetworkPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListNetworkPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{39}
}

func (x *ListNetworkPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNetworkPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListNetworkPoliciesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [VmwareEngine.ListNetworkPolicies][google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies]
type ListNetworkPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of network policies.
	NetworkPolicies []*NetworkPolicy `protobuf:"bytes,1,rep,name=network_policies,json=networkPolicies,proto3" json:"network_policies,omitempty"`
	// A token, which can be send as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached when making an aggregated query using
	// wildcards.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListNetworkPoliciesResponse) Reset() {
	*x = ListNetworkPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworkPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworkPoliciesResponse) ProtoMessage() {}

func (x *ListNetworkPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworkPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListNetworkPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{40}
}

func (x *ListNetworkPoliciesResponse) GetNetworkPolicies() []*NetworkPolicy {
	if x != nil {
		return x.NetworkPolicies
	}
	return nil
}

func (x *ListNetworkPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListNetworkPoliciesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [VmwareEngine.GetNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy]
type GetNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the network policy to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNetworkPolicyRequest) Reset() {
	*x = GetNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNetworkPolicyRequest) ProtoMessage() {}

func (x *GetNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{41}
}

func (x *GetNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [VmwareEngine.UpdateNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy]
type UpdateNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Network policy description.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,1,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// `NetworkPolicy` resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateNetworkPolicyRequest) Reset() {
	*x = UpdateNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateNetworkPolicyRequest) ProtoMessage() {}

func (x *UpdateNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{42}
}

func (x *UpdateNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *UpdateNetworkPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.CreateNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy]
type CreateNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location (region)
	// to create the new network policy in.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	//
	//	`projects/my-project/locations/us-central1`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the network policy to be created.
	// This identifier must be unique within parent
	// `projects/{my-project}/locations/{us-central1}/networkPolicies` and becomes
	// the final token in the name URI.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	NetworkPolicyId string `protobuf:"bytes,2,opt,name=network_policy_id,json=networkPolicyId,proto3" json:"network_policy_id,omitempty"`
	// Required. The network policy configuration to use in the request.
	NetworkPolicy *NetworkPolicy `protobuf:"bytes,3,opt,name=network_policy,json=networkPolicy,proto3" json:"network_policy,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateNetworkPolicyRequest) Reset() {
	*x = CreateNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateNetworkPolicyRequest) ProtoMessage() {}

func (x *CreateNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{43}
}

func (x *CreateNetworkPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateNetworkPolicyRequest) GetNetworkPolicyId() string {
	if x != nil {
		return x.NetworkPolicyId
	}
	return ""
}

func (x *CreateNetworkPolicyRequest) GetNetworkPolicy() *NetworkPolicy {
	if x != nil {
		return x.NetworkPolicy
	}
	return nil
}

func (x *CreateNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.DeleteNetworkPolicy][google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy]
type DeleteNetworkPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the network policy to delete.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/us-central1/networkPolicies/my-network-policy`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteNetworkPolicyRequest) Reset() {
	*x = DeleteNetworkPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteNetworkPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteNetworkPolicyRequest) ProtoMessage() {}

func (x *DeleteNetworkPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteNetworkPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteNetworkPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{44}
}

func (x *DeleteNetworkPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteNetworkPolicyRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// VMware Engine network resource that provides connectivity for VMware Engine
// private clouds.
type VmwareEngineNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the VMware Engine network.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation time of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last update time of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description for this VMware Engine network.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. VMware Engine service VPC networks that provide connectivity
	// from a private cloud to customer projects, the internet, and other Google
	// Cloud services.
	VpcNetworks []*VmwareEngineNetwork_VpcNetwork `protobuf:"bytes,6,rep,name=vpc_networks,json=vpcNetworks,proto3" json:"vpc_networks,omitempty"`
	// Output only. State of the VMware Engine network.
	State VmwareEngineNetwork_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_State" json:"state,omitempty"`
	// Required. VMware Engine network type.
	Type VmwareEngineNetwork_Type `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_Type" json:"type,omitempty"`
	// Output only. System-generated unique identifier for the resource.
	Uid string `protobuf:"bytes,9,opt,name=uid,proto3" json:"uid,omitempty"`
	// Checksum that may be sent on update and delete requests to ensure that the
	// user-provided value is up to date before the server processes a request.
	// The server computes checksums based on the value of other fields in the
	// request.
	Etag string `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *VmwareEngineNetwork) Reset() {
	*x = VmwareEngineNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareEngineNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45}
}

func (x *VmwareEngineNetwork) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VmwareEngineNetwork) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *VmwareEngineNetwork) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VmwareEngineNetwork) GetVpcNetworks() []*VmwareEngineNetwork_VpcNetwork {
	if x != nil {
		return x.VpcNetworks
	}
	return nil
}

func (x *VmwareEngineNetwork) GetState() VmwareEngineNetwork_State {
	if x != nil {
		return x.State
	}
	return VmwareEngineNetwork_STATE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetType() VmwareEngineNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *VmwareEngineNetwork) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for [VmwareEngine.CreateVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork]
type CreateVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to create the new VMware Engine
	// network in. A VMware Engine network of type
	// `LEGACY` is a regional resource, and a VMware
	// Engine network of type `STANDARD` is a global resource.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names. For example:
	// `projects/my-project/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-provided identifier of the new VMware Engine network.
	// This identifier must be unique among VMware Engine network resources
	// within the parent and becomes the final token in the name URI. The
	// identifier must meet the following requirements:
	//
	// * For networks of type LEGACY, adheres to the format:
	// `{region-id}-default`. Replace `{region-id}` with the region where you want
	// to create the VMware Engine network. For example, "us-west1-default".
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC 1034](https://datatracker.ietf.org/doc/html/rfc1034)
	// (section 3.5)
	VmwareEngineNetworkId string `protobuf:"bytes,2,opt,name=vmware_engine_network_id,json=vmwareEngineNetworkId,proto3" json:"vmware_engine_network_id,omitempty"`
	// Required. The initial description of the new VMware Engine network.
	VmwareEngineNetwork *VmwareEngineNetwork `protobuf:"bytes,3,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateVmwareEngineNetworkRequest) Reset() {
	*x = CreateVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *CreateVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*CreateVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{46}
}

func (x *CreateVmwareEngineNetworkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVmwareEngineNetworkRequest) GetVmwareEngineNetworkId() string {
	if x != nil {
		return x.VmwareEngineNetworkId
	}
	return ""
}

func (x *CreateVmwareEngineNetworkRequest) GetVmwareEngineNetwork() *VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return nil
}

func (x *CreateVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.UpdateVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork]
type UpdateVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. VMware Engine network description.
	VmwareEngineNetwork *VmwareEngineNetwork `protobuf:"bytes,1,opt,name=vmware_engine_network,json=vmwareEngineNetwork,proto3" json:"vmware_engine_network,omitempty"`
	// Required. Field mask is used to specify the fields to be overwritten in the
	// VMware Engine network resource by the update.
	// The fields specified in the `update_mask` are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten. Only the
	// following fields can be updated: `description`.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateVmwareEngineNetworkRequest) Reset() {
	*x = UpdateVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *UpdateVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*UpdateVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{47}
}

func (x *UpdateVmwareEngineNetworkRequest) GetVmwareEngineNetwork() *VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetwork
	}
	return nil
}

func (x *UpdateVmwareEngineNetworkRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [VmwareEngine.DeleteVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork]
type DeleteVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VMware Engine network to be deleted.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server guarantees that a
	// request doesn't result in creation of duplicate commitments for at least 60
	// minutes.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Checksum used to ensure that the user-provided value is up to date before
	// the server processes the request. The server compares provided checksum
	// with the current checksum of the resource. If the user-provided value is
	// out of date, this request returns an `ABORTED` error.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteVmwareEngineNetworkRequest) Reset() {
	*x = DeleteVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *DeleteVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*DeleteVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{48}
}

func (x *DeleteVmwareEngineNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteVmwareEngineNetworkRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteVmwareEngineNetworkRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for [VmwareEngine.GetVmwareEngineNetwork][google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork]
type GetVmwareEngineNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the VMware Engine network to retrieve.
	// Resource names are schemeless URIs that follow the conventions in
	// https://cloud.google.com/apis/design/resource_names.
	// For example:
	// `projects/my-project/locations/global/vmwareEngineNetworks/my-network`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVmwareEngineNetworkRequest) Reset() {
	*x = GetVmwareEngineNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVmwareEngineNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVmwareEngineNetworkRequest) ProtoMessage() {}

func (x *GetVmwareEngineNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVmwareEngineNetworkRequest.ProtoReflect.Descriptor instead.
func (*GetVmwareEngineNetworkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{49}
}

func (x *GetVmwareEngineNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [VmwareEngine.ListVmwareEngineNetworks][google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks]
type ListVmwareEngineNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the location to query for
	// VMware Engine networks. Resource names are schemeless URIs that follow the
	// conventions in https://cloud.google.com/apis/design/resource_names. For
	// example: `projects/my-project/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return in one page.
	// The maximum value is coerced to 1000.
	// The default value of this field is 500.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListVmwareEngineNetworks` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListVmwareEngineNetworks` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that matches resources returned in the response.
	// The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value
	// must be a string, a number, or a boolean. The comparison operator
	// must be `=`, `!=`, `>`, or `<`.
	//
	// For example, if you are filtering a list of network peerings, you can
	// exclude the ones named `example-network` by specifying
	// `name != "example-network"`.
	//
	// To filter on multiple expressions, provide each separate expression within
	// parentheses. For example:
	// ```
	// (name = "example-network")
	// (createTime > "2021-04-12T08:15:10.40Z")
	// ```
	//
	// By default, each expression is an `AND` expression. However, you
	// can include `AND` and `OR` expressions explicitly.
	// For example:
	// ```
	// (name = "example-network-1") AND
	// (createTime > "2021-04-12T08:15:10.40Z") OR
	// (name = "example-network-2")
	// ```
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sorts list results by a certain order. By default, returned results
	// are ordered by `name` in ascending order.
	// You can also sort results in descending order based on the `name` value
	// using `orderBy="name desc"`.
	// Currently, only ordering by `name` is supported.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListVmwareEngineNetworksRequest) Reset() {
	*x = ListVmwareEngineNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVmwareEngineNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVmwareEngineNetworksRequest) ProtoMessage() {}

func (x *ListVmwareEngineNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVmwareEngineNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListVmwareEngineNetworksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{50}
}

func (x *ListVmwareEngineNetworksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVmwareEngineNetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVmwareEngineNetworksRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [VmwareEngine.ListVmwareEngineNetworks][google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks]
type ListVmwareEngineNetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of VMware Engine networks.
	VmwareEngineNetworks []*VmwareEngineNetwork `protobuf:"bytes,1,rep,name=vmware_engine_networks,json=vmwareEngineNetworks,proto3" json:"vmware_engine_networks,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListVmwareEngineNetworksResponse) Reset() {
	*x = ListVmwareEngineNetworksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVmwareEngineNetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVmwareEngineNetworksResponse) ProtoMessage() {}

func (x *ListVmwareEngineNetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVmwareEngineNetworksResponse.ProtoReflect.Descriptor instead.
func (*ListVmwareEngineNetworksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{51}
}

func (x *ListVmwareEngineNetworksResponse) GetVmwareEngineNetworks() []*VmwareEngineNetwork {
	if x != nil {
		return x.VmwareEngineNetworks
	}
	return nil
}

func (x *ListVmwareEngineNetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListVmwareEngineNetworksResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Management cluster configuration.
type PrivateCloud_ManagementCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user-provided identifier of the new `Cluster`.
	// The identifier must meet the following requirements:
	//
	// * Only contains 1-63 alphanumeric characters and hyphens
	// * Begins with an alphabetical character
	// * Ends with a non-hyphen character
	// * Not formatted as a UUID
	// * Complies with [RFC
	// 1034](https://datatracker.ietf.org/doc/html/rfc1034) (section 3.5)
	ClusterId string `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The map of cluster node types in this cluster, where the key is canonical
	// identifier of the node type (corresponds to the `NodeType`).
	NodeTypeConfigs map[string]*NodeTypeConfig `protobuf:"bytes,7,rep,name=node_type_configs,json=nodeTypeConfigs,proto3" json:"node_type_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PrivateCloud_ManagementCluster) Reset() {
	*x = PrivateCloud_ManagementCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrivateCloud_ManagementCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateCloud_ManagementCluster) ProtoMessage() {}

func (x *PrivateCloud_ManagementCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateCloud_ManagementCluster.ProtoReflect.Descriptor instead.
func (*PrivateCloud_ManagementCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{2, 0}
}

func (x *PrivateCloud_ManagementCluster) GetClusterId() string {
	if x != nil {
		return x.ClusterId
	}
	return ""
}

func (x *PrivateCloud_ManagementCluster) GetNodeTypeConfigs() map[string]*NodeTypeConfig {
	if x != nil {
		return x.NodeTypeConfigs
	}
	return nil
}

// Represents a network service that is managed by a `NetworkPolicy` resource.
// A network service provides a way to control an aspect of external access to
// VMware workloads. For example, whether the VMware workloads in the
// private clouds governed by a network policy can access or be accessed from
// the internet.
type NetworkPolicy_NetworkService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the service is enabled; false otherwise.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Output only. State of the service. New values may be added to this enum
	// when appropriate.
	State NetworkPolicy_NetworkService_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.vmwareengine.v1.NetworkPolicy_NetworkService_State" json:"state,omitempty"`
}

func (x *NetworkPolicy_NetworkService) Reset() {
	*x = NetworkPolicy_NetworkService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkPolicy_NetworkService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkPolicy_NetworkService) ProtoMessage() {}

func (x *NetworkPolicy_NetworkService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkPolicy_NetworkService.ProtoReflect.Descriptor instead.
func (*NetworkPolicy_NetworkService) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{38, 0}
}

func (x *NetworkPolicy_NetworkService) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *NetworkPolicy_NetworkService) GetState() NetworkPolicy_NetworkService_State {
	if x != nil {
		return x.State
	}
	return NetworkPolicy_NetworkService_STATE_UNSPECIFIED
}

// Represents a VMware Engine VPC network that is managed by a
// VMware Engine network resource.
type VmwareEngineNetwork_VpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Type of VPC network (INTRANET, INTERNET, or
	// GOOGLE_CLOUD)
	Type VmwareEngineNetwork_VpcNetwork_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vmwareengine.v1.VmwareEngineNetwork_VpcNetwork_Type" json:"type,omitempty"`
	// Output only. The relative resource name of the service VPC network this
	// VMware Engine network is attached to. For example:
	// `projects/123123/global/networks/my-network`
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *VmwareEngineNetwork_VpcNetwork) Reset() {
	*x = VmwareEngineNetwork_VpcNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmwareEngineNetwork_VpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareEngineNetwork_VpcNetwork) ProtoMessage() {}

func (x *VmwareEngineNetwork_VpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareEngineNetwork_VpcNetwork.ProtoReflect.Descriptor instead.
func (*VmwareEngineNetwork_VpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP(), []int{45, 0}
}

func (x *VmwareEngineNetwork_VpcNetwork) GetType() VmwareEngineNetwork_VpcNetwork_Type {
	if x != nil {
		return x.Type
	}
	return VmwareEngineNetwork_VpcNetwork_TYPE_UNSPECIFIED
}

func (x *VmwareEngineNetwork_VpcNetwork) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

var File_google_cloud_vmwareengine_v1_vmwareengine_proto protoreflect.FileDescriptor

var file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x02, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x69, 0x64, 0x72, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61,
	0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x53, 0x0a, 0x24, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x0e,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22,
	0x0a, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x22, 0xcf, 0x0a, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x12, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x11, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x38, 0x0a, 0x03, 0x68, 0x63, 0x78, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x68, 0x63, 0x78, 0x12, 0x38, 0x0a, 0x03, 0x6e, 0x73, 0x78,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x6e, 0x73, 0x78, 0x12, 0x44, 0x0a, 0x07, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x1a, 0xae, 0x02, 0x0a, 0x11, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x11, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a,
	0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x6c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x55, 0x52, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x3a,
	0x74, 0xea, 0x41, 0x71, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x45,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x22, 0xcc, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xb8, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x5e, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb1, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x2d, 0x0a, 0x10, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x49, 0x64, 0x12,
	0x54, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0xd7, 0x01, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x54, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xdb, 0x01,
	0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x12, 0x29, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x65,
	0x6c, 0x61, 0x79, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x88, 0x01, 0x01, 0x42, 0x0e, 0x0a, 0x0c, 0x5f,
	0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x22, 0x87, 0x01, 0x0a, 0x1b,
	0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xf3, 0x05, 0x0a, 0x07, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x6b, 0x0a, 0x11, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f,
	0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a,
	0x70, 0x0a, 0x14, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x63, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x50, 0x41, 0x49,
	0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x23, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x7d, 0x22, 0xce, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa3, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x08,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x54, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x98, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12,
	0x44, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0xec, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x44,
	0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0x7b, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x9b, 0x03, 0x0a, 0x06, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x69, 0x70, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x70, 0x43, 0x69,
	0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02,
	0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c,
	0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x7f, 0xea, 0x41,
	0x7c, 0x0a, 0x22, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x7d, 0x22, 0x9a, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7d, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x3e, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65,
	0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61,
	0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0xcb, 0x03, 0x0a, 0x08, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0c, 0x6e, 0x6f, 0x64, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61,
	0x6c, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x43,
	0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x72,
	0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x67, 0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x47, 0x62, 0x12, 0x25, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12,
	0x44, 0x0a, 0x1c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x61, 0x76, 0x61, 0x69,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x73, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x24, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x22,
	0xad, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0xa8, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x56, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x45, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x72, 0x0a, 0x19, 0x53, 0x68, 0x6f,
	0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52,
	0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x22, 0x76, 0x0a,
	0x1d, 0x53, 0x68, 0x6f, 0x77, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55,
	0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e,
	0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x9b, 0x01, 0x0a, 0x1e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x0c, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc9, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5e, 0x0a, 0x13, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x11, 0x68, 0x63,
	0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xef, 0x03, 0x0a, 0x10, 0x48, 0x63,
	0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x22, 0x49, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x41, 0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x4f, 0x4e, 0x53, 0x55, 0x4d, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x3a, 0xa0, 0x01, 0xea, 0x41, 0x9c, 0x01, 0x0a,
	0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x63, 0x78,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x6c, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x7d, 0x22, 0xa4, 0x01, 0x0a, 0x1c,
	0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x66, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa3, 0x02, 0x0a, 0x1d, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x12, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b,
	0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x36, 0x0a, 0x15, 0x68, 0x63, 0x78,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x68,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x49,
	0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xd2, 0x01, 0x0a, 0x03, 0x48, 0x63, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x63, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xd2, 0x01, 0x0a, 0x03, 0x4e, 0x73, 0x78, 0x12, 0x1f, 0x0a,
	0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x73, 0x78, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x66, 0x71, 0x64, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e,
	0x22, 0x38, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xda, 0x01, 0x0a, 0x07, 0x56,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x71, 0x64,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64, 0x6e, 0x22, 0x38, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0xa0, 0x08, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x63, 0x0a, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x65, 0x74, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x5b, 0x0a, 0x0b, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0a, 0x65, 0x78,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x31, 0x0a, 0x12, 0x65, 0x64, 0x67, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x69, 0x64, 0x72, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x65, 0x64, 0x67, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x43, 0x69, 0x64, 0x72, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x6b, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x37, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e, 0x0a, 0x1f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f,
	0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x1c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x61, 0x6e,
	0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x1a, 0xd7, 0x01, 0x0a, 0x0e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x22, 0x4e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03,
	0x3a, 0x78, 0xea, 0x41, 0x75, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x48, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x22, 0xd6, 0x01, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x12, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x56, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x60, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x95, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x2f, 0x0a, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64,
	0x12, 0x57, 0x0a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x87, 0x01,
	0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x91, 0x08, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64,
	0x0a, 0x0c, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x1a, 0xf6, 0x01, 0x0a, 0x0a, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x5a, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x22, 0x4a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x54, 0x52, 0x41, 0x4e, 0x45, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x45, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x47,
	0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x10, 0x03, 0x22, 0x54, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x22, 0x28, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x10, 0x01, 0x3a, 0x8b, 0x01,
	0xea, 0x41, 0x87, 0x01, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x22, 0xc1, 0x02, 0x0a, 0x20,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x12, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x3c, 0x0a, 0x18, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x64, 0x12,
	0x6a, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xf4, 0x01, 0x0a, 0x20, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x6a, 0x0a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xac, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x31, 0x0a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x6c, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd3, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd5, 0x01, 0x0a, 0x20, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x67,
	0x0a, 0x16, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x14, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x32, 0x96, 0x39, 0x0a, 0x0c, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb5, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x83, 0x02, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73,
	0x3a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0xda,
	0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x85, 0x02, 0x0a, 0x12,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x50, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0xda, 0x41, 0x19, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca,
	0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xd2, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xe2, 0x01, 0x0a, 0x14, 0x55, 0x6e, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x70, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3f, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc4, 0x01,
	0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0xb1, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x4b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xed, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x3a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0xda, 0x41, 0x19,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xef, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x32, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0xda, 0x41, 0x13, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x1c, 0x0a, 0x07,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xdc, 0x01, 0x0a, 0x0d, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x78, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xc0, 0x01, 0x0a, 0x0b, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x6e,
	0x65, 0x74, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xb8, 0x01, 0x0a,
	0x0d, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12,
	0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa5, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4e,
	0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x6f, 0x64, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0xdf, 0x01, 0x0a, 0x12, 0x53, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x4f, 0x12, 0x4d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x68, 0x6f, 0x77, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x12, 0xeb, 0x01, 0x0a, 0x16, 0x53, 0x68, 0x6f, 0x77, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x6f, 0x77,
	0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x22, 0x69, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x12, 0x51, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x68, 0x6f, 0x77, 0x56, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0xda,
	0x41, 0x0d, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x12,
	0xfe, 0x01, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8d, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x4e, 0x73, 0x78, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x70,
	0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0xca, 0x41, 0x21, 0x0a,
	0x0c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x8a, 0x02, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x65, 0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x65,
	0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x57, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72,
	0x65, 0x73, 0x65, 0x74, 0x56, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x0d, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x5f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x50, 0x72,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb2, 0x02,
	0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x63,
	0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbb, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x22, 0x45, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0x3a, 0x12, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x68, 0x63, 0x78, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x48,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0xe8, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x63, 0x78, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd5, 0x01,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x48, 0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x63, 0x78, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22,
	0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x2f, 0x2a, 0x2f, 0x68, 0x63, 0x78, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xba, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x42,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xd0, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x8b, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x3a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0xca, 0x41,
	0x22, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x8d, 0x02, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9c, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x32, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x0e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0xda, 0x41, 0x1a, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41,
	0x22, 0x0a, 0x0d, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0xdf, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xb7, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xba, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x22, 0x38, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x3a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0xda, 0x41, 0x35, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2c, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xb9, 0x02, 0x0a, 0x19, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x67, 0x32, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x15, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0xda, 0x41, 0x21, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0xca, 0x41, 0x28, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xf0, 0x01, 0x0a, 0x19,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a,
	0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd1,
	0x01, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xe4, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x1a, 0x4f, 0xca, 0x41, 0x1b, 0x76, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb2, 0x02, 0x0a, 0x20, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42,
	0x11, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x3b, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0xaa, 0x02,
	0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1c,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1f, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0xea, 0x41,
	0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescOnce sync.Once
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData = file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc
)

func file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescGZIP() []byte {
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData)
	})
	return file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDescData
}

var file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes = make([]protoimpl.MessageInfo, 57)
var file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes = []interface{}{
	(PrivateCloud_State)(0),                  // 0: google.cloud.vmwareengine.v1.PrivateCloud.State
	(Cluster_State)(0),                       // 1: google.cloud.vmwareengine.v1.Cluster.State
	(Subnet_State)(0),                        // 2: google.cloud.vmwareengine.v1.Subnet.State
	(HcxActivationKey_State)(0),              // 3: google.cloud.vmwareengine.v1.HcxActivationKey.State
	(Hcx_State)(0),                           // 4: google.cloud.vmwareengine.v1.Hcx.State
	(Nsx_State)(0),                           // 5: google.cloud.vmwareengine.v1.Nsx.State
	(Vcenter_State)(0),                       // 6: google.cloud.vmwareengine.v1.Vcenter.State
	(NetworkPolicy_NetworkService_State)(0),  // 7: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	(VmwareEngineNetwork_State)(0),           // 8: google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	(VmwareEngineNetwork_Type)(0),            // 9: google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	(VmwareEngineNetwork_VpcNetwork_Type)(0), // 10: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	(*NetworkConfig)(nil),                    // 11: google.cloud.vmwareengine.v1.NetworkConfig
	(*NodeTypeConfig)(nil),                   // 12: google.cloud.vmwareengine.v1.NodeTypeConfig
	(*PrivateCloud)(nil),                     // 13: google.cloud.vmwareengine.v1.PrivateCloud
	(*ListPrivateCloudsRequest)(nil),         // 14: google.cloud.vmwareengine.v1.ListPrivateCloudsRequest
	(*ListPrivateCloudsResponse)(nil),        // 15: google.cloud.vmwareengine.v1.ListPrivateCloudsResponse
	(*GetPrivateCloudRequest)(nil),           // 16: google.cloud.vmwareengine.v1.GetPrivateCloudRequest
	(*CreatePrivateCloudRequest)(nil),        // 17: google.cloud.vmwareengine.v1.CreatePrivateCloudRequest
	(*UpdatePrivateCloudRequest)(nil),        // 18: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest
	(*DeletePrivateCloudRequest)(nil),        // 19: google.cloud.vmwareengine.v1.DeletePrivateCloudRequest
	(*UndeletePrivateCloudRequest)(nil),      // 20: google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest
	(*Cluster)(nil),                          // 21: google.cloud.vmwareengine.v1.Cluster
	(*ListClustersRequest)(nil),              // 22: google.cloud.vmwareengine.v1.ListClustersRequest
	(*ListClustersResponse)(nil),             // 23: google.cloud.vmwareengine.v1.ListClustersResponse
	(*GetClusterRequest)(nil),                // 24: google.cloud.vmwareengine.v1.GetClusterRequest
	(*CreateClusterRequest)(nil),             // 25: google.cloud.vmwareengine.v1.CreateClusterRequest
	(*UpdateClusterRequest)(nil),             // 26: google.cloud.vmwareengine.v1.UpdateClusterRequest
	(*DeleteClusterRequest)(nil),             // 27: google.cloud.vmwareengine.v1.DeleteClusterRequest
	(*Subnet)(nil),                           // 28: google.cloud.vmwareengine.v1.Subnet
	(*ListSubnetsRequest)(nil),               // 29: google.cloud.vmwareengine.v1.ListSubnetsRequest
	(*ListSubnetsResponse)(nil),              // 30: google.cloud.vmwareengine.v1.ListSubnetsResponse
	(*OperationMetadata)(nil),                // 31: google.cloud.vmwareengine.v1.OperationMetadata
	(*NodeType)(nil),                         // 32: google.cloud.vmwareengine.v1.NodeType
	(*ListNodeTypesRequest)(nil),             // 33: google.cloud.vmwareengine.v1.ListNodeTypesRequest
	(*ListNodeTypesResponse)(nil),            // 34: google.cloud.vmwareengine.v1.ListNodeTypesResponse
	(*GetNodeTypeRequest)(nil),               // 35: google.cloud.vmwareengine.v1.GetNodeTypeRequest
	(*Credentials)(nil),                      // 36: google.cloud.vmwareengine.v1.Credentials
	(*ShowNsxCredentialsRequest)(nil),        // 37: google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest
	(*ShowVcenterCredentialsRequest)(nil),    // 38: google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest
	(*ResetNsxCredentialsRequest)(nil),       // 39: google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest
	(*ResetVcenterCredentialsRequest)(nil),   // 40: google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest
	(*ListHcxActivationKeysResponse)(nil),    // 41: google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse
	(*HcxActivationKey)(nil),                 // 42: google.cloud.vmwareengine.v1.HcxActivationKey
	(*ListHcxActivationKeysRequest)(nil),     // 43: google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest
	(*GetHcxActivationKeyRequest)(nil),       // 44: google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest
	(*CreateHcxActivationKeyRequest)(nil),    // 45: google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest
	(*Hcx)(nil),                              // 46: google.cloud.vmwareengine.v1.Hcx
	(*Nsx)(nil),                              // 47: google.cloud.vmwareengine.v1.Nsx
	(*Vcenter)(nil),                          // 48: google.cloud.vmwareengine.v1.Vcenter
	(*NetworkPolicy)(nil),                    // 49: google.cloud.vmwareengine.v1.NetworkPolicy
	(*ListNetworkPoliciesRequest)(nil),       // 50: google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest
	(*ListNetworkPoliciesResponse)(nil),      // 51: google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse
	(*GetNetworkPolicyRequest)(nil),          // 52: google.cloud.vmwareengine.v1.GetNetworkPolicyRequest
	(*UpdateNetworkPolicyRequest)(nil),       // 53: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest
	(*CreateNetworkPolicyRequest)(nil),       // 54: google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest
	(*DeleteNetworkPolicyRequest)(nil),       // 55: google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest
	(*VmwareEngineNetwork)(nil),              // 56: google.cloud.vmwareengine.v1.VmwareEngineNetwork
	(*CreateVmwareEngineNetworkRequest)(nil), // 57: google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest
	(*UpdateVmwareEngineNetworkRequest)(nil), // 58: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest
	(*DeleteVmwareEngineNetworkRequest)(nil), // 59: google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest
	(*GetVmwareEngineNetworkRequest)(nil),    // 60: google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest
	(*ListVmwareEngineNetworksRequest)(nil),  // 61: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest
	(*ListVmwareEngineNetworksResponse)(nil), // 62: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse
	(*PrivateCloud_ManagementCluster)(nil),   // 63: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	nil,                                      // 64: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	nil,                                      // 65: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	(*NetworkPolicy_NetworkService)(nil),     // 66: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	(*VmwareEngineNetwork_VpcNetwork)(nil),   // 67: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	(*timestamppb.Timestamp)(nil),            // 68: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 69: google.protobuf.FieldMask
	(*longrunning.Operation)(nil),            // 70: google.longrunning.Operation
}
var file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs = []int32{
	68, // 0: google.cloud.vmwareengine.v1.PrivateCloud.create_time:type_name -> google.protobuf.Timestamp
	68, // 1: google.cloud.vmwareengine.v1.PrivateCloud.update_time:type_name -> google.protobuf.Timestamp
	68, // 2: google.cloud.vmwareengine.v1.PrivateCloud.delete_time:type_name -> google.protobuf.Timestamp
	68, // 3: google.cloud.vmwareengine.v1.PrivateCloud.expire_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.cloud.vmwareengine.v1.PrivateCloud.state:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.State
	11, // 5: google.cloud.vmwareengine.v1.PrivateCloud.network_config:type_name -> google.cloud.vmwareengine.v1.NetworkConfig
	63, // 6: google.cloud.vmwareengine.v1.PrivateCloud.management_cluster:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster
	46, // 7: google.cloud.vmwareengine.v1.PrivateCloud.hcx:type_name -> google.cloud.vmwareengine.v1.Hcx
	47, // 8: google.cloud.vmwareengine.v1.PrivateCloud.nsx:type_name -> google.cloud.vmwareengine.v1.Nsx
	48, // 9: google.cloud.vmwareengine.v1.PrivateCloud.vcenter:type_name -> google.cloud.vmwareengine.v1.Vcenter
	13, // 10: google.cloud.vmwareengine.v1.ListPrivateCloudsResponse.private_clouds:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	13, // 11: google.cloud.vmwareengine.v1.CreatePrivateCloudRequest.private_cloud:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	13, // 12: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest.private_cloud:type_name -> google.cloud.vmwareengine.v1.PrivateCloud
	69, // 13: google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest.update_mask:type_name -> google.protobuf.FieldMask
	68, // 14: google.cloud.vmwareengine.v1.Cluster.create_time:type_name -> google.protobuf.Timestamp
	68, // 15: google.cloud.vmwareengine.v1.Cluster.update_time:type_name -> google.protobuf.Timestamp
	1,  // 16: google.cloud.vmwareengine.v1.Cluster.state:type_name -> google.cloud.vmwareengine.v1.Cluster.State
	65, // 17: google.cloud.vmwareengine.v1.Cluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry
	21, // 18: google.cloud.vmwareengine.v1.ListClustersResponse.clusters:type_name -> google.cloud.vmwareengine.v1.Cluster
	21, // 19: google.cloud.vmwareengine.v1.CreateClusterRequest.cluster:type_name -> google.cloud.vmwareengine.v1.Cluster
	69, // 20: google.cloud.vmwareengine.v1.UpdateClusterRequest.update_mask:type_name -> google.protobuf.FieldMask
	21, // 21: google.cloud.vmwareengine.v1.UpdateClusterRequest.cluster:type_name -> google.cloud.vmwareengine.v1.Cluster
	2,  // 22: google.cloud.vmwareengine.v1.Subnet.state:type_name -> google.cloud.vmwareengine.v1.Subnet.State
	28, // 23: google.cloud.vmwareengine.v1.ListSubnetsResponse.subnets:type_name -> google.cloud.vmwareengine.v1.Subnet
	68, // 24: google.cloud.vmwareengine.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	68, // 25: google.cloud.vmwareengine.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	32, // 26: google.cloud.vmwareengine.v1.ListNodeTypesResponse.node_types:type_name -> google.cloud.vmwareengine.v1.NodeType
	42, // 27: google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse.hcx_activation_keys:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey
	68, // 28: google.cloud.vmwareengine.v1.HcxActivationKey.create_time:type_name -> google.protobuf.Timestamp
	3,  // 29: google.cloud.vmwareengine.v1.HcxActivationKey.state:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey.State
	42, // 30: google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest.hcx_activation_key:type_name -> google.cloud.vmwareengine.v1.HcxActivationKey
	4,  // 31: google.cloud.vmwareengine.v1.Hcx.state:type_name -> google.cloud.vmwareengine.v1.Hcx.State
	5,  // 32: google.cloud.vmwareengine.v1.Nsx.state:type_name -> google.cloud.vmwareengine.v1.Nsx.State
	6,  // 33: google.cloud.vmwareengine.v1.Vcenter.state:type_name -> google.cloud.vmwareengine.v1.Vcenter.State
	68, // 34: google.cloud.vmwareengine.v1.NetworkPolicy.create_time:type_name -> google.protobuf.Timestamp
	68, // 35: google.cloud.vmwareengine.v1.NetworkPolicy.update_time:type_name -> google.protobuf.Timestamp
	66, // 36: google.cloud.vmwareengine.v1.NetworkPolicy.internet_access:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	66, // 37: google.cloud.vmwareengine.v1.NetworkPolicy.external_ip:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService
	49, // 38: google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse.network_policies:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	49, // 39: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest.network_policy:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	69, // 40: google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	49, // 41: google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest.network_policy:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy
	68, // 42: google.cloud.vmwareengine.v1.VmwareEngineNetwork.create_time:type_name -> google.protobuf.Timestamp
	68, // 43: google.cloud.vmwareengine.v1.VmwareEngineNetwork.update_time:type_name -> google.protobuf.Timestamp
	67, // 44: google.cloud.vmwareengine.v1.VmwareEngineNetwork.vpc_networks:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork
	8,  // 45: google.cloud.vmwareengine.v1.VmwareEngineNetwork.state:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.State
	9,  // 46: google.cloud.vmwareengine.v1.VmwareEngineNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.Type
	56, // 47: google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest.vmware_engine_network:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	56, // 48: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest.vmware_engine_network:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	69, // 49: google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest.update_mask:type_name -> google.protobuf.FieldMask
	56, // 50: google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse.vmware_engine_networks:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	64, // 51: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.node_type_configs:type_name -> google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry
	12, // 52: google.cloud.vmwareengine.v1.PrivateCloud.ManagementCluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	12, // 53: google.cloud.vmwareengine.v1.Cluster.NodeTypeConfigsEntry.value:type_name -> google.cloud.vmwareengine.v1.NodeTypeConfig
	7,  // 54: google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.state:type_name -> google.cloud.vmwareengine.v1.NetworkPolicy.NetworkService.State
	10, // 55: google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.type:type_name -> google.cloud.vmwareengine.v1.VmwareEngineNetwork.VpcNetwork.Type
	14, // 56: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds:input_type -> google.cloud.vmwareengine.v1.ListPrivateCloudsRequest
	16, // 57: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud:input_type -> google.cloud.vmwareengine.v1.GetPrivateCloudRequest
	17, // 58: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud:input_type -> google.cloud.vmwareengine.v1.CreatePrivateCloudRequest
	18, // 59: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud:input_type -> google.cloud.vmwareengine.v1.UpdatePrivateCloudRequest
	19, // 60: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud:input_type -> google.cloud.vmwareengine.v1.DeletePrivateCloudRequest
	20, // 61: google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud:input_type -> google.cloud.vmwareengine.v1.UndeletePrivateCloudRequest
	22, // 62: google.cloud.vmwareengine.v1.VmwareEngine.ListClusters:input_type -> google.cloud.vmwareengine.v1.ListClustersRequest
	24, // 63: google.cloud.vmwareengine.v1.VmwareEngine.GetCluster:input_type -> google.cloud.vmwareengine.v1.GetClusterRequest
	25, // 64: google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster:input_type -> google.cloud.vmwareengine.v1.CreateClusterRequest
	26, // 65: google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster:input_type -> google.cloud.vmwareengine.v1.UpdateClusterRequest
	27, // 66: google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster:input_type -> google.cloud.vmwareengine.v1.DeleteClusterRequest
	29, // 67: google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets:input_type -> google.cloud.vmwareengine.v1.ListSubnetsRequest
	33, // 68: google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes:input_type -> google.cloud.vmwareengine.v1.ListNodeTypesRequest
	35, // 69: google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType:input_type -> google.cloud.vmwareengine.v1.GetNodeTypeRequest
	37, // 70: google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials:input_type -> google.cloud.vmwareengine.v1.ShowNsxCredentialsRequest
	38, // 71: google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials:input_type -> google.cloud.vmwareengine.v1.ShowVcenterCredentialsRequest
	39, // 72: google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials:input_type -> google.cloud.vmwareengine.v1.ResetNsxCredentialsRequest
	40, // 73: google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials:input_type -> google.cloud.vmwareengine.v1.ResetVcenterCredentialsRequest
	45, // 74: google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey:input_type -> google.cloud.vmwareengine.v1.CreateHcxActivationKeyRequest
	43, // 75: google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys:input_type -> google.cloud.vmwareengine.v1.ListHcxActivationKeysRequest
	44, // 76: google.cloud.vmwareengine.v1.VmwareEngine.GetHcxActivationKey:input_type -> google.cloud.vmwareengine.v1.GetHcxActivationKeyRequest
	52, // 77: google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.GetNetworkPolicyRequest
	50, // 78: google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies:input_type -> google.cloud.vmwareengine.v1.ListNetworkPoliciesRequest
	54, // 79: google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.CreateNetworkPolicyRequest
	53, // 80: google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.UpdateNetworkPolicyRequest
	55, // 81: google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy:input_type -> google.cloud.vmwareengine.v1.DeleteNetworkPolicyRequest
	57, // 82: google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.CreateVmwareEngineNetworkRequest
	58, // 83: google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.UpdateVmwareEngineNetworkRequest
	59, // 84: google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.DeleteVmwareEngineNetworkRequest
	60, // 85: google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork:input_type -> google.cloud.vmwareengine.v1.GetVmwareEngineNetworkRequest
	61, // 86: google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks:input_type -> google.cloud.vmwareengine.v1.ListVmwareEngineNetworksRequest
	15, // 87: google.cloud.vmwareengine.v1.VmwareEngine.ListPrivateClouds:output_type -> google.cloud.vmwareengine.v1.ListPrivateCloudsResponse
	13, // 88: google.cloud.vmwareengine.v1.VmwareEngine.GetPrivateCloud:output_type -> google.cloud.vmwareengine.v1.PrivateCloud
	70, // 89: google.cloud.vmwareengine.v1.VmwareEngine.CreatePrivateCloud:output_type -> google.longrunning.Operation
	70, // 90: google.cloud.vmwareengine.v1.VmwareEngine.UpdatePrivateCloud:output_type -> google.longrunning.Operation
	70, // 91: google.cloud.vmwareengine.v1.VmwareEngine.DeletePrivateCloud:output_type -> google.longrunning.Operation
	70, // 92: google.cloud.vmwareengine.v1.VmwareEngine.UndeletePrivateCloud:output_type -> google.longrunning.Operation
	23, // 93: google.cloud.vmwareengine.v1.VmwareEngine.ListClusters:output_type -> google.cloud.vmwareengine.v1.ListClustersResponse
	21, // 94: google.cloud.vmwareengine.v1.VmwareEngine.GetCluster:output_type -> google.cloud.vmwareengine.v1.Cluster
	70, // 95: google.cloud.vmwareengine.v1.VmwareEngine.CreateCluster:output_type -> google.longrunning.Operation
	70, // 96: google.cloud.vmwareengine.v1.VmwareEngine.UpdateCluster:output_type -> google.longrunning.Operation
	70, // 97: google.cloud.vmwareengine.v1.VmwareEngine.DeleteCluster:output_type -> google.longrunning.Operation
	30, // 98: google.cloud.vmwareengine.v1.VmwareEngine.ListSubnets:output_type -> google.cloud.vmwareengine.v1.ListSubnetsResponse
	34, // 99: google.cloud.vmwareengine.v1.VmwareEngine.ListNodeTypes:output_type -> google.cloud.vmwareengine.v1.ListNodeTypesResponse
	32, // 100: google.cloud.vmwareengine.v1.VmwareEngine.GetNodeType:output_type -> google.cloud.vmwareengine.v1.NodeType
	36, // 101: google.cloud.vmwareengine.v1.VmwareEngine.ShowNsxCredentials:output_type -> google.cloud.vmwareengine.v1.Credentials
	36, // 102: google.cloud.vmwareengine.v1.VmwareEngine.ShowVcenterCredentials:output_type -> google.cloud.vmwareengine.v1.Credentials
	70, // 103: google.cloud.vmwareengine.v1.VmwareEngine.ResetNsxCredentials:output_type -> google.longrunning.Operation
	70, // 104: google.cloud.vmwareengine.v1.VmwareEngine.ResetVcenterCredentials:output_type -> google.longrunning.Operation
	70, // 105: google.cloud.vmwareengine.v1.VmwareEngine.CreateHcxActivationKey:output_type -> google.longrunning.Operation
	41, // 106: google.cloud.vmwareengine.v1.VmwareEngine.ListHcxActivationKeys:output_type -> google.cloud.vmwareengine.v1.ListHcxActivationKeysResponse
	42, // 107: google.cloud.vmwareengine.v1.VmwareEngine.GetHcxActivationKey:output_type -> google.cloud.vmwareengine.v1.HcxActivationKey
	49, // 108: google.cloud.vmwareengine.v1.VmwareEngine.GetNetworkPolicy:output_type -> google.cloud.vmwareengine.v1.NetworkPolicy
	51, // 109: google.cloud.vmwareengine.v1.VmwareEngine.ListNetworkPolicies:output_type -> google.cloud.vmwareengine.v1.ListNetworkPoliciesResponse
	70, // 110: google.cloud.vmwareengine.v1.VmwareEngine.CreateNetworkPolicy:output_type -> google.longrunning.Operation
	70, // 111: google.cloud.vmwareengine.v1.VmwareEngine.UpdateNetworkPolicy:output_type -> google.longrunning.Operation
	70, // 112: google.cloud.vmwareengine.v1.VmwareEngine.DeleteNetworkPolicy:output_type -> google.longrunning.Operation
	70, // 113: google.cloud.vmwareengine.v1.VmwareEngine.CreateVmwareEngineNetwork:output_type -> google.longrunning.Operation
	70, // 114: google.cloud.vmwareengine.v1.VmwareEngine.UpdateVmwareEngineNetwork:output_type -> google.longrunning.Operation
	70, // 115: google.cloud.vmwareengine.v1.VmwareEngine.DeleteVmwareEngineNetwork:output_type -> google.longrunning.Operation
	56, // 116: google.cloud.vmwareengine.v1.VmwareEngine.GetVmwareEngineNetwork:output_type -> google.cloud.vmwareengine.v1.VmwareEngineNetwork
	62, // 117: google.cloud.vmwareengine.v1.VmwareEngine.ListVmwareEngineNetworks:output_type -> google.cloud.vmwareengine.v1.ListVmwareEngineNetworksResponse
	87, // [87:118] is the sub-list for method output_type
	56, // [56:87] is the sub-list for method input_type
	56, // [56:56] is the sub-list for extension type_name
	56, // [56:56] is the sub-list for extension extendee
	0,  // [0:56] is the sub-list for field type_name
}

func init() { file_google_cloud_vmwareengine_v1_vmwareengine_proto_init() }
func file_google_cloud_vmwareengine_v1_vmwareengine_proto_init() {
	if File_google_cloud_vmwareengine_v1_vmwareengine_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeTypeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateCloud); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateCloudsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPrivateCloudsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeletePrivateCloudRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListClustersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteClusterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subnet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubnetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSubnetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NodeType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodeTypesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNodeTypesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNodeTypeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Credentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowNsxCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ShowVcenterCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetNsxCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResetVcenterCredentialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHcxActivationKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HcxActivationKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListHcxActivationKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetHcxActivationKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateHcxActivationKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Hcx); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Nsx); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Vcenter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworkPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteNetworkPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareEngineNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[49].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVmwareEngineNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[50].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVmwareEngineNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[51].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVmwareEngineNetworksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[52].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrivateCloud_ManagementCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[55].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkPolicy_NetworkService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[56].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmwareEngineNetwork_VpcNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes[8].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   57,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes,
		DependencyIndexes: file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs,
		EnumInfos:         file_google_cloud_vmwareengine_v1_vmwareengine_proto_enumTypes,
		MessageInfos:      file_google_cloud_vmwareengine_v1_vmwareengine_proto_msgTypes,
	}.Build()
	File_google_cloud_vmwareengine_v1_vmwareengine_proto = out.File
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_rawDesc = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_goTypes = nil
	file_google_cloud_vmwareengine_v1_vmwareengine_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VmwareEngineClient is the client API for VmwareEngine service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VmwareEngineClient interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds can only be created in zones, regional private clouds are
	// not supported.
	//
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Modifies a `Cluster` resource. Only the following fields can be updated:
	// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error)
	// Lists node types
	ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error)
}

type vmwareEngineClient struct {
	cc grpc.ClientConnInterface
}

func NewVmwareEngineClient(cc grpc.ClientConnInterface) VmwareEngineClient {
	return &vmwareEngineClient{cc}
}

func (c *vmwareEngineClient) ListPrivateClouds(ctx context.Context, in *ListPrivateCloudsRequest, opts ...grpc.CallOption) (*ListPrivateCloudsResponse, error) {
	out := new(ListPrivateCloudsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateClouds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetPrivateCloud(ctx context.Context, in *GetPrivateCloudRequest, opts ...grpc.CallOption) (*PrivateCloud, error) {
	out := new(PrivateCloud)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreatePrivateCloud(ctx context.Context, in *CreatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdatePrivateCloud(ctx context.Context, in *UpdatePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeletePrivateCloud(ctx context.Context, in *DeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UndeletePrivateCloud(ctx context.Context, in *UndeletePrivateCloudRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UndeletePrivateCloud", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListSubnets(ctx context.Context, in *ListSubnetsRequest, opts ...grpc.CallOption) (*ListSubnetsResponse, error) {
	out := new(ListSubnetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListSubnets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNodeTypes(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*ListNodeTypesResponse, error) {
	out := new(ListNodeTypesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodeTypes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNodeType(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error) {
	out := new(NodeType)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetNodeType", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowNsxCredentials(ctx context.Context, in *ShowNsxCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ShowNsxCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ShowVcenterCredentials(ctx context.Context, in *ShowVcenterCredentialsRequest, opts ...grpc.CallOption) (*Credentials, error) {
	out := new(Credentials)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ShowVcenterCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetNsxCredentials(ctx context.Context, in *ResetNsxCredentialsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ResetNsxCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ResetVcenterCredentials(ctx context.Context, in *ResetVcenterCredentialsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ResetVcenterCredentials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateHcxActivationKey(ctx context.Context, in *CreateHcxActivationKeyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateHcxActivationKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListHcxActivationKeys(ctx context.Context, in *ListHcxActivationKeysRequest, opts ...grpc.CallOption) (*ListHcxActivationKeysResponse, error) {
	out := new(ListHcxActivationKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListHcxActivationKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetHcxActivationKey(ctx context.Context, in *GetHcxActivationKeyRequest, opts ...grpc.CallOption) (*HcxActivationKey, error) {
	out := new(HcxActivationKey)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetHcxActivationKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetNetworkPolicy(ctx context.Context, in *GetNetworkPolicyRequest, opts ...grpc.CallOption) (*NetworkPolicy, error) {
	out := new(NetworkPolicy)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListNetworkPolicies(ctx context.Context, in *ListNetworkPoliciesRequest, opts ...grpc.CallOption) (*ListNetworkPoliciesResponse, error) {
	out := new(ListNetworkPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateNetworkPolicy(ctx context.Context, in *CreateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateNetworkPolicy(ctx context.Context, in *UpdateNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteNetworkPolicy(ctx context.Context, in *DeleteNetworkPolicyRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) CreateVmwareEngineNetwork(ctx context.Context, in *CreateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/CreateVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) UpdateVmwareEngineNetwork(ctx context.Context, in *UpdateVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) DeleteVmwareEngineNetwork(ctx context.Context, in *DeleteVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) GetVmwareEngineNetwork(ctx context.Context, in *GetVmwareEngineNetworkRequest, opts ...grpc.CallOption) (*VmwareEngineNetwork, error) {
	out := new(VmwareEngineNetwork)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/GetVmwareEngineNetwork", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmwareEngineClient) ListVmwareEngineNetworks(ctx context.Context, in *ListVmwareEngineNetworksRequest, opts ...grpc.CallOption) (*ListVmwareEngineNetworksResponse, error) {
	out := new(ListVmwareEngineNetworksResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vmwareengine.v1.VmwareEngine/ListVmwareEngineNetworks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VmwareEngineServer is the server API for VmwareEngine service.
type VmwareEngineServer interface {
	// Lists `PrivateCloud` resources in a given project and location.
	ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error)
	// Retrieves a `PrivateCloud` resource by its resource name.
	GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error)
	// Creates a new `PrivateCloud` resource in a given project and location.
	// Private clouds can only be created in zones, regional private clouds are
	// not supported.
	//
	// Creating a private cloud also creates a [management
	// cluster](https://cloud.google.com/vmware-engine/docs/concepts-vmware-components)
	// for that private cloud.
	CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunning.Operation, error)
	// Modifies a `PrivateCloud` resource. Only the following fields can be
	// updated: `description`.
	// Only fields specified in `updateMask` are applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunning.Operation, error)
	// Schedules a `PrivateCloud` resource for deletion.
	//
	// A `PrivateCloud` resource scheduled for deletion has `PrivateCloud.state`
	// set to `DELETED` and `expireTime` set to the time when deletion is final
	// and can no longer be reversed. The delete operation is marked as done
	// as soon as the `PrivateCloud` is successfully scheduled for deletion
	// (this also applies when `delayHours` is set to zero), and the operation is
	// not kept in pending state until `PrivateCloud` is purged.
	// `PrivateCloud` can be restored using `UndeletePrivateCloud` method before
	// the `expireTime` elapses. When `expireTime` is reached, deletion is final
	// and all private cloud resources are irreversibly removed and billing stops.
	// During the final removal process, `PrivateCloud.state` is set to `PURGING`.
	// `PrivateCloud` can be polled using standard `GET` method for the whole
	// period of deletion and purging. It will not be returned only
	// when it is completely purged.
	DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunning.Operation, error)
	// Restores a private cloud that was previously scheduled for deletion by
	// `DeletePrivateCloud`. A `PrivateCloud` resource scheduled for deletion has
	// `PrivateCloud.state` set to `DELETED` and `PrivateCloud.expireTime` set to
	// the time when deletion can no longer be reversed.
	UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunning.Operation, error)
	// Lists `Cluster` resources in a given private cloud.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Retrieves a `Cluster` resource by its resource name.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a new cluster in a given private cloud.
	// Creating a new cluster provides additional nodes for
	// use in the parent private cloud and requires sufficient [node
	// quota](https://cloud.google.com/vmware-engine/quotas).
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunning.Operation, error)
	// Modifies a `Cluster` resource. Only the following fields can be updated:
	// `node_type_configs.*.node_count`. Only fields specified in `updateMask` are
	// applied.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunning.Operation, error)
	// Deletes a `Cluster` resource. To avoid unintended data loss, migrate or
	// gracefully shut down any workloads running on the cluster before deletion.
	// You cannot delete the management cluster of a private cloud using this
	// method.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunning.Operation, error)
	// Lists subnets in a given private cloud.
	ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error)
	// Lists node types
	ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error)
	// Gets details of a single `NodeType`.
	GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error)
	// Gets details of credentials for NSX appliance.
	ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error)
	// Gets details of credentials for Vcenter appliance.
	ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error)
	// Resets credentials of the NSX appliance.
	ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunning.Operation, error)
	// Resets credentials of the Vcenter appliance.
	ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunning.Operation, error)
	// Creates a new HCX activation key in a given private cloud.
	CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunning.Operation, error)
	// Lists `HcxActivationKey` resources in a given private cloud.
	ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error)
	// Retrieves a `HcxActivationKey` resource by its resource name.
	GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error)
	// Retrieves a `NetworkPolicy` resource by its resource name.
	GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error)
	// Lists `NetworkPolicy` resources in a specified project and location.
	ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error)
	// Creates a new network policy in a given VMware Engine network of a
	// project and location (region). A new network policy cannot be created if
	// another network policy already exists in the same scope.
	CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunning.Operation, error)
	// Modifies a `NetworkPolicy` resource. Only the following fields can be
	// updated: `internet_access`, `external_ip`, `edge_services_cidr`.
	// Only fields specified in `updateMask` are applied. When updating a network
	// policy, the external IP network service can only be disabled if there are
	// no external IP addresses present in the scope of the policy. Also, a
	// `NetworkService` cannot be updated when `NetworkService.state` is set
	// to `RECONCILING`.
	//
	// During operation processing, the resource is temporarily in the `ACTIVE`
	// state before the operation fully completes. For that period of time, you
	// can't update the resource. Use the operation status to determine when the
	// processing fully completes.
	UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunning.Operation, error)
	// Deletes a `NetworkPolicy` resource. A network policy cannot be deleted
	// when `NetworkService.state` is set to `RECONCILING` for either its external
	// IP or internet access service.
	DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunning.Operation, error)
	// Creates a new VMware Engine network that can be used by a private cloud.
	CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunning.Operation, error)
	// Modifies a VMware Engine network resource. Only the following fields can be
	// updated: `description`. Only fields specified in `updateMask` are
	// applied.
	UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunning.Operation, error)
	// Deletes a `VmwareEngineNetwork` resource. You can only delete a VMware
	// Engine network after all resources that refer to it are deleted. For
	// example, a private cloud, a network peering, and a network policy can all
	// refer to the same VMware Engine network.
	DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunning.Operation, error)
	// Retrieves a `VmwareEngineNetwork` resource by its resource name. The
	// resource contains details of the VMware Engine network, such as its VMware
	// Engine network type, peered networks in a service project, and state
	// (for example, `CREATING`, `ACTIVE`, `DELETING`).
	GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error)
	// Lists `VmwareEngineNetwork` resources in a given project and location.
	ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error)
}

// UnimplementedVmwareEngineServer can be embedded to have forward compatible implementations.
type UnimplementedVmwareEngineServer struct {
}

func (*UnimplementedVmwareEngineServer) ListPrivateClouds(context.Context, *ListPrivateCloudsRequest) (*ListPrivateCloudsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrivateClouds not implemented")
}
func (*UnimplementedVmwareEngineServer) GetPrivateCloud(context.Context, *GetPrivateCloudRequest) (*PrivateCloud, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) CreatePrivateCloud(context.Context, *CreatePrivateCloudRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdatePrivateCloud(context.Context, *UpdatePrivateCloudRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) DeletePrivateCloud(context.Context, *DeletePrivateCloudRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) UndeletePrivateCloud(context.Context, *UndeletePrivateCloudRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeletePrivateCloud not implemented")
}
func (*UnimplementedVmwareEngineServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedVmwareEngineServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateCluster(context.Context, *CreateClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateCluster(context.Context, *UpdateClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedVmwareEngineServer) ListSubnets(context.Context, *ListSubnetsRequest) (*ListSubnetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSubnets not implemented")
}
func (*UnimplementedVmwareEngineServer) ListNodeTypes(context.Context, *ListNodeTypesRequest) (*ListNodeTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodeTypes not implemented")
}
func (*UnimplementedVmwareEngineServer) GetNodeType(context.Context, *GetNodeTypeRequest) (*NodeType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNodeType not implemented")
}
func (*UnimplementedVmwareEngineServer) ShowNsxCredentials(context.Context, *ShowNsxCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowNsxCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ShowVcenterCredentials(context.Context, *ShowVcenterCredentialsRequest) (*Credentials, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ShowVcenterCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ResetNsxCredentials(context.Context, *ResetNsxCredentialsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetNsxCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) ResetVcenterCredentials(context.Context, *ResetVcenterCredentialsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetVcenterCredentials not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateHcxActivationKey(context.Context, *CreateHcxActivationKeyRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHcxActivationKey not implemented")
}
func (*UnimplementedVmwareEngineServer) ListHcxActivationKeys(context.Context, *ListHcxActivationKeysRequest) (*ListHcxActivationKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHcxActivationKeys not implemented")
}
func (*UnimplementedVmwareEngineServer) GetHcxActivationKey(context.Context, *GetHcxActivationKeyRequest) (*HcxActivationKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHcxActivationKey not implemented")
}
func (*UnimplementedVmwareEngineServer) GetNetworkPolicy(context.Context, *GetNetworkPolicyRequest) (*NetworkPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) ListNetworkPolicies(context.Context, *ListNetworkPoliciesRequest) (*ListNetworkPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkPolicies not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateNetworkPolicy(context.Context, *CreateNetworkPolicyRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateNetworkPolicy(context.Context, *UpdateNetworkPolicyRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteNetworkPolicy(context.Context, *DeleteNetworkPolicyRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNetworkPolicy not implemented")
}
func (*UnimplementedVmwareEngineServer) CreateVmwareEngineNetwork(context.Context, *CreateVmwareEngineNetworkRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) UpdateVmwareEngineNetwork(context.Context, *UpdateVmwareEngineNetworkRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) DeleteVmwareEngineNetwork(context.Context, *DeleteVmwareEngineNetworkRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) GetVmwareEngineNetwork(context.Context, *GetVmwareEngineNetworkRequest) (*VmwareEngineNetwork, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVmwareEngineNetwork not implemented")
}
func (*UnimplementedVmwareEngineServer) ListVmwareEngineNetworks(context.Context, *ListVmwareEngineNetworksRequest) (*ListVmwareEngineNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVmwareEngineNetworks not implemented")
}

func RegisterVmwareEngineServer(s *grpc.Server, srv VmwareEngineServer) {
	s.RegisterService(&_VmwareEngine_serviceDesc, srv)
}

func _VmwareEngine_ListPrivateClouds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrivateCloudsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListPrivateClouds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListPrivateClouds(ctx, req.(*ListPrivateCloudsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetPrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetPrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetPrivateCloud(ctx, req.(*GetPrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreatePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreatePrivateCloud(ctx, req.(*CreatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdatePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdatePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdatePrivateCloud(ctx, req.(*UpdatePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeletePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeletePrivateCloud(ctx, req.(*DeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UndeletePrivateCloud_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeletePrivateCloudRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UndeletePrivateCloud",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UndeletePrivateCloud(ctx, req.(*UndeletePrivateCloudRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListSubnets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubnetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListSubnets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListSubnets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListSubnets(ctx, req.(*ListSubnetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNodeTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListNodeTypes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNodeTypes(ctx, req.(*ListNodeTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNodeType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNodeType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetNodeType",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNodeType(ctx, req.(*GetNodeTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ShowNsxCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowNsxCredentials(ctx, req.(*ShowNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ShowVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ShowVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ShowVcenterCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ShowVcenterCredentials(ctx, req.(*ShowVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetNsxCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetNsxCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ResetNsxCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetNsxCredentials(ctx, req.(*ResetNsxCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ResetVcenterCredentials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetVcenterCredentialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ResetVcenterCredentials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ResetVcenterCredentials(ctx, req.(*ResetVcenterCredentialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateHcxActivationKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateHcxActivationKey(ctx, req.(*CreateHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListHcxActivationKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHcxActivationKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListHcxActivationKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListHcxActivationKeys(ctx, req.(*ListHcxActivationKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetHcxActivationKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHcxActivationKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetHcxActivationKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetHcxActivationKey(ctx, req.(*GetHcxActivationKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetNetworkPolicy(ctx, req.(*GetNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListNetworkPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListNetworkPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListNetworkPolicies(ctx, req.(*ListNetworkPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateNetworkPolicy(ctx, req.(*CreateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateNetworkPolicy(ctx, req.(*UpdateNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteNetworkPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteNetworkPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteNetworkPolicy(ctx, req.(*DeleteNetworkPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_CreateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/CreateVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).CreateVmwareEngineNetwork(ctx, req.(*CreateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_UpdateVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/UpdateVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).UpdateVmwareEngineNetwork(ctx, req.(*UpdateVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_DeleteVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/DeleteVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).DeleteVmwareEngineNetwork(ctx, req.(*DeleteVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_GetVmwareEngineNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVmwareEngineNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/GetVmwareEngineNetwork",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).GetVmwareEngineNetwork(ctx, req.(*GetVmwareEngineNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmwareEngine_ListVmwareEngineNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVmwareEngineNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vmwareengine.v1.VmwareEngine/ListVmwareEngineNetworks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmwareEngineServer).ListVmwareEngineNetworks(ctx, req.(*ListVmwareEngineNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VmwareEngine_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vmwareengine.v1.VmwareEngine",
	HandlerType: (*VmwareEngineServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPrivateClouds",
			Handler:    _VmwareEngine_ListPrivateClouds_Handler,
		},
		{
			MethodName: "GetPrivateCloud",
			Handler:    _VmwareEngine_GetPrivateCloud_Handler,
		},
		{
			MethodName: "CreatePrivateCloud",
			Handler:    _VmwareEngine_CreatePrivateCloud_Handler,
		},
		{
			MethodName: "UpdatePrivateCloud",
			Handler:    _VmwareEngine_UpdatePrivateCloud_Handler,
		},
		{
			MethodName: "DeletePrivateCloud",
			Handler:    _VmwareEngine_DeletePrivateCloud_Handler,
		},
		{
			MethodName: "UndeletePrivateCloud",
			Handler:    _VmwareEngine_UndeletePrivateCloud_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _VmwareEngine_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _VmwareEngine_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _VmwareEngine_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _VmwareEngine_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _VmwareEngine_DeleteCluster_Handler,
		},
		{
			MethodName: "ListSubnets",
			Handler:    _VmwareEngine_ListSubnets_Handler,
		},
		{
			MethodName: "ListNodeTypes",
			Handler:    _VmwareEngine_ListNodeTypes_Handler,
		},
		{
			MethodName: "GetNodeType",
			Handler:    _VmwareEngine_GetNodeType_Handler,
		},
		{
			MethodName: "ShowNsxCredentials",
			Handler:    _VmwareEngine_ShowNsxCredentials_Handler,
		},
		{
			MethodName: "ShowVcenterCredentials",
			Handler:    _VmwareEngine_ShowVcenterCredentials_Handler,
		},
		{
			MethodName: "ResetNsxCredentials",
			Handler:    _VmwareEngine_ResetNsxCredentials_Handler,
		},
		{
			MethodName: "ResetVcenterCredentials",
			Handler:    _VmwareEngine_ResetVcenterCredentials_Handler,
		},
		{
			MethodName: "CreateHcxActivationKey",
			Handler:    _VmwareEngine_CreateHcxActivationKey_Handler,
		},
		{
			MethodName: "ListHcxActivationKeys",
			Handler:    _VmwareEngine_ListHcxActivationKeys_Handler,
		},
		{
			MethodName: "GetHcxActivationKey",
			Handler:    _VmwareEngine_GetHcxActivationKey_Handler,
		},
		{
			MethodName: "GetNetworkPolicy",
			Handler:    _VmwareEngine_GetNetworkPolicy_Handler,
		},
		{
			MethodName: "ListNetworkPolicies",
			Handler:    _VmwareEngine_ListNetworkPolicies_Handler,
		},
		{
			MethodName: "CreateNetworkPolicy",
			Handler:    _VmwareEngine_CreateNetworkPolicy_Handler,
		},
		{
			MethodName: "UpdateNetworkPolicy",
			Handler:    _VmwareEngine_UpdateNetworkPolicy_Handler,
		},
		{
			MethodName: "DeleteNetworkPolicy",
			Handler:    _VmwareEngine_DeleteNetworkPolicy_Handler,
		},
		{
			MethodName: "CreateVmwareEngineNetwork",
			Handler:    _VmwareEngine_CreateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "UpdateVmwareEngineNetwork",
			Handler:    _VmwareEngine_UpdateVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "DeleteVmwareEngineNetwork",
			Handler:    _VmwareEngine_DeleteVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "GetVmwareEngineNetwork",
			Handler:    _VmwareEngine_GetVmwareEngineNetwork_Handler,
		},
		{
			MethodName: "ListVmwareEngineNetworks",
			Handler:    _VmwareEngine_ListVmwareEngineNetworks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vmwareengine/v1/vmwareengine.proto",
}
