// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto

package runtimeconfig

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request for the `ListConfigs()` method.
type ListConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [project
	// ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConfigsRequest) Reset() {
	*x = ListConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfigsRequest) ProtoMessage() {}

func (x *ListConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{0}
}

func (x *ListConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// `ListConfigs()` returns the following response. The order of returned
// objects is arbitrary; that is, it is not ordered in any particular way.
type ListConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of the configurations in the project. The order of returned
	// objects is arbitrary; that is, it is not ordered in any particular way.
	Configs []*RuntimeConfig `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConfigsResponse) Reset() {
	*x = ListConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConfigsResponse) ProtoMessage() {}

func (x *ListConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{1}
}

func (x *ListConfigsResponse) GetConfigs() []*RuntimeConfig {
	if x != nil {
		return x.Configs
	}
	return nil
}

func (x *ListConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Gets a RuntimeConfig resource.
type GetConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the RuntimeConfig resource to retrieve, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConfigRequest) Reset() {
	*x = GetConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConfigRequest) ProtoMessage() {}

func (x *GetConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConfigRequest.ProtoReflect.Descriptor instead.
func (*GetConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{2}
}

func (x *GetConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Creates a RuntimeConfig resource.
type CreateConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [project
	// ID](https://support.google.com/cloud/answer/6158840?hl=en&ref_topic=6158848)
	// for this request, in the format `projects/[PROJECT_ID]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The RuntimeConfig to create.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateConfigRequest) Reset() {
	*x = CreateConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConfigRequest) ProtoMessage() {}

func (x *CreateConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{3}
}

func (x *CreateConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConfigRequest) GetConfig() *RuntimeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *CreateConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for `UpdateConfig()` method.
type UpdateConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the RuntimeConfig resource to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The config resource to update.
	Config *RuntimeConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *UpdateConfigRequest) Reset() {
	*x = UpdateConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConfigRequest) ProtoMessage() {}

func (x *UpdateConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateConfigRequest) GetConfig() *RuntimeConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

// Request for the `DeleteConfig()` method.
type DeleteConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The RuntimeConfig resource to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteConfigRequest) Reset() {
	*x = DeleteConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConfigRequest) ProtoMessage() {}

func (x *DeleteConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `ListVariables()` method.
type ListVariablesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the RuntimeConfig resource for which you want to list
	// variables. The configuration must exist beforehand; the path must by in the
	// format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filters variables by matching the specified filter. For example:
	//
	// `projects/example-project/config/[CONFIG_NAME]/variables/example-variable`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The flag indicates whether the user wants to return values of variables.
	// If true, then only those variables that user has IAM GetVariable permission
	// will be returned along with their values.
	ReturnValues bool `protobuf:"varint,5,opt,name=return_values,json=returnValues,proto3" json:"return_values,omitempty"`
}

func (x *ListVariablesRequest) Reset() {
	*x = ListVariablesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVariablesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVariablesRequest) ProtoMessage() {}

func (x *ListVariablesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVariablesRequest.ProtoReflect.Descriptor instead.
func (*ListVariablesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{6}
}

func (x *ListVariablesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVariablesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListVariablesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVariablesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListVariablesRequest) GetReturnValues() bool {
	if x != nil {
		return x.ReturnValues
	}
	return false
}

// Response for the `ListVariables()` method.
type ListVariablesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of variables and their values. The order of returned variable
	// objects is arbitrary.
	Variables []*Variable `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVariablesResponse) Reset() {
	*x = ListVariablesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVariablesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVariablesResponse) ProtoMessage() {}

func (x *ListVariablesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVariablesResponse.ProtoReflect.Descriptor instead.
func (*ListVariablesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{7}
}

func (x *ListVariablesResponse) GetVariables() []*Variable {
	if x != nil {
		return x.Variables
	}
	return nil
}

func (x *ListVariablesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `WatchVariable()` method.
type WatchVariableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the variable to watch, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If specified, checks the current timestamp of the variable and if the
	// current timestamp is newer than `newerThan` timestamp, the method returns
	// immediately.
	//
	// If not specified or the variable has an older timestamp, the watcher waits
	// for a the value to change before returning.
	NewerThan *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=newer_than,json=newerThan,proto3" json:"newer_than,omitempty"`
}

func (x *WatchVariableRequest) Reset() {
	*x = WatchVariableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WatchVariableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchVariableRequest) ProtoMessage() {}

func (x *WatchVariableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchVariableRequest.ProtoReflect.Descriptor instead.
func (*WatchVariableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{8}
}

func (x *WatchVariableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WatchVariableRequest) GetNewerThan() *timestamppb.Timestamp {
	if x != nil {
		return x.NewerThan
	}
	return nil
}

// Request for the `GetVariable()` method.
type GetVariableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the variable to return, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIBLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVariableRequest) Reset() {
	*x = GetVariableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVariableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVariableRequest) ProtoMessage() {}

func (x *GetVariableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVariableRequest.ProtoReflect.Descriptor instead.
func (*GetVariableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{9}
}

func (x *GetVariableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateVariable()` method.
type CreateVariableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the RutimeConfig resource that this variable should belong to.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The variable to create.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable,proto3" json:"variable,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateVariableRequest) Reset() {
	*x = CreateVariableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVariableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVariableRequest) ProtoMessage() {}

func (x *CreateVariableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVariableRequest.ProtoReflect.Descriptor instead.
func (*CreateVariableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{10}
}

func (x *CreateVariableRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVariableRequest) GetVariable() *Variable {
	if x != nil {
		return x.Variable
	}
	return nil
}

func (x *CreateVariableRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for the `UpdateVariable()` method.
type UpdateVariableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the variable to update, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The variable to update.
	Variable *Variable `protobuf:"bytes,2,opt,name=variable,proto3" json:"variable,omitempty"`
}

func (x *UpdateVariableRequest) Reset() {
	*x = UpdateVariableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVariableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVariableRequest) ProtoMessage() {}

func (x *UpdateVariableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVariableRequest.ProtoReflect.Descriptor instead.
func (*UpdateVariableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateVariableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateVariableRequest) GetVariable() *Variable {
	if x != nil {
		return x.Variable
	}
	return nil
}

// Request for the `DeleteVariable()` method.
type DeleteVariableRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the variable to delete, in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/variables/[VARIABLE_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Set to `true` to recursively delete multiple variables with the same
	// prefix.
	Recursive bool `protobuf:"varint,2,opt,name=recursive,proto3" json:"recursive,omitempty"`
}

func (x *DeleteVariableRequest) Reset() {
	*x = DeleteVariableRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVariableRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVariableRequest) ProtoMessage() {}

func (x *DeleteVariableRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVariableRequest.ProtoReflect.Descriptor instead.
func (*DeleteVariableRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteVariableRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteVariableRequest) GetRecursive() bool {
	if x != nil {
		return x.Recursive
	}
	return false
}

// Request for the `ListWaiters()` method.
type ListWaitersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the configuration for which you want to get a list of waiters.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Specifies the number of results to return per page. If there are fewer
	// elements than the specified number, returns all elements.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Specifies a page token to use. Set `pageToken` to a `nextPageToken`
	// returned by a previous list request to get the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWaitersRequest) Reset() {
	*x = ListWaitersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWaitersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWaitersRequest) ProtoMessage() {}

func (x *ListWaitersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWaitersRequest.ProtoReflect.Descriptor instead.
func (*ListWaitersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{13}
}

func (x *ListWaitersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWaitersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWaitersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListWaiters()` method.
// Order of returned waiter objects is arbitrary.
type ListWaitersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Found waiters in the project.
	Waiters []*Waiter `protobuf:"bytes,1,rep,name=waiters,proto3" json:"waiters,omitempty"`
	// This token allows you to get the next page of results for list requests.
	// If the number of results is larger than `pageSize`, use the `nextPageToken`
	// as a value for the query parameter `pageToken` in the next list request.
	// Subsequent list requests will have their own `nextPageToken` to continue
	// paging through the results
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWaitersResponse) Reset() {
	*x = ListWaitersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListWaitersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWaitersResponse) ProtoMessage() {}

func (x *ListWaitersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWaitersResponse.ProtoReflect.Descriptor instead.
func (*ListWaitersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{14}
}

func (x *ListWaitersResponse) GetWaiters() []*Waiter {
	if x != nil {
		return x.Waiters
	}
	return nil
}

func (x *ListWaitersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for the `GetWaiter()` method.
type GetWaiterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fully-qualified name of the Waiter resource object to retrieve, in the
	// format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWaiterRequest) Reset() {
	*x = GetWaiterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetWaiterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWaiterRequest) ProtoMessage() {}

func (x *GetWaiterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWaiterRequest.ProtoReflect.Descriptor instead.
func (*GetWaiterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{15}
}

func (x *GetWaiterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `CreateWaiter()` method.
type CreateWaiterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path to the configuration that will own the waiter.
	// The configuration must exist beforehand; the path must by in the format:
	//
	// `projects/[PROJECT_ID]/configs/[CONFIG_NAME]`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Waiter resource to create.
	Waiter *Waiter `protobuf:"bytes,2,opt,name=waiter,proto3" json:"waiter,omitempty"`
	// An optional but recommended unique `request_id`. If the server
	// receives two `create()` requests  with the same
	// `request_id`, then the second request will be ignored and the
	// first resource created and stored in the backend is returned.
	// Empty `request_id` fields are ignored.
	//
	// It is responsibility of the client to ensure uniqueness of the
	// `request_id` strings.
	//
	// `request_id` strings are limited to 64 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateWaiterRequest) Reset() {
	*x = CreateWaiterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateWaiterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWaiterRequest) ProtoMessage() {}

func (x *CreateWaiterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWaiterRequest.ProtoReflect.Descriptor instead.
func (*CreateWaiterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{16}
}

func (x *CreateWaiterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWaiterRequest) GetWaiter() *Waiter {
	if x != nil {
		return x.Waiter
	}
	return nil
}

func (x *CreateWaiterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for the `DeleteWaiter()` method.
type DeleteWaiterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Waiter resource to delete, in the format:
	//
	//  `projects/[PROJECT_ID]/configs/[CONFIG_NAME]/waiters/[WAITER_NAME]`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteWaiterRequest) Reset() {
	*x = DeleteWaiterRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteWaiterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWaiterRequest) ProtoMessage() {}

func (x *DeleteWaiterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWaiterRequest.ProtoReflect.Descriptor instead.
func (*DeleteWaiterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteWaiterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto protoreflect.FileDescriptor

var file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x68, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x26, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x97, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x49, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x74, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x29, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x8b, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4a, 0x0a, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x14, 0x57, 0x61, 0x74, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x39, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x61, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x09, 0x6e, 0x65, 0x77, 0x65, 0x72, 0x54, 0x68, 0x61, 0x6e, 0x22, 0x28, 0x0a, 0x12, 0x47, 0x65,
	0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x75, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x08,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x08, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x49, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x69, 0x76,
	0x65, 0x22, 0x68, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x07, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72,
	0x52, 0x07, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x26, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x90, 0x01, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x77, 0x61, 0x69,
	0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57,
	0x61, 0x69, 0x74, 0x65, 0x72, 0x52, 0x06, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x29, 0x0a, 0x13,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xd6, 0x14, 0x0a, 0x14, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x12, 0xac, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0xa2, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x12, 0x24,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x22, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x3a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xb0, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x1a, 0x24, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8d, 0x01, 0x0a, 0x0c, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x26, 0x2a, 0x24, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x01, 0x0a, 0x0d, 0x4c,
	0x69, 0x73, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x38, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0xae, 0x01, 0x0a, 0x0b,
	0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a,
	0x0d, 0x57, 0x61, 0x74, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x57, 0x61, 0x74, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x77, 0x61, 0x74, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0xbd, 0x01, 0x0a, 0x0e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x30,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x3a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x1a, 0x31,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x9e, 0x01, 0x0a, 0x0e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xb6, 0x01, 0x0a,
	0x0b, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x61,
	0x69, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x36, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x61,
	0x69, 0x74, 0x65, 0x72, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x57, 0x61, 0x69,
	0x74, 0x65, 0x72, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x57, 0x61, 0x69, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x57,
	0x61, 0x69, 0x74, 0x65, 0x72, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x2a, 0x2f, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa6, 0x01,
	0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x12, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x22, 0x2e,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x06,
	0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x12, 0x97, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x57, 0x61, 0x69, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x36, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x61, 0x69, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x42, 0xc5, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x4f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0xaa, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31, 0x42, 0x65,
	0x74, 0x61, 0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescOnce sync.Once
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescData = file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDesc
)

func file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescGZIP() []byte {
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescOnce.Do(func() {
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescData)
	})
	return file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDescData
}

var file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_goTypes = []interface{}{
	(*ListConfigsRequest)(nil),    // 0: google.cloud.runtimeconfig.v1beta1.ListConfigsRequest
	(*ListConfigsResponse)(nil),   // 1: google.cloud.runtimeconfig.v1beta1.ListConfigsResponse
	(*GetConfigRequest)(nil),      // 2: google.cloud.runtimeconfig.v1beta1.GetConfigRequest
	(*CreateConfigRequest)(nil),   // 3: google.cloud.runtimeconfig.v1beta1.CreateConfigRequest
	(*UpdateConfigRequest)(nil),   // 4: google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest
	(*DeleteConfigRequest)(nil),   // 5: google.cloud.runtimeconfig.v1beta1.DeleteConfigRequest
	(*ListVariablesRequest)(nil),  // 6: google.cloud.runtimeconfig.v1beta1.ListVariablesRequest
	(*ListVariablesResponse)(nil), // 7: google.cloud.runtimeconfig.v1beta1.ListVariablesResponse
	(*WatchVariableRequest)(nil),  // 8: google.cloud.runtimeconfig.v1beta1.WatchVariableRequest
	(*GetVariableRequest)(nil),    // 9: google.cloud.runtimeconfig.v1beta1.GetVariableRequest
	(*CreateVariableRequest)(nil), // 10: google.cloud.runtimeconfig.v1beta1.CreateVariableRequest
	(*UpdateVariableRequest)(nil), // 11: google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest
	(*DeleteVariableRequest)(nil), // 12: google.cloud.runtimeconfig.v1beta1.DeleteVariableRequest
	(*ListWaitersRequest)(nil),    // 13: google.cloud.runtimeconfig.v1beta1.ListWaitersRequest
	(*ListWaitersResponse)(nil),   // 14: google.cloud.runtimeconfig.v1beta1.ListWaitersResponse
	(*GetWaiterRequest)(nil),      // 15: google.cloud.runtimeconfig.v1beta1.GetWaiterRequest
	(*CreateWaiterRequest)(nil),   // 16: google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest
	(*DeleteWaiterRequest)(nil),   // 17: google.cloud.runtimeconfig.v1beta1.DeleteWaiterRequest
	(*RuntimeConfig)(nil),         // 18: google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	(*Variable)(nil),              // 19: google.cloud.runtimeconfig.v1beta1.Variable
	(*timestamppb.Timestamp)(nil), // 20: google.protobuf.Timestamp
	(*Waiter)(nil),                // 21: google.cloud.runtimeconfig.v1beta1.Waiter
	(*emptypb.Empty)(nil),         // 22: google.protobuf.Empty
	(*longrunning.Operation)(nil), // 23: google.longrunning.Operation
}
var file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_depIdxs = []int32{
	18, // 0: google.cloud.runtimeconfig.v1beta1.ListConfigsResponse.configs:type_name -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	18, // 1: google.cloud.runtimeconfig.v1beta1.CreateConfigRequest.config:type_name -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	18, // 2: google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest.config:type_name -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	19, // 3: google.cloud.runtimeconfig.v1beta1.ListVariablesResponse.variables:type_name -> google.cloud.runtimeconfig.v1beta1.Variable
	20, // 4: google.cloud.runtimeconfig.v1beta1.WatchVariableRequest.newer_than:type_name -> google.protobuf.Timestamp
	19, // 5: google.cloud.runtimeconfig.v1beta1.CreateVariableRequest.variable:type_name -> google.cloud.runtimeconfig.v1beta1.Variable
	19, // 6: google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest.variable:type_name -> google.cloud.runtimeconfig.v1beta1.Variable
	21, // 7: google.cloud.runtimeconfig.v1beta1.ListWaitersResponse.waiters:type_name -> google.cloud.runtimeconfig.v1beta1.Waiter
	21, // 8: google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest.waiter:type_name -> google.cloud.runtimeconfig.v1beta1.Waiter
	0,  // 9: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListConfigs:input_type -> google.cloud.runtimeconfig.v1beta1.ListConfigsRequest
	2,  // 10: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetConfig:input_type -> google.cloud.runtimeconfig.v1beta1.GetConfigRequest
	3,  // 11: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateConfig:input_type -> google.cloud.runtimeconfig.v1beta1.CreateConfigRequest
	4,  // 12: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.UpdateConfig:input_type -> google.cloud.runtimeconfig.v1beta1.UpdateConfigRequest
	5,  // 13: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteConfig:input_type -> google.cloud.runtimeconfig.v1beta1.DeleteConfigRequest
	6,  // 14: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListVariables:input_type -> google.cloud.runtimeconfig.v1beta1.ListVariablesRequest
	9,  // 15: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetVariable:input_type -> google.cloud.runtimeconfig.v1beta1.GetVariableRequest
	8,  // 16: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.WatchVariable:input_type -> google.cloud.runtimeconfig.v1beta1.WatchVariableRequest
	10, // 17: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateVariable:input_type -> google.cloud.runtimeconfig.v1beta1.CreateVariableRequest
	11, // 18: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.UpdateVariable:input_type -> google.cloud.runtimeconfig.v1beta1.UpdateVariableRequest
	12, // 19: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteVariable:input_type -> google.cloud.runtimeconfig.v1beta1.DeleteVariableRequest
	13, // 20: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListWaiters:input_type -> google.cloud.runtimeconfig.v1beta1.ListWaitersRequest
	15, // 21: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetWaiter:input_type -> google.cloud.runtimeconfig.v1beta1.GetWaiterRequest
	16, // 22: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateWaiter:input_type -> google.cloud.runtimeconfig.v1beta1.CreateWaiterRequest
	17, // 23: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteWaiter:input_type -> google.cloud.runtimeconfig.v1beta1.DeleteWaiterRequest
	1,  // 24: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListConfigs:output_type -> google.cloud.runtimeconfig.v1beta1.ListConfigsResponse
	18, // 25: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetConfig:output_type -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	18, // 26: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateConfig:output_type -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	18, // 27: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.UpdateConfig:output_type -> google.cloud.runtimeconfig.v1beta1.RuntimeConfig
	22, // 28: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteConfig:output_type -> google.protobuf.Empty
	7,  // 29: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListVariables:output_type -> google.cloud.runtimeconfig.v1beta1.ListVariablesResponse
	19, // 30: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetVariable:output_type -> google.cloud.runtimeconfig.v1beta1.Variable
	19, // 31: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.WatchVariable:output_type -> google.cloud.runtimeconfig.v1beta1.Variable
	19, // 32: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateVariable:output_type -> google.cloud.runtimeconfig.v1beta1.Variable
	19, // 33: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.UpdateVariable:output_type -> google.cloud.runtimeconfig.v1beta1.Variable
	22, // 34: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteVariable:output_type -> google.protobuf.Empty
	14, // 35: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.ListWaiters:output_type -> google.cloud.runtimeconfig.v1beta1.ListWaitersResponse
	21, // 36: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.GetWaiter:output_type -> google.cloud.runtimeconfig.v1beta1.Waiter
	23, // 37: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.CreateWaiter:output_type -> google.longrunning.Operation
	22, // 38: google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager.DeleteWaiter:output_type -> google.protobuf.Empty
	24, // [24:39] is the sub-list for method output_type
	9,  // [9:24] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_init() }
func file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_init() {
	if File_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto != nil {
		return
	}
	file_google_cloud_runtimeconfig_v1beta1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVariablesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVariablesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WatchVariableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVariableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVariableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVariableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVariableRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWaitersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListWaitersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetWaiterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateWaiterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteWaiterRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_goTypes,
		DependencyIndexes: file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_depIdxs,
		MessageInfos:      file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_msgTypes,
	}.Build()
	File_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto = out.File
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_rawDesc = nil
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_goTypes = nil
	file_google_cloud_runtimeconfig_v1beta1_runtimeconfig_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RuntimeConfigManagerClient is the client API for RuntimeConfigManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RuntimeConfigManagerClient interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists variables within given a configuration, matching any provided
	// filters. This only lists variable names, not the values, unless
	// `return_values` is true, in which case only variables that user has IAM
	// permission to GetVariable will be returned.
	ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal
	// timeout (60 seconds), the current variable value is returned and the
	// `variableState` will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for
	// Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting
	// Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type runtimeConfigManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewRuntimeConfigManagerClient(cc grpc.ClientConnInterface) RuntimeConfigManagerClient {
	return &runtimeConfigManagerClient{cc}
}

func (c *runtimeConfigManagerClient) ListConfigs(ctx context.Context, in *ListConfigsRequest, opts ...grpc.CallOption) (*ListConfigsResponse, error) {
	out := new(ListConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateConfig(ctx context.Context, in *CreateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*RuntimeConfig, error) {
	out := new(RuntimeConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteConfig(ctx context.Context, in *DeleteConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListVariables(ctx context.Context, in *ListVariablesRequest, opts ...grpc.CallOption) (*ListVariablesResponse, error) {
	out := new(ListVariablesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetVariable(ctx context.Context, in *GetVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) WatchVariable(ctx context.Context, in *WatchVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateVariable(ctx context.Context, in *CreateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) UpdateVariable(ctx context.Context, in *UpdateVariableRequest, opts ...grpc.CallOption) (*Variable, error) {
	out := new(Variable)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteVariable(ctx context.Context, in *DeleteVariableRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) ListWaiters(ctx context.Context, in *ListWaitersRequest, opts ...grpc.CallOption) (*ListWaitersResponse, error) {
	out := new(ListWaitersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) GetWaiter(ctx context.Context, in *GetWaiterRequest, opts ...grpc.CallOption) (*Waiter, error) {
	out := new(Waiter)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) CreateWaiter(ctx context.Context, in *CreateWaiterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runtimeConfigManagerClient) DeleteWaiter(ctx context.Context, in *DeleteWaiterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RuntimeConfigManagerServer is the server API for RuntimeConfigManager service.
type RuntimeConfigManagerServer interface {
	// Lists all the RuntimeConfig resources within project.
	ListConfigs(context.Context, *ListConfigsRequest) (*ListConfigsResponse, error)
	// Gets information about a RuntimeConfig resource.
	GetConfig(context.Context, *GetConfigRequest) (*RuntimeConfig, error)
	// Creates a new RuntimeConfig resource. The configuration name must be
	// unique within project.
	CreateConfig(context.Context, *CreateConfigRequest) (*RuntimeConfig, error)
	// Updates a RuntimeConfig resource. The configuration must exist beforehand.
	UpdateConfig(context.Context, *UpdateConfigRequest) (*RuntimeConfig, error)
	// Deletes a RuntimeConfig resource.
	DeleteConfig(context.Context, *DeleteConfigRequest) (*emptypb.Empty, error)
	// Lists variables within given a configuration, matching any provided
	// filters. This only lists variable names, not the values, unless
	// `return_values` is true, in which case only variables that user has IAM
	// permission to GetVariable will be returned.
	ListVariables(context.Context, *ListVariablesRequest) (*ListVariablesResponse, error)
	// Gets information about a single variable.
	GetVariable(context.Context, *GetVariableRequest) (*Variable, error)
	// Watches a specific variable and waits for a change in the variable's value.
	// When there is a change, this method returns the new value or times out.
	//
	// If a variable is deleted while being watched, the `variableState` state is
	// set to `DELETED` and the method returns the last known variable `value`.
	//
	// If you set the deadline for watching to a larger value than internal
	// timeout (60 seconds), the current variable value is returned and the
	// `variableState` will be `VARIABLE_STATE_UNSPECIFIED`.
	//
	// To learn more about creating a watcher, read the
	// [Watching a Variable for
	// Changes](/deployment-manager/runtime-configurator/watching-a-variable)
	// documentation.
	WatchVariable(context.Context, *WatchVariableRequest) (*Variable, error)
	// Creates a variable within the given configuration. You cannot create
	// a variable with a name that is a prefix of an existing variable name, or a
	// name that has an existing variable name as a prefix.
	//
	// To learn more about creating a variable, read the
	// [Setting and Getting
	// Data](/deployment-manager/runtime-configurator/set-and-get-variables)
	// documentation.
	CreateVariable(context.Context, *CreateVariableRequest) (*Variable, error)
	// Updates an existing variable with a new value.
	UpdateVariable(context.Context, *UpdateVariableRequest) (*Variable, error)
	// Deletes a variable or multiple variables.
	//
	// If you specify a variable name, then that variable is deleted. If you
	// specify a prefix and `recursive` is true, then all variables with that
	// prefix are deleted. You must set a `recursive` to true if you delete
	// variables by prefix.
	DeleteVariable(context.Context, *DeleteVariableRequest) (*emptypb.Empty, error)
	// List waiters within the given configuration.
	ListWaiters(context.Context, *ListWaitersRequest) (*ListWaitersResponse, error)
	// Gets information about a single waiter.
	GetWaiter(context.Context, *GetWaiterRequest) (*Waiter, error)
	// Creates a Waiter resource. This operation returns a long-running Operation
	// resource which can be polled for completion. However, a waiter with the
	// given name will exist (and can be retrieved) prior to the operation
	// completing. If the operation fails, the failed Waiter resource will
	// still exist and must be deleted prior to subsequent creation attempts.
	CreateWaiter(context.Context, *CreateWaiterRequest) (*longrunning.Operation, error)
	// Deletes the waiter with the specified name.
	DeleteWaiter(context.Context, *DeleteWaiterRequest) (*emptypb.Empty, error)
}

// UnimplementedRuntimeConfigManagerServer can be embedded to have forward compatible implementations.
type UnimplementedRuntimeConfigManagerServer struct {
}

func (*UnimplementedRuntimeConfigManagerServer) ListConfigs(context.Context, *ListConfigsRequest) (*ListConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConfigs not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) GetConfig(context.Context, *GetConfigRequest) (*RuntimeConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) CreateConfig(context.Context, *CreateConfigRequest) (*RuntimeConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConfig not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) UpdateConfig(context.Context, *UpdateConfigRequest) (*RuntimeConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfig not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) DeleteConfig(context.Context, *DeleteConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConfig not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) ListVariables(context.Context, *ListVariablesRequest) (*ListVariablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVariables not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) GetVariable(context.Context, *GetVariableRequest) (*Variable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVariable not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) WatchVariable(context.Context, *WatchVariableRequest) (*Variable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WatchVariable not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) CreateVariable(context.Context, *CreateVariableRequest) (*Variable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVariable not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) UpdateVariable(context.Context, *UpdateVariableRequest) (*Variable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVariable not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) DeleteVariable(context.Context, *DeleteVariableRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVariable not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) ListWaiters(context.Context, *ListWaitersRequest) (*ListWaitersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWaiters not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) GetWaiter(context.Context, *GetWaiterRequest) (*Waiter, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWaiter not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) CreateWaiter(context.Context, *CreateWaiterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateWaiter not implemented")
}
func (*UnimplementedRuntimeConfigManagerServer) DeleteWaiter(context.Context, *DeleteWaiterRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteWaiter not implemented")
}

func RegisterRuntimeConfigManagerServer(s *grpc.Server, srv RuntimeConfigManagerServer) {
	s.RegisterService(&_RuntimeConfigManager_serviceDesc, srv)
}

func _RuntimeConfigManager_ListConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListConfigs(ctx, req.(*ListConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateConfig(ctx, req.(*CreateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteConfig(ctx, req.(*DeleteConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListVariables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVariablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListVariables",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListVariables(ctx, req.(*ListVariablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetVariable(ctx, req.(*GetVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_WatchVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WatchVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/WatchVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).WatchVariable(ctx, req.(*WatchVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateVariable(ctx, req.(*CreateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_UpdateVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/UpdateVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).UpdateVariable(ctx, req.(*UpdateVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteVariable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteVariable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteVariable(ctx, req.(*DeleteVariableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_ListWaiters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWaitersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/ListWaiters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).ListWaiters(ctx, req.(*ListWaitersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_GetWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/GetWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).GetWaiter(ctx, req.(*GetWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_CreateWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/CreateWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).CreateWaiter(ctx, req.(*CreateWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RuntimeConfigManager_DeleteWaiter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWaiterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager/DeleteWaiter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RuntimeConfigManagerServer).DeleteWaiter(ctx, req.(*DeleteWaiterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RuntimeConfigManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.runtimeconfig.v1beta1.RuntimeConfigManager",
	HandlerType: (*RuntimeConfigManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConfigs",
			Handler:    _RuntimeConfigManager_ListConfigs_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _RuntimeConfigManager_GetConfig_Handler,
		},
		{
			MethodName: "CreateConfig",
			Handler:    _RuntimeConfigManager_CreateConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _RuntimeConfigManager_UpdateConfig_Handler,
		},
		{
			MethodName: "DeleteConfig",
			Handler:    _RuntimeConfigManager_DeleteConfig_Handler,
		},
		{
			MethodName: "ListVariables",
			Handler:    _RuntimeConfigManager_ListVariables_Handler,
		},
		{
			MethodName: "GetVariable",
			Handler:    _RuntimeConfigManager_GetVariable_Handler,
		},
		{
			MethodName: "WatchVariable",
			Handler:    _RuntimeConfigManager_WatchVariable_Handler,
		},
		{
			MethodName: "CreateVariable",
			Handler:    _RuntimeConfigManager_CreateVariable_Handler,
		},
		{
			MethodName: "UpdateVariable",
			Handler:    _RuntimeConfigManager_UpdateVariable_Handler,
		},
		{
			MethodName: "DeleteVariable",
			Handler:    _RuntimeConfigManager_DeleteVariable_Handler,
		},
		{
			MethodName: "ListWaiters",
			Handler:    _RuntimeConfigManager_ListWaiters_Handler,
		},
		{
			MethodName: "GetWaiter",
			Handler:    _RuntimeConfigManager_GetWaiter_Handler,
		},
		{
			MethodName: "CreateWaiter",
			Handler:    _RuntimeConfigManager_CreateWaiter_Handler,
		},
		{
			MethodName: "DeleteWaiter",
			Handler:    _RuntimeConfigManager_DeleteWaiter_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/runtimeconfig/v1beta1/runtimeconfig.proto",
}
