// Copyright 2020 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package kernfs

import (
	"sync/atomic"

	"gvisor.dev/gvisor/pkg/refsvfs2"
)

// afterLoad is invoked by stateify.
func (d *Dentry) afterLoad() {
	if atomic.LoadInt64(&d.refs) >= 0 {
		refsvfs2.Register(d)
	}
}

// afterLoad is invoked by stateify.
func (i *inodePlatformFile) afterLoad() {
	if i.fileMapper.IsInited() {
		// Ensure that we don't call i.fileMapper.Init() again.
		i.fileMapperInitOnce.Do(func() {})
	}
}
