# Configuration Changes

- The experimental `hoverKind=Structured` setting is no longer supported.

- The `gc_details` code lens has been deleted. (It was previously
  disabled by default.) This functionality is now available through
  the `settings.toggleCompilerOptDetails` code action (documented
  below), as code actions are better supported than code lenses across
  a range of clients.

  VS Code's special "Go: Toggle GC details" command continues to work.

# New features

## "Toggle compiler optimization details" code action

This code action, accessible through the "Source Action" menu in VS
Code, toggles a per-package flag that causes Go compiler optimization
details to be reported as diagnostics. For example, it indicates which
variables escape to the heap, and which array accesses require bounds
checks.

## New `modernize` analyzer

Gopls now reports when code could be simplified or clarified by
using more modern features of Go, and provides a quick fix to apply
the change.

Examples:

- replacement of conditional assignment using an if/else statement by
  a call to the `min` or `max` built-in functions added in Go 1.18;

## New `unusedfunc` analyzer

Gopls now reports unused functions and methods, giving you near
real-time feedback about dead code that may be safely deleted.
Because the analysis is local to each package, only unexported
functions and methods are candidates.
(For a more precise analysis that may report unused exported
functions too, use the `golang.org/x/tools/cmd/deadcode` command.)

## "Implementations" supports generics

At long last, the "Go to Implementations" feature now fully supports
generic types and functions (#59224).

For example, invoking the feature on the interface method `Stack.Push`
below will report the concrete method `C[T].Push`, and vice versa.

```go
package p

type Stack[T any] interface {
	Push(T) error
	Pop() (T, bool)
}

type C[T any] struct{}

func (C[T]) Push(t T) error { ... }
func (C[T]) Pop() (T, bool) { ... }

var _ Stack[int] = C[int]{}
```

## Extract all occurrences of the same expression under selection

When you have multiple instances of the same expression in a function,
you can use this code action to extract it into a variable.
All occurrences of the expression will be replaced with a reference to the new variable.

## Improvements to "Definition"

The Definition query now supports additional locations:

- When invoked on a return statement, it reports the location
  of the function's result variables.
- When invoked on a break, goto, or continue statement, it reports
  the location of the label, the closing brace of the relevant
  block statement, or the start of the relevant loop, respectively.

## Improvements to "Hover"

When invoked on a return statement, hover reports the types of
  the function's result variables.
