---
title: Staticcheck 2022.1 release notes
linkTitle: "2022.1 (v0.3.0)"
weight: -7
---

## Improvements {#improvements}

This release adds support for Go 1.18 and type parameters (generics).

Furthermore, it adds two new flags for handling build tags, `-matrix` and `-merge`. Their use is extensively documented
on the new [Build tags]({{< relref "/docs/running-staticcheck/cli/build-tags" >}}) page. Their intended use is for
avoiding false positives when dealing with different build tags.

Not tied directly to this release, but worth mentioning regardless: Staticcheck has an [official GitHub
Action](https://github.com/dominikh/staticcheck-action) now, which may simplify your CI pipeline.

Minor changes include slightly nicer output from `staticcheck -explain`, better error messages, and allowing whitespace in flags like `-checks`.

## Checks {#checks}

### New checks {#checks-new}

The following new checks have been added:

- {{< check "SA4028" >}} flags `x % 1`, which always yields zero, and is sometimes accidentally used instead of `x % 2`
- {{< check "SA4029" >}} flags misuses of `sort.IntSlice` and related types
- {{< check "SA4030" >}} flags misuses of `math/rand` that always generate zeros
- {{< check "SA4031" >}} flags comparisons of never-nil values against nil
- {{< check "SA9007" >}} flags attempts at deleting system directories
- {{< check "SA9008" >}} flags accidental shadowing in the else branches of type assertions

### Changed checks {#checks-changed}

The following checks have been improved:

- {{< check "S1001"  >}} now simplifies more loops
- {{< check "S1038"  >}} now simplifies formatted printing in `log` and `testing`, in addition to `fmt`
- {{< check "SA1019" >}} no longer flags deprecated API in the Go standard library if it doesn't know when the API was
  deprecated. This is to avoid false positives when using older versions of Staticcheck on newer versions of Go, in
  particular Go's `master` branch.
- {{< check "SA1020" >}} no longer flags `net/http.ListenAndServe` with a completely empty address
- {{< check "ST1001" >}} various packages of `github.com/mmcloughlin/avo` have been whitelisted by default
- {{< check "ST1008" >}} no longer flags functions that return `(..., error, bool)`
- {{< check "ST1018" >}} no longer flags emoji sequences
- {{< check "ST1023" >}} no longer makes erroneous suggestions
- Numerous checks have a better understanding of integer literals and can detect mistakes involving unconventional
  literals such as `---1` instead of `-1`
- Some runtime crashes have been fixed
