// This file is generated by "./lib/proto/generate"

package proto

import (
	"github.com/ysmood/gson"
)

/*

Debugger

Debugger domain exposes JavaScript debugging capabilities. It allows setting and removing
breakpoints, stepping through execution, exploring stack traces, etc.

*/

// DebuggerBreakpointID Breakpoint identifier.
type DebuggerBreakpointID string

// DebuggerCallFrameID Call frame identifier.
type DebuggerCallFrameID string

// DebuggerLocation Location in the source code.
type DebuggerLocation struct {
	// ScriptID Script identifier as reported in the `Debugger.scriptParsed`.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// LineNumber Line number in the script (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber (optional) Column number in the script (0-based).
	ColumnNumber *int `json:"columnNumber,omitempty"`
}

// DebuggerScriptPosition (experimental) Location in the source code.
type DebuggerScriptPosition struct {
	// LineNumber ...
	LineNumber int `json:"lineNumber"`

	// ColumnNumber ...
	ColumnNumber int `json:"columnNumber"`
}

// DebuggerLocationRange (experimental) Location range within one script.
type DebuggerLocationRange struct {
	// ScriptID ...
	ScriptID RuntimeScriptID `json:"scriptId"`

	// Start ...
	Start *DebuggerScriptPosition `json:"start"`

	// End ...
	End *DebuggerScriptPosition `json:"end"`
}

// DebuggerCallFrame JavaScript call frame. Array of call frames form the call stack.
type DebuggerCallFrame struct {
	// CallFrameID Call frame identifier. This identifier is only valid while the virtual machine is paused.
	CallFrameID DebuggerCallFrameID `json:"callFrameId"`

	// FunctionName Name of the JavaScript function called on this call frame.
	FunctionName string `json:"functionName"`

	// FunctionLocation (optional) Location in the source code.
	FunctionLocation *DebuggerLocation `json:"functionLocation,omitempty"`

	// Location in the source code.
	Location *DebuggerLocation `json:"location"`

	// URL (deprecated) JavaScript script name or url.
	// Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously
	// sent `Debugger.scriptParsed` event.
	URL string `json:"url"`

	// ScopeChain Scope chain for this call frame.
	ScopeChain []*DebuggerScope `json:"scopeChain"`

	// This `this` object for this call frame.
	This *RuntimeRemoteObject `json:"this"`

	// ReturnValue (optional) The value being returned, if the function is at return point.
	ReturnValue *RuntimeRemoteObject `json:"returnValue,omitempty"`

	// CanBeRestarted (experimental) (optional) Valid only while the VM is paused and indicates whether this frame
	// can be restarted or not. Note that a `true` value here does not
	// guarantee that Debugger#restartFrame with this CallFrameId will be
	// successful, but it is very likely.
	CanBeRestarted bool `json:"canBeRestarted,omitempty"`
}

// DebuggerScopeType enum.
type DebuggerScopeType string

const (
	// DebuggerScopeTypeGlobal enum const.
	DebuggerScopeTypeGlobal DebuggerScopeType = "global"

	// DebuggerScopeTypeLocal enum const.
	DebuggerScopeTypeLocal DebuggerScopeType = "local"

	// DebuggerScopeTypeWith enum const.
	DebuggerScopeTypeWith DebuggerScopeType = "with"

	// DebuggerScopeTypeClosure enum const.
	DebuggerScopeTypeClosure DebuggerScopeType = "closure"

	// DebuggerScopeTypeCatch enum const.
	DebuggerScopeTypeCatch DebuggerScopeType = "catch"

	// DebuggerScopeTypeBlock enum const.
	DebuggerScopeTypeBlock DebuggerScopeType = "block"

	// DebuggerScopeTypeScript enum const.
	DebuggerScopeTypeScript DebuggerScopeType = "script"

	// DebuggerScopeTypeEval enum const.
	DebuggerScopeTypeEval DebuggerScopeType = "eval"

	// DebuggerScopeTypeModule enum const.
	DebuggerScopeTypeModule DebuggerScopeType = "module"

	// DebuggerScopeTypeWasmExpressionStack enum const.
	DebuggerScopeTypeWasmExpressionStack DebuggerScopeType = "wasm-expression-stack"
)

// DebuggerScope Scope description.
type DebuggerScope struct {
	// Type Scope type.
	Type DebuggerScopeType `json:"type"`

	// Object representing the scope. For `global` and `with` scopes it represents the actual
	// object; for the rest of the scopes, it is artificial transient object enumerating scope
	// variables as its properties.
	Object *RuntimeRemoteObject `json:"object"`

	// Name (optional) ...
	Name string `json:"name,omitempty"`

	// StartLocation (optional) Location in the source code where scope starts
	StartLocation *DebuggerLocation `json:"startLocation,omitempty"`

	// EndLocation (optional) Location in the source code where scope ends
	EndLocation *DebuggerLocation `json:"endLocation,omitempty"`
}

// DebuggerSearchMatch Search match for resource.
type DebuggerSearchMatch struct {
	// LineNumber Line number in resource content.
	LineNumber float64 `json:"lineNumber"`

	// LineContent Line with match content.
	LineContent string `json:"lineContent"`
}

// DebuggerBreakLocationType enum.
type DebuggerBreakLocationType string

const (
	// DebuggerBreakLocationTypeDebuggerStatement enum const.
	DebuggerBreakLocationTypeDebuggerStatement DebuggerBreakLocationType = "debuggerStatement"

	// DebuggerBreakLocationTypeCall enum const.
	DebuggerBreakLocationTypeCall DebuggerBreakLocationType = "call"

	// DebuggerBreakLocationTypeReturn enum const.
	DebuggerBreakLocationTypeReturn DebuggerBreakLocationType = "return"
)

// DebuggerBreakLocation ...
type DebuggerBreakLocation struct {
	// ScriptID Script identifier as reported in the `Debugger.scriptParsed`.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// LineNumber Line number in the script (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber (optional) Column number in the script (0-based).
	ColumnNumber *int `json:"columnNumber,omitempty"`

	// Type (optional) ...
	Type DebuggerBreakLocationType `json:"type,omitempty"`
}

// DebuggerWasmDisassemblyChunk (experimental) ...
type DebuggerWasmDisassemblyChunk struct {
	// Lines The next chunk of disassembled lines.
	Lines []string `json:"lines"`

	// BytecodeOffsets The bytecode offsets describing the start of each line.
	BytecodeOffsets []int `json:"bytecodeOffsets"`
}

// DebuggerScriptLanguage Enum of possible script languages.
type DebuggerScriptLanguage string

const (
	// DebuggerScriptLanguageJavaScript enum const.
	DebuggerScriptLanguageJavaScript DebuggerScriptLanguage = "JavaScript"

	// DebuggerScriptLanguageWebAssembly enum const.
	DebuggerScriptLanguageWebAssembly DebuggerScriptLanguage = "WebAssembly"
)

// DebuggerDebugSymbolsType enum.
type DebuggerDebugSymbolsType string

const (
	// DebuggerDebugSymbolsTypeNone enum const.
	DebuggerDebugSymbolsTypeNone DebuggerDebugSymbolsType = "None"

	// DebuggerDebugSymbolsTypeSourceMap enum const.
	DebuggerDebugSymbolsTypeSourceMap DebuggerDebugSymbolsType = "SourceMap"

	// DebuggerDebugSymbolsTypeEmbeddedDWARF enum const.
	DebuggerDebugSymbolsTypeEmbeddedDWARF DebuggerDebugSymbolsType = "EmbeddedDWARF"

	// DebuggerDebugSymbolsTypeExternalDWARF enum const.
	DebuggerDebugSymbolsTypeExternalDWARF DebuggerDebugSymbolsType = "ExternalDWARF"
)

// DebuggerDebugSymbols Debug symbols available for a wasm script.
type DebuggerDebugSymbols struct {
	// Type of the debug symbols.
	Type DebuggerDebugSymbolsType `json:"type"`

	// ExternalURL (optional) URL of the external symbol source.
	ExternalURL string `json:"externalURL,omitempty"`
}

// DebuggerContinueToLocationTargetCallFrames enum.
type DebuggerContinueToLocationTargetCallFrames string

const (
	// DebuggerContinueToLocationTargetCallFramesAny enum const.
	DebuggerContinueToLocationTargetCallFramesAny DebuggerContinueToLocationTargetCallFrames = "any"

	// DebuggerContinueToLocationTargetCallFramesCurrent enum const.
	DebuggerContinueToLocationTargetCallFramesCurrent DebuggerContinueToLocationTargetCallFrames = "current"
)

// DebuggerContinueToLocation Continues execution until specific location is reached.
type DebuggerContinueToLocation struct {
	// Location to continue to.
	Location *DebuggerLocation `json:"location"`

	// TargetCallFrames (optional) ...
	TargetCallFrames DebuggerContinueToLocationTargetCallFrames `json:"targetCallFrames,omitempty"`
}

// ProtoReq name.
func (m DebuggerContinueToLocation) ProtoReq() string { return "Debugger.continueToLocation" }

// Call sends the request.
func (m DebuggerContinueToLocation) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerDisable Disables debugger for given page.
type DebuggerDisable struct{}

// ProtoReq name.
func (m DebuggerDisable) ProtoReq() string { return "Debugger.disable" }

// Call sends the request.
func (m DebuggerDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerEnable Enables debugger for the given page. Clients should not assume that the debugging has been
// enabled until the result for this command is received.
type DebuggerEnable struct {
	// MaxScriptsCacheSize (experimental) (optional) The maximum size in bytes of collected scripts (not referenced by other heap objects)
	// the debugger can hold. Puts no limit if parameter is omitted.
	MaxScriptsCacheSize *float64 `json:"maxScriptsCacheSize,omitempty"`
}

// ProtoReq name.
func (m DebuggerEnable) ProtoReq() string { return "Debugger.enable" }

// Call the request.
func (m DebuggerEnable) Call(c Client) (*DebuggerEnableResult, error) {
	var res DebuggerEnableResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerEnableResult ...
type DebuggerEnableResult struct {
	// DebuggerID (experimental) Unique identifier of the debugger.
	DebuggerID RuntimeUniqueDebuggerID `json:"debuggerId"`
}

// DebuggerEvaluateOnCallFrame Evaluates expression on a given call frame.
type DebuggerEvaluateOnCallFrame struct {
	// CallFrameID Call frame identifier to evaluate on.
	CallFrameID DebuggerCallFrameID `json:"callFrameId"`

	// Expression to evaluate.
	Expression string `json:"expression"`

	// ObjectGroup (optional) String object group name to put result into (allows rapid releasing resulting object handles
	// using `releaseObjectGroup`).
	ObjectGroup string `json:"objectGroup,omitempty"`

	// IncludeCommandLineAPI (optional) Specifies whether command line API should be available to the evaluated expression, defaults
	// to false.
	IncludeCommandLineAPI bool `json:"includeCommandLineAPI,omitempty"`

	// Silent (optional) In silent mode exceptions thrown during evaluation are not reported and do not pause
	// execution. Overrides `setPauseOnException` state.
	Silent bool `json:"silent,omitempty"`

	// ReturnByValue (optional) Whether the result is expected to be a JSON object that should be sent by value.
	ReturnByValue bool `json:"returnByValue,omitempty"`

	// GeneratePreview (experimental) (optional) Whether preview should be generated for the result.
	GeneratePreview bool `json:"generatePreview,omitempty"`

	// ThrowOnSideEffect (optional) Whether to throw an exception if side effect cannot be ruled out during evaluation.
	ThrowOnSideEffect bool `json:"throwOnSideEffect,omitempty"`

	// Timeout (experimental) (optional) Terminate execution after timing out (number of milliseconds).
	Timeout RuntimeTimeDelta `json:"timeout,omitempty"`
}

// ProtoReq name.
func (m DebuggerEvaluateOnCallFrame) ProtoReq() string { return "Debugger.evaluateOnCallFrame" }

// Call the request.
func (m DebuggerEvaluateOnCallFrame) Call(c Client) (*DebuggerEvaluateOnCallFrameResult, error) {
	var res DebuggerEvaluateOnCallFrameResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerEvaluateOnCallFrameResult ...
type DebuggerEvaluateOnCallFrameResult struct {
	// Result Object wrapper for the evaluation result.
	Result *RuntimeRemoteObject `json:"result"`

	// ExceptionDetails (optional) Exception details.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// DebuggerGetPossibleBreakpoints Returns possible locations for breakpoint. scriptId in start and end range locations should be
// the same.
type DebuggerGetPossibleBreakpoints struct {
	// Start of range to search possible breakpoint locations in.
	Start *DebuggerLocation `json:"start"`

	// End (optional) End of range to search possible breakpoint locations in (excluding). When not specified, end
	// of scripts is used as end of range.
	End *DebuggerLocation `json:"end,omitempty"`

	// RestrictToFunction (optional) Only consider locations which are in the same (non-nested) function as start.
	RestrictToFunction bool `json:"restrictToFunction,omitempty"`
}

// ProtoReq name.
func (m DebuggerGetPossibleBreakpoints) ProtoReq() string { return "Debugger.getPossibleBreakpoints" }

// Call the request.
func (m DebuggerGetPossibleBreakpoints) Call(c Client) (*DebuggerGetPossibleBreakpointsResult, error) {
	var res DebuggerGetPossibleBreakpointsResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerGetPossibleBreakpointsResult ...
type DebuggerGetPossibleBreakpointsResult struct {
	// Locations List of the possible breakpoint locations.
	Locations []*DebuggerBreakLocation `json:"locations"`
}

// DebuggerGetScriptSource Returns source for the script with given id.
type DebuggerGetScriptSource struct {
	// ScriptID Id of the script to get source for.
	ScriptID RuntimeScriptID `json:"scriptId"`
}

// ProtoReq name.
func (m DebuggerGetScriptSource) ProtoReq() string { return "Debugger.getScriptSource" }

// Call the request.
func (m DebuggerGetScriptSource) Call(c Client) (*DebuggerGetScriptSourceResult, error) {
	var res DebuggerGetScriptSourceResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerGetScriptSourceResult ...
type DebuggerGetScriptSourceResult struct {
	// ScriptSource Script source (empty in case of Wasm bytecode).
	ScriptSource string `json:"scriptSource"`

	// Bytecode (optional) Wasm bytecode.
	Bytecode []byte `json:"bytecode,omitempty"`
}

// DebuggerDisassembleWasmModule (experimental) ...
type DebuggerDisassembleWasmModule struct {
	// ScriptID Id of the script to disassemble
	ScriptID RuntimeScriptID `json:"scriptId"`
}

// ProtoReq name.
func (m DebuggerDisassembleWasmModule) ProtoReq() string { return "Debugger.disassembleWasmModule" }

// Call the request.
func (m DebuggerDisassembleWasmModule) Call(c Client) (*DebuggerDisassembleWasmModuleResult, error) {
	var res DebuggerDisassembleWasmModuleResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerDisassembleWasmModuleResult (experimental) ...
type DebuggerDisassembleWasmModuleResult struct {
	// StreamID (optional) For large modules, return a stream from which additional chunks of
	// disassembly can be read successively.
	StreamID string `json:"streamId,omitempty"`

	// TotalNumberOfLines The total number of lines in the disassembly text.
	TotalNumberOfLines int `json:"totalNumberOfLines"`

	// FunctionBodyOffsets The offsets of all function bodies, in the format [start1, end1,
	// start2, end2, ...] where all ends are exclusive.
	FunctionBodyOffsets []int `json:"functionBodyOffsets"`

	// Chunk The first chunk of disassembly.
	Chunk *DebuggerWasmDisassemblyChunk `json:"chunk"`
}

// DebuggerNextWasmDisassemblyChunk (experimental) Disassemble the next chunk of lines for the module corresponding to the
// stream. If disassembly is complete, this API will invalidate the streamId
// and return an empty chunk. Any subsequent calls for the now invalid stream
// will return errors.
type DebuggerNextWasmDisassemblyChunk struct {
	// StreamID ...
	StreamID string `json:"streamId"`
}

// ProtoReq name.
func (m DebuggerNextWasmDisassemblyChunk) ProtoReq() string {
	return "Debugger.nextWasmDisassemblyChunk"
}

// Call the request.
func (m DebuggerNextWasmDisassemblyChunk) Call(c Client) (*DebuggerNextWasmDisassemblyChunkResult, error) {
	var res DebuggerNextWasmDisassemblyChunkResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerNextWasmDisassemblyChunkResult (experimental) ...
type DebuggerNextWasmDisassemblyChunkResult struct {
	// Chunk The next chunk of disassembly.
	Chunk *DebuggerWasmDisassemblyChunk `json:"chunk"`
}

// DebuggerGetWasmBytecode (deprecated) This command is deprecated. Use getScriptSource instead.
type DebuggerGetWasmBytecode struct {
	// ScriptID Id of the Wasm script to get source for.
	ScriptID RuntimeScriptID `json:"scriptId"`
}

// ProtoReq name.
func (m DebuggerGetWasmBytecode) ProtoReq() string { return "Debugger.getWasmBytecode" }

// Call the request.
func (m DebuggerGetWasmBytecode) Call(c Client) (*DebuggerGetWasmBytecodeResult, error) {
	var res DebuggerGetWasmBytecodeResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerGetWasmBytecodeResult (deprecated) ...
type DebuggerGetWasmBytecodeResult struct {
	// Bytecode Script source.
	Bytecode []byte `json:"bytecode"`
}

// DebuggerGetStackTrace (experimental) Returns stack trace with given `stackTraceId`.
type DebuggerGetStackTrace struct {
	// StackTraceID ...
	StackTraceID *RuntimeStackTraceID `json:"stackTraceId"`
}

// ProtoReq name.
func (m DebuggerGetStackTrace) ProtoReq() string { return "Debugger.getStackTrace" }

// Call the request.
func (m DebuggerGetStackTrace) Call(c Client) (*DebuggerGetStackTraceResult, error) {
	var res DebuggerGetStackTraceResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerGetStackTraceResult (experimental) ...
type DebuggerGetStackTraceResult struct {
	// StackTrace ...
	StackTrace *RuntimeStackTrace `json:"stackTrace"`
}

// DebuggerPause Stops on the next JavaScript statement.
type DebuggerPause struct{}

// ProtoReq name.
func (m DebuggerPause) ProtoReq() string { return "Debugger.pause" }

// Call sends the request.
func (m DebuggerPause) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerPauseOnAsyncCall (deprecated) (experimental) ...
type DebuggerPauseOnAsyncCall struct {
	// ParentStackTraceID Debugger will pause when async call with given stack trace is started.
	ParentStackTraceID *RuntimeStackTraceID `json:"parentStackTraceId"`
}

// ProtoReq name.
func (m DebuggerPauseOnAsyncCall) ProtoReq() string { return "Debugger.pauseOnAsyncCall" }

// Call sends the request.
func (m DebuggerPauseOnAsyncCall) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerRemoveBreakpoint Removes JavaScript breakpoint.
type DebuggerRemoveBreakpoint struct {
	// BreakpointID ...
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`
}

// ProtoReq name.
func (m DebuggerRemoveBreakpoint) ProtoReq() string { return "Debugger.removeBreakpoint" }

// Call sends the request.
func (m DebuggerRemoveBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerRestartFrameMode enum.
type DebuggerRestartFrameMode string

const (
	// DebuggerRestartFrameModeStepInto enum const.
	DebuggerRestartFrameModeStepInto DebuggerRestartFrameMode = "StepInto"
)

// DebuggerRestartFrame Restarts particular call frame from the beginning. The old, deprecated
// behavior of `restartFrame` is to stay paused and allow further CDP commands
// after a restart was scheduled. This can cause problems with restarting, so
// we now continue execution immediately after it has been scheduled until we
// reach the beginning of the restarted frame.
//
// To stay back-wards compatible, `restartFrame` now expects a `mode`
// parameter to be present. If the `mode` parameter is missing, `restartFrame`
// errors out.
//
// The various return values are deprecated and `callFrames` is always empty.
// Use the call frames from the `Debugger#paused` events instead, that fires
// once V8 pauses at the beginning of the restarted function.
type DebuggerRestartFrame struct {
	// CallFrameID Call frame identifier to evaluate on.
	CallFrameID DebuggerCallFrameID `json:"callFrameId"`

	// Mode (experimental) (optional) The `mode` parameter must be present and set to 'StepInto', otherwise
	// `restartFrame` will error out.
	Mode DebuggerRestartFrameMode `json:"mode,omitempty"`
}

// ProtoReq name.
func (m DebuggerRestartFrame) ProtoReq() string { return "Debugger.restartFrame" }

// Call the request.
func (m DebuggerRestartFrame) Call(c Client) (*DebuggerRestartFrameResult, error) {
	var res DebuggerRestartFrameResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerRestartFrameResult ...
type DebuggerRestartFrameResult struct {
	// CallFrames (deprecated) New stack trace.
	CallFrames []*DebuggerCallFrame `json:"callFrames"`

	// AsyncStackTrace (deprecated) (optional) Async stack trace, if any.
	AsyncStackTrace *RuntimeStackTrace `json:"asyncStackTrace,omitempty"`

	// AsyncStackTraceID (deprecated) (optional) Async stack trace, if any.
	AsyncStackTraceID *RuntimeStackTraceID `json:"asyncStackTraceId,omitempty"`
}

// DebuggerResume Resumes JavaScript execution.
type DebuggerResume struct {
	// TerminateOnResume (optional) Set to true to terminate execution upon resuming execution. In contrast
	// to Runtime.terminateExecution, this will allows to execute further
	// JavaScript (i.e. via evaluation) until execution of the paused code
	// is actually resumed, at which point termination is triggered.
	// If execution is currently not paused, this parameter has no effect.
	TerminateOnResume bool `json:"terminateOnResume,omitempty"`
}

// ProtoReq name.
func (m DebuggerResume) ProtoReq() string { return "Debugger.resume" }

// Call sends the request.
func (m DebuggerResume) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSearchInContent Searches for given string in script content.
type DebuggerSearchInContent struct {
	// ScriptID Id of the script to search in.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// Query String to search for.
	Query string `json:"query"`

	// CaseSensitive (optional) If true, search is case sensitive.
	CaseSensitive bool `json:"caseSensitive,omitempty"`

	// IsRegex (optional) If true, treats string parameter as regex.
	IsRegex bool `json:"isRegex,omitempty"`
}

// ProtoReq name.
func (m DebuggerSearchInContent) ProtoReq() string { return "Debugger.searchInContent" }

// Call the request.
func (m DebuggerSearchInContent) Call(c Client) (*DebuggerSearchInContentResult, error) {
	var res DebuggerSearchInContentResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSearchInContentResult ...
type DebuggerSearchInContentResult struct {
	// Result List of search matches.
	Result []*DebuggerSearchMatch `json:"result"`
}

// DebuggerSetAsyncCallStackDepth Enables or disables async call stacks tracking.
type DebuggerSetAsyncCallStackDepth struct {
	// MaxDepth Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async
	// call stacks (default).
	MaxDepth int `json:"maxDepth"`
}

// ProtoReq name.
func (m DebuggerSetAsyncCallStackDepth) ProtoReq() string { return "Debugger.setAsyncCallStackDepth" }

// Call sends the request.
func (m DebuggerSetAsyncCallStackDepth) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetBlackboxPatterns (experimental) Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in
// scripts with url matching one of the patterns. VM will try to leave blackboxed script by
// performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
type DebuggerSetBlackboxPatterns struct {
	// Patterns Array of regexps that will be used to check script url for blackbox state.
	Patterns []string `json:"patterns"`
}

// ProtoReq name.
func (m DebuggerSetBlackboxPatterns) ProtoReq() string { return "Debugger.setBlackboxPatterns" }

// Call sends the request.
func (m DebuggerSetBlackboxPatterns) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetBlackboxedRanges (experimental) Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted
// scripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
// Positions array contains positions where blackbox state is changed. First interval isn't
// blackboxed. Array should be sorted.
type DebuggerSetBlackboxedRanges struct {
	// ScriptID Id of the script.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// Positions ...
	Positions []*DebuggerScriptPosition `json:"positions"`
}

// ProtoReq name.
func (m DebuggerSetBlackboxedRanges) ProtoReq() string { return "Debugger.setBlackboxedRanges" }

// Call sends the request.
func (m DebuggerSetBlackboxedRanges) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetBreakpoint Sets JavaScript breakpoint at a given location.
type DebuggerSetBreakpoint struct {
	// Location to set breakpoint in.
	Location *DebuggerLocation `json:"location"`

	// Condition (optional) Expression to use as a breakpoint condition. When specified, debugger will only stop on the
	// breakpoint if this expression evaluates to true.
	Condition string `json:"condition,omitempty"`
}

// ProtoReq name.
func (m DebuggerSetBreakpoint) ProtoReq() string { return "Debugger.setBreakpoint" }

// Call the request.
func (m DebuggerSetBreakpoint) Call(c Client) (*DebuggerSetBreakpointResult, error) {
	var res DebuggerSetBreakpointResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSetBreakpointResult ...
type DebuggerSetBreakpointResult struct {
	// BreakpointID Id of the created breakpoint for further reference.
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`

	// ActualLocation Location this breakpoint resolved into.
	ActualLocation *DebuggerLocation `json:"actualLocation"`
}

// DebuggerSetInstrumentationBreakpointInstrumentation enum.
type DebuggerSetInstrumentationBreakpointInstrumentation string

const (
	// DebuggerSetInstrumentationBreakpointInstrumentationBeforeScriptExecution enum const.
	DebuggerSetInstrumentationBreakpointInstrumentationBeforeScriptExecution DebuggerSetInstrumentationBreakpointInstrumentation = "beforeScriptExecution"

	// DebuggerSetInstrumentationBreakpointInstrumentationBeforeScriptWithSourceMapExecution enum const.
	DebuggerSetInstrumentationBreakpointInstrumentationBeforeScriptWithSourceMapExecution DebuggerSetInstrumentationBreakpointInstrumentation = "beforeScriptWithSourceMapExecution"
)

// DebuggerSetInstrumentationBreakpoint Sets instrumentation breakpoint.
type DebuggerSetInstrumentationBreakpoint struct {
	// Instrumentation name.
	Instrumentation DebuggerSetInstrumentationBreakpointInstrumentation `json:"instrumentation"`
}

// ProtoReq name.
func (m DebuggerSetInstrumentationBreakpoint) ProtoReq() string {
	return "Debugger.setInstrumentationBreakpoint"
}

// Call the request.
func (m DebuggerSetInstrumentationBreakpoint) Call(c Client) (*DebuggerSetInstrumentationBreakpointResult, error) {
	var res DebuggerSetInstrumentationBreakpointResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSetInstrumentationBreakpointResult ...
type DebuggerSetInstrumentationBreakpointResult struct {
	// BreakpointID Id of the created breakpoint for further reference.
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`
}

// DebuggerSetBreakpointByURL Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this
// command is issued, all existing parsed scripts will have breakpoints resolved and returned in
// `locations` property. Further matching script parsing will result in subsequent
// `breakpointResolved` events issued. This logical breakpoint will survive page reloads.
type DebuggerSetBreakpointByURL struct {
	// LineNumber Line number to set breakpoint at.
	LineNumber int `json:"lineNumber"`

	// URL (optional) URL of the resources to set breakpoint on.
	URL string `json:"url,omitempty"`

	// URLRegex (optional) Regex pattern for the URLs of the resources to set breakpoints on. Either `url` or
	// `urlRegex` must be specified.
	URLRegex string `json:"urlRegex,omitempty"`

	// ScriptHash (optional) Script hash of the resources to set breakpoint on.
	ScriptHash string `json:"scriptHash,omitempty"`

	// ColumnNumber (optional) Offset in the line to set breakpoint at.
	ColumnNumber *int `json:"columnNumber,omitempty"`

	// Condition (optional) Expression to use as a breakpoint condition. When specified, debugger will only stop on the
	// breakpoint if this expression evaluates to true.
	Condition string `json:"condition,omitempty"`
}

// ProtoReq name.
func (m DebuggerSetBreakpointByURL) ProtoReq() string { return "Debugger.setBreakpointByUrl" }

// Call the request.
func (m DebuggerSetBreakpointByURL) Call(c Client) (*DebuggerSetBreakpointByURLResult, error) {
	var res DebuggerSetBreakpointByURLResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSetBreakpointByURLResult ...
type DebuggerSetBreakpointByURLResult struct {
	// BreakpointID Id of the created breakpoint for further reference.
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`

	// Locations List of the locations this breakpoint resolved into upon addition.
	Locations []*DebuggerLocation `json:"locations"`
}

// DebuggerSetBreakpointOnFunctionCall (experimental) Sets JavaScript breakpoint before each call to the given function.
// If another function was created from the same source as a given one,
// calling it will also trigger the breakpoint.
type DebuggerSetBreakpointOnFunctionCall struct {
	// ObjectID Function object id.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`

	// Condition (optional) Expression to use as a breakpoint condition. When specified, debugger will
	// stop on the breakpoint if this expression evaluates to true.
	Condition string `json:"condition,omitempty"`
}

// ProtoReq name.
func (m DebuggerSetBreakpointOnFunctionCall) ProtoReq() string {
	return "Debugger.setBreakpointOnFunctionCall"
}

// Call the request.
func (m DebuggerSetBreakpointOnFunctionCall) Call(c Client) (*DebuggerSetBreakpointOnFunctionCallResult, error) {
	var res DebuggerSetBreakpointOnFunctionCallResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSetBreakpointOnFunctionCallResult (experimental) ...
type DebuggerSetBreakpointOnFunctionCallResult struct {
	// BreakpointID Id of the created breakpoint for further reference.
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`
}

// DebuggerSetBreakpointsActive Activates / deactivates all breakpoints on the page.
type DebuggerSetBreakpointsActive struct {
	// Active New value for breakpoints active state.
	Active bool `json:"active"`
}

// ProtoReq name.
func (m DebuggerSetBreakpointsActive) ProtoReq() string { return "Debugger.setBreakpointsActive" }

// Call sends the request.
func (m DebuggerSetBreakpointsActive) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetPauseOnExceptionsState enum.
type DebuggerSetPauseOnExceptionsState string

const (
	// DebuggerSetPauseOnExceptionsStateNone enum const.
	DebuggerSetPauseOnExceptionsStateNone DebuggerSetPauseOnExceptionsState = "none"

	// DebuggerSetPauseOnExceptionsStateCaught enum const.
	DebuggerSetPauseOnExceptionsStateCaught DebuggerSetPauseOnExceptionsState = "caught"

	// DebuggerSetPauseOnExceptionsStateUncaught enum const.
	DebuggerSetPauseOnExceptionsStateUncaught DebuggerSetPauseOnExceptionsState = "uncaught"

	// DebuggerSetPauseOnExceptionsStateAll enum const.
	DebuggerSetPauseOnExceptionsStateAll DebuggerSetPauseOnExceptionsState = "all"
)

// DebuggerSetPauseOnExceptions Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions,
// or caught exceptions, no exceptions. Initial pause on exceptions state is `none`.
type DebuggerSetPauseOnExceptions struct {
	// State Pause on exceptions mode.
	State DebuggerSetPauseOnExceptionsState `json:"state"`
}

// ProtoReq name.
func (m DebuggerSetPauseOnExceptions) ProtoReq() string { return "Debugger.setPauseOnExceptions" }

// Call sends the request.
func (m DebuggerSetPauseOnExceptions) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetReturnValue (experimental) Changes return value in top frame. Available only at return break position.
type DebuggerSetReturnValue struct {
	// NewValue New return value.
	NewValue *RuntimeCallArgument `json:"newValue"`
}

// ProtoReq name.
func (m DebuggerSetReturnValue) ProtoReq() string { return "Debugger.setReturnValue" }

// Call sends the request.
func (m DebuggerSetReturnValue) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetScriptSource Edits JavaScript source live.
//
// In general, functions that are currently on the stack can not be edited with
// a single exception: If the edited function is the top-most stack frame and
// that is the only activation of that function on the stack. In this case
// the live edit will be successful and a `Debugger.restartFrame` for the
// top-most function is automatically triggered.
type DebuggerSetScriptSource struct {
	// ScriptID Id of the script to edit.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// ScriptSource New content of the script.
	ScriptSource string `json:"scriptSource"`

	// DryRun (optional) If true the change will not actually be applied. Dry run may be used to get result
	// description without actually modifying the code.
	DryRun bool `json:"dryRun,omitempty"`

	// AllowTopFrameEditing (experimental) (optional) If true, then `scriptSource` is allowed to change the function on top of the stack
	// as long as the top-most stack frame is the only activation of that function.
	AllowTopFrameEditing bool `json:"allowTopFrameEditing,omitempty"`
}

// ProtoReq name.
func (m DebuggerSetScriptSource) ProtoReq() string { return "Debugger.setScriptSource" }

// Call the request.
func (m DebuggerSetScriptSource) Call(c Client) (*DebuggerSetScriptSourceResult, error) {
	var res DebuggerSetScriptSourceResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DebuggerSetScriptSourceResultStatus enum.
type DebuggerSetScriptSourceResultStatus string

const (
	// DebuggerSetScriptSourceResultStatusOk enum const.
	DebuggerSetScriptSourceResultStatusOk DebuggerSetScriptSourceResultStatus = "Ok"

	// DebuggerSetScriptSourceResultStatusCompileError enum const.
	DebuggerSetScriptSourceResultStatusCompileError DebuggerSetScriptSourceResultStatus = "CompileError"

	// DebuggerSetScriptSourceResultStatusBlockedByActiveGenerator enum const.
	DebuggerSetScriptSourceResultStatusBlockedByActiveGenerator DebuggerSetScriptSourceResultStatus = "BlockedByActiveGenerator"

	// DebuggerSetScriptSourceResultStatusBlockedByActiveFunction enum const.
	DebuggerSetScriptSourceResultStatusBlockedByActiveFunction DebuggerSetScriptSourceResultStatus = "BlockedByActiveFunction"

	// DebuggerSetScriptSourceResultStatusBlockedByTopLevelEsModuleChange enum const.
	DebuggerSetScriptSourceResultStatusBlockedByTopLevelEsModuleChange DebuggerSetScriptSourceResultStatus = "BlockedByTopLevelEsModuleChange"
)

// DebuggerSetScriptSourceResult ...
type DebuggerSetScriptSourceResult struct {
	// CallFrames (deprecated) (optional) New stack trace in case editing has happened while VM was stopped.
	CallFrames []*DebuggerCallFrame `json:"callFrames,omitempty"`

	// StackChanged (deprecated) (optional) Whether current call stack  was modified after applying the changes.
	StackChanged bool `json:"stackChanged,omitempty"`

	// AsyncStackTrace (deprecated) (optional) Async stack trace, if any.
	AsyncStackTrace *RuntimeStackTrace `json:"asyncStackTrace,omitempty"`

	// AsyncStackTraceID (deprecated) (optional) Async stack trace, if any.
	AsyncStackTraceID *RuntimeStackTraceID `json:"asyncStackTraceId,omitempty"`

	// Status (experimental) Whether the operation was successful or not. Only `Ok` denotes a
	// successful live edit while the other enum variants denote why
	// the live edit failed.
	Status DebuggerSetScriptSourceResultStatus `json:"status"`

	// ExceptionDetails (optional) Exception details if any. Only present when `status` is `CompileError`.
	ExceptionDetails *RuntimeExceptionDetails `json:"exceptionDetails,omitempty"`
}

// DebuggerSetSkipAllPauses Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).
type DebuggerSetSkipAllPauses struct {
	// Skip New value for skip pauses state.
	Skip bool `json:"skip"`
}

// ProtoReq name.
func (m DebuggerSetSkipAllPauses) ProtoReq() string { return "Debugger.setSkipAllPauses" }

// Call sends the request.
func (m DebuggerSetSkipAllPauses) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerSetVariableValue Changes value of variable in a callframe. Object-based scopes are not supported and must be
// mutated manually.
type DebuggerSetVariableValue struct {
	// ScopeNumber 0-based number of scope as was listed in scope chain. Only 'local', 'closure' and 'catch'
	// scope types are allowed. Other scopes could be manipulated manually.
	ScopeNumber int `json:"scopeNumber"`

	// VariableName Variable name.
	VariableName string `json:"variableName"`

	// NewValue New variable value.
	NewValue *RuntimeCallArgument `json:"newValue"`

	// CallFrameID Id of callframe that holds variable.
	CallFrameID DebuggerCallFrameID `json:"callFrameId"`
}

// ProtoReq name.
func (m DebuggerSetVariableValue) ProtoReq() string { return "Debugger.setVariableValue" }

// Call sends the request.
func (m DebuggerSetVariableValue) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerStepInto Steps into the function call.
type DebuggerStepInto struct {
	// BreakOnAsyncCall (experimental) (optional) Debugger will pause on the execution of the first async task which was scheduled
	// before next pause.
	BreakOnAsyncCall bool `json:"breakOnAsyncCall,omitempty"`

	// SkipList (experimental) (optional) The skipList specifies location ranges that should be skipped on step into.
	SkipList []*DebuggerLocationRange `json:"skipList,omitempty"`
}

// ProtoReq name.
func (m DebuggerStepInto) ProtoReq() string { return "Debugger.stepInto" }

// Call sends the request.
func (m DebuggerStepInto) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerStepOut Steps out of the function call.
type DebuggerStepOut struct{}

// ProtoReq name.
func (m DebuggerStepOut) ProtoReq() string { return "Debugger.stepOut" }

// Call sends the request.
func (m DebuggerStepOut) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerStepOver Steps over the statement.
type DebuggerStepOver struct {
	// SkipList (experimental) (optional) The skipList specifies location ranges that should be skipped on step over.
	SkipList []*DebuggerLocationRange `json:"skipList,omitempty"`
}

// ProtoReq name.
func (m DebuggerStepOver) ProtoReq() string { return "Debugger.stepOver" }

// Call sends the request.
func (m DebuggerStepOver) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DebuggerBreakpointResolved Fired when breakpoint is resolved to an actual script and location.
type DebuggerBreakpointResolved struct {
	// BreakpointID Breakpoint unique identifier.
	BreakpointID DebuggerBreakpointID `json:"breakpointId"`

	// Location Actual breakpoint location.
	Location *DebuggerLocation `json:"location"`
}

// ProtoEvent name.
func (evt DebuggerBreakpointResolved) ProtoEvent() string {
	return "Debugger.breakpointResolved"
}

// DebuggerPausedReason enum.
type DebuggerPausedReason string

const (
	// DebuggerPausedReasonAmbiguous enum const.
	DebuggerPausedReasonAmbiguous DebuggerPausedReason = "ambiguous"

	// DebuggerPausedReasonAssert enum const.
	DebuggerPausedReasonAssert DebuggerPausedReason = "assert"

	// DebuggerPausedReasonCSPViolation enum const.
	DebuggerPausedReasonCSPViolation DebuggerPausedReason = "CSPViolation"

	// DebuggerPausedReasonDebugCommand enum const.
	DebuggerPausedReasonDebugCommand DebuggerPausedReason = "debugCommand"

	// DebuggerPausedReasonDOM enum const.
	DebuggerPausedReasonDOM DebuggerPausedReason = "DOM"

	// DebuggerPausedReasonEventListener enum const.
	DebuggerPausedReasonEventListener DebuggerPausedReason = "EventListener"

	// DebuggerPausedReasonException enum const.
	DebuggerPausedReasonException DebuggerPausedReason = "exception"

	// DebuggerPausedReasonInstrumentation enum const.
	DebuggerPausedReasonInstrumentation DebuggerPausedReason = "instrumentation"

	// DebuggerPausedReasonOOM enum const.
	DebuggerPausedReasonOOM DebuggerPausedReason = "OOM"

	// DebuggerPausedReasonOther enum const.
	DebuggerPausedReasonOther DebuggerPausedReason = "other"

	// DebuggerPausedReasonPromiseRejection enum const.
	DebuggerPausedReasonPromiseRejection DebuggerPausedReason = "promiseRejection"

	// DebuggerPausedReasonXHR enum const.
	DebuggerPausedReasonXHR DebuggerPausedReason = "XHR"

	// DebuggerPausedReasonStep enum const.
	DebuggerPausedReasonStep DebuggerPausedReason = "step"
)

// DebuggerPaused Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
type DebuggerPaused struct {
	// CallFrames Call stack the virtual machine stopped on.
	CallFrames []*DebuggerCallFrame `json:"callFrames"`

	// Reason Pause reason.
	Reason DebuggerPausedReason `json:"reason"`

	// Data (optional) Object containing break-specific auxiliary properties.
	Data map[string]gson.JSON `json:"data,omitempty"`

	// HitBreakpoints (optional) Hit breakpoints IDs
	HitBreakpoints []string `json:"hitBreakpoints,omitempty"`

	// AsyncStackTrace (optional) Async stack trace, if any.
	AsyncStackTrace *RuntimeStackTrace `json:"asyncStackTrace,omitempty"`

	// AsyncStackTraceID (experimental) (optional) Async stack trace, if any.
	AsyncStackTraceID *RuntimeStackTraceID `json:"asyncStackTraceId,omitempty"`

	// AsyncCallStackTraceID (deprecated) (experimental) (optional) Never present, will be removed.
	AsyncCallStackTraceID *RuntimeStackTraceID `json:"asyncCallStackTraceId,omitempty"`
}

// ProtoEvent name.
func (evt DebuggerPaused) ProtoEvent() string {
	return "Debugger.paused"
}

// DebuggerResumed Fired when the virtual machine resumed execution.
type DebuggerResumed struct{}

// ProtoEvent name.
func (evt DebuggerResumed) ProtoEvent() string {
	return "Debugger.resumed"
}

// DebuggerScriptFailedToParse Fired when virtual machine fails to parse the script.
type DebuggerScriptFailedToParse struct {
	// ScriptID Identifier of the script parsed.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// URL or name of the script parsed (if any).
	URL string `json:"url"`

	// StartLine Line offset of the script within the resource with given URL (for script tags).
	StartLine int `json:"startLine"`

	// StartColumn Column offset of the script within the resource with given URL.
	StartColumn int `json:"startColumn"`

	// EndLine Last line of the script.
	EndLine int `json:"endLine"`

	// EndColumn Length of the last line of the script.
	EndColumn int `json:"endColumn"`

	// ExecutionContextID Specifies script creation context.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`

	// Hash Content hash of the script, SHA-256.
	Hash string `json:"hash"`

	// ExecutionContextAuxData (optional) Embedder-specific auxiliary data.
	ExecutionContextAuxData map[string]gson.JSON `json:"executionContextAuxData,omitempty"`

	// SourceMapURL (optional) URL of source map associated with script (if any).
	SourceMapURL string `json:"sourceMapURL,omitempty"`

	// HasSourceURL (optional) True, if this script has sourceURL.
	HasSourceURL bool `json:"hasSourceURL,omitempty"`

	// IsModule (optional) True, if this script is ES6 module.
	IsModule bool `json:"isModule,omitempty"`

	// Length (optional) This script length.
	Length *int `json:"length,omitempty"`

	// StackTrace (experimental) (optional) JavaScript top stack frame of where the script parsed event was triggered if available.
	StackTrace *RuntimeStackTrace `json:"stackTrace,omitempty"`

	// CodeOffset (experimental) (optional) If the scriptLanguage is WebAssembly, the code section offset in the module.
	CodeOffset *int `json:"codeOffset,omitempty"`

	// ScriptLanguage (experimental) (optional) The language of the script.
	ScriptLanguage DebuggerScriptLanguage `json:"scriptLanguage,omitempty"`

	// EmbedderName (experimental) (optional) The name the embedder supplied for this script.
	EmbedderName string `json:"embedderName,omitempty"`
}

// ProtoEvent name.
func (evt DebuggerScriptFailedToParse) ProtoEvent() string {
	return "Debugger.scriptFailedToParse"
}

// DebuggerScriptParsed Fired when virtual machine parses script. This event is also fired for all known and uncollected
// scripts upon enabling debugger.
type DebuggerScriptParsed struct {
	// ScriptID Identifier of the script parsed.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// URL or name of the script parsed (if any).
	URL string `json:"url"`

	// StartLine Line offset of the script within the resource with given URL (for script tags).
	StartLine int `json:"startLine"`

	// StartColumn Column offset of the script within the resource with given URL.
	StartColumn int `json:"startColumn"`

	// EndLine Last line of the script.
	EndLine int `json:"endLine"`

	// EndColumn Length of the last line of the script.
	EndColumn int `json:"endColumn"`

	// ExecutionContextID Specifies script creation context.
	ExecutionContextID RuntimeExecutionContextID `json:"executionContextId"`

	// Hash Content hash of the script, SHA-256.
	Hash string `json:"hash"`

	// ExecutionContextAuxData (optional) Embedder-specific auxiliary data.
	ExecutionContextAuxData map[string]gson.JSON `json:"executionContextAuxData,omitempty"`

	// IsLiveEdit (experimental) (optional) True, if this script is generated as a result of the live edit operation.
	IsLiveEdit bool `json:"isLiveEdit,omitempty"`

	// SourceMapURL (optional) URL of source map associated with script (if any).
	SourceMapURL string `json:"sourceMapURL,omitempty"`

	// HasSourceURL (optional) True, if this script has sourceURL.
	HasSourceURL bool `json:"hasSourceURL,omitempty"`

	// IsModule (optional) True, if this script is ES6 module.
	IsModule bool `json:"isModule,omitempty"`

	// Length (optional) This script length.
	Length *int `json:"length,omitempty"`

	// StackTrace (experimental) (optional) JavaScript top stack frame of where the script parsed event was triggered if available.
	StackTrace *RuntimeStackTrace `json:"stackTrace,omitempty"`

	// CodeOffset (experimental) (optional) If the scriptLanguage is WebAssembly, the code section offset in the module.
	CodeOffset *int `json:"codeOffset,omitempty"`

	// ScriptLanguage (experimental) (optional) The language of the script.
	ScriptLanguage DebuggerScriptLanguage `json:"scriptLanguage,omitempty"`

	// DebugSymbols (experimental) (optional) If the scriptLanguage is WebASsembly, the source of debug symbols for the module.
	DebugSymbols *DebuggerDebugSymbols `json:"debugSymbols,omitempty"`

	// EmbedderName (experimental) (optional) The name the embedder supplied for this script.
	EmbedderName string `json:"embedderName,omitempty"`
}

// ProtoEvent name.
func (evt DebuggerScriptParsed) ProtoEvent() string {
	return "Debugger.scriptParsed"
}
