// This file is generated by "./lib/proto/generate"

package proto

/*

Audits

Audits domain allows investigation of page violations and possible improvements.

*/

// AuditsAffectedCookie Information about a cookie that is affected by an inspector issue.
type AuditsAffectedCookie struct {

	// Name The following three properties uniquely identify a cookie
	Name string `json:"name"`

	// Path ...
	Path string `json:"path"`

	// Domain ...
	Domain string `json:"domain"`
}

// AuditsAffectedRequest Information about a request that is affected by an inspector issue.
type AuditsAffectedRequest struct {

	// RequestID The unique request id.
	RequestID NetworkRequestID `json:"requestId"`

	// URL (optional) ...
	URL string `json:"url,omitempty"`
}

// AuditsAffectedFrame Information about the frame affected by an inspector issue.
type AuditsAffectedFrame struct {

	// FrameID ...
	FrameID PageFrameID `json:"frameId"`
}

// AuditsCookieExclusionReason ...
type AuditsCookieExclusionReason string

const (
	// AuditsCookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax enum const
	AuditsCookieExclusionReasonExcludeSameSiteUnspecifiedTreatedAsLax AuditsCookieExclusionReason = "ExcludeSameSiteUnspecifiedTreatedAsLax"

	// AuditsCookieExclusionReasonExcludeSameSiteNoneInsecure enum const
	AuditsCookieExclusionReasonExcludeSameSiteNoneInsecure AuditsCookieExclusionReason = "ExcludeSameSiteNoneInsecure"

	// AuditsCookieExclusionReasonExcludeSameSiteLax enum const
	AuditsCookieExclusionReasonExcludeSameSiteLax AuditsCookieExclusionReason = "ExcludeSameSiteLax"

	// AuditsCookieExclusionReasonExcludeSameSiteStrict enum const
	AuditsCookieExclusionReasonExcludeSameSiteStrict AuditsCookieExclusionReason = "ExcludeSameSiteStrict"

	// AuditsCookieExclusionReasonExcludeInvalidSameParty enum const
	AuditsCookieExclusionReasonExcludeInvalidSameParty AuditsCookieExclusionReason = "ExcludeInvalidSameParty"

	// AuditsCookieExclusionReasonExcludeSamePartyCrossPartyContext enum const
	AuditsCookieExclusionReasonExcludeSamePartyCrossPartyContext AuditsCookieExclusionReason = "ExcludeSamePartyCrossPartyContext"

	// AuditsCookieExclusionReasonExcludeDomainNonASCII enum const
	AuditsCookieExclusionReasonExcludeDomainNonASCII AuditsCookieExclusionReason = "ExcludeDomainNonASCII"

	// AuditsCookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet enum const
	AuditsCookieExclusionReasonExcludeThirdPartyCookieBlockedInFirstPartySet AuditsCookieExclusionReason = "ExcludeThirdPartyCookieBlockedInFirstPartySet"
)

// AuditsCookieWarningReason ...
type AuditsCookieWarningReason string

const (
	// AuditsCookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext enum const
	AuditsCookieWarningReasonWarnSameSiteUnspecifiedCrossSiteContext AuditsCookieWarningReason = "WarnSameSiteUnspecifiedCrossSiteContext"

	// AuditsCookieWarningReasonWarnSameSiteNoneInsecure enum const
	AuditsCookieWarningReasonWarnSameSiteNoneInsecure AuditsCookieWarningReason = "WarnSameSiteNoneInsecure"

	// AuditsCookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe enum const
	AuditsCookieWarningReasonWarnSameSiteUnspecifiedLaxAllowUnsafe AuditsCookieWarningReason = "WarnSameSiteUnspecifiedLaxAllowUnsafe"

	// AuditsCookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict enum const
	AuditsCookieWarningReasonWarnSameSiteStrictLaxDowngradeStrict AuditsCookieWarningReason = "WarnSameSiteStrictLaxDowngradeStrict"

	// AuditsCookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict enum const
	AuditsCookieWarningReasonWarnSameSiteStrictCrossDowngradeStrict AuditsCookieWarningReason = "WarnSameSiteStrictCrossDowngradeStrict"

	// AuditsCookieWarningReasonWarnSameSiteStrictCrossDowngradeLax enum const
	AuditsCookieWarningReasonWarnSameSiteStrictCrossDowngradeLax AuditsCookieWarningReason = "WarnSameSiteStrictCrossDowngradeLax"

	// AuditsCookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict enum const
	AuditsCookieWarningReasonWarnSameSiteLaxCrossDowngradeStrict AuditsCookieWarningReason = "WarnSameSiteLaxCrossDowngradeStrict"

	// AuditsCookieWarningReasonWarnSameSiteLaxCrossDowngradeLax enum const
	AuditsCookieWarningReasonWarnSameSiteLaxCrossDowngradeLax AuditsCookieWarningReason = "WarnSameSiteLaxCrossDowngradeLax"

	// AuditsCookieWarningReasonWarnAttributeValueExceedsMaxSize enum const
	AuditsCookieWarningReasonWarnAttributeValueExceedsMaxSize AuditsCookieWarningReason = "WarnAttributeValueExceedsMaxSize"

	// AuditsCookieWarningReasonWarnDomainNonASCII enum const
	AuditsCookieWarningReasonWarnDomainNonASCII AuditsCookieWarningReason = "WarnDomainNonASCII"
)

// AuditsCookieOperation ...
type AuditsCookieOperation string

const (
	// AuditsCookieOperationSetCookie enum const
	AuditsCookieOperationSetCookie AuditsCookieOperation = "SetCookie"

	// AuditsCookieOperationReadCookie enum const
	AuditsCookieOperationReadCookie AuditsCookieOperation = "ReadCookie"
)

// AuditsCookieIssueDetails This information is currently necessary, as the front-end has a difficult
// time finding a specific cookie. With this, we can convey specific error
// information without the cookie.
type AuditsCookieIssueDetails struct {

	// Cookie (optional) If AffectedCookie is not set then rawCookieLine contains the raw
	// Set-Cookie header string. This hints at a problem where the
	// cookie line is syntactically or semantically malformed in a way
	// that no valid cookie could be created.
	Cookie *AuditsAffectedCookie `json:"cookie,omitempty"`

	// RawCookieLine (optional) ...
	RawCookieLine string `json:"rawCookieLine,omitempty"`

	// CookieWarningReasons ...
	CookieWarningReasons []AuditsCookieWarningReason `json:"cookieWarningReasons"`

	// CookieExclusionReasons ...
	CookieExclusionReasons []AuditsCookieExclusionReason `json:"cookieExclusionReasons"`

	// Operation Optionally identifies the site-for-cookies and the cookie url, which
	// may be used by the front-end as additional context.
	Operation AuditsCookieOperation `json:"operation"`

	// SiteForCookies (optional) ...
	SiteForCookies string `json:"siteForCookies,omitempty"`

	// CookieURL (optional) ...
	CookieURL string `json:"cookieUrl,omitempty"`

	// Request (optional) ...
	Request *AuditsAffectedRequest `json:"request,omitempty"`
}

// AuditsMixedContentResolutionStatus ...
type AuditsMixedContentResolutionStatus string

const (
	// AuditsMixedContentResolutionStatusMixedContentBlocked enum const
	AuditsMixedContentResolutionStatusMixedContentBlocked AuditsMixedContentResolutionStatus = "MixedContentBlocked"

	// AuditsMixedContentResolutionStatusMixedContentAutomaticallyUpgraded enum const
	AuditsMixedContentResolutionStatusMixedContentAutomaticallyUpgraded AuditsMixedContentResolutionStatus = "MixedContentAutomaticallyUpgraded"

	// AuditsMixedContentResolutionStatusMixedContentWarning enum const
	AuditsMixedContentResolutionStatusMixedContentWarning AuditsMixedContentResolutionStatus = "MixedContentWarning"
)

// AuditsMixedContentResourceType ...
type AuditsMixedContentResourceType string

const (
	// AuditsMixedContentResourceTypeAttributionSrc enum const
	AuditsMixedContentResourceTypeAttributionSrc AuditsMixedContentResourceType = "AttributionSrc"

	// AuditsMixedContentResourceTypeAudio enum const
	AuditsMixedContentResourceTypeAudio AuditsMixedContentResourceType = "Audio"

	// AuditsMixedContentResourceTypeBeacon enum const
	AuditsMixedContentResourceTypeBeacon AuditsMixedContentResourceType = "Beacon"

	// AuditsMixedContentResourceTypeCSPReport enum const
	AuditsMixedContentResourceTypeCSPReport AuditsMixedContentResourceType = "CSPReport"

	// AuditsMixedContentResourceTypeDownload enum const
	AuditsMixedContentResourceTypeDownload AuditsMixedContentResourceType = "Download"

	// AuditsMixedContentResourceTypeEventSource enum const
	AuditsMixedContentResourceTypeEventSource AuditsMixedContentResourceType = "EventSource"

	// AuditsMixedContentResourceTypeFavicon enum const
	AuditsMixedContentResourceTypeFavicon AuditsMixedContentResourceType = "Favicon"

	// AuditsMixedContentResourceTypeFont enum const
	AuditsMixedContentResourceTypeFont AuditsMixedContentResourceType = "Font"

	// AuditsMixedContentResourceTypeForm enum const
	AuditsMixedContentResourceTypeForm AuditsMixedContentResourceType = "Form"

	// AuditsMixedContentResourceTypeFrame enum const
	AuditsMixedContentResourceTypeFrame AuditsMixedContentResourceType = "Frame"

	// AuditsMixedContentResourceTypeImage enum const
	AuditsMixedContentResourceTypeImage AuditsMixedContentResourceType = "Image"

	// AuditsMixedContentResourceTypeImport enum const
	AuditsMixedContentResourceTypeImport AuditsMixedContentResourceType = "Import"

	// AuditsMixedContentResourceTypeManifest enum const
	AuditsMixedContentResourceTypeManifest AuditsMixedContentResourceType = "Manifest"

	// AuditsMixedContentResourceTypePing enum const
	AuditsMixedContentResourceTypePing AuditsMixedContentResourceType = "Ping"

	// AuditsMixedContentResourceTypePluginData enum const
	AuditsMixedContentResourceTypePluginData AuditsMixedContentResourceType = "PluginData"

	// AuditsMixedContentResourceTypePluginResource enum const
	AuditsMixedContentResourceTypePluginResource AuditsMixedContentResourceType = "PluginResource"

	// AuditsMixedContentResourceTypePrefetch enum const
	AuditsMixedContentResourceTypePrefetch AuditsMixedContentResourceType = "Prefetch"

	// AuditsMixedContentResourceTypeResource enum const
	AuditsMixedContentResourceTypeResource AuditsMixedContentResourceType = "Resource"

	// AuditsMixedContentResourceTypeScript enum const
	AuditsMixedContentResourceTypeScript AuditsMixedContentResourceType = "Script"

	// AuditsMixedContentResourceTypeServiceWorker enum const
	AuditsMixedContentResourceTypeServiceWorker AuditsMixedContentResourceType = "ServiceWorker"

	// AuditsMixedContentResourceTypeSharedWorker enum const
	AuditsMixedContentResourceTypeSharedWorker AuditsMixedContentResourceType = "SharedWorker"

	// AuditsMixedContentResourceTypeStylesheet enum const
	AuditsMixedContentResourceTypeStylesheet AuditsMixedContentResourceType = "Stylesheet"

	// AuditsMixedContentResourceTypeTrack enum const
	AuditsMixedContentResourceTypeTrack AuditsMixedContentResourceType = "Track"

	// AuditsMixedContentResourceTypeVideo enum const
	AuditsMixedContentResourceTypeVideo AuditsMixedContentResourceType = "Video"

	// AuditsMixedContentResourceTypeWorker enum const
	AuditsMixedContentResourceTypeWorker AuditsMixedContentResourceType = "Worker"

	// AuditsMixedContentResourceTypeXMLHTTPRequest enum const
	AuditsMixedContentResourceTypeXMLHTTPRequest AuditsMixedContentResourceType = "XMLHttpRequest"

	// AuditsMixedContentResourceTypeXSLT enum const
	AuditsMixedContentResourceTypeXSLT AuditsMixedContentResourceType = "XSLT"
)

// AuditsMixedContentIssueDetails ...
type AuditsMixedContentIssueDetails struct {

	// ResourceType (optional) The type of resource causing the mixed content issue (css, js, iframe,
	// form,...). Marked as optional because it is mapped to from
	// blink::mojom::RequestContextType, which will be replaced
	// by network::mojom::RequestDestination
	ResourceType AuditsMixedContentResourceType `json:"resourceType,omitempty"`

	// ResolutionStatus The way the mixed content issue is being resolved.
	ResolutionStatus AuditsMixedContentResolutionStatus `json:"resolutionStatus"`

	// InsecureURL The unsafe http url causing the mixed content issue.
	InsecureURL string `json:"insecureURL"`

	// MainResourceURL The url responsible for the call to an unsafe url.
	MainResourceURL string `json:"mainResourceURL"`

	// Request (optional) The mixed content request.
	// Does not always exist (e.g. for unsafe form submission urls).
	Request *AuditsAffectedRequest `json:"request,omitempty"`

	// Frame (optional) Optional because not every mixed content issue is necessarily linked to a frame.
	Frame *AuditsAffectedFrame `json:"frame,omitempty"`
}

// AuditsBlockedByResponseReason Enum indicating the reason a response has been blocked. These reasons are
// refinements of the net error BLOCKED_BY_RESPONSE.
type AuditsBlockedByResponseReason string

const (
	// AuditsBlockedByResponseReasonCoepFrameResourceNeedsCoepHeader enum const
	AuditsBlockedByResponseReasonCoepFrameResourceNeedsCoepHeader AuditsBlockedByResponseReason = "CoepFrameResourceNeedsCoepHeader"

	// AuditsBlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage enum const
	AuditsBlockedByResponseReasonCoopSandboxedIFrameCannotNavigateToCoopPage AuditsBlockedByResponseReason = "CoopSandboxedIFrameCannotNavigateToCoopPage"

	// AuditsBlockedByResponseReasonCorpNotSameOrigin enum const
	AuditsBlockedByResponseReasonCorpNotSameOrigin AuditsBlockedByResponseReason = "CorpNotSameOrigin"

	// AuditsBlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep enum const
	AuditsBlockedByResponseReasonCorpNotSameOriginAfterDefaultedToSameOriginByCoep AuditsBlockedByResponseReason = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep"

	// AuditsBlockedByResponseReasonCorpNotSameSite enum const
	AuditsBlockedByResponseReasonCorpNotSameSite AuditsBlockedByResponseReason = "CorpNotSameSite"
)

// AuditsBlockedByResponseIssueDetails Details for a request that has been blocked with the BLOCKED_BY_RESPONSE
// code. Currently only used for COEP/COOP, but may be extended to include
// some CSP errors in the future.
type AuditsBlockedByResponseIssueDetails struct {

	// Request ...
	Request *AuditsAffectedRequest `json:"request"`

	// ParentFrame (optional) ...
	ParentFrame *AuditsAffectedFrame `json:"parentFrame,omitempty"`

	// BlockedFrame (optional) ...
	BlockedFrame *AuditsAffectedFrame `json:"blockedFrame,omitempty"`

	// Reason ...
	Reason AuditsBlockedByResponseReason `json:"reason"`
}

// AuditsHeavyAdResolutionStatus ...
type AuditsHeavyAdResolutionStatus string

const (
	// AuditsHeavyAdResolutionStatusHeavyAdBlocked enum const
	AuditsHeavyAdResolutionStatusHeavyAdBlocked AuditsHeavyAdResolutionStatus = "HeavyAdBlocked"

	// AuditsHeavyAdResolutionStatusHeavyAdWarning enum const
	AuditsHeavyAdResolutionStatusHeavyAdWarning AuditsHeavyAdResolutionStatus = "HeavyAdWarning"
)

// AuditsHeavyAdReason ...
type AuditsHeavyAdReason string

const (
	// AuditsHeavyAdReasonNetworkTotalLimit enum const
	AuditsHeavyAdReasonNetworkTotalLimit AuditsHeavyAdReason = "NetworkTotalLimit"

	// AuditsHeavyAdReasonCPUTotalLimit enum const
	AuditsHeavyAdReasonCPUTotalLimit AuditsHeavyAdReason = "CpuTotalLimit"

	// AuditsHeavyAdReasonCPUPeakLimit enum const
	AuditsHeavyAdReasonCPUPeakLimit AuditsHeavyAdReason = "CpuPeakLimit"
)

// AuditsHeavyAdIssueDetails ...
type AuditsHeavyAdIssueDetails struct {

	// Resolution The resolution status, either blocking the content or warning.
	Resolution AuditsHeavyAdResolutionStatus `json:"resolution"`

	// Reason The reason the ad was blocked, total network or cpu or peak cpu.
	Reason AuditsHeavyAdReason `json:"reason"`

	// Frame The frame that was blocked.
	Frame *AuditsAffectedFrame `json:"frame"`
}

// AuditsContentSecurityPolicyViolationType ...
type AuditsContentSecurityPolicyViolationType string

const (
	// AuditsContentSecurityPolicyViolationTypeKInlineViolation enum const
	AuditsContentSecurityPolicyViolationTypeKInlineViolation AuditsContentSecurityPolicyViolationType = "kInlineViolation"

	// AuditsContentSecurityPolicyViolationTypeKEvalViolation enum const
	AuditsContentSecurityPolicyViolationTypeKEvalViolation AuditsContentSecurityPolicyViolationType = "kEvalViolation"

	// AuditsContentSecurityPolicyViolationTypeKURLViolation enum const
	AuditsContentSecurityPolicyViolationTypeKURLViolation AuditsContentSecurityPolicyViolationType = "kURLViolation"

	// AuditsContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation enum const
	AuditsContentSecurityPolicyViolationTypeKTrustedTypesSinkViolation AuditsContentSecurityPolicyViolationType = "kTrustedTypesSinkViolation"

	// AuditsContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation enum const
	AuditsContentSecurityPolicyViolationTypeKTrustedTypesPolicyViolation AuditsContentSecurityPolicyViolationType = "kTrustedTypesPolicyViolation"

	// AuditsContentSecurityPolicyViolationTypeKWasmEvalViolation enum const
	AuditsContentSecurityPolicyViolationTypeKWasmEvalViolation AuditsContentSecurityPolicyViolationType = "kWasmEvalViolation"
)

// AuditsSourceCodeLocation ...
type AuditsSourceCodeLocation struct {

	// ScriptID (optional) ...
	ScriptID RuntimeScriptID `json:"scriptId,omitempty"`

	// URL ...
	URL string `json:"url"`

	// LineNumber ...
	LineNumber int `json:"lineNumber"`

	// ColumnNumber ...
	ColumnNumber int `json:"columnNumber"`
}

// AuditsContentSecurityPolicyIssueDetails ...
type AuditsContentSecurityPolicyIssueDetails struct {

	// BlockedURL (optional) The url not included in allowed sources.
	BlockedURL string `json:"blockedURL,omitempty"`

	// ViolatedDirective Specific directive that is violated, causing the CSP issue.
	ViolatedDirective string `json:"violatedDirective"`

	// IsReportOnly ...
	IsReportOnly bool `json:"isReportOnly"`

	// ContentSecurityPolicyViolationType ...
	ContentSecurityPolicyViolationType AuditsContentSecurityPolicyViolationType `json:"contentSecurityPolicyViolationType"`

	// FrameAncestor (optional) ...
	FrameAncestor *AuditsAffectedFrame `json:"frameAncestor,omitempty"`

	// SourceCodeLocation (optional) ...
	SourceCodeLocation *AuditsSourceCodeLocation `json:"sourceCodeLocation,omitempty"`

	// ViolatingNodeID (optional) ...
	ViolatingNodeID DOMBackendNodeID `json:"violatingNodeId,omitempty"`
}

// AuditsSharedArrayBufferIssueType ...
type AuditsSharedArrayBufferIssueType string

const (
	// AuditsSharedArrayBufferIssueTypeTransferIssue enum const
	AuditsSharedArrayBufferIssueTypeTransferIssue AuditsSharedArrayBufferIssueType = "TransferIssue"

	// AuditsSharedArrayBufferIssueTypeCreationIssue enum const
	AuditsSharedArrayBufferIssueTypeCreationIssue AuditsSharedArrayBufferIssueType = "CreationIssue"
)

// AuditsSharedArrayBufferIssueDetails Details for a issue arising from an SAB being instantiated in, or
// transferred to a context that is not cross-origin isolated.
type AuditsSharedArrayBufferIssueDetails struct {

	// SourceCodeLocation ...
	SourceCodeLocation *AuditsSourceCodeLocation `json:"sourceCodeLocation"`

	// IsWarning ...
	IsWarning bool `json:"isWarning"`

	// Type ...
	Type AuditsSharedArrayBufferIssueType `json:"type"`
}

// AuditsTwaQualityEnforcementViolationType ...
type AuditsTwaQualityEnforcementViolationType string

const (
	// AuditsTwaQualityEnforcementViolationTypeKHTTPError enum const
	AuditsTwaQualityEnforcementViolationTypeKHTTPError AuditsTwaQualityEnforcementViolationType = "kHttpError"

	// AuditsTwaQualityEnforcementViolationTypeKUnavailableOffline enum const
	AuditsTwaQualityEnforcementViolationTypeKUnavailableOffline AuditsTwaQualityEnforcementViolationType = "kUnavailableOffline"

	// AuditsTwaQualityEnforcementViolationTypeKDigitalAssetLinks enum const
	AuditsTwaQualityEnforcementViolationTypeKDigitalAssetLinks AuditsTwaQualityEnforcementViolationType = "kDigitalAssetLinks"
)

// AuditsTrustedWebActivityIssueDetails ...
type AuditsTrustedWebActivityIssueDetails struct {

	// URL The url that triggers the violation.
	URL string `json:"url"`

	// ViolationType ...
	ViolationType AuditsTwaQualityEnforcementViolationType `json:"violationType"`

	// HTTPStatusCode (optional) ...
	HTTPStatusCode *int `json:"httpStatusCode,omitempty"`

	// PackageName (optional) The package name of the Trusted Web Activity client app. This field is
	// only used when violation type is kDigitalAssetLinks.
	PackageName string `json:"packageName,omitempty"`

	// Signature (optional) The signature of the Trusted Web Activity client app. This field is only
	// used when violation type is kDigitalAssetLinks.
	Signature string `json:"signature,omitempty"`
}

// AuditsLowTextContrastIssueDetails ...
type AuditsLowTextContrastIssueDetails struct {

	// ViolatingNodeID ...
	ViolatingNodeID DOMBackendNodeID `json:"violatingNodeId"`

	// ViolatingNodeSelector ...
	ViolatingNodeSelector string `json:"violatingNodeSelector"`

	// ContrastRatio ...
	ContrastRatio float64 `json:"contrastRatio"`

	// ThresholdAA ...
	ThresholdAA float64 `json:"thresholdAA"`

	// ThresholdAAA ...
	ThresholdAAA float64 `json:"thresholdAAA"`

	// FontSize ...
	FontSize string `json:"fontSize"`

	// FontWeight ...
	FontWeight string `json:"fontWeight"`
}

// AuditsCorsIssueDetails Details for a CORS related issue, e.g. a warning or error related to
// CORS RFC1918 enforcement.
type AuditsCorsIssueDetails struct {

	// CorsErrorStatus ...
	CorsErrorStatus *NetworkCorsErrorStatus `json:"corsErrorStatus"`

	// IsWarning ...
	IsWarning bool `json:"isWarning"`

	// Request ...
	Request *AuditsAffectedRequest `json:"request"`

	// Location (optional) ...
	Location *AuditsSourceCodeLocation `json:"location,omitempty"`

	// InitiatorOrigin (optional) ...
	InitiatorOrigin string `json:"initiatorOrigin,omitempty"`

	// ResourceIPAddressSpace (optional) ...
	ResourceIPAddressSpace NetworkIPAddressSpace `json:"resourceIPAddressSpace,omitempty"`

	// ClientSecurityState (optional) ...
	ClientSecurityState *NetworkClientSecurityState `json:"clientSecurityState,omitempty"`
}

// AuditsAttributionReportingIssueType ...
type AuditsAttributionReportingIssueType string

const (
	// AuditsAttributionReportingIssueTypePermissionPolicyDisabled enum const
	AuditsAttributionReportingIssueTypePermissionPolicyDisabled AuditsAttributionReportingIssueType = "PermissionPolicyDisabled"

	// AuditsAttributionReportingIssueTypePermissionPolicyNotDelegated enum const
	AuditsAttributionReportingIssueTypePermissionPolicyNotDelegated AuditsAttributionReportingIssueType = "PermissionPolicyNotDelegated"

	// AuditsAttributionReportingIssueTypeUntrustworthyReportingOrigin enum const
	AuditsAttributionReportingIssueTypeUntrustworthyReportingOrigin AuditsAttributionReportingIssueType = "UntrustworthyReportingOrigin"

	// AuditsAttributionReportingIssueTypeInsecureContext enum const
	AuditsAttributionReportingIssueTypeInsecureContext AuditsAttributionReportingIssueType = "InsecureContext"

	// AuditsAttributionReportingIssueTypeInvalidHeader enum const
	AuditsAttributionReportingIssueTypeInvalidHeader AuditsAttributionReportingIssueType = "InvalidHeader"

	// AuditsAttributionReportingIssueTypeInvalidRegisterTriggerHeader enum const
	AuditsAttributionReportingIssueTypeInvalidRegisterTriggerHeader AuditsAttributionReportingIssueType = "InvalidRegisterTriggerHeader"

	// AuditsAttributionReportingIssueTypeInvalidEligibleHeader enum const
	AuditsAttributionReportingIssueTypeInvalidEligibleHeader AuditsAttributionReportingIssueType = "InvalidEligibleHeader"

	// AuditsAttributionReportingIssueTypeTooManyConcurrentRequests enum const
	AuditsAttributionReportingIssueTypeTooManyConcurrentRequests AuditsAttributionReportingIssueType = "TooManyConcurrentRequests"

	// AuditsAttributionReportingIssueTypeSourceAndTriggerHeaders enum const
	AuditsAttributionReportingIssueTypeSourceAndTriggerHeaders AuditsAttributionReportingIssueType = "SourceAndTriggerHeaders"

	// AuditsAttributionReportingIssueTypeSourceIgnored enum const
	AuditsAttributionReportingIssueTypeSourceIgnored AuditsAttributionReportingIssueType = "SourceIgnored"

	// AuditsAttributionReportingIssueTypeTriggerIgnored enum const
	AuditsAttributionReportingIssueTypeTriggerIgnored AuditsAttributionReportingIssueType = "TriggerIgnored"
)

// AuditsAttributionReportingIssueDetails Details for issues around "Attribution Reporting API" usage.
// Explainer: https://github.com/WICG/attribution-reporting-api
type AuditsAttributionReportingIssueDetails struct {

	// ViolationType ...
	ViolationType AuditsAttributionReportingIssueType `json:"violationType"`

	// Request (optional) ...
	Request *AuditsAffectedRequest `json:"request,omitempty"`

	// ViolatingNodeID (optional) ...
	ViolatingNodeID DOMBackendNodeID `json:"violatingNodeId,omitempty"`

	// InvalidParameter (optional) ...
	InvalidParameter string `json:"invalidParameter,omitempty"`
}

// AuditsQuirksModeIssueDetails Details for issues about documents in Quirks Mode
// or Limited Quirks Mode that affects page layouting.
type AuditsQuirksModeIssueDetails struct {

	// IsLimitedQuirksMode If false, it means the document's mode is "quirks"
	// instead of "limited-quirks".
	IsLimitedQuirksMode bool `json:"isLimitedQuirksMode"`

	// DocumentNodeID ...
	DocumentNodeID DOMBackendNodeID `json:"documentNodeId"`

	// URL ...
	URL string `json:"url"`

	// FrameID ...
	FrameID PageFrameID `json:"frameId"`

	// LoaderID ...
	LoaderID NetworkLoaderID `json:"loaderId"`
}

// AuditsNavigatorUserAgentIssueDetails ...
type AuditsNavigatorUserAgentIssueDetails struct {

	// URL ...
	URL string `json:"url"`

	// Location (optional) ...
	Location *AuditsSourceCodeLocation `json:"location,omitempty"`
}

// AuditsGenericIssueErrorType ...
type AuditsGenericIssueErrorType string

const (
	// AuditsGenericIssueErrorTypeCrossOriginPortalPostMessageError enum const
	AuditsGenericIssueErrorTypeCrossOriginPortalPostMessageError AuditsGenericIssueErrorType = "CrossOriginPortalPostMessageError"

	// AuditsGenericIssueErrorTypeFormLabelForNameError enum const
	AuditsGenericIssueErrorTypeFormLabelForNameError AuditsGenericIssueErrorType = "FormLabelForNameError"

	// AuditsGenericIssueErrorTypeFormDuplicateIDForInputError enum const
	AuditsGenericIssueErrorTypeFormDuplicateIDForInputError AuditsGenericIssueErrorType = "FormDuplicateIdForInputError"

	// AuditsGenericIssueErrorTypeFormInputWithNoLabelError enum const
	AuditsGenericIssueErrorTypeFormInputWithNoLabelError AuditsGenericIssueErrorType = "FormInputWithNoLabelError"

	// AuditsGenericIssueErrorTypeFormAutocompleteAttributeEmptyError enum const
	AuditsGenericIssueErrorTypeFormAutocompleteAttributeEmptyError AuditsGenericIssueErrorType = "FormAutocompleteAttributeEmptyError"

	// AuditsGenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError enum const
	AuditsGenericIssueErrorTypeFormEmptyIDAndNameAttributesForInputError AuditsGenericIssueErrorType = "FormEmptyIdAndNameAttributesForInputError"

	// AuditsGenericIssueErrorTypeFormAriaLabelledByToNonExistingID enum const
	AuditsGenericIssueErrorTypeFormAriaLabelledByToNonExistingID AuditsGenericIssueErrorType = "FormAriaLabelledByToNonExistingId"

	// AuditsGenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError enum const
	AuditsGenericIssueErrorTypeFormInputAssignedAutocompleteValueToIDOrNameAttributeError AuditsGenericIssueErrorType = "FormInputAssignedAutocompleteValueToIdOrNameAttributeError"

	// AuditsGenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput enum const
	AuditsGenericIssueErrorTypeFormLabelHasNeitherForNorNestedInput AuditsGenericIssueErrorType = "FormLabelHasNeitherForNorNestedInput"

	// AuditsGenericIssueErrorTypeFormLabelForMatchesNonExistingIDError enum const
	AuditsGenericIssueErrorTypeFormLabelForMatchesNonExistingIDError AuditsGenericIssueErrorType = "FormLabelForMatchesNonExistingIdError"
)

// AuditsGenericIssueDetails Depending on the concrete errorType, different properties are set.
type AuditsGenericIssueDetails struct {

	// ErrorType Issues with the same errorType are aggregated in the frontend.
	ErrorType AuditsGenericIssueErrorType `json:"errorType"`

	// FrameID (optional) ...
	FrameID PageFrameID `json:"frameId,omitempty"`

	// ViolatingNodeID (optional) ...
	ViolatingNodeID DOMBackendNodeID `json:"violatingNodeId,omitempty"`
}

// AuditsDeprecationIssueType ...
type AuditsDeprecationIssueType string

const (
	// AuditsDeprecationIssueTypeAuthorizationCoveredByWildcard enum const
	AuditsDeprecationIssueTypeAuthorizationCoveredByWildcard AuditsDeprecationIssueType = "AuthorizationCoveredByWildcard"

	// AuditsDeprecationIssueTypeCanRequestURLHTTPContainingNewline enum const
	AuditsDeprecationIssueTypeCanRequestURLHTTPContainingNewline AuditsDeprecationIssueType = "CanRequestURLHTTPContainingNewline"

	// AuditsDeprecationIssueTypeChromeLoadTimesConnectionInfo enum const
	AuditsDeprecationIssueTypeChromeLoadTimesConnectionInfo AuditsDeprecationIssueType = "ChromeLoadTimesConnectionInfo"

	// AuditsDeprecationIssueTypeChromeLoadTimesFirstPaintAfterLoadTime enum const
	AuditsDeprecationIssueTypeChromeLoadTimesFirstPaintAfterLoadTime AuditsDeprecationIssueType = "ChromeLoadTimesFirstPaintAfterLoadTime"

	// AuditsDeprecationIssueTypeChromeLoadTimesWasAlternateProtocolAvailable enum const
	AuditsDeprecationIssueTypeChromeLoadTimesWasAlternateProtocolAvailable AuditsDeprecationIssueType = "ChromeLoadTimesWasAlternateProtocolAvailable"

	// AuditsDeprecationIssueTypeCookieWithTruncatingChar enum const
	AuditsDeprecationIssueTypeCookieWithTruncatingChar AuditsDeprecationIssueType = "CookieWithTruncatingChar"

	// AuditsDeprecationIssueTypeCrossOriginAccessBasedOnDocumentDomain enum const
	AuditsDeprecationIssueTypeCrossOriginAccessBasedOnDocumentDomain AuditsDeprecationIssueType = "CrossOriginAccessBasedOnDocumentDomain"

	// AuditsDeprecationIssueTypeCrossOriginWindowAlert enum const
	AuditsDeprecationIssueTypeCrossOriginWindowAlert AuditsDeprecationIssueType = "CrossOriginWindowAlert"

	// AuditsDeprecationIssueTypeCrossOriginWindowConfirm enum const
	AuditsDeprecationIssueTypeCrossOriginWindowConfirm AuditsDeprecationIssueType = "CrossOriginWindowConfirm"

	// AuditsDeprecationIssueTypeCSSSelectorInternalMediaControlsOverlayCastButton enum const
	AuditsDeprecationIssueTypeCSSSelectorInternalMediaControlsOverlayCastButton AuditsDeprecationIssueType = "CSSSelectorInternalMediaControlsOverlayCastButton"

	// AuditsDeprecationIssueTypeDeprecationExample enum const
	AuditsDeprecationIssueTypeDeprecationExample AuditsDeprecationIssueType = "DeprecationExample"

	// AuditsDeprecationIssueTypeDocumentDomainSettingWithoutOriginAgentClusterHeader enum const
	AuditsDeprecationIssueTypeDocumentDomainSettingWithoutOriginAgentClusterHeader AuditsDeprecationIssueType = "DocumentDomainSettingWithoutOriginAgentClusterHeader"

	// AuditsDeprecationIssueTypeEventPath enum const
	AuditsDeprecationIssueTypeEventPath AuditsDeprecationIssueType = "EventPath"

	// AuditsDeprecationIssueTypeExpectCTHeader enum const
	AuditsDeprecationIssueTypeExpectCTHeader AuditsDeprecationIssueType = "ExpectCTHeader"

	// AuditsDeprecationIssueTypeGeolocationInsecureOrigin enum const
	AuditsDeprecationIssueTypeGeolocationInsecureOrigin AuditsDeprecationIssueType = "GeolocationInsecureOrigin"

	// AuditsDeprecationIssueTypeGeolocationInsecureOriginDeprecatedNotRemoved enum const
	AuditsDeprecationIssueTypeGeolocationInsecureOriginDeprecatedNotRemoved AuditsDeprecationIssueType = "GeolocationInsecureOriginDeprecatedNotRemoved"

	// AuditsDeprecationIssueTypeGetUserMediaInsecureOrigin enum const
	AuditsDeprecationIssueTypeGetUserMediaInsecureOrigin AuditsDeprecationIssueType = "GetUserMediaInsecureOrigin"

	// AuditsDeprecationIssueTypeHostCandidateAttributeGetter enum const
	AuditsDeprecationIssueTypeHostCandidateAttributeGetter AuditsDeprecationIssueType = "HostCandidateAttributeGetter"

	// AuditsDeprecationIssueTypeIdentityInCanMakePaymentEvent enum const
	AuditsDeprecationIssueTypeIdentityInCanMakePaymentEvent AuditsDeprecationIssueType = "IdentityInCanMakePaymentEvent"

	// AuditsDeprecationIssueTypeInsecurePrivateNetworkSubresourceRequest enum const
	AuditsDeprecationIssueTypeInsecurePrivateNetworkSubresourceRequest AuditsDeprecationIssueType = "InsecurePrivateNetworkSubresourceRequest"

	// AuditsDeprecationIssueTypeLocalCSSFileExtensionRejected enum const
	AuditsDeprecationIssueTypeLocalCSSFileExtensionRejected AuditsDeprecationIssueType = "LocalCSSFileExtensionRejected"

	// AuditsDeprecationIssueTypeMediaSourceAbortRemove enum const
	AuditsDeprecationIssueTypeMediaSourceAbortRemove AuditsDeprecationIssueType = "MediaSourceAbortRemove"

	// AuditsDeprecationIssueTypeMediaSourceDurationTruncatingBuffered enum const
	AuditsDeprecationIssueTypeMediaSourceDurationTruncatingBuffered AuditsDeprecationIssueType = "MediaSourceDurationTruncatingBuffered"

	// AuditsDeprecationIssueTypeNoSysexWebMIDIWithoutPermission enum const
	AuditsDeprecationIssueTypeNoSysexWebMIDIWithoutPermission AuditsDeprecationIssueType = "NoSysexWebMIDIWithoutPermission"

	// AuditsDeprecationIssueTypeNotificationInsecureOrigin enum const
	AuditsDeprecationIssueTypeNotificationInsecureOrigin AuditsDeprecationIssueType = "NotificationInsecureOrigin"

	// AuditsDeprecationIssueTypeNotificationPermissionRequestedIframe enum const
	AuditsDeprecationIssueTypeNotificationPermissionRequestedIframe AuditsDeprecationIssueType = "NotificationPermissionRequestedIframe"

	// AuditsDeprecationIssueTypeObsoleteCreateImageBitmapImageOrientationNone enum const
	AuditsDeprecationIssueTypeObsoleteCreateImageBitmapImageOrientationNone AuditsDeprecationIssueType = "ObsoleteCreateImageBitmapImageOrientationNone"

	// AuditsDeprecationIssueTypeObsoleteWebRtcCipherSuite enum const
	AuditsDeprecationIssueTypeObsoleteWebRtcCipherSuite AuditsDeprecationIssueType = "ObsoleteWebRtcCipherSuite"

	// AuditsDeprecationIssueTypeOpenWebDatabaseInsecureContext enum const
	AuditsDeprecationIssueTypeOpenWebDatabaseInsecureContext AuditsDeprecationIssueType = "OpenWebDatabaseInsecureContext"

	// AuditsDeprecationIssueTypeOverflowVisibleOnReplacedElement enum const
	AuditsDeprecationIssueTypeOverflowVisibleOnReplacedElement AuditsDeprecationIssueType = "OverflowVisibleOnReplacedElement"

	// AuditsDeprecationIssueTypePaymentInstruments enum const
	AuditsDeprecationIssueTypePaymentInstruments AuditsDeprecationIssueType = "PaymentInstruments"

	// AuditsDeprecationIssueTypePaymentRequestCSPViolation enum const
	AuditsDeprecationIssueTypePaymentRequestCSPViolation AuditsDeprecationIssueType = "PaymentRequestCSPViolation"

	// AuditsDeprecationIssueTypePersistentQuotaType enum const
	AuditsDeprecationIssueTypePersistentQuotaType AuditsDeprecationIssueType = "PersistentQuotaType"

	// AuditsDeprecationIssueTypePictureSourceSrc enum const
	AuditsDeprecationIssueTypePictureSourceSrc AuditsDeprecationIssueType = "PictureSourceSrc"

	// AuditsDeprecationIssueTypePrefixedCancelAnimationFrame enum const
	AuditsDeprecationIssueTypePrefixedCancelAnimationFrame AuditsDeprecationIssueType = "PrefixedCancelAnimationFrame"

	// AuditsDeprecationIssueTypePrefixedRequestAnimationFrame enum const
	AuditsDeprecationIssueTypePrefixedRequestAnimationFrame AuditsDeprecationIssueType = "PrefixedRequestAnimationFrame"

	// AuditsDeprecationIssueTypePrefixedStorageInfo enum const
	AuditsDeprecationIssueTypePrefixedStorageInfo AuditsDeprecationIssueType = "PrefixedStorageInfo"

	// AuditsDeprecationIssueTypePrefixedVideoDisplayingFullscreen enum const
	AuditsDeprecationIssueTypePrefixedVideoDisplayingFullscreen AuditsDeprecationIssueType = "PrefixedVideoDisplayingFullscreen"

	// AuditsDeprecationIssueTypePrefixedVideoEnterFullscreen enum const
	AuditsDeprecationIssueTypePrefixedVideoEnterFullscreen AuditsDeprecationIssueType = "PrefixedVideoEnterFullscreen"

	// AuditsDeprecationIssueTypePrefixedVideoEnterFullScreen enum const
	AuditsDeprecationIssueTypePrefixedVideoEnterFullScreen AuditsDeprecationIssueType = "PrefixedVideoEnterFullScreen"

	// AuditsDeprecationIssueTypePrefixedVideoExitFullscreen enum const
	AuditsDeprecationIssueTypePrefixedVideoExitFullscreen AuditsDeprecationIssueType = "PrefixedVideoExitFullscreen"

	// AuditsDeprecationIssueTypePrefixedVideoExitFullScreen enum const
	AuditsDeprecationIssueTypePrefixedVideoExitFullScreen AuditsDeprecationIssueType = "PrefixedVideoExitFullScreen"

	// AuditsDeprecationIssueTypePrefixedVideoSupportsFullscreen enum const
	AuditsDeprecationIssueTypePrefixedVideoSupportsFullscreen AuditsDeprecationIssueType = "PrefixedVideoSupportsFullscreen"

	// AuditsDeprecationIssueTypePrivacySandboxExtensionsAPI enum const
	AuditsDeprecationIssueTypePrivacySandboxExtensionsAPI AuditsDeprecationIssueType = "PrivacySandboxExtensionsAPI"

	// AuditsDeprecationIssueTypeRangeExpand enum const
	AuditsDeprecationIssueTypeRangeExpand AuditsDeprecationIssueType = "RangeExpand"

	// AuditsDeprecationIssueTypeRequestedSubresourceWithEmbeddedCredentials enum const
	AuditsDeprecationIssueTypeRequestedSubresourceWithEmbeddedCredentials AuditsDeprecationIssueType = "RequestedSubresourceWithEmbeddedCredentials"

	// AuditsDeprecationIssueTypeRTCConstraintEnableDtlsSrtpFalse enum const
	AuditsDeprecationIssueTypeRTCConstraintEnableDtlsSrtpFalse AuditsDeprecationIssueType = "RTCConstraintEnableDtlsSrtpFalse"

	// AuditsDeprecationIssueTypeRTCConstraintEnableDtlsSrtpTrue enum const
	AuditsDeprecationIssueTypeRTCConstraintEnableDtlsSrtpTrue AuditsDeprecationIssueType = "RTCConstraintEnableDtlsSrtpTrue"

	// AuditsDeprecationIssueTypeRTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics enum const
	AuditsDeprecationIssueTypeRTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics AuditsDeprecationIssueType = "RTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics"

	// AuditsDeprecationIssueTypeRTCPeerConnectionSdpSemanticsPlanB enum const
	AuditsDeprecationIssueTypeRTCPeerConnectionSdpSemanticsPlanB AuditsDeprecationIssueType = "RTCPeerConnectionSdpSemanticsPlanB"

	// AuditsDeprecationIssueTypeRtcpMuxPolicyNegotiate enum const
	AuditsDeprecationIssueTypeRtcpMuxPolicyNegotiate AuditsDeprecationIssueType = "RtcpMuxPolicyNegotiate"

	// AuditsDeprecationIssueTypeSharedArrayBufferConstructedWithoutIsolation enum const
	AuditsDeprecationIssueTypeSharedArrayBufferConstructedWithoutIsolation AuditsDeprecationIssueType = "SharedArrayBufferConstructedWithoutIsolation"

	// AuditsDeprecationIssueTypeTextToSpeechDisallowedByAutoplay enum const
	AuditsDeprecationIssueTypeTextToSpeechDisallowedByAutoplay AuditsDeprecationIssueType = "TextToSpeech_DisallowedByAutoplay"

	// AuditsDeprecationIssueTypeV8SharedArrayBufferConstructedInExtensionWithoutIsolation enum const
	AuditsDeprecationIssueTypeV8SharedArrayBufferConstructedInExtensionWithoutIsolation AuditsDeprecationIssueType = "V8SharedArrayBufferConstructedInExtensionWithoutIsolation"

	// AuditsDeprecationIssueTypeXHRJSONEncodingDetection enum const
	AuditsDeprecationIssueTypeXHRJSONEncodingDetection AuditsDeprecationIssueType = "XHRJSONEncodingDetection"

	// AuditsDeprecationIssueTypeXMLHTTPRequestSynchronousInNonWorkerOutsideBeforeUnload enum const
	AuditsDeprecationIssueTypeXMLHTTPRequestSynchronousInNonWorkerOutsideBeforeUnload AuditsDeprecationIssueType = "XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload"

	// AuditsDeprecationIssueTypeXRSupportsSession enum const
	AuditsDeprecationIssueTypeXRSupportsSession AuditsDeprecationIssueType = "XRSupportsSession"
)

// AuditsDeprecationIssueDetails This issue tracks information needed to print a deprecation message.
// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md
type AuditsDeprecationIssueDetails struct {

	// AffectedFrame (optional) ...
	AffectedFrame *AuditsAffectedFrame `json:"affectedFrame,omitempty"`

	// SourceCodeLocation ...
	SourceCodeLocation *AuditsSourceCodeLocation `json:"sourceCodeLocation"`

	// Type ...
	Type AuditsDeprecationIssueType `json:"type"`
}

// AuditsClientHintIssueReason ...
type AuditsClientHintIssueReason string

const (
	// AuditsClientHintIssueReasonMetaTagAllowListInvalidOrigin enum const
	AuditsClientHintIssueReasonMetaTagAllowListInvalidOrigin AuditsClientHintIssueReason = "MetaTagAllowListInvalidOrigin"

	// AuditsClientHintIssueReasonMetaTagModifiedHTML enum const
	AuditsClientHintIssueReasonMetaTagModifiedHTML AuditsClientHintIssueReason = "MetaTagModifiedHTML"
)

// AuditsFederatedAuthRequestIssueDetails ...
type AuditsFederatedAuthRequestIssueDetails struct {

	// FederatedAuthRequestIssueReason ...
	FederatedAuthRequestIssueReason AuditsFederatedAuthRequestIssueReason `json:"federatedAuthRequestIssueReason"`
}

// AuditsFederatedAuthRequestIssueReason Represents the failure reason when a federated authentication reason fails.
// Should be updated alongside RequestIdTokenStatus in
// third_party/blink/public/mojom/devtools/inspector_issue.mojom to include
// all cases except for success.
type AuditsFederatedAuthRequestIssueReason string

const (
	// AuditsFederatedAuthRequestIssueReasonShouldEmbargo enum const
	AuditsFederatedAuthRequestIssueReasonShouldEmbargo AuditsFederatedAuthRequestIssueReason = "ShouldEmbargo"

	// AuditsFederatedAuthRequestIssueReasonTooManyRequests enum const
	AuditsFederatedAuthRequestIssueReasonTooManyRequests AuditsFederatedAuthRequestIssueReason = "TooManyRequests"

	// AuditsFederatedAuthRequestIssueReasonWellKnownHTTPNotFound enum const
	AuditsFederatedAuthRequestIssueReasonWellKnownHTTPNotFound AuditsFederatedAuthRequestIssueReason = "WellKnownHttpNotFound"

	// AuditsFederatedAuthRequestIssueReasonWellKnownNoResponse enum const
	AuditsFederatedAuthRequestIssueReasonWellKnownNoResponse AuditsFederatedAuthRequestIssueReason = "WellKnownNoResponse"

	// AuditsFederatedAuthRequestIssueReasonWellKnownInvalidResponse enum const
	AuditsFederatedAuthRequestIssueReasonWellKnownInvalidResponse AuditsFederatedAuthRequestIssueReason = "WellKnownInvalidResponse"

	// AuditsFederatedAuthRequestIssueReasonWellKnownListEmpty enum const
	AuditsFederatedAuthRequestIssueReasonWellKnownListEmpty AuditsFederatedAuthRequestIssueReason = "WellKnownListEmpty"

	// AuditsFederatedAuthRequestIssueReasonConfigNotInWellKnown enum const
	AuditsFederatedAuthRequestIssueReasonConfigNotInWellKnown AuditsFederatedAuthRequestIssueReason = "ConfigNotInWellKnown"

	// AuditsFederatedAuthRequestIssueReasonWellKnownTooBig enum const
	AuditsFederatedAuthRequestIssueReasonWellKnownTooBig AuditsFederatedAuthRequestIssueReason = "WellKnownTooBig"

	// AuditsFederatedAuthRequestIssueReasonConfigHTTPNotFound enum const
	AuditsFederatedAuthRequestIssueReasonConfigHTTPNotFound AuditsFederatedAuthRequestIssueReason = "ConfigHttpNotFound"

	// AuditsFederatedAuthRequestIssueReasonConfigNoResponse enum const
	AuditsFederatedAuthRequestIssueReasonConfigNoResponse AuditsFederatedAuthRequestIssueReason = "ConfigNoResponse"

	// AuditsFederatedAuthRequestIssueReasonConfigInvalidResponse enum const
	AuditsFederatedAuthRequestIssueReasonConfigInvalidResponse AuditsFederatedAuthRequestIssueReason = "ConfigInvalidResponse"

	// AuditsFederatedAuthRequestIssueReasonClientMetadataHTTPNotFound enum const
	AuditsFederatedAuthRequestIssueReasonClientMetadataHTTPNotFound AuditsFederatedAuthRequestIssueReason = "ClientMetadataHttpNotFound"

	// AuditsFederatedAuthRequestIssueReasonClientMetadataNoResponse enum const
	AuditsFederatedAuthRequestIssueReasonClientMetadataNoResponse AuditsFederatedAuthRequestIssueReason = "ClientMetadataNoResponse"

	// AuditsFederatedAuthRequestIssueReasonClientMetadataInvalidResponse enum const
	AuditsFederatedAuthRequestIssueReasonClientMetadataInvalidResponse AuditsFederatedAuthRequestIssueReason = "ClientMetadataInvalidResponse"

	// AuditsFederatedAuthRequestIssueReasonDisabledInSettings enum const
	AuditsFederatedAuthRequestIssueReasonDisabledInSettings AuditsFederatedAuthRequestIssueReason = "DisabledInSettings"

	// AuditsFederatedAuthRequestIssueReasonErrorFetchingSignin enum const
	AuditsFederatedAuthRequestIssueReasonErrorFetchingSignin AuditsFederatedAuthRequestIssueReason = "ErrorFetchingSignin"

	// AuditsFederatedAuthRequestIssueReasonInvalidSigninResponse enum const
	AuditsFederatedAuthRequestIssueReasonInvalidSigninResponse AuditsFederatedAuthRequestIssueReason = "InvalidSigninResponse"

	// AuditsFederatedAuthRequestIssueReasonAccountsHTTPNotFound enum const
	AuditsFederatedAuthRequestIssueReasonAccountsHTTPNotFound AuditsFederatedAuthRequestIssueReason = "AccountsHttpNotFound"

	// AuditsFederatedAuthRequestIssueReasonAccountsNoResponse enum const
	AuditsFederatedAuthRequestIssueReasonAccountsNoResponse AuditsFederatedAuthRequestIssueReason = "AccountsNoResponse"

	// AuditsFederatedAuthRequestIssueReasonAccountsInvalidResponse enum const
	AuditsFederatedAuthRequestIssueReasonAccountsInvalidResponse AuditsFederatedAuthRequestIssueReason = "AccountsInvalidResponse"

	// AuditsFederatedAuthRequestIssueReasonAccountsListEmpty enum const
	AuditsFederatedAuthRequestIssueReasonAccountsListEmpty AuditsFederatedAuthRequestIssueReason = "AccountsListEmpty"

	// AuditsFederatedAuthRequestIssueReasonIDTokenHTTPNotFound enum const
	AuditsFederatedAuthRequestIssueReasonIDTokenHTTPNotFound AuditsFederatedAuthRequestIssueReason = "IdTokenHttpNotFound"

	// AuditsFederatedAuthRequestIssueReasonIDTokenNoResponse enum const
	AuditsFederatedAuthRequestIssueReasonIDTokenNoResponse AuditsFederatedAuthRequestIssueReason = "IdTokenNoResponse"

	// AuditsFederatedAuthRequestIssueReasonIDTokenInvalidResponse enum const
	AuditsFederatedAuthRequestIssueReasonIDTokenInvalidResponse AuditsFederatedAuthRequestIssueReason = "IdTokenInvalidResponse"

	// AuditsFederatedAuthRequestIssueReasonIDTokenInvalidRequest enum const
	AuditsFederatedAuthRequestIssueReasonIDTokenInvalidRequest AuditsFederatedAuthRequestIssueReason = "IdTokenInvalidRequest"

	// AuditsFederatedAuthRequestIssueReasonErrorIDToken enum const
	AuditsFederatedAuthRequestIssueReasonErrorIDToken AuditsFederatedAuthRequestIssueReason = "ErrorIdToken"

	// AuditsFederatedAuthRequestIssueReasonCanceled enum const
	AuditsFederatedAuthRequestIssueReasonCanceled AuditsFederatedAuthRequestIssueReason = "Canceled"

	// AuditsFederatedAuthRequestIssueReasonRpPageNotVisible enum const
	AuditsFederatedAuthRequestIssueReasonRpPageNotVisible AuditsFederatedAuthRequestIssueReason = "RpPageNotVisible"
)

// AuditsClientHintIssueDetails This issue tracks client hints related issues. It's used to deprecate old
// features, encourage the use of new ones, and provide general guidance.
type AuditsClientHintIssueDetails struct {

	// SourceCodeLocation ...
	SourceCodeLocation *AuditsSourceCodeLocation `json:"sourceCodeLocation"`

	// ClientHintIssueReason ...
	ClientHintIssueReason AuditsClientHintIssueReason `json:"clientHintIssueReason"`
}

// AuditsInspectorIssueCode A unique identifier for the type of issue. Each type may use one of the
// optional fields in InspectorIssueDetails to convey more specific
// information about the kind of issue.
type AuditsInspectorIssueCode string

const (
	// AuditsInspectorIssueCodeCookieIssue enum const
	AuditsInspectorIssueCodeCookieIssue AuditsInspectorIssueCode = "CookieIssue"

	// AuditsInspectorIssueCodeMixedContentIssue enum const
	AuditsInspectorIssueCodeMixedContentIssue AuditsInspectorIssueCode = "MixedContentIssue"

	// AuditsInspectorIssueCodeBlockedByResponseIssue enum const
	AuditsInspectorIssueCodeBlockedByResponseIssue AuditsInspectorIssueCode = "BlockedByResponseIssue"

	// AuditsInspectorIssueCodeHeavyAdIssue enum const
	AuditsInspectorIssueCodeHeavyAdIssue AuditsInspectorIssueCode = "HeavyAdIssue"

	// AuditsInspectorIssueCodeContentSecurityPolicyIssue enum const
	AuditsInspectorIssueCodeContentSecurityPolicyIssue AuditsInspectorIssueCode = "ContentSecurityPolicyIssue"

	// AuditsInspectorIssueCodeSharedArrayBufferIssue enum const
	AuditsInspectorIssueCodeSharedArrayBufferIssue AuditsInspectorIssueCode = "SharedArrayBufferIssue"

	// AuditsInspectorIssueCodeTrustedWebActivityIssue enum const
	AuditsInspectorIssueCodeTrustedWebActivityIssue AuditsInspectorIssueCode = "TrustedWebActivityIssue"

	// AuditsInspectorIssueCodeLowTextContrastIssue enum const
	AuditsInspectorIssueCodeLowTextContrastIssue AuditsInspectorIssueCode = "LowTextContrastIssue"

	// AuditsInspectorIssueCodeCorsIssue enum const
	AuditsInspectorIssueCodeCorsIssue AuditsInspectorIssueCode = "CorsIssue"

	// AuditsInspectorIssueCodeAttributionReportingIssue enum const
	AuditsInspectorIssueCodeAttributionReportingIssue AuditsInspectorIssueCode = "AttributionReportingIssue"

	// AuditsInspectorIssueCodeQuirksModeIssue enum const
	AuditsInspectorIssueCodeQuirksModeIssue AuditsInspectorIssueCode = "QuirksModeIssue"

	// AuditsInspectorIssueCodeNavigatorUserAgentIssue enum const
	AuditsInspectorIssueCodeNavigatorUserAgentIssue AuditsInspectorIssueCode = "NavigatorUserAgentIssue"

	// AuditsInspectorIssueCodeGenericIssue enum const
	AuditsInspectorIssueCodeGenericIssue AuditsInspectorIssueCode = "GenericIssue"

	// AuditsInspectorIssueCodeDeprecationIssue enum const
	AuditsInspectorIssueCodeDeprecationIssue AuditsInspectorIssueCode = "DeprecationIssue"

	// AuditsInspectorIssueCodeClientHintIssue enum const
	AuditsInspectorIssueCodeClientHintIssue AuditsInspectorIssueCode = "ClientHintIssue"

	// AuditsInspectorIssueCodeFederatedAuthRequestIssue enum const
	AuditsInspectorIssueCodeFederatedAuthRequestIssue AuditsInspectorIssueCode = "FederatedAuthRequestIssue"
)

// AuditsInspectorIssueDetails This struct holds a list of optional fields with additional information
// specific to the kind of issue. When adding a new issue code, please also
// add a new optional field to this type.
type AuditsInspectorIssueDetails struct {

	// CookieIssueDetails (optional) ...
	CookieIssueDetails *AuditsCookieIssueDetails `json:"cookieIssueDetails,omitempty"`

	// MixedContentIssueDetails (optional) ...
	MixedContentIssueDetails *AuditsMixedContentIssueDetails `json:"mixedContentIssueDetails,omitempty"`

	// BlockedByResponseIssueDetails (optional) ...
	BlockedByResponseIssueDetails *AuditsBlockedByResponseIssueDetails `json:"blockedByResponseIssueDetails,omitempty"`

	// HeavyAdIssueDetails (optional) ...
	HeavyAdIssueDetails *AuditsHeavyAdIssueDetails `json:"heavyAdIssueDetails,omitempty"`

	// ContentSecurityPolicyIssueDetails (optional) ...
	ContentSecurityPolicyIssueDetails *AuditsContentSecurityPolicyIssueDetails `json:"contentSecurityPolicyIssueDetails,omitempty"`

	// SharedArrayBufferIssueDetails (optional) ...
	SharedArrayBufferIssueDetails *AuditsSharedArrayBufferIssueDetails `json:"sharedArrayBufferIssueDetails,omitempty"`

	// TwaQualityEnforcementDetails (optional) ...
	TwaQualityEnforcementDetails *AuditsTrustedWebActivityIssueDetails `json:"twaQualityEnforcementDetails,omitempty"`

	// LowTextContrastIssueDetails (optional) ...
	LowTextContrastIssueDetails *AuditsLowTextContrastIssueDetails `json:"lowTextContrastIssueDetails,omitempty"`

	// CorsIssueDetails (optional) ...
	CorsIssueDetails *AuditsCorsIssueDetails `json:"corsIssueDetails,omitempty"`

	// AttributionReportingIssueDetails (optional) ...
	AttributionReportingIssueDetails *AuditsAttributionReportingIssueDetails `json:"attributionReportingIssueDetails,omitempty"`

	// QuirksModeIssueDetails (optional) ...
	QuirksModeIssueDetails *AuditsQuirksModeIssueDetails `json:"quirksModeIssueDetails,omitempty"`

	// NavigatorUserAgentIssueDetails (optional) ...
	NavigatorUserAgentIssueDetails *AuditsNavigatorUserAgentIssueDetails `json:"navigatorUserAgentIssueDetails,omitempty"`

	// GenericIssueDetails (optional) ...
	GenericIssueDetails *AuditsGenericIssueDetails `json:"genericIssueDetails,omitempty"`

	// DeprecationIssueDetails (optional) ...
	DeprecationIssueDetails *AuditsDeprecationIssueDetails `json:"deprecationIssueDetails,omitempty"`

	// ClientHintIssueDetails (optional) ...
	ClientHintIssueDetails *AuditsClientHintIssueDetails `json:"clientHintIssueDetails,omitempty"`

	// FederatedAuthRequestIssueDetails (optional) ...
	FederatedAuthRequestIssueDetails *AuditsFederatedAuthRequestIssueDetails `json:"federatedAuthRequestIssueDetails,omitempty"`
}

// AuditsIssueID A unique id for a DevTools inspector issue. Allows other entities (e.g.
// exceptions, CDP message, console messages, etc.) to reference an issue.
type AuditsIssueID string

// AuditsInspectorIssue An inspector issue reported from the back-end.
type AuditsInspectorIssue struct {

	// Code ...
	Code AuditsInspectorIssueCode `json:"code"`

	// Details ...
	Details *AuditsInspectorIssueDetails `json:"details"`

	// IssueID (optional) A unique id for this issue. May be omitted if no other entity (e.g.
	// exception, CDP message, etc.) is referencing this issue.
	IssueID AuditsIssueID `json:"issueId,omitempty"`
}

// AuditsGetEncodedResponseEncoding enum
type AuditsGetEncodedResponseEncoding string

const (
	// AuditsGetEncodedResponseEncodingWebp enum const
	AuditsGetEncodedResponseEncodingWebp AuditsGetEncodedResponseEncoding = "webp"

	// AuditsGetEncodedResponseEncodingJpeg enum const
	AuditsGetEncodedResponseEncodingJpeg AuditsGetEncodedResponseEncoding = "jpeg"

	// AuditsGetEncodedResponseEncodingPng enum const
	AuditsGetEncodedResponseEncodingPng AuditsGetEncodedResponseEncoding = "png"
)

// AuditsGetEncodedResponse Returns the response body and size if it were re-encoded with the specified settings. Only
// applies to images.
type AuditsGetEncodedResponse struct {

	// RequestID Identifier of the network request to get content for.
	RequestID NetworkRequestID `json:"requestId"`

	// Encoding The encoding to use.
	Encoding AuditsGetEncodedResponseEncoding `json:"encoding"`

	// Quality (optional) The quality of the encoding (0-1). (defaults to 1)
	Quality *float64 `json:"quality,omitempty"`

	// SizeOnly (optional) Whether to only return the size information (defaults to false).
	SizeOnly bool `json:"sizeOnly,omitempty"`
}

// ProtoReq name
func (m AuditsGetEncodedResponse) ProtoReq() string { return "Audits.getEncodedResponse" }

// Call the request
func (m AuditsGetEncodedResponse) Call(c Client) (*AuditsGetEncodedResponseResult, error) {
	var res AuditsGetEncodedResponseResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// AuditsGetEncodedResponseResult ...
type AuditsGetEncodedResponseResult struct {

	// Body (optional) The encoded body as a base64 string. Omitted if sizeOnly is true.
	Body []byte `json:"body,omitempty"`

	// OriginalSize Size before re-encoding.
	OriginalSize int `json:"originalSize"`

	// EncodedSize Size after re-encoding.
	EncodedSize int `json:"encodedSize"`
}

// AuditsDisable Disables issues domain, prevents further issues from being reported to the client.
type AuditsDisable struct {
}

// ProtoReq name
func (m AuditsDisable) ProtoReq() string { return "Audits.disable" }

// Call sends the request
func (m AuditsDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AuditsEnable Enables issues domain, sends the issues collected so far to the client by means of the
// `issueAdded` event.
type AuditsEnable struct {
}

// ProtoReq name
func (m AuditsEnable) ProtoReq() string { return "Audits.enable" }

// Call sends the request
func (m AuditsEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AuditsCheckContrast Runs the contrast check for the target page. Found issues are reported
// using Audits.issueAdded event.
type AuditsCheckContrast struct {

	// ReportAAA (optional) Whether to report WCAG AAA level issues. Default is false.
	ReportAAA bool `json:"reportAAA,omitempty"`
}

// ProtoReq name
func (m AuditsCheckContrast) ProtoReq() string { return "Audits.checkContrast" }

// Call sends the request
func (m AuditsCheckContrast) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AuditsIssueAdded ...
type AuditsIssueAdded struct {

	// Issue ...
	Issue *AuditsInspectorIssue `json:"issue"`
}

// ProtoEvent name
func (evt AuditsIssueAdded) ProtoEvent() string {
	return "Audits.issueAdded"
}
