// This file is generated by "./lib/proto/generate"

package proto

/*

DOMDebugger

DOM debugging allows setting breakpoints on particular DOM operations and events. JavaScript
execution will stop on these operations as if there was a regular breakpoint set.

*/

// DOMDebuggerDOMBreakpointType DOM breakpoint type.
type DOMDebuggerDOMBreakpointType string

const (
	// DOMDebuggerDOMBreakpointTypeSubtreeModified enum const
	DOMDebuggerDOMBreakpointTypeSubtreeModified DOMDebuggerDOMBreakpointType = "subtree-modified"

	// DOMDebuggerDOMBreakpointTypeAttributeModified enum const
	DOMDebuggerDOMBreakpointTypeAttributeModified DOMDebuggerDOMBreakpointType = "attribute-modified"

	// DOMDebuggerDOMBreakpointTypeNodeRemoved enum const
	DOMDebuggerDOMBreakpointTypeNodeRemoved DOMDebuggerDOMBreakpointType = "node-removed"
)

// DOMDebuggerCSPViolationType (experimental) CSP Violation type.
type DOMDebuggerCSPViolationType string

const (
	// DOMDebuggerCSPViolationTypeTrustedtypeSinkViolation enum const
	DOMDebuggerCSPViolationTypeTrustedtypeSinkViolation DOMDebuggerCSPViolationType = "trustedtype-sink-violation"

	// DOMDebuggerCSPViolationTypeTrustedtypePolicyViolation enum const
	DOMDebuggerCSPViolationTypeTrustedtypePolicyViolation DOMDebuggerCSPViolationType = "trustedtype-policy-violation"
)

// DOMDebuggerEventListener Object event listener.
type DOMDebuggerEventListener struct {

	// Type `EventListener`'s type.
	Type string `json:"type"`

	// UseCapture `EventListener`'s useCapture.
	UseCapture bool `json:"useCapture"`

	// Passive `EventListener`'s passive flag.
	Passive bool `json:"passive"`

	// Once `EventListener`'s once flag.
	Once bool `json:"once"`

	// ScriptID Script id of the handler code.
	ScriptID RuntimeScriptID `json:"scriptId"`

	// LineNumber Line number in the script (0-based).
	LineNumber int `json:"lineNumber"`

	// ColumnNumber Column number in the script (0-based).
	ColumnNumber int `json:"columnNumber"`

	// Handler (optional) Event handler function value.
	Handler *RuntimeRemoteObject `json:"handler,omitempty"`

	// OriginalHandler (optional) Event original handler function value.
	OriginalHandler *RuntimeRemoteObject `json:"originalHandler,omitempty"`

	// BackendNodeID (optional) Node the listener is added to (if any).
	BackendNodeID DOMBackendNodeID `json:"backendNodeId,omitempty"`
}

// DOMDebuggerGetEventListeners Returns event listeners of the given object.
type DOMDebuggerGetEventListeners struct {

	// ObjectID Identifier of the object to return listeners for.
	ObjectID RuntimeRemoteObjectID `json:"objectId"`

	// Depth (optional) The maximum depth at which Node children should be retrieved, defaults to 1. Use -1 for the
	// entire subtree or provide an integer larger than 0.
	Depth *int `json:"depth,omitempty"`

	// Pierce (optional) Whether or not iframes and shadow roots should be traversed when returning the subtree
	// (default is false). Reports listeners for all contexts if pierce is enabled.
	Pierce bool `json:"pierce,omitempty"`
}

// ProtoReq name
func (m DOMDebuggerGetEventListeners) ProtoReq() string { return "DOMDebugger.getEventListeners" }

// Call the request
func (m DOMDebuggerGetEventListeners) Call(c Client) (*DOMDebuggerGetEventListenersResult, error) {
	var res DOMDebuggerGetEventListenersResult
	return &res, call(m.ProtoReq(), m, &res, c)
}

// DOMDebuggerGetEventListenersResult ...
type DOMDebuggerGetEventListenersResult struct {

	// Listeners Array of relevant listeners.
	Listeners []*DOMDebuggerEventListener `json:"listeners"`
}

// DOMDebuggerRemoveDOMBreakpoint Removes DOM breakpoint that was set using `setDOMBreakpoint`.
type DOMDebuggerRemoveDOMBreakpoint struct {

	// NodeID Identifier of the node to remove breakpoint from.
	NodeID DOMNodeID `json:"nodeId"`

	// Type Type of the breakpoint to remove.
	Type DOMDebuggerDOMBreakpointType `json:"type"`
}

// ProtoReq name
func (m DOMDebuggerRemoveDOMBreakpoint) ProtoReq() string { return "DOMDebugger.removeDOMBreakpoint" }

// Call sends the request
func (m DOMDebuggerRemoveDOMBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerRemoveEventListenerBreakpoint Removes breakpoint on particular DOM event.
type DOMDebuggerRemoveEventListenerBreakpoint struct {

	// EventName Event name.
	EventName string `json:"eventName"`

	// TargetName (experimental) (optional) EventTarget interface name.
	TargetName string `json:"targetName,omitempty"`
}

// ProtoReq name
func (m DOMDebuggerRemoveEventListenerBreakpoint) ProtoReq() string {
	return "DOMDebugger.removeEventListenerBreakpoint"
}

// Call sends the request
func (m DOMDebuggerRemoveEventListenerBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerRemoveInstrumentationBreakpoint (experimental) Removes breakpoint on particular native event.
type DOMDebuggerRemoveInstrumentationBreakpoint struct {

	// EventName Instrumentation name to stop on.
	EventName string `json:"eventName"`
}

// ProtoReq name
func (m DOMDebuggerRemoveInstrumentationBreakpoint) ProtoReq() string {
	return "DOMDebugger.removeInstrumentationBreakpoint"
}

// Call sends the request
func (m DOMDebuggerRemoveInstrumentationBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerRemoveXHRBreakpoint Removes breakpoint from XMLHttpRequest.
type DOMDebuggerRemoveXHRBreakpoint struct {

	// URL Resource URL substring.
	URL string `json:"url"`
}

// ProtoReq name
func (m DOMDebuggerRemoveXHRBreakpoint) ProtoReq() string { return "DOMDebugger.removeXHRBreakpoint" }

// Call sends the request
func (m DOMDebuggerRemoveXHRBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerSetBreakOnCSPViolation (experimental) Sets breakpoint on particular CSP violations.
type DOMDebuggerSetBreakOnCSPViolation struct {

	// ViolationTypes CSP Violations to stop upon.
	ViolationTypes []DOMDebuggerCSPViolationType `json:"violationTypes"`
}

// ProtoReq name
func (m DOMDebuggerSetBreakOnCSPViolation) ProtoReq() string {
	return "DOMDebugger.setBreakOnCSPViolation"
}

// Call sends the request
func (m DOMDebuggerSetBreakOnCSPViolation) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerSetDOMBreakpoint Sets breakpoint on particular operation with DOM.
type DOMDebuggerSetDOMBreakpoint struct {

	// NodeID Identifier of the node to set breakpoint on.
	NodeID DOMNodeID `json:"nodeId"`

	// Type Type of the operation to stop upon.
	Type DOMDebuggerDOMBreakpointType `json:"type"`
}

// ProtoReq name
func (m DOMDebuggerSetDOMBreakpoint) ProtoReq() string { return "DOMDebugger.setDOMBreakpoint" }

// Call sends the request
func (m DOMDebuggerSetDOMBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerSetEventListenerBreakpoint Sets breakpoint on particular DOM event.
type DOMDebuggerSetEventListenerBreakpoint struct {

	// EventName DOM Event name to stop on (any DOM event will do).
	EventName string `json:"eventName"`

	// TargetName (experimental) (optional) EventTarget interface name to stop on. If equal to `"*"` or not provided, will stop on any
	// EventTarget.
	TargetName string `json:"targetName,omitempty"`
}

// ProtoReq name
func (m DOMDebuggerSetEventListenerBreakpoint) ProtoReq() string {
	return "DOMDebugger.setEventListenerBreakpoint"
}

// Call sends the request
func (m DOMDebuggerSetEventListenerBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerSetInstrumentationBreakpoint (experimental) Sets breakpoint on particular native event.
type DOMDebuggerSetInstrumentationBreakpoint struct {

	// EventName Instrumentation name to stop on.
	EventName string `json:"eventName"`
}

// ProtoReq name
func (m DOMDebuggerSetInstrumentationBreakpoint) ProtoReq() string {
	return "DOMDebugger.setInstrumentationBreakpoint"
}

// Call sends the request
func (m DOMDebuggerSetInstrumentationBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// DOMDebuggerSetXHRBreakpoint Sets breakpoint on XMLHttpRequest.
type DOMDebuggerSetXHRBreakpoint struct {

	// URL Resource URL substring. All XHRs having this substring in the URL will get stopped upon.
	URL string `json:"url"`
}

// ProtoReq name
func (m DOMDebuggerSetXHRBreakpoint) ProtoReq() string { return "DOMDebugger.setXHRBreakpoint" }

// Call sends the request
func (m DOMDebuggerSetXHRBreakpoint) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}
