package api

/************************************************
  generated by IDE. for [LicenseAPI]
************************************************/

import (
	"github.com/sacloud/libsacloud/sacloud"
)

/************************************************
   To support fluent interface for Find()
************************************************/

// Reset 検索条件のリセット
func (api *LicenseAPI) Reset() *LicenseAPI {
	api.reset()
	return api
}

// Offset オフセット
func (api *LicenseAPI) Offset(offset int) *LicenseAPI {
	api.offset(offset)
	return api
}

// Limit リミット
func (api *LicenseAPI) Limit(limit int) *LicenseAPI {
	api.limit(limit)
	return api
}

// Include 取得する項目
func (api *LicenseAPI) Include(key string) *LicenseAPI {
	api.include(key)
	return api
}

// Exclude 除外する項目
func (api *LicenseAPI) Exclude(key string) *LicenseAPI {
	api.exclude(key)
	return api
}

// FilterBy 指定キーでのフィルター
func (api *LicenseAPI) FilterBy(key string, value interface{}) *LicenseAPI {
	api.filterBy(key, value, false)
	return api
}

// FilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *LicenseAPI) FilterMultiBy(key string, value interface{}) *LicenseAPI {
	api.filterBy(key, value, true)
	return api
}

// WithNameLike 名称条件
func (api *LicenseAPI) WithNameLike(name string) *LicenseAPI {
	return api.FilterBy("Name", name)
}

// WithTag タグ条件
func (api *LicenseAPI) WithTag(tag string) *LicenseAPI {
	return api.FilterBy("Tags.Name", tag)
}

// WithTags タグ(複数)条件
func (api *LicenseAPI) WithTags(tags []string) *LicenseAPI {
	return api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *LicenseAPI) WithSizeGib(size int) *LicenseAPI {
// 	api.FilterBy("SizeMB", size*1024)
// 	return api
// }

// func (api *LicenseAPI) WithSharedScope() *LicenseAPI {
// 	api.FilterBy("Scope", "shared")
// 	return api
// }

// func (api *LicenseAPI) WithUserScope() *LicenseAPI {
// 	api.FilterBy("Scope", "user")
// 	return api
// }

// SortBy 指定キーでのソート
func (api *LicenseAPI) SortBy(key string, reverse bool) *LicenseAPI {
	api.sortBy(key, reverse)
	return api
}

// SortByName 名称でのソート
func (api *LicenseAPI) SortByName(reverse bool) *LicenseAPI {
	api.sortByName(reverse)
	return api
}

// func (api *LicenseAPI) SortBySize(reverse bool) *LicenseAPI {
// 	api.sortBy("SizeMB", reverse)
// 	return api
// }

/************************************************
   To support Setxxx interface for Find()
************************************************/

// SetEmpty 検索条件のリセット
func (api *LicenseAPI) SetEmpty() {
	api.reset()
}

// SetOffset オフセット
func (api *LicenseAPI) SetOffset(offset int) {
	api.offset(offset)
}

// SetLimit リミット
func (api *LicenseAPI) SetLimit(limit int) {
	api.limit(limit)
}

// SetInclude 取得する項目
func (api *LicenseAPI) SetInclude(key string) {
	api.include(key)
}

// SetExclude 除外する項目
func (api *LicenseAPI) SetExclude(key string) {
	api.exclude(key)
}

// SetFilterBy 指定キーでのフィルター
func (api *LicenseAPI) SetFilterBy(key string, value interface{}) {
	api.filterBy(key, value, false)
}

// SetFilterMultiBy 任意項目でのフィルタ(完全一致 OR条件)
func (api *LicenseAPI) SetFilterMultiBy(key string, value interface{}) {
	api.filterBy(key, value, true)
}

// SetNameLike 名称条件
func (api *LicenseAPI) SetNameLike(name string) {
	api.FilterBy("Name", name)
}

// SetTag タグ条件
func (api *LicenseAPI) SetTag(tag string) {
	api.FilterBy("Tags.Name", tag)
}

// SetTags タグ(複数)条件
func (api *LicenseAPI) SetTags(tags []string) {
	api.FilterBy("Tags.Name", []interface{}{tags})
}

// func (api *LicenseAPI) SetSizeGib(size int) {
// 	api.FilterBy("SizeMB", size*1024)
// }

// func (api *LicenseAPI) SetSharedScope() {
// 	api.FilterBy("Scope", "shared")
// }

// func (api *LicenseAPI) SetUserScope() {
// 	api.FilterBy("Scope", "user")
// }

// SetSortBy 指定キーでのソート
func (api *LicenseAPI) SetSortBy(key string, reverse bool) {
	api.sortBy(key, reverse)
}

// SetSortByName 名称でのソート
func (api *LicenseAPI) SetSortByName(reverse bool) {
	api.sortByName(reverse)
}

// func (api *LicenseAPI) SetSortBySize(reverse bool) {
// 	api.sortBy("SizeMB", reverse)
// }

/************************************************
  To support CRUD(Create/Read/Update/Delete)
************************************************/

// New 新規作成用パラメーター作成
func (api *LicenseAPI) New() *sacloud.License {
	return &sacloud.License{}
}

// Create 新規作成
func (api *LicenseAPI) Create(value *sacloud.License) (*sacloud.License, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.create(api.createRequest(value), res)
	})
}

// Read 読み取り
func (api *LicenseAPI) Read(id int64) (*sacloud.License, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.read(id, nil, res)
	})
}

// Update 更新
func (api *LicenseAPI) Update(id int64, value *sacloud.License) (*sacloud.License, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.update(id, api.createRequest(value), res)
	})
}

// Delete 削除
func (api *LicenseAPI) Delete(id int64) (*sacloud.License, error) {
	return api.request(func(res *sacloud.Response) error {
		return api.delete(id, nil, res)
	})
}

/************************************************
  Inner functions
************************************************/

func (api *LicenseAPI) setStateValue(setFunc func(*sacloud.Request)) *LicenseAPI {
	api.baseAPI.setStateValue(setFunc)
	return api
}

func (api *LicenseAPI) request(f func(*sacloud.Response) error) (*sacloud.License, error) {
	res := &sacloud.Response{}
	err := f(res)
	if err != nil {
		return nil, err
	}
	return res.License, nil
}

func (api *LicenseAPI) createRequest(value *sacloud.License) *sacloud.Request {
	req := &sacloud.Request{}
	req.License = value
	return req
}
