package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainLogs invokes the alidns.DescribeDomainLogs API synchronously
// api document: https://help.aliyun.com/api/alidns/describedomainlogs.html
func (client *Client) DescribeDomainLogs(request *DescribeDomainLogsRequest) (response *DescribeDomainLogsResponse, err error) {
	response = CreateDescribeDomainLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainLogsWithChan invokes the alidns.DescribeDomainLogs API asynchronously
// api document: https://help.aliyun.com/api/alidns/describedomainlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainLogsWithChan(request *DescribeDomainLogsRequest) (<-chan *DescribeDomainLogsResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainLogsWithCallback invokes the alidns.DescribeDomainLogs API asynchronously
// api document: https://help.aliyun.com/api/alidns/describedomainlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainLogsWithCallback(request *DescribeDomainLogsRequest, callback func(response *DescribeDomainLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainLogsRequest is the request struct for api DescribeDomainLogs
type DescribeDomainLogsRequest struct {
	*requests.RpcRequest
	Lang         string           `position:"Query" name:"Lang"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	KeyWord      string           `position:"Query" name:"KeyWord"`
	GroupId      string           `position:"Query" name:"GroupId"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	StartDate    string           `position:"Query" name:"StartDate"`
	EndDate      string           `position:"Query" name:"endDate"`
}

// DescribeDomainLogsResponse is the response struct for api DescribeDomainLogs
type DescribeDomainLogsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	DomainLogs DomainLogs `json:"DomainLogs" xml:"DomainLogs"`
}

// CreateDescribeDomainLogsRequest creates a request to invoke DescribeDomainLogs API
func CreateDescribeDomainLogsRequest() (request *DescribeDomainLogsRequest) {
	request = &DescribeDomainLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDomainLogs", "", "")
	return
}

// CreateDescribeDomainLogsResponse creates a response to parse from DescribeDomainLogs response
func CreateDescribeDomainLogsResponse() (response *DescribeDomainLogsResponse) {
	response = &DescribeDomainLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
