package codec

// hexMap is a precalculated map of hex nibbles
const hexMap = "" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\x00\x01\x02\x03\x04\x05\x06\x07\x08\x09\xff\xff\xff\xff\xff\xff" +
	"\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\x0a\x0b\x0c\x0d\x0e\x0f\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff" +
	"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"

// likelyHexChars is a set of characters that you would expect to find at
// least one of in hex encoded data. This risks missing some hex data that
// doesn't contain these characters, but gives you the performance gain of not
// trying to decode a lot of long symbols in code.
var likelyHexChars = make([]bool, 256)

func init() {
	for _, c := range `0123456789` {
		likelyHexChars[c] = true
	}
}

// decodeHex decodes hex data
func decodeHex(encodedValue string) string {
	size := len(encodedValue)
	// hex should have two characters per byte
	if size%2 != 0 {
		return ""
	}
	if !hasByte(encodedValue, likelyHexChars) {
		return ""
	}

	decodedValue := make([]byte, size/2)
	for i := 0; i < size; i += 2 {
		n1 := hexMap[encodedValue[i]]
		n2 := hexMap[encodedValue[i+1]]
		if n1|n2 == '\xff' {
			return ""
		}
		b := n1<<4 | n2
		if !printableASCII[b] {
			return ""
		}
		decodedValue[i/2] = b
	}

	return string(decodedValue)
}
