// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/ml/v1/model_service.proto

package ml // import "google.golang.org/genproto/googleapis/cloud/ml/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents a machine learning solution.
//
// A model can have multiple versions, each of which is a deployed, trained
// model ready to receive prediction requests. The model itself is just a
// container.
type Model struct {
	// Required. The name specified for the model when it was created.
	//
	// The model name must be unique within the project it is created in.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description specified for the model when it was created.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The default version of the model. This version will be used to
	// handle prediction requests that do not specify a version.
	//
	// You can change the default version by calling
	// [projects.methods.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
	DefaultVersion *Version `protobuf:"bytes,3,opt,name=default_version,json=defaultVersion,proto3" json:"default_version,omitempty"`
	// Optional. The list of regions where the model is going to be deployed.
	// Currently only one region per model is supported.
	// Defaults to 'us-central1' if nothing is set.
	Regions []string `protobuf:"bytes,4,rep,name=regions,proto3" json:"regions,omitempty"`
	// Optional. If true, enables StackDriver Logging for online prediction.
	// Default is false.
	OnlinePredictionLogging bool     `protobuf:"varint,5,opt,name=online_prediction_logging,json=onlinePredictionLogging,proto3" json:"online_prediction_logging,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *Model) Reset()         { *m = Model{} }
func (m *Model) String() string { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()    {}
func (*Model) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{0}
}
func (m *Model) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model.Unmarshal(m, b)
}
func (m *Model) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model.Marshal(b, m, deterministic)
}
func (dst *Model) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model.Merge(dst, src)
}
func (m *Model) XXX_Size() int {
	return xxx_messageInfo_Model.Size(m)
}
func (m *Model) XXX_DiscardUnknown() {
	xxx_messageInfo_Model.DiscardUnknown(m)
}

var xxx_messageInfo_Model proto.InternalMessageInfo

func (m *Model) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Model) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Model) GetDefaultVersion() *Version {
	if m != nil {
		return m.DefaultVersion
	}
	return nil
}

func (m *Model) GetRegions() []string {
	if m != nil {
		return m.Regions
	}
	return nil
}

func (m *Model) GetOnlinePredictionLogging() bool {
	if m != nil {
		return m.OnlinePredictionLogging
	}
	return false
}

// Represents a version of the model.
//
// Each version is a trained model deployed in the cloud, ready to handle
// prediction requests. A model can have multiple versions. You can get
// information about all of the versions of a given model by calling
// [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list).
type Version struct {
	// Required.The name specified for the version when it was created.
	//
	// The version name must be unique within the model it is created in.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The description specified for the version when it was created.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. If true, this version will be used to handle prediction
	// requests that do not specify a version.
	//
	// You can change the default version by calling
	// [projects.methods.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
	IsDefault bool `protobuf:"varint,3,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Required. The Google Cloud Storage location of the trained model used to
	// create the version. See the
	// [overview of model deployment](/ml/docs/concepts/deployment-overview) for
	// more informaiton.
	//
	// When passing Version to
	// [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create)
	// the model service uses the specified location as the source of the model.
	// Once deployed, the model version is hosted by the prediction service, so
	// this location is useful only as a historical record.
	DeploymentUri string `protobuf:"bytes,4,opt,name=deployment_uri,json=deploymentUri,proto3" json:"deployment_uri,omitempty"`
	// Output only. The time the version was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the version was last used for prediction.
	LastUseTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=last_use_time,json=lastUseTime,proto3" json:"last_use_time,omitempty"`
	// Optional. The Google Cloud ML runtime version to use for this deployment.
	// If not set, Google Cloud ML will choose a version.
	RuntimeVersion string `protobuf:"bytes,8,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	// Optional. Manually select the number of nodes to use for serving the
	// model. If unset (i.e., by default), the number of nodes used to serve
	// the model automatically scales with traffic. However, care should be
	// taken to ramp up traffic according to the model's ability to scale. If
	// your model needs to handle bursts of traffic beyond it's ability to
	// scale, it is recommended you set this field appropriately.
	ManualScaling        *ManualScaling `protobuf:"bytes,9,opt,name=manual_scaling,json=manualScaling,proto3" json:"manual_scaling,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{1}
}
func (m *Version) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Version.Unmarshal(m, b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Version.Marshal(b, m, deterministic)
}
func (dst *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(dst, src)
}
func (m *Version) XXX_Size() int {
	return xxx_messageInfo_Version.Size(m)
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Version) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Version) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *Version) GetDeploymentUri() string {
	if m != nil {
		return m.DeploymentUri
	}
	return ""
}

func (m *Version) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Version) GetLastUseTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUseTime
	}
	return nil
}

func (m *Version) GetRuntimeVersion() string {
	if m != nil {
		return m.RuntimeVersion
	}
	return ""
}

func (m *Version) GetManualScaling() *ManualScaling {
	if m != nil {
		return m.ManualScaling
	}
	return nil
}

// Options for manually scaling a model.
type ManualScaling struct {
	// The number of nodes to allocate for this model. These nodes are always up,
	// starting from the time the model is deployed, so the cost of operating
	// this model will be proportional to nodes * number of hours since
	// deployment.
	Nodes                int32    `protobuf:"varint,1,opt,name=nodes,proto3" json:"nodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManualScaling) Reset()         { *m = ManualScaling{} }
func (m *ManualScaling) String() string { return proto.CompactTextString(m) }
func (*ManualScaling) ProtoMessage()    {}
func (*ManualScaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{2}
}
func (m *ManualScaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManualScaling.Unmarshal(m, b)
}
func (m *ManualScaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManualScaling.Marshal(b, m, deterministic)
}
func (dst *ManualScaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManualScaling.Merge(dst, src)
}
func (m *ManualScaling) XXX_Size() int {
	return xxx_messageInfo_ManualScaling.Size(m)
}
func (m *ManualScaling) XXX_DiscardUnknown() {
	xxx_messageInfo_ManualScaling.DiscardUnknown(m)
}

var xxx_messageInfo_ManualScaling proto.InternalMessageInfo

func (m *ManualScaling) GetNodes() int32 {
	if m != nil {
		return m.Nodes
	}
	return 0
}

// Request message for the CreateModel method.
type CreateModelRequest struct {
	// Required. The project name.
	//
	// Authorization: requires `Editor` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The model to create.
	Model                *Model   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelRequest) Reset()         { *m = CreateModelRequest{} }
func (m *CreateModelRequest) String() string { return proto.CompactTextString(m) }
func (*CreateModelRequest) ProtoMessage()    {}
func (*CreateModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{3}
}
func (m *CreateModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelRequest.Unmarshal(m, b)
}
func (m *CreateModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelRequest.Marshal(b, m, deterministic)
}
func (dst *CreateModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelRequest.Merge(dst, src)
}
func (m *CreateModelRequest) XXX_Size() int {
	return xxx_messageInfo_CreateModelRequest.Size(m)
}
func (m *CreateModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelRequest proto.InternalMessageInfo

func (m *CreateModelRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

// Request message for the ListModels method.
type ListModelsRequest struct {
	// Required. The name of the project whose models are to be listed.
	//
	// Authorization: requires `Viewer` role on the specified project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The number of models to retrieve per "page" of results. If there
	// are more remaining results than this number, the response message will
	// contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize             int32    `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{4}
}
func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (dst *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(dst, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListModelsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for the ListModels method.
type ListModelsResponse struct {
	// The list of models.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{5}
}
func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (dst *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(dst, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModels() []*Model {
	if m != nil {
		return m.Models
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the GetModel method.
type GetModelRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{6}
}
func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (dst *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(dst, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the DeleteModel method.
type DeleteModelRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Editor` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{7}
}
func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(dst, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Uploads the provided trained model version to Cloud Machine Learning.
type CreateVersionRequest struct {
	// Required. The name of the model.
	//
	// Authorization: requires `Editor` role on the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The version details.
	Version              *Version `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateVersionRequest) Reset()         { *m = CreateVersionRequest{} }
func (m *CreateVersionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateVersionRequest) ProtoMessage()    {}
func (*CreateVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{8}
}
func (m *CreateVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateVersionRequest.Unmarshal(m, b)
}
func (m *CreateVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateVersionRequest.Marshal(b, m, deterministic)
}
func (dst *CreateVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateVersionRequest.Merge(dst, src)
}
func (m *CreateVersionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateVersionRequest.Size(m)
}
func (m *CreateVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateVersionRequest proto.InternalMessageInfo

func (m *CreateVersionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateVersionRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// Request message for the ListVersions method.
type ListVersionsRequest struct {
	// Required. The name of the model for which to list the version.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	//
	// You get the token from the `next_page_token` field of the response from
	// the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The number of versions to retrieve per "page" of results. If
	// there are more remaining results than this number, the response message
	// will contain a valid value in the `next_page_token` field.
	//
	// The default value is 20, and the maximum page size is 100.
	PageSize             int32    `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVersionsRequest) Reset()         { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()    {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{9}
}
func (m *ListVersionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVersionsRequest.Unmarshal(m, b)
}
func (m *ListVersionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVersionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListVersionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVersionsRequest.Merge(dst, src)
}
func (m *ListVersionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListVersionsRequest.Size(m)
}
func (m *ListVersionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVersionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListVersionsRequest proto.InternalMessageInfo

func (m *ListVersionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListVersionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListVersionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for the ListVersions method.
type ListVersionsResponse struct {
	// The list of versions.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions,proto3" json:"versions,omitempty"`
	// Optional. Pass this token as the `page_token` field of the request for a
	// subsequent call.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListVersionsResponse) Reset()         { *m = ListVersionsResponse{} }
func (m *ListVersionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListVersionsResponse) ProtoMessage()    {}
func (*ListVersionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{10}
}
func (m *ListVersionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListVersionsResponse.Unmarshal(m, b)
}
func (m *ListVersionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListVersionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListVersionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListVersionsResponse.Merge(dst, src)
}
func (m *ListVersionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListVersionsResponse.Size(m)
}
func (m *ListVersionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListVersionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListVersionsResponse proto.InternalMessageInfo

func (m *ListVersionsResponse) GetVersions() []*Version {
	if m != nil {
		return m.Versions
	}
	return nil
}

func (m *ListVersionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for the GetVersion method.
type GetVersionRequest struct {
	// Required. The name of the version.
	//
	// Authorization: requires `Viewer` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetVersionRequest) Reset()         { *m = GetVersionRequest{} }
func (m *GetVersionRequest) String() string { return proto.CompactTextString(m) }
func (*GetVersionRequest) ProtoMessage()    {}
func (*GetVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{11}
}
func (m *GetVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetVersionRequest.Unmarshal(m, b)
}
func (m *GetVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetVersionRequest.Marshal(b, m, deterministic)
}
func (dst *GetVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetVersionRequest.Merge(dst, src)
}
func (m *GetVersionRequest) XXX_Size() int {
	return xxx_messageInfo_GetVersionRequest.Size(m)
}
func (m *GetVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetVersionRequest proto.InternalMessageInfo

func (m *GetVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the DeleteVerionRequest method.
type DeleteVersionRequest struct {
	// Required. The name of the version. You can get the names of all the
	// versions of a model by calling
	// [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list).
	//
	// Authorization: requires `Editor` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteVersionRequest) Reset()         { *m = DeleteVersionRequest{} }
func (m *DeleteVersionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteVersionRequest) ProtoMessage()    {}
func (*DeleteVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{12}
}
func (m *DeleteVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteVersionRequest.Unmarshal(m, b)
}
func (m *DeleteVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteVersionRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteVersionRequest.Merge(dst, src)
}
func (m *DeleteVersionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteVersionRequest.Size(m)
}
func (m *DeleteVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteVersionRequest proto.InternalMessageInfo

func (m *DeleteVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for the SetDefaultVersion request.
type SetDefaultVersionRequest struct {
	// Required. The name of the version to make the default for the model. You
	// can get the names of all the versions of a model by calling
	// [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list).
	//
	// Authorization: requires `Editor` role on the parent project.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetDefaultVersionRequest) Reset()         { *m = SetDefaultVersionRequest{} }
func (m *SetDefaultVersionRequest) String() string { return proto.CompactTextString(m) }
func (*SetDefaultVersionRequest) ProtoMessage()    {}
func (*SetDefaultVersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_service_ee3e6c8b5c2161ac, []int{13}
}
func (m *SetDefaultVersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetDefaultVersionRequest.Unmarshal(m, b)
}
func (m *SetDefaultVersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetDefaultVersionRequest.Marshal(b, m, deterministic)
}
func (dst *SetDefaultVersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetDefaultVersionRequest.Merge(dst, src)
}
func (m *SetDefaultVersionRequest) XXX_Size() int {
	return xxx_messageInfo_SetDefaultVersionRequest.Size(m)
}
func (m *SetDefaultVersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetDefaultVersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetDefaultVersionRequest proto.InternalMessageInfo

func (m *SetDefaultVersionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func init() {
	proto.RegisterType((*Model)(nil), "google.cloud.ml.v1.Model")
	proto.RegisterType((*Version)(nil), "google.cloud.ml.v1.Version")
	proto.RegisterType((*ManualScaling)(nil), "google.cloud.ml.v1.ManualScaling")
	proto.RegisterType((*CreateModelRequest)(nil), "google.cloud.ml.v1.CreateModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.ml.v1.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.ml.v1.ListModelsResponse")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.ml.v1.GetModelRequest")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.ml.v1.DeleteModelRequest")
	proto.RegisterType((*CreateVersionRequest)(nil), "google.cloud.ml.v1.CreateVersionRequest")
	proto.RegisterType((*ListVersionsRequest)(nil), "google.cloud.ml.v1.ListVersionsRequest")
	proto.RegisterType((*ListVersionsResponse)(nil), "google.cloud.ml.v1.ListVersionsResponse")
	proto.RegisterType((*GetVersionRequest)(nil), "google.cloud.ml.v1.GetVersionRequest")
	proto.RegisterType((*DeleteVersionRequest)(nil), "google.cloud.ml.v1.DeleteVersionRequest")
	proto.RegisterType((*SetDefaultVersionRequest)(nil), "google.cloud.ml.v1.SetDefaultVersionRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Creates a model which will later contain one or more versions.
	//
	// You must add at least one version before you can request predictions from
	// the model. Add versions by calling
	// [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create).
	CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists the models in a project.
	//
	// Each project can contain multiple models, and each model can have multiple
	// versions.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Gets information about a model, including its name, the description (if
	// set), and the default version (if at least one version of the model has
	// been deployed).
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes a model.
	//
	// You can only delete a model if there are no versions in it. You can delete
	// versions by calling
	// [projects.models.versions.delete](/ml/reference/rest/v1/projects.models.versions/delete).
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new version of a model from a trained TensorFlow model.
	//
	// If the version created in the cloud by this call is the first deployed
	// version of the specified model, it will be made the default version of the
	// model. When you add a version to a model that already has one or more
	// versions, the default version does not automatically change. If you want a
	// new version to be the default, you must call
	// [projects.models.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
	CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets basic information about all the versions of a model.
	//
	// If you expect that a model has a lot of versions, or if you need to handle
	// only a limited number of results at a time, you can request that the list
	// be retrieved in batches (called pages):
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets information about a model version.
	//
	// Models can have multiple versions. You can call
	// [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list)
	// to get the same information that this method returns for all of the
	// versions of a model.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deletes a model version.
	//
	// Each model can have multiple versions deployed and in use at any given
	// time. Use this method to remove a single version.
	//
	// Note: You cannot delete the version that is set as the default version
	// of the model unless it is the only remaining version.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Designates a version to be the default for the model.
	//
	// The default version is used for prediction requests made against the model
	// that don't specify a version.
	//
	// The first version to be created for a model is automatically set as the
	// default. You must make any subsequent changes to the default version
	// setting manually using this method.
	SetDefaultVersion(ctx context.Context, in *SetDefaultVersionRequest, opts ...grpc.CallOption) (*Version, error)
}

type modelServiceClient struct {
	cc *grpc.ClientConn
}

func NewModelServiceClient(cc *grpc.ClientConn) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) CreateModel(ctx context.Context, in *CreateModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/CreateModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/CreateVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/ListVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/GetVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/DeleteVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) SetDefaultVersion(ctx context.Context, in *SetDefaultVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, "/google.cloud.ml.v1.ModelService/SetDefaultVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
type ModelServiceServer interface {
	// Creates a model which will later contain one or more versions.
	//
	// You must add at least one version before you can request predictions from
	// the model. Add versions by calling
	// [projects.models.versions.create](/ml/reference/rest/v1/projects.models.versions/create).
	CreateModel(context.Context, *CreateModelRequest) (*Model, error)
	// Lists the models in a project.
	//
	// Each project can contain multiple models, and each model can have multiple
	// versions.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Gets information about a model, including its name, the description (if
	// set), and the default version (if at least one version of the model has
	// been deployed).
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Deletes a model.
	//
	// You can only delete a model if there are no versions in it. You can delete
	// versions by calling
	// [projects.models.versions.delete](/ml/reference/rest/v1/projects.models.versions/delete).
	DeleteModel(context.Context, *DeleteModelRequest) (*longrunning.Operation, error)
	// Creates a new version of a model from a trained TensorFlow model.
	//
	// If the version created in the cloud by this call is the first deployed
	// version of the specified model, it will be made the default version of the
	// model. When you add a version to a model that already has one or more
	// versions, the default version does not automatically change. If you want a
	// new version to be the default, you must call
	// [projects.models.versions.setDefault](/ml/reference/rest/v1/projects.models.versions/setDefault).
	CreateVersion(context.Context, *CreateVersionRequest) (*longrunning.Operation, error)
	// Gets basic information about all the versions of a model.
	//
	// If you expect that a model has a lot of versions, or if you need to handle
	// only a limited number of results at a time, you can request that the list
	// be retrieved in batches (called pages):
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets information about a model version.
	//
	// Models can have multiple versions. You can call
	// [projects.models.versions.list](/ml/reference/rest/v1/projects.models.versions/list)
	// to get the same information that this method returns for all of the
	// versions of a model.
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deletes a model version.
	//
	// Each model can have multiple versions deployed and in use at any given
	// time. Use this method to remove a single version.
	//
	// Note: You cannot delete the version that is set as the default version
	// of the model unless it is the only remaining version.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunning.Operation, error)
	// Designates a version to be the default for the model.
	//
	// The default version is used for prediction requests made against the model
	// that don't specify a version.
	//
	// The first version to be created for a model is automatically set as the
	// default. You must make any subsequent changes to the default version
	// setting manually using this method.
	SetDefaultVersion(context.Context, *SetDefaultVersionRequest) (*Version, error)
}

func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	s.RegisterService(&_ModelService_serviceDesc, srv)
}

func _ModelService_CreateModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/CreateModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateModel(ctx, req.(*CreateModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/CreateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).CreateVersion(ctx, req.(*CreateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/DeleteVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_SetDefaultVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).SetDefaultVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.ml.v1.ModelService/SetDefaultVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).SetDefaultVersion(ctx, req.(*SetDefaultVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ml.v1.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateModel",
			Handler:    _ModelService_CreateModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _ModelService_CreateVersion_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ModelService_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ModelService_GetVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _ModelService_DeleteVersion_Handler,
		},
		{
			MethodName: "SetDefaultVersion",
			Handler:    _ModelService_SetDefaultVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/ml/v1/model_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/ml/v1/model_service.proto", fileDescriptor_model_service_ee3e6c8b5c2161ac)
}

var fileDescriptor_model_service_ee3e6c8b5c2161ac = []byte{
	// 996 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcf, 0x6f, 0xe3, 0x44,
	0x14, 0x96, 0xdb, 0xa6, 0x4d, 0x5e, 0x36, 0xad, 0x3a, 0x14, 0xc8, 0x66, 0x29, 0x04, 0xaf, 0xda,
	0x86, 0x00, 0xb6, 0x52, 0x8a, 0x10, 0x59, 0x01, 0xd2, 0x52, 0x69, 0x39, 0xec, 0x8a, 0xca, 0xdd,
	0xe5, 0x80, 0x84, 0x2c, 0x6f, 0x32, 0x6b, 0x06, 0xec, 0x19, 0xe3, 0x19, 0x07, 0x58, 0x58, 0x21,
	0xc1, 0x91, 0x23, 0xdc, 0xf9, 0xa3, 0x38, 0x71, 0xe7, 0xc6, 0x99, 0x3b, 0x9a, 0x1f, 0x4e, 0xed,
	0xc4, 0x89, 0x0b, 0x12, 0x37, 0xcf, 0x9b, 0xef, 0xcd, 0xfb, 0xe6, 0x7d, 0xef, 0xbd, 0x31, 0x1c,
	0x87, 0x8c, 0x85, 0x11, 0x76, 0x27, 0x11, 0xcb, 0xa6, 0x6e, 0x1c, 0xb9, 0xb3, 0x91, 0x1b, 0xb3,
	0x29, 0x8e, 0x7c, 0x8e, 0xd3, 0x19, 0x99, 0x60, 0x27, 0x49, 0x99, 0x60, 0x08, 0x69, 0x9c, 0xa3,
	0x70, 0x4e, 0x1c, 0x39, 0xb3, 0x51, 0xef, 0x25, 0xe3, 0x1b, 0x24, 0xc4, 0x0d, 0x28, 0x65, 0x22,
	0x10, 0x84, 0x51, 0xae, 0x3d, 0x7a, 0xcf, 0x17, 0x77, 0x33, 0xf1, 0xb9, 0x31, 0xdf, 0x36, 0xe6,
	0x88, 0xd1, 0x30, 0xcd, 0x28, 0x25, 0x34, 0x74, 0x59, 0x82, 0xd3, 0x92, 0xef, 0x2b, 0x06, 0xa4,
	0x56, 0x8f, 0xb3, 0x27, 0xae, 0x20, 0x31, 0xe6, 0x22, 0x88, 0x13, 0x0d, 0xb0, 0xff, 0xb0, 0xa0,
	0xf1, 0x40, 0xd2, 0x44, 0x08, 0xb6, 0x68, 0x10, 0xe3, 0xae, 0xd5, 0xb7, 0x06, 0x2d, 0x4f, 0x7d,
	0xa3, 0x3e, 0xb4, 0xa7, 0x98, 0x4f, 0x52, 0x92, 0xc8, 0x43, 0xbb, 0x1b, 0x6a, 0xab, 0x68, 0x42,
	0xe7, 0xb0, 0x37, 0xc5, 0x4f, 0x82, 0x2c, 0x12, 0xfe, 0x0c, 0xa7, 0x5c, 0xa2, 0x36, 0xfb, 0xd6,
	0xa0, 0x7d, 0x7a, 0xcb, 0x59, 0xbe, 0xa8, 0xf3, 0x89, 0x86, 0x78, 0xbb, 0xc6, 0xc7, 0xac, 0x51,
	0x17, 0x76, 0x52, 0x1c, 0x4a, 0xde, 0xdd, 0xad, 0xfe, 0xe6, 0xa0, 0xe5, 0xe5, 0x4b, 0x34, 0x86,
	0x9b, 0x8c, 0x46, 0x84, 0x62, 0x3f, 0x49, 0xf1, 0x94, 0x4c, 0x64, 0x50, 0x3f, 0x62, 0x61, 0x48,
	0x68, 0xd8, 0x6d, 0xf4, 0xad, 0x41, 0xd3, 0x7b, 0x51, 0x03, 0x2e, 0xe6, 0xfb, 0xf7, 0xf5, 0xb6,
	0xfd, 0xf7, 0x06, 0xec, 0xe4, 0x11, 0xfe, 0xdb, 0xed, 0x0e, 0x01, 0x08, 0xf7, 0x0d, 0x59, 0x75,
	0xb1, 0xa6, 0xd7, 0x22, 0xfc, 0x5c, 0x1b, 0xd0, 0x11, 0xec, 0x4e, 0x71, 0x12, 0xb1, 0x6f, 0x63,
	0x4c, 0x85, 0x9f, 0xa5, 0xa4, 0xbb, 0xa5, 0xce, 0xe8, 0x5c, 0x59, 0x1f, 0xa5, 0x04, 0xdd, 0x81,
	0xf6, 0x24, 0xc5, 0x81, 0xc0, 0xbe, 0xcc, 0xbe, 0x62, 0xdd, 0x3e, 0xed, 0xe5, 0xf9, 0xc9, 0xa5,
	0x71, 0x1e, 0xe6, 0xd2, 0x78, 0xa0, 0xe1, 0xd2, 0x80, 0xde, 0x87, 0x4e, 0x14, 0x70, 0xe1, 0x67,
	0xdc, 0xb8, 0x6f, 0xd7, 0xba, 0xb7, 0xa5, 0xc3, 0x23, 0xae, 0xfd, 0x4f, 0x60, 0x2f, 0xcd, 0xa8,
	0xf4, 0x9c, 0x0b, 0xd4, 0x54, 0x24, 0x77, 0x8d, 0x39, 0xcf, 0xd0, 0x47, 0xb0, 0x1b, 0x07, 0x34,
	0x0b, 0x22, 0x9f, 0x4f, 0x82, 0x48, 0xa6, 0xb7, 0xa5, 0x22, 0xbd, 0x5a, 0x25, 0xe4, 0x03, 0x85,
	0xbc, 0xd4, 0x40, 0xaf, 0x13, 0x17, 0x97, 0xf6, 0x11, 0x74, 0x4a, 0xfb, 0xe8, 0x00, 0x1a, 0x94,
	0x4d, 0x31, 0x57, 0xd9, 0x6f, 0x78, 0x7a, 0x61, 0x7f, 0x06, 0xe8, 0x43, 0x75, 0x4f, 0x55, 0x7f,
	0x1e, 0xfe, 0x2a, 0xc3, 0x5c, 0xa0, 0x17, 0x60, 0x3b, 0x09, 0x52, 0x4c, 0x85, 0x91, 0xca, 0xac,
	0x90, 0x0b, 0x0d, 0xd5, 0x4e, 0x4a, 0xa6, 0xf6, 0xe9, 0xcd, 0x4a, 0x56, 0xea, 0x20, 0x8d, 0xb3,
	0x43, 0xd8, 0xbf, 0x4f, 0xb8, 0x50, 0x36, 0x5e, 0x77, 0xfa, 0x21, 0x40, 0x12, 0x84, 0xd8, 0x17,
	0xec, 0x4b, 0x4c, 0x8d, 0x8a, 0x2d, 0x69, 0x79, 0x28, 0x0d, 0xe8, 0x16, 0xa8, 0x85, 0xcf, 0xc9,
	0x53, 0xad, 0x5f, 0xc3, 0x6b, 0x4a, 0xc3, 0x25, 0x79, 0x8a, 0x6d, 0x06, 0xa8, 0x18, 0x88, 0x27,
	0x8c, 0x72, 0x8c, 0x46, 0xb0, 0xad, 0x78, 0xc8, 0x4b, 0x6f, 0xae, 0x27, 0x6c, 0x80, 0xe8, 0x18,
	0xf6, 0x28, 0xfe, 0x46, 0xf8, 0x05, 0x26, 0xba, 0x26, 0x3b, 0xd2, 0x7c, 0x91, 0xb3, 0xb1, 0x8f,
	0x60, 0xef, 0x1e, 0x16, 0xa5, 0xac, 0x55, 0x94, 0xb7, 0x3d, 0x00, 0x74, 0x8e, 0x23, 0xbc, 0x90,
	0xdf, 0x2a, 0x24, 0x86, 0x03, 0xad, 0x44, 0xde, 0x9f, 0x35, 0xd9, 0x7a, 0x1b, 0x76, 0xf2, 0x5a,
	0xda, 0xa8, 0x6f, 0xf6, 0x1c, 0x6b, 0x13, 0x78, 0x4e, 0x26, 0xca, 0xd8, 0xff, 0x57, 0x4d, 0xbe,
	0x86, 0x83, 0x72, 0x28, 0xa3, 0xca, 0x3b, 0xd0, 0x34, 0x6c, 0x72, 0x5d, 0xd6, 0x52, 0x9f, 0x83,
	0xaf, 0xad, 0xcd, 0x09, 0xec, 0xdf, 0xc3, 0x62, 0x21, 0x8f, 0x55, 0x39, 0x1f, 0xc2, 0x81, 0x56,
	0xe7, 0x1a, 0x58, 0x07, 0xba, 0x97, 0x58, 0x9c, 0x97, 0x66, 0xe6, 0x1a, 0xfc, 0xe9, 0x5f, 0x2d,
	0xb8, 0xa1, 0x44, 0xbf, 0xd4, 0x4f, 0x0f, 0xfa, 0x01, 0xda, 0x85, 0x56, 0x43, 0xc7, 0x55, 0x77,
	0x5e, 0xee, 0xc5, 0xde, 0xea, 0x9a, 0xb5, 0xdf, 0xfc, 0xf1, 0xf7, 0x3f, 0x7f, 0xd9, 0x38, 0xb1,
	0x5f, 0x96, 0xef, 0xdc, 0x77, 0x5a, 0xb1, 0xf7, 0x92, 0x94, 0x7d, 0x81, 0x27, 0x82, 0xbb, 0xc3,
	0x67, 0xfa, 0xed, 0xe3, 0x63, 0xdd, 0x8c, 0xe8, 0x27, 0x0b, 0xe0, 0xaa, 0x49, 0xd0, 0x51, 0xd5,
	0xc1, 0x4b, 0xdd, 0xda, 0x3b, 0xae, 0x83, 0x69, 0x55, 0xed, 0x63, 0x45, 0xa6, 0x8f, 0x6a, 0xc8,
	0xa0, 0x14, 0x9a, 0x79, 0xe3, 0xa0, 0xdb, 0x55, 0x67, 0x2f, 0xb4, 0xd5, 0xba, 0x04, 0x94, 0x63,
	0xca, 0xb4, 0x17, 0x22, 0x9a, 0x80, 0xee, 0xf0, 0x19, 0xfa, 0x1e, 0xda, 0x85, 0x2e, 0xac, 0x4e,
	0xfd, 0x72, 0x9b, 0xf6, 0x0e, 0x73, 0x5c, 0xe1, 0x79, 0x77, 0x3e, 0xce, 0x9f, 0xf7, 0x3c, 0xfa,
	0xb0, 0x2e, 0xfa, 0xaf, 0x16, 0x74, 0x4a, 0xad, 0x8d, 0x06, 0xab, 0xb5, 0x2f, 0x57, 0x56, 0x1d,
	0x85, 0xb1, 0xa2, 0x70, 0x66, 0xbf, 0x56, 0x9d, 0xf4, 0x2b, 0x12, 0x6e, 0xde, 0x44, 0xe3, 0x7c,
	0x12, 0x48, 0x5a, 0x37, 0x8a, 0xfd, 0x89, 0x4e, 0x56, 0x29, 0xbd, 0x30, 0x2c, 0x7a, 0x83, 0x7a,
	0xa0, 0x29, 0x8a, 0x91, 0xe2, 0xf7, 0x3a, 0xba, 0x3e, 0x3f, 0x55, 0xa5, 0x57, 0xdd, 0x5b, 0x5d,
	0xa5, 0x4b, 0xdd, 0xdd, 0x5b, 0x37, 0x41, 0x16, 0x58, 0xac, 0x12, 0x6a, 0x4e, 0x41, 0x6a, 0xf6,
	0xb3, 0x05, 0x9d, 0xd2, 0x68, 0xa8, 0xd6, 0xac, 0x6a, 0x7a, 0xd4, 0x69, 0x66, 0xd8, 0x0c, 0xff,
	0x05, 0x9b, 0xdf, 0x2c, 0xd8, 0x5f, 0x1a, 0x3e, 0xe8, 0x8d, 0x2a, 0x46, 0xab, 0x66, 0xd4, 0xfa,
	0x0c, 0x7d, 0xa0, 0x38, 0xbd, 0x6b, 0x9f, 0x5d, 0x9b, 0xd3, 0x98, 0xcf, 0x03, 0x8d, 0xad, 0xe1,
	0xdd, 0x10, 0x7a, 0x13, 0x16, 0x2f, 0x85, 0x08, 0x12, 0xe2, 0xcc, 0x46, 0x77, 0xf7, 0x8b, 0x83,
	0xf0, 0x42, 0xfe, 0x2c, 0x5d, 0x58, 0x9f, 0x9e, 0x19, 0x70, 0xc8, 0xa2, 0x80, 0x86, 0x0e, 0x4b,
	0x43, 0x37, 0xc4, 0x54, 0xfd, 0x4a, 0xb9, 0x7a, 0x2b, 0x48, 0x08, 0x2f, 0xfe, 0xcb, 0xdf, 0x89,
	0xa3, 0xc7, 0xdb, 0x0a, 0xf0, 0xd6, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xcc, 0x07, 0x42, 0xf7,
	0xeb, 0x0b, 0x00, 0x00,
}
