// +build !ignore_autogenerated

/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	spec "github.com/go-openapi/spec"
	resource "k8s.io/apimachinery/pkg/api/resource"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	common "k8s.io/kube-openapi/pkg/common"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Addon":                                 schema_pkg_apis_core_v1alpha1_Addon(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Addons":                                schema_pkg_apis_core_v1alpha1_Addons(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AdmissionPlugin":                       schema_pkg_apis_core_v1alpha1_AdmissionPlugin(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Alerting":                              schema_pkg_apis_core_v1alpha1_Alerting(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditConfig":                           schema_pkg_apis_core_v1alpha1_AuditConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditPolicy":                           schema_pkg_apis_core_v1alpha1_AuditPolicy(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AvailabilityZone":                      schema_pkg_apis_core_v1alpha1_AvailabilityZone(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucket":                          schema_pkg_apis_core_v1alpha1_BackupBucket(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketList":                      schema_pkg_apis_core_v1alpha1_BackupBucketList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketProvider":                  schema_pkg_apis_core_v1alpha1_BackupBucketProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketSpec":                      schema_pkg_apis_core_v1alpha1_BackupBucketSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketStatus":                    schema_pkg_apis_core_v1alpha1_BackupBucketStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntry":                           schema_pkg_apis_core_v1alpha1_BackupEntry(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntryList":                       schema_pkg_apis_core_v1alpha1_BackupEntryList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntrySpec":                       schema_pkg_apis_core_v1alpha1_BackupEntrySpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntryStatus":                     schema_pkg_apis_core_v1alpha1_BackupEntryStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CRI":                                   schema_pkg_apis_core_v1alpha1_CRI(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudInfo":                             schema_pkg_apis_core_v1alpha1_CloudInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfile":                          schema_pkg_apis_core_v1alpha1_CloudProfile(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfileList":                      schema_pkg_apis_core_v1alpha1_CloudProfileList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfileSpec":                      schema_pkg_apis_core_v1alpha1_CloudProfileSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterAutoscaler":                     schema_pkg_apis_core_v1alpha1_ClusterAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterInfo":                           schema_pkg_apis_core_v1alpha1_ClusterInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition":                             schema_pkg_apis_core_v1alpha1_Condition(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ContainerRuntime":                      schema_pkg_apis_core_v1alpha1_ContainerRuntime(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerDeployment":                  schema_pkg_apis_core_v1alpha1_ControllerDeployment(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallation":                schema_pkg_apis_core_v1alpha1_ControllerInstallation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationList":            schema_pkg_apis_core_v1alpha1_ControllerInstallationList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationSpec":            schema_pkg_apis_core_v1alpha1_ControllerInstallationSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationStatus":          schema_pkg_apis_core_v1alpha1_ControllerInstallationStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistration":                schema_pkg_apis_core_v1alpha1_ControllerRegistration(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistrationList":            schema_pkg_apis_core_v1alpha1_ControllerRegistrationList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistrationSpec":            schema_pkg_apis_core_v1alpha1_ControllerRegistrationSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerResource":                    schema_pkg_apis_core_v1alpha1_ControllerResource(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNS":                                   schema_pkg_apis_core_v1alpha1_DNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSIncludeExclude":                     schema_pkg_apis_core_v1alpha1_DNSIncludeExclude(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSProvider":                           schema_pkg_apis_core_v1alpha1_DNSProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DataVolume":                            schema_pkg_apis_core_v1alpha1_DataVolume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Endpoint":                              schema_pkg_apis_core_v1alpha1_Endpoint(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExpirableVersion":                      schema_pkg_apis_core_v1alpha1_ExpirableVersion(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Extension":                             schema_pkg_apis_core_v1alpha1_Extension(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExtensionResourceState":                schema_pkg_apis_core_v1alpha1_ExtensionResourceState(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Gardener":                              schema_pkg_apis_core_v1alpha1_Gardener(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.GardenerResourceData":                  schema_pkg_apis_core_v1alpha1_GardenerResourceData(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Hibernation":                           schema_pkg_apis_core_v1alpha1_Hibernation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.HibernationSchedule":                   schema_pkg_apis_core_v1alpha1_HibernationSchedule(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.HorizontalPodAutoscalerConfig":         schema_pkg_apis_core_v1alpha1_HorizontalPodAutoscalerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeAPIServerConfig":                   schema_pkg_apis_core_v1alpha1_KubeAPIServerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeControllerManagerConfig":           schema_pkg_apis_core_v1alpha1_KubeControllerManagerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeProxyConfig":                       schema_pkg_apis_core_v1alpha1_KubeProxyConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeSchedulerConfig":                   schema_pkg_apis_core_v1alpha1_KubeSchedulerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfig":                         schema_pkg_apis_core_v1alpha1_KubeletConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEviction":                 schema_pkg_apis_core_v1alpha1_KubeletConfigEviction(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionMinimumReclaim":   schema_pkg_apis_core_v1alpha1_KubeletConfigEvictionMinimumReclaim(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionSoftGracePeriod":  schema_pkg_apis_core_v1alpha1_KubeletConfigEvictionSoftGracePeriod(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigReserved":                 schema_pkg_apis_core_v1alpha1_KubeletConfigReserved(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Kubernetes":                            schema_pkg_apis_core_v1alpha1_Kubernetes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesConfig":                      schema_pkg_apis_core_v1alpha1_KubernetesConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesDashboard":                   schema_pkg_apis_core_v1alpha1_KubernetesDashboard(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesInfo":                        schema_pkg_apis_core_v1alpha1_KubernetesInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesSettings":                    schema_pkg_apis_core_v1alpha1_KubernetesSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError":                             schema_pkg_apis_core_v1alpha1_LastError(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation":                         schema_pkg_apis_core_v1alpha1_LastOperation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Machine":                               schema_pkg_apis_core_v1alpha1_Machine(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineControllerManagerSettings":      schema_pkg_apis_core_v1alpha1_MachineControllerManagerSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImage":                          schema_pkg_apis_core_v1alpha1_MachineImage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImageVersion":                   schema_pkg_apis_core_v1alpha1_MachineImageVersion(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineType":                           schema_pkg_apis_core_v1alpha1_MachineType(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineTypeStorage":                    schema_pkg_apis_core_v1alpha1_MachineTypeStorage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Maintenance":                           schema_pkg_apis_core_v1alpha1_Maintenance(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceAutoUpdate":                 schema_pkg_apis_core_v1alpha1_MaintenanceAutoUpdate(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceTimeWindow":                 schema_pkg_apis_core_v1alpha1_MaintenanceTimeWindow(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Monitoring":                            schema_pkg_apis_core_v1alpha1_Monitoring(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.NamedResourceReference":                schema_pkg_apis_core_v1alpha1_NamedResourceReference(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Networking":                            schema_pkg_apis_core_v1alpha1_Networking(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.NginxIngress":                          schema_pkg_apis_core_v1alpha1_NginxIngress(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.OIDCConfig":                            schema_pkg_apis_core_v1alpha1_OIDCConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.OpenIDConnectClientAuthentication":     schema_pkg_apis_core_v1alpha1_OpenIDConnectClientAuthentication(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Plant":                                 schema_pkg_apis_core_v1alpha1_Plant(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantList":                             schema_pkg_apis_core_v1alpha1_PlantList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantSpec":                             schema_pkg_apis_core_v1alpha1_PlantSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantStatus":                           schema_pkg_apis_core_v1alpha1_PlantStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Project":                               schema_pkg_apis_core_v1alpha1_Project(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectList":                           schema_pkg_apis_core_v1alpha1_ProjectList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectMember":                         schema_pkg_apis_core_v1alpha1_ProjectMember(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectSpec":                           schema_pkg_apis_core_v1alpha1_ProjectSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectStatus":                         schema_pkg_apis_core_v1alpha1_ProjectStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectTolerations":                    schema_pkg_apis_core_v1alpha1_ProjectTolerations(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Provider":                              schema_pkg_apis_core_v1alpha1_Provider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Quota":                                 schema_pkg_apis_core_v1alpha1_Quota(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.QuotaList":                             schema_pkg_apis_core_v1alpha1_QuotaList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.QuotaSpec":                             schema_pkg_apis_core_v1alpha1_QuotaSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Region":                                schema_pkg_apis_core_v1alpha1_Region(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceData":                          schema_pkg_apis_core_v1alpha1_ResourceData(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceWatchCacheSize":                schema_pkg_apis_core_v1alpha1_ResourceWatchCacheSize(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SecretBinding":                         schema_pkg_apis_core_v1alpha1_SecretBinding(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SecretBindingList":                     schema_pkg_apis_core_v1alpha1_SecretBindingList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Seed":                                  schema_pkg_apis_core_v1alpha1_Seed(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedBackup":                            schema_pkg_apis_core_v1alpha1_SeedBackup(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedDNS":                               schema_pkg_apis_core_v1alpha1_SeedDNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedList":                              schema_pkg_apis_core_v1alpha1_SeedList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedNetworks":                          schema_pkg_apis_core_v1alpha1_SeedNetworks(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedProvider":                          schema_pkg_apis_core_v1alpha1_SeedProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSelector":                          schema_pkg_apis_core_v1alpha1_SeedSelector(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingExcessCapacityReservation":  schema_pkg_apis_core_v1alpha1_SeedSettingExcessCapacityReservation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingLoadBalancerServices":       schema_pkg_apis_core_v1alpha1_SeedSettingLoadBalancerServices(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingScheduling":                 schema_pkg_apis_core_v1alpha1_SeedSettingScheduling(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingShootDNS":                   schema_pkg_apis_core_v1alpha1_SeedSettingShootDNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingVerticalPodAutoscaler":      schema_pkg_apis_core_v1alpha1_SeedSettingVerticalPodAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettings":                          schema_pkg_apis_core_v1alpha1_SeedSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSpec":                              schema_pkg_apis_core_v1alpha1_SeedSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedStatus":                            schema_pkg_apis_core_v1alpha1_SeedStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedTaint":                             schema_pkg_apis_core_v1alpha1_SeedTaint(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolume":                            schema_pkg_apis_core_v1alpha1_SeedVolume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolumeProvider":                    schema_pkg_apis_core_v1alpha1_SeedVolumeProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ServiceAccountConfig":                  schema_pkg_apis_core_v1alpha1_ServiceAccountConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Shoot":                                 schema_pkg_apis_core_v1alpha1_Shoot(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootList":                             schema_pkg_apis_core_v1alpha1_ShootList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootMachineImage":                     schema_pkg_apis_core_v1alpha1_ShootMachineImage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootNetworks":                         schema_pkg_apis_core_v1alpha1_ShootNetworks(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootSpec":                             schema_pkg_apis_core_v1alpha1_ShootSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootState":                            schema_pkg_apis_core_v1alpha1_ShootState(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStateList":                        schema_pkg_apis_core_v1alpha1_ShootStateList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStateSpec":                        schema_pkg_apis_core_v1alpha1_ShootStateSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStatus":                           schema_pkg_apis_core_v1alpha1_ShootStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration":                            schema_pkg_apis_core_v1alpha1_Toleration(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.VerticalPodAutoscaler":                 schema_pkg_apis_core_v1alpha1_VerticalPodAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Volume":                                schema_pkg_apis_core_v1alpha1_Volume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.VolumeType":                            schema_pkg_apis_core_v1alpha1_VolumeType(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.WatchCacheSizes":                       schema_pkg_apis_core_v1alpha1_WatchCacheSizes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Worker":                                schema_pkg_apis_core_v1alpha1_Worker(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerKubernetes":                      schema_pkg_apis_core_v1alpha1_WorkerKubernetes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerSystemComponents":                schema_pkg_apis_core_v1alpha1_WorkerSystemComponents(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Addon":                                  schema_pkg_apis_core_v1beta1_Addon(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Addons":                                 schema_pkg_apis_core_v1beta1_Addons(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.AdmissionPlugin":                        schema_pkg_apis_core_v1beta1_AdmissionPlugin(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Alerting":                               schema_pkg_apis_core_v1beta1_Alerting(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditConfig":                            schema_pkg_apis_core_v1beta1_AuditConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditPolicy":                            schema_pkg_apis_core_v1beta1_AuditPolicy(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.AvailabilityZone":                       schema_pkg_apis_core_v1beta1_AvailabilityZone(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucket":                           schema_pkg_apis_core_v1beta1_BackupBucket(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketList":                       schema_pkg_apis_core_v1beta1_BackupBucketList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketProvider":                   schema_pkg_apis_core_v1beta1_BackupBucketProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketSpec":                       schema_pkg_apis_core_v1beta1_BackupBucketSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketStatus":                     schema_pkg_apis_core_v1beta1_BackupBucketStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntry":                            schema_pkg_apis_core_v1beta1_BackupEntry(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntryList":                        schema_pkg_apis_core_v1beta1_BackupEntryList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntrySpec":                        schema_pkg_apis_core_v1beta1_BackupEntrySpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntryStatus":                      schema_pkg_apis_core_v1beta1_BackupEntryStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.CRI":                                    schema_pkg_apis_core_v1beta1_CRI(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudInfo":                              schema_pkg_apis_core_v1beta1_CloudInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfile":                           schema_pkg_apis_core_v1beta1_CloudProfile(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfileList":                       schema_pkg_apis_core_v1beta1_CloudProfileList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfileSpec":                       schema_pkg_apis_core_v1beta1_CloudProfileSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterAutoscaler":                      schema_pkg_apis_core_v1beta1_ClusterAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterInfo":                            schema_pkg_apis_core_v1beta1_ClusterInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition":                              schema_pkg_apis_core_v1beta1_Condition(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ContainerRuntime":                       schema_pkg_apis_core_v1beta1_ContainerRuntime(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerDeployment":                   schema_pkg_apis_core_v1beta1_ControllerDeployment(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallation":                 schema_pkg_apis_core_v1beta1_ControllerInstallation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationList":             schema_pkg_apis_core_v1beta1_ControllerInstallationList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationSpec":             schema_pkg_apis_core_v1beta1_ControllerInstallationSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationStatus":           schema_pkg_apis_core_v1beta1_ControllerInstallationStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistration":                 schema_pkg_apis_core_v1beta1_ControllerRegistration(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistrationList":             schema_pkg_apis_core_v1beta1_ControllerRegistrationList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistrationSpec":             schema_pkg_apis_core_v1beta1_ControllerRegistrationSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerResource":                     schema_pkg_apis_core_v1beta1_ControllerResource(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.DNS":                                    schema_pkg_apis_core_v1beta1_DNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSIncludeExclude":                      schema_pkg_apis_core_v1beta1_DNSIncludeExclude(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSProvider":                            schema_pkg_apis_core_v1beta1_DNSProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.DataVolume":                             schema_pkg_apis_core_v1beta1_DataVolume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Endpoint":                               schema_pkg_apis_core_v1beta1_Endpoint(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ExpirableVersion":                       schema_pkg_apis_core_v1beta1_ExpirableVersion(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Extension":                              schema_pkg_apis_core_v1beta1_Extension(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Gardener":                               schema_pkg_apis_core_v1beta1_Gardener(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Hibernation":                            schema_pkg_apis_core_v1beta1_Hibernation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.HibernationSchedule":                    schema_pkg_apis_core_v1beta1_HibernationSchedule(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.HorizontalPodAutoscalerConfig":          schema_pkg_apis_core_v1beta1_HorizontalPodAutoscalerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeAPIServerConfig":                    schema_pkg_apis_core_v1beta1_KubeAPIServerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeControllerManagerConfig":            schema_pkg_apis_core_v1beta1_KubeControllerManagerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeProxyConfig":                        schema_pkg_apis_core_v1beta1_KubeProxyConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeSchedulerConfig":                    schema_pkg_apis_core_v1beta1_KubeSchedulerConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfig":                          schema_pkg_apis_core_v1beta1_KubeletConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEviction":                  schema_pkg_apis_core_v1beta1_KubeletConfigEviction(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionMinimumReclaim":    schema_pkg_apis_core_v1beta1_KubeletConfigEvictionMinimumReclaim(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionSoftGracePeriod":   schema_pkg_apis_core_v1beta1_KubeletConfigEvictionSoftGracePeriod(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigReserved":                  schema_pkg_apis_core_v1beta1_KubeletConfigReserved(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Kubernetes":                             schema_pkg_apis_core_v1beta1_Kubernetes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesConfig":                       schema_pkg_apis_core_v1beta1_KubernetesConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesDashboard":                    schema_pkg_apis_core_v1beta1_KubernetesDashboard(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesInfo":                         schema_pkg_apis_core_v1beta1_KubernetesInfo(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesSettings":                     schema_pkg_apis_core_v1beta1_KubernetesSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError":                              schema_pkg_apis_core_v1beta1_LastError(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation":                          schema_pkg_apis_core_v1beta1_LastOperation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Machine":                                schema_pkg_apis_core_v1beta1_Machine(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineControllerManagerSettings":       schema_pkg_apis_core_v1beta1_MachineControllerManagerSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImage":                           schema_pkg_apis_core_v1beta1_MachineImage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImageVersion":                    schema_pkg_apis_core_v1beta1_MachineImageVersion(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineType":                            schema_pkg_apis_core_v1beta1_MachineType(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineTypeStorage":                     schema_pkg_apis_core_v1beta1_MachineTypeStorage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Maintenance":                            schema_pkg_apis_core_v1beta1_Maintenance(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceAutoUpdate":                  schema_pkg_apis_core_v1beta1_MaintenanceAutoUpdate(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceTimeWindow":                  schema_pkg_apis_core_v1beta1_MaintenanceTimeWindow(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Monitoring":                             schema_pkg_apis_core_v1beta1_Monitoring(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.NamedResourceReference":                 schema_pkg_apis_core_v1beta1_NamedResourceReference(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Networking":                             schema_pkg_apis_core_v1beta1_Networking(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.NginxIngress":                           schema_pkg_apis_core_v1beta1_NginxIngress(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.OIDCConfig":                             schema_pkg_apis_core_v1beta1_OIDCConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.OpenIDConnectClientAuthentication":      schema_pkg_apis_core_v1beta1_OpenIDConnectClientAuthentication(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Plant":                                  schema_pkg_apis_core_v1beta1_Plant(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantList":                              schema_pkg_apis_core_v1beta1_PlantList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantSpec":                              schema_pkg_apis_core_v1beta1_PlantSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantStatus":                            schema_pkg_apis_core_v1beta1_PlantStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Project":                                schema_pkg_apis_core_v1beta1_Project(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectList":                            schema_pkg_apis_core_v1beta1_ProjectList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectMember":                          schema_pkg_apis_core_v1beta1_ProjectMember(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectSpec":                            schema_pkg_apis_core_v1beta1_ProjectSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectStatus":                          schema_pkg_apis_core_v1beta1_ProjectStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectTolerations":                     schema_pkg_apis_core_v1beta1_ProjectTolerations(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Provider":                               schema_pkg_apis_core_v1beta1_Provider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Quota":                                  schema_pkg_apis_core_v1beta1_Quota(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.QuotaList":                              schema_pkg_apis_core_v1beta1_QuotaList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.QuotaSpec":                              schema_pkg_apis_core_v1beta1_QuotaSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Region":                                 schema_pkg_apis_core_v1beta1_Region(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ResourceWatchCacheSize":                 schema_pkg_apis_core_v1beta1_ResourceWatchCacheSize(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SecretBinding":                          schema_pkg_apis_core_v1beta1_SecretBinding(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SecretBindingList":                      schema_pkg_apis_core_v1beta1_SecretBindingList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Seed":                                   schema_pkg_apis_core_v1beta1_Seed(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedBackup":                             schema_pkg_apis_core_v1beta1_SeedBackup(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedDNS":                                schema_pkg_apis_core_v1beta1_SeedDNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedList":                               schema_pkg_apis_core_v1beta1_SeedList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedNetworks":                           schema_pkg_apis_core_v1beta1_SeedNetworks(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedProvider":                           schema_pkg_apis_core_v1beta1_SeedProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSelector":                           schema_pkg_apis_core_v1beta1_SeedSelector(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingExcessCapacityReservation":   schema_pkg_apis_core_v1beta1_SeedSettingExcessCapacityReservation(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingLoadBalancerServices":        schema_pkg_apis_core_v1beta1_SeedSettingLoadBalancerServices(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingScheduling":                  schema_pkg_apis_core_v1beta1_SeedSettingScheduling(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingShootDNS":                    schema_pkg_apis_core_v1beta1_SeedSettingShootDNS(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingVerticalPodAutoscaler":       schema_pkg_apis_core_v1beta1_SeedSettingVerticalPodAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettings":                           schema_pkg_apis_core_v1beta1_SeedSettings(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSpec":                               schema_pkg_apis_core_v1beta1_SeedSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedStatus":                             schema_pkg_apis_core_v1beta1_SeedStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedTaint":                              schema_pkg_apis_core_v1beta1_SeedTaint(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolume":                             schema_pkg_apis_core_v1beta1_SeedVolume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolumeProvider":                     schema_pkg_apis_core_v1beta1_SeedVolumeProvider(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ServiceAccountConfig":                   schema_pkg_apis_core_v1beta1_ServiceAccountConfig(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Shoot":                                  schema_pkg_apis_core_v1beta1_Shoot(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootList":                              schema_pkg_apis_core_v1beta1_ShootList(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootMachineImage":                      schema_pkg_apis_core_v1beta1_ShootMachineImage(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootNetworks":                          schema_pkg_apis_core_v1beta1_ShootNetworks(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootSpec":                              schema_pkg_apis_core_v1beta1_ShootSpec(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootStatus":                            schema_pkg_apis_core_v1beta1_ShootStatus(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration":                             schema_pkg_apis_core_v1beta1_Toleration(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.VerticalPodAutoscaler":                  schema_pkg_apis_core_v1beta1_VerticalPodAutoscaler(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Volume":                                 schema_pkg_apis_core_v1beta1_Volume(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.VolumeType":                             schema_pkg_apis_core_v1beta1_VolumeType(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.WatchCacheSizes":                        schema_pkg_apis_core_v1beta1_WatchCacheSizes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.Worker":                                 schema_pkg_apis_core_v1beta1_Worker(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerKubernetes":                       schema_pkg_apis_core_v1beta1_WorkerKubernetes(ref),
		"github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerSystemComponents":                 schema_pkg_apis_core_v1beta1_WorkerSystemComponents(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPreset":        schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPreset(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPresetList":    schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPresetList(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPresetSpec":    schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPresetSpec(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.KubeAPIServerOpenIDConnect":        schema_pkg_apis_settings_v1alpha1_KubeAPIServerOpenIDConnect(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectClientAuthentication": schema_pkg_apis_settings_v1alpha1_OpenIDConnectClientAuthentication(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPreset":               schema_pkg_apis_settings_v1alpha1_OpenIDConnectPreset(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPresetList":           schema_pkg_apis_settings_v1alpha1_OpenIDConnectPresetList(ref),
		"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPresetSpec":           schema_pkg_apis_settings_v1alpha1_OpenIDConnectPresetSpec(ref),
		"k8s.io/api/autoscaling/v1.CrossVersionObjectReference":                                     schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref),
		"k8s.io/api/autoscaling/v1.ExternalMetricSource":                                            schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ExternalMetricStatus":                                            schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler":                                         schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerCondition":                                schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerList":                                     schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec":                                     schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref),
		"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus":                                   schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref),
		"k8s.io/api/autoscaling/v1.MetricSpec":                                                      schema_k8sio_api_autoscaling_v1_MetricSpec(ref),
		"k8s.io/api/autoscaling/v1.MetricStatus":                                                    schema_k8sio_api_autoscaling_v1_MetricStatus(ref),
		"k8s.io/api/autoscaling/v1.ObjectMetricSource":                                              schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ObjectMetricStatus":                                              schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.PodsMetricSource":                                                schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref),
		"k8s.io/api/autoscaling/v1.PodsMetricStatus":                                                schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.ResourceMetricSource":                                            schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref),
		"k8s.io/api/autoscaling/v1.ResourceMetricStatus":                                            schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref),
		"k8s.io/api/autoscaling/v1.Scale":                                                           schema_k8sio_api_autoscaling_v1_Scale(ref),
		"k8s.io/api/autoscaling/v1.ScaleSpec":                                                       schema_k8sio_api_autoscaling_v1_ScaleSpec(ref),
		"k8s.io/api/autoscaling/v1.ScaleStatus":                                                     schema_k8sio_api_autoscaling_v1_ScaleStatus(ref),
		"k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource":                                       schema_k8sio_api_core_v1_AWSElasticBlockStoreVolumeSource(ref),
		"k8s.io/api/core/v1.Affinity":                                                               schema_k8sio_api_core_v1_Affinity(ref),
		"k8s.io/api/core/v1.AttachedVolume":                                                         schema_k8sio_api_core_v1_AttachedVolume(ref),
		"k8s.io/api/core/v1.AvoidPods":                                                              schema_k8sio_api_core_v1_AvoidPods(ref),
		"k8s.io/api/core/v1.AzureDiskVolumeSource":                                                  schema_k8sio_api_core_v1_AzureDiskVolumeSource(ref),
		"k8s.io/api/core/v1.AzureFilePersistentVolumeSource":                                        schema_k8sio_api_core_v1_AzureFilePersistentVolumeSource(ref),
		"k8s.io/api/core/v1.AzureFileVolumeSource":                                                  schema_k8sio_api_core_v1_AzureFileVolumeSource(ref),
		"k8s.io/api/core/v1.Binding":                                                                schema_k8sio_api_core_v1_Binding(ref),
		"k8s.io/api/core/v1.CSIPersistentVolumeSource":                                              schema_k8sio_api_core_v1_CSIPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CSIVolumeSource":                                                        schema_k8sio_api_core_v1_CSIVolumeSource(ref),
		"k8s.io/api/core/v1.Capabilities":                                                           schema_k8sio_api_core_v1_Capabilities(ref),
		"k8s.io/api/core/v1.CephFSPersistentVolumeSource":                                           schema_k8sio_api_core_v1_CephFSPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CephFSVolumeSource":                                                     schema_k8sio_api_core_v1_CephFSVolumeSource(ref),
		"k8s.io/api/core/v1.CinderPersistentVolumeSource":                                           schema_k8sio_api_core_v1_CinderPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.CinderVolumeSource":                                                     schema_k8sio_api_core_v1_CinderVolumeSource(ref),
		"k8s.io/api/core/v1.ClientIPConfig":                                                         schema_k8sio_api_core_v1_ClientIPConfig(ref),
		"k8s.io/api/core/v1.ComponentCondition":                                                     schema_k8sio_api_core_v1_ComponentCondition(ref),
		"k8s.io/api/core/v1.ComponentStatus":                                                        schema_k8sio_api_core_v1_ComponentStatus(ref),
		"k8s.io/api/core/v1.ComponentStatusList":                                                    schema_k8sio_api_core_v1_ComponentStatusList(ref),
		"k8s.io/api/core/v1.ConfigMap":                                                              schema_k8sio_api_core_v1_ConfigMap(ref),
		"k8s.io/api/core/v1.ConfigMapEnvSource":                                                     schema_k8sio_api_core_v1_ConfigMapEnvSource(ref),
		"k8s.io/api/core/v1.ConfigMapKeySelector":                                                   schema_k8sio_api_core_v1_ConfigMapKeySelector(ref),
		"k8s.io/api/core/v1.ConfigMapList":                                                          schema_k8sio_api_core_v1_ConfigMapList(ref),
		"k8s.io/api/core/v1.ConfigMapNodeConfigSource":                                              schema_k8sio_api_core_v1_ConfigMapNodeConfigSource(ref),
		"k8s.io/api/core/v1.ConfigMapProjection":                                                    schema_k8sio_api_core_v1_ConfigMapProjection(ref),
		"k8s.io/api/core/v1.ConfigMapVolumeSource":                                                  schema_k8sio_api_core_v1_ConfigMapVolumeSource(ref),
		"k8s.io/api/core/v1.Container":                                                              schema_k8sio_api_core_v1_Container(ref),
		"k8s.io/api/core/v1.ContainerImage":                                                         schema_k8sio_api_core_v1_ContainerImage(ref),
		"k8s.io/api/core/v1.ContainerPort":                                                          schema_k8sio_api_core_v1_ContainerPort(ref),
		"k8s.io/api/core/v1.ContainerState":                                                         schema_k8sio_api_core_v1_ContainerState(ref),
		"k8s.io/api/core/v1.ContainerStateRunning":                                                  schema_k8sio_api_core_v1_ContainerStateRunning(ref),
		"k8s.io/api/core/v1.ContainerStateTerminated":                                               schema_k8sio_api_core_v1_ContainerStateTerminated(ref),
		"k8s.io/api/core/v1.ContainerStateWaiting":                                                  schema_k8sio_api_core_v1_ContainerStateWaiting(ref),
		"k8s.io/api/core/v1.ContainerStatus":                                                        schema_k8sio_api_core_v1_ContainerStatus(ref),
		"k8s.io/api/core/v1.DaemonEndpoint":                                                         schema_k8sio_api_core_v1_DaemonEndpoint(ref),
		"k8s.io/api/core/v1.DownwardAPIProjection":                                                  schema_k8sio_api_core_v1_DownwardAPIProjection(ref),
		"k8s.io/api/core/v1.DownwardAPIVolumeFile":                                                  schema_k8sio_api_core_v1_DownwardAPIVolumeFile(ref),
		"k8s.io/api/core/v1.DownwardAPIVolumeSource":                                                schema_k8sio_api_core_v1_DownwardAPIVolumeSource(ref),
		"k8s.io/api/core/v1.EmptyDirVolumeSource":                                                   schema_k8sio_api_core_v1_EmptyDirVolumeSource(ref),
		"k8s.io/api/core/v1.EndpointAddress":                                                        schema_k8sio_api_core_v1_EndpointAddress(ref),
		"k8s.io/api/core/v1.EndpointPort":                                                           schema_k8sio_api_core_v1_EndpointPort(ref),
		"k8s.io/api/core/v1.EndpointSubset":                                                         schema_k8sio_api_core_v1_EndpointSubset(ref),
		"k8s.io/api/core/v1.Endpoints":                                                              schema_k8sio_api_core_v1_Endpoints(ref),
		"k8s.io/api/core/v1.EndpointsList":                                                          schema_k8sio_api_core_v1_EndpointsList(ref),
		"k8s.io/api/core/v1.EnvFromSource":                                                          schema_k8sio_api_core_v1_EnvFromSource(ref),
		"k8s.io/api/core/v1.EnvVar":                                                                 schema_k8sio_api_core_v1_EnvVar(ref),
		"k8s.io/api/core/v1.EnvVarSource":                                                           schema_k8sio_api_core_v1_EnvVarSource(ref),
		"k8s.io/api/core/v1.EphemeralContainer":                                                     schema_k8sio_api_core_v1_EphemeralContainer(ref),
		"k8s.io/api/core/v1.EphemeralContainerCommon":                                               schema_k8sio_api_core_v1_EphemeralContainerCommon(ref),
		"k8s.io/api/core/v1.EphemeralContainers":                                                    schema_k8sio_api_core_v1_EphemeralContainers(ref),
		"k8s.io/api/core/v1.Event":                                                                  schema_k8sio_api_core_v1_Event(ref),
		"k8s.io/api/core/v1.EventList":                                                              schema_k8sio_api_core_v1_EventList(ref),
		"k8s.io/api/core/v1.EventSeries":                                                            schema_k8sio_api_core_v1_EventSeries(ref),
		"k8s.io/api/core/v1.EventSource":                                                            schema_k8sio_api_core_v1_EventSource(ref),
		"k8s.io/api/core/v1.ExecAction":                                                             schema_k8sio_api_core_v1_ExecAction(ref),
		"k8s.io/api/core/v1.FCVolumeSource":                                                         schema_k8sio_api_core_v1_FCVolumeSource(ref),
		"k8s.io/api/core/v1.FlexPersistentVolumeSource":                                             schema_k8sio_api_core_v1_FlexPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.FlexVolumeSource":                                                       schema_k8sio_api_core_v1_FlexVolumeSource(ref),
		"k8s.io/api/core/v1.FlockerVolumeSource":                                                    schema_k8sio_api_core_v1_FlockerVolumeSource(ref),
		"k8s.io/api/core/v1.GCEPersistentDiskVolumeSource":                                          schema_k8sio_api_core_v1_GCEPersistentDiskVolumeSource(ref),
		"k8s.io/api/core/v1.GitRepoVolumeSource":                                                    schema_k8sio_api_core_v1_GitRepoVolumeSource(ref),
		"k8s.io/api/core/v1.GlusterfsPersistentVolumeSource":                                        schema_k8sio_api_core_v1_GlusterfsPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.GlusterfsVolumeSource":                                                  schema_k8sio_api_core_v1_GlusterfsVolumeSource(ref),
		"k8s.io/api/core/v1.HTTPGetAction":                                                          schema_k8sio_api_core_v1_HTTPGetAction(ref),
		"k8s.io/api/core/v1.HTTPHeader":                                                             schema_k8sio_api_core_v1_HTTPHeader(ref),
		"k8s.io/api/core/v1.Handler":                                                                schema_k8sio_api_core_v1_Handler(ref),
		"k8s.io/api/core/v1.HostAlias":                                                              schema_k8sio_api_core_v1_HostAlias(ref),
		"k8s.io/api/core/v1.HostPathVolumeSource":                                                   schema_k8sio_api_core_v1_HostPathVolumeSource(ref),
		"k8s.io/api/core/v1.ISCSIPersistentVolumeSource":                                            schema_k8sio_api_core_v1_ISCSIPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.ISCSIVolumeSource":                                                      schema_k8sio_api_core_v1_ISCSIVolumeSource(ref),
		"k8s.io/api/core/v1.KeyToPath":                                                              schema_k8sio_api_core_v1_KeyToPath(ref),
		"k8s.io/api/core/v1.Lifecycle":                                                              schema_k8sio_api_core_v1_Lifecycle(ref),
		"k8s.io/api/core/v1.LimitRange":                                                             schema_k8sio_api_core_v1_LimitRange(ref),
		"k8s.io/api/core/v1.LimitRangeItem":                                                         schema_k8sio_api_core_v1_LimitRangeItem(ref),
		"k8s.io/api/core/v1.LimitRangeList":                                                         schema_k8sio_api_core_v1_LimitRangeList(ref),
		"k8s.io/api/core/v1.LimitRangeSpec":                                                         schema_k8sio_api_core_v1_LimitRangeSpec(ref),
		"k8s.io/api/core/v1.List":                                                                   schema_k8sio_api_core_v1_List(ref),
		"k8s.io/api/core/v1.LoadBalancerIngress":                                                    schema_k8sio_api_core_v1_LoadBalancerIngress(ref),
		"k8s.io/api/core/v1.LoadBalancerStatus":                                                     schema_k8sio_api_core_v1_LoadBalancerStatus(ref),
		"k8s.io/api/core/v1.LocalObjectReference":                                                   schema_k8sio_api_core_v1_LocalObjectReference(ref),
		"k8s.io/api/core/v1.LocalVolumeSource":                                                      schema_k8sio_api_core_v1_LocalVolumeSource(ref),
		"k8s.io/api/core/v1.NFSVolumeSource":                                                        schema_k8sio_api_core_v1_NFSVolumeSource(ref),
		"k8s.io/api/core/v1.Namespace":                                                              schema_k8sio_api_core_v1_Namespace(ref),
		"k8s.io/api/core/v1.NamespaceCondition":                                                     schema_k8sio_api_core_v1_NamespaceCondition(ref),
		"k8s.io/api/core/v1.NamespaceList":                                                          schema_k8sio_api_core_v1_NamespaceList(ref),
		"k8s.io/api/core/v1.NamespaceSpec":                                                          schema_k8sio_api_core_v1_NamespaceSpec(ref),
		"k8s.io/api/core/v1.NamespaceStatus":                                                        schema_k8sio_api_core_v1_NamespaceStatus(ref),
		"k8s.io/api/core/v1.Node":                                                                   schema_k8sio_api_core_v1_Node(ref),
		"k8s.io/api/core/v1.NodeAddress":                                                            schema_k8sio_api_core_v1_NodeAddress(ref),
		"k8s.io/api/core/v1.NodeAffinity":                                                           schema_k8sio_api_core_v1_NodeAffinity(ref),
		"k8s.io/api/core/v1.NodeCondition":                                                          schema_k8sio_api_core_v1_NodeCondition(ref),
		"k8s.io/api/core/v1.NodeConfigSource":                                                       schema_k8sio_api_core_v1_NodeConfigSource(ref),
		"k8s.io/api/core/v1.NodeConfigStatus":                                                       schema_k8sio_api_core_v1_NodeConfigStatus(ref),
		"k8s.io/api/core/v1.NodeDaemonEndpoints":                                                    schema_k8sio_api_core_v1_NodeDaemonEndpoints(ref),
		"k8s.io/api/core/v1.NodeList":                                                               schema_k8sio_api_core_v1_NodeList(ref),
		"k8s.io/api/core/v1.NodeProxyOptions":                                                       schema_k8sio_api_core_v1_NodeProxyOptions(ref),
		"k8s.io/api/core/v1.NodeResources":                                                          schema_k8sio_api_core_v1_NodeResources(ref),
		"k8s.io/api/core/v1.NodeSelector":                                                           schema_k8sio_api_core_v1_NodeSelector(ref),
		"k8s.io/api/core/v1.NodeSelectorRequirement":                                                schema_k8sio_api_core_v1_NodeSelectorRequirement(ref),
		"k8s.io/api/core/v1.NodeSelectorTerm":                                                       schema_k8sio_api_core_v1_NodeSelectorTerm(ref),
		"k8s.io/api/core/v1.NodeSpec":                                                               schema_k8sio_api_core_v1_NodeSpec(ref),
		"k8s.io/api/core/v1.NodeStatus":                                                             schema_k8sio_api_core_v1_NodeStatus(ref),
		"k8s.io/api/core/v1.NodeSystemInfo":                                                         schema_k8sio_api_core_v1_NodeSystemInfo(ref),
		"k8s.io/api/core/v1.ObjectFieldSelector":                                                    schema_k8sio_api_core_v1_ObjectFieldSelector(ref),
		"k8s.io/api/core/v1.ObjectReference":                                                        schema_k8sio_api_core_v1_ObjectReference(ref),
		"k8s.io/api/core/v1.PersistentVolume":                                                       schema_k8sio_api_core_v1_PersistentVolume(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaim":                                                  schema_k8sio_api_core_v1_PersistentVolumeClaim(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimCondition":                                         schema_k8sio_api_core_v1_PersistentVolumeClaimCondition(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimList":                                              schema_k8sio_api_core_v1_PersistentVolumeClaimList(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimSpec":                                              schema_k8sio_api_core_v1_PersistentVolumeClaimSpec(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimStatus":                                            schema_k8sio_api_core_v1_PersistentVolumeClaimStatus(ref),
		"k8s.io/api/core/v1.PersistentVolumeClaimVolumeSource":                                      schema_k8sio_api_core_v1_PersistentVolumeClaimVolumeSource(ref),
		"k8s.io/api/core/v1.PersistentVolumeList":                                                   schema_k8sio_api_core_v1_PersistentVolumeList(ref),
		"k8s.io/api/core/v1.PersistentVolumeSource":                                                 schema_k8sio_api_core_v1_PersistentVolumeSource(ref),
		"k8s.io/api/core/v1.PersistentVolumeSpec":                                                   schema_k8sio_api_core_v1_PersistentVolumeSpec(ref),
		"k8s.io/api/core/v1.PersistentVolumeStatus":                                                 schema_k8sio_api_core_v1_PersistentVolumeStatus(ref),
		"k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource":                                       schema_k8sio_api_core_v1_PhotonPersistentDiskVolumeSource(ref),
		"k8s.io/api/core/v1.Pod":                                                                    schema_k8sio_api_core_v1_Pod(ref),
		"k8s.io/api/core/v1.PodAffinity":                                                            schema_k8sio_api_core_v1_PodAffinity(ref),
		"k8s.io/api/core/v1.PodAffinityTerm":                                                        schema_k8sio_api_core_v1_PodAffinityTerm(ref),
		"k8s.io/api/core/v1.PodAntiAffinity":                                                        schema_k8sio_api_core_v1_PodAntiAffinity(ref),
		"k8s.io/api/core/v1.PodAttachOptions":                                                       schema_k8sio_api_core_v1_PodAttachOptions(ref),
		"k8s.io/api/core/v1.PodCondition":                                                           schema_k8sio_api_core_v1_PodCondition(ref),
		"k8s.io/api/core/v1.PodDNSConfig":                                                           schema_k8sio_api_core_v1_PodDNSConfig(ref),
		"k8s.io/api/core/v1.PodDNSConfigOption":                                                     schema_k8sio_api_core_v1_PodDNSConfigOption(ref),
		"k8s.io/api/core/v1.PodExecOptions":                                                         schema_k8sio_api_core_v1_PodExecOptions(ref),
		"k8s.io/api/core/v1.PodIP":                                                                  schema_k8sio_api_core_v1_PodIP(ref),
		"k8s.io/api/core/v1.PodList":                                                                schema_k8sio_api_core_v1_PodList(ref),
		"k8s.io/api/core/v1.PodLogOptions":                                                          schema_k8sio_api_core_v1_PodLogOptions(ref),
		"k8s.io/api/core/v1.PodPortForwardOptions":                                                  schema_k8sio_api_core_v1_PodPortForwardOptions(ref),
		"k8s.io/api/core/v1.PodProxyOptions":                                                        schema_k8sio_api_core_v1_PodProxyOptions(ref),
		"k8s.io/api/core/v1.PodReadinessGate":                                                       schema_k8sio_api_core_v1_PodReadinessGate(ref),
		"k8s.io/api/core/v1.PodSecurityContext":                                                     schema_k8sio_api_core_v1_PodSecurityContext(ref),
		"k8s.io/api/core/v1.PodSignature":                                                           schema_k8sio_api_core_v1_PodSignature(ref),
		"k8s.io/api/core/v1.PodSpec":                                                                schema_k8sio_api_core_v1_PodSpec(ref),
		"k8s.io/api/core/v1.PodStatus":                                                              schema_k8sio_api_core_v1_PodStatus(ref),
		"k8s.io/api/core/v1.PodStatusResult":                                                        schema_k8sio_api_core_v1_PodStatusResult(ref),
		"k8s.io/api/core/v1.PodTemplate":                                                            schema_k8sio_api_core_v1_PodTemplate(ref),
		"k8s.io/api/core/v1.PodTemplateList":                                                        schema_k8sio_api_core_v1_PodTemplateList(ref),
		"k8s.io/api/core/v1.PodTemplateSpec":                                                        schema_k8sio_api_core_v1_PodTemplateSpec(ref),
		"k8s.io/api/core/v1.PortworxVolumeSource":                                                   schema_k8sio_api_core_v1_PortworxVolumeSource(ref),
		"k8s.io/api/core/v1.PreferAvoidPodsEntry":                                                   schema_k8sio_api_core_v1_PreferAvoidPodsEntry(ref),
		"k8s.io/api/core/v1.PreferredSchedulingTerm":                                                schema_k8sio_api_core_v1_PreferredSchedulingTerm(ref),
		"k8s.io/api/core/v1.Probe":                                                                  schema_k8sio_api_core_v1_Probe(ref),
		"k8s.io/api/core/v1.ProjectedVolumeSource":                                                  schema_k8sio_api_core_v1_ProjectedVolumeSource(ref),
		"k8s.io/api/core/v1.QuobyteVolumeSource":                                                    schema_k8sio_api_core_v1_QuobyteVolumeSource(ref),
		"k8s.io/api/core/v1.RBDPersistentVolumeSource":                                              schema_k8sio_api_core_v1_RBDPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.RBDVolumeSource":                                                        schema_k8sio_api_core_v1_RBDVolumeSource(ref),
		"k8s.io/api/core/v1.RangeAllocation":                                                        schema_k8sio_api_core_v1_RangeAllocation(ref),
		"k8s.io/api/core/v1.ReplicationController":                                                  schema_k8sio_api_core_v1_ReplicationController(ref),
		"k8s.io/api/core/v1.ReplicationControllerCondition":                                         schema_k8sio_api_core_v1_ReplicationControllerCondition(ref),
		"k8s.io/api/core/v1.ReplicationControllerList":                                              schema_k8sio_api_core_v1_ReplicationControllerList(ref),
		"k8s.io/api/core/v1.ReplicationControllerSpec":                                              schema_k8sio_api_core_v1_ReplicationControllerSpec(ref),
		"k8s.io/api/core/v1.ReplicationControllerStatus":                                            schema_k8sio_api_core_v1_ReplicationControllerStatus(ref),
		"k8s.io/api/core/v1.ResourceFieldSelector":                                                  schema_k8sio_api_core_v1_ResourceFieldSelector(ref),
		"k8s.io/api/core/v1.ResourceQuota":                                                          schema_k8sio_api_core_v1_ResourceQuota(ref),
		"k8s.io/api/core/v1.ResourceQuotaList":                                                      schema_k8sio_api_core_v1_ResourceQuotaList(ref),
		"k8s.io/api/core/v1.ResourceQuotaSpec":                                                      schema_k8sio_api_core_v1_ResourceQuotaSpec(ref),
		"k8s.io/api/core/v1.ResourceQuotaStatus":                                                    schema_k8sio_api_core_v1_ResourceQuotaStatus(ref),
		"k8s.io/api/core/v1.ResourceRequirements":                                                   schema_k8sio_api_core_v1_ResourceRequirements(ref),
		"k8s.io/api/core/v1.SELinuxOptions":                                                         schema_k8sio_api_core_v1_SELinuxOptions(ref),
		"k8s.io/api/core/v1.ScaleIOPersistentVolumeSource":                                          schema_k8sio_api_core_v1_ScaleIOPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.ScaleIOVolumeSource":                                                    schema_k8sio_api_core_v1_ScaleIOVolumeSource(ref),
		"k8s.io/api/core/v1.ScopeSelector":                                                          schema_k8sio_api_core_v1_ScopeSelector(ref),
		"k8s.io/api/core/v1.ScopedResourceSelectorRequirement":                                      schema_k8sio_api_core_v1_ScopedResourceSelectorRequirement(ref),
		"k8s.io/api/core/v1.Secret":                                                                 schema_k8sio_api_core_v1_Secret(ref),
		"k8s.io/api/core/v1.SecretEnvSource":                                                        schema_k8sio_api_core_v1_SecretEnvSource(ref),
		"k8s.io/api/core/v1.SecretKeySelector":                                                      schema_k8sio_api_core_v1_SecretKeySelector(ref),
		"k8s.io/api/core/v1.SecretList":                                                             schema_k8sio_api_core_v1_SecretList(ref),
		"k8s.io/api/core/v1.SecretProjection":                                                       schema_k8sio_api_core_v1_SecretProjection(ref),
		"k8s.io/api/core/v1.SecretReference":                                                        schema_k8sio_api_core_v1_SecretReference(ref),
		"k8s.io/api/core/v1.SecretVolumeSource":                                                     schema_k8sio_api_core_v1_SecretVolumeSource(ref),
		"k8s.io/api/core/v1.SecurityContext":                                                        schema_k8sio_api_core_v1_SecurityContext(ref),
		"k8s.io/api/core/v1.SerializedReference":                                                    schema_k8sio_api_core_v1_SerializedReference(ref),
		"k8s.io/api/core/v1.Service":                                                                schema_k8sio_api_core_v1_Service(ref),
		"k8s.io/api/core/v1.ServiceAccount":                                                         schema_k8sio_api_core_v1_ServiceAccount(ref),
		"k8s.io/api/core/v1.ServiceAccountList":                                                     schema_k8sio_api_core_v1_ServiceAccountList(ref),
		"k8s.io/api/core/v1.ServiceAccountTokenProjection":                                          schema_k8sio_api_core_v1_ServiceAccountTokenProjection(ref),
		"k8s.io/api/core/v1.ServiceList":                                                            schema_k8sio_api_core_v1_ServiceList(ref),
		"k8s.io/api/core/v1.ServicePort":                                                            schema_k8sio_api_core_v1_ServicePort(ref),
		"k8s.io/api/core/v1.ServiceProxyOptions":                                                    schema_k8sio_api_core_v1_ServiceProxyOptions(ref),
		"k8s.io/api/core/v1.ServiceSpec":                                                            schema_k8sio_api_core_v1_ServiceSpec(ref),
		"k8s.io/api/core/v1.ServiceStatus":                                                          schema_k8sio_api_core_v1_ServiceStatus(ref),
		"k8s.io/api/core/v1.SessionAffinityConfig":                                                  schema_k8sio_api_core_v1_SessionAffinityConfig(ref),
		"k8s.io/api/core/v1.StorageOSPersistentVolumeSource":                                        schema_k8sio_api_core_v1_StorageOSPersistentVolumeSource(ref),
		"k8s.io/api/core/v1.StorageOSVolumeSource":                                                  schema_k8sio_api_core_v1_StorageOSVolumeSource(ref),
		"k8s.io/api/core/v1.Sysctl":                                                                 schema_k8sio_api_core_v1_Sysctl(ref),
		"k8s.io/api/core/v1.TCPSocketAction":                                                        schema_k8sio_api_core_v1_TCPSocketAction(ref),
		"k8s.io/api/core/v1.Taint":                                                                  schema_k8sio_api_core_v1_Taint(ref),
		"k8s.io/api/core/v1.Toleration":                                                             schema_k8sio_api_core_v1_Toleration(ref),
		"k8s.io/api/core/v1.TopologySelectorLabelRequirement":                                       schema_k8sio_api_core_v1_TopologySelectorLabelRequirement(ref),
		"k8s.io/api/core/v1.TopologySelectorTerm":                                                   schema_k8sio_api_core_v1_TopologySelectorTerm(ref),
		"k8s.io/api/core/v1.TopologySpreadConstraint":                                               schema_k8sio_api_core_v1_TopologySpreadConstraint(ref),
		"k8s.io/api/core/v1.TypedLocalObjectReference":                                              schema_k8sio_api_core_v1_TypedLocalObjectReference(ref),
		"k8s.io/api/core/v1.Volume":                                                                 schema_k8sio_api_core_v1_Volume(ref),
		"k8s.io/api/core/v1.VolumeDevice":                                                           schema_k8sio_api_core_v1_VolumeDevice(ref),
		"k8s.io/api/core/v1.VolumeMount":                                                            schema_k8sio_api_core_v1_VolumeMount(ref),
		"k8s.io/api/core/v1.VolumeNodeAffinity":                                                     schema_k8sio_api_core_v1_VolumeNodeAffinity(ref),
		"k8s.io/api/core/v1.VolumeProjection":                                                       schema_k8sio_api_core_v1_VolumeProjection(ref),
		"k8s.io/api/core/v1.VolumeSource":                                                           schema_k8sio_api_core_v1_VolumeSource(ref),
		"k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource":                                         schema_k8sio_api_core_v1_VsphereVirtualDiskVolumeSource(ref),
		"k8s.io/api/core/v1.WeightedPodAffinityTerm":                                                schema_k8sio_api_core_v1_WeightedPodAffinityTerm(ref),
		"k8s.io/api/core/v1.WindowsSecurityContextOptions":                                          schema_k8sio_api_core_v1_WindowsSecurityContextOptions(ref),
		"k8s.io/api/rbac/v1.AggregationRule":                                                        schema_k8sio_api_rbac_v1_AggregationRule(ref),
		"k8s.io/api/rbac/v1.ClusterRole":                                                            schema_k8sio_api_rbac_v1_ClusterRole(ref),
		"k8s.io/api/rbac/v1.ClusterRoleBinding":                                                     schema_k8sio_api_rbac_v1_ClusterRoleBinding(ref),
		"k8s.io/api/rbac/v1.ClusterRoleBindingList":                                                 schema_k8sio_api_rbac_v1_ClusterRoleBindingList(ref),
		"k8s.io/api/rbac/v1.ClusterRoleList":                                                        schema_k8sio_api_rbac_v1_ClusterRoleList(ref),
		"k8s.io/api/rbac/v1.PolicyRule":                                                             schema_k8sio_api_rbac_v1_PolicyRule(ref),
		"k8s.io/api/rbac/v1.Role":                                                                   schema_k8sio_api_rbac_v1_Role(ref),
		"k8s.io/api/rbac/v1.RoleBinding":                                                            schema_k8sio_api_rbac_v1_RoleBinding(ref),
		"k8s.io/api/rbac/v1.RoleBindingList":                                                        schema_k8sio_api_rbac_v1_RoleBindingList(ref),
		"k8s.io/api/rbac/v1.RoleList":                                                               schema_k8sio_api_rbac_v1_RoleList(ref),
		"k8s.io/api/rbac/v1.RoleRef":                                                                schema_k8sio_api_rbac_v1_RoleRef(ref),
		"k8s.io/api/rbac/v1.Subject":                                                                schema_k8sio_api_rbac_v1_Subject(ref),
		"k8s.io/apimachinery/pkg/api/resource.Quantity":                                             schema_apimachinery_pkg_api_resource_Quantity(ref),
		"k8s.io/apimachinery/pkg/api/resource.int64Amount":                                          schema_apimachinery_pkg_api_resource_int64Amount(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroup":                                             schema_pkg_apis_meta_v1_APIGroup(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIGroupList":                                         schema_pkg_apis_meta_v1_APIGroupList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResource":                                          schema_pkg_apis_meta_v1_APIResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIResourceList":                                      schema_pkg_apis_meta_v1_APIResourceList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.APIVersions":                                          schema_pkg_apis_meta_v1_APIVersions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.CreateOptions":                                        schema_pkg_apis_meta_v1_CreateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.DeleteOptions":                                        schema_pkg_apis_meta_v1_DeleteOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Duration":                                             schema_pkg_apis_meta_v1_Duration(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ExportOptions":                                        schema_pkg_apis_meta_v1_ExportOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.FieldsV1":                                             schema_pkg_apis_meta_v1_FieldsV1(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GetOptions":                                           schema_pkg_apis_meta_v1_GetOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupKind":                                            schema_pkg_apis_meta_v1_GroupKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupResource":                                        schema_pkg_apis_meta_v1_GroupResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersion":                                         schema_pkg_apis_meta_v1_GroupVersion(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionForDiscovery":                             schema_pkg_apis_meta_v1_GroupVersionForDiscovery(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionKind":                                     schema_pkg_apis_meta_v1_GroupVersionKind(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.GroupVersionResource":                                 schema_pkg_apis_meta_v1_GroupVersionResource(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.InternalEvent":                                        schema_pkg_apis_meta_v1_InternalEvent(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector":                                        schema_pkg_apis_meta_v1_LabelSelector(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement":                             schema_pkg_apis_meta_v1_LabelSelectorRequirement(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.List":                                                 schema_pkg_apis_meta_v1_List(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta":                                             schema_pkg_apis_meta_v1_ListMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ListOptions":                                          schema_pkg_apis_meta_v1_ListOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ManagedFieldsEntry":                                   schema_pkg_apis_meta_v1_ManagedFieldsEntry(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime":                                            schema_pkg_apis_meta_v1_MicroTime(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta":                                           schema_pkg_apis_meta_v1_ObjectMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference":                                       schema_pkg_apis_meta_v1_OwnerReference(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadata":                                schema_pkg_apis_meta_v1_PartialObjectMetadata(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PartialObjectMetadataList":                            schema_pkg_apis_meta_v1_PartialObjectMetadataList(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Patch":                                                schema_pkg_apis_meta_v1_Patch(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.PatchOptions":                                         schema_pkg_apis_meta_v1_PatchOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Preconditions":                                        schema_pkg_apis_meta_v1_Preconditions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.RootPaths":                                            schema_pkg_apis_meta_v1_RootPaths(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.ServerAddressByClientCIDR":                            schema_pkg_apis_meta_v1_ServerAddressByClientCIDR(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Status":                                               schema_pkg_apis_meta_v1_Status(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusCause":                                          schema_pkg_apis_meta_v1_StatusCause(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.StatusDetails":                                        schema_pkg_apis_meta_v1_StatusDetails(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Table":                                                schema_pkg_apis_meta_v1_Table(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableColumnDefinition":                                schema_pkg_apis_meta_v1_TableColumnDefinition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableOptions":                                         schema_pkg_apis_meta_v1_TableOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRow":                                             schema_pkg_apis_meta_v1_TableRow(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TableRowCondition":                                    schema_pkg_apis_meta_v1_TableRowCondition(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Time":                                                 schema_pkg_apis_meta_v1_Time(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.Timestamp":                                            schema_pkg_apis_meta_v1_Timestamp(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta":                                             schema_pkg_apis_meta_v1_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.UpdateOptions":                                        schema_pkg_apis_meta_v1_UpdateOptions(ref),
		"k8s.io/apimachinery/pkg/apis/meta/v1.WatchEvent":                                           schema_pkg_apis_meta_v1_WatchEvent(ref),
		"k8s.io/apimachinery/pkg/runtime.RawExtension":                                              schema_k8sio_apimachinery_pkg_runtime_RawExtension(ref),
		"k8s.io/apimachinery/pkg/runtime.TypeMeta":                                                  schema_k8sio_apimachinery_pkg_runtime_TypeMeta(ref),
		"k8s.io/apimachinery/pkg/runtime.Unknown":                                                   schema_k8sio_apimachinery_pkg_runtime_Unknown(ref),
		"k8s.io/apimachinery/pkg/util/intstr.IntOrString":                                           schema_apimachinery_pkg_util_intstr_IntOrString(ref),
		"k8s.io/apimachinery/pkg/version.Info":                                                      schema_k8sio_apimachinery_pkg_version_Info(ref),
	}
}

func schema_pkg_apis_core_v1alpha1_Addon(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Addon allows enabling or disabling a specific addon and is used to derive from.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Addons(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Addons is a collection of configuration for specific addons which are managed by the Gardener.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetes-dashboard": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesDashboard holds configuration settings for the kubernetes dashboard addon.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesDashboard"),
						},
					},
					"nginx-ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "NginxIngress holds configuration settings for the nginx-ingress addon.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.NginxIngress"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesDashboard", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.NginxIngress"},
	}
}

func schema_pkg_apis_core_v1alpha1_AdmissionPlugin(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AdmissionPlugin contains information about a specific admission plugin and its corresponding configuration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the plugin.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"config": {
						SchemaProps: spec.SchemaProps{
							Description: "Config is the configuration of the plugin.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_Alerting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Alerting contains information about how alerting will be done (i.e. who will receive alerts and how).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"emailReceivers": {
						SchemaProps: spec.SchemaProps{
							Description: "MonitoringEmailReceivers is a list of recipients for alerts",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_AuditConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditConfig contains settings for audit of the api server",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"auditPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "AuditPolicy contains configuration settings for audit policy of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditPolicy"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditPolicy"},
	}
}

func schema_pkg_apis_core_v1alpha1_AuditPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditPolicy contains audit policy for kube-apiserver",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMapRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMapRef is a reference to a ConfigMap object in the same namespace, which contains the audit policy for the kube-apiserver.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_AvailabilityZone(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AvailabilityZone is an availability zone.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an an availability zone name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"unavailableMachineTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "UnavailableMachineTypes is a list of machine type names that are not availability in this zone.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"unavailableVolumeTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "UnavailableVolumeTypes is a list of volume type names that are not availability in this zone.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupBucket(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucket holds details about backup bucket",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the Backup Bucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Backup Bucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketStatus"),
						},
					},
				},
				Required: []string{"metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupBucketList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketList is a list of BackupBucket objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of BackupBucket.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucket"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucket", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupBucketProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketProvider holds the details of cloud provider of the object store.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is the region of the bucket.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupBucketSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketSpec is the specification of a Backup Bucket.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider hold the details of cloud provider of the object store.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketProvider"),
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a secret that contains the credentials to access object store.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"seed": {
						SchemaProps: spec.SchemaProps{
							Description: "Seed holds the name of the seed allocated to BackupBucket for running controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"provider", "secretRef"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupBucketProvider", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupBucketStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketStatus holds the most recently observed status of the Backup Bucket.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"providerStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderStatus is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the BackupBucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation"),
						},
					},
					"lastError": {
						SchemaProps: spec.SchemaProps{
							Description: "LastError holds information about the last occurred error during an operation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError"),
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this BackupBucket. It corresponds to the BackupBucket's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"generatedSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "GeneratedSecretRef is reference to the secret generated by backup bucket, which will have object store specific credentials.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupEntry(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntry holds details about shoot backup.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of the Backup Entry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntrySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the most recently observed status of the Backup Entry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntryStatus"),
						},
					},
				},
				Required: []string{"metadata"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntrySpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntryStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupEntryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntryList is a list of BackupEntry objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of BackupEntry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntry"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.BackupEntry", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupEntrySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntrySpec is the specification of a Backup Entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bucketName": {
						SchemaProps: spec.SchemaProps{
							Description: "BucketName is the name of backup bucket for this Backup Entry.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seed": {
						SchemaProps: spec.SchemaProps{
							Description: "Seed holds the name of the seed allocated to BackupEntry for running controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"bucketName"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_BackupEntryStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntryStatus holds the most recently observed status of the Backup Entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the BackupEntry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation"),
						},
					},
					"lastError": {
						SchemaProps: spec.SchemaProps{
							Description: "LastError holds information about the last occurred error during an operation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError"),
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this BackupEntry. It corresponds to the BackupEntry's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation"},
	}
}

func schema_pkg_apis_core_v1alpha1_CRI(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CRI contains information about the Container Runtimes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the CRI library",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntimes": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerRuntimes is the list of the required container runtimes supported for a worker pool.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ContainerRuntime"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ContainerRuntime"},
	}
}

func schema_pkg_apis_core_v1alpha1_CloudInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudInfo contains information about the cloud",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the cloud type",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is the cloud region",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_CloudProfile(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfile represents certain properties about a provider environment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the provider environment properties.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfileSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfileSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CloudProfileList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfileList is a collection of CloudProfiles.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of CloudProfiles.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfile"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudProfile", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_CloudProfileSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfileSpec is the specification of a CloudProfile. It must contain exactly one of its defined keys.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "CABundle is a certificate bundle which will be installed onto every host machine of shoot cluster targeting this profile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains constraints regarding allowed values of the 'kubernetes' block in the Shoot specification.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesSettings"),
						},
					},
					"machineImages": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MachineImages contains constraints regarding allowed values for machine images in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImage"),
									},
								},
							},
						},
					},
					"machineTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MachineTypes contains constraints regarding allowed values for machine types in the 'workers' block in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineType"),
									},
								},
							},
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig contains provider-specific configuration for the profile.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"regions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Regions contains constraints regarding allowed values for regions and zones.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Region"),
									},
								},
							},
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector contains an optional list of labels on `Seed` resources that marks those seeds whose shoots may use this provider profile. An empty list means that all seeds of the same provider type are supported. This is useful for environments that are of the same type (like openstack) but may have different \"instances\"/landscapes. Optionally a list of possible providers can be added to enable cross-provider scheduling. By default, the provider type of the seed must match the shoot's provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSelector"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the name of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "VolumeTypes contains constraints regarding allowed values for volume types in the 'workers' block in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.VolumeType"),
									},
								},
							},
						},
					},
				},
				Required: []string{"kubernetes", "machineImages", "machineTypes", "regions", "type"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesSettings", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImage", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineType", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Region", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSelector", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.VolumeType", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterAutoscaler contains the configuration flags for the Kubernetes cluster autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleDownDelayAfterAdd": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterAdd defines how long after scale up that scale down evaluation resumes (default: 1 hour).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownDelayAfterDelete": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterDelete how long after node deletion that scale down evaluation resumes, defaults to scanInterval (defaults to ScanInterval).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownDelayAfterFailure": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterFailure how long after scale down failure that scale down evaluation resumes (default: 3 mins).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownUnneededTime": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownUnneededTime defines how long a node should be unneeded before it is eligible for scale down (default: 30 mins).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownUtilizationThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownUtilizationThreshold defines the threshold in % under which a node is being removed",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"scanInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "ScanInterval how often cluster is reevaluated for scale up or down (default: 10 secs).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_ClusterInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterInfo contains information about the Plant cluster",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cloud": {
						SchemaProps: spec.SchemaProps{
							Description: "Cloud describes the cloud information",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudInfo"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes describes kubernetes meta information (e.g., version)",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesInfo"),
						},
					},
				},
				Required: []string{"cloud", "kubernetes"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CloudInfo", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubernetesInfo"},
	}
}

func schema_pkg_apis_core_v1alpha1_Condition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Condition holds the information about the state of a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the Shoot condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"codes": {
						SchemaProps: spec.SchemaProps{
							Description: "Well-defined error codes in case the condition reports a problem.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"type", "status", "lastTransitionTime", "lastUpdateTime", "reason", "message"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_ContainerRuntime(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerRuntime contains information about worker's available container runtime",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the Container Runtime.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to the ContainerRuntime resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerDeployment contains information for how this controller is deployed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the deployment type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig contains type-specific configuration.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"policy": {
						SchemaProps: spec.SchemaProps{
							Description: "Policy controls how the controller is deployed. It defaults to 'OnDemand'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector contains an optional label selector for seeds. Only if the labels match then this controller will be considered for a deployment. An empty list means that all seeds are selected.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerInstallation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallation represents an installation request for an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallationStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerInstallationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationList is a collection of ControllerInstallations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerInstallations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallation"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerInstallation", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerInstallationSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationSpec is the specification of a ControllerInstallation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"registrationRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RegistrationRef is used to reference a ControllerRegistration resources.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"seedRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedRef is used to reference a Seed resources.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"registrationRef", "seedRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerInstallationStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationStatus is the status of a ControllerInstallation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a ControllerInstallations's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"),
									},
								},
							},
						},
					},
					"providerStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderStatus contains type-specific status.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerRegistration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistration represents a registration of an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this registration.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistrationSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistrationSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerRegistrationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistrationList is a collection of ControllerRegistrations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRegistrations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerRegistration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerRegistrationSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistrationSpec is the specification of a ControllerRegistration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of combinations of kinds (DNSProvider, Infrastructure, Generic, ...) and their actual types (aws-route53, gcp, auditlog, ...).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerResource"),
									},
								},
							},
						},
					},
					"deployment": {
						SchemaProps: spec.SchemaProps{
							Description: "Deployment contains information for how this controller is deployed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerDeployment", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ControllerResource"},
	}
}

func schema_pkg_apis_core_v1alpha1_ControllerResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerResource is a combination of a kind (DNSProvider, Infrastructure, Generic, ...) and the actual type for this kind (aws-route53, gcp, auditlog, ...).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the resource kind, for example \"OperatingSystemConfig\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the resource type, for example \"coreos\" or \"ubuntu\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"globallyEnabled": {
						SchemaProps: spec.SchemaProps{
							Description: "GloballyEnabled determines if this ControllerResource is required by all Shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reconcileTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "ReconcileTimeout defines how long Gardener should wait for the resource reconciliation.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"primary": {
						SchemaProps: spec.SchemaProps{
							Description: "Primary determines if the controller backed by this ControllerRegistration is responsible for the extension resource's lifecycle. This field defaults to true. There must be exactly one primary controller for this kind/type combination.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_DNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DNS holds information about the provider, the hosted zone id and the domain.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"domain": {
						SchemaProps: spec.SchemaProps{
							Description: "Domain is the external available domain of the Shoot cluster. This domain will be written into the kubeconfig that is handed out to end-users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Providers is a list of DNS providers that shall be enabled for this shoot cluster. Only relevant if not a default domain is used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSProvider"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSProvider"},
	}
}

func schema_pkg_apis_core_v1alpha1_DNSIncludeExclude(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"include": {
						SchemaProps: spec.SchemaProps{
							Description: "Include is a list of resources that shall be included.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"exclude": {
						SchemaProps: spec.SchemaProps{
							Description: "Exclude is a list of resources that shall be excluded.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_DNSProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DNSProvider contains information about a DNS provider.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"domains": {
						SchemaProps: spec.SchemaProps{
							Description: "Domains contains information about which domains shall be included/excluded for this provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSIncludeExclude"),
						},
					},
					"primary": {
						SchemaProps: spec.SchemaProps{
							Description: "Primary indicates that this DNSProvider is used for shoot related domains.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretName is a name of a secret containing credentials for the stated domain and the provider. When not specified, the Gardener will use the cloud provider credentials referenced by the Shoot and try to find respective credentials there (primary provider only). Specifying this field may override this behavior, i.e. forcing the Gardener to only look into the given secret.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the DNS provider type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						SchemaProps: spec.SchemaProps{
							Description: "Zones contains information about which hosted zones shall be included/excluded for this provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSIncludeExclude"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNSIncludeExclude"},
	}
}

func schema_pkg_apis_core_v1alpha1_DataVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DataVolume contains information about a data volume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the volume to make it referencable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeSize is the size of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encrypted": {
						SchemaProps: spec.SchemaProps{
							Description: "Encrypted determines if the volume should be encrypted.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Endpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Endpoint is an endpoint for monitoring, logging and other services around the plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "URL is the url of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "url", "purpose"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ExpirableVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpirableVersion contains a version and an expiration date.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version identifier.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationDate": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationDate defines the time at which this version expires.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"classification": {
						SchemaProps: spec.SchemaProps{
							Description: "Classification defines the state of a version (preview, supported, deprecated)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_Extension(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Extension contains type and provider information for Shoot extensions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the extension resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to extension resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Disabled allows to disable extensions that were marked as 'globally enabled' by Gardener administrators.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ExtensionResourceState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExtensionResourceState contains the kind of the extension custom resource and its last observed state in the Shoot's namespace on the Seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind (type) of the extension custom resource",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the extension custom resource",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose of the extension custom resource",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "State of the extension resource",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources holds a list of named resource references that can be referred to in the state by their names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.NamedResourceReference"),
									},
								},
							},
						},
					},
				},
				Required: []string{"kind"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.NamedResourceReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_Gardener(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Gardener holds the information about the Gardener version that operated a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "ID is the Docker container id of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the hostname (pod name) of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"id", "name", "version"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_GardenerResourceData(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "GardenerResourceData holds the data which is used to generate resources, deployed in the Shoot's control plane.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object required to generate resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the object",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the payload required to generate resources",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"name", "type", "data"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_Hibernation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Hibernation contains information whether the Shoot is suspended or not.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled specifies whether the Shoot needs to be hibernated or not. If it is true, the Shoot's desired state is to be hibernated. If it is false or nil, the Shoot's desired state is to be awaken.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"schedules": {
						SchemaProps: spec.SchemaProps{
							Description: "Schedules determine the hibernation schedules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.HibernationSchedule"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.HibernationSchedule"},
	}
}

func schema_pkg_apis_core_v1alpha1_HibernationSchedule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HibernationSchedule determines the hibernation schedule of a Shoot. A Shoot will be regularly hibernated at each start time and will be woken up at each end time. Start or End can be omitted, though at least one of each has to be specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "Start is a Cron spec at which time a Shoot will be hibernated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"end": {
						SchemaProps: spec.SchemaProps{
							Description: "End is a Cron spec at which time a Shoot will be woken up.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"location": {
						SchemaProps: spec.SchemaProps{
							Description: "Location is the time location in which both start and and shall be evaluated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_HorizontalPodAutoscalerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerConfig contains horizontal pod autoscaler configuration settings for the kube-controller-manager. Note: Descriptions were taken from the Kubernetes documentation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpuInitializationPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "The period after which a ready pod transition is considered to be the first.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"downscaleDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The period since last downscale, before another downscale can be performed in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"downscaleStabilization": {
						SchemaProps: spec.SchemaProps{
							Description: "The configurable window at which the controller will choose the highest recommendation for autoscaling.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"initialReadinessDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The configurable period at which the horizontal pod autoscaler considers a Pod “not yet ready” given that it’s unready and it has  transitioned to unready during that time.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"syncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "The period for syncing the number of pods in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"tolerance": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum change (from 1.0) in the desired-to-actual metrics ratio for the horizontal pod autoscaler to consider scaling.",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"upscaleDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The period since last upscale, before another upscale can be performed in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeAPIServerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeAPIServerConfig contains configuration settings for the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"admissionPlugins": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionPlugins contains the list of user-defined admission plugins (additional to those managed by Gardener), and, if desired, the corresponding configuration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.AdmissionPlugin"),
									},
								},
							},
						},
					},
					"apiAudiences": {
						SchemaProps: spec.SchemaProps{
							Description: "APIAudiences are the identifiers of the API. The service account token authenticator will validate that tokens used against the API are bound to at least one of these audiences. Defaults to [\"kubernetes\"].",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"auditConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "AuditConfig contains configuration settings for the audit of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditConfig"),
						},
					},
					"enableBasicAuthentication": {
						SchemaProps: spec.SchemaProps{
							Description: "EnableBasicAuthentication defines whether basic authentication should be enabled for this cluster or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"oidcConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "OIDCConfig contains configuration settings for the OIDC provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.OIDCConfig"),
						},
					},
					"runtimeConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "RuntimeConfig contains information about enabled or disabled APIs.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"serviceAccountConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountConfig contains configuration settings for the service account handling of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ServiceAccountConfig"),
						},
					},
					"watchCacheSizes": {
						SchemaProps: spec.SchemaProps{
							Description: "WatchCacheSizes contains configuration of the API server's watch cache sizes. Configuring these flags might be useful for large-scale Shoot clusters with a lot of parallel update requests and a lot of watching controllers (e.g. large shooted Seed clusters). When the API server's watch cache's capacity is too small to cope with the amount of update requests and watchers for a particular resource, it might happen that controller watches are permanently stopped with `too old resource version` errors. Starting from kubernetes v1.19, the API server's watch cache size is adapted dynamically and setting the watch cache size flags will have no effect, except when setting it to 0 (which disables the watch cache).",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.WatchCacheSizes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AdmissionPlugin", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.AuditConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.OIDCConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ServiceAccountConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.WatchCacheSizes"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeControllerManagerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeControllerManagerConfig contains configuration settings for the kube-controller-manager.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"horizontalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "HorizontalPodAutoscalerConfig contains horizontal pod autoscaler configuration settings for the kube-controller-manager.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.HorizontalPodAutoscalerConfig"),
						},
					},
					"nodeCIDRMaskSize": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeCIDRMaskSize defines the mask size for node cidr in cluster (default is 24)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.HorizontalPodAutoscalerConfig"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeProxyConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeProxyConfig contains configuration settings for the kube-proxy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Mode specifies which proxy mode to use. defaults to IPTables.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeSchedulerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeSchedulerConfig contains configuration settings for the kube-scheduler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"kubeMaxPDVols": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeMaxPDVols allows to configure the `KUBE_MAX_PD_VOLS` environment variable for the kube-scheduler. Please find more information here: https://kubernetes.io/docs/concepts/storage/storage-limits/#custom-limits Note that using this field is considered alpha-/experimental-level and is on your own risk. You should be aware of all the side-effects and consequences when changing it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeletConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfig contains configuration settings for the kubelet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"cpuCFSQuota": {
						SchemaProps: spec.SchemaProps{
							Description: "CPUCFSQuota allows you to disable/enable CPU throttling for Pods.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cpuManagerPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "CPUManagerPolicy allows to set alternative CPU management policies (default: none).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionHard": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionHard describes a set of eviction thresholds (e.g. memory.available<1Gi) that if met would trigger a Pod eviction. Default:\n  memory.available:   \"100Mi/1Gi/5%\"\n  nodefs.available:   \"5%\"\n  nodefs.inodesFree:  \"5%\"\n  imagefs.available:  \"5%\"\n  imagefs.inodesFree: \"5%\"",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEviction"),
						},
					},
					"evictionMaxPodGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionMaxPodGracePeriod describes the maximum allowed grace period (in seconds) to use when terminating pods in response to a soft eviction threshold being met. Default: 90",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionMinimumReclaim": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionMinimumReclaim configures the amount of resources below the configured eviction threshold that the kubelet attempts to reclaim whenever the kubelet observes resource pressure. Default: 0 for each resource",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionMinimumReclaim"),
						},
					},
					"evictionPressureTransitionPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionPressureTransitionPeriod is the duration for which the kubelet has to wait before transitioning out of an eviction pressure condition. Default: 4m0s",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"evictionSoft": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionSoft describes a set of eviction thresholds (e.g. memory.available<1.5Gi) that if met over a corresponding grace period would trigger a Pod eviction. Default:\n  memory.available:   \"200Mi/1.5Gi/10%\"\n  nodefs.available:   \"10%\"\n  nodefs.inodesFree:  \"10%\"\n  imagefs.available:  \"10%\"\n  imagefs.inodesFree: \"10%\"",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEviction"),
						},
					},
					"evictionSoftGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionSoftGracePeriod describes a set of eviction grace periods (e.g. memory.available=1m30s) that correspond to how long a soft eviction threshold must hold before triggering a Pod eviction. Default:\n  memory.available:   1m30s\n  nodefs.available:   1m30s\n  nodefs.inodesFree:  1m30s\n  imagefs.available:  1m30s\n  imagefs.inodesFree: 1m30s",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionSoftGracePeriod"),
						},
					},
					"maxPods": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxPods is the maximum number of Pods that are allowed by the Kubelet. Default: 110",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"podPidsLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "PodPIDsLimit is the maximum number of process IDs per pod allowed by the kubelet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"imagePullProgressDeadline": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullProgressDeadline describes the time limit under which if no pulling progress is made, the image pulling will be cancelled. Default: 1m",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"failSwapOn": {
						SchemaProps: spec.SchemaProps{
							Description: "FailSwapOn makes the Kubelet fail to start if swap is enabled on the node. (default true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"kubeReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeReserved is the configuration for resources reserved for kubernetes node components (mainly kubelet and container runtime). When updating these values, be aware that cgroup resizes may not succeed on active worker nodes. Look for the NodeAllocatableEnforced event to determine if the configuration was applied. Default: cpu=80m,memory=1Gi",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigReserved"),
						},
					},
					"systemReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemReserved is the configuration for resources reserved for system processes not managed by kubernetes (e.g. journald). When updating these values, be aware that cgroup resizes may not succeed on active worker nodes. Look for the NodeAllocatableEnforced event to determine if the configuration was applied.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigReserved"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEviction", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionMinimumReclaim", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigEvictionSoftGracePeriod", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfigReserved", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeletConfigEviction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEviction contains kubelet eviction thresholds supporting either a resource.Quantity or a percentage based value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the threshold for the free memory on the host server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the threshold for the free disk space in the imagefs filesystem (docker images and container writable layers).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the threshold for the available inodes in the imagefs filesystem.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the threshold for the free disk space in the nodefs filesystem (docker volumes, logs, etc).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the threshold for the available inodes in the nodefs filesystem.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeletConfigEvictionMinimumReclaim(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEvictionMinimumReclaim contains configuration for the kubelet eviction minimum reclaim.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the threshold for the memory reclaim on the host server.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the threshold for the disk space reclaim in the imagefs filesystem (docker images and container writable layers).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the threshold for the inodes reclaim in the imagefs filesystem.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the threshold for the disk space reclaim in the nodefs filesystem (docker volumes, logs, etc).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the threshold for the inodes reclaim in the nodefs filesystem.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeletConfigEvictionSoftGracePeriod(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEvictionSoftGracePeriod contains grace periods for kubelet eviction thresholds.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the grace period for the MemoryAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the grace period for the ImageFSAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the grace period for the ImageFSInodesFree eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the grace period for the NodeFSAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the grace period for the NodeFSInodesFree eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubeletConfigReserved(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigReserved contains reserved resources for daemons",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpu": {
						SchemaProps: spec.SchemaProps{
							Description: "CPU is the reserved cpu.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Description: "Memory is the reserved memory.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"ephemeralStorage": {
						SchemaProps: spec.SchemaProps{
							Description: "EphemeralStorage is the reserved ephemeral-storage.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "PID is the reserved process-ids. To reserve PID, the SupportNodePidsLimit feature gate must be enabled in Kubernetes versions < 1.15.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_Kubernetes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Kubernetes contains the version and configuration variables for the Shoot control plane.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowPrivilegedContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowPrivilegedContainers indicates whether privileged containers are allowed in the Shoot (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterAutoscaler contains the configuration flags for the Kubernetes cluster autoscaler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterAutoscaler"),
						},
					},
					"kubeAPIServer": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeAPIServer contains configuration settings for the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeAPIServerConfig"),
						},
					},
					"kubeControllerManager": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeControllerManager contains configuration settings for the kube-controller-manager.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeControllerManagerConfig"),
						},
					},
					"kubeScheduler": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeScheduler contains configuration settings for the kube-scheduler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeSchedulerConfig"),
						},
					},
					"kubeProxy": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeProxy contains configuration settings for the kube-proxy.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeProxyConfig"),
						},
					},
					"kubelet": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet contains configuration settings for the kubelet.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfig"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the semantic Kubernetes version to use for the Shoot cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verticalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "VerticalPodAutoscaler contains the configuration flags for the Kubernetes vertical pod autoscaler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.VerticalPodAutoscaler"),
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterAutoscaler", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeAPIServerConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeControllerManagerConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeProxyConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeSchedulerConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfig", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.VerticalPodAutoscaler"},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesConfig contains common configuration fields for the control plane components.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesDashboard(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDashboard describes configuration values for the kubernetes-dashboard addon.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"authenticationMode": {
						SchemaProps: spec.SchemaProps{
							Description: "AuthenticationMode defines the authentication mode for the kubernetes-dashboard.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesInfo contains the version and configuration variables for the Plant cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the semantic Kubernetes version to use for the Plant cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_KubernetesSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesSettings contains constraints regarding allowed values of the 'kubernetes' block in the Shoot specification.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "version",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Versions is the list of allowed Kubernetes versions with optional expiration dates for Shoot clusters.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExpirableVersion"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExpirableVersion"},
	}
}

func schema_pkg_apis_core_v1alpha1_LastError(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LastError indicates the last occurred error for an operation on a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the last error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"taskID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID of the task which caused this last error",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"codes": {
						SchemaProps: spec.SchemaProps{
							Description: "Well-defined error codes of the last error(s).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the error was reported",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"description"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_LastOperation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LastOperation indicates the type and the state of the last operation, along with a description message and a progress indicator.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the last operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the operation state transitioned from one to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"progress": {
						SchemaProps: spec.SchemaProps{
							Description: "The progress in percentage (0-100) of the last operation.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the last operation, one of Aborted, Processing, Succeeded, Error, Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the last operation, one of Create, Reconcile, Delete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"description", "lastUpdateTime", "progress", "state", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_Machine(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Machine contains information about the machine type and image.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the machine type of the worker group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Image holds information about the machine image to use for all nodes of this pool. It will default to the latest version of the first image stated in the referenced CloudProfile if no value has been provided.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootMachineImage"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootMachineImage"},
	}
}

func schema_pkg_apis_core_v1alpha1_MachineControllerManagerSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineControllerManagerSettings contains configurations for different worker-pools. Eg. MachineDrainTimeout, MachineHealthTimeout.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"machineDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineDrainTimeout is the period after which machine is forcefully deleted.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"machineHealthTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthTimeout is the period after which machine is declared failed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"machineCreationTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineCreationTimeout is the period after which creation of the machine is declared failed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"maxEvictRetries": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxEvictRetries are the number of eviction retries on a pod after which drain is declared failed, and forceful deletion is triggered.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nodeConditions": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeConditions are the set of conditions if set to true for the period of MachineHealthTimeout, machine will be declared failed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_MachineImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineImage defines the name and multiple versions of the machine image in any environment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "version",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Versions contains versions, expiration dates and container runtimes of the machine image",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImageVersion"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "versions"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineImageVersion"},
	}
}

func schema_pkg_apis_core_v1alpha1_MachineImageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineImageVersion is an expirable version with list of supported container runtimes and interfaces",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version identifier.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationDate": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationDate defines the time at which this version expires.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"classification": {
						SchemaProps: spec.SchemaProps{
							Description: "Classification defines the state of a version (preview, supported, deprecated)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cri": {
						SchemaProps: spec.SchemaProps{
							Description: "CRI list of supported container runtime and interfaces supported by this version",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.CRI"),
									},
								},
							},
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CRI", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_MachineType(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineType contains certain properties of a machine type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpu": {
						SchemaProps: spec.SchemaProps{
							Description: "CPU is the number of CPUs for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"gpu": {
						SchemaProps: spec.SchemaProps{
							Description: "GPU is the number of GPUs for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Description: "Memory is the amount of memory for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the machine type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storage": {
						SchemaProps: spec.SchemaProps{
							Description: "Storage is the amount of storage associated with the root volume of this machine type.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineTypeStorage"),
						},
					},
					"usable": {
						SchemaProps: spec.SchemaProps{
							Description: "Usable defines if the machine type can be used for shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"cpu", "gpu", "memory", "name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineTypeStorage", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_MachineTypeStorage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineTypeStorage is the amount of storage associated with the root volume of this machine type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the class of the storage type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "StorageSize is the storage size.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the storage.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"class", "size", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_Maintenance(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Maintenance contains information about the time window for maintenance operations and which operations should be performed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"autoUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "AutoUpdate contains information about which constraints should be automatically updated.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceAutoUpdate"),
						},
					},
					"timeWindow": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeWindow contains information about the time window for maintenance operations.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceTimeWindow"),
						},
					},
					"confineSpecUpdateRollout": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfineSpecUpdateRollout prevents that changes/updates to the shoot specification will be rolled out immediately. Instead, they are rolled out during the shoot's maintenance time window. There is one exception that will trigger an immediate roll out which is changes to the Spec.Hibernation.Enabled field.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceAutoUpdate", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.MaintenanceTimeWindow"},
	}
}

func schema_pkg_apis_core_v1alpha1_MaintenanceAutoUpdate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MaintenanceAutoUpdate contains information about which constraints should be automatically updated.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetesVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesVersion indicates whether the patch Kubernetes version may be automatically updated (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"machineImageVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineImageVersion indicates whether the machine image version may be automatically updated (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"kubernetesVersion", "machineImageVersion"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_MaintenanceTimeWindow(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MaintenanceTimeWindow contains information about the time window for maintenance operations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"begin": {
						SchemaProps: spec.SchemaProps{
							Description: "Begin is the beginning of the time window in the format HHMMSS+ZONE, e.g. \"220000+0100\". If not present, a random value will be computed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"end": {
						SchemaProps: spec.SchemaProps{
							Description: "End is the end of the time window in the format HHMMSS+ZONE, e.g. \"220000+0100\". If not present, the value will be computed based on the \"Begin\" value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"begin", "end"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Monitoring(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Monitoring contains information about the monitoring configuration for the shoot.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"alerting": {
						SchemaProps: spec.SchemaProps{
							Description: "Alerting contains information about the alerting configuration for the shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Alerting"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Alerting"},
	}
}

func schema_pkg_apis_core_v1alpha1_NamedResourceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedResourceReference is a named reference to a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the resource reference.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRef is a reference to a resource.",
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
				},
				Required: []string{"name", "resourceRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_Networking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Networking defines networking parameters for the shoot cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type identifies the type of the networking plugin.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to network resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodes": {
						SchemaProps: spec.SchemaProps{
							Description: "Nodes is the CIDR of the entire node network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_NginxIngress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NginxIngress describes configuration values for the nginx-ingress addon.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"loadBalancerSourceRanges": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancerSourceRanges is list of whitelist IP sources for NginxIngress",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"config": {
						SchemaProps: spec.SchemaProps{
							Description: "Config contains custom configuration for the nginx-ingress-controller configuration. See https://github.com/kubernetes/ingress-nginx/blob/master/docs/user-guide/nginx-configuration/configmap.md#configuration-options",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"externalTrafficPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "ExternalTrafficPolicy controls the `.spec.externalTrafficPolicy` value of the load balancer `Service` exposing the nginx-ingress. Defaults to `Cluster`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_OIDCConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OIDCConfig contains configuration settings for the OIDC provider. Note: Descriptions were taken from the Kubernetes documentation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the OpenID server's certificate will be verified by one of the authorities in the oidc-ca-file, otherwise the host's root CA set will be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientAuthentication": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientAuthentication can optionally contain client configuration used for kubeconfig generation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.OpenIDConnectClientAuthentication"),
						},
					},
					"clientID": {
						SchemaProps: spec.SchemaProps{
							Description: "The client ID for the OpenID Connect client, must be set if oidc-issuer-url is set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, the name of a custom OpenID Connect claim for specifying user groups. The claim value is expected to be a string or array of strings. This flag is experimental, please see the authentication documentation for further details.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsPrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all groups will be prefixed with this value to prevent conflicts with other authentication strategies.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"issuerURL": {
						SchemaProps: spec.SchemaProps{
							Description: "The URL of the OpenID issuer, only HTTPS scheme will be accepted. If set, it will be used to verify the OIDC JSON Web Token (JWT).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requiredClaims": {
						SchemaProps: spec.SchemaProps{
							Description: "ATTENTION: Only meaningful for Kubernetes >= 1.11 key=value pairs that describes a required claim in the ID Token. If set, the claim is verified to be present in the ID Token with a matching value.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"signingAlgs": {
						SchemaProps: spec.SchemaProps{
							Description: "List of allowed JOSE asymmetric signing algorithms. JWTs with a 'alg' header value not in this list will be rejected. Values are defined by RFC 7518 https://tools.ietf.org/html/rfc7518#section-3.1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"usernameClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "The OpenID claim to use as the user name. Note that claims other than the default ('sub') is not guaranteed to be unique and immutable. This flag is experimental, please see the authentication documentation for further details. (default \"sub\")",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"usernamePrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all usernames will be prefixed with this value. If not provided, username claims other than 'email' are prefixed by the issuer URL to avoid clashes. To skip any prefixing, provide the value '-'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.OpenIDConnectClientAuthentication"},
	}
}

func schema_pkg_apis_core_v1alpha1_OpenIDConnectClientAuthentication(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectClientAuthentication contains configuration for OIDC clients.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"extraConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra configuration added to kubeconfig's auth-provider. Must not be any of idp-issuer-url, client-id, client-secret, idp-certificate-authority, idp-certificate-authority-data, id-token or refresh-token",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "The client Secret for the OpenID Connect client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_Plant(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this Plant.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this Plant.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.PlantStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PlantList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantList is a collection of Plants.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Plants.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Plant"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Plant", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_PlantSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantSpec is the specification of a Plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the Kubeconfig of the external kubernetes clusters to be added to Gardener.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"endpoints": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Endpoints is the configuration plant endpoints",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Endpoint"),
									},
								},
							},
						},
					},
				},
				Required: []string{"secretRef"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Endpoint", "k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_PlantStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantStatus is the status of a Plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Plant's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Plant. It corresponds to the Plant's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"clusterInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterInfo is additional computed information about the newly added cluster (Plant)",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterInfo"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ClusterInfo", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"},
	}
}

func schema_pkg_apis_core_v1alpha1_Project(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Project holds certain properties about a Gardener project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the project properties.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Project.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ProjectList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectList is a collection of Projects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Projects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Project"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Project", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ProjectMember(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectMember is a member of a project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup holds the API group of the referenced subject. Defaults to \"\" for ServiceAccount subjects. Defaults to \"rbac.authorization.k8s.io\" for User and Group subjects.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object being referenced.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"role": {
						SchemaProps: spec.SchemaProps{
							Description: "Role represents the role of this member. IMPORTANT: Be aware that this field will be removed in the `v1` version of this API in favor of the `roles` list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"roles": {
						SchemaProps: spec.SchemaProps{
							Description: "Roles represents the list of roles of this member.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"kind", "name", "role"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ProjectSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectSpec is the specification of a Project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"createdBy": {
						SchemaProps: spec.SchemaProps{
							Description: "CreatedBy is a subject representing a user name, an email address, or any other identifier of a user who created the project.",
							Ref:         ref("k8s.io/api/rbac/v1.Subject"),
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is a human-readable description of what the project is used for.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"owner": {
						SchemaProps: spec.SchemaProps{
							Description: "Owner is a subject representing a user name, an email address, or any other identifier of a user owning the project. IMPORTANT: Be aware that this field will be removed in the `v1` version of this API in favor of the `owner` role. The only way to change the owner will be by moving the `owner` role. In this API version the only way to change the owner is to use this field.",
							Ref:         ref("k8s.io/api/rbac/v1.Subject"),
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is a human-readable explanation of the project's purpose.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"members": {
						SchemaProps: spec.SchemaProps{
							Description: "Members is a list of subjects representing a user name, an email address, or any other identifier of a user, group, or service account that has a certain role.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectMember"),
									},
								},
							},
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the name of the namespace that has been created for the Project object. A nil value means that Gardener will determine the name of the namespace.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tolerations": {
						SchemaProps: spec.SchemaProps{
							Description: "Tolerations contains the default tolerations and a whitelist for taints on seed clusters.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectTolerations"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectMember", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ProjectTolerations", "k8s.io/api/rbac/v1.Subject"},
	}
}

func schema_pkg_apis_core_v1alpha1_ProjectStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectStatus holds the most recently observed status of the project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this project.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is the current phase of the project.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"staleSinceTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "StaleSinceTimestamp contains the timestamp when the project was first discovered to be stale/unused.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"staleAutoDeleteTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "StaleAutoDeleteTimestamp contains the timestamp when the project will be garbage-collected/automatically deleted because it's stale/unused.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_ProjectTolerations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectTolerations contains the tolerations for taints on seed clusters.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"defaults": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Defaults contains a list of tolerations that are added to the shoots in this project by default.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration"),
									},
								},
							},
						},
					},
					"whitelist": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Whitelist contains a list of tolerations that are allowed to be added to the shoots in this project. Please note that this list may only be added by users having the `spec-tolerations-whitelist` verb for project resources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration"},
	}
}

func schema_pkg_apis_core_v1alpha1_Provider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Provider contains provider-specific information that are handed-over to the provider-specific extension controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"controlPlaneConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlaneConfig contains the provider-specific control plane config blob. Please look up the concrete definition in the documentation of your provider extension.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"infrastructureConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureConfig contains the provider-specific infrastructure config blob. Please look up the concrete definition in the documentation of your provider extension.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"workers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Workers is a list of worker groups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Worker"),
									},
								},
							},
						},
					},
				},
				Required: []string{"type", "workers"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Worker", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_Quota(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the Quota constraints.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.QuotaSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.QuotaSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_QuotaList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "QuotaList is a collection of Quotas.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Quotas.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Quota"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Quota", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_QuotaSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "QuotaSpec is the specification of a Quota.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterLifetimeDays": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterLifetimeDays is the lifetime of a Shoot cluster in days before it will be terminated automatically.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						SchemaProps: spec.SchemaProps{
							Description: "Metrics is a list of resources which will be put under constraints.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "Scope is the scope of the Quota object, either 'project' or 'secret'.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"metrics", "scope"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_Region(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Region contains certain properties of a region.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is a region name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Zones is a list of availability zones in this region.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.AvailabilityZone"),
									},
								},
							},
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels is an optional set of key-value pairs that contain certain administrator-controlled labels for this region. It can be used by Gardener administrators/operators to provide additional information about a region, e.g. wrt quality, reliability, access restrictions, etc.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.AvailabilityZone"},
	}
}

func schema_pkg_apis_core_v1alpha1_ResourceData(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceData holds the data of a resource referred to by an extension controller state.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data of the resource",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"kind", "name", "data"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ResourceWatchCacheSize(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceWatchCacheSize contains configuration of the API server's watch cache size for one specific resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup is the API group of the resource for which the watch cache size should be configured. An unset value is used to specify the legacy core API (e.g. for `secrets`).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is the name of the resource for which the watch cache size should be configured (in lowercase plural form, e.g. `secrets`).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "CacheSize specifies the watch cache size that should be configured for the specified resource.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"resource", "size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SecretBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a secret object in the same or another namespace.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"quotas": {
						SchemaProps: spec.SchemaProps{
							Description: "Quotas is a list of references to Quota objects in the same or another namespace.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ObjectReference"),
									},
								},
							},
						},
					},
				},
				Required: []string{"secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_SecretBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretBindingList is a collection of SecretBindings.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of SecretBindings.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SecretBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SecretBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_Seed(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Seed represents an installation request for an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedBackup(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedBackup contains the object store configuration for backups for shoot (currently only etcd).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider is a provider name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a region name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the cloud provider credentials for the object store where backups should be stored. It should have enough privileges to manipulate the objects as well as buckets.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
				Required: []string{"provider", "secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedDNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedDNS contains DNS-relevant information about this seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ingressDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "IngressDomain is the domain of the Seed cluster pointing to the ingress controller endpoint. It will be used to construct ingress URLs for system applications running in Shoot clusters.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ingressDomain"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedList is a collection of Seeds.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Seeds.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Seed"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Seed", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedNetworks(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedNetworks contains CIDRs for the pod, service and node networks of a Kubernetes cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodes": {
						SchemaProps: spec.SchemaProps{
							Description: "Nodes is the CIDR of the node network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"shootDefaults": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootDefaults contains the default networks CIDRs for shoots.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootNetworks"),
						},
					},
				},
				Required: []string{"pods", "services"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootNetworks"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedProvider defines the provider type and region for this Seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the name of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to Seed resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a name of a region.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSelector contains constraints for selecting seed to be usable for shoots using a profile",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
									},
								},
							},
						},
					},
					"providerTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "Providers is optional and can be used by restricting seeds by their provider type. '*' can be used to enable seeds regardless of their provider type.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettingExcessCapacityReservation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingExcessCapacityReservation controls the excess capacity reservation for shoot control planes in the seed. When enabled then this is done via PodPriority and requires the Seed cluster to have Kubernetes version 1.11 or the PodPriority feature gate as well as the scheduling.k8s.io/v1alpha1 API group enabled.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the excess capacity reservation should be enabled.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettingLoadBalancerServices(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingLoadBalancerServices controls certain settings for services of type load balancer that are created in the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a map of annotations that will be injected/merged into every load balancer service object.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettingScheduling(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingScheduling controls settings for scheduling decisions for the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"visible": {
						SchemaProps: spec.SchemaProps{
							Description: "Visible controls whether the gardener-scheduler shall consider this seed when scheduling shoots. Invisible seeds are not considered by the scheduler.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"visible"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettingShootDNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingShootDNS controls the shoot DNS settings for the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the DNS for shoot clusters should be enabled. When disabled then all shoots using the seed won't get any DNS providers, DNS records, and no DNS extension controller is required to be installed here. This is useful for environments where DNS is not required.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettingVerticalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingVerticalPodAutoscaler controls certain settings for the vertical pod autoscaler components deployed in the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the VPA components shall be deployed into the garden namespace in the seed cluster. It is enabled by default because Gardener heavily relies on a VPA being deployed. You should only disable this if your seed cluster already has another, manually/custom managed VPA deployment.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettings contains certain settings for this seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"excessCapacityReservation": {
						SchemaProps: spec.SchemaProps{
							Description: "ExcessCapacityReservation controls the excess capacity reservation for shoot control planes in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingExcessCapacityReservation"),
						},
					},
					"scheduling": {
						SchemaProps: spec.SchemaProps{
							Description: "Scheduling controls settings for scheduling decisions for the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingScheduling"),
						},
					},
					"shootDNS": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootDNS controls the shoot DNS settings for the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingShootDNS"),
						},
					},
					"loadBalancerServices": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancerServices controls certain settings for services of type load balancer that are created in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingLoadBalancerServices"),
						},
					},
					"verticalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "VerticalPodAutoscaler controls certain settings for the vertical pod autoscaler components deployed in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingVerticalPodAutoscaler"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingExcessCapacityReservation", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingLoadBalancerServices", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingScheduling", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingShootDNS", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettingVerticalPodAutoscaler"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSpec is the specification of a Seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"backup": {
						SchemaProps: spec.SchemaProps{
							Description: "Backup holds the object store configuration for the backups of shoot (currently only etcd). If it is not specified, then there won't be any backups taken for shoots associated with this seed. If backup field is present in seed, then backups of the etcd from shoot control plane will be stored under the configured object store.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedBackup"),
						},
					},
					"blockCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "BlockCIDRs is a list of network addresses that should be blocked for shoot control plane components running in the seed cluster.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"dns": {
						SchemaProps: spec.SchemaProps{
							Description: "DNS contains DNS-relevant information about this seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedDNS"),
						},
					},
					"networks": {
						SchemaProps: spec.SchemaProps{
							Description: "Networks defines the pod, service and worker network of the Seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedNetworks"),
						},
					},
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider defines the provider type and region for this Seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedProvider"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the Kubeconfig and the cloud provider credentials for the account the Seed cluster has been deployed to.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"taints": {
						SchemaProps: spec.SchemaProps{
							Description: "Taints describes taints on the seed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedTaint"),
									},
								},
							},
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume contains settings for persistentvolumes created in the seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolume"),
						},
					},
					"settings": {
						SchemaProps: spec.SchemaProps{
							Description: "Settings contains certain settings for this seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettings"),
						},
					},
				},
				Required: []string{"dns", "networks", "provider"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedBackup", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedDNS", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedNetworks", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedProvider", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSettings", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedTaint", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolume", "k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedStatus is the status of a Seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Seed's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"),
									},
								},
							},
						},
					},
					"gardener": {
						SchemaProps: spec.SchemaProps{
							Description: "Gardener holds information about the Gardener instance which last acted on the Seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Gardener"),
						},
					},
					"kubernetesVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesVersion is the Kubernetes version of the seed cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Seed. It corresponds to the Seed's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"clusterIdentity": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterIdentity is the identity of the Seed cluster",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Gardener"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedTaint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedTaint describes a taint on a seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Key is the taint key to be applied to a seed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the taint value corresponding to the taint key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedVolume contains settings for persistentvolumes created in the seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"minimumSize": {
						SchemaProps: spec.SchemaProps{
							Description: "MinimumSize defines the minimum size that should be used for PVCs in the seed.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"providers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Providers is a list of storage class provisioner types for the seed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolumeProvider"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedVolumeProvider", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1alpha1_SeedVolumeProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedVolumeProvider is a storage class provisioner type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose of this provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the storage class provisioner type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"purpose", "name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ServiceAccountConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccountConfig is the kube-apiserver configuration for service accounts.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"issuer": {
						SchemaProps: spec.SchemaProps{
							Description: "Issuer is the identifier of the service account token issuer. The issuer will assert this identifier in \"iss\" claim of issued tokens. This value is a string or URI. Defaults to URI of the API server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"signingKeySecretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SigningKeySecret is a reference to a secret that contains an optional private key of the service account token issuer. The issuer will sign issued ID tokens with this private key. Only useful if service account tokens are also issued by another external system.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_pkg_apis_core_v1alpha1_Shoot(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the Shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootSpec", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootList is a list of Shoot objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Shoots.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Shoot"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Shoot", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootMachineImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootMachineImage defines the name and the version of the shoot's machine image in any environment. Has to be defined in the respective CloudProfile.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the shoot's individual configuration passed to an extension resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version of the shoot's image. If version is not provided, it will be defaulted to the latest version from the CloudProfile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootNetworks(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootNetworks contains the default networks CIDRs for shoots.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootSpec is the specification of a Shoot.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"addons": {
						SchemaProps: spec.SchemaProps{
							Description: "Addons contains information about enabled/disabled addons and their configuration.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Addons"),
						},
					},
					"cloudProfileName": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudProfileName is a name of a CloudProfile object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dns": {
						SchemaProps: spec.SchemaProps{
							Description: "DNS contains information about the DNS settings of the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNS"),
						},
					},
					"extensions": {
						SchemaProps: spec.SchemaProps{
							Description: "Extensions contain type and provider information for Shoot extensions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Extension"),
									},
								},
							},
						},
					},
					"hibernation": {
						SchemaProps: spec.SchemaProps{
							Description: "Hibernation contains information whether the Shoot is suspended or not.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Hibernation"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains the version and configuration settings of the control plane components.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Kubernetes"),
						},
					},
					"networking": {
						SchemaProps: spec.SchemaProps{
							Description: "Networking contains information about cluster networking such as CNI Plugin type, CIDRs, ...etc.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Networking"),
						},
					},
					"maintenance": {
						SchemaProps: spec.SchemaProps{
							Description: "Maintenance contains information about the time window for maintenance operations and which operations should be performed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Maintenance"),
						},
					},
					"monitoring": {
						SchemaProps: spec.SchemaProps{
							Description: "Monitoring contains information about custom monitoring configurations for the shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Monitoring"),
						},
					},
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider contains all provider-specific and provider-relevant information.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Provider"),
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose class for this cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a name of a region.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretBindingName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretBindingName is the name of the a SecretBinding that has a reference to the provider secret. The credentials inside the provider secret will be used to create the shoot in the respective account.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedName": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedName is the name of the seed cluster that runs the control plane of the Shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector is an optional selector which must match a seed's labels for the shoot to be scheduled on that seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSelector"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources holds a list of named resource references that can be referred to in extension configs by their names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.NamedResourceReference"),
									},
								},
							},
						},
					},
					"tolerations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Tolerations contains the tolerations for taints on seed clusters.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"cloudProfileName", "kubernetes", "networking", "provider", "region", "secretBindingName"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Addons", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.DNS", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Extension", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Hibernation", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Kubernetes", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Maintenance", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Monitoring", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.NamedResourceReference", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Networking", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Provider", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.SeedSelector", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Toleration"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootState contains a snapshot of the Shoot's state required to migrate the Shoot's control plane to a new Seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the ShootState.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootStateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootStateList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootStateList is a list of ShootState objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ShootStates.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootState"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ShootState", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootStateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootStateSpec is the specification of the ShootState.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"gardener": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Gardener holds the data required to generate resources deployed by the gardenlet",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.GardenerResourceData"),
									},
								},
							},
						},
					},
					"extensions": {
						SchemaProps: spec.SchemaProps{
							Description: "Extensions holds the state of custom resources reconciled by extension controllers in the seed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExtensionResourceState"),
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources holds the data of resources referred to by extension controller states",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceData"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ExtensionResourceState", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.GardenerResourceData", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceData"},
	}
}

func schema_pkg_apis_core_v1alpha1_ShootStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootStatus holds the most recently observed status of the Shoot cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Shoots's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"),
									},
								},
							},
						},
					},
					"constraints": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Constraints represents conditions of a Shoot's current state that constraint some operations on it.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition"),
									},
								},
							},
						},
					},
					"gardener": {
						SchemaProps: spec.SchemaProps{
							Description: "Gardener holds information about the Gardener which last acted on the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Gardener"),
						},
					},
					"hibernated": {
						SchemaProps: spec.SchemaProps{
							Description: "IsHibernated indicates whether the Shoot is currently hibernated.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation"),
						},
					},
					"lastError": {
						SchemaProps: spec.SchemaProps{
							Description: "LastError holds information about the last occurred error during an operation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError"),
						},
					},
					"lastErrors": {
						SchemaProps: spec.SchemaProps{
							Description: "LastErrors holds information about the last occurred error(s) during an operation.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Shoot. It corresponds to the Shoot's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"retryCycleStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "RetryCycleStartTime is the start time of the last retry cycle (used to determine how often an operation must be retried until we give up).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"seed": {
						SchemaProps: spec.SchemaProps{
							Description: "Seed is the name of the seed cluster that runs the control plane of the Shoot. This value is only written after a successful create/reconcile operation. It will be used when control planes are moved between Seeds.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"technicalID": {
						SchemaProps: spec.SchemaProps{
							Description: "TechnicalID is the name that is used for creating the Seed namespace, the infrastructure resources, and basically everything that is related to this particular Shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is a unique identifier for the Shoot cluster to avoid portability between Kubernetes clusters. It is used to compute unique hashes.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterIdentity": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterIdentity is the identity of the Shoot cluster",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"gardener", "hibernated", "technicalID", "uid"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.Condition", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Gardener", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.LastOperation", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1alpha1_Toleration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Toleration is a toleration for a seed taint.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Key is the toleration key to be applied to a project or shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the toleration value corresponding to the toleration key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_VerticalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VerticalPodAutoscaler contains the configuration flags for the Kubernetes vertical pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled specifies whether the Kubernetes VPA shall be enabled for the shoot cluster.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evictAfterOOMThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictAfterOOMThreshold defines the threshold that will lead to pod eviction in case it OOMed in less than the given threshold since its start and if it has only one container (default: 10m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"evictionRateBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionRateBurst defines the burst of pods that can be evicted (default: 1)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionRateLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionRateLimit defines the number of pods that can be evicted per second. A rate limit set to 0 or -1 will disable the rate limiter (default: -1).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"evictionTolerance": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionTolerance defines the fraction of replica count that can be evicted for update in case more than one pod can be evicted (default: 0.5).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"recommendationMarginFraction": {
						SchemaProps: spec.SchemaProps{
							Description: "RecommendationMarginFraction is the fraction of usage added as the safety margin to the recommended request (default: 0.15).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"updaterInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "UpdaterInterval is the interval how often the updater should run (default: 1m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"recommenderInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "RecommenderInterval is the interval how often metrics should be fetched (default: 1m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1alpha1_Volume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Volume contains information about the volume type and size.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the volume to make it referencable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "Size is the size of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encrypted": {
						SchemaProps: spec.SchemaProps{
							Description: "Encrypted determines if the volume should be encrypted.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_VolumeType(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VolumeType contains certain properties of a volume type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the class of the volume type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the volume type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"usable": {
						SchemaProps: spec.SchemaProps{
							Description: "Usable defines if the volume type can be used for shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"class", "name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1alpha1_WatchCacheSizes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WatchCacheSizes contains configuration of the API server's watch cache sizes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default configures the default watch cache size of the kube-apiserver (flag `--default-watch-cache-size`, defaults to 100). See: https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources configures the watch cache size of the kube-apiserver per resource (flag `--watch-cache-sizes`). See: https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceWatchCacheSize"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.ResourceWatchCacheSize"},
	}
}

func schema_pkg_apis_core_v1alpha1_Worker(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Worker is the base definition of a worker group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a map of key/value pairs for annotations for all the `Node` objects in this worker pool.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "CABundle is a certificate bundle which will be installed onto every machine of this worker pool.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cri": {
						SchemaProps: spec.SchemaProps{
							Description: "CRI contains configurations of CRI support of every machine in the worker pool",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.CRI"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains configuration for Kubernetes components related to this worker pool.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerKubernetes"),
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels is a map of key/value pairs for labels for all the `Node` objects in this worker pool.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the worker group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"machine": {
						SchemaProps: spec.SchemaProps{
							Description: "Machine contains information about the machine type and image.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Machine"),
						},
					},
					"maximum": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum is the maximum number of VMs to create.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minimum": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum is the minimum number of VMs to create.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxSurge is maximum number of VMs that are created during an update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxUnavailable is the maximum number of VMs that can be unavailable during an update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the provider-specific configuration for this worker pool.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"taints": {
						SchemaProps: spec.SchemaProps{
							Description: "Taints is a list of taints for all the `Node` objects in this worker pool.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Taint"),
									},
								},
							},
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume contains information about the volume type and size.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.Volume"),
						},
					},
					"dataVolumes": {
						SchemaProps: spec.SchemaProps{
							Description: "DataVolumes contains a list of additional worker volumes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.DataVolume"),
									},
								},
							},
						},
					},
					"kubeletDataVolumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeletDataVolumeName contains the name of a dataVolume that should be used for storing kubelet state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						SchemaProps: spec.SchemaProps{
							Description: "Zones is a list of availability zones that are used to evenly distribute this worker pool. Optional as not every provider may support availability zones.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"systemComponents": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemComponents contains configuration for system components related to this worker pool",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerSystemComponents"),
						},
					},
					"machineControllerManager": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineControllerManagerSettings contains configurations for different worker-pools. Eg. MachineDrainTimeout, MachineHealthTimeout.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineControllerManagerSettings"),
						},
					},
				},
				Required: []string{"name", "machine", "maximum", "minimum"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.CRI", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.DataVolume", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Machine", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.MachineControllerManagerSettings", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.Volume", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerKubernetes", "github.com/gardener/gardener/pkg/apis/core/v1alpha1.WorkerSystemComponents", "k8s.io/api/core/v1.Taint", "k8s.io/apimachinery/pkg/runtime.RawExtension", "k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_pkg_apis_core_v1alpha1_WorkerKubernetes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkerKubernetes contains configuration for Kubernetes components related to this worker pool.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubelet": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet contains configuration settings for all kubelets of this worker pool.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfig"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1alpha1.KubeletConfig"},
	}
}

func schema_pkg_apis_core_v1alpha1_WorkerSystemComponents(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkerSystemComponents contains configuration for system components related to this worker pool",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allow": {
						SchemaProps: spec.SchemaProps{
							Description: "Allow determines whether the pool should be allowed to host system components or not (defaults to true)",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"allow"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Addon(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Addon allows enabling or disabling a specific addon and is used to derive from.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Addons(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Addons is a collection of configuration for specific addons which are managed by the Gardener.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetesDashboard": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesDashboard holds configuration settings for the kubernetes dashboard addon.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesDashboard"),
						},
					},
					"nginxIngress": {
						SchemaProps: spec.SchemaProps{
							Description: "NginxIngress holds configuration settings for the nginx-ingress addon.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.NginxIngress"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesDashboard", "github.com/gardener/gardener/pkg/apis/core/v1beta1.NginxIngress"},
	}
}

func schema_pkg_apis_core_v1beta1_AdmissionPlugin(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AdmissionPlugin contains information about a specific admission plugin and its corresponding configuration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the plugin.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"config": {
						SchemaProps: spec.SchemaProps{
							Description: "Config is the configuration of the plugin.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_Alerting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Alerting contains information about how alerting will be done (i.e. who will receive alerts and how).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"emailReceivers": {
						SchemaProps: spec.SchemaProps{
							Description: "MonitoringEmailReceivers is a list of recipients for alerts",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_AuditConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditConfig contains settings for audit of the api server",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"auditPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "AuditPolicy contains configuration settings for audit policy of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditPolicy"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditPolicy"},
	}
}

func schema_pkg_apis_core_v1beta1_AuditPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditPolicy contains audit policy for kube-apiserver",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMapRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMapRef is a reference to a ConfigMap object in the same namespace, which contains the audit policy for the kube-apiserver.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_pkg_apis_core_v1beta1_AvailabilityZone(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AvailabilityZone is an availability zone.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an an availability zone name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"unavailableMachineTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "UnavailableMachineTypes is a list of machine type names that are not availability in this zone.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"unavailableVolumeTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "UnavailableVolumeTypes is a list of volume type names that are not availability in this zone.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_BackupBucket(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucket holds details about backup bucket",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the Backup Bucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Backup Bucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketStatus"),
						},
					},
				},
				Required: []string{"metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupBucketList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketList is a list of BackupBucket objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of BackupBucket.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucket"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucket", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupBucketProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketProvider holds the details of cloud provider of the object store.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is the region of the bucket.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_BackupBucketSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketSpec is the specification of a Backup Bucket.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider hold the details of cloud provider of the object store.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketProvider"),
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a secret that contains the credentials to access object store.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"seedName": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedName holds the name of the seed allocated to BackupBucket for running controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"provider", "secretRef"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupBucketProvider", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupBucketStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupBucketStatus holds the most recently observed status of the Backup Bucket.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"providerStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderStatus is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the BackupBucket.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation"),
						},
					},
					"lastError": {
						SchemaProps: spec.SchemaProps{
							Description: "LastError holds information about the last occurred error during an operation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError"),
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this BackupBucket. It corresponds to the BackupBucket's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"generatedSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "GeneratedSecretRef is reference to the secret generated by backup bucket, which will have object store specific credentials.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupEntry(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntry holds details about shoot backup.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of the Backup Entry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntrySpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the most recently observed status of the Backup Entry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntryStatus"),
						},
					},
				},
				Required: []string{"metadata"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntrySpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntryStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupEntryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntryList is a list of BackupEntry objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of BackupEntry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntry"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.BackupEntry", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_BackupEntrySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntrySpec is the specification of a Backup Entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bucketName": {
						SchemaProps: spec.SchemaProps{
							Description: "BucketName is the name of backup bucket for this Backup Entry.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedName": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedName holds the name of the seed allocated to BackupEntry for running controller.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"bucketName"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_BackupEntryStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BackupEntryStatus holds the most recently observed status of the Backup Entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the BackupEntry.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation"),
						},
					},
					"lastError": {
						SchemaProps: spec.SchemaProps{
							Description: "LastError holds information about the last occurred error during an operation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError"),
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this BackupEntry. It corresponds to the BackupEntry's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation"},
	}
}

func schema_pkg_apis_core_v1beta1_CRI(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CRI contains information about the Container Runtimes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the CRI library",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntimes": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerRuntimes is the list of the required container runtimes supported for a worker pool.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ContainerRuntime"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ContainerRuntime"},
	}
}

func schema_pkg_apis_core_v1beta1_CloudInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudInfo contains information about the cloud",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the cloud type",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is the cloud region",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_CloudProfile(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfile represents certain properties about a provider environment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the provider environment properties.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfileSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfileSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_CloudProfileList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfileList is a collection of CloudProfiles.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of CloudProfiles.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfile"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudProfile", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_CloudProfileSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CloudProfileSpec is the specification of a CloudProfile. It must contain exactly one of its defined keys.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "CABundle is a certificate bundle which will be installed onto every host machine of shoot cluster targeting this profile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains constraints regarding allowed values of the 'kubernetes' block in the Shoot specification.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesSettings"),
						},
					},
					"machineImages": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MachineImages contains constraints regarding allowed values for machine images in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImage"),
									},
								},
							},
						},
					},
					"machineTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MachineTypes contains constraints regarding allowed values for machine types in the 'workers' block in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineType"),
									},
								},
							},
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig contains provider-specific configuration for the profile.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"regions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Regions contains constraints regarding allowed values for regions and zones.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Region"),
									},
								},
							},
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector contains an optional list of labels on `Seed` resources that marks those seeds whose shoots may use this provider profile. An empty list means that all seeds of the same provider type are supported. This is useful for environments that are of the same type (like openstack) but may have different \"instances\"/landscapes. Optionally a list of possible providers can be added to enable cross-provider scheduling. By default, the provider type of the seed must match the shoot's provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSelector"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the name of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "VolumeTypes contains constraints regarding allowed values for volume types in the 'workers' block in the Shoot specification.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.VolumeType"),
									},
								},
							},
						},
					},
				},
				Required: []string{"kubernetes", "machineImages", "machineTypes", "regions", "type"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesSettings", "github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImage", "github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineType", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Region", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSelector", "github.com/gardener/gardener/pkg/apis/core/v1beta1.VolumeType", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_ClusterAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterAutoscaler contains the configuration flags for the Kubernetes cluster autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleDownDelayAfterAdd": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterAdd defines how long after scale up that scale down evaluation resumes (default: 1 hour).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownDelayAfterDelete": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterDelete how long after node deletion that scale down evaluation resumes, defaults to scanInterval (defaults to ScanInterval).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownDelayAfterFailure": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownDelayAfterFailure how long after scale down failure that scale down evaluation resumes (default: 3 mins).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownUnneededTime": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownUnneededTime defines how long a node should be unneeded before it is eligible for scale down (default: 30 mins).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"scaleDownUtilizationThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleDownUtilizationThreshold defines the threshold in % under which a node is being removed",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"scanInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "ScanInterval how often cluster is reevaluated for scale up or down (default: 10 secs).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_ClusterInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterInfo contains information about the Plant cluster",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cloud": {
						SchemaProps: spec.SchemaProps{
							Description: "Cloud describes the cloud information",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudInfo"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes describes kubernetes meta information (e.g., version)",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesInfo"),
						},
					},
				},
				Required: []string{"cloud", "kubernetes"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.CloudInfo", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubernetesInfo"},
	}
}

func schema_pkg_apis_core_v1beta1_Condition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Condition holds the information about the state of a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the Shoot condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition was updated.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"codes": {
						SchemaProps: spec.SchemaProps{
							Description: "Well-defined error codes in case the condition reports a problem.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"type", "status", "lastTransitionTime", "lastUpdateTime", "reason", "message"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_ContainerRuntime(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerRuntime contains information about worker's available container runtime",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the Container Runtime.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to container runtime resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerDeployment contains information for how this controller is deployed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the deployment type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig contains type-specific configuration.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"policy": {
						SchemaProps: spec.SchemaProps{
							Description: "Policy controls how the controller is deployed. It defaults to 'OnDemand'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector contains an optional label selector for seeds. Only if the labels match then this controller will be considered for a deployment. An empty list means that all seeds are selected.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerInstallation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallation represents an installation request for an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallationStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerInstallationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationList is a collection of ControllerInstallations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerInstallations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallation"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerInstallation", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerInstallationSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationSpec is the specification of a ControllerInstallation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"registrationRef": {
						SchemaProps: spec.SchemaProps{
							Description: "RegistrationRef is used to reference a ControllerRegistration resources.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"seedRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedRef is used to reference a Seed resources.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"registrationRef", "seedRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerInstallationStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerInstallationStatus is the status of a ControllerInstallation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a ControllerInstallations's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"providerStatus": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderStatus contains type-specific status.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerRegistration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistration represents a registration of an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this registration.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistrationSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistrationSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerRegistrationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistrationList is a collection of ControllerRegistrations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRegistrations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerRegistration", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerRegistrationSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRegistrationSpec is the specification of a ControllerRegistration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of combinations of kinds (DNSProvider, Infrastructure, Generic, ...) and their actual types (aws-route53, gcp, auditlog, ...).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerResource"),
									},
								},
							},
						},
					},
					"deployment": {
						SchemaProps: spec.SchemaProps{
							Description: "Deployment contains information for how this controller is deployed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerDeployment"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerDeployment", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ControllerResource"},
	}
}

func schema_pkg_apis_core_v1beta1_ControllerResource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerResource is a combination of a kind (DNSProvider, Infrastructure, Generic, ...) and the actual type for this kind (aws-route53, gcp, auditlog, ...).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the resource kind, for example \"OperatingSystemConfig\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the resource type, for example \"coreos\" or \"ubuntu\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"globallyEnabled": {
						SchemaProps: spec.SchemaProps{
							Description: "GloballyEnabled determines if this ControllerResource is required by all Shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reconcileTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "ReconcileTimeout defines how long Gardener should wait for the resource reconciliation.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"primary": {
						SchemaProps: spec.SchemaProps{
							Description: "Primary determines if the controller backed by this ControllerRegistration is responsible for the extension resource's lifecycle. This field defaults to true. There must be exactly one primary controller for this kind/type combination.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_DNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DNS holds information about the provider, the hosted zone id and the domain.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"domain": {
						SchemaProps: spec.SchemaProps{
							Description: "Domain is the external available domain of the Shoot cluster. This domain will be written into the kubeconfig that is handed out to end-users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Providers is a list of DNS providers that shall be enabled for this shoot cluster. Only relevant if not a default domain is used.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSProvider"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSProvider"},
	}
}

func schema_pkg_apis_core_v1beta1_DNSIncludeExclude(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"include": {
						SchemaProps: spec.SchemaProps{
							Description: "Include is a list of resources that shall be included.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"exclude": {
						SchemaProps: spec.SchemaProps{
							Description: "Exclude is a list of resources that shall be excluded.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_DNSProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DNSProvider contains information about a DNS provider.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"domains": {
						SchemaProps: spec.SchemaProps{
							Description: "Domains contains information about which domains shall be included/excluded for this provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSIncludeExclude"),
						},
					},
					"primary": {
						SchemaProps: spec.SchemaProps{
							Description: "Primary indicates that this DNSProvider is used for shoot related domains.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretName is a name of a secret containing credentials for the stated domain and the provider. When not specified, the Gardener will use the cloud provider credentials referenced by the Shoot and try to find respective credentials there (primary provider only). Specifying this field may override this behavior, i.e. forcing the Gardener to only look into the given secret.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the DNS provider type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						SchemaProps: spec.SchemaProps{
							Description: "Zones contains information about which hosted zones shall be included/excluded for this provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSIncludeExclude"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.DNSIncludeExclude"},
	}
}

func schema_pkg_apis_core_v1beta1_DataVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DataVolume contains information about a data volume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the volume to make it referencable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeSize is the size of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encrypted": {
						SchemaProps: spec.SchemaProps{
							Description: "Encrypted determines if the volume should be encrypted.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Endpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Endpoint is an endpoint for monitoring, logging and other services around the plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "URL is the url of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose of the endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "url", "purpose"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_ExpirableVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpirableVersion contains a version and an expiration date.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version identifier.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationDate": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationDate defines the time at which this version expires.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"classification": {
						SchemaProps: spec.SchemaProps{
							Description: "Classification defines the state of a version (preview, supported, deprecated)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_Extension(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Extension contains type and provider information for Shoot extensions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the extension resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to extension resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"disabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Disabled allows to disable extensions that were marked as 'globally enabled' by Gardener administrators.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_Gardener(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Gardener holds the information about the Gardener version that operated a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "ID is the Docker container id of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the hostname (pod name) of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version of the Gardener which last acted on a resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"id", "name", "version"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Hibernation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Hibernation contains information whether the Shoot is suspended or not.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled specifies whether the Shoot needs to be hibernated or not. If it is true, the Shoot's desired state is to be hibernated. If it is false or nil, the Shoot's desired state is to be awaken.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"schedules": {
						SchemaProps: spec.SchemaProps{
							Description: "Schedules determine the hibernation schedules.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.HibernationSchedule"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.HibernationSchedule"},
	}
}

func schema_pkg_apis_core_v1beta1_HibernationSchedule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HibernationSchedule determines the hibernation schedule of a Shoot. A Shoot will be regularly hibernated at each start time and will be woken up at each end time. Start or End can be omitted, though at least one of each has to be specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "Start is a Cron spec at which time a Shoot will be hibernated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"end": {
						SchemaProps: spec.SchemaProps{
							Description: "End is a Cron spec at which time a Shoot will be woken up.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"location": {
						SchemaProps: spec.SchemaProps{
							Description: "Location is the time location in which both start and and shall be evaluated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_HorizontalPodAutoscalerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerConfig contains horizontal pod autoscaler configuration settings for the kube-controller-manager. Note: Descriptions were taken from the Kubernetes documentation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpuInitializationPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "The period after which a ready pod transition is considered to be the first.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"downscaleDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The period since last downscale, before another downscale can be performed in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"downscaleStabilization": {
						SchemaProps: spec.SchemaProps{
							Description: "The configurable window at which the controller will choose the highest recommendation for autoscaling.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"initialReadinessDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The configurable period at which the horizontal pod autoscaler considers a Pod “not yet ready” given that it’s unready and it has  transitioned to unready during that time.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"syncPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "The period for syncing the number of pods in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"tolerance": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum change (from 1.0) in the desired-to-actual metrics ratio for the horizontal pod autoscaler to consider scaling.",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"upscaleDelay": {
						SchemaProps: spec.SchemaProps{
							Description: "The period since last upscale, before another upscale can be performed in horizontal pod autoscaler.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeAPIServerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeAPIServerConfig contains configuration settings for the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"admissionPlugins": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionPlugins contains the list of user-defined admission plugins (additional to those managed by Gardener), and, if desired, the corresponding configuration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.AdmissionPlugin"),
									},
								},
							},
						},
					},
					"apiAudiences": {
						SchemaProps: spec.SchemaProps{
							Description: "APIAudiences are the identifiers of the API. The service account token authenticator will validate that tokens used against the API are bound to at least one of these audiences. Defaults to [\"kubernetes\"].",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"auditConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "AuditConfig contains configuration settings for the audit of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditConfig"),
						},
					},
					"enableBasicAuthentication": {
						SchemaProps: spec.SchemaProps{
							Description: "EnableBasicAuthentication defines whether basic authentication should be enabled for this cluster or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"oidcConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "OIDCConfig contains configuration settings for the OIDC provider.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.OIDCConfig"),
						},
					},
					"runtimeConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "RuntimeConfig contains information about enabled or disabled APIs.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"serviceAccountConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountConfig contains configuration settings for the service account handling of the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ServiceAccountConfig"),
						},
					},
					"watchCacheSizes": {
						SchemaProps: spec.SchemaProps{
							Description: "WatchCacheSizes contains configuration of the API server's watch cache sizes. Configuring these flags might be useful for large-scale Shoot clusters with a lot of parallel update requests and a lot of watching controllers (e.g. large shooted Seed clusters). When the API server's watch cache's capacity is too small to cope with the amount of update requests and watchers for a particular resource, it might happen that controller watches are permanently stopped with `too old resource version` errors. Starting from kubernetes v1.19, the API server's watch cache size is adapted dynamically and setting the watch cache size flags will have no effect, except when setting it to 0 (which disables the watch cache).",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.WatchCacheSizes"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.AdmissionPlugin", "github.com/gardener/gardener/pkg/apis/core/v1beta1.AuditConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.OIDCConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ServiceAccountConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.WatchCacheSizes"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeControllerManagerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeControllerManagerConfig contains configuration settings for the kube-controller-manager.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"horizontalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "HorizontalPodAutoscalerConfig contains horizontal pod autoscaler configuration settings for the kube-controller-manager.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.HorizontalPodAutoscalerConfig"),
						},
					},
					"nodeCIDRMaskSize": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeCIDRMaskSize defines the mask size for node cidr in cluster (default is 24)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.HorizontalPodAutoscalerConfig"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeProxyConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeProxyConfig contains configuration settings for the kube-proxy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Mode specifies which proxy mode to use. defaults to IPTables.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubeSchedulerConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeSchedulerConfig contains configuration settings for the kube-scheduler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"kubeMaxPDVols": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeMaxPDVols allows to configure the `KUBE_MAX_PD_VOLS` environment variable for the kube-scheduler. Please find more information here: https://kubernetes.io/docs/concepts/storage/storage-limits/#custom-limits Note that using this field is considered alpha-/experimental-level and is on your own risk. You should be aware of all the side-effects and consequences when changing it.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubeletConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfig contains configuration settings for the kubelet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
					"cpuCFSQuota": {
						SchemaProps: spec.SchemaProps{
							Description: "CPUCFSQuota allows you to disable/enable CPU throttling for Pods.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"cpuManagerPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "CPUManagerPolicy allows to set alternative CPU management policies (default: none).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evictionHard": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionHard describes a set of eviction thresholds (e.g. memory.available<1Gi) that if met would trigger a Pod eviction. Default:\n  memory.available:   \"100Mi/1Gi/5%\"\n  nodefs.available:   \"5%\"\n  nodefs.inodesFree:  \"5%\"\n  imagefs.available:  \"5%\"\n  imagefs.inodesFree: \"5%\"",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEviction"),
						},
					},
					"evictionMaxPodGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionMaxPodGracePeriod describes the maximum allowed grace period (in seconds) to use when terminating pods in response to a soft eviction threshold being met. Default: 90",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionMinimumReclaim": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionMinimumReclaim configures the amount of resources below the configured eviction threshold that the kubelet attempts to reclaim whenever the kubelet observes resource pressure. Default: 0 for each resource",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionMinimumReclaim"),
						},
					},
					"evictionPressureTransitionPeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionPressureTransitionPeriod is the duration for which the kubelet has to wait before transitioning out of an eviction pressure condition. Default: 4m0s",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"evictionSoft": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionSoft describes a set of eviction thresholds (e.g. memory.available<1.5Gi) that if met over a corresponding grace period would trigger a Pod eviction. Default:\n  memory.available:   \"200Mi/1.5Gi/10%\"\n  nodefs.available:   \"10%\"\n  nodefs.inodesFree:  \"10%\"\n  imagefs.available:  \"10%\"\n  imagefs.inodesFree: \"10%\"",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEviction"),
						},
					},
					"evictionSoftGracePeriod": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionSoftGracePeriod describes a set of eviction grace periods (e.g. memory.available=1m30s) that correspond to how long a soft eviction threshold must hold before triggering a Pod eviction. Default:\n  memory.available:   1m30s\n  nodefs.available:   1m30s\n  nodefs.inodesFree:  1m30s\n  imagefs.available:  1m30s\n  imagefs.inodesFree: 1m30s",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionSoftGracePeriod"),
						},
					},
					"maxPods": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxPods is the maximum number of Pods that are allowed by the Kubelet. Default: 110",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"podPidsLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "PodPIDsLimit is the maximum number of process IDs per pod allowed by the kubelet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"imagePullProgressDeadline": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullProgressDeadline describes the time limit under which if no pulling progress is made, the image pulling will be cancelled. Default: 1m",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"failSwapOn": {
						SchemaProps: spec.SchemaProps{
							Description: "FailSwapOn makes the Kubelet fail to start if swap is enabled on the node. (default true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"kubeReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeReserved is the configuration for resources reserved for kubernetes node components (mainly kubelet and container runtime). When updating these values, be aware that cgroup resizes may not succeed on active worker nodes. Look for the NodeAllocatableEnforced event to determine if the configuration was applied. Default: cpu=80m,memory=1Gi",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigReserved"),
						},
					},
					"systemReserved": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemReserved is the configuration for resources reserved for system processes not managed by kubernetes (e.g. journald). When updating these values, be aware that cgroup resizes may not succeed on active worker nodes. Look for the NodeAllocatableEnforced event to determine if the configuration was applied.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigReserved"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEviction", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionMinimumReclaim", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigEvictionSoftGracePeriod", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfigReserved", "k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeletConfigEviction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEviction contains kubelet eviction thresholds supporting either a resource.Quantity or a percentage based value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the threshold for the free memory on the host server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the threshold for the free disk space in the imagefs filesystem (docker images and container writable layers).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the threshold for the available inodes in the imagefs filesystem.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the threshold for the free disk space in the nodefs filesystem (docker volumes, logs, etc).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the threshold for the available inodes in the nodefs filesystem.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubeletConfigEvictionMinimumReclaim(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEvictionMinimumReclaim contains configuration for the kubelet eviction minimum reclaim.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the threshold for the memory reclaim on the host server.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the threshold for the disk space reclaim in the imagefs filesystem (docker images and container writable layers).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the threshold for the inodes reclaim in the imagefs filesystem.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the threshold for the disk space reclaim in the nodefs filesystem (docker volumes, logs, etc).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the threshold for the inodes reclaim in the nodefs filesystem.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeletConfigEvictionSoftGracePeriod(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigEvictionSoftGracePeriod contains grace periods for kubelet eviction thresholds.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"memoryAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MemoryAvailable is the grace period for the MemoryAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"imageFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSAvailable is the grace period for the ImageFSAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"imageFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageFSInodesFree is the grace period for the ImageFSInodesFree eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeFSAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSAvailable is the grace period for the NodeFSAvailable eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"nodeFSInodesFree": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeFSInodesFree is the grace period for the NodeFSInodesFree eviction threshold.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_KubeletConfigReserved(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeletConfigReserved contains reserved resources for daemons",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpu": {
						SchemaProps: spec.SchemaProps{
							Description: "CPU is the reserved cpu.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Description: "Memory is the reserved memory.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"ephemeralStorage": {
						SchemaProps: spec.SchemaProps{
							Description: "EphemeralStorage is the reserved ephemeral-storage.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"pid": {
						SchemaProps: spec.SchemaProps{
							Description: "PID is the reserved process-ids. To reserve PID, the SupportNodePidsLimit feature gate must be enabled in Kubernetes versions < 1.15.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_Kubernetes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Kubernetes contains the version and configuration variables for the Shoot control plane.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowPrivilegedContainers": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowPrivilegedContainers indicates whether privileged containers are allowed in the Shoot (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"clusterAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterAutoscaler contains the configuration flags for the Kubernetes cluster autoscaler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterAutoscaler"),
						},
					},
					"kubeAPIServer": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeAPIServer contains configuration settings for the kube-apiserver.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeAPIServerConfig"),
						},
					},
					"kubeControllerManager": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeControllerManager contains configuration settings for the kube-controller-manager.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeControllerManagerConfig"),
						},
					},
					"kubeScheduler": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeScheduler contains configuration settings for the kube-scheduler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeSchedulerConfig"),
						},
					},
					"kubeProxy": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeProxy contains configuration settings for the kube-proxy.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeProxyConfig"),
						},
					},
					"kubelet": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet contains configuration settings for the kubelet.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfig"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the semantic Kubernetes version to use for the Shoot cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verticalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "VerticalPodAutoscaler contains the configuration flags for the Kubernetes vertical pod autoscaler.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.VerticalPodAutoscaler"),
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterAutoscaler", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeAPIServerConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeControllerManagerConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeProxyConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeSchedulerConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfig", "github.com/gardener/gardener/pkg/apis/core/v1beta1.VerticalPodAutoscaler"},
	}
}

func schema_pkg_apis_core_v1beta1_KubernetesConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesConfig contains common configuration fields for the control plane components.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"featureGates": {
						SchemaProps: spec.SchemaProps{
							Description: "FeatureGates contains information about enabled feature gates.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"boolean"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubernetesDashboard(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesDashboard describes configuration values for the kubernetes-dashboard addon.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"authenticationMode": {
						SchemaProps: spec.SchemaProps{
							Description: "AuthenticationMode defines the authentication mode for the kubernetes-dashboard.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubernetesInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesInfo contains the version and configuration variables for the Plant cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the semantic Kubernetes version to use for the Plant cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_KubernetesSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubernetesSettings contains constraints regarding allowed values of the 'kubernetes' block in the Shoot specification.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "version",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Versions is the list of allowed Kubernetes versions with optional expiration dates for Shoot clusters.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ExpirableVersion"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ExpirableVersion"},
	}
}

func schema_pkg_apis_core_v1beta1_LastError(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LastError indicates the last occurred error for an operation on a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the last error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"taskID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID of the task which caused this last error",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"codes": {
						SchemaProps: spec.SchemaProps{
							Description: "Well-defined error codes of the last error(s).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the error was reported",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"description"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_LastOperation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LastOperation indicates the type and the state of the last operation, along with a description message and a progress indicator.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the last operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the operation state transitioned from one to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"progress": {
						SchemaProps: spec.SchemaProps{
							Description: "The progress in percentage (0-100) of the last operation.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the last operation, one of Aborted, Processing, Succeeded, Error, Failed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the last operation, one of Create, Reconcile, Delete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"description", "lastUpdateTime", "progress", "state", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_Machine(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Machine contains information about the machine type and image.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the machine type of the worker group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Image holds information about the machine image to use for all nodes of this pool. It will default to the latest version of the first image stated in the referenced CloudProfile if no value has been provided.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootMachineImage"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootMachineImage"},
	}
}

func schema_pkg_apis_core_v1beta1_MachineControllerManagerSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineControllerManagerSettings contains configurations for different worker-pools. Eg. MachineDrainTimeout, MachineHealthTimeout.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"machineDrainTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineDrainTimeout is the period after which machine is forcefully deleted.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"machineHealthTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineHealthTimeout is the period after which machine is declared failed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"machineCreationTimeout": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineCreationTimeout is the period after which creation of the machine is declared failed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"maxEvictRetries": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxEvictRetries are the number of eviction retries on a pod after which drain is declared failed, and forceful deletion is triggered.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"nodeConditions": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeConditions are the set of conditions if set to true for the period of MachineHealthTimeout, machine will be declared failed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_MachineImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineImage defines the name and multiple versions of the machine image in any environment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "version",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Versions contains versions, expiration dates and container runtimes of the machine image",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImageVersion"),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "versions"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineImageVersion"},
	}
}

func schema_pkg_apis_core_v1beta1_MachineImageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineImageVersion is an expirable version with list of supported container runtimes and interfaces",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version identifier.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationDate": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationDate defines the time at which this version expires.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"classification": {
						SchemaProps: spec.SchemaProps{
							Description: "Classification defines the state of a version (preview, supported, deprecated)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cri": {
						SchemaProps: spec.SchemaProps{
							Description: "CRI list of supported container runtime and interfaces supported by this version",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.CRI"),
									},
								},
							},
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.CRI", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_MachineType(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineType contains certain properties of a machine type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"cpu": {
						SchemaProps: spec.SchemaProps{
							Description: "CPU is the number of CPUs for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"gpu": {
						SchemaProps: spec.SchemaProps{
							Description: "GPU is the number of GPUs for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Description: "Memory is the amount of memory for this machine type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the machine type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storage": {
						SchemaProps: spec.SchemaProps{
							Description: "Storage is the amount of storage associated with the root volume of this machine type.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineTypeStorage"),
						},
					},
					"usable": {
						SchemaProps: spec.SchemaProps{
							Description: "Usable defines if the machine type can be used for shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"cpu", "gpu", "memory", "name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineTypeStorage", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_MachineTypeStorage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MachineTypeStorage is the amount of storage associated with the root volume of this machine type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the class of the storage type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "StorageSize is the storage size.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the storage.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"class", "size", "type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_Maintenance(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Maintenance contains information about the time window for maintenance operations and which operations should be performed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"autoUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "AutoUpdate contains information about which constraints should be automatically updated.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceAutoUpdate"),
						},
					},
					"timeWindow": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeWindow contains information about the time window for maintenance operations.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceTimeWindow"),
						},
					},
					"confineSpecUpdateRollout": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfineSpecUpdateRollout prevents that changes/updates to the shoot specification will be rolled out immediately. Instead, they are rolled out during the shoot's maintenance time window. There is one exception that will trigger an immediate roll out which is changes to the Spec.Hibernation.Enabled field.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceAutoUpdate", "github.com/gardener/gardener/pkg/apis/core/v1beta1.MaintenanceTimeWindow"},
	}
}

func schema_pkg_apis_core_v1beta1_MaintenanceAutoUpdate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MaintenanceAutoUpdate contains information about which constraints should be automatically updated.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubernetesVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesVersion indicates whether the patch Kubernetes version may be automatically updated (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"machineImageVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineImageVersion indicates whether the machine image version may be automatically updated (default: true).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"kubernetesVersion", "machineImageVersion"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_MaintenanceTimeWindow(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MaintenanceTimeWindow contains information about the time window for maintenance operations.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"begin": {
						SchemaProps: spec.SchemaProps{
							Description: "Begin is the beginning of the time window in the format HHMMSS+ZONE, e.g. \"220000+0100\". If not present, a random value will be computed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"end": {
						SchemaProps: spec.SchemaProps{
							Description: "End is the end of the time window in the format HHMMSS+ZONE, e.g. \"220000+0100\". If not present, the value will be computed based on the \"Begin\" value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"begin", "end"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Monitoring(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Monitoring contains information about the monitoring configuration for the shoot.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"alerting": {
						SchemaProps: spec.SchemaProps{
							Description: "Alerting contains information about the alerting configuration for the shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Alerting"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Alerting"},
	}
}

func schema_pkg_apis_core_v1beta1_NamedResourceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedResourceReference is a named reference to a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the resource reference.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRef is a reference to a resource.",
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
				},
				Required: []string{"name", "resourceRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference"},
	}
}

func schema_pkg_apis_core_v1beta1_Networking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Networking defines networking parameters for the shoot cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type identifies the type of the networking plugin.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to network resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodes": {
						SchemaProps: spec.SchemaProps{
							Description: "Nodes is the CIDR of the entire node network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_NginxIngress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NginxIngress describes configuration values for the nginx-ingress addon.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled indicates whether the addon is enabled or not.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"loadBalancerSourceRanges": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancerSourceRanges is list of whitelist IP sources for NginxIngress",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"config": {
						SchemaProps: spec.SchemaProps{
							Description: "Config contains custom configuration for the nginx-ingress-controller configuration. See https://github.com/kubernetes/ingress-nginx/blob/master/docs/user-guide/nginx-configuration/configmap.md#configuration-options",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"externalTrafficPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "ExternalTrafficPolicy controls the `.spec.externalTrafficPolicy` value of the load balancer `Service` exposing the nginx-ingress. Defaults to `Cluster`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_OIDCConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OIDCConfig contains configuration settings for the OIDC provider. Note: Descriptions were taken from the Kubernetes documentation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the OpenID server's certificate will be verified by one of the authorities in the oidc-ca-file, otherwise the host's root CA set will be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientAuthentication": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientAuthentication can optionally contain client configuration used for kubeconfig generation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.OpenIDConnectClientAuthentication"),
						},
					},
					"clientID": {
						SchemaProps: spec.SchemaProps{
							Description: "The client ID for the OpenID Connect client, must be set if oidc-issuer-url is set.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, the name of a custom OpenID Connect claim for specifying user groups. The claim value is expected to be a string or array of strings. This flag is experimental, please see the authentication documentation for further details.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsPrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all groups will be prefixed with this value to prevent conflicts with other authentication strategies.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"issuerURL": {
						SchemaProps: spec.SchemaProps{
							Description: "The URL of the OpenID issuer, only HTTPS scheme will be accepted. If set, it will be used to verify the OIDC JSON Web Token (JWT).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requiredClaims": {
						SchemaProps: spec.SchemaProps{
							Description: "ATTENTION: Only meaningful for Kubernetes >= 1.11 key=value pairs that describes a required claim in the ID Token. If set, the claim is verified to be present in the ID Token with a matching value.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"signingAlgs": {
						SchemaProps: spec.SchemaProps{
							Description: "List of allowed JOSE asymmetric signing algorithms. JWTs with a 'alg' header value not in this list will be rejected. Values are defined by RFC 7518 https://tools.ietf.org/html/rfc7518#section-3.1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"usernameClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "The OpenID claim to use as the user name. Note that claims other than the default ('sub') is not guaranteed to be unique and immutable. This flag is experimental, please see the authentication documentation for further details. (default \"sub\")",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"usernamePrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all usernames will be prefixed with this value. If not provided, username claims other than 'email' are prefixed by the issuer URL to avoid clashes. To skip any prefixing, provide the value '-'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.OpenIDConnectClientAuthentication"},
	}
}

func schema_pkg_apis_core_v1beta1_OpenIDConnectClientAuthentication(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectClientAuthentication contains configuration for OIDC clients.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"extraConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra configuration added to kubeconfig's auth-provider. Must not be any of idp-issuer-url, client-id, client-secret, idp-certificate-authority, idp-certificate-authority-data, id-token or refresh-token",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "The client Secret for the OpenID Connect client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_Plant(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this Plant.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this Plant.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.PlantStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_PlantList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantList is a collection of Plants.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Plants.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Plant"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Plant", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_PlantSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantSpec is the specification of a Plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the Kubeconfig of the external kubernetes clusters to be added to Gardener.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"endpoints": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Endpoints is the configuration plant endpoints",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Endpoint"),
									},
								},
							},
						},
					},
				},
				Required: []string{"secretRef"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Endpoint", "k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_pkg_apis_core_v1beta1_PlantStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PlantStatus is the status of a Plant.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Plant's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Plant. It corresponds to the Plant's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"clusterInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterInfo is additional computed information about the newly added cluster (Plant)",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterInfo"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ClusterInfo", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"},
	}
}

func schema_pkg_apis_core_v1beta1_Project(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Project holds certain properties about a Gardener project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the project properties.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Project.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ProjectList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectList is a collection of Projects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Projects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Project"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Project", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ProjectMember(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectMember is a member of a project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of object being referenced. Values defined by this API group are \"User\", \"Group\", and \"ServiceAccount\". If the Authorizer does not recognized the kind value, the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup holds the API group of the referenced subject. Defaults to \"\" for ServiceAccount subjects. Defaults to \"rbac.authorization.k8s.io\" for User and Group subjects.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the object being referenced.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referenced object.  If the object kind is non-namespace, such as \"User\" or \"Group\", and this value is not empty the Authorizer should report an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"role": {
						SchemaProps: spec.SchemaProps{
							Description: "Role represents the role of this member. IMPORTANT: Be aware that this field will be removed in the `v1` version of this API in favor of the `roles` list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"roles": {
						SchemaProps: spec.SchemaProps{
							Description: "Roles represents the list of roles of this member.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"kind", "name", "role"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_ProjectSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectSpec is the specification of a Project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"createdBy": {
						SchemaProps: spec.SchemaProps{
							Description: "CreatedBy is a subject representing a user name, an email address, or any other identifier of a user who created the project.",
							Ref:         ref("k8s.io/api/rbac/v1.Subject"),
						},
					},
					"description": {
						SchemaProps: spec.SchemaProps{
							Description: "Description is a human-readable description of what the project is used for.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"owner": {
						SchemaProps: spec.SchemaProps{
							Description: "Owner is a subject representing a user name, an email address, or any other identifier of a user owning the project. IMPORTANT: Be aware that this field will be removed in the `v1` version of this API in favor of the `owner` role. The only way to change the owner will be by moving the `owner` role. In this API version the only way to change the owner is to use this field.",
							Ref:         ref("k8s.io/api/rbac/v1.Subject"),
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is a human-readable explanation of the project's purpose.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"members": {
						SchemaProps: spec.SchemaProps{
							Description: "Members is a list of subjects representing a user name, an email address, or any other identifier of a user, group, or service account that has a certain role.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectMember"),
									},
								},
							},
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the name of the namespace that has been created for the Project object. A nil value means that Gardener will determine the name of the namespace.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tolerations": {
						SchemaProps: spec.SchemaProps{
							Description: "Tolerations contains the tolerations for taints on seed clusters.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectTolerations"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectMember", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ProjectTolerations", "k8s.io/api/rbac/v1.Subject"},
	}
}

func schema_pkg_apis_core_v1beta1_ProjectStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectStatus holds the most recently observed status of the project.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this project.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is the current phase of the project.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"staleSinceTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "StaleSinceTimestamp contains the timestamp when the project was first discovered to be stale/unused.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"staleAutoDeleteTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "StaleAutoDeleteTimestamp contains the timestamp when the project will be garbage-collected/automatically deleted because it's stale/unused.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_ProjectTolerations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ProjectTolerations contains the tolerations for taints on seed clusters.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"defaults": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Defaults contains a list of tolerations that are added to the shoots in this project by default.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration"),
									},
								},
							},
						},
					},
					"whitelist": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Whitelist contains a list of tolerations that are allowed to be added to the shoots in this project. Please note that this list may only be added by users having the `spec-tolerations-whitelist` verb for project resources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration"},
	}
}

func schema_pkg_apis_core_v1beta1_Provider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Provider contains provider-specific information that are handed-over to the provider-specific extension controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"controlPlaneConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ControlPlaneConfig contains the provider-specific control plane config blob. Please look up the concrete definition in the documentation of your provider extension.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"infrastructureConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "InfrastructureConfig contains the provider-specific infrastructure config blob. Please look up the concrete definition in the documentation of your provider extension.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"workers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Workers is a list of worker groups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Worker"),
									},
								},
							},
						},
					},
				},
				Required: []string{"type", "workers"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Worker", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_Quota(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the Quota constraints.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.QuotaSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.QuotaSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_QuotaList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "QuotaList is a collection of Quotas.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Quotas.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Quota"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Quota", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_QuotaSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "QuotaSpec is the specification of a Quota.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"clusterLifetimeDays": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterLifetimeDays is the lifetime of a Shoot cluster in days before it will be terminated automatically.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						SchemaProps: spec.SchemaProps{
							Description: "Metrics is a list of resources which will be put under constraints.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "Scope is the scope of the Quota object, either 'project' or 'secret'.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"metrics", "scope"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_Region(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Region contains certain properties of a region.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is a region name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Zones is a list of availability zones in this region.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.AvailabilityZone"),
									},
								},
							},
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels is an optional set of key-value pairs that contain certain administrator-controlled labels for this region. It can be used by Gardener administrators/operators to provide additional information about a region, e.g. wrt quality, reliability, access restrictions, etc.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.AvailabilityZone"},
	}
}

func schema_pkg_apis_core_v1beta1_ResourceWatchCacheSize(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceWatchCacheSize contains configuration of the API server's watch cache size for one specific resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "APIGroup is the API group of the resource for which the watch cache size should be configured. An unset value is used to specify the legacy core API (e.g. for `secrets`).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is the name of the resource for which the watch cache size should be configured (in lowercase plural form, e.g. `secrets`).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "CacheSize specifies the watch cache size that should be configured for the specified resource.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"resource", "size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SecretBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a secret object in the same or another namespace.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"quotas": {
						SchemaProps: spec.SchemaProps{
							Description: "Quotas is a list of references to Quota objects in the same or another namespace.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ObjectReference"),
									},
								},
							},
						},
					},
				},
				Required: []string{"secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_SecretBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretBindingList is a collection of SecretBindings.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of SecretBindings.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SecretBinding"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.SecretBinding", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_Seed(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Seed represents an installation request for an external controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec contains the specification of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status contains the status of this installation.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedBackup(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedBackup contains the object store configuration for backups for shoot (currently only etcd).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider is a provider name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to BackupBucket resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a region name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the cloud provider credentials for the object store where backups should be stored. It should have enough privileges to manipulate the objects as well as buckets.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
				Required: []string{"provider", "secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedDNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedDNS contains DNS-relevant information about this seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ingressDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "IngressDomain is the domain of the Seed cluster pointing to the ingress controller endpoint. It will be used to construct ingress URLs for system applications running in Shoot clusters.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"ingressDomain"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedList is a collection of Seeds.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Seeds.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Seed"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Seed", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedNetworks(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedNetworks contains CIDRs for the pod, service and node networks of a Kubernetes cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodes": {
						SchemaProps: spec.SchemaProps{
							Description: "Nodes is the CIDR of the node network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"shootDefaults": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootDefaults contains the default networks CIDRs for shoots.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootNetworks"),
						},
					},
					"blockCIDRs": {
						SchemaProps: spec.SchemaProps{
							Description: "BlockCIDRs is a list of network addresses that should be blocked for shoot control plane components running in the seed cluster.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"pods", "services"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootNetworks"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedProvider defines the provider type and region for this Seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the name of the provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the configuration passed to Seed resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a name of a region.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "region"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSelector contains constraints for selecting seed to be usable for shoots using a profile",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchLabels": {
						SchemaProps: spec.SchemaProps{
							Description: "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is \"key\", the operator is \"In\", and the values array contains only \"value\". The requirements are ANDed.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "matchExpressions is a list of label selector requirements. The requirements are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"),
									},
								},
							},
						},
					},
					"providerTypes": {
						SchemaProps: spec.SchemaProps{
							Description: "Providers is optional and can be used by restricting seeds by their provider type. '*' can be used to enable seeds regardless of their provider type.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelectorRequirement"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettingExcessCapacityReservation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingExcessCapacityReservation controls the excess capacity reservation for shoot control planes in the seed. When enabled then this is done via PodPriority and requires the Seed cluster to have Kubernetes version 1.11 or the PodPriority feature gate as well as the scheduling.k8s.io/v1alpha1 API group enabled.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the excess capacity reservation should be enabled.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettingLoadBalancerServices(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingLoadBalancerServices controls certain settings for services of type load balancer that are created in the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a map of annotations that will be injected/merged into every load balancer service object.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettingScheduling(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingScheduling controls settings for scheduling decisions for the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"visible": {
						SchemaProps: spec.SchemaProps{
							Description: "Visible controls whether the gardener-scheduler shall consider this seed when scheduling shoots. Invisible seeds are not considered by the scheduler.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"visible"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettingShootDNS(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingShootDNS controls the shoot DNS settings for the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the DNS for shoot clusters should be enabled. When disabled then all shoots using the seed won't get any DNS providers, DNS records, and no DNS extension controller is required to be installed here. This is useful for environments where DNS is not required.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettingVerticalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettingVerticalPodAutoscaler controls certain settings for the vertical pod autoscaler components deployed in the seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled controls whether the VPA components shall be deployed into the garden namespace in the seed cluster. It is enabled by default because Gardener heavily relies on a VPA being deployed. You should only disable this if your seed cluster already has another, manually/custom managed VPA deployment.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSettings(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSettings contains certain settings for this seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"excessCapacityReservation": {
						SchemaProps: spec.SchemaProps{
							Description: "ExcessCapacityReservation controls the excess capacity reservation for shoot control planes in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingExcessCapacityReservation"),
						},
					},
					"scheduling": {
						SchemaProps: spec.SchemaProps{
							Description: "Scheduling controls settings for scheduling decisions for the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingScheduling"),
						},
					},
					"shootDNS": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootDNS controls the shoot DNS settings for the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingShootDNS"),
						},
					},
					"loadBalancerServices": {
						SchemaProps: spec.SchemaProps{
							Description: "LoadBalancerServices controls certain settings for services of type load balancer that are created in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingLoadBalancerServices"),
						},
					},
					"verticalPodAutoscaler": {
						SchemaProps: spec.SchemaProps{
							Description: "VerticalPodAutoscaler controls certain settings for the vertical pod autoscaler components deployed in the seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingVerticalPodAutoscaler"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingExcessCapacityReservation", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingLoadBalancerServices", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingScheduling", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingShootDNS", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettingVerticalPodAutoscaler"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedSpec is the specification of a Seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"backup": {
						SchemaProps: spec.SchemaProps{
							Description: "Backup holds the object store configuration for the backups of shoot (currently only etcd). If it is not specified, then there won't be any backups taken for shoots associated with this seed. If backup field is present in seed, then backups of the etcd from shoot control plane will be stored under the configured object store.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedBackup"),
						},
					},
					"dns": {
						SchemaProps: spec.SchemaProps{
							Description: "DNS contains DNS-relevant information about this seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedDNS"),
						},
					},
					"networks": {
						SchemaProps: spec.SchemaProps{
							Description: "Networks defines the pod, service and worker network of the Seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedNetworks"),
						},
					},
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider defines the provider type and region for this Seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedProvider"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is a reference to a Secret object containing the Kubeconfig and the cloud provider credentials for the account the Seed cluster has been deployed to.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"taints": {
						SchemaProps: spec.SchemaProps{
							Description: "Taints describes taints on the seed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedTaint"),
									},
								},
							},
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume contains settings for persistentvolumes created in the seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolume"),
						},
					},
					"settings": {
						SchemaProps: spec.SchemaProps{
							Description: "Settings contains certain settings for this seed cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettings"),
						},
					},
				},
				Required: []string{"dns", "networks", "provider"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedBackup", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedDNS", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedNetworks", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedProvider", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSettings", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedTaint", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolume", "k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedStatus is the status of a Seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"gardener": {
						SchemaProps: spec.SchemaProps{
							Description: "Gardener holds information about the Gardener which last acted on the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Gardener"),
						},
					},
					"kubernetesVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubernetesVersion is the Kubernetes version of the seed cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Seed's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Seed. It corresponds to the Seed's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"clusterIdentity": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterIdentity is the identity of the Seed cluster",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Gardener"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedTaint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedTaint describes a taint on a seed.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Key is the taint key to be applied to a seed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the taint value corresponding to the taint key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_SeedVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedVolume contains settings for persistentvolumes created in the seed cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"minimumSize": {
						SchemaProps: spec.SchemaProps{
							Description: "MinimumSize defines the minimum size that should be used for PVCs in the seed.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"providers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Providers is a list of storage class provisioner types for the seed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolumeProvider"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedVolumeProvider", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_pkg_apis_core_v1beta1_SeedVolumeProvider(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SeedVolumeProvider is a storage class provisioner type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose of this provider.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the storage class provisioner type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"purpose", "name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_ServiceAccountConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccountConfig is the kube-apiserver configuration for service accounts.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"issuer": {
						SchemaProps: spec.SchemaProps{
							Description: "Issuer is the identifier of the service account token issuer. The issuer will assert this identifier in \"iss\" claim of issued tokens. This value is a string or URI. Defaults to URI of the API server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"signingKeySecretName": {
						SchemaProps: spec.SchemaProps{
							Description: "SigningKeySecret is a reference to a secret that contains an optional private key of the service account token issuer. The issuer will sign issued ID tokens with this private key. Only useful if service account tokens are also issued by another external system.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_pkg_apis_core_v1beta1_Shoot(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the Shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Shoot cluster.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootSpec", "github.com/gardener/gardener/pkg/apis/core/v1beta1.ShootStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ShootList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootList is a list of Shoot objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Shoots.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Shoot"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Shoot", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_core_v1beta1_ShootMachineImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootMachineImage defines the name and the version of the shoot's machine image in any environment. Has to be defined in the respective CloudProfile.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the shoot's individual configuration passed to an extension resource.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the version of the shoot's image. If version is not provided, it will be defaulted to the latest version from the CloudProfile.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_pkg_apis_core_v1beta1_ShootNetworks(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootNetworks contains the default networks CIDRs for shoots.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "Pods is the CIDR of the pod network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"services": {
						SchemaProps: spec.SchemaProps{
							Description: "Services is the CIDR of the service network.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_ShootSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootSpec is the specification of a Shoot.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"addons": {
						SchemaProps: spec.SchemaProps{
							Description: "Addons contains information about enabled/disabled addons and their configuration.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Addons"),
						},
					},
					"cloudProfileName": {
						SchemaProps: spec.SchemaProps{
							Description: "CloudProfileName is a name of a CloudProfile object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dns": {
						SchemaProps: spec.SchemaProps{
							Description: "DNS contains information about the DNS settings of the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.DNS"),
						},
					},
					"extensions": {
						SchemaProps: spec.SchemaProps{
							Description: "Extensions contain type and provider information for Shoot extensions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Extension"),
									},
								},
							},
						},
					},
					"hibernation": {
						SchemaProps: spec.SchemaProps{
							Description: "Hibernation contains information whether the Shoot is suspended or not.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Hibernation"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains the version and configuration settings of the control plane components.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Kubernetes"),
						},
					},
					"networking": {
						SchemaProps: spec.SchemaProps{
							Description: "Networking contains information about cluster networking such as CNI Plugin type, CIDRs, ...etc.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Networking"),
						},
					},
					"maintenance": {
						SchemaProps: spec.SchemaProps{
							Description: "Maintenance contains information about the time window for maintenance operations and which operations should be performed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Maintenance"),
						},
					},
					"monitoring": {
						SchemaProps: spec.SchemaProps{
							Description: "Monitoring contains information about custom monitoring configurations for the shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Monitoring"),
						},
					},
					"provider": {
						SchemaProps: spec.SchemaProps{
							Description: "Provider contains all provider-specific and provider-relevant information.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Provider"),
						},
					},
					"purpose": {
						SchemaProps: spec.SchemaProps{
							Description: "Purpose is the purpose class for this cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"region": {
						SchemaProps: spec.SchemaProps{
							Description: "Region is a name of a region.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretBindingName": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretBindingName is the name of the a SecretBinding that has a reference to the provider secret. The credentials inside the provider secret will be used to create the shoot in the respective account.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedName": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedName is the name of the seed cluster that runs the control plane of the Shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"seedSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedSelector is an optional selector which must match a seed's labels for the shoot to be scheduled on that seed.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSelector"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources holds a list of named resource references that can be referred to in extension configs by their names.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.NamedResourceReference"),
									},
								},
							},
						},
					},
					"tolerations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "key",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Tolerations contains the tolerations for taints on seed clusters.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration"),
									},
								},
							},
						},
					},
				},
				Required: []string{"cloudProfileName", "kubernetes", "networking", "provider", "region", "secretBindingName"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Addons", "github.com/gardener/gardener/pkg/apis/core/v1beta1.DNS", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Extension", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Hibernation", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Kubernetes", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Maintenance", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Monitoring", "github.com/gardener/gardener/pkg/apis/core/v1beta1.NamedResourceReference", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Networking", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Provider", "github.com/gardener/gardener/pkg/apis/core/v1beta1.SeedSelector", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Toleration"},
	}
}

func schema_pkg_apis_core_v1beta1_ShootStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ShootStatus holds the most recently observed status of the Shoot cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions represents the latest available observations of a Shoots's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"constraints": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Constraints represents conditions of a Shoot's current state that constraint some operations on it.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition"),
									},
								},
							},
						},
					},
					"gardener": {
						SchemaProps: spec.SchemaProps{
							Description: "Gardener holds information about the Gardener which last acted on the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Gardener"),
						},
					},
					"hibernated": {
						SchemaProps: spec.SchemaProps{
							Description: "IsHibernated indicates whether the Shoot is currently hibernated.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"lastOperation": {
						SchemaProps: spec.SchemaProps{
							Description: "LastOperation holds information about the last operation on the Shoot.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation"),
						},
					},
					"lastErrors": {
						SchemaProps: spec.SchemaProps{
							Description: "LastErrors holds information about the last occurred error(s) during an operation.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError"),
									},
								},
							},
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration is the most recent generation observed for this Shoot. It corresponds to the Shoot's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"retryCycleStartTime": {
						SchemaProps: spec.SchemaProps{
							Description: "RetryCycleStartTime is the start time of the last retry cycle (used to determine how often an operation must be retried until we give up).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"seedName": {
						SchemaProps: spec.SchemaProps{
							Description: "SeedName is the name of the seed cluster that runs the control plane of the Shoot. This value is only written after a successful create/reconcile operation. It will be used when control planes are moved between Seeds.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"technicalID": {
						SchemaProps: spec.SchemaProps{
							Description: "TechnicalID is the name that is used for creating the Seed namespace, the infrastructure resources, and basically everything that is related to this particular Shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is a unique identifier for the Shoot cluster to avoid portability between Kubernetes clusters. It is used to compute unique hashes.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clusterIdentity": {
						SchemaProps: spec.SchemaProps{
							Description: "ClusterIdentity is the identity of the Shoot cluster",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"gardener", "hibernated", "technicalID", "uid"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.Condition", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Gardener", "github.com/gardener/gardener/pkg/apis/core/v1beta1.LastError", "github.com/gardener/gardener/pkg/apis/core/v1beta1.LastOperation", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_core_v1beta1_Toleration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Toleration is a toleration for a seed taint.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "Key is the toleration key to be applied to a project or shoot.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Value is the toleration value corresponding to the toleration key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_VerticalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VerticalPodAutoscaler contains the configuration flags for the Kubernetes vertical pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"enabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Enabled specifies whether the Kubernetes VPA shall be enabled for the shoot cluster.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evictAfterOOMThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictAfterOOMThreshold defines the threshold that will lead to pod eviction in case it OOMed in less than the given threshold since its start and if it has only one container (default: 10m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"evictionRateBurst": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionRateBurst defines the burst of pods that can be evicted (default: 1)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"evictionRateLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionRateLimit defines the number of pods that can be evicted per second. A rate limit set to 0 or -1 will disable the rate limiter (default: -1).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"evictionTolerance": {
						SchemaProps: spec.SchemaProps{
							Description: "EvictionTolerance defines the fraction of replica count that can be evicted for update in case more than one pod can be evicted (default: 0.5).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"recommendationMarginFraction": {
						SchemaProps: spec.SchemaProps{
							Description: "RecommendationMarginFraction is the fraction of usage added as the safety margin to the recommended request (default: 0.15).",
							Type:        []string{"number"},
							Format:      "double",
						},
					},
					"updaterInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "UpdaterInterval is the interval how often the updater should run (default: 1m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
					"recommenderInterval": {
						SchemaProps: spec.SchemaProps{
							Description: "RecommenderInterval is the interval how often metrics should be fetched (default: 1m0s).",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Duration"),
						},
					},
				},
				Required: []string{"enabled"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Duration"},
	}
}

func schema_pkg_apis_core_v1beta1_Volume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Volume contains information about the volume type, size, and encryption.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the volume to make it referencable.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeSize is the size of the volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encrypted": {
						SchemaProps: spec.SchemaProps{
							Description: "Encrypted determines if the volume should be encrypted.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"size"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_VolumeType(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VolumeType contains certain properties of a volume type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"class": {
						SchemaProps: spec.SchemaProps{
							Description: "Class is the class of the volume type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the volume type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"usable": {
						SchemaProps: spec.SchemaProps{
							Description: "Usable defines if the volume type can be used for shoot clusters.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"class", "name"},
			},
		},
	}
}

func schema_pkg_apis_core_v1beta1_WatchCacheSizes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WatchCacheSizes contains configuration of the API server's watch cache sizes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default configures the default watch cache size of the kube-apiserver (flag `--default-watch-cache-size`, defaults to 100). See: https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources configures the watch cache size of the kube-apiserver per resource (flag `--watch-cache-sizes`). See: https://kubernetes.io/docs/reference/command-line-tools-reference/kube-apiserver/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.ResourceWatchCacheSize"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.ResourceWatchCacheSize"},
	}
}

func schema_pkg_apis_core_v1beta1_Worker(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Worker is the base definition of a worker group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Description: "Annotations is a map of key/value pairs for annotations for all the `Node` objects in this worker pool.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "CABundle is a certificate bundle which will be installed onto every machine of this worker pool.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cri": {
						SchemaProps: spec.SchemaProps{
							Description: "CRI contains configurations of CRI support of every machine in the worker pool",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.CRI"),
						},
					},
					"kubernetes": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubernetes contains configuration for Kubernetes components related to this worker pool.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerKubernetes"),
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Description: "Labels is a map of key/value pairs for labels for all the `Node` objects in this worker pool.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the worker group.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"machine": {
						SchemaProps: spec.SchemaProps{
							Description: "Machine contains information about the machine type and image.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Machine"),
						},
					},
					"maximum": {
						SchemaProps: spec.SchemaProps{
							Description: "Maximum is the maximum number of VMs to create.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minimum": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum is the minimum number of VMs to create.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxSurge is maximum number of VMs that are created during an update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxUnavailable is the maximum number of VMs that can be unavailable during an update.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"providerConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ProviderConfig is the provider-specific configuration for this worker pool.",
							Ref:         ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
						},
					},
					"taints": {
						SchemaProps: spec.SchemaProps{
							Description: "Taints is a list of taints for all the `Node` objects in this worker pool.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Taint"),
									},
								},
							},
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume contains information about the volume type and size.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.Volume"),
						},
					},
					"dataVolumes": {
						SchemaProps: spec.SchemaProps{
							Description: "DataVolumes contains a list of additional worker volumes.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.DataVolume"),
									},
								},
							},
						},
					},
					"kubeletDataVolumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeletDataVolumeName contains the name of a dataVolume that should be used for storing kubelet state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"zones": {
						SchemaProps: spec.SchemaProps{
							Description: "Zones is a list of availability zones that are used to evenly distribute this worker pool. Optional as not every provider may support availability zones.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"systemComponents": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemComponents contains configuration for system components related to this worker pool",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerSystemComponents"),
						},
					},
					"machineControllerManager": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineControllerManagerSettings contains configurations for different worker-pools. Eg. MachineDrainTimeout, MachineHealthTimeout.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineControllerManagerSettings"),
						},
					},
				},
				Required: []string{"name", "machine", "maximum", "minimum"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.CRI", "github.com/gardener/gardener/pkg/apis/core/v1beta1.DataVolume", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Machine", "github.com/gardener/gardener/pkg/apis/core/v1beta1.MachineControllerManagerSettings", "github.com/gardener/gardener/pkg/apis/core/v1beta1.Volume", "github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerKubernetes", "github.com/gardener/gardener/pkg/apis/core/v1beta1.WorkerSystemComponents", "k8s.io/api/core/v1.Taint", "k8s.io/apimachinery/pkg/runtime.RawExtension", "k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_pkg_apis_core_v1beta1_WorkerKubernetes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkerKubernetes contains configuration for Kubernetes components related to this worker pool.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubelet": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet contains configuration settings for all kubelets of this worker pool.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfig"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/core/v1beta1.KubeletConfig"},
	}
}

func schema_pkg_apis_core_v1beta1_WorkerSystemComponents(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WorkerSystemComponents contains configuration for system components related to this worker pool",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allow": {
						SchemaProps: spec.SchemaProps{
							Description: "Allow determines whether the pool should be allowed to host system components or not (defaults to true)",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"allow"},
			},
		},
	}
}

func schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPreset(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterOpenIDConnectPreset is a OpenID Connect configuration that is applied to a Shoot objects cluster-wide.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is the specification of this OpenIDConnect preset.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPresetSpec"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPresetSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPresetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterOpenIDConnectPresetList is a collection of ClusterOpenIDConnectPresets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ClusterOpenIDConnectPresets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPreset"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.ClusterOpenIDConnectPreset", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_settings_v1alpha1_ClusterOpenIDConnectPresetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClusterOpenIDConnectPresetSpec contains the OpenIDConnect specification and project selector matching Shoots in Projects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"server": {
						SchemaProps: spec.SchemaProps{
							Description: "Server contains the kube-apiserver's OpenID Connect configuration. This configuration is not overwritting any existing OpenID Connect configuration already set on the Shoot object.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.KubeAPIServerOpenIDConnect"),
						},
					},
					"client": {
						SchemaProps: spec.SchemaProps{
							Description: "Client contains the configuration used for client OIDC authentication of Shoot clusters. This configuration is not overwritting any existing OpenID Connect client authentication already set on the Shoot object.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectClientAuthentication"),
						},
					},
					"shootSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootSelector decides whether to apply the configuration if the Shoot has matching labels. Use the selector only if the OIDC Preset is opt-in, because end users may skip the admission by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"weight": {
						SchemaProps: spec.SchemaProps{
							Description: "Weight associated with matching the corresponding preset, in the range 1-100. Required.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"projectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "Project decides whether to apply the configuration if the Shoot is in a specific Project mathching the label selector. Use the selector only if the OIDC Preset is opt-in, because end users may skip the admission by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"server", "weight"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.KubeAPIServerOpenIDConnect", "github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectClientAuthentication", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_pkg_apis_settings_v1alpha1_KubeAPIServerOpenIDConnect(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KubeAPIServerOpenIDConnect contains configuration settings for the OIDC provider. Note: Descriptions were taken from the Kubernetes documentation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the OpenID server's certificate will be verified by one of the authorities in the oidc-ca-file, otherwise the host's root CA set will be used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientID": {
						SchemaProps: spec.SchemaProps{
							Description: "The client ID for the OpenID Connect client. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, the name of a custom OpenID Connect claim for specifying user groups. The claim value is expected to be a string or array of strings. This field is experimental, please see the authentication documentation for further details.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groupsPrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all groups will be prefixed with this value to prevent conflicts with other authentication strategies.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"issuerURL": {
						SchemaProps: spec.SchemaProps{
							Description: "The URL of the OpenID issuer, only HTTPS scheme will be accepted. If set, it will be used to verify the OIDC JSON Web Token (JWT). Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requiredClaims": {
						SchemaProps: spec.SchemaProps{
							Description: "key=value pairs that describes a required claim in the ID Token. If set, the claim is verified to be present in the ID Token with a matching value. Only applied when the Kubernetes version of the Shoot is >= 1.11",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"signingAlgs": {
						SchemaProps: spec.SchemaProps{
							Description: "List of allowed JOSE asymmetric signing algorithms. JWTs with a 'alg' header value not in this list will be rejected. Values are defined by RFC 7518 https://tools.ietf.org/html/rfc7518#section-3.1 Defaults to [RS256]",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"usernameClaim": {
						SchemaProps: spec.SchemaProps{
							Description: "The OpenID claim to use as the user name. Note that claims other than the default ('sub') is not guaranteed to be unique and immutable. This field is experimental, please see the authentication documentation for further details. Defaults to \"sub\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"usernamePrefix": {
						SchemaProps: spec.SchemaProps{
							Description: "If provided, all usernames will be prefixed with this value. If not provided, username claims other than 'email' are prefixed by the issuer URL to avoid clashes. To skip any prefixing, provide the value '-'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"clientID", "issuerURL"},
			},
		},
	}
}

func schema_pkg_apis_settings_v1alpha1_OpenIDConnectClientAuthentication(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectClientAuthentication contains configuration for OIDC clients.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secret": {
						SchemaProps: spec.SchemaProps{
							Description: "The client Secret for the OpenID Connect client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"extraConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra configuration added to kubeconfig's auth-provider. Must not be any of idp-issuer-url, client-id, client-secret, idp-certificate-authority, idp-certificate-authority-data, id-token or refresh-token",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_pkg_apis_settings_v1alpha1_OpenIDConnectPreset(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectPreset is a OpenID Connect configuration that is applied to a Shoot in a namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is the specification of this OpenIDConnect preset.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPresetSpec"),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPresetSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_pkg_apis_settings_v1alpha1_OpenIDConnectPresetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectPresetList is a collection of OpenIDConnectPresets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list object metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of OpenIDConnectPresets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPreset"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectPreset", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_pkg_apis_settings_v1alpha1_OpenIDConnectPresetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OpenIDConnectPresetSpec contains the Shoot selector for which a specific OpenID Connect configuration is applied.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"server": {
						SchemaProps: spec.SchemaProps{
							Description: "Server contains the kube-apiserver's OpenID Connect configuration. This configuration is not overwritting any existing OpenID Connect configuration already set on the Shoot object.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.KubeAPIServerOpenIDConnect"),
						},
					},
					"client": {
						SchemaProps: spec.SchemaProps{
							Description: "Client contains the configuration used for client OIDC authentication of Shoot clusters. This configuration is not overwritting any existing OpenID Connect client authentication already set on the Shoot object.",
							Ref:         ref("github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectClientAuthentication"),
						},
					},
					"shootSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ShootSelector decides whether to apply the configuration if the Shoot has matching labels. Use the selector only if the OIDC Preset is opt-in, because end users may skip the admission by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"weight": {
						SchemaProps: spec.SchemaProps{
							Description: "Weight associated with matching the corresponding preset, in the range 1-100. Required.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"server", "weight"},
			},
		},
		Dependencies: []string{
			"github.com/gardener/gardener/pkg/apis/settings/v1alpha1.KubeAPIServerOpenIDConnect", "github.com/gardener/gardener/pkg/apis/settings/v1alpha1.OpenIDConnectClientAuthentication", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: http://kubernetes.io/docs/user-guide/identifiers#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of a metric used for autoscaling in metric system.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of metric averaged over autoscaled pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Ref:         ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current information about the autoscaler.",
							Ref:         ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerSpec", "k8s.io/api/autoscaling/v1.HorizontalPodAutoscalerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.HorizontalPodAutoscaler", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.",
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference"},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "current number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of replicas of pods managed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ObjectMetricSource"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v1.PodsMetricSource"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ResourceMetricSource"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ExternalMetricSource"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ExternalMetricSource", "k8s.io/api/autoscaling/v1.ObjectMetricSource", "k8s.io/api/autoscaling/v1.PodsMetricSource", "k8s.io/api/autoscaling/v1.ResourceMetricSource"},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ObjectMetricStatus"),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref("k8s.io/api/autoscaling/v1.PodsMetricStatus"),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ResourceMetricStatus"),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref("k8s.io/api/autoscaling/v1.ExternalMetricStatus"),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ExternalMetricStatus", "k8s.io/api/autoscaling/v1.ObjectMetricStatus", "k8s.io/api/autoscaling/v1.PodsMetricStatus", "k8s.io/api/autoscaling/v1.ResourceMetricStatus"},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "targetValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Ref:         ref("k8s.io/api/autoscaling/v1.CrossVersionObjectReference"),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity).",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"target", "metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.CrossVersionObjectReference", "k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "targetAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
				},
				Required: []string{"metricName", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"name", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_autoscaling_v1_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ScaleSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Ref:         ref("k8s.io/api/autoscaling/v1.ScaleStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/autoscaling/v1.ScaleSpec", "k8s.io/api/autoscaling/v1.ScaleStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: http://kubernetes.io/docs/user-guide/labels#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_AWSElasticBlockStoreVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Persistent Disk resource in AWS.\n\nAn AWS EBS disk must exist before mounting to a container. The disk must also be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as read/write once. AWS EBS volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify \"true\" to force and set the ReadOnly property in VolumeMounts to \"true\". If omitted, the default is \"false\". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Affinity(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Affinity is a group of affinity scheduling rules.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodeAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes node affinity scheduling rules for the pod.",
							Ref:         ref("k8s.io/api/core/v1.NodeAffinity"),
						},
					},
					"podAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).",
							Ref:         ref("k8s.io/api/core/v1.PodAffinity"),
						},
					},
					"podAntiAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).",
							Ref:         ref("k8s.io/api/core/v1.PodAntiAffinity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeAffinity", "k8s.io/api/core/v1.PodAffinity", "k8s.io/api/core/v1.PodAntiAffinity"},
	}
}

func schema_k8sio_api_core_v1_AttachedVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AttachedVolume describes a volume attached to a node",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the attached volume",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"devicePath": {
						SchemaProps: spec.SchemaProps{
							Description: "DevicePath represents the device path where the volume should be available",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "devicePath"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_AvoidPods(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AvoidPods describes pods that should avoid this node. This is the value for a Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and will eventually become a field of NodeStatus.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"preferAvoidPods": {
						SchemaProps: spec.SchemaProps{
							Description: "Bounded-sized list of signatures of pods that should avoid this node, sorted in timestamp order from oldest to newest. Size of the slice is unspecified.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PreferAvoidPodsEntry"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PreferAvoidPodsEntry"},
	}
}

func schema_k8sio_api_core_v1_AzureDiskVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"diskName": {
						SchemaProps: spec.SchemaProps{
							Description: "The Name of the data disk in the blob storage",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"diskURI": {
						SchemaProps: spec.SchemaProps{
							Description: "The URI the data disk in the blob storage",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"cachingMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Host Caching mode: None, Read Only, Read Write.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"diskName", "diskURI"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_AzureFilePersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "the name of secret that contains Azure Storage Account Name and Key",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"shareName": {
						SchemaProps: spec.SchemaProps{
							Description: "Share Name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "the namespace of the secret that contains Azure Storage Account Name and Key default is the same as the Pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"secretName", "shareName"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_AzureFileVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "the name of secret that contains Azure Storage Account Name and Key",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"shareName": {
						SchemaProps: spec.SchemaProps{
							Description: "Share Name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"secretName", "shareName"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Binding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Binding ties one object to another; for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "The target object that you want to bind to the standard object.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"target"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_CSIPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents storage that is managed by an external CSI volume driver (Beta feature)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"driver": {
						SchemaProps: spec.SchemaProps{
							Description: "Driver is the name of the driver to use for this volume. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeHandle": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeHandle is the unique volume name returned by the CSI volume plugin’s CreateVolume to refer to the volume on all subsequent calls. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to false (read/write).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "Attributes of the volume to publish.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"controllerPublishSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ControllerPublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerPublishVolume and ControllerUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"nodeStageSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeStageSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodeStageVolume and NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"nodePublishSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"controllerExpandSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ControllerExpandSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI ControllerExpandVolume call. This is an alpha field and requires enabling ExpandCSIVolumes feature gate. This field is optional, and may be empty if no secret is required. If the secret object contains more than one secret, all secrets are passed.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
				Required: []string{"driver", "volumeHandle"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_CSIVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a source location of a volume to mount, managed by an external CSI driver",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"driver": {
						SchemaProps: spec.SchemaProps{
							Description: "Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies a read-only configuration for the volume. Defaults to false (read/write).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Ex. \"ext4\", \"xfs\", \"ntfs\". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"nodePublishSecretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
				},
				Required: []string{"driver"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_Capabilities(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adds and removes POSIX capabilities from running containers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"add": {
						SchemaProps: spec.SchemaProps{
							Description: "Added capabilities",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"drop": {
						SchemaProps: spec.SchemaProps{
							Description: "Removed capabilities",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_CephFSPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Used as the mounted root, rather than the full Ceph tree, default is /",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretFile": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_CephFSVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Used as the mounted root, rather than the full Ceph tree, default is /",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretFile": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_CinderPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: points to a secret object containing parameters used to connect to OpenStack.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_CinderVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: points to a secret object containing parameters used to connect to OpenStack.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_ClientIPConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ClientIPConfig represents the configurations of Client IP based session affinity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "timeoutSeconds specifies the seconds of ClientIP type session sticky time. The value must be >0 && <=86400(for 1 day) if ServiceAffinity == \"ClientIP\". Default value is 10800(for 3 hours).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ComponentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Information about the condition of a component.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of condition for a component. Valid value: \"Healthy\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition for a component. Valid values for \"Healthy\": \"True\", \"False\", or \"Unknown\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message about the condition for a component. For example, information about a health check.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Condition error code for a component. For example, a health check error code.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ComponentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ComponentStatus (and ComponentStatusList) holds the cluster validation info.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of component conditions observed",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ComponentCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ComponentCondition", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ComponentStatusList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Status of all the conditions for the component as a list of ComponentStatus objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ComponentStatus objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ComponentStatus"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ComponentStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_ConfigMap(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMap holds configuration data for pods to consume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"immutable": {
						SchemaProps: spec.SchemaProps{
							Description: "Immutable, if set to true, ensures that data stored in the ConfigMap cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil. This is an alpha field enabled by ImmutableEphemeralVolumes feature gate.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the configuration data. Each key must consist of alphanumeric characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the BinaryData field. The keys stored in Data must not overlap with the keys in the BinaryData field, this is enforced during validation process.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"binaryData": {
						SchemaProps: spec.SchemaProps{
							Description: "BinaryData contains the binary data. Each key must consist of alphanumeric characters, '-', '_' or '.'. BinaryData can contain byte sequences that are not in the UTF-8 range. The keys stored in BinaryData must not overlap with the ones in the Data field, this is enforced during validation process. Using this field will require 1.10+ apiserver and kubelet.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "byte",
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ConfigMapEnvSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapEnvSource selects a ConfigMap to populate the environment variables with.\n\nThe contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the ConfigMap must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ConfigMapKeySelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Selects a key from a ConfigMap.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key to select.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the ConfigMap or its key must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ConfigMapList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapList is a resource containing a list of ConfigMap objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ConfigMaps.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ConfigMap"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ConfigMap", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_ConfigMapNodeConfigSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the metadata.namespace of the referenced ConfigMap. This field is required in all cases.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the metadata.name of the referenced ConfigMap. This field is required in all cases.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID is the metadata.UID of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap. This field is forbidden in Node.Spec, and required in Node.Status.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeletConfigKey": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure This field is required in all cases.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"namespace", "name", "kubeletConfigKey"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ConfigMapProjection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a ConfigMap into a projected volume.\n\nThe contents of the target ConfigMap's Data field will be presented in a projected volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. Note that this is identical to a configmap volume source without the default mode.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the ConfigMap or its keys must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.KeyToPath"},
	}
}

func schema_k8sio_api_core_v1_ConfigMapVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a ConfigMap into a volume.\n\nThe contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths. ConfigMap volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the ConfigMap or its keys must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.KeyToPath"},
	}
}

func schema_k8sio_api_core_v1_Container(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A single application container that you want to run within a pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"workingDir": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"containerPort",
									"protocol",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "containerPort",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerPort"),
									},
								},
							},
						},
					},
					"envFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvFromSource"),
									},
								},
							},
						},
					},
					"env": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of environment variables to set in the container. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvVar"),
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
							Ref:         ref("k8s.io/api/core/v1.ResourceRequirements"),
						},
					},
					"volumeMounts": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "mountPath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Pod volumes to mount into the container's filesystem. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeMount"),
									},
								},
							},
						},
					},
					"volumeDevices": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "devicePath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeDevices is the list of block devices to be used by the container.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeDevice"),
									},
								},
							},
						},
					},
					"livenessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"startupProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. This is a beta feature enabled by the StartupProbe feature flag. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"lifecycle": {
						SchemaProps: spec.SchemaProps{
							Description: "Actions that the management system should take in response to container lifecycle events. Cannot be updated.",
							Ref:         ref("k8s.io/api/core/v1.Lifecycle"),
						},
					},
					"terminationMessagePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationMessagePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/",
							Ref:         ref("k8s.io/api/core/v1.SecurityContext"),
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdinOnce": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerPort", "k8s.io/api/core/v1.EnvFromSource", "k8s.io/api/core/v1.EnvVar", "k8s.io/api/core/v1.Lifecycle", "k8s.io/api/core/v1.Probe", "k8s.io/api/core/v1.ResourceRequirements", "k8s.io/api/core/v1.SecurityContext", "k8s.io/api/core/v1.VolumeDevice", "k8s.io/api/core/v1.VolumeMount"},
	}
}

func schema_k8sio_api_core_v1_ContainerImage(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describe a container image",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"names": {
						SchemaProps: spec.SchemaProps{
							Description: "Names by which this image is known. e.g. [\"k8s.gcr.io/hyperkube:v1.0.7\", \"dockerhub.io/google_containers/hyperkube:v1.0.7\"]",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"sizeBytes": {
						SchemaProps: spec.SchemaProps{
							Description: "The size of the image in bytes.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"names"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ContainerPort(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerPort represents a network port in a single container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostPort": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"containerPort": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "Protocol for port. Must be UDP, TCP, or SCTP. Defaults to \"TCP\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostIP": {
						SchemaProps: spec.SchemaProps{
							Description: "What host IP to bind the external port to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"containerPort"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ContainerState(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerState holds a possible state of container. Only one of its members may be specified. If none of them is specified, the default one is ContainerStateWaiting.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"waiting": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a waiting container",
							Ref:         ref("k8s.io/api/core/v1.ContainerStateWaiting"),
						},
					},
					"running": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a running container",
							Ref:         ref("k8s.io/api/core/v1.ContainerStateRunning"),
						},
					},
					"terminated": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about a terminated container",
							Ref:         ref("k8s.io/api/core/v1.ContainerStateTerminated"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerStateRunning", "k8s.io/api/core/v1.ContainerStateTerminated", "k8s.io/api/core/v1.ContainerStateWaiting"},
	}
}

func schema_k8sio_api_core_v1_ContainerStateRunning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateRunning is a running state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the container was last (re-)started",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_ContainerStateTerminated(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateTerminated is a terminated state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"exitCode": {
						SchemaProps: spec.SchemaProps{
							Description: "Exit status from the last termination of the container",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"signal": {
						SchemaProps: spec.SchemaProps{
							Description: "Signal from the last termination of the container",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason from the last termination of the container",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message regarding the last termination of the container",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"startedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which previous execution of the container started",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"finishedAt": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which the container last terminated",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's ID in the format 'docker://<container_id>'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"exitCode"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_ContainerStateWaiting(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStateWaiting is a waiting state of a container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason the container is not yet running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message regarding why the container is not yet running.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ContainerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerStatus contains details for the current status of this container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about the container's current condition.",
							Ref:         ref("k8s.io/api/core/v1.ContainerState"),
						},
					},
					"lastState": {
						SchemaProps: spec.SchemaProps{
							Description: "Details about the container's last termination condition.",
							Ref:         ref("k8s.io/api/core/v1.ContainerState"),
						},
					},
					"ready": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies whether the container has passed its readiness probe.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"restartCount": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imageID": {
						SchemaProps: spec.SchemaProps{
							Description: "ImageID of the container's image.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerID": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's ID in the format 'docker://<container_id>'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"started": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "ready", "restartCount", "image", "imageID"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerState"},
	}
}

func schema_k8sio_api_core_v1_DaemonEndpoint(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonEndpoint contains information about a single Daemon endpoint.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"Port": {
						SchemaProps: spec.SchemaProps{
							Description: "Port number of the given endpoint.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"Port"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_DownwardAPIProjection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents downward API info for projecting into a projected volume. Note that this is identical to a downwardAPI volume source without the default mode.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of DownwardAPIVolume file",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.DownwardAPIVolumeFile"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.DownwardAPIVolumeFile"},
	}
}

func schema_k8sio_api_core_v1_DownwardAPIVolumeFile(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DownwardAPIVolumeFile represents information to create the file containing the pod field",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.",
							Ref:         ref("k8s.io/api/core/v1.ObjectFieldSelector"),
						},
					},
					"resourceFieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.",
							Ref:         ref("k8s.io/api/core/v1.ResourceFieldSelector"),
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"path"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectFieldSelector", "k8s.io/api/core/v1.ResourceFieldSelector"},
	}
}

func schema_k8sio_api_core_v1_DownwardAPIVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of downward API volume file",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.DownwardAPIVolumeFile"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.DownwardAPIVolumeFile"},
	}
}

func schema_k8sio_api_core_v1_EmptyDirVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an empty directory for a pod. Empty directory volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"medium": {
						SchemaProps: spec.SchemaProps{
							Description: "What type of storage medium should back this directory. The default is \"\" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"sizeLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_EndpointAddress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointAddress is a tuple that describes single IP address.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "The Hostname of this endpoint",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Reference to object providing the endpoint.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
				Required: []string{"ip"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_k8sio_api_core_v1_EndpointPort(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointPort is a tuple that describes a single port.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of this port.  This must match the 'name' field in the corresponding ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "The port number of the endpoint.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Description: "The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"appProtocol": {
						SchemaProps: spec.SchemaProps{
							Description: "The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol. Field can be enabled with ServiceAppProtocol feature gate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"port"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_EndpointSubset(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:\n  {\n    Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n    Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n  }\nThe resulting set of endpoints can be viewed as:\n    a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],\n    b: [ 10.10.1.1:309, 10.10.2.2:309 ]",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"addresses": {
						SchemaProps: spec.SchemaProps{
							Description: "IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EndpointAddress"),
									},
								},
							},
						},
					},
					"notReadyAddresses": {
						SchemaProps: spec.SchemaProps{
							Description: "IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EndpointAddress"),
									},
								},
							},
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Port numbers available on the related IP addresses.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EndpointPort"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.EndpointAddress", "k8s.io/api/core/v1.EndpointPort"},
	}
}

func schema_k8sio_api_core_v1_Endpoints(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Endpoints is a collection of endpoints that implement the actual service. Example:\n  Name: \"mysvc\",\n  Subsets: [\n    {\n      Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],\n      Ports: [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]\n    },\n    {\n      Addresses: [{\"ip\": \"10.10.3.3\"}],\n      Ports: [{\"name\": \"a\", \"port\": 93}, {\"name\": \"b\", \"port\": 76}]\n    },\n ]",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"subsets": {
						SchemaProps: spec.SchemaProps{
							Description: "The set of all endpoints is the union of all subsets. Addresses are placed into subsets according to the IPs they share. A single address with multiple ports, some of which are ready and some of which are not (because they come from different containers) will result in the address being displayed in different subsets for the different ports. No address will appear in both Addresses and NotReadyAddresses in the same subset. Sets of addresses and ports that comprise a service.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EndpointSubset"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.EndpointSubset", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_EndpointsList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EndpointsList is a list of endpoints.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of endpoints.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Endpoints"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Endpoints", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_EnvFromSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnvFromSource represents the source of a set of ConfigMaps",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"prefix": {
						SchemaProps: spec.SchemaProps{
							Description: "An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"configMapRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The ConfigMap to select from",
							Ref:         ref("k8s.io/api/core/v1.ConfigMapEnvSource"),
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The Secret to select from",
							Ref:         ref("k8s.io/api/core/v1.SecretEnvSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ConfigMapEnvSource", "k8s.io/api/core/v1.SecretEnvSource"},
	}
}

func schema_k8sio_api_core_v1_EnvVar(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnvVar represents an environment variable present in a Container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the environment variable. Must be a C_IDENTIFIER.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "Source for the environment variable's value. Cannot be used if value is not empty.",
							Ref:         ref("k8s.io/api/core/v1.EnvVarSource"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.EnvVarSource"},
	}
}

func schema_k8sio_api_core_v1_EnvVarSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EnvVarSource represents a source for the value of an EnvVar.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a field of the pod: supports metadata.name, metadata.namespace, metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.",
							Ref:         ref("k8s.io/api/core/v1.ObjectFieldSelector"),
						},
					},
					"resourceFieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.",
							Ref:         ref("k8s.io/api/core/v1.ResourceFieldSelector"),
						},
					},
					"configMapKeyRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a key of a ConfigMap.",
							Ref:         ref("k8s.io/api/core/v1.ConfigMapKeySelector"),
						},
					},
					"secretKeyRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Selects a key of a secret in the pod's namespace",
							Ref:         ref("k8s.io/api/core/v1.SecretKeySelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ConfigMapKeySelector", "k8s.io/api/core/v1.ObjectFieldSelector", "k8s.io/api/core/v1.ResourceFieldSelector", "k8s.io/api/core/v1.SecretKeySelector"},
	}
}

func schema_k8sio_api_core_v1_EphemeralContainer(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An EphemeralContainer is a container that may be added temporarily to an existing pod for user-initiated activities such as debugging. Ephemeral containers have no resource or scheduling guarantees, and they will not be restarted when they exit or when a pod is removed or restarted. If an ephemeral container causes a pod to exceed its resource allocation, the pod may be evicted. Ephemeral containers may not be added by directly updating the pod spec. They must be added via the pod's ephemeralcontainers subresource, and they will appear in the pod spec once added. This is an alpha feature enabled by the EphemeralContainers feature flag.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"workingDir": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports are not allowed for ephemeral containers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerPort"),
									},
								},
							},
						},
					},
					"envFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvFromSource"),
									},
								},
							},
						},
					},
					"env": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of environment variables to set in the container. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvVar"),
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.",
							Ref:         ref("k8s.io/api/core/v1.ResourceRequirements"),
						},
					},
					"volumeMounts": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "mountPath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Pod volumes to mount into the container's filesystem. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeMount"),
									},
								},
							},
						},
					},
					"volumeDevices": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "devicePath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeDevices is the list of block devices to be used by the container.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeDevice"),
									},
								},
							},
						},
					},
					"livenessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"startupProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"lifecycle": {
						SchemaProps: spec.SchemaProps{
							Description: "Lifecycle is not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Lifecycle"),
						},
					},
					"terminationMessagePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationMessagePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "SecurityContext is not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.SecurityContext"),
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdinOnce": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"targetContainerName": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerPort", "k8s.io/api/core/v1.EnvFromSource", "k8s.io/api/core/v1.EnvVar", "k8s.io/api/core/v1.Lifecycle", "k8s.io/api/core/v1.Probe", "k8s.io/api/core/v1.ResourceRequirements", "k8s.io/api/core/v1.SecurityContext", "k8s.io/api/core/v1.VolumeDevice", "k8s.io/api/core/v1.VolumeMount"},
	}
}

func schema_k8sio_api_core_v1_EphemeralContainerCommon(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EphemeralContainerCommon is a copy of all fields in Container to be inlined in EphemeralContainer. This separate type allows easy conversion from EphemeralContainer to Container and allows separate documentation for the fields of EphemeralContainer. When a new field is added to Container it must be added here as well.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"args": {
						SchemaProps: spec.SchemaProps{
							Description: "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"workingDir": {
						SchemaProps: spec.SchemaProps{
							Description: "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "Ports are not allowed for ephemeral containers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerPort"),
									},
								},
							},
						},
					},
					"envFrom": {
						SchemaProps: spec.SchemaProps{
							Description: "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvFromSource"),
									},
								},
							},
						},
					},
					"env": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of environment variables to set in the container. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EnvVar"),
									},
								},
							},
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.",
							Ref:         ref("k8s.io/api/core/v1.ResourceRequirements"),
						},
					},
					"volumeMounts": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "mountPath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Pod volumes to mount into the container's filesystem. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeMount"),
									},
								},
							},
						},
					},
					"volumeDevices": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "devicePath",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeDevices is the list of block devices to be used by the container.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeDevice"),
									},
								},
							},
						},
					},
					"livenessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"readinessProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"startupProbe": {
						SchemaProps: spec.SchemaProps{
							Description: "Probes are not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Probe"),
						},
					},
					"lifecycle": {
						SchemaProps: spec.SchemaProps{
							Description: "Lifecycle is not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.Lifecycle"),
						},
					},
					"terminationMessagePath": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationMessagePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"imagePullPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "SecurityContext is not allowed for ephemeral containers.",
							Ref:         ref("k8s.io/api/core/v1.SecurityContext"),
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdinOnce": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerPort", "k8s.io/api/core/v1.EnvFromSource", "k8s.io/api/core/v1.EnvVar", "k8s.io/api/core/v1.Lifecycle", "k8s.io/api/core/v1.Probe", "k8s.io/api/core/v1.ResourceRequirements", "k8s.io/api/core/v1.SecurityContext", "k8s.io/api/core/v1.VolumeDevice", "k8s.io/api/core/v1.VolumeMount"},
	}
}

func schema_k8sio_api_core_v1_EphemeralContainers(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A list of ephemeral containers used with the Pod ephemeralcontainers subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"ephemeralContainers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "A list of ephemeral containers associated with this pod. New ephemeral containers may be appended to this list, but existing ephemeral containers may not be removed or modified.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EphemeralContainer"),
									},
								},
							},
						},
					},
				},
				Required: []string{"ephemeralContainers"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.EphemeralContainer", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_Event(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Event is a report of an event somewhere in the cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"involvedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "The object that this event is about.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "This should be a short, machine understandable string that gives the reason for the transition into the object's current status.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable description of the status of this operation.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"source": {
						SchemaProps: spec.SchemaProps{
							Description: "The component reporting this event. Should be a short machine understandable string.",
							Ref:         ref("k8s.io/api/core/v1.EventSource"),
						},
					},
					"firstTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "The time at which the most recent occurrence of this event was recorded.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"count": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of times this event has occurred.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of this event (Normal, Warning), new types could be added in the future",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"eventTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Time when this Event was first observed.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"series": {
						SchemaProps: spec.SchemaProps{
							Description: "Data about the Event series this event represents or nil if it's a singleton Event.",
							Ref:         ref("k8s.io/api/core/v1.EventSeries"),
						},
					},
					"action": {
						SchemaProps: spec.SchemaProps{
							Description: "What action was taken/failed regarding to the Regarding object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"related": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional secondary object for more complex actions.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"reportingComponent": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reportingInstance": {
						SchemaProps: spec.SchemaProps{
							Description: "ID of the controller instance, e.g. `kubelet-xyzf`.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"metadata", "involvedObject"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.EventSeries", "k8s.io/api/core/v1.EventSource", "k8s.io/api/core/v1.ObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_EventList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventList is a list of events.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of events",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Event"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Event", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_EventSeries(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventSeries contain information on series of events, i.e. thing that was/is happening continuously for some time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"count": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of occurrences in this series up to the last heartbeat time",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"lastObservedTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Time of the last occurrence observed",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"),
						},
					},
					"state": {
						SchemaProps: spec.SchemaProps{
							Description: "State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.MicroTime"},
	}
}

func schema_k8sio_api_core_v1_EventSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "EventSource contains information for an event.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"component": {
						SchemaProps: spec.SchemaProps{
							Description: "Component from which the event is generated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Node name on which the event is generated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ExecAction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExecAction describes a \"run in container\" action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_FCVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"targetWWNs": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: FC target worldwide names (WWNs)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: FC target lun number",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"wwids": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_FlexPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"driver": {
						SchemaProps: spec.SchemaProps{
							Description: "Driver is the name of the driver to use for this volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"options": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Extra command options if any.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"driver"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_FlexVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"driver": {
						SchemaProps: spec.SchemaProps{
							Description: "Driver is the name of the driver to use for this volume.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"options": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: Extra command options if any.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"driver"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_FlockerVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"datasetName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"datasetUUID": {
						SchemaProps: spec.SchemaProps{
							Description: "UUID of the dataset. This is unique identifier of a Flocker dataset",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_GCEPersistentDiskVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Persistent Disk resource in Google Compute Engine.\n\nA GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pdName": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"pdName"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_GitRepoVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.\n\nDEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"repository": {
						SchemaProps: spec.SchemaProps{
							Description: "Repository URL",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Commit hash for the specified revision.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"directory": {
						SchemaProps: spec.SchemaProps{
							Description: "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"repository"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_GlusterfsPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"endpoints": {
						SchemaProps: spec.SchemaProps{
							Description: "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"endpointsNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"endpoints", "path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_GlusterfsVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"endpoints": {
						SchemaProps: spec.SchemaProps{
							Description: "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"endpoints", "path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_HTTPGetAction(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPGetAction describes an action based on HTTP Get requests.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path to access on the HTTP server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.",
							Ref:         ref("k8s.io/apimachinery/pkg/util/intstr.IntOrString"),
						},
					},
					"host": {
						SchemaProps: spec.SchemaProps{
							Description: "Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"scheme": {
						SchemaProps: spec.SchemaProps{
							Description: "Scheme to use for connecting to the host. Defaults to HTTP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"httpHeaders": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom headers to set in the request. HTTP allows repeated headers.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.HTTPHeader"),
									},
								},
							},
						},
					},
				},
				Required: []string{"port"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.HTTPHeader", "k8s.io/apimachinery/pkg/util/intstr.IntOrString"},
	}
}

func schema_k8sio_api_core_v1_HTTPHeader(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HTTPHeader describes a custom header to be used in HTTP probes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field name",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "The header field value",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "value"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Handler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Handler defines a specific action that should be taken",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         ref("k8s.io/api/core/v1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         ref("k8s.io/api/core/v1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         ref("k8s.io/api/core/v1.TCPSocketAction"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ExecAction", "k8s.io/api/core/v1.HTTPGetAction", "k8s.io/api/core/v1.TCPSocketAction"},
	}
}

func schema_k8sio_api_core_v1_HostAlias(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address of the host file entry.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostnames": {
						SchemaProps: spec.SchemaProps{
							Description: "Hostnames for the above IP address.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_HostPathVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type for HostPath Volume Defaults to \"\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ISCSIPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"targetPortal": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iqn": {
						SchemaProps: spec.SchemaProps{
							Description: "Target iSCSI Qualified Name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Lun number.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iscsiInterface": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"portals": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"chapAuthDiscovery": {
						SchemaProps: spec.SchemaProps{
							Description: "whether support iSCSI Discovery CHAP authentication",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"chapAuthSession": {
						SchemaProps: spec.SchemaProps{
							Description: "whether support iSCSI Session CHAP authentication",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "CHAP Secret for iSCSI target and initiator authentication",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"initiatorName": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"targetPortal", "iqn", "lun"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_ISCSIVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"targetPortal": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"iqn": {
						SchemaProps: spec.SchemaProps{
							Description: "Target iSCSI Qualified Name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lun": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Lun number.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"iscsiInterface": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"portals": {
						SchemaProps: spec.SchemaProps{
							Description: "iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"chapAuthDiscovery": {
						SchemaProps: spec.SchemaProps{
							Description: "whether support iSCSI Discovery CHAP authentication",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"chapAuthSession": {
						SchemaProps: spec.SchemaProps{
							Description: "whether support iSCSI Session CHAP authentication",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "CHAP Secret for iSCSI target and initiator authentication",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"initiatorName": {
						SchemaProps: spec.SchemaProps{
							Description: "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"targetPortal", "iqn", "lun"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_KeyToPath(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Maps a string key to a path within a volume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key to project.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"mode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"key", "path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Lifecycle(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"postStart": {
						SchemaProps: spec.SchemaProps{
							Description: "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
							Ref:         ref("k8s.io/api/core/v1.Handler"),
						},
					},
					"preStop": {
						SchemaProps: spec.SchemaProps{
							Description: "PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks",
							Ref:         ref("k8s.io/api/core/v1.Handler"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Handler"},
	}
}

func schema_k8sio_api_core_v1_LimitRange(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRange sets resource usage limits for each kind of resource in a Namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the limits enforced. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.LimitRangeSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LimitRangeSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_LimitRangeItem(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeItem defines a min/max usage limit for any resource that matches on kind.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of resource that this limit applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"max": {
						SchemaProps: spec.SchemaProps{
							Description: "Max usage constraints on this kind by resource name.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"min": {
						SchemaProps: spec.SchemaProps{
							Description: "Min usage constraints on this kind by resource name.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"default": {
						SchemaProps: spec.SchemaProps{
							Description: "Default resource requirement limit value by resource name if resource limit is omitted.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"defaultRequest": {
						SchemaProps: spec.SchemaProps{
							Description: "DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"maxLimitRequestRatio": {
						SchemaProps: spec.SchemaProps{
							Description: "MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_LimitRangeList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeList is a list of LimitRange items.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of LimitRange objects. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.LimitRange"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LimitRange", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_LimitRangeSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LimitRangeSpec defines a min/max usage limit for resources that match on kind.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"limits": {
						SchemaProps: spec.SchemaProps{
							Description: "Limits is the list of LimitRangeItem objects that are enforced.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.LimitRangeItem"),
									},
								},
							},
						},
					},
				},
				Required: []string{"limits"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LimitRangeItem"},
	}
}

func schema_k8sio_api_core_v1_List(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "List holds a list of objects, which may not be known by the server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of objects",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/runtime.RawExtension"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta", "k8s.io/apimachinery/pkg/runtime.RawExtension"},
	}
}

func schema_k8sio_api_core_v1_LoadBalancerIngress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_LoadBalancerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LoadBalancerStatus represents the status of a load-balancer.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ingress": {
						SchemaProps: spec.SchemaProps{
							Description: "Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.LoadBalancerIngress"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LoadBalancerIngress"},
	}
}

func schema_k8sio_api_core_v1_LocalObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_LocalVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Local represents directly-attached storage with node affinity (Beta feature)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "The full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default value is to auto-select a fileystem if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_NFSVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"server": {
						SchemaProps: spec.SchemaProps{
							Description: "Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"server", "path"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Namespace(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Namespace provides a scope for Names. Use of multiple namespaces is optional.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of the Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.NamespaceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status describes the current status of a Namespace. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.NamespaceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NamespaceSpec", "k8s.io/api/core/v1.NamespaceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_NamespaceCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceCondition contains details about state of namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of namespace controller condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_NamespaceList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceList is a list of Namespaces.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Namespace"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Namespace", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_NamespaceSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceSpec describes the attributes on a Namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"finalizers": {
						SchemaProps: spec.SchemaProps{
							Description: "Finalizers is an opaque list of values that must be empty to permanently remove object from storage. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_NamespaceStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamespaceStatus is information about the current status of a Namespace.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase is the current lifecycle phase of the namespace. More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a namespace's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NamespaceCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NamespaceCondition"},
	}
}

func schema_k8sio_api_core_v1_Node(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Node is a worker node in Kubernetes. Each node will have a unique identifier in the cache (i.e. in etcd).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of a node. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.NodeSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the node. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.NodeStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSpec", "k8s.io/api/core/v1.NodeStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_NodeAddress(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeAddress contains information for the node's address.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Node address type, one of Hostname, ExternalIP or InternalIP.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"address": {
						SchemaProps: spec.SchemaProps{
							Description: "The node address.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "address"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_NodeAffinity(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Node affinity is a group of node affinity scheduling rules.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.",
							Ref:         ref("k8s.io/api/core/v1.NodeSelector"),
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PreferredSchedulingTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSelector", "k8s.io/api/core/v1.PreferredSchedulingTerm"},
	}
}

func schema_k8sio_api_core_v1_NodeCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeCondition contains condition information for a node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of node condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastHeartbeatTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time we got an update on a given condition.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transit from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_NodeConfigSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"configMap": {
						SchemaProps: spec.SchemaProps{
							Description: "ConfigMap is a reference to a Node's ConfigMap",
							Ref:         ref("k8s.io/api/core/v1.ConfigMapNodeConfigSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ConfigMapNodeConfigSource"},
	}
}

func schema_k8sio_api_core_v1_NodeConfigStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"assigned": {
						SchemaProps: spec.SchemaProps{
							Description: "Assigned reports the checkpointed config the node will try to use. When Node.Spec.ConfigSource is updated, the node checkpoints the associated config payload to local disk, along with a record indicating intended config. The node refers to this record to choose its config checkpoint, and reports this record in Assigned. Assigned only updates in the status after the record has been checkpointed to disk. When the Kubelet is restarted, it tries to make the Assigned config the Active config by loading and validating the checkpointed payload identified by Assigned.",
							Ref:         ref("k8s.io/api/core/v1.NodeConfigSource"),
						},
					},
					"active": {
						SchemaProps: spec.SchemaProps{
							Description: "Active reports the checkpointed config the node is actively using. Active will represent either the current version of the Assigned config, or the current LastKnownGood config, depending on whether attempting to use the Assigned config results in an error.",
							Ref:         ref("k8s.io/api/core/v1.NodeConfigSource"),
						},
					},
					"lastKnownGood": {
						SchemaProps: spec.SchemaProps{
							Description: "LastKnownGood reports the checkpointed config the node will fall back to when it encounters an error attempting to use the Assigned config. The Assigned config becomes the LastKnownGood config when the node determines that the Assigned config is stable and correct. This is currently implemented as a 10-minute soak period starting when the local record of Assigned config is updated. If the Assigned config is Active at the end of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil, because the local default config is always assumed good. You should not make assumptions about the node's method of determining config stability and correctness, as this may change or become configurable in the future.",
							Ref:         ref("k8s.io/api/core/v1.NodeConfigSource"),
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error describes any problems reconciling the Spec.ConfigSource to the Active config. Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting to load or validate the Assigned config, etc. Errors may occur at different points while syncing config. Earlier errors (e.g. download or checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error by fixing the config assigned in Spec.ConfigSource. You can find additional information for debugging by searching the error message in the Kubelet log. Error is a human-readable description of the error state; machines can check whether or not Error is empty, but should not rely on the stability of the Error text across Kubelet versions.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeConfigSource"},
	}
}

func schema_k8sio_api_core_v1_NodeDaemonEndpoints(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeDaemonEndpoints lists ports opened by daemons running on the Node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kubeletEndpoint": {
						SchemaProps: spec.SchemaProps{
							Description: "Endpoint on which Kubelet is listening.",
							Ref:         ref("k8s.io/api/core/v1.DaemonEndpoint"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.DaemonEndpoint"},
	}
}

func schema_k8sio_api_core_v1_NodeList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeList is the whole list of all Nodes which have been registered with master.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of nodes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Node"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Node", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_NodeProxyOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeProxyOptions is the query options to a Node's proxy call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path to use for the current proxy request to node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_NodeResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeResources is an object for conveying resource information about a node. see http://releases.k8s.io/HEAD/docs/design/resources.md for more details.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"Capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Capacity represents the available resources of a node",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
				},
				Required: []string{"Capacity"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_NodeSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A node selector represents the union of the results of one or more label queries over a set of nodes; that is, it represents the OR of the selectors represented by the node selector terms.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nodeSelectorTerms": {
						SchemaProps: spec.SchemaProps{
							Description: "Required. A list of node selector terms. The terms are ORed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NodeSelectorTerm"),
									},
								},
							},
						},
					},
				},
				Required: []string{"nodeSelectorTerms"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSelectorTerm"},
	}
}

func schema_k8sio_api_core_v1_NodeSelectorRequirement(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The label key that the selector applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"values": {
						SchemaProps: spec.SchemaProps{
							Description: "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"key", "operator"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_NodeSelectorTerm(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of node selector requirements by node's labels.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NodeSelectorRequirement"),
									},
								},
							},
						},
					},
					"matchFields": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of node selector requirements by node's fields.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NodeSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSelectorRequirement"},
	}
}

func schema_k8sio_api_core_v1_NodeSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSpec describes the attributes that a node is created with.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"podCIDR": {
						SchemaProps: spec.SchemaProps{
							Description: "PodCIDR represents the pod IP range assigned to the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podCIDRs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"providerID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"unschedulable": {
						SchemaProps: spec.SchemaProps{
							Description: "Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"taints": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the node's taints.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Taint"),
									},
								},
							},
						},
					},
					"configSource": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the source to get node configuration from The DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this field",
							Ref:         ref("k8s.io/api/core/v1.NodeConfigSource"),
						},
					},
					"externalID": {
						SchemaProps: spec.SchemaProps{
							Description: "Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeConfigSource", "k8s.io/api/core/v1.Taint"},
	}
}

func schema_k8sio_api_core_v1_NodeStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeStatus is information about the current status of a node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"allocatable": {
						SchemaProps: spec.SchemaProps{
							Description: "Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NodeCondition"),
									},
								},
							},
						},
					},
					"addresses": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.NodeAddress"),
									},
								},
							},
						},
					},
					"daemonEndpoints": {
						SchemaProps: spec.SchemaProps{
							Description: "Endpoints of daemons running on the Node.",
							Ref:         ref("k8s.io/api/core/v1.NodeDaemonEndpoints"),
						},
					},
					"nodeInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "Set of ids/uuids to uniquely identify the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#info",
							Ref:         ref("k8s.io/api/core/v1.NodeSystemInfo"),
						},
					},
					"images": {
						SchemaProps: spec.SchemaProps{
							Description: "List of container images on this node",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerImage"),
									},
								},
							},
						},
					},
					"volumesInUse": {
						SchemaProps: spec.SchemaProps{
							Description: "List of attachable volumes in use (mounted) by the node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"volumesAttached": {
						SchemaProps: spec.SchemaProps{
							Description: "List of volumes that are attached to the node.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.AttachedVolume"),
									},
								},
							},
						},
					},
					"config": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the config assigned to the node via the dynamic Kubelet config feature.",
							Ref:         ref("k8s.io/api/core/v1.NodeConfigStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.AttachedVolume", "k8s.io/api/core/v1.ContainerImage", "k8s.io/api/core/v1.NodeAddress", "k8s.io/api/core/v1.NodeCondition", "k8s.io/api/core/v1.NodeConfigStatus", "k8s.io/api/core/v1.NodeDaemonEndpoints", "k8s.io/api/core/v1.NodeSystemInfo", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_NodeSystemInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NodeSystemInfo is a set of ids/uuids to uniquely identify the node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"machineID": {
						SchemaProps: spec.SchemaProps{
							Description: "MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"systemUUID": {
						SchemaProps: spec.SchemaProps{
							Description: "SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"bootID": {
						SchemaProps: spec.SchemaProps{
							Description: "Boot ID reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kernelVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"osImage": {
						SchemaProps: spec.SchemaProps{
							Description: "OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"containerRuntimeVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeletVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Kubelet Version reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kubeProxyVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "KubeProxy Version reported by the node.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operatingSystem": {
						SchemaProps: spec.SchemaProps{
							Description: "The Operating System reported by the node",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"architecture": {
						SchemaProps: spec.SchemaProps{
							Description: "The Architecture reported by the node",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"machineID", "systemUUID", "bootID", "kernelVersion", "osImage", "containerRuntimeVersion", "kubeletVersion", "kubeProxyVersion", "operatingSystem", "architecture"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ObjectFieldSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectFieldSelector selects an APIVersioned field of an object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Version of the schema the FieldPath is written in terms of, defaults to \"v1\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldPath": {
						SchemaProps: spec.SchemaProps{
							Description: "Path of the field to select in the specified API version.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldPath"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectReference contains enough information to let you inspect or modify the referred object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resourceVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "Specific resourceVersion to which this reference is made, if any. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldPath": {
						SchemaProps: spec.SchemaProps{
							Description: "If referring to a piece of an object instead of an entire object, this string should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2]. For example, if the object reference is to a container within a pod, this would take on a value like: \"spec.containers{name}\" (where \"name\" refers to the name of the container that triggered the event) or if no container name is specified \"spec.containers[2]\" (container with index 2 in this pod). This syntax is chosen only to have some well-defined way of referencing a part of an object.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PersistentVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolume (PV) is a storage resource provisioned by an administrator. It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines a specification of a persistent volume owned by the cluster. Provisioned by an administrator. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status represents the current information/status for the persistent volume. Populated by the system. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeSpec", "k8s.io/api/core/v1.PersistentVolumeStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaim(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaim is a user's request for and claim to a persistent volume",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired characteristics of a volume requested by a pod author. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeClaimSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status represents the current information/status of a persistent volume claim. Read-only. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Ref:         ref("k8s.io/api/core/v1.PersistentVolumeClaimStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaimSpec", "k8s.io/api/core/v1.PersistentVolumeClaimStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaimCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimCondition contails details about state of pvc",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time we probed the condition.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports \"ResizeStarted\" that means the underlying persistent volume is being resized.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human-readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaimList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimList is a list of PersistentVolumeClaim items.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of persistent volume claims. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PersistentVolumeClaim"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaim", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaimSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over volumes to consider for binding.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"resources": {
						SchemaProps: spec.SchemaProps{
							Description: "Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources",
							Ref:         ref("k8s.io/api/core/v1.ResourceRequirements"),
						},
					},
					"volumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeName is the binding reference to the PersistentVolume backing this claim.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storageClassName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeMode": {
						SchemaProps: spec.SchemaProps{
							Description: "volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dataSource": {
						SchemaProps: spec.SchemaProps{
							Description: "This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot - Beta) * An existing PVC (PersistentVolumeClaim) * An existing custom resource/object that implements data population (Alpha) In order to use VolumeSnapshot object types, the appropriate feature gate must be enabled (VolumeSnapshotDataSource or AnyVolumeDataSource) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the specified data source is not supported, the volume will not be created and the failure will be reported as an event. In the future, we plan to support more data source types and the behavior of the provisioner may change.",
							Ref:         ref("k8s.io/api/core/v1.TypedLocalObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ResourceRequirements", "k8s.io/api/core/v1.TypedLocalObjectReference", "k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaimStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimStatus is the current status of a persistent volume claim.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase represents the current phase of PersistentVolumeClaim.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents the actual resources of the underlying volume.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PersistentVolumeClaimCondition"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolumeClaimCondition", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeClaimVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"claimName": {
						SchemaProps: spec.SchemaProps{
							Description: "ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Will force the ReadOnly setting in VolumeMounts. Default false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"claimName"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeList is a list of PersistentVolume items.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of persistent volumes. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PersistentVolume"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PersistentVolume", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeSource is similar to VolumeSource but meant for the administrator who creates PVs. Exactly one of its members must be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Ref:         ref("k8s.io/api/core/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
							Ref:         ref("k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
							Ref:         ref("k8s.io/api/core/v1.HostPathVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md",
							Ref:         ref("k8s.io/api/core/v1.GlusterfsPersistentVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
							Ref:         ref("k8s.io/api/core/v1.NFSVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md",
							Ref:         ref("k8s.io/api/core/v1.RBDPersistentVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
							Ref:         ref("k8s.io/api/core/v1.ISCSIPersistentVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Ref:         ref("k8s.io/api/core/v1.CinderPersistentVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         ref("k8s.io/api/core/v1.CephFSPersistentVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         ref("k8s.io/api/core/v1.FCVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
							Ref:         ref("k8s.io/api/core/v1.FlockerVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.",
							Ref:         ref("k8s.io/api/core/v1.FlexPersistentVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         ref("k8s.io/api/core/v1.AzureFilePersistentVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         ref("k8s.io/api/core/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         ref("k8s.io/api/core/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
					"portworxVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.PortworxVolumeSource"),
						},
					},
					"scaleIO": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
							Ref:         ref("k8s.io/api/core/v1.ScaleIOPersistentVolumeSource"),
						},
					},
					"local": {
						SchemaProps: spec.SchemaProps{
							Description: "Local represents directly-attached storage with node affinity",
							Ref:         ref("k8s.io/api/core/v1.LocalVolumeSource"),
						},
					},
					"storageos": {
						SchemaProps: spec.SchemaProps{
							Description: "StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md",
							Ref:         ref("k8s.io/api/core/v1.StorageOSPersistentVolumeSource"),
						},
					},
					"csi": {
						SchemaProps: spec.SchemaProps{
							Description: "CSI represents storage that is handled by an external CSI driver (Beta feature).",
							Ref:         ref("k8s.io/api/core/v1.CSIPersistentVolumeSource"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/api/core/v1.AzureDiskVolumeSource", "k8s.io/api/core/v1.AzureFilePersistentVolumeSource", "k8s.io/api/core/v1.CSIPersistentVolumeSource", "k8s.io/api/core/v1.CephFSPersistentVolumeSource", "k8s.io/api/core/v1.CinderPersistentVolumeSource", "k8s.io/api/core/v1.FCVolumeSource", "k8s.io/api/core/v1.FlexPersistentVolumeSource", "k8s.io/api/core/v1.FlockerVolumeSource", "k8s.io/api/core/v1.GCEPersistentDiskVolumeSource", "k8s.io/api/core/v1.GlusterfsPersistentVolumeSource", "k8s.io/api/core/v1.HostPathVolumeSource", "k8s.io/api/core/v1.ISCSIPersistentVolumeSource", "k8s.io/api/core/v1.LocalVolumeSource", "k8s.io/api/core/v1.NFSVolumeSource", "k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource", "k8s.io/api/core/v1.PortworxVolumeSource", "k8s.io/api/core/v1.QuobyteVolumeSource", "k8s.io/api/core/v1.RBDPersistentVolumeSource", "k8s.io/api/core/v1.ScaleIOPersistentVolumeSource", "k8s.io/api/core/v1.StorageOSPersistentVolumeSource", "k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeSpec is the specification of a persistent volume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"capacity": {
						SchemaProps: spec.SchemaProps{
							Description: "A description of the persistent volume's resources and capacity. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"gcePersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk",
							Ref:         ref("k8s.io/api/core/v1.GCEPersistentDiskVolumeSource"),
						},
					},
					"awsElasticBlockStore": {
						SchemaProps: spec.SchemaProps{
							Description: "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore",
							Ref:         ref("k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource"),
						},
					},
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Description: "HostPath represents a directory on the host. Provisioned by a developer or tester. This is useful for single-node development and testing only! On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath",
							Ref:         ref("k8s.io/api/core/v1.HostPathVolumeSource"),
						},
					},
					"glusterfs": {
						SchemaProps: spec.SchemaProps{
							Description: "Glusterfs represents a Glusterfs volume that is attached to a host and exposed to the pod. Provisioned by an admin. More info: https://examples.k8s.io/volumes/glusterfs/README.md",
							Ref:         ref("k8s.io/api/core/v1.GlusterfsPersistentVolumeSource"),
						},
					},
					"nfs": {
						SchemaProps: spec.SchemaProps{
							Description: "NFS represents an NFS mount on the host. Provisioned by an admin. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs",
							Ref:         ref("k8s.io/api/core/v1.NFSVolumeSource"),
						},
					},
					"rbd": {
						SchemaProps: spec.SchemaProps{
							Description: "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md",
							Ref:         ref("k8s.io/api/core/v1.RBDPersistentVolumeSource"),
						},
					},
					"iscsi": {
						SchemaProps: spec.SchemaProps{
							Description: "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. Provisioned by an admin.",
							Ref:         ref("k8s.io/api/core/v1.ISCSIPersistentVolumeSource"),
						},
					},
					"cinder": {
						SchemaProps: spec.SchemaProps{
							Description: "Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md",
							Ref:         ref("k8s.io/api/core/v1.CinderPersistentVolumeSource"),
						},
					},
					"cephfs": {
						SchemaProps: spec.SchemaProps{
							Description: "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime",
							Ref:         ref("k8s.io/api/core/v1.CephFSPersistentVolumeSource"),
						},
					},
					"fc": {
						SchemaProps: spec.SchemaProps{
							Description: "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.",
							Ref:         ref("k8s.io/api/core/v1.FCVolumeSource"),
						},
					},
					"flocker": {
						SchemaProps: spec.SchemaProps{
							Description: "Flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running",
							Ref:         ref("k8s.io/api/core/v1.FlockerVolumeSource"),
						},
					},
					"flexVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.",
							Ref:         ref("k8s.io/api/core/v1.FlexPersistentVolumeSource"),
						},
					},
					"azureFile": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.",
							Ref:         ref("k8s.io/api/core/v1.AzureFilePersistentVolumeSource"),
						},
					},
					"vsphereVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource"),
						},
					},
					"quobyte": {
						SchemaProps: spec.SchemaProps{
							Description: "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime",
							Ref:         ref("k8s.io/api/core/v1.QuobyteVolumeSource"),
						},
					},
					"azureDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.",
							Ref:         ref("k8s.io/api/core/v1.AzureDiskVolumeSource"),
						},
					},
					"photonPersistentDisk": {
						SchemaProps: spec.SchemaProps{
							Description: "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource"),
						},
					},
					"portworxVolume": {
						SchemaProps: spec.SchemaProps{
							Description: "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine",
							Ref:         ref("k8s.io/api/core/v1.PortworxVolumeSource"),
						},
					},
					"scaleIO": {
						SchemaProps: spec.SchemaProps{
							Description: "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.",
							Ref:         ref("k8s.io/api/core/v1.ScaleIOPersistentVolumeSource"),
						},
					},
					"local": {
						SchemaProps: spec.SchemaProps{
							Description: "Local represents directly-attached storage with node affinity",
							Ref:         ref("k8s.io/api/core/v1.LocalVolumeSource"),
						},
					},
					"storageos": {
						SchemaProps: spec.SchemaProps{
							Description: "StorageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod More info: https://examples.k8s.io/volumes/storageos/README.md",
							Ref:         ref("k8s.io/api/core/v1.StorageOSPersistentVolumeSource"),
						},
					},
					"csi": {
						SchemaProps: spec.SchemaProps{
							Description: "CSI represents storage that is handled by an external CSI driver (Beta feature).",
							Ref:         ref("k8s.io/api/core/v1.CSIPersistentVolumeSource"),
						},
					},
					"accessModes": {
						SchemaProps: spec.SchemaProps{
							Description: "AccessModes contains all ways the volume can be mounted. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"claimRef": {
						SchemaProps: spec.SchemaProps{
							Description: "ClaimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is the authoritative bind between PV and PVC. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
					"persistentVolumeReclaimPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "What happens to a persistent volume when released from its claim. Valid options are Retain (default for manually created PersistentVolumes), Delete (default for dynamically provisioned PersistentVolumes), and Recycle (deprecated). Recycle must be supported by the volume plugin underlying this PersistentVolume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storageClassName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of StorageClass to which this persistent volume belongs. Empty value means that this volume does not belong to any StorageClass.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"mountOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of mount options, e.g. [\"ro\", \"soft\"]. Not validated - mount will simply fail if one is invalid. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"volumeMode": {
						SchemaProps: spec.SchemaProps{
							Description: "volumeMode defines if a volume is intended to be used with a formatted filesystem or to remain in raw block state. Value of Filesystem is implied when not included in spec.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeAffinity": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeAffinity defines constraints that limit what nodes this volume can be accessed from. This field influences the scheduling of pods that use this volume.",
							Ref:         ref("k8s.io/api/core/v1.VolumeNodeAffinity"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.AWSElasticBlockStoreVolumeSource", "k8s.io/api/core/v1.AzureDiskVolumeSource", "k8s.io/api/core/v1.AzureFilePersistentVolumeSource", "k8s.io/api/core/v1.CSIPersistentVolumeSource", "k8s.io/api/core/v1.CephFSPersistentVolumeSource", "k8s.io/api/core/v1.CinderPersistentVolumeSource", "k8s.io/api/core/v1.FCVolumeSource", "k8s.io/api/core/v1.FlexPersistentVolumeSource", "k8s.io/api/core/v1.FlockerVolumeSource", "k8s.io/api/core/v1.GCEPersistentDiskVolumeSource", "k8s.io/api/core/v1.GlusterfsPersistentVolumeSource", "k8s.io/api/core/v1.HostPathVolumeSource", "k8s.io/api/core/v1.ISCSIPersistentVolumeSource", "k8s.io/api/core/v1.LocalVolumeSource", "k8s.io/api/core/v1.NFSVolumeSource", "k8s.io/api/core/v1.ObjectReference", "k8s.io/api/core/v1.PhotonPersistentDiskVolumeSource", "k8s.io/api/core/v1.PortworxVolumeSource", "k8s.io/api/core/v1.QuobyteVolumeSource", "k8s.io/api/core/v1.RBDPersistentVolumeSource", "k8s.io/api/core/v1.ScaleIOPersistentVolumeSource", "k8s.io/api/core/v1.StorageOSPersistentVolumeSource", "k8s.io/api/core/v1.VolumeNodeAffinity", "k8s.io/api/core/v1.VsphereVirtualDiskVolumeSource", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_PersistentVolumeStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PersistentVolumeStatus is the current status of a persistent volume.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "Phase indicates if a volume is available, bound to a claim, or released by a claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human-readable message indicating details about why the volume is in this state.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is a brief CamelCase string that describes any failure and is meant for machine parsing and tidy display in the CLI.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PhotonPersistentDiskVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Photon Controller persistent disk resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"pdID": {
						SchemaProps: spec.SchemaProps{
							Description: "ID that identifies Photon Controller persistent disk",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"pdID"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Pod(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod is a collection of containers that can run on a host. This resource is created by clients and scheduled onto hosts.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.PodSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.PodStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodSpec", "k8s.io/api/core/v1.PodStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PodAffinity(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod affinity is a group of inter pod affinity scheduling rules.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodAffinityTerm"),
									},
								},
							},
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.WeightedPodAffinityTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodAffinityTerm", "k8s.io/api/core/v1.WeightedPodAffinityTerm"},
	}
}

func schema_k8sio_api_core_v1_PodAffinityTerm(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over a set of resources, in this case pods.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"),
						},
					},
					"namespaces": {
						SchemaProps: spec.SchemaProps{
							Description: "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"topologyKey": {
						SchemaProps: spec.SchemaProps{
							Description: "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"topologyKey"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.LabelSelector"},
	}
}

func schema_k8sio_api_core_v1_PodAntiAffinity(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pod anti affinity is a group of inter pod anti affinity scheduling rules.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"requiredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodAffinityTerm"),
									},
								},
							},
						},
					},
					"preferredDuringSchedulingIgnoredDuringExecution": {
						SchemaProps: spec.SchemaProps{
							Description: "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.WeightedPodAffinityTerm"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodAffinityTerm", "k8s.io/api/core/v1.WeightedPodAffinityTerm"},
	}
}

func schema_k8sio_api_core_v1_PodAttachOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodAttachOptions is the query options to a Pod's remote attach call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Stdin if true, redirects the standard input stream of the pod for this call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdout": {
						SchemaProps: spec.SchemaProps{
							Description: "Stdout if true indicates that stdout is to be redirected for the attach call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stderr": {
						SchemaProps: spec.SchemaProps{
							Description: "Stderr if true indicates that stderr is to be redirected for the attach call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "TTY if true indicates that a tty will be allocated for the attach call. This is passed through the container runtime so the tty is allocated on the worker node by the container runtime. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "The container in which to execute the command. Defaults to only container if there is only one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodCondition contains details for the current condition of this pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is the type of the condition. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the status of the condition. Can be True, False, Unknown. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastProbeTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time we probed the condition.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Unique, one-word, CamelCase reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human-readable message indicating details about last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_PodDNSConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"nameservers": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"searches": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"options": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodDNSConfigOption"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodDNSConfigOption"},
	}
}

func schema_k8sio_api_core_v1_PodDNSConfigOption(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodDNSConfigOption defines DNS resolver options of a pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodExecOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodExecOptions is the query options to a Pod's remote exec call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"stdin": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard input stream of the pod for this call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stdout": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard output stream of the pod for this call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"stderr": {
						SchemaProps: spec.SchemaProps{
							Description: "Redirect the standard error stream of the pod for this call. Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tty": {
						SchemaProps: spec.SchemaProps{
							Description: "TTY if true indicates that a tty will be allocated for the exec call. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "Container in which to execute the command. Defaults to only container if there is only one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"command": {
						SchemaProps: spec.SchemaProps{
							Description: "Command is the remote command to execute. argv array. Not executed within a shell.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"command"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodIP(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "IP address information for entries in the (plural) PodIPs field. Each entry includes:\n   IP: An IP address allocated to the pod. Routable at least within the cluster.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ip": {
						SchemaProps: spec.SchemaProps{
							Description: "ip is an IP address (IPv4 or IPv6) assigned to the pod",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodList is a list of Pods.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of pods. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Pod"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Pod", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_PodLogOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodLogOptions is the query options for a Pod's logs REST call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "The container for which to stream logs. Defaults to only container if there is one container in the pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"follow": {
						SchemaProps: spec.SchemaProps{
							Description: "Follow the log stream of the pod. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"previous": {
						SchemaProps: spec.SchemaProps{
							Description: "Return previous terminated container logs. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"sinceSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "A relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"sinceTime": {
						SchemaProps: spec.SchemaProps{
							Description: "An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"timestamps": {
						SchemaProps: spec.SchemaProps{
							Description: "If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"tailLines": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"limitBytes": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"insecureSkipTLSVerifyBackend": {
						SchemaProps: spec.SchemaProps{
							Description: "insecureSkipTLSVerifyBackend indicates that the apiserver should not confirm the validity of the serving certificate of the backend it is connecting to.  This will make the HTTPS connection between the apiserver and the backend insecure. This means the apiserver cannot verify the log data it is receiving came from the real kubelet.  If the kubelet is configured to verify the apiserver's TLS credentials, it does not mean the connection to the real kubelet is vulnerable to a man in the middle attack (e.g. an attacker could not intercept the actual log data coming from the real kubelet).",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_PodPortForwardOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodPortForwardOptions is the query options to a Pod's port forward call when using WebSockets. The `port` query parameter must specify the port or ports (comma separated) to forward over. Port forwarding over SPDY does not use these options. It requires the port to be passed in the `port` header as part of request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ports to forward Required when using WebSockets",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"integer"},
										Format: "int32",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodProxyOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodProxyOptions is the query options to a Pod's proxy call.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path to use for the current proxy request to pod.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodReadinessGate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodReadinessGate contains the reference to a pod condition",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"conditionType": {
						SchemaProps: spec.SchemaProps{
							Description: "ConditionType refers to a condition in the pod's condition list with matching type.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"conditionType"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PodSecurityContext(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
							Ref:         ref("k8s.io/api/core/v1.SELinuxOptions"),
						},
					},
					"windowsOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Ref:         ref("k8s.io/api/core/v1.WindowsSecurityContextOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsNonRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"supplementalGroups": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"integer"},
										Format: "int64",
									},
								},
							},
						},
					},
					"fsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"sysctls": {
						SchemaProps: spec.SchemaProps{
							Description: "Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Sysctl"),
									},
								},
							},
						},
					},
					"fsGroupChangePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are \"OnRootMismatch\" and \"Always\". If not specified defaults to \"Always\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SELinuxOptions", "k8s.io/api/core/v1.Sysctl", "k8s.io/api/core/v1.WindowsSecurityContextOptions"},
	}
}

func schema_k8sio_api_core_v1_PodSignature(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes the class of pods that should avoid this node. Exactly one field should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"podController": {
						SchemaProps: spec.SchemaProps{
							Description: "Reference to controller whose pods should avoid this node.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.OwnerReference"},
	}
}

func schema_k8sio_api_core_v1_PodSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodSpec is a description of a pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge,retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Volume"),
									},
								},
							},
						},
					},
					"initContainers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Container"),
									},
								},
							},
						},
					},
					"containers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Container"),
									},
								},
							},
						},
					},
					"ephemeralContainers": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.EphemeralContainer"),
									},
								},
							},
						},
					},
					"restartPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"terminationGracePeriodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"activeDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"dnsPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "Set DNS policy for the pod. Defaults to \"ClusterFirst\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nodeSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"serviceAccountName": {
						SchemaProps: spec.SchemaProps{
							Description: "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"serviceAccount": {
						SchemaProps: spec.SchemaProps{
							Description: "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"automountServiceAccountToken": {
						SchemaProps: spec.SchemaProps{
							Description: "AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"nodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostNetwork": {
						SchemaProps: spec.SchemaProps{
							Description: "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostPID": {
						SchemaProps: spec.SchemaProps{
							Description: "Use the host's pid namespace. Optional: Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"hostIPC": {
						SchemaProps: spec.SchemaProps{
							Description: "Use the host's ipc namespace. Optional: Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"shareProcessNamespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"securityContext": {
						SchemaProps: spec.SchemaProps{
							Description: "SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.",
							Ref:         ref("k8s.io/api/core/v1.PodSecurityContext"),
						},
					},
					"imagePullSecrets": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.LocalObjectReference"),
									},
								},
							},
						},
					},
					"hostname": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subdomain": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the fully qualified Pod hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the pod will not have a domainname at all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"affinity": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the pod's scheduling constraints",
							Ref:         ref("k8s.io/api/core/v1.Affinity"),
						},
					},
					"schedulerName": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tolerations": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the pod's tolerations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Toleration"),
									},
								},
							},
						},
					},
					"hostAliases": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "ip",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.HostAlias"),
									},
								},
							},
						},
					},
					"priorityClassName": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, indicates the pod's priority. \"system-node-critical\" and \"system-cluster-critical\" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"priority": {
						SchemaProps: spec.SchemaProps{
							Description: "The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"dnsConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the DNS parameters of a pod. Parameters specified here will be merged to the generated DNS configuration based on DNSPolicy.",
							Ref:         ref("k8s.io/api/core/v1.PodDNSConfig"),
						},
					},
					"readinessGates": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \"True\" More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodReadinessGate"),
									},
								},
							},
						},
					},
					"runtimeClassName": {
						SchemaProps: spec.SchemaProps{
							Description: "RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \"legacy\" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"enableServiceLinks": {
						SchemaProps: spec.SchemaProps{
							Description: "EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"preemptionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is alpha-level and is only honored by servers that enable the NonPreemptingPriority feature.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"overhead": {
						SchemaProps: spec.SchemaProps{
							Description: "Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"topologySpreadConstraints": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"topologyKey",
									"whenUnsatisfiable",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "topologyKey",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. This field is only honored by clusters that enable the EvenPodsSpread feature. All topologySpreadConstraints are ANDed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.TopologySpreadConstraint"),
									},
								},
							},
						},
					},
				},
				Required: []string{"containers"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Affinity", "k8s.io/api/core/v1.Container", "k8s.io/api/core/v1.EphemeralContainer", "k8s.io/api/core/v1.HostAlias", "k8s.io/api/core/v1.LocalObjectReference", "k8s.io/api/core/v1.PodDNSConfig", "k8s.io/api/core/v1.PodReadinessGate", "k8s.io/api/core/v1.PodSecurityContext", "k8s.io/api/core/v1.Toleration", "k8s.io/api/core/v1.TopologySpreadConstraint", "k8s.io/api/core/v1.Volume", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_PodStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"phase": {
						SchemaProps: spec.SchemaProps{
							Description: "The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:\n\nPending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.\n\nMore info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodCondition"),
									},
								},
							},
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about why the pod is in this condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"nominatedNodeName": {
						SchemaProps: spec.SchemaProps{
							Description: "nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"hostIP": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address of the host to which the pod is assigned. Empty if not yet scheduled.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podIP": {
						SchemaProps: spec.SchemaProps{
							Description: "IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podIPs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "ip",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodIP"),
									},
								},
							},
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Description: "RFC 3339 date and time at which the object was acknowledged by the Kubelet. This is before the Kubelet pulled the container image(s) for the pod.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"initContainerStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerStatus"),
									},
								},
							},
						},
					},
					"containerStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerStatus"),
									},
								},
							},
						},
					},
					"qosClass": {
						SchemaProps: spec.SchemaProps{
							Description: "The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ephemeralContainerStatuses": {
						SchemaProps: spec.SchemaProps{
							Description: "Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ContainerStatus"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ContainerStatus", "k8s.io/api/core/v1.PodCondition", "k8s.io/api/core/v1.PodIP", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_PodStatusResult(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the pod. This data may not be up to date. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.PodStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PodTemplate(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplate describes a template for creating copies of a predefined pod.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template defines the pods that will be created from this pod template. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodTemplateSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PodTemplateList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplateList is a list of PodTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of pod templates",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.PodTemplate"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodTemplate", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_PodTemplateSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodTemplateSpec describes the data a pod should have when created from a template",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.PodSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodSpec", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_PortworxVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortworxVolumeSource represents a Portworx volume resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumeID": {
						SchemaProps: spec.SchemaProps{
							Description: "VolumeID uniquely identifies a Portworx volume",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\". Implicitly inferred to be \"ext4\" if unspecified.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"volumeID"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_PreferAvoidPodsEntry(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes a class of pods that should avoid this node.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"podSignature": {
						SchemaProps: spec.SchemaProps{
							Description: "The class of pods.",
							Ref:         ref("k8s.io/api/core/v1.PodSignature"),
						},
					},
					"evictionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Time at which this entry was added to the list.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "(brief) reason why this entry was added to the list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Human readable message indicating why this entry was added to the list.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"podSignature"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodSignature", "k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_PreferredSchedulingTerm(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"weight": {
						SchemaProps: spec.SchemaProps{
							Description: "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"preference": {
						SchemaProps: spec.SchemaProps{
							Description: "A node selector term, associated with the corresponding weight.",
							Ref:         ref("k8s.io/api/core/v1.NodeSelectorTerm"),
						},
					},
				},
				Required: []string{"weight", "preference"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.NodeSelectorTerm"},
	}
}

func schema_k8sio_api_core_v1_Probe(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"exec": {
						SchemaProps: spec.SchemaProps{
							Description: "One and only one of the following should be specified. Exec specifies the action to take.",
							Ref:         ref("k8s.io/api/core/v1.ExecAction"),
						},
					},
					"httpGet": {
						SchemaProps: spec.SchemaProps{
							Description: "HTTPGet specifies the http request to perform.",
							Ref:         ref("k8s.io/api/core/v1.HTTPGetAction"),
						},
					},
					"tcpSocket": {
						SchemaProps: spec.SchemaProps{
							Description: "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported",
							Ref:         ref("k8s.io/api/core/v1.TCPSocketAction"),
						},
					},
					"initialDelaySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"successThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"failureThreshold": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ExecAction", "k8s.io/api/core/v1.HTTPGetAction", "k8s.io/api/core/v1.TCPSocketAction"},
	}
}

func schema_k8sio_api_core_v1_ProjectedVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a projected volume source",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"sources": {
						SchemaProps: spec.SchemaProps{
							Description: "list of volume projections",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.VolumeProjection"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Mode bits to use on created files by default. Must be a value between 0 and 0777. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"sources"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.VolumeProjection"},
	}
}

func schema_k8sio_api_core_v1_QuobyteVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"registry": {
						SchemaProps: spec.SchemaProps{
							Description: "Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volume": {
						SchemaProps: spec.SchemaProps{
							Description: "Volume is a string that references an already created Quobyte volume by name.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User to map volume access to Defaults to serivceaccount user",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group to map volume access to Default is no group",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"tenant": {
						SchemaProps: spec.SchemaProps{
							Description: "Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"registry", "volume"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_RBDPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pool": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"keyring": {
						SchemaProps: spec.SchemaProps{
							Description: "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors", "image"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_RBDVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"monitors": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"pool": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"keyring": {
						SchemaProps: spec.SchemaProps{
							Description: "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"monitors", "image"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_RangeAllocation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RangeAllocation is not a public type.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"range": {
						SchemaProps: spec.SchemaProps{
							Description: "Range is string that identifies the range represented by 'data'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is a bit array containing all allocated addresses in the previous segment.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
				Required: []string{"range", "data"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ReplicationController(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationController represents the configuration of a replication controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicationController are empty, they are defaulted to be the same as the Pod(s) that the replication controller manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the replication controller. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ReplicationControllerSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the replication controller. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ReplicationControllerStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ReplicationControllerSpec", "k8s.io/api/core/v1.ReplicationControllerStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ReplicationControllerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerCondition describes the state of a replication controller at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replication controller condition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_k8sio_api_core_v1_ReplicationControllerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerList is a collection of replication controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of replication controllers. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ReplicationController"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ReplicationController", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_ReplicationControllerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerSpec is the specification of a replication controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. This takes precedence over a TemplateRef. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Ref:         ref("k8s.io/api/core/v1.PodTemplateSpec"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.PodTemplateSpec"},
	}
}

func schema_k8sio_api_core_v1_ReplicationControllerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicationControllerStatus represents the current status of a replication controller.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of pods that have labels matching the labels of the pod template of the replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of ready replicas for this replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available replicas (ready for at least minReadySeconds) for this replication controller.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed replication controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replication controller's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ReplicationControllerCondition"),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ReplicationControllerCondition"},
	}
}

func schema_k8sio_api_core_v1_ResourceFieldSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceFieldSelector represents container resources (cpu, memory) and their output format",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"containerName": {
						SchemaProps: spec.SchemaProps{
							Description: "Container name: required for volumes, optional for env vars",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: resource to select",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"divisor": {
						SchemaProps: spec.SchemaProps{
							Description: "Specifies the output format of the exposed resources, defaults to \"1\"",
							Ref:         ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
						},
					},
				},
				Required: []string{"resource"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_ResourceQuota(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuota sets aggregate quota restrictions enforced per namespace",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired quota. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ResourceQuotaSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status defines the actual enforced quota and its current usage. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ResourceQuotaStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ResourceQuotaSpec", "k8s.io/api/core/v1.ResourceQuotaStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ResourceQuotaList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaList is a list of ResourceQuota items.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of ResourceQuota objects. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ResourceQuota"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ResourceQuota", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_ResourceQuotaSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaSpec defines the desired hard limits to enforce for Quota.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"hard": {
						SchemaProps: spec.SchemaProps{
							Description: "hard is the set of desired hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"scopes": {
						SchemaProps: spec.SchemaProps{
							Description: "A collection of filters that must match each object tracked by a quota. If not specified, the quota matches all objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"scopeSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota but expressed using ScopeSelectorOperator in combination with possible values. For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.",
							Ref:         ref("k8s.io/api/core/v1.ScopeSelector"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ScopeSelector", "k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_ResourceQuotaStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceQuotaStatus defines the enforced hard limits and observed use.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"hard": {
						SchemaProps: spec.SchemaProps{
							Description: "Hard is the set of enforced hard limits for each named resource. More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"used": {
						SchemaProps: spec.SchemaProps{
							Description: "Used is the current observed total usage of the resource in the namespace.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_ResourceRequirements(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRequirements describes the compute resource requirements.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"limits": {
						SchemaProps: spec.SchemaProps{
							Description: "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
					"requests": {
						SchemaProps: spec.SchemaProps{
							Description: "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/apimachinery/pkg/api/resource.Quantity"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/api/resource.Quantity"},
	}
}

func schema_k8sio_api_core_v1_SELinuxOptions(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SELinuxOptions are the labels to be applied to the container",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is a SELinux user label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"role": {
						SchemaProps: spec.SchemaProps{
							Description: "Role is a SELinux role label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type is a SELinux type label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"level": {
						SchemaProps: spec.SchemaProps{
							Description: "Level is SELinux level label that applies to the container.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_ScaleIOPersistentVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"gateway": {
						SchemaProps: spec.SchemaProps{
							Description: "The host address of the ScaleIO API Gateway.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"system": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the storage system as configured in ScaleIO.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.",
							Ref:         ref("k8s.io/api/core/v1.SecretReference"),
						},
					},
					"sslEnabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Flag to enable/disable SSL communication with Gateway, default false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"protectionDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the ScaleIO Protection Domain for the configured storage.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storagePool": {
						SchemaProps: spec.SchemaProps{
							Description: "The ScaleIO Storage Pool associated with the protection domain.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storageMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of a volume already created in the ScaleIO system that is associated with this volume source.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"gateway", "system", "secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.SecretReference"},
	}
}

func schema_k8sio_api_core_v1_ScaleIOVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleIOVolumeSource represents a persistent ScaleIO volume",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"gateway": {
						SchemaProps: spec.SchemaProps{
							Description: "The host address of the ScaleIO API Gateway.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"system": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the storage system as configured in ScaleIO.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"secretRef": {
						SchemaProps: spec.SchemaProps{
							Description: "SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.",
							Ref:         ref("k8s.io/api/core/v1.LocalObjectReference"),
						},
					},
					"sslEnabled": {
						SchemaProps: spec.SchemaProps{
							Description: "Flag to enable/disable SSL communication with Gateway, default false",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"protectionDomain": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the ScaleIO Protection Domain for the configured storage.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storagePool": {
						SchemaProps: spec.SchemaProps{
							Description: "The ScaleIO Storage Pool associated with the protection domain.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"storageMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"volumeName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of a volume already created in the ScaleIO system that is associated with this volume source.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fsType": {
						SchemaProps: spec.SchemaProps{
							Description: "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"readOnly": {
						SchemaProps: spec.SchemaProps{
							Description: "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"gateway", "system", "secretRef"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.LocalObjectReference"},
	}
}

func schema_k8sio_api_core_v1_ScopeSelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A scope selector represents the AND of the selectors represented by the scoped-resource selector requirements.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"matchExpressions": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of scope selector requirements by scope of the resources.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ScopedResourceSelectorRequirement"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ScopedResourceSelectorRequirement"},
	}
}

func schema_k8sio_api_core_v1_ScopedResourceSelectorRequirement(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scopeName": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the scope that the selector applies to.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"operator": {
						SchemaProps: spec.SchemaProps{
							Description: "Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"values": {
						SchemaProps: spec.SchemaProps{
							Description: "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"scopeName", "operator"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_Secret(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"immutable": {
						SchemaProps: spec.SchemaProps{
							Description: "Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil. This is an alpha field enabled by ImmutableEphemeralVolumes feature gate.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "byte",
									},
								},
							},
						},
					},
					"stringData": {
						SchemaProps: spec.SchemaProps{
							Description: "stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Used to facilitate programmatic handling of secret data.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_SecretEnvSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretEnvSource selects a Secret to populate the environment variables with.\n\nThe contents of the target Secret's Data field will represent the key-value pairs as environment variables.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the Secret must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_SecretKeySelector(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretKeySelector selects a key of a Secret.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "The key of the secret to select from.  Must be a valid secret key.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the Secret or its key must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
				Required: []string{"key"},
			},
		},
	}
}

func schema_k8sio_api_core_v1_SecretList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretList is a list of Secret.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is a list of secret objects. More info: https://kubernetes.io/docs/concepts/configuration/secret",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.Secret"),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Secret", "k8s.io/apimachinery/pkg/apis/meta/v1.ListMeta"},
	}
}

func schema_k8sio_api_core_v1_SecretProjection(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a secret into a projected volume.\n\nThe contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the Secret or its key must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.KeyToPath"},
	}
}

func schema_k8sio_api_core_v1_SecretReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is unique within a namespace to reference a secret resource.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace defines the space within which the secret name must be unique.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_core_v1_SecretVolumeSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Adapts a Secret into a volume.\n\nThe contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names. Secret volumes support ownership management and SELinux relabeling.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"secretName": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.KeyToPath"),
									},
								},
							},
						},
					},
					"defaultMode": {
						SchemaProps: spec.SchemaProps{
							Description: "Optional: mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"optional": {
						SchemaProps: spec.SchemaProps{
							Description: "Specify whether the Secret or its keys must be defined",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.KeyToPath"},
	}
}

func schema_k8sio_api_core_v1_SecurityContext(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"capabilities": {
						SchemaProps: spec.SchemaProps{
							Description: "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.",
							Ref:         ref("k8s.io/api/core/v1.Capabilities"),
						},
					},
					"privileged": {
						SchemaProps: spec.SchemaProps{
							Description: "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"seLinuxOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Ref:         ref("k8s.io/api/core/v1.SELinuxOptions"),
						},
					},
					"windowsOptions": {
						SchemaProps: spec.SchemaProps{
							Description: "The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Ref:         ref("k8s.io/api/core/v1.WindowsSecurityContextOptions"),
						},
					},
					"runAsUser": {
						SchemaProps: spec.SchemaProps{
							Description: "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsGroup": {
						SchemaProps: spec.SchemaProps{
							Description: "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"runAsNonRoot": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"readOnlyRootFilesystem": {
						SchemaProps: spec.SchemaProps{
							Description: "Whether this container has a read-only root filesystem. Default is false.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"allowPrivilegeEscalation": {
						SchemaProps: spec.SchemaProps{
							Description: "AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"procMount": {
						SchemaProps: spec.SchemaProps{
							Description: "procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.Capabilities", "k8s.io/api/core/v1.SELinuxOptions", "k8s.io/api/core/v1.WindowsSecurityContextOptions"},
	}
}

func schema_k8sio_api_core_v1_SerializedReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SerializedReference is a reference to serialized object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reference": {
						SchemaProps: spec.SchemaProps{
							Description: "The reference to an object in the system.",
							Ref:         ref("k8s.io/api/core/v1.ObjectReference"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ObjectReference"},
	}
}

func schema_k8sio_api_core_v1_Service(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Service is a named abstraction of software service (for example, mysql) consisting of local port (for example 3306) that the proxy listens on, and the selector that determines which pods will answer requests sent through the proxy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the behavior of a service. https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ServiceSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the service. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Ref:         ref("k8s.io/api/core/v1.ServiceStatus"),
						},
					},
				},
			},
		},
		Dependencies: []string{
			"k8s.io/api/core/v1.ServiceSpec", "k8s.io/api/core/v1.ServiceStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"},
	}
}

func schema_k8sio_api_core_v1_ServiceAccount(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Ref:         ref("k8s.io/apimachinery/pkg/apis/meta/v1.ObjectMeta"),
						},
					},
					"secrets": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("k8s.io/api/core/v1.ObjectReference"),
									},
								},
							},
						},
					},
					"imagePullSecrets": {
						SchemaProps: spec.SchemaProps{
							Description: "ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in 