/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// InfrastructureLister helps list Infrastructures.
type InfrastructureLister interface {
	// List lists all Infrastructures in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Infrastructure, err error)
	// Infrastructures returns an object that can list and get Infrastructures.
	Infrastructures(namespace string) InfrastructureNamespaceLister
	InfrastructureListerExpansion
}

// infrastructureLister implements the InfrastructureLister interface.
type infrastructureLister struct {
	indexer cache.Indexer
}

// NewInfrastructureLister returns a new InfrastructureLister.
func NewInfrastructureLister(indexer cache.Indexer) InfrastructureLister {
	return &infrastructureLister{indexer: indexer}
}

// List lists all Infrastructures in the indexer.
func (s *infrastructureLister) List(selector labels.Selector) (ret []*v1alpha1.Infrastructure, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Infrastructure))
	})
	return ret, err
}

// Infrastructures returns an object that can list and get Infrastructures.
func (s *infrastructureLister) Infrastructures(namespace string) InfrastructureNamespaceLister {
	return infrastructureNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// InfrastructureNamespaceLister helps list and get Infrastructures.
type InfrastructureNamespaceLister interface {
	// List lists all Infrastructures in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Infrastructure, err error)
	// Get retrieves the Infrastructure from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Infrastructure, error)
	InfrastructureNamespaceListerExpansion
}

// infrastructureNamespaceLister implements the InfrastructureNamespaceLister
// interface.
type infrastructureNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Infrastructures in the indexer for a given namespace.
func (s infrastructureNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Infrastructure, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Infrastructure))
	})
	return ret, err
}

// Get retrieves the Infrastructure from the indexer for a given namespace and name.
func (s infrastructureNamespaceLister) Get(name string) (*v1alpha1.Infrastructure, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("infrastructure"), name)
	}
	return obj.(*v1alpha1.Infrastructure), nil
}
