/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/extensions/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeInfrastructures implements InfrastructureInterface
type FakeInfrastructures struct {
	Fake *FakeExtensionsV1alpha1
	ns   string
}

var infrastructuresResource = schema.GroupVersionResource{Group: "extensions.gardener.cloud", Version: "v1alpha1", Resource: "infrastructures"}

var infrastructuresKind = schema.GroupVersionKind{Group: "extensions.gardener.cloud", Version: "v1alpha1", Kind: "Infrastructure"}

// Get takes name of the infrastructure, and returns the corresponding infrastructure object, and an error if there is any.
func (c *FakeInfrastructures) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(infrastructuresResource, c.ns, name), &v1alpha1.Infrastructure{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Infrastructure), err
}

// List takes label and field selectors, and returns the list of Infrastructures that match those selectors.
func (c *FakeInfrastructures) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.InfrastructureList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(infrastructuresResource, infrastructuresKind, c.ns, opts), &v1alpha1.InfrastructureList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.InfrastructureList{ListMeta: obj.(*v1alpha1.InfrastructureList).ListMeta}
	for _, item := range obj.(*v1alpha1.InfrastructureList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested infrastructures.
func (c *FakeInfrastructures) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(infrastructuresResource, c.ns, opts))

}

// Create takes the representation of a infrastructure and creates it.  Returns the server's representation of the infrastructure, and an error, if there is any.
func (c *FakeInfrastructures) Create(ctx context.Context, infrastructure *v1alpha1.Infrastructure, opts v1.CreateOptions) (result *v1alpha1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(infrastructuresResource, c.ns, infrastructure), &v1alpha1.Infrastructure{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Infrastructure), err
}

// Update takes the representation of a infrastructure and updates it. Returns the server's representation of the infrastructure, and an error, if there is any.
func (c *FakeInfrastructures) Update(ctx context.Context, infrastructure *v1alpha1.Infrastructure, opts v1.UpdateOptions) (result *v1alpha1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(infrastructuresResource, c.ns, infrastructure), &v1alpha1.Infrastructure{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Infrastructure), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeInfrastructures) UpdateStatus(ctx context.Context, infrastructure *v1alpha1.Infrastructure, opts v1.UpdateOptions) (*v1alpha1.Infrastructure, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(infrastructuresResource, "status", c.ns, infrastructure), &v1alpha1.Infrastructure{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Infrastructure), err
}

// Delete takes name of the infrastructure and deletes it. Returns an error if one occurs.
func (c *FakeInfrastructures) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(infrastructuresResource, c.ns, name), &v1alpha1.Infrastructure{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeInfrastructures) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(infrastructuresResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.InfrastructureList{})
	return err
}

// Patch applies the patch and returns the patched infrastructure.
func (c *FakeInfrastructures) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Infrastructure, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(infrastructuresResource, c.ns, name, pt, data, subresources...), &v1alpha1.Infrastructure{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Infrastructure), err
}
