# Gardener Adopters

This is a list of adopters of Gardener in __production environments__ that have
publicly shared details of their usage.

- [b’nerd](https://bnerd.com) uses Gardener as the core technology for
its own managed Kubernetes as a Service solution and operates multiple
Gardener installations for several cloud hosting service providers.
- [SAP](https://www.sap.com) uses Gardener to deploy and manage Kubernetes
clusters at scale in a uniform way across infrastructures (AWS, Azure, GCP,
Alicloud, OpenStack). Workloads include databases
([SAP Hana](https://www.sap.com/products/hana.html)),
Big Data ([SAP Data Hub](https://www.sap.com/products/data-hub.html)), IoT, AI,
and Machine Learning ([SAP Leonardo](https://www.sap.com/products/leonardo.html)),
Serverless and diverse business workloads.
- [ScaleUp Technologies](https://www.scaleuptech.com/) runs Gardener
within their public Openstack Clouds (Hamburg, Berlin, Düsseldorf).
Their clients run all kinds of workloads on top of Gardener maintained
Kubernetes clusters ranging from databases to Software as a Service
applications.

Cloud provider adopters

- [Packet](https://packet.com) drove and sponsored integration of Gardener into its
bare-metal cloud platform. Packet customers now are able to manage multiple Kubernetes
clusters with ease everywhere that Packet is available: across regions, at the edge
in telco networks, and on customer premises.

Adopters in evaluation or pre-production phase

- [Finanz Informatik Technologie Services GmbH]( https://f-i-ts.de/ )
uses Gardener to offer k8s as a service for customers in the financial
industry in Germany. It is built on top of a "metal as a service"
infrastructure implemented from scratch for k8s workloads in mind.
The result is k8s on top of bare metal in minutes.
- [PTC](https://www.ptc.com) uses Gardener to provide development environments
and CI/CD systems internally.
- [Beez Innovation Labs Pvt Ltd](https://www.beezlabs.com/) uses Gardener to offer its 
products across cloud providers and manage its clusters for different environments.
- [PingCAP](https://pingcap.com/) uses Gardener to build its managed database service known as [TiDB Cloud](https://pingcap.com/tidb-cloud/) on mainstream cloud providers.

If you’re using Gardener and aren’t on this list, feel free to
[submit a pull request](https://github.com/gardener/gardener/pulls)!
