/*
Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved. This file is licensed under the Apache Software License, v. 2 except as noted otherwise in the LICENSE file

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/gardener/gardener/pkg/apis/core/v1alpha1"
	scheme "github.com/gardener/gardener/pkg/client/core/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ControllerRegistrationsGetter has a method to return a ControllerRegistrationInterface.
// A group's client should implement this interface.
type ControllerRegistrationsGetter interface {
	ControllerRegistrations() ControllerRegistrationInterface
}

// ControllerRegistrationInterface has methods to work with ControllerRegistration resources.
type ControllerRegistrationInterface interface {
	Create(*v1alpha1.ControllerRegistration) (*v1alpha1.ControllerRegistration, error)
	Update(*v1alpha1.ControllerRegistration) (*v1alpha1.ControllerRegistration, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ControllerRegistration, error)
	List(opts v1.ListOptions) (*v1alpha1.ControllerRegistrationList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ControllerRegistration, err error)
	ControllerRegistrationExpansion
}

// controllerRegistrations implements ControllerRegistrationInterface
type controllerRegistrations struct {
	client rest.Interface
}

// newControllerRegistrations returns a ControllerRegistrations
func newControllerRegistrations(c *CoreV1alpha1Client) *controllerRegistrations {
	return &controllerRegistrations{
		client: c.RESTClient(),
	}
}

// Get takes name of the controllerRegistration, and returns the corresponding controllerRegistration object, and an error if there is any.
func (c *controllerRegistrations) Get(name string, options v1.GetOptions) (result *v1alpha1.ControllerRegistration, err error) {
	result = &v1alpha1.ControllerRegistration{}
	err = c.client.Get().
		Resource("controllerregistrations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ControllerRegistrations that match those selectors.
func (c *controllerRegistrations) List(opts v1.ListOptions) (result *v1alpha1.ControllerRegistrationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ControllerRegistrationList{}
	err = c.client.Get().
		Resource("controllerregistrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested controllerRegistrations.
func (c *controllerRegistrations) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("controllerregistrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a controllerRegistration and creates it.  Returns the server's representation of the controllerRegistration, and an error, if there is any.
func (c *controllerRegistrations) Create(controllerRegistration *v1alpha1.ControllerRegistration) (result *v1alpha1.ControllerRegistration, err error) {
	result = &v1alpha1.ControllerRegistration{}
	err = c.client.Post().
		Resource("controllerregistrations").
		Body(controllerRegistration).
		Do().
		Into(result)
	return
}

// Update takes the representation of a controllerRegistration and updates it. Returns the server's representation of the controllerRegistration, and an error, if there is any.
func (c *controllerRegistrations) Update(controllerRegistration *v1alpha1.ControllerRegistration) (result *v1alpha1.ControllerRegistration, err error) {
	result = &v1alpha1.ControllerRegistration{}
	err = c.client.Put().
		Resource("controllerregistrations").
		Name(controllerRegistration.Name).
		Body(controllerRegistration).
		Do().
		Into(result)
	return
}

// Delete takes name of the controllerRegistration and deletes it. Returns an error if one occurs.
func (c *controllerRegistrations) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("controllerregistrations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *controllerRegistrations) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("controllerregistrations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched controllerRegistration.
func (c *controllerRegistrations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ControllerRegistration, err error) {
	result = &v1alpha1.ControllerRegistration{}
	err = c.client.Patch(pt).
		Resource("controllerregistrations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
