// Package ciphersuites defines TLS and SSL cipher suit properties
// generated by ciphersuites.jq
//
// Ignored lint warnings to keep same names as in spec
//
//nolint:revive
package ciphersuites

type Protocol int

const (
	SSL Protocol = iota
	TLS
)

type KeyAgreement int

const (
	DHE_DSS KeyAgreement = iota
	DHE_DSS_EXPORT
	DHE_PSK
	DHE_RSA
	DHE_RSA_EXPORT
	DH_DSS
	DH_DSS_EXPORT
	DH_RSA
	DH_RSA_EXPORT
	DH_anon
	DH_anon_EXPORT
	ECCPWD
	ECDHE_ECDSA
	ECDHE_PSK
	ECDHE_RSA
	ECDH_ECDSA
	ECDH_RSA
	ECDH_anon
	GOSTR341001
	GOSTR341094
	GOSTR341112_256
	KRB5
	KRB5_EXPORT
	NULL_KeyAgreement
	PSK
	RSA
	RSA_EXPORT
	RSA_FIPS
	RSA_PSK
	SRP_SHA
	SRP_SHA_DSS
	SRP_SHA_RSA
	UNKNOWN_KeyAgreement
)

type Cipher int

const (
	AES_128_CBC Cipher = iota
	AES_128_CCM
	AES_128_CCM_8
	AES_128_GCM
	AES_256_CBC
	AES_256_CCM
	AES_256_GCM
	ARIA_128_CBC
	ARIA_128_GCM
	ARIA_256_CBC
	ARIA_256_GCM
	CAMELLIA_128_CBC
	CAMELLIA_128_GCM
	CAMELLIA_256_CBC
	CAMELLIA_256_GCM
	CHACHA20_POLY1305
	DES40_CBC
	DES_CBC
	DES_CBC_40
	IDEA_CBC
	NULL_Cipher
	RC2_CBC_40
	RC4_128
	RC4_40
	SEED_CBC
	UNKNOWN_Cipher
	_28147_CNT
	_3DES_EDE_CBC
)

type Hash int

const (
	GOSTR3411 Hash = iota
	IMIT
	MD5
	NULL_Hash
	SHA
	SHA256
	SHA384
	UNKNOWN_Hash
)
const (
	TLS_NULL_WITH_NULL_NULL                       = 0x0000
	TLS_RSA_WITH_NULL_MD5                         = 0x0001
	TLS_RSA_WITH_NULL_SHA                         = 0x0002
	TLS_RSA_EXPORT_WITH_RC4_40_MD5                = 0x0003
	TLS_RSA_WITH_RC4_128_MD5                      = 0x0004
	TLS_RSA_WITH_RC4_128_SHA                      = 0x0005
	TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5            = 0x0006
	TLS_RSA_WITH_IDEA_CBC_SHA                     = 0x0007
	TLS_RSA_EXPORT_WITH_DES40_CBC_SHA             = 0x0008
	TLS_RSA_WITH_DES_CBC_SHA                      = 0x0009
	TLS_RSA_WITH_3DES_EDE_CBC_SHA                 = 0x000a
	TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA          = 0x000b
	TLS_DH_DSS_WITH_DES_CBC_SHA                   = 0x000c
	TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA              = 0x000d
	TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA          = 0x000e
	TLS_DH_RSA_WITH_DES_CBC_SHA                   = 0x000f
	TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA              = 0x0010
	TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA         = 0x0011
	TLS_DHE_DSS_WITH_DES_CBC_SHA                  = 0x0012
	TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA             = 0x0013
	TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA         = 0x0014
	TLS_DHE_RSA_WITH_DES_CBC_SHA                  = 0x0015
	TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA             = 0x0016
	TLS_DH_anon_EXPORT_WITH_RC4_40_MD5            = 0x0017
	TLS_DH_anon_WITH_RC4_128_MD5                  = 0x0018
	TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA         = 0x0019
	TLS_DH_anon_WITH_DES_CBC_SHA                  = 0x001a
	TLS_DH_anon_WITH_3DES_EDE_CBC_SHA             = 0x001b
	TLS_KRB5_WITH_DES_CBC_SHA                     = 0x001e
	TLS_KRB5_WITH_3DES_EDE_CBC_SHA                = 0x001f
	TLS_KRB5_WITH_RC4_128_SHA                     = 0x0020
	TLS_KRB5_WITH_IDEA_CBC_SHA                    = 0x0021
	TLS_KRB5_WITH_DES_CBC_MD5                     = 0x0022
	TLS_KRB5_WITH_3DES_EDE_CBC_MD5                = 0x0023
	TLS_KRB5_WITH_RC4_128_MD5                     = 0x0024
	TLS_KRB5_WITH_IDEA_CBC_MD5                    = 0x0025
	TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA           = 0x0026
	TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA           = 0x0027
	TLS_KRB5_EXPORT_WITH_RC4_40_SHA               = 0x0028
	TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5           = 0x0029
	TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5           = 0x002a
	TLS_KRB5_EXPORT_WITH_RC4_40_MD5               = 0x002b
	TLS_PSK_WITH_NULL_SHA                         = 0x002c
	TLS_DHE_PSK_WITH_NULL_SHA                     = 0x002d
	TLS_RSA_PSK_WITH_NULL_SHA                     = 0x002e
	TLS_RSA_WITH_AES_128_CBC_SHA                  = 0x002f
	TLS_DH_DSS_WITH_AES_128_CBC_SHA               = 0x0030
	TLS_DH_RSA_WITH_AES_128_CBC_SHA               = 0x0031
	TLS_DHE_DSS_WITH_AES_128_CBC_SHA              = 0x0032
	TLS_DHE_RSA_WITH_AES_128_CBC_SHA              = 0x0033
	TLS_DH_anon_WITH_AES_128_CBC_SHA              = 0x0034
	TLS_RSA_WITH_AES_256_CBC_SHA                  = 0x0035
	TLS_DH_DSS_WITH_AES_256_CBC_SHA               = 0x0036
	TLS_DH_RSA_WITH_AES_256_CBC_SHA               = 0x0037
	TLS_DHE_DSS_WITH_AES_256_CBC_SHA              = 0x0038
	TLS_DHE_RSA_WITH_AES_256_CBC_SHA              = 0x0039
	TLS_DH_anon_WITH_AES_256_CBC_SHA              = 0x003a
	TLS_RSA_WITH_NULL_SHA256                      = 0x003b
	TLS_RSA_WITH_AES_128_CBC_SHA256               = 0x003c
	TLS_RSA_WITH_AES_256_CBC_SHA256               = 0x003d
	TLS_DH_DSS_WITH_AES_128_CBC_SHA256            = 0x003e
	TLS_DH_RSA_WITH_AES_128_CBC_SHA256            = 0x003f
	TLS_DHE_DSS_WITH_AES_128_CBC_SHA256           = 0x0040
	TLS_RSA_WITH_CAMELLIA_128_CBC_SHA             = 0x0041
	TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA          = 0x0042
	TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA          = 0x0043
	TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA         = 0x0044
	TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA         = 0x0045
	TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA         = 0x0046
	TLS_DHE_RSA_WITH_AES_128_CBC_SHA256           = 0x0067
	TLS_DH_DSS_WITH_AES_256_CBC_SHA256            = 0x0068
	TLS_DH_RSA_WITH_AES_256_CBC_SHA256            = 0x0069
	TLS_DHE_DSS_WITH_AES_256_CBC_SHA256           = 0x006a
	TLS_DHE_RSA_WITH_AES_256_CBC_SHA256           = 0x006b
	TLS_DH_anon_WITH_AES_128_CBC_SHA256           = 0x006c
	TLS_DH_anon_WITH_AES_256_CBC_SHA256           = 0x006d
	TLS_RSA_WITH_CAMELLIA_256_CBC_SHA             = 0x0084
	TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA          = 0x0085
	TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA          = 0x0086
	TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA         = 0x0087
	TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA         = 0x0088
	TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA         = 0x0089
	TLS_PSK_WITH_RC4_128_SHA                      = 0x008a
	TLS_PSK_WITH_3DES_EDE_CBC_SHA                 = 0x008b
	TLS_PSK_WITH_AES_128_CBC_SHA                  = 0x008c
	TLS_PSK_WITH_AES_256_CBC_SHA                  = 0x008d
	TLS_DHE_PSK_WITH_RC4_128_SHA                  = 0x008e
	TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA             = 0x008f
	TLS_DHE_PSK_WITH_AES_128_CBC_SHA              = 0x0090
	TLS_DHE_PSK_WITH_AES_256_CBC_SHA              = 0x0091
	TLS_RSA_PSK_WITH_RC4_128_SHA                  = 0x0092
	TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA             = 0x0093
	TLS_RSA_PSK_WITH_AES_128_CBC_SHA              = 0x0094
	TLS_RSA_PSK_WITH_AES_256_CBC_SHA              = 0x0095
	TLS_RSA_WITH_SEED_CBC_SHA                     = 0x0096
	TLS_DH_DSS_WITH_SEED_CBC_SHA                  = 0x0097
	TLS_DH_RSA_WITH_SEED_CBC_SHA                  = 0x0098
	TLS_DHE_DSS_WITH_SEED_CBC_SHA                 = 0x0099
	TLS_DHE_RSA_WITH_SEED_CBC_SHA                 = 0x009a
	TLS_DH_anon_WITH_SEED_CBC_SHA                 = 0x009b
	TLS_RSA_WITH_AES_128_GCM_SHA256               = 0x009c
	TLS_RSA_WITH_AES_256_GCM_SHA384               = 0x009d
	TLS_DHE_RSA_WITH_AES_128_GCM_SHA256           = 0x009e
	TLS_DHE_RSA_WITH_AES_256_GCM_SHA384           = 0x009f
	TLS_DH_RSA_WITH_AES_128_GCM_SHA256            = 0x00a0
	TLS_DH_RSA_WITH_AES_256_GCM_SHA384            = 0x00a1
	TLS_DHE_DSS_WITH_AES_128_GCM_SHA256           = 0x00a2
	TLS_DHE_DSS_WITH_AES_256_GCM_SHA384           = 0x00a3
	TLS_DH_DSS_WITH_AES_128_GCM_SHA256            = 0x00a4
	TLS_DH_DSS_WITH_AES_256_GCM_SHA384            = 0x00a5
	TLS_DH_anon_WITH_AES_128_GCM_SHA256           = 0x00a6
	TLS_DH_anon_WITH_AES_256_GCM_SHA384           = 0x00a7
	TLS_PSK_WITH_AES_128_GCM_SHA256               = 0x00a8
	TLS_PSK_WITH_AES_256_GCM_SHA384               = 0x00a9
	TLS_DHE_PSK_WITH_AES_128_GCM_SHA256           = 0x00aa
	TLS_DHE_PSK_WITH_AES_256_GCM_SHA384           = 0x00ab
	TLS_RSA_PSK_WITH_AES_128_GCM_SHA256           = 0x00ac
	TLS_RSA_PSK_WITH_AES_256_GCM_SHA384           = 0x00ad
	TLS_PSK_WITH_AES_128_CBC_SHA256               = 0x00ae
	TLS_PSK_WITH_AES_256_CBC_SHA384               = 0x00af
	TLS_PSK_WITH_NULL_SHA256                      = 0x00b0
	TLS_PSK_WITH_NULL_SHA384                      = 0x00b1
	TLS_DHE_PSK_WITH_AES_128_CBC_SHA256           = 0x00b2
	TLS_DHE_PSK_WITH_AES_256_CBC_SHA384           = 0x00b3
	TLS_DHE_PSK_WITH_NULL_SHA256                  = 0x00b4
	TLS_DHE_PSK_WITH_NULL_SHA384                  = 0x00b5
	TLS_RSA_PSK_WITH_AES_128_CBC_SHA256           = 0x00b6
	TLS_RSA_PSK_WITH_AES_256_CBC_SHA384           = 0x00b7
	TLS_RSA_PSK_WITH_NULL_SHA256                  = 0x00b8
	TLS_RSA_PSK_WITH_NULL_SHA384                  = 0x00b9
	TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256          = 0x00ba
	TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256       = 0x00bb
	TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256       = 0x00bc
	TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256      = 0x00bd
	TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256      = 0x00be
	TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256      = 0x00bf
	TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256          = 0x00c0
	TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256       = 0x00c1
	TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256       = 0x00c2
	TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256      = 0x00c3
	TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256      = 0x00c4
	TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256      = 0x00c5
	TLS_SM4_GCM_SM3                               = 0x00c6
	TLS_SM4_CCM_SM3                               = 0x00c7
	TLS_EMPTY_RENEGOTIATION_INFO_SCSV             = 0x00ff
	TLS_AES_128_GCM_SHA256                        = 0x1301
	TLS_AES_256_GCM_SHA384                        = 0x1302
	TLS_CHACHA20_POLY1305_SHA256                  = 0x1303
	TLS_AES_128_CCM_SHA256                        = 0x1304
	TLS_AES_128_CCM_8_SHA256                      = 0x1305
	TLS_AEGIS_256_SHA384                          = 0x1306
	TLS_AEGIS_128L_SHA256                         = 0x1307
	TLS_FALLBACK_SCSV                             = 0x5600
	TLS_ECDH_ECDSA_WITH_NULL_SHA                  = 0xc001
	TLS_ECDH_ECDSA_WITH_RC4_128_SHA               = 0xc002
	TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA          = 0xc003
	TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA           = 0xc004
	TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA           = 0xc005
	TLS_ECDHE_ECDSA_WITH_NULL_SHA                 = 0xc006
	TLS_ECDHE_ECDSA_WITH_RC4_128_SHA              = 0xc007
	TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA         = 0xc008
	TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA          = 0xc009
	TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA          = 0xc00a
	TLS_ECDH_RSA_WITH_NULL_SHA                    = 0xc00b
	TLS_ECDH_RSA_WITH_RC4_128_SHA                 = 0xc00c
	TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA            = 0xc00d
	TLS_ECDH_RSA_WITH_AES_128_CBC_SHA             = 0xc00e
	TLS_ECDH_RSA_WITH_AES_256_CBC_SHA             = 0xc00f
	TLS_ECDHE_RSA_WITH_NULL_SHA                   = 0xc010
	TLS_ECDHE_RSA_WITH_RC4_128_SHA                = 0xc011
	TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA           = 0xc012
	TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA            = 0xc013
	TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA            = 0xc014
	TLS_ECDH_anon_WITH_NULL_SHA                   = 0xc015
	TLS_ECDH_anon_WITH_RC4_128_SHA                = 0xc016
	TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA           = 0xc017
	TLS_ECDH_anon_WITH_AES_128_CBC_SHA            = 0xc018
	TLS_ECDH_anon_WITH_AES_256_CBC_SHA            = 0xc019
	TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA             = 0xc01a
	TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA         = 0xc01b
	TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA         = 0xc01c
	TLS_SRP_SHA_WITH_AES_128_CBC_SHA              = 0xc01d
	TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA          = 0xc01e
	TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA          = 0xc01f
	TLS_SRP_SHA_WITH_AES_256_CBC_SHA              = 0xc020
	TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA          = 0xc021
	TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA          = 0xc022
	TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256       = 0xc023
	TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384       = 0xc024
	TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256        = 0xc025
	TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384        = 0xc026
	TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256         = 0xc027
	TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384         = 0xc028
	TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256          = 0xc029
	TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384          = 0xc02a
	TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256       = 0xc02b
	TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384       = 0xc02c
	TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256        = 0xc02d
	TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384        = 0xc02e
	TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256         = 0xc02f
	TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384         = 0xc030
	TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256          = 0xc031
	TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384          = 0xc032
	TLS_ECDHE_PSK_WITH_RC4_128_SHA                = 0xc033
	TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA           = 0xc034
	TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA            = 0xc035
	TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA            = 0xc036
	TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256         = 0xc037
	TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384         = 0xc038
	TLS_ECDHE_PSK_WITH_NULL_SHA                   = 0xc039
	TLS_ECDHE_PSK_WITH_NULL_SHA256                = 0xc03a
	TLS_ECDHE_PSK_WITH_NULL_SHA384                = 0xc03b
	TLS_RSA_WITH_ARIA_128_CBC_SHA256              = 0xc03c
	TLS_RSA_WITH_ARIA_256_CBC_SHA384              = 0xc03d
	TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256           = 0xc03e
	TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384           = 0xc03f
	TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256           = 0xc040
	TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384           = 0xc041
	TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256          = 0xc042
	TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384          = 0xc043
	TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256          = 0xc044
	TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384          = 0xc045
	TLS_DH_anon_WITH_ARIA_128_CBC_SHA256          = 0xc046
	TLS_DH_anon_WITH_ARIA_256_CBC_SHA384          = 0xc047
	TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256      = 0xc048
	TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384      = 0xc049
	TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256       = 0xc04a
	TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384       = 0xc04b
	TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256        = 0xc04c
	TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384        = 0xc04d
	TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256         = 0xc04e
	TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384         = 0xc04f
	TLS_RSA_WITH_ARIA_128_GCM_SHA256              = 0xc050
	TLS_RSA_WITH_ARIA_256_GCM_SHA384              = 0xc051
	TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256          = 0xc052
	TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384          = 0xc053
	TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256           = 0xc054
	TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384           = 0xc055
	TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256          = 0xc056
	TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384          = 0xc057
	TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256           = 0xc058
	TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384           = 0xc059
	TLS_DH_anon_WITH_ARIA_128_GCM_SHA256          = 0xc05a
	TLS_DH_anon_WITH_ARIA_256_GCM_SHA384          = 0xc05b
	TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256      = 0xc05c
	TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384      = 0xc05d
	TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256       = 0xc05e
	TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384       = 0xc05f
	TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256        = 0xc060
	TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384        = 0xc061
	TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256         = 0xc062
	TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384         = 0xc063
	TLS_PSK_WITH_ARIA_128_CBC_SHA256              = 0xc064
	TLS_PSK_WITH_ARIA_256_CBC_SHA384              = 0xc065
	TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256          = 0xc066
	TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384          = 0xc067
	TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256          = 0xc068
	TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384          = 0xc069
	TLS_PSK_WITH_ARIA_128_GCM_SHA256              = 0xc06a
	TLS_PSK_WITH_ARIA_256_GCM_SHA384              = 0xc06b
	TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256          = 0xc06c
	TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384          = 0xc06d
	TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256          = 0xc06e
	TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384          = 0xc06f
	TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256        = 0xc070
	TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384        = 0xc071
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256  = 0xc072
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384  = 0xc073
	TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256   = 0xc074
	TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384   = 0xc075
	TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256    = 0xc076
	TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384    = 0xc077
	TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256     = 0xc078
	TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384     = 0xc079
	TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256          = 0xc07a
	TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384          = 0xc07b
	TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256      = 0xc07c
	TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384      = 0xc07d
	TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256       = 0xc07e
	TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384       = 0xc07f
	TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256      = 0xc080
	TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384      = 0xc081
	TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256       = 0xc082
	TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384       = 0xc083
	TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256      = 0xc084
	TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384      = 0xc085
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256  = 0xc086
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384  = 0xc087
	TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256   = 0xc088
	TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384   = 0xc089
	TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256    = 0xc08a
	TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384    = 0xc08b
	TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256     = 0xc08c
	TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384     = 0xc08d
	TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256          = 0xc08e
	TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384          = 0xc08f
	TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256      = 0xc090
	TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384      = 0xc091
	TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256      = 0xc092
	TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384      = 0xc093
	TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256          = 0xc094
	TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384          = 0xc095
	TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256      = 0xc096
	TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384      = 0xc097
	TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256      = 0xc098
	TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384      = 0xc099
	TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256    = 0xc09a
	TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384    = 0xc09b
	TLS_RSA_WITH_AES_128_CCM                      = 0xc09c
	TLS_RSA_WITH_AES_256_CCM                      = 0xc09d
	TLS_DHE_RSA_WITH_AES_128_CCM                  = 0xc09e
	TLS_DHE_RSA_WITH_AES_256_CCM                  = 0xc09f
	TLS_RSA_WITH_AES_128_CCM_8                    = 0xc0a0
	TLS_RSA_WITH_AES_256_CCM_8                    = 0xc0a1
	TLS_DHE_RSA_WITH_AES_128_CCM_8                = 0xc0a2
	TLS_DHE_RSA_WITH_AES_256_CCM_8                = 0xc0a3
	TLS_PSK_WITH_AES_128_CCM                      = 0xc0a4
	TLS_PSK_WITH_AES_256_CCM                      = 0xc0a5
	TLS_DHE_PSK_WITH_AES_128_CCM                  = 0xc0a6
	TLS_DHE_PSK_WITH_AES_256_CCM                  = 0xc0a7
	TLS_PSK_WITH_AES_128_CCM_8                    = 0xc0a8
	TLS_PSK_WITH_AES_256_CCM_8                    = 0xc0a9
	TLS_PSK_DHE_WITH_AES_128_CCM_8                = 0xc0aa
	TLS_PSK_DHE_WITH_AES_256_CCM_8                = 0xc0ab
	TLS_ECDHE_ECDSA_WITH_AES_128_CCM              = 0xc0ac
	TLS_ECDHE_ECDSA_WITH_AES_256_CCM              = 0xc0ad
	TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8            = 0xc0ae
	TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8            = 0xc0af
	TLS_ECCPWD_WITH_AES_128_GCM_SHA256            = 0xc0b0
	TLS_ECCPWD_WITH_AES_256_GCM_SHA384            = 0xc0b1
	TLS_ECCPWD_WITH_AES_128_CCM_SHA256            = 0xc0b2
	TLS_ECCPWD_WITH_AES_256_CCM_SHA384            = 0xc0b3
	TLS_SHA256_SHA256                             = 0xc0b4
	TLS_SHA384_SHA384                             = 0xc0b5
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC  = 0xc100
	TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC       = 0xc101
	TLS_GOSTR341112_256_WITH_28147_CNT_IMIT       = 0xc102
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L     = 0xc103
	TLS_GOSTR341112_256_WITH_MAGMA_MGM_L          = 0xc104
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S     = 0xc105
	TLS_GOSTR341112_256_WITH_MAGMA_MGM_S          = 0xc106
	TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256   = 0xcca8
	TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256 = 0xcca9
	TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256     = 0xccaa
	TLS_PSK_WITH_CHACHA20_POLY1305_SHA256         = 0xccab
	TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256   = 0xccac
	TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256     = 0xccad
	TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256     = 0xccae
	TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256         = 0xd001
	TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384         = 0xd002
	TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256       = 0xd003
	TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256         = 0xd005
	TLS_GOSTR341094_WITH_28147_CNT_IMIT           = 0x0080
	TLS_GOSTR341001_WITH_28147_CNT_IMIT           = 0x0081
	TLS_GOSTR341094_WITH_NULL_GOSTR3411           = 0x0082
	TLS_GOSTR341001_WITH_NULL_GOSTR3411           = 0x0083
	SSL_RSA_FIPS_WITH_DES_CBC_SHA                 = 0xfefe
	SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA            = 0xfeff
	SSL_CK_RC4_128_WITH_MD5                       = 0x010080
	SSL_CK_RC4_128_EXPORT40_WITH_MD5              = 0x020080
	SSL_CK_RC2_128_CBC_WITH_MD5                   = 0x030080
	SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5          = 0x040080
	SSL_CK_IDEA_128_CBC_WITH_MD5                  = 0x050080
	SSL_CK_DES_64_CBC_WITH_MD5                    = 0x060040
	SSL_CK_DES_64_CBC_WITH_SHA                    = 0x060140
	SSL_CK_DES_192_EDE3_CBC_WITH_MD5              = 0x0700c0
	SSL_CK_DES_192_EDE3_CBC_WITH_SHA              = 0x0701c0
	SSL_CK_RC4_64_WITH_MD5                        = 0x080080
	SSL_CK_DES_64_CFB64_WITH_MD5_1                = 0xff0800
	SSL_CK_NULL                                   = 0xff0810
)

type Suit struct {
	Name         string
	Protocol     Protocol
	KeyAgreement KeyAgreement
	Cipher       Cipher
	Hash         Hash
}

var Suits = map[int]Suit{
	TLS_NULL_WITH_NULL_NULL:                       {Name: "TLS_NULL_WITH_NULL_NULL", Protocol: TLS, KeyAgreement: NULL_KeyAgreement, Cipher: NULL_Cipher, Hash: NULL_Hash},
	TLS_RSA_WITH_NULL_MD5:                         {Name: "TLS_RSA_WITH_NULL_MD5", Protocol: TLS, KeyAgreement: RSA, Cipher: NULL_Cipher, Hash: MD5},
	TLS_RSA_WITH_NULL_SHA:                         {Name: "TLS_RSA_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: NULL_Cipher, Hash: SHA},
	TLS_RSA_EXPORT_WITH_RC4_40_MD5:                {Name: "TLS_RSA_EXPORT_WITH_RC4_40_MD5", Protocol: TLS, KeyAgreement: RSA_EXPORT, Cipher: RC4_40, Hash: MD5},
	TLS_RSA_WITH_RC4_128_MD5:                      {Name: "TLS_RSA_WITH_RC4_128_MD5", Protocol: TLS, KeyAgreement: RSA, Cipher: RC4_128, Hash: MD5},
	TLS_RSA_WITH_RC4_128_SHA:                      {Name: "TLS_RSA_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: RC4_128, Hash: SHA},
	TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5:            {Name: "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5", Protocol: TLS, KeyAgreement: RSA_EXPORT, Cipher: RC2_CBC_40, Hash: MD5},
	TLS_RSA_WITH_IDEA_CBC_SHA:                     {Name: "TLS_RSA_WITH_IDEA_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: IDEA_CBC, Hash: SHA},
	TLS_RSA_EXPORT_WITH_DES40_CBC_SHA:             {Name: "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: RSA_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_RSA_WITH_DES_CBC_SHA:                      {Name: "TLS_RSA_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: DES_CBC, Hash: SHA},
	TLS_RSA_WITH_3DES_EDE_CBC_SHA:                 {Name: "TLS_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA:          {Name: "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_DES_CBC_SHA:                   {Name: "TLS_DH_DSS_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: DES_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA:              {Name: "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA:          {Name: "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_DES_CBC_SHA:                   {Name: "TLS_DH_RSA_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: DES_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA:              {Name: "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA:         {Name: "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_DES_CBC_SHA:                  {Name: "TLS_DHE_DSS_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: DES_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA:         {Name: "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_DES_CBC_SHA:                  {Name: "TLS_DHE_RSA_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: DES_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DH_anon_EXPORT_WITH_RC4_40_MD5:            {Name: "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5", Protocol: TLS, KeyAgreement: DH_anon_EXPORT, Cipher: RC4_40, Hash: MD5},
	TLS_DH_anon_WITH_RC4_128_MD5:                  {Name: "TLS_DH_anon_WITH_RC4_128_MD5", Protocol: TLS, KeyAgreement: DH_anon, Cipher: RC4_128, Hash: MD5},
	TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA:         {Name: "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon_EXPORT, Cipher: DES40_CBC, Hash: SHA},
	TLS_DH_anon_WITH_DES_CBC_SHA:                  {Name: "TLS_DH_anon_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: DES_CBC, Hash: SHA},
	TLS_DH_anon_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_KRB5_WITH_DES_CBC_SHA:                     {Name: "TLS_KRB5_WITH_DES_CBC_SHA", Protocol: TLS, KeyAgreement: KRB5, Cipher: DES_CBC, Hash: SHA},
	TLS_KRB5_WITH_3DES_EDE_CBC_SHA:                {Name: "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: KRB5, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_KRB5_WITH_RC4_128_SHA:                     {Name: "TLS_KRB5_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: KRB5, Cipher: RC4_128, Hash: SHA},
	TLS_KRB5_WITH_IDEA_CBC_SHA:                    {Name: "TLS_KRB5_WITH_IDEA_CBC_SHA", Protocol: TLS, KeyAgreement: KRB5, Cipher: IDEA_CBC, Hash: SHA},
	TLS_KRB5_WITH_DES_CBC_MD5:                     {Name: "TLS_KRB5_WITH_DES_CBC_MD5", Protocol: TLS, KeyAgreement: KRB5, Cipher: DES_CBC, Hash: MD5},
	TLS_KRB5_WITH_3DES_EDE_CBC_MD5:                {Name: "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", Protocol: TLS, KeyAgreement: KRB5, Cipher: _3DES_EDE_CBC, Hash: MD5},
	TLS_KRB5_WITH_RC4_128_MD5:                     {Name: "TLS_KRB5_WITH_RC4_128_MD5", Protocol: TLS, KeyAgreement: KRB5, Cipher: RC4_128, Hash: MD5},
	TLS_KRB5_WITH_IDEA_CBC_MD5:                    {Name: "TLS_KRB5_WITH_IDEA_CBC_MD5", Protocol: TLS, KeyAgreement: KRB5, Cipher: IDEA_CBC, Hash: MD5},
	TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA:           {Name: "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: DES_CBC_40, Hash: SHA},
	TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA:           {Name: "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: RC2_CBC_40, Hash: SHA},
	TLS_KRB5_EXPORT_WITH_RC4_40_SHA:               {Name: "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: RC4_40, Hash: SHA},
	TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5:           {Name: "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: DES_CBC_40, Hash: MD5},
	TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5:           {Name: "TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: RC2_CBC_40, Hash: MD5},
	TLS_KRB5_EXPORT_WITH_RC4_40_MD5:               {Name: "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", Protocol: TLS, KeyAgreement: KRB5_EXPORT, Cipher: RC4_40, Hash: MD5},
	TLS_PSK_WITH_NULL_SHA:                         {Name: "TLS_PSK_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: PSK, Cipher: NULL_Cipher, Hash: SHA},
	TLS_DHE_PSK_WITH_NULL_SHA:                     {Name: "TLS_DHE_PSK_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: NULL_Cipher, Hash: SHA},
	TLS_RSA_PSK_WITH_NULL_SHA:                     {Name: "TLS_RSA_PSK_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: NULL_Cipher, Hash: SHA},
	TLS_RSA_WITH_AES_128_CBC_SHA:                  {Name: "TLS_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_AES_128_CBC_SHA:               {Name: "TLS_DH_DSS_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_AES_128_CBC_SHA:               {Name: "TLS_DH_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_AES_128_CBC_SHA:              {Name: "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_AES_128_CBC_SHA:              {Name: "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DH_anon_WITH_AES_128_CBC_SHA:              {Name: "TLS_DH_anon_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_128_CBC, Hash: SHA},
	TLS_RSA_WITH_AES_256_CBC_SHA:                  {Name: "TLS_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_AES_256_CBC_SHA:               {Name: "TLS_DH_DSS_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_AES_256_CBC_SHA:               {Name: "TLS_DH_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_AES_256_CBC_SHA:              {Name: "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_AES_256_CBC_SHA:              {Name: "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DH_anon_WITH_AES_256_CBC_SHA:              {Name: "TLS_DH_anon_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_256_CBC, Hash: SHA},
	TLS_RSA_WITH_NULL_SHA256:                      {Name: "TLS_RSA_WITH_NULL_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: NULL_Cipher, Hash: SHA256},
	TLS_RSA_WITH_AES_128_CBC_SHA256:               {Name: "TLS_RSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_RSA_WITH_AES_256_CBC_SHA256:               {Name: "TLS_RSA_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_DH_DSS_WITH_AES_128_CBC_SHA256:            {Name: "TLS_DH_DSS_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_DH_RSA_WITH_AES_128_CBC_SHA256:            {Name: "TLS_DH_RSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_DHE_DSS_WITH_AES_128_CBC_SHA256:           {Name: "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_RSA_WITH_CAMELLIA_128_CBC_SHA:             {Name: "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA:          {Name: "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA:          {Name: "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA:         {Name: "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA:         {Name: "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA:         {Name: "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_128_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_AES_128_CBC_SHA256:           {Name: "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_DH_DSS_WITH_AES_256_CBC_SHA256:            {Name: "TLS_DH_DSS_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_DH_RSA_WITH_AES_256_CBC_SHA256:            {Name: "TLS_DH_RSA_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_DHE_DSS_WITH_AES_256_CBC_SHA256:           {Name: "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_DHE_RSA_WITH_AES_256_CBC_SHA256:           {Name: "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_DH_anon_WITH_AES_128_CBC_SHA256:           {Name: "TLS_DH_anon_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_DH_anon_WITH_AES_256_CBC_SHA256:           {Name: "TLS_DH_anon_WITH_AES_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_256_CBC, Hash: SHA256},
	TLS_RSA_WITH_CAMELLIA_256_CBC_SHA:             {Name: "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA:          {Name: "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA:          {Name: "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA:         {Name: "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA:         {Name: "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA:         {Name: "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_256_CBC, Hash: SHA},
	TLS_PSK_WITH_RC4_128_SHA:                      {Name: "TLS_PSK_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: PSK, Cipher: RC4_128, Hash: SHA},
	TLS_PSK_WITH_3DES_EDE_CBC_SHA:                 {Name: "TLS_PSK_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: PSK, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_PSK_WITH_AES_128_CBC_SHA:                  {Name: "TLS_PSK_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_128_CBC, Hash: SHA},
	TLS_PSK_WITH_AES_256_CBC_SHA:                  {Name: "TLS_PSK_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_256_CBC, Hash: SHA},
	TLS_DHE_PSK_WITH_RC4_128_SHA:                  {Name: "TLS_DHE_PSK_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: RC4_128, Hash: SHA},
	TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_DHE_PSK_WITH_AES_128_CBC_SHA:              {Name: "TLS_DHE_PSK_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_128_CBC, Hash: SHA},
	TLS_DHE_PSK_WITH_AES_256_CBC_SHA:              {Name: "TLS_DHE_PSK_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_256_CBC, Hash: SHA},
	TLS_RSA_PSK_WITH_RC4_128_SHA:                  {Name: "TLS_RSA_PSK_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: RC4_128, Hash: SHA},
	TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_RSA_PSK_WITH_AES_128_CBC_SHA:              {Name: "TLS_RSA_PSK_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_128_CBC, Hash: SHA},
	TLS_RSA_PSK_WITH_AES_256_CBC_SHA:              {Name: "TLS_RSA_PSK_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_256_CBC, Hash: SHA},
	TLS_RSA_WITH_SEED_CBC_SHA:                     {Name: "TLS_RSA_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: RSA, Cipher: SEED_CBC, Hash: SHA},
	TLS_DH_DSS_WITH_SEED_CBC_SHA:                  {Name: "TLS_DH_DSS_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: SEED_CBC, Hash: SHA},
	TLS_DH_RSA_WITH_SEED_CBC_SHA:                  {Name: "TLS_DH_RSA_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: SEED_CBC, Hash: SHA},
	TLS_DHE_DSS_WITH_SEED_CBC_SHA:                 {Name: "TLS_DHE_DSS_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: SEED_CBC, Hash: SHA},
	TLS_DHE_RSA_WITH_SEED_CBC_SHA:                 {Name: "TLS_DHE_RSA_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: SEED_CBC, Hash: SHA},
	TLS_DH_anon_WITH_SEED_CBC_SHA:                 {Name: "TLS_DH_anon_WITH_SEED_CBC_SHA", Protocol: TLS, KeyAgreement: DH_anon, Cipher: SEED_CBC, Hash: SHA},
	TLS_RSA_WITH_AES_128_GCM_SHA256:               {Name: "TLS_RSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_RSA_WITH_AES_256_GCM_SHA384:               {Name: "TLS_RSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DHE_RSA_WITH_AES_128_GCM_SHA256:           {Name: "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DHE_RSA_WITH_AES_256_GCM_SHA384:           {Name: "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DH_RSA_WITH_AES_128_GCM_SHA256:            {Name: "TLS_DH_RSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DH_RSA_WITH_AES_256_GCM_SHA384:            {Name: "TLS_DH_RSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DHE_DSS_WITH_AES_128_GCM_SHA256:           {Name: "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DHE_DSS_WITH_AES_256_GCM_SHA384:           {Name: "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DH_DSS_WITH_AES_128_GCM_SHA256:            {Name: "TLS_DH_DSS_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DH_DSS_WITH_AES_256_GCM_SHA384:            {Name: "TLS_DH_DSS_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DH_anon_WITH_AES_128_GCM_SHA256:           {Name: "TLS_DH_anon_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DH_anon_WITH_AES_256_GCM_SHA384:           {Name: "TLS_DH_anon_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_anon, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_PSK_WITH_AES_128_GCM_SHA256:               {Name: "TLS_PSK_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_PSK_WITH_AES_256_GCM_SHA384:               {Name: "TLS_PSK_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_DHE_PSK_WITH_AES_128_GCM_SHA256:           {Name: "TLS_DHE_PSK_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_DHE_PSK_WITH_AES_256_GCM_SHA384:           {Name: "TLS_DHE_PSK_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_RSA_PSK_WITH_AES_128_GCM_SHA256:           {Name: "TLS_RSA_PSK_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_RSA_PSK_WITH_AES_256_GCM_SHA384:           {Name: "TLS_RSA_PSK_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_PSK_WITH_AES_128_CBC_SHA256:               {Name: "TLS_PSK_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_PSK_WITH_AES_256_CBC_SHA384:               {Name: "TLS_PSK_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_PSK_WITH_NULL_SHA256:                      {Name: "TLS_PSK_WITH_NULL_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: NULL_Cipher, Hash: SHA256},
	TLS_PSK_WITH_NULL_SHA384:                      {Name: "TLS_PSK_WITH_NULL_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: NULL_Cipher, Hash: SHA384},
	TLS_DHE_PSK_WITH_AES_128_CBC_SHA256:           {Name: "TLS_DHE_PSK_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_DHE_PSK_WITH_AES_256_CBC_SHA384:           {Name: "TLS_DHE_PSK_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_DHE_PSK_WITH_NULL_SHA256:                  {Name: "TLS_DHE_PSK_WITH_NULL_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: NULL_Cipher, Hash: SHA256},
	TLS_DHE_PSK_WITH_NULL_SHA384:                  {Name: "TLS_DHE_PSK_WITH_NULL_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: NULL_Cipher, Hash: SHA384},
	TLS_RSA_PSK_WITH_AES_128_CBC_SHA256:           {Name: "TLS_RSA_PSK_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_RSA_PSK_WITH_AES_256_CBC_SHA384:           {Name: "TLS_RSA_PSK_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_RSA_PSK_WITH_NULL_SHA256:                  {Name: "TLS_RSA_PSK_WITH_NULL_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: NULL_Cipher, Hash: SHA256},
	TLS_RSA_PSK_WITH_NULL_SHA384:                  {Name: "TLS_RSA_PSK_WITH_NULL_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: NULL_Cipher, Hash: SHA384},
	TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256:          {Name: "TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256:       {Name: "TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256:       {Name: "TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256:      {Name: "TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256:      {Name: "TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256:      {Name: "TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256:          {Name: "TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256:       {Name: "TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256:       {Name: "TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256:      {Name: "TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256:      {Name: "TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256:      {Name: "TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_256_CBC, Hash: SHA256},
	TLS_SM4_GCM_SM3:                               {Name: "TLS_SM4_GCM_SM3", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_SM4_CCM_SM3:                               {Name: "TLS_SM4_CCM_SM3", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_EMPTY_RENEGOTIATION_INFO_SCSV:             {Name: "TLS_EMPTY_RENEGOTIATION_INFO_SCSV", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AES_128_GCM_SHA256:                        {Name: "TLS_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AES_256_GCM_SHA384:                        {Name: "TLS_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_CHACHA20_POLY1305_SHA256:                  {Name: "TLS_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AES_128_CCM_SHA256:                        {Name: "TLS_AES_128_CCM_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AES_128_CCM_8_SHA256:                      {Name: "TLS_AES_128_CCM_8_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AEGIS_256_SHA384:                          {Name: "TLS_AEGIS_256_SHA384", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_AEGIS_128L_SHA256:                         {Name: "TLS_AEGIS_128L_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_FALLBACK_SCSV:                             {Name: "TLS_FALLBACK_SCSV", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDH_ECDSA_WITH_NULL_SHA:                  {Name: "TLS_ECDH_ECDSA_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDH_ECDSA_WITH_RC4_128_SHA:               {Name: "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: RC4_128, Hash: SHA},
	TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA:          {Name: "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA:           {Name: "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA:           {Name: "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_NULL_SHA:                 {Name: "TLS_ECDHE_ECDSA_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_RC4_128_SHA:              {Name: "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: RC4_128, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA:         {Name: "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA:          {Name: "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA:          {Name: "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDH_RSA_WITH_NULL_SHA:                    {Name: "TLS_ECDH_RSA_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDH_RSA_WITH_RC4_128_SHA:                 {Name: "TLS_ECDH_RSA_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: RC4_128, Hash: SHA},
	TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA:            {Name: "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDH_RSA_WITH_AES_128_CBC_SHA:             {Name: "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDH_RSA_WITH_AES_256_CBC_SHA:             {Name: "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDHE_RSA_WITH_NULL_SHA:                   {Name: "TLS_ECDHE_RSA_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDHE_RSA_WITH_RC4_128_SHA:                {Name: "TLS_ECDHE_RSA_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: RC4_128, Hash: SHA},
	TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA:           {Name: "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA:            {Name: "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA:            {Name: "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDH_anon_WITH_NULL_SHA:                   {Name: "TLS_ECDH_anon_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDH_anon, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDH_anon_WITH_RC4_128_SHA:                {Name: "TLS_ECDH_anon_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDH_anon, Cipher: RC4_128, Hash: SHA},
	TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA:           {Name: "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_anon, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDH_anon_WITH_AES_128_CBC_SHA:            {Name: "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_anon, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDH_anon_WITH_AES_256_CBC_SHA:            {Name: "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDH_anon, Cipher: AES_256_CBC, Hash: SHA},
	TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA:             {Name: "TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA:         {Name: "TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_RSA, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA:         {Name: "TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_DSS, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_SRP_SHA_WITH_AES_128_CBC_SHA:              {Name: "TLS_SRP_SHA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA:          {Name: "TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_RSA, Cipher: AES_128_CBC, Hash: SHA},
	TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA:          {Name: "TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_DSS, Cipher: AES_128_CBC, Hash: SHA},
	TLS_SRP_SHA_WITH_AES_256_CBC_SHA:              {Name: "TLS_SRP_SHA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA:          {Name: "TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_RSA, Cipher: AES_256_CBC, Hash: SHA},
	TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA:          {Name: "TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: SRP_SHA_DSS, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256:       {Name: "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384:       {Name: "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256:        {Name: "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384:        {Name: "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256:         {Name: "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384:         {Name: "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256:          {Name: "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384:          {Name: "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256:       {Name: "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384:       {Name: "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256:        {Name: "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384:        {Name: "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256:         {Name: "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384:         {Name: "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256:          {Name: "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384:          {Name: "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECDHE_PSK_WITH_RC4_128_SHA:                {Name: "TLS_ECDHE_PSK_WITH_RC4_128_SHA", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: RC4_128, Hash: SHA},
	TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA:           {Name: "TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: _3DES_EDE_CBC, Hash: SHA},
	TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA:            {Name: "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_128_CBC, Hash: SHA},
	TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA:            {Name: "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_256_CBC, Hash: SHA},
	TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256:         {Name: "TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_128_CBC, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384:         {Name: "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_256_CBC, Hash: SHA384},
	TLS_ECDHE_PSK_WITH_NULL_SHA:                   {Name: "TLS_ECDHE_PSK_WITH_NULL_SHA", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: NULL_Cipher, Hash: SHA},
	TLS_ECDHE_PSK_WITH_NULL_SHA256:                {Name: "TLS_ECDHE_PSK_WITH_NULL_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: NULL_Cipher, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_NULL_SHA384:                {Name: "TLS_ECDHE_PSK_WITH_NULL_SHA384", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: NULL_Cipher, Hash: SHA384},
	TLS_RSA_WITH_ARIA_128_CBC_SHA256:              {Name: "TLS_RSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_RSA_WITH_ARIA_256_CBC_SHA384:              {Name: "TLS_RSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: RSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256:           {Name: "TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384:           {Name: "TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256:           {Name: "TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384:           {Name: "TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256:          {Name: "TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384:          {Name: "TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256:          {Name: "TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384:          {Name: "TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DH_anon_WITH_ARIA_128_CBC_SHA256:          {Name: "TLS_DH_anon_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DH_anon_WITH_ARIA_256_CBC_SHA384:          {Name: "TLS_DH_anon_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DH_anon, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256:      {Name: "TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384:      {Name: "TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256:       {Name: "TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384:       {Name: "TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256:        {Name: "TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384:        {Name: "TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256:         {Name: "TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384:         {Name: "TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_RSA_WITH_ARIA_128_GCM_SHA256:              {Name: "TLS_RSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_RSA_WITH_ARIA_256_GCM_SHA384:              {Name: "TLS_RSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256:          {Name: "TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384:          {Name: "TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256:           {Name: "TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384:           {Name: "TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256:          {Name: "TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384:          {Name: "TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256:           {Name: "TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384:           {Name: "TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DH_anon_WITH_ARIA_128_GCM_SHA256:          {Name: "TLS_DH_anon_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DH_anon_WITH_ARIA_256_GCM_SHA384:          {Name: "TLS_DH_anon_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_anon, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256:      {Name: "TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384:      {Name: "TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256:       {Name: "TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384:       {Name: "TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256:        {Name: "TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384:        {Name: "TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256:         {Name: "TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384:         {Name: "TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_PSK_WITH_ARIA_128_CBC_SHA256:              {Name: "TLS_PSK_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_PSK_WITH_ARIA_256_CBC_SHA384:              {Name: "TLS_PSK_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256:          {Name: "TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384:          {Name: "TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256:          {Name: "TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384:          {Name: "TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_PSK_WITH_ARIA_128_GCM_SHA256:              {Name: "TLS_PSK_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_PSK_WITH_ARIA_256_GCM_SHA384:              {Name: "TLS_PSK_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256:          {Name: "TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384:          {Name: "TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256:          {Name: "TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: ARIA_128_GCM, Hash: SHA256},
	TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384:          {Name: "TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: ARIA_256_GCM, Hash: SHA384},
	TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256:        {Name: "TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: ARIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384:        {Name: "TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: ARIA_256_CBC, Hash: SHA384},
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256:  {Name: "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384:  {Name: "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256:   {Name: "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384:   {Name: "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256:    {Name: "TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384:    {Name: "TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256:     {Name: "TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384:     {Name: "TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256:          {Name: "TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384:          {Name: "TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256:      {Name: "TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384:      {Name: "TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256:       {Name: "TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384:       {Name: "TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_RSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256:      {Name: "TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384:      {Name: "TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_DSS, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256:       {Name: "TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384:       {Name: "TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_DSS, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256:      {Name: "TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384:      {Name: "TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DH_anon, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256:  {Name: "TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384:  {Name: "TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256:   {Name: "TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384:   {Name: "TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_ECDSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256:    {Name: "TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384:    {Name: "TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256:     {Name: "TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384:     {Name: "TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDH_RSA, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256:          {Name: "TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384:          {Name: "TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256:      {Name: "TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384:      {Name: "TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256:      {Name: "TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: CAMELLIA_128_GCM, Hash: SHA256},
	TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384:      {Name: "TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: CAMELLIA_256_GCM, Hash: SHA384},
	TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256:          {Name: "TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384:          {Name: "TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: PSK, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256:      {Name: "TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384:      {Name: "TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256:      {Name: "TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384:      {Name: "TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256:    {Name: "TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: CAMELLIA_128_CBC, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384:    {Name: "TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: CAMELLIA_256_CBC, Hash: SHA384},
	TLS_RSA_WITH_AES_128_CCM:                      {Name: "TLS_RSA_WITH_AES_128_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_RSA_WITH_AES_256_CCM:                      {Name: "TLS_RSA_WITH_AES_256_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_RSA_WITH_AES_128_CCM:                  {Name: "TLS_DHE_RSA_WITH_AES_128_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_RSA_WITH_AES_256_CCM:                  {Name: "TLS_DHE_RSA_WITH_AES_256_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_RSA_WITH_AES_128_CCM_8:                    {Name: "TLS_RSA_WITH_AES_128_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_RSA_WITH_AES_256_CCM_8:                    {Name: "TLS_RSA_WITH_AES_256_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_RSA_WITH_AES_128_CCM_8:                {Name: "TLS_DHE_RSA_WITH_AES_128_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_RSA_WITH_AES_256_CCM_8:                {Name: "TLS_DHE_RSA_WITH_AES_256_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_WITH_AES_128_CCM:                      {Name: "TLS_PSK_WITH_AES_128_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_WITH_AES_256_CCM:                      {Name: "TLS_PSK_WITH_AES_256_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_PSK_WITH_AES_128_CCM:                  {Name: "TLS_DHE_PSK_WITH_AES_128_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_DHE_PSK_WITH_AES_256_CCM:                  {Name: "TLS_DHE_PSK_WITH_AES_256_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_WITH_AES_128_CCM_8:                    {Name: "TLS_PSK_WITH_AES_128_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_WITH_AES_256_CCM_8:                    {Name: "TLS_PSK_WITH_AES_256_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_DHE_WITH_AES_128_CCM_8:                {Name: "TLS_PSK_DHE_WITH_AES_128_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_PSK_DHE_WITH_AES_256_CCM_8:                {Name: "TLS_PSK_DHE_WITH_AES_256_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDHE_ECDSA_WITH_AES_128_CCM:              {Name: "TLS_ECDHE_ECDSA_WITH_AES_128_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDHE_ECDSA_WITH_AES_256_CCM:              {Name: "TLS_ECDHE_ECDSA_WITH_AES_256_CCM", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8:            {Name: "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8:            {Name: "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECCPWD_WITH_AES_128_GCM_SHA256:            {Name: "TLS_ECCPWD_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECCPWD, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECCPWD_WITH_AES_256_GCM_SHA384:            {Name: "TLS_ECCPWD_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECCPWD, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECCPWD_WITH_AES_128_CCM_SHA256:            {Name: "TLS_ECCPWD_WITH_AES_128_CCM_SHA256", Protocol: TLS, KeyAgreement: ECCPWD, Cipher: AES_128_CCM, Hash: SHA256},
	TLS_ECCPWD_WITH_AES_256_CCM_SHA384:            {Name: "TLS_ECCPWD_WITH_AES_256_CCM_SHA384", Protocol: TLS, KeyAgreement: ECCPWD, Cipher: AES_256_CCM, Hash: SHA384},
	TLS_SHA256_SHA256:                             {Name: "TLS_SHA256_SHA256", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_SHA384_SHA384:                             {Name: "TLS_SHA384_SHA384", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC:  {Name: "TLS_GOSTR341112_256_WITH_KUZNYECHIK_CTR_OMAC", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC:       {Name: "TLS_GOSTR341112_256_WITH_MAGMA_CTR_OMAC", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_28147_CNT_IMIT:       {Name: "TLS_GOSTR341112_256_WITH_28147_CNT_IMIT", Protocol: TLS, KeyAgreement: GOSTR341112_256, Cipher: _28147_CNT, Hash: IMIT},
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L:     {Name: "TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_L", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_MAGMA_MGM_L:          {Name: "TLS_GOSTR341112_256_WITH_MAGMA_MGM_L", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S:     {Name: "TLS_GOSTR341112_256_WITH_KUZNYECHIK_MGM_S", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_GOSTR341112_256_WITH_MAGMA_MGM_S:          {Name: "TLS_GOSTR341112_256_WITH_MAGMA_MGM_S", Protocol: TLS, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256:   {Name: "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: ECDHE_RSA, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256: {Name: "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: ECDHE_ECDSA, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256:     {Name: "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: DHE_RSA, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_PSK_WITH_CHACHA20_POLY1305_SHA256:         {Name: "TLS_PSK_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: PSK, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256:   {Name: "TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256:     {Name: "TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: DHE_PSK, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256:     {Name: "TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256", Protocol: TLS, KeyAgreement: RSA_PSK, Cipher: CHACHA20_POLY1305, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256:         {Name: "TLS_ECDHE_PSK_WITH_AES_128_GCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_128_GCM, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384:         {Name: "TLS_ECDHE_PSK_WITH_AES_256_GCM_SHA384", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_256_GCM, Hash: SHA384},
	TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256:       {Name: "TLS_ECDHE_PSK_WITH_AES_128_CCM_8_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_128_CCM_8, Hash: SHA256},
	TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256:         {Name: "TLS_ECDHE_PSK_WITH_AES_128_CCM_SHA256", Protocol: TLS, KeyAgreement: ECDHE_PSK, Cipher: AES_128_CCM, Hash: SHA256},
	TLS_GOSTR341094_WITH_28147_CNT_IMIT:           {Name: "TLS_GOSTR341094_WITH_28147_CNT_IMIT", Protocol: TLS, KeyAgreement: GOSTR341094, Cipher: _28147_CNT, Hash: IMIT},
	TLS_GOSTR341001_WITH_28147_CNT_IMIT:           {Name: "TLS_GOSTR341001_WITH_28147_CNT_IMIT", Protocol: TLS, KeyAgreement: GOSTR341001, Cipher: _28147_CNT, Hash: IMIT},
	TLS_GOSTR341094_WITH_NULL_GOSTR3411:           {Name: "TLS_GOSTR341094_WITH_NULL_GOSTR3411", Protocol: TLS, KeyAgreement: GOSTR341094, Cipher: NULL_Cipher, Hash: GOSTR3411},
	TLS_GOSTR341001_WITH_NULL_GOSTR3411:           {Name: "TLS_GOSTR341001_WITH_NULL_GOSTR3411", Protocol: TLS, KeyAgreement: GOSTR341001, Cipher: NULL_Cipher, Hash: GOSTR3411},
	SSL_RSA_FIPS_WITH_DES_CBC_SHA:                 {Name: "SSL_RSA_FIPS_WITH_DES_CBC_SHA", Protocol: SSL, KeyAgreement: RSA_FIPS, Cipher: DES_CBC, Hash: SHA},
	SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA:            {Name: "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", Protocol: SSL, KeyAgreement: RSA_FIPS, Cipher: _3DES_EDE_CBC, Hash: SHA},
	SSL_CK_RC4_128_WITH_MD5:                       {Name: "SSL_CK_RC4_128_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_RC4_128_EXPORT40_WITH_MD5:              {Name: "SSL_CK_RC4_128_EXPORT40_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_RC2_128_CBC_WITH_MD5:                   {Name: "SSL_CK_RC2_128_CBC_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5:          {Name: "SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_IDEA_128_CBC_WITH_MD5:                  {Name: "SSL_CK_IDEA_128_CBC_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_DES_64_CBC_WITH_MD5:                    {Name: "SSL_CK_DES_64_CBC_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_DES_64_CBC_WITH_SHA:                    {Name: "SSL_CK_DES_64_CBC_WITH_SHA", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_DES_192_EDE3_CBC_WITH_MD5:              {Name: "SSL_CK_DES_192_EDE3_CBC_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_DES_192_EDE3_CBC_WITH_SHA:              {Name: "SSL_CK_DES_192_EDE3_CBC_WITH_SHA", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_RC4_64_WITH_MD5:                        {Name: "SSL_CK_RC4_64_WITH_MD5", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_DES_64_CFB64_WITH_MD5_1:                {Name: "SSL_CK_DES_64_CFB64_WITH_MD5_1", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
	SSL_CK_NULL:                                   {Name: "SSL_CK_NULL", Protocol: SSL, KeyAgreement: UNKNOWN_KeyAgreement, Cipher: UNKNOWN_Cipher, Hash: UNKNOWN_Hash},
}
