// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package gql

import (
	"context"

	"github.com/Khan/genqlient/graphql"
)

type AddOnType string

const (
	// A Redis database
	AddOnTypeRedis AddOnType = "redis"
)

// AgentGetInstancesApp includes the requested fields of the GraphQL type App.
type AgentGetInstancesApp struct {
	// Organization that owns this app
	Organization AgentGetInstancesAppOrganization `json:"organization"`
	// Unique application ID
	Id string `json:"id"`
	// The unique application name
	Name        string                                        `json:"name"`
	Allocations []AgentGetInstancesAppAllocationsAllocation   `json:"allocations"`
	Machines    AgentGetInstancesAppMachinesMachineConnection `json:"machines"`
}

// GetOrganization returns AgentGetInstancesApp.Organization, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetOrganization() AgentGetInstancesAppOrganization {
	return v.Organization
}

// GetId returns AgentGetInstancesApp.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetId() string { return v.Id }

// GetName returns AgentGetInstancesApp.Name, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetName() string { return v.Name }

// GetAllocations returns AgentGetInstancesApp.Allocations, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetAllocations() []AgentGetInstancesAppAllocationsAllocation {
	return v.Allocations
}

// GetMachines returns AgentGetInstancesApp.Machines, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesApp) GetMachines() AgentGetInstancesAppMachinesMachineConnection {
	return v.Machines
}

// AgentGetInstancesAppAllocationsAllocation includes the requested fields of the GraphQL type Allocation.
type AgentGetInstancesAppAllocationsAllocation struct {
	// Unique ID for this instance
	Id string `json:"id"`
	// Region this allocation is running in
	Region string `json:"region"`
	// Private IPv6 address for this instance
	PrivateIP string `json:"privateIP"`
}

// GetId returns AgentGetInstancesAppAllocationsAllocation.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetId() string { return v.Id }

// GetRegion returns AgentGetInstancesAppAllocationsAllocation.Region, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetRegion() string { return v.Region }

// GetPrivateIP returns AgentGetInstancesAppAllocationsAllocation.PrivateIP, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppAllocationsAllocation) GetPrivateIP() string { return v.PrivateIP }

// AgentGetInstancesAppMachinesMachineConnection includes the requested fields of the GraphQL type MachineConnection.
// The GraphQL type's documentation follows.
//
// The connection type for Machine.
type AgentGetInstancesAppMachinesMachineConnection struct {
	// A list of nodes.
	Nodes []AgentGetInstancesAppMachinesMachineConnectionNodesMachine `json:"nodes"`
}

// GetNodes returns AgentGetInstancesAppMachinesMachineConnection.Nodes, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnection) GetNodes() []AgentGetInstancesAppMachinesMachineConnectionNodesMachine {
	return v.Nodes
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachine includes the requested fields of the GraphQL type Machine.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachine struct {
	Id     string                                                                          `json:"id"`
	Region string                                                                          `json:"region"`
	Ips    AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection `json:"ips"`
}

// GetId returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Id, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetId() string { return v.Id }

// GetRegion returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Region, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetRegion() string {
	return v.Region
}

// GetIps returns AgentGetInstancesAppMachinesMachineConnectionNodesMachine.Ips, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachine) GetIps() AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection {
	return v.Ips
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection includes the requested fields of the GraphQL type MachineIPConnection.
// The GraphQL type's documentation follows.
//
// The connection type for MachineIP.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection struct {
	// A list of nodes.
	Nodes []AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP `json:"nodes"`
}

// GetNodes returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection.Nodes, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnection) GetNodes() []AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP {
	return v.Nodes
}

// AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP includes the requested fields of the GraphQL type MachineIP.
type AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP struct {
	Kind   string `json:"kind"`
	Family string `json:"family"`
	Ip     string `json:"ip"`
}

// GetKind returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Kind, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetKind() string {
	return v.Kind
}

// GetFamily returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Family, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetFamily() string {
	return v.Family
}

// GetIp returns AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP.Ip, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppMachinesMachineConnectionNodesMachineIpsMachineIPConnectionNodesMachineIP) GetIp() string {
	return v.Ip
}

// AgentGetInstancesAppOrganization includes the requested fields of the GraphQL type Organization.
type AgentGetInstancesAppOrganization struct {
	// Unique organization slug
	Slug string `json:"slug"`
}

// GetSlug returns AgentGetInstancesAppOrganization.Slug, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesAppOrganization) GetSlug() string { return v.Slug }

// AgentGetInstancesResponse is returned by AgentGetInstances on success.
type AgentGetInstancesResponse struct {
	// Find an app by name
	App AgentGetInstancesApp `json:"app"`
}

// GetApp returns AgentGetInstancesResponse.App, and is useful for accessing the field via an interface.
func (v *AgentGetInstancesResponse) GetApp() AgentGetInstancesApp { return v.App }

type BuildFinalImageInput struct {
	// Sha256 id of docker image
	Id string `json:"id"`
	// Size in bytes of the docker image
	SizeBytes int64 `json:"sizeBytes"`
	// Tag used for docker image
	Tag string `json:"tag"`
}

// GetId returns BuildFinalImageInput.Id, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetId() string { return v.Id }

// GetSizeBytes returns BuildFinalImageInput.SizeBytes, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetSizeBytes() int64 { return v.SizeBytes }

// GetTag returns BuildFinalImageInput.Tag, and is useful for accessing the field via an interface.
func (v *BuildFinalImageInput) GetTag() string { return v.Tag }

type BuildImageOptsInput struct {
	// Set of build time variables passed to cli
	BuildArgs interface{} `json:"buildArgs"`
	// Fly.toml build.buildpacks setting
	BuildPacks []string `json:"buildPacks"`
	// Fly.toml build.builder setting
	Builder string `json:"builder"`
	// Builtin builder to use
	BuiltIn string `json:"builtIn"`
	// Builtin builder settings
	BuiltInSettings interface{} `json:"builtInSettings"`
	// Path to dockerfile, if one exists
	DockerfilePath string `json:"dockerfilePath"`
	// Unused in cli?
	ExtraBuildArgs interface{} `json:"extraBuildArgs"`
	// Image label to use when tagging and pushing to the fly registry
	ImageLabel string `json:"imageLabel"`
	// Unused in cli?
	ImageRef string `json:"imageRef"`
	// Do not use the build cache when building the image
	NoCache bool `json:"noCache"`
	// Whether publishing to the registry was requested
	Publish bool `json:"publish"`
	// Docker tag used to publish image to registry
	Tag string `json:"tag"`
	// Set the target build stage to build if the Dockerfile has more than one stage
	Target string `json:"target"`
}

// GetBuildArgs returns BuildImageOptsInput.BuildArgs, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuildArgs() interface{} { return v.BuildArgs }

// GetBuildPacks returns BuildImageOptsInput.BuildPacks, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuildPacks() []string { return v.BuildPacks }

// GetBuilder returns BuildImageOptsInput.Builder, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuilder() string { return v.Builder }

// GetBuiltIn returns BuildImageOptsInput.BuiltIn, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuiltIn() string { return v.BuiltIn }

// GetBuiltInSettings returns BuildImageOptsInput.BuiltInSettings, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetBuiltInSettings() interface{} { return v.BuiltInSettings }

// GetDockerfilePath returns BuildImageOptsInput.DockerfilePath, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetDockerfilePath() string { return v.DockerfilePath }

// GetExtraBuildArgs returns BuildImageOptsInput.ExtraBuildArgs, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetExtraBuildArgs() interface{} { return v.ExtraBuildArgs }

// GetImageLabel returns BuildImageOptsInput.ImageLabel, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetImageLabel() string { return v.ImageLabel }

// GetImageRef returns BuildImageOptsInput.ImageRef, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetImageRef() string { return v.ImageRef }

// GetNoCache returns BuildImageOptsInput.NoCache, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetNoCache() bool { return v.NoCache }

// GetPublish returns BuildImageOptsInput.Publish, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetPublish() bool { return v.Publish }

// GetTag returns BuildImageOptsInput.Tag, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetTag() string { return v.Tag }

// GetTarget returns BuildImageOptsInput.Target, and is useful for accessing the field via an interface.
func (v *BuildImageOptsInput) GetTarget() string { return v.Target }

type BuildStrategyAttemptInput struct {
	// Optional error message from strategy
	Error string `json:"error"`
	// Optional note about this strategy or its result
	Note string `json:"note"`
	// Result attempting this strategy
	Result string `json:"result"`
	// Build strategy attempted
	Strategy string `json:"strategy"`
}

// GetError returns BuildStrategyAttemptInput.Error, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetError() string { return v.Error }

// GetNote returns BuildStrategyAttemptInput.Note, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetNote() string { return v.Note }

// GetResult returns BuildStrategyAttemptInput.Result, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetResult() string { return v.Result }

// GetStrategy returns BuildStrategyAttemptInput.Strategy, and is useful for accessing the field via an interface.
func (v *BuildStrategyAttemptInput) GetStrategy() string { return v.Strategy }

type BuildTimingsInput struct {
	// Time to build and push the image, measured by flyctl
	BuildAndPushMs int64 `json:"buildAndPushMs"`
	// Time to build the image including create context, measured by flyctl
	BuildMs int64 `json:"buildMs"`
	// Time to initialize client used to connect to either remote or local builder
	BuilderInitMs int64 `json:"builderInitMs"`
	// Time to create the build context tar file, measured by flyctl
	ContextBuildMs int64 `json:"contextBuildMs"`
	// Time for builder to build image after receiving context, measured by flyctl
	ImageBuildMs int64 `json:"imageBuildMs"`
	// Time to push completed image to registry, measured by flyctl
	PushMs int64 `json:"pushMs"`
}

// GetBuildAndPushMs returns BuildTimingsInput.BuildAndPushMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuildAndPushMs() int64 { return v.BuildAndPushMs }

// GetBuildMs returns BuildTimingsInput.BuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuildMs() int64 { return v.BuildMs }

// GetBuilderInitMs returns BuildTimingsInput.BuilderInitMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetBuilderInitMs() int64 { return v.BuilderInitMs }

// GetContextBuildMs returns BuildTimingsInput.ContextBuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetContextBuildMs() int64 { return v.ContextBuildMs }

// GetImageBuildMs returns BuildTimingsInput.ImageBuildMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetImageBuildMs() int64 { return v.ImageBuildMs }

// GetPushMs returns BuildTimingsInput.PushMs, and is useful for accessing the field via an interface.
func (v *BuildTimingsInput) GetPushMs() int64 { return v.PushMs }

type BuilderMetaInput struct {
	// Local or remote builder type
	BuilderType string `json:"builderType"`
	// Whther or not buildkit is enabled on builder
	BuildkitEnabled bool `json:"buildkitEnabled"`
	// Docker version reported by builder
	DockerVersion string `json:"dockerVersion"`
	// Platform reported by the builder
	Platform string `json:"platform"`
	// Remote builder app used
	RemoteAppName string `json:"remoteAppName"`
	// Remote builder machine used
	RemoteMachineId string `json:"remoteMachineId"`
}

// GetBuilderType returns BuilderMetaInput.BuilderType, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetBuilderType() string { return v.BuilderType }

// GetBuildkitEnabled returns BuilderMetaInput.BuildkitEnabled, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetBuildkitEnabled() bool { return v.BuildkitEnabled }

// GetDockerVersion returns BuilderMetaInput.DockerVersion, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetDockerVersion() string { return v.DockerVersion }

// GetPlatform returns BuilderMetaInput.Platform, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetPlatform() string { return v.Platform }

// GetRemoteAppName returns BuilderMetaInput.RemoteAppName, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetRemoteAppName() string { return v.RemoteAppName }

// GetRemoteMachineId returns BuilderMetaInput.RemoteMachineId, and is useful for accessing the field via an interface.
func (v *BuilderMetaInput) GetRemoteMachineId() string { return v.RemoteMachineId }

// CreateAddOnCreateAddOnCreateAddOnPayload includes the requested fields of the GraphQL type CreateAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateAddOn
type CreateAddOnCreateAddOnCreateAddOnPayload struct {
	AddOn CreateAddOnCreateAddOnCreateAddOnPayloadAddOn `json:"addOn"`
}

// GetAddOn returns CreateAddOnCreateAddOnCreateAddOnPayload.AddOn, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayload) GetAddOn() CreateAddOnCreateAddOnCreateAddOnPayloadAddOn {
	return v.AddOn
}

// CreateAddOnCreateAddOnCreateAddOnPayloadAddOn includes the requested fields of the GraphQL type AddOn.
type CreateAddOnCreateAddOnCreateAddOnPayloadAddOn struct {
	// The service name according to the provider
	Name string `json:"name"`
	// Public URL for this service
	PublicUrl string `json:"publicUrl"`
}

// GetName returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.Name, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetName() string { return v.Name }

// GetPublicUrl returns CreateAddOnCreateAddOnCreateAddOnPayloadAddOn.PublicUrl, and is useful for accessing the field via an interface.
func (v *CreateAddOnCreateAddOnCreateAddOnPayloadAddOn) GetPublicUrl() string { return v.PublicUrl }

// CreateAddOnResponse is returned by CreateAddOn on success.
type CreateAddOnResponse struct {
	CreateAddOn CreateAddOnCreateAddOnCreateAddOnPayload `json:"createAddOn"`
}

// GetCreateAddOn returns CreateAddOnResponse.CreateAddOn, and is useful for accessing the field via an interface.
func (v *CreateAddOnResponse) GetCreateAddOn() CreateAddOnCreateAddOnCreateAddOnPayload {
	return v.CreateAddOn
}

// Autogenerated input type of CreateBuild
type CreateBuildInput struct {
	// The name of the app being built
	AppName string `json:"appName"`
	// Whether builder is remote or local
	BuilderType string `json:"builderType"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Options set for building image
	ImageOpts BuildImageOptsInput `json:"imageOpts"`
	// The ID of the machine being built (only set for machine builds)
	MachineId string `json:"machineId"`
	// List of available build strategies that will be attempted
	StrategiesAvailable []string `json:"strategiesAvailable"`
}

// GetAppName returns CreateBuildInput.AppName, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetAppName() string { return v.AppName }

// GetBuilderType returns CreateBuildInput.BuilderType, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetBuilderType() string { return v.BuilderType }

// GetClientMutationId returns CreateBuildInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetClientMutationId() string { return v.ClientMutationId }

// GetImageOpts returns CreateBuildInput.ImageOpts, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetImageOpts() BuildImageOptsInput { return v.ImageOpts }

// GetMachineId returns CreateBuildInput.MachineId, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetMachineId() string { return v.MachineId }

// GetStrategiesAvailable returns CreateBuildInput.StrategiesAvailable, and is useful for accessing the field via an interface.
func (v *CreateBuildInput) GetStrategiesAvailable() []string { return v.StrategiesAvailable }

// DeleteAddOnDeleteAddOnDeleteAddOnPayload includes the requested fields of the GraphQL type DeleteAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of DeleteAddOn
type DeleteAddOnDeleteAddOnDeleteAddOnPayload struct {
	DeletedAddOnName string `json:"deletedAddOnName"`
}

// GetDeletedAddOnName returns DeleteAddOnDeleteAddOnDeleteAddOnPayload.DeletedAddOnName, and is useful for accessing the field via an interface.
func (v *DeleteAddOnDeleteAddOnDeleteAddOnPayload) GetDeletedAddOnName() string {
	return v.DeletedAddOnName
}

// DeleteAddOnResponse is returned by DeleteAddOn on success.
type DeleteAddOnResponse struct {
	DeleteAddOn DeleteAddOnDeleteAddOnDeleteAddOnPayload `json:"deleteAddOn"`
}

// GetDeleteAddOn returns DeleteAddOnResponse.DeleteAddOn, and is useful for accessing the field via an interface.
func (v *DeleteAddOnResponse) GetDeleteAddOn() DeleteAddOnDeleteAddOnDeleteAddOnPayload {
	return v.DeleteAddOn
}

// Autogenerated input type of FinishBuild
type FinishBuildInput struct {
	// The name of the app being built
	AppName string `json:"appName"`
	// Build id returned by createBuild() mutation
	BuildId string `json:"buildId"`
	// Metadata about the builder
	BuilderMeta BuilderMetaInput `json:"builderMeta"`
	// A unique identifier for the client performing the mutation.
	ClientMutationId string `json:"clientMutationId"`
	// Information about the docker image that was built
	FinalImage BuildFinalImageInput `json:"finalImage"`
	// Log or error output
	Logs string `json:"logs"`
	// The ID of the machine being built (only set for machine builds)
	MachineId string `json:"machineId"`
	// Indicate whether build completed or failed
	Status string `json:"status"`
	// Build strategies attempted and their result, should be in order of attempt
	StrategiesAttempted []BuildStrategyAttemptInput `json:"strategiesAttempted"`
	// Timings for different phases of the build
	Timings BuildTimingsInput `json:"timings"`
}

// GetAppName returns FinishBuildInput.AppName, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetAppName() string { return v.AppName }

// GetBuildId returns FinishBuildInput.BuildId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetBuildId() string { return v.BuildId }

// GetBuilderMeta returns FinishBuildInput.BuilderMeta, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetBuilderMeta() BuilderMetaInput { return v.BuilderMeta }

// GetClientMutationId returns FinishBuildInput.ClientMutationId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetClientMutationId() string { return v.ClientMutationId }

// GetFinalImage returns FinishBuildInput.FinalImage, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetFinalImage() BuildFinalImageInput { return v.FinalImage }

// GetLogs returns FinishBuildInput.Logs, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetLogs() string { return v.Logs }

// GetMachineId returns FinishBuildInput.MachineId, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetMachineId() string { return v.MachineId }

// GetStatus returns FinishBuildInput.Status, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetStatus() string { return v.Status }

// GetStrategiesAttempted returns FinishBuildInput.StrategiesAttempted, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetStrategiesAttempted() []BuildStrategyAttemptInput {
	return v.StrategiesAttempted
}

// GetTimings returns FinishBuildInput.Timings, and is useful for accessing the field via an interface.
func (v *FinishBuildInput) GetTimings() BuildTimingsInput { return v.Timings }

// GetAddOnAddOn includes the requested fields of the GraphQL type AddOn.
type GetAddOnAddOn struct {
	Id string `json:"id"`
	// The service name according to the provider
	Name string `json:"name"`
	// Public URL for this service
	PublicUrl string `json:"publicUrl"`
	// Private flycast IP address of the add-on
	PrivateIp string `json:"privateIp"`
	// Password for the add-on
	Password string `json:"password"`
	// Region where the primary instance is deployed
	PrimaryRegion string `json:"primaryRegion"`
	// Regions where replica instances are deployed
	ReadRegions []string `json:"readRegions"`
	// Organization that owns this service
	Organization GetAddOnAddOnOrganization `json:"organization"`
	// The add-on plan
	AddOnPlan GetAddOnAddOnAddOnPlan `json:"addOnPlan"`
}

// GetId returns GetAddOnAddOn.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetId() string { return v.Id }

// GetName returns GetAddOnAddOn.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetName() string { return v.Name }

// GetPublicUrl returns GetAddOnAddOn.PublicUrl, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPublicUrl() string { return v.PublicUrl }

// GetPrivateIp returns GetAddOnAddOn.PrivateIp, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPrivateIp() string { return v.PrivateIp }

// GetPassword returns GetAddOnAddOn.Password, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPassword() string { return v.Password }

// GetPrimaryRegion returns GetAddOnAddOn.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetReadRegions returns GetAddOnAddOn.ReadRegions, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetReadRegions() []string { return v.ReadRegions }

// GetOrganization returns GetAddOnAddOn.Organization, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetOrganization() GetAddOnAddOnOrganization { return v.Organization }

// GetAddOnPlan returns GetAddOnAddOn.AddOnPlan, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOn) GetAddOnPlan() GetAddOnAddOnAddOnPlan { return v.AddOnPlan }

// GetAddOnAddOnAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type GetAddOnAddOnAddOnPlan struct {
	Id          string `json:"id"`
	Name        string `json:"name"`
	DisplayName string `json:"displayName"`
}

// GetId returns GetAddOnAddOnAddOnPlan.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetId() string { return v.Id }

// GetName returns GetAddOnAddOnAddOnPlan.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetName() string { return v.Name }

// GetDisplayName returns GetAddOnAddOnAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnAddOnPlan) GetDisplayName() string { return v.DisplayName }

// GetAddOnAddOnOrganization includes the requested fields of the GraphQL type Organization.
type GetAddOnAddOnOrganization struct {
	// Unique organization slug
	Slug string `json:"slug"`
}

// GetSlug returns GetAddOnAddOnOrganization.Slug, and is useful for accessing the field via an interface.
func (v *GetAddOnAddOnOrganization) GetSlug() string { return v.Slug }

// GetAddOnProviderAddOnProvider includes the requested fields of the GraphQL type AddOnProvider.
type GetAddOnProviderAddOnProvider struct {
	Id              string                                               `json:"id"`
	Name            string                                               `json:"name"`
	ExcludedRegions []GetAddOnProviderAddOnProviderExcludedRegionsRegion `json:"excludedRegions"`
}

// GetId returns GetAddOnProviderAddOnProvider.Id, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetId() string { return v.Id }

// GetName returns GetAddOnProviderAddOnProvider.Name, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetName() string { return v.Name }

// GetExcludedRegions returns GetAddOnProviderAddOnProvider.ExcludedRegions, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProvider) GetExcludedRegions() []GetAddOnProviderAddOnProviderExcludedRegionsRegion {
	return v.ExcludedRegions
}

// GetAddOnProviderAddOnProviderExcludedRegionsRegion includes the requested fields of the GraphQL type Region.
type GetAddOnProviderAddOnProviderExcludedRegionsRegion struct {
	// The IATA airport code for this region
	Code string `json:"code"`
}

// GetCode returns GetAddOnProviderAddOnProviderExcludedRegionsRegion.Code, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderAddOnProviderExcludedRegionsRegion) GetCode() string { return v.Code }

// GetAddOnProviderResponse is returned by GetAddOnProvider on success.
type GetAddOnProviderResponse struct {
	AddOnProvider GetAddOnProviderAddOnProvider `json:"addOnProvider"`
}

// GetAddOnProvider returns GetAddOnProviderResponse.AddOnProvider, and is useful for accessing the field via an interface.
func (v *GetAddOnProviderResponse) GetAddOnProvider() GetAddOnProviderAddOnProvider {
	return v.AddOnProvider
}

// GetAddOnResponse is returned by GetAddOn on success.
type GetAddOnResponse struct {
	// Find an add-on by ID or name
	AddOn GetAddOnAddOn `json:"addOn"`
}

// GetAddOn returns GetAddOnResponse.AddOn, and is useful for accessing the field via an interface.
func (v *GetAddOnResponse) GetAddOn() GetAddOnAddOn { return v.AddOn }

// GetOrganizationOrganization includes the requested fields of the GraphQL type Organization.
type GetOrganizationOrganization struct {
	Id string `json:"id"`
	// Organization name
	Name string `json:"name"`
	// Single sign-on link for the given integration type
	AddOnSsoLink string `json:"addOnSsoLink"`
}

// GetId returns GetOrganizationOrganization.Id, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetId() string { return v.Id }

// GetName returns GetOrganizationOrganization.Name, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetName() string { return v.Name }

// GetAddOnSsoLink returns GetOrganizationOrganization.AddOnSsoLink, and is useful for accessing the field via an interface.
func (v *GetOrganizationOrganization) GetAddOnSsoLink() string { return v.AddOnSsoLink }

// GetOrganizationResponse is returned by GetOrganization on success.
type GetOrganizationResponse struct {
	// Find an organization by ID
	Organization GetOrganizationOrganization `json:"organization"`
}

// GetOrganization returns GetOrganizationResponse.Organization, and is useful for accessing the field via an interface.
func (v *GetOrganizationResponse) GetOrganization() GetOrganizationOrganization {
	return v.Organization
}

// ListAddOnPlansAddOnPlansAddOnPlanConnection includes the requested fields of the GraphQL type AddOnPlanConnection.
// The GraphQL type's documentation follows.
//
// The connection type for AddOnPlan.
type ListAddOnPlansAddOnPlansAddOnPlanConnection struct {
	// A list of nodes.
	Nodes []ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan `json:"nodes"`
}

// GetNodes returns ListAddOnPlansAddOnPlansAddOnPlanConnection.Nodes, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnection) GetNodes() []ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan {
	return v.Nodes
}

// ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan struct {
	Id            string `json:"id"`
	DisplayName   string `json:"displayName"`
	MaxDataSize   string `json:"maxDataSize"`
	PricePerMonth int    `json:"pricePerMonth"`
}

// GetId returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetId() string { return v.Id }

// GetDisplayName returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetDisplayName() string {
	return v.DisplayName
}

// GetMaxDataSize returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.MaxDataSize, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetMaxDataSize() string {
	return v.MaxDataSize
}

// GetPricePerMonth returns ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan.PricePerMonth, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansAddOnPlansAddOnPlanConnectionNodesAddOnPlan) GetPricePerMonth() int {
	return v.PricePerMonth
}

// ListAddOnPlansResponse is returned by ListAddOnPlans on success.
type ListAddOnPlansResponse struct {
	// List add-on service plans
	AddOnPlans ListAddOnPlansAddOnPlansAddOnPlanConnection `json:"addOnPlans"`
}

// GetAddOnPlans returns ListAddOnPlansResponse.AddOnPlans, and is useful for accessing the field via an interface.
func (v *ListAddOnPlansResponse) GetAddOnPlans() ListAddOnPlansAddOnPlansAddOnPlanConnection {
	return v.AddOnPlans
}

// ListAddOnsAddOnsAddOnConnection includes the requested fields of the GraphQL type AddOnConnection.
// The GraphQL type's documentation follows.
//
// The connection type for AddOn.
type ListAddOnsAddOnsAddOnConnection struct {
	// A list of nodes.
	Nodes []ListAddOnsAddOnsAddOnConnectionNodesAddOn `json:"nodes"`
}

// GetNodes returns ListAddOnsAddOnsAddOnConnection.Nodes, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnection) GetNodes() []ListAddOnsAddOnsAddOnConnectionNodesAddOn {
	return v.Nodes
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOn includes the requested fields of the GraphQL type AddOn.
type ListAddOnsAddOnsAddOnConnectionNodesAddOn struct {
	Id string `json:"id"`
	// The service name according to the provider
	Name string `json:"name"`
	// The add-on plan
	AddOnPlan ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan `json:"addOnPlan"`
	// Private flycast IP address of the add-on
	PrivateIp string `json:"privateIp"`
	// Region where the primary instance is deployed
	PrimaryRegion string `json:"primaryRegion"`
	// Regions where replica instances are deployed
	ReadRegions []string `json:"readRegions"`
	// Organization that owns this service
	Organization ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization `json:"organization"`
}

// GetId returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetId() string { return v.Id }

// GetName returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Name, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetName() string { return v.Name }

// GetAddOnPlan returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.AddOnPlan, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetAddOnPlan() ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan {
	return v.AddOnPlan
}

// GetPrivateIp returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.PrivateIp, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetPrivateIp() string { return v.PrivateIp }

// GetPrimaryRegion returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetReadRegions returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.ReadRegions, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetReadRegions() []string { return v.ReadRegions }

// GetOrganization returns ListAddOnsAddOnsAddOnConnectionNodesAddOn.Organization, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOn) GetOrganization() ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization {
	return v.Organization
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan includes the requested fields of the GraphQL type AddOnPlan.
type ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan struct {
	DisplayName string `json:"displayName"`
}

// GetDisplayName returns ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan.DisplayName, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnAddOnPlan) GetDisplayName() string {
	return v.DisplayName
}

// ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization includes the requested fields of the GraphQL type Organization.
type ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization struct {
	Id string `json:"id"`
	// Unique organization slug
	Slug string `json:"slug"`
}

// GetId returns ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization.Id, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization) GetId() string { return v.Id }

// GetSlug returns ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization.Slug, and is useful for accessing the field via an interface.
func (v *ListAddOnsAddOnsAddOnConnectionNodesAddOnOrganization) GetSlug() string { return v.Slug }

// ListAddOnsResponse is returned by ListAddOns on success.
type ListAddOnsResponse struct {
	// List add-ons associated with an organization
	AddOns ListAddOnsAddOnsAddOnConnection `json:"addOns"`
}

// GetAddOns returns ListAddOnsResponse.AddOns, and is useful for accessing the field via an interface.
func (v *ListAddOnsResponse) GetAddOns() ListAddOnsAddOnsAddOnConnection { return v.AddOns }

// ResolverCreateBuildCreateBuildCreateBuildPayload includes the requested fields of the GraphQL type CreateBuildPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of CreateBuild
type ResolverCreateBuildCreateBuildCreateBuildPayload struct {
	// build id
	Id string `json:"id"`
	// stored build status
	Status string `json:"status"`
}

// GetId returns ResolverCreateBuildCreateBuildCreateBuildPayload.Id, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildCreateBuildCreateBuildPayload) GetId() string { return v.Id }

// GetStatus returns ResolverCreateBuildCreateBuildCreateBuildPayload.Status, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildCreateBuildCreateBuildPayload) GetStatus() string { return v.Status }

// ResolverCreateBuildResponse is returned by ResolverCreateBuild on success.
type ResolverCreateBuildResponse struct {
	CreateBuild ResolverCreateBuildCreateBuildCreateBuildPayload `json:"createBuild"`
}

// GetCreateBuild returns ResolverCreateBuildResponse.CreateBuild, and is useful for accessing the field via an interface.
func (v *ResolverCreateBuildResponse) GetCreateBuild() ResolverCreateBuildCreateBuildCreateBuildPayload {
	return v.CreateBuild
}

// ResolverFinishBuildFinishBuildFinishBuildPayload includes the requested fields of the GraphQL type FinishBuildPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of FinishBuild
type ResolverFinishBuildFinishBuildFinishBuildPayload struct {
	// build id
	Id string `json:"id"`
	// stored build status
	Status string `json:"status"`
	// wall clock time for this build
	WallclockTimeMs int `json:"wallclockTimeMs"`
}

// GetId returns ResolverFinishBuildFinishBuildFinishBuildPayload.Id, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetId() string { return v.Id }

// GetStatus returns ResolverFinishBuildFinishBuildFinishBuildPayload.Status, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetStatus() string { return v.Status }

// GetWallclockTimeMs returns ResolverFinishBuildFinishBuildFinishBuildPayload.WallclockTimeMs, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildFinishBuildFinishBuildPayload) GetWallclockTimeMs() int {
	return v.WallclockTimeMs
}

// ResolverFinishBuildResponse is returned by ResolverFinishBuild on success.
type ResolverFinishBuildResponse struct {
	FinishBuild ResolverFinishBuildFinishBuildFinishBuildPayload `json:"finishBuild"`
}

// GetFinishBuild returns ResolverFinishBuildResponse.FinishBuild, and is useful for accessing the field via an interface.
func (v *ResolverFinishBuildResponse) GetFinishBuild() ResolverFinishBuildFinishBuildFinishBuildPayload {
	return v.FinishBuild
}

// UpdateAddOnResponse is returned by UpdateAddOn on success.
type UpdateAddOnResponse struct {
	UpdateAddOn UpdateAddOnUpdateAddOnUpdateAddOnPayload `json:"updateAddOn"`
}

// GetUpdateAddOn returns UpdateAddOnResponse.UpdateAddOn, and is useful for accessing the field via an interface.
func (v *UpdateAddOnResponse) GetUpdateAddOn() UpdateAddOnUpdateAddOnUpdateAddOnPayload {
	return v.UpdateAddOn
}

// UpdateAddOnUpdateAddOnUpdateAddOnPayload includes the requested fields of the GraphQL type UpdateAddOnPayload.
// The GraphQL type's documentation follows.
//
// Autogenerated return type of UpdateAddOn
type UpdateAddOnUpdateAddOnUpdateAddOnPayload struct {
	AddOn UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn `json:"addOn"`
}

// GetAddOn returns UpdateAddOnUpdateAddOnUpdateAddOnPayload.AddOn, and is useful for accessing the field via an interface.
func (v *UpdateAddOnUpdateAddOnUpdateAddOnPayload) GetAddOn() UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn {
	return v.AddOn
}

// UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn includes the requested fields of the GraphQL type AddOn.
type UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn struct {
	Id string `json:"id"`
}

// GetId returns UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn.Id, and is useful for accessing the field via an interface.
func (v *UpdateAddOnUpdateAddOnUpdateAddOnPayloadAddOn) GetId() string { return v.Id }

// __AgentGetInstancesInput is used internally by genqlient
type __AgentGetInstancesInput struct {
	AppName string `json:"appName"`
}

// GetAppName returns __AgentGetInstancesInput.AppName, and is useful for accessing the field via an interface.
func (v *__AgentGetInstancesInput) GetAppName() string { return v.AppName }

// __CreateAddOnInput is used internally by genqlient
type __CreateAddOnInput struct {
	OrganizationId string      `json:"organizationId"`
	PrimaryRegion  string      `json:"primaryRegion"`
	Name           string      `json:"name"`
	PlanId         string      `json:"planId"`
	ReadRegions    []string    `json:"readRegions"`
	Options        interface{} `json:"options"`
}

// GetOrganizationId returns __CreateAddOnInput.OrganizationId, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetOrganizationId() string { return v.OrganizationId }

// GetPrimaryRegion returns __CreateAddOnInput.PrimaryRegion, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetPrimaryRegion() string { return v.PrimaryRegion }

// GetName returns __CreateAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetName() string { return v.Name }

// GetPlanId returns __CreateAddOnInput.PlanId, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetPlanId() string { return v.PlanId }

// GetReadRegions returns __CreateAddOnInput.ReadRegions, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetReadRegions() []string { return v.ReadRegions }

// GetOptions returns __CreateAddOnInput.Options, and is useful for accessing the field via an interface.
func (v *__CreateAddOnInput) GetOptions() interface{} { return v.Options }

// __DeleteAddOnInput is used internally by genqlient
type __DeleteAddOnInput struct {
	Name string `json:"name"`
}

// GetName returns __DeleteAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__DeleteAddOnInput) GetName() string { return v.Name }

// __GetAddOnInput is used internally by genqlient
type __GetAddOnInput struct {
	Name string `json:"name"`
}

// GetName returns __GetAddOnInput.Name, and is useful for accessing the field via an interface.
func (v *__GetAddOnInput) GetName() string { return v.Name }

// __GetAddOnProviderInput is used internally by genqlient
type __GetAddOnProviderInput struct {
	Name string `json:"name"`
}

// GetName returns __GetAddOnProviderInput.Name, and is useful for accessing the field via an interface.
func (v *__GetAddOnProviderInput) GetName() string { return v.Name }

// __GetOrganizationInput is used internally by genqlient
type __GetOrganizationInput struct {
	Slug string `json:"slug"`
}

// GetSlug returns __GetOrganizationInput.Slug, and is useful for accessing the field via an interface.
func (v *__GetOrganizationInput) GetSlug() string { return v.Slug }

// __ListAddOnsInput is used internally by genqlient
type __ListAddOnsInput struct {
	AddOnType AddOnType `json:"addOnType"`
}

// GetAddOnType returns __ListAddOnsInput.AddOnType, and is useful for accessing the field via an interface.
func (v *__ListAddOnsInput) GetAddOnType() AddOnType { return v.AddOnType }

// __ResolverCreateBuildInput is used internally by genqlient
type __ResolverCreateBuildInput struct {
	Input CreateBuildInput `json:"input"`
}

// GetInput returns __ResolverCreateBuildInput.Input, and is useful for accessing the field via an interface.
func (v *__ResolverCreateBuildInput) GetInput() CreateBuildInput { return v.Input }

// __ResolverFinishBuildInput is used internally by genqlient
type __ResolverFinishBuildInput struct {
	Input FinishBuildInput `json:"input"`
}

// GetInput returns __ResolverFinishBuildInput.Input, and is useful for accessing the field via an interface.
func (v *__ResolverFinishBuildInput) GetInput() FinishBuildInput { return v.Input }

// __UpdateAddOnInput is used internally by genqlient
type __UpdateAddOnInput struct {
	AddOnId     string   `json:"addOnId"`
	PlanId      string   `json:"planId"`
	ReadRegions []string `json:"readRegions"`
}

// GetAddOnId returns __UpdateAddOnInput.AddOnId, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetAddOnId() string { return v.AddOnId }

// GetPlanId returns __UpdateAddOnInput.PlanId, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetPlanId() string { return v.PlanId }

// GetReadRegions returns __UpdateAddOnInput.ReadRegions, and is useful for accessing the field via an interface.
func (v *__UpdateAddOnInput) GetReadRegions() []string { return v.ReadRegions }

func AgentGetInstances(
	ctx context.Context,
	client graphql.Client,
	appName string,
) (*AgentGetInstancesResponse, error) {
	req := &graphql.Request{
		OpName: "AgentGetInstances",
		Query: `
query AgentGetInstances ($appName: String!) {
	app(name: $appName) {
		organization {
			slug
		}
		id
		name
		allocations(showCompleted: false) {
			id
			region
			privateIP
		}
		machines {
			nodes {
				id
				region
				ips {
					nodes {
						kind
						family
						ip
					}
				}
			}
		}
	}
}
`,
		Variables: &__AgentGetInstancesInput{
			AppName: appName,
		},
	}
	var err error

	var data AgentGetInstancesResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func CreateAddOn(
	ctx context.Context,
	client graphql.Client,
	organizationId string,
	primaryRegion string,
	name string,
	planId string,
	readRegions []string,
	options interface{},
) (*CreateAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "CreateAddOn",
		Query: `
mutation CreateAddOn ($organizationId: ID!, $primaryRegion: String!, $name: String, $planId: ID!, $readRegions: [String!], $options: JSON!) {
	createAddOn(input: {organizationId:$organizationId,type:redis,name:$name,planId:$planId,primaryRegion:$primaryRegion,readRegions:$readRegions,options:$options}) {
		addOn {
			name
			publicUrl
		}
	}
}
`,
		Variables: &__CreateAddOnInput{
			OrganizationId: organizationId,
			PrimaryRegion:  primaryRegion,
			Name:           name,
			PlanId:         planId,
			ReadRegions:    readRegions,
			Options:        options,
		},
	}
	var err error

	var data CreateAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func DeleteAddOn(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*DeleteAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "DeleteAddOn",
		Query: `
mutation DeleteAddOn ($name: String) {
	deleteAddOn(input: {name:$name}) {
		deletedAddOnName
	}
}
`,
		Variables: &__DeleteAddOnInput{
			Name: name,
		},
	}
	var err error

	var data DeleteAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetAddOn(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*GetAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "GetAddOn",
		Query: `
query GetAddOn ($name: String) {
	addOn(name: $name) {
		id
		name
		publicUrl
		privateIp
		password
		primaryRegion
		readRegions
		organization {
			slug
		}
		addOnPlan {
			id
			name
			displayName
		}
	}
}
`,
		Variables: &__GetAddOnInput{
			Name: name,
		},
	}
	var err error

	var data GetAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetAddOnProvider(
	ctx context.Context,
	client graphql.Client,
	name string,
) (*GetAddOnProviderResponse, error) {
	req := &graphql.Request{
		OpName: "GetAddOnProvider",
		Query: `
query GetAddOnProvider ($name: String!) {
	addOnProvider(name: $name) {
		id
		name
		excludedRegions {
			code
		}
	}
}
`,
		Variables: &__GetAddOnProviderInput{
			Name: name,
		},
	}
	var err error

	var data GetAddOnProviderResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func GetOrganization(
	ctx context.Context,
	client graphql.Client,
	slug string,
) (*GetOrganizationResponse, error) {
	req := &graphql.Request{
		OpName: "GetOrganization",
		Query: `
query GetOrganization ($slug: String!) {
	organization(slug: $slug) {
		id
		name
		addOnSsoLink
	}
}
`,
		Variables: &__GetOrganizationInput{
			Slug: slug,
		},
	}
	var err error

	var data GetOrganizationResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ListAddOnPlans(
	ctx context.Context,
	client graphql.Client,
) (*ListAddOnPlansResponse, error) {
	req := &graphql.Request{
		OpName: "ListAddOnPlans",
		Query: `
query ListAddOnPlans {
	addOnPlans {
		nodes {
			id
			displayName
			maxDataSize
			pricePerMonth
		}
	}
}
`,
	}
	var err error

	var data ListAddOnPlansResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ListAddOns(
	ctx context.Context,
	client graphql.Client,
	addOnType AddOnType,
) (*ListAddOnsResponse, error) {
	req := &graphql.Request{
		OpName: "ListAddOns",
		Query: `
query ListAddOns ($addOnType: AddOnType) {
	addOns(type: $addOnType) {
		nodes {
			id
			name
			addOnPlan {
				displayName
			}
			privateIp
			primaryRegion
			readRegions
			organization {
				id
				slug
			}
		}
	}
}
`,
		Variables: &__ListAddOnsInput{
			AddOnType: addOnType,
		},
	}
	var err error

	var data ListAddOnsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ResolverCreateBuild(
	ctx context.Context,
	client graphql.Client,
	input CreateBuildInput,
) (*ResolverCreateBuildResponse, error) {
	req := &graphql.Request{
		OpName: "ResolverCreateBuild",
		Query: `
mutation ResolverCreateBuild ($input: CreateBuildInput!) {
	createBuild(input: $input) {
		id
		status
	}
}
`,
		Variables: &__ResolverCreateBuildInput{
			Input: input,
		},
	}
	var err error

	var data ResolverCreateBuildResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func ResolverFinishBuild(
	ctx context.Context,
	client graphql.Client,
	input FinishBuildInput,
) (*ResolverFinishBuildResponse, error) {
	req := &graphql.Request{
		OpName: "ResolverFinishBuild",
		Query: `
mutation ResolverFinishBuild ($input: FinishBuildInput!) {
	finishBuild(input: $input) {
		id
		status
		wallclockTimeMs
	}
}
`,
		Variables: &__ResolverFinishBuildInput{
			Input: input,
		},
	}
	var err error

	var data ResolverFinishBuildResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}

func UpdateAddOn(
	ctx context.Context,
	client graphql.Client,
	addOnId string,
	planId string,
	readRegions []string,
) (*UpdateAddOnResponse, error) {
	req := &graphql.Request{
		OpName: "UpdateAddOn",
		Query: `
mutation UpdateAddOn ($addOnId: ID!, $planId: ID!, $readRegions: [String!]!) {
	updateAddOn(input: {addOnId:$addOnId,planId:$planId,readRegions:$readRegions}) {
		addOn {
			id
		}
	}
}
`,
		Variables: &__UpdateAddOnInput{
			AddOnId:     addOnId,
			PlanId:      planId,
			ReadRegions: readRegions,
		},
	}
	var err error

	var data UpdateAddOnResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		ctx,
		req,
		resp,
	)

	return &data, err
}
