// Code generated for package expreduce by go-bindata DO NOT EDIT. (@generated)
// sources:
// resources/arithmetic.m
// resources/atoms.m
// resources/boolean.m
// resources/calculus.m
// resources/combinatorics.m
// resources/comparison.m
// resources/equationdata.m
// resources/expression.m
// resources/flowcontrol.m
// resources/functional.m
// resources/init.m
// resources/list.m
// resources/manip.m
// resources/matrix.m
// resources/numbertheory.m
// resources/pattern.m
// resources/plot.m
// resources/power.m
// resources/random.m
// resources/replacement.m
// resources/rubi/1.1.1 Linear binomial products.m
// resources/rubi/1.1.3 General binomial products.m
// resources/rubi/1.1.4 Improper binomial products.m
// resources/rubi/1.2.1 Quadratic trinomial products.m
// resources/rubi/1.2.2 Quartic trinomial products.m
// resources/rubi/1.2.3 General trinomial products.m
// resources/rubi/1.2.4 Improper trinomial products.m
// resources/rubi/1.3 Miscellaneous algebraic functions.m
// resources/rubi/2 Exponentials.m
// resources/rubi/3 Logarithms.m
// resources/rubi/4.1 Sine.m
// resources/rubi/4.2 Tangent.m
// resources/rubi/4.3 Secant.m
// resources/rubi/4.4 Miscellaneous trig functions.m
// resources/rubi/5 Inverse trig functions.m
// resources/rubi/6 Hyperbolic functions.m
// resources/rubi/7 Inverse hyperbolic functions.m
// resources/rubi/8 Special functions.m
// resources/rubi/9.1 Integrand simplification rules.m
// resources/rubi/9.2 Derivative integration rules.m
// resources/rubi/9.3 Piecewise linear functions.m
// resources/rubi/9.4 Miscellaneous integration rules.m
// resources/rubi/Integration Utility Functions.m
// resources/rubi/MakeRubiMxFile.m
// resources/rubi/README
// resources/rubi/Rubi.m
// resources/rubi/Rubi4.12.nb
// resources/rubi/ShowStep Routines.m
// resources/rubi.m
// resources/rubi_loader.m
// resources/simplify.m
// resources/solve.m
// resources/sort.m
// resources/specialsyms.m
// resources/stats.m
// resources/string.m
// resources/system.m
// resources/tests.m
// resources/time.m
// resources/trig.m
package expreduce

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// Mode return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _resourcesArithmeticM = []byte(`Plus::usage = "`+"`"+`(e1 + e2 + ...)`+"`"+` computes the sum of all expressions in the function.";
(*{"Verbatim[Plus][beg___, Optional[c1_?NumberQ]*a_, Optional[c2_?NumberQ]*a_, end___]", "beg+(c1+c2)*a+end"},*)
 (*The world is not ready for this madness.*)
(*{"Verbatim[Plus][beg___, Verbatim[Times][Optional[c1_?NumberQ],a__], Verbatim[Times][Optional[c2_?NumberQ],a__], end___]", "beg+(c1+c2)*a+end"},*)
Attributes[Plus] = {Flat, Listable, NumericFunction, OneIdentity, Orderless, Protected};
Tests`+"`"+`Plus = {
    ESimpleExamples[
        ESameTest[2, 1 + 1],
        EComment["If Reals are present, other Integers are demoted to Reals:"],
        ESameTest[0., (5.2 - .2) - 5],
        EComment["Plus automatically combines like terms:"],
        ESameTest[a+6*b^2, a + b^2 + 5*b^2],
        ESameTest[((5 * c^a) + (3 * d)), (a+b)-(a+b)+c-c+2*c^a+2*d+5*d+d-5*d+3*c^a],
        ESameTest[-3 a b c d e f, 4*a*b*c*d*e*f + -7*a*b*c*d*e*f]
    ], ETests[
        (*Test automatic expansion*)
        EStringTest["(a + b)", "1*(a + b)"],
        EStringTest["(1.*(a + b))", "1.*(a + b)"],
        EStringTest["(2.*(a + b))", "2.*(a + b)"],
        EStringTest["(a + b)", "(a + b)/1"],
        EStringTest["(1.*(a + b))", "(a + b)/1."],
        EStringTest["(2*(a + b))", "2*(a + b)"],
        EStringTest["(a*(b + c))", "a*(b + c)"],
        EStringTest["(-a - b)", "-1*(a + b)"],
        EStringTest["(-a - b)", "-(a + b)"],
        EStringTest["((-1.)*(a + b))", "-1.*(a + b)"],
        EStringTest["(-a - b)", "(a + b)/-1"],
        EStringTest["((-1.)*(a + b))", "(a + b)/-1."],

        (*Test that we do not delete all the addends*)
        ESameTest[0., (5.2 - .2) - 5],
        ESameTest[0, 0 + 0],

        (*Test empty Plus expressions*)
        ESameTest[0, Plus[]],

        (*Test proper accumulation of Rationals*)
        EStringTest["(47/6 + sym)", "Rational[5, 2] + Rational[7, 3] + 3 + sym"],
        EStringTest["(17/6 + sym)", "Rational[5, -2] + Rational[7, 3] + 3 + sym"],
        EStringTest["(-19/6 + sym)", "Rational[5, -2] + Rational[7, 3] - 3 + sym"],
        EStringTest["(-47/6 + sym)", "Rational[5, -2] + Rational[-7, 3] - 3 + sym"],

        (*Test combining monomials of degree 1*)
        ESameTest[a+7*b, a + 2*b + 5*b],

        (*Test a more general version*)
        ESameTest[a+7*b, a + 2*b + 5*b],
        ESameTest[a+7*b^2, a + 2*b^2 + 5*b^2],
        ESameTest[a+3*b^2, a - 2*b^2 + 5*b^2],

        (*Test using terms without a coefficient*)
        ESameTest[a+6*b^2, a + b^2 + 5*b^2],

        (*Test additive identity*)
        ESameTest[a, a+0],
        ESameTest[a+b, (a+b)+0],

        (*Test additive inverse*)
        ESameTest[0, a-a],
        ESameTest[0, -a + a],
        ESameTest[0, (a+b)-(a+b)],
        ESameTest[0, -(a+b)+(a+b)],
        ESameTest[0, (a+b)-(a+b)],
        ESameTest[0, -(a+b)+(a+b)],

        (*Test basic simplifications*)
        ESameTest[d, (a+b)-(a+b)+c-c+d],
        ESameTest[((5 * c^a) + (3 * d)), (a+b)-(a+b)+c-c+2*c^a+2*d+5*d+d-5*d+3*c^a],
        ESameTest[87.5 + 3 * x, ((x + 80. + 3. + x) + 2. + x + 2.5)],
        ESameTest[87.5 + (7. * x), ((x + 80. + 3. + x) + 2. + (x * 2. * 2.) + (0. * 3. * x) + x + 2.5)],
        ESameTest[50*a, a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a+a],

        (*More complicated term combining*)
        ESameTest[-3 * m - 10 * n, -9 * n - n - 3 * m],
        ESameTest[7*a * b - 2*a * c, 3*a*b - 2*a*c + 4*a*b],
        ESameTest[-3*a - 2*b + 3*a*b, 2*a - 4*b + 3*a*b - 5*a + 2*b],
        ESameTest[7*x - 11*y + x*y, 8*x - 9*y - 3*x*y - 2*y - x + 4*x*y],
        ESameTest[-3*a*b*c*d*e*f, 4*a*b*c*d*e*f + -7*a*b*c*d*e*f],
        ESameTest[-3*a*b*c*d*e*f, a*b*c*4*d*e*f + -a*b*c*d*e*f*7],
        ESameTest[-3*a*b*c*d*e*f, a*b*2*c*2*d*e*f + -a*b*c*d*e*f*7],
        ESameTest[2 r + 2 t, 2 r - 3 s - t + 3 t + 3 s],
        ESameTest[3 (x - 2 y) - 4 x y + 2 (-1 + x y), 2 (x*y - 1) + 3 (x - 2 y) - 4 x*y],
        ESameTest[-4 s + 4 r s - 3 (1 + r s), 4 r*s - 2 s - 3 (r*s + 1) - 2 s],
        ESameTest[7 y - z + 3 y z, 8 y - 2 z - (y - z) + 3 y*z]
    ]
};

Sum::usage = "`+"`"+`Sum[expr, n]`+"`"+` returns the sum of `+"`"+`n`+"`"+` copies of `+"`"+`expr`+"`"+`.

`+"`"+`Sum[expr, {sym, n}]`+"`"+` returns the sum of `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = 1 to `+"`"+`n`+"`"+`.

`+"`"+`Sum[expr, {sym, m, n}]`+"`"+` returns the sum of `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`.";
Sum[i_Symbol, {i_Symbol, 0, n_Integer}] := 1/2*n*(1 + n);
Sum[i_Symbol, {i_Symbol, 1, n_Integer}] := 1/2*n*(1 + n);
Sum[i_Symbol, {i_Symbol, end_}]         := 1/2*end*(1 + end);
Sum[i_Symbol, {i_Symbol, 0, n_Symbol}]  := 1/2*n*(1 + n);
Sum[i_Symbol, {i_Symbol, 1, n_Symbol}]  := 1/2*n*(1 + n);
Attributes[Sum] = {HoldAll, ReadProtected, Protected};
Tests`+"`"+`Sum = {
    ESimpleExamples[
        ESameTest[45, Sum[i, {i, 5, 10}]],
        ESameTest[55, Sum[i, {i, 1, 10}]],
        ESameTest[55, Sum[i, {i, 0, 10}]],
        ESameTest[450015000, Sum[i, {i, 1, 30000}]],
        ESameTest[450015000, Sum[i, {i, 0, 30000}]],
        ESameTest[1/2*n*(1 + n), Sum[i, {i, 0, n}]],
        ESameTest[1/2*n*(1 + n), Sum[i, {i, 1, n}]],
        ESameTest[30, Sum[a + b, {a, 0, 2}, {b, 0, 3}]],
        ESameTest[b+c+d+e, Sum[a, {a, {b, c, d, e}}]],
        ESameTest[b g + c g + d g + e g + b h + c h + d h + e h, Sum[a*f, {a, {b, c, d, e}}, {f, {g, h}}]],
        ESameTest[25 n (1 + 50 n), Sum[i, {i, n*50}]],
    ]
};

Times::usage = "`+"`"+`(e1 * e2 * ...)`+"`"+` computes the product of all expressions in the function.";
(* This is likely the most compute-intensive rule in the system. Modify with
care. *)
Verbatim[Times][beg___, a_^Optional[m_], a_^Optional[n_], end___] := beg*a^(m+n)*end /; (!NumberQ[a] || !NumberQ[m] || !NumberQ[n]);
(*Verbatim[Times][a_Integer, mid___, b_Integer^n_, end___] := mid*-(b^(n+1))*end /; (a == -b);*)
a_Integer^c_Rational*b_Integer^c_Rational*rest___ := (a*b)^c*rest;
(*Verbatim[Times][beg___, a_^Optional[m_], a_^Optional[n_], end___] := beg*a^(m+n)*end;*)
(* This qualifier is so that the simplification for 3^(4/3) -> 3*3^(1/3) does not produce an infinite evaluation loop *)
wouldntBeLessThanNegOne[x_] := ((x - 1) < -1) =!= True;
Verbatim[Times][Rational[1, a_Integer], inner___, a_Integer^n_?wouldntBeLessThanNegOne, end___] := inner*a^(n-1)*end;
Times[den_Integer^-1, num_Integer, rest___] := Rational[num,den] * rest;
Times[ComplexInfinity, rest___] := ComplexInfinity;
a_Integer?Negative^b_Rational*c_Integer^d_Rational*rest___ := (-1)^b*rest /; (a == -c && b == -d);
Verbatim[Times][beg___, a_Integer^m_Rational, a_Integer^n_Rational, end___] := beg*a^(m+n)*end;
Times[c : (Rational[_Integer, d_Integer] |
     Complex[_Integer, Rational[_Integer, d_Integer]]),
  Power[a_Integer, Rational[1, r_Integer]], rest___] :=
 Times[c*a, a^(1/r - 1), rest] /; (Mod[d, a] === 0 && a > 1)
Sin[x_]*Cos[x_]^(-1)*rest___ := Tan[x]*rest;
Cos[x_]*Sin[x_]^(-1)*rest___ := Cot[x]*rest;
Attributes[Times] = {Flat, Listable, NumericFunction, OneIdentity, Orderless, Protected};
Tests`+"`"+`Times = {
    ESimpleExamples[
        EComment["Simplification rules apply automatically:"],
        ESameTest[3/2, (3 + (x^2 * 0)) * 2^-1],
        ESameTest[a^(2+c), a^2*a^c],
        ESameTest[a/(b*c*d), a/b/c/d]
    ], EFurtherExamples[
        EComment["Rational numbers are suppported (explicit rational declaration added for clarity):"],
        ESameTest[-2/3, Rational[1, -2]*Rational[-2, 3]*-2],
        EComment["The product of nothing is defined to be one:"],
        ESameTest[1, Times[]]
    ], ETests[
        (*Test that we do not delete all the multiplicands*)
        ESameTest[1, 1*1],
        ESameTest[1, 5*1/5*1],

        (*Test empty Times expressions*)
        ESameTest[1, Times[]],

        (*Test fraction simplification*)
        ESameTest[25, 50/2],
        ESameTest[50, 100/2],
        ESameTest[50, 1/2*100],
        ESameTest[5/4, 1/2*5/2],
        ESameTest[1/4, 1/2*1/2],
        ESameTest[a/(b*c*d), a/b/c/d],

        (*Test Rational detection*)
        EStringTest["10", "40/2^2"],
        EStringTest["10", "40/4"],
        ESameTest[40/3, 40/3],
        ESameTest[20/3, 40/6],
        EStringTest["10", "1/4*40"],
        EStringTest["10", "1/(2^2)*40"],

        (*Test proper accumulation of Rationals*)
        EStringTest["(2*sym)", "sym*Rational[1,2]*Rational[2,3]*6"],
        ESameTest[-2/3, Rational[1, -2]*Rational[-2, 3]*-2],
        EStringTest["Rational", "Rational[1, -2]*Rational[-2, 3]*-2 // Head"],

        (*Test multiplicative identity*)
        EStringTest["5", "5*1"],
        EStringTest["a", "1*a"],
        EStringTest["(1.*a)", "1.*a"],

        (*Test multiplicative inverse*)
        EStringTest["1", "8*1/8"],
        EStringTest["1", "a*1/a"],
        EStringTest["1", "1/a*a"],

        (*Test multiplicative property of zero*)
        ESameTest[3/2, (3 + (x^2 * 0)) * 2^-1],

        (*Simplifications with Power*)
        ESameTest[a^(2+c), a^2*a^c],
        ESameTest[a^(2-c), a^2/a^c],
        ESameTest[m^2, m*m],
        ESameTest[1, m/m],
        ESameTest[1, m^2/m^2],
        ESameTest[Times[Power[2,Rational[-1,2]],a], (1/2)*a*2^(1/2)],

        (*Conversion of exact numeric functions to reals*)
        ESameTest[True, MatchQ[Sqrt[2*Pi]*.1, _Real]],

        ESameTest[(-1)^(1/3) a b c, (-2)^(1/3)*2^(-1/3)*a*b*c],
        ESameTest[1/12, (1/12)*2^(-2/3)*2^(2/3)],
        ESameTest[I/(4 Sqrt[3]), (0+I/12) Sqrt[3]],
        (* 1/12*Sqrt[3]===1/12*3^(1/2)===12^-1*3^(1/2)===(2*2*3)^-1*3^(1/2)===(2*2)^-1*3^-1*3^(1/2)===(2*2)^-1*3^(1/2-1)===1/4*3^(-1/2)===1/(4 Sqrt[3]) *)
        ESameTest[1/(4 Sqrt[3]), 1/12*Sqrt[3]],
        ESameTest[-(I/(4 Sqrt[3])), (0-I/4) 1/Sqrt[3]],
        ESameTest[-(1/(4 Sqrt[3])), Times[-1/12,Sqrt[3]]],
        ESameTest[-(5/(4 Sqrt[3])), Times[-5/12,Sqrt[3]]],
        ESameTest[(3+I/4)/Sqrt[3], Times[1+1/12 I,Sqrt[3]]],
        ESameTest[(I Sqrt[3])/4, Times[3/12 I,Sqrt[3]]],
        ESameTest[-(I/(2 Sqrt[3])), Times[-2/12 I,Sqrt[3]]],
        ESameTest[-(I/(2 Sqrt[3])), Times[2/-12 I,Sqrt[3]]],
        ESameTest[(3+(5 I)/4)/Sqrt[3], Times[1+5/12 I,Sqrt[3]]],
        ESameTest[I/(2 Sqrt[3] a^2), (0+1/6*I)*3^(1/2)*a^(-2)],
        (* Test wouldntBeLessThanNegOne. *)
        ESameTest[(1/3)*3^(-1/2), (1/3)*3^(-1/2)],

        ESameTest[Sqrt[2/\[Pi]], Sqrt[2]*Sqrt[1/Pi]],
        ESameTest[Sqrt[3/(2 \[Pi])], Sqrt[3/2]*Sqrt[1/Pi]],
    ], EKnownFailures[
        ESameTest[-2^(1/3), (-2)*2^(-2/3)],
        ESameTest[-2^(1+a), (-2)*2^(a)],
    ]
};

Product::usage = "`+"`"+`Product[expr, n]`+"`"+` returns the product of `+"`"+`n`+"`"+` copies of `+"`"+`expr`+"`"+`.

`+"`"+`Product[expr, {sym, n}]`+"`"+` returns the product of `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = 1 to `+"`"+`n`+"`"+`.

`+"`"+`Product[expr, {sym, m, n}]`+"`"+` returns the product of `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`.";
Attributes[Product] = {HoldAll, ReadProtected, Protected};
Tests`+"`"+`Product = {
    ESimpleExamples[
        ESameTest[120, Product[a, {a, 1, 5}]],
        ESameTest[f[1] * f[2] * f[3] * f[4] * f[5], Product[f[a], {a, 1, 5}]],
        ESameTest[576, Product[a^2, {a, 4}]],
        ESameTest[1440, Product[a + b, {a, 1, 2}, {b, 1, 3}]]
    ]
};

Abs::usage = "`+"`"+`Abs[expr]`+"`"+` calculates the absolute value of `+"`"+`expr`+"`"+`.";
Abs[a_?NumberQ] := If[a<0,-a,a];
Abs[Infinity] := Infinity;
Abs[ComplexInfinity] := Infinity;
Abs[-a_] := Abs[a];
Abs[a_?((!FreeQ[#,I|_Complex])&)] := Sqrt[Total[ReIm[a]^2]] ;/ (FreeQ[ReIm[a], Re] && FreeQ[ReIm[a], Im]);
Attributes[Abs] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`Abs = {
    ESimpleExamples[
        ESameTest[5, Abs[-5]],
        ESameTest[5, Abs[5]],
        EComment["Absolute values of unspecified inputs will be left unevaluated:"],
        ESameTest[Abs[a], Abs[a]],
        EComment["But sometimes simplifications can occur:"],
        ESameTest[Abs[Sin[x]], Abs[-Sin[x]]]
    ], ETests[
        ESameTest[True, Abs[-5.2] > 0],
        ESameTest[0, Abs[0]],
        ESameTest[Abs[x^a], Abs[-x^a]],
        ESameTest[Abs[x^(a + b)], Abs[-x^(a + b)]],
        ESameTest[1/2, Abs[1/2 E^(\[ImaginaryJ]*\[Pi]/4)]],
    ]
};

Divide::usage = "`+"`"+`Divide[a, b]`+"`"+` computes `+"`"+`a/b`+"`"+`.";
Divide[a_,b_] := a/b;
Attributes[Divide] = {Listable, NumericFunction, Protected};
Tests`+"`"+`Divide = {
    ESimpleExamples[
        ESameTest[2, Divide[10, 5]]
    ]
};

Increment::usage = "`+"`"+`Increment[a]`+"`"+` adds 1 to `+"`"+`a`+"`"+` and returns the original value.";
Increment[a_] := (a = a + 1; a - 1);
Attributes[Increment] = {HoldFirst, Protected, ReadProtected};
Tests`+"`"+`Increment = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[3, toModify++],
        ESameTest[4, toModify]
    ]
};

Decrement::usage = "`+"`"+`Decrement[a]`+"`"+` subtracts 1 from `+"`"+`a`+"`"+` and returns the original value.";
Decrement[a_] := (a = a - 1; a + 1);
Attributes[Decrement] = {HoldFirst, Protected, ReadProtected};
Tests`+"`"+`Decrement = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[3, toModify--],
        ESameTest[2, toModify]
    ]
};

PreIncrement::usage = "`+"`"+`PreIncrement[a]`+"`"+` adds 1 to `+"`"+`a`+"`"+` and returns the new value.";
PreIncrement[a_] := (a = a + 1);
Attributes[PreIncrement] = {HoldFirst, Protected, ReadProtected};
Tests`+"`"+`PreIncrement = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[4, ++toModify],
        ESameTest[4, toModify]
    ]
};

PreDecrement::usage = "`+"`"+`PreDecrement[a]`+"`"+` subtracts 1 from `+"`"+`a`+"`"+` and returns the new value.";
PreDecrement[a_] := (a = a - 1);
Attributes[PreDecrement] = {HoldFirst, Protected, ReadProtected};
Tests`+"`"+`PreDecrement = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[2, --toModify],
        ESameTest[2, toModify]
    ]
};

AddTo::usage = "`+"`"+`AddTo[a, b]`+"`"+` adds `+"`"+`b`+"`"+` to `+"`"+`a`+"`"+` and returns the new value.";
AddTo[a_, b_] := (a = a + b);
Attributes[AddTo] = {HoldFirst, Protected};
Tests`+"`"+`AddTo = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[5, toModify += 2],
        ESameTest[5, toModify]
    ]
};

SubtractFrom::usage = "`+"`"+`SubtractFrom[a, b]`+"`"+` subtracts `+"`"+`b`+"`"+` from `+"`"+`a`+"`"+` and returns the new value.";
SubtractFrom[a_, b_] := (a = a - b);
Attributes[SubtractFrom] = {HoldFirst, Protected};
Tests`+"`"+`SubtractFrom = {
    ESimpleExamples[
        ESameTest[3, toModify = 3],
        ESameTest[1, toModify -= 2],
        ESameTest[1, toModify]
    ]
};
`)

func resourcesArithmeticMBytes() ([]byte, error) {
	return _resourcesArithmeticM, nil
}

func resourcesArithmeticM() (*asset, error) {
	bytes, err := resourcesArithmeticMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/arithmetic.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesAtomsM = []byte(`Rational::usage = "`+"`"+`Rational`+"`"+` is the head for the atomic rational type.";
Attributes[Rational] = {Protected};
Tests`+"`"+`Rational = {
    ESimpleExamples[
        EComment["Rationals are created from `+"`"+`Times`+"`"+` when a rational form is encountered:"],
        ESameTest[Rational, Times[5, 6^-1] // Head],
        EComment["Which is equivalent to typing them in directly:"],
        ESameTest[Rational, 5/6 // Head],
        EComment["Or being even more explicit:"],
        ESameTest[Rational, Rational[5, 6] // Head],
        EComment["Rationals simplify on evaluation:"],
        ESameTest[5/3, Rational[10, 6]],
        EComment["Which might include evaluating to an Integer:"],
        ESameTest[Integer, Rational[-100, 10] // Head],
        EComment["Rationals of non-Integer types are not allowed:"],
        EStringTest["Rational[0, n]", "Rational[0, n]"]
    ], EFurtherExamples[
        EComment["Undefined rationals are handled accordingly:"],
        EStringTest["Indeterminate", "Rational[0, 0]"],
        EStringTest["ComplexInfinity", "Rational[1, 0]"],
        EComment["Rational numbers have some special handling for pattern matching:"],
        ESameTest[2/3, test = Rational[2, 3]],
        ESameTest[True, MatchQ[test, 2/3]],
        ESameTest[True, MatchQ[test, Rational[a_Integer, b_Integer]]],
        ESameTest[{2, 3}, 2/3 /. Rational[a_Integer, b_Integer] -> {a, b}],
        ESameTest[2/3, 2/3 /. a_Integer/b_Integer -> {a, b}]
    ], ETests[
        ESameTest[10/7, Rational[10, 7]],
        EStringTest["Rational[x, 10]", "Rational[x, 10]"],
        EStringTest["10", "Rational[100, 10]"],
        ESameTest[-10, Rational[-100, 10]],
        EStringTest["10", "Rational[-100, -10]"],
        ESameTest[-5/3, Rational[-10, 6]],
        ESameTest[5/3, Rational[-10, -6]],
        EStringTest["0", "Rational[0, 5]"],
        EStringTest["Rational[0, n]", "Rational[0, n]"],
        EStringTest["ComplexInfinity", "Rational[-1, 0]"],
        EStringTest["ComplexInfinity", "Rational[-1, -0]"],
        EStringTest["Indeterminate", "Rational[-0, -0]"],
        EStringTest["Indeterminate", "Rational[-0, 0]"],
        ESameTest[buzz[bar], foo[bar, 1/2] /. foo[base_, 1/2] -> buzz[base]],
        ESameTest[buzz[bar], foo[bar, 1/2] /. foo[base_, Rational[1, 2]] -> buzz[base]],
        ESameTest[buzz[bar], foo[bar, Rational[1, 2]] /. foo[base_, 1/2] -> buzz[base]],
        ESameTest[buzz[bar], foo[bar, Rational[1, 2]] /. foo[base_, Rational[1, 2]] -> buzz[base]],
        ESameTest[True, MatchQ[1/2, Rational[1, 2]]],
        ESameTest[True, MatchQ[Rational[1, 2], 1/2]],
        ESameTest[False, Hold[Rational[1, 2]] === Hold[1/2]]
    ]
};

Complex::usage = "`+"`"+`Complex`+"`"+` is the head for the atomic rational type.";
(a : (_Integer|_Real|_Rational)) * Complex[real_, im_] * rest___ := Complex[a * real, a * im] * rest;
(a : (_Integer|_Real|_Rational)) + Complex[real_, im_] + rest___ := Complex[a + real, im] + rest;
Complex[x_,y_] + Complex[u_,v_] + rest___ := Complex[x+u,y+v] + rest;
Complex[x_,y_] * Complex[u_,v_] * rest___ := Complex[x*u-y*v,x*v+y*u] * rest;
Attributes[Complex] = {Protected};
Tests`+"`"+`Complex = {
    ESimpleExamples[
        ESameTest[Complex[-16, 28], (4 + 8I)(2 + 3I)]
    ]
};

String::usage = "`+"`"+`String`+"`"+` is the head for the atomic string type.";
Attributes[String] = {Protected};
Tests`+"`"+`String = {
    ESimpleExamples[
        ESameTest["Hello", "Hello"],
        ESameTest[True, "Hello" == "Hello"],
        ESameTest[False, "Hello" == "Hello world"],
        ESameTest[String, Head["Hello"]]
    ]
};

Real::usage = "`+"`"+`Real`+"`"+` is the head for the atomic floating point type.";
Attributes[Real] = {Protected};
Tests`+"`"+`Real = {
    ESimpleExamples[
        ESameTest[Real, Head[1.53]],
        EComment["One can force Real interperetation on an Integer by appending a decimal point:"],
        ESameTest[Real, Head[1.]],
        EComment["Real numbers are backed by arbitrary-precision floating points:"],
        EStringTest["10.", "10.^5000 / 10.^4999"]
    ], EFurtherExamples[
        ESameTest[True, MatchQ[1.53, _Real]]
    ]
};

Integer::usage = "`+"`"+`Integer`+"`"+` is the head for the atomic integer type.";
Attributes[Integer] = {Protected};
Tests`+"`"+`Integer = {
    ESimpleExamples[
        ESameTest[Integer, Head[153]],
        EComment["Integer numbers are backed by arbitrary-precision data structures:"],
        ESameTest[815915283247897734345611269596115894272000000000, Factorial[40]]
    ], EFurtherExamples[
        ESameTest[True, MatchQ[153, _Integer]]
    ]
};

IntegerQ::usage = "`+"`"+`IntegerQ[e]`+"`"+` returns True if `+"`"+`e`+"`"+` is an Integer, False otherwise.";
IntegerQ[e_] := Head[e] === Integer;
Attributes[IntegerQ] = {Protected};
Tests`+"`"+`IntegerQ = {
    ESimpleExamples[
        ESameTest[False, IntegerQ[a]],
        ESameTest[True, IntegerQ[1]],
        ESameTest[False, IntegerQ[2.]]
    ]
};

realNumberQ[x_Integer] := True;
realNumberQ[x_Real] := True;
realNumberQ[x_Rational] := True;
realNumberQ[(b_Integer?Positive)^Rational[-1, n_Integer?Positive]] := True;
realNumberQ[(b_Integer?Positive)^Rational[1, 2]] := True;
realNumberQ[x_] := Which[
  x === Pi, True,
  True, False
];

Im::usage = "`+"`"+`Im[e]`+"`"+` finds the imaginary part of `+"`"+`e`+"`"+`.";
Im[x_?realNumberQ] := 0;
Im[a_Integer * x_Integer?Positive^y_Rational] := 0;
Im[Complex[_,im_]] := im;
Im[x_?realNumberQ + rest__] := Im[Plus[rest]];
Im[x_?realNumberQ * rest__] := x * Im[Times[rest]];
Im[I * rest__] := Re[Times[rest]];
Im[Complex[a_, b_] * rest__] := Im[a rest] + Re[b rest];
Im[Complex[a_, b_] * c__ + d__] := Im[a c + d] + Re[b c];
Im[E^(x_?NumericQ)] := E^Re[x] Sin[Im[x]];
Attributes[Im] = {Listable, NumericFunction, Protected};
Tests`+"`"+`Im = {
    ESimpleExamples[
        ESameTest[0, Im[1]],
        ESameTest[0, Im[0.5]],
        ESameTest[0, Im[2/3]],
        ESameTest[1, Im[2 + I]],
        ESameTest[1/(2 Sqrt[2]), Im[1/2 E^(I*\[Pi]/4)]],
        ESameTest[-1/Sqrt[2], Im[(-I)/Sqrt[2]]],
        ESameTest[Re[a*b], Im[a*I*b]],
        ESameTest[-(1/(2 Sqrt[2])), Im[-(I/Sqrt[2])+1/2 E^((I \[Pi])/4)]],
    ], EKnownFailures[
        ESameTest[Im[a c]+Re[b c], Im[a c + I b c]],
    ]
};

Re::usage = "`+"`"+`Re[e]`+"`"+` finds the real part of `+"`"+`e`+"`"+`.";
Re[x_?realNumberQ] := x;
Re[Complex[re_,_]] := re;
Re[Complex[0, 1] + rest__] := Re[Plus[rest]];
Re[x_?realNumberQ + rest__] := x + Re[Plus[rest]];
Re[x_?realNumberQ * rest__] := x * Re[Times[rest]];
Re[Complex[0, 1] * rest__] := -Im[Times[rest]];
Re[E^(x_?NumericQ)] := E^Re[x] Cos[Im[x]];
Attributes[Re] = {Listable, NumericFunction, Protected};
Tests`+"`"+`Re = {
    ESimpleExamples[
        ESameTest[1, Re[1]],
        ESameTest[0.5, Re[0.5]],
        ESameTest[2/3, Re[2/3]],
        ESameTest[2, Re[2 + I]],
        ESameTest[1/(2 Sqrt[2]), Re[1/2 E^(I*\[Pi]/4)]],
        ESameTest[1 + Re[foo], Re[foo+1]],
        ESameTest[1 + Re[foo+bar], Re[foo+1+bar]],
        ESameTest[Re[foo], Re[foo+I]],
        ESameTest[Re[foo+bar], Re[foo+I+bar]],
        ESameTest[Re[a]/2, Re[a/2]],
    ]
};

ReIm[x_] := {Re[x], Im[x]};
`)

func resourcesAtomsMBytes() ([]byte, error) {
	return _resourcesAtomsM, nil
}

func resourcesAtomsM() (*asset, error) {
	bytes, err := resourcesAtomsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/atoms.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesBooleanM = []byte(`And::usage = "`+"`"+`e1 && e2 && ...`+"`"+` returns `+"`"+`True`+"`"+` if all expressions evaluate to `+"`"+`True`+"`"+`.";
Attributes[And] = {Flat, HoldAll, OneIdentity, Protected};
Tests`+"`"+`And = {
    ESimpleExamples[
        ESameTest[False, True && False],
        ESameTest[True, True && True && True]
    ], ETests[
        ESameTest[True, And[]],
        ESameTest[1, 1 && True && True],
        ESameTest[False, True && False],
        ESameTest[False, False && True],
        ESameTest[True, True && True],
        ESameTest[False, False && 1],
        ESameTest[False, 1 && False],
        ESameTest[1 && 1, 1 && 1],
        ESameTest[1 && 1 && kfdkkfd, 1 && 1 && kfdkkfd],
        ESameTest[1 && 1 && kfdkkfd, 1 && 1 && True && kfdkkfd],
        ESameTest[False, 1 && 1 && True && False && kfdkkfd]
    ]
};

Or::usage = "`+"`"+`e1 || e2 || ...`+"`"+` returns `+"`"+`True`+"`"+` if any expressions evaluate to `+"`"+`True`+"`"+`.";
Attributes[Or] = {Flat, HoldAll, OneIdentity, Protected};
Tests`+"`"+`Or = {
    ESimpleExamples[
        ESameTest[True, True || False],
        ESameTest[False, False || False || False]
    ], ETests[
        ESameTest[a || b, a || b],
        ESameTest[True, a || True || b],
        ESameTest[True, a || True || False],
        ESameTest[a || b, a || b || False],
        ESameTest[a || b, a || b || False || False],
        ESameTest[a || b, a || False || b || False || False],
        ESameTest[True, True || False],
        ESameTest[False, False || False],
        ESameTest[False, Or[False]],
        ESameTest[False, Or[]]
    ]
};

Not::usage = "`+"`"+`!e`+"`"+` returns `+"`"+`True`+"`"+` if `+"`"+`e`+"`"+` is `+"`"+`False`+"`"+` and `+"`"+`False`+"`"+` if `+"`"+`e`+"`"+` is `+"`"+`True`+"`"+`.";
!!e_ := e;
Attributes[Not] = {Protected};
Tests`+"`"+`Not = {
    ESimpleExamples[
        ESameTest[False, !True],
        ESameTest[True, !False],
        ESameTest[!a, !a],
        ESameTest[a, !!a]
    ]
};

TrueQ::usage = "`+"`"+`TrueQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is True, False otherwise.";
Attributes[TrueQ] = {Protected};
Tests`+"`"+`TrueQ = {
    ESimpleExamples[
        ESameTest[True, TrueQ[True]],
        ESameTest[False, TrueQ[False]],
        ESameTest[False, TrueQ[1]]
    ]
};

BooleanQ::usage = "`+"`"+`BooleanQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is True or False, False otherwise.";
Attributes[BooleanQ] = {Protected};
Tests`+"`"+`BooleanQ = {
    ESimpleExamples[
        ESameTest[True, BooleanQ[True]],
        ESameTest[True, BooleanQ[False]],
        ESameTest[False, BooleanQ[1]]
    ]
};

AllTrue::usage = "`+"`"+`AllTrue[list, condition]`+"`"+` returns True if all parts of `+"`"+`list`+"`"+` satisfy `+"`"+`condition`+"`"+`.";
AllTrue[_[elems___], cond_] := And @@ (cond /@ {elems});
Attributes[AllTrue] = {Protected};
Tests`+"`"+`AllTrue = {
    ESimpleExamples[
        ESameTest[False, AllTrue[{1, a}, NumberQ]],
        ESameTest[True, AllTrue[{1, 2}, NumberQ]]
    ]
};

Boole::usage = "`+"`"+`Boole[e]`+"`"+` returns 0 if `+"`"+`e`+"`"+` is False and 1 if `+"`"+`e`+"`"+` is True.";
Boole[True] := 1;
Boole[False] := 0;
Attributes[Boole] = {Listable, Protected};
Tests`+"`"+`Boole = {
    ESimpleExamples[
        ESameTest[1, Boole[True]],
        ESameTest[0, Boole[False]]
    ], ETests[
        ESameTest[Boole[1], Boole[1]],
        ESameTest[Boole[a], Boole[a]],
        ESameTest[Boole[False,False], Boole[False, False]]
    ]
};
`)

func resourcesBooleanMBytes() ([]byte, error) {
	return _resourcesBooleanM, nil
}

func resourcesBooleanM() (*asset, error) {
	bytes, err := resourcesBooleanMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/boolean.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesCalculusM = []byte(`D::usage = "`+"`"+`D[f, x]`+"`"+` finds the partial derivative of `+"`"+`f`+"`"+` with respect to `+"`"+`x`+"`"+`.";
D[Indeterminate, x_] := Indeterminate;
D[x_,x_] := 1;
D[a_,x_] := 0 /; (FreeQ[a,x] && a =!= Indeterminate);
D[a_+b_,x_] := D[a,x]+D[b,x];
D[a_ b_,x_] := D[a,x]*b + a*D[b,x];
(*Chain rule*)
(*Prime notation would be nicer here*)
D[f_[g_[x_Symbol]], x_Symbol] := (Evaluate[D[f[#], #]] &)[g[x]]*D[g[x],x];
(*The times operator is needed here. Whitespace precedence is messed up*)
D[a_^(b_), x_] := a^b*(D[b,x] Log[a]+D[a,x]/a*b);
D[Abs[a_], x_] := If[FreeQ[a, x], 0, Derivative[1][Abs][x]];
D[Log[a_], x_] := D[a, x]/a;
D[Sin[a_], x_] := D[a,x] Cos[a];
D[Cos[a_], x_] := -D[a,x] Sin[a];
D[Exp[x_Symbol], x_Symbol] := Exp[x];
D[l_List, x_] := Table[D[l[[idx]], x], {idx, Length[l]}];
Attributes[D] = {ReadProtected, Protected};
Tests`+"`"+`D = {
    ESimpleExamples[
        ESameTest[Sqrt[x] + x^(3/2), D[2/3*x^(3/2) + 2/5*x^(5/2), x]],
        ESameTest[2/x, D[Log[5 x^2], x]],
        ESameTest[-(Sin[Log[x]]/x), D[Cos[Log[x]], x]]
    ], ETests[
        ESameTest[1, D[x,x]],
        ESameTest[1, D[foo,foo]],
        ESameTest[0, D[foo,bar]],
        ESameTest[2, D[bar+foo+bar,bar]],
        ESameTest[2x, D[x^2,x]],
        ESameTest[2x+3x^2, D[x^2+x^3,x]],
        ESameTest[-4x^3, D[-x^4,x]],
        ESameTest[-n x^(-1 - n) + n x^(-1 + n), D[x^n+x^(-n),x]],
        ESameTest[4 x (1 + x^2), D[(x^2 + 1)^2, x]],
        ESameTest[((1 + x + (1/6 * x^3) + (1/2 * x^2))), D[1 + x + 1/2*x^2 + 1/6*x^3 + 1/24*x^4, x]],
        ESameTest[-10*Power[x,-3] - 7*Power[x,-2], D[1 + 7/x + 5/(x^2), x]],
        ESameTest[-2 Sin[2 x], D[Cos[2 x], x]],
        ESameTest[Cos[x]/x - Sin[x]*Power[x,-2], D[(Sin[x]*x^-1), x]],
        ESameTest[-((2 Cos[x])*Power[x,-2]) + (2 Sin[x])*Power[x,-3] - Sin[x]/x, D[D[(Sin[x]*x^-1), x], x]],
        ESameTest[-((2 Cos[x])*Power[x,-2]) + (2 Sin[x])*Power[x,-3] - Sin[x]/x, D[D[(Sin[x]*x^-1+Sin[y]), x], x]],
        ESameTest[-Cos[Cos[x]] Sin[x], D[Sin[Cos[x]],x]],
        ESameTest[Cos[Log[x]]/x, D[Sin[Log[x]],x]],
        ESameTest[-(Sin[Log[x]]/x), D[Cos[Log[x]],x]],
        ESameTest[1-(1+Cot[x]) Sin[x+Log[Sin[x]]], D[Cos[Log[Sin[x]]+x]+x,x]],
        ESameTest[{a,b}, D[{a*x, b*x}, x]],
    ]
};

Grad::usage = "`+"`"+`Grad[e, {var1, var2, ...}]`+"`"+` finds the gradient of `+"`"+`e`+"`"+` with respect to the named variables.";
Grad[e_,vars_List]:=Table[D[e,vars[[idx]]],{idx,Length[vars]}];
Attributes[Grad] = {ReadProtected, Protected};
Tests`+"`"+`Grad = {
    ESimpleExamples[
        ESameTest[{-Sin[x+2 y],-2 Sin[x+2 y]}, Grad[Cos[x+2y],{x,y}]],
    ]
};

findSubscripts[expr_] := Module[{subscripts = {}},
   Map[
    (If[MatchQ[#, Subscript[_, _]],
       AppendTo[subscripts, #];
       ]; #) &, expr, {0, Infinity}];
   subscripts // DeleteDuplicates
   ];
genSubscriptReplacements[expr_] :=
  Module[{subscripts, uniques, n, fwd, bwd, tmpi},
   subscripts = findSubscripts[expr];
   n = Length[subscripts];
   uniques = Table[Unique[], {tmpi, 1, n}];
   fwd = Table[subscripts[[i]] -> uniques[[i]], {i, n}];
   bwd = Table[uniques[[i]] -> subscripts[[i]], {i, n}];
   {fwd, bwd}
   ];

Integrate::usage = "`+"`"+`Integrate[f, x]`+"`"+` finds the indefinite integral of `+"`"+`f`+"`"+` with respect to `+"`"+`x`+"`"+`.

!!! warning \"Under development\"
    This function is under development, and as such will be incomplete and inaccurate.";
Integrate[a_,{x_Symbol,start_,end_}] :=
    (ReplaceAll[Integrate[a, x],x->end] - ReplaceAll[Integrate[a, x],x->start]) // Simplify;
Integrate[a_,x_Symbol] := Module[{cleanedA, replaceRules},
  If[!MemberQ[$ContextPath, "Rubi`+"`"+`"],
    Print["Loading Rubi rules for integration. This happens once. Preload on startup with -preloadrubi."];
    LoadRubiBundledSnapshot[]
  ];
  replaceRules = genSubscriptReplacements[a];
  cleanedA = a /. replaceRules[[1]];
  (Rubi`+"`"+`Int[cleanedA, x] /. replaceRules[[2]]) // Simplify
];
Attributes[Integrate] = {ReadProtected, Protected};
Tests`+"`"+`Integrate = {
    ESimpleExamples[
        ESameTest[Null, LoadRubiBundledSnapshot[]],
        ESameTest[2 x + (3 x^(5/3))/5 + (3 x^2)/2, Integrate[x^(2/3) + 3 x + 2, x]],
        ESameTest[-((3 x^2)/4) + (1/2) (x^2) Log[x] - Sin[x], Integrate[Integrate[Sin[x] + Log[x], x], x]],
        ESameTest[1/3, Integrate[x^2, {x, 0, 1}]],
        ESameTest[True, (Integrate[x^2, {x, 0.5, 1.}] - 0.29166667) < .00001],
        (*ESameTest[-(E^(3 x)/9)+1/3 E^(3 x) x, Integrate[E^(3*x)*x, x]//Expand],*)
        ESameTest[E^(3*x)/3, Integrate[E^(3*x), x]],
        ESameTest[x^(1 + a + b)/(1 + a + b), Integrate[x^(a + b), x]],
        ESameTest[n^3/3, Integrate[x^2, {x, 0, n}]],
        ESameTest[x^3/3, Integrate[x^2, {x, 0, x}]]
    ], ETests[
        (*Test some trig definitions*)
        ESameTest[Tan[x], Integrate[Sec[x]^2,x]],
        ESameTest[-Cot[x], Integrate[Csc[x]^2,x]],
        ESameTest[Sec[x], Integrate[Sec[x]Tan[x],x]],
        ESameTest[-Csc[x], Integrate[Csc[x]Cot[x],x]],
        ESameTest[ArcSin[x], Integrate[1/Sqrt[1-x^2],x]],
        ESameTest[ArcTan[x], Integrate[1/(1+x^2),x]]
    ], EKnownFailures[
        ESameTest[Log[x] - 1/2 Log[1 + 2 x^2], Integrate[1/(2 x^3 + x), x]]
    ]
};
`)

func resourcesCalculusMBytes() ([]byte, error) {
	return _resourcesCalculusM, nil
}

func resourcesCalculusM() (*asset, error) {
	bytes, err := resourcesCalculusMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/calculus.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesCombinatoricsM = []byte(`IntegerPartitions::usage = "`+"`"+`IntegerPartitions[n]`+"`"+` lists the possible ways to partition `+"`"+`n`+"`"+` into smaller integers.

`+"`"+`IntegerPartitions[n, k]`+"`"+` lists the possible ways to partition `+"`"+`n`+"`"+` into smaller integers, using up to `+"`"+`k`+"`"+` elements.";
Attributes[IntegerPartitions] = {Protected};
Tests`+"`"+`IntegerPartitions = {
    ESimpleExamples[
        EComment["Find the partitions of 4:"],
        ESameTest[{{4}, {3, 1}, {2, 2}, {2, 1, 1}, {1, 1, 1, 1}}, IntegerPartitions[4]],
        EComment["Find the partitions of 10, using a maximum of k = 2 integers:"],
        ESameTest[{{10}, {9, 1}, {8, 2}, {7, 3}, {6, 4}, {5, 5}}, IntegerPartitions[10, 2]]
    ], EFurtherExamples[
        EComment["The partitions of zero is a nested empty List:"],
        ESameTest[{{}}, IntegerPartitions[0]]
    ], ETests[
        ESameTest[{{1}}, IntegerPartitions[1]],
        ESameTest[{}, IntegerPartitions[-1]],
        ESameTest[{}, IntegerPartitions[-5]],
        ESameTest[IntegerPartitions[.5], IntegerPartitions[.5]],
        ESameTest[{{10}}, IntegerPartitions[10, 1]],
        ESameTest[{}, IntegerPartitions[10, 0]]
    ]
};

Permutations::usage = "`+"`"+`Permutations[list]`+"`"+` lists the possible permutations for a given list.";
Attributes[Permutations] = {Protected};
Tests`+"`"+`Permutations = {
    ESimpleExamples[
        EComment["Find the permutations of `+"`"+`{1, 2, 3}`+"`"+`:"],
        ESameTest[{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 1}}, Permutations[Range[3]]],
        EComment["`+"`"+`Permutations`+"`"+` ignores duplicates:"],
        ESameTest[{{1, 2, 2}, {2, 1, 2}, {2, 2, 1}}, Permutations[{1, 2, 2}]]
    ]
};

Multinomial::usage = "`+"`"+`Multinomial[n1, n2, ...]`+"`"+` gives the multinomial coefficient for the given term.";
Multinomial[seq___] := Factorial[Apply[Plus, {seq}]] / Apply[Times, Map[Factorial, {seq}]];
Attributes[Multinomial] = {Listable, NumericFunction, Orderless, ReadProtected, Protected};
Tests`+"`"+`Multinomial = {
    ESimpleExamples[
        EComment["Find the multinomial coefficient for the 1, 3, 1 term:"],
        ESameTest[20, Multinomial[1, 3, 1]],
        EComment["`+"`"+`Multinomial`+"`"+` handles symbolic arguments:"],
        ESameTest[Factorial[k+2] / Factorial[k], Multinomial[1,k,1]]
    ]
};

Factorial::usage = "`+"`"+`n!`+"`"+` returns the factorial of `+"`"+`n`+"`"+`.";
Attributes[Factorial] = {Listable, NumericFunction, ReadProtected, Protected};
Tests`+"`"+`Factorial = {
    ESimpleExamples[
        ESameTest[2432902008176640000, 20!],
        ESameTest[120, Factorial[5]]
    ], EFurtherExamples[
        ESameTest[1, Factorial[0]],
        ESameTest[ComplexInfinity, Factorial[-1]]
    ], ETests[
        ESameTest[1, Factorial[1]],
        ESameTest[1, Factorial[0]],
        ESameTest[1, Factorial[-0]],
        ESameTest[ComplexInfinity, Factorial[-10]],
        ESameTest[120, Factorial[5]],
        ESameTest[Indeterminate, 0 * Infinity],
        ESameTest[Indeterminate, 0 * ComplexInfinity]
    ]
};
`)

func resourcesCombinatoricsMBytes() ([]byte, error) {
	return _resourcesCombinatoricsM, nil
}

func resourcesCombinatoricsM() (*asset, error) {
	bytes, err := resourcesCombinatoricsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/combinatorics.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesComparisonM = []byte(`NumericQ::usage =  "`+"`"+`NumericQ[expr]`+"`"+` returns `+"`"+`True`+"`"+` if `+"`"+`expr`+"`"+` is a numeric quantity, `+"`"+`False`+"`"+` otherwise.";
NumericQ[e_] := If[NumberQ[N[e]], True, False];
Attributes[NumericQ] = {Protected};
Tests`+"`"+`NumericQ = {
    ESimpleExamples[
        ESameTest[True, NumericQ[5]],
        ESameTest[False, NumericQ[a]],
        ESameTest[False, NumericQ[Sin[a]]],
        ESameTest[True, NumericQ[Sin[2]]]
    ], ETests[
        ESameTest[True, NumericQ[Cos[2]]],
        ESameTest[False, NumericQ[Sqrt[a]]],
        ESameTest[False, NumericQ[Sqrt[Sin[2]]*Sqrt[Sin[x]]]],
        ESameTest[True, NumericQ[Sqrt[2]]]
    ]
};
Equal::usage = "`+"`"+`lhs == rhs`+"`"+` evaluates to True or False if equality or inequality is known.";
(*TODO(corywalker): Ideally this should be handled in the core. Also should
  support arbitrary number of arguments.*)
Equal[a_?NumericQ, b_?NumericQ] := (a//N) == (b//N);
Attributes[Equal] = {Protected};
Tests`+"`"+`Equal = {
    ESimpleExamples[
        EComment["Expressions known to be equal will evaluate to True:"],
        EStringTest["True", "9*x==x*9"],
        EComment["Sometimes expressions may or may not be equal, or Expreduce does not know how to test for equality. In these cases, the statement will remain unevaluated:"],
        EStringTest["(9*x == 10*x)", "9*x==x*10"],
        EComment["Equal considers Integers and Reals that are close enough to be equal:"],
        EStringTest["5", "tmp=5"],
        EStringTest["True", "tmp==5"],
        EStringTest["True", "tmp==5."],
        EStringTest["True", "tmp==5.00000"],
        EComment["Equal can test for Rational equality:"],
        EStringTest["False", "4/3==3/2"],
        EStringTest["True", "4/3==8/6"]
    ], EFurtherExamples[
        EStringTest["True", "If[xx == 2, yy, zz] == If[xx == 2, yy, zz]"],
        EComment["Equal does not match patterns:"],
        ESameTest[{1, 2, 3} == _List, {1, 2, 3} == _List],
        EComment["This functionality is reserved for MatchQ:"],
        ESameTest[True, MatchQ[{1, 2, 3}, _List]]
    ], ETests[
        EStringTest["5", "tmp=5"],
        EStringTest["True", "tmp==5"],
        EStringTest["True", "5==tmp"],
        EStringTest["False", "tmp==6"],
        EStringTest["False", "6==tmp"],
        EStringTest["(a == b)", "a==b"],
        EStringTest["True", "a==a"],
        EStringTest["(a == 2)", "a==2"],
        EStringTest["(2 == a)", "2==a"],
        EStringTest["(2 == a + b)", "2==a+b"],
        EStringTest["(2. == a)", "2.==a"],
        EStringTest["(2^k == a)", "2^k==a"],
        EStringTest["(2^k == 2^a)", "2^k==2^a"],
        EStringTest["(2^k == 2 + k)", "2^k==k+2"],
        EStringTest["(k == 2*k)", "k==2*k"],
        EStringTest["(2*k == k)", "2*k==k"],
        EStringTest["True", "1+1==2"],
        EStringTest["(y == b + m*x)", "y==m*x+b"],
        EStringTest["True", "1==1."],
        EStringTest["True", "1.==1"],
        EStringTest["True", "(x==2)==(x==2)"],
        EStringTest["True", "(x==2.)==(x==2)"],
        EStringTest["True", "(x===2.)==(x===2)"],
        EStringTest["(If[xx == 3, yy, zz] == If[xx == 2, yy, zz])", "If[xx == 3, yy, zz] == If[xx == 2, yy, zz]"],
        EStringTest["True", "(1 == 2) == (2 == 3)"],
        EStringTest["False", "(1 == 2) == (2 == 2)"],
        ESameTest[True, foo[x == 2, y, x] == foo[x == 2, y, x]],
        ESameTest[True, foo[x == 2, y, x] == foo[x == 2., y, x]],
        ESameTest[foo[x == 2, y, x] == foo[x == 2., y, y], foo[x == 2, y, x] == foo[x == 2., y, y]],
        ESameTest[foo[x == 2, y, x] == bar[x == 2, y, x], foo[x == 2, y, x] == bar[x == 2, y, x]],
        EStringTest["(foo[x, y, z] == foo[x, y])", "foo[x, y, z] == foo[x, y]"],
        EStringTest["(foo[x, y, z] == foo[x, y, 1])", "foo[x, y, z] == foo[x, y, 1]"],
        ESameTest[True, foo[x, y, 1] == foo[x, y, 1]],
        ESameTest[True, foo[x, y, 1.] == foo[x, y, 1]],
        ESameTest[True, Equal[test]],
        ESameTest[True, Equal[]],
        ESameTest[False, (-1)^(1/6)==-I],
        ESameTest[True, (-1)^(1/6)==(-1)^(1/6)//N],
        ESameTest[True, (2^(-1/2)*E^((-1/2)*x^2)*Pi^(-1/2)/.x->(-Sqrt[2] Sqrt[Log[5 Sqrt[2/\[Pi]]]]//N))==.1],
        ESameTest[True, 1.0000000000005==1.00000000000051],
        ESameTest[False, 1.000000000005==1.0000000000051],
        ESameTest[True, 100.00000000005==100.000000000051],
        ESameTest[True, 1000000000000.5==1000000000000.51],
    ]
};

Unequal::usage = "`+"`"+`lhs != rhs`+"`"+` evaluates to True if inequality is known or False if equality is known.";
Attributes[Unequal] = {Protected};
Tests`+"`"+`Unequal = {
    ESimpleExamples[
        EComment["Expressions known to be unequal will evaluate to True:"],
        EStringTest["True", "9 != 8"],
        EComment["Sometimes expressions may or may not be unequal, or Expreduce does not know how to test for inequality. In these cases, the statement will remain unevaluated:"],
        EStringTest["((9*x) != (10*x))", "9*x != x*10"],
        EComment["Unequal considers Integers and Reals that are close enough to be equal:"],
        EStringTest["5", "tmp=5"],
        EStringTest["False", "tmp != 5"],
        EStringTest["False", "tmp != 5."],
        EStringTest["False", "tmp != 5.00000"],
        EComment["Unequal can test for Rational inequality:"],
        EStringTest["True", "4/3 != 3/2"],
        EStringTest["False", "4/3 != 8/6"]
    ]
};

SameQ::usage = "`+"`"+`lhs === rhs`+"`"+` evaluates to True if `+"`"+`lhs`+"`"+` and `+"`"+`rhs`+"`"+` are identical after evaluation, False otherwise.";
Attributes[SameQ] = {Protected};
Tests`+"`"+`SameQ = {
    ESimpleExamples[
        EStringTest["True", "a===a"],
        EStringTest["True", "5 === 5"],
        EComment["Unlike Equal, SameQ does not forgive differences between Integers and Reals:"],
        EStringTest["False", "5 === 5."],
        EComment["SameQ considers the arguments of all expressions and subexpressions:"],
        ESameTest[True, foo[x == 2, y, x] === foo[x == 2, y, x]],
        ESameTest[False, foo[x == 2, y, x] === foo[x == 2., y, x]]
    ], EFurtherExamples[
        EComment["SameQ does not match patterns:"],
        ESameTest[False, {1, 2, 3} === _List],
        EComment["This functionality is reserved for MatchQ:"],
        ESameTest[True, MatchQ[{1, 2, 3}, _List]]
    ], ETests[
        EStringTest["5", "tmp=5"],
        EStringTest["False", "a===b"],
        EStringTest["True", "tmp===5"],
        EStringTest["False", "tmp===5."],
        EStringTest["True", "1+1===2"],
        EStringTest["False", "y===m*x+b"],
        EStringTest["False", "1===1."],
        EStringTest["False", "1.===1"],
        EStringTest["True", "(x===2.)===(x===2)"],
        EStringTest["False", "(x==2.)===(x==2)"],
        EStringTest["True", "If[xx == 2, yy, zz] === If[xx == 2, yy, zz]"],
        EStringTest["False", "If[xx == 2, yy, zz] === If[xx == 2., yy, zz]"],
        EStringTest["False", "If[xx == 3, yy, zz] === If[xx == 2, yy, zz]"],
        EStringTest["False", "(x == y) === (y == x)"],
        EStringTest["True", "(x == y) === (x == y)"],
        ESameTest[False, foo[x == 2, y, x] === foo[x == 2., y, y]],
        ESameTest[False, foo[x == 2, y, x] === bar[x == 2, y, x]],
        ESameTest[False, foo[x, y, z] === foo[x, y]],
        ESameTest[False, foo[x, y, z] === foo[x, y, 1]],
        ESameTest[True, foo[x, y, 1] === foo[x, y, 1]],
        ESameTest[False, foo[x, y, 1.] === foo[x, y, 1]],
        ESameTest[True, SameQ[test]],
        ESameTest[True, SameQ[]]
    ]
};

UnsameQ::usage = "`+"`"+`lhs =!= rhs`+"`"+` evaluates to False if `+"`"+`lhs`+"`"+` and `+"`"+`rhs`+"`"+` are identical after evaluation, True otherwise.";
Attributes[UnsameQ] = {Protected};
Tests`+"`"+`UnsameQ = {
    ESimpleExamples[
        EStringTest["False", "a=!=a"],
        EStringTest["False", "5 =!= 5"],
        EStringTest["True", "a=!=b"]
    ], ETests[
        EStringTest["False", "a=!=b=!=a"],
        EStringTest["True", "UnsameQ[]"]
    ]
};

AtomQ::usage = "`+"`"+`AtomQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is an atomic type, and False if `+"`"+`expr`+"`"+` is a full expression.";
Attributes[AtomQ] = {Protected};
Tests`+"`"+`AtomQ = {
    ESimpleExamples[
        ESameTest[True, AtomQ["hello"]],
        ESameTest[True, AtomQ[5/3]],
        ESameTest[True, AtomQ[hello]],
        ESameTest[False, AtomQ[a/b]],
        ESameTest[False, AtomQ[bar[x]]]
    ]
};

NumberQ::usage = "`+"`"+`NumberQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is numeric, otherwise False.";
Attributes[NumberQ] = {Protected};
Tests`+"`"+`NumberQ = {
    ESimpleExamples[
        ESameTest[True, NumberQ[2]],
        ESameTest[True, NumberQ[2.2]],
        ESameTest[True, NumberQ[Rational[5, 2]]],
        ESameTest[False, NumberQ[Infinity]],
        ESameTest[False, NumberQ[Sqrt[2]]],
        ESameTest[False, NumberQ[randomvar]],
        ESameTest[False, NumberQ["hello"]]
    ]
};

Less::usage = "`+"`"+`a < b`+"`"+` returns True if `+"`"+`a`+"`"+` is less than `+"`"+`b`+"`"+`.";
Attributes[Less] = {Protected};
Tests`+"`"+`Less = {
    ESimpleExamples[
        ESameTest[a < b, a < b],
        ESameTest[True, 1 < 2],
        ESameTest[True, 3 < 5.5],
        ESameTest[False, 5.5 < 3],
        ESameTest[False, 3 < 3]
    ]
};

Greater::usage = "`+"`"+`a > b`+"`"+` returns True if `+"`"+`a`+"`"+` is greater than `+"`"+`b`+"`"+`.";
Attributes[Greater] = {Protected};
Tests`+"`"+`Greater = {
    ESimpleExamples[
        ESameTest[a > b, a > b],
        ESameTest[False, 1 > 2],
        ESameTest[False, 3 > 5.5],
        ESameTest[True, 5.5 > 3],
        ESameTest[False, 3 > 3]
    ]
};

LessEqual::usage = "`+"`"+`a <= b`+"`"+` returns True if `+"`"+`a`+"`"+` is less than or equal to `+"`"+`b`+"`"+`.";
-Infinity <= (_Integer | _Real | _Rational) := True;
Infinity <= (_Integer | _Real | _Rational) := False;
(_Integer | _Real | _Rational) <= -Infinity := False;
(_Integer | _Real | _Rational) <= Infinity := True;
Attributes[LessEqual] = {Protected};
Tests`+"`"+`LessEqual = {
    ESimpleExamples[
        ESameTest[a <= b, a <= b],
        ESameTest[True, 1 <= 2],
        ESameTest[True, 3 <= 5.5],
        ESameTest[False, 5.5 <= 3],
        ESameTest[True, 3 <= 3]
    ]
};

GreaterEqual::usage = "`+"`"+`a >= b`+"`"+` returns True if `+"`"+`a`+"`"+` is greater than or equal to `+"`"+`b`+"`"+`.";
Attributes[GreaterEqual] = {Protected};
Tests`+"`"+`GreaterEqual = {
    ESimpleExamples[
        ESameTest[a >= b, a >= b],
        ESameTest[False, 1 >= 2],
        ESameTest[False, 3 >= 5.5],
        ESameTest[True, 5.5 >= 3],
        ESameTest[True, 3 >= 3]
    ]
};

Positive::usage = "`+"`"+`Positive[x]`+"`"+` returns `+"`"+`True`+"`"+` if `+"`"+`x`+"`"+` is positive.";
Positive[x_?NumberQ] := x > 0;
Attributes[Positive] = {Listable, Protected};
Tests`+"`"+`Positive = {
    ESimpleExamples[
        ESameTest[{True, False, False, Positive[a]}, Map[Positive, {1, 0, -1, a}]]
    ]
};

Negative::usage = "`+"`"+`Negative[x]`+"`"+` returns `+"`"+`True`+"`"+` if `+"`"+`x`+"`"+` is positive.";
Negative[x_?NumberQ] := x < 0;
Attributes[Negative] = {Listable, Protected};
Tests`+"`"+`Negative = {
    ESimpleExamples[
        ESameTest[{False, False, True, Negative[a]}, Map[Negative, {1, 0, -1, a}]]
    ]
};

Max::usage = "`+"`"+`Max[e1, e2, ...]`+"`"+` the maximum of the expressions.";
Attributes[Max] = {Flat, NumericFunction, OneIdentity, Orderless, Protected};
Tests`+"`"+`Max = {
    ESimpleExamples[
        ESameTest[3, Max[1,2,3]],
        ESameTest[Max[3,a], Max[1,a,3]]
    ], ETests[
        ESameTest[Max[3,a,b], Max[b,1,a,3]],
        ESameTest[Max[3.,a,b], Max[b,1,a,3,3.]],
        ESameTest[Max[3.1,a,b], Max[b,1,a,3,3.,3.1]],
        ESameTest[Max[99/2,a,b], Max[b,1,a,3,3.,3.1 ,Rational[99,2]]],
        ESameTest[-Infinity, Max[]],
        ESameTest[Max[99/2,a,b], Max[{b,1,a},3,3.,3.1 ,Rational[99,2]]],
        ESameTest[Max[99/2,foo[b,1,a]], Max[foo[b,1,a],3,3.,3.1 ,Rational[99,2]]]
    ], EKnownDangerous[
        ESameTest[Max[a,b,c,d], Max[{c,d},{b,a}]],
        ESameTest[Max[a,b,c,d], Max[{c,{d}},{b,a}]]
    ]
};

Min::usage = "`+"`"+`Min[e1, e2, ...]`+"`"+` the maximum of the expressions.";
Attributes[Min] = {Flat, NumericFunction, OneIdentity, Orderless, Protected};
Tests`+"`"+`Min = {
    ESimpleExamples[
        ESameTest[1, Min[1,2,3]],
        ESameTest[Min[1,a], Min[1,a,3]]
    ], ETests[
        ESameTest[Min[1,a,b], Min[b,1,a,3]],
        ESameTest[Min[1,a,b], Min[b,1,a,3,3.]],
        ESameTest[Min[1,a,b], Min[b,1,a,3,3.,3.1]],
        ESameTest[Min[1,a,b], Min[b,1,a,3,3.,3.1 ,Rational[99,2]]],
        ESameTest[Infinity, Min[]],
    ], EKnownDangerous[
        ESameTest[Min[a,b,c,d], Min[{c,d},{b,a}]],
        ESameTest[Min[a,b,c,d], Min[{c,{d}},{b,a}]]
    ]
};

PossibleZeroQ::usage = "`+"`"+`PossibleZeroQ[e]`+"`"+` returns True if `+"`"+`e`+"`"+` is most likely equivalent to zero.";
Attributes[PossibleZeroQ] = {Listable, Protected};
PossibleZeroQ[e_] := e === 0 || e === 0.;
Tests`+"`"+`PossibleZeroQ = {
    ESimpleExamples[
        ESameTest[True, PossibleZeroQ[a-a]],
        ESameTest[False, PossibleZeroQ[a-b]]
    ]
};

MinMax::usage = "`+"`"+`MinMax[l]`+"`"+` returns `+"`"+`{Min[l], Max[l]}`+"`"+`.";
Attributes[MinMax] = {Protected};
MinMax[l_List] := {Min[l], Max[l]};
Tests`+"`"+`MinMax = {
    ESimpleExamples[
        ESameTest[{1, 5}, MinMax[Range[5]]]
    ]
};

Element::usage = "`+"`"+`Element[i, s]`+"`"+` checks if `+"`"+`i`+"`"+` is an element of `+"`"+`s`+"`"+`.";
Attributes[Element] = {Protected};
Element[i_Integer, Integers] := True;
Tests`+"`"+`Element = {
    ESimpleExamples[
        ESameTest[True, Element[-1, Integers]]
    ]
};

Attributes[Inequality] = {Protected};
Tests`+"`"+`Inequality = {
    ESimpleExamples[
        ESameTest[True, Inequality[-Pi,Less,0,LessEqual,Pi]],
        ESameTest[0<=a, Inequality[-Pi,Less,0,LessEqual,a]],
    ], ETests[
        ESameTest[Inequality[c, Less, 0, Less, a], Inequality[c,Less,0,Less,a]],
        ESameTest[c<0, Inequality[c,Less,0]],
        ESameTest[Inequality[c,Less], Inequality[c,Less]],
        ESameTest[True, Inequality[c]],
        ESameTest[Inequality[], Inequality[]],
        ESameTest[True, Inequality[False]],
        ESameTest[Inequality[-1, Less], Inequality[-1,Less]],
        ESameTest[Inequality[-1, Less, a, Less, 0], Inequality[-1,Less,a,Less,0,Less,1]],
        ESameTest[Inequality[0, Less, a, Less, 1], Inequality[-1,Less,0,Less,a,Less,1]],
        ESameTest[False, Inequality[-1,Less,a,Less,-2]],
        ESameTest[0>=a, Inequality[-Pi,Less,0,GreaterEqual,a]],
        ESameTest[0<a&&Inequality[a,Greater,0,Greater,k], Inequality[0,Less,a,Greater,0,Greater,k]],
        ESameTest[0>a&&a<0, Inequality[0,Greater,a,Less,0]],
        ESameTest[Inequality[0, Less, a, Less, 1], Inequality[0,Less,a,Less,1]],
        ESameTest[0<a&&a<1, 0<a && a<1],
        ESameTest[a<b<=c, Inequality[a,Less,b,LessEqual,c]],
        ESameTest[a<b<=c==d&&d>=e>f, Inequality[a,Less,b,LessEqual,c,Equal,d,GreaterEqual,e,Greater,f]],
        ESameTest[a>b>=c==d&&d<=e<f, Inequality[a,Greater,b,GreaterEqual,c,Equal,d,LessEqual,e,Less,f]],
        ESameTest[a>b>=c==d>=e&&e<f, Inequality[a,Greater,b,GreaterEqual,c,Equal,d,GreaterEqual,e,Less,f]],
        ESameTest[False, Inequality[a,Greater,1,GreaterEqual,c,Equal,d,GreaterEqual,5,Less,f]],
        ESameTest[a<1<4<=b, a<1<2<3<4<=b],
        ESameTest[a<1<4<=b<5, a<1<2<3<4<=b<5],
    ], EKnownFailures[
        ESameTest[Inequality[0,Lesks,1], Inequality[-1,Less,0,Lesks,1]],
    ]
};
`)

func resourcesComparisonMBytes() ([]byte, error) {
	return _resourcesComparisonM, nil
}

func resourcesComparisonM() (*asset, error) {
	bytes, err := resourcesComparisonMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/comparison.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesEquationdataM = []byte(`solveQuadratic[a_, b_, c_, x_] := {{x->(-b-Sqrt[b^2-4 a c])/(2 a)},{x->(-b+Sqrt[b^2-4 a c])/(2 a)}};
solveCubic[d_,c_,b_,a_,x_] := {{x->-(c/(3 d))-(2^(1/3) (-c^2+3 b d))/(3 d (-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3))+(-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3)/(3 2^(1/3) d)},{x->-(c/(3 d))+((1+I Sqrt[3]) (-c^2+3 b d))/(3 2^(2/3) d (-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3))-(1/(6 2^(1/3) d))(1-I Sqrt[3]) (-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3)},{x->-(c/(3 d))+((1-I Sqrt[3]) (-c^2+3 b d))/(3 2^(2/3) d (-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3))-(1/(6 2^(1/3) d))(1+I Sqrt[3]) (-2 c^3+9 b c d-27 a d^2+Sqrt[4 (-c^2+3 b d)^3+(-2 c^3+9 b c d-27 a d^2)^2])^(1/3)}};
solveQuartic[e_,d_,c_,b_,a_,x_] := {{x->-(d/(4 e))-1/2 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3)))-1/2 \[Sqrt](d^2/(2 e^2)-(4 c)/(3 e)-(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(-(d^3/e^3)+(4 c d)/e^2-(8 b)/e)/(4 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3)))))},{x->-(d/(4 e))-1/2 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3)))+1/2 \[Sqrt](d^2/(2 e^2)-(4 c)/(3 e)-(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(-(d^3/e^3)+(4 c d)/e^2-(8 b)/e)/(4 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3)))))},{x->-(d/(4 e))+1/2 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3)))-1/2 \[Sqrt](d^2/(2 e^2)-(4 c)/(3 e)-(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(-(d^3/e^3)+(4 c d)/e^2-(8 b)/e)/(4 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3)))))},{x->-(d/(4 e))+1/2 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3)))+1/2 \[Sqrt](d^2/(2 e^2)-(4 c)/(3 e)-(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))-(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+Sqrt[-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2])^(1/3))+(-(d^3/e^3)+(4 c d)/e^2-(8 b)/e)/(4 \[Sqrt](d^2/(4 e^2)-(2 c)/(3 e)+(2^(1/3) (c^2-3 b d+12 a e))/(3 e (2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3))+(1/(3 2^(1/3) e))((2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e+\[Sqrt](-4 (c^2-3 b d+12 a e)^3+(2 c^3-9 b c d+27 a d^2+27 b^2 e-72 a c e)^2))^(1/3)))))}}/;FreeQ[{a,b,c,d,e},x];
`)

func resourcesEquationdataMBytes() ([]byte, error) {
	return _resourcesEquationdataM, nil
}

func resourcesEquationdataM() (*asset, error) {
	bytes, err := resourcesEquationdataMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/equationdata.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesExpressionM = []byte(`Head::usage = "`+"`"+`Head[expr]`+"`"+` returns the head of the expression.";
Attributes[Head] = {Protected};
Tests`+"`"+`Head = {
    ESimpleExamples[
        ESameTest[f, Head[f[x]]],
        ESameTest[Symbol, Head[x]],
        ESameTest[List, Head[{x}]],
        ESameTest[Plus, Head[a + b]],
        ESameTest[Integer, Head[1]],
        ESameTest[Real, Head[1.]],
        ESameTest[Rational, Head[2/7]],
        ESameTest[Rational, Head[1/7]],
        ESameTest[String, Head["1"]],
        ESameTest[Plus, Head[Head[(a + b)[x]]]]
    ]
};

Depth::usage = "`+"`"+`Depth[expr]`+"`"+` returns the depth of `+"`"+`expr`+"`"+`.";
Attributes[Depth] = {Protected};
Tests`+"`"+`Depth = {
    ESimpleExamples[
        ESameTest[1, Depth[foo]],
        ESameTest[2, Depth[{foo}]],
        ESameTest[2, Depth[bar[foo, bar]]],
        ESameTest[3, Depth[foo[foo[]]]],
        ESameTest[1, Depth[3]],
        ESameTest[1, Depth[3.5]],
        ESameTest[1, Depth[3/5]],
        ESameTest[2, Depth[foo[{{{}}}][]]]
    ]
};

Length::usage = "`+"`"+`Length[expr]`+"`"+` returns the length of `+"`"+`expr`+"`"+`.";
Attributes[Length] = {Protected};
Tests`+"`"+`Length = {
    ESimpleExamples[
        ESameTest[4, Length[{1,2,3,4}]],
        ESameTest[0, Length[{}]],
        ESameTest[1, Length[{5}]]
    ], EFurtherExamples[
        EComment["`+"`"+`expr`+"`"+` need not have a `+"`"+`List`+"`"+` head:"],
        ESameTest[2, Length[foo[1, 2]]],
        EComment["The length of an atomic expression is zero:"],
        ESameTest[0, Length[a]],
        ESameTest[0, Length[2.5]],
        ESameTest[0, Length["hello"]]
    ]
};

Sequence::usage = "`+"`"+`Sequence[e1, e2, ...]`+"`"+` holds a list of expressions to be automatically inserted into another function.";
Attributes[Sequence] = {Protected};
Tests`+"`"+`Sequence = {
    ESimpleExamples[
        EComment["Sequence arguments are automatically inserted into the parent functions:"],
        ESameTest[foo[a, 2, 3], foo[a, Sequence[2, 3]]],
        EComment["Outside of the context of functions, Sequence objects do not merge:"],
        ESameTest[Sequence[2, 3], Sequence[2, 3]],
        ESameTest[14, Sequence[2, 3] + Sequence[5, 4]],
        ESameTest[120, Sequence[2, 3]*Sequence[5, 4]]
    ], EFurtherExamples[
        EComment["Empty `+"`"+`Sequence[]`+"`"+` objects effectively disappear:"],
        ESameTest[foo[], foo[Sequence[]]]
    ], ETests[
        ESameTest[Sequence[2], Sequence[2]],
        ESameTest[Sequence[2, 3], Sequence[2, 3]],
        ESameTest[foo[2, 3], foo[Sequence[2, 3]]],
        ESameTest[foo[2], foo[Sequence[2]]],
        ESameTest[foo[14], foo[Sequence[2, 3] + Sequence[5, 4]]],
        ESameTest[foo[2, 3, 5, 4], foo[Sequence[2, 3], Sequence[5, 4]]],
        ESameTest[False, Sequence[2, 3] == Sequence[2, 3]],
        ESameTest[True, Sequence[2, 2] == Sequence[2]],
        ESameTest[False, Sequence[2, 3] === Sequence[2, 3]],
        ESameTest[True, Sequence[2, 2] === Sequence[2]]
    ]
};

Evaluate::usage = "`+"`"+`Evaluate[expr]`+"`"+` evaluates to an evaluated form of `+"`"+`expr`+"`"+`, even when under hold conditions.";
Attributes[Evaluate] = {Protected};
Tests`+"`"+`Evaluate = {
    ESimpleExamples[
        EStringTest["Hold[4, 2 + 1]", "Hold[Evaluate[1 + 3], 2 + 1]"],
        EStringTest["Hold[foo[Evaluate[1 + 1]]]", "Hold[foo[Evaluate[1 + 1]]]"],
        EStringTest["Hold[4, 7, 2 + 1]", "Hold[Evaluate[1 + 3, 5 + 2], 2 + 1]"],
        EStringTest["Hold[1 + 3, 5 + 2, 2 + 1]", "Hold[Sequence[1 + 3, 5 + 2], 2 + 1]"]
    ]
};

Hold::usage = "`+"`"+`Hold[expr]`+"`"+` prevents automatic evaluation of `+"`"+`expr`+"`"+`.";
Attributes[Hold] = {HoldAll, Protected};
Tests`+"`"+`Hold = {
    ESimpleExamples[
        EStringTest["Hold[5^3]", "Hold[Power[5, 3]]"],
        EStringTest["Hold[5.^3.]", "Hold[Power[5., 3.]]"]
    ]
};

HoldForm::usage = "`+"`"+`HoldForm[expr]`+"`"+` prevents automatic evaluation of `+"`"+`expr`+"`"+`. Prints as `+"`"+`expr`+"`"+`.";
Attributes[HoldForm] = {HoldAll, Protected};
Tests`+"`"+`HoldForm = {
    ESimpleExamples[
        EStringTest["(5^3)", "HoldForm[Power[5, 3]]"],
        EStringTest["(5.^3.)", "HoldForm[Power[5., 3.]]"]
    ]
};

Flatten::usage = "`+"`"+`Flatten[list]`+"`"+` flattens out lists in `+"`"+`list`+"`"+`.";
Attributes[Flatten] = {Protected};
Tests`+"`"+`Flatten = {
    ESimpleExamples[
        ESameTest[Flatten[1], Flatten[1]],
        EComment["Input must be nonatomic:"],
        ESameTest[{1}, Flatten[{1}]],
        ESameTest[{1}, Flatten[{{{{1}}}}]],
        ESameTest[{1, 2, 3}, Flatten[{{{{1}, 2}}, 3}]],
        ESameTest[{1, 2, 3, 4}, Flatten[{{{{1}, 2}}, 3, 4}]],
        ESameTest[{-1, 1, 2, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}]],
        EComment["A level of zero means no change:"],
        ESameTest[{-1, {{{1}, 2}}, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}, 0]],
        ESameTest[{-1, {{1}, 2}, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}, 1]],
        ESameTest[{-1, {1}, 2, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}, 2]],
        ESameTest[{-1, 1, 2, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}, 3]],
        ESameTest[{-1, 1, 2, 3, 4}, Flatten[{-1, {{{1}, 2}}, 3, 4}, 4]],
        ESameTest[Flatten[{-1, {{{1}, 2}}, 3, 4}, a], Flatten[{-1, {{{1}, 2}}, 3, 4}, a]],
        ESameTest[{-1, foo[{{1}, 2}], 3, 4}, Flatten[{-1, {foo[{{1}, 2}]}, 3, 4}, 999]],
        ESameTest[{-1, foo[{{1}, 2}], 3, 4}, Flatten[{-1, {foo[{{1}, 2}]}, 3, 4}, 999]],
        ESameTest[{-1, 1[{{1}, 2}], 3, 4}, Flatten[{-1, {1[{{1}, 2}]}, 3, 4}, 999]]
    ]
};

LeafCount::usage = "`+"`"+`LeafCount[e]`+"`"+` returns the count of leaves in `+"`"+`e`+"`"+`.";
Attributes[LeafCount] = {Protected};
Tests`+"`"+`LeafCount = {
    ESimpleExamples[
        ESameTest[3, LeafCount[a+b]],
        ESameTest[8, LeafCount[a^2 + b^(c!)]],
        ESameTest[1, LeafCount[a]]
    ]
};

Unevaluated::usage = "`+"`"+`Unevaluated[e]`+"`"+` do not evaluate `+"`"+`e`+"`"+` in an expression, but treat as `+"`"+`e`+"`"+`.";
Attributes[Unevaluated] = {HoldAllComplete, Protected};
Tests`+"`"+`Unevaluated = {
    ESimpleExamples[
        ESameTest[{1,2}, List@@Unevaluated[1+2]],
    ]
};

HoldComplete::usage = "`+"`"+`HoldComplete[e1, e2, ...]`+"`"+` holds evaluation of its arguments, even evaluation that would take place under `+"`"+`Hold`+"`"+`.";
Attributes[HoldComplete] = {HoldAllComplete, Protected};
Tests`+"`"+`HoldComplete = {
    ESimpleExamples[
        ESameTest[HoldComplete[Evaluate[a+a],2+2,Sequence[a,b]], HoldComplete[Evaluate[a+a],2+2,Sequence[a,b]]],
        ESameTest[3, HoldComplete[Evaluate[a + a], 2 + 2, Sequence[a, b]] // Length],
    ]
};
`)

func resourcesExpressionMBytes() ([]byte, error) {
	return _resourcesExpressionM, nil
}

func resourcesExpressionM() (*asset, error) {
	bytes, err := resourcesExpressionMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/expression.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesFlowcontrolM = []byte(`If::usage = "`+"`"+`If[cond, iftrue, iffalse]`+"`"+` returns `+"`"+`iftrue`+"`"+` if `+"`"+`cond`+"`"+` is True, and `+"`"+`iffalse`+"`"+` if `+"`"+`cond`+"`"+` is False.";
Attributes[If] = {HoldRest, Protected};
Tests`+"`"+`If = {
    ESimpleExamples[
        EStringTest["9", "x=9"],
        EStringTest["18", "If[x+3==12, x*2, x+3]"],
        EStringTest["12", "If[x+3==11, x*2, x+3]"]
    ], EFurtherExamples[
        EComment["Undefined conditions leave the statement unevaluated."],
        EStringTest["If[undefined, a, b]", "If[undefined, a, b]"]
    ], ETests[
        EStringTest["True", "t=True"],
        EStringTest["True", "t"],
        EStringTest["False", "f=False"],
        EStringTest["False", "f"],
        EStringTest["True", "If[t, True, False]"],
        EStringTest["False", "If[f, True, False]"],
        EStringTest["False", "If[t, False, True]"],
        EStringTest["True", "If[f, False, True]"],
        ESameTest[itsfalse, If[1 == 2, itstrue, itsfalse]],
        ESameTest[itsfalse, If[1 == 2, itstrue, itsfalse] /. (2 -> 1)],
        ESameTest[itstrue, If[1 == k, itstrue, itsfalse] /. (k -> 1)],
        ESameTest[If[1 == k, itstrue, itsfalse], If[1 == k, itstrue, itsfalse]],
        ESameTest[a, If[True, a]],
        ESameTest[Null, If[False, a]]
    ]
};

While::usage = "`+"`"+`While[cond, body]`+"`"+` evaluates `+"`"+`cond`+"`"+`, and if it returns True, evaluates `+"`"+`body`+"`"+`. This happens repeatedly.";
Attributes[While] = {HoldAll, Protected};
Tests`+"`"+`While = {
    ESimpleExamples[
        ESameTest[1, a=1],
        ESameTest[Null, While[a != 5, a = a + 1]],
        ESameTest[5, a]
    ]
};

CompoundExpression::usage = "`+"`"+`CompoundExpression[e1, e2, ...]`+"`"+` evaluates each expression in order and returns the result of the last one.";
Attributes[CompoundExpression] = {HoldAll, ReadProtected, Protected};
Tests`+"`"+`CompoundExpression = {
    ESimpleExamples[
        EComment["The result of the first expression is not included in the output, but the result of the second is:"],
        ESameTest[3, a = 5; a - 2],
        EComment["Including a trailing semicolon causes the expression to return `+"`"+`Null`+"`"+`:"],
        ESameTest[Null, a = 5; a - 2;]
    ]
};

Return::usage = "`+"`"+`Return[x]`+"`"+` returns `+"`"+`x`+"`"+` immediately.";
Attributes[Return] = {Protected};
Tests`+"`"+`Return = {
    ESimpleExamples[
        ESameTest[x, myreturnfunc:=(Return[x];hello);myreturnfunc],
        ESameTest[3, ret[x_]:=(Return[x];hello);ret[3]],
        ESameTest[3, myfoo:=(i=1;While[i<5,If[i===3,Return[i]];i=i+1]);myfoo],
        ESameTest[Return[3], Return[3]],
        ESameTest[Null, retother:=(Return[];hello);retother]
    ]
};

Which::usage = "`+"`"+`Which[cond, res, cond, res, ...]`+"`"+` tries each `+"`"+`cond`+"`"+` in sequence and returns the corresponding result if True.";
Attributes[Which] = {HoldAll, Protected};
Tests`+"`"+`Which = {
    ESimpleExamples[
        ESameTest[b, Which[1>2, a, 1<2, b]],
        ESameTest[Null, Which[2>2, a, 2<2, b]]
    ], ETests[
        ESameTest[Which[True, a, b], Which[True, a, b]],
        ESameTest[Null, Which[False,a,False,b]]
    ]
};

Switch::usage = "`+"`"+`Switch[e, case1, val1, case2, val2, ...]`+"`"+` attempts to match `+"`"+`e`+"`"+` with the cases in order. If a match is found, returns the corresponding value.";
Attributes[Switch] = {HoldRest, Protected, ReadProtected};
Tests`+"`"+`Switch = {
    ESimpleExamples[
        ESameTest[b, Switch[z,_,b,z,c]],
        ESameTest[k, Switch[z,k_Symbol,k]],
        ESameTest[Switch[z,1], Switch[z,1]],
        ESameTest[Switch[z,d,b,l,c], Switch[z,d,b,l,c]]
    ], ETests[
        ESameTest[Switch[], Switch[]],
        ESameTest[Switch[z], Switch[z]]
    ]
};

With::usage = "`+"`"+`With[{s1=v1, s2=v2, ...}, body]`+"`"+` locally replaces the specified symbols in body with their respective values.";
Attributes[With] = {HoldAll, Protected};
Tests`+"`"+`With = {
    ESimpleExamples[
        ESameTest[{2, 6}, With[{x=2},{x,3*x}]],
        ESameTest[{2, 9}, With[{x:=2,y:=3},{x,3*y}]]
    ]
};

Do::usage = "`+"`"+`Do[expr, n]`+"`"+` evaluates `+"`"+`expr`+"`"+` `+"`"+`n`+"`"+` times.

`+"`"+`Table[expr, {sym, n}]`+"`"+` evaluates `+"`"+`expr`+"`"+` with `+"`"+`sym`+"`"+` = 1 to `+"`"+`n`+"`"+`.

`+"`"+`Table[expr, {sym, m, n}]`+"`"+` evaluates `+"`"+`expr`+"`"+` with `+"`"+`sym`+"`"+` = `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`.";
Attributes[Do] = {HoldAll, Protected};
Tests`+"`"+`Do = {
    ESimpleExamples[
        ESameTest[7, Catch[Do[If[a > 6, Throw[a]], {a, 10}]; False]]
    ]
};

For::usage = "`+"`"+`For[beg, cond, incr, expr]`+"`"+` runs a for loop.";
Attributes[For] = {HoldAll, Protected};
For[beg_, cond_, incr_, expr_] := (beg; While[cond, expr; incr]);
Tests`+"`"+`For = {
    ESimpleExamples[
        ESameTest[11, For[n = 1, n < 1000, n++, If[PrimeQ[n] && (n > 7), Return[]]]; n]
    ]
};
`)

func resourcesFlowcontrolMBytes() ([]byte, error) {
	return _resourcesFlowcontrolM, nil
}

func resourcesFlowcontrolM() (*asset, error) {
	bytes, err := resourcesFlowcontrolMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/flowcontrol.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesFunctionalM = []byte(`Function::usage = "`+"`"+`Function[inner]`+"`"+` defines a pure function where `+"`"+`inner`+"`"+` is evaluated with `+"`"+`Slot`+"`"+` parameters.

`+"`"+`Function[x, inner]`+"`"+` defines a pure function where `+"`"+`inner`+"`"+` is evaluated a single parameter `+"`"+`x`+"`"+`.";
Attributes[Function] = {HoldAll, Protected};
Tests`+"`"+`Function = {
    ESimpleExamples[
        ESameTest[1 + x, Function[1 + #][x]],
        ESameTest[1 + x + 2y, Function[1 + # + 2#2][x, y]],
        ESameTest[a^2, Function[x, x^2][a]],
        ESameTest[a^2, Function[x, x^2][a, b]],
        ESameTest[x^2, Function[x, x^2][x]],
        ESameTest[4, Function[x, x^2][-2]]
    ]
};

Slot::usage = "`+"`"+`#`+"`"+` serves as a pure function's first parameter.

`+"`"+`#n`+"`"+` serves as a pure function's `+"`"+`n`+"`"+`'th parameter.";
Attributes[Slot] = {NHoldAll, Protected};
Tests`+"`"+`Slot = {
    ESimpleExamples[
        ESameTest[1 + x, Function[1 + #][x]],
        ESameTest[1 + x + 2y, Function[1 + # + 2#2][x, y]],
        ESameTest[True, # === Slot[1]],
        ESameTest[True, #2 === Slot[2]],
        ESameTest[2a + 4b, (4 # + (2 # &)[a] &)[b]]
    ], ETests[
        ESameTest[foo[test, k], (foo[test, #] &) &[j][k]]
    ]
};

Apply::usage = "`+"`"+`Apply[f, e]`+"`"+` (`+"`"+`f@@e`+"`"+`) replaces the head of expression `+"`"+`e`+"`"+` with `+"`"+`f`+"`"+`.";
Attributes[Apply] = {Protected};
Tests`+"`"+`Apply = {
    ESimpleExamples[
        ESameTest[bar[syma, symb], Apply[bar, foo[syma, symb]]],
        ESameTest[bar[syma, symb], bar@@foo[syma, symb]],
        ESameTest[{syma, symb}, List@@(syma + symb)],
        EComment["`+"`"+`Apply`+"`"+` is useful in performing aggregations on `+"`"+`List`+"`"+`s:"],
        ESameTest[12, Times @@ {2, 6}],
        ESameTest[a b, Times @@ {a, b}]
    ], EFurtherExamples[
        EComment["`+"`"+`Apply`+"`"+` has no effect on atoms:"],
        ESameTest[1, foo @@ 1],
        ESameTest[bar, foo @@ bar]
    ], ETests[
        ESameTest[foo[a,b,c], Apply[foo, {a,b,c}]],
        ESameTest[foo[bar, buzz], Apply[foo, {bar, buzz}]],
        ESameTest[foo[bar, buzz], foo @@ {bar, buzz}],
        ESameTest[foo[1, 2], foo @@ {1, 2}],
        ESameTest[f[{{a}}], Apply[f,{{{a}}}]],
        ESameTest[{{f[a]}}, Apply[f,{{{a}}},{2}]],
        ESameTest[{{{a}}}, Apply[f,{{{a}}},{3}]],
        ESameTest[{f[a],f[b]}, f@@@{{a},foo[b]}],
        ESameTest[f[{a},foo[b]], Apply[f,{{a},foo[b]},{0}]],
        ESameTest[f[f[a],f[b]], Apply[f,{{a},foo[b]},{0,1}]],
        ESameTest[f[f[a,{c}],f[b]], Apply[f,{{a,{c}},foo[b]},{0,1}]],
        ESameTest[f[f[a,f[c,{d}]],f[b]], Apply[f,{{a,{c,{d}}},foo[b]},{0,2}]],
        ESameTest[{f[a,f[c,f[d]]],f[b]}, Apply[f,{{a,{c,{d}}},foo[b]},Infinity]],
        ESameTest[{f[a,f[c]],f[b]}, Apply[f,{{a,{c}},foo[b]},2]]
    ]
};

Map::usage = "`+"`"+`Map[f, expr]`+"`"+` returns a new expression with the same head as `+"`"+`expr`+"`"+`, but with `+"`"+`f`+"`"+` mapped to each of the arguments.
Map[f, expr, levelspec] maps f to all subexpressions that match the level specification levelspec.";
Attributes[Map] = {Protected};
Tests`+"`"+`Map = {
    ESimpleExamples[
        ESameTest[{foo[a], foo[b], foo[c]}, Map[foo, {a, b, c}]],
        ESameTest[{foo[a], foo[b], foo[c]}, foo /@ {a, b, c}],
        ESameTest[{2, 4, 9}, Times /@ {2, 4, 9}],
        ESameTest[{foo[{a, b}], foo[c]}, Map[foo, {{a, b}, c}]],
        ESameTest[Map[foo], Map[foo]],
        ESameTest[foo, Map[foo, foo]],
        ESameTest[Map[foo, foo, foo], Map[foo, foo, foo]],
        EComment["Pure functions are useful with `+"`"+`Map`+"`"+`:"],
        ESameTest[{4,16}, Function[x, x^2] /@ {2,4}],
        ESameTest[{4,16}, Function[#^2] /@ {2,4}],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], {-Infinity, Infinity}],
            f[a[f[b[f[c], f[d], f[e]]], f[l[f[g[f[h], f[j]]], f[k]]]]]
        ],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], Infinity],
            a[f[b[f[c], f[d], f[e]]], f[l[f[g[f[h], f[j]]], f[k]]]]
        ],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], {-2, Infinity}],
            a[f[b[f[c], f[d], f[e]]], l[f[g[f[h], f[j]]], f[k]]]
        ],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], {2, -2}],
            a[b[c, d, e], l[f[g[h, j]], k]]
        ],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], 2],
            a[f[b[f[c], f[d], f[e]]], f[l[f[g[h, j]], f[k]]]]
        ],
        ESameTest[
            Map[f, a[b[c, d, e], l[g[h, j], k]], -2],
            a[f[b[c, d, e]], f[l[f[g[h, j]], k]]]
        ]
    ]
};

MapIndexed::usage = "`+"`"+`MapIndexed[f, expr]`+"`"+` returns a new expression with the same head as `+"`"+`expr`+"`"+`, but with `+"`"+`f`+"`"+` mapped to each of the arguments.
Additionally, MapIdnexed supplies the part specification of the subexpression as the second argument of f.
Map[f, expr, levelspec] maps f to all subexpressions that match the level specification levelspec, also supplying the part specification for
each subexpression as the second argument to f.";
Attributes[MapIndexed] = {Protected}
Tests`+"`"+`MapIndexed = {
    ESimpleExamples[
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], {-Infinity, Infinity}],
            f[a[f[b[f[c, {1, 1}], f[d, {1, 2}], f[e, {1, 3}]], {1}], f[l[f[g[f[h, {2, 1, 1}], f[j, {2, 1, 2}]], {2, 1}], f[k, {2, 2}]], {2}]], {}]
        ],
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], Infinity],
            a[f[b[f[c, {1, 1}], f[d, {1, 2}], f[e, {1, 3}]], {1}], f[l[f[g[f[h, {2, 1, 1}], f[j, {2, 1, 2}]], {2, 1}], f[k, {2, 2}]], {2}]]
        ],
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], {-2, Infinity}],
            a[f[b[f[c, {1, 1}], f[d, {1, 2}], f[e, {1, 3}]], {1}], l[f[g[f[h, {2, 1, 1}], f[j, {2, 1, 2}]], {2, 1}], f[k, {2, 2}]]]
        ],
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], {2, -2}],
            a[b[c, d, e], l[f[g[h, j], {2, 1}], k]]
        ],
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], 2],
            a[f[b[f[c, {1, 1}], f[d, {1, 2}], f[e, {1, 3}]], {1}], f[l[f[g[h, j], {2, 1}], f[k, {2, 2}]], {2}]]
        ],
        ESameTest[
            MapIndexed[f, a[b[c, d, e], l[g[h, j], k]], -2],
            a[f[b[c, d, e], {1}], f[l[f[g[h, j], {2, 1}], k], {2}]]
        ]
    ]
};

FoldList::usage = "`+"`"+`FoldList[f, x, {a, b}] returns {x, f[x, a], f[f[x, a], b]}"
FoldList[f_, expr_] := FoldList[f, First[expr], Rest[expr]]
(* FoldList[f_][expr__] := FoldList[f, expr] When subvalues are allowed *)
Attributes[FoldList] = {Protected};
Tests`+"`"+`FoldList = {
    ESimpleExamples[
        ESameTest[{1, f[1, 2], f[f[1, 2], 3]}, FoldList[f, 1, {2, 3}]],
        ESameTest[{1, f[1, 2], f[f[1, 2], 3]}, FoldList[f, {1, 2, 3}]],
        (* ESameTest[{1, f[1, 2], f[f[1, 2], 3]}, FoldList[f][{1, 2, 3}]], *)
        ESameTest[h[e1, f[e1, e2], f[f[e1, e2], e3], f[f[f[e1, e2], e3], e4]], FoldList[f, e1, h[e2, e3, e4]]],
        ESameTest[{h}, FoldList[f, h, {}]]
    ]
}

Fold::usage = "`+"`"+`Fold[f, x, {a, b}]`+"`"+` returns `+"`"+`f[f[x, a], b]`+"`"+`, and this nesting continues for lists of arbitrary length. `+"`"+`Fold[f, {a, b, c}]`+"`"+` returns `+"`"+`Fold[f, a, {b, c}]`+"`"+`. `+"`"+`Fold[f]`+"`"+` is an operator form that can be applied to expressions such as `+"`"+`{a, b, c}`+"`"+`."
Fold[f_, x_, expr_] := Last[FoldList[f, x, expr]]
Fold[f_, expr_] := Last[FoldList[f, First[expr], Rest[expr]]]
(* Fold[f_][expr__] := Last[FoldList[f, expr]] When subvalues are allowed *)
Attributes[Fold] = {Protected};
Tests`+"`"+`Fold = {
    ESimpleExamples[
        ESameTest[f[f[1, 2], 3], Fold[f, 1, {2, 3}]],
        ESameTest[f[f[1, 2], 3], Fold[f, {1, 2, 3}]],
        (* ESameTest[f[f[1, 2], 3], Fold[f][{1, 2, 3}]], *)
        ESameTest[f[f[f[e1, e2], e3], e4], Fold[f, e1, h[e2, e3, e4]]],
        ESameTest[h, Fold[f, h, {}]]
    ]
}

NestList::usage = "`+"`"+`NestList[f, expr, n]`+"`"+` returns `+"`"+`f`+"`"+` wrapped around `+"`"+`expr`+"`"+` first once, then twice, and so on up to `+"`"+`n`+"`"+` times."
Attributes[NestList] = {Protected}
Tests`+"`"+`NestList = {
    ESimpleExamples[
        ESameTest[{x, f[x], f[f[x]], f[f[f[x]]]}, NestList[f, x, 3]],
        ESameTest[{{1, 2, 3}, {1, 4, 9}, {1, 16, 81}, {1, 256, 6561}}, NestList[#^2 &, {1, 2, 3}, 3]]
    ]
}

Nest::usage = "`+"`"+`Nest[f, expr, n]`+"`"+` returns `+"`"+`f`+"`"+` wrapped around `+"`"+`expr`+"`"+` `+"`"+`n`+"`"+` times."
Nest[f_, expr_, n_] := Last[NestList[f, expr, n]]
Attributes[Nest] = {Protected}
Tests`+"`"+`Nest = {
    ESimpleExamples[
        ESameTest[f[f[f[x]]], Nest[f, x, 3]],
        ESameTest[{1, 256, 6561}, Nest[#^2 &, {1, 2, 3}, 3]]
    ]
}

NestWhileList::usage = "`+"`"+`NestWhileList[f, expr, test, m, max, n]`+"`"+` applies `+"`"+`f`+"`"+` to `+"`"+`expr`+"`"+` until `+"`"+`test`+"`"+` does not return `+"`"+`True`+"`"+`.
It returns a list of all intermediate results. `+"`"+`test`+"`"+` is a function that takes as its argument the last `+"`"+`m`+"`"+` results.
`+"`"+`max`+"`"+` denotes the maximum number of applications of `+"`"+`f`+"`"+` and `+"`"+`n`+"`"+` denotes that `+"`"+`f`+"`"+` should be applied another `+"`"+`n`+"`"+` times after
`+"`"+`test`+"`"+` has terminated the recursion."
Attributes[NestWhileList] = {Protected}
Tests`+"`"+`NestWhileList = {
    ESimpleExamples[
        ESameTest[7, Length@NestWhileList[(# + 3/#)/2 &, 1.0, UnsameQ[#1, #2] &, 2]],
        ESameTest[{2, 4, 16, 256}, NestWhileList[#^2 &, 2, # < 256 &]],
        ESameTest[{1, 2, 3, 4, 5, 6, 7}, NestWhileList[#+1 &, 1, # + #4 < 10 &, 4]],
        ESameTest[{1, 2, 3, 4, 5}, NestWhileList[#+1 &, 1, True &, 1, 4]],
        ESameTest[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, NestWhileList[#+1 &, 1, True &, 1, 4, 5]]
    ]
}

NestWhile::usage = "`+"`"+`NestWhile[f, expr, test, m, max, n]`+"`"+` applies `+"`"+`f`+"`"+` to `+"`"+`expr`+"`"+` until `+"`"+`test`+"`"+` does not return `+"`"+`True`+"`"+`.
`+"`"+`test`+"`"+` is a function that takes as its argument the last `+"`"+`m`+"`"+` results. `+"`"+`max`+"`"+` denotes the maximum number of applications
of `+"`"+`f`+"`"+` and `+"`"+`n`+"`"+` denotes that `+"`"+`f`+"`"+` should be applied another `+"`"+`n`+"`"+` times after `+"`"+`test`+"`"+` has terminated the recursion."
Attributes[NestWhile] = {Protected}
NestWhile[args__] := Last[NestWhileList[args]]
Tests`+"`"+`NestWhile = {
    ESimpleExamples[
        ESameTest[256, NestWhile[#^2 &, 2, # < 256 &]],
        ESameTest[7, NestWhile[#+1 &, 1, # + #4 < 10 &, 4]],
        ESameTest[5, NestWhile[#+1 &, 1, True &, 1, 4]],
        ESameTest[10, NestWhile[#+1 &, 1, True &, 1, 4, 5]]
    ]
}

FixedPointList::usage = "`+"`"+`FixedPointList[f, expr]`+"`"+` applies `+"`"+`f`+"`"+` to `+"`"+`expr`+"`"+` until `+"`"+`UnsameQ`+"`"+` applied to the two most recent results
returns False. It returns a list of all intermediate results."
FixedPointList[f_, expr_] := NestWhileList[f, expr, UnsameQ, 2]
Tests`+"`"+`FixedPointList = {
    ESimpleExamples[
        ESameTest[7, Length@FixedPointList[(# + 3/#)/2 &, 1.0]],
        ESameTest[{x^3, 3 x^2, 6 x, 6, 0, 0}, FixedPointList[D[#, x] &, x^3]]
    ]
}

FixedPoint::usage = "`+"`"+`FixedPoint[f, expr]`+"`"+` applies `+"`"+`f`+"`"+` to `+"`"+`expr`+"`"+` until `+"`"+`UnsameQ`+"`"+` applied to the two most recent results
returns False."
(*FixedPoint[f_, expr_] := Module[{currVal=expr, nextVal=f[expr]},*)
  (*While[UnsameQ[currVal, nextVal],*)
    (*currVal = nextVal;*)
    (*nextVal = f[currVal];*)
  (*];*)
  (*nextVal]*)
Tests`+"`"+`FixedPoint = {
    ESimpleExamples[
        ESameTest[0, FixedPoint[D[#, x] &, x^3]]
    ]
}

Array::usage = "`+"`"+`Array[f, n]`+"`"+` creates a list of `+"`"+`f[i]`+"`"+`, with `+"`"+`i`+"`"+` = 1 to `+"`"+`n`+"`"+`.";
Attributes[Array] = {Protected};
Tests`+"`"+`Array = {
    ESimpleExamples[
        ESameTest[{f[1], f[2], f[3]}, Array[f, 3]],
        ESameTest[Null, mytest[x_] := 5],
        ESameTest[{5, 5, 5}, Array[mytest, 3]],
        ESameTest[{(a + b)[1], (a + b)[2], (a + b)[3]}, Array[a + b, 3]],
        ESameTest[Array[a, a], Array[a, a]]
    ]
};

Identity::usage = "`+"`"+`Identity[expr_]`+"`"+` returns `+"`"+`expr`+"`"+`.";
Identity[expr_] := expr;
Attributes[Identity] = {Protected};
Tests`+"`"+`Identity = {
    ESimpleExamples[
        ESameTest[5, Identity[5]],
        ESameTest[a, Identity[Identity[a]]]
    ]
};
`)

func resourcesFunctionalMBytes() ([]byte, error) {
	return _resourcesFunctionalM, nil
}

func resourcesFunctionalM() (*asset, error) {
	bytes, err := resourcesFunctionalMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/functional.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesInitM = []byte(`(* This file is executed upon initialization. *)
SeedRandom[UnixTime[]];
$Version = "Expreduce";
$ModuleNumber = 1;
$Path = {"."};
$Line = 1;
`)

func resourcesInitMBytes() ([]byte, error) {
	return _resourcesInitM, nil
}

func resourcesInitM() (*asset, error) {
	bytes, err := resourcesInitMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/init.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesListM = []byte(`List::usage = "`+"`"+`{e1, e2, ...}`+"`"+` groups expressions together.";
Attributes[List] = {Locked, Protected};
Tests`+"`"+`List = {
    ESimpleExamples[
        ESameTest[{1, 2, a}, List[1,2,a]]
    ]
};

Total::usage = "`+"`"+`Total[list]`+"`"+` sums all the values in `+"`"+`list`+"`"+`.";
Total[l__List] := Apply[Plus, l];
Attributes[Total] = {Protected};
Tests`+"`"+`Total = {
    ESimpleExamples[
        ESameTest[10, Total[{1,2,3,4}]]
    ], EFurtherExamples[
        EComment["The total of an empty list is zero:"],
        ESameTest[0, Total[{}]]
    ]
};

Mean::usage = "`+"`"+`Mean[list]`+"`"+` calculates the statistical mean of `+"`"+`list`+"`"+`.";
Mean[l__List] := Total[l]/Length[l];
Attributes[Mean] = {Protected};
Tests`+"`"+`Mean = {
    ESimpleExamples[
        ESameTest[11/2, Mean[{5,6}]]
    ]
};

Table::usage = "`+"`"+`Table[expr, n]`+"`"+` returns a list with `+"`"+`n`+"`"+` copies of `+"`"+`expr`+"`"+`.

`+"`"+`Table[expr, {sym, n}]`+"`"+` returns a list with `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = 1 to `+"`"+`n`+"`"+`.

`+"`"+`Table[expr, {sym, m, n}]`+"`"+` returns a list with `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`.";
(*Use a UniqueDefined`+"`"+` prefix, or else Table[i, 5] will return*)
(*incorrect results.*)
Table[a_, b_Integer] := Table[a, {UniqueDefined`+"`"+`i, 1, b}];
Attributes[Table] = {HoldAll, Protected};
Tests`+"`"+`Table = {
    ESimpleExamples[
        ESameTest[{a, a, a, a, a}, Table[a, 5]],
        ESameTest[{5, 6, 7, 8, 9, 10}, Table[i, {i, 5, 10}]],
        EComment["Create a list of the first 10 squares:"],
        ESameTest[{1, 4, 9, 16, 25, 36, 49, 64, 81, 100}, Table[n^2, {n, 1, 10}]],
        EComment["Iteration definitions do not have side effects:"],
        EStringTest["i", "i"],
        ESameTest[22, listTableTestState`+"`"+`i = 22],
        ESameTest[{5, 6, 7, 8, 9, 10}, Table[i, {i, 5, 10}]],
        EStringTest["22", "i"]
    ], EFurtherExamples[
        ESameTest[{0,1,2}, Table[x[99], {x[_], 0, 2}]]
    ], ETests[
        EComment["Test proper evaluation of the iterspec."],
        ESameTest[Null, testn := 5;],
        ESameTest[{1, 2, 3, 4, 5}, Table[i, {i, testn}]]
    ]
};

ParallelTable::usage = "`+"`"+`ParallelTable[expr, n]`+"`"+` returns a list with `+"`"+`n`+"`"+` copies of `+"`"+`expr`+"`"+`, evaluated in parallel.

`+"`"+`ParallelTable[expr, {sym, n}]`+"`"+` returns a list with `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = 1 to `+"`"+`n`+"`"+`, evaluated in parallel.

`+"`"+`ParallelTable[expr, {sym, m, n}]`+"`"+` returns a list with `+"`"+`expr`+"`"+` evaluated with `+"`"+`sym`+"`"+` = `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`, evaluated in parallel.";
ParallelTable[a_, b_Integer] := ParallelTable[a, {UniqueDefined`+"`"+`i, 1, b}];
Attributes[ParallelTable] = {HoldAll, Protected};
Tests`+"`"+`ParallelTable = {
    ESimpleExamples[
        ESameTest[{5, 6, 7, 8, 9, 10}, ParallelTable[i, {i, 5, 10}]],
    ]
};

MemberQ::usage = "`+"`"+`MemberQ[expr, pat]`+"`"+` returns True if any of the elements in `+"`"+`expr`+"`"+` match `+"`"+`pat`+"`"+`, otherwise returns False.";
Attributes[MemberQ] = {Protected};
Tests`+"`"+`MemberQ = {
    ESimpleExamples[
        ESameTest[False, MemberQ[{1, 2, 3}, 0]],
        ESameTest[True, MemberQ[{1, 2, 3}, 1]],
        ESameTest[False, MemberQ[{1, 2, 3}, {1}]],
        EComment["`+"`"+`MemberQ`+"`"+` works with patterns:"],
        ESameTest[True, MemberQ[{1, 2, 3}, _Integer]],
        ESameTest[True, MemberQ[{1, 2, 3}, _]],
        ESameTest[False, MemberQ[{1, 2, 3}, _Real]],
        ESameTest[True, MemberQ[{1, 2, 3}, testmatch_Integer]],
        EStringTest["testmatch", "testmatch"],
        ESameTest[False, MemberQ[a, a]],
        ESameTest[False, MemberQ[a, _]],
        (*More tests to be used in OrderlessIsMatchQ*)
        ESameTest[False, MemberQ[{a, b}, c]],
        ESameTest[True, MemberQ[{a, b}, a]]
    ], EFurtherExamples[
        EComment["`+"`"+`MemberQ`+"`"+` works with BlankSequences:"],
        ESameTest[True, MemberQ[{a, b}, ___]],
        ESameTest[True, MemberQ[{a, b}, __]],
        ESameTest[False, MemberQ[{a, b}, __Integer]],
        ESameTest[False, MemberQ[{a, b}, ___Integer]],
        ESameTest[True, MemberQ[{a, b}, ___Symbol]],
        ESameTest[True, MemberQ[{a, b}, __Symbol]],
        ESameTest[True, MemberQ[{a, b, 1}, __Symbol]],
        ESameTest[True, MemberQ[{a, b, 1}, __Integer]],
        EComment["`+"`"+`expr`+"`"+` need not be a List:"],
        ESameTest[True, MemberQ[bar[a, b, c], a]],
        ESameTest[False, MemberQ[bar[a, b, c], bar]]
    ]
};

Cases::usage = "`+"`"+`Cases[expr, pat]`+"`"+` returns a new `+"`"+`List`+"`"+` of all elements in `+"`"+`expr`+"`"+` that match `+"`"+`pat`+"`"+`.";
Attributes[Cases] = {Protected};
Tests`+"`"+`Cases = {
    ESimpleExamples[
        ESameTest[{5, 2, 3.5, x, y, 4}, Cases[{5, 2, 3.5, x, y, 4}, _]],
        ESameTest[{5,2,4}, Cases[{5, 2, 3.5, x, y, 4}, _Integer]],
        ESameTest[{3.5}, Cases[{5, 2, 3.5, x, y, 4}, _Real]],
        ESameTest[{2,c}, Cases[{b^2,1,a^c},_^e_->e]]
    ], EFurtherExamples[
        EComment["`+"`"+`expr`+"`"+` need not be a list:"],
        ESameTest[{a}, Cases[bar[a, b, c], a]]
    ]
};

DeleteCases::usage = "`+"`"+`DeleteCases[expr, pat]`+"`"+` returns a new expression of all elements in `+"`"+`expr`+"`"+` that do not match `+"`"+`pat`+"`"+`.";
Attributes[DeleteCases] = {Protected};
Tests`+"`"+`DeleteCases = {
    ESimpleExamples[
        ESameTest[{3.5,x,y}, DeleteCases[{5,2,3.5,x,y,4},_Integer]],
        ESameTest[{5,2,x,y,4}, DeleteCases[{5,2,3.5,x,y,4},_Real]],
        ESameTest[x+y, DeleteCases[3.5+x+y,_Real]]
    ]
};

Union::usage = "`+"`"+`Union[expr1, expr2, ...]`+"`"+` returns a sorted union of the items in the expressions.";
Attributes[Union] = {Protected};
Tests`+"`"+`Union = {
    ESimpleExamples[
        ESameTest[{a,b}, Union[{b,a,a,b,a}]],
        ESameTest[{a,b,y,z}, Union[{b,a,a,b,a},{y,z}]],
        ESameTest[foo[a,b,y,z], Union[foo[b,a,a,b,a],foo[y,z]]]
    ], ETests[
        ESameTest[Union[foo[b,a,a,b,a],{y,z}], Union[foo[b,a,a,b,a],{y,z}]],
        ESameTest[{}, Union[]],
        ESameTest[Union[{b,a,a,b,a},z], Union[{b,a,a,b,a},z]],
        ESameTest[{a}, Union[{a}]],
        ESameTest[{List}, Union[{List}]]
    ]
};

Complement::usage = "`+"`"+`Complement[expr1, expr2, ...]`+"`"+` returns a sorted union of the items in the expressions.";
Attributes[Complement] = {Protected};
Tests`+"`"+`Complement = {
    ESimpleExamples[
        ESameTest[{b}, Complement[{a, b}, {a}]],
        ESameTest[{c}, Complement[{a, b, c}, {a}, {b}]]
    ], ETests[
        ESameTest[foo[], Complement[foo[a], foo[a]]],
        ESameTest[Complement[], Complement[]],
        ESameTest[{}, Complement[{}]],
        ESameTest[Complement[{}, foo[a]], Complement[{}, foo[a]]],
        ESameTest[{b, c}, Complement[{a, b, c}, {a}, {_}]],
        ESameTest[{b, c}, Complement[{a, b, c, _}, {a}, {_}]],
        ESameTest[{b, c}, Complement[{a, b, c, _}, {a}, {_}, {}]],
        ESameTest[{b, c}, Complement[{a, c, b, _}, {a}, {_}, {}]],
        ESameTest[{b, c}, Complement[{a, c, c, b, _}, {a}, {_}, {}]]
    ]
};

Intersection::usage = "`+"`"+`Intersection[expr1, expr2, ...]`+"`"+` returns a sorted intersection of the items in the expressions.";
Attributes[Intersection] = {Flat, OneIdentity, Protected, ReadProtected};
Tests`+"`"+`Complement = {
    ESimpleExamples[
        ESameTest[{a}, Intersection[{a, b}, {a}]],
        ESameTest[{}, Intersection[{a, b, c}, {a}, {b}]]
    ], ETests[
        ESameTest[foo[a], Intersection[foo[a], foo[a]]],
    ]
};

Range::usage = "`+"`"+`Range[n]`+"`"+` returns a `+"`"+`List`+"`"+` of integers from 1 to `+"`"+`n`+"`"+`.

`+"`"+`Range[m, n]`+"`"+` returns a `+"`"+`List`+"`"+` of integers from `+"`"+`m`+"`"+` to `+"`"+`n`+"`"+`.";
Attributes[Range] = {Listable, Protected};
Tests`+"`"+`Range = {
    ESimpleExamples[
        ESameTest[{1, 2, 3}, Range[3]],
        ESameTest[{2, 3, 4, 5}, Range[2, 5]],
        ESameTest[{}, Range[2, -5]]
    ]
};

Part::usage = "`+"`"+`expr[[i]]`+"`"+` or `+"`"+`Part[expr, i]`+"`"+` returns the `+"`"+`i`+"`"+`th element of `+"`"+`expr`+"`"+`.";
Attributes[Part] = {NHoldRest, ReadProtected, Protected};
Tests`+"`"+`Part = {
    ESimpleExamples[
        EComment["Return the second item in a list:"],
        ESameTest[b, {a, b, c, d}[[2]]],
        EComment["Multi-dimensional indices are supported:"],
        ESameTest[{{1, 4, 9, 16, 25}, {2, 8, 18, 32, 50}, {3, 12, 27, 48, 75}, {4, 16, 36, 64, 100}, {5, 20, 45, 80, 125}}, mat = Table[Table[a*b^2, {b, 5}], {a, 5}]],
        ESameTest[20, mat[[5, 2]]],
        EComment["Use `+"`"+`All`+"`"+` to select along the entire dimension:"],
        ESameTest[{5, 20, 45, 80, 125}, mat[[5, All]]]
    ], EFurtherExamples[
        EComment["Out of bounds issues will prevent the expression from evaluating:"],
        ESameTest[{a}[[2]], Part[{a}, 2]],
        EComment["The input need not be a `+"`"+`List`+"`"+`:"],
        ESameTest[foo, Part[foo[a], 0]],
        EComment["Omitting an index will return the original expression:"],
        ESameTest[i, Part[i]],
        ESameTest[{2,4,6}, {{1, 2}, {3, 4}, {5, 6}}[[All, 2]]]
    ], ETests[
        ESameTest[i, Part[i]],
        ESameTest[Part[], Part[]],
        ESameTest[{a, b}[[1.5]], Part[{a, b}, 1.5]],
        ESameTest[{a, b}[[a, 1.5]], Part[{a, b}, a, 1.5]],
        ESameTest[foo, Part[foo[a], 0]],
        ESameTest[{{1, 4, 9, 16, 25}, {2, 8, 18, 32, 50}, {3, 12, 27, 48, 75}, {4, 16, 36, 64, 100}, {5, 20, 45, 80, 125}}, mat = Table[Table[a*b^2, {b, 5}], {a, 5}]],
        ESameTest[20, mat[[5, 2]]],
        ESameTest[{5, 20, 45, 80, 125}, mat[[5, All]]],
        ESameTest[foo[a, b, c], foo[a, b, c][[All]]],
        ESameTest[1[[5]], Part[1, 5]],
        ESameTest[a, Part[{a}, 1]],
        ESameTest[{a}[[2]], Part[{a}, 2]],
        ESameTest[{5, 20, 45, 80, 125}, mat[[All]][[5]]],
        ESameTest[3, {{1, 2}, {3, 4}}[[2, 1]]],
        ESameTest[{{1, 2}, {3}}[[2, 2]], {{1, 2}, {3}}[[2, 2]]],
        ESameTest[{3,4}, {{1, 2}, {3, 4}, {5, 6}}[[2, All]]],
        ESameTest[{25, 50, 75, 100, 125}, mat[[All, 5]]]
    ], EKnownFailures[
        ESameTest[Integer[], Part[1, All]],
        ESameTest[Symbol[], Part[a, All]]
    ]
};

Span::usage = "`+"`"+`start ;; end`+"`"+` represents an index span to select using Part.";
Attributes[Span] = {Protected};
Tests`+"`"+`Span = {
    ESimpleExamples[
        ESameTest[{b, c}, {a, b, c, d}[[2 ;; 3]]],
        ESameTest[{b, c, d}, {a, b, c, d}[[2 ;; All]]]
    ]
};

All::usage = "`+"`"+`All`+"`"+` allows selection along a dimension in `+"`"+`Part`+"`"+`.";
Attributes[All] = {Protected};
Tests`+"`"+`All = {
    ESimpleExamples[
        ESameTest[{{1, 4, 9, 16, 25}, {2, 8, 18, 32, 50}, {3, 12, 27, 48, 75}, {4, 16, 36, 64, 100}, {5, 20, 45, 80, 125}}, mat = Table[Table[a*b^2, {b, 5}], {a, 5}]],
        EComment["Use `+"`"+`All`+"`"+` to select along the entire dimension:"],
        ESameTest[{5, 20, 45, 80, 125}, mat[[5, All]]]
    ]
};

Thread::usage = "`+"`"+`Thread[f[a1, a2, ...}]]`+"`"+` applies f over the arguments, expanding out any lists.";
Attributes[Thread] = {Protected};
Tests`+"`"+`Thread = {
    ETests[
        ESameTest[{f[x], f[y], f[z]}, Thread[f[{x, y, z}]]],
        ESameTest[{f[x, b], f[y, b], f[z, b]}, Thread[f[{x, y, z}, b]]],
        ESameTest[f[{x, y, z}, {b}], Thread[f[{x, y, z}, {b}]]],
        ESameTest[{f[{x, y, z}, b]}, Thread[f[{{x, y, z}}, {b}]]],
        ESameTest[{f[{x, y, z}, b]}, Thread[f[{{x, y, z}}, b]]],
        ESameTest[{f[x, b, a], f[y, b, b], f[z, b, c]}, Thread[f[{x, y, z}, b, {a, b, c}]]],
        ESameTest[{mypos[-1], mypos[4], mypos[5]}, Thread[mypos[{-1, 4, 5}]]],
        ESameTest[f[a, b, c], Thread[f[a, b, c]]],
        ESameTest[{f[1]}, Thread[f[{1}]]],
        ESameTest[{0, 1, 2}, Thread[{0, 1, 2}]],
        ESameTest[{{0, a}, {1, a}, {2, a}}, Thread[{{0, 1, 2}, a}]],
        ESameTest[a, Thread[a]],
        ESameTest[Thread[], Thread[]]
    ]
};

Append::usage = "`+"`"+`Append[list, e]`+"`"+` returns `+"`"+`list`+"`"+` with `+"`"+`e`+"`"+` appended.";
Attributes[Append] = {Protected};
Tests`+"`"+`Append = {
    ESimpleExamples[
        ESameTest[{a,b,c}, Append[{a,b},c]],
        ESameTest[foo[a,b,c], Append[foo[a,b],c]]
    ]
};

AppendTo::usage = "`+"`"+`AppendTo[list, e]`+"`"+` appends `+"`"+`e`+"`"+` to `+"`"+`list`+"`"+` and returns the modified `+"`"+`list`+"`"+`.";
AppendTo[list_, e_] := (list = Append[list, e]);
Attributes[AppendTo] = {HoldFirst, Protected};
Tests`+"`"+`AppendTo = {
    ESimpleExamples[
        ESameTest[{a,b,c}, l = {a, b}; AppendTo[l, c]; l]
    ]
};

Prepend::usage = "`+"`"+`Prepend[list, e]`+"`"+` returns `+"`"+`list`+"`"+` with `+"`"+`e`+"`"+` prepended.";
Attributes[Prepend] = {Protected};
Tests`+"`"+`Prepend = {
    ESimpleExamples[
        ESameTest[{c,a,b}, Prepend[{a,b},c]],
        ESameTest[foo[c,a,b], Prepend[foo[a,b],c]]
    ]
};

PrependTo::usage = "`+"`"+`PrependTo[list, e]`+"`"+` prepends `+"`"+`e`+"`"+` to `+"`"+`list`+"`"+` and returns the modified `+"`"+`list`+"`"+`.";
PrependTo[list_, e_] := (list = Prepend[list, e]);
Attributes[PrependTo] = {HoldFirst, Protected};
Tests`+"`"+`PrependTo = {
    ESimpleExamples[
        ESameTest[{c,a,b}, l = {a, b}; PrependTo[l, c]; l]
    ]
};

DeleteDuplicates::usage = "`+"`"+`DeleteDuplicates[list]`+"`"+` returns `+"`"+`list`+"`"+` with the duplicates removed.";
Attributes[DeleteDuplicates] = {Protected};
Tests`+"`"+`DeleteDuplicates = {
    ESimpleExamples[
        ESameTest[{b,a}, DeleteDuplicates[{b,a,b}]],
        ESameTest[foo[b,a], DeleteDuplicates[foo[b,a,b]]],
        ESameTest[{}, DeleteDuplicates[{}]],
        ESameTest[10000, Length[DeleteDuplicates[Range[10000]]]]
    ]
};

Last::usage = "`+"`"+`Last[expr]`+"`"+` returns the last part of `+"`"+`expr`+"`"+`.";
Last[e_?((Length[#]>=1)&)] := e[[Length[e]]];
Attributes[Last] = {Protected};
Tests`+"`"+`Last = {
    ESimpleExamples[
        ESameTest[6, Last[{1,5,6}]],
        ESameTest[b, Last[a+b]]
    ], ETests[
        ESameTest[Last[a], Last[a]],
        ESameTest[Last[{}], Last[{}]],
        ESameTest[a, Last[{a}]]
    ]
};

First::usage = "`+"`"+`First[expr]`+"`"+` returns the first part of `+"`"+`expr`+"`"+`.";
First[e_?((Length[#]>=1)&)] := e[[1]];
Attributes[First] = {Protected};
Tests`+"`"+`First = {
    ESimpleExamples[
        ESameTest[1, First[{1,5,6}]],
        ESameTest[a, First[a+b]]
    ], ETests[
        ESameTest[First[a], First[a]],
        ESameTest[First[{}], First[{}]],
        ESameTest[a, First[{a}]]
    ]
};

Rest::usage = "`+"`"+`Rest[expr]`+"`"+` returns all but the first part of `+"`"+`expr`+"`"+`.";
Rest[e_?((Length[#]>=1)&)] := e[[2;;All]];
Attributes[Rest] = {Protected};
Tests`+"`"+`Rest = {
    ESimpleExamples[
        ESameTest[{5,6}, Rest[{1,5,6}]],
        ESameTest[b+c, Rest[a+b+c]]
    ], ETests[
        ESameTest[Rest[a], Rest[a]],
        ESameTest[Rest[{}], Rest[{}]],
        ESameTest[{}, Rest[{a}]]
    ]
};

Select::usage = "`+"`"+`Select[expr, cond]`+"`"+` selects only parts of `+"`"+`expr`+"`"+` that satisfy `+"`"+`cond`+"`"+`.";
Attributes[Select] = {Protected};
Tests`+"`"+`Select = {
    ESimpleExamples[
        ESameTest[{1,3,5,7,9,11,13,15,17,19}, Select[Range[20],OddQ]],
        ESameTest[{1,2,3,4}, Select[{1,2,3,4},(True)&]],
        ESameTest[{1,2}, Select[{1,2,3,4},(True)&,2]]
    ], ETests[
        ESameTest[{}, Select[{1,2,3,4},(False)&]],
        ESameTest[{}, Select[{1,2,3,4},(hello)&]],
        ESameTest[foo[2,4], Select[foo[1,2,3,4],(EvenQ[#])&]],
        ESameTest[Select[foo[1,2,3,4]], Select[foo[1,2,3,4]]],
        ESameTest[foo[], Select[foo[1,2,3,4],notfunction]],
        ESameTest[Select[2,EvenQ], Select[2,EvenQ]]
    ]
};

ListQ::usage = "`+"`"+`ListQ[expr]`+"`"+` checks if `+"`"+`expr`+"`"+` has a head of `+"`"+`List`+"`"+`.";
ListQ[expr_] := Head[expr] === List;
Attributes[ListQ] = {Protected};
Tests`+"`"+`ListQ = {
    ESimpleExamples[
        ESameTest[True, ListQ[{a}]],
        ESameTest[False, ListQ[a]],
        ESameTest[True, ListQ[{}]]
    ]
};

Scan::usage = "`+"`"+`Scan[fn, list]`+"`"+` evaluates `+"`"+`fn[elem]`+"`"+` for each element in `+"`"+`list`+"`"+`.";
Attributes[Scan] = {Protected};
Tests`+"`"+`Scan = {
    ESimpleExamples[
        ESameTest[6, Scan[(If[# > 5, Return[#]]) &, {1, 6, 9}]],
        ESameTest[False, Catch[Scan[Function[If[IntegerQ[#], Null, Throw[False]]], {a}]; True]],
        ESameTest[True, Catch[Scan[Function[If[IntegerQ[#], Null, Throw[False]]], {1, 2}]; True]],
        ESameTest[False, Catch[Scan[Function[If[IntegerQ[#], Null, Throw[False]]], {1, a}]; True]]
    ]
};

Join::usage = "`+"`"+`Join[l1, l2, ...]`+"`"+` joins the lists into a single list.";
Attributes[Join] = {Flat, OneIdentity, Protected};
Tests`+"`"+`Join = {
    ESimpleExamples[
        ESameTest[{a,b,c}, Join[{a},{b,c}]],
        ESameTest[{}, Join[]],
        ESameTest[foo[a,b,c], Join[foo[a],foo[b,c]]]
    ]
};

Count::usage = "`+"`"+`Count[l, pattern]`+"`"+` returns the number of expressions in `+"`"+`l`+"`"+` matching `+"`"+`pattern`+"`"+`.";
Count[l_, pattern_] := Count[l, pattern, {1}];
Attributes[Count] = {Protected};
Tests`+"`"+`Count = {
    ESimpleExamples[
        ESameTest[3, Count[a+b+c^2,_]],
        ESameTest[5, Count[a+b+c^2,_,-1]],
        ESameTest[5, Count[a+b+c^2,_,Infinity]],
        ESameTest[0, Count[a,_,Infinity]],
        ESameTest[0, Count[a,_,-1]],
        ESameTest[2, Count[a + 2 + c^2, _Integer, Infinity]],
    ]
};

Tally::usage = "`+"`"+`Tally[list]`+"`"+` creates tallies of the elements in `+"`"+`list`+"`"+`.";
Tally[l_List] := {#, Count[l, #]} & /@ DeleteDuplicates[l];
Attributes[Tally] = {Protected};
Tests`+"`"+`Tally = {
    ESimpleExamples[
        ESameTest[{{a, 2}, {b, 2}}, Tally[{a, a, b, b}]],
        ESameTest[{{b, 2}, {a, 2}}, Tally[{b, b, a, a}]],
        ESameTest[{{b, 2}, {a, 1}}, Tally[{b, b, a}]],
    ]
};

ConstantArray::usage = "`+"`"+`ConstantArray[c, n]`+"`"+` creates a list of `+"`"+`n`+"`"+` copies of `+"`"+`c`+"`"+`.";
Attributes[ConstantArray] = {Protected};
ConstantArray[c_, n_Integer] := Table[c, n];
Tests`+"`"+`ConstantArray = {
    ESimpleExamples[
        ESameTest[{a, a, a}, ConstantArray[a, 3]],
    ]
};

Reverse::usage = "`+"`"+`Reverse[list]`+"`"+` evaluates to a reversed copy of `+"`"+`list`+"`"+`.";
Attributes[Reverse] = {Protected};
Tests`+"`"+`Reverse = {
    ESimpleExamples[
        ESameTest[{5, 4, 3, 2, 1}, Reverse[Range[5]]],
    ]
};
`)

func resourcesListMBytes() ([]byte, error) {
	return _resourcesListM, nil
}

func resourcesListM() (*asset, error) {
	bytes, err := resourcesListMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/list.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesManipM = []byte(`ExpreduceDistributeMultiply[e_, multiplicand_] :=
  If[Head[e] === Plus, (#*multiplicand) & /@ e, e*multiplicand];

Together::usage = "`+"`"+`Together[e]`+"`"+` attempts to put the terms in `+"`"+`e`+"`"+` under the same denominator.";

(*Factor out some operations*)
ExpreduceTogether[a_Plus*b_] := ExpreduceTogether[a]*b;
ExpreduceTogether[e_^p_?NumberQ] := ExpreduceTogether[e]^p;

(*Process any denominator*)
ExpreduceTogether[c_.*1/d_ + rest_] := ExpreduceTogether[(c+Expand[ExpreduceDistributeMultiply[rest, d]])/d];
(*Rationals have denominators too. Rational denominators are integers, and
thus automatically distributed through Plus, so no need for the distribute
function.*)
ExpreduceTogether[c_.*Rational[n_,d_] + rest_] := ExpreduceTogether[(c n+Expand[rest d])/d];
ExpreduceTogether[c_.*Complex[0, Rational[n_,d_]] + rest_] := ExpreduceTogether[(I c n+Expand[rest d])/d];

ExpreduceTogether[e_] := e;
Together[e_] := ExpreduceFactorConstant[ExpreduceTogether[e]];

Attributes[Together] = {Listable, Protected};
Tests`+"`"+`Together = {
    ESimpleExamples[
        ESameTest[(6+a)/(2 a), 1/2+3/a//Together],
        ESameTest[(1/2+3/a)^c, (1/2+3/a)^c//Together],
        ESameTest[(6+a)^2/(4 a^2), (1/2+3/a)^2//Together]
    ], ETests[
        ESameTest[(c+a d+b d)/d, a+b+c/d//Together],
        ESameTest[(a+b+c+d)/((a+b) (c+d)), 1/(a+b)+1/(c+d)//Together],
        ESameTest[(a+b+c-a^2*c-a b c+d-a^2*d-a b d)/((a+b) (c+d)), 1/(a+b)+1/(c+d)-a//Together],
        (*Only for when we have Cancel:*)
        (*ESameTest[-(a/(2+a)), Together[a/(-2+a+a^2)-a^2/(-2+a+a^2)]],*)
        ESameTest[(a+b c)/b, a/b+c//Together],
        ESameTest[(b c+a d)/(b d), (a+(b c)/d)/b//Together],
        ESameTest[(b c+a d)/d, a+(b c)/d//Together],
        ESameTest[(c+a d+b d)/d, Together[(c + a*d + b*d)/d]],
        ESameTest[(6+a+2 b)/(2 a), (3+a/2+b)/a//Together],
        ESameTest[a/(b e), (a/b)/e//Together],
        ESameTest[(12+a)/(4 a), (3 + a*1/4)/a//Together],
        ESameTest[(1/2) (6+foo[a]), 3 + foo[a]*2/4//Together],
        ESameTest[(6+a)/(2 a), 1/2 + 3/a//Together],
        ESameTest[(a+b c)/(a b), (c+ a/b)/a//Together],
        ESameTest[(a+b c+b e)/(b d), (c+e+ a/b)/d//Together],
        ESameTest[(4 a^2*b+36 c+12 a c+a^2*c)/(4 a^2*c), Together[(1/2 + 3/a)^2+b/c]],
        ESameTest[(6+a)/(2 a), (3 + a/2)/a//Together],
        ESameTest[(a b+c rest)/(c d), (rest + a*b/c)/d//Together],
        ESameTest[(1+a c+b c)/(a+b), 1/(a+b)+c//Together],
        ESameTest[(c+a d+b d)/d, Together[(c + a*d + b*d)/d]],
        ESameTest[(6+a+2 b)/(2 a), (3+a/2+b)/a//Together],
        ESameTest[a/(b e), (a/b)/e//Together],
        ESameTest[(a+a^2*c+a b c+a d+b d)/(a (a+b)), Together[1/(a + b) + c+d/a]],
        ESameTest[(a+b) (c+d), (a+b)(c+d)//Together],
        ESameTest[(a+b+c+d)/((a+b) (c+d)), 1/(a + b)+1/(c+d)//Together],
        ESameTest[1/(a+b), 1/(a + b)//Together],
        ESameTest[(a+b c e f)/(b c), a/(b*c)+(e*f)//Together],
        ESameTest[(a+b+c-a^2*c-a b c+d-a^2*d-a b d)/((a+b) (c+d)), Together[1/(a + b) + 1/(c + d) - a]],
        ESameTest[(a+b)/(a b), 1/a+1/b//Together],
        ESameTest[(a+b+a b c)/(a b), 1/a+1/b+c//Together],
        ESameTest[(1+c d)/c, 1/c+d//Together],
        ESameTest[1/2*(1+2 a), 1/2+a//Together],
        ESameTest[(a+b+c+d)/((a+b) (c+d)), (1+a/(c+d)+b/(c+d))/(a+b)//Together],
        ESameTest[(a+b+a b c+a b d)/(a b), 1/a+1/b+c+d//Together],
        ESameTest[2(a+b), 2a+2b//Together],
    ], EKnownFailures[
        ESameTest[(I (a-b))/(2 Subscript[\[Omega], 0]), (I a)/(2 Subscript[\[Omega], 0])-(I b)/(2 Subscript[\[Omega], 0])//Together],
    ]
};

Numerator::usage = "`+"`"+`Numerator[e]`+"`"+` returns the numerator of `+"`"+`e`+"`"+`.";
denPattern := b_^n_?Negative | b_^(n : (-_Symbol));
Numerator[prod_Times] := Times@@Cases[prod, Except[denPattern]];
Numerator[Rational[n_,d_]] := n;
Numerator[e_] := e;
Attributes[Numerator] = {Listable, Protected};
Tests`+"`"+`Numerator = {
    ESimpleExamples[
        ESameTest[a, Numerator[a/b]],
        ESameTest[a^2 b, Numerator[a^2*b]],
        ESameTest[a^2, Numerator[a^2*b^-2]],
        ESameTest[a^2 c, Numerator[a^2*b^-a*c]],
        ESameTest[2, Numerator[2/3]]
    ]
};

Denominator::usage = "`+"`"+`Denominator[e]`+"`"+` returns the denominator of `+"`"+`e`+"`"+`.";
Denominator[prod_Times] := Times@@Cases[prod, denPattern -> b^(-n)];
Denominator[Rational[n_,d_]] := d;
Denominator[e_] := 1;
Attributes[Denominator] = {Listable, Protected};
Tests`+"`"+`Denominator = {
    ESimpleExamples[
        ESameTest[b c, Denominator[a/(b*c)]],
        ESameTest[1, Denominator[a^2*b]],
        ESameTest[b^2 c^3, Denominator[a^2*b^-2*c^-3]],
        ESameTest[b^a c^d, Denominator[a^2*b^-a*c^-d]],
        ESameTest[3, Denominator[2/3]]
    ]
};

Apart::usage = "`+"`"+`Apart[e]`+"`"+` attempts to break apart the terms in `+"`"+`e`+"`"+`. Warning: not fully implemented.";
termsWithout[dTerms_, i_] :=
  Product[If[index === i, 1, dTerms[[index]]], {index,
    Length[dTerms]}];
getPowerApartForm[base_, exp_, denTerms_] :=
  Module[{b = base, n = exp, holders, form, dTerms = denTerms,
    unDivForm, finalForm},
   holders = Table[Unique[], n//Evaluate];
   finalForm = Sum[(holders[[i]]/b^i), {i, n}];
   form = Sum[(holders[[i]]/b^i)*Times @@ dTerms, {i, n}];
   {finalForm, form, holders}
   ];
getApartForm[denTerms_, iVar_] :=
  Module[{dTerms = denTerms, i = iVar, holder, powerPattern},
   powerPattern := b_^n_Integer;
   If[MatchQ[dTerms[[i]], powerPattern],
    Replace[dTerms[[i]],
     powerPattern :> getPowerApartForm[b, n, dTerms]],
    holder = Unique[];
    {holder/dTerms[[i]],
     holder*If[Length[dTerms] === 1, dTerms[[1]],
       termsWithout[dTerms, i]], {holder}}]
   ];
myLinearApart[num_, denTerms_, var_] :=
  Module[{n = num, dTerms = denTerms, v = var, lhs, rhs, coeffs,
    apartForm, coeffHolders, tmp, toSolve, finalForm},
   coeffHolders = {};
   apartForm = {};
   finalForm = {};
   Do[
    tmp = getApartForm[dTerms, i];
    coeffHolders = Join[coeffHolders, tmp[[3]]];
    AppendTo[apartForm, tmp[[2]]];
    AppendTo[finalForm, tmp[[1]]];
    , {i, Length[dTerms]}];
   apartForm = Plus @@ apartForm;

   lhs = CoefficientList[apartForm, v];
   rhs = PadRight[CoefficientList[n, v], Length[lhs]];
   toSolve = Table[lhs[[i]] == rhs[[i]], {i, Length[lhs]}];
   (*Print[toSolve, coeffHolders];*)
   coeffs = Solve[toSolve, coeffHolders];
   If[Length[coeffs] === 0 || Head[coeffs] === Solve,
    num/(Times @@ denTerms),
    Plus @@ (finalForm /. coeffs[[1]])
    ]
   ];
ClearAll[denTerms];
getDenTerms[den_Times] := List @@ den;
getDenTerms[den_] := {den};
validDenTermQ[t_, x_] :=
  MatchQ[t, (Optional[a_?((FreeQ[#, x]) &)]*
      x^Optional[n_Integer]) | (Optional[a_?((FreeQ[#, x]) &)]*x +
       Optional[b_?((FreeQ[#, x]) &)])^Optional[n_?((FreeQ[#, x]) &)]];
myApartUnexpanded[expr_Times, var_] :=
  Module[{e = expr, v = var, denTerms, num, den, divRes},
   num = Numerator[e];
   den = Denominator[e];
   If[Exponent[num, v] > Exponent[den, v], Return[
     divRes = PolynomialQuotientRemainder[num, den, v];
     divRes[[1]] + myApartUnexpanded[divRes[[2]]/den, v]
     ]];
   denTerms = getDenTerms[den];
   (*If[Length[denTerms]<2,Return[e]];*)

   If[! AllTrue[denTerms, validDenTermQ[#, v] &], Return[e]];
   myLinearApart[num, denTerms, v]
   ];
myApartUnexpanded[expr_, var_] := expr;

Apart[expr_, var_] := myApartUnexpanded[expr, var] // Expand;
Apart[e_] := Expand[e];

Attributes[Apart] = {Listable, Protected};
Tests`+"`"+`Apart = {
    ESimpleExamples[
        ESameTest[a^3+3 a^2 b+3 a b^2+b^3, Apart[(a + b)^3]],
        ESameTest[7/(6 (-5+x))+11/(6 (1+x)), Apart[(3x-8)/((x+1)*(x-5)),x]],
        (*ESameTest[13/(10 (-1+x))-5/(6 (1+x))-7/(15 (4+x)), Apart[(4x+9)/((-1+x) (1+x) (4+x)),x]],*)
        (*ESameTest[1/b-a/(b (a+b x)), Apart[(x/(a+(b*x))),x]],*)
        ESameTest[(5 a^4)/b^6-(4 a^3 x)/b^5+(3 a^2 x^2)/b^4-(2 a x^3)/b^3+x^4/b^2+a^6/(b^6 (a+b x)^2)-(6 a^5)/(b^6 (a+b x)), Apart[(x^6/((a+(b*x))*(a+(b*x)))),x]],
        ESameTest[(5 a^4)/b^6-(4 a^3 x)/b^5+(3 a^2 x^2)/b^4-(2 a x^3)/b^3+x^4/b^2+a^6/(b^6 (a+b x)^2)-(6 a^5)/(b^6 (a+b x)), Apart[(x^6*(a+(b*x))^-2),x]],
        (*ESameTest[2/(27 (-2+x))+1/(3 (1+x)^3)+7/(9 (1+x)^2)-2/(27 (1+x)), Apart[(x^2-2)/((x-2)(x+1)^3),x]]*)
    ]
};

Distribute::usage = "`+"`"+`Distribute[e]`+"`"+` distributes the function over the `+"`"+`Plus`+"`"+` expressions.";
Distribute[e_] := Distribute[e, Plus];
Attributes[Distribute] = {Protected};
Tests`+"`"+`Distribute = {
    ESimpleExamples[
        ESameTest[a c+b c+a d+b d, Distribute[(a+b)*(c+d)]],
        ESameTest[a c+b c, Distribute[(a+b)*c]],
        ESameTest[foo[a,c]+foo[b,c], Distribute[foo[(a+b),c]]],
        ESameTest[foo[a,b], Distribute[foo[a,b]]],
        ESameTest[foo[c]+foo[a,b], Distribute[foo[a,b]+foo[c]]],
        ESameTest[a+(a+b) c, Distribute[(a+b)*(c)+a]],
        ESameTest[(a+b) c e+d e+(a+b) c f+d f, Distribute[((a+b)*(c)+d)*(e+f)]],
        ESameTest[test[foo[a,b]], Distribute[foo[a,b],test]],
        ESameTest[test[foo[a,b],foo[a,c]], Distribute[foo[a,test[b,c]],test]],
        ESameTest[test[foo[a,b,d],foo[a,b,e],foo[a,c,d],foo[a,c,e]], Distribute[foo[a,test[b,c],test[d,e]],test]],
        ESameTest[test[foo[a,b,d,bar[a]],foo[a,b,e,bar[a]],foo[a,c,d,bar[a]],foo[a,c,e,bar[a]]], Distribute[foo[a,test[b,c],test[d,e],bar[a]],test]],
        ESameTest[a, Distribute[a,test]],
        ESameTest[1[a+b], Distribute[a+b,1]],
        ESameTest[test[bar[a,b,d],bar[a,b,e],bar[a,c,d],bar[a,c,e]], Distribute[bar[a,test[b,c],test[d,e]],test]],
        ESameTest[test[test[f,g][a,b,d],test[f,g][a,b,e],test[f,g][a,c,d],test[f,g][a,c,e]], Distribute[test[f,g][a,test[b,c],test[d,e]],test]],
        ESameTest[test[foo[]], Distribute[foo[],test]],
        ESameTest[test[][foo[]], Distribute[foo[],test[]]],
        ESameTest[foo, Distribute[foo,test]]
    ]
};
`)

func resourcesManipMBytes() ([]byte, error) {
	return _resourcesManipM, nil
}

func resourcesManipM() (*asset, error) {
	bytes, err := resourcesManipMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/manip.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesMatrixM = []byte(`Inverse::usage = "`+"`"+`Inverse[mat]`+"`"+` finds the inverse of the square matrix `+"`"+`mat`+"`"+`.";
Inverse[{{a_}}] := {{1/a}};
Inverse[{{a_, b_}, {c_, d_}}] := {{d/(-b c + a d), -(b/(-b c + a d))}, {-(c/(-b c + a d)), a/(-b c + a d)}};
Inverse[{{a_, b_, c_}, {d_, e_, f_}, {h_, i_, j_}}] := {{(-f i + e j)/(-c e h + b f h + c d i - a f i - b d j + a e j), (c i - b j)/(-c e h + b f h + c d i - a f i - b d j + a e j), (-c e + b f)/(-c e h + b f h + c d i - a f i - b d j + a e j)}, {(f h - d j)/(-c e h + b f h + c d i - a f i - b d j + a e j), (-c h + a j)/(-c e h + b f h + c d i - a f i - b d j + a e j), (c d - a f)/(-c e h + b f h + c d i - a f i - b d j + a e j)}, {(-e h + d i)/(-c e h + b f h + c d i - a f i - b d j + a e j), (b h - a i)/(-c e h + b f h + c d i - a f i - b d j + a e j), (-b d + a e)/(-c e h + b f h + c d i - a f i - b d j + a e j)}};
Attributes[Inverse] = {Protected};
Tests`+"`"+`Inverse = {
    ESimpleExamples[
        ESameTest[{{-2, 1}, {3/2, -(1/2)}}, Inverse[{{1, 2}, {3, 4}}]],
        ESameTest[{{2/5, -(1/5), 0}, {-(1/15), 19/45, -(1/9)}, {-(1/15), -(11/45), 2/9}}, Inverse[{{3, 2, 1}, {1, 4, 2}, {2, 5, 7}}]]
    ], EFurtherExamples[
        EComment["Symbolic elements are handled correctly:"],
        ESameTest[Inverse[{{b}}], {{1/b}}]
    ]
};

Dimensions::usage = "`+"`"+`Dimensions[expr]`+"`"+` finds the dimensions of `+"`"+`expr`+"`"+`.";
Attributes[Dimensions] = {Protected};
Tests`+"`"+`Dimensions = {
    ESimpleExamples[
        ESameTest[{2, 2}, Dimensions[{{1, 3}, {1, 2}}]],
        ESameTest[{2}, Dimensions[{{{1, 2}, {3, 2}}, {{1, 2}}}]]
    ], EFurtherExamples[
        ESameTest[{}, Dimensions[foo]],
        EComment["`+"`"+`Dimensions`+"`"+` works with any head, not just `+"`"+`List`+"`"+`:"],
        ESameTest[{0}, Dimensions[foo[]]]
    ], ETests[
        ESameTest[{2}, Dimensions[{1, 2}]],
        ESameTest[{0}, Dimensions[{}]],
        ESameTest[{1}, Dimensions[foo[{1}]]],
        ESameTest[{1, 1}, Dimensions[{{1}}]],
        ESameTest[{2, 1}, Dimensions[{{1}, {1}}]],
        ESameTest[{2}, Dimensions[{{1}, {1, 2}}]],
        ESameTest[{2, 2}, Dimensions[{{1, 3}, {1, 2}}]],
        ESameTest[{2, 2, 1}, Dimensions[{{{1}, {3}}, {{1}, {2}}}]],
        ESameTest[{2, 2, 2}, Dimensions[{{{1, 2}, {3, 2}}, {{1, 2}, {2, 2}}}]],
        ESameTest[{2}, Dimensions[{{{1, 2}, {3, 2}}, {{1, 2}}}]],
        ESameTest[{2, 2, 2}, Dimensions[{{{1, 2}, {3, 2}}, {{1, 2}, {foo, 2}}}]],
        ESameTest[{2, 2}, Dimensions[{{{1, 2}, {3, 2}}, {{1, 2}, foo[foo, 2]}}]],
        ESameTest[{1, 2, 0}, Dimensions[{{{}, {}}}]],
        ESameTest[{1, 2}, Dimensions[{{{}, foo[x]}}]]
    ]
};

VectorQ::usage = "`+"`"+`VectorQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is a vector, False otherwise.";
Attributes[VectorQ] = {Protected};
Tests`+"`"+`VectorQ = {
    ESimpleExamples[
        ESameTest[True, VectorQ[{1, 2, c}]],
        ESameTest[True, VectorQ[{1, 2, foo[a]}]],
        ESameTest[False, VectorQ[foo[1, 2, 3]]],
        ESameTest[False, VectorQ[{1, 2, 3, {}}]],
        ESameTest[True, VectorQ[{f[a], f[b]}]],
        ESameTest[True, VectorQ[{a, c}]],
        ESameTest[True, VectorQ[{}]]
    ]
};

MatrixQ::usage = "`+"`"+`MatrixQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is a 2D matrix, False otherwise.";
Attributes[MatrixQ] = {Protected};
Tests`+"`"+`MatrixQ = {
    ESimpleExamples[
        ESameTest[False, MatrixQ[{}]],
        ESameTest[True, MatrixQ[{{}}]],
        ESameTest[True, MatrixQ[{{a}}]],
        ESameTest[False, MatrixQ[{{{}}}]],
        ESameTest[False, MatrixQ[{{{a}}}]],
        ESameTest[True, MatrixQ[{{a}, {b}}]],
        ESameTest[True, MatrixQ[{{a, b}, {c, d}}]],
        ESameTest[False, MatrixQ[{{a, b, e}, {c, d}}]],
        ESameTest[True, MatrixQ[{{a, b, e}, {c, d, f}}]],
        ESameTest[False, MatrixQ[{{{a}, {b}}, {{c}, {d}}}]],
        ESameTest[True, MatrixQ[{{a, b, e}}]]
    ]
};

Dot::usage = "`+"`"+`a.b`+"`"+` computes the product of `+"`"+`a`+"`"+` and `+"`"+`b`+"`"+` for vectors and matrices.";
Dot[m_?MatrixQ,v_?VectorQ]:=Table[m[[idx]].v,{idx,Length[v]}];
Attributes[Dot] = {Flat, OneIdentity, Protected};
Tests`+"`"+`Dot = {
    ESimpleExamples[
        ESameTest[a c + b d, {a, b}.{c, d}],
        ESameTest[{a, b}.{c, d, e}, {a, b}.{c, d, e}],
        ESameTest[Dot[1, {c, d, e}], Dot[1, {c, d, e}]],
        ESameTest[0, Dot[{}, {}]],
        ESameTest[{{a, b}, {c, d}}.{e, f, g}, {{a, b}, {c, d}}.{e, f, g}],
        ESameTest[{a, b}, Dot[{a, b}]],
        ESameTest[a, Dot[a]],
        ESameTest[1, Dot[1]],
        ESameTest[{{a e + b g, a f + b h}, {c e + d g, c f + d h}}, {{a, b}, {c, d}}.{{e, f}, {g, h}}],
        ESameTest[{{a e + b f}, {c e + d f}}, {{a, b}, {c, d}}.{{e}, {f}}],
        ESameTest[{{a, b}, {c, d}}.{{e, f}}, {{a, b}, {c, d}}.{{e, f}}]
    ], EKnownFailures[
        ESameTest[{a e + b f, c e + d f}, {{a, b}, {c, d}}.{e, f}],
        ESameTest[{a e + c f, b e + d f}, {e, f}.{{a, b}, {c, d}}]
    ]
};

Transpose::usage = "`+"`"+`Transpose[mat]`+"`"+` transposes the first two levels of `+"`"+`mat`+"`"+`";
Attributes[Transpose] = {Protected};
Tests`+"`"+`Transpose = {
    ESimpleExamples[
        ESameTest[Transpose[{a, b}], Transpose[{a, b}]],
        ESameTest[{{a, b}}, Transpose[{{a}, {b}}]],
        ESameTest[{{a}, {b}}, Transpose[{{a, b}}]],
        ESameTest[{{{a}}, {{b}}}, Transpose[{{{a}, {b}}}]],
        ESameTest[Transpose[a], Transpose[a]]
    ]
};
`)

func resourcesMatrixMBytes() ([]byte, error) {
	return _resourcesMatrixM, nil
}

func resourcesMatrixM() (*asset, error) {
	bytes, err := resourcesMatrixMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/matrix.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesNumbertheoryM = []byte(`PrimeQ::usage = "`+"`"+`PrimeQ[n]`+"`"+` returns True if `+"`"+`n`+"`"+` is prime, False otherwise.";
Attributes[PrimeQ] = {Listable, Protected};
Tests`+"`"+`PrimeQ = {
    ESimpleExamples[
        ESameTest[True, PrimeQ[5]],
        ESameTest[False, PrimeQ[100]],
        ESameTest[True, PrimeQ[982451653]],
        ESameTest[True, PrimeQ[-2]]
    ], EFurtherExamples[
        EComment["`+"`"+`PrimeQ`+"`"+` only works for Integers:"],
        ESameTest[False, PrimeQ[5.]]
    ], ETests[
        ESameTest[False, PrimeQ[0]],
        ESameTest[False, PrimeQ[1]],
        ESameTest[False, PrimeQ[-1]],
        ESameTest[False, PrimeQ[0.5]]
    ]
};

GCD::usage = "`+"`"+`GCD[n1, n2, ...]`+"`"+` finds the greatest common denominator of the integer inputs.";
(* Eventually we should not need the rest___ term. GCD is Flat. *)
GCD[Rational[a_, b_], Rational[c_, d_], rest___] := 
  GCD[GCD[a*d, c*b]/(b*d), rest];
GCD[Rational[a_, b_], c_Integer, rest___] := 
  GCD[GCD[a, c*b]/b, rest];
(*This deviates from how it should be done*)
GCD[a_Rational] := Abs[a];
Attributes[GCD] = {Flat, Listable, OneIdentity, Orderless, Protected};
Tests`+"`"+`GCD = {
    ESimpleExamples[
        ESameTest[3, GCD[9, 6]],
        ESameTest[5, GCD[100, 30, 15]]
    ], ETests[
        ESameTest[1, GCD[9, 2]],
        ESameTest[10, GCD[100, 0, 10]],
        ESameTest[3, GCD[9, 3]],
        ESameTest[10, GCD[100, 30, 10]],
        ESameTest[10, GCD[100, 30]],
        ESameTest[1, GCD[100, 30, -1]],
        ESameTest[10, GCD[100, 30, -60]],
        ESameTest[60, GCD[-60, -60, -60]],
        ESameTest[GCD[-60, -60, -0.5], GCD[-60, -60, -0.5]],
        ESameTest[GCD[0.5], GCD[0.5]],
        ESameTest[GCD[1, a], GCD[1, a]],
        ESameTest[GCD[a, a], GCD[a, a]],
        ESameTest[0, GCD[]],
        ESameTest[1, GCD[1]],
        ESameTest[GCD[a], GCD[a]],
        ESameTest[1000, GCD[1000]],
        ESameTest[5, GCD[5, 15]],
        ESameTest[5, GCD[5, 15, 30]],
        ESameTest[5, GCD[10, 20, 25]],
        ESameTest[1, GCD[5, 14]],
        ESameTest[5/2, GCD[5/2, 15/2]],
        ESameTest[5/3, GCD[5/3, 5]],
        ESameTest[GCD[5/3,a], GCD[5/3, a]],
        ESameTest[GCD[a,b,c], GCD[a, b, c]],
        ESameTest[0, GCD[0]],
        ESameTest[0, GCD[0, 0]],
        ESameTest[99, GCD[-99]],
        ESameTest[5/2, GCD[-5/2]],
        ESameTest[5, GCD[10, -20, 25]],
        ESameTest[1, GCD[5, -14]],
        ESameTest[5/2, GCD[5/2, -15/2]],
        ESameTest[5/2, GCD[5/2, -15/2, -15/2]],
        ESameTest[5/3, GCD[-5/3, -5]],
        ESameTest[5/3, GCD[-5/3, -5]],
        ESameTest[GCD[-(5/3),a], GCD[-5/3, a]]
    ]
};

LCM::usage = "`+"`"+`LCM[n1, n2, ...]`+"`"+` finds the least common multiple of the inputs.";
LCM[a_?NumberQ, b_?NumberQ] := (a/GCD[a, b])*b;
LCM[a_?NumberQ, b_?NumberQ, rest__?NumberQ] := 
  LCM[LCM[a, b], rest];
Attributes[LCM]={Flat,Listable,OneIdentity,Orderless,Protected};
Tests`+"`"+`LCM = {
    ESimpleExamples[
        ESameTest[70, LCM[5, 14]],
        ESameTest[2380, LCM[5, 14, 68]],
        ESameTest[2/3, LCM[2/3, 1/3]],
        ESameTest[10/3, LCM[2/3, 1/3, 5/6]],
        ESameTest[30, LCM[2/3, 1/3, 5/6, 3]],
        ESameTest[{2/3,10/3,6}, LCM[2/3, {1/3, 5/6, 3}]]
    ], ETests[
        ESameTest[{10/3,10/3,30}, LCM[2/3, {1/3, 5/6, 3}, 5/6]],
        ESameTest[LCM[a,b], LCM[a, b]],
        ESameTest[LCM[a,b,c], LCM[a, b, c]],
        ESameTest[LCM[5,6,c], LCM[5, 6, c]]
    ]
};

Mod::usage = "`+"`"+`Mod[x, y]`+"`"+` finds the remainder when `+"`"+`x`+"`"+` is divided by `+"`"+`y`+"`"+`.";
(* Factor out numeric constants like Pi: *)
Mod[a_Integer*c_?NumericQ,b_Integer*c_?NumericQ] := c * Mod[a,b];
Mod[Rational[a_,b_],c_Integer] := Mod[a,c*b] / b;
Attributes[Mod] = {Listable, NumericFunction, ReadProtected, Protected};
Tests`+"`"+`Mod = {
    ESimpleExamples[
        ESameTest[2, Mod[5,3]],
        ESameTest[0, Mod[0,3]],
        ESameTest[Indeterminate, Mod[2,0]],
        ESameTest[Pi, Mod[-2 Pi,3 Pi]]
    ], ETests[
        ESameTest[1, Mod[-5,3]],
        ESameTest[Mod[a,3], Mod[a,3]],
        ESameTest[Indeterminate, Mod[0,0]],
        ESameTest[Mod[2,a], Mod[2,a]],
        ESameTest[Mod[0,a], Mod[0,a]],
        ESameTest[1,Mod[-1,2]],
        ESameTest[5/4,Mod[-(3/4),2]],
        ESameTest[3/2,Mod[-(1/2),2]],
        ESameTest[7/4,Mod[-(1/4),2]],
        ESameTest[0,Mod[0,2]],
        ESameTest[1/4,Mod[1/4,2]],
        ESameTest[1/2,Mod[1/2,2]],
        ESameTest[3/4,Mod[3/4,2]],
        ESameTest[1,Mod[1,2]],
    ], EKnownFailures[
        ESameTest[1.5, Mod[1.5,3]],
        ESameTest[0., Mod[2,0.5]]
    ]
};

EvenQ::usage = "`+"`"+`EvenQ[n]`+"`"+` returns True if `+"`"+`n`+"`"+` is an even integer.";
EvenQ[n_Integer] := Mod[n,2]===0;
Attributes[EvenQ] = {Listable, Protected};
Tests`+"`"+`EvenQ = {
    ESimpleExamples[
        ESameTest[True, EvenQ[6]],
        ESameTest[True, EvenQ[-2]],
        ESameTest[False, EvenQ[1]],
        ESameTest[EvenQ[2.], EvenQ[2.]],
        ESameTest[EvenQ[a], EvenQ[a]]
    ]
};

OddQ::usage = "`+"`"+`OddQ[n]`+"`"+` returns True if `+"`"+`n`+"`"+` is an odd integer.";
OddQ[n_Integer] := Mod[n,2]===1;
Attributes[OddQ] = {Listable, Protected};
Tests`+"`"+`OddQ = {
    ESimpleExamples[
        ESameTest[False, OddQ[6]],
        ESameTest[False, OddQ[-2]],
        ESameTest[True, OddQ[1]],
        ESameTest[OddQ[2.], OddQ[2.]],
        ESameTest[OddQ[a], OddQ[a]]
    ]
};

FactorInteger::usage = "`+"`"+`FactorInteger[n]`+"`"+` factors the integer `+"`"+`n`+"`"+`.";
FactorInteger[Rational[n_, d_]] := 
  DeleteCases[Join[FactorInteger[n], ({#[[1]], -#[[2]]} &) /@ FactorInteger[d]] // Sort, {1,1}];
FactorInteger[int_Integer?Negative] := DeleteCases[Prepend[FactorInteger[-int], {-1, 1}], {1,1}];
FactorInteger[0] := {{0, 1}};
(* TODO: use Pollard's rho algorithm. *)
(* TODO: convert to using the internal primeFactorsTallied function *)

FactorInteger[int_Integer?Positive] := Module[{n = int, i = 2, factors},
   If[n === 1, Return[{{1, 1}}]];
   factors = {};
   While[n =!= 1,
    While[Mod[n, i] =!= 0, i = i + 1];
    AppendTo[factors, i];
    n = n/i;
    i = 2
    ];
   Tally[factors] // Sort
   ];
Attributes[FactorInteger] = {Listable, Protected};
Tests`+"`"+`FactorInteger = {
    ESimpleExamples[
        ESameTest[{{2, 3}}, FactorInteger[8]],
        ESameTest[{{-1,1},{2,-1},{3,1},{5,1}}, FactorInteger[Rational[-15,2]]],
    ], ETests[
        ESameTest[{{-1,1},{2,2},{5,1}}, FactorInteger[-20]],
        ESameTest[{{-1,1},{7,1}}, FactorInteger[-7]],
        ESameTest[{{-1,1},{3,1}}, FactorInteger[-3]],
        ESameTest[{{-1,1},{2,1}}, FactorInteger[-2]],
        ESameTest[{{-1,1}}, FactorInteger[-1]],
        ESameTest[{{0, 1}}, FactorInteger[0]],
        ESameTest[{{1, 1}}, FactorInteger[1]],
        ESameTest[{{2, 1}}, FactorInteger[2]],
        ESameTest[{{3, 1}}, FactorInteger[3]],
        ESameTest[{{2, 2}}, FactorInteger[4]],
        ESameTest[{{7, 1}}, FactorInteger[7]],
        ESameTest[{{2, -2}, {3, 1}, {7, 1}}, FactorInteger[Rational[21,4]]],
        ESameTest[{{-1, 1}, {2, -1}}, FactorInteger[Rational[-1,2]]],
        ESameTest[{{2, -1}}, FactorInteger[Rational[1,2]]],
    ]
};

FractionalPart::usage = "`+"`"+`FractionalPart[n]`+"`"+` gives the fractional part of `+"`"+`n`+"`"+`";
FractionalPart[n_Rational] := If[n >= 0, Mod[n, 1], -Mod[-n, 1]];
FractionalPart[n_Integer] := 0;
Attributes[FractionalPart] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`FractionalPart = {
    ESimpleExamples[
        ESameTest[0,FractionalPart[-1]],
        ESameTest[-(3/4),FractionalPart[-(3/4)]],
        ESameTest[-(1/2),FractionalPart[-(1/2)]],
        ESameTest[-(1/4),FractionalPart[-(1/4)]],
        ESameTest[0,FractionalPart[0]],
        ESameTest[1/4,FractionalPart[1/4]],
        ESameTest[1/2,FractionalPart[1/2]],
        ESameTest[3/4,FractionalPart[3/4]],
        ESameTest[0,FractionalPart[1]],
    ]
};

IntegerPart::usage = "`+"`"+`IntegerPart[n]`+"`"+` gives the integer part of `+"`"+`n`+"`"+`";
IntegerPart[n_Rational] := n - FractionalPart[n];
IntegerPart[n_Integer] := n;
Attributes[IntegerPart] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`IntegerPart = {
    ESimpleExamples[
        ESameTest[-1,IntegerPart[-1]],
        ESameTest[0,IntegerPart[-(3/4)]],
        ESameTest[0,IntegerPart[-(1/2)]],
        ESameTest[0,IntegerPart[-(1/4)]],
        ESameTest[0,IntegerPart[0]],
        ESameTest[0,IntegerPart[1/4]],
        ESameTest[0,IntegerPart[1/2]],
        ESameTest[0,IntegerPart[3/4]],
        ESameTest[1,IntegerPart[1]],
    ]
};

PowerMod::usage = "`+"`"+`PowerMod[x, y, m]`+"`"+` computes `+"`"+`Mod[x^y, m]`+"`"+`";
(*TODO: use efficient version of this function.*)
PowerMod[x_, y_, m_] := Mod[x^y, m];
Attributes[PowerMod] = {Listable, Protected, ReadProtected};
Tests`+"`"+`PowerMod = {
    ESimpleExamples[
        ESameTest[6,PowerMod[5, 9999, 7]],
    ]
};

EulerPhi::usage = "`+"`"+`EulerPhi[n]`+"`"+` computes Euler's totient function for `+"`"+`n`+"`"+`";
Attributes[EulerPhi] = {Listable, Protected, ReadProtected};
EulerPhi[0] := 0;
EulerPhi[n_Integer?Positive] := 
 If[n === 1, 1,
 n*Product[1 - 1/p[[1]], {p, FactorInteger[n]}]];
EulerPhi[n_Integer?Negative] := EulerPhi[-n];
Tests`+"`"+`EulerPhi = {
    ESimpleExamples[
        ESameTest[42,EulerPhi[98]],
        ESameTest[0,EulerPhi[0]],
        ESameTest[42,EulerPhi[-98]],
    ], ETests[
        ESameTest[1,EulerPhi[1]],
        ESameTest[1,EulerPhi[-1]],
    ]
};

Fibonacci::usage = "`+"`"+`Fibonacci[n]`+"`"+` computes the Fibonacci number for `+"`"+`n`+"`"+`";
Fibonacci[0] = 0; Fibonacci[1] = 1;
(*TODO: implement as RootReduce@(((1 + Sqrt[5])/2)^n - ((1 - Sqrt[5])/2)^n)/Sqrt[5]*)
Fibonacci[n_] := Fibonacci[n] = Fibonacci[n - 1] + Fibonacci[n - 2];
Attributes[Fibonacci] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`Fibonacci = {
    ESimpleExamples[
        ESameTest[6765, Fibonacci[20]]
    ]
};

IntegerDigits::usage = "`+"`"+`IntegerDigits[n, base]`+"`"+` returns a list of integer digits for `+"`"+`n`+"`"+` under `+"`"+`base`+"`"+`.";
IntegerDigits[n_Integer] := IntegerDigits[n, 10];
IntegerDigits[signedN_Integer, base_Integer?Positive] :=
  Module[{n = Abs[signedN], list = {}},
   While[n > 0,
    PrependTo[list, Mod[n, base]];
    n = (n - Mod[n, base])/base;
    ];
   list
   ];
Attributes[IntegerDigits] = {Listable, Protected};
Tests`+"`"+`IntegerDigits = {
    ESimpleExamples[
        ESameTest[{1, 2, 3}, IntegerDigits[123]],
        ESameTest[{1, 1, 1, 1, 0, 1, 1}, IntegerDigits[123, 2]],
        ESameTest[{1, 1, 1, 1, 0, 1, 1}, IntegerDigits[-123, 2]]
    ]
};

Sign::usage = "`+"`"+`Sign[x]`+"`"+` returns the sign of `+"`"+`x`+"`"+`.";
Sign[n_Integer] := Which[
  n < 0, -1,
  n > 0, 1,
  True, 0];
Sign[n_Real] := Which[
  n < 0, -1,
  n > 0, 1,
  True, 0];
Sign[n_Rational] := Which[
  n < 0, -1,
  n > 0, 1,
  True, 0];
Attributes[Sign] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`Sign = {
    ESimpleExamples[
        ESameTest[1, Sign[5]],
        ESameTest[0, Sign[0]],
        ESameTest[-1, Sign[-5]],
        ESameTest[1, Sign[5.]],
        ESameTest[0, Sign[0.]],
        ESameTest[-1, Sign[-5.]],
        ESameTest[1, Sign[1/2]],
    ]
};
`)

func resourcesNumbertheoryMBytes() ([]byte, error) {
	return _resourcesNumbertheoryM, nil
}

func resourcesNumbertheoryM() (*asset, error) {
	bytes, err := resourcesNumbertheoryMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/numbertheory.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesPatternM = []byte(`MatchQ::usage = "`+"`"+`MatchQ[expr, form]`+"`"+` returns True if `+"`"+`expr`+"`"+` matches `+"`"+`form`+"`"+`, False otherwise.";
Attributes[MatchQ] = {Protected};
Tests`+"`"+`MatchQ = {
    ESimpleExamples[
        EComment["A `+"`"+`Blank[]`+"`"+` expression matches everything:"],
        ESameTest[True, MatchQ[2*x, _]],
        EComment["Although a more specific pattern would have matched as well:"],
        ESameTest[True, MatchQ[2*x, c1_Integer*a_Symbol]],
        EComment["Since `+"`"+`Times`+"`"+` is `+"`"+`Orderless`+"`"+`, this would work as well:"],
        ESameTest[True, MatchQ[x*2, c1_Integer*a_Symbol]],
        EComment["As would the `+"`"+`FullForm`+"`"+`:"],
        ESameTest[True, MatchQ[Times[x, 2], c1_Integer*a_Symbol]],
        EComment["Named patterns must match the same expression, or the match will fail:"],
        ESameTest[False, MatchQ[a + b, x_Symbol + x_Symbol]]
    ], EFurtherExamples[
        ESameTest[True, MatchQ[{2^a, a}, {2^x_Symbol, x_Symbol}]],
        ESameTest[False, MatchQ[{2^a, b}, {2^x_Symbol, x_Symbol}]],
        EComment["`+"`"+`Blank`+"`"+` sequences allow for the matching of multiple objects. `+"`"+`BlankSequence`+"`"+` (__) matches one or more parts of the expression:"],
        ESameTest[True, MatchQ[{a, b}, {a, __}]],
        ESameTest[False, MatchQ[{a}, {a, __}]],
        EComment["`+"`"+`BlankNullSequence`+"`"+` (___) allows for zero or more matches:"],
        ESameTest[True, MatchQ[{a}, {a, ___}]]
    ], ETests[
        ESameTest[True, MatchQ[2^x, base_Integer^pow_Symbol]],
        ESameTest[True, MatchQ[2+x, c1_Integer+a_Symbol]],
        ESameTest[True, MatchQ[a + b, x_Symbol + y_Symbol]],
        ESameTest[True, MatchQ[{a,b}, {x_Symbol,y_Symbol}]],
        ESameTest[False, MatchQ[{a,b}, {x_Symbol,x_Symbol}]],
         (*Test speed of OrderlessIsMatchQ*)
        ESameTest[Null, Plus[testa, testb, rest___] := bar + rest],
        ESameTest[bar + 1 + a + b + c + d + e + f + g, Plus[testa,1,testb,a,b,c,d,e,f,g]],
        ESameTest[True, MatchQ[foo[2*x, x], foo[matcha_Integer*matchx_, matchx_]]],
        ESameTest[False, MatchQ[foo[2*x, x], bar[matcha_Integer*matchx_, matchx_]]],
        ESameTest[False, MatchQ[foo[2*x, y], foo[matcha_Integer*matchx_, matchx_]]],
        ESameTest[False, MatchQ[foo[x, 2*y], foo[matcha_Integer*matchx_, matchx_]]],
        ESameTest[True, MatchQ[foo[2 * x,2], foo[(p_ * v_), v_]]],

        ESameTest[True, MatchQ[mysolve[m*x + b == 0, x], mysolve[x_*__ + _ == _, x_]]],
        ESameTest[False, MatchQ[mysolve[m*x + b == 0, y], mysolve[x_*__ + _ == _, x_]]],
        ESameTest[True, MatchQ[mysolve[m*x+a, m], mysolve[x_*_+a, x_]]],
        ESameTest[True, MatchQ[bar[foo[a + b] + c + d, c, d, a, b], bar[w_ + x_ + foo[y_ + z_], w_, x_, y_, z_]]],
        ESameTest[True, MatchQ[bar[foo[a + b] + c + d, d, c, b, a], bar[w_ + x_ + foo[y_ + z_], w_, x_, y_, z_]]],
        ESameTest[False, MatchQ[bar[foo[a + b] + c + d, d, a, b, c], bar[w_ + x_ + foo[y_ + z_], w_, x_, y_, z_]]],

        (* We disable the tests that use rm because they require the
        freezeStateDuringPreMatch flag, which is now turned off by default. *)
         (*Test order of pattern checking*)
        (*ESameTest[Null, rm[pattern_]:=pattern?((pats=Append[pats,{pattern[[1]],#}];True)&);],
        ESameTest[True, pats={};MatchQ[foo[a,b,c],foo[x_//rm,y_//rm,z_//rm]]],
        ESameTest[{{x,a},{y,b},{z,c}}, pats],*)

         (*Test pinning in flat*)
        (*ESameTest[{{{a},{c}}}, pats={};ReplaceList[ExpreduceFlatFn[a,b,c],ExpreduceFlatFn[x___//rm,b//rm,y___//rm]->{{x},{y}}]],

        ESameTest[{{{a,a,c}},{{a,a,c}},{{a,a,c}},{{a,a,c}}}, pats={};ReplaceList[ExpreduceFlOrOiFn[a,a,c],ExpreduceFlOrOiFn[b___//rm,c//rm,a___//rm]->{{a,b,c}}]],
        ESameTest[{{{},{a,c}},{{a},{c}},{{c},{a}},{{a,c},{}}}, pats={};ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[x___//rm,b//rm,y___//rm]->{{x},{y}}]],*)

         (*Test pinning in orderless*)
        (*ESameTest[{{b[[1]],b},{y,a},{y,c},{b[[1]],b},{x,a},{y,c},{b[[1]],b},{x,c},{y,a},{b[[1]],b},{x,a},{x,c}}, pats],*)

        ESameTest[True, MatchQ[(a+b)[testsym],Blank[(a+b)]]]
    ], EKnownFailures[
         (*Test order of pattern checking*)
         (*These probably fail because of my formparsing of PatternTest.*)
         (*Try these without the //rm. They will most likely work.*)
        ESameTest[{{c[[1]],c},{b,a},{b,a},{c[[1]],c},{a,a},{b,a},{c[[1]],c},{a,a},{b,a},{c[[1]],c},{a,a},{a,a}}, pats],
        ESameTest[{{x,a},{b[[1]],b},{y,c}}, pats]
    ]
};

Pattern::usage = "`+"`"+`name{BLANKFORM}`+"`"+` is equivalent to `+"`"+`Pattern[name, {BLANKFORM}]`+"`"+` and can be used in pattern matching to refer to the matched expression as `+"`"+`name`+"`"+`, where `+"`"+`{BLANKFORM}`+"`"+` is one of `+"`"+`{_, __, ___}`+"`"+`.

`+"`"+`name{BLANKFORM}head`+"`"+` is equivalent to `+"`"+`Pattern[name, {BLANKFORM}head]`+"`"+` and can be used in pattern matching to refer to the matched expression as `+"`"+`name`+"`"+`, where `+"`"+`{BLANKFORM}`+"`"+` is one of `+"`"+`{_, __, ___}`+"`"+`.";
Attributes[Pattern] = {HoldFirst, Protected};
Tests`+"`"+`Pattern = {
    ESimpleExamples[
        EComment["To demonstrate referencing `+"`"+`name`+"`"+` in the replacement RHS:"],
        ESameTest[2, foo[2, 1] /. foo[a_, b_] -> a],
        EComment["If two matches share the same name, they must be equivalent:"],
        ESameTest[foo[2, 1], foo[2, 1] /. foo[a_, a_] -> a],
        ESameTest[2, foo[2, 2] /. foo[a_, a_] -> a],
        EComment["To demonstrate the head matching capability:"],
        ESameTest[True, MatchQ[2, a_Integer]],
        ESameTest[False, MatchQ[2, a_Real]]
    ], EFurtherExamples[
        EComment["To demonstrate patterns matching a sequence of expressions:"],
        ESameTest[bar[2, 1], foo[2, 1] /. foo[a___Integer] -> bar[a]]
    ]
};

Blank::usage = "`+"`"+`_`+"`"+` matches any expression.

`+"`"+`_head`+"`"+` matches any expression with a `+"`"+`Head`+"`"+` of `+"`"+`head`+"`"+`.";
Attributes[Blank] = {Protected};
Tests`+"`"+`Blank = {
    ESimpleExamples[
        ESameTest[True, MatchQ[a + b, _]],
        ESameTest[True, MatchQ[1, _Integer]],
        ESameTest[False, MatchQ[s, _Integer]],
        EComment["`+"`"+`Blank`+"`"+` works with nonatomic `+"`"+`head`+"`"+`s:"],
        ESameTest[2, a*b*c*d /. _Times -> 2]
    ], EFurtherExamples[
        EComment["For `+"`"+`Orderless`+"`"+` functions, the match engine will attempt to find a match in any order:"],
        ESameTest[True, MatchQ[x+3., c1match_Real+matcha_]]
    ], ETests[
        ESameTest[True, MatchQ[s, _Symbol]],
        ESameTest[False, MatchQ[1, _Symbol]],
        ESameTest[False, MatchQ[_Symbol, _Symbol]],
        ESameTest[False, MatchQ[_Integer, _Integer]],
        ESameTest[True, MatchQ[_Symbol, _Blank]],
        ESameTest[True, MatchQ[_Symbol, test_Blank]],
        ESameTest[True, MatchQ[_Symbol, test_Blank]],
        ESameTest[False, MatchQ[_Symbol, test_Symbol]],
        ESameTest[False, MatchQ[name_Symbol, test_Blank]],
        ESameTest[True, MatchQ[name_Symbol, test_Pattern]],
        ESameTest[True, MatchQ[_Symbol, test_Blank]],
        ESameTest[False, MatchQ[_Symbol, test_Pattern]],
        ESameTest[False, MatchQ[1.5, _Integer]],
        ESameTest[True, MatchQ[1.5, _Real]],
        ESameTest[True, _Symbol == _Symbol],
        ESameTest[_Symbol == _Integer, _Symbol == _Integer],
        ESameTest[False, MatchQ[_Symbol, s]],
        ESameTest[False, MatchQ[_Integer, 1]],
        ESameTest[_Integer == 1, _Integer == 1],
        ESameTest[1 == _Integer, 1 == _Integer],
        ESameTest[False, _Integer === 1],
        ESameTest[False, 1 === _Integer],
        ESameTest[True, _Integer === _Integer],
        ESameTest[False, _Symbol === a],
        ESameTest[False, a === _Symbol],
        ESameTest[True, _Symbol === _Symbol],
        ESameTest[a == b, a == b],
        ESameTest[2, a == b /. _Equal -> 2],
        ESameTest[If[1 == k, itstrue, itsfalse], If[1 == k, itstrue, itsfalse]],
        ESameTest[99, If[1 == k, itstrue, itsfalse] /. _If -> 99],
        ESameTest[False, MatchQ[kfdsfdsf[], _Function]],
        ESameTest[True, MatchQ[kfdsfdsf[], _kfdsfdsf]],
        ESameTest[99, kfdsfdsf[] /. _kfdsfdsf -> 99],
        ESameTest[a + b, a + b],
        ESameTest[2, a + b /. _Plus -> 2],
        ESameTest[2, a*b /. _Times -> 2],
        ESameTest[2, a^b /. _Power -> 2],
        ESameTest[2, a -> b /. _Rule -> 2],
        ESameTest[2, a*b*c*d /. _Times -> 2],
        ESameTest[True, MatchQ[x*3., c1match_Real*matcha_]],
        ESameTest[True, MatchQ[3.*x, c1match_Real*matcha_]],
        ESameTest[True, MatchQ[x+3., c1match_Real+matcha_]],
        ESameTest[True, MatchQ[3.+x, c1match_Real+matcha_]],
        ESameTest[True, MatchQ[y + x, matcha_]],
        ESameTest[True, MatchQ[y*x, matcha_]]
    ]
};

BlankSequence::usage = "`+"`"+`__`+"`"+` matches any sequence of one or more expressions.

`+"`"+`__head`+"`"+` matches any sequence of one or more expressions, each with a `+"`"+`Head`+"`"+` of `+"`"+`head`+"`"+`.";
Attributes[BlankSequence] = {Protected};
Tests`+"`"+`BlankSequence = {
    ESimpleExamples[
        ESameTest[True, MatchQ[a + b + c, a + b + __]],
        ESameTest[False, MatchQ[a + b + c, a + b + c + __]]
    ], EFurtherExamples[
        EComment["With head assertions:"],
        ESameTest[False, MatchQ[a * b, __Symbol]],
        ESameTest[False, MatchQ[a * b, x__Symbol]],
        ESameTest[True, MatchQ[a, __Symbol]],
        ESameTest[True, MatchQ[a * b, x__Times]],
        ESameTest[False, MatchQ[a * b, x__Plus]],
        ESameTest[True, MatchQ[a + b, x__Plus]]
    ], ETests[
         (*Be wary of the false matches - the default is usually false.*)
        ESameTest[True, MatchQ[a, __]],
        ESameTest[True, MatchQ[a + b, __]],
        ESameTest[True, MatchQ[a*b, __]],
        ESameTest[False, MatchQ[a, a*__]],
        ESameTest[True, MatchQ[a + b + c, a + b + __]],
        ESameTest[True, MatchQ[a + b + c + d, a + b + __]],
        ESameTest[False, MatchQ[a*b, __Symbol]],
        ESameTest[False, MatchQ[a*b, x__Symbol]],
        ESameTest[True, MatchQ[a, __Symbol]],
        ESameTest[True, MatchQ[a*b, x__Times]],
        ESameTest[False, MatchQ[a*b, x__Plus]],
        ESameTest[True, MatchQ[a + b, x__Plus]],
        ESameTest[True, MatchQ[a + b + c, a + x__Symbol]],
        ESameTest[False, MatchQ[a + b + c, a + x__Plus]],
        ESameTest[True, MatchQ[a + b, a + x__Symbol]],
        ESameTest[False, MatchQ[a + b, a + x__Plus]],
        ESameTest[False, MatchQ[a + b, a + b + x__Symbol]],
        ESameTest[False, MatchQ[a + b, a + b + x__Plus]],
        ESameTest[True, MatchQ[4*a*b*c*d*e*f, __]],
        ESameTest[True, MatchQ[4*a*b*c*d*e*f, 4*__]],
        ESameTest[False, MatchQ[4*a*b*c*4*d*e*f, 4*__]],
        ESameTest[False, MatchQ[4*a*b*c*4*d*e*f, 4*__]],
        ESameTest[True, MatchQ[a*b*c*4*d*e*f, 4*__]],
        ESameTest[True, MatchQ[a*b*c*4*d*e*f, 4*__]],
        ESameTest[False, MatchQ[a*b*c*4*d*e*f, 5*__]],
        ESameTest[False, MatchQ[a*b*c*4*d*e*f + 5, 4*__]],
        ESameTest[False, MatchQ[a*b*c*4*d*e*f + 5*k, 4*__]],
        ESameTest[False, MatchQ[a*b*c*4*d*e*f + 5*k, 4*__]],
        ESameTest[True, MatchQ[a*b*c*4*d*e*f + 5*k, 4*__ + 5*k]],
        ESameTest[False, MatchQ[a*b*c*4*d*e*f + 2 + 5*k, 4*__ + 5*k]],
        ESameTest[True, MatchQ[(a*b*c)^e, __^e]],
        ESameTest[False, MatchQ[(a*b*c)^e, __^f + __^e]],
        ESameTest[True, MatchQ[(a*b*c)^e + (a*b*c)^f, __^f + __^e]],
        ESameTest[True, MatchQ[(a*b*c)^e + (a + b + c)^f, __^f + __^e]],
        ESameTest[False, MatchQ[(a*b*c)^e + (a + b + c)^f, amatch__^f + amatch__^e]],
        ESameTest[True, MatchQ[(a*b*c)^e + (a*b*c)^f, amatch__^f + amatch__^e]],

         (*Warm up for combining like terms*)
        ESameTest[True, MatchQ[bar[1, foo[a, b]], bar[amatch_Integer, foo[cmatch__]]]],
        ESameTest[True, MatchQ[bar[1, foo[a, b, c]], bar[amatch_Integer, foo[cmatch__]]]],
        ESameTest[False, MatchQ[bar[1, foo[]], bar[amatch_Integer, foo[cmatch__]]]],
        ESameTest[2, bar[1, foo[a, b]] /. bar[amatch_Integer, foo[cmatch__]] -> 2],
        ESameTest[4, bar[1, foo[a, b]] + bar[5, foo[a, b]] /. bar[amatch_Integer, foo[cmatch__]] -> 2],
        ESameTest[6 * buzz[a, b], bar[1, foo[a, b]] + bar[5, foo[a, b]] /. bar[amatch_Integer, foo[cmatch__]] -> amatch*buzz[cmatch]],
        ESameTest[bar[3, foo[a, b]], bar[1, foo[a, b]] + bar[2, foo[a, b]] /. bar[amatch_Integer, foo[cmatch__]] + bar[bmatch_Integer, foo[cmatch__]] -> bar[amatch + bmatch, foo[cmatch]]],

         (*Test special case of Orderless sequence matches*)
        ESameTest[Null, fooPlus[Plus[addends__]] := Hold[addends]],
        ESameTest[Null, fooList[List[addends__]] := Hold[addends]],
        ESameTest[Null, fooBlank[_[addends__]] := Hold[addends]],
        ESameTest[Hold[a, b, c], fooList[List[a, b, c]]],
        ESameTest[Hold[a, b, c], fooBlank[Plus[a, b, c]]],

        ESameTest[True, MatchQ[foo[1, 2, 3], foo[__Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[__]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[__Real]]],
        ESameTest[True, MatchQ[foo[1.], foo[__Real]]],
        ESameTest[False, MatchQ[foo[], foo[__Real]]],
        ESameTest[True, MatchQ[foo[1.], foo[__]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, __Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, 2, __Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, 2, 3, ___Integer]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, 2, 3, 4, ___Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, ___Integer, 3]]],

        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, 2, 3, a__Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, a__Integer, 3]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, a__Integer, 5]]]
    ]
};

BlankNullSequence::usage = "`+"`"+`___`+"`"+` matches any sequence of zero or more expressions.

`+"`"+`___head`+"`"+` matches any sequence of zero or more expressions, each with a `+"`"+`Head`+"`"+` of `+"`"+`head`+"`"+`.";
Attributes[BlankNullSequence] = {Protected};
Tests`+"`"+`BlankNullSequence = {
    ESimpleExamples[
        ESameTest[True, MatchQ[a*b, ___]],
        ESameTest[True, MatchQ[a + b, a + b + ___]]
    ], EFurtherExamples[
        EComment["With head assertions:"],
        ESameTest[True, MatchQ[a + b + c, a + x___Symbol]],
        ESameTest[False, MatchQ[a + b + c, a + x___Plus]]
    ], ETests[
        ESameTest[True, MatchQ[a*b, ___]],
        ESameTest[False, MatchQ[a, a*___]],
        ESameTest[False, MatchQ[a, a + ___]],
        ESameTest[True, MatchQ[a + b, a + b + ___]],
        ESameTest[False, MatchQ[a*b, ___Integer]],
        ESameTest[False, MatchQ[a*b, ___Symbol]],
        ESameTest[True, MatchQ[a, ___Symbol]],
        ESameTest[False, MatchQ[a + b, ___Symbol]],
        ESameTest[True, MatchQ[a + b + c, a + x___Symbol]],
        ESameTest[False, MatchQ[a + b + c, a + x___Plus]],
        ESameTest[True, MatchQ[a + b, a + b + x___Symbol]],
        ESameTest[True, MatchQ[foo[1.], foo[___]]],
        ESameTest[True, MatchQ[foo[1.], foo[___Real]]],
        ESameTest[False, MatchQ[foo[1.], foo[___Integer]]],
        ESameTest[True, MatchQ[foo[], foo[___Integer]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, 2]]],
        ESameTest[False, MatchQ[foo[1, 2], foo[1, 2, 3]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, 2, 3, __Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, __Integer, 3]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, __Integer, 5]]],

         (*Make sure some similar cases still work with Patterns, not just Blanks*)
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, 2, 3, a___Integer]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, 2, 3, 4, a___Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, a___Integer, 3]]],
        ESameTest[False, MatchQ[foo[1, 2, 3], foo[1, a__Integer, 3, b__Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[1, a__Integer, 3, b___Integer]]],
        ESameTest[True, MatchQ[foo[1, 2, 3, 4], foo[1, a__Integer, 3, b___Integer, 4]]]
    ]
};

Except::usage = "`+"`"+`Except[pat]`+"`"+` matches all expressions except those that match `+"`"+`pat`+"`"+`.

`+"`"+`Except[pat1, pat2]`+"`"+` matches all expressions that match `+"`"+`pat2`+"`"+` but not `+"`"+`pat1`+"`"+`.";
Attributes[Except] = {Protected};
Tests`+"`"+`Except = {
    ESimpleExamples[
        ESameTest[{5, 2, x, y, 4}, Cases[{5, 2, 3.5, x, y, 4}, Except[_Real]]],
        ESameTest[{5, 2, x, y, 4}, Cases[{5, 2, a^b, x, y, 4}, Except[_Symbol^_Symbol]]],
        ESameTest[{a, b, 0, foo[1], foo[2], x, y}, {a, b, 0, 1, 2, x, y} /. Except[0, a_Integer] -> foo[a]]
    ]
};

PatternTest::usage = "`+"`"+`pat?test`+"`"+` matches when the expression matches `+"`"+`pat`+"`"+` and `+"`"+`test[MATCH]`+"`"+` evaluates to `+"`"+`True`+"`"+`.";
Attributes[PatternTest] = {HoldRest, Protected};
Tests`+"`"+`PatternTest = {
    ESimpleExamples[
        ESameTest[True, MatchQ[1, _?NumberQ]],
        ESameTest[False, MatchQ[a, _?NumberQ]],
        ESameTest[True, MatchQ[1, 1?NumberQ]],
        ESameTest[False, MatchQ[1, 1.5?NumberQ]],
        ESameTest[True, MatchQ[1.5, 1.5?NumberQ]],
        ESameTest[{5,2,4.5}, Cases[{5, 2, a^b, x, y, 4.5}, _?NumberQ]]
    ]
};

Condition::usage = "`+"`"+`pat /; cond`+"`"+` matches an expression if the expression matches `+"`"+`pat`+"`"+`, and if `+"`"+`cond`+"`"+` evaluates to `+"`"+`True`+"`"+` with all the named patterns substituted in.";
Attributes[Condition] = {HoldAll, Protected};
Tests`+"`"+`Condition = {
    ESimpleExamples[
        ESameTest[True, MatchQ[5, _ /; True]],
        ESameTest[False, MatchQ[5, _ /; False]],
        ESameTest[True, MatchQ[5, y_ /; True]],
        ESameTest[False, MatchQ[5, y_Real /; True]],
        ESameTest[True, MatchQ[5, y_Integer /; True]],
        ESameTest[False, MatchQ[5, y_ /; y == 0]],
        ESameTest[True, MatchQ[5, y_ /; y == 5]],
        ESameTest[{1,2,3,5}, {3, 5, 2, 1} //. {x___, y_, z_, k___} /; (Order[y, z] == -1) -> {x, z, y, k}],
        ESameTest[myfn[1], Replace[1,a_Integer:>myfn[a]/;a>0]],
        ESameTest[-1, Replace[-1,a_Integer:>myfn[a]/;a>0]],

        ESameTest[4, Replace[foo[2,3],foo[x_,y_]:>With[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[foo[3,3], Replace[foo[3,3],foo[x_,y_]:>With[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[foo[2,4], Replace[foo[2,4],foo[x_,y_]:>With[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[4, Replace[bar[2],bar[x_]:>With[{a=x},x^2/;a==2]]],
        ESameTest[bar[3], Replace[bar[3],bar[x_]:>With[{a=x},x^2/;a==2]]],

        ESameTest[4, Replace[foo[2,3],foo[x_,y_]:>Module[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[foo[3,3], Replace[foo[3,3],foo[x_,y_]:>Module[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[foo[2,4], Replace[foo[2,4],foo[x_,y_]:>Module[{a=x},x^2/;a==2]/;y==3]],
        ESameTest[4, Replace[bar[2],bar[x_]:>Module[{a=x},x^2/;a==2]]],
        ESameTest[bar[3], Replace[bar[3],bar[x_]:>Module[{a=x},x^2/;a==2]]],

        ESameTest[4, Replace[2,x_:>Condition[Condition[Condition[x^2,x==2],x==2],x==2]]],
        ESameTest[3, Replace[3,x_:>Condition[Condition[Condition[x^2,x==2],x==2],x==2]]]
    ]
};

Alternatives::usage = "`+"`"+`alt1 | alt2 | ...`+"`"+` matches an expression if it matches any pattern in the list of alternatives.";
Attributes[Alternatives] = {Protected};
Tests`+"`"+`Alternatives = {
    ESimpleExamples[
        ESameTest[Alternatives[c,d], c | d],
        ESameTest[False, MatchQ[b, c | d]],
        ESameTest[True, MatchQ[c, c | d]],
        ESameTest[True, MatchQ[d, c | d]],
        ESameTest[{c, 1, 2}, Cases[{a, b, c, 1, 2}, c | _Integer]],
        ESameTest[(1 + List)[1 + a, 1 + b, 1 + c, 1., 3], {a, b, c, 1., 2} /. amatch_Symbol | amatch_Integer -> amatch + 1],
        ESameTest[{b, c, d, e}, Cases[{a, b, c, d, e, f}, b | c | d | e]],
        ESameTest[False, MatchQ[{a, b}, {a_, k | a_}]]
    ], ETests[
        ESameTest[False, MatchQ[c || a || Not[b], Or[___, a_, ___, Not[And[___, a_, ___] | a_], ___]]]
    ]
};

FreeQ::usage = "`+"`"+`FreeQ[e, var]`+"`"+` returns True if `+"`"+`e`+"`"+` is free from any occurences of `+"`"+`var`+"`"+`.";
FreeQ[expr_, val_] := expr === (expr /. val -> Internal`+"`"+`DummyReplace);
Attributes[FreeQ] = {Protected};
Tests`+"`"+`FreeQ = {
    ETests[
        ESameTest[False, FreeQ[{0, 1, 2}, 1]],
        ESameTest[True, FreeQ[{0, 1, 2}, 3]],
        ESameTest[False, FreeQ[{0, 1, 2}, _Integer]],
        ESameTest[True, FreeQ[{0, 1, 2}, _Real]],
        ESameTest[True, FreeQ[x^2, _Real]],
        ESameTest[False, FreeQ[x^2, _Integer]],
        ESameTest[False, FreeQ[x^2, 2]],
        ESameTest[True, FreeQ[x^2, 3]],
        ESameTest[True, FreeQ[x^2, y]],
        ESameTest[True, FreeQ[x^2, y]],
        ESameTest[False, FreeQ[x^2, x^_Integer]],
        ESameTest[True, FreeQ[x^2, y^_Integer]],
        ESameTest[False, FreeQ[5*foo[x], foo]],
        ESameTest[True, FreeQ[5*foo[x], bar]]
    ]
};

ReplaceList::usage = "`+"`"+`ReplaceList[expr, rule]`+"`"+` returns all the possible replacements using `+"`"+`rule`+"`"+` on `+"`"+`expr`+"`"+`.";
Attributes[ReplaceList] = {Protected};
Tests`+"`"+`ReplaceList = {
    ESimpleExamples[
        ESameTest[{{a, b}, {b, a}}, ReplaceList[a + b, x_ + y_ -> {x, y}]],
        ESameTest[{{b, a}}, ReplaceList[foo[a + b, b], foo[j_ + k_, j_] -> {j, k}]],
        ESameTest[{{a, b}, {b, a}}, ReplaceList[foo[a + b], foo[x_ + y_] -> {x, y}]],
        ESameTest[{{a, b, c}, {b, a, c}}, ReplaceList[bar[foo[a + b] + c], bar[foo[x_ + y_] + z_] -> {x, y, z}]],
        ESameTest[{{c, d, a, b}, {c, d, b, a}, {d, c, a, b}, {d, c, b, a}}, ReplaceList[bar[foo[a + b] + c + d], bar[w_ + x_ + foo[y_ + z_]] -> {w, x, y, z}]],
        ESameTest[{}, ReplaceList[foo[a + b, c], foo[j_ + k_, j_] -> {j, k}]]
    ], ETests[
        ESameTest[{{{a},{b}},{{b},{a}}}, ReplaceList[a+b,x__+y__->{{x},{y}}]],
        ESameTest[{{{},{a,b}},{{a},{b}},{{a,b},{}}}, ReplaceList[foo[a,b],foo[a___,b___]->{{a},{b}}]],
        ESameTest[{}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a:Repeated[b_,{2}],rest___]->{{a},{rest}}]],
        ESameTest[{{c}}, ReplaceList[foo[a,b,c],foo[___,a_]->{a}]],
        ESameTest[{{a+b+c}}, ReplaceList[a+b+c,a_->{a}]],
        ESameTest[{{{},{a,b},{},{b,c}},{{},{a,b},{b},{c}},{{},{a,b},{b,c},{}},{{a},{b},{},{b,c}},{{a},{b},{b},{c}},{{a},{b},{b,c},{}},{{a,b},{},{},{b,c}},{{a,b},{},{b},{c}},{{a,b},{},{b,c},{}}}, ReplaceList[foo[a,b,foo[b,c]],foo[a___,b___,foo[c___,d___]]->{{a},{b},{c},{d}}]],
        ESameTest[{{a+b+c},{b+c},{a+c},{a+b},{c},{b},{a}}, ReplaceList[a+b+c,___+a_->{a}]],
        ESameTest[{{{},{a,b}},{{a},{b}},{{b},{a}},{{a,b},{}}}, ReplaceList[a+b,x___+y___->{{x},{y}}]],
        ESameTest[{{{a},{b+c}},{{b},{a+c}},{{c},{a+b}},{{a+b},{c}},{{a+c},{b}},{{b+c},{a}}}, ReplaceList[a+b+c,a_+b_->{{a},{b}}]],
        ESameTest[{{{a},{b,c}},{{b},{a,c}},{{c},{a,b}},{{a,b},{c}},{{a,c},{b}},{{b,c},{a}}}, ReplaceList[a+b+c,a__+b__->{{a},{b}}]],
        ESameTest[{{{a},{b,c}},{{b},{a,c}},{{c},{a,b}},{{a,b},{c}},{{a,c},{b}},{{b,c},{a}}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a__,b__]->{{a},{b}}]],
        ESameTest[{{{a,b},{c}},{{a,c},{b}},{{b,c},{a}}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a:Repeated[_,{2}],rest___]->{{a},{rest}}]],
        ESameTest[{{{a,b},{c}},{{a,c},{b}},{{b,c},{a}}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a:Repeated[_,{2}],rest___]->{{a},{rest}}]],
        ESameTest[{{{a,b},{c,d}},{{a,c},{b,d}},{{a,d},{b,c}},{{b,c},{a,d}},{{b,d},{a,c}},{{c,d},{a,b}}}, ReplaceList[ExpreduceOrderlessFn[a,b,c,d],ExpreduceOrderlessFn[a:Repeated[_,{2}],rest___]->{{a},{rest}}]],
        ESameTest[{{a+b+c},{b+c},{a+c},{a+b},{c},{b},{a}}, ReplaceList[a+b+c,___+a_->{a}]],
        ESameTest[{{{},{a,b}},{{a},{b}},{{b},{a}},{{a,b},{}}}, ReplaceList[ExpreduceOrderlessFn[a,b],ExpreduceOrderlessFn[a___,b___]->{{a},{b}}]],
        ESameTest[{{{a},{b},{c}},{{a},{c},{b}},{{b},{a},{c}},{{b},{c},{a}},{{c},{a},{b}},{{c},{b},{a}},{{a},{b+c},{}},{{b},{a+c},{}},{{c},{a+b},{}},{{a+b},{c},{}},{{a+c},{b},{}},{{b+c},{a},{}}}, ReplaceList[a+b+c,a_+b_+rest___->{{a},{b},{rest}}]],
        ESameTest[{{{},{a,b,c}},{{a},{b,c}},{{b},{a,c}},{{c},{a,b}},{{a,b},{c}},{{a,c},{b}},{{b,c},{a}},{{a,b,c},{}}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a___,b___]->{{a},{b}}]],
        ESameTest[{{{a,a},{b,b,c}},{{b,b},{a,a,c}}}, ReplaceList[ExpreduceOrderlessFn[a,a,b,b,c],ExpreduceOrderlessFn[a:Repeated[b_,{2}],rest___]->{{a},{rest}}]],
        ESameTest[{{a,b,c},{b,c},{a,c},{a,b},{c},{b},{a},{}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[a___,rest___]->{rest}]],
        ESameTest[{{{},{a,b},{},{c,d}},{{},{a,b},{c},{d}},{{},{a,b},{d},{c}},{{},{a,b},{c,d},{}},{{a},{b},{},{c,d}},{{a},{b},{c},{d}},{{a},{b},{d},{c}},{{a},{b},{c,d},{}},{{b},{a},{},{c,d}},{{b},{a},{c},{d}},{{b},{a},{d},{c}},{{b},{a},{c,d},{}},{{a,b},{},{},{c,d}},{{a,b},{},{c},{d}},{{a,b},{},{d},{c}},{{a,b},{},{c,d},{}}}, ReplaceList[ExpreduceOrderlessFn[a,b,ExpreduceOrderlessFn[c,d]],ExpreduceOrderlessFn[a___,b___,ExpreduceOrderlessFn[c___,d___]]->{{a},{b},{c},{d}}]],
        ESameTest[{}, ReplaceList[a+b+c,___+a_+___->{a}]],
        ESameTest[{{{2},{x,y}}}, ReplaceList[ExpreduceFlOrOiFn[2,x,y],ExpreduceFlOrOiFn[c_Integer,e__]->{{c},{e}}]],
        ESameTest[{{{2},{x,y}}}, ReplaceList[ExpreduceFlOrOiFn[2,x,y],ExpreduceFlOrOiFn[c_?NumberQ,e__]->{{c},{e}}]]
    ], EKnownFailures[
         (*Orderless has issues. Flat seems to work fine. regular ordered matching seems perfect.*)
        ESameTest[{{a},{b},{c}}, ReplaceList[ExpreduceOrderlessFn[a,b,c],ExpreduceOrderlessFn[___,a_]->{a}]]
    ]
};

Repeated::usage = "`+"`"+`Repeated[p_]`+"`"+` matches a sequence of expressions that match the pattern `+"`"+`p`+"`"+`.";
Attributes[Repeated] = {Protected};
Tests`+"`"+`Repeated = {
    ETests[
        ESameTest[True, MatchQ[foo[a, a], foo[Repeated[a]]]],
        ESameTest[False, MatchQ[foo[a, b], foo[Repeated[a]]]],
        ESameTest[True, MatchQ[foo[a], foo[Repeated[a]]]],
        ESameTest[False, MatchQ[foo[], foo[Repeated[a]]]],
        ESameTest[True, MatchQ[foo[1, 2, 3], foo[Repeated[_Integer]]]],
        ESameTest[False, MatchQ[foo[1, 2, a], foo[Repeated[_Integer]]]],
        ESameTest[2, foo[1, 2, 3] /. foo[a : (Repeated[_Integer])] -> 2],
        ESameTest[matches[1, 2, 3], foo[1, 2, 3] /. foo[a : (Repeated[_Integer])] -> matches[a]],
        ESameTest[foo[1, 2, 3], foo[1, 2, 3] /. foo[a : (Repeated[k_Integer])] -> matches[a]],
        ESameTest[matches[1, 1, 1], foo[1, 1, 1] /. foo[a : (Repeated[k_Integer])] -> matches[a]],
        ESameTest[True, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[a, Repeated[b, {3}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[a, Repeated[b, {a}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[a, Repeated[b, {4}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[a, Repeated[b, {2}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[a, Repeated[_Integer, {2}]]]],
        ESameTest[True, MatchQ[ExpreduceFlOrOiFn[a, 1, 2], ExpreduceFlOrOiFn[a, Repeated[_Integer, {2}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, 1, 2], ExpreduceFlOrOiFn[a, Repeated[k_Integer, {2}]]]],
        ESameTest[True, MatchQ[ExpreduceFlOrOiFn[a, 2, 2], ExpreduceFlOrOiFn[a, Repeated[k_Integer, {2}]]]],
        ESameTest[True, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[___, Repeated[_Integer, {0}]]]],
        ESameTest[False, MatchQ[ExpreduceFlOrOiFn[a, b, b, b], ExpreduceFlOrOiFn[___, Repeated[_Integer, {-1}]]]],
        ESameTest[x, foo[x, x] /. foo[Repeated[a_, {2}]] -> a]
    ]
};

Optional::usage = "`+"`"+`Optional[pat, default]`+"`"+` attempts to match `+"`"+`pat`+"`"+` but uses `+"`"+`default`+"`"+` if not present.";
Attributes[Optional] = {Protected};
Tests`+"`"+`Optional = {
    ETests[
        ESameTest[foo[a], foo[a]/.foo[a,b_.]->{a,b}],
        ESameTest[{a,b}, foo[a,b]/.foo[a,b_.]->{a,b}],
        ESameTest[{a,c}, foo[a]/.foo[a,b_:c]->{a,b}],
        ESameTest[{a,b}, foo[a,b]/.foo[a,b_:c]->{a,b}],
        ESameTest[{{a},{b}}, foo[a,b]/.foo[a___,b_.]->{{a},{b}}],
        ESameTest[{{a},{b}}, foo[a,b]/.foo[a___,b_:c]->{{a},{b}}],
        ESameTest[{{},{a},{b}}, foo[a,b]/.foo[a___,b_:c,d_:e]->{{a},{b},{d}}],
        ESameTest[{{x},{y},{z}}, foo[x]/.foo[a_,b_:y,c_:z]->{{a},{b},{c}}],
        ESameTest[foo[], foo[]/.foo[a_,b_:y,c_:z]->{{a},{b},{c}}],
        ESameTest[{{x},{i},{j}}, foo[x,i,j]/.foo[a_,b_:y,c_:z]->{{a},{b},{c}}],
        ESameTest[a, a /. foo[a, c_.] -> {{c}}],
         (*This match succeeds because Plus has both a Default and has*)
         (*OneIdentity*)
        ESameTest[{{0}}, a /. a + c_. -> {{c}}],
        ESameTest[False, MatchQ[a,foo[a,c_.]]],
        ESameTest[True, MatchQ[a,a+c_.]],
        ESameTest[False, MatchQ[foo[a],a+c_.]],
        ESameTest[{{0},{0}}, a/.a+c_.+d_.->{{c},{d}}],
        ESameTest[{{0},{0}}, Cos[x]/.(_+c_.+d_.)->{{c},{d}}],
        ESameTest[{{5},{a}}, 5*a/.Optional[c1_?NumberQ]*a_->{{c1},{a}}],
        ESameTest[{{1},{a}}, a/.Optional[c1_?NumberQ]*a_->{{c1},{a}}],
        ESameTest[False, MatchQ[foo[a,b],foo[c1__?NumberQ]]],
        ESameTest[True, MatchQ[foo[1,2],foo[c1__?NumberQ]]],
        ESameTest[False, MatchQ[foo[1,2],foo[Optional[c1__?NumberQ]]]],
        ESameTest[True, MatchQ[foo[1],foo[Optional[c1__?NumberQ]]]],

         (*Ensure that we attempt to fill optionals before using the*)
         (*default.*)
        ESameTest[{{{a},{b,c}},{{5},{a,b,c}}}, ReplaceList[{a,b,c},{a_:5,b__}->{{a},{b}}]],
        ESameTest[{{{a},{b},{c}},{{a},{6},{b,c}},{{5},{a},{b,c}},{{5},{6},{a,b,c}}}, ReplaceList[{a,b,c},{a_:5,b_:6,c___}->{{a},{b},{c}}]],
        ESameTest[True, MatchQ[-x,p_.]],
        ESameTest[True, MatchQ[-x*a,p_.*a]],
        ESameTest[True, MatchQ[__, Optional[1]*a_]],
        ESameTest[True, MatchQ[x^x, x^Optional[exp_]]]
    ], EKnownFailures[
        ESameTest[foo[a,b], foo[a,b]/.foo[a___,b_.,d_.]->{{a},{b},{d}}],
        ESameTest[True, MatchQ[x^x, (x^x)^Optional[exp_]]],
        (*Disabled because issue #79*)
        ESameTest[{{0},{5}}, a/.a+c_.+d_:5->{{c},{d}}]
    ]
};

Verbatim::usage = "`+"`"+`Verbatim[expr]`+"`"+` matches `+"`"+`expr`+"`"+` exactly, even if it has patterns.";
Attributes[Verbatim] = {Protected};
Tests`+"`"+`Verbatim = {
    ETests[
        ESameTest[{{a,b},{b,c},{c,d}}, ReplaceList[a+b+c+d,Verbatim[Plus][___,x_,y_,___]->{x,y}]],
        ESameTest[{}, ReplaceList[a+b+c+d,Verbatim[Times][___,x_,y_,___]->{x,y}]],
        ESameTest[{}, ReplaceList[a+b*c+d,Verbatim[Times][___,x_,y_,___]->{x,y}]],
        ESameTest[{{a,b},{b,c},{c,d}}, ReplaceList[foo[a,b,c,d],Verbatim[foo][___,x_,y_,___]->{x,y}]],
        ESameTest[{{a,b},{b,c},{c,d}}, ReplaceList[(a+b)[a,b,c,d],Verbatim[a+b][___,x_,y_,___]->{x,y}]],
        ESameTest[{}, ReplaceList[(a+b)[a,b,c,d],Verbatim[a+_][___,x_,y_,___]->{x,y}]]
    ]
};

HoldPattern::usage = "`+"`"+`HoldPattern[expr]`+"`"+` leaves `+"`"+`expr`+"`"+` unevaluated but is seen as just `+"`"+`expr`+"`"+` for the purposes of pattern matching.";
Attributes[HoldPattern] = {HoldAll, Protected};
Tests`+"`"+`HoldPattern = {
    ESimpleExamples[
        ESameTest[False, MatchQ[2x+2y,2_+2_]],
        ESameTest[True, MatchQ[2x+2y,HoldPattern[2_+2_]]],
        ESameTest[True, MatchQ[2x+2y,HoldPattern[2_+HoldPattern[2_]]]]
    ]
};
`)

func resourcesPatternMBytes() ([]byte, error) {
	return _resourcesPatternM, nil
}

func resourcesPatternM() (*asset, error) {
	bytes, err := resourcesPatternMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/pattern.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesPlotM = []byte(`ColorData[97, i_] := Switch[i,
  1, RGBColor[0.37, 0.5, 0.71],
  2, RGBColor[0.88, 0.6, 0.14],
  True, RGBColor[0.55, 0.7, 0.2]
];

ExpreduceFilterImaginaryPoints[unfilteredPoints_] :=
  Select[unfilteredPoints, (Im[#[[2]]] == 0) &];

Attributes[ExpreducePlotPoints] = {HoldAll};
ExpreduceGetPoints[fn_, range_List] :=
  Module[{nPoints, stepSize, replacedFn, unfilteredPoints},
   nPoints = 500;
   stepSize = (range[[3]] - range[[2]])/nPoints // N;
   replacedFn = fn /. range[[1]] -> varOfIteration;
   unfilteredPoints =
    Table[{varOfIteration, replacedFn // N}, {varOfIteration,
      range[[2]], range[[3]], stepSize}];
   ExpreduceFilterImaginaryPoints[unfilteredPoints]
   ];

Attributes[ExpreduceGetLine] = {HoldAll};
ExpreduceGetLine[fn_, range_List,
   color_] := {Directive[Opacity[1.], color, AbsoluteThickness[1.6]],
   Line[ExpreduceGetPoints[fn, range]]};

Attributes[ExpreduceGetLines] = {HoldAll};
ExpreduceGetLines[fn_, range_List] := Module[{fns},
   fns = If[Head[fn] === List, fn, {fn}];
   Table[ExpreduceGetLine[fns[[i]], range, ColorData[97, i]], {i,
     Length[fns]}]
   ];

Plot::usage = "`+"`"+`Plot[fn, {var, min, max}]`+"`"+` plots `+"`"+`fn`+"`"+` over the range specified.";
Attributes[Plot] = {HoldAll, Protected, ReadProtected}
Plot[fn_, range_List] :=
  Module[{lines, plotPoints, fullRange, displayOptions},
   lines = ExpreduceGetLines[fn, range];
   plotPoints = Join @@ Map[(#[[2]][[1]]) &, lines];
   fullRange = {MinMax[Join[plotPoints[[All, 1]], range[[2 ;; 3]]]],
     MinMax[plotPoints[[All, 2]]]};
   displayOptions = {DisplayFunction -> Identity,
     AspectRatio -> GoldenRatio^(-1), Axes -> {True, True},
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0},
     DisplayFunction :> Identity,
     Frame -> {{False, False}, {False, False}},
     FrameLabel -> {{None, None}, {None, None}},
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}},
     GridLines -> {None, None},
     GridLinesStyle -> Directive[GrayLevel[0.5, 0.4]],
     Method -> {"DefaultBoundaryStyle" -> Automatic,
       "DefaultMeshStyle" -> AbsolutePointSize[6],
       "ScalingFunctions" -> None}, PlotRange -> fullRange,
     PlotRangeClipping -> True,
     PlotRangePadding -> {{Scaled[0.02], Scaled[0.02]}, {Scaled[0.05],
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}};
   Graphics[lines, displayOptions]];
Tests`+"`"+`Plot = {
    ETests[
        ESameTest[Graphics, Plot[2*Cos[10 t + 1] - Sin[4 t - 1], {t, 0, 10}] // Head],
    ]
};
`)

func resourcesPlotMBytes() ([]byte, error) {
	return _resourcesPlotM, nil
}

func resourcesPlotM() (*asset, error) {
	bytes, err := resourcesPlotMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/plot.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesPowerM = []byte(`Power::usage = "`+"`"+`base^exp`+"`"+` finds `+"`"+`base`+"`"+` raised to the power of `+"`"+`exp`+"`"+`.";
(*Simplify nested exponents*)
Power[Power[a_,b_Integer],c_Integer] := a^(b*c);
Power[Power[a_,b_Real],c_Integer] := a^(b*c);
Power[Power[a_,b_Symbol],c_Integer] := a^(b*c);
Power[Power[a_,b_Complex*c_Symbol],d_Integer] := a^(b*c*d);
Power[Power[a_,b_Rational],c_] := a^(b*c);
Power[Infinity, 0] := Indeterminate;
Power[-Infinity, 0] := Indeterminate;
Power[_, 0] := 1;
Power[Infinity, 0.] := Indeterminate;
Power[-Infinity, 0.] := Indeterminate;
Power[_, 0.] := 1;
Power[Infinity, -1] := 0;
Power[Indeterminate, _] := Indeterminate;
Power[_, Indeterminate] := Indeterminate;
Power[1, a_] := 1;
Power[b_?NumberQ, Infinity] := Which[
    b < -1,
    ComplexInfinity,
    b === -1,
    Indeterminate,
    b < 1,
    0,
    b === 1,
    Indeterminate,
    b > 1,
    Infinity,
    True,
    UnexpectedInfinitePowerBase
];
Power[b_, Infinity] := Indeterminate;
Power[b_?NumberQ, -Infinity] := Which[
    b < -1,
    0,
    b === -1,
    Indeterminate,
    b <= 0,
    ComplexInfinity,
    b < 1,
    Infinity,
    b === 1,
    Indeterminate,
    b > 1,
    0,
    True,
    UnexpectedInfinitePowerBase
];
(* Example: 3^(4/3) -> 3*3^(1/3) *)
Power[b_Integer, Rational[n_, d_]] := b^((n-Mod[n,d])/d) * b^(Mod[n,d]/d) /; Or[n > d, -n > d];
Power[b_, -Infinity] := Indeterminate;
(*Power definitions*)
(*Distribute any kind of power for numeric values in Times:*)
((first:(_Integer | _Real | _Rational)?((#!=-1)&)) * inner__)^pow_ := first^pow * Times[inner]^pow;
(*Otherwise, only distribute integer powers*)
(first_ * inner___)^pow_Integer := first^pow * Times[inner]^pow;
(*Rational simplifications*)
(*These take up time. Possibly convert to Upvalues.*)
Power[Rational[a_,b_], -1] := Rational[b,a];
Power[Rational[a_,b_], e_Integer?Positive] := Rational[a^e,b^e];
Power[-1, -1/2] := -I;
Power[-1, 1/2] := I;
Power[Rational[a_?Positive,b_?Positive], 1/2] := Power[a, 1/2] * Power[b, -1/2];
Power[Power[x_, y_Rational], -1] := Power[x, -y];
(*We may want to deprecate this in favor of the general definition.*)
Complex[0,1]^e_Integer := Switch[Mod[e, 4],
  0, 1,
  1, I,
  2, -1,
  3, -I];
Complex[re_,im_]^n_Integer := If[n===-1,
  Complex[re/(re^2+im^2), -(im/(re^2+im^2))],
  Module[{theta = ArcTan[re,im]}, Sqrt[re^2+im^2]^n*Complex[Cos[n*theta],Sin[n*theta]]]];
Complex[re_,im_]^n_Real := Module[{theta = ArcTan[re,im]}, Sqrt[re^2+im^2]^n*Complex[Cos[n*theta],Sin[n*theta]]];
Power[ComplexInfinity+_, -1] := 0;
_^ComplexInfinity := Indeterminate;
(*TODO(corywalker): Remove this as there should be a more general version.*)
E^pow_Real := N[E]^pow;
E^(Log[a_]+rest___) := a * E^rest;
E^Log[a_] := a;
E^(Complex[0, n_Integer]*Pi) := -(Mod[n, 2]*2 - 1);
a_Real ^ Complex[b_Real, c_Real] := Module[{inner},
  inner = b Arg[a]+1/2 c Log[a^2];
  (a^2)^(b/2) E^(-c Arg[a]) * Complex[Cos[inner], Sin[inner]]
];
Attributes[Power] = {Listable, NumericFunction, OneIdentity, Protected};
Tests`+"`"+`Power = {
    ESimpleExamples[
        EComment["Exponents of integers are computed exactly:"],
        ESameTest[-1/125, (-5)^-3],
        EComment["Floating point exponents are handled with floating point precision:"],
        EStringTest["1.99506e+3010", ".5^-10000."],
        EComment["Automatically apply some basic simplification rules:"],
        ESameTest[m^4., (m^2.)^2]
    ], EFurtherExamples[
        EComment["Expreduce handles problematic exponents accordingly:"],
        EStringTest["Indeterminate", "0^0"],
        ESameTest[ComplexInfinity, 0^(-1)]
    ], ETests[
        (*Test raising expressions to the first power*)
        ESameTest[1 + x, (x+1)^1],
        EStringTest["0", "0^1"],
        EStringTest["0.", "0.^1"],
        ESameTest[-5, -5^1],
        ESameTest[-5.5, -5.5^1],
        ESameTest[1 + x, (x+1)^1.],
        EStringTest["0", "0^1."],
        EStringTest["0.", "0.^1."],
        ESameTest[-5, (-5)^1.],
        ESameTest[-5.5, -5.5^1.],

        (*Test raising expressions to the zero power*)
        EStringTest["1", "(x+1)^0"],
        EStringTest["Indeterminate", "0^0"],
        EStringTest["Indeterminate", "0.^0"],
        ESameTest[-1, -5^0],
        EStringTest["1", "(-5)^0"],
        EStringTest["1", "(-5.5)^0"],
        EStringTest["1", "(x+1)^0."],
        EStringTest["Indeterminate", "0^0."],
        EStringTest["Indeterminate", "0.^0."],
        ESameTest[-1, -5^0.],
        EStringTest["1", "(-5.5)^0."],
        ESameTest[-1, -5^0],
        EStringTest["1", "99^0"],

        EStringTest["125", "5^3"],
        ESameTest[1/125, 5^-3],
        ESameTest[-125, (-5)^3],
        ESameTest[-1/125, (-5)^-3],

        EStringTest["2.97538e+1589", "39^999."],
        EStringTest["3.36092e-1590", "39^-999."],
        EStringTest["1.99506e+3010", ".5^-10000."],
        EStringTest["1.99506e+3010", ".5^-10000"],

        EStringTest["1", "1^1"],
        EStringTest["1", "1^2"],
        EStringTest["1", "1^0"],
        EStringTest["1", "1^-1"],
        EStringTest["1", "1^-2"],
        EStringTest["1", "1^99999992"],
        EStringTest["1.", "1^2."],
        EStringTest["1.", "1^99999992."],
        EStringTest["1.", "1.^30"],
        EStringTest["4.", "(1.*2*1.)^2"],
        ESameTest[-1, (-1)^1],
        EStringTest["1", "(-1)^2"],
        EStringTest["1", "(-1)^0"],
        EStringTest["1", "(-1)^0"],
        ESameTest[-1, (-1)^-1],
        EStringTest["1", "(-1)^-2"],
        EStringTest["1", "(-1)^99999992"],
        EStringTest["1.", "(-1.)^30"],
        EStringTest["4.", "(1.*2*-1.)^2"],
        ESameTest[-0.5, (1.*2*-1.)^(-1)],

        ESameTest[Rational, Power[2, -1] // Head],
        ESameTest[Integer, Power[1, -1] // Head],
        ESameTest[Integer, Power[2, 2] // Head],
        ESameTest[Rational, Power[-2, -1] // Head],
        ESameTest[Rational, Power[2, -2] // Head],

        (*Exponent simplifications*)
        ESameTest[m^4, m^2*m^2],
        ESameTest[m^4, (m^2)^2],
        ESameTest[(m^2)^2., (m^2)^2.],
        ESameTest[(m^2.)^2., (m^2.)^2.],
        ESameTest[m^4., (m^2.)^2],

        ESameTest[ComplexInfinity, 0^(-1)],

        ESameTest[{1}, ReplaceAll[a, a^p_. -> {p}]],

        ESameTest[0, 2^(-Infinity)],
        ESameTest[0, (-2)^(-Infinity)],
        ESameTest[Indeterminate, (-1)^(-Infinity)],
        ESameTest[Indeterminate, (1)^(-Infinity)],
        ESameTest[Indeterminate, (d)^(-Infinity)],
        ESameTest[Infinity, 2^(Infinity)],
        ESameTest[ComplexInfinity, (-2)^(Infinity)],
        ESameTest[Indeterminate, (-1)^(Infinity)],
        ESameTest[Indeterminate, (1)^(Infinity)],
        ESameTest[Indeterminate, (d)^(Infinity)],

        (* Test nth-root algorithm. *)
        ESameTest[2, 16^(1/4)],
        ESameTest[2., 16^(1/4.)],
        ESameTest[True, Head[101^(1/2)]=!=Integer],
        ESameTest[True, Head[99^(1/2)]=!=Integer],
        ESameTest[0, 0^(1/2)],
        ESameTest[8, 2^3],
        ESameTest[0, 0^(1/3)],
        ESameTest[0, 0^(1/4)],
        ESameTest[2, 8^(1/3)],
        ESameTest[Power, 7^(1/3)//Head],
        ESameTest[Power, 9^(1/3)//Head],
        ESameTest[1/2, 16^(-1/4)],
        ESameTest[ComplexInfinity, 0^(-1/3)],
        ESameTest[ComplexInfinity, 0^(-1/2)],
        ESameTest[1/3, 27^(-1/3)],
        ESameTest[Power, 7^(-1/3)//Head],
        ESameTest[Power, 9^(-1/3)//Head],
        ESameTest[27, 9^(3/2)],
        ESameTest[1/27, 9^(-3/2)],

        (* Test simplifying radicals *)
        ESameTest[4 2^(1/3), (128)^(1/3)],
        ESameTest[4 (-2)^(1/3), (-128)^(1/3)],
        ESameTest[15 7^(2/3) 57^(1/3), 9426375^(1/3)],
        ESameTest[15 7^(2/3) 57^(1/3), 9426375^(1/3)],
        ESameTest[3 3^(1/3), (3^4)^(1/3)],
        ESameTest[3 3^(1/3), (3)^(4/3)],
        ESameTest[15 7^(2/3) 57^(1/3), (3^(4/3)*5^(3/3)*7^(2/3)*19^(1/3))],
        ESameTest[15 7^(2/3) 57^(1/3), 5*3^(4/3)*7^(2/3)*19^(1/3)],
        ESameTest[3 3^(1/3), 3^(4/3)],
        ESameTest[3 3^(1/3), 3^(4/3)],
        ESameTest[a^(4/3), a^(4/3)],
        ESameTest[-(-1)^(1/3), (-1)^(4/3)],
        ESameTest[(-1)^(2/3), (-1)^(-4/3)],
        ESameTest[-(I/2), (-4)^(-1/2)],
        ESameTest[Indeterminate, (-1)^(-1/0)],
        ESameTest[1., (-1.)^0.5 // Im],
    ], EKnownFailures[
        ESameTest[(3+I Sqrt[29]) E^(-((2 I \[Pi])/3)), ((3 + I*Sqrt[29])^3)^(1/3)],
        ESameTest[{{-5,1/5^(1/3)},{-4,1/2^(2/3)},{-3,1/3^(1/3)},{-2,1/2^(1/3)},{-1,1},{0,ComplexInfinity},{1,-(-1)^(2/3)},{2,-((-1)^(2/3)/2^(1/3))},{3,-((-1)^(2/3)/3^(1/3))},{4,-(-(1/2))^(2/3)},{5,-((-1)^(2/3)/5^(1/3))}}, Table[{n, (-n)^(-1/3)}, {n, -5, 5}] // Quiet],
    ]
};

Log::usage = "`+"`"+`Log[e]`+"`"+` finds the natural logarithm of `+"`"+`e`+"`"+`.";
Log[n_Integer?Negative] := I*Pi + Log[-n];
Log[ComplexInfinity] := Infinity;
Log[Infinity] := Infinity;
Log[-ComplexInfinity] := Infinity;
Log[-Infinity] := Infinity;
Log[0] := -Infinity;
Log[1] := 0;
Log[E] := 1;
Log[E^p_?NumberQ] := p;
Log[Rational[1,b_]] := -Log[a];
Attributes[Log] = {Listable,NumericFunction,Protected};
Tests`+"`"+`Log = {
    ESimpleExamples[
        ESameTest[1, Log[E]],
        ESameTest[-2, Log[E^(-2)]],
        ESameTest[Log[2], Log[2]]
    ]
};

Sqrt::usage = "`+"`"+`Sqrt[e]`+"`"+` finds the square root of `+"`"+`e`+"`"+`.";
(*TODO: automatically simplify perfect squares*)
Attributes[Sqrt] = {Listable, NumericFunction, Protected};
Sqrt[a_Integer?Negative] := I*Sqrt[-a];
Sqrt[-a_?NumberQ] := I*Sqrt[a];
Sqrt[a_Integer*b_Plus] := Sqrt[Abs[a]]*Sqrt[(a/Abs[a])*b] /; a != 0;
Sqrt[a_Real?Positive] := a^.5;
Sqrt[x_] := Which[
    (*Normally we would define these directly, but right now "x_" is
    considered more specific than 0 or 1. *)
    x===0, 0,
    x===1, 1,
    True,  x^(1/2)
];
Tests`+"`"+`Sqrt = {
    ESimpleExamples[
        ESameTest[Sqrt[3], Sqrt[3]],
        ESameTest[I, Sqrt[-1]],
        ESameTest[I * Sqrt[3], Sqrt[-3]],
        ESameTest[1, Sqrt[1]],
        ESameTest[0, Sqrt[0]]
    ], ETests[
        ESameTest[Sqrt[2] Sqrt[-2-x^y], (-2)(x^y+2)//Sqrt],
    ]
};

I::usage = "`+"`"+`I`+"`"+` is the imaginary number representing `+"`"+`Sqrt[-1]`+"`"+`.";
I := Complex[0, 1];
Attributes[I] = {Locked, Protected, ReadProtected};
Tests`+"`"+`I = {
    ESimpleExamples[
        ESameTest[-1, I^2],
        ESameTest[1, I^4]
    ]
};

possibleExponents[n_Integer, m_Integer] :=
 Flatten[Permutations /@ ((PadRight[#, m]) & /@
     IntegerPartitions[n, m]), 1];
genVars[addends_List, exponents_List] := Times@@(addends ^ exponents);
genExpand[addends_List, exponents_List] :=
 Plus@@Table[(Multinomial @@ exponents[[ExpandUnique`+"`"+`i]])*
   genVars[addends, exponents[[ExpandUnique`+"`"+`i]]], {ExpandUnique`+"`"+`i, 1,
   Length[exponents]}];
expandRules := {
  s_Plus^n_Integer?Positive :>
    genExpand[List @@ s, possibleExponents[n, Length[s]]],
  c_*s_Plus :> ((c*#) &) /@ s
};
Expand::usage = "`+"`"+`Expand[expr]`+"`"+` attempts to expand `+"`"+`expr`+"`"+`.";
Expand[a_] := a //. expandRules;
Expand[a_, x_] := (Print["Expand does not support second argument."];Expand[a]);
Attributes[Expand] = {Protected};
Tests`+"`"+`Expand = {
    ESimpleExamples[
        ESameTest[a^3 + 3 a^2 * b + 3 a b^2 + b^3 + 3 a^2 * c + 6 a b c + 3 b^2 * c + 3 a c^2 + 3 b c^2 + c^3, Expand[(a + b + c)^3]],
        ESameTest[a c + b c + a d + b d + a e + b e, (a + b) * (c + d + e) // Expand],
        ESameTest[a d^2 + b d^2 + c d^2 + 2 a d e + 2 b d e + 2 c d e + a e^2 + b e^2 + c e^2, (a + b + c)*(d + e)^2 // Expand],
        ESameTest[a^(2 b) + 2 a^b * c^d + c^(2 d), Expand[(a^b + c^d)^2]],
        ESameTest[a/d + b/d + c/d, Expand[(a + b + c)/d]],
        ESameTest[1/d + (2 a)/d + a^2/d + b/d + c/d, Expand[((a + 1)^2 + b + c)/d]],
        ESameTest[2 + 2 a, 2*(a + 1) // Expand]
    ], ETests[
        ESameTest[Null, ((60 * c * a^2 * b^2) + (30 * c * a^2 * b^2) + (30 * c * a^2 * b^2) + a^5 + b^5 + c^5 + (5 * a * b^4) + (5 * a * c^4) + (5 * b * a^4) + (5 * b * c^4) + (5 * c * a^4) + (5 * c * b^4) + (10 * a^2 * b^3) + (10 * a^2 * c^3) + (10 * a^3 * b^2) + (10 * a^3 * c^2) + (10 * b^2 * c^3) + (10 * b^3 * c^2) + (20 * a * b * c^3) + (20 * a * c * b^3) + (20 * b * c * a^3));],
        ESameTest[1/3, ((1+I Sqrt[3]) (1/(2 2^(1/3))-(I Sqrt[3])/(2 2^(1/3))))/(3 2^(2/3))//Expand],
    ]
};

ExpandAll::usage = "`+"`"+`ExpandAll[expr]`+"`"+` attempts to expand `+"`"+`expr`+"`"+` at all levels.";
ExpandAll[a_] := Map[Expand, a, {0, Infinity}];
Attributes[ExpandAll] = {Protected};
Tests`+"`"+`ExpandAll = {
    ESimpleExamples[
        ESameTest[Log[-1+x^2], Log[(x+1)(x-1)]//ExpandAll],
    ]
};

PolynomialQ::usage =  "`+"`"+`PolynomialQ[e, var]`+"`"+` returns True if `+"`"+`e`+"`"+` is a polynomial in `+"`"+`var`+"`"+`.";
innerPolynomialQ[p_Plus, v_] :=
  AllTrue[List @@ p, (PolynomialQ[#, v]) &];
innerPolynomialQ[p_.*v_^Optional[exp_Integer], v_] :=
  If[FreeQ[p, v] && Positive[exp], True, False];
innerPolynomialQ[p_, v_] := If[FreeQ[p, v], True, False];
PolynomialQ[p_, v_] := innerPolynomialQ[p//Expand, v];
(*Seemingly undocumented version with no variable specification:*)
PolynomialQ[p_] := PolynomialQ[p, Variables[p]];
Attributes[PolynomialQ] = {Protected};
Tests`+"`"+`PolynomialQ = {
    ETests[
        ESameTest[True, PolynomialQ[2x^2-3x+2, x]],
        ESameTest[True, PolynomialQ[2x^2, x]],
        ESameTest[False, PolynomialQ[2x^2.5, x]],
        ESameTest[False, PolynomialQ[2x^-2, x]],
        ESameTest[True, PolynomialQ[2x^0, x]],
        ESameTest[False, PolynomialQ[2x^y, x]],
        ESameTest[True, PolynomialQ[-3x, x]],
        ESameTest[True, PolynomialQ[2, x]],
        ESameTest[True, PolynomialQ[2y^2, x]],
        ESameTest[True, PolynomialQ[-3y, x]],
        ESameTest[False, PolynomialQ[2x^2-3x+2+Cos[x], x]],
        ESameTest[False, PolynomialQ[Cos[x], x]],
        ESameTest[False, PolynomialQ[2x^2-3x+Cos[x], x]],
        ESameTest[False, PolynomialQ[2x^2-x*Cos[x], x]],
        ESameTest[True, PolynomialQ[2x^2-x*Cos[y], x]],
        ESameTest[True, PolynomialQ[2.5x^2-3x+2.5, 2.5]],
        ESameTest[True, PolynomialQ[2x^2-3x+2, "hello"]],
        ESameTest[True, PolynomialQ[2x^2-3x+2, y]],
        ESameTest[True, PolynomialQ[x, y]],
        ESameTest[True, PolynomialQ[y, y]],
        ESameTest[True, PolynomialQ[2*x, y]],
        ESameTest[False, PolynomialQ[2*x^Sin[y], x]],
        ESameTest[True, PolynomialQ[Sin[y]*x^2, x]],
        ESameTest[False, PolynomialQ[Sin[y]*x^2.5, x]],
        ESameTest[False, PolynomialQ[Sin[y]*x^y, x]],
        ESameTest[True, PolynomialQ[2*y, y]],
        ESameTest[True, PolynomialQ[y*x, y]],
        ESameTest[True, PolynomialQ[y*x, z]],
        ESameTest[True, PolynomialQ[y*Sin[x], z]],
        ESameTest[False, PolynomialQ[y^x, y]],
        ESameTest[False, PolynomialQ[x^y, y]],
        ESameTest[True, PolynomialQ[x^y, z]],
        ESameTest[True, PolynomialQ[2.5*x^2, 2.5]],
        ESameTest[True, PolynomialQ[2.5*x, 2.5]],
        ESameTest[False, PolynomialQ[2*x^2, 2]],
        ESameTest[True, PolynomialQ[2*x, 2]],
        ESameTest[True, PolynomialQ[x, 2]],
        ESameTest[True, PolynomialQ[Cos[x*y], Cos[x*y]]],
        ESameTest[True, PolynomialQ[x^2,2.]],
        ESameTest[False, PolynomialQ[x^a,a]],
        ESameTest[False, PolynomialQ[x^n,x]],
        ESameTest[True, PolynomialQ[-x*Cos[y],x]],
        ESameTest[True, PolynomialQ[x^y, 1]],
        ESameTest[True, PolynomialQ[(-280*c^4*d^2*x^2 + -315*c^6*d^2*x^4 + 9*c^2*(63*d^2 + 90*c^2*d^2*x^2 + 35*c^4*d^2*x^4))//Expand,x]],
        ESameTest[True, PolynomialQ[(-280*c^4*d^2*x^2 + -315*c^6*d^2*x^4 + 9*c^2*(63*d^2 + 90*c^2*d^2*x^2 + 35*c^4*d^2*x^4)),x]],
    ], EKnownFailures[
        ESameTest[True, PolynomialQ[2*x^2-3x+2, 2]],
        ESameTest[True, PolynomialQ[2*x^2-3x, 2]],
        ESameTest[False, PolynomialQ[x/y]]
    ]
};

Exponent::usage = "`+"`"+`Exponent[p, var]`+"`"+` returns the degree of `+"`"+`p`+"`"+` with respect to the variable `+"`"+`var`+"`"+`.";
Exponent[expr_/p_Plus, var_, head_] := Exponent[expr, var, head];
Exponent[expr_, var_, head_] := If[expr === 0, head[],
  Module[{e = expr, v = var, h = head, theCases, toCheck},
   toCheck = expr // Expand;
   toCheck = If[Head[toCheck] === Plus, toCheck, {toCheck}];
   theCases =
    Cases[toCheck, p_.*v^Optional[exp_] -> exp] // DeleteDuplicates;
   If[Length[theCases] =!= Length[toCheck], PrependTo[theCases, 0]];
   h @@ theCases
   ]];
Exponent[expr_, var_] := Exponent[expr, var, Max];
Attributes[Exponent] = {Listable, Protected};
Tests`+"`"+`Exponent = {
    ESimpleExamples[
        EComment["Find the degree of a polynomial:"],
        ESameTest[5, Exponent[3 + x^3 + k*x^5, x]]
    ], EFurtherExamples[
        EComment["Find the degree of a polynomial:"],
        ESameTest[{0,3,5}, Exponent[3 + x^3 + k*x^5, x, List]]
    ], ETests[
        (*Sorting of the input addition expression is off here, so we sort*)
        (*the result so it does match up.*)
        ESameTest[{0,3,5,x^x}, Exponent[3 + "hello" + x^3 + a*x^5 + x^x^x, x, List]//Sort],
        ESameTest[{0}, Exponent[1 + x^x^x, x^x, List]],
        ESameTest[{0}, Exponent[2 + a, x, List]],
        ESameTest[{0}, Exponent[a, x, List]],
        ESameTest[{2}, Exponent[x^2, x, List]],
        ESameTest[{1}, Exponent[x^2 - x*(a + x), x, List]],
        ESameTest[{0,1}, Exponent[(1 + x)/(3 + x), x, List]],
        ESameTest[{0,2}, Exponent[(1 + x^2)/(3 + x), x, List]],
        ESameTest[{0,1}, Exponent[(1 + x)/(3 + x^3), x, List]],
        ESameTest[{0}, Exponent[(3 + x^3)^(-1), x, List]],
        ESameTest[{-3}, Exponent[x^(-3), x, List]],
        ESameTest[{-3}, Exponent[a/x^3, x, List]],
        ESameTest[{-2}, Exponent[x^(-2), x, List]],
        ESameTest[{1}, Exponent[(a*x)/(3 + x^3), x, List]],
        ESameTest[{0,1}, Exponent[1 + b*x + x^2 - (x*(1 + a*x))/a, x, List]],
        ESameTest[{0,1}, Exponent[1 + x + x^2 - (x*(1 + 2*x))/2, x, List]],
        ESameTest[{}, Exponent[0, x, List]],
        ESameTest[{}, Exponent[0, x+2, List]],
        ESameTest[{}, Exponent[0, 0, List]]
    ], EKnownFailures[
        ESameTest[{0,1}, Exponent[1 + x^x^x, x^x^x, List]]
    ]
};

ExpreduceSingleCoefficient[inP_, inTerm_] :=
  Module[{p = inP, term = inTerm, pat},
   (*If[MatchQ[p,term],Return[1]];*)
   pat = If[term === 1, Print["Warning: term of 1 used"]; a_?NumberQ, Optional[a_]*term];
   (*pat=Optional[a_]*term;*)
   If[MatchQ[p, pat],
    (p) /. pat -> a, 0]
   ];
ExpreduceNonProp[inP_, inTerm_] :=
  Module[{p = inP, term = inTerm, toMatch, pat},
   toMatch = p // Expand;
   pat = Except[Optional[a_]*term^n_.];
   If[Head[toMatch] === Plus,
    Plus@@Cases[toMatch, pat],
    If[MatchQ[toMatch, pat], toMatch, 0]]
   ];
Coefficient::usage =  "`+"`"+`Coefficient[p, form]`+"`"+` returns the coefficient of form `+"`"+`form`+"`"+` in polynomial `+"`"+`p`+"`"+`.";
Coefficient[p_, var_, exp_] :=
    If[exp === 0,
        ExpreduceNonProp[p, var],
        Coefficient[p, var^exp]
    ];
Coefficient[inP_, inTerm_] :=
  Module[{p = inP, term = inTerm, toMatch},
   toMatch = p // Expand;
   If[Head[toMatch] === Plus,
    Map[ExpreduceSingleCoefficient[#, term] &, toMatch],
    ExpreduceSingleCoefficient[toMatch, term]]
   ];
Attributes[Coefficient] = {Listable, Protected};
Tests`+"`"+`Coefficient = {
    ESimpleExamples[
        ESameTest[3, Coefficient[(a + b)^3, a*b^2]]
    ], ETests[
        ESameTest[j, Coefficient[c + j*a + k*b, a]],
        ESameTest[a, Coefficient[c + k*x + a*x^3, x, 3]],
        ESameTest[24, Coefficient[2*b*(2*a + 3*b)*(1 + 2*a + 3*b), a*b^2]],
        ESameTest[29, Coefficient[(2 + x)^2 + (5 + x)^2, x, 0]],
        ESameTest[1, Coefficient[a + x, x]],
        ESameTest[4, Coefficient[2*b*(2*a + 3*b)*(1 + 2*a + 3*b), a*b]],
        ESameTest[1, Coefficient[x^2, x^2]],
        ESameTest[-a, Coefficient[x^2 - x*(a + x), x]],
        ESameTest[-(1/a)+b, Coefficient[1 + b*x + x^2 - (x*(1 + a*x))/a, x]],
        ESameTest[1/2, Coefficient[1 + x + x^2 - (x*(1 + 2*x))/2, x]],
        ESameTest[a, Coefficient[a,x,0]],
        ESameTest[a b, Coefficient[a*b,x,0]],
        ESameTest[a b+c^d, Coefficient[a*b+c^d,x,0]],
        ESameTest[a b+c^d, Coefficient[a*b+c^d+5x,x,0]],
        ESameTest[0, Coefficient[(a*b+c^d)*x^2+5x,x,0]]
    ]
};

CoefficientList::usage =  "`+"`"+`CoefficientList[p, var]`+"`"+` returns the list of coefficients associated with variable `+"`"+`var`+"`"+`.";
CoefficientList[p_, var_] :=
    Table[Coefficient[p,var,i],{i,0,Exponent[p,var]}];
Attributes[CoefficientList] = {Protected};
Tests`+"`"+`CoefficientList = {
    ESimpleExamples[
        ESameTest[{b,3,5}, CoefficientList[b+3x+5x^2,x]],
        ESameTest[{0,0,5}, CoefficientList[5x^2,x]],
        ESameTest[{-(a/b),1/b}, CoefficientList[(-a+x)/b,x]]
    ], ETests[
        ESameTest[{b,3,0,5}, CoefficientList[b+3x+5x^3,x]],
        ESameTest[{b+3 x+5 x^3}, CoefficientList[b+3x+5x^3,y]],
        ESameTest[{3 x+5 x^3,1}, CoefficientList[b+3x+5x^3,b]]
    ]
};

PolynomialQuotientRemainder::usage =  "`+"`"+`PolynomialQuotientRemainder[poly_, div_, var_]`+"`"+` returns the quotient and remainder of `+"`"+`poly`+"`"+` divided by `+"`"+`div`+"`"+` treating `+"`"+`var`+"`"+` as the polynomial variable.";
ExpreduceLeadingCoeff[p_, x_] := Coefficient[p, x^Exponent[p, x]];
PolynomialQuotientRemainder[inp_, inq_, v_] :=
  Module[{a = inp, b = inq, x = v, r, d, c, i, s, q, rExp},
   (*I should think carefully about when I use = vs := to avoid unwanted evaluation*)
   q = 0;
   r = a;
   d = Exponent[b, x];
   pow = x^d;
   (* This should happen any time that inq is free of v, or if inq === 1. *)
   If[pow === 1, Return[{a/b//Distribute, 0}]];
   c = Coefficient[b, pow];
   i = 1;
   While[rExp = Exponent[r, x]; rExp >= d && i < 20,
    (*Looks like we get the coefficient and the exponent of the leading term here. Perhaps we can just grab the leading term and get both at once. And maybe we can exploit the canonical ordering*)
    (*But all of this seems wrong. I think the slowness resides in the expreduce interpreter.*)
    (*TODO tomorrow: find out what 'power' function takes up the most time and optimize it by making kernel changes*)
    s = (Coefficient[r, x^rExp]/c)*x^(rExp - d);
    q = q + s;
    r = r - s*b;
    i = i + 1;
    ];
   {q, r} // Expand
   ];
Attributes[PolynomialQuotientRemainder] = {Protected};
PolynomialQuotient::usage =  "`+"`"+`PolynomialQuotient[poly_, div_, var_]`+"`"+` returns the quotient of `+"`"+`poly`+"`"+` divided by `+"`"+`div`+"`"+` treating `+"`"+`var`+"`"+` as the polynomial variable.";
PolynomialQuotient[inp_, inq_, v_] :=
  PolynomialQuotientRemainder[inp, inq, v][[1]];
Attributes[PolynomialQuotient] = {Protected};
PolynomialRemainder::usage =  "`+"`"+`PolynomialRemainder[poly_, div_, var_]`+"`"+` returns the remainder of `+"`"+`poly`+"`"+` divided by `+"`"+`div`+"`"+` treating `+"`"+`var`+"`"+` as the polynomial variable.";
PolynomialRemainder[inp_, inq_, v_] :=
  PolynomialQuotientRemainder[inp, inq, v][[2]];
Attributes[PolynomialRemainder] = {Protected};
Tests`+"`"+`PolynomialQuotientRemainder = {
    ESimpleExamples[
        ESameTest[{x^2/2,2}, PolynomialQuotientRemainder[2 + x^2 + x^3, 2 + 2*x, x]],
        ESameTest[{x^2-x y+y^2,-y^3}, PolynomialQuotientRemainder[x^3, x + y, x]],
        ESameTest[{x/a,1-x/a}, PolynomialQuotientRemainder[1 + x^3, 1 + a*x^2, x]]
    ], ETests[
        ESameTest[{b+a/x,0}, PolynomialQuotientRemainder[a+b*x,x,a]],
        ESameTest[{a+b x,0}, PolynomialQuotientRemainder[a+b*x,1,a]],
        ESameTest[{a/c+(b x)/c,0}, PolynomialQuotientRemainder[a+b*x,c,a]]
    ]
};
Tests`+"`"+`PolynomialQuotient = {
    ESimpleExamples[
        ESameTest[x^2/2, PolynomialQuotient[2 + x^2 + x^3, 2 + 2*x, x]],
        ESameTest[x^2-x y+y^2, PolynomialQuotient[x^3, x + y, x]],
        ESameTest[x/a, PolynomialQuotient[1 + x^3, 1 + a*x^2, x]]
    ]
};
Tests`+"`"+`PolynomialRemainder = {
    ESimpleExamples[
        ESameTest[2, PolynomialRemainder[2 + x^2 + x^3, 2 + 2*x, x]],
        ESameTest[-y^3, PolynomialRemainder[x^3, x + y, x]],
        ESameTest[1-x/a, PolynomialRemainder[1 + x^3, 1 + a*x^2, x]]
    ]
};

FactorTermsList::usage =  "`+"`"+`FactorTermsList[expr]`+"`"+` factors out the constant term of `+"`"+`expr`+"`"+` and puts the factored result into a `+"`"+`List`+"`"+`.";
ExpreduceConstantTerm[c_?NumberQ] := {c, 1};
ExpreduceConstantTerm[c_?NumberQ*e_] := {c, e};
ExpreduceConstantTerm[e_] := {1, e};
FactorTermsList[expr_] := Module[{e = expr, toFactor, cTerms, c},
   toFactor = e // Expand;
   If[Head[toFactor] =!= Plus,
    Return[ExpreduceConstantTerm[toFactor]]
    ];
   (* Parens are necessary due to precedence issue. *)
   cTerms = ((ExpreduceConstantTerm /@ (List @@ toFactor)) //
       Transpose)[[1]];
   c = GCD @@ cTerms;
   If[Last[cTerms] < 0, c = -c];
   {c, toFactor/c // Expand}
   ];
Attributes[FactorTermsList] = {Protected};
Tests`+"`"+`FactorTermsList = {
    ESimpleExamples[
        ESameTest[{2,Sin[8 k]}, FactorTermsList[2*Sin[8*k]]],
        ESameTest[{1/2,a+x}, FactorTermsList[a/2 + x/2]],
        ESameTest[{1,a+x}, FactorTermsList[a + x]]
    ], ETests[
        ESameTest[{1,1}, FactorTermsList[1]],
        ESameTest[{5,1}, FactorTermsList[5]],
        ESameTest[{5.,1}, FactorTermsList[5.]],
        ESameTest[{1,a}, FactorTermsList[a]],
        ESameTest[{1/2,a}, FactorTermsList[a/2]],
        ESameTest[{-(3/2),x}, FactorTermsList[(-3*x)/2]],
        ESameTest[{2,a+x}, FactorTermsList[2*a + 2*x]],
        ESameTest[{1/2,a/(2 b+2 c)+x/(2 b+2 c)}, FactorTermsList[(a/2 + x/2)/(2*b + 2*c)]],
        ESameTest[{1,2+x^2}, FactorTermsList[(8 + 4*x^2)/4]],
        ESameTest[{-(1/2),2+3 x+x^2}, FactorTermsList[(-4 - 6*x - 2*x^2)/4]],
        ESameTest[{-(1/2),-2+3 x+x^2}, FactorTermsList[(2 - 3*x - x^2)/2]],
        ESameTest[{-(1/2),-2-3 x+x^2}, FactorTermsList[(2 + 3*x - x^2)/2]],
        ESameTest[{1/2,2+3 x+x^2}, FactorTermsList[(2 + 3*x + x^2)/2]],
        ESameTest[{1/2,-2-3 x+x^2}, FactorTermsList[(-2 - 3*x + x^2)/2]],
        ESameTest[{5,2+3 x+x^2}, FactorTermsList[5*(1 + x)*(2 + x)]],
        ESameTest[{40,1+3 x+3 x^2+x^3}, FactorTermsList[5*(2 + 2*x)^3]],
        ESameTest[{-6,1+x}, FactorTermsList[(-12 - 12*x)/2]],
        ESameTest[{2/3,3+x}, FactorTermsList[(18 + 6*x)/9]],
        ESameTest[{-(2800301/67344500),1-2 x+x^3}, FactorTermsList[(-2800301/538756 + (2800301*x)/269378 - (2800301*x^3)/538756)/125]]
    ]
};

FactorTerms::usage =  "`+"`"+`FactorTerms[expr]`+"`"+` factors out the constant term of `+"`"+`expr`+"`"+`, if any.";
FactorTerms[expr_] := Module[{e = expr, factored},
    factored = FactorTermsList[e];
    If[factored[[1]] === 1,
      factored[[2]],
      Times@@factored
    ]
   ];
Attributes[FactorTerms] = {Protected};
Tests`+"`"+`FactorTerms = {
    ESimpleExamples[
        ESameTest[2*Sin[8 k], FactorTerms[2*Sin[8*k]]],
        ESameTest[(1/2)*(a+x), FactorTerms[a/2 + x/2]],
        ESameTest[a+x, FactorTerms[a + x]]
    ]
};

ExpreduceFactorConstant[p_Plus] := Module[{e = p, cTerms, c},
   (* Parens are necessary due to precedence issue. *)
   cTerms = ((ExpreduceConstantTerm /@ (List @@ e)) // Transpose)[[1]];
   c = GCD @@ cTerms;
   If[Last[cTerms] < 0, c = -c];
   c * Distribute[e/c]
   ];
ExpreduceFactorConstant[e_] := e;
Attributes[ExpreduceFactorConstant] = {Protected};

Variables::usage = "`+"`"+`Variables[expr]`+"`"+` returns the variables in `+"`"+`expr`+"`"+`.";
Variables[s_Symbol] := {s};
Variables[s_^p_Integer] := Variables[s];
Variables[s_^p_Rational] := Variables[s];
Variables[s_^p_Plus] :=
  If[NumericQ[s], {}, (((s^#) &) /@ p) // Variables];
Variables[s_^p_] := If[NumericQ[s], {}, {s^p}];
Variables[s_^p_Times] :=
  If[NumericQ[s], {}, {s^DeleteCases[p, _Integer]}];
Variables[e_] := (
   If[NumericQ[e] || Length[e] === 0, Return[{}]];
   If[MemberQ[{Plus, Times, List}, Head[e]],
    Return[Union @@ Variables /@ (List @@ e)]];
   If[Length[e] > 0, Return[{e}]];
   Unknown
   );
Attributes[Variables] = {Protected};
Tests`+"`"+`Variables = {
    ESimpleExamples[
        ESameTest[{x, y}, Variables[x + y + y^2]],
        ESameTest[{w^w, x^y, z}, Variables[w^w + x^y + z]],
        ESameTest[{a, b^c, b^d}, Variables[a^2*b^(2*c + 2*d)]]
    ], ETests[
        ESameTest[{x, y}, Variables[x*y]],
        ESameTest[{x, y}, Variables[x + y]],
        ESameTest[{x, y, y^2.5}, Variables[x + y + y^2.5]],
        ESameTest[{y}, Variables[y^2]],
        ESameTest[{x^y}, Variables[x^y]],
        ESameTest[{x^y, y^x}, Variables[x^y + y^x]],
        ESameTest[{x^y, z}, Variables[x^y + z]],
        ESameTest[{w, x^y, z}, Variables[w^2 + x^y + z]],
        ESameTest[{}, Variables[2^(x + y)]],
        ESameTest[{}, Variables[2^x]],
        ESameTest[{}, Variables[foo[]]],
        ESameTest[{foo[x]}, Variables[foo[x]]],
        ESameTest[{foo[x, y]}, Variables[foo[x, y]]],
        ESameTest[{foo[2]}, Variables[foo[2]]],
        ESameTest[{}, Variables[Sin[2]]],
        ESameTest[{Sin[x]}, Variables[Sin[x]]],
        ESameTest[{}, Variables[1]],
        ESameTest[{x}, Variables[{x}]],
        ESameTest[{}, Variables[{1}]],
        ESameTest[{x}, Variables[x]],
        ESameTest[{a, b, x, y, z}, Variables[a + (a + b)^2 + x*y^3 + 2*z]],
        ESameTest[{a, b}, Variables[(a + b)^2]],
        ESameTest[{a, b}, Variables[(a + 2*b)^2]],
        ESameTest[{a, b^c, b^d}, Variables[(a + b^(c + d))^2]],
        ESameTest[{a, b^c, b^d}, Variables[a + b^(c + d)]],
        ESameTest[{(a*b^(c + d))^e}, Variables[(a*b^(c + d))^e]],
        ESameTest[{(a + b)^c}, Variables[(a + b)^c]],
        ESameTest[{(a + b)^c, (a + b)^d}, Variables[(a + b)^(c + d)]],
        ESameTest[{}, Variables[2^(c + d)]],
        ESameTest[{Log[b]}, Variables[Log[b]]],
        ESameTest[{a^b, a^c}, Variables[a^(b + c)]],
        ESameTest[{b^c, b^d}, Variables[b^(2*c + 2*d)]],
        ESameTest[{b^(c*d)}, Variables[b^(2*c*d)]],
        ESameTest[{b^(c*d)}, Variables[b^(c*d)]],
        ESameTest[{b^(2.5*c*d)}, Variables[b^(2.5*c*d)]],
        ESameTest[{(a + b)^2.5}, Variables[(a + b)^2.5]],
        ESameTest[{(a + b)^(2.5*a)}, Variables[(a + b)^(2.5*a)]],
        ESameTest[{(a + b)^2.5, (a + b)^a}, Variables[(a + b)^(2.5 + a)]],
        ESameTest[{}, Variables[5.656854249492381]],
        ESameTest[{}, Variables[{}]],
        ESameTest[{a^"Hello"}, Variables[a^"Hello"]],
        ESameTest[{}, Variables[2^"Hello"]],
        ESameTest[{}, Variables[2^"Hello"^2]],
        ESameTest[{a^"Hello"^2}, Variables[a^"Hello"^2]],

        ESameTest[{}, Variables[Pi^y]],
        ESameTest[{a, Log[b]}, Variables[Sqrt[a] + Log[b]]],
        ESameTest[{a}, Variables[Sqrt[a]]]
    ], EKnownFailures[
        (*I think these have to do with NumericQ.*)
        ESameTest[{(a*b)^c, (a*b)^d}, Variables[(a*b)^(c + d)]]
    ]
};

PolynomialGCD::usage = "`+"`"+`PolynomialGCD[a, b]`+"`"+` calculates the polynomial GCD of `+"`"+`a`+"`"+` and `+"`"+`b`+"`"+`.";
PolySubresultantGCD[inA_, inB_, inX_] :=
  Module[{u = inA, v = inB, x = inX, h, delta, beta, newU, newV, i},
   h = 1;
   i = 1;
   While[v =!= 0 && i < 20,
    uEx = Exponent[u, x];
    vEx = Exponent[v, x];
    delta = uEx - vEx;
    beta = (-1)^(delta + 1)*uEx*h^delta;
    h = h*(vEx/h)^delta;
    newU := v;
    newV = PolynomialRemainder[u, v, x]/beta;
    u = newU;
    v = newV;
    i = i + 1;
    ];
   If[Exponent[u, x] == 0, 1, u]
   ];
(* doesn't work with rational functions yet. *)
(* Looks like prefactored inputs remain factored. *)
PolynomialGCD[inA_, inB_] :=
  FactorTermsList[
    PolySubresultantGCD[inA, inB, Variables[inA][[1]]]][[2]];
Attributes[PolynomialGCD] = {Listable, Protected};
Tests`+"`"+`PolynomialGCD = {
    ESimpleExamples[
        ESameTest[5+a, PolynomialGCD[15+13 a+2 a^2,10+7 a+a^2]],
        ESameTest[5+a+a^2, PolynomialGCD[15+13 a+5 a^2+2 a^3,10+7 a+3 a^2+a^3]],
        ESameTest[-5-a+a^2, PolynomialGCD[15+13 a-a^2-2 a^3,5+a-a^2]]
    ]
};

SquareFreeQ::usage = "`+"`"+`SquareFreeQ[expr]`+"`"+` returns True if `+"`"+`expr`+"`"+` is a square-free polynomial.";
(*only works for univariate polynomials, does not support numbers *)
SquareFreeQ[ex_] := Module[{f = ex, expF, polyvar, fprime},
   If[Length[Variables[f]] != 1, Return[False]];
   expF = Expand[f];
   polyvar = Variables[expF][[1]];
   If[! PolynomialQ[expF, polyvar], Return[False]];
   fprime = D[expF, polyvar];
   PolynomialGCD[expF, fprime] === 1];
Attributes[SquareFreeQ] = {Protected, ReadProtected};
Tests`+"`"+`SquareFreeQ = {
    ESimpleExamples[
        ESameTest[False, SquareFreeQ[(x+1)(x+2)^2//Expand]],
        ESameTest[True, SquareFreeQ[(x + 1) (x + 2)]],
        ESameTest[True, SquareFreeQ[(2 x + 3) (x + 2) // Expand]],
        ESameTest[False, SquareFreeQ[(2 x + 3)^2]]
    ]
};

PSimplify[expr_] := expr;
PSimplify[p_?PolynomialQ/q_?PolynomialQ] :=
  If[Length[Variables[p]] === 1 && Variables[p] === Variables[q],
   PolynomialQuotient[p, q, Variables[p][[1]]], p/q];
Tests`+"`"+`PSimplify = {
    ESimpleExamples[
        ESameTest[-1 + x^2, PSimplify[(1 - 2*x^2 + x^4)/(-1 + x^2)]],
        ESameTest[4*x, PSimplify[(-4*x + 4*x^3)/(-1 + x^2)]],
        ESameTest[-1 - x + x^3 + x^4, PSimplify[(1 - x^2 - x^3 + x^5)/(-1 + x)]],
        ESameTest[2*x + 5*x^2 + 5*x^3, PSimplify[(-2*x - 3*x^2 + 5*x^4)/(-1 + x)]],
        ESameTest[-6 + 11*x - 6*x^2 + x^3, PSimplify[(18 - 39*x + 29*x^2 - 9*x^3 + x^4)/(-3 + x)]],
        ESameTest[13 - 15*x + 4*x^2, PSimplify[(-39 + 58*x - 27*x^2 + 4*x^3)/(-3 + x)]],
        ESameTest[-3 - x + 3*x^2 + x^3, PSimplify[(-9 - 6*x + 8*x^2 + 6*x^3 + x^4)/(3 + x)]],
        ESameTest[-2 + 6*x + 4*x^2, PSimplify[(-6 + 16*x + 18*x^2 + 4*x^3)/(3 + x)]]
    ], ETests[
        ESameTest[12 + 4*x - 15*x^2 - 5*x^3 + 3*x^4 + x^5, PSimplify[(-108 - 108*x + 207*x^2 + 239*x^3 - 81*x^4 - 153*x^5 - 27*x^6 + 21*x^7 + 9*x^8 + x^9)/(-9 - 6*x + 8*x^2 + 6*x^3 + x^4)]],
        ESameTest[12 - 54*x - 33*x^2 + 18*x^3 + 9*x^4, PSimplify[(-108 + 414*x + 717*x^2 - 324*x^3 - 765*x^4 - 162*x^5 + 147*x^6 + 72*x^7 + 9*x^8)/(-9 - 6*x + 8*x^2 + 6*x^3 + x^4)]]
    ],
};

myFactorCommonTerms[a_] := a;
allTimes[p_Plus] := AllTrue[p, (Head[#] === Times) &];
myFactorCommonTerms[a_Plus] := Module[{commonTerms},
   If[! allTimes[a], Return[a]];
   commonTerms = Intersection @@ a;
   commonTerms ((a/commonTerms) // Expand)
   ];

FactorSquareFree::usage = "`+"`"+`FactorSquareFree[poly]`+"`"+` computes the square free factorization of `+"`"+`poly`+"`"+`.";
FactorSquareFree[poly_] :=
  Module[{f = poly, a, b, nb, c, d, i, res, fprime, polyvar, vars},
   vars = Variables[f];
   If[Length[vars] != 1, Return[f//myFactorCommonTerms]];
   polyvar = vars[[1]];
   If[! PolynomialQ[f, polyvar], Return[f]];
   fprime = D[f, polyvar];
   a = PolynomialGCD[f, fprime];
   res = If[SquareFreeQ[a], a, a // FactorSquareFree];
   nb = PolynomialQuotient[f,a,polyvar];
   c = PolynomialQuotient[fprime,a,polyvar];
   d = c - D[nb, polyvar];
   i = 1;
   b = nb;
   While[b =!= 1 && i < 20,
    a = PolynomialGCD[b, d];
    nb = PolynomialQuotient[b,a,polyvar];
    c = PolynomialQuotient[d,a,polyvar];
    res = res*If[SquareFreeQ[a], a, a // FactorSquareFree];
    i = i + 1;
    b = nb;
    d = c - D[b, polyvar]
    (*Print[{Subscript[a, i-1],Subscript[b, i],Subscript[c, i],
    Subscript[d, i]}]*)];
   res
   ];
Attributes[FactorSquareFree] = {Listable, Protected};
Tests`+"`"+`FactorSquareFree = {
    ESimpleExamples[
        ESameTest[(-1 + x^2)^2, FactorSquareFree[1 - 2*x^2 + x^4]],
        ESameTest[(-1 + x)^2*(1 + 2*x + 2*x^2 + x^3), FactorSquareFree[1 - x^2 - x^3 + x^5]],
        ESameTest[(-3 + x)^2*(2 - 3*x + x^2), FactorSquareFree[18 - 39*x + 29*x^2 - 9*x^3 + x^4]],
        ESameTest[(3 + x)^3*(-4 + x^2)*(-1 + x^2)^2, FactorSquareFree[-108 - 108*x + 207*x^2 + 239*x^3 - 81*x^4 - 153*x^5 - 27*x^6 + 21*x^7 + 9*x^8 + x^9]]
    ], ETests[
        ESameTest[a (b+c), FactorSquareFree[a b+a c]],
    ]
};

Factor::usage = "`+"`"+`Factor[poly]`+"`"+` factors `+"`"+`poly`+"`"+`.";
Factor[poly_] := poly;
Attributes[Factor] = {Listable, Protected};
Tests`+"`"+`Factor = {
    ETests[
        ESameTest[a, Factor[a]],
    ]
};

PowerExpand[exp_] := exp //. {
  Log[x_ y_]:>Log[x]+Log[y],
  Log[x_^k_]:>k Log[x],
  Sqrt[-a_]:>I*Sqrt[a],
  Sqrt[a_^2]:>a,
  Sqrt[a_/b_]:>Sqrt[a]/Sqrt[b],
  (a_^b_Integer)^c_Rational:>a^(b*c)
};
Attributes[PowerExpand] = {Protected};
Tests`+"`"+`PowerExpand = {
    ESimpleExamples[
        EComment["`+"`"+`PowerExpand`+"`"+` can expand nested log expressions:"],
        ESameTest[Log[a] + e (Log[b] + d Log[c]), PowerExpand[Log[a (b c^d)^e]]],
        ESameTest[{I Sqrt[a],a,Sqrt[a]/Sqrt[b]}, {Sqrt[-a],Sqrt[a^2],Sqrt[a/b]}//PowerExpand]
    ]
};

Arg::usage = "`+"`"+`Arg[x]`+"`"+` computes the argument of `+"`"+`x`+"`"+`.";
Attributes[Arg] = {Listable, NumericFunction, Protected};
Arg[a_?NumberQ] := ArcTan[Re[a], Im[a]];
Arg[a_] := ArcTan[Re[a], Im[a]] ;/ (FreeQ[ReIm[a], Re] && FreeQ[ReIm[a], Im]);
Tests`+"`"+`Arg = {
    ESimpleExamples[
        ESameTest[Pi/4, Arg[1/2 E^(I*Pi/4)]],
    ]
};

Conjugate::usage = "`+"`"+`Conjugate[x]`+"`"+` computes the complex conjugate of `+"`"+`x`+"`"+`.";
Conjugate[a_] := a - 2 Im[a] I ;/ (FreeQ[Im[a], Re] && FreeQ[Im[a], Im]);
Attributes[Conjugate] = {Listable, NumericFunction, Protected, ReadProtected};
Tests`+"`"+`Conjugate = {
    ESimpleExamples[
        ESameTest[4-4I, Conjugate[4+4I]],
        ESameTest[-4I, Conjugate[4I]],
        ESameTest[4, Conjugate[4]],
    ]
};

ComplexExpand::usage = "`+"`"+`ComplexExpand[e]`+"`"+` returns a complex expansion of `+"`"+`e`+"`"+`.";
Attributes[ComplexExpand] = {Protected};
complexExpandInner[e_] := e;
complexExpandInner[(a_Integer?Negative)^b_Rational] :=
  Module[{coeff, inner},
   coeff = ((a^2)^(b/2));
   inner = b*Arg[a];
   coeff*Cos[inner] + I*coeff*Sin[inner]];
complexExpandInner[E^((a_ + I*b_)*c_)] := E^(a c) Cos[b c]+I E^(a c) Sin[b c];
complexExpandInner[E^(Complex[a_, b_]*c_)] := E^(a c) Cos[b c]+I E^(a c) Sin[b c];
ComplexExpand[exp_] :=
  Map[complexExpandInner, exp, {0, Infinity}] // Expand;
Tests`+"`"+`ComplexExpand = {
    ESimpleExamples[
        ESameTest[a, ComplexExpand[a]],
        ESameTest[1, ComplexExpand[1]],
        ESameTest[a b+a c, ComplexExpand[a*(b+c)]],
        ESameTest[1/2+(I Sqrt[3])/2, ComplexExpand[(-1)^(1/3)]],
        ESameTest[-(1/2)-(I Sqrt[3])/2, ComplexExpand[(-1)^(4/3)]],
        ESameTest[2 2^(1/3), ComplexExpand[(2)^(4/3)]],
        ESameTest[-1+I Sqrt[3], ComplexExpand[(-1)^(1/3) (1+I Sqrt[3])]],
        ESameTest[d E^(a c) Cos[b c]+d I E^(a c) Sin[b c], ComplexExpand[d*E^((a+I*b)*c)]],
        ESameTest[(1/2 + I/2)/Sqrt[2], ComplexExpand[1/2 E^(\[ImaginaryJ]*\[Pi]/4)]],
    ], EKnownFailures[
        ESameTest[-2^(1/3)-I 2^(1/3) Sqrt[3], ComplexExpand[(-2)^(4/3)]],
    ]
};

Exp::usage = "`+"`"+`Exp[x]`+"`"+` returns the exponential of `+"`"+`x`+"`"+`.";
Attributes[Exp] = {Listable, NumericFunction, Protected, ReadProtected};
Exp[x_] := E^x;
Tests`+"`"+`Exp = {
    ESimpleExamples[
        ESameTest[Simplify[Exp[x] * Exp[y] == Exp[x + y]], True],
    ]
};`)

func resourcesPowerMBytes() ([]byte, error) {
	return _resourcesPowerM, nil
}

func resourcesPowerM() (*asset, error) {
	bytes, err := resourcesPowerMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/power.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRandomM = []byte(`RandomReal::usage = "`+"`"+`RandomReal[]`+"`"+` generates a random floating point from 0 to 1.

`+"`"+`RandomReal[max]`+"`"+` generates a random floating point from 0 to `+"`"+`max`+"`"+`.

`+"`"+`RandomReal[min, max]`+"`"+` generates a random floating point from `+"`"+`min`+"`"+` to `+"`"+`max.";
RandomReal[{min_, max_}] := RandomReal[]*(max - min) + min;
RandomReal[max_] := RandomReal[]*max;
Attributes[RandomReal] = {Protected};
Tests`+"`"+`RandomReal = {
    ESimpleExamples[
        EExampleOnlyInstruction["0.0750914", "RandomReal[]"]
    ], EFurtherExamples[
        EComment["Use `+"`"+`SeedRandom`+"`"+` to seed the RNG:"],
        EExampleOnlyInstruction["Null", "SeedRandom[3]"],
        EExampleOnlyInstruction["0.719983", "RandomReal[]"],
        EExampleOnlyInstruction["0.652631", "RandomReal[]"],
        EExampleOnlyInstruction["Null", "SeedRandom[3]"],
        EExampleOnlyInstruction["0.719983", "RandomReal[]"]
    ]
};

SeedRandom::usage = "`+"`"+`SeedRandom[seed]`+"`"+` seeds the internal random number generator with a given integer `+"`"+`seed`+"`"+`.";
Attributes[SeedRandom] = {Protected};
Tests`+"`"+`SeedRandom = {
    ESimpleExamples[
        EExampleOnlyInstruction["0.0750914", "RandomReal[]"],
        EExampleOnlyInstruction["Null", "SeedRandom[3]"],
        EExampleOnlyInstruction["0.719983", "RandomReal[]"],
        EExampleOnlyInstruction["0.652631", "RandomReal[]"],
        EExampleOnlyInstruction["Null", "SeedRandom[3]"],
        EExampleOnlyInstruction["0.719983", "RandomReal[]"]
    ]
};
`)

func resourcesRandomMBytes() ([]byte, error) {
	return _resourcesRandomM, nil
}

func resourcesRandomM() (*asset, error) {
	bytes, err := resourcesRandomMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/random.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesReplacementM = []byte(`ReplaceAll::usage = "`+"`"+`expr /. rule`+"`"+` replaces all occurences of the LHS of `+"`"+`rule`+"`"+` with the RHS of `+"`"+`rule`+"`"+` in `+"`"+`expr`+"`"+`.

`+"`"+`expr /. {r1, r2, ...}`+"`"+` performes the same operation as `+"`"+`expr /. rule`+"`"+`, but evaluating each `+"`"+`r_n`+"`"+` in sequence.";
Attributes[ReplaceAll] = {Protected};
Tests`+"`"+`ReplaceAll = {
    ESimpleExamples[
        ESameTest[2^(y+1) + y, 2^(x^2+1) + x^2 /. x^2->y],
        EComment["If no match is found, `+"`"+`ReplaceAll`+"`"+` evaluates to an unchanged `+"`"+`expr`+"`"+`:"],
        ESameTest[2^(x^2+1) + x^2, 2^(x^2+1) + x^2 /. z^2->y],
        EComment["`+"`"+`ReplaceAll`+"`"+` works within Orderless expressions as well (such as `+"`"+`Plus`+"`"+`):"],
        ESameTest[b + c + d, a + b + c + c^2 /. c^2 + a -> d],
        EComment["`+"`"+`ReplaceAll`+"`"+` can use named patterns:"],
        ESameTest[a^b + c + d, a + b + c + d/. x_Symbol + y_Symbol -> x^y],
        ESameTest[a + 99 * b + 99 * c, a + 2*b + 5*c /. (c1_Integer*a_Symbol) -> 99*a]
    ], EFurtherExamples[
        EComment["`+"`"+`ReplaceAll`+"`"+` can be used to replace sequences of expressions:"],
        ESameTest[foo[b, c, d], a + b + c + d /. a + amatch___ -> foo[amatch]],
        EComment["The `+"`"+`Head`+"`"+` of functions can be replaced just as the subexpressions:"],
        ESameTest[11, (x + 2)[5, 6] /. (2 + x) -> Plus],
        ESameTest[2[2, 2, 2, 2], a*b*c*d /. _Symbol -> 2]
    ], ETests[
        ESameTest[a * b * c, a*b*c /. c + a -> d],
        ESameTest[b * d, a*b*c /. c*a -> d],
        ESameTest[2 * a + b + c + c^2, 2 * a + b + c + c^2 /. c^2 + a -> d],
        ESameTest[a^2 + b + c + d, a^2 + a + b + c + c^2 /. c^2 + a -> d],
        ESameTest[a * b * c + a * b^2 * c, (a*b*c) + (a*b^2*c)],
        ESameTest[b * d + b^2 * d, (a*b*c) + (a*b^2*c) /. c*a -> d],
        ESameTest[b * d + b^2 * d, (a*b*c) + (a*b^2*c) /. a*c -> d],
        ESameTest[a + b + c, a + b + c /. c + a -> c + a],
        ESameTest[d, a*b*c /. c*a*b -> d],
        ESameTest[a * b * c, a*b*c /. c*a*b*d -> d],
        ESameTest[a*b*c*d*e, a*b*c*d*e /. a*b*f -> z],
        ESameTest[z*d*e, a*b*c*d*e /. a*b*c -> z],
        ESameTest[z*a*b, a*b*c*d*e /. e*d*c -> z],
        ESameTest[z*a*b, a*b*c*d*e /. c*e*d -> z],
        ESameTest[a^b, a + b /. x_Symbol + y_Symbol -> x^y],
        ESameTest[2, x = 2],
        ESameTest[2^b, a + b /. x_Symbol + y_Symbol -> x^y],
        ESameTest[2, x],
        ESameTest[a^b, a == b /. j_Symbol == k_Symbol -> j^k],
        ESameTest[2, a == b /. j_Equal -> 2],
        ESameTest[(a == b)^k, a == b /. j_Equal -> j^k],
        ESameTest[3^k, 2^k /. base_Integer -> base + 1],
        ESameTest[3^k, 2^k /. base_Integer^exp_ -> (base + 1)^exp],
        ESameTest[(2 + k)^k, 2^k /. base_Integer^exp_ -> (base + exp)^exp],
        ESameTest[(2 + k)^k, 2^k /. base_Integer^exp_Symbol -> (base + exp)^exp],
        ESameTest[1 + (2 + k)^k, 2^k + 1 /. base_Integer^exp_Symbol -> (base + exp)^exp],
        ESameTest[a^c + b, a^c + b /. test_Symbol^test_Symbol + test_Symbol -> test + 1],
        ESameTest[1 + a, a^a + a /. test_Symbol^test_Symbol + test_Symbol -> test + 1],
        ESameTest[a^a, a^a /. (test_Symbol^test) -> 2],
        ESameTest[2, a^a /. (test_Symbol^test_Symbol) -> 2],
        ESameTest[a^a, a^a /. (test^test_Symbol) -> 2],
        ESameTest[2, test^a /. (test^test_Symbol) -> 2],
        ESameTest[2, a^test /. (test_Symbol^test) -> 2],
        EResetState[],
        ESameTest[testa*testb, testa*testb /. a_Symbol*a_Symbol -> 5],
        ESameTest[False, MatchQ[testa*testb, a_Symbol*a_Symbol]],
        ESameTest[testa+testb, testa+testb /. a_Symbol+a_Symbol -> 5],
        ESameTest[5, testa*testb /. a_Symbol*b_Symbol -> 5],
        ESameTest[a+b, a + b /. (b_Symbol + b_Symbol) -> 2],
        EResetState[],

        (*Test matching/replacement contexts*)
        ESameTest[99^k, test = 99^k],
        ESameTest[2, 99^k /. test -> 2],
        ESameTest[2, 99^k /. test_ -> 2],
        ESameTest[3, test2 = 3],
        ESameTest[3, 99 /. test2_Integer -> test2],
        ESameTest[a^b, a^b /. test3_Symbol^test3_Symbol -> k],
        ESameTest[5, test3 = 5],
        ESameTest[a^b, a^b /. test3_Symbol^test3_Symbol -> k],

        EResetState[],
        ESameTest[a + 99 * b + 99 * c, a + 2*b + 5*c /. (c1_Integer*a_Symbol) -> 99*a],
        ESameTest[a + 99 * b + 5 * c, a + 2*b + 5*c /. (2*a_Symbol) -> 99*a],
        ESameTest[a + 99 * b + 99 * c, a + 2*b + 2*c /. (2*a_Symbol) -> 99*a],
        ESameTest[a + 99 * b + 99 * c + 99 * d, a + 2*b + 3*c + 3*d /. (cl_Integer*a_Symbol) -> 99*a],

        (*Work way up to combining like terms*)
        EResetState[],
        ESameTest[a + 99 * b + 99 * c, a + 2*b + 5*c /. (c1_Integer*a_Symbol) -> 99*a],
        ESameTest[a + 99 * b, a + 2*b + 5*c /. (c1_Integer*matcha_Symbol) + (c2_Integer*matchb_Symbol) -> 99*matcha],
        ESameTest[a + (2 * b) + (5 * c), a + 2*b + 5*c /. (c1_Integer*matcha_Symbol) + (c2_Integer*matcha_Symbol) -> (c1+c2)*matcha],
        ESameTest[(a + (7 * b)), a + 2*b + 5*b /. (c1_Integer*matcha_Symbol) + (c2_Integer*matcha_Symbol) -> (c1+c2)*matcha],

        EResetState[],
        ESameTest[2, a + b /. (d_Symbol + c_Symbol) -> 2],
        ESameTest[2 + c, a + b + c /. (d_Symbol + c_Symbol) -> 2],
        ESameTest[2 + c + d, a + b + c + d /. (d_Symbol + c_Symbol) -> 2],
        ESameTest[a+99+c+d, a + b + c + d /. (dmatch_Symbol + cmatch_Symbol) -> cmatch + 99],
        ESameTest[a * b + c + d, a + b + c + d /. (d_Symbol + c_Symbol) -> c*d],
        ESameTest[98, d = 98],
        ESameTest[c+98+(b*a), a + b + c + d /. (dmatch_Symbol + cmatch_Symbol) -> cmatch*dmatch],

        EResetState[],
        ESameTest[2 * a^2 - 2 * b^2, 2 * a^2 - 2 * b^2 /. matcha_ - matchb_ -> 2],
        ESameTest[3 * a^2 + 5 * b^2, 2 * a^2 - 2 * b^2 /. 2*matcha_ - 2*matchb_ -> 3*matcha + 5*matchb],
        ESameTest[2 * a^2 - 2 * b^2, 2 * a^2 - 2 * b^2 /. _Integer*matcha_ - _Integer*matchb_ -> 2],
        ESameTest[2 * a^2 - 2 * b^2, 2 * a^2 - 2 * b^2 /. _*matcha_ - _*matchb_ -> 2],
        ESameTest[2 * a^2 - 2 * b^2, 2 * a^2 - 2 * b^2 /. _ - _ -> 2],
        ESameTest[2 * a^2 - 2 * b^2, 2 * a^2 - 2 * b^2 /. _ - 2*_ -> 2],

        (*Test replacing functions*)
        ESameTest[test[], kfdsfdsf[] /. _Symbol -> test],
        ESameTest[11, (x + 2)[5, 6] /. (2 + x) -> Plus],
        ESameTest[2[2, 2, 2, 2], a*b*c*d /. _Symbol -> 2],
        ESameTest[2, foo[2*x, x] /. foo[matcha_Integer*matchx_, matchx_] -> matcha],
        ESameTest[foo[], a + b /. a + b + amatch___ -> foo[amatch]],
        ESameTest[foo[b, c, d], a + b + c + d /. a + amatch___ -> foo[amatch]],
        ESameTest[foo[a + b + c + d], a + b + c + d /. amatch___ -> foo[amatch]],
        ESameTest[a + b, a + b /. a + b + amatch__ -> foo[amatch]],
        ESameTest[foo[b, c, d], a + b + c + d /. a + amatch__ -> foo[amatch]],
        ESameTest[foo[a + b + c + d], a + b + c + d /. amatch__ -> foo[amatch]],

        (*Test replacement within Hold parts*)
        ESameTest[3, {a, b, c} /. {n__} :> Length[{n}]],
        ESameTest[1, {a, b, c} /. {n__} -> Length[{n}]],
        ESameTest[bar[m,n], foo[m, n] /. foo[a_, m_] -> bar[a, m]],

        (*Test replacement of functions and arguments*)
        ESameTest[foo[False, y, 5], foo[x == 2, y, x] /. x -> 5],
        ESameTest[foo[5, y, x], foo[x * 2, y, x] /. x * 2 -> 5],
        ESameTest[k, foo[k] /. foo[k] -> k],
        ESameTest[foo[k], foo[foo[k]] /. foo[k] -> k],
        ESameTest[k, (foo[foo[k]] /. foo[k] -> k) /. foo[k] -> k],
        ESameTest[foo[bla], foo[foo[k]] /. foo[k] -> bla],

        ESameTest[2 * a + 12 * b, foo[1, 2, 3, 4] /. foo[1, amatch__Integer, bmatch___Integer] -> a*Times[amatch] + b*Times[bmatch]],
        ESameTest[a + 24 * b, foo[1, 2, 3, 4] /. foo[1, amatch___Integer, bmatch___Integer] -> a*Times[amatch] + b*Times[bmatch]],

        (*Test handling of orderless and Flat attributes.*)
        ESameTest[False, MatchQ[Plus[a, b], Plus[a, b, c]]],
        ESameTest[f && c, And[a, b, c] /. And[a, b] -> f],
        ESameTest[False, MatchQ[And[a, b, c], And[b, c]]],
        ESameTest[False, MatchQ[And[a, b, c], And[a, b]]],
        ESameTest[jjj && eee && c, And[a, b, c] /. And[a, b] -> Sequence[jjj, eee]],
        ESameTest[myand[a, b, c], myand[a, b, c] /. myand[a, b] -> f],
        ESameTest[a && b && c, And[a, b, c] /. And[b, a] -> Sequence[jjj, eee]],
        ESameTest[c + eee + jjj, Plus[a, b, c] /. Plus[b, a] -> Sequence[jjj, eee]],
        ESameTest[c + eee + jjj, Plus[a, b, c] /. Plus[a, b] -> Sequence[jjj, eee]],
        ESameTest[a && b && c, And[a, b, c] /. And[a, c] -> Sequence[jjj, eee]],
        ESameTest[1 && 2 && a && b && jjj && eee, And[1, 2, a, b, c] /. And[___Integer, c] -> Sequence[jjj, eee]],
        ESameTest[1 && 2 && a && b && c, And[1, 2, a, b, c] /. And[__Integer, c] -> Sequence[jjj, eee]],
        ESameTest[jjj && eee && b && c, And[1, 2, a, b, c] /. And[__Integer, a] -> Sequence[jjj, eee]],
        ESameTest[Sequence[jjj, eee], And[1, 2, a, b, c] /. And[__Integer, a, __Symbol] -> Sequence[jjj, eee]],
        ESameTest[1 && 2 && a && b && c, And[1, 2, a, b, c] /. And[__Symbol, a, __Integer] -> Sequence[jjj, eee]],
        ESameTest[1 && 2 && jjj && eee && b && c, And[1, 2, a, b, c] /. And[___Symbol, a, ___Integer] -> Sequence[jjj, eee]]
    ], EKnownDangerous[
        (*Causes stack overflow*)
        ESameTest[99 + a + b + c + d, a + b + c + d /. (d_Symbol + c_Symbol) -> c + 99 + d]
    ]
};

Replace::usage = "`+"`"+`Replace[expr, rules]`+"`"+` applies `+"`"+`rules`+"`"+` to `+"`"+`expr`+"`"+` if they match at the base level.";
Attributes[Replace] = {Protected};
Tests`+"`"+`Replace = {
    ESimpleExamples[
        ESameTest[2, Replace[a+b,a+b->2]],
        ESameTest[a+b, Replace[a+b,a->2]],
        ESameTest[2, Replace[a+b,_->2]],
        ESameTest[c+d, Replace[a+b,{a+b->c+d,c+d->3}]]
    ]
};

ReplaceRepeated::usage = "`+"`"+`expr //. rule`+"`"+` replaces all occurences of the LHS of `+"`"+`rule`+"`"+` with the RHS of `+"`"+`rule`+"`"+` in `+"`"+`expr`+"`"+` repeatedly until the expression stabilizes.

`+"`"+`expr //. {r1, r2, ...}`+"`"+` performes the same operation as `+"`"+`expr //. rule`+"`"+`, but evaluating each `+"`"+`r_n`+"`"+` in sequence.";
Attributes[ReplaceRepeated] = {Protected};
Tests`+"`"+`ReplaceRepeated = {
    ESimpleExamples[
        EComment["`+"`"+`ReplaceRepeated`+"`"+` can be used to implement logarithm expansion:"],
        ESameTest[Null, logRules := {Log[x_ y_] :> Log[x] + Log[y], Log[x_^k_] :> k Log[x]}],
        ESameTest[b Log[a] + (c^d) Log[b], Log[a^b*b^(c^d)] //. logRules]
    ]
};

Rule::usage = "`+"`"+`lhs -> rhs`+"`"+` can be used in replacement functions to say that instances of `+"`"+`lhs`+"`"+` should be replaced with `+"`"+`rhs`+"`"+`.";
Attributes[Rule] = {SequenceHold, Protected};
Tests`+"`"+`Rule = {
    ESimpleExamples[
        ESameTest[2^(y+1) + y, 2^(x^2+1) + x^2 /. x^2 -> y],
        EComment["To demonstrate the difference between `+"`"+`Rule`+"`"+` and `+"`"+`RuleDelayed`+"`"+`:"],
        ESameTest[True, Equal @@ ({1, 1} /. 1 -> RandomReal[])],
        ESameTest[False, Equal @@ ({1, 1} /. 1 :> RandomReal[])]
    ]
};

RuleDelayed::usage = "`+"`"+`lhs :> rhs`+"`"+` can be used in replacement functions to say that instances of `+"`"+`lhs`+"`"+` should be replaced with `+"`"+`rhs`+"`"+`, evaluating `+"`"+`rhs`+"`"+` only after replacement.";
Attributes[RuleDelayed] = {HoldRest, SequenceHold, Protected};
Tests`+"`"+`RuleDelayed = {
    ESimpleExamples[
        ESameTest[2^(y+1) + y, 2^(x^2+1) + x^2 /. x^2 :> y],
        EComment["To demonstrate the difference between `+"`"+`Rule`+"`"+` and `+"`"+`RuleDelayed`+"`"+`:"],
        ESameTest[True, Equal @@ ({1, 1} /. 1 -> RandomReal[])],
        ESameTest[False, Equal @@ ({1, 1} /. 1 :> RandomReal[])]
    ]
};

ReplacePart::usage = "`+"`"+`ReplacePart[e, {loc1 -> newval1, ...}]`+"`"+` replaces the value at the locations with their corresponding new values in `+"`"+`e`+"`"+`.";
Attributes[ReplacePart] = {Protected};
ReplacePart[e_?((! AtomQ[#]) &), r_, i_Integer?Positive] :=
  
  If[i <= Length[e] === True,
   Join[e[[1 ;; i - 1]], Head[e][r], e[[i + 1 ;; Length[e]]]],
   Print["Index too large for ReplacePart!"]];
ReplacePart[e_, r_Rule] := ReplacePart[e, {r}];
Tests`+"`"+`ReplacePart = {
    ESimpleExamples[
        ESameTest[{1,foo,3,4}, ReplacePart[Range[4],foo,2]],
        ESameTest[{1,2,foo,4}, ReplacePart[Range[4],3->foo]],
        ESameTest[{1,2,foo,4}, ReplacePart[Range[4],{3}->foo]],
        ESameTest[{1,2,3,4}, ReplacePart[Range[4],{3,1}->foo]],
    ], EFurtherExamples[
        ESameTest[{foo,foo,foo,foo}, ReplacePart[Range[4],i_->foo]],
        ESameTest[{1,2,3,4}, ReplacePart[Range[4],7->foo]],
        ESameTest[a+b^foo, ReplacePart[a+b^c,{2,2}->foo]],
        ESameTest[a+b^c, ReplacePart[a+b^c,{2,2,1}->foo]],
    ], ETests[
        ESameTest[a+foo^foo, ReplacePart[a+b^c,{2,_}->foo]],
        ESameTest[a+b^foo, ReplacePart[a+b^c,{{2,2}->foo}]],
        ESameTest[b^foo+foo, ReplacePart[a+b^c,{{2,2}->foo,{1}->foo}]],
        ESameTest[b^foo+foo, ReplacePart[a+b^c,{{1}->foo,{2,2}->foo}]],
        ESameTest[ReplacePart[a+b^c,{{1}->foo,bar}], ReplacePart[a+b^c,{{1}->foo,bar}]],
        ESameTest[3, ReplacePart[a+b^c,{{a_}->a}]],
        ESameTest[hi, ReplacePart[hi,{{a_}->a}]],
        ESameTest[a+foo[1]^foo[2], ReplacePart[a+b^c,{{_,a_}->foo[a]}]],
    ], EKnownFailures[
        ESameTest[foo[a,b^c], ReplacePart[a+b^c,{{0}->foo}]],
        ESameTest[a+foo, ReplacePart[a+b^c,{{-1}->foo}]],
    ]
};
`)

func resourcesReplacementMBytes() ([]byte, error) {
	return _resourcesReplacementM, nil
}

func resourcesReplacementM() (*asset, error) {
	bytes, err := resourcesReplacementMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/replacement.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi111LinearBinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.1.1 Linear Binomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.1.1.1 (a+b x)^m*)


Int[1/x_,x_Symbol] :=
  Log[x]


Int[x_^m_.,x_Symbol] :=
  x^(m+1)/(m+1) /;
FreeQ[m,x] && NeQ[m,-1]


Int[1/(a_+b_.*x_),x_Symbol] :=
  Log[RemoveContent[a+b*x,x]]/b /;
FreeQ[{a,b},x]


Int[(a_.+b_.*x_)^m_,x_Symbol] :=
  (a+b*x)^(m+1)/(b*(m+1)) /;
FreeQ[{a,b,m},x] && NeQ[m,-1]


Int[(a_.+b_.*u_)^m_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x)^m,x],x,u] /;
FreeQ[{a,b,m},x] && LinearQ[u,x] && NeQ[u-x,0]





(* ::Subsection::Closed:: *)
(*1.1.1.2 (a+b x)^m (c+d x)^n*)


Int[1/((a_+b_.*x_)*(c_+d_.*x_)),x_Symbol] :=
  Int[1/(a*c+b*d*x^2),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0]


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  b/(b*c-a*d)*Int[1/(a+b*x),x] - d/(b*c-a*d)*Int[1/(c+d*x),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^(n+1)/((b*c-a*d)*(m+1)) /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d,0] && EqQ[m+n+2,0] && NeQ[m,-1]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^m_,x_Symbol] :=
  x*(a+b*x)^m*(c+d*x)^m/(2*m+1) + 2*a*c*m/(2*m+1)*Int[(a+b*x)^(m-1)*(c+d*x)^(m-1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && PositiveIntegerQ[m+1/2]


Int[1/((a_+b_.*x_)^(3/2)*(c_+d_.*x_)^(3/2)),x_Symbol] :=
  x/(a*c*Sqrt[a+b*x]*Sqrt[c+d*x]) /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^m_,x_Symbol] :=
  -x*(a+b*x)^(m+1)*(c+d*x)^(m+1)/(2*a*c*(m+1)) + 
  (2*m+3)/(2*a*c*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(m+1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && NegativeIntegerQ[m+3/2]


Int[(a_+b_.*x_)^m_.*(c_+d_.*x_)^m_.,x_Symbol] :=
  Int[(a*c+b*d*x^2)^m,x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[b*c+a*d,0] && (IntegerQ[m] || PositiveQ[a] && PositiveQ[c])


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  ArcCosh[b*x/a]/b /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && PositiveQ[a] && EqQ[a+c,0]


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  2*Subst[Int[1/(b-d*x^2),x],x,Sqrt[a+b*x]/Sqrt[c+d*x]] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^m_,x_Symbol] :=
  (a+b*x)^FracPart[m]*(c+d*x)^FracPart[m]/(a*c+b*d*x^2)^FracPart[m]*Int[(a*c+b*d*x^2)^m,x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[b*c+a*d,0] && Not[IntegerQ[2*m]]


Int[1/((a_+b_.*x_)^(5/4)*(c_+d_.*x_)^(1/4)),x_Symbol] :=
  -2/(b*(a+b*x)^(1/4)*(c+d*x)^(1/4)) + c*Int[1/((a+b*x)^(5/4)*(c+d*x)^(5/4)),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && NegQ[a^2*b^2]


Int[1/((a_+b_.*x_)^(9/4)*(c_+d_.*x_)^(1/4)),x_Symbol] :=
  -4/(5*b*(a+b*x)^(5/4)*(c+d*x)^(1/4)) - d/(5*b)*Int[1/((a+b*x)^(5/4)*(c+d*x)^(5/4)),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && NegQ[a^2*b^2]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n/(b*(m+n+1)) + 
  2*c*n/(m+n+1)*Int[(a+b*x)^m*(c+d*x)^(n-1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && IntegerQ[m+1/2] && IntegerQ[n+1/2] && 0<m<n


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  -(a+b*x)^(m+1)*(c+d*x)^(n+1)/(2*a*d*(m+1)) + 
  (m+n+2)/(2*a*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d,0] && IntegerQ[m+1/2] && IntegerQ[n+1/2] && m<n<0


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n,x],x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && IGtQ[m,0] && 
  (Not[IntegerQ[n]] || EqQ[c,0] && 7*m+4*n+4<=0 || 9*m+5*(n+1)<0 || m+n+2>0)


Int[(a_+b_.*x_)^m_.*(c_.+d_.*x_)^n_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n,x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && ILtQ[m,0] && IntegerQ[n] && Not[IGtQ[n,0] && m+n+2<0]


Int[(c_.+d_.*x_)^n_/(a_.+b_.*x_),x_Symbol] :=
  (c+d*x)^n/(b*n) + 
  (b*c-a*d)/b*Int[(c+d*x)^(n-1)/(a+b*x),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[n] && n>0


Int[(c_.+d_.*x_)^n_/(a_.+b_.*x_),x_Symbol] :=
  -(c+d*x)^(n+1)/((n+1)*(b*c-a*d)) + 
  b*(n+1)/((n+1)*(b*c-a*d))*Int[(c+d*x)^(n+1)/(a+b*x),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[n] && n<-1


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)^(1/3)),x_Symbol] :=
  With[{q=Rt[(b*c-a*d)/b,3]},
  -Log[RemoveContent[a+b*x,x]]/(2*b*q) - 
  3/(2*b*q)*Subst[Int[1/(q-x),x],x,(c+d*x)^(1/3)] + 
  3/(2*b)*Subst[Int[1/(q^2+q*x+x^2),x],x,(c+d*x)^(1/3)]] /;
FreeQ[{a,b,c,d},x] && PosQ[(b*c-a*d)/b]


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)^(1/3)),x_Symbol] :=
  With[{q=Rt[-(b*c-a*d)/b,3]},
  Log[RemoveContent[a+b*x,x]]/(2*b*q) - 
  3/(2*b*q)*Subst[Int[1/(q+x),x],x,(c+d*x)^(1/3)] + 
  3/(2*b)*Subst[Int[1/(q^2-q*x+x^2),x],x,(c+d*x)^(1/3)]] /;
FreeQ[{a,b,c,d},x] && NegQ[(b*c-a*d)/b]


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)^(2/3)),x_Symbol] :=
  With[{q=Rt[(b*c-a*d)/b,3]},
  -Log[RemoveContent[a+b*x,x]]/(2*b*q^2) - 
  3/(2*b*q^2)*Subst[Int[1/(q-x),x],x,(c+d*x)^(1/3)] - 
  3/(2*b*q)*Subst[Int[1/(q^2+q*x+x^2),x],x,(c+d*x)^(1/3)]] /;
FreeQ[{a,b,c,d},x] && PosQ[(b*c-a*d)/b]


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)^(2/3)),x_Symbol] :=
  With[{q=Rt[-(b*c-a*d)/b,3]},
  -Log[RemoveContent[a+b*x,x]]/(2*b*q^2) + 
  3/(2*b*q^2)*Subst[Int[1/(q+x),x],x,(c+d*x)^(1/3)] + 
  3/(2*b*q)*Subst[Int[1/(q^2-q*x+x^2),x],x,(c+d*x)^(1/3)]] /;
FreeQ[{a,b,c,d},x] && NegQ[(b*c-a*d)/b]


Int[(c_.+d_.*x_)^n_/(a_.+b_.*x_),x_Symbol] :=
  With[{p=Denominator[n]},
  p*Subst[Int[x^(p*(n+1)-1)/(a*d-b*c+b*x^p),x],x,(c+d*x)^(1/p)]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[n] && -1<n<0


Int[(c_+d_.*x_)^n_/x_,x_Symbol] :=
  -(c+d*x)^(n+1)/(c*(n+1))*Hypergeometric2F1[1,n+1,n+2,1+d*x/c] /;
FreeQ[{c,d,n},x] && Not[IntegerQ[n]]


Int[(c_.+d_.*x_)^n_/(a_+b_.*x_),x_Symbol] :=
  -(c+d*x)^(n+1)/((n+1)*(b*c-a*d))*Hypergeometric2F1[1,n+1,n+2,TogetherSimplify[b*(c+d*x)/(b*c-a*d)]] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && Not[IntegerQ[n]]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n/(b*(m+1)) - 
  d*n/(b*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m,n] && m<-1 && n>0 && Not[IntegerQ[n] && Not[IntegerQ[m]]] && 
  Not[IntegerQ[m+n] && m+n+2<=0 && (FractionQ[m] || 2*n+m+1>=0)] && IntLinearcQ[a,b,c,d,m,n,x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^(n+1)/((b*c-a*d)*(m+1)) - 
  d*(m+n+2)/((b*c-a*d)*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m,n] && m<-1 && 
  Not[n<-1 && (EqQ[a,0] || NeQ[c,0] && m<n && IntegerQ[n])] && IntLinearcQ[a,b,c,d,m,n,x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n/(b*(m+n+1)) + 
  n*(b*c-a*d)/(b*(m+n+1))*Int[(a+b*x)^m*(c+d*x)^(n-1),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m,n] && n>0 && m+n+1!=0 && 
  Not[PositiveIntegerQ[m] && (Not[IntegerQ[n]] || 0<m<n)] && 
  Not[IntegerQ[m+n] && m+n+2<0] && IntLinearcQ[a,b,c,d,m,n,x]


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  Int[1/Sqrt[a*c-b*(a-c)*x-b^2*x^2],x] /;
FreeQ[{a,b,c,d},x] && EqQ[b+d,0] && PositiveQ[a+c]


Int[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  2/Sqrt[b]*Subst[Int[1/Sqrt[b*c-a*d+d*x^2],x],x,Sqrt[a+b*x]] /;
FreeQ[{a,b,c,d},x] && PositiveQ[b*c-a*d] && PositiveQ[b]


Int[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  2/b*Subst[Int[1/Sqrt[c-a+x^2],x],x,Sqrt[a+b*x]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && EqQ[b-d,0]


Int[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  2*Subst[Int[1/(b-d*x^2),x],x,Sqrt[a+b*x]/Sqrt[c+d*x]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[(a_.+b_.*x_)^m_*(c_+d_.*x_)^m_,x_Symbol] :=
  (a+b*x)^m*(c+d*x)^m/(a*c+(b*c+a*d)*x+b*d*x^2)^m*Int[(a*c+(b*c+a*d)*x+b*d*x^2)^m,x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m] && -1<m<0 && 3<=Denominator[m]<=4


Int[1/((a_.+b_.*x_)^(1/3)*(c_.+d_.*x_)^(2/3)),x_Symbol] :=
  With[{q=Rt[d/b,3]},
  -Sqrt[3]*q/d*ArcTan[2*q*(a+b*x)^(1/3)/(Sqrt[3]*(c+d*x)^(1/3))+1/Sqrt[3]] - 
  q/(2*d)*Log[c+d*x] - 
  3*q/(2*d)*Log[q*(a+b*x)^(1/3)/(c+d*x)^(1/3)-1]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && PosQ[d/b]


Int[1/((a_.+b_.*x_)^(1/3)*(c_.+d_.*x_)^(2/3)),x_Symbol] :=
  With[{q=Rt[-d/b,3]},
  Sqrt[3]*q/d*ArcTan[1/Sqrt[3]-2*q*(a+b*x)^(1/3)/(Sqrt[3]*(c+d*x)^(1/3))] + 
  q/(2*d)*Log[c+d*x] + 
  3*q/(2*d)*Log[q*(a+b*x)^(1/3)/(c+d*x)^(1/3)+1]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && NegQ[d/b]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  With[{p=Denominator[m]},
  p*Subst[Int[x^(p*(m+1)-1)/(b-d*x^p),x],x,(a+b*x)^(1/p)/(c+d*x)^(1/p)]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m,n] && -1<m<0 && m+n+1==0


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  With[{p=Denominator[m]},
  p/b*Subst[Int[x^(p*(m+1)-1)*(c-a*d/b+d*x^p/b)^n,x],x,(a+b*x)^(1/p)]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[m,n] && -1<m<0 && -1<n<0 && Denominator[n]<=Denominator[m] && 
  IntLinearcQ[a,b,c,d,m,n,x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^(n+1)/((b*c-a*d)*(m+1)) - 
  d*Simplify[m+n+2]/((b*c-a*d)*(m+1))*Int[(a+b*x)^Simplify[m+1]*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d,0] && NegativeIntegerQ[Simplify[m+n+2]] && NeQ[m,-1] && 
  (SumSimplerQ[m,1] || Not[SumSimplerQ[n,1]])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  c^n*(b*x)^(m+1)/(b*(m+1))*Hypergeometric2F1[-n,m+1,m+2,-d*x/c] /;
FreeQ[{b,c,d,m,n},x] && Not[IntegerQ[m]] && (IntegerQ[n] || PositiveQ[c] && Not[EqQ[n,-1/2] && EqQ[c^2-d^2,0] && PositiveQ[-d/(b*c)]])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (c+d*x)^(n+1)/(d*(n+1)*(-d/(b*c))^m)*Hypergeometric2F1[-m,n+1,n+2,1+d*x/c] /;
FreeQ[{b,c,d,m,n},x] && Not[IntegerQ[n]] && (IntegerQ[m] || PositiveQ[-d/(b*c)])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  c^IntPart[n]*(c+d*x)^FracPart[n]/(1+d*x/c)^FracPart[n]*Int[(b*x)^m*(1+d*x/c)^n,x] /;
FreeQ[{b,c,d,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[PositiveQ[c]] && Not[PositiveQ[-d/(b*c)]] && 
  (RationalQ[m] && Not[EqQ[n,-1/2] && EqQ[c^2-d^2,0]] || Not[RationalQ[n]])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (-b*c/d)^IntPart[m]*(b*x)^FracPart[m]/(-d*x/c)^FracPart[m]*Int[(-d*x/c)^m*(c+d*x)^n,x] /;
FreeQ[{b,c,d,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[PositiveQ[c]] && Not[PositiveQ[-d/(b*c)]]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (b*c-a*d)^n*(a+b*x)^(m+1)/(b^(n+1)*(m+1))*Hypergeometric2F1[-n,m+1,m+2,-d*(a+b*x)/(b*c-a*d)] /;
FreeQ[{a,b,c,d,m},x] && NeQ[b*c-a*d,0] && Not[IntegerQ[m]] && IntegerQ[n]


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (a+b*x)^(m+1)/(b*(m+1)*(b/(b*c-a*d))^n)*Hypergeometric2F1[-n,m+1,m+2,-d*(a+b*x)/(b*c-a*d)] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d,0] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && PositiveQ[b/(b*c-a*d)] && 
  (RationalQ[m] || Not[RationalQ[n] && PositiveQ[-d/(b*c-a*d)]])


Int[(a_+b_.*x_)^m_*(c_+d_.*x_)^n_,x_Symbol] :=
  (c+d*x)^FracPart[n]/((b/(b*c-a*d))^IntPart[n]*(b*(c+d*x)/(b*c-a*d))^FracPart[n])*
    Int[(a+b*x)^m*(b*c/(b*c-a*d)+b*d*x/(b*c-a*d))^n,x] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d,0] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && (RationalQ[m] || Not[SimplerQ[n+1,m+1]])


Int[(a_.+b_.*u_)^m_.*(c_.+d_.*u_)^n_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x)^m*(c+d*x)^n,x],x,u] /;
FreeQ[{a,b,c,d,m,n},x] && LinearQ[u,x] && NeQ[Coefficient[u,x,0],0]


(* IntLinearcQ[a,b,c,d,m,n,x] returns True iff (a+b*x)^m*(c+d*x)^n is integrable wrt x in terms of non-hypergeometric functions. *)
IntLinearcQ[a_,b_,c_,d_,m_,n_,x_] :=
  IntegerQ[m] || IntegerQ[n] || IntegersQ[3*m,3*n] || IntegersQ[4*m,4*n] || IntegersQ[2*m,6*n] || IntegersQ[6*m,2*n] || IntegerQ[m+n]


(* ::Subsection::Closed:: *)
(*1.1.1.3 (a+b x)^m (c+d x)^n (e+f x)^p*)


Int[(a_+b_.*x_)^m_.*(c_+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  Int[(a*c+b*d*x^2)^m*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && EqQ[b*c+a*d,0] && EqQ[m-n,0] && IntegerQ[m]


Int[(a_.+b_.*x_)*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(n+p+2)) /;
FreeQ[{a,b,c,d,e,f,n,p},x] && NeQ[n+p+2,0] && EqQ[a*d*f*(n+p+2)-b*(d*e*(n+1)+c*f*(p+1)),0]


Int[(a_+b_.*x_)*(d_.*x_)^n_.*(e_+f_.*x_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)*(d*x)^n*(e+f*x)^p,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && IGtQ[p,0] && EqQ[b*e+a*f,0] && Not[NegativeIntegerQ[n+p+2] && n+2*p>0]


Int[(a_+b_.*x_)*(d_.*x_)^n_.*(e_+f_.*x_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)*(d*x)^n*(e+f*x)^p,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && IGtQ[p,0] && (NeQ[n,-1] || EqQ[p,1]) && NeQ[b*e+a*f,0] &&
  (Not[IntegerQ[n]] || 9*p+5*n<0 || n+p+1>=0 || n+p+2>=0 && RationalQ[a,b,d,e,f]) && (NeQ[n+p+3,0] || EqQ[p,1])


Int[(a_.+b_.*x_)*(c_+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)*(c+d*x)^n*(e+f*x)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d,0] && 
  (NegativeIntegerQ[n,p] || EqQ[p,1] || 
    IGtQ[p,0] && (Not[IntegerQ[n]] || 9*p+5*(n+2)<=0 || n+p+1>=0 || n+p+2>=0 && RationalQ[a,b,c,d,e,f]))


Int[(a_.+b_.*x_)*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  -(b*e-a*f)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(f*(p+1)*(c*f-d*e)) - 
  (a*d*f*(n+p+2)-b*(d*e*(n+1)+c*f*(p+1)))/(f*(p+1)*(c*f-d*e))*Int[(c+d*x)^n*(e+f*x)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,n},x] && LtQ[p,-1] && 
  (Not[LtQ[n,-1]] || IntegerQ[p] || Not[IntegerQ[n] || Not[EqQ[e,0] || Not[EqQ[c,0] || p<n]]])


Int[(a_.+b_.*x_)*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  -(b*e-a*f)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(f*(p+1)*(c*f-d*e)) - 
  (a*d*f*(n+p+2)-b*(d*e*(n+1)+c*f*(p+1)))/(f*(p+1)*(c*f-d*e))*Int[(c+d*x)^n*(e+f*x)^Simplify[p+1],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && Not[RationalQ[p]] && SumSimplerQ[p,1]


Int[(a_.+b_.*x_)*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(n+p+2)) + 
  (a*d*f*(n+p+2)-b*(d*e*(n+1)+c*f*(p+1)))/(d*f*(n+p+2))*Int[(c+d*x)^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && NeQ[n+p+2,0]


Int[(a_.+b_.*x_)^2*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(c+d*x)^(n+1)*(e+f*x)^(p+1)*(2*a*d*f*(n+p+3)-b*(d*e*(n+2)+c*f*(p+2))+b*d*f*(n+p+2)*x)/(d^2*f^2*(n+p+2)*(n+p+3)) /;
FreeQ[{a,b,c,d,e,f,n,p},x] && NeQ[n+p+2,0] && NeQ[n+p+3,0] && 
  EqQ[d*f*(n+p+2)*(a^2*d*f*(n+p+3)-b*(b*c*e+a*(d*e*(n+1)+c*f*(p+1))))-b*(d*e*(n+1)+c*f*(p+1))*(a*d*f*(n+p+4)-b*(d*e*(n+2)+c*f*(p+2))),0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(f_.*x_)^p_.,x_Symbol] :=
   a*Int[(a+b*x)^n*(c+d*x)^n*(f*x)^p,x] + b/f*Int[(a+b*x)^n*(c+d*x)^n*(f*x)^(p+1),x] /;
FreeQ[{a,b,c,d,f,m,n,p},x] && EqQ[b*c+a*d,0] && EqQ[m-n-1,0] && Not[RationalQ[p]] && Not[PositiveIntegerQ[m]] && NeQ[m+n+p+2,0]


Int[(e_.+f_.*x_)^p_./((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  Int[ExpandIntegrand[(e+f*x)^p/((a+b*x)*(c+d*x)),x],x] /;
FreeQ[{a,b,c,d,e,f},x] && IntegerQ[p]


Int[(e_.+f_.*x_)^p_./((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[(e+f*x)^(p-1)/(a+b*x),x] - 
  (d*e-c*f)/(b*c-a*d)*Int[(e+f*x)^(p-1)/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[p] && 0<p<1


Int[(e_.+f_.*x_)^p_/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  f*(e+f*x)^(p-1)/(b*d*(p-1)) + 
 1/(b*d)*Int[(b*d*e^2-a*c*f^2+f*(2*b*d*e-b*c*f-a*d*f)*x)*(e+f*x)^(p-2)/((a+b*x)*(c+d*x)),x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[p] && p>1


Int[(e_.+f_.*x_)^p_/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  f*(e+f*x)^(p+1)/((p+1)*(b*e-a*f)*(d*e-c*f)) + 
  1/((b*e-a*f)*(d*e-c*f))*Int[(b*d*e-b*c*f-a*d*f-b*d*f*x)*(e+f*x)^(p+1)/((a+b*x)*(c+d*x)),x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[p] && p<-1


Int[(e_.+f_.*x_)^p_/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  b/(b*c-a*d)*Int[(e+f*x)^p/(a+b*x),x] - 
  d/(b*c-a*d)*Int[(e+f*x)^p/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,p},x] && Not[IntegerQ[p]]


Int[(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_/(a_.+b_.*x_),x_Symbol] :=
  Int[ExpandIntegrand[(e+f*x)^FractionalPart[p],(c+d*x)^n*(e+f*x)^IntegerPart[p]/(a+b*x),x],x] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveIntegerQ[n] && FractionQ[p] && p<-1


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && IntegersQ[m,n] && (IntegerQ[p] || m>0 && n>=-1)


Int[(a_.+b_.*x_)^2*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (b*c-a*d)^2*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d^2*(d*e-c*f)*(n+1)) - 
  1/(d^2*(d*e-c*f)*(n+1))*Int[(c+d*x)^(n+1)*(e+f*x)^p*
    Simp[a^2*d^2*f*(n+p+2)+b^2*c*(d*e*(n+1)+c*f*(p+1))-2*a*b*d*(d*e*(n+1)+c*f*(p+1))-b^2*d*(d*e-c*f)*(n+1)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && (RationalQ[n] && n<-1 || EqQ[n+p+3,0] && NeQ[n,-1] && (SumSimplerQ[n,1] || Not[SumSimplerQ[p,1]]))


Int[(a_.+b_.*x_)^2*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(n+p+3)) + 
  1/(d*f*(n+p+3))*Int[(c+d*x)^n*(e+f*x)^p*
    Simp[a^2*d*f*(n+p+3)-b*(b*c*e+a*(d*e*(n+1)+c*f*(p+1)))+b*(a*d*f*(n+p+4)-b*(d*e*(n+2)+c*f*(p+2)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && NeQ[n+p+3,0]


Int[1/((a_.+b_.*x_)^(1/3)*(c_.+d_.*x_)^(2/3)*(e_.+f_.*x_)),x_Symbol] :=
  With[{q=Rt[(d*e-c*f)/(b*e-a*f),3]},
  -Sqrt[3]*q*ArcTan[1/Sqrt[3]+2*q*(a+b*x)^(1/3)/(Sqrt[3]*(c+d*x)^(1/3))]/(d*e-c*f) + 
  q*Log[e+f*x]/(2*(d*e-c*f)) - 
  3*q*Log[q*(a+b*x)^(1/3)-(c+d*x)^(1/3)]/(2*(d*e-c*f))] /;
FreeQ[{a,b,c,d,e,f},x]


Int[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]*(e_.+f_.*x_)),x_Symbol] :=
  b*f*Subst[Int[1/(d*(b*e-a*f)^2+b*f^2*x^2),x],x,Sqrt[a+b*x]*Sqrt[c+d*x]] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[2*b*d*e-f*(b*c+a*d),0]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_/(e_.+f_.*x_),x_Symbol] :=
  With[{q=Denominator[m]},
  q*Subst[Int[x^(q*(m+1)-1)/(b*e-a*f-(d*e-c*f)*x^q),x],x,(a+b*x)^(1/q)/(c+d*x)^(1/q)]] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[m+n+1,0] && RationalQ[m,n] && -1<m<0 && SimplerQ[a+b*x,c+d*x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^(p+1)/((m+1)*(b*e-a*f)) - 
  n*(d*e-c*f)/((m+1)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && EqQ[m+n+p+2,0] && RationalQ[n] && n>0 && Not[SumSimplerQ[p,1] && Not[SumSimplerQ[m,1]]]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && EqQ[Simplify[m+n+p+3],0] && EqQ[a*d*f*(m+1)+b*c*f*(n+1)+b*d*e*(p+1),0] && NeQ[m,-1]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  (a*d*f*(m+1)+b*c*f*(n+1)+b*d*e*(p+1))/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && EqQ[Simplify[m+n+p+3],0] && (RationalQ[m] && m<-1 || SumSimplerQ[m,1])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p/(b*(m+1)) - 
  1/(b*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^(p-1)*Simp[d*e*n+c*f*p+d*f*(n+p)*x,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[m,n,p] && m<-1 && n>0 && p>0 && (IntegersQ[2*m,2*n,2*p] || IntegersQ[m,n+p] || IntegersQ[p,m+n])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (b*c-a*d)*(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^(p+1)/(b*(b*e-a*f)*(m+1)) + 
  1/(b*(b*e-a*f)*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-2)*(e+f*x)^p*
    Simp[a*d*(d*e*(n-1)+c*f*(p+1))+b*c*(d*e*(m-n+2)-c*f*(m+p+2))+d*(a*d*f*(n+p)+b*(d*e*(m+1)-c*f*(m+n+p+1)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && RationalQ[m,n,p] && m<-1 && n>1 && (IntegersQ[2*m,2*n,2*p] || IntegersQ[m,n+p] || IntegersQ[p,m+n])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^(p+1)/((m+1)*(b*e-a*f)) - 
  1/((m+1)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^p*
    Simp[d*e*n+c*f*(m+p+2)+d*f*(m+n+p+2)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && RationalQ[m,n,p] && m<-1 && n>0 && (IntegersQ[2*m,2*n,2*p] || IntegersQ[m,n+p] || IntegersQ[p,m+n])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m-1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(m+n+p+1)) + 
  1/(d*f*(m+n+p+1))*Int[(a+b*x)^(m-2)*(c+d*x)^n*(e+f*x)^p*
    Simp[a^2*d*f*(m+n+p+1)-b*(b*c*e*(m-1)+a*(d*e*(n+1)+c*f*(p+1)))+b*(a*d*f*(2*m+n+p)-b*(d*e*(m+n)+c*f*(m+p)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && RationalQ[m] && m>1 && NeQ[m+n+p+1,0] && IntegerQ[m]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  (a+b*x)^m*(c+d*x)^n*(e+f*x)^(p+1)/(f*(m+n+p+1)) - 
  1/(f*(m+n+p+1))*Int[(a+b*x)^(m-1)*(c+d*x)^(n-1)*(e+f*x)^p*
    Simp[c*m*(b*e-a*f)+a*n*(d*e-c*f)+(d*m*(b*e-a*f)+b*n*(d*e-c*f))*x,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[m,n,p] && m>0 && n>0 && NeQ[m+n+p+1,0] && 
  (IntegersQ[2*m,2*n,2*p] || (IntegersQ[m,n+p] || IntegersQ[p,m+n]))


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m-1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(m+n+p+1)) + 
  1/(d*f*(m+n+p+1))*Int[(a+b*x)^(m-2)*(c+d*x)^n*(e+f*x)^p*
    Simp[a^2*d*f*(m+n+p+1)-b*(b*c*e*(m-1)+a*(d*e*(n+1)+c*f*(p+1)))+b*(a*d*f*(2*m+n+p)-b*(d*e*(m+n)+c*f*(m+p)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && RationalQ[m] && m>1 && NeQ[m+n+p+1,0] && IntegersQ[2*m,2*n,2*p]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[a*d*f*(m+1)-b*(d*e*(m+n+2)+c*f*(m+p+2))-b*d*f*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && RationalQ[m] && m<-1 && IntegerQ[m] && (IntegerQ[n] || IntegersQ[2*n,2*p])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[a*d*f*(m+1)-b*(d*e*(m+n+2)+c*f*(m+p+2))-b*d*f*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && RationalQ[m] && m<-1 && IntegersQ[2*m,2*n,2*p]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_/(e_.+f_.*x_),x_Symbol] :=
  b/f*Int[(a+b*x)^(m-1)*(c+d*x)^n,x] - (b*e-a*f)/f*Int[(a+b*x)^(m-1)*(c+d*x)^n/(e+f*x),x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && PositiveIntegerQ[Simplify[m+n+1]] && 
  (RationalQ[m] && m>0 || Not[RationalQ[m]] && (SumSimplerQ[m,-1] || Not[SumSimplerQ[n,-1]]))


(* Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  b/f*Int[(a+b*x)^(m-1)*(c+d*x)^n*(e+f*x)^(p+1),x] - (b*e-a*f)/f*Int[(a+b*x)^(m-1)*(c+d*x)^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && NegativeIntegerQ[p] && PositiveIntegerQ[m+n+p+2] && Not[SimplerQ[c+d*x,a+b*x]] *)


Int[1/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]*(e_.+f_.*x_)^(1/4)),x_Symbol] :=
  -4*Subst[Int[x^2/((b*e-a*f-b*x^4)*Sqrt[c-d*e/f+d*x^4/f]),x],x,(e+f*x)^(1/4)] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[-f/(d*e-c*f)]


Int[1/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]*(e_.+f_.*x_)^(1/4)),x_Symbol] :=
  Sqrt[-f*(c+d*x)/(d*e-c*f)]/Sqrt[c+d*x]*Int[1/((a+b*x)*Sqrt[-c*f/(d*e-c*f)-d*f*x/(d*e-c*f)]*(e+f*x)^(1/4)),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[PositiveQ[-f/(d*e-c*f)]]


Int[1/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]*(e_.+f_.*x_)^(3/4)),x_Symbol] :=
  -4*Subst[Int[1/((b*e-a*f-b*x^4)*Sqrt[c-d*e/f+d*x^4/f]),x],x,(e+f*x)^(1/4)] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[-f/(d*e-c*f)]


Int[1/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]*(e_.+f_.*x_)^(3/4)),x_Symbol] :=
  Sqrt[-f*(c+d*x)/(d*e-c*f)]/Sqrt[c+d*x]*Int[1/((a+b*x)*Sqrt[-c*f/(d*e-c*f)-d*f*x/(d*e-c*f)]*(e+f*x)^(3/4)),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[PositiveQ[-f/(d*e-c*f)]]


Int[Sqrt[e_+f_.*x_]/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  2*Sqrt[e]/b*Rt[-b/d,2]*EllipticE[ArcSin[Sqrt[b*x]/(Sqrt[c]*Rt[-b/d,2])],c*f/(d*e)] /;
FreeQ[{b,c,d,e,f},x] && NeQ[d*e-c*f,0] && PositiveQ[c] && PositiveQ[e] && Not[NegativeQ[-b/d]]


Int[Sqrt[e_+f_.*x_]/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  Sqrt[-b*x]/Sqrt[b*x]*Int[Sqrt[e+f*x]/(Sqrt[-b*x]*Sqrt[c+d*x]),x] /;
FreeQ[{b,c,d,e,f},x] && NeQ[d*e-c*f,0] && PositiveQ[c] && PositiveQ[e] && NegativeQ[-b/d]


Int[Sqrt[e_+f_.*x_]/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  Sqrt[e+f*x]*Sqrt[1+d*x/c]/(Sqrt[c+d*x]*Sqrt[1+f*x/e])*Int[Sqrt[1+f*x/e]/(Sqrt[b*x]*Sqrt[1+d*x/c]),x] /;
FreeQ[{b,c,d,e,f},x] && NeQ[d*e-c*f,0] && Not[PositiveQ[c] && PositiveQ[e]]


(* Int[Sqrt[e_.+f_.*x_]/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  f/b*Int[Sqrt[a+b*x]/(Sqrt[c+d*x]*Sqrt[e+f*x]),x] - 
  f/b*Int[1/(Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[b*e-f*(a-1),0] *)


(* Int[Sqrt[e_.+f_.*x_]/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  2/b*Rt[-(b*c-a*d)/d,2]*Sqrt[(b*e-a*f)/(b*c-a*d)]*
    EllipticE[ArcSin[Sqrt[a+b*x]/Rt[-(b*c-a*d)/d,2]],f*(b*c-a*d)/(d*(b*e-a*f))] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)] && Not[NegativeQ[-(b*c-a*d)/d]] && 
  Not[SimplerQ[c+d*x,a+b*x] && PositiveQ[-d/(b*c-a*d)] && PositiveQ[d/(d*e-c*f)] && Not[NegativeQ[(b*c-a*d)/b]]] *)


Int[Sqrt[e_.+f_.*x_]/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  2/b*Rt[-(b*e-a*f)/d,2]*EllipticE[ArcSin[Sqrt[a+b*x]/Rt[-(b*c-a*d)/d,2]],f*(b*c-a*d)/(d*(b*e-a*f))] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)] && Not[NegativeQ[-(b*c-a*d)/d]] && 
  Not[SimplerQ[c+d*x,a+b*x] && PositiveQ[-d/(b*c-a*d)] && PositiveQ[d/(d*e-c*f)] && Not[NegativeQ[(b*c-a*d)/b]]]


Int[Sqrt[e_.+f_.*x_]/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]),x_Symbol] :=
  Sqrt[e+f*x]*Sqrt[b*(c+d*x)/(b*c-a*d)]/(Sqrt[c+d*x]*Sqrt[b*(e+f*x)/(b*e-a*f)])*
    Int[Sqrt[b*e/(b*e-a*f)+b*f*x/(b*e-a*f)]/(Sqrt[a+b*x]*Sqrt[b*c/(b*c-a*d)+b*d*x/(b*c-a*d)]),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)]] && Not[NegativeQ[-(b*c-a*d)/d]]


Int[1/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  2/(b*Sqrt[e])*Rt[-b/d,2]*EllipticF[ArcSin[Sqrt[b*x]/(Sqrt[c]*Rt[-b/d,2])],c*f/(d*e)] /;
FreeQ[{b,c,d,e,f},x] && PositiveQ[c] && PositiveQ[e] && (PositiveQ[-b/d] || NegativeQ[-b/f])


Int[1/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  2/(b*Sqrt[e])*Rt[-b/d,2]*EllipticF[ArcSin[Sqrt[b*x]/(Sqrt[c]*Rt[-b/d,2])],c*f/(d*e)] /;
FreeQ[{b,c,d,e,f},x] && PositiveQ[c] && PositiveQ[e] && (PosQ[-b/d] || NegQ[-b/f])


Int[1/(Sqrt[b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  Sqrt[1+d*x/c]*Sqrt[1+f*x/e]/(Sqrt[c+d*x]*Sqrt[e+f*x])*Int[1/(Sqrt[b*x]*Sqrt[1+d*x/c]*Sqrt[1+f*x/e]),x] /;
FreeQ[{b,c,d,e,f},x] && Not[PositiveQ[c] && PositiveQ[e]]


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  2/b*Rt[-(b*c-a*d)/d,2]*Sqrt[b^2/((b*c-a*d)*(b*e-a*f))]*
    EllipticF[ArcSin[Sqrt[a+b*x]/Rt[-(b*c-a*d)/d,2]],f*(b*c-a*d)/(d*(b*e-a*f))] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)] && SimplerQ[a+b*x,c+d*x] && SimplerQ[a+b*x,e+f*x] && 
  (PositiveQ[-(b*c-a*d)/d] || NegativeQ[-(b*e-a*f)/f])


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  2/b*Rt[-(b*c-a*d)/d,2]*Sqrt[b^2/((b*c-a*d)*(b*e-a*f))]*
    EllipticF[ArcSin[Sqrt[a+b*x]/Rt[-(b*c-a*d)/d,2]],f*(b*c-a*d)/(d*(b*e-a*f))] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)] && SimplerQ[a+b*x,c+d*x] && SimplerQ[a+b*x,e+f*x] && 
  (PosQ[-(b*c-a*d)/d] || NegQ[-(b*e-a*f)/f])


Int[1/(Sqrt[a_+b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  Sqrt[b*(c+d*x)/(b*c-a*d)]*Sqrt[b*(e+f*x)/(b*e-a*f)]/(Sqrt[c+d*x]*Sqrt[e+f*x])*
    Int[1/(Sqrt[a+b*x]*Sqrt[b*c/(b*c-a*d)+b*d*x/(b*c-a*d)]*Sqrt[b*e/(b*e-a*f)+b*f*x/(b*e-a*f)]),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)]] && SimplerQ[a+b*x,c+d*x] && SimplerQ[a+b*x,e+f*x]


Int[1/((a_.+b_.*x_)*(c_.+d_.*x_)^(1/3)*(e_.+f_.*x_)^(1/3)),x_Symbol] :=
  With[{q=Rt[b*(b*e-a*f)/(b*c-a*d)^2,3]},
  -Log[a+b*x]/(2*q*(b*c-a*d)) - 
  Sqrt[3]*ArcTan[1/Sqrt[3]+2*q*(c+d*x)^(2/3)/(Sqrt[3]*(e+f*x)^(1/3))]/(2*q*(b*c-a*d)) + 
  3*Log[q*(c+d*x)^(2/3)-(e+f*x)^(1/3)]/(4*q*(b*c-a*d))] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[2*b*d*e-b*c*f-a*d*f,0]


Int[(a_.+b_.*x_)^m_/((c_.+d_.*x_)^(1/3)*(e_.+f_.*x_)^(1/3)),x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(2/3)*(e+f*x)^(2/3)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  f/(6*(m+1)*(b*c-a*d)*(b*e-a*f))*
    Int[(a+b*x)^(m+1)*(a*d*(3*m+1)-3*b*c*(3*m+5)-2*b*d*(3*m+7)*x)/((c+d*x)^(1/3)*(e+f*x)^(1/3)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[2*b*d*e-b*c*f-a*d*f,0] && IntegerQ[m] && m<-1


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(f_.*x_)^p_.,x_Symbol] :=
  Int[(a*c+b*d*x^2)^m*(f*x)^p,x] /;
FreeQ[{a,b,c,d,f,m,n,p},x] && EqQ[b*c+a*d,0] && EqQ[m-n,0] && PositiveQ[a] && PositiveQ[c]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(f_.*x_)^p_.,x_Symbol] :=
  (a+b*x)^FracPart[m]*(c+d*x)^FracPart[m]/(a*c+b*d*x^2)^FracPart[m]*Int[(a*c+b*d*x^2)^m*(f*x)^p,x] /;
FreeQ[{a,b,c,d,f,m,n,p},x] && EqQ[b*c+a*d,0] && EqQ[m-n,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(f_.*x_)^p_.,x_Symbol] :=
   Int[ExpandIntegrand[(a+b*x)^n*(c+d*x)^n*(f*x)^p,(a+b*x)^(m-n),x],x] /;
FreeQ[{a,b,c,d,f,m,n,p},x] && EqQ[b*c+a*d,0] && PositiveIntegerQ[m-n] && NeQ[m+n+p+2,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && (PositiveIntegerQ[m] || NegativeIntegerQ[m,n])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.,x_Symbol] :=
  b*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[a*d*f*(m+1)-b*(d*e*(m+n+2)+c*f*(m+p+2))-b*d*f*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && NegativeIntegerQ[m+n+p+2] && NeQ[m,-1] && 
  (SumSimplerQ[m,1] || Not[NeQ[n,-1] && SumSimplerQ[n,1]] && Not[NeQ[p,-1] && SumSimplerQ[p,1]])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_,x_Symbol] :=
  (b*c-a*d)^n*(a+b*x)^(m+1)/((m+1)*(b*e-a*f)^(n+1)*(e+f*x)^(m+1))*
    Hypergeometric2F1[m+1,-n,m+2,-(d*e-c*f)*(a+b*x)/((b*c-a*d)*(e+f*x))] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && EqQ[m+n+p+2,0] && NegativeIntegerQ[n]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^(p+1)/((b*e-a*f)*(m+1))*((b*e-a*f)*(c+d*x)/((b*c-a*d)*(e+f*x)))^(-n)*
    Hypergeometric2F1[m+1,-n,m+2,-(d*e-c*f)*(a+b*x)/((b*c-a*d)*(e+f*x))] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && EqQ[m+n+p+2,0] && Not[IntegerQ[n]]


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_*(e_+f_.*x_)^p_,x_Symbol] :=
  c^n*e^p*(b*x)^(m+1)/(b*(m+1))*AppellF1[m+1,-n,-p,m+2,-d*x/c,-f*x/e] /;
FreeQ[{b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && PositiveQ[c] && (IntegerQ[p] || PositiveQ[e])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_*(e_+f_.*x_)^p_,x_Symbol] :=
  (c+d*x)^(n+1)/(d*(n+1)*(-d/(b*c))^m*(d/(d*e-c*f))^p)*AppellF1[n+1,-m,-p,n+2,1+d*x/c,-f*(c+d*x)/(d*e-c*f)] /;
FreeQ[{b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && PositiveQ[-d/(b*c)] && (IntegerQ[p] || PositiveQ[d/(d*e-c*f)])


Int[(b_.*x_)^m_*(c_+d_.*x_)^n_*(e_+f_.*x_)^p_,x_Symbol] :=
  c^IntPart[n]*(c+d*x)^FracPart[n]/(1+d*x/c)^FracPart[n]*Int[(b*x)^m*(1+d*x/c)^n*(e+f*x)^p,x] /;
FreeQ[{b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[PositiveQ[c]]


Int[(a_+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (b*e-a*f)^p*(a+b*x)^(m+1)/(b^(p+1)*(m+1)*(b/(b*c-a*d))^n)*
    AppellF1[m+1,-n,-p,m+2,-d*(a+b*x)/(b*c-a*d),-f*(a+b*x)/(b*e-a*f)] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && IntegerQ[p] && PositiveQ[b/(b*c-a*d)] && 
  Not[PositiveQ[d/(d*a-c*b)] && SimplerQ[c+d*x,a+b*x]]


Int[(a_+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (c+d*x)^FracPart[n]/((b/(b*c-a*d))^IntPart[n]*(b*(c+d*x)/(b*c-a*d))^FracPart[n])*
    Int[(a+b*x)^m*(b*c/(b*c-a*d)+b*d*x/(b*c-a*d))^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && IntegerQ[p] && Not[PositiveQ[b/(b*c-a*d)]] && 
  Not[SimplerQ[c+d*x,a+b*x]]


Int[(a_+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (a+b*x)^(m+1)/(b*(m+1)*(b/(b*c-a*d))^n*(b/(b*e-a*f))^p)*AppellF1[m+1,-n,-p,m+2,-d*(a+b*x)/(b*c-a*d),-f*(a+b*x)/(b*e-a*f)] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[IntegerQ[p]] && 
  PositiveQ[b/(b*c-a*d)] && PositiveQ[b/(b*e-a*f)] && 
  Not[PositiveQ[d/(d*a-c*b)] && PositiveQ[d/(d*e-c*f)] && SimplerQ[c+d*x,a+b*x]] && 
  Not[PositiveQ[f/(f*a-e*b)] && PositiveQ[f/(f*c-e*d)] && SimplerQ[e+f*x,a+b*x]]


Int[(a_+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (e+f*x)^FracPart[p]/((b/(b*e-a*f))^IntPart[p]*(b*(e+f*x)/(b*e-a*f))^FracPart[p])*
    Int[(a+b*x)^m*(c+d*x)^n*(b*e/(b*e-a*f)+b*f*x/(b*e-a*f))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[IntegerQ[p]] && 
  PositiveQ[b/(b*c-a*d)] && Not[PositiveQ[b/(b*e-a*f)]]


Int[(a_+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_,x_Symbol] :=
  (c+d*x)^FracPart[n]/((b/(b*c-a*d))^IntPart[n]*(b*(c+d*x)/(b*c-a*d))^FracPart[n])*
    Int[(a+b*x)^m*(b*c/(b*c-a*d)+b*d*x/(b*c-a*d))^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && Not[IntegerQ[p]] && Not[PositiveQ[b/(b*c-a*d)]] && 
  Not[SimplerQ[c+d*x,a+b*x]] && Not[SimplerQ[e+f*x,a+b*x]]


Int[(a_.+b_.*u_)^m_.*(c_.+d_.*u_)^n_.*(e_+f_.*u_)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p,x],x,u] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && LinearQ[u,x] && NeQ[u-x,0]





(* ::Subsection::Closed:: *)
(*1.1.1.4 (a+b x)^m (c+d x)^n (e+f x)^p (g+h x)^q*)


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n*(e+f*x)*(g+h*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && (PositiveIntegerQ[m] || IntegersQ[m,n])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  (b^2*d*e*g-a^2*d*f*h*m-a*b*(d*(f*g+e*h)-c*f*h*(m+1))+b*f*h*(b*c-a*d)*(m+1)*x)*(a+b*x)^(m+1)*(c+d*x)^(n+1)/
    (b^2*d*(b*c-a*d)*(m+1)) + 
  (a*d*f*h*m+b*(d*(f*g+e*h)-c*f*h*(m+2)))/(b^2*d)*Int[(a+b*x)^(m+1)*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && EqQ[m+n+2,0] && NeQ[m,-1] && Not[SumSimplerQ[n,1] && Not[SumSimplerQ[m,1]]]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  (b^2*c*d*e*g*(n+1)+a^2*c*d*f*h*(n+1)+a*b*(d^2*e*g*(m+1)+c^2*f*h*(m+1)-c*d*(f*g+e*h)*(m+n+2))+
      (a^2*d^2*f*h*(n+1)-a*b*d^2*(f*g+e*h)*(n+1)+b^2*(c^2*f*h*(m+1)-c*d*(f*g+e*h)*(m+1)+d^2*e*g*(m+n+2)))*x)/
    (b*d*(b*c-a*d)^2*(m+1)*(n+1))*(a+b*x)^(m+1)*(c+d*x)^(n+1) - 
  (a^2*d^2*f*h*(2+3*n+n^2)+a*b*d*(n+1)*(2*c*f*h*(m+1)-d*(f*g+e*h)*(m+n+3))+
      b^2*(c^2*f*h*(2+3*m+m^2)-c*d*(f*g+e*h)*(m+1)*(m+n+3)+d^2*e*g*(6+m^2+5*n+n^2+m*(2*n+5))))/
    (b*d*(b*c-a*d)^2*(m+1)*(n+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && RationalQ[m,n] && m<-1 && n<-1


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  (b^3*c*e*g*(m+2)-a^3*d*f*h*(n+2)-a^2*b*(c*f*h*m-d*(f*g+e*h)*(m+n+3))-a*b^2*(c*(f*g+e*h)+d*e*g*(2*m+n+4))+
      b*(a^2*d*f*h*(m-n)-a*b*(2*c*f*h*(m+1)-d*(f*g+e*h)*(n+1))+b^2*(c*(f*g+e*h)*(m+1)-d*e*g*(m+n+2)))*x)/
    (b^2*(b*c-a*d)^2*(m+1)*(m+2))*(a+b*x)^(m+1)*(c+d*x)^(n+1) + 
  (f*h/b^2-(d*(m+n+3)*(a^2*d*f*h*(m-n)-a*b*(2*c*f*h*(m+1)-d*(f*g+e*h)*(n+1))+b^2*(c*(f*g+e*h)*(m+1)-d*e*g*(m+n+2))))/
      (b^2*(b*c-a*d)^2*(m+1)*(m+2)))*
    Int[(a+b*x)^(m+2)*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && (RationalQ[m] && m<-2 || EqQ[m+n+3,0] && Not[RationalQ[n] && n<-2])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_.*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  (a^2*d*f*h*(n+2)+b^2*d*e*g*(m+n+3)+a*b*(c*f*h*(m+1)-d*(f*g+e*h)*(m+n+3))+b*f*h*(b*c-a*d)*(m+1)*x)/
    (b^2*d*(b*c-a*d)*(m+1)*(m+n+3))*(a+b*x)^(m+1)*(c+d*x)^(n+1) - 
  (a^2*d^2*f*h*(n+1)*(n+2)+a*b*d*(n+1)*(2*c*f*h*(m+1)-d*(f*g+e*h)*(m+n+3))+
      b^2*(c^2*f*h*(m+1)*(m+2)-c*d*(f*g+e*h)*(m+1)*(m+n+3)+d^2*e*g*(m+n+2)*(m+n+3)))/
    (b^2*d*(b*c-a*d)*(m+1)*(m+n+3))*Int[(a+b*x)^(m+1)*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && (RationalQ[m] && -2<=m<-1 || SumSimplerQ[m,1]) && NeQ[m,-1] && NeQ[m+n+3,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_+f_.*x_)*(g_.+h_.*x_),x_Symbol] :=
  -(a*d*f*h*(n+2)+b*c*f*h*(m+2)-b*d*(f*g+e*h)*(m+n+3)-b*d*f*h*(m+n+2)*x)*(a+b*x)^(m+1)*(c+d*x)^(n+1)/
    (b^2*d^2*(m+n+2)*(m+n+3)) + 
  (a^2*d^2*f*h*(n+1)*(n+2)+a*b*d*(n+1)*(2*c*f*h*(m+1)-d*(f*g+e*h)*(m+n+3))+
      b^2*(c^2*f*h*(m+1)*(m+2)-c*d*(f*g+e*h)*(m+1)*(m+n+3)+d^2*e*g*(m+n+2)*(m+n+3)))/
    (b^2*d^2*(m+n+2)*(m+n+3))*Int[(a+b*x)^m*(c+d*x)^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && NeQ[m+n+2,0] && NeQ[m+n+3,0]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,m},x] && (IntegersQ[m,n,p] || PositiveIntegerQ[n,p])


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  (b*g-a*h)*(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^(p+1)/(b*(b*e-a*f)*(m+1)) - 
  1/(b*(b*e-a*f)*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^p*
    Simp[b*c*(f*g-e*h)*(m+1)+(b*g-a*h)*(d*e*n+c*f*(p+1))+d*(b*(f*g-e*h)*(m+1)+f*(b*g-a*h)*(n+p+1))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,p},x] && RationalQ[m,n] && m<-1 && n>0 && IntegerQ[m]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  (b*g-a*h)*(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^(p+1)/(b*(b*e-a*f)*(m+1)) - 
  1/(b*(b*e-a*f)*(m+1))*Int[(a+b*x)^(m+1)*(c+d*x)^(n-1)*(e+f*x)^p*
    Simp[b*c*(f*g-e*h)*(m+1)+(b*g-a*h)*(d*e*n+c*f*(p+1))+d*(b*(f*g-e*h)*(m+1)+f*(b*g-a*h)*(n+p+1))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,p},x] && RationalQ[m,n] && m<-1 && n>0 && IntegersQ[2*m,2*n,2*p]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  (b*g-a*h)*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[(a*d*f*g-b*(d*e+c*f)*g+b*c*e*h)*(m+1)-(b*g-a*h)*(d*e*(n+1)+c*f*(p+1))-d*f*(b*g-a*h)*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x] && RationalQ[m] && m<-1 && IntegerQ[m]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  (b*g-a*h)*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[(a*d*f*g-b*(d*e+c*f)*g+b*c*e*h)*(m+1)-(b*g-a*h)*(d*e*(n+1)+c*f*(p+1))-d*f*(b*g-a*h)*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x] && RationalQ[m] && m<-1 && IntegersQ[2*m,2*n,2*p]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  h*(a+b*x)^m*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(m+n+p+2)) + 
  1/(d*f*(m+n+p+2))*Int[(a+b*x)^(m-1)*(c+d*x)^n*(e+f*x)^p*
    Simp[a*d*f*g*(m+n+p+2)-h*(b*c*e*m+a*(d*e*(n+1)+c*f*(p+1)))+(b*d*f*g*(m+n+p+2)+h*(a*d*f*m-b*(d*e*(m+n+1)+c*f*(m+p+1))))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x] && RationalQ[m] && m>0 && NeQ[m+n+p+2,0] && IntegerQ[m]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  h*(a+b*x)^m*(c+d*x)^(n+1)*(e+f*x)^(p+1)/(d*f*(m+n+p+2)) + 
  1/(d*f*(m+n+p+2))*Int[(a+b*x)^(m-1)*(c+d*x)^n*(e+f*x)^p*
    Simp[a*d*f*g*(m+n+p+2)-h*(b*c*e*m+a*(d*e*(n+1)+c*f*(p+1)))+(b*d*f*g*(m+n+p+2)+h*(a*d*f*m-b*(d*e*(m+n+1)+c*f*(m+p+1))))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x] && RationalQ[m] && m>0 && NeQ[m+n+p+2,0] && IntegersQ[2*m,2*n,2*p]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  (b*g-a*h)*(a+b*x)^(m+1)*(c+d*x)^(n+1)*(e+f*x)^(p+1)/((m+1)*(b*c-a*d)*(b*e-a*f)) + 
  1/((m+1)*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*
    Simp[(a*d*f*g-b*(d*e+c*f)*g+b*c*e*h)*(m+1)-(b*g-a*h)*(d*e*(n+1)+c*f*(p+1))-d*f*(b*g-a*h)*(m+n+p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x] && NegativeIntegerQ[m+n+p+2] && NeQ[m,-1] && 
  (SumSimplerQ[m,1] || Not[NeQ[n,-1] && SumSimplerQ[n,1]] && Not[NeQ[p,-1] && SumSimplerQ[p,1]])


Int[(e_.+f_.*x_)^p_*(g_.+h_.*x_)/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  (b*g-a*h)/(b*c-a*d)*Int[(e+f*x)^p/(a+b*x),x] - 
  (d*g-c*h)/(b*c-a*d)*Int[(e+f*x)^p/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_)/(a_.+b_.*x_),x_Symbol] :=
  h/b*Int[(c+d*x)^n*(e+f*x)^p,x] + (b*g-a*h)/b*Int[(c+d*x)^n*(e+f*x)^p/(a+b*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p},x]


Int[(g_.+h_.*x_)/(Sqrt[a_.+b_.*x_]*Sqrt[c_+d_.*x_]*Sqrt[e_+f_.*x_]),x_Symbol] :=
  h/f*Int[Sqrt[e+f*x]/(Sqrt[a+b*x]*Sqrt[c+d*x]),x] + (f*g-e*h)/f*Int[1/(Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && SimplerQ[a+b*x,e+f*x] && SimplerQ[c+d*x,e+f*x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_),x_Symbol] :=
  h/b*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p,x] + (b*g-a*h)/b*Int[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p},x] && (SumSimplerQ[m,1] || Not[SumSimplerQ[n,1]] && Not[SumSimplerQ[p,1]])


Int[(e_.+f_.*x_)^p_*(g_.+h_.*x_)^q_/((a_.+b_.*x_)*(c_.+d_.*x_)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[(e+f*x)^(p-1)*(g+h*x)^q/(a+b*x),x] - 
  (d*e-c*f)/(b*c-a*d)*Int[(e+f*x)^(p-1)*(g+h*x)^q/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,q},x] && RationalQ[p] && 0<p<1


Int[1/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  -2*Sqrt[d*(e+f*x)/(d*e-c*f)]*Sqrt[d*(g+h*x)/(d*g-c*h)]/((b*c-a*d)*Sqrt[-f/(d*e-c*f)]*Sqrt[e+f*x]*Sqrt[g+h*x])*
    EllipticPi[-b*(d*e-c*f)/(f*(b*c-a*d)),ArcSin[Sqrt[-f/(d*e-c*f)]*Sqrt[c+d*x]],h*(d*e-c*f)/(f*(d*g-c*h))] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[(c_.+d_.*x_)^n_/((a_.+b_.*x_)*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  Int[ExpandIntegrand[1/(Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),(c+d*x)^(n+1/2)/(a+b*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && IntegerQ[n+1/2]


Int[Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]/((a_.+b_.*x_)*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  (b*e-a*f)*(b*g-a*h)/b^2*Int[1/((a+b*x)*Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),x] + 
  1/b^2*Int[(b*f*g+b*e*h-a*f*h+b*f*h*x)/(Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[1/(Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  -2*(a+b*x)*Sqrt[(b*g-a*h)*(c+d*x)/((d*g-c*h)*(a+b*x))]*Sqrt[(b*g-a*h)*(e+f*x)/((f*g-e*h)*(a+b*x))]/
    ((b*g-a*h)*Sqrt[c+d*x]*Sqrt[e+f*x])*
    Subst[Int[1/(Sqrt[1+(b*c-a*d)*x^2/(d*g-c*h)]*Sqrt[1+(b*e-a*f)*x^2/(f*g-e*h)]),x],x,Sqrt[g+h*x]/Sqrt[a+b*x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[Sqrt[c_.+d_.*x_]/((a_.+b_.*x_)^(3/2)*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  -2*(d*g-c*h)*(a+b*x)*Sqrt[(b*g-a*h)*(c+d*x)/((d*g-c*h)*(a+b*x))]*
    Sqrt[(b*g-a*h)*(e+f*x)/((f*g-e*h)*(a+b*x))]/((b*g-a*h)^2*Sqrt[c+d*x]*Sqrt[e+f*x])*
    Subst[Int[Sqrt[1+(b*c-a*d)*x^2/(d*g-c*h)]/Sqrt[1+(b*e-a*f)*x^2/(f*g-e*h)],x],x,Sqrt[g+h*x]/Sqrt[a+b*x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[Sqrt[a_.+b_.*x_]/(Sqrt[c_.+d_.*x_]*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  2*(a+b*x)*Sqrt[(b*g-a*h)*(c+d*x)/((d*g-c*h)*(a+b*x))]*Sqrt[(b*g-a*h)*(e+f*x)/((f*g-e*h)*(a+b*x))]/(Sqrt[c+d*x]*Sqrt[e+f*x])*
    Subst[Int[1/((h-b*x^2)*Sqrt[1+(b*c-a*d)*x^2/(d*g-c*h)]*Sqrt[1+(b*e-a*f)*x^2/(f*g-e*h)]),x],x,Sqrt[g+h*x]/Sqrt[a+b*x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[1/((a_.+b_.*x_)^(3/2)*Sqrt[c_.+d_.*x_]*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  -d/(b*c-a*d)*Int[1/(Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),x] + 
  b/(b*c-a*d)*Int[Sqrt[c+d*x]/((a+b*x)^(3/2)*Sqrt[e+f*x]*Sqrt[g+h*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[Sqrt[a_.+b_.*x_]*Sqrt[c_.+d_.*x_]/(Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[g+h*x]/(h*Sqrt[e+f*x]) + 
  (d*e-c*f)*(b*f*g+b*e*h-2*a*f*h)/(2*f^2*h)*Int[1/(Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),x] + 
  (a*d*f*h-b*(d*f*g+d*e*h-c*f*h))/(2*f^2*h)*Int[Sqrt[e+f*x]/(Sqrt[a+b*x]*Sqrt[c+d*x]*Sqrt[g+h*x]),x] - 
  (d*e-c*f)*(f*g-e*h)/(2*f*h)*Int[Sqrt[a+b*x]/(Sqrt[c+d*x]*(e+f*x)^(3/2)*Sqrt[g+h*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[(a_.+b_.*x_)^(3/2)/(Sqrt[c_.+d_.*x_]*Sqrt[e_.+f_.*x_]*Sqrt[g_.+h_.*x_]),x_Symbol] :=
  b/d*Int[Sqrt[a+b*x]*Sqrt[c+d*x]/(Sqrt[e+f*x]*Sqrt[g+h*x]),x] - 
  (b*c-a*d)/d*Int[Sqrt[a+b*x]/(Sqrt[c+d*x]*Sqrt[e+f*x]*Sqrt[g+h*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_)^q_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^q,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && IntegersQ[p,q]


Int[(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_)^q_,x_Symbol] :=
  h/b*Int[(a+b*x)^(m+1)*(c+d*x)^n*(e+f*x)^p*(g+h*x)^(q-1),x] + 
  (b*g-a*h)/b*Int[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^(q-1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p},x] && PositiveIntegerQ[q] && 
  (SumSimplerQ[m,1] || Not[SumSimplerQ[n,1]] && Not[SumSimplerQ[p,1]])


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*(e_.+f_.*x_)^p_.*(g_.+h_.*x_)^q_.,x_Symbol] :=
  Defer[Int][(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p,q},x]


Int[(a_.+b_.*u_)^m_.*(c_.+d_.*u_)^n_.*(e_.+f_.*u_)^p_.*(g_.+h_.*u_)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^q,x],x,u] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p,q},x] && LinearQ[u,x] && NeQ[u-x,0]


Int[(i_.*(a_.+b_.*x_)^m_*(c_.+d_.*x_)^n_*(e_.+f_.*x_)^p_*(g_.+h_.*x_)^q_)^r_,x_Symbol] :=
  (i*(a+b*x)^m*(c+d*x)^n*(e+f*x)^p*(g+h*x)^q)^r/((a+b*x)^(m*r)*(c+d*x)^(n*r)*(e+f*x)^(p*r)*(g+h*x)^(q*r))*
    Int[(a+b*x)^(m*r)*(c+d*x)^(n*r)*(e+f*x)^(p*r)*(g+h*x)^(q*r),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,m,n,p,q,r},x]


Int[u_^m_,x_Symbol] :=
  Int[ExpandToSum[u,x]^m,x] /;
FreeQ[m,x] && LinearQ[u,x] && Not[LinearMatchQ[u,x]]


Int[u_^m_.*v_^n_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n,x] /;
FreeQ[{m,n},x] && LinearQ[{u,v},x] && Not[LinearMatchQ[{u,v},x]]


Int[u_^m_.*v_^n_.*w_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n*ExpandToSum[w,x]^p,x] /;
FreeQ[{m,n,p},x] && LinearQ[{u,v,w},x] && Not[LinearMatchQ[{u,v,w},x]]


Int[u_^m_.*v_^n_.*w_^p_.*z_^q_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n*ExpandToSum[w,x]^p*ExpandToSum[z,x]^q,x] /;
FreeQ[{m,n,p,q},x] && LinearQ[{u,v,w,z},x] && Not[LinearMatchQ[{u,v,w,z},x]]



`)

func resourcesRubi111LinearBinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi111LinearBinomialProductsM, nil
}

func resourcesRubi111LinearBinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi111LinearBinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.1.1 Linear binomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi113GeneralBinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.1.3 General Binomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.1.3.1 (a+b x^n)^p*)


Int[(b_.*x_^n_)^p_,x_Symbol] :=
  b^IntPart[p]*(b*x^n)^FracPart[p]/x^(n*FracPart[p])*Int[x^(n*p),x] /;
FreeQ[{b,n,p},x]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(1/n-1)*(a+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,p},x] && FractionQ[n] && IntegerQ[1/n]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x*(a+b*x^n)^(p+1)/a /;
FreeQ[{a,b,n,p},x] && EqQ[1/n+p+1,0]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -x*(a+b*x^n)^(p+1)/(a*n*(p+1)) +
  (n*(p+1)+1)/(a*n*(p+1))*Int[(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,n,p},x] && ILtQ[Simplify[1/n+p+1],0] && NeQ[p,-1]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Int[x^(n*p)*(b+a*x^(-n))^p,x] /;
FreeQ[{a,b},x] && LtQ[n,0] && IntegerQ[p]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p,x],x] /;
FreeQ[{a,b},x] && IGtQ[n,0] && IGtQ[p,0]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x*(a+b*x^n)^p/(n*p+1) +
  a*n*p/(n*p+1)*Int[(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b},x] && IGtQ[n,0] && GtQ[p,0] && 
  (IntegerQ[2*p] || n==2 && IntegerQ[4*p] || n==2 && IntegerQ[3*p] || Denominator[p+1/n]<Denominator[p])


Int[1/(a_+b_.*x_^2)^(5/4),x_Symbol] :=
  2/(a^(5/4)*Rt[b/a,2])*EllipticE[1/2*ArcTan[Rt[b/a,2]*x],2] /;
FreeQ[{a,b},x] && PosQ[b/a] && PositiveQ[a]


Int[1/(a_+b_.*x_^2)^(5/4),x_Symbol] :=
  (1+b*x^2/a)^(1/4)/(a*(a+b*x^2)^(1/4))*Int[1/(1+b*x^2/a)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a] && Not[PositiveQ[a]]


Int[1/(a_+b_.*x_^2)^(7/6),x_Symbol] :=
  1/((a +b*x^2)^(2/3)*(a/(a+b*x^2))^(2/3))*Subst[Int[1/(1-b*x^2)^(1/3),x],x,x/Sqrt[a+b*x^2]] /;
FreeQ[{a,b},x]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -x*(a+b*x^n)^(p+1)/(a*n*(p+1)) +
  (n*(p+1)+1)/(a*n*(p+1))*Int[(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b},x] && IGtQ[n,0] && LtQ[p,-1] && 
  (IntegerQ[2*p] || n==2 && IntegerQ[4*p] || n==2 && IntegerQ[3*p] || Denominator[p+1/n]<Denominator[p])


Int[1/(a_+b_.*x_^3),x_Symbol] :=
  1/(3*Rt[a,3]^2)*Int[1/(Rt[a,3]+Rt[b,3]*x),x] + 
  1/(3*Rt[a,3]^2)*Int[(2*Rt[a,3]-Rt[b,3]*x)/(Rt[a,3]^2-Rt[a,3]*Rt[b,3]*x+Rt[b,3]^2*x^2),x] /;
FreeQ[{a,b},x]


(* Int[1/(a_+b_.*x_^5),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,5]], s=Denominator[Rt[a/b,5]]},
  r/(5*a)*Int[1/(r+s*x),x] + 
  2*r/(5*a)*Int[(r-1/4*(1-Sqrt[5])*s*x)/(r^2-1/2*(1-Sqrt[5])*r*s*x+s^2*x^2),x] + 
  2*r/(5*a)*Int[(r-1/4*(1+Sqrt[5])*s*x)/(r^2-1/2*(1+Sqrt[5])*r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b},x] && PosQ[a/b] *)


(* Int[1/(a_+b_.*x_^5),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,5]], s=Denominator[Rt[-a/b,5]]},
  r/(5*a)*Int[1/(r-s*x),x] + 
  2*r/(5*a)*Int[(r+1/4*(1-Sqrt[5])*s*x)/(r^2+1/2*(1-Sqrt[5])*r*s*x+s^2*x^2),x] + 
  2*r/(5*a)*Int[(r+1/4*(1+Sqrt[5])*s*x)/(r^2+1/2*(1+Sqrt[5])*r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b},x] && NegQ[a/b] *)


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[a/b,n]], s=Denominator[Rt[a/b,n]], k, u},
  u=Int[(r-s*Cos[(2*k-1)*Pi/n]*x)/(r^2-2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  r/(a*n)*Int[1/(r+s*x),x] + Dist[2*r/(a*n),Sum[u,{k,1,(n-1)/2}],x]] /;
FreeQ[{a,b},x] && IGtQ[(n-3)/2,0] && PosQ[a/b]


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[-a/b,n]], s=Denominator[Rt[-a/b,n]], k, u},
  u=Int[(r+s*Cos[(2*k-1)*Pi/n]*x)/(r^2+2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  r/(a*n)*Int[1/(r-s*x),x] + Dist[2*r/(a*n),Sum[u,{k,1,(n-1)/2}],x]] /;
FreeQ[{a,b},x] && IGtQ[(n-3)/2,0] && NegQ[a/b]


Int[1/(a_+b_.*x_^2),x_Symbol] :=
  1/(Rt[a,2]*Rt[b,2])*ArcTan[Rt[b,2]*x/Rt[a,2]] /;
FreeQ[{a,b},x] && PosQ[a/b] && (PositiveQ[a] || PositiveQ[b])


Int[1/(a_+b_.*x_^2),x_Symbol] :=
  -1/(Rt[-a,2]*Rt[-b,2])*ArcTan[Rt[-b,2]*x/Rt[-a,2]] /;
FreeQ[{a,b},x] && PosQ[a/b] && (NegativeQ[a] || NegativeQ[b])


Int[1/(a_+b_.*x_^2),x_Symbol] :=
(*Rt[b/a,2]/b*ArcTan[Rt[b/a,2]*x] /; *)
  Rt[a/b,2]/a*ArcTan[x/Rt[a/b,2]] /;
FreeQ[{a,b},x] && PosQ[a/b]


Int[1/(a_+b_.*x_^2),x_Symbol] :=
  1/(Rt[a,2]*Rt[-b,2])*ArcTanh[Rt[-b,2]*x/Rt[a,2]] /;
FreeQ[{a,b},x] && NegQ[a/b] && (PositiveQ[a] || NegativeQ[b])


Int[1/(a_+b_.*x_^2),x_Symbol] :=
  -1/(Rt[-a,2]*Rt[b,2])*ArcTanh[Rt[b,2]*x/Rt[-a,2]] /;
FreeQ[{a,b},x] && NegQ[a/b] && (NegativeQ[a] || PositiveQ[b])


Int[1/(a_+b_.*x_^2),x_Symbol] :=
(*-Rt[-b/a,2]/b*ArcTanh[Rt[-b/a,2]*x] /; *)
  Rt[-a/b,2]/a*ArcTanh[x/Rt[-a/b,2]] /;
FreeQ[{a,b},x] && NegQ[a/b]


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[a/b,n]], s=Denominator[Rt[a/b,n]], k, u, v},
  u=Int[(r-s*Cos[(2*k-1)*Pi/n]*x)/(r^2-2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x] + 
    Int[(r+s*Cos[(2*k-1)*Pi/n]*x)/(r^2+2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  2*r^2/(a*n)*Int[1/(r^2+s^2*x^2),x] + Dist[2*r/(a*n),Sum[u,{k,1,(n-2)/4}],x]] /;
FreeQ[{a,b},x] && IGtQ[(n-2)/4,0] && PosQ[a/b]


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[-a/b,n]], s=Denominator[Rt[-a/b,n]], k, u},
  u=Int[(r-s*Cos[(2*k*Pi)/n]*x)/(r^2-2*r*s*Cos[(2*k*Pi)/n]*x+s^2*x^2),x] + 
    Int[(r+s*Cos[(2*k*Pi)/n]*x)/(r^2+2*r*s*Cos[(2*k*Pi)/n]*x+s^2*x^2),x];
  2*r^2/(a*n)*Int[1/(r^2-s^2*x^2),x] + Dist[2*r/(a*n),Sum[u,{k,1,(n-2)/4}],x]] /;
FreeQ[{a,b},x] && IGtQ[(n-2)/4,0] && NegQ[a/b]


Int[1/(a_+b_.*x_^4),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,2]], s=Denominator[Rt[a/b,2]]},
  1/(2*r)*Int[(r-s*x^2)/(a+b*x^4),x] + 1/(2*r)*Int[(r+s*x^2)/(a+b*x^4),x]] /;
FreeQ[{a,b},x] && (PositiveQ[a/b] || PosQ[a/b] && AtomQ[SplitProduct[SumBaseQ,a]] && AtomQ[SplitProduct[SumBaseQ,b]])


Int[1/(a_+b_.*x_^4),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  r/(2*a)*Int[1/(r-s*x^2),x] + r/(2*a)*Int[1/(r+s*x^2),x]] /;
FreeQ[{a,b},x] && Not[PositiveQ[a/b]]


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,4]], s=Denominator[Rt[a/b,4]]},
  r/(2*Sqrt[2]*a)*Int[(Sqrt[2]*r-s*x^(n/4))/(r^2-Sqrt[2]*r*s*x^(n/4)+s^2*x^(n/2)),x] + 
  r/(2*Sqrt[2]*a)*Int[(Sqrt[2]*r+s*x^(n/4))/(r^2+Sqrt[2]*r*s*x^(n/4)+s^2*x^(n/2)),x]] /;
FreeQ[{a,b},x] && IGtQ[n/4,1] && PositiveQ[a/b]


Int[1/(a_+b_.*x_^n_),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  r/(2*a)*Int[1/(r-s*x^(n/2)),x] + r/(2*a)*Int[1/(r+s*x^(n/2)),x]] /;
FreeQ[{a,b},x] && IGtQ[n/4,1] && Not[PositiveQ[a/b]]


Int[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  ArcSinh[Rt[b,2]*x/Sqrt[a]]/Rt[b,2] /;
FreeQ[{a,b},x] && PositiveQ[a] && PosQ[b]


Int[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  ArcSin[Rt[-b,2]*x/Sqrt[a]]/Rt[-b,2] /;
FreeQ[{a,b},x] && PositiveQ[a] && NegQ[b]


Int[1/Sqrt[a_+b_.*x_^2],x_Symbol] :=
  Subst[Int[1/(1-b*x^2),x],x,x/Sqrt[a+b*x^2]] /;
FreeQ[{a,b},x] && Not[PositiveQ[a]]


(* Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -Sqrt[2]*(1+Sqrt[3])*(1+Sqrt[3]+q*x)^2*Sqrt[(1+q^3*x^3)/(1+Sqrt[3]+q*x)^4]/(3^(1/4)*q*Sqrt[a+b*x^3])*
    EllipticF[ArcSin[(-1+Sqrt[3]-q*x)/(1+Sqrt[3]+q*x)],-7-4*Sqrt[3]]] /;
FreeQ[{a,b},x] && PosQ[a] *)


(* Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[a/b,3]},
  2*Sqrt[2+Sqrt[3]]*(q+x)*Sqrt[(q^2-q*x+x^2)/((1+Sqrt[3])*q+x)^2]/
    (3^(1/4)*Sqrt[a+b*x^3]*Sqrt[q*(q+x)/((1+Sqrt[3])*q+x)^2])*
    EllipticF[ArcSin[((1-Sqrt[3])*q+x)/((1+Sqrt[3])*q+x)],-7-4*Sqrt[3]]] /;
FreeQ[{a,b},x] && PosQ[a] && EqQ[b^2,1] *)


(* Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -2*Sqrt[2+Sqrt[3]]*(1+q*x)*Sqrt[(1-q*x+q^2*x^2)/(1+Sqrt[3]+q*x)^2]/
    (3^(1/4)*q*Sqrt[a+b*x^3]*Sqrt[(1+q*x)/(1+Sqrt[3]+q*x)^2])*
    EllipticF[ArcSin[(-1+Sqrt[3]-q*x)/(1+Sqrt[3]+q*x)],-7-4*Sqrt[3]]] /;
FreeQ[{a,b},x] && PosQ[a] *)


Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  2*Sqrt[2+Sqrt[3]]*(s+r*x)*Sqrt[(s^2-r*s*x+r^2*x^2)/((1+Sqrt[3])*s+r*x)^2]/
    (3^(1/4)*r*Sqrt[a+b*x^3]*Sqrt[s*(s+r*x)/((1+Sqrt[3])*s+r*x)^2])*
    EllipticF[ArcSin[((1-Sqrt[3])*s+r*x)/((1+Sqrt[3])*s+r*x)],-7-4*Sqrt[3]]] /;
FreeQ[{a,b},x] && PosQ[a]


(* Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[a/b,3]},
  2*Sqrt[2-Sqrt[3]]*(q+x)*Sqrt[(q^2-q*x+x^2)/((1-Sqrt[3])*q+x)^2]/
    (3^(1/4)*Sqrt[a+b*x^3]*Sqrt[-q*(q+x)/((1-Sqrt[3])*q+x)^2])*
    EllipticF[ArcSin[((1+Sqrt[3])*q+x)/((1-Sqrt[3])*q+x)],-7+4*Sqrt[3]]] /;
FreeQ[{a,b},x] && NegQ[a] && EqQ[b^2,1] *)


(* Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -2*Sqrt[2-Sqrt[3]]*(1+q*x)*Sqrt[(1-q*x+q^2*x^2)/(1-Sqrt[3]+q*x)^2]/
    (3^(1/4)*q*Sqrt[a+b*x^3]*Sqrt[-(1+q*x)/(1-Sqrt[3]+q*x)^2])*
    EllipticF[ArcSin[(1+Sqrt[3]+q*x)/(-1+Sqrt[3]-q*x)],-7+4*Sqrt[3]]] /;
FreeQ[{a,b},x] && NegQ[a] *)


Int[1/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  2*Sqrt[2-Sqrt[3]]*(s+r*x)*Sqrt[(s^2-r*s*x+r^2*x^2)/((1-Sqrt[3])*s+r*x)^2]/
    (3^(1/4)*r*Sqrt[a+b*x^3]*Sqrt[-s*(s+r*x)/((1-Sqrt[3])*s+r*x)^2])*
    EllipticF[ArcSin[((1+Sqrt[3])*s+r*x)/((1-Sqrt[3])*s+r*x)],-7+4*Sqrt[3]]] /;
FreeQ[{a,b},x] && NegQ[a]


Int[1/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[b/a,4]},
  (1+q^2*x^2)*Sqrt[(a+b*x^4)/(a*(1+q^2*x^2)^2)]/(2*q*Sqrt[a+b*x^4])*EllipticF[2*ArcTan[q*x],1/2]] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[1/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  EllipticF[ArcSin[Rt[-b,4]*x/Rt[a,4]],-1]/(Rt[a,4]*Rt[-b,4]) /;
FreeQ[{a,b},x] && NegQ[b/a] && PositiveQ[a]


Int[1/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*b,2]},
  Sqrt[-a+q*x^2]*Sqrt[(a+q*x^2)/q]/(Sqrt[2]*Sqrt[-a]*Sqrt[a+b*x^4])*
    EllipticF[ArcSin[x/Sqrt[(a+q*x^2)/(2*q)]],1/2] /;
  IntegerQ[q]] /;
FreeQ[{a,b},x] && NegativeQ[a] && PositiveQ[b]


Int[1/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*b,2]},
  Sqrt[(a-q*x^2)/(a+q*x^2)]*Sqrt[(a+q*x^2)/q]/(Sqrt[2]*Sqrt[a+b*x^4]*Sqrt[a/(a+q*x^2)])*
    EllipticF[ArcSin[x/Sqrt[(a+q*x^2)/(2*q)]],1/2]] /;
FreeQ[{a,b},x] && NegativeQ[a] && PositiveQ[b]


Int[1/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  Sqrt[1+b*x^4/a]/Sqrt[a+b*x^4]*Int[1/Sqrt[1+b*x^4/a],x] /;
FreeQ[{a,b},x] && NegQ[b/a] && Not[PositiveQ[a]]


Int[1/Sqrt[a_+b_.*x_^6],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  x*(s+r*x^2)*Sqrt[(s^2-r*s*x^2+r^2*x^4)/(s+(1+Sqrt[3])*r*x^2)^2]/
    (2*3^(1/4)*s*Sqrt[a+b*x^6]*Sqrt[r*x^2*(s+r*x^2)/(s+(1+Sqrt[3])*r*x^2)^2])*
    EllipticF[ArcCos[(s+(1-Sqrt[3])*r*x^2)/(s+(1+Sqrt[3])*r*x^2)],(2+Sqrt[3])/4]] /;
FreeQ[{a,b},x]


Int[1/Sqrt[a_+b_.*x_^8],x_Symbol] :=
  1/2*Int[(1-Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] + 
  1/2*Int[(1+Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] /;
FreeQ[{a,b},x]


Int[1/(a_+b_.*x_^2)^(1/4),x_Symbol] :=
  2*x/(a+b*x^2)^(1/4) - a*Int[1/(a+b*x^2)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[1/(a_+b_.*x_^2)^(1/4),x_Symbol] :=
  2/(a^(1/4)*Rt[-b/a,2])*EllipticE[1/2*ArcSin[Rt[-b/a,2]*x],2] /;
FreeQ[{a,b},x] && NegQ[b/a] && PositiveQ[a]


Int[1/(a_+b_.*x_^2)^(1/4),x_Symbol] :=
  (1+b*x^2/a)^(1/4)/(a+b*x^2)^(1/4)*Int[1/(1+b*x^2/a)^(1/4),x] /;
FreeQ[{a,b},x] && NegQ[b/a] && Not[PositiveQ[a]]


Int[1/(a_+b_.*x_^2)^(3/4),x_Symbol] :=
  2/(a^(3/4)*Rt[b/a,2])*EllipticF[1/2*ArcTan[Rt[b/a,2]*x],2] /;
FreeQ[{a,b},x] && PositiveQ[a] && PosQ[b/a]


Int[1/(a_+b_.*x_^2)^(3/4),x_Symbol] :=
  2/(a^(3/4)*Rt[-b/a,2])*EllipticF[1/2*ArcSin[Rt[-b/a,2]*x],2] /;
FreeQ[{a,b},x] && PositiveQ[a] && NegQ[b/a]


Int[1/(a_+b_.*x_^2)^(3/4),x_Symbol] :=
  (1+b*x^2/a)^(3/4)/(a+b*x^2)^(3/4)*Int[1/(1+b*x^2/a)^(3/4),x] /;
FreeQ[{a,b},x] && Not[PositiveQ[a]]


Int[1/(a_+b_.*x_^2)^(1/3),x_Symbol] :=
  3*Sqrt[b*x^2]/(2*b*x)*Subst[Int[x/Sqrt[-a+x^3],x],x,(a+b*x^2)^(1/3)] /;
FreeQ[{a,b},x]


Int[1/(a_+b_.*x_^2)^(2/3),x_Symbol] :=
  3*Sqrt[b*x^2]/(2*b*x)*Subst[Int[1/Sqrt[-a+x^3],x],x,(a+b*x^2)^(1/3)] /;
FreeQ[{a,b},x]


Int[1/(a_+b_.*x_^4)^(3/4),x_Symbol] :=
  x^3*(1+a/(b*x^4))^(3/4)/(a+b*x^4)^(3/4)*Int[1/(x^3*(1+a/(b*x^4))^(3/4)),x] /;
FreeQ[{a,b},x]


Int[1/(a_+b_.*x_^2)^(1/6),x_Symbol] :=
  3*x/(2*(a+b*x^2)^(1/6)) - a/2*Int[1/(a+b*x^2)^(7/6),x] /;
FreeQ[{a,b},x]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^(p+1/n)*Subst[Int[1/(1-b*x^n)^(p+1/n+1),x],x,x/(a+b*x^n)^(1/n)] /;
FreeQ[{a,b},x] && IGtQ[n,0] && GtQ[p,-1] && LtQ[p,0] && NeQ[p,-1/2] && IntegerQ[p+1/n]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (a/(a+b*x^n))^(p+1/n)*(a+b*x^n)^(p+1/n)*Subst[Int[1/(1-b*x^n)^(p+1/n+1),x],x,x/(a+b*x^n)^(1/n)] /;
FreeQ[{a,b},x] && IGtQ[n,0] && GtQ[p,-1] && LtQ[p,0] && NeQ[p,-1/2] && Denominator[p+1/n]<Denominator[p]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p/x^2,x],x,1/x] /;
FreeQ[{a,b,p},x] && ILtQ[n,0]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[n]},
  k*Subst[Int[x^(k-1)*(a+b*x^(k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a,b,p},x] && FractionQ[n]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,n},x] && IGtQ[p,0]


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^p*x*Hypergeometric2F1[-p,1/n,1/n+1,-b*x^n/a] /;
FreeQ[{a,b,n,p},x] && Not[IGtQ[p,0]] && Not[IntegerQ[1/n]] && Not[ILtQ[Simplify[1/n+p],0]] && 
  (IntegerQ[p] || PositiveQ[a])


(* Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x*(a+b*x^n)^(p+1)/a*Hypergeometric2F1[1,1/n+p+1,1/n+1,-b*x^n/a] /;
FreeQ[{a,b,n,p},x] && Not[IGtQ[p,0]] && Not[IntegerQ[1/n]] && Not[ILtQ[Simplify[1/n+p],0]] && 
  Not[IntegerQ[p] || PositiveQ[a]] *)


Int[(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n)^FracPart[p]/(1+b*x^n/a)^FracPart[p]*Int[(1+b*x^n/a)^p,x] /;
FreeQ[{a,b,n,p},x] && Not[IGtQ[p,0]] && Not[IntegerQ[1/n]] && 
  Not[ILtQ[Simplify[1/n+p],0]] && Not[IntegerQ[p] || PositiveQ[a]]


Int[(a_.+b_.*u_^n_)^p_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x^n)^p,x],x,u] /;
FreeQ[{a,b,n,p},x] && LinearQ[u,x] && NeQ[u,x]


Int[(a1_.+b1_.*x_^n_)^p_.*(a2_.+b2_.*x_^n_)^p_.,x_Symbol] :=
  Int[(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,n,p},x] && EqQ[a2*b1+a1*b2,0] && (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[(a1_+b1_.*x_^n_.)^p_.*(a2_+b2_.*x_^n_.)^p_.,x_Symbol] :=
  x*(a1+b1*x^n)^p*(a2+b2*x^n)^p/(2*n*p+1) + 
  2*a1*a2*n*p/(2*n*p+1)*Int[(a1+b1*x^n)^(p-1)*(a2+b2*x^n)^(p-1),x] /;
FreeQ[{a1,b1,a2,b2},x] && EqQ[a2*b1+a1*b2,0] && IGtQ[2*n,0] && GtQ[p,0] && (IntegerQ[2*p] || Denominator[p+1/n]<Denominator[p])


Int[(a1_+b1_.*x_^n_.)^p_*(a2_+b2_.*x_^n_.)^p_,x_Symbol] :=
  -x*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*a1*a2*n*(p+1)) + 
  (2*n*(p+1)+1)/(2*a1*a2*n*(p+1))*Int[(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1),x] /;
FreeQ[{a1,b1,a2,b2},x] && EqQ[a2*b1+a1*b2,0] && IGtQ[2*n,0] && LtQ[p,-1] && (IntegerQ[2*p] || Denominator[p+1/n]<Denominator[p])


Int[(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -Subst[Int[(a1+b1*x^(-n))^p*(a2+b2*x^(-n))^p/x^2,x],x,1/x] /;
FreeQ[{a1,b1,a2,b2,p},x] && EqQ[a2*b1+a1*b2,0] && ILtQ[2*n,0]


Int[(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[2*n]},
  k*Subst[Int[x^(k-1)*(a1+b1*x^(k*n))^p*(a2+b2*x^(k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a1,b1,a2,b2,p},x] && EqQ[a2*b1+a1*b2,0] && FractionQ[2*n]


Int[(a1_.+b1_.*x_^n_)^p_*(a2_.+b2_.*x_^n_)^p_,x_Symbol] :=
  (a1+b1*x^n)^FracPart[p]*(a2+b2*x^n)^FracPart[p]/(a1*a2+b1*b2*x^(2*n))^FracPart[p]*Int[(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,n,p},x] && EqQ[a2*b1+a1*b2,0] && Not[IntegerQ[p]]





(* ::Subsection::Closed:: *)
(*1.1.3.2 (c x)^m (a+b x^n)^p*)


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  Int[(c*x)^m*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[(c_.*x_)^m_.*(b_.*x_^n_)^p_,x_Symbol] :=
  c^m/(n*b^(Simplify[(m+1)/n]-1))*Subst[Int[(b*x)^(p+Simplify[(m+1)/n]-1),x],x,x^n] /;
FreeQ[{b,c,m,n,p},x] && (IntegerQ[m] || PositiveQ[c]) && IntegerQ[Simplify[(m+1)/n]]


Int[(c_.*x_)^m_.*(b_.*x_^n_.)^p_,x_Symbol] :=
  c^m*b^IntPart[p]*(b*x^n)^FracPart[p]/x^(n*FracPart[p])*Int[x^(m+n*p),x] /;
FreeQ[{b,c,m,n,p},x] && (IntegerQ[m] || PositiveQ[c]) && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[(c_*x_)^m_*(b_.*x_^n_.)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(b*x^n)^p,x] /;
FreeQ[{b,c,m,n,p},x] && Not[IntegerQ[m]]


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Log[RemoveContent[a+b*x^n,x]]/(b*n) /;
FreeQ[{a,b,m,n},x] && EqQ[m,n-1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (a+b*x^n)^(p+1)/(b*n*(p+1)) /;
FreeQ[{a,b,m,n,p},x] && EqQ[m,n-1] && NeQ[p,-1]


Int[x_^m_.*(a1_+b1_.*x_^n_.)^p_*(a2_+b2_.*x_^n_.)^p_,x_Symbol] :=
  (a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*b1*b2*n*(p+1)) /;
FreeQ[{a1,b1,a2,b2,m,n,p},x] && EqQ[a2*b1+a1*b2,0] && EqQ[m,2*n-1] && NeQ[p,-1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Int[x^(m+n*p)*(b+a*x^(-n))^p,x] /;
FreeQ[{a,b,m,n},x] && IntegerQ[p] && NegQ[n]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*(m+1)) /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[(m+1)/n+p+1] && NeQ[m+1]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(a1*a2*c*(m+1)) /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && EqQ[(m+1)/(2*n)+p+1] && NeQ[m+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,m,n,p},x] && IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a1+b1*x)^p*(a2+b2*x)^p,x],x,x^n] /;
FreeQ[{a1,b1,a2,b2,m,n,p},x] && EqQ[a2*b1+a1*b2] && IntegerQ[Simplify[(m+1)/(2*n)]]


Int[(c_*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && IntegerQ[Simplify[(m+1)/n]]


Int[(c_*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && IntegerQ[Simplify[(m+1)/(2*n)]]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(c*x)^m*(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,c,m,n},x] && PositiveIntegerQ[p]


Int[x_^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^(p+1)/(a*(m+1)) - 
  b*(m+n*(p+1)+1)/(a*(m+1))*Int[x^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,m,n,p},x] && NegativeIntegerQ[Simplify[(m+1)/n+p+1]] && NeQ[m+1]


Int[x_^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(a1*a2*(m+1)) - 
  b1*b2*(m+2*n*(p+1)+1)/(a1*a2*(m+1))*Int[x^(m+2*n)*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,m,n,p},x] && EqQ[a2*b1+a1*b2] && NegativeIntegerQ[Simplify[(m+1)/(2*n)+p+1]] && NeQ[m+1]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*n*(p+1)) +
  (m+n*(p+1)+1)/(a*n*(p+1))*Int[(c*x)^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,m,n,p},x] && NegativeIntegerQ[Simplify[(m+1)/n+p+1]] && NeQ[p+1]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*a1*a2*c*n*(p+1)) +
  (m+2*n*(p+1)+1)/(2*a1*a2*n*(p+1))*Int[(c*x)^m*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && NegativeIntegerQ[Simplify[(m+1)/(2*n)+p+1]] && NeQ[p+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(a+b*x^(n/k))^p,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,b,p},x] && PositiveIntegerQ[n] && IntegerQ[m]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=GCD[m+1,2*n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(a1+b1*x^(n/k))^p*(a2+b2*x^(n/k))^p,x],x,x^k] /;
 k!=1] /;
FreeQ[{a1,b1,a2,b2,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && IntegerQ[m]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^p/(c*(m+1)) - 
  b*n*p/(c^n*(m+1))*Int[(c*x)^(m+n)*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c},x] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-1 && Not[NegativeIntegerQ[(m+n*p+n+1)/n]] && 
  IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^p*(a2+b2*x^n)^p/(c*(m+1)) - 
  2*b1*b2*n*p/(c^(2*n)*(m+1))*Int[(c*x)^(m+2*n)*(a1+b1*x^n)^(p-1)*(a2+b2*x^n)^(p-1),x] /;
FreeQ[{a1,b1,a2,b2,c,m},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m,p] && p>0 && NeQ[m+2*n*p+1] && 
  IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^p/(c*(m+n*p+1)) +
  a*n*p/(m+n*p+1)*Int[(c*x)^m*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c,m},x] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && NeQ[m+n*p+1] && IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^p*(a2+b2*x^n)^p/(c*(m+2*n*p+1)) + 
  2*a1*a2*n*p/(m+2*n*p+1)*Int[(c*x)^m*(a1+b1*x^n)^(p-1)*(a2+b2*x^n)^(p-1),x] /;
FreeQ[{a1,b1,a2,b2,c,m},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m,p] && p>0 && NeQ[m+2*n*p+1] && 
  IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[x_^2/(a_+b_.*x_^4)^(5/4),x_Symbol] :=
  x*(1+a/(b*x^4))^(1/4)/(b*(a+b*x^4)^(1/4))*Int[1/(x^3*(1+a/(b*x^4))^(5/4)),x] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[x_^m_/(a_+b_.*x_^4)^(5/4),x_Symbol] :=
  x^(m-3)/(b*(m-4)*(a+b*x^4)^(1/4)) - a*(m-3)/(b*(m-4))*Int[x^(m-4)/(a+b*x^4)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a] && PositiveIntegerQ[(m-2)/4]


Int[x_^m_/(a_+b_.*x_^4)^(5/4),x_Symbol] :=
  x^(m+1)/(a*(m+1)*(a+b*x^4)^(1/4)) - b*m/(a*(m+1))*Int[x^(m+4)/(a+b*x^4)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a] && NegativeIntegerQ[(m-2)/4]


Int[Sqrt[c_.*x_]/(a_+b_.*x_^2)^(5/4),x_Symbol] :=
  Sqrt[c*x]*(1+a/(b*x^2))^(1/4)/(b*(a+b*x^2)^(1/4))*Int[1/(x^2*(1+a/(b*x^2))^(5/4)),x] /;
FreeQ[{a,b,c},x] && PosQ[b/a]


Int[(c_.*x_)^m_/(a_+b_.*x_^2)^(5/4),x_Symbol] :=
  2*c*(c*x)^(m-1)/(b*(2*m-3)*(a+b*x^2)^(1/4)) - 2*a*c^2*(m-1)/(b*(2*m-3))*Int[(c*x)^(m-2)/(a+b*x^2)^(5/4),x] /;
FreeQ[{a,b,c},x] && PosQ[b/a] && IntegerQ[2*m] && m>3/2 


Int[(c_.*x_)^m_/(a_+b_.*x_^2)^(5/4),x_Symbol] :=
  (c*x)^(m+1)/(a*c*(m+1)*(a+b*x^2)^(1/4)) - b*(2*m+1)/(2*a*c^2*(m+1))*Int[(c*x)^(m+2)/(a+b*x^2)^(5/4),x] /;
FreeQ[{a,b,c},x] && PosQ[b/a] && IntegerQ[2*m] && m<-1


Int[x_^2/(a_+b_.*x_^4)^(5/4),x_Symbol] :=
  -1/(b*x*(a+b*x^4)^(1/4)) - 1/b*Int[1/(x^2*(a+b*x^4)^(1/4)),x] /;
FreeQ[{a,b},x] && NegQ[b/a]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^(n-1)*(c*x)^(m-n+1)*(a+b*x^n)^(p+1)/(b*n*(p+1)) -
  c^n*(m-n+1)/(b*n*(p+1))*Int[(c*x)^(m-n)*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c},x] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m+1>n && 
  Not[NegativeIntegerQ[(m+n*(p+1)+1)/n]] && IntBinomialQ[a,b,c,n,m,p,x]


(* Int[(c_.*x_)^m_.*u_^p_*v_^p_,x_Symbol] :=
  With[{a=BinomialParts[u,x][[1]],b=BinomialParts[u,x][[2]],n=BinomialParts[u,x][[3]]},
  c^(n-1)*(c*x)^(m-n+1)*u^(p+1)*v^(p+1)/(b*n*(p+1)) -
  c^n*(m-n+1)/(b*n*(p+1))*Int[(c*x)^(m-n)*u^(p+1)*v^(p+1),x] /;
 PositiveIntegerQ[n] && m+1>n && Not[NegativeIntegerQ[(m+n*(p+1)+1)/n]] && 
   IntBinomialQ[a,b,c,n,m,p,x]] /;
FreeQ[c,x] && BinomialQ[u*v,x] && RationalQ[m,p] && p<-1 *)


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^(2*n-1)*(c*x)^(m-2*n+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*b1*b2*n*(p+1)) - 
  c^(2*n)*(m-2*n+1)/(2*b1*b2*n*(p+1))*Int[(c*x)^(m-2*n)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m,p] && p<-1 && m+1>2*n && 
  Not[NegativeIntegerQ[(m+2*n*(p+1)+1)/(2*n)]] && IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*n*(p+1)) +
  (m+n*(p+1)+1)/(a*n*(p+1))*Int[(c*x)^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,m},x] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*a1*a2*c*n*(p+1)) + 
  (m+2*n*(p+1)+1)/(2*a1*a2*n*(p+1))*Int[(c*x)^m*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c,m},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m,p] && p<-1 && 
  IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[x_/(a_+b_.*x_^3),x_Symbol] :=
  -1/(3*Rt[a,3]*Rt[b,3])*Int[1/(Rt[a,3]+Rt[b,3]*x),x] + 
  1/(3*Rt[a,3]*Rt[b,3])*Int[(Rt[a,3]+Rt[b,3]*x)/(Rt[a,3]^2-Rt[a,3]*Rt[b,3]*x+Rt[b,3]^2*x^2),x] /;
FreeQ[{a,b},x]


(* Int[x_^m_./(a_+b_.*x_^5),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,5]], s=Denominator[Rt[a/b,5]]},
  (-1)^m*r^(m+1)/(5*a*s^m)*Int[1/(r+s*x),x] + 
  2*r^(m+1)/(5*a*s^m)*Int[(r*Cos[m*Pi/5]-s*Cos[(m+1)*Pi/5]*x)/(r^2-1/2*(1+Sqrt[5])*r*s*x+s^2*x^2),x] + 
  2*r^(m+1)/(5*a*s^m)*Int[(r*Cos[3*m*Pi/5]-s*Cos[3*(m+1)*Pi/5]*x)/(r^2-1/2*(1-Sqrt[5])*r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m] && m<4 && PosQ[a/b] *)


(* Int[x_^m_./(a_+b_.*x_^5),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,5]], s=Denominator[Rt[-a/b,5]]},
  (r^(m+1)/(5*a*s^m))*Int[1/(r-s*x),x] + 
  2*(-1)^m*r^(m+1)/(5*a*s^m)*Int[(r*Cos[m*Pi/5]+s*Cos[(m+1)*Pi/5]*x)/(r^2+1/2*(1+Sqrt[5])*r*s*x+s^2*x^2),x] + 
  2*(-1)^m*r^(m+1)/(5*a*s^m)*Int[(r*Cos[3*m*Pi/5]+s*Cos[3*(m+1)*Pi/5]*x)/(r^2+1/2*(1-Sqrt[5])*r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m] && m<4 && NegQ[a/b] *)


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[a/b,n]], s=Denominator[Rt[a/b,n]], k, u},
  u=Int[(r*Cos[(2*k-1)*m*Pi/n]-s*Cos[(2*k-1)*(m+1)*Pi/n]*x)/(r^2-2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  -(-r)^(m+1)/(a*n*s^m)*Int[1/(r+s*x),x] + Dist[2*r^(m+1)/(a*n*s^m),Sum[u,{k,1,(n-1)/2}],x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[(n-1)/2] && PositiveIntegerQ[m] && m<n-1 && PosQ[a/b]


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[-a/b,n]], s=Denominator[Rt[-a/b,n]], k, u},
  u=Int[(r*Cos[(2*k-1)*m*Pi/n]+s*Cos[(2*k-1)*(m+1)*Pi/n]*x)/(r^2+2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  r^(m+1)/(a*n*s^m)*Int[1/(r-s*x),x] - Dist[2*(-r)^(m+1)/(a*n*s^m),Sum[u,{k,1,(n-1)/2}],x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m,(n-1)/2] && PositiveIntegerQ[m] && m<n-1 && NegQ[a/b]


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[a/b,n]], s=Denominator[Rt[a/b,n]], k, u},
  u=Int[(r*Cos[(2*k-1)*m*Pi/n]-s*Cos[(2*k-1)*(m+1)*Pi/n]*x)/(r^2-2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x] + 
    Int[(r*Cos[(2*k-1)*m*Pi/n]+s*Cos[(2*k-1)*(m+1)*Pi/n]*x)/(r^2+2*r*s*Cos[(2*k-1)*Pi/n]*x+s^2*x^2),x];
  2*(-1)^(m/2)*r^(m+2)/(a*n*s^m)*Int[1/(r^2+s^2*x^2),x] + Dist[2*r^(m+1)/(a*n*s^m),Sum[u,{k,1,(n-2)/4}],x]] /;
 FreeQ[{a,b},x] && PositiveIntegerQ[m,(n-2)/4] && PositiveIntegerQ[m] && m<n-1 && PosQ[a/b]


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  Module[{r=Numerator[Rt[-a/b,n]], s=Denominator[Rt[-a/b,n]], k, u},
  u=Int[(r*Cos[2*k*m*Pi/n]-s*Cos[2*k*(m+1)*Pi/n]*x)/(r^2-2*r*s*Cos[2*k*Pi/n]*x+s^2*x^2),x] + 
    Int[(r*Cos[2*k*m*Pi/n]+s*Cos[2*k*(m+1)*Pi/n]*x)/(r^2+2*r*s*Cos[2*k*Pi/n]*x+s^2*x^2),x];
  2*r^(m+2)/(a*n*s^m)*Int[1/(r^2-s^2*x^2),x] + Dist[2*r^(m+1)/(a*n*s^m),Sum[u,{k,1,(n-2)/4}],x]] /;
 FreeQ[{a,b},x] && PositiveIntegerQ[m,(n-2)/4] && PositiveIntegerQ[m] && m<n-1 && NegQ[a/b]


Int[x_^2/(a_+b_.*x_^4),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,2]], s=Denominator[Rt[a/b,2]]},
  1/(2*s)*Int[(r+s*x^2)/(a+b*x^4),x] - 
  1/(2*s)*Int[(r-s*x^2)/(a+b*x^4),x]] /;
FreeQ[{a,b},x] && (PositiveQ[a/b] || PosQ[a/b] && AtomQ[SplitProduct[SumBaseQ,a]] && AtomQ[SplitProduct[SumBaseQ,b]])


Int[x_^2/(a_+b_.*x_^4),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  s/(2*b)*Int[1/(r+s*x^2),x] -
  s/(2*b)*Int[1/(r-s*x^2),x]] /;
FreeQ[{a,b},x] && Not[PositiveQ[a/b]]


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,4]], s=Denominator[Rt[a/b,4]]},
  s^3/(2*Sqrt[2]*b*r)*Int[x^(m-n/4)/(r^2-Sqrt[2]*r*s*x^(n/4)+s^2*x^(n/2)),x] -
  s^3/(2*Sqrt[2]*b*r)*Int[x^(m-n/4)/(r^2+Sqrt[2]*r*s*x^(n/4)+s^2*x^(n/2)),x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m,n/4] && PositiveIntegerQ[m] && m<n-1 && PositiveQ[a/b]


Int[x_^m_/(a_+b_.*x_^n_),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  r/(2*a)*Int[x^m/(r+s*x^(n/2)),x] +
  r/(2*a)*Int[x^m/(r-s*x^(n/2)),x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m,n/4] && PositiveIntegerQ[m] && m<n/2 && Not[PositiveQ[a/b]]


Int[x_^m_/(a_+b_.*x_^n_),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  s/(2*b)*Int[x^(m-n/2)/(r+s*x^(n/2)),x] -
  s/(2*b)*Int[x^(m-n/2)/(r-s*x^(n/2)),x]] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m,n/4] && PositiveIntegerQ[m] && n/2<=m<n && Not[PositiveQ[a/b]]


Int[x_^m_/(a_+b_.*x_^n_),x_Symbol] :=
  Int[PolynomialDivide[x^m,(a+b*x^n),x],x] /;
FreeQ[{a,b},x] && PositiveIntegerQ[m,n] && m>2*n-1


Int[x_/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  Sqrt[2]*s/(Sqrt[2+Sqrt[3]]*r)*Int[1/Sqrt[a+b*x^3],x] + 1/r*Int[((1-Sqrt[3])*s+r*x)/Sqrt[a+b*x^3],x]] /;
FreeQ[{a,b},x] && PosQ[a]


Int[x_/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  -Sqrt[2]*s/(Sqrt[2-Sqrt[3]]*r)*Int[1/Sqrt[a+b*x^3],x] + 1/r*Int[((1+Sqrt[3])*s+r*x)/Sqrt[a+b*x^3],x]] /;
FreeQ[{a,b},x] && NegQ[a]


Int[x_^2/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[b/a,2]},
  1/q*Int[1/Sqrt[a+b*x^4],x] - 1/q*Int[(1-q*x^2)/Sqrt[a+b*x^4],x]] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[x_^2/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[-b/a,2]},
  1/q*Int[1/Sqrt[a+b*x^4],x] - 1/q*Int[(1-q*x^2)/Sqrt[a+b*x^4],x]] /;
FreeQ[{a,b},x] && NegativeQ[a] && PositiveQ[b]


Int[x_^2/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  With[{q=Rt[-b/a,2]},
  -1/q*Int[1/Sqrt[a+b*x^4],x] + 1/q*Int[(1+q*x^2)/Sqrt[a+b*x^4],x]] /;
FreeQ[{a,b},x] && NegQ[b/a]


Int[x_^4/Sqrt[a_+b_.*x_^6],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  (Sqrt[3]-1)*s^2/(2*r^2)*Int[1/Sqrt[a+b*x^6],x] - 1/(2*r^2)*Int[((Sqrt[3]-1)*s^2-2*r^2*x^4)/Sqrt[a+b*x^6],x]] /;
FreeQ[{a,b},x]


(* Int[x_^4/Sqrt[a_+b_.*x_^6],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  (1+Sqrt[3])*r*x*Sqrt[a+b*x^6]/(2*b*(s+(1+Sqrt[3])*r*x^2)) - 
  3^(1/4)*s*x*(s+r*x^2)*Sqrt[(s^2-r*s*x^2+r^2*x^4)/(s+(1+Sqrt[3])*r*x^2)^2]/
    (2*r^2*Sqrt[a+b*x^6]*Sqrt[r*x^2*(s+r*x^2)/(s+(1+Sqrt[3])*r*x^2)^2])*
    EllipticE[ArcCos[(s+(1-Sqrt[3])*r*x^2)/(s+(1+Sqrt[3])*r*x^2)],(2+Sqrt[3])/4] - 
  (1-Sqrt[3])*s*x*(s+r*x^2)*Sqrt[(s^2-r*s*x^2+r^2*x^4)/(s+(1+Sqrt[3])*r*x^2)^2]/
    (4*3^(1/4)*r^2*Sqrt[a+b*x^6]*Sqrt[r*x^2*(s+r*x^2)/(s+(1+Sqrt[3])*r*x^2)^2])*
    EllipticF[ArcCos[(s+(1-Sqrt[3])*r*x^2)/(s+(1+Sqrt[3])*r*x^2)],(2+Sqrt[3])/4]] /;
FreeQ[{a,b},x] *)


Int[x_^2/Sqrt[a_+b_.*x_^8],x_Symbol] :=
  1/(2*Rt[b/a,4])*Int[(1+Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] - 
  1/(2*Rt[b/a,4])*Int[(1-Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] /;
FreeQ[{a,b},x]


Int[x_^2/(a_+b_.*x_^4)^(1/4),x_Symbol] :=
  x^3/(2*(a+b*x^4)^(1/4)) - a/2*Int[x^2/(a+b*x^4)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[x_^2/(a_+b_.*x_^4)^(1/4),x_Symbol] :=
  (a+b*x^4)^(3/4)/(2*b*x) + a/(2*b)*Int[1/(x^2*(a+b*x^4)^(1/4)),x] /;
FreeQ[{a,b},x] && NegQ[b/a]


Int[1/(x_^2*(a_+b_.*x_^4)^(1/4)),x_Symbol] :=
  -1/(x*(a+b*x^4)^(1/4)) - b*Int[x^2/(a+b*x^4)^(5/4),x] /;
FreeQ[{a,b},x] && PosQ[b/a]


Int[1/(x_^2*(a_+b_.*x_^4)^(1/4)),x_Symbol] :=
  x*(1+a/(b*x^4))^(1/4)/(a+b*x^4)^(1/4)*Int[1/(x^3*(1+a/(b*x^4))^(1/4)),x] /;
FreeQ[{a,b},x] && NegQ[b/a]


Int[Sqrt[c_*x_]/(a_+b_.*x_^2)^(1/4),x_Symbol] :=
  x*Sqrt[c*x]/(a+b*x^2)^(1/4) - a/2*Int[Sqrt[c*x]/(a+b*x^2)^(5/4),x] /;
FreeQ[{a,b,c},x] && PosQ[b/a]


Int[Sqrt[c_*x_]/(a_+b_.*x_^2)^(1/4),x_Symbol] :=
  c*(a+b*x^2)^(3/4)/(b*Sqrt[c*x]) + a*c^2/(2*b)*Int[1/((c*x)^(3/2)*(a+b*x^2)^(1/4)),x] /;
FreeQ[{a,b,c},x] && NegQ[b/a]


Int[1/((c_.*x_)^(3/2)*(a_+b_.*x_^2)^(1/4)),x_Symbol] :=
  -2/(c*Sqrt[c*x]*(a+b*x^2)^(1/4)) - b/c^2*Int[Sqrt[c*x]/(a+b*x^2)^(5/4),x] /;
FreeQ[{a,b,c},x] && PosQ[b/a]


Int[1/((c_.*x_)^(3/2)*(a_+b_.*x_^2)^(1/4)),x_Symbol] :=
  Sqrt[c*x]*(1+a/(b*x^2))^(1/4)/(c^2*(a+b*x^2)^(1/4))*Int[1/(x^2*(1+a/(b*x^2))^(1/4)),x] /;
FreeQ[{a,b,c},x] && NegQ[b/a]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^(n-1)*(c*x)^(m-n+1)*(a+b*x^n)^(p+1)/(b*(m+n*p+1)) -
  a*c^n*(m-n+1)/(b*(m+n*p+1))*Int[(c*x)^(m-n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,p},x] && PositiveIntegerQ[n] && RationalQ[m] && m>n-1 && NeQ[m+n*p+1] && IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^(n-1)*(c*x)^(m-n+1)*(a+b*x^n)^(p+1)/(b*(m+n*p+1)) -
  a*c^n*(m-n+1)/(b*(m+n*p+1))*Int[(c*x)^(m-n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && PositiveIntegerQ[n] && SumSimplerQ[m,-n] && NeQ[m+n*p+1] && NegativeIntegerQ[Simplify[(m+1)/n+p]]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^(2*n-1)*(c*x)^(m-2*n+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(b1*b2*(m+2*n*p+1)) - 
  a1*a2*c^(2*n)*(m-2*n+1)/(b1*b2*(m+2*n*p+1))*Int[(c*x)^(m-2*n)*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m] && m>2*n-1 && 
  NeQ[m+2*n*p+1] && IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^(2*n-1)*(c*x)^(m-2*n+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(b1*b2*(m+2*n*p+1)) - 
  a1*a2*c^(2*n)*(m-2*n+1)/(b1*b2*(m+2*n*p+1))*Int[(c*x)^(m-2*n)*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && SumSimplerQ[m,-2*n] && NeQ[m+2*n*p+1] && 
  NegativeIntegerQ[Simplify[(m+1)/(2*n)+p]]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*(m+1)) -
  b*(m+n*(p+1)+1)/(a*c^n*(m+1))*Int[(c*x)^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,p},x] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*(m+1)) -
  b*(m+n*(p+1)+1)/(a*c^n*(m+1))*Int[(c*x)^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && PositiveIntegerQ[n] && SumSimplerQ[m,n] && NegativeIntegerQ[Simplify[(m+1)/n+p]]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(a1*a2*c*(m+1)) - 
  b1*b2*(m+2*n*(p+1)+1)/(a1*a2*c^(2*n)*(m+1))*Int[(c*x)^(m+2*n)*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[m] && m<-1 && 
  IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(a1*a2*c*(m+1)) - 
  b1*b2*(m+2*n*(p+1)+1)/(a1*a2*c^(2*n)*(m+1))*Int[(c*x)^(m+2*n)*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && SumSimplerQ[m,2*n] && 
  NegativeIntegerQ[Simplify[(m+1)/(2*n)+p]]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/c*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n)/c^n)^p,x],x,(c*x)^(1/k)]] /;
FreeQ[{a,b,c,p},x] && PositiveIntegerQ[n] && FractionQ[m] && IntBinomialQ[a,b,c,n,m,p,x]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/c*Subst[Int[x^(k*(m+1)-1)*(a1+b1*x^(k*n)/c^n)^p*(a2+b2*x^(k*n)/c^n)^p,x],x,(c*x)^(1/k)]] /;
FreeQ[{a1,b1,a2,b2,c,p},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && FractionQ[m] && IntBinomialQ[a1*a2,b1*b2,c,n,m,p,x]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^(p+(m+1)/n)*Subst[Int[x^m/(1-b*x^n)^(p+(m+1)/n+1),x],x,x/(a+b*x^n)^(1/n)] /;
FreeQ[{a,b},x] && PositiveIntegerQ[n] && RationalQ[p] && -1<p<0 && p!=-1/2 && IntegersQ[m,p+(m+1)/n]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (a1*a2)^(p+(m+1)/(2*n))*
    Subst[Int[x^m/((1-b1*x^n)^(p+(m+1)/(2*n)+1)*(1-b2*x^n)^(p+(m+1)/(2*n)+1)),x],x,
      x/((a1+b1*x^n)^(1/(2*n))*(a2+b2*x^n)^(1/(2*n)))] /;
FreeQ[{a1,b1,a2,b2},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[p] && -1<p<0 && p!=-1/2 && 
  IntegersQ[m,p+(m+1)/(2*n)]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (a/(a+b*x^n))^(p+(m+1)/n)*(a+b*x^n)^(p+(m+1)/n)*Subst[Int[x^m/(1-b*x^n)^(p+(m+1)/n+1),x],x,x/(a+b*x^n)^(1/n)] /;
FreeQ[{a,b},x] && PositiveIntegerQ[n] && RationalQ[p] && -1<p<0 && p!=-1/2 && IntegerQ[m] && 
  Denominator[p+(m+1)/n]<Denominator[p]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (a1/(a1+b1*x^n))^(p+(m+1)/(2*n))*(a1+b1*x^n)^(p+(m+1)/(2*n))*(a2/(a2+b2*x^n))^(p+(m+1)/(2*n))*(a2+b2*x^n)^(p+(m+1)/(2*n))*
    Subst[Int[x^m/((1-b1*x^n)^(p+(m+1)/(2*n)+1)*(1-b2*x^n)^(p+(m+1)/(2*n)+1)),x],x,
      x/((a1+b1*x^n)^(1/(2*n))*(a2+b2*x^n)^(1/(2*n)))] /;
FreeQ[{a1,b1,a2,b2},x] && EqQ[a2*b1+a1*b2] && PositiveIntegerQ[2*n] && RationalQ[p] && -1<p<0 && p!=-1/2 && 
  IntegerQ[m] && Denominator[p+(m+1)/(2*n)]<Denominator[p]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,p},x] && NegativeIntegerQ[n] && IntegerQ[m]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -Subst[Int[(a1+b1*x^(-n))^p*(a2+b2*x^(-n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a1,b1,a2,b2,p},x] && EqQ[a2*b1+a1*b2] && NegativeIntegerQ[2*n] && IntegerQ[m]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  -k/c*Subst[Int[(a+b*c^(-n)*x^(-k*n))^p/x^(k*(m+1)+1),x],x,1/(c*x)^(1/k)]] /;
FreeQ[{a,b,c,p},x] && NegativeIntegerQ[n] && FractionQ[m]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  -k/c*Subst[Int[(a1+b1*c^(-n)*x^(-k*n))^p*(a2+b2*c^(-n)*x^(-k*n))^p/x^(k*(m+1)+1),x],x,1/(c*x)^(1/k)]] /;
FreeQ[{a1,b1,a2,b2,c,p},x] && EqQ[a2*b1+a1*b2] && NegativeIntegerQ[2*n] && FractionQ[m]


Int[(c_.*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^m*(x^(-1))^m*Subst[Int[(a+b*x^(-n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,m,p},x] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[(c_.*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^m*(x^(-1))^m*Subst[Int[(a1+b1*x^(-n))^p*(a2+b2*x^(-n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a1,b1,a2,b2,c,m,p},x] && EqQ[a2*b1+a1*b2] && NegativeIntegerQ[2*n] && Not[RationalQ[m]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[n]},
  k*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a,b,m,p},x] && FractionQ[n]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[2*n]},
  k*Subst[Int[x^(k*(m+1)-1)*(a1+b1*x^(k*n))^p*(a2+b2*x^(k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a1,b1,a2,b2,m,p},x] && EqQ[a2*b1+a1*b2] && FractionQ[2*n]


Int[(c_*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && FractionQ[n]


Int[(c_*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,p},x] && EqQ[a2*b1+a1*b2] && FractionQ[2*n]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(a+b*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,m,n,p},x] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(a1+b1*x^Simplify[n/(m+1)])^p*(a2+b2*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a1,b1,a2,b2,m,n,p},x] && EqQ[a2*b1+a1*b2] && IntegerQ[Simplify[2*n/(m+1)]] && Not[IntegerQ[2*n]]


Int[(c_*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && IntegerQ[Simplify[2*n/(m+1)]] && Not[IntegerQ[2*n]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a+b*x^n)^p/(m+1) - 
  b*n*p/(m+1)*Int[x^(m+n)*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,m,n},x] && EqQ[(m+1)/n+p] && RationalQ[p] && p>0


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  x^(m+1)*(a1+b1*x^n)^p*(a2+b2*x^n)^p/(m+1) - 
  2*b1*b2*n*p/(m+1)*Int[x^(m+n)*(a1+b1*x^n)^(p-1)*(a2+b2*x^n)^(p-1),x] /;
FreeQ[{a1,b1,a2,b2,m,n},x] && EqQ[a2*b1+a1*b2] && EqQ[(m+1)/(2*n)+p] && RationalQ[p] && p>0


Int[(c_*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n},x] && EqQ[(m+1)/n+p] && RationalQ[p] && p>0


Int[(c_*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n},x] && EqQ[a2*b1+a1*b2] && EqQ[(m+1)/(2*n)+p] && RationalQ[p] && p>0


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^p/(c*(m+n*p+1)) +
  a*n*p/(m+n*p+1)*Int[(c*x)^m*(a+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c,m,n},x] && IntegerQ[p+Simplify[(m+1)/n]] && RationalQ[p] && p>0 && NeQ[m+n*p+1]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a1+b1*x^n)^p*(a2+b2*x^n)^p/(c*(m+2*n*p+1)) +
  2*a1*a2*n*p/(m+2*n*p+1)*Int[(c*x)^m*(a1+b1*x^n)^(p-1)*(a2+b2*x^n)^(p-1),x] /;
FreeQ[{a1,b1,a2,b2,c,m,n},x] && EqQ[a2*b1+a1*b2] && IntegerQ[p+Simplify[(m+1)/(2*n)]] && RationalQ[p] && p>0 && 
  NeQ[m+2*n*p+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[p]},
  k*a^(p+Simplify[(m+1)/n])/n*
	Subst[Int[x^(k*Simplify[(m+1)/n]-1)/(1-b*x^k)^(p+Simplify[(m+1)/n]+1),x],x,x^(n/k)/(a+b*x^n)^(1/k)]] /;
FreeQ[{a,b,m,n},x] && IntegerQ[p+Simplify[(m+1)/n]] && RationalQ[p] && -1<p<0


Int[x_^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  With[{k=Denominator[p]},
  k*(a1*a2)^(p+Simplify[(m+1)/(2*n)])/(2*n)*
	Subst[Int[x^(k*Simplify[(m+1)/(2*n)]-1)/((1-b1*x^k)^(p+Simplify[(m+1)/(2*n)]+1)*(1-b2*x^k)^(p+Simplify[(m+1)/(2*n)]+1)),x],x,
      x^(2*n/k)/((a1+b1*x^n)^(1/k)*(a2+b2*x^n)^(1/k))]] /;
FreeQ[{a1,b1,a2,b2,m,n},x] && EqQ[a2*b1+a1*b2] && IntegerQ[p+Simplify[(m+1)/(2*n)]] && RationalQ[p] && -1<p<0


Int[(c_*x_)^m_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n},x] && IntegerQ[p+Simplify[(m+1)/n]] && RationalQ[p] && -1<p<0


Int[(c_*x_)^m_*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a1+b1*x^n)^p*(a2+b2*x^n)^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n},x] && EqQ[a2*b1+a1*b2] && IntegerQ[p+Simplify[(m+1)/(2*n)]] && RationalQ[p] && -1<p<0


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*n*(p+1)) +
  (m+n*(p+1)+1)/(a*n*(p+1))*Int[(c*x)^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,m,n},x] && IntegerQ[p+Simplify[(m+1)/n]] && RationalQ[p] && p<-1


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  -(c*x)^(m+1)*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1)/(2*a1*a2*c*n*(p+1)) +
  (m+2*n*(p+1)+1)/(2*a1*a2*n*(p+1))*Int[(c*x)^m*(a1+b1*x^n)^(p+1)*(a2+b2*x^n)^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c,m,n},x] && EqQ[a2*b1+a1*b2] && IntegerQ[p+Simplify[(m+1)/n]] && RationalQ[p] && p<-1


Int[x_^m_./(a_+b_.*x_^n_),x_Symbol] :=
  With[{mn=Simplify[m-n]},
  x^(mn+1)/(b*(mn+1)) -
  a/b*Int[x^mn/(a+b*x^n),x]] /;
FreeQ[{a,b,m,n},x] && FractionQ[Simplify[(m+1)/n]] && SumSimplerQ[m,-n]


Int[x_^m_/(a_+b_.*x_^n_),x_Symbol] :=
  x^(m+1)/(a*(m+1)) -
  b/a*Int[x^Simplify[m+n]/(a+b*x^n),x] /;
FreeQ[{a,b,m,n},x] && FractionQ[Simplify[(m+1)/n]] && SumSimplerQ[m,n]


Int[(c_*x_)^m_/(a_+b_.*x_^n_),x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m/(a+b*x^n),x] /;
FreeQ[{a,b,c,m,n},x] && FractionQ[Simplify[(m+1)/n]] && (SumSimplerQ[m,n] || SumSimplerQ[m,-n])


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^p*(c*x)^(m+1)/(c*(m+1))*Hypergeometric2F1[-p,(m+1)/n,(m+1)/n+1,-b*x^n/a] /;
FreeQ[{a,b,c,m,n,p},x] && Not[PositiveIntegerQ[p]] && (NegativeIntegerQ[p] || PositiveQ[a])


(* Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*(m+1))*Hypergeometric2F1[1,(m+1)/n+p+1,(m+1)/n+1,-b*x^n/a] /;
FreeQ[{a,b,c,m,n,p},x] && Not[PositiveIntegerQ[p]] && Not[NegativeIntegerQ[p] || PositiveQ[a]] *)


Int[(c_.*x_)^m_.*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n)^FracPart[p]/(1+b*x^n/a)^FracPart[p]*Int[(c*x)^m*(1+b*x^n/a)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && Not[PositiveIntegerQ[p]] && Not[NegativeIntegerQ[p] || PositiveQ[a]]


Int[x_^m_.*(a_+b_.*v_^n_)^p_.,x_Symbol] :=
  1/Coefficient[v,x,1]^(m+1)*Subst[Int[SimplifyIntegrand[(x-Coefficient[v,x,0])^m*(a+b*x^n)^p,x],x],x,v] /;
FreeQ[{a,b,n,p},x] && LinearQ[v,x] && IntegerQ[m] && NeQ[v-x]


Int[u_^m_.*(a_+b_.*v_^n_)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a+b*x^n)^p,x],x,v] /;
FreeQ[{a,b,m,n,p},x] && LinearPairQ[u,v,x]


Int[(c_.*x_)^m_.*(a1_+b1_.*x_^n_)^p_*(a2_+b2_.*x_^n_)^p_,x_Symbol] :=
  (a1+b1*x^n)^FracPart[p]*(a2+b2*x^n)^FracPart[p]/(a1*a2+b1*b2*x^(2*n))^FracPart[p]*Int[(c*x)^m*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && EqQ[a2*b1+a1*b2] && Not[IntegerQ[p]]


(* IntBinomialQ[a,b,c,n,m,p,x] returns True iff (c*x)^m*(a+b*x^n)^p is integrable wrt x in terms of non-hypergeometric functions. *)
IntBinomialQ[a_,b_,c_,n_,m_,p_,x_] :=
  IntegerQ[2*p] || IntegerQ[(m+1)/n+p] || 
  (EqQ[n-2] || EqQ[n-4]) && IntegersQ[2*m,4*p] || 
  EqQ[n-2] && IntegerQ[6*p] && (IntegerQ[m] || IntegerQ[m-p])


(* ::Subsection::Closed:: *)
(*1.1.3.3 (a+b x^n)^p (c+d x^n)^q*)


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p*(c+d*x^n)^q,x],x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && PositiveIntegerQ[p,q]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  Int[x^(n*(p+q))*(b+a*x^(-n))^p*(d+c*x^(-n))^q,x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && IntegersQ[p,q] && NegQ[n]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q/x^2,x],x,1/x] /;
FreeQ[{a,b,c,d,p,q},x] && NeQ[b*c-a*d,0] && NegativeIntegerQ[n]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g-1)*(a+b*x^(g*n))^p*(c+d*x^(g*n))^q,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,d,p,q},x] && NeQ[b*c-a*d,0] && FractionQ[n]


Int[(a_+b_.*x_^n_)^p_/(c_+d_.*x_^n_),x_Symbol] :=
  Subst[Int[1/(c-(b*c-a*d)*x^n),x],x,x/(a+b*x^n)^(1/n)] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && EqQ[n*p+1] && IntegerQ[n]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  -x*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*n*(p+1)) - 
  c*q/(a*(p+1))*Int[(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1),x] /;
FreeQ[{a,b,c,d,n,p},x] && NeQ[b*c-a*d,0] && EqQ[n*(p+q+1)+1] && RationalQ[q] && q>0 && NeQ[p+1]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  a^p*x/(c^(p+1)*(c+d*x^n)^(1/n))*Hypergeometric2F1[1/n,-p,1+1/n,-(b*c-a*d)*x^n/(a*(c+d*x^n))] /;
FreeQ[{a,b,c,d,n,q},x] && NeQ[b*c-a*d,0] && EqQ[n*(p+q+1)+1] && NegativeIntegerQ[p]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  x*(a+b*x^n)^p/(c*(c*(a+b*x^n)/(a*(c+d*x^n)))^p*(c+d*x^n)^(1/n+p))*
    Hypergeometric2F1[1/n,-p,1+1/n,-(b*c-a*d)*x^n/(a*(c+d*x^n))] /;
FreeQ[{a,b,c,d,n,p,q},x] && NeQ[b*c-a*d,0] && EqQ[n*(p+q+1)+1]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*c) /;
FreeQ[{a,b,c,d,n,p,q},x] && NeQ[b*c-a*d,0] && EqQ[n*(p+q+2)+1] && EqQ[a*d*(p+1)+b*c*(q+1)]


(* Int[(a1_+b1_.*x_^n2_.)^p_*(a2_+b2_.*x_^n2_.)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  x*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)*(c+d*x^n)^(q+1)/(a1*a2*c) /;
FreeQ[{a1,b1,a2,b2,c,d,n,p,q},x] && EqQ[n2-n/2] && EqQ[a2*b1+a1*b2] && EqQ[n*(p+q+2)+1] && EqQ[a1*a2*d*(p+1)+b1*b2*c*(q+1)] *)


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -b*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*n*(p+1)*(b*c-a*d)) + 
  (b*c+n*(p+1)*(b*c-a*d))/(a*n*(p+1)*(b*c-a*d))*Int[(a+b*x^n)^(p+1)*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,n,q},x] && NeQ[b*c-a*d,0] && EqQ[n*(p+q+2)+1] && (RationalQ[p] && p<-1 || Not[RationalQ[q] && q<-1]) && NeQ[p+1]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*x*(a+b*x^n)^(p+1)/a /;
FreeQ[{a,b,c,d,n,p},x] && NeQ[b*c-a*d,0] && EqQ[a*d-b*c*(n*(p+1)+1),0]


Int[(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*x*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(a1*a2) /;
FreeQ[{a1,b1,a2,b2,c,d,n,p},x] && EqQ[non2,n/2] && EqQ[a2*b1+a1*b2,0] && EqQ[a1*a2*d-b1*b2*c*(n*(p+1)+1),0]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_),x_Symbol] :=
  -(b*c-a*d)*x*(a+b*x^n)^(p+1)/(a*b*n*(p+1)) - 
  (a*d-b*c*(n*(p+1)+1))/(a*b*n*(p+1))*Int[(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,d,n,p},x] && NeQ[b*c-a*d,0] && (LtQ[p,-1] || ILtQ[1/n+p,0])


Int[(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  -(b1*b2*c-a1*a2*d)*x*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(a1*a2*b1*b2*n*(p+1)) - 
  (a1*a2*d-b1*b2*c*(n*(p+1)+1))/(a1*a2*b1*b2*n*(p+1))*Int[(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c,d,n},x] && EqQ[non2,n/2] && EqQ[a2*b1+a1*b2,0] && (LtQ[p,-1] || ILtQ[1/n+p,0])


Int[(c_+d_.*x_^n_)/(a_+b_.*x_^n_),x_Symbol] :=
  c*x/a - (b*c-a*d)/a*Int[1/(b+a*x^(-n)),x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && RationalQ[n] && n<0


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_),x_Symbol] :=
  d*x*(a+b*x^n)^(p+1)/(b*(n*(p+1)+1)) - 
  (a*d-b*c*(n*(p+1)+1))/(b*(n*(p+1)+1))*Int[(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && NeQ[n*(p+1)+1,0]


Int[(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  d*x*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(b1*b2*(n*(p+1)+1)) - 
  (a1*a2*d-b1*b2*c*(n*(p+1)+1))/(b1*b2*(n*(p+1)+1))*Int[(a1+b1*x^(n/2))^p*(a2+b2*x^(n/2))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,d,n,p},x] && EqQ[non2,n/2] && EqQ[a2*b1+a1*b2,0] && NeQ[n*(p+1)+1,0]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  Int[PolynomialDivide[(a+b*x^n)^p,(c+d*x^n)^(-q),x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && PositiveIntegerQ[n,p] && NegativeIntegerQ[q] && p>=-q


Int[1/((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  b/(b*c-a*d)*Int[1/(a+b*x^n),x] - d/(b*c-a*d)*Int[1/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0]


Int[1/((a_+b_.*x_^2)^(1/3)*(c_+d_.*x_^2)),x_Symbol] :=
  Sqrt[3]/(2*c)*Int[1/((a+b*x^2)^(1/3)*(Sqrt[3]-Rt[b/a,2]*x)),x] + 
  Sqrt[3]/(2*c)*Int[1/((a+b*x^2)^(1/3)*(Sqrt[3]+Rt[b/a,2]*x)),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && EqQ[b*c+3*a*d] && PosQ[b/a]


Int[1/((a_+b_.*x_^2)^(1/3)*(c_+d_.*x_^2)),x_Symbol] :=
  1/6*Int[(3+Rt[-b/a,2]*x)/((a+b*x^2)^(1/3)*(c+d*x^2)),x] + 
  1/6*Int[(3-Rt[-b/a,2]*x)/((a+b*x^2)^(1/3)*(c+d*x^2)),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && EqQ[b*c+3*a*d] && NegQ[b/a]


Int[(a_+b_.*x_^2)^(2/3)/(c_+d_.*x_^2),x_Symbol] :=
  b/d*Int[1/(a+b*x^2)^(1/3),x] - (b*c-a*d)/d*Int[1/((a+b*x^2)^(1/3)*(c+d*x^2)),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && EqQ[b*c+3*a*d]


Int[1/((a_+b_.*x_^2)^(1/4)*(c_+d_.*x_^2)),x_Symbol] :=
  Sqrt[-b*x^2/a]/(2*x)*Subst[Int[1/(Sqrt[-b*x/a]*(a+b*x)^(1/4)*(c+d*x)),x],x,x^2] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[1/((a_+b_.*x_^2)^(3/4)*(c_+d_.*x_^2)),x_Symbol] :=
  Sqrt[-b*x^2/a]/(2*x)*Subst[Int[1/(Sqrt[-b*x/a]*(a+b*x)^(3/4)*(c+d*x)),x],x,x^2] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[(a_+b_.*x_^2)^p_./(c_+d_.*x_^2),x_Symbol] :=
  b/d*Int[(a+b*x^2)^(p-1),x] - (b*c-a*d)/d*Int[(a+b*x^2)^(p-1)/(c+d*x^2),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[p] && p>0 && (p==1/2 || Denominator[p]==4)


Int[(a_+b_.*x_^2)^p_/(c_+d_.*x_^2),x_Symbol] :=
  b/(b*c-a*d)*Int[(a+b*x^2)^p,x] - d/(b*c-a*d)*Int[(a+b*x^2)^(p+1)/(c+d*x^2),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[p] && p<-1 && Denominator[p]==4 && (p==-5/4 || p==-7/4)


Int[Sqrt[a_+b_.*x_^4]/(c_+d_.*x_^4),x_Symbol] :=
  a/c*Subst[Int[1/(1-4*a*b*x^4),x],x,x/Sqrt[a+b*x^4]] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d] && PosQ[a*b]


Int[Sqrt[a_+b_.*x_^4]/(c_+d_.*x_^4),x_Symbol] :=
  With[{q=Rt[-a*b,4]},
  a/(2*c*q)*ArcTan[q*x*(a+q^2*x^2)/(a*Sqrt[a+b*x^4])] + a/(2*c*q)*ArcTanh[q*x*(a-q^2*x^2)/(a*Sqrt[a+b*x^4])]] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c+a*d] && NegQ[a*b]


Int[Sqrt[a_+b_.*x_^4]/(c_+d_.*x_^4),x_Symbol] :=
  b/d*Int[1/Sqrt[a+b*x^4],x] - (b*c-a*d)/d*Int[1/(Sqrt[a+b*x^4]*(c+d*x^4)),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[(a_+b_.*x_^4)^(1/4)/(c_+d_.*x_^4),x_Symbol] :=
  Sqrt[a+b*x^4]*Sqrt[a/(a+b*x^4)]*Subst[Int[1/(Sqrt[1-b*x^4]*(c-(b*c-a*d)*x^4)),x],x,x/(a+b*x^4)^(1/4)] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[(a_+b_.*x_^4)^p_/(c_+d_.*x_^4),x_Symbol] :=
  b/d*Int[(a+b*x^4)^(p-1),x] - (b*c-a*d)/d*Int[(a+b*x^4)^(p-1)/(c+d*x^4),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && RationalQ[p] && (p==3/4 || p==5/4)


Int[1/(Sqrt[a_+b_.*x_^4]*(c_+d_.*x_^4)),x_Symbol] :=
  1/(2*c)*Int[1/(Sqrt[a+b*x^4]*(1-Rt[-d/c,2]*x^2)),x] + 1/(2*c)*Int[1/(Sqrt[a+b*x^4]*(1+Rt[-d/c,2]*x^2)),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[1/((a_+b_.*x_^4)^(3/4)*(c_+d_.*x_^4)),x_Symbol] :=
  b/(b*c-a*d)*Int[1/(a+b*x^4)^(3/4),x] - d/(b*c-a*d)*Int[(a+b*x^4)^(1/4)/(c+d*x^4),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]


Int[Sqrt[a_+b_.*x_^2]/(c_+d_.*x_^2)^(3/2),x_Symbol] :=
  Sqrt[a+b*x^2]/(c*Rt[d/c,2]*Sqrt[c+d*x^2]*Sqrt[c*(a+b*x^2)/(a*(c+d*x^2))])*EllipticE[ArcTan[Rt[d/c,2]*x],1-b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && PosQ[b/a] && PosQ[d/c]


(* Int[Sqrt[a_+b_.*x_^2]/(c_+d_.*x_^2)^(3/2),x_Symbol] :=
  a*Sqrt[c+d*x^2]*Sqrt[(c*(a+b*x^2))/(a*(c+d*x^2))]/(c^2*Rt[d/c,2]*Sqrt[a+b*x^2])*EllipticE[ArcTan[Rt[d/c,2]*x],1-b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && PosQ[b/a] && PosQ[d/c] *)


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -x*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*n*(p+1)) + 
  1/(a*n*(p+1))*Int[(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*Simp[c*(n*(p+1)+1)+d*(n*(p+q+1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && RationalQ[p,q] && p<-1 && 0<q<1 && IntBinomialQ[a,b,c,d,n,p,q,x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (a*d-c*b)*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(a*b*n*(p+1)) - 
  1/(a*b*n*(p+1))*
    Int[(a+b*x^n)^(p+1)*(c+d*x^n)^(q-2)*Simp[c*(a*d-c*b*(n*(p+1)+1))+d*(a*d*(n*(q-1)+1)-b*c*(n*(p+q)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && RationalQ[p,q] && p<-1 && q>1 && IntBinomialQ[a,b,c,d,n,p,q,x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -b*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*n*(p+1)*(b*c-a*d)) + 
  1/(a*n*(p+1)*(b*c-a*d))*
    Int[(a+b*x^n)^(p+1)*(c+d*x^n)^q*Simp[b*c+n*(p+1)*(b*c-a*d)+d*b*(n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,n,q},x] && NeQ[b*c-a*d,0] && RationalQ[p] && p<-1 && Not[Not[IntegerQ[p]] && IntegerQ[q] && q<-1] && 
  IntBinomialQ[a,b,c,d,n,p,q,x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p*(c+d*x^n)^q,x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0] && PositiveIntegerQ[n] && IntegersQ[p,q] && p+q>0


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  d*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(b*(n*(p+q)+1)) + 
  1/(b*(n*(p+q)+1))*
    Int[(a+b*x^n)^p*(c+d*x^n)^(q-2)*Simp[c*(b*c*(n*(p+q)+1)-a*d)+d*(b*c*(n*(p+2*q-1)+1)-a*d*(n*(q-1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,n,p},x] && NeQ[b*c-a*d,0] && RationalQ[q] && q>1 && NeQ[n*(p+q)+1] && Not[IntegerQ[p] && p>1] && 
  IntBinomialQ[a,b,c,d,n,p,q,x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  x*(a+b*x^n)^p*(c+d*x^n)^q/(n*(p+q)+1) + 
  n/(n*(p+q)+1)*Int[(a+b*x^n)^(p-1)*(c+d*x^n)^(q-1)*Simp[a*c*(p+q)+(q*(b*c-a*d)+a*d*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,n},x] && NeQ[b*c-a*d,0] && RationalQ[p,q] && q>0 && p>0 && IntBinomialQ[a,b,c,d,n,p,q,x]


Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  Sqrt[a+b*x^2]/(a*Rt[d/c,2]*Sqrt[c+d*x^2]*Sqrt[c*(a+b*x^2)/(a*(c+d*x^2))])*EllipticF[ArcTan[Rt[d/c,2]*x],1-b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && PosQ[d/c] && PosQ[b/a] && Not[SimplerSqrtQ[b/a,d/c]]


(* Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  Sqrt[c+d*x^2]*Sqrt[c*(a+b*x^2)/(a*(c+d*x^2))]/(c*Rt[d/c,2]*Sqrt[a+b*x^2])*EllipticF[ArcTan[Rt[d/c,2]*x],1-b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && PosQ[d/c] && PosQ[b/a] && Not[SimplerSqrtQ[b/a,d/c]] *)


Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  1/(Sqrt[a]*Sqrt[c]*Rt[-d/c,2])*EllipticF[ArcSin[Rt[-d/c,2]*x],b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && PositiveQ[c] && PositiveQ[a] && Not[NegQ[b/a] && SimplerSqrtQ[-b/a,-d/c]]


Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  -1/(Sqrt[c]*Rt[-d/c,2]*Sqrt[a-b*c/d])*EllipticF[ArcCos[Rt[-d/c,2]*x],b*c/(b*c-a*d)] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && PositiveQ[c] && PositiveQ[a-b*c/d]


Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  Sqrt[1+d/c*x^2]/Sqrt[c+d*x^2]*Int[1/(Sqrt[a+b*x^2]*Sqrt[1+d/c*x^2]),x] /;
FreeQ[{a,b,c,d},x] && Not[PositiveQ[c]]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  a*Int[1/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]),x] + b*Int[x^2/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d},x] && PosQ[d/c] && PosQ[b/a]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  b/d*Int[Sqrt[c+d*x^2]/Sqrt[a+b*x^2],x] - (b*c-a*d)/d*Int[1/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d},x] && PosQ[d/c] && NegQ[b/a]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  Sqrt[a]/(Sqrt[c]*Rt[-d/c,2])*EllipticE[ArcSin[Rt[-d/c,2]*x],b*c/(a*d)] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && PositiveQ[c] && PositiveQ[a]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  -Sqrt[a-b*c/d]/(Sqrt[c]*Rt[-d/c,2])*EllipticE[ArcCos[Rt[-d/c,2]*x],b*c/(b*c-a*d)] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && PositiveQ[c] && PositiveQ[a-b*c/d]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  Sqrt[a+b*x^2]/Sqrt[1+b/a*x^2]*Int[Sqrt[1+b/a*x^2]/Sqrt[c+d*x^2],x] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && PositiveQ[c] && Not[PositiveQ[a]]


Int[Sqrt[a_+b_.*x_^2]/Sqrt[c_+d_.*x_^2],x_Symbol] :=
  Sqrt[1+d/c*x^2]/Sqrt[c+d*x^2]*Int[Sqrt[a+b*x^2]/Sqrt[1+d/c*x^2],x] /;
FreeQ[{a,b,c,d},x] && NegQ[d/c] && Not[PositiveQ[c]]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p*(c+d*x^n)^q,x],x] /;
FreeQ[{a,b,c,d,n,q},x] && NeQ[b*c-a*d,0] && PositiveIntegerQ[p]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  a^p*c^q*x*AppellF1[1/n,-p,-q,1+1/n,-b*x^n/a,-d*x^n/c] /;
FreeQ[{a,b,c,d,n,p,q},x] && NeQ[b*c-a*d,0] && NeQ[n+1] && PositiveQ[a] && PositiveQ[c]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n)^FracPart[p]/(1+b*x^n/a)^FracPart[p]*Int[(1+b*x^n/a)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,n,p,q},x] && NeQ[b*c-a*d,0] && NeQ[n+1] && Not[PositiveQ[a]]


Int[(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.,x_Symbol] :=
  Int[(a+b*x^n)^p*(d+c*x^n)^q/x^(n*q),x] /;
FreeQ[{a,b,c,d,n,p},x] && EqQ[mn,-n] && IntegerQ[q] && (PosQ[n] || Not[IntegerQ[p]])


Int[(a_+b_.*x_^n_.)^p_*(c_+d_.*x_^mn_.)^q_,x_Symbol] :=
  x^(n*FracPart[q])*(c+d*x^(-n))^FracPart[q]/(d+c*x^n)^FracPart[q]*Int[(a+b*x^n)^p*(d+c*x^n)^q/x^(n*q),x] /;
FreeQ[{a,b,c,d,n,p,q},x] && EqQ[mn,-n] && Not[IntegerQ[q]] && Not[IntegerQ[p]]


Int[(a_.+b_.*u_^n_)^p_.*(c_.+d_.*u_^n_)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x^n)^p*(c+d*x^n)^q,x],x,u] /;
FreeQ[{a,b,c,d,n,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[u_^p_.*v_^q_.,x_Symbol] :=
  Int[NormalizePseudoBinomial[u,x]^p*NormalizePseudoBinomial[v,x]^q,x] /;
FreeQ[{p,q},x] && PseudoBinomialPairQ[u,v,x]


Int[x_^m_.*u_^p_.*v_^q_.,x_Symbol] :=
  Int[NormalizePseudoBinomial[x^(m/p)*u,x]^p*NormalizePseudoBinomial[v,x]^q,x] /;
FreeQ[{p,q},x] && IntegersQ[p,m/p] && PseudoBinomialPairQ[x^(m/p)*u,v,x]


(* IntBinomialQ[a,b,c,d,n,p,q,x] returns True iff (a+b*x^n)^p*(c+d*x^n)^q is integrable wrt x in terms of non-Appell functions. *)
IntBinomialQ[a_,b_,c_,d_,n_,p_,q_,x_Symbol] :=
  IntegersQ[p,q] || PositiveIntegerQ[p] || PositiveIntegerQ[q] || 
  (EqQ[n-2] || EqQ[n-4]) && (IntegersQ[p,4*q] || IntegersQ[4*p,q]) || 
  EqQ[n-2] && (IntegersQ[2*p,2*q] || IntegersQ[3*p,q] && EqQ[b*c+3*a*d] || IntegersQ[p,3*q] && EqQ[3*b*c+a*d])


(* ::Subsection::Closed:: *)
(*1.1.3.4 (e x)^m (a+b x^n)^p (c+d x^n)^q*)


Int[(e_.*x_)^m_.*(b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  e^m/(n*b^(Simplify[(m+1)/n]-1))*Subst[Int[(b*x)^(p+Simplify[(m+1)/n]-1)*(c+d*x)^q,x],x,x^n] /;
FreeQ[{b,c,d,e,m,n,p,q},x] && (IntegerQ[m] || PositiveQ[e]) && IntegerQ[Simplify[(m+1)/n]]


Int[(e_.*x_)^m_.*(b_.*x_^n_.)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  e^m*b^IntPart[p]*(b*x^n)^FracPart[p]/x^(n*FracPart[p])*Int[x^(m+n*p)*(c+d*x^n)^q,x] /;
FreeQ[{b,c,d,e,m,n,p,q},x] && (IntegerQ[m] || PositiveQ[e]) && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[(e_*x_)^m_*(b_.*x_^n_.)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{b,c,d,e,m,n,p,q},x] && Not[IntegerQ[m]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  1/n*Subst[Int[(a+b*x)^p*(c+d*x)^q,x],x,x^n] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && NeQ[b*c-a*d] && EqQ[m-n+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  Int[x^(m+n*(p+q))*(b+a*x^(-n))^p*(d+c*x^(-n))^q,x] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d] && IntegersQ[p,q] && NegQ[n]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a+b*x)^p*(c+d*x)^q,x],x,x^n] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && NeQ[b*c-a*d] && IntegerQ[Simplify[(m+1)/n]]


Int[(e_*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && NeQ[b*c-a*d] && IntegerQ[Simplify[(m+1)/n]]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  Int[ExpandIntegrand[(e*x)^m*(a+b*x^n)^p*(c+d*x^n)^q,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && PositiveIntegerQ[p,q]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*e*(m+1)) /;
FreeQ[{a,b,c,d,e,m,n,p},x] && NeQ[b*c-a*d] && EqQ[a*d*(m+1)-b*c*(m+n*(p+1)+1)] && NeQ[m+1]


Int[(e_.*x_)^m_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*(e*x)^(m+1)*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(a1*a2*e*(m+1)) /;
FreeQ[{a1,b1,a2,b2,c,d,e,m,n,p},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2] && EqQ[a1*a2*d*(m+1)-b1*b2*c*(m+n*(p+1)+1)] && 
  NeQ[m+1]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*e*(m+1)) + d/e^n*Int[(e*x)^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && EqQ[m+n*(p+1)+1] && (IntegerQ[n] || PositiveQ[e]) && 
  RationalQ[m,n] && (n>0 && m<-1 || n<0 && m+n>-1)


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  (b*c-a*d)*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*b*e*(m+1)) + d/b*Int[(e*x)^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && NeQ[b*c-a*d] && EqQ[m+n*(p+1)+1] && NeQ[m+1]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*e*(m+1)) + 
  (a*d*(m+1)-b*c*(m+n*(p+1)+1))/(a*e^n*(m+1))*Int[(e*x)^(m+n)*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && (IntegerQ[n] || PositiveQ[e]) && 
  RationalQ[m,n] && (n>0 && m<-1 || n<0 && m+n>-1) && Not[IntegerQ[p] && p<-1]


Int[(e_.*x_)^m_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  c*(e*x)^(m+1)*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(a1*a2*e*(m+1)) + 
  (a1*a2*d*(m+1)-b1*b2*c*(m+n*(p+1)+1))/(a1*a2*e^n*(m+1))*Int[(e*x)^(m+n)*(a1+b1*x^(n/2))^p*(a2+b2*x^(n/2))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,d,e,p},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2] && (IntegerQ[n] || PositiveQ[e]) && 
  RationalQ[m,n] && (n>0 && m<-1 || n<0 && m+n>-1) && Not[IntegerQ[p] && p<-1]


Int[x_^m_*(a_+b_.*x_^2)^p_*(c_+d_.*x_^2),x_Symbol] :=
  (-a)^(m/2-1)*(b*c-a*d)*x*(a+b*x^2)^(p+1)/(2*b^(m/2+1)*(p+1)) + 
  1/(2*b^(m/2+1)*(p+1))*Int[(a+b*x^2)^(p+1)*
    ExpandToSum[2*b*(p+1)*x^2*Together[(b^(m/2)*x^(m-2)*(c+d*x^2)-(-a)^(m/2-1)*(b*c-a*d))/(a+b*x^2)]-(-a)^(m/2-1)*(b*c-a*d),x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && RationalQ[p] && p<-1 && PositiveIntegerQ[m/2] && (IntegerQ[p] || m+2*p+1==0)


Int[x_^m_*(a_+b_.*x_^2)^p_*(c_+d_.*x_^2),x_Symbol] :=
  (-a)^(m/2-1)*(b*c-a*d)*x*(a+b*x^2)^(p+1)/(2*b^(m/2+1)*(p+1)) + 
  1/(2*b^(m/2+1)*(p+1))*Int[x^m*(a+b*x^2)^(p+1)*
    ExpandToSum[2*b*(p+1)*Together[(b^(m/2)*(c+d*x^2)-(-a)^(m/2-1)*(b*c-a*d)*x^(-m+2))/(a+b*x^2)]-
      (-a)^(m/2-1)*(b*c-a*d)*x^(-m),x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && RationalQ[p] && p<-1 && NegativeIntegerQ[m/2] && (IntegerQ[p] || m+2*p+1==0)


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  -(b*c-a*d)*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*b*e*n*(p+1)) - 
  (a*d*(m+1)-b*c*(m+n*(p+1)+1))/(a*b*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && RationalQ[p] && p<-1 && 
  (IntegerQ[p] || Not[RationalQ[m]] || PositiveIntegerQ[n] && NegativeIntegerQ[p+1/2] && -1<=m<=-n*(p+1))


Int[(e_.*x_)^m_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  -(b1*b2*c-a1*a2*d)*(e*x)^(m+1)*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(a1*a2*b1*b2*e*n*(p+1)) - 
  (a1*a2*d*(m+1)-b1*b2*c*(m+n*(p+1)+1))/(a1*a2*b1*b2*n*(p+1))*Int[(e*x)^m*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1),x] /;
FreeQ[{a1,b1,a2,b2,c,d,e,m,n},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2] && RationalQ[p] && p<-1 && 
  (IntegerQ[p] || Not[RationalQ[m]] || PositiveIntegerQ[n] && NegativeIntegerQ[p+1/2] && -1<=m<=-n*(p+1))


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  d*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(b*e*(m+n*(p+1)+1)) - 
  (a*d*(m+1)-b*c*(m+n*(p+1)+1))/(b*(m+n*(p+1)+1))*Int[(e*x)^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && NeQ[b*c-a*d] && NeQ[m+n*(p+1)+1]


Int[(e_.*x_)^m_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_),x_Symbol] :=
  d*(e*x)^(m+1)*(a1+b1*x^(n/2))^(p+1)*(a2+b2*x^(n/2))^(p+1)/(b1*b2*e*(m+n*(p+1)+1)) - 
  (a1*a2*d*(m+1)-b1*b2*c*(m+n*(p+1)+1))/(b1*b2*(m+n*(p+1)+1))*Int[(e*x)^m*(a1+b1*x^(n/2))^p*(a2+b2*x^(n/2))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,d,e,m,n,p},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2] && NeQ[m+n*(p+1)+1]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_/(c_+d_.*x_^n_),x_Symbol] :=
  Int[ExpandIntegrand[(e*x)^m*(a+b*x^n)^p/(c+d*x^n),x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && PositiveIntegerQ[p] && 
  (IntegerQ[m] || PositiveIntegerQ[2*(m+1)] || Not[RationalQ[m]])


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^2,x_Symbol] :=
  c^2*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*e*(m+1)) - 
  1/(a*e^n*(m+1))*Int[(e*x)^(m+n)*(a+b*x^n)^p*Simp[b*c^2*n*(p+1)+c*(b*c-2*a*d)*(m+1)-a*(m+1)*d^2*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,n] && m<-1 && n>0


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^2,x_Symbol] :=
  -(b*c-a*d)^2*(e*x)^(m+1)*(a+b*x^n)^(p+1)/(a*b^2*e*n*(p+1)) + 
  1/(a*b^2*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1)*Simp[(b*c-a*d)^2*(m+1)+b^2*c^2*n*(p+1)+a*b*d^2*n*(p+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^2,x_Symbol] :=
  d^2*(e*x)^(m+n+1)*(a+b*x^n)^(p+1)/(b*e^(n+1)*(m+n*(p+2)+1)) + 
  1/(b*(m+n*(p+2)+1))*Int[(e*x)^m*(a+b*x^n)^p*Simp[b*c^2*(m+n*(p+2)+1)+d*((2*b*c-a*d)*(m+n+1)+2*b*c*n*(p+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && NeQ[m+n*(p+2)+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(a+b*x^(n/k))^p*(c+d*x^(n/k))^q,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,b,c,d,p,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/e*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n)/e^n)^p*(c+d*x^(k*n)/e^n)^q,x],x,(e*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,p,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && FractionQ[m] && IntegerQ[p]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^(n-1)*(e*x)^(m-n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(b*n*(p+1)) - 
  e^n/(b*n*(p+1))*Int[(e*x)^(m-n)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*Simp[c*(m-n+1)+d*(m+n*(q-1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,p,q] && p<-1 && q>0 && m-n+1>0 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -(c*b-a*d)*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(a*b*e*n*(p+1)) + 
  1/(a*b*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-2)*
    Simp[c*(c*b*n*(p+1)+(c*b-a*d)*(m+1))+d*(c*b*n*(p+1)+(c*b-a*d)*(m+n*(q-1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[p,q] && p<-1 && q>1 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*e*n*(p+1)) + 
  1/(a*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*Simp[c*(m+n*(p+1)+1)+d*(m+n*(p+q+1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[p,q] && p<-1 && 0<q<1 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -a*e^(2*n-1)*(e*x)^(m-2*n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(b*n*(b*c-a*d)*(p+1)) + 
  e^(2*n)/(b*n*(b*c-a*d)*(p+1))*Int[(e*x)^(m-2*n)*(a+b*x^n)^(p+1)*(c+d*x^n)^q*
    Simp[a*c*(m-2*n+1)+(a*d*(m-n+n*q+1)+b*c*n*(p+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m-n+1>n && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^(n-1)*(e*x)^(m-n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(n*(b*c-a*d)*(p+1)) - 
  e^n/(n*(b*c-a*d)*(p+1))*Int[(e*x)^(m-n)*(a+b*x^n)^(p+1)*(c+d*x^n)^q*Simp[c*(m-n+1)+d*(m+n*(p+q+1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && n>=m-n+1>0 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -b*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*e*n*(b*c-a*d)*(p+1)) + 
  1/(a*n*(b*c-a*d)*(p+1))*
    Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^q*Simp[c*b*(m+1)+n*(b*c-a*d)*(p+1)+d*b*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (e*x)^(m+1)*(a+b*x^n)^p*(c+d*x^n)^q/(e*(m+1)) - 
  n/(e^n*(m+1))*Int[(e*x)^(m+n)*(a+b*x^n)^(p-1)*(c+d*x^n)^(q-1)*Simp[b*c*p+a*d*q+b*d*(p+q)*x^n,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,p,q] && q>0 && m<-1 && p>0 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  c*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(a*e*(m+1)) - 
  1/(a*e^n*(m+1))*Int[(e*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^(q-2)*
    Simp[c*(c*b-a*d)*(m+1)+c*n*(b*c*(p+1)+a*d*(q-1))+d*((c*b-a*d)*(m+1)+c*b*n*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,q] && q>1 && m<-1 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*e*(m+1)) - 
  1/(a*e^n*(m+1))*Int[(e*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^(q-1)*
    Simp[c*b*(m+1)+n*(b*c*(p+1)+a*d*q)+d*(b*(m+1)+b*n*(p+q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,q] && 0<q<1 && m<-1 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (e*x)^(m+1)*(a+b*x^n)^p*(c+d*x^n)^q/(e*(m+n*(p+q)+1)) + 
  n/(m+n*(p+q)+1)*Int[(e*x)^m*(a+b*x^n)^(p-1)*(c+d*x^n)^(q-1)*Simp[a*c*(p+q)+(q*(b*c-a*d)+a*d*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[p,q] && q>0 && p>0 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  d*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(b*e*(m+n*(p+q)+1)) + 
  1/(b*(m+n*(p+q)+1))*Int[(e*x)^m*(a+b*x^n)^p*(c+d*x^n)^(q-2)*
    Simp[c*((c*b-a*d)*(m+1)+c*b*n*(p+q))+(d*(c*b-a*d)*(m+1)+d*n*(q-1)*(b*c-a*d)+c*b*d*n*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[q] && q>1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^(n-1)*(e*x)^(m-n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(b*(m+n*(p+q)+1)) - 
  e^n/(b*(m+n*(p+q)+1))*
    Int[(e*x)^(m-n)*(a+b*x^n)^p*(c+d*x^n)^(q-1)*Simp[a*c*(m-n+1)+(a*d*(m-n+1)-n*q*(b*c-a*d))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m,q] && q>0 && m-n+1>0 && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^(2*n-1)*(e*x)^(m-2*n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(b*d*(m+n*(p+q)+1)) - 
  e^(2*n)/(b*d*(m+n*(p+q)+1))*
    Int[(e*x)^(m-2*n)*(a+b*x^n)^p*(c+d*x^n)^q*Simp[a*c*(m-2*n+1)+(a*d*(m+n*(q-1)+1)+b*c*(m+n*(p-1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m] && m-n+1>n && 
  IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*c*e*(m+1)) - 
  1/(a*c*e^n*(m+1))*
    Int[(e*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^q*Simp[(b*c+a*d)*(m+n+1)+n*(b*c*p+a*d*q)+b*d*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,p,q},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_./((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  -a*e^n/(b*c-a*d)*Int[(e*x)^(m-n)/(a+b*x^n),x] + c*e^n/(b*c-a*d)*Int[(e*x)^(m-n)/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n] && RationalQ[m] && n<=m<=2*n-1


Int[(e_.*x_)^m_./((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  b/(b*c-a*d)*Int[(e*x)^m/(a+b*x^n),x] - d/(b*c-a*d)*Int[(e*x)^m/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b*c-a*d] && PositiveIntegerQ[n]


Int[x_^m_/((a_+b_.*x_^n_)*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  1/b*Int[x^(m-n)/Sqrt[c+d*x^n],x] - a/b*Int[x^(m-n)/((a+b*x^n)*Sqrt[c+d*x^n]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && IntegersQ[m/2,n/2] && 0<m-n+1<n && n<=4


Int[x_^2/((a_+b_.*x_^4)*Sqrt[c_+d_.*x_^4]),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,2]], s=Denominator[Rt[-a/b,2]]},
  s/(2*b)*Int[1/((r+s*x^2)*Sqrt[c+d*x^4]),x] - s/(2*b)*Int[1/((r-s*x^2)*Sqrt[c+d*x^4]),x]] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d]


Int[x_/((a_+b_.*x_^3)*Sqrt[c_+d_.*x_^3]),x_Symbol] :=
  With[{q=Rt[d/c,3]},
  -q*ArcTan[1/Sqrt[3]+2^(2/3)*(Sqrt[c]-Sqrt[c+d*x^3])/(Sqrt[3]*Sqrt[c]*q*x)]/(3*2^(2/3)*Sqrt[3]*b*Sqrt[c]) + 
  q*ArcTan[1/Sqrt[3]+2^(2/3)*(Sqrt[c]+Sqrt[c+d*x^3])/(Sqrt[3]*Sqrt[c]*q*x)]/(3*2^(2/3)*Sqrt[3]*b*Sqrt[c]) + 
  q*ArcTanh[Sqrt[c+d*x^3]/Sqrt[c]]/(9*2^(2/3)*b*Sqrt[c]) + 
  q*Log[1-2^(1/3)*q*x-Sqrt[c+d*x^3]/Sqrt[c]]/(6*2^(2/3)*b*Sqrt[c]) - 
  q*Log[1-2^(1/3)*q*x+Sqrt[c+d*x^3]/Sqrt[c]]/(6*2^(2/3)*b*Sqrt[c])] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && EqQ[4*b*c-a*d]


Int[x_^m_/((a_+b_.*x_^3)*Sqrt[c_+d_.*x_^3]),x_Symbol] :=
  1/b*Int[x^(m-3)/Sqrt[c+d*x^3],x] - a/b*Int[x^(m-3)/((a+b*x^3)*Sqrt[c+d*x^3]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && EqQ[4*b*c-a*d] && PositiveIntegerQ[(m-1)/3]


Int[x_^m_/((a_+b_.*x_^3)*Sqrt[c_+d_.*x_^3]),x_Symbol] :=
  1/a*Int[x^m/Sqrt[c+d*x^3],x] - b/a*Int[x^(m+3)/((a+b*x^3)*Sqrt[c+d*x^3]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && EqQ[4*b*c-a*d] && NegativeIntegerQ[(m-1)/3]


Int[x_^2*Sqrt[c_+d_.*x_^4]/(a_+b_.*x_^4),x_Symbol] :=
  d/b*Int[x^2/Sqrt[c+d*x^4],x] + (b*c-a*d)/b*Int[x^2/((a+b*x^4)*Sqrt[c+d*x^4]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d]


Int[x_^m_.*Sqrt[c_+d_.*x_^3]/(a_+b_.*x_^3),x_Symbol] :=
  d/b*Int[x^m/Sqrt[c+d*x^3],x] + (b*c-a*d)/b*Int[x^m/((a+b*x^3)*Sqrt[c+d*x^3]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && EqQ[4*b*c-a*d] && IntegerQ[(m-1)/3]


Int[x_^2/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  x*Sqrt[a+b*x^2]/(b*Sqrt[c+d*x^2]) - c/b*Int[Sqrt[a+b*x^2]/(c+d*x^2)^(3/2),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && PosQ[b/a] && PosQ[d/c] && Not[SimplerSqrtQ[b/a,d/c]]


Int[x_^n_/(Sqrt[a_+b_.*x_^n_]*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  1/b*Int[Sqrt[a+b*x^n]/Sqrt[c+d*x^n],x] - a/b*Int[1/(Sqrt[a+b*x^n]*Sqrt[c+d*x^n]),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d] && (EqQ[n,2] || EqQ[n,4]) && Not[EqQ[n,2] && SimplerSqrtQ[-b/a,-d/c]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  With[{k=Denominator[p]},
  k*a^(p+(m+1)/n)/n*
	Subst[Int[x^(k*(m+1)/n-1)*(c-(b*c-a*d)*x^k)^q/(1-b*x^k)^(p+q+(m+1)/n+1),x],x,x^(n/k)/(a+b*x^n)^(1/k)]] /;
FreeQ[{a,b,c,d},x] && PositiveIntegerQ[n] && RationalQ[m,p] && IntegersQ[p+(m+1)/n,q] && -1<p<0


Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,p,q},x] && NeQ[b*c-a*d] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  With[{g=Denominator[m]},
  -g/e*Subst[Int[(a+b*e^(-n)*x^(-g*n))^p*(c+d*e^(-n)*x^(-g*n))^q/x^(g*(m+1)+1),x],x,1/(e*x)^(1/g)]] /;
FreeQ[{a,b,c,d,e,p,q},x] && NegativeIntegerQ[n] && FractionQ[m]


Int[(e_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -(e*x)^m*(x^(-1))^m*Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,e,m,p,q},x] && NeQ[b*c-a*d] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g*(m+1)-1)*(a+b*x^(g*n))^p*(c+d*x^(g*n))^q,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,d,m,p,q},x] && NeQ[b*c-a*d] && FractionQ[n]


Int[(e_*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,m,p,q},x] && NeQ[b*c-a*d] && FractionQ[n]


(* Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -1/(m+1)*Subst[Int[(a+b*x^Simplify[-n/(m+1)])^p*(c+d*x^Simplify[-n/(m+1)])^q/x^2,x],x,x^(-(m+1))] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d] && NeQ[m+1] && NegativeIntegerQ[Simplify[n/(m+1)+1]] && 
  RationalQ[p,q] && -1<=p<0 && -1<=q<0 && Not[IntegerQ[n]] *)


Int[x_^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  1/(m+1)*Subst[Int[(a+b*x^Simplify[n/(m+1)])^p*(c+d*x^Simplify[n/(m+1)])^q,x],x,x^(m+1)] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && NeQ[b*c-a*d] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(e_*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && NeQ[b*c-a*d] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -(c*b-a*d)*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(a*b*e*n*(p+1)) + 
  1/(a*b*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-2)*
    Simp[c*(c*b*n*(p+1)+(c*b-a*d)*(m+1))+d*(c*b*n*(p+1)+(c*b-a*d)*(m+n*(q-1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && RationalQ[p,q] && p<-1 && q>1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*e*n*(p+1)) + 
  1/(a*n*(p+1))*Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*Simp[c*(m+n*(p+1)+1)+d*(m+n*(p+q+1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && RationalQ[p,q] && p<-1 && 0<q<1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  -b*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*e*n*(b*c-a*d)*(p+1)) + 
  1/(a*n*(b*c-a*d)*(p+1))*
    Int[(e*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^q*Simp[c*b*(m+1)+n*(b*c-a*d)*(p+1)+d*b*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n,q},x] && NeQ[b*c-a*d] && RationalQ[p] && p<-1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  (e*x)^(m+1)*(a+b*x^n)^p*(c+d*x^n)^q/(e*(m+n*(p+q)+1)) + 
  n/(m+n*(p+q)+1)*Int[(e*x)^m*(a+b*x^n)^(p-1)*(c+d*x^n)^(q-1)*Simp[a*c*(p+q)+(q*(b*c-a*d)+a*d*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && RationalQ[p,q] && q>0 && p>0 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  d*(e*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)/(b*e*(m+n*(p+q)+1)) + 
  1/(b*(m+n*(p+q)+1))*Int[(e*x)^m*(a+b*x^n)^p*(c+d*x^n)^(q-2)*
    Simp[c*((c*b-a*d)*(m+1)+c*b*n*(p+q))+(d*(c*b-a*d)*(m+1)+d*n*(q-1)*(b*c-a*d)+c*b*d*n*(p+q))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && NeQ[b*c-a*d] && RationalQ[q] && q>1 && IntBinomialQ[a,b,c,d,e,m,n,p,q,x]


Int[x_^m_/((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  -a/(b*c-a*d)*Int[x^(m-n)/(a+b*x^n),x] + c/(b*c-a*d)*Int[x^(m-n)/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,m,n},x] && NeQ[b*c-a*d] && (EqQ[m-n] || EqQ[m-2*n+1])


Int[(e_.*x_)^m_./((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  b/(b*c-a*d)*Int[(e*x)^m/(a+b*x^n),x] - d/(b*c-a*d)*Int[(e*x)^m/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,e,n,m},x] && NeQ[b*c-a*d]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  Int[ExpandIntegrand[(e*x)^m*(a+b*x^n)^p*(c+d*x^n)^q,x],x] /;
FreeQ[{a,b,c,d,e,m,n},x] && NeQ[b*c-a*d] && IntegersQ[m,p,q] && p>=-2 && (q>=-2 || q==-3 && IntegerQ[(m-1)/2])


Int[x_^m_.*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.,x_Symbol] :=
  Int[x^(m-n*q)*(a+b*x^n)^p*(d+c*x^n)^q,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[mn,-n] && IntegerQ[q] && (PosQ[n] || Not[IntegerQ[p]])


Int[x_^m_.*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_,x_Symbol] :=
  x^(n*FracPart[q])*(c+d*x^(-n))^FracPart[q]/(d+c*x^n)^FracPart[q]*Int[x^(m-n*q)*(a+b*x^n)^p*(d+c*x^n)^q,x] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && EqQ[mn,-n] && Not[IntegerQ[q]] && Not[IntegerQ[p]]


Int[(e_*x_)^m_*(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^(-n))^q,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[mn,-n]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  a^p*c^q*(e*x)^(m+1)/(e*(m+1))*AppellF1[(m+1)/n,-p,-q,1+(m+1)/n,-b*x^n/a,-d*x^n/c] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && NeQ[b*c-a*d] && NeQ[m+1] && NeQ[m-n+1] && PositiveQ[a] && PositiveQ[c]


Int[(e_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n)^FracPart[p]/(1+b*x^n/a)^FracPart[p]*Int[(e*x)^m*(1+b*x^n/a)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && NeQ[b*c-a*d] && NeQ[m+1] && NeQ[m-n+1] && Not[PositiveQ[a]]


Int[x_^m_.*(a_.+b_.*v_^n_)^p_.*(c_.+d_.*v_^n_)^q_.,x_Symbol] :=
  1/Coefficient[v,x,1]^(m+1)*Subst[Int[SimplifyIntegrand[(x-Coefficient[v,x,0])^m*(a+b*x^n)^p*(c+d*x^n)^q,x],x],x,v] /;
FreeQ[{a,b,c,d,n,p,q},x] && LinearQ[v,x] && IntegerQ[m] && NeQ[v-x]


Int[u_^m_.*(a_.+b_.*v_^n_)^p_.*(c_.+d_.*v_^n_)^q_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q,x],x,v] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && LinearPairQ[u,v,x]


(* IntBinomialQ[a,b,c,d,e,m,n,p,q,x] returns True iff (e*x)^m*(a+b*x^n)^p*(c+d*x^n)^q is integrable wrt x in terms of non-Appell functions. *)
IntBinomialQ[a_,b_,c_,d_,e_,m_,n_,p_,q_,x_Symbol] :=
  IntegersQ[p,q] || PositiveIntegerQ[p] || PositiveIntegerQ[q] || 
  EqQ[n-2] && IntegerQ[m] && IntegersQ[2*p,2*q] || 
  EqQ[n-4] && (IntegersQ[m,p,2*q] || IntegersQ[m,2*p,q])


Int[u_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  Int[u*(a1*a2+b1*b2*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a1,b1,a2,b2,c,d,n,p,q},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2] && (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[u_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_.+e_.*x_^n2_.)^q_.,x_Symbol] :=
  Int[u*(a1*a2+b1*b2*x^n)^p*(c+d*x^n+e*x^(2*n))^q,x] /;
FreeQ[{a1,b1,a2,b2,c,d,e,n,p,q},x] && EqQ[non2-n/2] && EqQ[n2-2*n] && EqQ[a2*b1+a1*b2] && 
  (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[u_.*(a1_+b1_.*x_^non2_.)^p_*(a2_+b2_.*x_^non2_.)^p_*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  (a1+b1*x^(n/2))^FracPart[p]*(a2+b2*x^(n/2))^FracPart[p]/(a1*a2+b1*b2*x^n)^FracPart[p]*
    Int[u*(a1*a2+b1*b2*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a1,b1,a2,b2,c,d,n,p,q},x] && EqQ[non2-n/2] && EqQ[a2*b1+a1*b2]


Int[u_.*(a1_+b1_.*x_^non2_.)^p_.*(a2_+b2_.*x_^non2_.)^p_.*(c_+d_.*x_^n_.+e_.*x_^n2_.)^q_.,x_Symbol] :=
  (a1+b1*x^(n/2))^FracPart[p]*(a2+b2*x^(n/2))^FracPart[p]/(a1*a2+b1*b2*x^n)^FracPart[p]*
    Int[u*(a1*a2+b1*b2*x^n)^p*(c+d*x^n+e*x^(2*n))^q,x] /;
FreeQ[{a1,b1,a2,b2,c,d,e,n,p,q},x] && EqQ[non2-n/2] && EqQ[n2-2*n] && EqQ[a2*b1+a1*b2]





(* ::Subsection::Closed:: *)
(*1.1.3.5 (a+b x^n)^p (c+d x^n)^q (e+f x^n)^r*)


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && PositiveIntegerQ[p,q,r]


Int[(e_+f_.*x_^n_)/((a_+b_.*x_^n_)*(c_+d_.*x_^n_)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[1/(a+b*x^n),x] - 
  (d*e-c*f)/(b*c-a*d)*Int[1/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,e,f,n},x]


Int[(e_+f_.*x_^n_)/((a_+b_.*x_^n_)*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  f/b*Int[1/Sqrt[c+d*x^n],x] + 
  (b*e-a*f)/b*Int[1/((a+b*x^n)*Sqrt[c+d*x^n]),x] /;
FreeQ[{a,b,c,d,e,f,n},x]


Int[(e_+f_.*x_^n_)/(Sqrt[a_+b_.*x_^n_]*Sqrt[c_+d_.*x_^n_]),x_Symbol] :=
  f/b*Int[Sqrt[a+b*x^n]/Sqrt[c+d*x^n],x] + 
  (b*e-a*f)/b*Int[1/(Sqrt[a+b*x^n]*Sqrt[c+d*x^n]),x] /;
FreeQ[{a,b,c,d,e,f,n},x] && 
  Not[EqQ[n-2] && (PosQ[b/a] && PosQ[d/c] || NegQ[b/a] && (PosQ[d/c] || PositiveQ[a] && (Not[PositiveQ[c]] || SimplerSqrtQ[-b/a,-d/c])))]


Int[(e_+f_.*x_^2)/(Sqrt[a_+b_.*x_^2]*(c_+d_.*x_^2)^(3/2)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[1/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]),x] - 
  (d*e-c*f)/(b*c-a*d)*Int[Sqrt[a+b*x^2]/(c+d*x^2)^(3/2),x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[b/a] && PosQ[d/c]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*x*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*b*n*(p+1)) + 
  1/(a*b*n*(p+1))*
    Int[(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*Simp[c*(b*e*n*(p+1)+b*e-a*f)+d*(b*e*n*(p+1)+(b*e-a*f)*(n*q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && RationalQ[p,q] && p<-1 && q>0


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*n*(b*c-a*d)*(p+1)) + 
  1/(a*n*(b*c-a*d)*(p+1))*
    Int[(a+b*x^n)^(p+1)*(c+d*x^n)^q*Simp[c*(b*e-a*f)+e*n*(b*c-a*d)*(p+1)+d*(b*e-a*f)*(n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n,q},x] && RationalQ[p] && p<-1


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  f*x*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(b*(n*(p+q+1)+1)) + 
  1/(b*(n*(p+q+1)+1))*
    Int[(a+b*x^n)^p*(c+d*x^n)^(q-1)*Simp[c*(b*e-a*f+b*e*n*(p+q+1))+(d*(b*e-a*f)+f*n*q*(b*c-a*d)+b*d*e*n*(p+q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && RationalQ[q] && q>0 && NeQ[n*(p+q+1)+1]


Int[(e_+f_.*x_^4)/((a_+b_.*x_^4)^(3/4)*(c_+d_.*x_^4)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[1/(a+b*x^4)^(3/4),x] - (d*e-c*f)/(b*c-a*d)*Int[(a+b*x^4)^(1/4)/(c+d*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[(a_+b_.*x_^n_)^p_*(e_+f_.*x_^n_)/(c_+d_.*x_^n_),x_Symbol] :=
  f/d*Int[(a+b*x^n)^p,x] + (d*e-c*f)/d*Int[(a+b*x^n)^p/(c+d*x^n),x] /;
FreeQ[{a,b,c,d,e,f,p,n},x]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  e*Int[(a+b*x^n)^p*(c+d*x^n)^q,x] + f*Int[x^n*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,f,n,p,q},x]


Int[1/((a_+b_.*x_^2)*(c_+d_.*x_^2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  b/(b*c-a*d)*Int[1/((a+b*x^2)*Sqrt[e+f*x^2]),x] - 
  d/(b*c-a*d)*Int[1/((c+d*x^2)*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[1/(x_^2*(c_+d_.*x_^2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  1/c*Int[1/(x^2*Sqrt[e+f*x^2]),x] - 
  d/c*Int[1/((c+d*x^2)*Sqrt[e+f*x^2]),x] /;
FreeQ[{c,d,e,f},x] && NeQ[d*e-c*f]


Int[Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]/(a_+b_.*x_^2),x_Symbol] :=
  d/b*Int[Sqrt[e+f*x^2]/Sqrt[c+d*x^2],x] + (b*c-a*d)/b*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && PositiveQ[d/c] && PositiveQ[f/e] && Not[SimplerSqrtQ[d/c,f/e]]


Int[Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]/(a_+b_.*x_^2),x_Symbol] :=
  d/b*Int[Sqrt[e+f*x^2]/Sqrt[c+d*x^2],x] + (b*c-a*d)/b*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[SimplerSqrtQ[-f/e,-d/c]]


Int[1/((a_+b_.*x_^2)*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  -f/(b*e-a*f)*Int[1/(Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] + 
  b/(b*e-a*f)*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c] && PosQ[f/e] && Not[SimplerSqrtQ[d/c,f/e]]


Int[1/((a_+b_.*x_^2)*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  1/(a*Sqrt[c]*Sqrt[e]*Rt[-d/c,2])*EllipticPi[b*c/(a*d), ArcSin[Rt[-d/c,2]*x], c*f/(d*e)] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[d/c] && PositiveQ[c] && PositiveQ[e] && Not[NegQ[f/e] && SimplerSqrtQ[-f/e,-d/c]]


Int[1/((a_+b_.*x_^2)*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  Sqrt[1+d/c*x^2]/Sqrt[c+d*x^2]*Int[1/((a+b*x^2)*Sqrt[1+d/c*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && Not[PositiveQ[c]]


Int[Sqrt[c_+d_.*x_^2]/((a_+b_.*x_^2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  c*Sqrt[e+f*x^2]/(a*e*Rt[d/c,2]*Sqrt[c+d*x^2]*Sqrt[c*(e+f*x^2)/(e*(c+d*x^2))])*
    EllipticPi[1-b*c/(a*d),ArcTan[Rt[d/c,2]*x],1-c*f/(d*e)] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c]


(* Int[Sqrt[c_+d_.*x_^2]/((a_+b_.*x_^2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  Sqrt[c+d*x^2]*Sqrt[c*(e+f*x^2)/(e*(c+d*x^2))]/(a*Rt[d/c,2]*Sqrt[e+f*x^2])*
    EllipticPi[1-b*c/(a*d),ArcTan[Rt[d/c,2]*x],1-c*f/(d*e)] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c] *)


Int[Sqrt[c_+d_.*x_^2]/((a_+b_.*x_^2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  d/b*Int[1/(Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] + 
  (b*c-a*d)/b*Int[1/((a+b*x^2)*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[d/c]


Int[Sqrt[e_+f_.*x_^2]/((a_+b_.*x_^2)*(c_+d_.*x_^2)^(3/2)),x_Symbol] :=
  b/(b*c-a*d)*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] - 
  d/(b*c-a*d)*Int[Sqrt[e+f*x^2]/(c+d*x^2)^(3/2),x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c] && PosQ[f/e]


Int[(e_+f_.*x_^2)^(3/2)/((a_+b_.*x_^2)*(c_+d_.*x_^2)^(3/2)),x_Symbol] :=
  (b*e-a*f)/(b*c-a*d)*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] - 
  (d*e-c*f)/(b*c-a*d)*Int[Sqrt[e+f*x^2]/(c+d*x^2)^(3/2),x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c] && PosQ[f/e]


Int[(c_+d_.*x_^2)^(3/2)*Sqrt[e_+f_.*x_^2]/(a_+b_.*x_^2),x_Symbol] :=
  (b*c-a*d)^2/b^2*Int[Sqrt[e+f*x^2]/((a+b*x^2)*Sqrt[c+d*x^2]),x] + 
  d/b^2*Int[(2*b*c-a*d+b*d*x^2)*Sqrt[e+f*x^2]/Sqrt[c+d*x^2],x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[d/c] && PosQ[f/e]


Int[(c_+d_.*x_^2)^q_*(e_+f_.*x_^2)^r_/(a_+b_.*x_^2),x_Symbol] :=
  b*(b*e-a*f)/(b*c-a*d)^2*Int[(c+d*x^2)^(q+2)*(e+f*x^2)^(r-1)/(a+b*x^2),x] - 
  1/(b*c-a*d)^2*Int[(c+d*x^2)^q*(e+f*x^2)^(r-1)*(2*b*c*d*e-a*d^2*e-b*c^2*f+d^2*(b*e-a*f)*x^2),x] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[q,r] && q<-1 && r>1


Int[(c_+d_.*x_^2)^q_*(e_+f_.*x_^2)^r_/(a_+b_.*x_^2),x_Symbol] :=
  d/b*Int[(c+d*x^2)^(q-1)*(e+f*x^2)^r,x] + 
  (b*c-a*d)/b*Int[(c+d*x^2)^(q-1)*(e+f*x^2)^r/(a+b*x^2),x] /;
FreeQ[{a,b,c,d,e,f,r},x] && RationalQ[q] && q>1


Int[(c_+d_.*x_^2)^q_*(e_+f_.*x_^2)^r_/(a_+b_.*x_^2),x_Symbol] :=
  b^2/(b*c-a*d)^2*Int[(c+d*x^2)^(q+2)*(e+f*x^2)^r/(a+b*x^2),x] - 
  d/(b*c-a*d)^2*Int[(c+d*x^2)^q*(e+f*x^2)^r*(2*b*c-a*d+b*d*x^2),x] /;
FreeQ[{a,b,c,d,e,f,r},x] && RationalQ[q] && q<-1


Int[(c_+d_.*x_^2)^q_*(e_+f_.*x_^2)^r_/(a_+b_.*x_^2),x_Symbol] :=
  -d/(b*c-a*d)*Int[(c+d*x^2)^q*(e+f*x^2)^r,x] + 
  b/(b*c-a*d)*Int[(c+d*x^2)^(q+1)*(e+f*x^2)^r/(a+b*x^2),x] /;
FreeQ[{a,b,c,d,e,f,r},x] && RationalQ[q] && q<=-1


Int[Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]/(a_+b_.*x_^2)^2,x_Symbol] :=
  x*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]/(2*a*(a+b*x^2)) + 
  d*f/(2*a*b^2)*Int[(a-b*x^2)/(Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] + 
  (b^2*c*e-a^2*d*f)/(2*a*b^2)*Int[1/((a+b*x^2)*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[1/((a_+b_.*x_^2)^2*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  b^2*x*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]/(2*a*(b*c-a*d)*(b*e-a*f)*(a+b*x^2)) - 
  d*f/(2*a*(b*c-a*d)*(b*e-a*f))*Int[(a+b*x^2)/(Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] + 
  (b^2*c*e+3*a^2*d*f-2*a*b*(d*e+c*f))/(2*a*(b*c-a*d)*(b*e-a*f))*Int[1/((a+b*x^2)*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_)^r_,x_Symbol] :=
  d/b*Int[(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*(e+f*x^n)^r,x] + 
  (b*c-a*d)/b*Int[(a+b*x^n)^p*(c+d*x^n)^(q-1)*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,n,r},x] && NegativeIntegerQ[p] && RationalQ[q] && q>0


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_)^r_,x_Symbol] :=
  b/(b*c-a*d)*Int[(a+b*x^n)^p*(c+d*x^n)^(q+1)*(e+f*x^n)^r,x] - 
  d/(b*c-a*d)*Int[(a+b*x^n)^(p+1)*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,n,q},x] && NegativeIntegerQ[p] && RationalQ[q] && q<=-1


Int[1/(Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  Sqrt[c+d*x^2]*Sqrt[a*(e+f*x^2)/(e*(a+b*x^2))]/(c*Sqrt[e+f*x^2]*Sqrt[a*(c+d*x^2)/(c*(a+b*x^2))])*
    Subst[Int[1/(Sqrt[1-(b*c-a*d)*x^2/c]*Sqrt[1-(b*e-a*f)*x^2/e]),x],x,x/Sqrt[a+b*x^2]] /;
FreeQ[{a,b,c,d,e,f},x]


Int[Sqrt[a_+b_.*x_^2]/(Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  a*Sqrt[c+d*x^2]*Sqrt[a*(e+f*x^2)/(e*(a+b*x^2))]/(c*Sqrt[e+f*x^2]*Sqrt[a*(c+d*x^2)/(c*(a+b*x^2))])*
    Subst[Int[1/((1-b*x^2)*Sqrt[1-(b*c-a*d)*x^2/c]*Sqrt[1-(b*e-a*f)*x^2/e]),x],x,x/Sqrt[a+b*x^2]] /;
FreeQ[{a,b,c,d,e,f},x]


Int[Sqrt[c_+d_.*x_^2]/((a_+b_.*x_^2)^(3/2)*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  Sqrt[c+d*x^2]*Sqrt[a*(e+f*x^2)/(e*(a+b*x^2))]/(a*Sqrt[e+f*x^2]*Sqrt[a*(c+d*x^2)/(c*(a+b*x^2))])*
    Subst[Int[Sqrt[1-(b*c-a*d)*x^2/c]/Sqrt[1-(b*e-a*f)*x^2/e],x],x,x/Sqrt[a+b*x^2]] /;
FreeQ[{a,b,c,d,e,f},x]


Int[Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]/Sqrt[e_+f_.*x_^2],x_Symbol] :=
  d*x*Sqrt[a+b*x^2]*Sqrt[e+f*x^2]/(2*f*Sqrt[c+d*x^2]) - 
  c*(d*e-c*f)/(2*f)*Int[Sqrt[a+b*x^2]/((c+d*x^2)^(3/2)*Sqrt[e+f*x^2]),x] + 
  b*c*(d*e-c*f)/(2*d*f)*Int[1/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] - 
  (b*d*e-b*c*f-a*d*f)/(2*d*f)*Int[Sqrt[c+d*x^2]/(Sqrt[a+b*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[(d*e-c*f)/c]


Int[Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]/Sqrt[e_+f_.*x_^2],x_Symbol] :=
  x*Sqrt[a+b*x^2]*Sqrt[c+d*x^2]/(2*Sqrt[e+f*x^2]) + 
  e*(b*e-a*f)/(2*f)*Int[Sqrt[c+d*x^2]/(Sqrt[a+b*x^2]*(e+f*x^2)^(3/2)),x] + 
  (b*e-a*f)*(d*e-2*c*f)/(2*f^2)*Int[1/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] - 
  (b*d*e-b*c*f-a*d*f)/(2*f^2)*Int[Sqrt[e+f*x^2]/(Sqrt[a+b*x^2]*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[(d*e-c*f)/c]


Int[Sqrt[a_+b_.*x_^2]*Sqrt[c_+d_.*x_^2]/(e_+f_.*x_^2)^(3/2),x_Symbol] :=
  b/f*Int[Sqrt[c+d*x^2]/(Sqrt[a+b*x^2]*Sqrt[e+f*x^2]),x] - 
  (b*e-a*f)/f*Int[Sqrt[c+d*x^2]/(Sqrt[a+b*x^2]*(e+f*x^2)^(3/2)),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_)^r_,x_Symbol] :=
  With[{u=ExpandIntegrand[(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && PositiveIntegerQ[n]


Int[(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_)^r_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q*(e+f*x^(-n))^r/x^2,x],x,1/x] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && NegativeIntegerQ[n]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  Defer[Int][(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,n,p,q,r},x]


Int[(a_.+b_.*u_^n_)^p_.*(c_.+d_.*v_^n_)^q_.*(e_.+f_.*w_^n_)^r_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x],x,u] /;
FreeQ[{a,b,c,d,e,f,p,n,q,r},x] && EqQ[u-v] && EqQ[u-w] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  Int[(a+b*x^n)^p*(d+c*x^n)^q*(e+f*x^n)^r/x^(n*q),x] /;
FreeQ[{a,b,c,d,e,f,n,p,r},x] && EqQ[mn,-n] && IntegerQ[q]


Int[(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  Int[x^(n*(p+r))*(b+a*x^(-n))^p*(c+d*x^(-n))^q*(f+e*x^(-n))^r,x] /;
FreeQ[{a,b,c,d,e,f,n,q},x] && EqQ[mn,-n] && IntegerQ[p] && IntegerQ[r]


Int[(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  x^(n*FracPart[q])*(c+d*x^(-n))^FracPart[q]/(d+c*x^n)^FracPart[q]*Int[(a+b*x^n)^p*(d+c*x^n)^q*(e+f*x^n)^r/x^(n*q),x] /;
FreeQ[{a,b,c,d,e,f,n,p,q,r},x] && EqQ[mn,-n] && Not[IntegerQ[q]]


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e1_+f1_.*x_^n2_.)^r_.*(e2_+f2_.*x_^n2_.)^r_.,x_Symbol] :=
  Int[(a+b*x^n)^p*(c+d*x^n)^q*(e1*e2+f1*f2*x^n)^r,x] /;
FreeQ[{a,b,c,d,e1,f1,e2,f2,n,p,q,r},x] && EqQ[n2-n/2] && EqQ[e2*f1+e1*f2] && (IntegerQ[r] || PositiveQ[e1] && PositiveQ[e2])


Int[(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e1_+f1_.*x_^n2_.)^r_.*(e2_+f2_.*x_^n2_.)^r_.,x_Symbol] :=
  (e1+f1*x^(n/2))^FracPart[r]*(e2+f2*x^(n/2))^FracPart[r]/(e1*e2+f1*f2*x^n)^FracPart[r]*
    Int[(a+b*x^n)^p*(c+d*x^n)^q*(e1*e2+f1*f2*x^n)^r,x] /;
FreeQ[{a,b,c,d,e1,f1,e2,f2,n,p,q,r},x] && EqQ[n2-n/2] && EqQ[e2*f1+e1*f2]





(* ::Subsection::Closed:: *)
(*1.1.3.6 (g x)^m (a+b x^n)^p (c+d x^n)^q (e+f x^n)^r*)


Int[(g_.*x_)^m_.*(b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^m/(n*b^(Simplify[(m+1)/n]-1))*Subst[Int[(b*x)^(p+Simplify[(m+1)/n]-1)*(c+d*x)^q*(e+f*x)^r,x],x,x^n] /;
FreeQ[{b,c,d,e,f,g,m,n,p,q,r},x] && (IntegerQ[m] || PositiveQ[g]) && IntegerQ[Simplify[(m+1)/n]]


Int[(g_.*x_)^m_.*(b_.*x_^n_.)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^m*b^IntPart[p]*(b*x^n)^FracPart[p]/x^(n*FracPart[p])*Int[x^(m+n*p)*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{b,c,d,e,f,g,m,n,p,q,r},x] && (IntegerQ[m] || PositiveQ[g]) && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[(g_*x_)^m_*(b_.*x_^n_.)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^IntPart[m]*(g*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{b,c,d,e,f,g,m,n,p,q,r},x] && Not[IntegerQ[m]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  Int[ExpandIntegrand[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && PositiveIntegerQ[p+2,q,r]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  1/n*Subst[Int[(a+b*x)^p*(c+d*x)^q*(e+f*x)^r,x],x,x^n] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && EqQ[m-n+1]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  Int[x^(m+n*(p+q+r))*(b+a*x^(-n))^p*(d+c*x^(-n))^q*(f+e*x^(-n))^r,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && IntegersQ[p,q,r] && NegQ[n]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a+b*x)^p*(c+d*x)^q*(e+f*x)^r,x],x,x^n] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && IntegerQ[Simplify[(m+1)/n]]


Int[(g_*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^IntPart[m]*(g*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p,q,r},x] && IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(a+b*x^(n/k))^p*(c+d*x^(n/k))^q*(e+f*x^(n/k))^r,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(g_.*x_)^m_*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_)^r_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/g*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n)/g^n)^p*(c+d*x^(k*n)/g^n)^q*(e+f*x^(k*n)/g^n)^r,x],x,(g*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,g,p,q,r},x] && PositiveIntegerQ[n] && FractionQ[m]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*b*g*n*(p+1)) + 
  1/(a*b*n*(p+1))*Int[(g*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*
    Simp[c*(b*e*n*(p+1)+(b*e-a*f)*(m+1))+d*(b*e*n*(p+1)+(b*e-a*f)*(m+n*q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && PositiveIntegerQ[n] && RationalQ[p,q] && p<-1 && q>0 && Not[q==1 && SimplerQ[b*c-a*d,b*e-a*f]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_),x_Symbol] :=
  g^(n-1)*(b*e-a*f)*(g*x)^(m-n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(b*n*(b*c-a*d)*(p+1)) - 
  g^n/(b*n*(b*c-a*d)*(p+1))*Int[(g*x)^(m-n)*(a+b*x^n)^(p+1)*(c+d*x^n)^q*
    Simp[c*(b*e-a*f)*(m-n+1)+(d*(b*e-a*f)*(m+n*q+1)-b*n*(c*f-d*e)*(p+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,q},x] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m-n+1>0


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*g*n*(b*c-a*d)*(p+1)) + 
  1/(a*n*(b*c-a*d)*(p+1))*Int[(g*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^q*
    Simp[c*(b*e-a*f)*(m+1)+e*n*(b*c-a*d)*(p+1)+d*(b*e-a*f)*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,q},x] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[(g_.*x_)^m_*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  e*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*g*(m+1)) - 
  1/(a*g^n*(m+1))*Int[(g*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^(q-1)*
    Simp[c*(b*e-a*f)*(m+1)+e*n*(b*c*(p+1)+a*d*q)+d*((b*e-a*f)*(m+1)+b*e*n*(p+q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && PositiveIntegerQ[n] && RationalQ[m,q] && q>0 && m<-1 && Not[q==1 && SimplerQ[e+f*x^n,c+d*x^n]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  f*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(b*g*(m+n*(p+q+1)+1)) + 
  1/(b*(m+n*(p+q+1)+1))*Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^(q-1)*
    Simp[c*((b*e-a*f)*(m+1)+b*e*n*(p+q+1))+(d*(b*e-a*f)*(m+1)+f*n*q*(b*c-a*d)+b*e*d*n*(p+q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && PositiveIntegerQ[n] && RationalQ[q] && q>0 && Not[q==1 && SimplerQ[e+f*x^n,c+d*x^n]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  f*g^(n-1)*(g*x)^(m-n+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(b*d*(m+n*(p+q+1)+1)) - 
  g^n/(b*d*(m+n*(p+q+1)+1))*Int[(g*x)^(m-n)*(a+b*x^n)^p*(c+d*x^n)^q*
    Simp[a*f*c*(m-n+1)+(a*f*d*(m+n*q+1)+b*(f*c*(m+n*p+1)-e*d*(m+n*(p+q+1)+1)))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p,q},x] && PositiveIntegerQ[n] && RationalQ[m] && m>n-1


Int[(g_.*x_)^m_*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  e*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*c*g*(m+1)) + 
  1/(a*c*g^n*(m+1))*Int[(g*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^q*
    Simp[a*f*c*(m+1)-e*(b*c+a*d)*(m+n+1)-e*n*(b*c*p+a*d*q)-b*e*d*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p,q},x] && PositiveIntegerQ[n] && RationalQ[m] && m<-1


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(e_+f_.*x_^n_)/(c_+d_.*x_^n_),x_Symbol] :=
  Int[ExpandIntegrand[(g*x)^m*(a+b*x^n)^p*(e+f*x^n)/(c+d*x^n),x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && PositiveIntegerQ[n]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  e*Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q,x] + 
  f/e^n*Int[(g*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p,q},x] && PositiveIntegerQ[n]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  e*Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^(r-1),x] + 
  f/e^n*Int[(g*x)^(m+n)*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^(r-1),x] /;
FreeQ[{a,b,c,d,e,f,g,m,p,q},x] && PositiveIntegerQ[n] && PositiveIntegerQ[r]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q*(e+f*x^(-n))^r/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(g_.*x_)^m_*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  With[{k=Denominator[m]},
  -k/g*Subst[Int[(a+b*g^(-n)*x^(-k*n))^p*(c+d*g^(-n)*x^(-k*n))^q*(e+f*g^(-n)*x^(-k*n))^r/x^(k*(m+1)+1),x],x,1/(g*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,g,p,q,r},x] && NegativeIntegerQ[n] && FractionQ[m]


Int[(g_.*x_)^m_*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  -(g*x)^m*(x^(-1))^m*Subst[Int[(a+b*x^(-n))^p*(c+d*x^(-n))^q*(e+f*x^(-n))^r/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,e,f,g,m,p,q,r},x] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  With[{k=Denominator[n]},
  k*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n))^p*(c+d*x^(k*n))^q*(e+f*x^(k*n))^r,x],x,x^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,m,p,q,r},x] && FractionQ[n]


Int[(g_*x_)^m_*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^IntPart[m]*(g*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p,q,r},x] && FractionQ[n]


Int[x_^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  1/(m+1)*Subst[Int[(a+b*x^Simplify[n/(m+1)])^p*(c+d*x^Simplify[n/(m+1)])^q*(e+f*x^Simplify[n/(m+1)])^r,x],x,x^(m+1)] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && IntegerQ[Simplify[n/(m+1)]]


Int[(g_*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  g^IntPart[m]*(g*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p,q,r},x] && IntegerQ[Simplify[n/(m+1)]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(a*b*g*n*(p+1)) + 
  1/(a*b*n*(p+1))*Int[(g*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^(q-1)*
    Simp[c*(b*e*n*(p+1)+(b*e-a*f)*(m+1))+d*(b*e*n*(p+1)+(b*e-a*f)*(m+n*q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && RationalQ[p,q] && p<-1 && q>0 && Not[q==1 && SimplerQ[b*c-a*d,b*e-a*f]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_),x_Symbol] :=
  -(b*e-a*f)*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(q+1)/(a*g*n*(b*c-a*d)*(p+1)) + 
  1/(a*n*(b*c-a*d)*(p+1))*Int[(g*x)^m*(a+b*x^n)^(p+1)*(c+d*x^n)^q*
    Simp[c*(b*e-a*f)*(m+1)+e*n*(b*c-a*d)*(p+1)+d*(b*e-a*f)*(m+n*(p+q+2)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,q},x] && RationalQ[p] && p<-1


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_),x_Symbol] :=
  f*(g*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^q/(b*g*(m+n*(p+q+1)+1)) + 
  1/(b*(m+n*(p+q+1)+1))*Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^(q-1)*
    Simp[c*((b*e-a*f)*(m+1)+b*e*n*(p+q+1))+(d*(b*e-a*f)*(m+1)+f*n*q*(b*c-a*d)+b*e*d*n*(p+q+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && RationalQ[q] && q>0 && Not[q==1 && SimplerQ[e+f*x^n,c+d*x^n]]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(e_+f_.*x_^n_)/(c_+d_.*x_^n_),x_Symbol] :=
  Int[ExpandIntegrand[(g*x)^m*(a+b*x^n)^p*(e+f*x^n)/(c+d*x^n),x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_*(c_+d_.*x_^n_)^q_*(e_+f_.*x_^n_),x_Symbol] :=
  e*Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q,x] + 
  f*(g*x)^m/x^m*Int[x^(m+n)*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p,q},x]


Int[x_^m_.*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  Int[x^(m-n*q)*(a+b*x^n)^p*(d+c*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,r},x] && EqQ[mn,-n] && IntegerQ[q]


Int[x_^m_.*(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  Int[x^(m+n*(p+r))*(b+a*x^(-n))^p*(c+d*x^(-n))^q*(f+e*x^(-n))^r,x] /;
FreeQ[{a,b,c,d,e,f,m,n,q},x] && EqQ[mn,-n] && IntegerQ[p] && IntegerQ[r]


Int[x_^m_.*(a_.+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  x^(n*FracPart[q])*(c+d*x^(-n))^FracPart[q]/(d+c*x^n)^FracPart[q]*Int[x^(m-n*q)*(a+b*x^n)^p*(d+c*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && EqQ[mn,-n] && Not[IntegerQ[q]]


Int[(g_*x_)^m_*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^mn_.)^q_.*(e_+f_.*x_^n_.)^r_.,x_Symbol] :=
  g^IntPart[m]*(g*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n)^p*(c+d*x^(-n))^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p,q,r},x] && EqQ[mn,-n]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e_+f_.*x_^n_)^r_.,x_Symbol] :=
  Defer[Int][(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p,q,r},x]


Int[u_^m_.*(a_.+b_.*v_^n_)^p_.*(c_.+d_.*v_^n_)^q_.*(e_+f_.*v_^n_)^r_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q*(e+f*x^n)^r,x],x,v] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && LinearPairQ[u,v,x]


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e1_+f1_.*x_^n2_.)^r_.*(e2_+f2_.*x_^n2_.)^r_.,x_Symbol] :=
  Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q*(e1*e2+f1*f2*x^n)^r,x] /;
FreeQ[{a,b,c,d,e1,f1,e2,f2,g,m,n,p,q,r},x] && EqQ[n2-n/2] && EqQ[e2*f1+e1*f2] && (IntegerQ[r] || PositiveQ[e1] && PositiveQ[e2])


Int[(g_.*x_)^m_.*(a_+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.*(e1_+f1_.*x_^n2_.)^r_.*(e2_+f2_.*x_^n2_.)^r_.,x_Symbol] :=
  (e1+f1*x^(n/2))^FracPart[r]*(e2+f2*x^(n/2))^FracPart[r]/(e1*e2+f1*f2*x^n)^FracPart[r]*
    Int[(g*x)^m*(a+b*x^n)^p*(c+d*x^n)^q*(e1*e2+f1*f2*x^n)^r,x] /;
FreeQ[{a,b,c,d,e1,f1,e2,f2,g,m,n,p,q,r},x] && EqQ[n2-n/2] && EqQ[e2*f1+e1*f2]



`)

func resourcesRubi113GeneralBinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi113GeneralBinomialProductsM, nil
}

func resourcesRubi113GeneralBinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi113GeneralBinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.1.3 General binomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi114ImproperBinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.3.4 Normalizing algebraic functions*)


(* ::Subsection::Closed:: *)
(*1.3.4 Normalizing algebraic functions*)


Int[(a_.+b_.*(c_.*x_^n_)^q_)^p_.,x_Symbol] :=
  x/(c*x^n)^(1/n)*Subst[Int[(a+b*x^(n*q))^p,x],x,(c*x^n)^(1/n)] /;
FreeQ[{a,b,c,q,n,p},x] && IntegerQ[n*q]


Int[x_^m_.*(a_.+b_.*(c_.*x_^n_)^q_)^p_.,x_Symbol] :=
  x^(m+1)/(c*x^n)^((m+1)/n)*Subst[Int[x^m*(a+b*x^(n*q))^p,x],x,(c*x^n)^(1/n)] /;
FreeQ[{a,b,c,m,n,p,q},x] && IntegerQ[n*q] && IntegerQ[m]


Int[x_^m_.*(e_.*(a_+b_.*x_^n_.)^r_.)^p_*(f_.*(c_+d_.*x_^n_.)^s_)^q_,x_Symbol] :=
  (e*(a+b*x^n)^r)^p*(f*(c+d*x^n)^s)^q/((a+b*x^n)^(p*r)*(c+d*x^n)^(q*s))*
    Int[x^m*(a+b*x^n)^(p*r)*(c+d*x^n)^(q*s),x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r,s},x]


Int[u_.*(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  (b*e/d)^p*Int[u,x] /;
FreeQ[{a,b,c,d,e,n,p},x] && EqQ[b*c-a*d]


Int[u_.*(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  Int[u*(e*(a+b*x^n))^p/(c+d*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,n,p},x] && PositiveQ[b*d*e] && PositiveQ[c-a*d/b]


Int[(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  With[{q=Denominator[p]},
  q*e*(b*c-a*d)/n*Subst[
    Int[x^(q*(p+1)-1)*(-a*e+c*x^q)^(1/n-1)/(b*e-d*x^q)^(1/n+1),x],x,(e*(a+b*x^n)/(c+d*x^n))^(1/q)]] /;
FreeQ[{a,b,c,d,e},x] && FractionQ[p] && IntegerQ[1/n]


Int[x_^m_.*(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  With[{q=Denominator[p]},
  q*e*(b*c-a*d)/n*Subst[
    Int[x^(q*(p+1)-1)*(-a*e+c*x^q)^(Simplify[(m+1)/n]-1)/(b*e-d*x^q)^(Simplify[(m+1)/n]+1),x],x,(e*(a+b*x^n)/(c+d*x^n))^(1/q)]] /;
FreeQ[{a,b,c,d,e,m,n},x] && FractionQ[p] && IntegerQ[Simplify[(m+1)/n]]


Int[u_^r_.*(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  With[{q=Denominator[p]},
  q*e*(b*c-a*d)/n*Subst[Int[SimplifyIntegrand[x^(q*(p+1)-1)*(-a*e+c*x^q)^(1/n-1)/(b*e-d*x^q)^(1/n+1)*
    ReplaceAll[u,x->(-a*e+c*x^q)^(1/n)/(b*e-d*x^q)^(1/n)]^r,x],x],x,(e*(a+b*x^n)/(c+d*x^n))^(1/q)]] /;
FreeQ[{a,b,c,d,e},x] && PolynomialQ[u,x] && FractionQ[p] && IntegerQ[1/n] && IntegerQ[r]


Int[x_^m_.*u_^r_.*(e_.*(a_.+b_.*x_^n_.)/(c_+d_.*x_^n_.))^p_,x_Symbol] :=
  With[{q=Denominator[p]},
  q*e*(b*c-a*d)/n*Subst[Int[SimplifyIntegrand[x^(q*(p+1)-1)*(-a*e+c*x^q)^((m+1)/n-1)/(b*e-d*x^q)^((m+1)/n+1)*
    ReplaceAll[u,x->(-a*e+c*x^q)^(1/n)/(b*e-d*x^q)^(1/n)]^r,x],x],x,(e*(a+b*x^n)/(c+d*x^n))^(1/q)]] /;
FreeQ[{a,b,c,d,e},x] && PolynomialQ[u,x] && FractionQ[p] && IntegerQ[1/n] && IntegersQ[m,r]


Int[(a_.+b_.*(c_./x_)^n_)^p_,x_Symbol] :=
  -c*Subst[Int[(a+b*x^n)^p/x^2,x],x,c/x] /;
FreeQ[{a,b,c,n,p},x]


Int[x_^m_.*(a_.+b_.*(c_./x_)^n_)^p_.,x_Symbol] :=
  -c^(m+1)*Subst[Int[(a+b*x^n)^p/x^(m+2),x],x,c/x] /;
FreeQ[{a,b,c,n,p},x] && IntegerQ[m]


Int[(d_.*x_)^m_*(a_.+b_.*(c_./x_)^n_)^p_.,x_Symbol] :=
  -c*(d*x)^m*(c/x)^m*Subst[Int[(a+b*x^n)^p/x^(m+2),x],x,c/x] /;
FreeQ[{a,b,c,d,m,n,p},x] && Not[IntegerQ[m]]


Int[(a_.+b_.*(d_./x_)^n_+c_.*(d_./x_)^n2_.)^p_.,x_Symbol] :=
  -d*Subst[Int[(a+b*x^n+c*x^(2*n))^p/x^2,x],x,d/x] /;
FreeQ[{a,b,c,d,n,p},x] && EqQ[n2-2*n]


Int[x_^m_.*(a_+b_.*(d_./x_)^n_+c_.*(d_./x_)^n2_.)^p_.,x_Symbol] :=
  -d^(m+1)*Subst[Int[(a+b*x^n+c*x^(2*n))^p/x^(m+2),x],x,d/x] /;
FreeQ[{a,b,c,d,n,p},x] && EqQ[n2-2*n] && IntegerQ[m]


Int[(e_.*x_)^m_*(a_+b_.*(d_./x_)^n_+c_.*(d_./x_)^n2_.)^p_.,x_Symbol] :=
  -d*(e*x)^m*(d/x)^m*Subst[Int[(a+b*x^n+c*x^(2*n))^p/x^(m+2),x],x,d/x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && EqQ[n2-2*n] && Not[IntegerQ[m]]


Int[(a_.+b_.*(d_./x_)^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  -d*Subst[Int[(a+b*x^n+c/d^(2*n)*x^(2*n))^p/x^2,x],x,d/x] /;
FreeQ[{a,b,c,d,n,p},x] && EqQ[n2+2*n] && IntegerQ[2*n]


Int[x_^m_.*(a_+b_.*(d_./x_)^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  -d^(m+1)*Subst[Int[(a+b*x^n+c/d^(2*n)*x^(2*n))^p/x^(m+2),x],x,d/x] /;
FreeQ[{a,b,c,d,n,p},x] && EqQ[n2+2*n] && IntegerQ[2*n] && IntegerQ[m]


Int[(e_.*x_)^m_*(a_+b_.*(d_./x_)^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  -d*(e*x)^m*(d/x)^m*Subst[Int[(a+b*x^n+c/d^(2*n)*x^(2*n))^p/x^(m+2),x],x,d/x] /;
FreeQ[{a,b,c,d,e,n,p},x] && EqQ[n2+2*n] && Not[IntegerQ[m]] && IntegerQ[2*n]


Int[u_^m_,x_Symbol] :=
  Int[ExpandToSum[u,x]^m,x] /;
FreeQ[m,x] && LinearQ[u,x] && Not[LinearMatchQ[u,x]]


Int[u_^m_.*v_^n_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n,x] /;
FreeQ[{m,n},x] && LinearQ[{u,v},x] && Not[LinearMatchQ[{u,v},x]]


Int[u_^m_.*v_^n_.*w_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n*ExpandToSum[w,x]^p,x] /;
FreeQ[{m,n,p},x] && LinearQ[{u,v,w},x] && Not[LinearMatchQ[{u,v,w},x]]


Int[u_^m_.*v_^n_.*w_^p_.*z_^q_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n*ExpandToSum[w,x]^p*ExpandToSum[z,x]^q,x] /;
FreeQ[{m,n,p,q},x] && LinearQ[{u,v,w,z},x] && Not[LinearMatchQ[{u,v,w,z},x]]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && BinomialQ[u,x] && Not[BinomialMatchQ[u,x]]


Int[(c_.*x_)^m_.*u_^p_.,x_Symbol] :=
  Int[(c*x)^m*ExpandToSum[u,x]^p,x] /;
FreeQ[{c,m,p},x] && BinomialQ[u,x] && Not[BinomialMatchQ[u,x]]


Int[u_^p_.*v_^q_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^p*ExpandToSum[v,x]^q,x] /;
FreeQ[{p,q},x] && BinomialQ[{u,v},x] && EqQ[BinomialDegree[u,x]-BinomialDegree[v,x]] && Not[BinomialMatchQ[{u,v},x]]


Int[(e_.*x_)^m_.*u_^p_.*v_^q_.,x_Symbol] :=
  Int[(e*x)^m*ExpandToSum[u,x]^p*ExpandToSum[v,x]^q,x] /;
FreeQ[{e,m,p,q},x] && BinomialQ[{u,v},x] && EqQ[BinomialDegree[u,x]-BinomialDegree[v,x]] && Not[BinomialMatchQ[{u,v},x]]


Int[u_^m_.*v_^p_.*w_^q_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^p*ExpandToSum[w,x]^q,x] /;
FreeQ[{m,p,q},x] && BinomialQ[{u,v,w},x] && EqQ[BinomialDegree[u,x]-BinomialDegree[v,x]] && 
  EqQ[BinomialDegree[u,x]-BinomialDegree[w,x]] && Not[BinomialMatchQ[{u,v,w},x]]


Int[(g_.*x_)^m_.*u_^p_.*v_^q_.*z_^r_.,x_Symbol] :=
  Int[(g*x)^m*ExpandToSum[u,x]^p*ExpandToSum[v,x]^q*ExpandToSum[z,x]^r,x] /;
FreeQ[{g,m,p,q,r},x] && BinomialQ[{u,v,z},x] && EqQ[BinomialDegree[u,x]-BinomialDegree[v,x]] && 
  EqQ[BinomialDegree[u,x]-BinomialDegree[z,x]] && Not[BinomialMatchQ[{u,v,z},x]]


Int[(c_.*x_)^m_.*Pq_*u_^p_.,x_Symbol] :=
  Int[(c*x)^m*Pq*ExpandToSum[u,x]^p,x] /;
FreeQ[{c,m,p},x] && PolyQ[Pq,x] && BinomialQ[u,x] && Not[BinomialMatchQ[u,x]]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && GeneralizedBinomialQ[u,x] && Not[GeneralizedBinomialMatchQ[u,x]]


Int[(c_.*x_)^m_.*u_^p_.,x_Symbol] :=
  Int[(c*x)^m*ExpandToSum[u,x]^p,x] /;
FreeQ[{c,m,p},x] && GeneralizedBinomialQ[u,x] && Not[GeneralizedBinomialMatchQ[u,x]]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && QuadraticQ[u,x] && Not[QuadraticMatchQ[u,x]]


Int[u_^m_.*v_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^p,x] /;
FreeQ[{m,p},x] && LinearQ[u,x] && QuadraticQ[v,x] && Not[LinearMatchQ[u,x] && QuadraticMatchQ[v,x]]


Int[u_^m_.*v_^n_.*w_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^n*ExpandToSum[w,x]^p,x] /;
FreeQ[{m,n,p},x] && LinearQ[{u,v},x] && QuadraticQ[w,x] && Not[LinearMatchQ[{u,v},x] && QuadraticMatchQ[w,x]]


Int[u_^p_.*v_^q_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^p*ExpandToSum[v,x]^q,x] /;
FreeQ[{p,q},x] && QuadraticQ[{u,v},x] && Not[QuadraticMatchQ[{u,v},x]]


Int[z_^m_.*u_^p_.*v_^q_.,x_Symbol] :=
  Int[ExpandToSum[z,x]^m*ExpandToSum[u,x]^p*ExpandToSum[v,x]^q,x] /;
FreeQ[{m,p,q},x] && LinearQ[z,x] && QuadraticQ[{u,v},x] && Not[LinearMatchQ[z,x] && QuadraticMatchQ[{u,v},x]]


Int[Pq_*u_^p_.,x_Symbol] :=
  Int[Pq*ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && PolyQ[Pq,x] && QuadraticQ[u,x] && Not[QuadraticMatchQ[u,x]]


Int[u_^m_.*Pq_*v_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*Pq*ExpandToSum[u,x]^p,x] /;
FreeQ[{m,p},x] && PolyQ[Pq,x] && LinearQ[u,x] && QuadraticQ[v,x] && Not[LinearMatchQ[u,x] && QuadraticMatchQ[v,x]]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && TrinomialQ[u,x] && Not[TrinomialMatchQ[u,x]]


Int[(d_.*x_)^m_.*u_^p_.,x_Symbol] :=
  Int[(d*x)^m*ExpandToSum[u,x]^p,x] /;
FreeQ[{d,m,p},x] && TrinomialQ[u,x] && Not[TrinomialMatchQ[u,x]]


Int[u_^q_.*v_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^q*ExpandToSum[v,x]^p,x] /;
FreeQ[{p,q},x] && BinomialQ[u,x] && TrinomialQ[v,x] && Not[BinomialMatchQ[u,x] && TrinomialMatchQ[v,x]]


Int[u_^q_.*v_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^q*ExpandToSum[v,x]^p,x] /;
FreeQ[{p,q},x] && BinomialQ[u,x] && BinomialQ[v,x] && Not[BinomialMatchQ[u,x] && BinomialMatchQ[v,x]]


Int[(f_.*x_)^m_.*z_^q_.*u_^p_.,x_Symbol] :=
  Int[(f*x)^m*ExpandToSum[z,x]^q*ExpandToSum[u,x]^p,x] /;
FreeQ[{f,m,p,q},x] && BinomialQ[z,x] && TrinomialQ[u,x] && Not[BinomialMatchQ[z,x] && TrinomialMatchQ[u,x]]


Int[(f_.*x_)^m_.*z_^q_.*u_^p_.,x_Symbol] :=
  Int[(f*x)^m*ExpandToSum[z,x]^q*ExpandToSum[u,x]^p,x] /;
FreeQ[{f,m,p,q},x] && BinomialQ[z,x] && BinomialQ[u,x] && Not[BinomialMatchQ[z,x] && BinomialMatchQ[u,x]]


Int[Pq_*u_^p_.,x_Symbol] :=
  Int[Pq*ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && PolyQ[Pq,x] && TrinomialQ[u,x] && Not[TrinomialMatchQ[u,x]]


Int[(d_.*x_)^m_.*Pq_*u_^p_.,x_Symbol] :=
  Int[(d*x)^m*Pq*ExpandToSum[u,x]^p,x] /;
FreeQ[{d,m,p},x] && PolyQ[Pq,x] && TrinomialQ[u,x] && Not[TrinomialMatchQ[u,x]]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && GeneralizedTrinomialQ[u,x] && Not[GeneralizedTrinomialMatchQ[u,x]]


Int[(d_.*x_)^m_.*u_^p_.,x_Symbol] :=
  Int[(d*x)^m*ExpandToSum[u,x]^p,x] /;
FreeQ[{d,m,p},x] && GeneralizedTrinomialQ[u,x] && Not[GeneralizedTrinomialMatchQ[u,x]]


Int[z_*u_^p_.,x_Symbol] :=
  Int[ExpandToSum[z,x]*ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && BinomialQ[z,x] && GeneralizedTrinomialQ[u,x] && 
  EqQ[BinomialDegree[z,x]-GeneralizedTrinomialDegree[u,x]] && Not[BinomialMatchQ[z,x] && GeneralizedTrinomialMatchQ[u,x]]


Int[(f_.*x_)^m_.*z_*u_^p_.,x_Symbol] :=
  Int[(f*x)^m*ExpandToSum[z,x]*ExpandToSum[u,x]^p,x] /;
FreeQ[{f,m,p},x] && BinomialQ[z,x] && GeneralizedTrinomialQ[u,x] && 
  EqQ[BinomialDegree[z,x]-GeneralizedTrinomialDegree[u,x]] && Not[BinomialMatchQ[z,x] && GeneralizedTrinomialMatchQ[u,x]]





(* ::Section:: *)
(*1.1.4 Improper Binomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.1.4.1 (a x^j+b x^n)^p*)


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^(p+1)/(b*(n-j)(p+1)*x^(n-1)) /;
FreeQ[{a,b,j,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && EqQ[j*p-n+j+1]


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)*x^(j-1)) + 
  (n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(a*x^j+b*x^n)^(p+1)/x^j,x] /;
FreeQ[{a,b,j,n},x] && Not[IntegerQ[p]] && NeQ[n-j] && NegativeIntegerQ[Simplify[(n*p+n-j+1)/(n-j)]] && RationalQ[p] && p<-1


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^(p+1)/(a*(j*p+1)*x^(j-1)) - 
  b*(n*p+n-j+1)/(a*(j*p+1))*Int[x^(n-j)*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,j,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && NegativeIntegerQ[Simplify[(n*p+n-j+1)/(n-j)]] && NeQ[j*p+1]


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  x*(a*x^j+b*x^n)^p/(j*p+1) - 
  b*(n-j)*p/(j*p+1)*Int[x^n*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && p>0 && j*p+1<0


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  x*(a*x^j+b*x^n)^p/(n*p+1) + 
  a*(n-j)*p/(n*p+1)*Int[x^j*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && p>0 && NeQ[n*p+1]


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^(p+1)/(b*(n-j)*(p+1)*x^(n-1)) - 
  (j*p-n+j+1)/(b*(n-j)*(p+1))*Int[(a*x^j+b*x^n)^(p+1)/x^n,x] /;
FreeQ[{a,b},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && p<-1 && j*p+1>n-j


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)*x^(j-1)) + 
  (n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(a*x^j+b*x^n)^(p+1)/x^j,x] /;
FreeQ[{a,b},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && p<-1


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  x*(a*x^j+b*x^n)^p/(p*(n-j)) + a*Int[x^j*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b,j,n},x] && PositiveIntegerQ[p+1/2] && NeQ[n-j] && EqQ[Simplify[j*p+1]]


Int[1/Sqrt[a_.*x_^2+b_.*x_^n_.],x_Symbol] :=
  2/(2-n)*Subst[Int[1/(1-a*x^2),x],x,x/Sqrt[a*x^2+b*x^n]] /;
FreeQ[{a,b,n},x] && NeQ[n-2]


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)*x^(j-1)) + 
  (n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(a*x^j+b*x^n)^(p+1)/x^j,x] /;
FreeQ[{a,b,j,n},x] && NegativeIntegerQ[p+1/2] && NeQ[n-j] && EqQ[Simplify[j*p+1]]


Int[1/Sqrt[a_.*x_^j_.+b_.*x_^n_.],x_Symbol] :=
  -2*Sqrt[a*x^j+b*x^n]/(b*(n-2)*x^(n-1)) - 
  a*(2*n-j-2)/(b*(n-2))*Int[1/(x^(n-j)*Sqrt[a*x^j+b*x^n]),x] /;
FreeQ[{a,b},x] && RationalQ[j,n] && 2*(n-1)<j<n


(* Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  x*(a*x^j+b*x^n)^p/(p*(n-j)*((a*x^j+b*x^n)/(b*x^n))^p)*Hypergeometric2F1[-p,-p,1-p,-a/(b*x^(n-j))] /;
FreeQ[{a,b,j,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && EqQ[j*p+1] *)


(* Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  x*(a*x^j+b*x^n)^p/((j*p+1)*((a*x^j+b*x^n)/(a*x^j))^p)*
    Hypergeometric2F1[-p,(j*p+1)/(n-j),(j*p+1)/(n-j)+1,-b*x^(n-j)/a] /;
FreeQ[{a,b,j,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && NeQ[j*p+1] *)


Int[(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^FracPart[p]/(x^(j*FracPart[p])*(a+b*x^(n-j))^FracPart[p])*Int[x^(j*p)*(a+b*x^(n-j))^p,x] /;
FreeQ[{a,b,j,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && PosQ[n-j]


Int[(a_.*u_^j_.+b_.*u_^n_.)^p_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a*x^j+b*x^n)^p,x],x,u] /;
FreeQ[{a,b,j,n,p},x] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.1.4.2 (c x)^m (a x^j+b x^n)^p*)


Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[(a*x^Simplify[j/n]+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && EqQ[Simplify[m-n+1]]


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)) /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && EqQ[m+n*p+n-j+1] && (IntegerQ[j] || PositiveQ[c])


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)) + 
  c^j*(m+n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(c*x)^(m-j)*(a*x^j+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,j,m,n},x] && Not[IntegerQ[p]] && NeQ[n-j] && NegativeIntegerQ[Simplify[(m+n*p+n-j+1)/(n-j)]] && 
  RationalQ[p] && p<-1 && (IntegerQ[j] || PositiveQ[c])


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(m+j*p+1)) - 
  b*(m+n*p+n-j+1)/(a*c^(n-j)*(m+j*p+1))*Int[(c*x)^(m+n-j)*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && NegativeIntegerQ[Simplify[(m+n*p+n-j+1)/(n-j)]] && 
  NeQ[m+j*p+1] && (IntegersQ[j,n] || PositiveQ[c])


Int[(c_*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && NegativeIntegerQ[Simplify[(m+n*p+n-j+1)/(n-j)]]


Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a*x^Simplify[j/n]+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[(m+1)/n]] && 
  NeQ[n^2-1]


Int[(c_*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[(m+1)/n]] && 
  NeQ[n^2-1]


Int[(c_.*x_)^m_*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a*x^j+b*x^n)^p/(c*(m+j*p+1)) - 
  b*p*(n-j)/(c^n*(m+j*p+1))*Int[(c*x)^(m+n)*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c},x] && Not[IntegerQ[p]] && RationalQ[j,m,n,p] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && p>0 && m+j*p+1<0


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a*x^j+b*x^n)^p/(c*(m+n*p+1)) + 
  a*(n-j)*p/(c^j*(m+n*p+1))*Int[(c*x)^(m+j)*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c,m},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && p>0 && NeQ[m+n*p+1]


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^(n-1)*(c*x)^(m-n+1)*(a*x^j+b*x^n)^(p+1)/(b*(n-j)*(p+1)) - 
  c^n*(m+j*p-n+j+1)/(b*(n-j)*(p+1))*Int[(c*x)^(m-n)*(a*x^j+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c},x] && Not[IntegerQ[p]] && RationalQ[j,m,n,p] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && p<-1 && m+j*p+1>n-j


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)) + 
  c^j*(m+n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(c*x)^(m-j)*(a*x^j+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,m},x] && Not[IntegerQ[p]] && RationalQ[j,n,p] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && p<-1


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^(n-1)*(c*x)^(m-n+1)*(a*x^j+b*x^n)^(p+1)/(b*(m+n*p+1)) - 
  a*c^(n-j)*(m+j*p-n+j+1)/(b*(m+n*p+1))*Int[(c*x)^(m-(n-j))*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && Not[IntegerQ[p]] && RationalQ[j,n] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && PositiveQ[m+j*p+1-n+j] && 
  NeQ[m+n*p+1]


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(m+j*p+1)) - 
  b*(m+n*p+n-j+1)/(a*c^(n-j)*(m+j*p+1))*Int[(c*x)^(m+n-j)*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && Not[IntegerQ[p]] && RationalQ[j,n] && 0<j<n && (IntegersQ[j,n] || PositiveQ[c]) && NegativeQ[m+j*p+1]


Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(a*x^Simplify[j/(m+1)]+b*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && NeQ[m+1] && 
  IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && NeQ[m+1] && 
  IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (c*x)^(m+1)*(a*x^j+b*x^n)^p/(c*p*(n-j)) + a/c^j*Int[(c*x)^(m+j)*(a*x^j+b*x^n)^(p-1),x] /;
FreeQ[{a,b,c,j,m,n},x] && PositiveIntegerQ[p+1/2] && NeQ[n-j] && EqQ[Simplify[m+j*p+1]] && (IntegerQ[j] || PositiveQ[c])


Int[x_^m_./Sqrt[a_.*x_^j_.+b_.*x_^n_.],x_Symbol] :=
  -2/(n-j)*Subst[Int[1/(1-a*x^2),x],x,x^(j/2)/Sqrt[a*x^j+b*x^n]] /;
FreeQ[{a,b,j,n},x] && EqQ[m-j/2+1] && NeQ[n-j]


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  -c^(j-1)*(c*x)^(m-j+1)*(a*x^j+b*x^n)^(p+1)/(a*(n-j)*(p+1)) + 
  c^j*(m+n*p+n-j+1)/(a*(n-j)*(p+1))*Int[(c*x)^(m-j)*(a*x^j+b*x^n)^(p+1),x] /;
FreeQ[{a,b,c,j,m,n},x] && NegativeIntegerQ[p+1/2] && NeQ[n-j] && EqQ[Simplify[m+j*p+1]] && (IntegerQ[j] || PositiveQ[c])


Int[(c_*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && IntegerQ[p+1/2] && NeQ[n-j] && EqQ[Simplify[m+j*p+1]]


(* Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^(p+1)/(b*p*(n-j)*x^(n+j*p))*Hypergeometric2F1[1,1,1-p,-a/(b*x^(n-j))] /;
FreeQ[{a,b,j,m,n,p},x] && NeQ[n-j] && EqQ[m+j*p+1] *)


(* Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^n)^(p+1)/(b*(p-1)*(n-j)*x^(2*n+j*(p-1)))*Hypergeometric2F1[1,2,2-p,-a/(b*x^(n-j))] /;
FreeQ[{a,b,j,m,n,p},x] && NeQ[n-j] && EqQ[m+n+(p-1)*j+1] *)


(* Int[x_^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  (x^(m-j+1)*(a*x^j+b*x^n)^(p+1))/(a*(m+j*p+1))*Hypergeometric2F1[1,(m+n*p+1)/(n-j)+1,(m+j*p+1)/(n-j)+1,-b*x^(n-j)/a] /;
FreeQ[{a,b,j,m,n,p},x] && NeQ[n-j] && NeQ[m+j*p+1] && NeQ[m+n+(p-1)*j+1] *)


Int[(c_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^n_.)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]*(a*x^j+b*x^n)^FracPart[p]/
    (x^(FracPart[m]+j*FracPart[p])*(a+b*x^(n-j))^FracPart[p])*
    Int[x^(m+j*p)*(a+b*x^(n-j))^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && Not[IntegerQ[p]] && NeQ[n-j] && PosQ[n-j]


Int[u_^m_.*(a_.*v_^j_.+b_.*v_^n_.)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a*x^j+b*x^n)^p,x],x,v] /;
FreeQ[{a,b,j,m,n,p},x] && LinearPairQ[u,v,x]





(* ::Subsection::Closed:: *)
(*1.1.4.3 (e x)^m (a x^j+b x^k)^p (c+d x^n)^q*)


Int[x_^m_.*(a_.*x_^j_+b_.*x_^k_.)^p_*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a*x^Simplify[j/n]+b*x^Simplify[k/n])^p*(c+d*x)^q,x],x,x^n] /;
FreeQ[{a,b,c,d,j,k,m,n,p,q},x] && Not[IntegerQ[p]] && NeQ[k-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[k/n]] && 
  IntegerQ[Simplify[(m+1)/n]] && NeQ[n^2-1]


Int[(e_*x_)^m_.*(a_.*x_^j_+b_.*x_^k_.)^p_*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^k)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,j,k,m,n,p,q},x] && Not[IntegerQ[p]] && NeQ[k-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[k/n]] && 
  IntegerQ[Simplify[(m+1)/n]] && NeQ[n^2-1]


Int[(e_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^jn_.)^p_*(c_+d_.*x_^n_.),x_Symbol] :=
  c*e^(j-1)*(e*x)^(m-j+1)*(a*x^j+b*x^(j+n))^(p+1)/(a*(m+j*p+1)) /;
FreeQ[{a,b,c,d,e,j,m,n,p},x] && EqQ[jn-j-n] && Not[IntegerQ[p]] && NeQ[b*c-a*d] && 
  EqQ[a*d*(m+j*p+1)-b*c*(m+n+p*(j+n)+1)] && (PositiveQ[e] || IntegersQ[j]) && NeQ[m+j*p+1]


Int[(e_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^jn_.)^p_*(c_+d_.*x_^n_.),x_Symbol] :=
  -e^(j-1)*(b*c-a*d)*(e*x)^(m-j+1)*(a*x^j+b*x^(j+n))^(p+1)/(a*b*n*(p+1)) - 
  e^j*(a*d*(m+j*p+1)-b*c*(m+n+p*(j+n)+1))/(a*b*n*(p+1))*Int[(e*x)^(m-j)*(a*x^j+b*x^(j+n))^(p+1),x] /;
FreeQ[{a,b,c,d,e,j,m,n},x] && EqQ[jn-j-n] && Not[IntegerQ[p]] && NeQ[b*c-a*d] && RationalQ[j,m,p] && p<-1 && 0<j<=m && 
  (PositiveQ[e] || IntegerQ[j])


Int[(e_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^jn_.)^p_*(c_+d_.*x_^n_.),x_Symbol] :=
  c*e^(j-1)*(e*x)^(m-j+1)*(a*x^j+b*x^(j+n))^(p+1)/(a*(m+j*p+1)) + 
  (a*d*(m+j*p+1)-b*c*(m+n+p*(j+n)+1))/(a*e^n*(m+j*p+1))*Int[(e*x)^(m+n)*(a*x^j+b*x^(j+n))^p,x] /;
FreeQ[{a,b,c,d,e,j,p},x] && EqQ[jn-j-n] && Not[IntegerQ[p]] && NeQ[b*c-a*d] && RationalQ[m,n] && n>0 && 
  (m+j*p<-1 || IntegersQ[m-1/2,p-1/2] && p<0 && m<-n*p-1) && 
  (PositiveQ[e] || IntegersQ[j,n]) && NeQ[m+j*p+1] && NeQ[m-n+j*p+1]


Int[(e_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^jn_.)^p_*(c_+d_.*x_^n_.),x_Symbol] :=
  d*e^(j-1)*(e*x)^(m-j+1)*(a*x^j+b*x^(j+n))^(p+1)/(b*(m+n+p*(j+n)+1)) - 
  (a*d*(m+j*p+1)-b*c*(m+n+p*(j+n)+1))/(b*(m+n+p*(j+n)+1))*Int[(e*x)^m*(a*x^j+b*x^(j+n))^p,x] /;
FreeQ[{a,b,c,d,e,j,m,n,p},x] && EqQ[jn-j-n] && Not[IntegerQ[p]] && NeQ[b*c-a*d] && 
  NeQ[m+n+p*(j+n)+1] && (PositiveQ[e] || IntegerQ[j])


Int[x_^m_.*(a_.*x_^j_+b_.*x_^k_.)^p_*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  1/(m+1)*Subst[Int[(a*x^Simplify[j/(m+1)]+b*x^Simplify[k/(m+1)])^p*(c+d*x^Simplify[n/(m+1)])^q,x],x,x^(m+1)] /;
FreeQ[{a,b,c,d,j,k,m,n,p,q},x] && Not[IntegerQ[p]] && NeQ[k-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[k/n]] && 
  NeQ[m+1] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(e_*x_)^m_.*(a_.*x_^j_+b_.*x_^k_.)^p_*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a*x^j+b*x^k)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,j,k,m,n,p,q},x] && Not[IntegerQ[p]] && NeQ[k-j] && IntegerQ[Simplify[j/n]] && IntegerQ[Simplify[k/n]] && 
  NeQ[m+1] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(e_.*x_)^m_.*(a_.*x_^j_.+b_.*x_^jn_.)^p_*(c_+d_.*x_^n_.)^q_.,x_Symbol] :=
  e^IntPart[m]*(e*x)^FracPart[m]*(a*x^j+b*x^(j+n))^FracPart[p]/
    (x^(FracPart[m]+j*FracPart[p])*(a+b*x^n)^FracPart[p])*
    Int[x^(m+j*p)*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,e,j,m,n,p,q},x] && EqQ[jn-j-n] && Not[IntegerQ[p]] && NeQ[b*c-a*d] && Not[EqQ[n-1] && EqQ[j-1]]





(* ::Subsection::Closed:: *)
(*1.1.4.4 (c x)^m Pq(x) (a x^j+b x^n)^p*)


Int[Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  With[{d=Denominator[n]},
  d*Subst[Int[x^(d-1)*ReplaceAll[SubstFor[x^n,Pq,x],x->x^(d*n)]*(a*x^(d*j)+b*x^(d*n))^p,x],x,x^(1/d)]] /;
FreeQ[{a,b,j,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && RationalQ[j,n] && IntegerQ[j/n] && -1<n<1


Int[x_^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*SubstFor[x^n,Pq,x]*(a*x^Simplify[j/n]+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,j,m,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[(m+1)/n]]


Int[(c_*x_)^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  c^(Sign[m]*Quotient[m,Sign[m]])*(c*x)^Mod[m,Sign[m]]/x^Mod[m,Sign[m]]*Int[x^m*Pq*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[(m+1)/n]] && RationalQ[m] && m^2>1


Int[(c_*x_)^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^m/x^m*Int[x^m*Pq*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  With[{g=GCD[m+1,n]},
  1/g*Subst[Int[x^((m+1)/g-1)*ReplaceAll[Pq,x->x^(1/g)]*(a*x^(j/g)+b*x^(n/g))^p,x],x,x^g] /;
 g!=1] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && PositiveIntegerQ[j,n,j/n] && IntegerQ[m]


Int[(c_.*x_)^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    Pqq*(c*x)^(m+q-n+1)*(a*x^j+b*x^n)^(p+1)/(b*c^(q-n+1)*(m+q+n*p+1)) + 
    Int[(c*x)^m*ExpandToSum[Pq-Pqq*x^q-a*Pqq*(m+q-n+1)*x^(q-n)/(b*(m+q+n*p+1)),x]*(a*x^j+b*x^n)^p,x]] /;
  q>n-1 && m+q+n*p+1!=0 && (IntegerQ[2*p] || IntegerQ[p+(q+1)/(2*n)])] /;
FreeQ[{a,b,c,m,p},x] && PolyQ[Pq,x] && Not[IntegerQ[p]] && PositiveIntegerQ[j,n] && j<n


Int[x_^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  1/(m+1)*Subst[
    Int[ReplaceAll[SubstFor[x^n,Pq,x],x->x^Simplify[n/(m+1)]]*(a*x^Simplify[j/(m+1)]+b*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,j,m,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_*x_)^m_*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  c^(Sign[m]*Quotient[m,Sign[m]])*(c*x)^Mod[m,Sign[m]]/x^Mod[m,Sign[m]]*Int[x^m*Pq*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]] && RationalQ[m] && m^2>1


Int[(c_*x_)^m_*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  (c*x)^m/x^m*Int[x^m*Pq*(a*x^j+b*x^n)^p,x] /;
FreeQ[{a,b,c,j,m,n,p},x] && PolyQ[Pq,x^n] && Not[IntegerQ[p]] && NeQ[n-j] && IntegerQ[Simplify[j/n]] && 
  IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_.*x_)^m_.*Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(c*x)^m*Pq*(a*x^j+b*x^n)^p,x],x] /;
FreeQ[{a,b,c,j,m,n,p},x] && (PolyQ[Pq,x] || PolyQ[Pq,x^n]) && Not[IntegerQ[p]] && NeQ[n-j]


Int[Pq_*(a_.*x_^j_.+b_.*x_^n_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a*x^j+b*x^n)^p,x],x] /;
FreeQ[{a,b,j,n,p},x] && (PolyQ[Pq,x] || PolyQ[Pq,x^n]) && Not[IntegerQ[p]] && NeQ[n-j]



`)

func resourcesRubi114ImproperBinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi114ImproperBinomialProductsM, nil
}

func resourcesRubi114ImproperBinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi114ImproperBinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.1.4 Improper binomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi121QuadraticTrinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*Quadratic Product Rules*)


(* ::Subsection::Closed:: *)
(*1.2.1.1 (a+b x+c x^2)^p*)


Int[1/Sqrt[a_+b_.*x_+c_.*x_^2],x_Symbol] :=
  (b/2+c*x)/Sqrt[a+b*x+c*x^2]*Int[1/(b/2+c*x),x] /;
FreeQ[{a,b,c},x] && EqQ[b^2-4*a*c,0]


Int[(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^p/(2*c*(2*p+1)) /;
FreeQ[{a,b,c,p},x] && EqQ[b^2-4*a*c,0] && NeQ[p,-1/2]


Int[(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  1/c^p*Int[Simp[b/2-q/2+c*x,x]^p*Simp[b/2+q/2+c*x,x]^p,x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && IGtQ[p,0] && PerfectSquareQ[b^2-4*a*c]


Int[(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && IGtQ[p,0] && Not[PerfectSquareQ[b^2-4*a*c]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^p/(2*c*(2*p+1)) -
  p*(b^2-4*a*c)/(2*c*(2*p+1))*Int[(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && GtQ[p,0] && IntegerQ[4*p]


Int[1/(a_.+b_.*x_+c_.*x_^2)^(3/2),x_Symbol] :=
  -2*(b+2*c*x)/((b^2-4*a*c)*Sqrt[a+b*x+c*x^2]) /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0]


Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) -
  2*c*(2*p+3)/((p+1)*(b^2-4*a*c))*Int[(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && LtQ[p,-1] && NeQ[p,-3/2] && IntegerQ[4*p]


Int[1/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  c/q*Int[1/Simp[b/2-q/2+c*x,x],x] - c/q*Int[1/Simp[b/2+q/2+c*x,x],x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && PosQ[b^2-4*a*c] && PerfectSquareQ[b^2-4*a*c]


Int[1/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  With[{q=1-4*Simplify[a*c/b^2]},
  -2/b*Subst[Int[1/(q-x^2),x],x,1+2*c*x/b] /;
 RationalQ[q] && (EqQ[q^2,1] || Not[RationalQ[b^2-4*a*c]])] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0]


Int[1/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  -2*Subst[Int[1/Simp[b^2-4*a*c-x^2,x],x],x,b+2*c*x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0]


Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  1/(2*c*(-4*c/(b^2-4*a*c))^p)*Subst[Int[Simp[1-x^2/(b^2-4*a*c),x]^p,x],x,b+2*c*x] /;
FreeQ[{a,b,c,p},x] && PositiveQ[4*a-b^2/c]


Int[1/Sqrt[b_.*x_+c_.*x_^2],x_Symbol] :=
  2*Subst[Int[1/(1-c*x^2),x],x,x/Sqrt[b*x+c*x^2]] /;
FreeQ[{b,c},x]


Int[1/Sqrt[a_+b_.*x_+c_.*x_^2],x_Symbol] :=
  2*Subst[Int[1/(4*c-x^2),x],x,(b+2*c*x)/Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0]


Int[(b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (b*x+c*x^2)^p/(-c*(b*x+c*x^2)/(b^2))^p*Int[(-c*x/b-c^2*x^2/b^2)^p,x] /;
FreeQ[{b,c},x] && RationalQ[p] && 3<=Denominator[p]<=4


(* Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^p/(-c*(a+b*x+c*x^2)/(b^2-4*a*c))^p*Int[(-a*c/(b^2-4*a*c)-b*c*x/(b^2-4*a*c)-c^2*x^2/(b^2-4*a*c))^p,x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && RationalQ[p] && 3<=Denominator[p]<=4 *)


Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{d=Denominator[p]},
  d*Sqrt[(b+2*c*x)^2]/(b+2*c*x)*Subst[Int[x^(d*(p+1)-1)/Sqrt[b^2-4*a*c+4*c*x^d],x],x,(a+b*x+c*x^2)^(1/d)] /;
 3<=d<=4] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && RationalQ[p]


Int[(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -(a+b*x+c*x^2)^(p+1)/(q*(p+1)*((q-b-2*c*x)/(2*q))^(p+1))*Hypergeometric2F1[-p,p+1,p+2,(b+q+2*c*x)/(2*q)]] /;
FreeQ[{a,b,c,p},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[4*p]]


Int[(a_.+b_.*u_+c_.*u_^2)^p_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x+c*x^2)^p,x],x,u] /;
FreeQ[{a,b,c,p},x] && LinearQ[u,x] && NeQ[u,x]





(* ::Subsection::Closed:: *)
(*1.2.1.2 (d+e x)^m (a+b x+c x^2)^p*)


Int[(d_+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(p+1)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d^2-b*d*e+a*e^2,0] && IGtQ[p,0]


Int[(d_.+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e},x] && IGtQ[p,0]


Int[(d_.+e_.*x_)/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (c*d-e*(b/2-q/2))/q*Int[1/(b/2-q/2+c*x),x] - (c*d-e*(b/2+q/2))/q*Int[1/(b/2+q/2+c*x),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NiceSqrtQ[b^2-4*a*c]


Int[(d_+e_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (e/2+c*d/(2*q))*Int[1/(-q+c*x),x] + (e/2-c*d/(2*q))*Int[1/(q+c*x),x]] /;
FreeQ[{a,c,d,e},x] && NiceSqrtQ[-a*c]


Int[(d_.+e_.*x_)/(a_+b_.*x_+c_.*x_^2),x_Symbol] :=
(* (d-b*e/(2*c))*Int[1/(a+b*x+c*x^2),x] + *)
  (2*c*d-b*e)/(2*c)*Int[1/(a+b*x+c*x^2),x] + e/(2*c)*Int[(b+2*c*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && Not[NiceSqrtQ[b^2-4*a*c]]


Int[(d_+e_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  d*Int[1/(a+c*x^2),x] + e*Int[x/(a+c*x^2),x] /;
FreeQ[{a,c,d,e},x] && Not[NiceSqrtQ[-a*c]]


Int[(d_.+e_.*x_)/(a_.+b_.*x_+c_.*x_^2)^(3/2),x_Symbol] :=
  -2*(b*d-2*a*e+(2*c*d-b*e)*x)/((b^2-4*a*c)*Sqrt[a+b*x+c*x^2]) /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c]


Int[(d_+e_.*x_)/(a_+c_.*x_^2)^(3/2),x_Symbol] :=
  (-a*e+c*d*x)/(a*c*Sqrt[a+c*x^2]) /;
FreeQ[{a,c,d,e},x]


Int[(d_.+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (b*d-2*a*e+(2*c*d-b*e)*x)/((p+1)*(b^2-4*a*c))*(a+b*x+c*x^2)^(p+1) - 
  (2*p+3)*(2*c*d-b*e)/((p+1)*(b^2-4*a*c))*Int[(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && LtQ[p,-1]


Int[(d_+e_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (a*e-c*d*x)/(2*a*c*(p+1))*(a+c*x^2)^(p+1) + 
  d*(2*p+3)/(2*a*(p+1))*Int[(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && LtQ[p,-1]


Int[(d_.+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(a+b*x+c*x^2)^(p+1)/(2*c*(p+1)) + (2*c*d-b*e)/(2*c)*Int[(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[p,-1]


Int[(d_.+e_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  e*(a+c*x^2)^(p+1)/(2*c*(p+1)) + d*Int[(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,p},x] && NeQ[p,-1]


Int[(d_+e_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^p/(d+e*x)^(2*p)*Int[(d+e*x)^(m+2*p),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && EqQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0]


Int[(d_.+e_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/(c^IntPart[p]*(b/2+c*x)^(2*FracPart[p]))*Int[(d+e*x)^m*(b/2+c*x)^(2*p),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && EqQ[b^2-4*a*c,0]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && IntegerQ[p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && (IntegerQ[p] || PositiveQ[a] && PositiveQ[d] && IntegerQ[m+p])


(* Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(a+b*x+c*x^2)^(m+p),x] /;
FreeQ[{a,b,c,d,e,p},x] && EqQ[c*d^2-b*d*e+a*e^2,0] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]] *)


(* Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(a+c*x^2)^(m+p),x] /;
FreeQ[{a,c,d,e,p},x] && EqQ[c*d^2+a*e^2,0] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]] *)


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(c*(p+1)) /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && EqQ[m+p,0]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+c*x^2)^(p+1)/(c*(p+1)) /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && EqQ[m+p,0]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/((p+1)*(2*c*d-b*e)) /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && EqQ[m+2*p+2,0]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(p+1)) /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && EqQ[m+2*p+2,0]


Int[(d_.+e_.*x_)^2*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)*(a+b*x+c*x^2)^(p+1)/(c*(p+1)) - e^2*(p+2)/(c*(p+1))*Int[(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && RationalQ[p] && p<-1


Int[(d_+e_.*x_)^2*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)*(a+c*x^2)^(p+1)/(c*(p+1)) - e^2*(p+2)/(c*(p+1))*Int[(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && RationalQ[p] && p<-1


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(a+b*x+c*x^2)^(m+p)/(a/d+c*x/e)^m,x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && IntegerQ[m] && 
  RationalQ[p] && (0<-m<p || p<-m<0) && m!=2 && m!=-1


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  d^(2*m)/a^m*Int[(a+c*x^2)^(m+p)/(d-e*x)^m,x] /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && IntegerQ[m] && 
  RationalQ[p] && (0<-m<p || p<-m<0) && m!=2 && m!=-1


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  Simplify[m+p]*(2*c*d-b*e)/(c*(m+2*p+1))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && PositiveIntegerQ[Simplify[m+p]]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  2*c*d*Simplify[m+p]/(c*(m+2*p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && PositiveIntegerQ[Simplify[m+p]]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/((m+p+1)*(2*c*d-b*e)) + 
  c*Simplify[m+2*p+2]/((m+p+1)*(2*c*d-b*e))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]] && 
  NegativeIntegerQ[Simplify[m+2*p+2]]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(m+p+1)) + 
  Simplify[m+2*p+2]/(2*d*(m+p+1))*Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && NegativeIntegerQ[Simplify[m+2*p+2]]


Int[1/(Sqrt[d_.+e_.*x_]*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  2*e*Subst[Int[1/(2*c*d-b*e+e^2*x^2),x],x,Sqrt[a+b*x+c*x^2]/Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0]


Int[1/(Sqrt[d_+e_.*x_]*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  2*e*Subst[Int[1/(2*c*d+e^2*x^2),x],x,Sqrt[a+c*x^2]/Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2+a*e^2,0]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+p+1)) - 
  c*p/(e^2*(m+p+1))*Int[(d+e*x)^(m+2)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m,p] && p>0 && 
  (m<-2 || EqQ[m+2*p+1]) && NeQ[m+p+1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+c*x^2)^p/(e*(m+p+1)) - 
  c*p/(e^2*(m+p+1))*Int[(d+e*x)^(m+2)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m,p] && p>0 && 
  (m<-2 || EqQ[m+2*p+1]) && NeQ[m+p+1] && IntegerQ[2*p]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+2*p+1)) - 
  p*(2*c*d-b*e)/(e^2*(m+2*p+1))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m,p] && p>0 && 
  (-2<=m<0 || m+p+1==0) && NeQ[m+2*p+1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+c*x^2)^p/(e*(m+2*p+1)) - 
  2*c*d*p/(e^2*(m+2*p+1))*Int[(d+e*x)^(m+1)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m,p] && p>0 && 
  (-2<=m<0 || m+p+1==0) && NeQ[m+2*p+1] && IntegerQ[2*p]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (2*c*d-b*e)*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(e*(p+1)*(b^2-4*a*c)) - 
  (2*c*d-b*e)*(m+2*p+2)/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m,p] && p<-1 && 0<m<=1 && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -d*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*a*e*(p+1)) + 
  d*(m+2*p+2)/(2*a*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m,p] && p<-1 && 0<m<=1 && IntegerQ[2*p]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(c*(p+1)) - 
  e^2*(m+p)/(c*(p+1))*Int[(d+e*x)^(m-2)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m,p] && p<-1 && m>1 && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+c*x^2)^(p+1)/(c*(p+1)) - 
  e^2*(m+p)/(c*(p+1))*Int[(d+e*x)^(m-2)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m,p] && p<-1 && m>1 && IntegerQ[2*p]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  (m+p)*(2*c*d-b*e)/(c*(m+2*p+1))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m] && m>=1 && 
  NeQ[m+2*p+1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  2*c*d*(m+p)/(c*(m+2*p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,p},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m] && m>=1 && NeQ[m+2*p+1] && IntegerQ[2*p]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/((m+p+1)*(2*c*d-b*e)) + 
  c*(m+2*p+2)/((m+p+1)*(2*c*d-b*e))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m] && m<0 && NeQ[m+p+1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(m+p+1)) + 
  (m+2*p+2)/(2*d*(m+p+1))*Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,p},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m] && m<0 && NeQ[m+p+1] && IntegerQ[2*p]


Int[(e_.*x_)^m_*(b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (e*x)^m*(b*x+c*x^2)^p/(x^(m+p)*(b+c*x)^p)*Int[x^(m+p)*(b+c*x)^p,x] /;
FreeQ[{b,c,e,m},x] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]] && PositiveQ[a] && PositiveQ[d]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (a+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,m},x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]]


Int[1/((d_+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  -4*b*c/(d*(b^2-4*a*c))*Int[1/(b+2*c*x),x] + 
  b^2/(d^2*(b^2-4*a*c))*Int[(d+e*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  2*c*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(e*(p+1)*(b^2-4*a*c)) /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && EqQ[m+2*p+3] && NeQ[p+1]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && PositiveIntegerQ[p] && Not[EqQ[m-3] && p!=1]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+1)) - 
  b*p/(d*e*(m+1))*Int[(d+e*x)^(m+2)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[m,p] && p>0 && m<-1 && 
  Not[EvenQ[m] && m+2*p+3<0] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+2*p+1)) - 
  d*p*(b^2-4*a*c)/(b*e*(m+2*p+1))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[p] && p>0 && 
  Not[RationalQ[m] && m<-1] && Not[PositiveIntegerQ[(m-1)/2] && (Not[IntegerQ[p]] || m<2*p)] && RationalQ[m] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  d*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(b*(p+1)) - 
  d*e*(m-1)/(b*(p+1))*Int[(d+e*x)^(m-2)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[m,p] && p<-1 && m>1 && 
  IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  2*c*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(e*(p+1)*(b^2-4*a*c)) - 
  2*c*e*(m+2*p+3)/(e*(p+1)*(b^2-4*a*c))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[p] && p<-1 && 
  Not[RationalQ[m] && m>1] && RationalQ[m] && IntegerQ[2*p]


Int[1/((d_+e_.*x_)*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  4*c*Subst[Int[1/(b^2*e-4*a*c*e+4*c*e*x^2),x],x,Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0]


Int[1/(Sqrt[d_+e_.*x_]*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  4/e*Sqrt[-c/(b^2-4*a*c)]*Subst[Int[1/Sqrt[Simp[1-b^2*x^4/(d^2*(b^2-4*a*c)),x]],x],x,Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NegativeQ[c/(b^2-4*a*c)]


Int[Sqrt[d_+e_.*x_]/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  4/e*Sqrt[-c/(b^2-4*a*c)]*Subst[Int[x^2/Sqrt[Simp[1-b^2*x^4/(d^2*(b^2-4*a*c)),x]],x],x,Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NegativeQ[c/(b^2-4*a*c)]


Int[(d_+e_.*x_)^m_/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  Sqrt[-c*(a+b*x+c*x^2)/(b^2-4*a*c)]/Sqrt[a+b*x+c*x^2]*
    Int[(d+e*x)^m/Sqrt[-a*c/(b^2-4*a*c)-b*c*x/(b^2-4*a*c)-c^2*x^2/(b^2-4*a*c)],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && EqQ[m^2,1/4]


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  2*d*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(b*(m+2*p+1)) + 
  d^2*(m-1)*(b^2-4*a*c)/(b^2*(m+2*p+1))*Int[(d+e*x)^(m-2)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[m] && m>1 && 
  NeQ[m+2*p+1] && (IntegerQ[2*p] || IntegerQ[m] && RationalQ[p] || OddQ[m])


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -2*b*d*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(d^2*(m+1)*(b^2-4*a*c)) + 
  b^2*(m+2*p+3)/(d^2*(m+1)*(b^2-4*a*c))*Int[(d+e*x)^(m+2)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0] && NeQ[m+2*p+3] && RationalQ[m] && m<-1 && 
  (IntegerQ[2*p] || IntegerQ[m] && RationalQ[p] || IntegerQ[(m+2*p+3)/2])


Int[(d_+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  1/e*Subst[Int[x^m*(a-b^2/(4*c)+(c*x^2)/e^2)^p,x],x,d+e*x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  PositiveIntegerQ[p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[p] && Not[EqQ[m-1] && p>1] 


(* Int[Sqrt[d_.+e_.*x_]/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[(c*d^2-b*d*e+a*e^2)/c,2]},
  1/2*Int[(d+q+e*x)/(Sqrt[d+e*x]*(a+b*x+c*x^2)),x] + 
  1/2*Int[(d-q+e*x)/(Sqrt[d+e*x]*(a+b*x+c*x^2)),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  NegativeQ[b^2-4*a*c] *)


(* Int[Sqrt[d_+e_.*x_]/(a_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[(c*d^2+a*e^2)/c,2]},
  1/2*Int[(d+q+e*x)/(Sqrt[d+e*x]*(a+c*x^2)),x] + 
  1/2*Int[(d-q+e*x)/(Sqrt[d+e*x]*(a+c*x^2)),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && NegativeQ[-a*c] *)


(* Int[Sqrt[d_.+e_.*x_]/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*d-b*e+e*q)/q*Int[1/(Sqrt[d+e*x]*(b-q+2*c*x)),x] - 
  (2*c*d-b*e-e*q)/q*Int[1/(Sqrt[d+e*x]*(b+q+2*c*x)),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] (* && 
  Not[NegativeQ[b^2-4*a*c]] *) *)


(* Int[Sqrt[d_+e_.*x_]/(a_+c_.*x_^2),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (c*d+e*q)/(2*q)*Int[1/(Sqrt[d+e*x]*(-q+c*x)),x] - 
  (c*d-e*q)/(2*q)*Int[1/(Sqrt[d+e*x]*(+q+c*x)),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] (* && Not[NegativeQ[-a*c]] *) *)


Int[Sqrt[d_.+e_.*x_]/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  2*e*Subst[Int[x^2/(c*d^2-b*d*e+a*e^2-(2*c*d-b*e)*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e]


Int[Sqrt[d_+e_.*x_]/(a_+c_.*x_^2),x_Symbol] :=
  2*e*Subst[Int[x^2/(c*d^2+a*e^2-2*c*d*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[(d_.+e_.*x_)^m_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[PolynomialDivide[(d+e*x)^m,a+b*x+c*x^2,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  IntegerQ[m] && m>1 && (NeQ[d] || m>2)


Int[(d_+e_.*x_)^m_/(a_+c_.*x_^2),x_Symbol] :=
  Int[PolynomialDivide[(d+e*x)^m,a+c*x^2,x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && IntegerQ[m] && m>1 && (NeQ[d] || m>2)


Int[(d_.+e_.*x_)^m_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m-1)/(c*(m-1)) + 
  1/c*Int[(d+e*x)^(m-2)*Simp[c*d^2-a*e^2+e*(2*c*d-b*e)*x,x]/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && RationalQ[m] && m>1


Int[(d_+e_.*x_)^m_/(a_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m-1)/(c*(m-1)) + 
  1/c*Int[(d+e*x)^(m-2)*Simp[c*d^2-a*e^2+2*c*d*e*x,x]/(a+c*x^2),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[m] && m>1


Int[1/((d_.+e_.*x_)*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  e^2/(c*d^2-b*d*e+a*e^2)*Int[1/(d+e*x),x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(c*d-b*e-c*e*x)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e]


Int[1/((d_+e_.*x_)*(a_+c_.*x_^2)),x_Symbol] :=
  e^2/(c*d^2+a*e^2)*Int[1/(d+e*x),x] + 
  1/(c*d^2+a*e^2)*Int[(c*d-c*e*x)/(a+c*x^2),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


(* Int[1/(Sqrt[d_.+e_.*x_]*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  With[{q=Rt[(c*d^2-b*d*e+a*e^2)/c,2]},
  1/(2*q)*Int[(d+q+e*x)/(Sqrt[d+e*x]*(a+b*x+c*x^2)),x] - 
  1/(2*q)*Int[(d-q+e*x)/(Sqrt[d+e*x]*(a+b*x+c*x^2)),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  NegativeQ[b^2-4*a*c] *)


(* Int[1/(Sqrt[d_+e_.*x_]*(a_+c_.*x_^2)),x_Symbol] :=
  With[{q=Rt[(c*d^2+a*e^2)/c,2]},
  1/(2*q)*Int[(d+q+e*x)/(Sqrt[d+e*x]*(a+c*x^2)),x] - 
  1/(2*q)*Int[(d-q+e*x)/(Sqrt[d+e*x]*(a+c*x^2)),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && NegativeQ[-a*c] *)


(* Int[1/(Sqrt[d_.+e_.*x_]*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[1/(Sqrt[d+e*x]*(b-q+2*c*x)),x] - 
  2*c/q*Int[1/(Sqrt[d+e*x]*(b+q+2*c*x)),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] (* && 
  Not[NegativeQ[b^2-4*a*c]] *) *)


(* Int[1/(Sqrt[d_+e_.*x_]*(a_+c_.*x_^2)),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  c/(2*q)*Int[1/(Sqrt[d+e*x]*(-q+c*x)),x] - 
  c/(2*q)*Int[1/(Sqrt[d+e*x]*(q+c*x)),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] (* && Not[NegativeQ[-a*c]] *) *)


Int[1/(Sqrt[d_.+e_.*x_]*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  2*e*Subst[Int[1/(c*d^2-b*d*e+a*e^2-(2*c*d-b*e)*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e]


Int[1/(Sqrt[d_+e_.*x_]*(a_+c_.*x_^2)),x_Symbol] :=
  2*e*Subst[Int[1/(c*d^2+a*e^2-2*c*d*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[(d_.+e_.*x_)^m_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x)^(m+1)*Simp[c*d-b*e-c*e*x,x]/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && RationalQ[m] && m<-1


Int[(d_+e_.*x_)^m_/(a_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m+1)/((m+1)*(c*d^2+a*e^2)) + 
  c/(c*d^2+a*e^2)*Int[(d+e*x)^(m+1)*(d-e*x)/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && RationalQ[m] && m<-1


Int[(d_.+e_.*x_)^m_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m,1/(a+b*x+c*x^2),x],x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && Not[IntegerQ[m]]


Int[(d_+e_.*x_)^m_/(a_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m,1/(a+c*x^2),x],x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[m]]


Int[(d_.+e_.*x_)^m_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^FracPart[p]*(a+b*x+c*x^2)^FracPart[p]/(a*d+c*e*x^3)^FracPart[p]*Int[(d+e*x)^(m-p)*(a*d+c*e*x^3)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && EqQ[b*d+a*e] && EqQ[c*d+b*e] && PositiveIntegerQ[m-p+1] && Not[IntegerQ[p]]


Int[(d_.+e_.*x_)^m_/Sqrt[b_.*x_+c_.*x_^2],x_Symbol] :=
  Int[(d+e*x)^m/(Sqrt[b*x]*Sqrt[1+c/b*x]),x] /;
FreeQ[{b,c,d,e},x] && NeQ[c*d-b*e] && NeQ[2*c*d-b*e] && RationalQ[m] && m^2==1/4 && NegativeQ[c] && RationalQ[b]


Int[(d_.+e_.*x_)^m_/Sqrt[b_.*x_+c_.*x_^2],x_Symbol] :=
  Sqrt[x]*Sqrt[b+c*x]/Sqrt[b*x+c*x^2]*Int[(d+e*x)^m/(Sqrt[x]*Sqrt[b+c*x]),x] /;
FreeQ[{b,c,d,e},x] && NeQ[c*d-b*e] && NeQ[2*c*d-b*e] && RationalQ[m] && m^2==1/4


Int[x_^m_/Sqrt[a_+b_.*x_+c_.*x_^2],x_Symbol] :=
  2*Subst[Int[x^(2*m+1)/Sqrt[a+b*x^2+c*x^4],x],x,Sqrt[x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c,0] && EqQ[m^2-1/4]


Int[(e_*x_)^m_/Sqrt[a_+b_.*x_+c_.*x_^2],x_Symbol] :=
  (e*x)^m/x^m*Int[x^m/Sqrt[a+b*x+c*x^2], x] /;
FreeQ[{a,b,c,e},x] && NeQ[b^2-4*a*c,0] && EqQ[m^2-1/4]


Int[(d_.+e_.*x_)^m_/Sqrt[a_.+b_.*x_+c_.*x_^2],x_Symbol] :=
  2*Rt[b^2-4*a*c,2]*(d+e*x)^m*Sqrt[-c*(a+b*x+c*x^2)/(b^2-4*a*c)]/
    (c*Sqrt[a+b*x+c*x^2]*(2*c*(d+e*x)/(2*c*d-b*e-e*Rt[b^2-4*a*c,2]))^m)*
    Subst[Int[(1+2*e*Rt[b^2-4*a*c,2]*x^2/(2*c*d-b*e-e*Rt[b^2-4*a*c,2]))^m/Sqrt[1-x^2],x],x,
      Sqrt[(b+Rt[b^2-4*a*c,2]+2*c*x)/(2*Rt[b^2-4*a*c,2])]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && EqQ[m^2-1/4]


Int[(d_+e_.*x_)^m_/Sqrt[a_+c_.*x_^2],x_Symbol] :=
  2*a*Rt[-c/a,2]*(d+e*x)^m*Sqrt[1+c*x^2/a]/(c*Sqrt[a+c*x^2]*(c*(d+e*x)/(c*d-a*e*Rt[-c/a,2]))^m)*
    Subst[Int[(1+2*a*e*Rt[-c/a,2]*x^2/(c*d-a*e*Rt[-c/a,2]))^m/Sqrt[1-x^2],x],x,Sqrt[(1-Rt[-c/a,2]*x)/2]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && EqQ[m^2-1/4]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^(m+1)*(d*b-2*a*e+(2*c*d-b*e)*x)*(a+b*x+c*x^2)^p/(2*(m+1)*(c*d^2-b*d*e+a*e^2)) + 
  p*(b^2-4*a*c)/(2*(m+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+2)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  RationalQ[m,p] && m+2*p+2==0 && p>0


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^(m+1)*(-2*a*e+(2*c*d)*x)*(a+c*x^2)^p/(2*(m+1)*(c*d^2+a*e^2)) - 
  4*a*c*p/(2*(m+1)*(c*d^2+a*e^2))*Int[(d+e*x)^(m+2)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[m,p] && m+2*p+2==0 && p>0


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m-1)*(d*b-2*a*e+(2*c*d-b*e)*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) - 
  2*(2*p+3)*(c*d^2-b*d*e+a*e^2)/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-2)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  RationalQ[m,p] && m+2*p+2==0 && p<-1


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m-1)*(a*e-c*d*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) + 
  (2*p+3)*(c*d^2+a*e^2)/(2*a*c*(p+1))*Int[(d+e*x)^(m-2)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[m,p] && m+2*p+2==0 && p<-1


Int[1/((d_.+e_.*x_)*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  -2*Subst[Int[1/(4*c*d^2-4*b*d*e+4*a*e^2-x^2),x],x,(2*a*e-b*d-(2*c*d-b*e)*x)/Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[2*c*d-b*e]


Int[1/((d_+e_.*x_)*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  -Subst[Int[1/(c*d^2+a*e^2-x^2),x],x,(a*e-c*d*x)/Sqrt[a+c*x^2]] /;
FreeQ[{a,c,d,e},x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(b-Rt[b^2-4*a*c,2]+2*c*x)*(d+e*x)^(m+1)*(a+b*x+c*x^2)^p/
    ((m+1)*(2*c*d-b*e+e*Rt[b^2-4*a*c,2])*
      ((2*c*d-b*e+e*Rt[b^2-4*a*c,2])*(b+Rt[b^2-4*a*c,2]+2*c*x)/((2*c*d-b*e-e*Rt[b^2-4*a*c,2])*(b-Rt[b^2-4*a*c,2]+2*c*x)))^p)*
    Hypergeometric2F1[m+1,-p,m+2,-4*c*Rt[b^2-4*a*c,2]*(d+e*x)/((2*c*d-b*e-e*Rt[b^2-4*a*c,2])*(b-Rt[b^2-4*a*c,2]+2*c*x))] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && Not[IntegerQ[p]] && 
  EqQ[m+2*p+2]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (Rt[-a*c,2]-c*x)*(d+e*x)^(m+1)*(a+c*x^2)^p/
    ((m+1)*(c*d+e*Rt[-a*c,2])*((c*d+e*Rt[-a*c,2])*(Rt[-a*c,2]+c*x)/((c*d-e*Rt[-a*c,2])*(-Rt[-a*c,2]+c*x)))^p)*
    Hypergeometric2F1[m+1,-p,m+2,2*c*Rt[-a*c,2]*(d+e*x)/((c*d-e*Rt[-a*c,2])*(Rt[-a*c,2]-c*x))] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && EqQ[m+2*p+2]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(b+2*c*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) + 
  m*(2*c*d-b*e)/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && EqQ[m+2*p+3] && 
  RationalQ[p] && p<-1


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^m*(2*c*x)*(a+c*x^2)^(p+1)/(4*a*c*(p+1)) - 
  m*(2*c*d)/(4*a*c*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && EqQ[m+2*p+3] && RationalQ[p] && p<-1


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  (2*c*d-b*e)/(2*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && EqQ[m+2*p+3]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/((m+1)*(c*d^2+a*e^2)) + 
  c*d/(c*d^2+a*e^2)*Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && EqQ[m+2*p+3]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+1)) - 
  p/(e*(m+1))*Int[(d+e*x)^(m+1)*(b+2*c*x)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && RationalQ[p] && p>0 && 
  (IntegerQ[p] || RationalQ[m] && m<-1) && NeQ[m+1] && Not[NegativeIntegerQ[m+2*p+1]] && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+c*x^2)^p/(e*(m+1)) - 
  2*c*p/(e*(m+1))*Int[x*(d+e*x)^(m+1)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && RationalQ[p] && p>0 && 
  (IntegerQ[p] || RationalQ[m] && m<-1) && NeQ[m+1] && Not[NegativeIntegerQ[m+2*p+1]] && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e*(m+2*p+1)) - 
  p/(e*(m+2*p+1))*Int[(d+e*x)^m*Simp[b*d-2*a*e+(2*c*d-b*e)*x,x]*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && RationalQ[p] && p>0 && 
  NeQ[m+2*p+1] && (Not[RationalQ[m]] || m<1) && Not[NegativeIntegerQ[m+2*p]] && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(a+c*x^2)^p/(e*(m+2*p+1)) + 
  2*p/(e*(m+2*p+1))*Int[(d+e*x)^m*Simp[a*e-c*d*x,x]*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && RationalQ[p] && p>0 && 
  NeQ[m+2*p+1] && (Not[RationalQ[m]] || m<1) && Not[NegativeIntegerQ[m+2*p]] && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(b+2*c*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) - 
  1/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(b*e*m+2*c*d*(2*p+3)+2*c*e*(m+2*p+3)*x)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  RationalQ[m,p] && p<-1 && m>0 && (m<1 || NegativeIntegerQ[m+2*p+3] && m!=2) && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -x*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*a*(p+1)) + 
  1/(2*a*(p+1))*Int[(d+e*x)^(m-1)*(d*(2*p+3)+e*(m+2*p+3)*x)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && 
  RationalQ[m,p] && p<-1 && m>0 && (m<1 || NegativeIntegerQ[m+2*p+3] && m!=2) && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m-1)*(d*b-2*a*e+(2*c*d-b*e)*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) + 
  1/((p+1)*(b^2-4*a*c))*
    Int[(d+e*x)^(m-2)*
      Simp[e*(2*a*e*(m-1)+b*d*(2*p-m+4))-2*c*d^2*(2*p+3)+e*(b*e-2*d*c)*(m+2*p+2)*x,x]*
      (a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  RationalQ[m,p] && p<-1 && m>1 && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m-1)*(a*e-c*d*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) + 
  1/((p+1)*(-2*a*c))*
    Int[(d+e*x)^(m-2)*Simp[a*e^2*(m-1)-c*d^2*(2*p+3)-d*c*e*(m+2*p+2)*x,x]*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[m,p] && p<-1 && m>1 && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(b*c*d-b^2*e+2*a*c*e+c*(2*c*d-b*e)*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2)) + 
  1/((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2))*
    Int[(d+e*x)^m*
      Simp[b*c*d*e*(2*p-m+2)+b^2*e^2*(m+p+2)-2*c^2*d^2*(2*p+3)-2*a*c*e^2*(m+2*p+3)-c*e*(2*c*d-b*e)*(m+2*p+4)*x,x]*
      (a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  RationalQ[p] && p<-1 && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^(m+1)*(a*e+c*d*x)*(a+c*x^2)^(p+1)/(2*a*(p+1)*(c*d^2+a*e^2)) + 
  1/(2*a*(p+1)*(c*d^2+a*e^2))*
    Int[(d+e*x)^m*Simp[c*d^2*(2*p+3)+a*e^2*(m+2*p+3)+c*e*d*(m+2*p+4)*x,x]*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,m},x] && NeQ[c*d^2+a*e^2] && RationalQ[p] && p<-1 && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  1/(c*(m+2*p+1))*
    Int[(d+e*x)^(m-2)*
      Simp[c*d^2*(m+2*p+1)-e*(a*e*(m-1)+b*d*(p+1))+e*(2*c*d-b*e)*(m+p)*x,x]*
      (a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  If[RationalQ[m], m>1, SumSimplerQ[m,-2]] && NeQ[m+2*p+1] && IntQuadraticQ[a,b,c,d,e,m,p,x]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(a+c*x^2)^(p+1)/(c*(m+2*p+1)) + 
  1/(c*(m+2*p+1))*
    Int[(d+e*x)^(m-2)*Simp[c*d^2*(m+2*p+1)-a*e^2*(m-1)+2*c*d*e*(m+p)*x,x]*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && 
  If[RationalQ[m], m>1, SumSimplerQ[m,-2]] && NeQ[m+2*p+1] && IntQuadraticQ[a,0,c,d,e,m,p,x]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/((m+1)*(c*d^2-b*d*e+a*e^2))*
    Int[(d+e*x)^(m+1)*Simp[c*d*(m+1)-b*e*(m+p+2)-c*e*(m+2*p+3)*x,x]*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && 
  (RationalQ[m] && m<-1 && IntQuadraticQ[a,b,c,d,e,m,p,x] || 
   SumSimplerQ[m,1] && IntegerQ[p] && NeQ[m+1] || 
   NegativeIntegerQ[Simplify[m+2*p+3]] && NeQ[m+1])


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/((m+1)*(c*d^2+a*e^2)) + 
  c/((m+1)*(c*d^2+a*e^2))*
    Int[(d+e*x)^(m+1)*Simp[d*(m+1)-e*(m+2*p+3)*x,x]*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && 
  (RationalQ[m] && m<-1 && IntQuadraticQ[a,0,c,d,e,m,p,x] || 
   SumSimplerQ[m,1] && IntegerQ[p] && NeQ[m+1] || 
   NegativeIntegerQ[Simplify[m+2*p+3]] && NeQ[m+1])


Int[1/((d_.+e_.*x_)*(a_+b_.*x_+c_.*x_^2)^(1/3)),x_Symbol] :=
  With[{q=Rt[3*c*e^2*(2*c*d-b*e),3]},
  -Sqrt[3]*c*e*ArcTan[1/Sqrt[3]+2*(c*d-b*e-c*e*x)/(Sqrt[3]*q*(a+b*x+c*x^2)^(1/3))]/q^2 - 
  3*c*e*Log[d+e*x]/(2*q^2) + 
  3*c*e*Log[c*d-b*e-c*e*x-q*(a+b*x+c*x^2)^(1/3)]/(2*q^2)] /;
FreeQ[{a,b,c,d,e},x] && NeQ[2*c*d-b*e] && EqQ[c^2*d^2-b*c*d*e+b^2*e^2-3*a*c*e^2] && PosQ[c*e^2*(2*c*d-b*e)]


Int[1/((d_+e_.*x_)*(a_+c_.*x_^2)^(1/3)),x_Symbol] :=
  With[{q=Rt[6*c^2*e^2/d^2,3]},
  -Sqrt[3]*c*e*ArcTan[1/Sqrt[3]+2*c*(d-e*x)/(Sqrt[3]*d*q*(a+c*x^2)^(1/3))]/(d^2*q^2) - 
  3*c*e*Log[d+e*x]/(2*d^2*q^2) + 
  3*c*e*Log[c*d-c*e*x-d*q*(a+c*x^2)^(1/3)]/(2*d^2*q^2)] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2-3*a*e^2]


Int[1/((d_.+e_.*x_)*(a_+b_.*x_+c_.*x_^2)^(1/3)),x_Symbol] :=
  With[{q=Rt[-3*c*e^2*(2*c*d-b*e),3]},
  -Sqrt[3]*c*e*ArcTan[1/Sqrt[3]-2*(c*d-b*e-c*e*x)/(Sqrt[3]*q*(a+b*x+c*x^2)^(1/3))]/q^2 - 
  3*c*e*Log[d+e*x]/(2*q^2) + 
  3*c*e*Log[c*d-b*e-c*e*x+q*(a+b*x+c*x^2)^(1/3)]/(2*q^2)] /;
FreeQ[{a,b,c,d,e},x] && NeQ[2*c*d-b*e] && EqQ[c^2*d^2-b*c*d*e+b^2*e^2-3*a*c*e^2] && NegQ[c*e^2*(2*c*d-b*e)]


(* Int[1/((d_+e_.*x_)*(a_+c_.*x_^2)^(1/3)),x_Symbol] :=
  With[{q=Rt[-6*c^2*d*e^2,3]},
  -Sqrt[3]*c*e*ArcTan[1/Sqrt[3]-2*(c*d-c*e*x)/(Sqrt[3]*q*(a+c*x^2)^(1/3))]/q^2 - 
  3*c*e*Log[d+e*x]/(2*q^2) + 
  3*c*e*Log[c*d-c*e*x+q*(a+c*x^2)^(1/3)]/(2*q^2)] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2-3*a*e^2] && NegQ[c^2*d*e^2] *)


Int[1/((d_.+e_.*x_)*(a_+b_.*x_+c_.*x_^2)^(1/3)),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (b+q+2*c*x)^(1/3)*(b-q+2*c*x)^(1/3)/(a+b*x+c*x^2)^(1/3)*Int[1/((d+e*x)*(b+q+2*c*x)^(1/3)*(b-q+2*c*x)^(1/3)),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && EqQ[c^2*d^2-b*c*d*e-2*b^2*e^2+9*a*c*e^2]


Int[1/((d_+e_.*x_)*(a_+c_.*x_^2)^(1/4)),x_Symbol] :=
  d*Int[1/((d^2-e^2*x^2)*(a+c*x^2)^(1/4)),x] - e*Int[x/((d^2-e^2*x^2)*(a+c*x^2)^(1/4)),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[1/((d_+e_.*x_)*(a_+c_.*x_^2)^(3/4)),x_Symbol] :=
  d*Int[1/((d^2-e^2*x^2)*(a+c*x^2)^(3/4)),x] - e*Int[x/((d^2-e^2*x^2)*(a+c*x^2)^(3/4)),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[(a_.+b_.*x_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  1/(-4*c/(b^2-4*a*c))^p*Subst[Int[Simp[1-x^2/(b^2-4*a*c),x]^p/Simp[2*c*d-b*e+e*x,x],x],x,b+2*c*x] /;
FreeQ[{a,b,c,d,e,p},x] && PositiveQ[4*a-b^2/c] && IntegerQ[4*p]


Int[(a_.+b_.*x_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  (a+b*x+c*x^2)^p/(-c*(a+b*x+c*x^2)/(b^2-4*a*c))^p*
    Int[(-a*c/(b^2-4*a*c)-b*c*x/(b^2-4*a*c)-c^2*x^2/(b^2-4*a*c))^p/(d+e*x),x] /;
FreeQ[{a,b,c,d,e,p},x] && Not[PositiveQ[4*a-b^2/c]] && IntegerQ[4*p]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(d+e*x)^m*(Rt[a,2]+Rt[-c,2]*x)^p*(Rt[a,2]-Rt[-c,2]*x)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && PositiveQ[a] && NegativeQ[c]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -(1/(d+e*x))^(2*p)*(a+b*x+c*x^2)^p/(e*(e*(b-q+2*c*x)/(2*c*(d+e*x)))^p*(e*(b+q+2*c*x)/(2*c*(d+e*x)))^p)*
    Subst[Int[x^(-m-2*(p+1))*Simp[1-(d-e*(b-q)/(2*c))*x,x]^p*Simp[1-(d-e*(b+q)/(2*c))*x,x]^p,x],x,1/(d+e*x)]] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && Not[IntegerQ[p]] && 
  NegativeIntegerQ[m]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  -(1/(d+e*x))^(2*p)*(a+c*x^2)^p/(e*(-e*(q-c*x)/(c*(d+e*x)))^p*(e*(q+c*x)/(c*(d+e*x)))^p)*
    Subst[Int[x^(-m-2*(p+1))*Simp[1-(d+e*q/c)*x,x]^p*Simp[1-(d-e*q/c)*x,x]^p,x],x,1/(d+e*x)]] /;
FreeQ[{a,c,d,e,p},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && NegativeIntegerQ[m]


Int[(d_.+e_.*x_)^m_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (a+b*x+c*x^2)^p/(e*(1-(d+e*x)/(d-e*(b-q)/(2*c)))^p*(1-(d+e*x)/(d-e*(b+q)/(2*c)))^p)*
    Subst[Int[x^m*Simp[1-x/(d-e*(b-q)/(2*c)),x]^p*Simp[1-x/(d-e*(b+q)/(2*c)),x]^p,x],x,d+e*x]] /;
FreeQ[{a,b,c,d,e,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2] && NeQ[2*c*d-b*e] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (a+c*x^2)^p/(e*(1-(d+e*x)/(d+e*q/c))^p*(1-(d+e*x)/(d-e*q/c))^p)*
    Subst[Int[x^m*Simp[1-x/(d+e*q/c),x]^p*Simp[1-x/(d-e*q/c),x]^p,x],x,d+e*x]] /;
FreeQ[{a,c,d,e,m,p},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[(d_.+e_.*u_)^m_.*(a_+b_.*u_+c_.*u_^2)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x)^m*(a+b*x+c*x^2)^p,x],x,u] /;
FreeQ[{a,b,c,d,e,m,p},x] && LinearQ[u,x] && NeQ[u-x]


Int[(d_.+e_.*u_)^m_.*(a_+c_.*u_^2)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x)^m*(a+c*x^2)^p,x],x,u] /;
FreeQ[{a,c,d,e,m,p},x] && LinearQ[u,x] && NeQ[u-x]


(* IntQuadraticQ[a,b,c,d,e,m,p,x] returns True iff (d+e*x)^m*(a+b*x+c*x^2)^p is integrable wrt x in terms of non-Appell functions. *)
IntQuadraticQ[a_,b_,c_,d_,e_,m_,p_,x_] :=
  IntegerQ[p] || PositiveIntegerQ[m] || IntegersQ[2*m,2*p] || IntegersQ[m,4*p] || 
  IntegersQ[m,p+1/3] && (EqQ[c^2*d^2-b*c*d*e+b^2*e^2-3*a*c*e^2] || EqQ[c^2*d^2-b*c*d*e-2*b^2*e^2+9*a*c*e^2])


(* ::Subsection::Closed:: *)
(*1.2.1.3 (d+e x)^m (f+g x) (a+b x+c x^2)^p*)


Int[x_^n_.*(f_+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  f*Int[x^n*(a+c*x^2)^p,x] + g*Int[x^(n+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,f,g,p},x] && IntegerQ[n] && Not[IntegerQ[2*p]]


Int[(d_.+e_.*x_)^m_.*(f_+g_.*x_)*(a_+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -f*g*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(b*(p+1)*(e*f-d*g)) /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[b^2-4*a*c,0] && EqQ[m+2*p+3,0] && EqQ[2*c*f-b*g,0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (2*c*f-b*g)/(2*c*d-b*e)*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] - 
  (e*f-d*g)/(2*c*d-b*e)*Int[(d+e*x)^m*(b+2*c*x)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[b^2-4*a*c,0] && EqQ[m+2*p+3,0] && NeQ[2*c*f-b*g,0] && NeQ[2*c*d-b*e,0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(2*c*(p+1)) - 
  e*g*m/(2*c*(p+1))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && EqQ[2*c*f-b*g,0] && LtQ[p,-1] && GtQ[m,0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/(c^IntPart[p]*(b/2+c*x)^(2*FracPart[p]))*Int[(d+e*x)^m*(f+g*x)*(b/2+c*x)^(2*p),x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && EqQ[b^2-4*a*c,0]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(f+g*x)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && IntegerQ[p]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(f+g*x)*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,f,g,m},x] && EqQ[c*d^2+a*e^2,0] && 
  (IntegerQ[p] || PositiveQ[a] && PositiveQ[d] && EqQ[m+p,0])


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_.*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(f+g*x)^n*(a+b*x+c*x^2)^(m+p),x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[c*d^2-b*d*e+a*e^2,0] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_.*(a_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(f+g*x)^n*(a+c*x^2)^(m+p),x] /;
FreeQ[{a,c,d,e,f,g,n,p},x] && EqQ[c*d^2+a*e^2,0] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+2)) /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && 
  EqQ[m*(g*(c*d-b*e)+c*e*f)+e*(p+1)*(2*c*f-b*g),0]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(a+c*x^2)^(p+1)/(c*(m+2*p+2)) /;
FreeQ[{a,c,d,e,f,g,m,p},x] && EqQ[c*d^2+a*e^2,0] && EqQ[m*(d*g+e*f)+2*e*f*(p+1),0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (g*(c*d-b*e)+c*e*f)*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(c*(p+1)*(2*c*d-b*e)) - 
  e*(m*(g*(c*d-b*e)+c*e*f)+e*(p+1)*(2*c*f-b*g))/(c*(p+1)*(2*c*d-b*e))*
    Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m,p] && p<-1 && m>0


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d*g+e*f)*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(p+1)) - 
  e*(m*(d*g+e*f)+2*e*f*(p+1))/(2*c*d*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,f,g},x] && EqQ[c*d^2+a*e^2,0] && RationalQ[m,p] && p<-1 && m>0


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (g*(c*d-b*e)+c*e*f)*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(c*(p+1)*(2*c*d-b*e)) - 
  e*(m*(g*(c*d-b*e)+c*e*f)+e*(p+1)*(2*c*f-b*g))/(c*(p+1)*(2*c*d-b*e))*
    Int[(d+e*x)^Simplify[m-1]*(a+b*x+c*x^2)^Simplify[p+1],x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && 
  SumSimplerQ[p,1] && SumSimplerQ[m,-1] && NeQ[p+1]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d*g+e*f)*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(p+1)) - 
  e*(m*(d*g+e*f)+2*e*f*(p+1))/(2*c*d*(p+1))*Int[(d+e*x)^Simplify[m-1]*(a+c*x^2)^Simplify[p+1],x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && EqQ[c*d^2+a*e^2,0] && SumSimplerQ[p,1] && SumSimplerQ[m,-1] && NeQ[p+1]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d*g-e*f)*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/((2*c*d-b*e)*(m+p+1)) + 
  (m*(g*(c*d-b*e)+c*e*f)+e*(p+1)*(2*c*f-b*g))/(e*(2*c*d-b*e)*(m+p+1))*
    Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && 
  (RationalQ[m] && m<-1 && Not[PositiveIntegerQ[m+p+1]] || RationalQ[m,p] && m<0 && p<-1 || EqQ[m+2*p+2]) && NeQ[m+p+1]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d*g-e*f)*(d+e*x)^m*(a+c*x^2)^(p+1)/(2*c*d*(m+p+1)) + 
  (m*(g*c*d+c*e*f)+2*e*c*f*(p+1))/(e*(2*c*d)*(m+p+1))*
    Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && EqQ[c*d^2+a*e^2,0] && 
  (RationalQ[m] && m<-1 && Not[PositiveIntegerQ[m+p+1]] || RationalQ[m,p] && m<0 && p<-1 || EqQ[m+2*p+2]) && NeQ[m+p+1]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+2)) + 
  (m*(g*(c*d-b*e)+c*e*f)+e*(p+1)*(2*c*f-b*g))/(c*e*(m+2*p+2))*Int[(d+e*x)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && NeQ[m+2*p+2]


Int[(d_+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(a+c*x^2)^(p+1)/(c*(m+2*p+2)) + 
  (m*(d*g+e*f)+2*e*f*(p+1))/(e*(m+2*p+2))*Int[(d+e*x)^m*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && EqQ[c*d^2+a*e^2,0] && NeQ[m+2*p+2]


Int[x_^2*(f_+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  x^2*(a*g-c*f*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) - 
  1/(2*a*c*(p+1))*Int[x*Simp[2*a*g-c*f*(2*p+5)*x,x]*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,f,g},x] && EqQ[a*g^2+f^2*c] && RationalQ[p] && p<-2


Int[x_^2*(f_+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  1/c*Int[(f+g*x)*(a+c*x^2)^(p+1),x] - f^2/c*Int[(a+c*x^2)^(p+1)/(f-g*x),x] /;
FreeQ[{a,c,f,g,p},x] && EqQ[a*g^2+f^2*c]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && IGtQ[p,0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,f,g,m},x] && NeQ[c*d^2+a*e^2,0] && IGtQ[p,0]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)/(a+b*x+c*x^2),x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && IntegerQ[m]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)/(a+c*x^2),x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && IntegerQ[m]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -(e*f-d*g)*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(2*(p+1)*(c*d^2-b*d*e+a*e^2)) /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  EqQ[Simplify[m+2*p+3]] && EqQ[b*(e*f+d*g)-2*(c*d*f+a*e*g)]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  -(e*f-d*g)*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/(2*(p+1)*(c*d^2+a*e^2)) /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[c*d^2+a*e^2,0] && EqQ[Simplify[m+2*p+3]] && EqQ[c*d*f+a*e*g]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(a+b*x+c*x^2)^(p+1)*(b*f-2*a*g+(2*c*f-b*g)*x)/((p+1)*(b^2-4*a*c)) - 
  m*(b*(e*f+d*g)-2*(c*d*f+a*e*g))/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  EqQ[Simplify[m+2*p+3]] && RationalQ[p] && p<-1 && Not[m==1 && (EqQ[d] || EqQ[2*c*d-b*e])]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(a+c*x^2)^(p+1)*(a*g-c*f*x)/(2*a*c*(p+1)) - 
  m*(c*d*f+a*e*g)/(2*a*c*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && 
  EqQ[Simplify[m+2*p+3]] && RationalQ[p] && p<-1 && Not[m==1 && EqQ[d]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -(e*f-d*g)*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(2*(p+1)*(c*d^2-b*d*e+a*e^2)) - 
  (b*(e*f+d*g)-2*(c*d*f+a*e*g))/(2*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  EqQ[Simplify[m+2*p+3]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  -(e*f-d*g)*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/(2*(p+1)*(c*d^2+a*e^2)) + 
  (c*d*f+a*e*g)/(c*d^2+a*e^2)*Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[c*d^2+a*e^2,0] && EqQ[Simplify[m+2*p+3]]


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(b*e*g*(p+2)-c*(e*f+d*g)*(2*p+3)-2*c*e*g*(p+1)*x)*(a+b*x+c*x^2)^(p+1)/(2*c^2*(p+1)*(2*p+3)) /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  EqQ[b^2*e*g*(p+2)-2*a*c*e*g+c*(2*c*d*f-b*(e*f+d*g))*(2*p+3)]


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  ((e*f+d*g)*(2*p+3)+2*e*g*(p+1)*x)*(a+c*x^2)^(p+1)/(2*c*(p+1)*(2*p+3)) /;
FreeQ[{a,c,d,e,f,g,p},x] && NeQ[c*d^2+a*e^2,0] && EqQ[a*e*g-c*d*f*(2*p+3)]


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(2*a*c*(e*f+d*g)-b*(c*d*f+a*e*g)-(b^2*e*g-b*c*(e*f+d*g)+2*c*(c*d*f-a*e*g))*x)*(a+b*x+c*x^2)^(p+1)/(c*(p+1)*(b^2-4*a*c)) - 
  (b^2*e*g*(p+2)-2*a*c*e*g+c*(2*c*d*f-b*(e*f+d*g))*(2*p+3))/(c*(p+1)*(b^2-4*a*c))*Int[(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[p] && p<-1


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(c*d*f*x-a*(d*g+e*(f+g*x)))*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) - 
  (a*e*g-c*d*f*(2*p+3))/(2*a*c*(p+1))*Int[(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && RationalQ[p] && p<-1


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(b*e*g*(p+2)-c*(e*f+d*g)*(2*p+3)-2*c*e*g*(p+1)*x)*(a+b*x+c*x^2)^(p+1)/(2*c^2*(p+1)*(2*p+3)) + 
  (b^2*e*g*(p+2)-2*a*c*e*g+c*(2*c*d*f-b*(e*f+d*g))*(2*p+3))/(2*c^2*(2*p+3))*Int[(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && Not[RationalQ[p] && p<=-1]


Int[(d_.+e_.*x_)*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  ((e*f+d*g)*(2*p+3)+2*e*g*(p+1)*x)*(a+c*x^2)^(p+1)/(2*c*(p+1)*(2*p+3)) - 
  (a*e*g-c*d*f*(2*p+3))/(c*(2*p+3))*Int[(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,p},x] && NeQ[c*d^2+a*e^2,0] && Not[RationalQ[p] && p<=-1]


Int[(e_.*x_)^m_*(f_+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  f*Int[(e*x)^m*(a+c*x^2)^p,x] + g/e*Int[(e*x)^(m+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,e,f,g,p},x] && Not[RationalQ[m]] && Not[PositiveIntegerQ[p]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^FracPart[p]*(a+b*x+c*x^2)^FracPart[p]/(a*d+c*e*x^3)^FracPart[p]*Int[(f+g*x)*(a*d+c*e*x^3)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[m-p] && EqQ[b*d+a*e] && EqQ[c*d+b*e]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -(d+e*x)^(m+1)*(a+b*x+c*x^2)^p/(e^2*(m+1)*(m+2)*(c*d^2-b*d*e+a*e^2))*
    ((d*g-e*f*(m+2))*(c*d^2-b*d*e+a*e^2)-d*p*(2*c*d-b*e)*(e*f-d*g)-e*(g*(m+1)*(c*d^2-b*d*e+a*e^2)+p*(2*c*d-b*e)*(e*f-d*g))*x) - 
  p/(e^2*(m+1)*(m+2)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+2)*(a+b*x+c*x^2)^(p-1)*
    Simp[2*a*c*e*(e*f-d*g)*(m+2)+b^2*e*(d*g*(p+1)-e*f*(m+p+2))+b*(a*e^2*g*(m+1)-c*d*(d*g*(2*p+1)-e*f*(m+2*p+2)))-
      c*(2*c*d*(d*g*(2*p+1)-e*f*(m+2*p+2))-e*(2*a*e*g*(m+1)-b*(d*g*(m-2*p)+e*f*(m+2*p+2))))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  RationalQ[m,p] && p>0 && m<-2 && m+2*p<0 && Not[NegativeIntegerQ[m+2*p+3]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  -(d+e*x)^(m+1)*(a+c*x^2)^p/(e^2*(m+1)*(m+2)*(c*d^2+a*e^2))*
    ((d*g-e*f*(m+2))*(c*d^2+a*e^2)-2*c*d^2*p*(e*f-d*g)-e*(g*(m+1)*(c*d^2+a*e^2)+2*c*d*p*(e*f-d*g))*x) - 
  p/(e^2*(m+1)*(m+2)*(c*d^2+a*e^2))*Int[(d+e*x)^(m+2)*(a+c*x^2)^(p-1)*
    Simp[2*a*c*e*(e*f-d*g)*(m+2)-c*(2*c*d*(d*g*(2*p+1)-e*f*(m+2*p+2))-2*a*e^2*g*(m+1))*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && 
  RationalQ[m,p] && p>0 && m<-2 && m+2*p<0 && Not[NegativeIntegerQ[m+2*p+3]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(e*f*(m+2*p+2)-d*g*(2*p+1)+e*g*(m+1)*x)*(a+b*x+c*x^2)^p/(e^2*(m+1)*(m+2*p+2)) + 
  p/(e^2*(m+1)*(m+2*p+2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p-1)*
    Simp[g*(b*d+2*a*e+2*a*e*m+2*b*d*p)-f*b*e*(m+2*p+2)+(g*(2*c*d+b*e+b*e*m+4*c*d*p)-2*c*e*f*(m+2*p+2))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[p] && p>0 && 
  (RationalQ[m] && m<-1 || p==1 || IntegerQ[p] && Not[RationalQ[m]]) && NeQ[m+1] && Not[NegativeIntegerQ[m+2*p+1]] && 
  (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(e*f*(m+2*p+2)-d*g*(2*p+1)+e*g*(m+1)*x)*(a+c*x^2)^p/(e^2*(m+1)*(m+2*p+2)) + 
  p/(e^2*(m+1)*(m+2*p+2))*Int[(d+e*x)^(m+1)*(a+c*x^2)^(p-1)*
    Simp[g*(2*a*e+2*a*e*m)+(g*(2*c*d+4*c*d*p)-2*c*e*f*(m+2*p+2))*x,x],x] /;
FreeQ[{a,c,d,e,f,g,m},x] && NeQ[c*d^2+a*e^2,0] && RationalQ[p] && p>0 && 
  (RationalQ[m] && m<-1 || p==1 || IntegerQ[p] && Not[RationalQ[m]]) && NeQ[m+1] && Not[NegativeIntegerQ[m+2*p+1]] && 
  (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(c*e*f*(m+2*p+2)-g*(c*d+2*c*d*p-b*e*p)+g*c*e*(m+2*p+1)*x)*(a+b*x+c*x^2)^p/
    (c*e^2*(m+2*p+1)*(m+2*p+2)) - 
  p/(c*e^2*(m+2*p+1)*(m+2*p+2))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p-1)*
    Simp[c*e*f*(b*d-2*a*e)*(m+2*p+2)+g*(a*e*(b*e-2*c*d*m+b*e*m)+b*d*(b*e*p-c*d-2*c*d*p))+
      (c*e*f*(2*c*d-b*e)*(m+2*p+2)+g*(b^2*e^2*(p+m+1)-2*c^2*d^2*(1+2*p)-c*e*(b*d*(m-2*p)+2*a*e*(m+2*p+1))))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  RationalQ[p] && p>0 && (IntegerQ[p] || Not[RationalQ[m]] || -1<=m<0) && Not[NegativeIntegerQ[m+2*p]] && 
  (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m+1)*(c*e*f*(m+2*p+2)-g*c*d*(2*p+1)+g*c*e*(m+2*p+1)*x)*(a+c*x^2)^p/
    (c*e^2*(m+2*p+1)*(m+2*p+2)) + 
  2*p/(c*e^2*(m+2*p+1)*(m+2*p+2))*Int[(d+e*x)^m*(a+c*x^2)^(p-1)*
    Simp[f*a*c*e^2*(m+2*p+2)+a*c*d*e*g*m-(c^2*f*d*e*(m+2*p+2)-g*(c^2*d^2*(2*p+1)+a*c*e^2*(m+2*p+1)))*x,x],x] /;
FreeQ[{a,c,d,e,f,g,m},x] && NeQ[c*d^2+a*e^2,0] && 
  RationalQ[p] && p>0 && (IntegerQ[p] || Not[RationalQ[m]] || -1<=m<0) && Not[NegativeIntegerQ[m+2*p]] && 
  (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_+e_.*x_)^m_.*(f_+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(a+b*x+c*x^2)^p*ExpandIntegrand[(d+e*x)^m*(f+g*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && ILtQ[p,-1] && IGtQ[m,0] && RationalQ[a,b,c,d,e,f,g]


Int[(d_+e_.*x_)^m_.*(f_+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(a+c*x^2)^p*ExpandIntegrand[(d+e*x)^m*(f+g*x),x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && ILtQ[p,-1] && IGtQ[m,0] && RationalQ[a,c,d,e,f,g]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  -(d+e*x)^(m-1)*(2*a*c*(e*f+d*g)-b*(c*d*f+a*e*g)-(2*c^2*d*f+b^2*e*g-c*(b*e*f+b*d*g+2*a*e*g))*x)*
    (a+b*x+c*x^2)^(p+1)/(c*(p+1)*(b^2-4*a*c)) - 
  1/(c*(p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-2)*(a+b*x+c*x^2)^(p+1)*
    Simp[2*c^2*d^2*f*(2*p+3)+b*e*g*(a*e*(m-1)+b*d*(p+2))-c*(2*a*e*(e*f*(m-1)+d*g*m)+b*d*(d*g*(2*p+3)-e*f*(m-2*p-4))) + 
      e*(b^2*e*g*(m+p+1)+2*c^2*d*f*(m+2*p+2)-c*(2*a*e*g*m+b*(e*f+d*g)*(m+2*p+2)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[p,-1] && GtQ[m,1] && 
  (EqQ[m,2] && EqQ[p,-3] && RationalQ[a,b,c,d,e,f,g] || Not[ILtQ[m+2*p+3,0]])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^(m-1)*(2*a*(e*f+d*g)-(2*c*d*f-2*a*e*g)*x)*(a+c*x^2)^(p+1)/(4*a*c*(p+1)) - 
  1/(4*a*c*(p+1))*Int[(d+e*x)^(m-2)*(a+c*x^2)^(p+1)*
    Simp[2*a*e*(e*f*(m-1)+d*g*m)-2*c*d^2*f*(2*p+3)+e*(2*a*e*g*m-2*c*d*f*(m+2*p+2))*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && LtQ[p,-1] && GtQ[m,1] && 
  (EqQ[m,2] && EqQ[p,-3] && RationalQ[a,c,d,e,f,g] || Not[ILtQ[m+2*p+3,0]])


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(a+b*x+c*x^2)^(p+1)*(f*b-2*a*g+(2*c*f-b*g)*x)/((p+1)*(b^2-4*a*c)) + 
  1/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)*
    Simp[g*(2*a*e*m+b*d*(2*p+3))-f*(b*e*m+2*c*d*(2*p+3))-e*(2*c*f-b*g)*(m+2*p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  RationalQ[m,p] && p<-1 && m>0 && Not[m==1 && SimplerQ[d+e*x,f+g*x]] && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(a+c*x^2)^(p+1)*(a*g-c*f*x)/(2*a*c*(p+1)) - 
  1/(2*a*c*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1)*Simp[a*e*g*m-c*d*f*(2*p+3)-c*e*f*(m+2*p+3)*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && 
  RationalQ[m,p] && p<-1 && m>0 && Not[m==1 && SimplerQ[d+e*x,f+g*x]] && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^(m+1)*(f*(b*c*d-b^2*e+2*a*c*e)-a*g*(2*c*d-b*e)+c*(f*(2*c*d-b*e)-g*(b*d-2*a*e))*x)*(a+b*x+c*x^2)^(p+1)/
    ((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2)) + 
  1/((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p+1)*
    Simp[f*(b*c*d*e*(2*p-m+2)+b^2*e^2*(p+m+2)-2*c^2*d^2*(2*p+3)-2*a*c*e^2*(m+2*p+3))-
      g*(a*e*(b*e-2*c*d*m+b*e*m)-b*d*(3*c*d-b*e+2*c*d*p-b*e*p))+
      c*e*(g*(b*d-2*a*e)-f*(2*c*d-b*e))*(m+2*p+4)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  RationalQ[p] && p<-1 && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^(m+1)*(f*a*c*e-a*g*c*d+c*(c*d*f+a*e*g)*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)*(c*d^2+a*e^2)) + 
  1/(2*a*c*(p+1)*(c*d^2+a*e^2))*Int[(d+e*x)^m*(a+c*x^2)^(p+1)*
    Simp[f*(c^2*d^2*(2*p+3)+a*c*e^2*(m+2*p+3))-a*c*d*e*g*m+c*e*(c*d*f+a*e*g)*(m+2*p+4)*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && 
  RationalQ[p] && p<-1 && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  g*(d+e*x)^m/(c*m) + 
  1/c*Int[(d+e*x)^(m-1)*Simp[c*d*f-a*e*g+(g*c*d-b*e*g+c*e*f)*x,x]/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && FractionQ[m] && m>0


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  g*(d+e*x)^m/(c*m) + 
  1/c*Int[(d+e*x)^(m-1)*Simp[c*d*f-a*e*g+(g*c*d+c*e*f)*x,x]/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && FractionQ[m] && m>0


Int[(f_.+g_.*x_)/(Sqrt[d_.+e_.*x_]*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  2*Subst[Int[(e*f-d*g+g*x^2)/(c*d^2-b*d*e+a*e^2-(2*c*d-b*e)*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0]


Int[(f_.+g_.*x_)/(Sqrt[d_.+e_.*x_]*(a_+c_.*x_^2)),x_Symbol] :=
  2*Subst[Int[(e*f-d*g+g*x^2)/(c*d^2+a*e^2-2*c*d*x^2+c*x^4),x],x,Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x)^(m+1)*Simp[c*d*f-f*b*e+a*e*g-c*(e*f-d*g)*x,x]/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && FractionQ[m] && m<-1


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)/((m+1)*(c*d^2+a*e^2)) + 
  1/(c*d^2+a*e^2)*Int[(d+e*x)^(m+1)*Simp[c*d*f+a*e*g-c*(e*f-d*g)*x,x]/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,f,g,m},x] && NeQ[c*d^2+a*e^2,0] && FractionQ[m] && m<-1


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m,(f+g*x)/(a+b*x+c*x^2),x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && Not[RationalQ[m]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)/(a_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m,(f+g*x)/(a+c*x^2),x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2,0] && Not[RationalQ[m]]


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  g*(d+e*x)^m*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+2)) + 
  1/(c*(m+2*p+2))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^p*
    Simp[m*(c*d*f-a*e*g)+d*(2*c*f-b*g)*(p+1)+(m*(c*e*f+c*d*g-b*e*g)+e*(p+1)*(2*c*f-b*g))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && RationalQ[m] && m>0 && 
  NeQ[m+2*p+2] && Not[m==1 && SimplerQ[f+g*x,d+e*x]] && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  g*(d+e*x)^m*(a+c*x^2)^(p+1)/(c*(m+2*p+2)) + 
  1/(c*(m+2*p+2))*Int[(d+e*x)^(m-1)*(a+c*x^2)^p*
    Simp[c*d*f*(m+2*p+2)-a*e*g*m+c*(e*f*(m+2*p+2)+d*g*m)*x,x],x] /;
FreeQ[{a,c,d,e,f,g,p},x] && NeQ[c*d^2+a*e^2,0] && RationalQ[m] && m>0 && 
  NeQ[m+2*p+2] && Not[m==1 && SimplerQ[f+g*x,d+e*x]] && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/((m+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p*
    Simp[(c*d*f-f*b*e+a*e*g)*(m+1)+b*(d*g-e*f)*(p+1)-c*(e*f-d*g)*(m+2*p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  RationalQ[m] && m<-1 && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/((m+1)*(c*d^2+a*e^2)) + 
  1/((m+1)*(c*d^2+a*e^2))*Int[(d+e*x)^(m+1)*(a+c*x^2)^p*Simp[(c*d*f+a*e*g)*(m+1)-c*(e*f-d*g)*(m+2*p+3)*x,x],x] /;
FreeQ[{a,c,d,e,f,g,p},x] && NeQ[c*d^2+a*e^2,0] && 
  RationalQ[m] && m<-1 && (IntegerQ[m] || IntegerQ[p] || IntegersQ[2*m,2*p])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/((m+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p*
    Simp[(c*d*f-f*b*e+a*e*g)*(m+1)+b*(d*g-e*f)*(p+1)-c*(e*f-d*g)*(m+2*p+3)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && 
  NegativeIntegerQ[Simplify[m+2*p+3]] && NeQ[m+1]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  (e*f-d*g)*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/((m+1)*(c*d^2+a*e^2)) + 
  1/((m+1)*(c*d^2+a*e^2))*Int[(d+e*x)^(m+1)*(a+c*x^2)^p*Simp[(c*d*f+a*e*g)*(m+1)-c*(e*f-d*g)*(m+2*p+3)*x,x],x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[c*d^2+a*e^2,0] && NegativeIntegerQ[m+2*p+3] && NeQ[m+1]


Int[(f_+g_.*x_)/((d_.+e_.*x_)*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  4*f*(a-d)/(b*d-a*e)*Subst[Int[1/(4*(a-d)-x^2),x],x,(2*(a-d)+(b-e)*x)/Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e,f,g},x] && EqQ[4*c*(a-d)-(b-e)^2] && EqQ[e*f*(b-e)-2*g*(b*d-a*e)] && NeQ[b*d-a*e]


Int[(f_+g_.*x_)/(Sqrt[x_]*Sqrt[a_+b_.*x_+c_.*x_^2]),x_Symbol] :=
  2*Subst[Int[(f+g*x^2)/Sqrt[a+b*x^2+c*x^4],x],x,Sqrt[x]] /;
FreeQ[{a,b,c,f,g},x] && NeQ[b^2-4*a*c,0]


Int[(f_+g_.*x_)/(Sqrt[x_]*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  2*Subst[Int[(f+g*x^2)/Sqrt[a+c*x^4],x],x,Sqrt[x]] /;
FreeQ[{a,c,f,g},x]


Int[(f_+g_.*x_)/(Sqrt[e_*x_]*Sqrt[a_+b_.*x_+c_.*x_^2]),x_Symbol] :=
  Sqrt[x]/Sqrt[e*x]*Int[(f+g*x)/(Sqrt[x]*Sqrt[a+b*x+c*x^2]),x] /;
FreeQ[{a,b,c,e,f,g},x] && NeQ[b^2-4*a*c,0]


Int[(f_+g_.*x_)/(Sqrt[e_*x_]*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  Sqrt[x]/Sqrt[e*x]*Int[(f+g*x)/(Sqrt[x]*Sqrt[a+c*x^2]),x] /;
FreeQ[{a,c,e,f,g},x]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  g/e*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p,x] + (e*f-d*g)/e*Int[(d+e*x)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  g/e*Int[(d+e*x)^(m+1)*(a+c*x^2)^p,x] + (e*f-d*g)/e*Int[(d+e*x)^m*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[c*d^2+a*e^2,0]





(* ::Subsection::Closed:: *)
(*1.2.1.4 (d+e x)^m (f+g x)^n (a+b x+c x^2)^p*)


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/(c^IntPart[p]*(b/2+c*x)^(2*FracPart[p]))*Int[(d+e*x)^m*(f+g*x)^n*(b/2+c*x)^(2*p),x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(f+g*x)^n*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(f+g*x)^n*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  (IntegerQ[p] || PositiveQ[a] && PositiveQ[d] && EqQ[m+p])


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(f+g*x)^n*(a+b*x+c*x^2)^(m+p),x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[c*d^2-b*d*e+a*e^2] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  d^m*e^m*Int[(a*e+c*d*x)^(-m)*(f+g*x)^n*(a+c*x^2)^(m+p),x] /;
FreeQ[{a,c,d,e,f,g,n,p},x] && EqQ[c*d^2+a*e^2] && NegativeIntegerQ[m] && Not[IntegerQ[2*p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(f+g*x)^n*(a+b*x+c*x^2)^(m+p)/(a/d+c*x/e)^m,x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]] && 
  IntegersQ[m,n] && RationalQ[p] && (0<-m<p+1 || p<-m<0)


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  d^(2*m)/a^m*Int[(f+g*x)^n*(a+c*x^2)^(m+p)/(d-e*x)^m,x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && 
  IntegersQ[m,n] && RationalQ[p] && (0<-m<p+1 || p<-m<0)


Int[(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  -(f+g*x)^n*(a+b*x+c*x^2)^p*(a*(2*c*d-b*e)+c*(b*d-2*a*e)*x)/(d*e*p*(b^2-4*a*c)) - 
  1/(d*e*p*(b^2-4*a*c))*Int[(f+g*x)^(n-1)*(a+b*x+c*x^2)^p*
    Simp[b*(a*e*g*n-c*d*f*(2*p+1))-2*a*c*(d*g*n-e*f*(2*p+1))-c*g*(b*d-2*a*e)*(n+2*p+1)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]] && 
  PositiveIntegerQ[n] && NegativeIntegerQ[n+2*p]


Int[(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  (f+g*x)^n*(a+c*x^2)^p*(d-e*x)/(2*d*e*p) - 
  1/(2*d*e*p)*Int[(f+g*x)^(n-1)*(a+c*x^2)^p*Simp[d*g*n-e*f*(2*p+1)-e*g*(n+2*p+1)*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && 
  PositiveIntegerQ[n] && NegativeIntegerQ[n+2*p]


Int[(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  -(f+g*x)^(n+1)*(a+b*x+c*x^2)^p*(a*c*d*(2*c*f-b*g)-a*e*(b*c*f-b^2*g+2*a*c*g)+c*(c*d*(b*f-2*a*g)-a*e*(2*c*f-b*g))*x)/
    (d*e*p*(b^2-4*a*c)*(c*f^2-b*f*g+a*g^2)) - 
  (1/(d*e*p*(b^2-4*a*c)*(c*f^2-b*f*g+a*g^2)))*Int[(f+g*x)^n*(a+b*x+c*x^2)^p*
    Simp[b^2*g*(c*d*f*p-a*e*g*(n+p+1))+b*c*(a*g*(d*g*(n+1)+e*f*(n-2*p))-c*d*f^2*(2*p+1))+
      2*a*c*(a*e*g^2*(n+2*p+1)+c*f*(e*f-d*g*n+2*e*f*p))+
      c*g*(2*a*c*(e*f+d*g)-b*(c*d*f+a*e*g))*(n+2*p+2)*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]] && 
  NegativeIntegerQ[n] && NegativeIntegerQ[n+2*p]


Int[(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  (f+g*x)^(n+1)*(a+c*x^2)^p*(c*d*f-a*e*g-c*(e*f+d*g)*x)/(2*d*e*p*(c*f^2+a*g^2)) + 
  (1/(2*d*e*p*(c*f^2+a*g^2)))*Int[(f+g*x)^n*(a+c*x^2)^p*
    Simp[(a*e*g^2*(n+2*p+1)-c*f*(d*g*n-e*(f+2*f*p)))+c*g*(e*f+d*g)*(n+2*p+2)*x,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && 
  NegativeIntegerQ[n] && NegativeIntegerQ[n+2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^(m-1)*(f+g*x)^n*(a+b*x+c*x^2)^(p+1)/(c*(m-n-1)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && EqQ[c*e*f+c*d*g-b*e*g] && NeQ[m-n-1]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^(m-1)*(f+g*x)^n*(a+c*x^2)^(p+1)/(c*(m-n-1)) /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && EqQ[e*f+d*g] && NeQ[m-n-1]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/((n+1)*(c*e*f+c*d*g-b*e*g)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && EqQ[m-n-2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/(c*(n+1)*(e*f+d*g)) /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && EqQ[m-n-2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(f+g*x)^(n+1)*(a+b*x+c*x^2)^p/(g*(n+1)) + 
  c*m/(e*g*(n+1))*Int[(d+e*x)^(m+1)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p>0 && n<-1 && Not[IntegerQ[n+p] && n+p+2<=0]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^m*(f+g*x)^(n+1)*(a+c*x^2)^p/(g*(n+1)) + 
  c*m/(e*g*(n+1))*Int[(d+e*x)^(m+1)*(f+g*x)^(n+1)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p>0 && n<-1 && Not[IntegerQ[n+p] && n+p+2<=0]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^m*(f+g*x)^(n+1)*(a+b*x+c*x^2)^p/(g*(m-n-1)) - 
  m*(c*e*f+c*d*g-b*e*g)/(e^2*g*(m-n-1))*Int[(d+e*x)^(m+1)*(f+g*x)^n*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,f,g,n},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p>0 && NeQ[m-n-1] && Not[PositiveIntegerQ[n]] && 
  Not[IntegerQ[n+p] && n+p+2<0]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -(d+e*x)^m*(f+g*x)^(n+1)*(a+c*x^2)^p/(g*(m-n-1)) - 
  c*m*(e*f+d*g)/(e^2*g*(m-n-1))*Int[(d+e*x)^(m+1)*(f+g*x)^n*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e,f,g,n},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p>0 && NeQ[m-n-1] && Not[PositiveIntegerQ[n]] && 
  Not[IntegerQ[n+p] && n+p+2<0]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(f+g*x)^n*(a+b*x+c*x^2)^(p+1)/(c*(p+1)) - 
  e*g*n/(c*(p+1))*Int[(d+e*x)^(m-1)*(f+g*x)^(n-1)*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p<-1 && n>0


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e*(d+e*x)^(m-1)*(f+g*x)^n*(a+c*x^2)^(p+1)/(c*(p+1)) - 
  e*g*n/(c*(p+1))*Int[(d+e*x)^(m-1)*(f+g*x)^(n-1)*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p<-1 && n>0


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/((p+1)*(c*e*f+c*d*g-b*e*g)) + 
  e^2*g*(m-n-2)/((p+1)*(c*e*f+c*d*g-b*e*g))*Int[(d+e*x)^(m-1)*(f+g*x)^n*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,f,g,n},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p<-1


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/(c*(p+1)*(e*f+d*g)) + 
  e^2*g*(m-n-2)/(c*(p+1)*(e*f+d*g))*Int[(d+e*x)^(m-1)*(f+g*x)^n*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,f,g,n},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n,p] && p<-1


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^(m-1)*(f+g*x)^n*(a+b*x+c*x^2)^(p+1)/(c*(m-n-1)) - 
  n*(c*e*f+c*d*g-b*e*g)/(c*e*(m-n-1))*Int[(d+e*x)^m*(f+g*x)^(n-1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n] && n>0 && NeQ[m-n-1] && (IntegerQ[2*p] || IntegerQ[n])


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e*(d+e*x)^(m-1)*(f+g*x)^n*(a+c*x^2)^(p+1)/(c*(m-n-1)) - 
  n*(e*f+d*g)/(e*(m-n-1))*Int[(d+e*x)^m*(f+g*x)^(n-1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n] && n>0 && NeQ[m-n-1] && (IntegerQ[2*p] || IntegerQ[n])


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  -e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/((n+1)*(c*e*f+c*d*g-b*e*g)) - 
  c*e*(m-n-2)/((n+1)*(c*e*f+c*d*g-b*e*g))*Int[(d+e*x)^m*(f+g*x)^(n+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n] && n<-1 && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  -e^2*(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/((n+1)*(c*e*f+c*d*g)) - 
  e*(m-n-2)/((n+1)*(e*f+d*g))*Int[(d+e*x)^m*(f+g*x)^(n+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p] && RationalQ[n] && n<-1 && IntegerQ[2*p]


Int[Sqrt[d_+e_.*x_]/((f_.+g_.*x_)*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  2*e^2*Subst[Int[1/(c*(e*f+d*g)-b*e*g+e^2*g*x^2),x],x,Sqrt[a+b*x+c*x^2]/Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2]


Int[Sqrt[d_+e_.*x_]/((f_.+g_.*x_)*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  2*e^2*Subst[Int[1/(c*(e*f+d*g)+e^2*g*x^2),x],x,Sqrt[a+c*x^2]/Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/(c*g*(n+p+2)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && EqQ[b*e*g*(n+1)+c*e*f*(p+1)-c*d*g*(2*n+p+3)] && NeQ[n+p+2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/(c*g*(n+p+2)) /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && EqQ[e*f*(p+1)-d*g*(2*n+p+3)] && NeQ[n+p+2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(e*f-d*g)*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/(g*(n+1)*(c*e*f+c*d*g-b*e*g)) - 
  e*(b*e*g*(n+1)+c*e*f*(p+1)-c*d*g*(2*n+p+3))/(g*(n+1)*(c*e*f+c*d*g-b*e*g))*
    Int[(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && RationalQ[n] && n<-1 && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(e*f-d*g)*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/(c*g*(n+1)*(e*f+d*g)) - 
  e*(e*f*(p+1)-d*g*(2*n+p+3))/(g*(n+1)*(e*f+d*g))*Int[(d+e*x)^(m-1)*(f+g*x)^(n+1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && RationalQ[n] && n<-1 && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p+1)/(c*g*(n+p+2)) - 
  (b*e*g*(n+1)+c*e*f*(p+1)-c*d*g*(2*n+p+3))/(c*g*(n+p+2))*Int[(d+e*x)^(m-1)*(f+g*x)^n*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && Not[RationalQ[n] && n<-1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  e^2*(d+e*x)^(m-2)*(f+g*x)^(n+1)*(a+c*x^2)^(p+1)/(c*g*(n+p+2)) - 
  (e*f*(p+1)-d*g*(2*n+p+3))/(g*(n+p+2))*Int[(d+e*x)^(m-1)*(f+g*x)^n*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && 
  Not[IntegerQ[p]] && EqQ[m+p-1] && Not[RationalQ[n] && n<-1] && IntegerQ[2*p]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[p]] && (PositiveIntegerQ[m] || IntegersQ[m,n])


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[ExpandIntegrand[1/Sqrt[a+c*x^2],(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^(p+1/2),x],x] /;
FreeQ[{a,c,d,e,f,g,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && IntegerQ[p-1/2] && IntegersQ[m,n] && Not[m<0 && p<0] && p!=1/2


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,f,g,n,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && (PositiveIntegerQ[m] || IntegersQ[m,n])


Int[x_^2*(a_.+b_.*x_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  d^2/e^2*Int[(a+b*x+c*x^2)^p/(d+e*x),x] - 1/e^2*Int[(d-e*x)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2]


Int[x_^2*(a_+c_.*x_^2)^p_/(d_+e_.*x_),x_Symbol] :=
  d^2/e^2*Int[(a+c*x^2)^p/(d+e*x),x] - 1/e^2*Int[(d-e*x)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,p},x] && EqQ[c*d^2+a*e^2]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^2*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(f+g*x)*(a+b*x+c*x^2)^(p+1)/(c*(m+2*p+3)) - 
  1/(c*e^2*(m+2*p+3))*Int[(d+e*x)^m*(a+b*x+c*x^2)^p*
    Simp[b*e*g*(d*g+e*f*(m+p+1))-c*(d^2*g^2+d*e*f*g*m+e^2*f^2*(m+2*p+3))+
      e*g*(b*e*g*(m+p+2)-c*(d*g*m+e*f*(m+2*p+4)))*x,x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]] && 
  NeQ[m+2*p+3]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^2*(a_+c_.*x_^2)^p_,x_Symbol] :=
  g*(d+e*x)^m*(f+g*x)*(a+c*x^2)^(p+1)/(c*(m+2*p+3)) - 
  1/(c*e^2*(m+2*p+3))*Int[(d+e*x)^m*(a+c*x^2)^p*
    Simp[-c*(d^2*g^2+d*e*f*g*m+e^2*f^2*(m+2*p+3))-c*e*g*(d*g*m+e*f*(m+2*p+4))*x,x],x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && NeQ[m+2*p+3]


Int[(e_.*x_)^m_*(f_.+g_.*x_)^n_*(b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (e*x)^m*(b*x+c*x^2)^p/(x^(m+p)*(b+c*x)^p)*Int[x^(m+p)*(f+g*x)^n*(b+c*x)^p,x] /;
FreeQ[{b,c,e,f,g,m,n},x] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(f+g*x)^n*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]] && PositiveQ[a] && PositiveQ[d]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
(*(a+b*x+c*x^2)^p/((d+e*x)^p*(a*e+c*d*x)^p)*Int[(d+e*x)^(m+p)*(f+g*x)^n*(a*e+c*d*x)^p,x] /; *)
  (a+b*x+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(f+g*x)^n*(a/d+c/e*x)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (a+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(f+g*x)^n*(a/d+c/e*x)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n},x] && NeQ[e*f-d*g] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && IntegersQ[m,n,p]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && IntegersQ[m,n,p]


Int[(a_.+b_.*x_+c_.*x_^2)^p_/((d_.+e_.*x_)*(f_.+g_.*x_)),x_Symbol] :=
  (c*d^2-b*d*e+a*e^2)/(e*(e*f-d*g))*Int[(a+b*x+c*x^2)^(p-1)/(d+e*x),x] - 
  1/(e*(e*f-d*g))*Int[Simp[c*d*f-b*e*f+a*e*g-c*(e*f-d*g)*x,x]*(a+b*x+c*x^2)^(p-1)/(f+g*x),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && FractionQ[p] && p>0


Int[(a_+c_.*x_^2)^p_/((d_.+e_.*x_)*(f_.+g_.*x_)),x_Symbol] :=
  (c*d^2+a*e^2)/(e*(e*f-d*g))*Int[(a+c*x^2)^(p-1)/(d+e*x),x] - 
  1/(e*(e*f-d*g))*Int[Simp[c*d*f+a*e*g-c*(e*f-d*g)*x,x]*(a+c*x^2)^(p-1)/(f+g*x),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && FractionQ[p] && p>0


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{q=Denominator[m]},
  q/e*Subst[Int[x^(q*(m+1)-1)*((e*f-d*g)/e+g*x^q/e)^n*
    ((c*d^2-b*d*e+a*e^2)/e^2-(2*c*d-b*e)*x^q/e^2+c*x^(2*q)/e^2)^p,x],x,(d+e*x)^(1/q)]] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && IntegersQ[n,p] && FractionQ[m]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{q=Denominator[m]},
  q/e*Subst[Int[x^(q*(m+1)-1)*((e*f-d*g)/e+g*x^q/e)^n*((c*d^2+a*e^2)/e^2-2*c*d*x^q/e^2+c*x^(2*q)/e^2)^p,x],x,(d+e*x)^(1/q)]] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && IntegersQ[n,p] && FractionQ[m]


Int[(d_+e_.*x_)^m_*(f_+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d*f+e*g*x^2)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[m-n] && EqQ[e*f+d*g] && (IntegerQ[m] || PositiveQ[d] && PositiveQ[f])


Int[(d_+e_.*x_)^m_*(f_+g_.*x_)^n_*(a_.+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d*f+e*g*x^2)^m*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && EqQ[m-n] && EqQ[e*f+d*g] && (IntegerQ[m] || PositiveQ[d] && PositiveQ[f])


Int[(d_+e_.*x_)^m_*(f_+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^FracPart[m]*(f+g*x)^FracPart[m]/(d*f+e*g*x^2)^FracPart[m]*Int[(d*f+e*g*x^2)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[m-n] && EqQ[e*f+d*g]


Int[(d_+e_.*x_)^m_*(f_+g_.*x_)^n_*(a_.+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^FracPart[m]*(f+g*x)^FracPart[m]/(d*f+e*g*x^2)^FracPart[m]*Int[(d*f+e*g*x^2)^m*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && EqQ[m-n] && EqQ[e*f+d*g]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[(a+b*x)*(d+e*x)^m*(f+g*x)^n,x] + c*Int[x^2*(d+e*x)^m*(f+g*x)^n,x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && RationalQ[m,n]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2),x_Symbol] :=
  a*Int[(d+e*x)^m*(f+g*x)^n,x] + c*Int[x^2*(d+e*x)^m*(f+g*x)^n,x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && RationalQ[m,n]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  g/c^2*Int[Simp[2*c*e*f+c*d*g-b*e*g+c*e*g*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n-2),x] + 
  1/c^2*Int[Simp[c^2*d*f^2-2*a*c*e*f*g-a*c*d*g^2+a*b*e*g^2+(c^2*e*f^2+2*c^2*d*f*g-2*b*c*e*f*g-b*c*d*g^2+b^2*e*g^2-a*c*e*g^2)*x,x]*
    (d+e*x)^(m-1)*(f+g*x)^(n-2)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n>1


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_+c_.*x_^2),x_Symbol] :=
  g/c*Int[Simp[2*e*f+d*g+e*g*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n-2),x] + 
  1/c*Int[Simp[c*d*f^2-2*a*e*f*g-a*d*g^2+(c*e*f^2+2*c*d*f*g-a*e*g^2)*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n-2)/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n>1


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*g/c*Int[(d+e*x)^(m-1)*(f+g*x)^(n-1),x] + 
  1/c*Int[Simp[c*d*f-a*e*g+(c*e*f+c*d*g-b*e*g)*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n-1)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n>0


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_+c_.*x_^2),x_Symbol] :=
  e*g/c*Int[(d+e*x)^(m-1)*(f+g*x)^(n-1),x] + 
  1/c*Int[Simp[c*d*f-a*e*g+(c*e*f+c*d*g)*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n-1)/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n>0


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  -g*(e*f-d*g)/(c*f^2-b*f*g+a*g^2)*Int[(d+e*x)^(m-1)*(f+g*x)^n,x] + 
  1/(c*f^2-b*f*g+a*g^2)*
    Int[Simp[c*d*f-b*d*g+a*e*g+c*(e*f-d*g)*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n+1)/(a+b*x+c*x^2),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n<-1


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_+c_.*x_^2),x_Symbol] :=
  -g*(e*f-d*g)/(c*f^2+a*g^2)*Int[(d+e*x)^(m-1)*(f+g*x)^n,x] + 
  1/(c*f^2+a*g^2)*
    Int[Simp[c*d*f+a*e*g+c*(e*f-d*g)*x,x]*(d+e*x)^(m-1)*(f+g*x)^(n+1)/(a+c*x^2),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && RationalQ[m,n] && m>0 && n<-1


Int[(d_.+e_.*x_)^m_/(Sqrt[f_.+g_.*x_]*(a_.+b_.*x_+c_.*x_^2)),x_Symbol] :=
  Int[ExpandIntegrand[1/(Sqrt[d+e*x]*Sqrt[f+g*x]),(d+e*x)^(m+1/2)/(a+b*x+c*x^2),x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[m+1/2]


Int[(d_.+e_.*x_)^m_/(Sqrt[f_.+g_.*x_]*(a_.+c_.*x_^2)),x_Symbol] :=
  Int[ExpandIntegrand[1/(Sqrt[d+e*x]*Sqrt[f+g*x]),(d+e*x)^(m+1/2)/(a+c*x^2),x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[m+1/2]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n,1/(a+b*x+c*x^2),x],x] /;
FreeQ[{a,b,c,d,e,f,g,m,n},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[m]] && Not[IntegerQ[n]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_/(a_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n,1/(a+c*x^2),x],x] /;
FreeQ[{a,c,d,e,f,g,m,n},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[m]] && Not[IntegerQ[n]]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  (IntegerQ[p] || IntegersQ[m,n])


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && (IntegerQ[p] || IntegersQ[m,n])


Int[(g_.*x_)^n_*(d_.+e_.*x_)^m_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (d+e*x)^FracPart[p]*(a+b*x+c*x^2)^FracPart[p]/(a*d+c*e*x^3)^FracPart[p]*Int[(g*x)^n*(a*d+c*e*x^3)^p,x] /;
FreeQ[{a,b,c,d,e,g,m,n,p},x] && EqQ[m-p] && EqQ[b*d+a*e] && EqQ[c*d+b*e]


Int[(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  (c*d^2-b*d*e+a*e^2)/(e*(e*f-d*g))*Int[(f+g*x)^(n+1)*(a+b*x+c*x^2)^(p-1)/(d+e*x),x] - 
  1/(e*(e*f-d*g))*Int[(f+g*x)^n*(c*d*f-b*e*f+a*e*g-c*(e*f-d*g)*x)*(a+b*x+c*x^2)^(p-1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[n]] && Not[IntegerQ[p]] && RationalQ[n,p] && p>0 && n<-1


Int[(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  (c*d^2+a*e^2)/(e*(e*f-d*g))*Int[(f+g*x)^(n+1)*(a+c*x^2)^(p-1)/(d+e*x),x] - 
  1/(e*(e*f-d*g))*Int[(f+g*x)^n*(c*d*f+a*e*g-c*(e*f-d*g)*x)*(a+c*x^2)^(p-1),x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && 
  Not[IntegerQ[n]] && Not[IntegerQ[p]] && RationalQ[n,p] && p>0 && n<-1


Int[(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  e*(e*f-d*g)/(c*d^2-b*d*e+a*e^2)*Int[(f+g*x)^(n-1)*(a+b*x+c*x^2)^(p+1)/(d+e*x),x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(f+g*x)^(n-1)*(c*d*f-b*e*f+a*e*g-c*(e*f-d*g)*x)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  Not[IntegerQ[n]] && Not[IntegerQ[p]] && RationalQ[n,p] && p<-1 && n>0


Int[(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_/(d_.+e_.*x_),x_Symbol] :=
  e*(e*f-d*g)/(c*d^2+a*e^2)*Int[(f+g*x)^(n-1)*(a+c*x^2)^(p+1)/(d+e*x),x] + 
  1/(c*d^2+a*e^2)*Int[(f+g*x)^(n-1)*(c*d*f+a*e*g-c*(e*f-d*g)*x)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && 
  Not[IntegerQ[n]] && Not[IntegerQ[p]] && RationalQ[n,p] && p<-1 && n>0


Int[1/((d_.+e_.*x_)*Sqrt[f_.+g_.*x_]*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -2*Sqrt[-g*(b-q+2*c*x)/(2*c*f-b*g+g*q)]*Sqrt[-g*(b+q+2*c*x)/(2*c*f-b*g-g*q)]/
    ((e*f-d*g)*Sqrt[2*c/(2*c*f-b*g+g*q)]*Sqrt[a+b*x+c*x^2])*
    EllipticPi[e*(2*c*f-b*g+g*q)/(2*c*(e*f-d*g)),ArcSin[Sqrt[2*c/(2*c*f-b*g+g*q)]*Sqrt[f+g*x]],(2*c*f-b*g+g*q)/(2*c*f-b*g-g*q)]] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[1/((d_.+e_.*x_)*Sqrt[f_.+g_.*x_]*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  -2*Sqrt[g*(q-c*x)/(c*f+g*q)]*Sqrt[-g*(q+c*x)/(c*f-g*q)]/((e*f-d*g)*Sqrt[c/(c*f+g*q)]*Sqrt[a+c*x^2])*
    EllipticPi[e*(c*f+g*q)/(c*(e*f-d*g)),ArcSin[Sqrt[c/(c*f+g*q)]*Sqrt[f+g*x]],(c*f+g*q)/(c*f-g*q)]] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2]


Int[(f_.+g_.*x_)^n_/((d_.+e_.*x_)*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  Int[ExpandIntegrand[1/(Sqrt[f+g*x]*Sqrt[a+b*x+c*x^2]),(f+g*x)^(n+1/2)/(d+e*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && IntegerQ[n+1/2]


Int[(f_.+g_.*x_)^n_/((d_.+e_.*x_)*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  Int[ExpandIntegrand[1/(Sqrt[f+g*x]*Sqrt[a+c*x^2]),(f+g*x)^(n+1/2)/(d+e*x),x],x] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && IntegerQ[n+1/2]


Int[1/(Sqrt[d_.+e_.*x_]*Sqrt[f_.+g_.*x_]*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  -2*(d+e*x)*Sqrt[(e*f-d*g)^2*(a+b*x+c*x^2)/((c*f^2-b*f*g+a*g^2)*(d+e*x)^2)]/((e*f-d*g)*Sqrt[a+b*x+c*x^2])*
  Subst[
    Int[1/Sqrt[1-(2*c*d*f-b*e*f-b*d*g+2*a*e*g)*x^2/(c*f^2-b*f*g+a*g^2)+(c*d^2-b*d*e+a*e^2)*x^4/(c*f^2-b*f*g+a*g^2)],x],
    x,
    Sqrt[f+g*x]/Sqrt[d+e*x]] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[1/(Sqrt[d_.+e_.*x_]*Sqrt[f_.+g_.*x_]*Sqrt[a_+c_.*x_^2]),x_Symbol] :=
  -2*(d+e*x)*Sqrt[(e*f-d*g)^2*(a+c*x^2)/((c*f^2+a*g^2)*(d+e*x)^2)]/((e*f-d*g)*Sqrt[a+c*x^2])*
  Subst[
    Int[1/Sqrt[1-(2*c*d*f+2*a*e*g)*x^2/(c*f^2+a*g^2)+(c*d^2+a*e^2)*x^4/(c*f^2+a*g^2)],x],x,Sqrt[f+g*x]/Sqrt[d+e*x]] /;
FreeQ[{a,c,d,e,f,g},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2]


Int[(e_.*x_)^m_*(f_+g_.*x_)^2*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  2*f*g/e*Int[(e*x)^(m+1)*(a+c*x^2)^p,x] + Int[(e*x)^m*(f^2+g^2*x^2)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,e,f,g,m,p},x]


Int[(e_.*x_)^m_*(f_+g_.*x_)^3*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  f*Int[(e*x)^m*(f^2+3*g^2*x^2)*(a+c*x^2)^p,x] + g/e*Int[(e*x)^(m+1)*(3*f^2+g^2*x^2)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,e,f,g,m,p},x]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  g/e*Int[(d+e*x)^(m+1)*(f+g*x)^(n-1)*(a+b*x+c*x^2)^p,x] + 
  (e*f-d*g)/e*Int[(d+e*x)^m*(f+g*x)^(n-1)*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[n]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  g/e*Int[(d+e*x)^(m+1)*(f+g*x)^(n-1)*(a+c*x^2)^p,x] + 
  (e*f-d*g)/e*Int[(d+e*x)^m*(f+g*x)^(n-1)*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,p},x] && NeQ[e*f-d*g] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[n]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Defer[Int][(d+e*x)^m*(f+g*x)^n*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x]


Int[(d_.+e_.*x_)^m_*(f_.+g_.*x_)^n_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Defer[Int][(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,g,m,n,p},x]


Int[(d_.+e_.*u_)^m_.*(f_.+g_.*u_)^n_.*(a_+b_.*u_+c_.*u_^2)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x)^m*(f+g*x)^n*(a+b*x+c*x^2)^p,x],x,u] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && LinearQ[u,x] && NeQ[u-x]


Int[(d_.+e_.*u_)^m_.*(f_.+g_.*u_)^n_.*(a_+c_.*u_^2)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x)^m*(f+g*x)^n*(a+c*x^2)^p,x],x,u] /;
FreeQ[{a,c,d,e,f,g,m,n,p},x] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.1.5 (a+b x+c x^2)^p (d+e x+f x^2)^q*)


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.,x_Symbol] :=
  (c/f)^p*Int[(d+e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && (IntegerQ[p] || PositiveQ[c/f]) && 
  (Not[IntegerQ[q]] || LeafCount[d+e*x+f*x^2]<=LeafCount[a+b*x+c*x^2])


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.,x_Symbol] :=
  a^IntPart[p]*(a+b*x+c*x^2)^FracPart[p]/(d^IntPart[p]*(d+e*x+f*x^2)^FracPart[p])*Int[(d+e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && Not[IntegerQ[p]] && Not[IntegerQ[q]] && Not[PositiveQ[c/f]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_.,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_.,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,f,p,q},x] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]]


(* Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  1/(2^(2*p+2*q+1)*c*(-c/(b^2-4*a*c))^p*(-f/(e^2-4*d*f))^q)*
    Subst[Int[(1-x^2/(b^2-4*a*c))^p*(1+e*x^2/(b*(4*c*d-b*e)))^q,x],x,b+2*c*x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f] && 
  (IntegerQ[p] || PositiveQ[-c/(b^2-4*a*c)]) && (IntegerQ[q] || PositiveQ[-f/(e^2-4*d*f)]) *)


(* Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (d+e*x+f*x^2)^q/(2^(2*p+2*q+1)*c*(-c/(b^2-4*a*c))^p*(-f*(d+e*x+f*x^2)/(e^2-4*d*f))^q)*
    Subst[Int[(1-x^2/(b^2-4*a*c))^p*(1+e*x^2/(b*(4*c*d-b*e)))^q,x],x,b+2*c*x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f] && 
  (IntegerQ[p] || PositiveQ[-c/(b^2-4*a*c)]) && Not[IntegerQ[q] || PositiveQ[-f/(e^2-4*d*f)]] *)


(* Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q/(2^(2*p+2*q+1)*c*(-c*(a+b*x+c*x^2)/(b^2-4*a*c))^p*(-f*(d+e*x+f*x^2)/(e^2-4*d*f))^q)*
    Subst[Int[(1-x^2/(b^2-4*a*c))^p*(1+e*x^2/(b*(4*c*d-b*e)))^q,x],x,b+2*c*x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f] *)


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/((b^2-4*a*c)*(p+1)) - 
  (1/((b^2-4*a*c)*(p+1)))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[2*c*d*(2*p+3)+b*e*q+(2*b*f*q+2*c*e*(2*p+q+3))*x+2*c*f*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  (b+2*c*x)*(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q/((b^2-4*a*c)*(p+1)) - 
  (1/((b^2-4*a*c)*(p+1)))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q-1)*
      Simp[2*c*d*(2*p+3)+(2*b*f*q)*x+2*c*f*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_.+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (2*c*x)*(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/((-4*a*c)*(p+1)) - 
  (1/((-4*a*c)*(p+1)))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[2*c*d*(2*p+3)+(2*c*e*(2*p+q+3))*x+2*c*f*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,c,d,e,f},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (2*a*c^2*e-b^2*c*e+b^3*f+b*c*(c*d-3*a*f)+c*(2*c^2*d+b^2*f-c*(b*e+2*a*f))*x)*(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/
    ((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)) - 
  (1/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[2*c*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)-
        (2*c^2*d+b^2*f-c*(b*e+2*a*f))*(a*f*(p+1)-c*d*(p+2))-
        e*(b^2*c*e-2*a*c^2*e-b^3*f-b*c*(c*d-3*a*f))*(p+q+2)+
       (2*f*(2*a*c^2*e-b^2*c*e+b^3*f+b*c*(c*d-3*a*f))*(p+q+2)-(2*c^2*d+b^2*f-c*(b*e+2*a*f))*(b*f*(p+1)-c*e*(2*p+q+4)))*x+
       c*f*(2*c^2*d+b^2*f-c*(b*e+2*a*f))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,e,f,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && 
  NeQ[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f)] && Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  (b^3*f+b*c*(c*d-3*a*f)+c*(2*c^2*d+b^2*f-c*(2*a*f))*x)*(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q+1)/
    ((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1)) - 
  (1/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1)))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q*
      Simp[2*c*(b^2*d*f+(c*d-a*f)^2)*(p+1)-
        (2*c^2*d+b^2*f-c*(2*a*f))*(a*f*(p+1)-c*d*(p+2))+
       (2*f*(b^3*f+b*c*(c*d-3*a*f))*(p+q+2)-(2*c^2*d+b^2*f-c*(2*a*f))*(b*f*(p+1)))*x+
       c*f*(2*c^2*d+b^2*f-c*(2*a*f))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,f,q},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && NeQ[b^2*d*f+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_.+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (2*a*c^2*e+c*(2*c^2*d-c*(2*a*f))*x)*(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/
    ((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1)) - 
  (1/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1)))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[2*c*((c*d-a*f)^2-(-a*e)*(c*e))*(p+1)-(2*c^2*d-c*(2*a*f))*(a*f*(p+1)-c*d*(p+2))-e*(-2*a*c^2*e)*(p+q+2)+
       (2*f*(2*a*c^2*e)*(p+q+2)-(2*c^2*d-c*(2*a*f))*(-c*e*(2*p+q+4)))*x+
       c*f*(2*c^2*d-c*(2*a*f))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,c,d,e,f,q},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && NeQ[a*c*e^2+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (b*f*(3*p+2*q)-c*e*(2*p+q)+2*c*f*(p+q)*x)*(a+b*x+c*x^2)^(p-1)*(d+e*x+f*x^2)^(q+1)/(2*f^2*(p+q)*(2*p+2*q+1)) - 
  1/(2*f^2*(p+q)*(2*p+2*q+1))*
    Int[(a+b*x+c*x^2)^(p-2)*(d+e*x+f*x^2)^q*
      Simp[(b*d-a*e)*(c*e-b*f)*(1-p)*(2*p+q)-
        (p+q)*(b^2*d*f*(1-p)-a*(f*(b*e-2*a*f)*(2*p+2*q+1)+c*(2*d*f-e^2*(2*p+q))))+
        (2*(c*d-a*f)*(c*e-b*f)*(1-p)*(2*p+q)-
          (p+q)*((b^2-4*a*c)*e*f*(1-p)+b*(c*(e^2-4*d*f)*(2*p+q)+f*(2*c*d-b*e+2*a*f)*(2*p+2*q+1))))*x+
        ((c*e-b*f)^2*(1-p)*p+c*(p+q)*(f*(b*e-2*a*f)*(4*p+2*q-1)-c*(2*d*f*(1-2*p)+e^2*(3*p+q-1))))*x^2,x],x]/;
FreeQ[{a,b,c,d,e,f,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && GtQ[p,1] && 
  NeQ[p+q] && NeQ[2*p+2*q+1] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  (b*(3*p+2*q)+2*c*(p+q)*x)*(a+b*x+c*x^2)^(p-1)*(d+f*x^2)^(q+1)/(2*f*(p+q)*(2*p+2*q+1)) - 
  1/(2*f*(p+q)*(2*p+2*q+1))*
    Int[(a+b*x+c*x^2)^(p-2)*(d+f*x^2)^q*
      Simp[b^2*d*(p-1)*(2*p+q)-(p+q)*(b^2*d*(1-p)-2*a*(c*d-a*f*(2*p+2*q+1)))-
        (2*b*(c*d-a*f)*(1-p)*(2*p+q)-2*(p+q)*b*(2*c*d*(2*p+q)-(c*d+a*f)*(2*p+2*q+1)))*x+
        (b^2*f*p*(1-p)+2*c*(p+q)*(c*d*(2*p-1)-a*f*(4*p+2*q-1)))*x^2,x],x]/;
FreeQ[{a,b,c,d,f,q},x] && NeQ[b^2-4*a*c] && GtQ[p,1] && NeQ[p+q] && NeQ[2*p+2*q+1] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_.+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  -c*(e*(2*p+q)-2*f*(p+q)*x)*(a+c*x^2)^(p-1)*(d+e*x+f*x^2)^(q+1)/(2*f^2*(p+q)*(2*p+2*q+1)) - 
  1/(2*f^2*(p+q)*(2*p+2*q+1))*
    Int[(a+c*x^2)^(p-2)*(d+e*x+f*x^2)^q*
      Simp[-a*c*e^2*(1-p)*(2*p+q)+a*(p+q)*(-2*a*f^2*(2*p+2*q+1)+c*(2*d*f-e^2*(2*p+q)))+
        (2*(c*d-a*f)*(c*e)*(1-p)*(2*p+q)+4*a*c*e*f*(1-p)*(p+q))*x+
        (p*c^2*e^2*(1-p)-c*(p+q)*(2*a*f^2*(4*p+2*q-1)+c*(2*d*f*(1-2*p)+e^2*(3*p+q-1))))*x^2,x],x]/;
FreeQ[{a,c,d,e,f,q},x] && NeQ[e^2-4*d*f] && GtQ[p,1] && NeQ[p+q] && NeQ[2*p+2*q+1] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[1/((a_+b_.*x_+c_.*x_^2)*(d_+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2-b*c*d*e+a*c*e^2+b^2*d*f-2*a*c*d*f-a*b*e*f+a^2*f^2},
  1/q*Int[(c^2*d-b*c*e+b^2*f-a*c*f-(c^2*e-b*c*f)*x)/(a+b*x+c*x^2),x] + 
  1/q*Int[(c*e^2-c*d*f-b*e*f+a*f^2+(c*e*f-b*f^2)*x)/(d+e*x+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[1/((a_+b_.*x_+c_.*x_^2)*(d_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2+b^2*d*f-2*a*c*d*f+a^2*f^2},
  1/q*Int[(c^2*d+b^2*f-a*c*f+b*c*f*x)/(a+b*x+c*x^2),x] - 
  1/q*Int[(c*d*f-a*f^2+b*f^2*x)/(d+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c]


Int[1/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -2*e*Subst[Int[1/(e*(b*e-4*a*f)-(b*d-a*e)*x^2),x],x,(e+2*f*x)/Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f]


(* Int[1/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{k=Rt[(a/c-d/f)^2+(b/c-e/f)*(b*d/(c*f)-a*e/(c*f)),2]},
  -2*(c*d-a*f+c*f*k+(c*e-b*f)*x)*Sqrt[(d+e*x+f*x^2)*((c*f*k)/(c*d-a*f+c*f*k+(c*e-b*f)*x))^2]/(c*Sqrt[d+e*x+f*x^2])*
    Subst[Int[(1-x)/(
      (b*d-a*e-b*f*k-(c*d-a*f-c*f*k)^2/(c*e-b*f)+(b*d-a*e+b*f*k-(a*f-c*d-c*f*k)^2/(c*e-b*f))*x^2)*
      Sqrt[-f*((b*d-a*e-c*e*k)/(c*e-b*f)-(c*d-a*f-c*f*k)^2/(c*e-b*f)^2)-f*((b*d-a*e+c*e*k)/(c*e-b*f)-(a*f-c*d-c*f*k)^2/(c*e-b*f)^2)*x^2]),x],x,
        (c*d-a*f-c*f*k+(c*e-b*f)*x)/(c*d-a*f+c*f*k+(c*e-b*f)*x)]] /;
FreeQ[{a,b,c,d,e,f},x] && RationalQ[a,b,c,d,e,f] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && NeQ[c*e-b*f] && NegativeQ[b^2-4*a*c] *)


(* Int[1/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{k=Rt[(a/c-d/f)^2+a*e^2/(c*f^2),2]},
  -2*(c*d-a*f+c*f*k+c*e*x)*Sqrt[(d+e*x+f*x^2)*((c*f*k)/(c*d-a*f+c*f*k+c*e*x))^2]/(c*Sqrt[d+e*x+f*x^2])*
    Subst[Int[(1-x)/(
      (-a*e-(c*d-a*f-c*f*k)^2/(c*e)+(-a*e-(a*f-c*d-c*f*k)^2/(c*e))*x^2)*
      Sqrt[-f*((-a*e-c*e*k)/(c*e)-(c*d-a*f-c*f*k)^2/(c*e)^2)-f*((-a*e+c*e*k)/(c*e)-(a*f-c*d-c*f*k)^2/(c*e)^2)*x^2]),x],x,
        (c*d-a*f-c*f*k+(c*e)*x)/(c*d-a*f+c*f*k+(c*e)*x)]] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[a,c,d,e,f] && NeQ[e^2-4*d*f] && NegativeQ[-a*c] *)


(* Int[1/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  With[{k=Rt[(a/c-d/f)^2+b^2*d/(c^2*f),2]},
  -2*(c*d-a*f+c*f*k-b*f*x)*Sqrt[(d+f*x^2)*((c*f*k)/(c*d-a*f+c*f*k-b*f*x))^2]/(c*Sqrt[d+f*x^2])*
    Subst[Int[(1-x)/(
      (b*d-b*f*k+(c*d-a*f-c*f*k)^2/(b*f)+(b*d+b*f*k+(a*f-c*d-c*f*k)^2/(b*f))*x^2)*
      Sqrt[-f*(-d/f-(c*d-a*f-c*f*k)^2/(b*f)^2)-f*(-d/f-(a*f-c*d-c*f*k)^2/(b*f)^2)*x^2]),x],x,
        (c*d-a*f-c*f*k+(-b*f)*x)/(c*d-a*f+c*f*k+(-b*f)*x)]] /;
FreeQ[{a,b,c,d,f},x] && RationalQ[a,b,c,d,f] && NeQ[b^2-4*a*c] && NegativeQ[b^2-4*a*c] *)


Int[1/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[1/((b-q+2*c*x)*Sqrt[d+e*x+f*x^2]),x] -
  2*c/q*Int[1/((b+q+2*c*x)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && NeQ[c*e-b*f] && PosQ[b^2-4*a*c]


Int[1/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  1/2*Int[1/((a-Rt[-a*c,2]*x)*Sqrt[d+e*x+f*x^2]),x] +
  1/2*Int[1/((a+Rt[-a*c,2]*x)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,c,d,e,f},x] && NeQ[e^2-4*d*f] && PosQ[-a*c]


Int[1/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[1/((b-q+2*c*x)*Sqrt[d+f*x^2]),x] -
  2*c/q*Int[1/((b+q+2*c*x)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c] && PosQ[b^2-4*a*c]


Int[1/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f),2]},
  1/(2*q)*Int[(c*d-a*f+q+(c*e-b*f)*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] - 
  1/(2*q)*Int[(c*d-a*f-q+(c*e-b*f)*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && NeQ[c*e-b*f] && NegQ[b^2-4*a*c]


Int[1/((a_.+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2+a*c*e^2,2]},
  1/(2*q)*Int[(c*d-a*f+q+c*e*x)/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x] - 
  1/(2*q)*Int[(c*d-a*f-q+c*e*x)/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,c,d,e,f},x] && NeQ[e^2-4*d*f] && NegQ[-a*c]


Int[1/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2+b^2*d*f,2]},
  1/(2*q)*Int[(c*d-a*f+q+(-b*f)*x)/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x] - 
  1/(2*q)*Int[(c*d-a*f-q+(-b*f)*x)/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c] && NegQ[b^2-4*a*c]


Int[Sqrt[a_+b_.*x_+c_.*x_^2]/(d_+e_.*x_+f_.*x_^2),x_Symbol] :=
  c/f*Int[1/Sqrt[a+b*x+c*x^2],x] - 
  1/f*Int[(c*d-a*f+(c*e-b*f)*x)/(Sqrt[a+b*x+c*x^2]*(d+e*x+f*x^2)),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[Sqrt[a_+b_.*x_+c_.*x_^2]/(d_+f_.*x_^2),x_Symbol] :=
  c/f*Int[1/Sqrt[a+b*x+c*x^2],x] - 
  1/f*Int[(c*d-a*f-b*f*x)/(Sqrt[a+b*x+c*x^2]*(d+f*x^2)),x] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c]


Int[Sqrt[a_+c_.*x_^2]/(d_+e_.*x_+f_.*x_^2),x_Symbol] :=
  c/f*Int[1/Sqrt[a+c*x^2],x] - 
  1/f*Int[(c*d-a*f+c*e*x)/(Sqrt[a+c*x^2]*(d+e*x+f*x^2)),x] /;
FreeQ[{a,c,d,e,f},x] && NeQ[e^2-4*d*f]


Int[1/(Sqrt[a_+b_.*x_+c_.*x_^2]*Sqrt[d_+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  Sqrt[b+r+2*c*x]*Sqrt[2*a+(b+r)*x]/Sqrt[a+b*x+c*x^2]*Int[1/(Sqrt[b+r+2*c*x]*Sqrt[2*a+(b+r)*x]*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[1/(Sqrt[a_+b_.*x_+c_.*x_^2]*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  Sqrt[b+r+2*c*x]*Sqrt[2*a+(b+r)*x]/Sqrt[a+b*x+c*x^2]*Int[1/(Sqrt[b+r+2*c*x]*Sqrt[2*a+(b+r)*x]*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,c,d,f},x] && NeQ[b^2-4*a*c]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Defer[Int][(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Defer[Int][(a+c*x^2)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,c,d,e,f,p,q},x] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_.+b_.*u_+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q,x],x,u] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+c*x^2)^p*(d+e*x+f*x^2)^q,x],x,u] /;
FreeQ[{a,c,d,e,f,p,q},x] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.1.6 (g+h x)^m (a+b x+c x^2)^p (d+e x+f x^2)^q*)


Int[(g_.+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (c/f)^p*Int[(g+h*x)^m*(d+e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && (IntegerQ[p] || PositiveQ[c/f]) && 
  (Not[IntegerQ[q]] || LeafCount[d+e*x+f*x^2]<=LeafCount[a+b*x+c*x^2])


Int[(g_.+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  a^IntPart[p]*(a+b*x+c*x^2)^FracPart[p]/(d^IntPart[p]*(d+e*x+f*x^2)^FracPart[p])*Int[(g+h*x)^m*(d+e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && Not[IntegerQ[p]] && Not[IntegerQ[q]] && Not[PositiveQ[c/f]]


Int[(g_.+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(g+h*x)^m*(b+2*c*x)^(2*p)*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[b^2-4*a*c]


Int[(g_.+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(g+h*x)^m*(b+2*c*x)^(2*p)*(d+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,f,g,h,m,p,q},x] && EqQ[b^2-4*a*c]


Int[(g_+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^m_.,x_Symbol] :=
  Int[(d*g/a+f*h*x/c)^m*(a+b*x+c*x^2)^(m+p),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p},x] && EqQ[c*g^2-b*g*h+a*h^2] && EqQ[c^2*d*g^2-a*c*e*g*h+a^2*f*h^2] && IntegerQ[m]


Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^m_.,x_Symbol] :=
  Int[(d*g/a+f*h*x/c)^m*(a+c*x^2)^(m+p),x] /;
FreeQ[{a,c,d,e,f,g,h,p},x] && EqQ[c*g^2+a*h^2] && EqQ[c^2*d*g^2-a*c*e*g*h+a^2*f*h^2] && IntegerQ[m]


Int[(g_+h_.*x_)^m_.*(a_+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^m_.,x_Symbol] :=
  Int[(d*g/a+f*h*x/c)^m*(a+b*x+c*x^2)^(m+p),x] /;
FreeQ[{a,b,c,d,f,g,h,p},x] && EqQ[c*g^2-b*g*h+a*h^2] && EqQ[c^2*d*g^2+a^2*f*h^2] && IntegerQ[m]


Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^m_.,x_Symbol] :=
  Int[(d*g/a+f*h*x/c)^m*(a+c*x^2)^(m+p),x] /;
FreeQ[{a,c,d,f,g,h,p},x] && EqQ[c*g^2+a*h^2] && EqQ[c^2*d*g^2+a^2*f*h^2] && IntegerQ[m]


(* Int[(g_+h_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,q},x] && EqQ[c*g^2-b*g*h+a*h^2] && IntegerQ[p] *)


(* Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,c,d,e,f,g,h,m,q},x] && NeQ[e^2-4*d*f] && EqQ[c*g^2+a*h^2] && IntegerQ[p] *)


(* Int[(g_+h_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,f,g,h,m,q},x] && NeQ[b^2-4*a*c] && EqQ[c*g^2-b*g*h+a*h^2] && IntegerQ[p] *)


(* Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+f*x^2)^q,x] /;
FreeQ[{a,c,d,f,g,h,m,q},x] && EqQ[c*g^2+a*h^2] && IntegerQ[p] *)


(* Int[(g_+h_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((g+h*x)^FracPart[p]*(a/g+(c*x)/h)^FracPart[p])*Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,q},x] && EqQ[c*g^2-b*g*h+a*h^2] && Not[IntegerQ[p]] *)


(* Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  (a+c*x^2)^FracPart[p]/((g+h*x)^FracPart[p]*(a/g+(c*x)/h)^FracPart[p])*Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+e*x+f*x^2)^q,x] /;
FreeQ[{a,c,d,e,f,g,h,m,q},x] && NeQ[e^2-4*d*f] && EqQ[c*g^2+a*h^2] && Not[IntegerQ[p]] *)


(* Int[(g_+h_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((g+h*x)^FracPart[p]*(a/g+(c*x)/h)^FracPart[p])*Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+f*x^2)^q,x] /;
FreeQ[{a,b,c,d,f,g,h,m,q},x] && NeQ[b^2-4*a*c] && EqQ[c*g^2-b*g*h+a*h^2] && Not[IntegerQ[p]] *)


(* Int[(g_+h_.*x_)^m_.*(a_+c_.*x_^2)^p_*(d_.+f_.*x_^2)^q_,x_Symbol] :=
  (a+c*x^2)^FracPart[p]/((g+h*x)^FracPart[p]*(a/g+(c*x)/h)^FracPart[p])*Int[(g+h*x)^(m+p)*(a/g+c/h*x)^p*(d+f*x^2)^q,x] /;
FreeQ[{a,c,d,f,g,h,m,q},x] && EqQ[c*g^2+a*h^2] && Not[IntegerQ[p]] *)


Int[x_^p_*(a_.+b_.*x_+c_.*x_^2)^p_*(e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Int[(a/e+c/f*x)^p*(e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,b,c,e,f,q},x] && NeQ[b^2-4*a*c] && EqQ[c*e^2-b*e*f+a*f^2] && IntegerQ[p]


Int[x_^p_*(a_+c_.*x_^2)^p_*(e_.*x_+f_.*x_^2)^q_,x_Symbol] :=
  Int[(a/e+c/f*x)^p*(e*x+f*x^2)^(p+q),x] /;
FreeQ[{a,c,e,f,q},x] && EqQ[c*e^2+a*f^2] && IntegerQ[p]


Int[(g_+h_.*x_)/((a_+c_.*x_^2)^(1/3)*(d_+f_.*x_^2)),x_Symbol] :=
  Sqrt[3]*h*ArcTan[1/Sqrt[3]-2^(2/3)*(1-3*h*x/g)^(2/3)/(Sqrt[3]*(1+3*h*x/g)^(1/3))]/(2^(2/3)*a^(1/3)*f) + 
  h*Log[d+f*x^2]/(2^(5/3)*a^(1/3)*f) - 
  3*h*Log[(1-3*h*x/g)^(2/3)+2^(1/3)*(1+3*h*x/g)^(1/3)]/(2^(5/3)*a^(1/3)*f) /;
FreeQ[{a,c,d,f,g,h},x] && EqQ[c*d+3*a*f] && EqQ[c*g^2+9*a*h^2] && PositiveQ[a]


Int[(g_+h_.*x_)/((a_+c_.*x_^2)^(1/3)*(d_+f_.*x_^2)),x_Symbol] :=
  (1+c*x^2/a)^(1/3)/(a+c*x^2)^(1/3)*Int[(g+h*x)/((1+c*x^2/a)^(1/3)*(d+f*x^2)),x] /;
FreeQ[{a,c,d,f,g,h},x] && EqQ[c*d+3*a*f] && EqQ[c*g^2+9*a*h^2] && Not[PositiveQ[a]]


Int[(g_+h_.*x_)*(a_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_,x_Symbol] :=
  g*Int[(a+c*x^2)^p*(d+f*x^2)^q,x] + h*Int[x*(a+c*x^2)^p*(d+f*x^2)^q,x] /;
FreeQ[{a,c,d,f,g,h,p,q},x]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q*(g+h*x),x],x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && IntegersQ[p,q] && p>0


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  Int[ExpandIntegrand[(a+c*x^2)^p*(d+e*x+f*x^2)^q*(g+h*x),x],x] /;
FreeQ[{a,c,d,e,f,g,h},x] && NeQ[e^2-4*d*f] && IntegersQ[p,q] && (p>0 || q>0)


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (g*b-2*a*h-(b*h-2*g*c)*x)*(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/((b^2-4*a*c)*(p+1)) - 
  1/((b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[e*q*(g*b-2*a*h)-d*(b*h-2*g*c)*(2*p+3)+
        (2*f*q*(g*b-2*a*h)-e*(b*h-2*g*c)*(2*p+q+3))*x-
        f*(b*h-2*g*c)*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && RationalQ[p,q] && p<-1 && q>0


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (a*h-g*c*x)*(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/(2*a*c*(p+1)) + 
  2/(4*a*c*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[g*c*d*(2*p+3)-a*(h*e*q)+(g*c*e*(2*p+q+3)-a*(2*h*f*q))*x+g*c*f*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,c,d,e,f,g,h},x] && NeQ[e^2-4*d*f] && RationalQ[p,q] && p<-1 && q>0


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (g*b-2*a*h-(b*h-2*g*c)*x)*(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q/((b^2-4*a*c)*(p+1)) - 
  1/((b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q-1)*
      Simp[-d*(b*h-2*g*c)*(2*p+3)+(2*f*q*(g*b-2*a*h))*x-f*(b*h-2*g*c)*(2*p+2*q+3)*x^2,x],x] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c] && RationalQ[p,q] && p<-1 && q>0


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    (g*c*(2*a*c*e-b*(c*d+a*f))+(g*b-a*h)*(2*c^2*d+b^2*f-c*(b*e+2*a*f))+
      c*(g*(2*c^2*d+b^2*f-c*(b*e+2*a*f))-h*(b*c*d-2*a*c*e+a*b*f))*x) + 
  1/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(b*h-2*g*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)+
        (b^2*(g*f)-b*(h*c*d+g*c*e+a*h*f)+2*(g*c*(c*d-a*f)-a*(-h*c*e)))*(a*f*(p+1)-c*d*(p+2))-
        e*((g*c)*(2*a*c*e-b*(c*d+a*f))+(g*b-a*h)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
        (2*f*((g*c)*(2*a*c*e-b*(c*d+a*f))+(g*b-a*h)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
          (b^2*g*f-b*(h*c*d+g*c*e+a*h*f)+2*(g*c*(c*d-a*f)-a*(-h*c*e)))*
          (b*f*(p+1)-c*e*(2*p+q+4)))*x-
        c*f*(b^2*(g*f)-b*(h*c*d+g*c*e+a*h*f)+2*(g*c*(c*d-a*f)+a*h*c*e))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,e,f,g,h,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && RationalQ[p] && p<-1 && 
  NeQ[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f)] && Not[Not[IntegerQ[p]] && IntegerQ[q] && q<-1]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    (g*c*(2*a*c*e)+(-a*h)*(2*c^2*d-c*(2*a*f))+
      c*(g*(2*c^2*d-c*(2*a*f))-h*(-2*a*c*e))*x) + 
  1/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(-2*g*c)*((c*d-a*f)^2-(-a*e)*(c*e))*(p+1)+
        (2*(g*c*(c*d-a*f)-a*(-h*c*e)))*(a*f*(p+1)-c*d*(p+2))-
        e*((g*c)*(2*a*c*e)+(-a*h)*(2*c^2*d-c*(+2*a*f)))*(p+q+2)-
        (2*f*((g*c)*(2*a*c*e)+(-a*h)*(2*c^2*d+-c*(+2*a*f)))*(p+q+2)-(2*(g*c*(c*d-a*f)-a*(-h*c*e)))*(-c*e*(2*p+q+4)))*x-
        c*f*(2*(g*c*(c*d-a*f)-a*(-h*c*e)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,c,d,e,f,g,h,q},x] && NeQ[e^2-4*d*f] && RationalQ[p] && p<-1 && NeQ[a*c*e^2+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && IntegerQ[q] && q<-1]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q+1)/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    ((g*c)*(-b*(c*d+a*f))+(g*b-a*h)*(2*c^2*d+b^2*f-c*(2*a*f))+
      c*(g*(2*c^2*d+b^2*f-c*(2*a*f))-h*(b*c*d+a*b*f))*x) + 
  1/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q*
      Simp[(b*h-2*g*c)*((c*d-a*f)^2-(b*d)*(-b*f))*(p+1)+
        (b^2*(g*f)-b*(h*c*d+a*h*f)+2*(g*c*(c*d-a*f)))*(a*f*(p+1)-c*d*(p+2))-
        (2*f*((g*c)*(-b*(c*d+a*f))+(g*b-a*h)*(2*c^2*d+b^2*f-c*(2*a*f)))*(p+q+2)-
          (b^2*(g*f)-b*(h*c*d+a*h*f)+2*(g*c*(c*d-a*f)))*
          (b*f*(p+1)))*x-
        c*f*(b^2*(g*f)-b*(h*c*d+a*h*f)+2*(g*c*(c*d-a*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,f,g,h,q},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && NeQ[b^2*d*f+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && IntegerQ[q] && q<-1]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  h*(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^(q+1)/(2*f*(p+q+1)) - 
  (1/(2*f*(p+q+1)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[h*p*(b*d-a*e)+a*(h*e-2*g*f)*(p+q+1)+
        (2*h*p*(c*d-a*f)+b*(h*e-2*g*f)*(p+q+1))*x+
        (h*p*(c*e-b*f)+c*(h*e-2*g*f)*(p+q+1))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && RationalQ[p] && p>0 && NeQ[p+q+1]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  h*(a+c*x^2)^p*(d+e*x+f*x^2)^(q+1)/(2*f*(p+q+1)) + 
  (1/(2*f*(p+q+1)))*
    Int[(a+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[a*h*e*p-a*(h*e-2*g*f)*(p+q+1)-2*h*p*(c*d-a*f)*x-(h*c*e*p+c*(h*e-2*g*f)*(p+q+1))*x^2,x],x] /;
FreeQ[{a,c,d,e,f,g,h,q},x] && NeQ[e^2-4*d*f] && RationalQ[p] && p>0 && NeQ[p+q+1]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  h*(a+b*x+c*x^2)^p*(d+f*x^2)^(q+1)/(2*f*(p+q+1)) - 
  (1/(2*f*(p+q+1)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+f*x^2)^q*
      Simp[h*p*(b*d)+a*(-2*g*f)*(p+q+1)+
        (2*h*p*(c*d-a*f)+b*(-2*g*f)*(p+q+1))*x+
        (h*p*(-b*f)+c*(-2*g*f)*(p+q+1))*x^2,x],x] /;
FreeQ[{a,b,c,d,f,g,h,q},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p>0 && NeQ[p+q+1]


Int[(g_.+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*(d_+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=Simplify[c^2*d^2-b*c*d*e+a*c*e^2+b^2*d*f-2*a*c*d*f-a*b*e*f+a^2*f^2]},
  1/q*Int[Simp[g*c^2*d-g*b*c*e+a*h*c*e+g*b^2*f-a*b*h*f-a*g*c*f+c*(h*c*d-g*c*e+g*b*f-a*h*f)*x,x]/(a+b*x+c*x^2),x] + 
  1/q*Int[Simp[-h*c*d*e+g*c*e^2+b*h*d*f-g*c*d*f-g*b*e*f+a*g*f^2-f*(h*c*d-g*c*e+g*b*f-a*h*f)*x,x]/(d+e*x+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(g_.+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*(d_+f_.*x_^2)),x_Symbol] :=
  With[{q=Simplify[c^2*d^2+b^2*d*f-2*a*c*d*f+a^2*f^2]},
  1/q*Int[Simp[g*c^2*d+g*b^2*f-a*b*h*f-a*g*c*f+c*(h*c*d+g*b*f-a*h*f)*x,x]/(a+b*x+c*x^2),x] + 
  1/q*Int[Simp[b*h*d*f-g*c*d*f+a*g*f^2-f*(h*c*d+g*b*f-a*h*f)*x,x]/(d+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c]


Int[(g_+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -2*g*Subst[Int[1/(b*d-a*e-b*x^2),x],x,Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f] && EqQ[h*e-2*g*f]


Int[(g_.+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -(h*e-2*g*f)/(2*f)*Int[1/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] + 
  h/(2*f)*Int[(e+2*f*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[c*e-b*f] && NeQ[h*e-2*g*f]


Int[x_/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -2*e*Subst[Int[(1-d*x^2)/(c*e-b*f-e*(2*c*d-b*e+2*a*f)*x^2+d^2*(c*e-b*f)*x^4),x],x,
    (1+(e+Sqrt[e^2-4*d*f])*x/(2*d))/Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[b*d-a*e]


Int[(g_+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_+e_.*x_+f_.*x_^2]),x_Symbol] :=
  g*Subst[Int[1/(a+(c*d-a*f)*x^2),x],x,x/Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[b*d-a*e] && EqQ[2*h*d-g*e]


Int[(g_+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -(2*h*d-g*e)/e*Int[1/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] + 
  h/e*Int[(2*d+e*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && EqQ[b*d-a*e] && NeQ[2*h*d-g*e]


Int[(g_.+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -2*g*(g*b-2*a*h)*
    Subst[Int[1/Simp[g*(g*b-2*a*h)*(b^2-4*a*c)-(b*d-a*e)*x^2,x],x],x,Simp[g*b-2*a*h-(b*h-2*g*c)*x,x]/Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && NeQ[b*d-a*e] && 
  EqQ[h^2*(b*d-a*e)-2*g*h*(c*d-a*f)+g^2*(c*e-b*f)]


Int[(g_+h_.*x_)/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  -2*a*g*h*Subst[Int[1/Simp[2*a^2*g*h*c+a*e*x^2,x],x],x,Simp[a*h-g*c*x,x]/Sqrt[d+e*x+f*x^2]] /;
FreeQ[{a,c,d,e,f,g,h},x] && EqQ[a*h^2*e+2*g*h*(c*d-a*f)-g^2*c*e]


Int[(g_+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  -2*g*(g*b-2*a*h)*Subst[Int[1/Simp[g*(g*b-2*a*h)*(b^2-4*a*c)-b*d*x^2,x],x],x,Simp[g*b-2*a*h-(b*h-2*g*c)*x,x]/Sqrt[d+f*x^2]] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c] && EqQ[b*h^2*d-2*g*h*(c*d-a*f)-g^2*b*f]


Int[(g_.+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*g-h*(b-q))/q*Int[1/((b-q+2*c*x)*Sqrt[d+e*x+f*x^2]),x] -
  (2*c*g-h*(b+q))/q*Int[1/((b+q+2*c*x)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && PosQ[b^2-4*a*c]


Int[(g_.+h_.*x_)/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (h/2+c*g/(2*q))*Int[1/((-q+c*x)*Sqrt[d+e*x+f*x^2]),x] +
  (h/2-c*g/(2*q))*Int[1/((q+c*x)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,c,d,e,f,g,h},x] && NeQ[e^2-4*d*f] && PosQ[-a*c]


Int[(g_.+h_.*x_)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*g-h*(b-q))/q*Int[1/((b-q+2*c*x)*Sqrt[d+f*x^2]),x] -
  (2*c*g-h*(b+q))/q*Int[1/((b+q+2*c*x)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c] && PosQ[b^2-4*a*c]


Int[(g_.+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f),2]},
  1/(2*q)*Int[Simp[h*(b*d-a*e)-g*(c*d-a*f-q)-(g*(c*e-b*f)-h*(c*d-a*f+q))*x,x]/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] - 
  1/(2*q)*Int[Simp[h*(b*d-a*e)-g*(c*d-a*f+q)-(g*(c*e-b*f)-h*(c*d-a*f-q))*x,x]/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && NeQ[b*d-a*e] && NegQ[b^2-4*a*c]


Int[(g_.+h_.*x_)/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2+a*c*e^2,2]},
  1/(2*q)*Int[Simp[-a*h*e-g*(c*d-a*f-q)+(h*(c*d-a*f+q)-g*c*e)*x,x]/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x] - 
  1/(2*q)*Int[Simp[-a*h*e-g*(c*d-a*f+q)+(h*(c*d-a*f-q)-g*c*e)*x,x]/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,c,d,e,f,g,h},x] && NeQ[e^2-4*d*f] && NegQ[-a*c]


Int[(g_.+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  With[{q=Rt[(c*d-a*f)^2+b^2*d*f,2]},
  1/(2*q)*Int[Simp[h*b*d-g*(c*d-a*f-q)+(h*(c*d-a*f+q)+g*b*f)*x,x]/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x] - 
  1/(2*q)*Int[Simp[h*b*d-g*(c*d-a*f+q)+(h*(c*d-a*f-q)+g*b*f)*x,x]/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c] && NegQ[b^2-4*a*c]


Int[(g_.+h_.*x_)/(Sqrt[a_+b_.*x_+c_.*x_^2]*Sqrt[d_+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{s=Rt[b^2-4*a*c,2],t=Rt[e^2-4*d*f,2]},
  Sqrt[b+s+2*c*x]*Sqrt[2*a+(b+s)*x]*Sqrt[e+t+2*f*x]*Sqrt[2*d+(e+t)*x]/(Sqrt[a+b*x+c*x^2]*Sqrt[d+e*x+f*x^2])*
    Int[(g+h*x)/(Sqrt[b+s+2*c*x]*Sqrt[2*a+(b+s)*x]*Sqrt[e+t+2*f*x]*Sqrt[2*d+(e+t)*x]),x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(g_.+h_.*x_)/(Sqrt[a_+b_.*x_+c_.*x_^2]*Sqrt[d_+f_.*x_^2]),x_Symbol] :=
  With[{s=Rt[b^2-4*a*c,2],t=Rt[-4*d*f,2]},
  Sqrt[b+s+2*c*x]*Sqrt[2*a+(b+s)*x]*Sqrt[t+2*f*x]*Sqrt[2*d+t*x]/(Sqrt[a+b*x+c*x^2]*Sqrt[d+f*x^2])*
    Int[(g+h*x)/(Sqrt[b+s+2*c*x]*Sqrt[2*a+(b+s)*x]*Sqrt[t+2*f*x]*Sqrt[2*d+t*x]),x]] /;
FreeQ[{a,b,c,d,f,g,h},x] && NeQ[b^2-4*a*c]


Int[(g_.+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)^(1/3)*(d_.+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=(-9*c*h^2/(2*c*g-b*h)^2)^(1/3)},
  Sqrt[3]*h*q*ArcTan[1/Sqrt[3]-2^(2/3)*(1-(3*h*(b+2*c*x))/(2*c*g-b*h))^(2/3)/(Sqrt[3]*(1+(3*h*(b+2*c*x))/(2*c*g-b*h))^(1/3))]/f + 
  h*q*Log[d+e*x+f*x^2]/(2*f) - 
  3*h*q*Log[(1-3*h*(b+2*c*x)/(2*c*g-b*h))^(2/3)+2^(1/3)*(1+3*h*(b+2*c*x)/(2*c*g-b*h))^(1/3)]/(2*f)] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && EqQ[c*e-b*f] && EqQ[c^2*d-f*(b^2-3*a*c)] && EqQ[c^2*g^2-b*c*g*h-2*b^2*h^2+9*a*c*h^2] && 
  PositiveQ[-9*c*h^2/(2*c*g-b*h)^2]


Int[(g_.+h_.*x_)/((a_.+b_.*x_+c_.*x_^2)^(1/3)*(d_.+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=-c/(b^2-4*a*c)},
  (q*(a+b*x+c*x^2))^(1/3)/(a+b*x+c*x^2)^(1/3)*Int[(g+h*x)/((q*a+b*q*x+c*q*x^2)^(1/3)*(d+e*x+f*x^2)),x]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && EqQ[c*e-b*f] && EqQ[c^2*d-f*(b^2-3*a*c)] && EqQ[c^2*g^2-b*c*g*h-2*b^2*h^2+9*a*c*h^2] && 
  Not[PositiveQ[4*a-b^2/c]]


Int[(a_.+b_.*x_+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  Defer[Int][(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q*(g+h*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x]


Int[(a_.+c_.*x_^2)^p_*(d_.+e_.*x_+f_.*x_^2)^q_*(g_.+h_.*x_),x_Symbol] :=
  Defer[Int][(a+c*x^2)^p*(d+e*x+f*x^2)^q*(g+h*x),x] /;
FreeQ[{a,c,d,e,f,g,h,p,q},x]


Int[(g_.+h_.*u_)^m_.*(a_.+b_.*u_+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(g+h*x)^m*(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q,x],x,u] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(g_.+h_.*u_)^m_.*(a_.+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(g+h*x)^m*(a+c*x^2)^p*(d+e*x+f*x^2)^q,x],x,u] /;
FreeQ[{a,c,d,e,f,g,h,m,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(d_+e_.*x_)^m_.*(f_+g_.*x_)^n_.*(h_.+i_.*x_)^q_.*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(h+i*x)^q*(d*f+e*g*x^2)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,m,n,p,q},x] && EqQ[e*f+d*g] && EqQ[m-n] && (IntegerQ[m] || PositiveQ[d] && PositiveQ[f])


Int[(d_.+e_.*x_)^m_.*(f_.+g_.*x_)^n_.*(h_.+i_.*x_)^q_.*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*(f+g*x)^n*(h+i*x)^q*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,m,n,p,q},x] && PositiveIntegerQ[p] && NegativeIntegerQ[m]


Int[(d_+e_.*x_)^m_*(f_+g_.*x_)^n_*(h_.+i_.*x_)^q_.*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  (d+e*x)^FracPart[m]*(f+g*x)^FracPart[m]/(d*f+e*g*x^2)^FracPart[m]*Int[(h+i*x)^q*(d*f+e*g*x^2)^m*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,m,n,p,q},x] && EqQ[e*f+d*g] && EqQ[m-n]





(* ::Subsection::Closed:: *)
(*1.2.1.7 (a+b x+c x^2)^p (d+e x+f x^2)^q (A+B x+C x^2)*)


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (c/f)^p*Int[(d+e*x+f*x^2)^(p+q)*(A+B*x+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,B,C,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && (IntegerQ[p] || PositiveQ[c/f]) && 
  (Not[IntegerQ[q]] || LeafCount[d+e*x+f*x^2]<=LeafCount[a+b*x+c*x^2])


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.*(A_.+C_.*x_^2),x_Symbol] :=
  (c/f)^p*Int[(d+e*x+f*x^2)^(p+q)*(A+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,C,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && (IntegerQ[p] || PositiveQ[c/f]) && 
  (Not[IntegerQ[q]] || LeafCount[d+e*x+f*x^2]<=LeafCount[a+b*x+c*x^2])


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  a^IntPart[p]*(a+b*x+c*x^2)^FracPart[p]/(d^IntPart[p]*(d+e*x+f*x^2)^FracPart[p])*Int[(d+e*x+f*x^2)^(p+q)*(A+B*x+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,B,C,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && Not[IntegerQ[p]] && Not[IntegerQ[q]] && Not[PositiveQ[c/f]]


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_+e_.*x_+f_.*x_^2)^q_.*(A_.+C_.*x_^2),x_Symbol] :=
  a^IntPart[p]*(a+b*x+c*x^2)^FracPart[p]/(d^IntPart[p]*(d+e*x+f*x^2)^FracPart[p])*Int[(d+e*x+f*x^2)^(p+q)*(A+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,C,p,q},x] && EqQ[c*d-a*f] && EqQ[b*d-a*e] && Not[IntegerQ[p]] && Not[IntegerQ[q]] && Not[PositiveQ[c/f]]


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_.+e_.*x_+f_.*x_^2)^q_.*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+e*x+f*x^2)^q*(A+B*x+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,B,C,p,q},x] && EqQ[b^2-4*a*c]


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_.+e_.*x_+f_.*x_^2)^q_.*(A_.+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+e*x+f*x^2)^q*(A+C*x^2),x] /;
FreeQ[{a,b,c,d,e,f,A,C,p,q},x] && EqQ[b^2-4*a*c]


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_.+f_.*x_^2)^q_.*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+f*x^2)^q*(A+B*x+C*x^2),x] /;
FreeQ[{a,b,c,d,f,A,B,C,p,q},x] && EqQ[b^2-4*a*c]


Int[(a_+b_.*x_+c_.*x_^2)^p_.*(d_.+f_.*x_^2)^q_.*(A_.+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(b+2*c*x)^(2*p)*(d+f*x^2)^q*(A+C*x^2),x] /;
FreeQ[{a,b,c,d,f,A,C,p,q},x] && EqQ[b^2-4*a*c]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (A*b*c-2*a*B*c+a*b*C-(c*(b*B-2*A*c)-C*(b^2-2*a*c))*x)*(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/(c*(b^2-4*a*c)*(p+1)) - 
  1/(c*(b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[e*q*(A*b*c-2*a*B*c+a*b*C)-d*(c*(b*B-2*A*c)*(2*p+3)+C*(2*a*c-b^2*(p+2)))+
        (2*f*q*(A*b*c-2*a*B*c+a*b*C)-e*(c*(b*B-2*A*c)*(2*p+q+3)+C*(2*a*c*(q+1)-b^2*(p+q+2))))*x-
        f*(c*(b*B-2*A*c)*(2*p+2*q+3)+C*(2*a*c*(2*q+1)-b^2*(p+2*q+2)))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,A,B,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (A*b*c+a*b*C+(2*A*c^2+C*(b^2-2*a*c))*x)*(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/(c*(b^2-4*a*c)*(p+1)) - 
  1/(c*(b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[A*c*(2*c*d*(2*p+3)+b*e*q)-C*(2*a*c*d-b^2*d*(p+2)-a*b*e*q)+
        (C*(2*a*b*f*q-2*a*c*e*(q+1)+b^2*e*(p+q+2))+2*A*c*(b*f*q+c*e*(2*p+q+3)))*x-
        f*(-2*A*c^2*(2*p+2*q+3)+C*(2*a*c*(2*q+1)-b^2*(p+2*q+2)))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,A,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a*B-(A*c-a*C)*x)*(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/(2*a*c*(p+1)) - 
  2/((-4*a*c)*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[A*c*d*(2*p+3)-a*(C*d+B*e*q)+(A*c*e*(2*p+q+3)-a*(2*B*f*q+C*e*(q+1)))*x-f*(a*C*(2*q+1)-A*c*(2*p+2*q+3))*x^2,x],x] /;
FreeQ[{a,c,d,e,f,A,B,C},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  -(A*c-a*C)*x*(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q/(2*a*c*(p+1)) + 
  2/(4*a*c*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q-1)*
      Simp[A*c*d*(2*p+3)-a*C*d+(A*c*e*(2*p+q+3)-a*C*e*(q+1))*x-f*(a*C*(2*q+1)-A*c*(2*p+2*q+3))*x^2,x],x] /;
FreeQ[{a,c,d,e,f,A,C},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (A*b*c-2*a*B*c+a*b*C-(c*(b*B-2*A*c)-C*(b^2-2*a*c))*x)*(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q/(c*(b^2-4*a*c)*(p+1)) - 
  1/(c*(b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q-1)*
      Simp[-d*(c*(b*B-2*A*c)*(2*p+3)+C*(2*a*c-b^2*(p+2)))+
        (2*f*q*(A*b*c-2*a*B*c+a*b*C))*x-
        f*(c*(b*B-2*A*c)*(2*p+2*q+3)+C*(2*a*c*(2*q+1)-b^2*(p+2*q+2)))*x^2,x],x] /;
FreeQ[{a,b,c,d,f,A,B,C},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (A*b*c+a*b*C+(2*A*c^2+C*(b^2-2*a*c))*x)*(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q/(c*(b^2-4*a*c)*(p+1)) - 
  1/(c*(b^2-4*a*c)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q-1)*
      Simp[A*c*(2*c*d*(2*p+3))-C*(2*a*c*d-b^2*d*(p+2))+
        (C*(2*a*b*f*q)+2*A*c*(b*f*q))*x-
        f*(-2*A*c^2*(2*p+2*q+3)+C*(2*a*c*(2*q+1)-b^2*(p+2*q+2)))*x^2,x],x] /;
FreeQ[{a,b,c,d,f,A,C},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && GtQ[q,0] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    ((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b-a*B)*(2*c^2*d+b^2*f-c*(b*e+2*a*f))+
      c*(A*(2*c^2*d+b^2*f-c*(b*e+2*a*f))-B*(b*c*d-2*a*c*e+a*b*f)+C*(b^2*d-a*b*e-2*a*(c*d-a*f)))*x) + 
  1/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(b*B-2*A*c-2*a*C)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)+
        (b^2*(C*d+A*f)-b*(B*c*d+A*c*e+a*C*e+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        e*((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b-a*B)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
        (2*f*((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b-a*B)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
          (b^2*(C*d+A*f)-b*(B*c*d+A*c*e+a*C*e+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*
          (b*f*(p+1)-c*e*(2*p+q+4)))*x-
        c*f*(b^2*(C*d+A*f)-b*(B*c*d+A*c*e+a*C*e+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,e,f,A,B,C,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && 
  NeQ[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f)] && Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    ((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b)*(2*c^2*d+b^2*f-c*(b*e+2*a*f))+
      c*(A*(2*c^2*d+b^2*f-c*(b*e+2*a*f))+C*(b^2*d-a*b*e-2*a*(c*d-a*f)))*x) + 
  1/((b^2-4*a*c)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(-2*A*c-2*a*C)*((c*d-a*f)^2-(b*d-a*e)*(c*e-b*f))*(p+1)+
        (b^2*(C*d+A*f)-b*(+A*c*e+a*C*e)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        e*((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
        (2*f*((A*c-a*C)*(2*a*c*e-b*(c*d+a*f))+(A*b)*(2*c^2*d+b^2*f-c*(b*e+2*a*f)))*(p+q+2)-
          (b^2*(C*d+A*f)-b*(A*c*e+a*C*e)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*
          (b*f*(p+1)-c*e*(2*p+q+4)))*x-
        c*f*(b^2*(C*d+A*f)-b*(A*c*e+a*C*e)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,e,f,A,C,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && LtQ[p,-1] && 
  NeQ[(c*d-a*f)^2-(b*d-a*e)*(c*e-b*f)] && Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    ((A*c-a*C)*(2*a*c*e)+(-a*B)*(2*c^2*d-c*(2*a*f))+
      c*(A*(2*c^2*d-c*(2*a*f))-B*(-2*a*c*e)+C*(-2*a*(c*d-a*f)))*x) + 
  1/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(-2*A*c-2*a*C)*((c*d-a*f)^2-(-a*e)*(c*e))*(p+1)+
        (2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        e*((A*c-a*C)*(2*a*c*e)+(-a*B)*(2*c^2*d-c*(+2*a*f)))*(p+q+2)-
        (2*f*((A*c-a*C)*(2*a*c*e)+(-a*B)*(2*c^2*d+-c*(+2*a*f)))*(p+q+2)-
          (2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*
          (-c*e*(2*p+q+4)))*x-
        c*f*(2*(A*c*(c*d-a*f)-a*(c*C*d-B*c*e-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,c,d,e,f,A,B,C,q},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && NeQ[a*c*e^2+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (a+c*x^2)^(p+1)*(d+e*x+f*x^2)^(q+1)/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    ((A*c-a*C)*(2*a*c*e)+c*(A*(2*c^2*d-c*(2*a*f))+C*(-2*a*(c*d-a*f)))*x) + 
  1/((-4*a*c)*(a*c*e^2+(c*d-a*f)^2)*(p+1))*
    Int[(a+c*x^2)^(p+1)*(d+e*x+f*x^2)^q*
      Simp[(-2*A*c-2*a*C)*((c*d-a*f)^2-(-a*e)*(c*e))*(p+1)+
        (2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        e*((A*c-a*C)*(2*a*c*e))*(p+q+2)-
        (2*f*((A*c-a*C)*(2*a*c*e))*(p+q+2)-(2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(-c*e*(2*p+q+4)))*x-
        c*f*(2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,c,d,e,f,A,C,q},x] && NeQ[e^2-4*d*f] && LtQ[p,-1] && NeQ[a*c*e^2+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q+1)/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    ((A*c-a*C)*(-b*(c*d+a*f))+(A*b-a*B)*(2*c^2*d+b^2*f-c*(2*a*f))+
      c*(A*(2*c^2*d+b^2*f-c*(2*a*f))-B*(b*c*d+a*b*f)+C*(b^2*d-2*a*(c*d-a*f)))*x) + 
  1/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q*
      Simp[(b*B-2*A*c-2*a*C)*((c*d-a*f)^2-(b*d)*(-b*f))*(p+1)+
        (b^2*(C*d+A*f)-b*(B*c*d+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        (2*f*((A*c-a*C)*(-b*(c*d+a*f))+(A*b-a*B)*(2*c^2*d+b^2*f-c*(2*a*f)))*(p+q+2)-
          (b^2*(C*d+A*f)-b*(B*c*d+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*
          (b*f*(p+1)))*x-
        c*f*(b^2*(C*d+A*f)-b*(B*c*d+a*B*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,f,A,B,C,q},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && NeQ[b^2*d*f+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (a+b*x+c*x^2)^(p+1)*(d+f*x^2)^(q+1)/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    ((A*c-a*C)*(-b*(c*d+a*f))+(A*b)*(2*c^2*d+b^2*f-c*(2*a*f))+
      c*(A*(2*c^2*d+b^2*f-c*(2*a*f))+C*(b^2*d-2*a*(c*d-a*f)))*x) + 
  1/((b^2-4*a*c)*(b^2*d*f+(c*d-a*f)^2)*(p+1))*
    Int[(a+b*x+c*x^2)^(p+1)*(d+f*x^2)^q*
      Simp[(-2*A*c-2*a*C)*((c*d-a*f)^2-(b*d)*(-b*f))*(p+1)+
        (b^2*(C*d+A*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(a*f*(p+1)-c*d*(p+2))-
        (2*f*((A*c-a*C)*(-b*(c*d+a*f))+(A*b)*(2*c^2*d+b^2*f-c*(2*a*f)))*(p+q+2)-
          (b^2*(C*d+A*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*
          (b*f*(p+1)))*x-
        c*f*(b^2*(C*d+A*f)+2*(A*c*(c*d-a*f)-a*(c*C*d-a*C*f)))*(2*p+2*q+5)*x^2,x],x]/;
FreeQ[{a,b,c,d,f,A,C,q},x] && NeQ[b^2-4*a*c] && LtQ[p,-1] && NeQ[b^2*d*f+(c*d-a*f)^2] && 
  Not[Not[IntegerQ[p]] && ILtQ[q,-1]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (B*c*f*(2*p+2*q+3)+C*(b*f*p-c*e*(2*p+q+2))+2*c*C*f*(p+q+1)*x)*(a+b*x+c*x^2)^p*
    (d+e*x+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[p*(b*d-a*e)*(C*(c*e-b*f)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(b^2*C*d*f*p+a*c*(C*(2*d*f-e^2*(2*p+q+2))+f*(B*e-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(c*e-b*f)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(C*e*f*p*(b^2-4*a*c)-b*c*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d-B*e+2*A*f)*(2*p+2*q+3))))*x+
        (p*(c*e-b*f)*(C*(c*e-b*f)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(C*f^2*p*(b^2-4*a*c)-c^2*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d-B*e+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,A,B,C,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && GtQ[p,0] && 
  NeQ[p+q+1] && NeQ[2*p+2*q+3] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (C*(b*f*p-c*e*(2*p+q+2))+2*c*C*f*(p+q+1)*x)*(a+b*x+c*x^2)^p*
    (d+e*x+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[p*(b*d-a*e)*(C*(c*e-b*f)*(q+1)-c*(C*e)*(2*p+2*q+3))+
          (p+q+1)*(b^2*C*d*f*p+a*c*(C*(2*d*f-e^2*(2*p+q+2))+f*(-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(c*e-b*f)*(q+1)-c*(C*e)*(2*p+2*q+3))+
          (p+q+1)*(C*e*f*p*(b^2-4*a*c)-b*c*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x+
        (p*(c*e-b*f)*(C*(c*e-b*f)*(q+1)-c*(C*e)*(2*p+2*q+3))+
          (p+q+1)*(C*f^2*p*(b^2-4*a*c)-c^2*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,A,C,q},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f] && GtQ[p,0] && 
  NeQ[p+q+1] && NeQ[2*p+2*q+3] && Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (B*c*f*(2*p+2*q+3)+C*(-c*e*(2*p+q+2))+2*c*C*f*(p+q+1)*x)*(a+c*x^2)^p*
    (d+e*x+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[p*(-a*e)*(C*(c*e)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(a*c*(C*(2*d*f-e^2*(2*p+q+2))+f*(B*e-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(c*e)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(C*e*f*p*(-4*a*c)))*x+
        (p*(c*e)*(C*(c*e)*(q+1)-c*(C*e-B*f)*(2*p+2*q+3))+
          (p+q+1)*(C*f^2*p*(-4*a*c)-c^2*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d-B*e+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,c,d,e,f,A,B,C,q},x] && NeQ[e^2-4*d*f] && GtQ[p,0] && NeQ[p+q+1] && NeQ[2*p+2*q+3] && 
 Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+c_.*x_^2)^p_*(d_+e_.*x_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (C*(-c*e*(2*p+q+2))+2*c*C*f*(p+q+1)*x)*(a+c*x^2)^p*(d+e*x+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+c*x^2)^(p-1)*(d+e*x+f*x^2)^q*
      Simp[p*(-a*e)*(C*(c*e)*(q+1)-c*(C*e)*(2*p+2*q+3))+(p+q+1)*(a*c*(C*(2*d*f-e^2*(2*p+q+2))+f*(-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(c*e)*(q+1)-c*(C*e)*(2*p+2*q+3))+(p+q+1)*(C*e*f*p*(-4*a*c)))*x+
        (p*(c*e)*(C*(c*e)*(q+1)-c*(C*e)*(2*p+2*q+3))+
          (p+q+1)*(C*f^2*p*(-4*a*c)-c^2*(C*(e^2-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,c,d,e,f,A,C,q},x] && NeQ[e^2-4*d*f] && GtQ[p,0] && NeQ[p+q+1] && NeQ[2*p+2*q+3] && 
 Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+B_.*x_+C_.*x_^2),x_Symbol] :=
  (B*c*f*(2*p+2*q+3)+C*(b*f*p)+2*c*C*f*(p+q+1)*x)*(a+b*x+c*x^2)^p*
    (d+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+f*x^2)^q*
      Simp[p*(b*d)*(C*(-b*f)*(q+1)-c*(-B*f)*(2*p+2*q+3))+
          (p+q+1)*(b^2*C*d*f*p+a*c*(C*(2*d*f)+f*(-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(-b*f)*(q+1)-c*(-B*f)*(2*p+2*q+3))+
          (p+q+1)*(-b*c*(C*(-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x+
        (p*(-b*f)*(C*(-b*f)*(q+1)-c*(-B*f)*(2*p+2*q+3))+
          (p+q+1)*(C*f^2*p*(b^2-4*a*c)-c^2*(C*(-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,b,c,d,f,A,B,C,q},x] && NeQ[b^2-4*a*c] && GtQ[p,0] && NeQ[p+q+1] && NeQ[2*p+2*q+3] && 
 Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(a_+b_.*x_+c_.*x_^2)^p_*(d_+f_.*x_^2)^q_*(A_.+C_.*x_^2),x_Symbol] :=
  (C*(b*f*p)+2*c*C*f*(p+q+1)*x)*(a+b*x+c*x^2)^p*
    (d+f*x^2)^(q+1)/(2*c*f^2*(p+q+1)*(2*p+2*q+3)) - 
  (1/(2*c*f^2*(p+q+1)*(2*p+2*q+3)))*
    Int[(a+b*x+c*x^2)^(p-1)*(d+f*x^2)^q*
      Simp[p*(b*d)*(C*(-b*f)*(q+1))+
          (p+q+1)*(b^2*C*d*f*p+a*c*(C*(2*d*f)+f*(-2*A*f)*(2*p+2*q+3)))+
        (2*p*(c*d-a*f)*(C*(-b*f)*(q+1))+
          (p+q+1)*(-b*c*(C*(-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x+
        (p*(-b*f)*(C*(-b*f)*(q+1))+
          (p+q+1)*(C*f^2*p*(b^2-4*a*c)-c^2*(C*(-4*d*f)*(2*p+q+2)+f*(2*C*d+2*A*f)*(2*p+2*q+3))))*x^2,x],x] /;
FreeQ[{a,b,c,d,f,A,C,q},x] && NeQ[b^2-4*a*c] && GtQ[p,0] && NeQ[p+q+1] && NeQ[2*p+2*q+3] && 
 Not[IGtQ[p,0]] && Not[IGtQ[q,0]]


Int[(A_.+B_.*x_+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*(d_+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2-b*c*d*e+a*c*e^2+b^2*d*f-2*a*c*d*f-a*b*e*f+a^2*f^2},
  1/q*Int[(A*c^2*d-a*c*C*d-A*b*c*e+a*B*c*e+A*b^2*f-a*b*B*f-a*A*c*f+a^2*C*f+
    c*(B*c*d-b*C*d-A*c*e+a*C*e+A*b*f-a*B*f)*x)/(a+b*x+c*x^2),x] + 
  1/q*Int[(c*C*d^2-B*c*d*e+A*c*e^2+b*B*d*f-A*c*d*f-a*C*d*f-A*b*e*f+a*A*f^2-
    f*(B*c*d-b*C*d-A*c*e+a*C*e+A*b*f-a*B*f)*x)/(d+e*x+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,e,f,A,B,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(A_.+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*(d_+e_.*x_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2-b*c*d*e+a*c*e^2+b^2*d*f-2*a*c*d*f-a*b*e*f+a^2*f^2},
  1/q*Int[(A*c^2*d-a*c*C*d-A*b*c*e+A*b^2*f-a*A*c*f+a^2*C*f+
    c*(-b*C*d-A*c*e+a*C*e+A*b*f)*x)/(a+b*x+c*x^2),x] + 
  1/q*Int[(c*C*d^2+A*c*e^2-A*c*d*f-a*C*d*f-A*b*e*f+a*A*f^2-
    f*(-b*C*d-A*c*e+a*C*e+A*b*f)*x)/(d+e*x+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,e,f,A,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(A_.+B_.*x_+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*(d_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2+b^2*d*f-2*a*c*d*f+a^2*f^2},
  1/q*Int[(A*c^2*d-a*c*C*d+A*b^2*f-a*b*B*f-a*A*c*f+a^2*C*f+c*(B*c*d-b*C*d+A*b*f-a*B*f)*x)/(a+b*x+c*x^2),x] + 
  1/q*Int[(c*C*d^2+b*B*d*f-A*c*d*f-a*C*d*f+a*A*f^2-f*(B*c*d-b*C*d+A*b*f-a*B*f)*x)/(d+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,f,A,B,C},x] && NeQ[b^2-4*a*c]


Int[(A_.+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*(d_+f_.*x_^2)),x_Symbol] :=
  With[{q=c^2*d^2+b^2*d*f-2*a*c*d*f+a^2*f^2},
  1/q*Int[(A*c^2*d-a*c*C*d+A*b^2*f-a*A*c*f+a^2*C*f+c*(-b*C*d+A*b*f)*x)/(a+b*x+c*x^2),x] + 
  1/q*Int[(c*C*d^2-A*c*d*f-a*C*d*f+a*A*f^2-f*(-b*C*d+A*b*f)*x)/(d+f*x^2),x] /;
 NeQ[q]] /;
FreeQ[{a,b,c,d,f,A,C},x] && NeQ[b^2-4*a*c]


Int[(A_.+B_.*x_+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+e*x+f*x^2],x] + 
  1/c*Int[(A*c-a*C+(B*c-b*C)*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f,A,B,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(A_.+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+e*x+f*x^2],x] + 1/c*Int[(A*c-a*C-b*C*x)/((a+b*x+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f,A,C},x] && NeQ[b^2-4*a*c] && NeQ[e^2-4*d*f]


Int[(A_.+B_.*x_+C_.*x_^2)/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+e*x+f*x^2],x] + 1/c*Int[(A*c-a*C+B*c*x)/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,c,d,e,f,A,B,C},x] && NeQ[e^2-4*d*f]


Int[(A_.+C_.*x_^2)/((a_+c_.*x_^2)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+e*x+f*x^2],x] + (A*c-a*C)/c*Int[1/((a+c*x^2)*Sqrt[d+e*x+f*x^2]),x] /;
FreeQ[{a,c,d,e,f,A,C},x] && NeQ[e^2-4*d*f]


Int[(A_.+B_.*x_+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+f*x^2],x] + 1/c*Int[(A*c-a*C+(B*c-b*C)*x)/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x] /;
FreeQ[{a,b,c,d,f,A,B,C},x] && NeQ[b^2-4*a*c]


Int[(A_.+C_.*x_^2)/((a_+b_.*x_+c_.*x_^2)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  C/c*Int[1/Sqrt[d+f*x^2],x] + 1/c*Int[(A*c-a*C-b*C*x)/((a+b*x+c*x^2)*Sqrt[d+f*x^2]),x] /;
FreeQ[{a,b,c,d,f,A,C},x] && NeQ[b^2-4*a*c]


Int[(a_.+b_.*u_+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+B_.*u_+C_.*u_^2),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q*(A+B*x+C*x^2),x],x,u] /;
FreeQ[{a,b,c,d,e,f,A,B,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+b_.*u_+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+B_.*u_),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q*(A+B*x),x],x,u] /;
FreeQ[{a,b,c,d,e,f,A,B,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+b_.*u_+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+C_.*u_^2),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x+c*x^2)^p*(d+e*x+f*x^2)^q*(A+C*x^2),x],x,u] /;
FreeQ[{a,b,c,d,e,f,A,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+B_.*u_+C_.*u_^2),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+c*x^2)^p*(d+e*x+f*x^2)^q*(A+B*x+C*x^2),x],x,u] /;
FreeQ[{a,c,d,e,f,A,B,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+B_.*u_),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+c*x^2)^p*(d+e*x+f*x^2)^q*(A+B*x),x],x,u] /;
FreeQ[{a,c,d,e,f,A,B,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]


Int[(a_.+c_.*u_^2)^p_.*(d_.+e_.*u_+f_.*u_^2)^q_.*(A_.+C_.*u_^2),x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+c*x^2)^p*(d+e*x+f*x^2)^q*(A+C*x^2),x],x,u] /;
FreeQ[{a,c,d,e,f,A,C,p,q},x] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.1.9 (d+e x)^m Pq(x) (a+b x+c x^2)^p*)


Int[x_^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  1/2*Subst[Int[x^((m-1)/2)*SubstFor[x^2,Pq,x]*(a+c*x)^p,x],x,x^2] /;
FreeQ[{a,c,p},x] && PolyQ[Pq,x^2] && IntegerQ[(m-1)/2]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+1)*PolynomialQuotient[Pq,d+e*x,x]*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[PolynomialRemainder[Pq,d+e*x,x]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+1)*PolynomialQuotient[Pq,d+e*x,x]*(a+c*x^2)^p,x] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[PolynomialRemainder[Pq,d+e*x,x]]


Int[(d_.+e_.*x_)^m_.*P2_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{f=Coeff[P2,x,0],g=Coeff[P2,x,1],h=Coeff[P2,x,2]},
  h*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)/(c*e*(m+2*p+3)) /;
 EqQ[b*e*h*(m+p+2)+2*c*d*h*(p+1)-c*e*g*(m+2*p+3)] && EqQ[b*d*h*(p+1)+a*e*h*(m+1)-c*e*f*(m+2*p+3)]] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[P2,x,2] && NeQ[m+2*p+3]


Int[(d_.+e_.*x_)^m_.*P2_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{f=Coeff[P2,x,0],g=Coeff[P2,x,1],h=Coeff[P2,x,2]},
  h*(d+e*x)^(m+1)*(a+c*x^2)^(p+1)/(c*e*(m+2*p+3)) /;
 EqQ[2*d*h*(p+1)-e*g*(m+2*p+3)] && EqQ[a*h*(m+1)-c*f*(m+2*p+3)]] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[P2,x,2] && NeQ[m+2*p+3]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*Pq*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c,d,e,m},x] && PolyQ[Pq,x] && IGtQ[p,-2]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x)^m*Pq*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c,d,e,m},x] && PolyQ[Pq,x] && IGtQ[p,-2]


Int[(d_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  1/d*Int[(d*x)^(m+1)*ExpandToSum[Pq/x,x]*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[(d+e*x)^m*Pq*(b+2*c*x)^(2*p),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[b^2-4*a*c,0]


Int[(e_.*x_)^m_.*Pq_*(b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(e*x)^(m-1)*ExpandToSum[e*Pq/(b+c*x),x]*(b*x+c*x^2)^(p+1),x] /;
FreeQ[{b,c,e,m,p},x] && PolyQ[Pq,x] && EqQ[PolynomialRemainder[Pq,b+c*x,x]]


Int[(d_+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m-1)*ExpandToSum[d*e*Pq/(a*e+c*d*x),x]*(a+b*x+c*x^2)^(p+1),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && EqQ[PolynomialRemainder[Pq,a*e+c*d*x,x]]


Int[(d_+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m-1)*ExpandToSum[d*e*Pq/(a*e+c*d*x),x]*(a+c*x^2)^(p+1),x] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[c*d^2+a*e^2,0] && EqQ[PolynomialRemainder[Pq,a*e+c*d*x,x]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],f=Coeff[Pq,x,Expon[Pq,x]]},
  f*(d+e*x)^(m+q-1)*(a+b*x+c*x^2)^(p+1)/(c*e^(q-1)*(m+q+2*p+1)) + 
  1/(c*e^q*(m+q+2*p+1))*Int[(d+e*x)^m*(a+b*x+c*x^2)^p*
    ExpandToSum[c*e^q*(m+q+2*p+1)*Pq-c*f*(m+q+2*p+1)*(d+e*x)^q+e*f*(m+p+q)*(d+e*x)^(q-2)*(b*d-2*a*e+(2*c*d-b*e)*x),x],x] /;
 NeQ[m+q+2*p+1]] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0]


Int[(d_+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],f=Coeff[Pq,x,Expon[Pq,x]]},
  f*(d+e*x)^(m+q-1)*(a+c*x^2)^(p+1)/(c*e^(q-1)*(m+q+2*p+1)) + 
  1/(c*e^q*(m+q+2*p+1))*Int[(d+e*x)^m*(a+c*x^2)^p*
    ExpandToSum[c*e^q*(m+q+2*p+1)*Pq-c*f*(m+q+2*p+1)*(d+e*x)^q-2*e*f*(m+p+q)*(d+e*x)^(q-2)*(a*e-c*d*x),x],x] /;
 NeQ[m+q+2*p+1]] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[c*d^2+a*e^2,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p*Pq,x] /;
FreeQ[{a,b,c,d,e,m},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && IntegerQ[p]


Int[(d_+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p*Pq,x] /;
FreeQ[{a,c,d,e,m},x] && PolyQ[Pq,x] && EqQ[c*d^2+a*e^2,0] && IntegerQ[p]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p*Pq,x] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2,0] && Not[IntegerQ[p]]


Int[(d_+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  (a+c*x^2)^FracPart[p]/((d+e*x)^FracPart[p]*(a/d+(c*x)/e)^FracPart[p])*Int[(d+e*x)^(m+p)*(a/d+c/e*x)^p*Pq,x] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && EqQ[c*d^2+a*e^2,0] && Not[IntegerQ[p]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(a+b*x+c*x^2)^p*ExpandIntegrand[(d+e*x)^m*Pq,x],x] /;
FreeQ[{a,b,c,d,e},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[p,-1] && IGtQ[m,0] && RationalQ[a,b,c,d,e] && Not[IntegerQ[p]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[(a+c*x^2)^p*ExpandIntegrand[(d+e*x)^m*Pq,x],x] /;
FreeQ[{a,c,d,e},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0] && LtQ[p,-1] && IGtQ[m,0] && RationalQ[a,c,d,e] && Not[IntegerQ[p]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+b*x+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,1]},
  (d+e*x)^m*(a+b*x+c*x^2)^(p+1)*(f*b-2*a*g+(2*c*f-b*g)*x)/((p+1)*(b^2-4*a*c)) + 
  1/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^(m-1)*(a+b*x+c*x^2)^(p+1)*
    ExpandToSum[(p+1)*(b^2-4*a*c)*(d+e*x)*Q+g*(2*a*e*m+b*d*(2*p+3))-f*(b*e*m+2*c*d*(2*p+3))-e*(2*c*f-b*g)*(m+2*p+3)*x,x],x]] /;
FreeQ[{a,b,c,d,e},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[p,-1] && GtQ[m,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,1]},
  (d+e*x)^m*(a+c*x^2)^(p+1)*(a*g-c*f*x)/(2*a*c*(p+1)) + 
  1/(2*a*c*(p+1))*Int[(d+e*x)^(m-1)*(a+c*x^2)^(p+1)*
    ExpandToSum[2*a*c*(p+1)*(d+e*x)*Q-a*e*g*m+c*d*f*(2*p+3)+c*e*f*(m+2*p+3)*x,x],x]] /;
FreeQ[{a,c,d,e},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0] && LtQ[p,-1] && GtQ[m,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[(d+e*x)^m*Pq,a+b*x+c*x^2,x],
        f=Coeff[PolynomialRemainder[(d+e*x)^m*Pq,a+b*x+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[(d+e*x)^m*Pq,a+b*x+c*x^2,x],x,1]},
  (b*f-2*a*g+(2*c*f-b*g)*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) + 
  1/((p+1)*(b^2-4*a*c))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p+1)*
    ExpandToSum[(p+1)*(b^2-4*a*c)*(d+e*x)^(-m)*Q-(2*p+3)*(2*c*f-b*g)*(d+e*x)^(-m),x],x]] /;
FreeQ[{a,b,c,d,e},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[p,-1] && ILtQ[m,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[(d+e*x)^m*Pq,a+c*x^2,x],
        f=Coeff[PolynomialRemainder[(d+e*x)^m*Pq,a+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[(d+e*x)^m*Pq,a+c*x^2,x],x,1]},
  (a*g-c*f*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) + 
  1/(2*a*c*(p+1))*Int[(d+e*x)^m*(a+c*x^2)^(p+1)*
    ExpandToSum[2*a*c*(p+1)*(d+e*x)^(-m)*Q+c*f*(2*p+3)*(d+e*x)^(-m),x],x]] /;
FreeQ[{a,c,d,e},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0] && LtQ[p,-1] && ILtQ[m,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+b*x+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,1]},
  (d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1)*(f*(b*c*d-b^2*e+2*a*c*e)-a*g*(2*c*d-b*e)+c*(f*(2*c*d-b*e)-g*(b*d-2*a*e))*x)/
    ((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2)) + 
  1/((p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^m*(a+b*x+c*x^2)^(p+1)*
   ExpandToSum[(p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2)*Q+
      f*(b*c*d*e*(2*p-m+2)+b^2*e^2*(p+m+2)-2*c^2*d^2*(2*p+3)-2*a*c*e^2*(m+2*p+3))-
      g*(a*e*(b*e-2*c*d*m+b*e*m)-b*d*(3*c*d-b*e+2*c*d*p-b*e*p))+
      c*e*(g*(b*d-2*a*e)-f*(2*c*d-b*e))*(m+2*p+4)*x,x],x]] /;
FreeQ[{a,b,c,d,e,m},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[p,-1] && Not[GtQ[m,0]]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,1]},
  -(d+e*x)^(m+1)*(a+c*x^2)^(p+1)*(a*(e*f-d*g)+(c*d*f+a*e*g)*x)/(2*a*(p+1)*(c*d^2+a*e^2)) + 
  1/(2*a*(p+1)*(c*d^2+a*e^2))*Int[(d+e*x)^m*(a+c*x^2)^(p+1)*
   ExpandToSum[2*a*(p+1)*(c*d^2+a*e^2)*Q+c*d^2*f*(2*p+3)-a*e*(d*g*m-e*f*(m+2*p+3))+e*(c*d*f+a*e*g)*(m+2*p+4)*x,x],x]] /;
FreeQ[{a,c,d,e,m},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0] && LtQ[p,-1] && Not[GtQ[m,0]]


Int[(d_.+e_.*x_)^m_*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,d+e*x,x], R=PolynomialRemainder[Pq,d+e*x,x]},
  (e*R*(d+e*x)^(m+1)*(a+b*x+c*x^2)^(p+1))/((m+1)*(c*d^2-b*d*e+a*e^2)) + 
  1/((m+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x)^(m+1)*(a+b*x+c*x^2)^p*
     ExpandToSum[(m+1)*(c*d^2-b*d*e+a*e^2)*Q+c*d*R*(m+1)-b*e*R*(m+p+2)-c*e*R*(m+2*p+3)*x,x],x]] /;
FreeQ[{a,b,c,d,e,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0] && LtQ[m,-1]


Int[(d_.+e_.*x_)^m_*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,d+e*x,x], R=PolynomialRemainder[Pq,d+e*x,x]},
  (e*R*(d+e*x)^(m+1)*(a+c*x^2)^(p+1))/((m+1)*(c*d^2+a*e^2)) + 
  1/((m+1)*(c*d^2+a*e^2))*Int[(d+e*x)^(m+1)*(a+c*x^2)^p*
     ExpandToSum[(m+1)*(c*d^2+a*e^2)*Q+c*d*R*(m+1)-c*e*R*(m+2*p+3)*x,x],x]] /;
FreeQ[{a,c,d,e,p},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0] && LtQ[m,-1]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  Coeff[Pq,x,q]/e^q*Int[(d+e*x)^(m+q)*(a+b*x+c*x^2)^p,x] + 
  1/e^q*Int[(d+e*x)^m*(a+b*x+c*x^2)^p*ExpandToSum[e^q*Pq-Coeff[Pq,x,q]*(d+e*x)^q,x],x] /;
 EqQ[m+q+2*p+1,0]] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  Coeff[Pq,x,q]/e^q*Int[(d+e*x)^(m+q)*(a+c*x^2)^p,x] + 
  1/e^q*Int[(d+e*x)^m*(a+c*x^2)^p*ExpandToSum[e^q*Pq-Coeff[Pq,x,q]*(d+e*x)^q,x],x] /;
 EqQ[m+q+2*p+1,0]] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],f=Coeff[Pq,x,Expon[Pq,x]]},
  f*(d+e*x)^(m+q-1)*(a+b*x+c*x^2)^(p+1)/(c*e^(q-1)*(m+q+2*p+1)) + 
  1/(c*e^q*(m+q+2*p+1))*Int[(d+e*x)^m*(a+b*x+c*x^2)^p*ExpandToSum[c*e^q*(m+q+2*p+1)*Pq-c*f*(m+q+2*p+1)*(d+e*x)^q-
    f*(d+e*x)^(q-2)*(b*d*e*(p+1)+a*e^2*(m+q-1)-c*d^2*(m+q+2*p+1)-e*(2*c*d-b*e)*(m+q+p)*x),x],x] /;
 NeQ[m+q+2*p+1,0]] /;
FreeQ[{a,b,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c,0] && NeQ[c*d^2-b*d*e+a*e^2,0]


Int[(d_.+e_.*x_)^m_.*Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],f=Coeff[Pq,x,Expon[Pq,x]]},
  f*(d+e*x)^(m+q-1)*(a+c*x^2)^(p+1)/(c*e^(q-1)*(m+q+2*p+1)) + 
  1/(c*e^q*(m+q+2*p+1))*Int[(d+e*x)^m*(a+c*x^2)^p*ExpandToSum[c*e^q*(m+q+2*p+1)*Pq-c*f*(m+q+2*p+1)*(d+e*x)^q-
    f*(d+e*x)^(q-2)*(a*e^2*(m+q-1)-c*d^2*(m+q+2*p+1)-2*c*d*e*(m+q+p)*x),x],x] /;
 NeQ[m+q+2*p+1,0]] /;
FreeQ[{a,c,d,e,m,p},x] && PolyQ[Pq,x] && NeQ[c*d^2+a*e^2,0]





(* ::Subsection::Closed:: *)
(*1.2.1.8 Pq(x) (a+b x+c x^2)^p*)


Int[Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],k},
  Int[Sum[Coeff[Pq,x,2*k]*x^(2*k),{k,0,q/2}]*(a+c*x^2)^p,x] + 
  Int[x*Sum[Coeff[Pq,x,2*k+1]*x^(2*k),{k,0,(q-1)/2}]*(a+c*x^2)^p,x]] /;
FreeQ[{a,c,p},x] && PolyQ[Pq,x] && Not[PolyQ[Pq,x^2]] && NeQ[p,-1]


Int[Pq_*(a_+b_.*x_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x+c*x^2)^p,x],x] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && PositiveIntegerQ[p+2]


Int[Pq_*(a_+c_.*x_^2)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+c*x^2)^p,x],x] /;
FreeQ[{a,c},x] && PolyQ[Pq,x] && PositiveIntegerQ[p+2]


Int[Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  Int[x*ExpandToSum[Pq/x,x]*(a+b*x+c*x^2)^p,x] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]]


Int[Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  Int[x*ExpandToSum[Pq/x,x]*(a+c*x^2)^p,x] /;
FreeQ[{a,c,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]]


Int[Pq_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  (a+b*x+c*x^2)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x)^(2*FracPart[p]))*Int[Pq*(b+2*c*x)^(2*p),x] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && EqQ[b^2-4*a*c]


Int[Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+b*x+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+b*x+c*x^2,x],x,1]},
  (b*f-2*a*g+(2*c*f-b*g)*x)*(a+b*x+c*x^2)^(p+1)/((p+1)*(b^2-4*a*c)) + 
  1/((p+1)*(b^2-4*a*c))*Int[(a+b*x+c*x^2)^(p+1)*ExpandToSum[(p+1)*(b^2-4*a*c)*Q-(2*p+3)*(2*c*f-b*g),x],x]] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && LtQ[p,-1]


Int[Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{Q=PolynomialQuotient[Pq,a+c*x^2,x],
        f=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,0],
        g=Coeff[PolynomialRemainder[Pq,a+c*x^2,x],x,1]},
  (a*g-c*f*x)*(a+c*x^2)^(p+1)/(2*a*c*(p+1)) + 
  1/(2*a*c*(p+1))*Int[(a+c*x^2)^(p+1)*ExpandToSum[2*a*c*(p+1)*Q+c*f*(2*p+3),x],x]] /;
FreeQ[{a,c},x] && PolyQ[Pq,x] && LtQ[p,-1]


Int[Pq_*(a_.+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],e=Coeff[Pq,x,Expon[Pq,x]]},
  e*x^(q-1)*(a+b*x+c*x^2)^(p+1)/(c*(q+2*p+1)) + 
  1/(c*(q+2*p+1))*Int[(a+b*x+c*x^2)^p*
    ExpandToSum[c*(q+2*p+1)*Pq-a*e*(q-1)*x^(q-2)-b*e*(q+p)*x^(q-1)-c*e*(q+2*p+1)*x^q,x],x]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && Not[LeQ[p,-1]]


Int[Pq_*(a_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x],e=Coeff[Pq,x,Expon[Pq,x]]},
  e*x^(q-1)*(a+c*x^2)^(p+1)/(c*(q+2*p+1)) + 
  1/(c*(q+2*p+1))*Int[(a+c*x^2)^p*
    ExpandToSum[c*(q+2*p+1)*Pq-a*e*(q-1)*x^(q-2)-c*e*(q+2*p+1)*x^q,x],x]] /;
FreeQ[{a,c,p},x] && PolyQ[Pq,x] && Not[LeQ[p,-1]]



`)

func resourcesRubi121QuadraticTrinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi121QuadraticTrinomialProductsM, nil
}

func resourcesRubi121QuadraticTrinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi121QuadraticTrinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.2.1 Quadratic trinomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi122QuarticTrinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.2.2 Quartic Trinomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.2.2.1 (a+b x^2+c x^4)^p*)


Int[(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^p/(b+2*c*x^2)^(2*p)*Int[(b+2*c*x^2)^(2*p),x] /;
FreeQ[{a,b,c,p},x] && EqQ[b^2-4*a*c,0]


Int[(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[p]


Int[(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  x*(a+b*x^2+c*x^4)^p/(4*p+1) + 
  2*p/(4*p+1)*Int[(2*a+b*x^2)*(a+b*x^2+c*x^4)^(p-1),x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p>0 && IntegerQ[2*p]


Int[(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  -x*(b^2-2*a*c+b*c*x^2)*(a+b*x^2+c*x^4)^(p+1)/(2*a*(p+1)*(b^2-4*a*c)) +
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(b^2-2*a*c+2*(p+1)*(b^2-4*a*c)+b*c*(4*p+7)*x^2)*(a+b*x^2+c*x^4)^(p+1),x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && IntegerQ[2*p]


Int[1/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  c/q*Int[1/(b/2-q/2+c*x^2),x] - c/q*Int[1/(b/2+q/2+c*x^2),x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && PosQ[b^2-4*a*c]


Int[1/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*q*r)*Int[(r-x)/(q-r*x+x^2),x] + 1/(2*c*q*r)*Int[(r+x)/(q+r*x+x^2),x]]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && NegQ[b^2-4*a*c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*Sqrt[-c]*Int[1/(Sqrt[b+q+2*c*x^2]*Sqrt[-b+q-2*c*x^2]),x]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && NegativeQ[c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,4]},
  (1+q^2*x^2)*Sqrt[(a+b*x^2+c*x^4)/(a*(1+q^2*x^2)^2)]/(2*q*Sqrt[a+b*x^2+c*x^4])*EllipticF[2*ArcTan[q*x],1/2-b*q^2/(4*c)]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && PositiveQ[c/a] && NegativeQ[b/a]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[-2*a-(b-q)*x^2]*Sqrt[(2*a+(b+q)*x^2)/q]/(2*Sqrt[-a]*Sqrt[a+b*x^2+c*x^4])*
    EllipticF[ArcSin[x/Sqrt[(2*a+(b+q)*x^2)/(2*q)]],(b+q)/(2*q)] /;
  IntegerQ[q]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && NegativeQ[a] && PositiveQ[c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[(2*a+(b-q)*x^2)/(2*a+(b+q)*x^2)]*Sqrt[(2*a+(b+q)*x^2)/q]/(2*Sqrt[a+b*x^2+c*x^4]*Sqrt[a/(2*a+(b+q)*x^2)])*
    EllipticF[ArcSin[x/Sqrt[(2*a+(b+q)*x^2)/(2*q)]],(b+q)/(2*q)]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && NegativeQ[a] && PositiveQ[c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*a+(b+q)*x^2)*Sqrt[(2*a+(b-q)*x^2)/(2*a+(b+q)*x^2)]/(2*a*Rt[(b+q)/(2*a),2]*Sqrt[a+b*x^2+c*x^4])*
    EllipticF[ArcTan[Rt[(b+q)/(2*a),2]*x],2*q/(b+q)] /;
 PosQ[(b+q)/a] && Not[PosQ[(b-q)/a] && SimplerSqrtQ[(b-q)/(2*a),(b+q)/(2*a)]]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*a+(b-q)*x^2)*Sqrt[(2*a+(b+q)*x^2)/(2*a+(b-q)*x^2)]/(2*a*Rt[(b-q)/(2*a),2]*Sqrt[a+b*x^2+c*x^4])*
    EllipticF[ArcTan[Rt[(b-q)/(2*a),2]*x],-2*q/(b-q)] /;
 PosQ[(b-q)/a]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+(b+q)*x^2/(2*a)]*Sqrt[1+(b-q)*x^2/(2*a)]/(Rt[-(b+q)/(2*a),2]*Sqrt[a+b*x^2+c*x^4])*
    EllipticF[ArcSin[Rt[-(b+q)/(2*a),2]*x],(b-q)/(b+q)] /;
 NegQ[(b+q)/a] && Not[NegQ[(b-q)/a] && SimplerSqrtQ[-(b-q)/(2*a),-(b+q)/(2*a)]]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+(b-q)*x^2/(2*a)]*Sqrt[1+(b+q)*x^2/(2*a)]/(Rt[-(b-q)/(2*a),2]*Sqrt[a+b*x^2+c*x^4])*
    EllipticF[ArcSin[Rt[-(b-q)/(2*a),2]*x],(b+q)/(b-q)] /;
 NegQ[(b-q)/a]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,4]},
  (1+q^2*x^2)*Sqrt[(a+b*x^2+c*x^4)/(a*(1+q^2*x^2)^2)]/(2*q*Sqrt[a+b*x^2+c*x^4])*EllipticF[2*ArcTan[q*x],1/2-b*q^2/(4*c)]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && PosQ[c/a]


Int[1/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]/Sqrt[a+b*x^2+c*x^4]*
    Int[1/(Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]),x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && NegQ[c/a]


Int[(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^2+c*x^4)^FracPart[p]/
    ((1+2*c*x^2/(b+Rt[b^2-4*a*c,2]))^FracPart[p]*(1+2*c*x^2/(b-Rt[b^2-4*a*c,2]))^FracPart[p])*
    Int[(1+2*c*x^2/(b+Sqrt[b^2-4*a*c]))^p*(1+2*c*x^2/(b-Sqrt[b^2-4*a*c]))^p,x] /;
FreeQ[{a,b,c,p},x] && NeQ[b^2-4*a*c]





(* ::Subsection::Closed:: *)
(*1.2.2.2 (d x)^m (a+b x^2+c x^4)^p*)


Int[x_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,p},x]


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,m},x] && PositiveIntegerQ[p] && Not[IntegerQ[Simplify[(m+1)/2]]]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(2*a*d*n*(p+1)*(2*p+1)) - 
  (d*x)^(m+1)*(2*a+b*x^n)*(a+b*x^n+c*x^(2*n))^p/(2*a*d*n*(2*p+1)) /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2,2*n] && EqQ[b^2-4*a*c,0] && EqQ[m+2*n(p+1)+1,0] && NeQ[2*p+1,0]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/(c^IntPart[p]*(b/2+c*x^n)^(2*FracPart[p]))*Int[(d*x)^m*(b/2+c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2,2*n] && EqQ[b^2-4*a*c,0]


Int[x_^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[x^(Simplify[(m+1)/2]-1)*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,p},x] && NeQ[b^2-4*a*c] && IntegerQ[(m+1)/2]


Int[(d_.*x_)^m_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/d*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(2*k)/d^2+c*x^(4*k)/d^4)^p,x],x,(d*x)^(1/k)]] /;
FreeQ[{a,b,c,d,p},x] && NeQ[b^2-4*a*c] && FractionQ[m] && IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  d*(d*x)^(m-1)*(2*b*p+c*(m+4*p-1)*x^2)*(a+b*x^2+c*x^4)^p/(c*(m+4*p+1)*(m+4*p-1)) - 
  2*p*d^2/(c*(m+4*p+1)*(m+4*p-1))*
    Int[(d*x)^(m-2)*(a+b*x^2+c*x^4)^(p-1)*Simp[a*b*(m-1)-(2*a*c*(m+4*p-1)-b^2*(m+2*p-1))*x^2,x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m,p] && p>0 && m>1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^2+c*x^4)^p/(d*(m+1)) - 
  2*p/(d^2*(m+1))*Int[(d*x)^(m+2)*(b+2*c*x^2)*(a+b*x^2+c*x^4)^(p-1),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m,p] && p>0 && m<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^2+c*x^4)^p/(d*(m+4*p+1)) + 
  2*p/(m+4*p+1)*Int[(d*x)^m*(2*a+b*x^2)*(a+b*x^2+c*x^4)^(p-1),x] /;
FreeQ[{a,b,c,d,m},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p>0 && NeQ[m+4*p+1] && IntegerQ[2*p] && 
  (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  d*(d*x)^(m-1)*(b+2*c*x^2)*(a+b*x^2+c*x^4)^(p+1)/(2*(p+1)*(b^2-4*a*c)) - 
  d^2/(2*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^(m-2)*(b*(m-1)+2*c*(m+4*(p+1)+1)*x^2)*(a+b*x^2+c*x^4)^(p+1),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m,p] && p<-1 && 1<m<=3 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  -d^3*(d*x)^(m-3)*(2*a+b*x^2)*(a+b*x^2+c*x^4)^(p+1)/(2*(p+1)*(b^2-4*a*c)) + 
  d^4/(2*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^(m-4)*(2*a*(m-3)+b*(m+4*p+3)*x^2)*(a+b*x^2+c*x^4)^(p+1),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m,p] && p<-1 && m>3 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  -(d*x)^(m+1)*(b^2-2*a*c+b*c*x^2)*(a+b*x^2+c*x^4)^(p+1)/(2*a*d*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^m*(a+b*x^2+c*x^4)^(p+1)*Simp[b^2*(m+2*p+3)-2*a*c*(m+4*(p+1)+1)+b*c*(m+4*p+7)*x^2,x],x] /;
FreeQ[{a,b,c,d,m},x] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  d^3*(d*x)^(m-3)*(a+b*x^2+c*x^4)^(p+1)/(c*(m+4*p+1)) - 
  d^4/(c*(m+4*p+1))*
    Int[(d*x)^(m-4)*Simp[a*(m-3)+b*(m+2*p-1)*x^2,x]*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,p},x] && NeQ[b^2-4*a*c] && RationalQ[m] && m>3 && NeQ[m+4*p+1] && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^2+c*x^4)^(p+1)/(a*d*(m+1)) - 
  1/(a*d^2*(m+1))*Int[(d*x)^(m+2)*(b*(m+2*p+3)+c*(m+4*p+5)*x^2)*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,p},x] && NeQ[b^2-4*a*c] && RationalQ[m] && m<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(d_.*x_)^m_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  (d*x)^(m+1)/(a*d*(m+1)) -
  1/(a*d^2)*Int[(d*x)^(m+2)*(b+c*x^2)/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m] && m<-1


Int[x_^m_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[PolynomialDivide[x^m,(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && IntegerQ[m] && m>5


Int[(d_.*x_)^m_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  d^3*(d*x)^(m-3)/(c*(m-3)) - d^4/c*Int[(d*x)^(m-4)*(a+b*x^2)/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m] && m>3


Int[x_^2/(a_+b_.*x_^2+c_.*x_^4), x_Symbol] :=
  With[{q=Rt[a/c,2]},
  1/2*Int[(q+x^2)/(a+b*x^2+c*x^4),x] - 1/2*Int[(q-x^2)/(a+b*x^2+c*x^4),x]] /;
FreeQ[{a,b,c},x] && NegativeQ[b^2-4*a*c] && PosQ[a*c]


Int[x_^m_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*r)*Int[x^(m-3)*(q+r*x)/(q+r*x+x^2),x] - 
  1/(2*c*r)*Int[x^(m-3)*(q-r*x)/(q-r*x+x^2),x]]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && 3<=m<4 && NegQ[b^2-4*a*c]


Int[x_^m_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*r)*Int[x^(m-1)/(q-r*x+x^2),x] - 1/(2*c*r)*Int[x^(m-1)/(q+r*x+x^2),x]]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && 1<=m<3 && NegQ[b^2-4*a*c]


Int[(d_.*x_)^m_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  d^2/2*(b/q+1)*Int[(d*x)^(m-2)/(b/2+q/2+c*x^2),x] - 
  d^2/2*(b/q-1)*Int[(d*x)^(m-2)/(b/2-q/2+c*x^2),x]] /;
FreeQ[{a,b,c,d},x] && NeQ[b^2-4*a*c] && RationalQ[m] && m>=2


Int[(d_.*x_)^m_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  c/q*Int[(d*x)^m/(b/2-q/2+c*x^2),x] - c/q*Int[(d*x)^m/(b/2+q/2+c*x^2),x]] /;
FreeQ[{a,b,c,d,m},x] && NeQ[b^2-4*a*c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*Sqrt[-c]*Int[x^2/(Sqrt[b+q+2*c*x^2]*Sqrt[-b+q-2*c*x^2]),x]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && NegativeQ[c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,2]},
  1/q*Int[1/Sqrt[a+b*x^2+c*x^4],x] - 1/q*Int[(1-q*x^2)/Sqrt[a+b*x^2+c*x^4],x]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && PositiveQ[c/a] && NegativeQ[b/a]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -(b-q)/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + 1/(2*c)*Int[(b-q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c] && NegativeQ[a] && PositiveQ[c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  x*(b+q+2*c*x^2)/(2*c*Sqrt[a+b*x^2+c*x^4]) - 
  Rt[(b+q)/(2*a),2]*(2*a+(b+q)*x^2)*Sqrt[(2*a+(b-q)*x^2)/(2*a+(b+q)*x^2)]/(2*c*Sqrt[a+b*x^2+c*x^4])*
    EllipticE[ArcTan[Rt[(b+q)/(2*a),2]*x],2*q/(b+q)] /;
 PosQ[(b+q)/a] && Not[PosQ[(b-q)/a] && SimplerSqrtQ[(b-q)/(2*a),(b+q)/(2*a)]]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  x*(b-q+2*c*x^2)/(2*c*Sqrt[a+b*x^2+c*x^4]) - 
  Rt[(b-q)/(2*a),2]*(2*a+(b-q)*x^2)*Sqrt[(2*a+(b+q)*x^2)/(2*a+(b-q)*x^2)]/(2*c*Sqrt[a+b*x^2+c*x^4])*
    EllipticE[ArcTan[Rt[(b-q)/(2*a),2]*x],-2*q/(b-q)] /;
 PosQ[(b-q)/a]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -(b+q)/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + 1/(2*c)*Int[(b+q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NegQ[(b+q)/a] && Not[NegQ[(b-q)/a] && SimplerSqrtQ[-(b-q)/(2*a),-(b+q)/(2*a)]]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -(b-q)/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + 1/(2*c)*Int[(b-q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NegQ[(b-q)/a]] /;
FreeQ[{a,b,c},x] && PositiveQ[b^2-4*a*c]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,2]},
  1/q*Int[1/Sqrt[a+b*x^2+c*x^4],x] - 1/q*Int[(1-q*x^2)/Sqrt[a+b*x^2+c*x^4],x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && PosQ[c/a]


Int[x_^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]/Sqrt[a+b*x^2+c*x^4]*
    Int[x^2/(Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]),x]] /;
FreeQ[{a,b,c},x] && NeQ[b^2-4*a*c] && NegQ[c/a]


Int[(d_.*x_)^m_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^2+c*x^4)^FracPart[p]/
    ((1+2*c*x^2/(b+Rt[b^2-4*a*c,2]))^FracPart[p]*(1+2*c*x^2/(b-Rt[b^2-4*a*c,2]))^FracPart[p])*
    Int[(d*x)^m*(1+2*c*x^2/(b+Sqrt[b^2-4*a*c]))^p*(1+2*c*x^2/(b-Sqrt[b^2-4*a*c]))^p,x] /;
FreeQ[{a,b,c,d,m,p},x]


Int[u_^m_.*(a_.+b_.*v_^2+c_.*v_^4)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a+b*x^2+c*x^(2*2))^p,x],x,v] /;
FreeQ[{a,b,c,m,p},x] && LinearPairQ[u,v,x]





(* ::Subsection::Closed:: *)
(*1.2.2.3 (d+e x^2)^q (a+b x^2+c x^4)^p*)


Int[(d_+e_.*x_^2)/(b_.*x_^2+c_.*x_^4)^(3/4),x_Symbol] :=
  -2*(c*d-b*e)*(b*x^2+c*x^4)^(1/4)/(b*c*x) + e/c*Int[(b*x^2+c*x^4)^(1/4)/x^2,x] /;
FreeQ[{b,c,d,e},x]


Int[(d_+e_.*x_^2)*(b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  e*(b*x^2+c*x^4)^(p+1)/(c*(4*p+3)*x) /;
FreeQ[{b,c,d,e,p},x] && Not[IntegerQ[p]] && NeQ[4*p+3] && EqQ[b*e*(2*p+1)-c*d*(4*p+3)]


Int[(d_+e_.*x_^2)*(b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  e*(b*x^2+c*x^4)^(p+1)/(c*(4*p+3)*x) - ((b*e*(2*p+1)-c*d*(4*p+3))/(c*(4*p+3)))*Int[(b*x^2+c*x^4)^p,x] /;
FreeQ[{b,c,d,e,p},x] && Not[IntegerQ[p]] && NeQ[4*p+3] && NeQ[b*e*(2*p+1)-c*d*(4*p+3)]


Int[(d_+e_.*x_^2)^q_.*(b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (b*x^2+c*x^4)^FracPart[p]/(x^(2*FracPart[p])*(b+c*x^2)^FracPart[p])*Int[x^(2*p)*(d+e*x^2)^q*(b+c*x^2)^p,x] /;
FreeQ[{b,c,d,e,p,q},x] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_.)^q_.*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^p/(d+e*x^n)^(2*p)*Int[(d+e*x^n)^(q+2*p),x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2,2*n] && EqQ[b^2-4*a*c,0] && EqQ[2*c*d-b*e,0]


Int[(d_+e_.*x_^n_.)^q_.*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/(c^IntPart[p]*(b/2+c*x^n)^(2*FracPart[p]))*Int[(d+e*x^n)^q*(b/2+c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2,2*n] && EqQ[b^2-4*a*c,0]


Int[(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[(d+e*x^2)^(p+q)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Int[(d+e*x^2)^(p+q)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,c,d,e,q},x] && EqQ[c*d^2+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^FracPart[p]/((d+e*x^2)^FracPart[p]*(a/d+(c*x^2)/e)^FracPart[p])*Int[(d+e*x^2)^(p+q)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,p,q},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  (a+c*x^4)^FracPart[p]/((d+e*x^2)^FracPart[p]*(a/d+(c*x^2)/e)^FracPart[p])*Int[(d+e*x^2)^(p+q)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,c,d,e,p,q},x] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[p,q]


Int[(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q*(a+c*x^4)^p,x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[p,q]


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  -(c*d^2-b*d*e+a*e^2)*x*(d+e*x^2)^(q+1)/(2*d*e^2*(q+1)) + 
  1/(2*(q+1)*d*e^2)*Int[(d+e*x^2)^(q+1)*Simp[c*d^2-b*d*e+a*e^2*(2*(q+1)+1)+2*c*d*e*(q+1)*x^2,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4),x_Symbol] :=
  -(c*d^2+a*e^2)*x*(d+e*x^2)^(q+1)/(2*d*e^2*(q+1)) + 
  1/(2*(q+1)*d*e^2)*Int[(d+e*x^2)^(q+1)*Simp[c*d^2+a*e^2*(2*(q+1)+1)+2*c*d*e*(q+1)*x^2,x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  c*x^(2+1)*(d+e*x^2)^(q+1)/(e*(2*(q+2)+1)) + 
  1/(e*(2*(q+2)+1))*Int[(d+e*x^2)^q*(a*e*(2*(q+2)+1)-(3*c*d-b*e*(2*(q+2)+1))*x^2),x] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4),x_Symbol] :=
  c*x^(2+1)*(d+e*x^2)^(q+1)/(e*(2*(q+2)+1)) + 
  1/(e*(2*(q+2)+1))*Int[(d+e*x^2)^q*(a*e*(2*(q+2)+1)-3*c*d*x^2),x] /;
FreeQ[{a,c,d,e,q},x] && NeQ[c*d^2+a*e^2]


Int[(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[2*d/e-b/c,2]},
  e/(2*c)*Int[1/Simp[d/e+q*x+x^2,x],x] + e/(2*c)*Int[1/Simp[d/e-q*x+x^2,x],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && 
  (PositiveQ[2*d/e-b/c] || Not[NegativeQ[2*d/e-b/c]] && EqQ[d-e*Rt[a/c,2]])


Int[(d_+e_.*x_^2)/(a_+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[2*d/e,2]},
  e/(2*c)*Int[1/Simp[d/e+q*x+x^2,x],x] + e/(2*c)*Int[1/Simp[d/e-q*x+x^2,x],x]] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2-a*e^2] && PosQ[d*e]


Int[(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[1/(b/2-q/2+c*x^2),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[1/(b/2+q/2+c*x^2),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[-2*d/e-b/c,2]},
  e/(2*c*q)*Int[(q-2*x)/Simp[d/e+q*x-x^2,x],x] + 
  e/(2*c*q)*Int[(q+2*x)/Simp[d/e-q*x-x^2,x],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && Not[PositiveQ[b^2-4*a*c]]


Int[(d_+e_.*x_^2)/(a_+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[-2*d/e,2]},
  e/(2*c*q)*Int[(q-2*x)/Simp[d/e+q*x-x^2,x],x] + 
  e/(2*c*q)*Int[(q+2*x)/Simp[d/e-q*x-x^2,x],x]] /;
FreeQ[{a,c,d,e},x] && EqQ[c*d^2-a*e^2] && NegQ[d*e]


Int[(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[1/(b/2-q/2+c*x^2),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[1/(b/2+q/2+c*x^2),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-a*e^2] && PosQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/(a_+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (e/2+c*d/(2*q))*Int[1/(-q+c*x^2),x] + (e/2-c*d/(2*q))*Int[1/(q+c*x^2),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2-a*e^2] && PosQ[-a*c]


Int[(d_+e_.*x_^2)/(a_+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[a*c,2]},
  (d*q+a*e)/(2*a*c)*Int[(q+c*x^2)/(a+c*x^4),x] +
  (d*q-a*e)/(2*a*c)*Int[(q-c*x^2)/(a+c*x^4),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && NeQ[c*d^2-a*e^2] && NegQ[-a*c]


Int[(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*q*r)*Int[(d*r-(d-e*q)*x)/(q-r*x+x^2),x] + 
  1/(2*c*q*r)*Int[(d*r+(d-e*q)*x)/(q+r*x+x^2),x]]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && NegQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && IntegerQ[q]


Int[(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q/(a+c*x^4),x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && IntegerQ[q]


Int[(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  e^2/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x^2)^q,x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x^2)^(q+1)*(c*d-b*e-c*e*x^2)/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  e^2/(c*d^2+a*e^2)*Int[(d+e*x^2)^q,x] + 
  c/(c*d^2+a*e^2)*Int[(d+e*x^2)^(q+1)*(d-e*x^2)/(a+c*x^4),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  2*c/r*Int[(d+e*x^2)^q/(b-r+2*c*x^2),x] - 2*c/r*Int[(d+e*x^2)^q/(b+r+2*c*x^2),x]] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[q]]


Int[(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  With[{r=Rt[-a*c,2]},
  -c/(2*r)*Int[(d+e*x^2)^q/(r-c*x^2),x] - c/(2*r)*Int[(d+e*x^2)^q/(r+c*x^2),x]] /;
FreeQ[{a,c,d,e,q},x] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[q]]


Int[(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  x*(2*b*e*p+c*d*(4*p+3)+c*e*(4*p+1)*x^2)*(a+b*x^2+c*x^4)^p/(c*(4*p+1)*(4*p+3)) + 
  2*p/(c*(4*p+1)*(4*p+3))*Int[Simp[2*a*c*d*(4*p+3)-a*b*e+(2*a*c*e*(4*p+1)+b*c*d*(4*p+3)-b^2*e*(2*p+1))*x^2,x]*
    (a+b*x^2+c*x^4)^(p-1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && FractionQ[p] && p>0 && IntegerQ[2*p]


Int[(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  x*(d*(4*p+3)+e*(4*p+1)*x^2)*(a+c*x^4)^p/((4*p+1)*(4*p+3)) + 
  2*p/((4*p+1)*(4*p+3))*Int[Simp[2*a*d*(4*p+3)+(2*a*e*(4*p+1))*x^2,x]*(a+c*x^4)^(p-1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && FractionQ[p] && p>0 && IntegerQ[2*p]


Int[(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  -x*(d*b^2-a*b*e-2*a*c*d+(b*d-2*a*e)*c*x^2)*(a+b*x^2+c*x^4)^(p+1)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[Simp[(2*p+3)*d*b^2-a*b*e-2*a*c*d*(4*p+5)+(4*p+7)*(d*b-2*a*e)*c*x^2,x]*
    (a+b*x^2+c*x^4)^(p+1),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && RationalQ[p] && p<-1 && IntegerQ[2*p]


Int[(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  -x*(d+e*x^2)*(a+c*x^4)^(p+1)/(4*a*(p+1)) + 
  1/(4*a*(p+1))*Int[Simp[d*(4*p+5)+e*(4*p+7)*x^2,x]*(a+c*x^4)^(p+1),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && RationalQ[p] && p<-1 && IntegerQ[2*p]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*Sqrt[-c]*Int[(d+e*x^2)/(Sqrt[b+q+2*c*x^2]*Sqrt[-b+q-2*c*x^2]),x]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && NegativeQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  Sqrt[-c]*Int[(d+e*x^2)/(Sqrt[q+c*x^2]*Sqrt[q-c*x^2]),x]] /;
FreeQ[{a,c,d,e},x] && PositiveQ[a] && NegativeQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,4]},
  -d*x*Sqrt[a+b*x^2+c*x^4]/(a*(1+q^2*x^2)) + 
  d*(1+q^2*x^2)*Sqrt[(a+b*x^2+c*x^4)/(a*(1+q^2*x^2)^2)]/(q*Sqrt[a+b*x^2+c*x^4])*EllipticE[2*ArcTan[q*x],1/2-b*q^2/(4*c)] /;
 EqQ[e+d*q^2]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && PositiveQ[c/a] && NegativeQ[b/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,2]},
  (e+d*q)/q*Int[1/Sqrt[a+b*x^2+c*x^4],x] - e/q*Int[(1-q*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NeQ[e+d*q]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && PositiveQ[c/a] && NegativeQ[b/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  e*x*(b+q+2*c*x^2)/(2*c*Sqrt[a+b*x^2+c*x^4]) - 
  e*q*Sqrt[(2*a+(b-q)*x^2)/(2*a+(b+q)*x^2)]*Sqrt[(2*a+(b+q)*x^2)/q]/(2*c*Sqrt[a+b*x^2+c*x^4]*Sqrt[a/(2*a+(b+q)*x^2)])*
    EllipticE[ArcSin[x/Sqrt[(2*a+(b+q)*x^2)/(2*q)]],(b+q)/(2*q)] /;
 EqQ[2*c*d-e*(b-q)]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && NegativeQ[a] && PositiveQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  e*x*(q+c*x^2)/(c*Sqrt[a+c*x^4]) - 
  Sqrt[2]*e*q*Sqrt[-a+q*x^2]*Sqrt[(a+q*x^2)/q]/(Sqrt[-a]*c*Sqrt[a+c*x^4])*
    EllipticE[ArcSin[x/Sqrt[(a+q*x^2)/(2*q)]],1/2] /;
 EqQ[c*d+e*q] && IntegerQ[q]] /;
FreeQ[{a,c,d,e},x] && NegativeQ[a] && PositiveQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  e*x*(q+c*x^2)/(c*Sqrt[a+c*x^4]) - 
  Sqrt[2]*e*q*Sqrt[(a-q*x^2)/(a+q*x^2)]*Sqrt[(a+q*x^2)/q]/(c*Sqrt[a+c*x^4]*Sqrt[a/(a+q*x^2)])*
    EllipticE[ArcSin[x/Sqrt[(a+q*x^2)/(2*q)]],1/2] /;
 EqQ[c*d+e*q]] /;
FreeQ[{a,c,d,e},x] && NegativeQ[a] && PositiveQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*d-e*(b-q))/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + e/(2*c)*Int[(b-q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NeQ[2*c*d-e*(b-q)]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && NegativeQ[a] && PositiveQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (c*d+e*q)/c*Int[1/Sqrt[a+c*x^4],x] - e/c*Int[(q-c*x^2)/Sqrt[a+c*x^4],x] /;
 NeQ[c*d+e*q]] /;
FreeQ[{a,c,d,e},x] && NegativeQ[a] && PositiveQ[c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  d*Int[1/Sqrt[a+b*x^2+c*x^4],x] + e*Int[x^2/Sqrt[a+b*x^2+c*x^4],x] /;
 PosQ[(b+q)/a] || PosQ[(b-q)/a]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  d*Int[1/Sqrt[a+c*x^4],x] + e*Int[x^2/Sqrt[a+c*x^4],x] /;
FreeQ[{a,c,d,e},x] && PositiveQ[-a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -a*e*Rt[-(b+q)/(2*a),2]*Sqrt[1+(b+q)*x^2/(2*a)]*Sqrt[1+(b-q)*x^2/(2*a)]/(c*Sqrt[a+b*x^2+c*x^4])*
    EllipticE[ArcSin[Rt[-(b+q)/(2*a),2]*x],(b-q)/(b+q)] /;
 NegQ[(b+q)/a] && EqQ[2*c*d-e*(b+q)] && Not[SimplerSqrtQ[-(b-q)/(2*a),-(b+q)/(2*a)]]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*d-e*(b+q))/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + e/(2*c)*Int[(b+q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NegQ[(b+q)/a] && NeQ[2*c*d-e*(b+q)] && Not[SimplerSqrtQ[-(b-q)/(2*a),-(b+q)/(2*a)]]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  -a*e*Rt[-(b-q)/(2*a),2]*Sqrt[1+(b-q)*x^2/(2*a)]*Sqrt[1+(b+q)*x^2/(2*a)]/(c*Sqrt[a+b*x^2+c*x^4])*
    EllipticE[ArcSin[Rt[-(b-q)/(2*a),2]*x],(b+q)/(b-q)] /;
 NegQ[(b-q)/a] && EqQ[2*c*d-e*(b-q)]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*d-e*(b-q))/(2*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] + e/(2*c)*Int[(b-q+2*c*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NegQ[(b-q)/a] && NeQ[2*c*d-e*(b-q)]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,4]},
  -d*x*Sqrt[a+b*x^2+c*x^4]/(a*(1+q^2*x^2)) + 
  d*(1+q^2*x^2)*Sqrt[(a+b*x^2+c*x^4)/(a*(1+q^2*x^2)^2)]/(q*Sqrt[a+b*x^2+c*x^4])*EllipticE[2*ArcTan[q*x],1/2-b*q^2/(4*c)] /;
 EqQ[e+d*q^2]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && PosQ[c/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,4]},
  -d*x*Sqrt[a+c*x^4]/(a*(1+q^2*x^2)) + 
  d*(1+q^2*x^2)*Sqrt[(a+c*x^4)/(a*(1+q^2*x^2)^2)]/(q*Sqrt[a+c*x^4])*EllipticE[2*ArcTan[q*x],1/2] /;
 EqQ[e+d*q^2]] /;
FreeQ[{a,c,d,e},x] && PosQ[c/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,2]},
  (e+d*q)/q*Int[1/Sqrt[a+b*x^2+c*x^4],x] - e/q*Int[(1-q*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
 NeQ[e+d*q]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && PosQ[c/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[c/a,2]},
  (e+d*q)/q*Int[1/Sqrt[a+c*x^4],x] - e/q*Int[(1-q*x^2)/Sqrt[a+c*x^4],x] /;
 NeQ[e+d*q]] /;
FreeQ[{a,c,d,e},x] && PosQ[c/a]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  d/Sqrt[a]*Int[Sqrt[1+e*x^2/d]/Sqrt[1-e*x^2/d],x] /;
FreeQ[{a,c,d,e},x] && NegQ[c/a] && EqQ[c*d^2+a*e^2] && PositiveQ[a]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  Sqrt[1+c*x^4/a]/Sqrt[a+c*x^4]*Int[(d+e*x^2)/Sqrt[1+c*x^4/a],x] /;
FreeQ[{a,c,d,e},x] && NegQ[c/a] && EqQ[c*d^2+a*e^2] && Not[PositiveQ[a]]


Int[(d_+e_.*x_^2)/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[-c/a,2]},
  (d*q-e)/q*Int[1/Sqrt[a+c*x^4],x] + e/q*Int[(1+q*x^2)/Sqrt[a+c*x^4],x]] /;
FreeQ[{a,c,d,e},x] && NegQ[c/a] && NeQ[c*d^2+a*e^2]


Int[(d_+e_.*x_^2)/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]/Sqrt[a+b*x^2+c*x^4]*
    Int[(d+e*x^2)/(Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NegQ[c/a]


Int[(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)*(a+c*x^4)^p,x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


(* Int[(d_+e_.*x_^2)^2/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  e^2*x*Sqrt[a+b*x^2+c*x^4]/(3*c) + 
  2*(3*c*d-b*e)/(3*c)*Int[(d+e*x^2)/Sqrt[a+b*x^2+c*x^4],x] - 
  (3*c*d^2-2*b*d*e+a*e^2)/(3*c)*Int[1/Sqrt[a+b*x^2+c*x^4],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] *)


(* Int[(d_+e_.*x_^2)^2/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  e^2*x*Sqrt[a+c*x^4]/(3*c) + 
  2*d*Int[(d+e*x^2)/Sqrt[a+c*x^4],x] - 
  (3*c*d^2+a*e^2)/(3*c)*Int[1/Sqrt[a+c*x^4],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] *)


(* Int[(d_+e_.*x_^2)^q_/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  e^2*x*(d+e*x^2)^(q-2)*Sqrt[a+b*x^2+c*x^4]/(c*(2*q-1)) + 
  2*(q-1)*(3*c*d-b*e)/(c*(2*q-1))*Int[(d+e*x^2)^(q-1)/Sqrt[a+b*x^2+c*x^4],x] - 
  (2*q-3)*(3*c*d^2-2*b*d*e+a*e^2)/(c*(2*q-1))*Int[(d+e*x^2)^(q-2)/Sqrt[a+b*x^2+c*x^4],x] + 
  2*d*(q-2)*(c*d^2-b*d*e+a*e^2)/(c*(2*q-1))*Int[(d+e*x^2)^(q-3)/Sqrt[a+b*x^2+c*x^4],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[q-2] *)


(* Int[(d_+e_.*x_^2)^q_/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  e^2*x*(d+e*x^2)^(q-2)*Sqrt[a+c*x^4]/(c*(2*q-1)) + 
  6*d*(q-1)/(2*q-1)*Int[(d+e*x^2)^(q-1)/Sqrt[a+c*x^4],x] - 
  (2*q-3)*(3*c*d^2+a*e^2)/(c*(2*q-1))*Int[(d+e*x^2)^(q-2)/Sqrt[a+c*x^4],x] + 
  2*d*(q-2)*(c*d^2+a*e^2)/(c*(2*q-1))*Int[(d+e*x^2)^(q-3)/Sqrt[a+c*x^4],x] /;
FreeQ[{a,c,d,e},x] && PositiveIntegerQ[q-2] *)


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{f=Coeff[PolynomialRemainder[(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,0],
        g=Coeff[PolynomialRemainder[(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*g-f*(b^2-2*a*c)-c*(b*f-2*a*g)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(a+b*x^2+c*x^4)^(p+1)*
    ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*PolynomialQuotient[(d+e*x^2)^q,a+b*x^2+c*x^4,x]+
      b^2*f*(2*p+3)-2*a*c*f*(4*p+5)-a*b*g+c*(4*p+7)*(b*f-2*a*g)*x^2,x],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[q-1] && 
  RationalQ[p] && p<-1


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  e^q*x^(2*q-3)*(a+b*x^2+c*x^4)^(p+1)/(c*(4*p+2*q+1)) + 
  1/(c*(4*p+2*q+1))*Int[(a+b*x^2+c*x^4)^p*
    ExpandToSum[c*(4*p+2*q+1)*(d+e*x^2)^q-a*(2*q-3)*e^q*x^(2*q-4)-b*(2*p+2*q-1)*e^q*x^(2*q-2)-c*(4*p+2*q+1)*e^q*x^(2*q),x],x] /;
FreeQ[{a,b,c,d,e,p},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[q-1]


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  e^q*x^(2*q-3)*(a+c*x^4)^(p+1)/(c*(4*p+2*q+1)) + 
  1/(c*(4*p+2*q+1))*Int[(a+c*x^4)^p*
    ExpandToSum[c*(4*p+2*q+1)*(d+e*x^2)^q-a*(2*q-3)*e^q*x^(2*q-4)-c*(4*p+2*q+1)*e^q*x^(2*q),x],x] /;
FreeQ[{a,c,d,e,p},x] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[q-1]


Int[(a_+b_.*x_^2+c_.*x_^4)^p_/(d_+e_.*x_^2),x_Symbol] :=
  -x*(b^2*c*d-b^3*e-2*a*c^2*d+3*a*b*c*e+c*(b*c*d-b^2*e+2*a*c*e)*x^2)*(a+b*x^2+c*x^4)^(p+1)/
    (2*a*(p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2)) - 
  1/(2*a*(p+1)*(b^2-4*a*c)*(c*d^2-b*d*e+a*e^2))*Int[((a+b*x^2+c*x^4)^(p+1)/(d+e*x^2))*
    Simp[b^3*d*e*(3+2*p)-a*b*c*d*e*(11+8*p)-b^2*(2*a*e^2*(p+1)+c*d^2*(3+2*p))+
      2*a*c*(4*a*e^2*(p+1)+c*d^2*(5+4*p))-
      (4*a*c^2*d*e-2*b^2*c*d*e*(2+p)-b^3*e^2*(3+2*p)+b*c*(c*d^2*(7+4*p)+a*e^2*(11+8*p)))*x^2-
      c*e*(b*c*d-b^2*e+2*a*c*e)*(7+4*p)*x^4,x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && NegativeIntegerQ[p+1/2]


Int[(a_+c_.*x_^4)^p_/(d_+e_.*x_^2),x_Symbol] :=
  -x*(-2*a*c^2*d+c*(2*a*c*e)*x^2)*(a+c*x^4)^(p+1)/(2*a*(p+1)*(-4*a*c)*(c*d^2+a*e^2)) - 
  1/(2*a*(p+1)*(-4*a*c)*(c*d^2+a*e^2))*Int[((a+c*x^4)^(p+1)/(d+e*x^2))*
    Simp[2*a*c*(4*a*e^2*(p+1)+c*d^2*(5+4*p))-(4*a*c^2*d*e)*x^2-c*e*(2*a*c*e)*(7+4*p)*x^4,x],x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && NegativeIntegerQ[p+1/2]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/(d_+e_.*x_^2),x_Symbol] :=
  -1/e^2*Int[(c*d-b*e-c*e*x^2)/Sqrt[a+b*x^2+c*x^4],x] + 
  (c*d^2-b*d*e+a*e^2)/e^2*Int[1/((d+e*x^2)*Sqrt[a+b*x^2+c*x^4]),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[Sqrt[a_+c_.*x_^4]/(d_+e_.*x_^2),x_Symbol] :=
  -c/e^2*Int[(d-e*x^2)/Sqrt[a+c*x^4],x] + 
  (c*d^2+a*e^2)/e^2*Int[1/((d+e*x^2)*Sqrt[a+c*x^4]),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*Sqrt[-c]*Int[1/((d+e*x^2)*Sqrt[b+q+2*c*x^2]*Sqrt[-b+q-2*c*x^2]),x]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && NegativeQ[c]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  Sqrt[-c]*Int[1/((d+e*x^2)*Sqrt[q+c*x^2]*Sqrt[q-c*x^2]),x]] /;
FreeQ[{a,c,d,e},x] && PositiveQ[a] && NegativeQ[c]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/(2*c*d-e*(b-q))*Int[1/Sqrt[a+b*x^2+c*x^4],x] - e/(2*c*d-e*(b-q))*Int[(b-q+2*c*x^2)/((d+e*x^2)*Sqrt[a+b*x^2+c*x^4]),x]] /;
FreeQ[{a,b,c,d,e},x] && PositiveQ[b^2-4*a*c] && Not[NegativeQ[c]]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  c/(c*d+e*q)*Int[1/Sqrt[a+c*x^4],x] + e/(c*d+e*q)*Int[(q-c*x^2)/((d+e*x^2)*Sqrt[a+c*x^4]),x]] /;
FreeQ[{a,c,d,e},x] && PositiveQ[-a*c] && Not[NegativeQ[c]]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[c/a,4]},
  ArcTan[Sqrt[(c*d^2-b*d*e+a*e^2)/(d*e)]*x/Sqrt[a+b*x^2+c*x^4]]/(2*d*Sqrt[(c*d^2-b*d*e+a*e^2)/(d*e)]) + 
  (e+d*q^2)*(1+q^2*x^2)*Sqrt[(a+b*x^2+c*x^4)/(a*(1+q^2*x^2)^2)]/(4*d*q*(e-d*q^2)*Sqrt[a+b*x^2+c*x^4])*
    EllipticPi[-(e-d*q^2)^2/(4*d*e*q^2),2*ArcTan[q*x],1/2-b*q^2/(4*c)] - 
  q^2/(e-d*q^2)*Int[1/Sqrt[a+b*x^2+c*x^4],x] /;
 NeQ[e-d*q^2]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PosQ[c/a]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[c/a,4]},
  ArcTan[Sqrt[(c*d^2+a*e^2)/(d*e)]*x/Sqrt[a+c*x^4]]/(2*d*Sqrt[(c*d^2+a*e^2)/(d*e)]) + 
  (e+d*q^2)*(1+q^2*x^2)*Sqrt[(a+c*x^4)/(a*(1+q^2*x^2)^2)]/(4*d*q*(e-d*q^2)*Sqrt[a+c*x^4])*
    EllipticPi[-(e-d*q^2)^2/(4*d*e*q^2),2*ArcTan[q*x],1/2] - 
  q^2/(e-d*q^2)*Int[1/Sqrt[a+c*x^4],x] /;
 NeQ[e-d*q^2]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && PosQ[c/a]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[-c/a,4]},
  1/(d*Sqrt[a]*q)*EllipticPi[-e/(d*q^2),ArcSin[q*x],-1]] /;
FreeQ[{a,c,d,e},x] && NegQ[c/a] && PositiveQ[a]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  Sqrt[1+c*x^4/a]/Sqrt[a+c*x^4]*Int[1/((d+e*x^2)*Sqrt[1+c*x^4/a]),x] /;
FreeQ[{a,c,d,e},x] && NegQ[c/a] && Not[PositiveQ[a]]


Int[1/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]/Sqrt[a+b*x^2+c*x^4]*
    Int[1/((d+e*x^2)*Sqrt[1+2*c*x^2/(b-q)]*Sqrt[1+2*c*x^2/(b+q)]),x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NegQ[c/a]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/(d_+e_.*x_^2)^2,x_Symbol] :=
  x*Sqrt[a+b*x^2+c*x^4]/(2*d*(d+e*x^2)) + 
  c/(2*d*e^2)*Int[(d-e*x^2)/Sqrt[a+b*x^2+c*x^4],x] - 
  (c*d^2-a*e^2)/(2*d*e^2)*Int[1/((d+e*x^2)*Sqrt[a+b*x^2+c*x^4]),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[Sqrt[a_+c_.*x_^4]/(d_+e_.*x_^2)^2,x_Symbol] :=
  x*Sqrt[a+c*x^4]/(2*d*(d+e*x^2)) + 
  c/(2*d*e^2)*Int[(d-e*x^2)/Sqrt[a+c*x^4],x] - 
  (c*d^2-a*e^2)/(2*d*e^2)*Int[1/((d+e*x^2)*Sqrt[a+c*x^4]),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[1/((d_+e_.*x_^2)^2*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  e^2*x*Sqrt[a+b*x^2+c*x^4]/(2*d*(c*d^2-b*d*e+a*e^2)*(d+e*x^2)) - 
  c/(2*d*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x^2)/Sqrt[a+b*x^2+c*x^4],x] + 
  (3*c*d^2-2*b*d*e+a*e^2)/(2*d*(c*d^2-b*d*e+a*e^2))*Int[1/((d+e*x^2)*Sqrt[a+b*x^2+c*x^4]),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[1/((d_+e_.*x_^2)^2*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  e^2*x*Sqrt[a+c*x^4]/(2*d*(c*d^2+a*e^2)*(d+e*x^2)) - 
  c/(2*d*(c*d^2+a*e^2))*Int[(d+e*x^2)/Sqrt[a+c*x^4],x] + 
  (3*c*d^2+a*e^2)/(2*d*(c*d^2+a*e^2))*Int[1/((d+e*x^2)*Sqrt[a+c*x^4]),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2]


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Module[{aa,bb,cc},
  Int[ReplaceAll[ExpandIntegrand[1/Sqrt[aa+bb*x^2+cc*x^4],(d+e*x^2)^q*(aa+bb*x^2+cc*x^4)^(p+1/2),x],{aa->a,bb->b,cc->c}],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && NegativeIntegerQ[q] && IntegerQ[p+1/2] && p!=-1/2


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  Module[{aa,cc},
  Int[ReplaceAll[ExpandIntegrand[1/Sqrt[aa+cc*x^4],(d+e*x^2)^q*(aa+cc*x^4)^(p+1/2),x],{aa->a,cc->c}],x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && NegativeIntegerQ[q] && IntegerQ[p+1/2] && p!=-1/2


Int[(d_+e_.*x_^2)^q_/Sqrt[a_+b_.*x_^2+c_.*x_^4],x_Symbol] :=
  -e^2*x*(d+e*x^2)^(q+1)*Sqrt[a+b*x^2+c*x^4]/(2*d*(q+1)*(c*d^2-b*d*e+a*e^2)) + 
  (2*q+3)*(3*c*d^2-2*b*d*e+a*e^2)/(2*d*(q+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x^2)^(q+1)/Sqrt[a+b*x^2+c*x^4],x] - 
  (q+2)*(3*c*d-b*e)/(d*(q+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x^2)^(q+2)/Sqrt[a+b*x^2+c*x^4],x] + 
  c*(2*q+5)/(2*d*(q+1)*(c*d^2-b*d*e+a*e^2))*Int[(d+e*x^2)^(q+3)/Sqrt[a+b*x^2+c*x^4],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[q+2]


Int[(d_+e_.*x_^2)^q_/Sqrt[a_+c_.*x_^4],x_Symbol] :=
  -e^2*x*(d+e*x^2)^(q+1)*Sqrt[a+c*x^4]/(2*d*(q+1)*(c*d^2+a*e^2)) + 
  (2*q+3)*(3*c*d^2+a*e^2)/(2*d*(q+1)*(c*d^2+a*e^2))*Int[(d+e*x^2)^(q+1)/Sqrt[a+c*x^4],x] - 
  3*c*(q+2)/((q+1)*(c*d^2+a*e^2))*Int[(d+e*x^2)^(q+2)/Sqrt[a+c*x^4],x] + 
  c*(2*q+5)/(2*d*(q+1)*(c*d^2+a*e^2))*Int[(d+e*x^2)^(q+3)/Sqrt[a+c*x^4],x] /;
FreeQ[{a,c,d,e},x] && NegativeIntegerQ[q+2]


Int[1/(Sqrt[d_+e_.*x_^2]*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  1/(2*Sqrt[a]*Sqrt[d]*Rt[-e/d,2])*EllipticF[2*ArcSin[Rt[-e/d,2]*x],b*d/(4*a*e)] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d-b*e] && PositiveQ[a] && PositiveQ[d]


Int[1/(Sqrt[d_+e_.*x_^2]*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  Sqrt[(d+e*x^2)/d]*Sqrt[(a+b*x^2+c*x^4)/a]/(Sqrt[d+e*x^2]*Sqrt[a+b*x^2+c*x^4])*
    Int[1/(Sqrt[1+e/d*x^2]*Sqrt[1+b/a*x^2+c/a*x^4]),x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d-b*e] && Not[PositiveQ[a] && PositiveQ[d]]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/Sqrt[d_+e_.*x_^2],x_Symbol] :=
  Sqrt[a]/(2*Sqrt[d]*Rt[-e/d,2])*EllipticE[2*ArcSin[Rt[-e/d,2]*x],b*d/(4*a*e)] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d-b*e] && PositiveQ[a] && PositiveQ[d]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/Sqrt[d_+e_.*x_^2],x_Symbol] :=
  Sqrt[a+b*x^2+c*x^4]*Sqrt[(d+e*x^2)/d]/(Sqrt[d+e*x^2]*Sqrt[(a+b*x^2+c*x^4)/a])*
    Int[Sqrt[1+b/a*x^2+c/a*x^4]/Sqrt[1+e/d*x^2],x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d-b*e] && Not[PositiveQ[a] && PositiveQ[d]]


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  c^p*x^(4*p-1)*(d+e*x^2)^(q+1)/(e*(4*p+2*q+1)) + 
  Int[(d+e*x^2)^q*ExpandToSum[(a+b*x^2+c*x^4)^p-c^p*x^(4*p)-d*c^p*(4*p-1)*x^(4*p-2)/(e*(4*p+2*q+1)),x],x] /;
FreeQ[{a,b,c,d,e,q},x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[p] && 
  NeQ[4*p+2*q+1] && Not[PositiveIntegerQ[q]]


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  c^p*x^(4*p-1)*(d+e*x^2)^(q+1)/(e*(4*p+2*q+1)) + 
  Int[(d+e*x^2)^q*ExpandToSum[(a+c*x^4)^p-c^p*x^(4*p)-d*c^p*(4*p-1)*x^(4*p-2)/(e*(4*p+2*q+1)),x],x] /;
FreeQ[{a,c,d,e,q},x] && PositiveIntegerQ[p] && 
  NeQ[4*p+2*q+1] && Not[PositiveIntegerQ[q]]


Int[(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,e,p,q},x] && NeQ[b^2-4*a*c] && (IntegersQ[p,q] || PositiveIntegerQ[p] || PositiveIntegerQ[q])


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q*(a+c*x^4)^p,x],x] /;
FreeQ[{a,c,d,e,p,q},x] && (IntegersQ[p,q] || PositiveIntegerQ[p])


Int[(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+c*x^4)^p,(d/(d^2-e^2*x^4)-e*x^2/(d^2-e^2*x^4))^(-q),x],x] /;
FreeQ[{a,c,d,e,p},x] && NeQ[c*d^2+a*e^2] && NegativeIntegerQ[q] && Not[IntegersQ[2*p]]


Int[(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Defer[Int][(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,e,p,q},x]


Int[(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Defer[Int][(d+e*x^2)^q*(a+c*x^4)^p,x] /;
FreeQ[{a,c,d,e,p,q},x]





(* ::Subsection::Closed:: *)
(*1.2.2.4 (f x)^m (d+e x^2)^q (a+b x^2+c x^4)^p*)


Int[x_^m_.*(e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  1/(2*e^((m+1)/2-1))*Subst[Int[(e*x)^(q+(m+1)/2-1)*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,e,p,q},x] && IntegerQ[(m+1)/2]


Int[x_^m_.*(e_.*x_^2)^q_*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  1/(2*e^((m+1)/2-1))*Subst[Int[(e*x)^(q+(m+1)/2-1)*(a+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,c,e,p,q},x] && IntegerQ[(m+1)/2]


Int[(f_.*x_)^m_.*(e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  f^m*e^IntPart[q]*(e*x^2)^FracPart[q]/x^(2*FracPart[q])*Int[x^(m+2*q)*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,e,f,m,p,q},x] && (IntegerQ[m] || PositiveQ[f]) && Not[IntegerQ[(m+1)/2]]


Int[(f_.*x_)^m_.*(e_.*x_^2)^q_*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  f^m*e^IntPart[q]*(e*x^2)^FracPart[q]/x^(2*FracPart[q])*Int[x^(m+2*q)*(a+c*x^4)^p,x] /;
FreeQ[{a,c,e,f,m,p,q},x] && (IntegerQ[m] || PositiveQ[f]) && Not[IntegerQ[(m+1)/2]]


Int[(f_*x_)^m_.*(e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(e*x^2)^q*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,e,f,m,p,q},x] && Not[IntegerQ[m]]


Int[(f_*x_)^m_.*(e_.*x_^2)^q_*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(e*x^2)^q*(a+c*x^4)^p,x] /;
FreeQ[{a,c,e,f,m,p,q},x] && Not[IntegerQ[m]]


Int[x_*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,d,e,p,q},x]


Int[x_*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[(d+e*x)^q*(a+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,c,d,e,p,q},x]


Int[x_^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  1/2*Subst[Int[x^((m+1)/2-1)*(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[b^2-4*a*c,0] && Not[IntegerQ[p]] && PositiveIntegerQ[(m+1)/2]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^FracPart[p]/(c^IntPart[p]*(b/2+c*x^2)^(2*FracPart[p]))*
    Int[(f*x)^m*(d+e*x^2)^q*(b/2+c*x^2)^(2*p),x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && EqQ[b^2-4*a*c,0] && Not[IntegerQ[p]]


Int[x_^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[x^((m+1)/2-1)*(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,d,e,m,p,q},x] && IntegerQ[(m+1)/2]


Int[x_^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  1/2*Subst[Int[x^((m+1)/2-1)*(d+e*x)^q*(a+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,c,d,e,m,p,q},x] && IntegerQ[(m+1)/2]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[(f*x)^m*(d+e*x^2)^(q+p)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Int[(f*x)^m*(d+e*x^2)^(q+p)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,q,m,q},x] && EqQ[c*d^2+a*e^2] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^FracPart[p]/((d+e*x^2)^FracPart[p]*(a/d+(c*x^2)/e)^FracPart[p])*
    Int[(f*x)^m*(d+e*x^2)^(q+p)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  (a+c*x^4)^FracPart[p]/((d+e*x^2)^FracPart[p]*(a/d+(c*x^2)/e)^FracPart[p])*Int[(f*x)^m*(d+e*x^2)^(q+p)*(a/d+c/e*x^2)^p,x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[x_^m_.*(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  (-d)^(m/2-1)*(c*d^2-b*d*e+a*e^2)^p*x*(d+e*x^2)^(q+1)/(2*e^(2*p+m/2)*(q+1)) + 
  1/(2*e^(2*p+m/2)*(q+1))*Int[(d+e*x^2)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^2)*(2*e^(2*p+m/2)*(q+1)*x^m*(a+b*x^2+c*x^4)^p-
      (-d)^(m/2-1)*(c*d^2-b*d*e+a*e^2)^p*(d+e*(2*q+3)*x^2))],x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && PositiveIntegerQ[p] && IntegersQ[m/2,q] && q<-1 && m>0


Int[x_^m_.*(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  (-d)^(m/2-1)*(c*d^2+a*e^2)^p*x*(d+e*x^2)^(q+1)/(2*e^(2*p+m/2)*(q+1)) + 
  1/(2*e^(2*p+m/2)*(q+1))*Int[(d+e*x^2)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^2)*(2*e^(2*p+m/2)*(q+1)*x^m*(a+c*x^4)^p-
      (-d)^(m/2-1)*(c*d^2+a*e^2)^p*(d+e*(2*q+3)*x^2))],x],x] /;
FreeQ[{a,c,d,e},x] && PositiveIntegerQ[p] && IntegersQ[m/2,q] && q<-1 && m>0


Int[x_^m_*(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  (-d)^(m/2-1)*(c*d^2-b*d*e+a*e^2)^p*x*(d+e*x^2)^(q+1)/(2*e^(2*p+m/2)*(q+1)) + 
  (-d)^(m/2-1)/(2*e^(2*p)*(q+1))*Int[x^m*(d+e*x^2)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^2)*(2*(-d)^(-m/2+1)*e^(2*p)*(q+1)*(a+b*x^2+c*x^4)^p - 
      (e^(-m/2)*(c*d^2-b*d*e+a*e^2)^p*x^(-m))*(d+e*(2*q+3)*x^2))],x],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && PositiveIntegerQ[p] && IntegersQ[m/2,q] && q<-1 && m<0


Int[x_^m_*(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  (-d)^(m/2-1)*(c*d^2+a*e^2)^p*x*(d+e*x^2)^(q+1)/(2*e^(2*p+m/2)*(q+1)) + 
  (-d)^(m/2-1)/(2*e^(2*p)*(q+1))*Int[x^m*(d+e*x^2)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^2)*(2*(-d)^(-m/2+1)*e^(2*p)*(q+1)*(a+c*x^4)^p - 
      (e^(-m/2)*(c*d^2+a*e^2)^p*x^(-m))*(d+e*(2*q+3)*x^2))],x],x] /;
FreeQ[{a,c,d,e},x] && PositiveIntegerQ[p] && IntegersQ[m/2,q] && q<-1 && m<0


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  c^p*(f*x)^(m+4*p-1)*(d+e*x^2)^(q+1)/(e*f^(4*p-1)*(m+4*p+2*q+1)) + 
  1/(e*(m+4*p+2*q+1))*Int[(f*x)^m*(d+e*x^2)^q*
    ExpandToSum[e*(m+4*p+2*q+1)*((a+b*x^2+c*x^4)^p-c^p*x^(4*p))-d*c^p*(m+4*p-1)*x^(4*p-2),x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && NeQ[b^2-4*a*c,0] && PositiveIntegerQ[p] && Not[IntegerQ[q]] && NeQ[m+4*p+2*q+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  c^p*(f*x)^(m+4*p-1)*(d+e*x^2)^(q+1)/(e*f^(4*p-1)*(m+4*p+2*q+1)) + 
  1/(e*(m+4*p+2*q+1))*Int[(f*x)^m*(d+e*x^2)^q*
    ExpandToSum[e*(m+4*p+2*q+1)*((a+c*x^4)^p-c^p*x^(4*p))-d*c^p*(m+4*p-1)*x^(4*p-2),x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && PositiveIntegerQ[p] && Not[IntegerQ[q]] && NeQ[m+4*p+2*q+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && PositiveIntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m(d+e*x^2)^q*(a+c*x^4)^p,x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && PositiveIntegerQ[p]


Int[(f_.*x_)^m_*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/f*Subst[Int[x^(k*(m+1)-1)*(d+e*x^(2*k)/f^2)^q*(a+b*x^(2*k)/f^k+c*x^(4*k)/f^4)^p,x],x,(f*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && NeQ[b^2-4*a*c,0] && FractionQ[m] && IntegerQ[p]


Int[(f_.*x_)^m_*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/f*Subst[Int[x^(k*(m+1)-1)*(d+e*x^(2*k)/f)^q*(a+c*x^(4*k)/f)^p,x],x,(f*x)^(1/k)]] /;
FreeQ[{a,c,d,e,f,p,q},x] && FractionQ[m] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+b*x^2+c*x^4)^p*(d*(m+4*p+3)+e*(m+1)*x^2)/(f*(m+1)*(m+4*p+3)) + 
  2*p/(f^2*(m+1)*(m+4*p+3))*Int[(f*x)^(m+2)*(a+b*x^2+c*x^4)^(p-1)*
    Simp[2*a*e*(m+1)-b*d*(m+4*p+3)+(b*e*(m+1)-2*c*d*(m+4*p+3))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p>0 && m<-1 && 
  m+4*p+3!=0 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+c*x^4)^p*(d*(m+4*p+3)+e*(m+1)*x^2)/(f*(m+1)*(m+4*p+3)) + 
  4*p/(f^2*(m+1)*(m+4*p+3))*Int[(f*x)^(m+2)*(a+c*x^4)^(p-1)*(a*e*(m+1)-c*d*(m+4*p+3)*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p>0 && m<-1 && 
  m+4*p+3!=0 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+b*x^2+c*x^4)^p*(b*e*2*p+c*d*(m+4*p+3)+c*e*(4*p+m+1)*x^2)/
    (c*f*(4*p+m+1)*(m+4*p+3)) + 
  2*p/(c*(4*p+m+1)*(m+4*p+3))*Int[(f*x)^m*(a+b*x^2+c*x^4)^(p-1)*
    Simp[2*a*c*d*(m+4*p+3)-a*b*e*(m+1)+(2*a*c*e*(4*p+m+1)+b*c*d*(m+4*p+3)-b^2*e*(m+2*p+1))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && RationalQ[p] && p>0 && 
  NeQ[4*p+m+1] && NeQ[m+4*p+3] && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+c*x^4)^p*(c*d*(m+4*p+3)+c*e*(4*p+m+1)*x^2)/(c*f*(4*p+m+1)*(m+4*p+3)) + 
  4*a*p/((4*p+m+1)*(m+4*p+3))*Int[(f*x)^m*(a+c*x^4)^(p-1)*Simp[d*(m+4*p+3)+e*(4*p+m+1)*x^2,x],x] /;
FreeQ[{a,c,d,e,f,m},x] && RationalQ[p] && p>0 && 
  NeQ[4*p+m+1] && NeQ[m+4*p+3] && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  f*(f*x)^(m-1)*(a+b*x^2+c*x^4)^(p+1)*(b*d-2*a*e-(b*e-2*c*d)*x^2)/(2*(p+1)*(b^2-4*a*c)) - 
  f^2/(2*(p+1)*(b^2-4*a*c))*Int[(f*x)^(m-2)*(a+b*x^2+c*x^4)^(p+1)*
    Simp[(m-1)*(b*d-2*a*e)-(4*p+4+m+1)*(b*e-2*c*d)*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p<-1 && m>1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  f*(f*x)^(m-1)*(a+c*x^4)^(p+1)*(a*e-c*d*x^2)/(4*a*c*(p+1)) - 
  f^2/(4*a*c*(p+1))*Int[(f*x)^(m-2)*(a+c*x^4)^(p+1)*(a*e*(m-1)-c*d*(4*p+4+m+1)*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p<-1 && m>1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+b*x^2+c*x^4)^(p+1)*(d*(b^2-2*a*c)-a*b*e+(b*d-2*a*e)*c*x^2)/(2*a*f*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(f*x)^m*(a+b*x^2+c*x^4)^(p+1)*
    Simp[d*(b^2*(m+2*(p+1)+1)-2*a*c*(m+4*(p+1)+1))-a*b*e*(m+1)+c*(m+2*(2*p+3)+1)*(b*d-2*a*e)*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && RationalQ[p] && p<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+c*x^4)^(p+1)*(d+e*x^2)/(4*a*f*(p+1)) + 
  1/(4*a*(p+1))*Int[(f*x)^m*(a+c*x^4)^(p+1)*Simp[d*(m+4*(p+1)+1)+e*(m+2*(2*p+3)+1)*x^2,x],x] /;
FreeQ[{a,c,d,e,f,m},x] && RationalQ[p] && p<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  e*f*(f*x)^(m-1)*(a+b*x^2+c*x^4)^(p+1)/(c*(m+4*p+3)) - 
  f^2/(c*(m+4*p+3))*Int[(f*x)^(m-2)*(a+b*x^2+c*x^4)^p*Simp[a*e*(m-1)+(b*e*(m+2*p+1)-c*d*(m+4*p+3))*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && NeQ[b^2-4*a*c,0] && RationalQ[m] && m>1 && 
  NeQ[m+4*p+3] && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  e*f*(f*x)^(m-1)*(a+c*x^4)^(p+1)/(c*(m+4*p+3)) - 
  f^2/(c*(m+4*p+3))*Int[(f*x)^(m-2)*(a+c*x^4)^p*(a*e*(m-1)-c*d*(m+4*p+3)*x^2),x] /;
FreeQ[{a,c,d,e,f,p},x] && RationalQ[m] && m>1 && NeQ[m+4*p+3] && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  d*(f*x)^(m+1)*(a+b*x^2+c*x^4)^(p+1)/(a*f*(m+1)) + 
  1/(a*f^2*(m+1))*Int[(f*x)^(m+2)*(a+b*x^2+c*x^4)^p*Simp[a*e*(m+1)-b*d*(m+2*p+3)-c*d*(m+4*p+5)*x^2,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && NeQ[b^2-4*a*c,0] && RationalQ[m] && m<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)*(a_+c_.*x_^4)^p_,x_Symbol] :=
  d*(f*x)^(m+1)*(a+c*x^4)^(p+1)/(a*f*(m+1)) + 
  1/(a*f^2*(m+1))*Int[(f*x)^(m+2)*(a+c*x^4)^p*(a*e*(m+1)-c*d*(m+4*p+5)*x^2),x] /;
FreeQ[{a,c,d,e,f,p},x] && RationalQ[m] && m<-1 && IntegerQ[2*p] && (IntegerQ[p] || IntegerQ[m])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4), x_Symbol] :=
  With[{r=Rt[c/e*(2*c*d-b*e),2]},
  e/2*Int[(f*x)^m/(c*d/e-r*x+c*x^2),x] + 
  e/2*Int[(f*x)^m/(c*d/e+r*x+c*x^2),x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && EqQ[c*d^2-a*e^2] && PositiveQ[d/e] && PosQ[c/e*(2*c*d-b*e)]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)/(a_+c_.*x_^4), x_Symbol] :=
  With[{r=Rt[2*c^2*d/e,2]},
  e/2*Int[(f*x)^m/(c*d/e-r*x+c*x^2),x] + 
  e/2*Int[(f*x)^m/(c*d/e+r*x+c*x^2),x]] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[c*d^2-a*e^2] && PositiveQ[d/e]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[(f*x)^m/(b/2-q/2+c*x^2),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[(f*x)^m/(b/2+q/2+c*x^2),x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)/(a_+c_.*x_^4),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  -(e/2+c*d/(2*q))*Int[(f*x)^m/(q-c*x^2),x] + (e/2-c*d/(2*q))*Int[(f*x)^m/(q+c*x^2),x]] /;
FreeQ[{a,c,d,e,f,m},x]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && IntegerQ[q] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_./(a_+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q/(a+c*x^4),x],x] /;
FreeQ[{a,c,d,e,f,m},x] && IntegerQ[q] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_./(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m,(d+e*x^2)^q/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && IntegerQ[q] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_./(a_+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m,(d+e*x^2)^q/(a+c*x^4),x],x] /;
FreeQ[{a,c,d,e,f,m},x] && IntegerQ[q] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  f^4/c^2*Int[(f*x)^(m-4)*(c*d-b*e+c*e*x^2)*(d+e*x^2)^(q-1),x] - 
  f^4/c^2*Int[(f*x)^(m-4)*(d+e*x^2)^(q-1)*Simp[a*(c*d-b*e)+(b*c*d-b^2*e+a*c*e)*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && m>3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  f^4/c*Int[(f*x)^(m-4)*(d+e*x^2)^q,x] - 
  a*f^4/c*Int[(f*x)^(m-4)*(d+e*x^2)^q/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f,q},x] && Not[IntegerQ[q]] && RationalQ[m] && m>3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  e*f^2/c*Int[(f*x)^(m-2)*(d+e*x^2)^(q-1),x] - 
  f^2/c*Int[(f*x)^(m-2)*(d+e*x^2)^(q-1)*Simp[a*e-(c*d-b*e)*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && 1<m<=3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  e*f^2/c*Int[(f*x)^(m-2)*(d+e*x^2)^(q-1),x] - 
  f^2/c*Int[(f*x)^(m-2)*(d+e*x^2)^(q-1)*Simp[a*e-c*d*x^2,x]/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f},x] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && 1<m<=3


Int[(f_.*x_)^m_*(d_.+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  d/a*Int[(f*x)^m*(d+e*x^2)^(q-1),x] - 
  1/(a*f^2)*Int[(f*x)^(m+2)*(d+e*x^2)^(q-1)*Simp[b*d-a*e+c*d*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && m<0


Int[(f_.*x_)^m_*(d_.+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  d/a*Int[(f*x)^m*(d+e*x^2)^(q-1),x] + 
  1/(a*f^2)*Int[(f*x)^(m+2)*(d+e*x^2)^(q-1)*Simp[a*e-c*d*x^2,x]/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f},x] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && m<0


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  d^2*f^4/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-4)*(d+e*x^2)^q,x] - 
  f^4/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-4)*(d+e*x^2)^(q+1)*Simp[a*d+(b*d-a*e)*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && m>3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  d^2*f^4/(c*d^2+a*e^2)*Int[(f*x)^(m-4)*(d+e*x^2)^q,x] - 
  a*f^4/(c*d^2+a*e^2)*Int[(f*x)^(m-4)*(d+e*x^2)^(q+1)*(d-e*x^2)/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f},x] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && m>3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  -d*e*f^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2)*(d+e*x^2)^q,x] + 
  f^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2)*(d+e*x^2)^(q+1)*Simp[a*e+c*d*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && 1<m<=3


Int[(f_.*x_)^m_.*(d_.+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  -d*e*f^2/(c*d^2+a*e^2)*Int[(f*x)^(m-2)*(d+e*x^2)^q,x] + 
  f^2/(c*d^2+a*e^2)*Int[(f*x)^(m-2)*(d+e*x^2)^(q+1)*Simp[a*e+c*d*x^2,x]/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f},x] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && 1<m<=3


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  e^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^m*(d+e*x^2)^q,x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^m*(d+e*x^2)^(q+1)*Simp[c*d-b*e-c*e*x^2,x]/(a+b*x^2+c*x^4),x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  e^2/(c*d^2+a*e^2)*Int[(f*x)^m*(d+e*x^2)^q,x] + 
  c/(c*d^2+a*e^2)*Int[(f*x)^m*(d+e*x^2)^(q+1)*(d-e*x^2)/(a+c*x^4),x] /;
FreeQ[{a,c,d,e,f,m},x] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q,(f*x)^m/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c,d,e,f,q},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^2)^q,(f*x)^m/(a+c*x^4),x],x] /;
FreeQ[{a,c,d,e,f,q},x] && Not[IntegerQ[q]] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q,1/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && NeQ[b^2-4*a*c,0] && Not[IntegerQ[q]] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q,1/(a+c*x^4),x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && Not[IntegerQ[q]] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  2*c/r*Int[(f*x)^m*(d+e*x^2)^q/(b-r+2*c*x^2),x] - 2*c/r*Int[(f*x)^m*(d+e*x^2)^q/(b+r+2*c*x^2),x]] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && NeQ[b^2-4*a*c,0]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_/(a_+c_.*x_^4),x_Symbol] :=
  With[{r=Rt[-a*c,2]},
  -c/(2*r)*Int[(f*x)^m*(d+e*x^2)^q/(r-c*x^2),x] - c/(2*r)*Int[(f*x)^m*(d+e*x^2)^q/(r+c*x^2),x]] /;
FreeQ[{a,c,d,e,f,m,q},x]


Int[(f_.*x_)^m_*(a_.+b_.*x_^2+c_.*x_^4)^p_./(d_.+e_.*x_^2),x_Symbol] :=
  1/d^2*Int[(f*x)^m*(a*d+(b*d-a*e)*x^2)*(a+b*x^2+c*x^4)^(p-1),x] + 
  (c*d^2-b*d*e+a*e^2)/(d^2*f^4)*Int[(f*x)^(m+4)*(a+b*x^2+c*x^4)^(p-1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p>0 && m<-2


Int[(f_.*x_)^m_*(a_+c_.*x_^4)^p_./(d_.+e_.*x_^2),x_Symbol] :=
  a/d^2*Int[(f*x)^m*(d-e*x^2)*(a+c*x^4)^(p-1),x] + 
  (c*d^2+a*e^2)/(d^2*f^4)*Int[(f*x)^(m+4)*(a+c*x^4)^(p-1)/(d+e*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p>0 && m<-2


Int[(f_.*x_)^m_*(a_.+b_.*x_^2+c_.*x_^4)^p_./(d_.+e_.*x_^2),x_Symbol] :=
  1/(d*e)*Int[(f*x)^m*(a*e+c*d*x^2)*(a+b*x^2+c*x^4)^(p-1),x] - 
  (c*d^2-b*d*e+a*e^2)/(d*e*f^2)*Int[(f*x)^(m+2)*(a+b*x^2+c*x^4)^(p-1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p>0 && m<0


Int[(f_.*x_)^m_*(a_+c_.*x_^4)^p_./(d_.+e_.*x_^2),x_Symbol] :=
  1/(d*e)*Int[(f*x)^m*(a*e+c*d*x^2)*(a+c*x^4)^(p-1),x] - 
  (c*d^2+a*e^2)/(d*e*f^2)*Int[(f*x)^(m+2)*(a+c*x^4)^(p-1)/(d+e*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p>0 && m<0


Int[(f_.*x_)^m_.*(a_.+b_.*x_^2+c_.*x_^4)^p_/(d_.+e_.*x_^2),x_Symbol] :=
  -f^4/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-4)*(a*d+(b*d-a*e)*x^2)*(a+b*x^2+c*x^4)^p,x] + 
  d^2*f^4/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-4)*(a+b*x^2+c*x^4)^(p+1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p<-1 && m>2


Int[(f_.*x_)^m_.*(a_+c_.*x_^4)^p_/(d_.+e_.*x_^2),x_Symbol] :=
  -a*f^4/(c*d^2+a*e^2)*Int[(f*x)^(m-4)*(d-e*x^2)*(a+c*x^4)^p,x] + 
  d^2*f^4/(c*d^2+a*e^2)*Int[(f*x)^(m-4)*(a+c*x^4)^(p+1)/(d+e*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p<-1 && m>2


Int[(f_.*x_)^m_.*(a_.+b_.*x_^2+c_.*x_^4)^p_/(d_.+e_.*x_^2),x_Symbol] :=
  f^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2)*(a*e+c*d*x^2)*(a+b*x^2+c*x^4)^p,x] - 
  d*e*f^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2)*(a+b*x^2+c*x^4)^(p+1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b^2-4*a*c,0] && RationalQ[m,p] && p<-1 && m>0


Int[(f_.*x_)^m_.*(a_+c_.*x_^4)^p_/(d_.+e_.*x_^2),x_Symbol] :=
  f^2/(c*d^2+a*e^2)*Int[(f*x)^(m-2)*(a*e+c*d*x^2)*(a+c*x^4)^p,x] - 
  d*e*f^2/(c*d^2+a*e^2)*Int[(f*x)^(m-2)*(a+c*x^4)^(p+1)/(d+e*x^2),x] /;
FreeQ[{a,c,d,e,f},x] && RationalQ[m,p] && p<-1 && m>0


Int[x_^m_*(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{f=Coeff[PolynomialRemainder[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,0],
        g=Coeff[PolynomialRemainder[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*g-f*(b^2-2*a*c)-c*(b*f-2*a*g)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(a+b*x^2+c*x^4)^(p+1)*
    Simp[ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*PolynomialQuotient[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x]+
      b^2*f*(2*p+3)-2*a*c*f*(4*p+5)-a*b*g+c*(4*p+7)*(b*f-2*a*g)*x^2,x],x],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && LtQ[p,-1] && IGtQ[q,1] && IGtQ[m/2,0]


Int[x_^m_*(d_+e_.*x_^2)^q_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{f=Coeff[PolynomialRemainder[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,0],
        g=Coeff[PolynomialRemainder[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*g-f*(b^2-2*a*c)-c*(b*f-2*a*g)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[x^m*(a+b*x^2+c*x^4)^(p+1)*
    Simp[ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*x^(-m)*PolynomialQuotient[x^m*(d+e*x^2)^q,a+b*x^2+c*x^4,x]+
      (b^2*f*(2*p+3)-2*a*c*f*(4*p+5)-a*b*g)*x^(-m)+c*(4*p+7)*(b*f-2*a*g)*x^(2-m),x],x],x]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b^2-4*a*c,0] && LtQ[p,-1] && IGtQ[q,1] && ILtQ[m/2,0]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && NeQ[b^2-4*a*c,0] && (PositiveIntegerQ[p] || PositiveIntegerQ[q] || IntegersQ[m,q])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^2)^q*(a+c*x^4)^p,x],x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && (PositiveIntegerQ[p] || PositiveIntegerQ[q] || IntegersQ[m,q])


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  f^m*Int[ExpandIntegrand[x^m*(a+c*x^4)^p,(d/(d^2-e^2*x^4)-e*x^2/(d^2-e^2*x^4))^(-q),x],x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && NegativeIntegerQ[q] && (IntegerQ[m] || PositiveQ[f])


Int[(f_.*x_)^m_*(d_+e_.*x_^2)^q_*(a_+c_.*x_^4)^p_,x_Symbol] :=
  (f*x)^m/x^m*Int[x^m*(d+e*x^2)^q*(a+c*x^4)^p,x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && NegativeIntegerQ[q] && Not[IntegerQ[m] || PositiveQ[f]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Defer[Int][(f*x)^m*(d+e*x^2)^q*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x]


Int[(f_.*x_)^m_.*(d_+e_.*x_^2)^q_.*(a_+c_.*x_^4)^p_.,x_Symbol] :=
  Defer[Int][(f*x)^m*(d+e*x^2)^q*(a+c*x^4)^p,x] /;
FreeQ[{a,c,d,e,f,m,p,q},x]





(* ::Subsection::Closed:: *)
(*1.2.2.6 (d x)^m Pq(x) (a+b x^2+c x^4)^p*)


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],k},
  Int[(d*x)^m*Sum[Coeff[Pq,x,2*k]*x^(2*k),{k,0,q/2+1}]*(a+b*x^2+c*x^4)^p,x] + 
  1/d*Int[(d*x)^(m+1)*Sum[Coeff[Pq,x,2*k+1]*x^(2*k),{k,0,(q-1)/2+1}]*(a+b*x^2+c*x^4)^p,x]] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x] && Not[PolyQ[Pq,x^2]]


Int[x_^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  1/2*Subst[Int[x^((m-1)/2)*SubstFor[x^2,Pq,x]*(a+b*x+c*x^2)^p,x],x,x^2] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x^2] && IntegerQ[(m-1)/2]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*Pq*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c,d,m},x] && PolyQ[Pq,x^2] && IGtQ[p,-2]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  1/d^2*Int[(d*x)^(m+2)*ExpandToSum[Pq/x^2,x]*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x^2] && EqQ[Coeff[Pq,x,0]]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  With[{e=Coeff[Pq,x,0],f=Coeff[Pq,x,2],g=Coeff[Pq,x,4]},
  e*(d*x)^(m+1)*(a+b*x^2+c*x^4)^(p+1)/(a*d*(m+1)) /;
 EqQ[a*f*(m+1)-b*e*(m+2*p+3)] && EqQ[a*g*(m+1)-c*e*(m+4*p+5)] && NeQ[m+1]] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x^2] && Expon[Pq,x]==4


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x^2)^(2*FracPart[p]))*Int[(d*x)^m*Pq*(b+2*c*x^2)^(2*p),x] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && EqQ[b^2-4*a*c]


Int[x_^m_*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{d=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,0],
        e=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*e-d*(b^2-2*a*c)-c*(b*d-2*a*e)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(a+b*x^2+c*x^4)^(p+1)*
    ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*PolynomialQuotient[x^m*Pq,a+b*x^2+c*x^4,x]+
      b^2*d*(2*p+3)-2*a*c*d*(4*p+5)-a*b*e+c*(4*p+7)*(b*d-2*a*e)*x^2,x],x]] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && 
  PositiveIntegerQ[m/2]


Int[x_^m_*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{d=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,0],
        e=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*e-d*(b^2-2*a*c)-c*(b*d-2*a*e)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[x^m*(a+b*x^2+c*x^4)^(p+1)*
    ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*x^(-m)*PolynomialQuotient[x^m*Pq,a+b*x^2+c*x^4,x]+
      (b^2*d*(2*p+3)-2*a*c*d*(4*p+5)-a*b*e)*x^(-m)+c*(4*p+7)*(b*d-2*a*e)*x^(2-m),x],x]] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && 
  NegativeIntegerQ[m/2]


(* Int[x_^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{d=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,1],
        e=Coeff[PolynomialRemainder[x^m*Pq,a+b*x^2+c*x^4,x],x,3]},
  x^2*(a+b*x^2+c*x^4)^(p+1)*(a*b*e-d*(b^2-2*a*c)-c*(b*d-2*a*e)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(a*(p+1)*(b^2-4*a*c))*Int[x^m*(a+b*x^2+c*x^4)^(p+1)*
    ExpandToSum[a*(p+1)*(b^2-4*a*c)*x^(-m)*PolynomialQuotient[x^m*Pq,a+b*x^2+c*x^4,x]+
      (b^2*d*(p+2)-2*a*c*d*(2*p+3)-a*b*e)*x^(1-m)+2*c*(p+2)*(b*d-2*a*e)*x^(3-m),x],x]] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && 
  IntegerQ[(m-1)/2] *)


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Defer[Int][(d*x)^m*Pq*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && PolyQ[Pq,x]





(* ::Subsection::Closed:: *)
(*1.2.2.5 Pq(x) (a+b x^2+c x^4)^p*)


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x^2+c*x^4)^p,x],x] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && IGtQ[p,0]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Int[x*ExpandToSum[Pq/x,x]*(a+b*x^2+c*x^4)^p,x] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0],0]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],k},
  Int[Sum[Coeff[Pq,x,2*k]*x^(2*k),{k,0,q/2}]*(a+b*x^2+c*x^4)^p,x] + 
  Int[x*Sum[Coeff[Pq,x,2*k+1]*x^(2*k),{k,0,(q-1)/2}]*(a+b*x^2+c*x^4)^p,x]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && Not[PolyQ[Pq,x^2]]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  With[{d=Coeff[Pq,x,0],e=Coeff[Pq,x,2],f=Coeff[Pq,x,4]},
  d*x*(a+b*x^2+c*x^4)^(p+1)/a /;
 EqQ[a*e-b*d*(2*p+3),0] && EqQ[a*f-c*d*(4*p+5),0]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x^2] && EqQ[Expon[Pq,x],4]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_.,x_Symbol] :=
  With[{d=Coeff[Pq,x,0],e=Coeff[Pq,x,2],f=Coeff[Pq,x,4],g=Coeff[Pq,x,6]},
  x*(3*a*d+(a*e-b*d*(2*p+3))*x^2)*(a+b*x^2+c*x^4)^(p+1)/(3*a^2) /;
 EqQ[3*a^2*g-c*(4*p+7)*(a*e-b*d*(2*p+3)),0] && EqQ[3*a^2*f-3*a*c*d*(4*p+5)-b*(2*p+5)*(a*e-b*d*(2*p+3)),0]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x^2] && EqQ[Expon[Pq,x],6]


Int[Pq_/(a_+b_.*x_^2+c_.*x_^4),x_Symbol] :=
  Int[ExpandIntegrand[Pq/(a+b*x^2+c*x^4),x],x] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  (a+b*x^2+c*x^4)^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x^2)^(2*FracPart[p]))*Int[Pq*(b+2*c*x^2)^(2*p),x] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && EqQ[b^2-4*a*c,0]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{d=Coeff[PolynomialRemainder[Pq,a+b*x^2+c*x^4,x],x,0],
        e=Coeff[PolynomialRemainder[Pq,a+b*x^2+c*x^4,x],x,2]},
  x*(a+b*x^2+c*x^4)^(p+1)*(a*b*e-d*(b^2-2*a*c)-c*(b*d-2*a*e)*x^2)/(2*a*(p+1)*(b^2-4*a*c)) + 
  1/(2*a*(p+1)*(b^2-4*a*c))*Int[(a+b*x^2+c*x^4)^(p+1)*
    ExpandToSum[2*a*(p+1)*(b^2-4*a*c)*PolynomialQuotient[Pq,a+b*x^2+c*x^4,x]+
      b^2*d*(2*p+3)-2*a*c*d*(4*p+5)-a*b*e+c*(4*p+7)*(b*d-2*a*e)*x^2,x],x]] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && NeQ[b^2-4*a*c,0] && LtQ[p,-1]


Int[Pq_*(a_+b_.*x_^2+c_.*x_^4)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x^2],e=Coeff[Pq,x^2,Expon[Pq,x^2]]},
  e*x^(2*q-3)*(a+b*x^2+c*x^4)^(p+1)/(c*(2*q+4*p+1)) + 
  1/(c*(2*q+4*p+1))*Int[(a+b*x^2+c*x^4)^p*
    ExpandToSum[c*(2*q+4*p+1)*Pq-a*e*(2*q-3)*x^(2*q-4)-b*e*(2*q+2*p-1)*x^(2*q-2)-c*e*(2*q+4*p+1)*x^(2*q),x],x]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x^2] && Expon[Pq,x^2]>1 && NeQ[b^2-4*a*c,0] && Not[LtQ[p,-1]]



`)

func resourcesRubi122QuarticTrinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi122QuarticTrinomialProductsM, nil
}

func resourcesRubi122QuarticTrinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi122QuarticTrinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.2.2 Quartic trinomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi123GeneralTrinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.2.3 General Trinomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.2.3.1 (a+b x^n+c x^(2 n))^p*)


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(2*n*p)*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[n2,2*n] && LtQ[n,0] && IntegerQ[p]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[n]},
  k*Subst[Int[x^(k-1)*(a+b*x^(k*n)+c*x^(2*k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a,b,c,p},x] && EqQ[n2,2*n] && FractionQ[n]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n)+c*x^(-2*n))^p/x^2,x],x,1/x] /;
FreeQ[{a,b,c,p},x] && EqQ[n2,2*n] && ILtQ[n,0]


Int[(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^p/(b+2*c*x^n)^(2*p)*Int[(b+2*c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2,2*n] && EqQ[b^2-4*a*c,0]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,n},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c,0] && IGtQ[p,0]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  x*(a+b*x^n+c*x^(2*n))^p/(2*n*p+1) + 
  n*p/(2*n*p+1)*Int[(2*a+b*x^n)*(a+b*x^n+c*x^(2*n))^(p-1),x] /;
FreeQ[{a,b,c,n},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c,0] && GtQ[p,0] && NeQ[2*n*p+1,0] && IntegerQ[p]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -x*(b^2-2*a*c+b*c*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c)) +
  1/(a*n*(p+1)*(b^2-4*a*c))*
    Int[(b^2-2*a*c+n*(p+1)*(b^2-4*a*c)+b*c*(n*(2*p+3)+1)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1),x] /;
FreeQ[{a,b,c,n},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c,0] && LtQ[p,-1] && IntegerQ[p]


Int[1/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*q*r)*Int[(r-x^(n/2))/(q-r*x^(n/2)+x^n),x] + 
  1/(2*c*q*r)*Int[(r+x^(n/2))/(q+r*x^(n/2)+x^n),x]]] /;
FreeQ[{a,b,c},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c,0] && IGtQ[n/2,0] && NegQ[b^2-4*a*c]


Int[1/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  c/q*Int[1/(b/2-q/2+c*x^n),x] - c/q*Int[1/(b/2+q/2+c*x^n),x]] /;
FreeQ[{a,b,c},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c,0]


Int[(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n+c*x^(2*n))^FracPart[p]/
    ((1+2*c*x^n/(b+Rt[b^2-4*a*c,2]))^FracPart[p]*(1+2*c*x^n/(b-Rt[b^2-4*a*c,2]))^FracPart[p])*
    Int[(1+2*c*x^n/(b+Sqrt[b^2-4*a*c]))^p*(1+2*c*x^n/(b-Sqrt[b^2-4*a*c]))^p,x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2,2*n]


Int[(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  Int[(b+a*x^n+c*x^(2*n))^p/x^(n*p),x] /;
FreeQ[{a,b,c,n},x] && EqQ[mn,-n] && IntegerQ[p] && PosQ[n]


Int[(a_+b_.*x_^mn_+c_.*x_^n_.)^p_,x_Symbol] :=
  x^(n*FracPart[p])*(a+b*x^(-n)+c*x^n)^FracPart[p]/(b+a*x^n+c*x^(2*n))^FracPart[p]*Int[(b+a*x^n+c*x^(2*n))^p/x^(n*p),x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[mn,-n] && Not[IntegerQ[p]] && PosQ[n]


Int[(a_+b_.*u_^n_+c_.*u_^n2_.)^p_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a+b*x^n+c*x^(2*n))^p,x],x,u] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2,2*n] && LinearQ[u,x] && NeQ[u,x]





(* ::Subsection::Closed:: *)
(*1.2.3.2 (d x)^m (a+b x^n+c x^(2 n))^p*)


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2,2*n] && EqQ[Simplify[m-n+1]]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2,2*n] && PositiveIntegerQ[p] && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  Int[x^(m+2*n*p)*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,m,n},x] && EqQ[n2,2*n] && NegativeIntegerQ[p] && NegQ[n]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[(m+1)/n]]


Int[(d_*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d^IntPart[m]*(d*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(a+b*x^(n/k)+c*x^(2*n/k))^p,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,b,c,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(d_.*x_)^m_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/d*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n)/d^n+c*x^(2*k*n)/d^(2*n))^p,x],x,(d*x)^(1/k)]] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && FractionQ[m] && IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^(n-1)*(d*x)^(m-n+1)*(b*n*p+c*(m+n*(2*p-1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^p/(c*(m+2*n*p+1)*(m+n*(2*p-1)+1)) - 
  n*p*d^n/(c*(m+2*n*p+1)*(m+n*(2*p-1)+1))*
    Int[(d*x)^(m-n)*(a+b*x^n+c*x^(2*n))^(p-1)*Simp[a*b*(m-n+1)-(2*a*c*(m+n*(2*p-1)+1)-b^2*(m+n*(p-1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m>n-1 && 
  m+2*n*p+1!=0 && m+n*(2*p-1)+1!=0 && IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^n+c*x^(2*n))^p/(d*(m+1)) - 
  n*p/(d^n*(m+1))*Int[(d*x)^(m+n)*(b+2*c*x^n)*(a+b*x^n+c*x^(2*n))^(p-1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-1 && IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^n+c*x^(2*n))^p/(d*(m+2*n*p+1)) + 
  n*p/(m+2*n*p+1)*Int[(d*x)^m*(2*a+b*x^n)*(a+b*x^n+c*x^(2*n))^(p-1),x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p>0 && NeQ[m+2*n*p+1] && 
  IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^(n-1)*(d*x)^(m-n+1)*(b+2*c*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(n*(p+1)*(b^2-4*a*c)) - 
  d^n/(n*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^(m-n)*(b*(m-n+1)+2*c*(m+2*n*(p+1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && n-1<m<=2*n-1 && 
  IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -d^(2*n-1)*(d*x)^(m-2*n+1)*(2*a+b*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(n*(p+1)*(b^2-4*a*c)) + 
  d^(2*n)/(n*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^(m-2*n)*(2*a*(m-2*n+1)+b*(m+n*(2*p+1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>2*n-1 && 
  IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -(d*x)^(m+1)*(b^2-2*a*c+b*c*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*d*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^m*(a+b*x^n+c*x^(2*n))^(p+1)*Simp[b^2*(n*(p+1)+m+1)-2*a*c*(m+2*n*(p+1)+1)+b*c*(2*n*p+3*n+m+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && IntegerQ[p]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^(2*n-1)*(d*x)^(m-2*n+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(c*(m+2*n*p+1)) - 
  d^(2*n)/(c*(m+2*n*p+1))*
    Int[(d*x)^(m-2*n)*Simp[a*(m-2*n+1)+b*(m+n*(p-1)+1)*x^n,x]*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m>2*n-1 && 
  NeQ[m+2*n*p+1] && IntegerQ[p]


Int[(d_.*x_)^m_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*d*(m+1)) - 
  1/(a*d^n*(m+1))*Int[(d*x)^(m+n)*(b*(m+n*(p+1)+1)+c*(m+2*n*(p+1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && IntegerQ[p]


Int[(d_.*x_)^m_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  (d*x)^(m+1)/(a*d*(m+1)) -
  1/(a*d^n)*Int[(d*x)^(m+n)*(b+c*x^n)/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m<-1


Int[x_^m_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  Int[PolynomialDivide[x^m,(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[m] && m>3*n-1


Int[(d_.*x_)^m_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  d^(2*n-1)*(d*x)^(m-2*n+1)/(c*(m-2*n+1)) -
  d^(2*n)/c*Int[(d*x)^(m-2*n)*(a+b*x^n)/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m>2*n-1


Int[x_^m_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*r)*Int[x^(m-3*(n/2))*(q+r*x^(n/2))/(q+r*x^(n/2)+x^n),x] - 
  1/(2*c*r)*Int[x^(m-3*(n/2))*(q-r*x^(n/2))/(q-r*x^(n/2)+x^n),x]]] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n/2,m] && 3*n/2<=m<2*n && NegQ[b^2-4*a*c]


Int[x_^m_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*r)*Int[x^(m-n/2)/(q-r*x^(n/2)+x^n),x] - 
  1/(2*c*r)*Int[x^(m-n/2)/(q+r*x^(n/2)+x^n),x]]] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n/2,m] && n/2<=m<3*n/2 && NegQ[b^2-4*a*c]


Int[(d_.*x_)^m_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  d^n/2*(b/q+1)*Int[(d*x)^(m-n)/(b/2+q/2+c*x^n),x] - 
  d^n/2*(b/q-1)*Int[(d*x)^(m-n)/(b/2-q/2+c*x^n),x]] /;
FreeQ[{a,b,c,d},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m>=n


Int[(d_.*x_)^m_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  c/q*Int[(d*x)^m/(b/2-q/2+c*x^n),x] - c/q*Int[(d*x)^m/(b/2+q/2+c*x^n),x]] /;
FreeQ[{a,b,c,d,m},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -Subst[Int[(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  -k/d*Subst[Int[(a+b*d^(-n)*x^(-k*n)+c*d^(-2*n)*x^(-2*k*n))^p/x^(k*(m+1)+1),x],x,1/(d*x)^(1/k)]] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && FractionQ[m]


Int[(d_.*x_)^m_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -d^IntPart[m]*(d*x)^FracPart[m]*(x^(-1))^FracPart[m]*Subst[Int[(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[n]},
  k*Subst[Int[x^(k*(m+1)-1)*(a+b*x^(k*n)+c*x^(2*k*n))^p,x],x,x^(1/k)]] /;
FreeQ[{a,b,c,m,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[(d_*x_)^m_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^IntPart[m]*(d*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[x_^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(a+b*x^Simplify[n/(m+1)]+c*x^Simplify[2*n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(d_*x_)^m_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^IntPart[m]*(d*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(d_.*x_)^m_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[(d*x)^m/(b-q+2*c*x^n),x] -
  2*c/q*Int[(d*x)^m/(b+q+2*c*x^n),x]] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -(d*x)^(m+1)*(b^2-2*a*c+b*c*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*d*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*
    Int[(d*x)^m*(a+b*x^n+c*x^(2*n))^(p+1)*Simp[b^2*(n*(p+1)+m+1)-2*a*c*(m+2*n*(p+1)+1)+b*c*(2*n*p+3*n+m+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2,2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_.*x_)^m_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  a^IntPart[p]*(a+b*x^n+c*x^(2*n))^FracPart[p]/
    ((1+2*c*x^n/(b+Rt[b^2-4*a*c,2]))^FracPart[p]*(1+2*c*x^n/(b-Rt[b^2-4*a*c,2]))^FracPart[p])*
    Int[(d*x)^m*(1+2*c*x^n/(b+Sqrt[b^2-4*a*c]))^p*(1+2*c*x^n/(b-Sqrt[b^2-4*a*c]))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2,2*n]


Int[x_^m_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  Int[x^(m-n*p)*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,m,n},x] && EqQ[mn,-n] && IntegerQ[p] && PosQ[n]


Int[x_^m_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  x^(n*FracPart[p])*(a+b/x^n+c*x^n)^FracPart[p]/(b+a*x^n+c*x^(2*n))^FracPart[p]*Int[x^(m-n*p)*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[mn,-n] && Not[IntegerQ[p]] && PosQ[n]


Int[(d_*x_)^m_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  d^IntPart[m]*(d*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(a+b*x^(-n)+c*x^n)^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[mn,-n]


Int[x_^m_.*(a_.+b_.*v_^n_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  1/Coefficient[v,x,1]^(m+1)*Subst[Int[SimplifyIntegrand[(x-Coefficient[v,x,0])^m*(a+b*x^n+c*x^(2*n))^p,x],x],x,v] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2,2*n] && LinearQ[v,x] && IntegerQ[m] && NeQ[v-x]


Int[u_^m_.*(a_.+b_.*v_^n_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(a+b*x^n+c*x^(2*n))^p,x],x,v] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2,2*n] && LinearPairQ[u,v,x]





(* ::Subsection::Closed:: *)
(*1.2.3.3 (d+e x^n)^q (a+b x^n+c x^(2 n))^p*)


Int[(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(n*(2*p+q))*(e+d*x^(-n))^q*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && IntegersQ[p,q] && NegQ[n]


Int[(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(n*(2*p+q))*(e+d*x^(-n))^q*(c+a*x^(-2*n))^p,x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && IntegersQ[p,q] && NegQ[n]


Int[(d_+e_.*x_^n_)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -Subst[Int[(d+e*x^(-n))^q*(a+b*x^(-n)+c*x^(-2*n))^p/x^2,x],x,1/x] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[n]


Int[(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -Subst[Int[(d+e*x^(-n))^q*(a+c*x^(-2*n))^p/x^2,x],x,1/x] /;
FreeQ[{a,c,d,e,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[n]


Int[(d_+e_.*x_^n_)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g-1)*(d+e*x^(g*n))^q*(a+b*x^(g*n)+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[n2-2*n] && FractionQ[n]


Int[(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g-1)*(d+e*x^(g*n))^q*(a+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,c,d,e,p,q},x] && EqQ[n2-2*n] && FractionQ[n]


Int[(d_+e_.*x_^n_)*(b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (b*e-d*c)*(b*x^n+c*x^(2*n))^(p+1)/(b*c*n*(p+1)*x^(2*n*(p+1))) + 
  e/c*Int[x^(-n)*(b*x^n+c*x^(2*n))^(p+1),x] /;
FreeQ[{b,c,d,e,n,p},x] && EqQ[n2-2*n] && Not[IntegerQ[p]] && EqQ[n*(2*p+1)+1]


Int[(d_+e_.*x_^n_)*(b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  e*x^(-n+1)*(b*x^n+c*x^(2*n))^(p+1)/(c*(n*(2*p+1)+1)) /;
FreeQ[{b,c,d,e,n,p},x] && EqQ[n2-2*n] && Not[IntegerQ[p]] && NeQ[n*(2*p+1)+1] && EqQ[b*e*(n*p+1)-c*d*(n*(2*p+1)+1)]


Int[(d_+e_.*x_^n_)*(b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  e*x^(-n+1)*(b*x^n+c*x^(2*n))^(p+1)/(c*(n*(2*p+1)+1)) - 
  (b*e*(n*p+1)-c*d*(n*(2*p+1)+1))/(c*(n*(2*p+1)+1))*Int[(b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{b,c,d,e,n,p},x] && EqQ[n2-2*n] && Not[IntegerQ[p]] && NeQ[n*(2*p+1)+1] && NeQ[b*e*(n*p+1)-c*d*(n*(2*p+1)+1)]


Int[(d_+e_.*x_^n_)^q_.*(b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (b*x^n+c*x^(2*n))^FracPart[p]/(x^(n*FracPart[p])*(b+c*x^n)^FracPart[p])*Int[x^(n*p)*(d+e*x^n)^q*(b+c*x^n)^p,x] /;
FreeQ[{b,c,d,e,n,p,q},x] && EqQ[n2-2*n] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(d+e*x^n)^(p+q)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(d+e*x^n)^(p+q)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,n,q},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*Int[(d+e*x^n)^(p+q)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*Int[(d+e*x^n)^(p+q)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,n,p,q},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q*(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[q]


Int[(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q*(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && PositiveIntegerQ[q]


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  -(c*d^2-b*d*e+a*e^2)*x*(d+e*x^n)^(q+1)/(d*e^2*n*(q+1)) + 
  1/(n*(q+1)*d*e^2)*Int[(d+e*x^n)^(q+1)*Simp[c*d^2-b*d*e+a*e^2*(n*(q+1)+1)+c*d*e*n*(q+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_),x_Symbol] :=
  -(c*d^2+a*e^2)*x*(d+e*x^n)^(q+1)/(d*e^2*n*(q+1)) + 
  1/(n*(q+1)*d*e^2)*Int[(d+e*x^n)^(q+1)*Simp[c*d^2+a*e^2*(n*(q+1)+1)+c*d*e*n*(q+1)*x^n,x],x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  c*x^(n+1)*(d+e*x^n)^(q+1)/(e*(n*(q+2)+1)) + 
  1/(e*(n*(q+2)+1))*Int[(d+e*x^n)^q*(a*e*(n*(q+2)+1)-(c*d*(n+1)-b*e*(n*(q+2)+1))*x^n),x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2]


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_),x_Symbol] :=
  c*x^(n+1)*(d+e*x^n)^(q+1)/(e*(n*(q+2)+1)) + 
  1/(e*(n*(q+2)+1))*Int[(d+e*x^n)^q*(a*e*(n*(q+2)+1)-c*d*(n+1)*x^n),x] /;
FreeQ[{a,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2]


Int[(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[2*d*e,2]},
  e^2/(2*c)*Int[1/(d+q*x^(n/2)+e*x^n),x] + e^2/(2*c)*Int[1/(d-q*x^(n/2)+e*x^n),x]] /;
FreeQ[{a,c,d,e},x] && EqQ[n2-2*n] && EqQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && PosQ[d*e]


Int[(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[-2*d*e,2]},
  d/(2*a)*Int[(d-q*x^(n/2))/(d-q*x^(n/2)-e*x^n),x] + 
  d/(2*a)*Int[(d+q*x^(n/2))/(d+q*x^(n/2)-e*x^n),x]] /;
FreeQ[{a,c,d,e},x] && EqQ[n2-2*n] && EqQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && NegQ[d*e]


Int[(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a/c,4]},
  1/(2*Sqrt[2]*c*q^3)*Int[(Sqrt[2]*d*q-(d-e*q^2)*x^(n/2))/(q^2-Sqrt[2]*q*x^(n/2)+x^n),x] + 
  1/(2*Sqrt[2]*c*q^3)*Int[(Sqrt[2]*d*q+(d-e*q^2)*x^(n/2))/(q^2+Sqrt[2]*q*x^(n/2)+x^n),x]] /;
FreeQ[{a,c,d,e},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && NeQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && PosQ[a*c]


Int[(d_+e_.*x_^3)/(a_+c_.*x_^6),x_Symbol] :=
  With[{q=Rt[c/a,6]},
  1/(3*a*q^2)*Int[(q^2*d-e*x)/(1+q^2*x^2),x] + 
  1/(6*a*q^2)*Int[(2*q^2*d-(Sqrt[3]*q^3*d-e)*x)/(1-Sqrt[3]*q*x+q^2*x^2),x] + 
  1/(6*a*q^2)*Int[(2*q^2*d+(Sqrt[3]*q^3*d+e)*x)/(1+Sqrt[3]*q*x+q^2*x^2),x]] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^2+a*e^2] && PosQ[c/a]


Int[(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[-a/c,2]},
  (d+e*q)/2*Int[1/(a+c*q*x^n),x] + (d-e*q)/2*Int[1/(a-c*q*x^n),x]] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && NegQ[a*c] && IntegerQ[n]


Int[(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  d*Int[1/(a+c*x^(2*n)),x] + e*Int[x^n/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && (PosQ[a*c] || Not[IntegerQ[n]])


Int[(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[2*d/e-b/c,2]},
  e/(2*c)*Int[1/Simp[d/e+q*x^(n/2)+x^n,x],x] + 
  e/(2*c)*Int[1/Simp[d/e-q*x^(n/2)+x^n,x],x]] /;
FreeQ[{a,b,c,d,e},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && 
  (PositiveQ[2*d/e-b/c] || Not[NegativeQ[2*d/e-b/c]] && EqQ[d-e*Rt[a/c,2]])


Int[(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[1/(b/2-q/2+c*x^n),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[1/(b/2+q/2+c*x^n),x]] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && 
  PositiveQ[b^2-4*a*c]


Int[(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[-2*d/e-b/c,2]},
  e/(2*c*q)*Int[(q-2*x^(n/2))/Simp[d/e+q*x^(n/2)-x^n,x],x] + 
  e/(2*c*q)*Int[(q+2*x^(n/2))/Simp[d/e-q*x^(n/2)-x^n,x],x]] /;
FreeQ[{a,b,c,d,e},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-a*e^2] && PositiveIntegerQ[n/2] && 
  Not[PositiveQ[b^2-4*a*c]]


Int[(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[1/(b/2-q/2+c*x^n),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[1/(b/2+q/2+c*x^n),x]] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  (PosQ[b^2-4*a*c] || Not[PositiveIntegerQ[n/2]])


Int[(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a/c,2]},
  With[{r=Rt[2*q-b/c,2]},
  1/(2*c*q*r)*Int[(d*r-(d-e*q)*x^(n/2))/(q-r*x^(n/2)+x^n),x] + 
  1/(2*c*q*r)*Int[(d*r+(d-e*q)*x^(n/2))/(q+r*x^(n/2)+x^n),x]]] /;
FreeQ[{a,b,c,d,e},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && PositiveIntegerQ[n/2] && 
  NegQ[b^2-4*a*c]


Int[(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && IntegerQ[q]


Int[(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q/(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && IntegerQ[q]


Int[(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  e^2/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x^n)^q,x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(d+e*x^n)^(q+1)*(c*d-b*e-c*e*x^n)/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[q]] && 
  RationalQ[q] && q<-1


Int[(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_),x_Symbol] :=
  e^2/(c*d^2+a*e^2)*Int[(d+e*x^n)^q,x] + 
  c/(c*d^2+a*e^2)*Int[(d+e*x^n)^(q+1)*(d-e*x^n)/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  2*c/r*Int[(d+e*x^n)^q/(b-r+2*c*x^n),x] - 2*c/r*Int[(d+e*x^n)^q/(b+r+2*c*x^n),x]] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[q]]


Int[(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{r=Rt[-a*c,2]},
  -c/(2*r)*Int[(d+e*x^n)^q/(r-c*x^n),x] - c/(2*r)*Int[(d+e*x^n)^q/(r+c*x^n),x]] /;
FreeQ[{a,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && Not[IntegerQ[q]]


Int[(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  x*(b*e*n*p+c*d*(2*n*p+n+1)+c*e*(2*n*p+1)*x^n)*(a+b*x^n+c*x^(2*n))^p/(c*(2*n*p+1)*(2*n*p+n+1)) + 
  n*p/(c*(2*n*p+1)*(2*n*p+n+1))*
    Int[Simp[2*a*c*d*(2*n*p+n+1)-a*b*e+(2*a*c*e*(2*n*p+1)+b*d*c*(2*n*p+n+1)-b^2*e*(n*p+1))*x^n,x]*
      (a+b*x^n+c*x^(2*n))^(p-1),x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && FractionQ[p] && p>0 && NeQ[2*n*p+1] && NeQ[2*n*p+n+1] && 
  IntegerQ[p]


Int[(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  x*(d*(2*n*p+n+1)+e*(2*n*p+1)*x^n)*(a+c*x^(2*n))^p/((2*n*p+1)*(2*n*p+n+1)) + 
  2*a*n*p/((2*n*p+1)*(2*n*p+n+1))*Int[(d*(2*n*p+n+1)+e*(2*n*p+1)*x^n)*(a+c*x^(2*n))^(p-1),x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && FractionQ[p] && p>0 && NeQ[2*n*p+1] && NeQ[2*n*p+n+1] && 
  IntegerQ[p]


Int[(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(d*b^2-a*b*e-2*a*c*d+(b*d-2*a*e)*c*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*
    Int[Simp[(n*p+n+1)*d*b^2-a*b*e-2*a*c*d*(2*n*p+2*n+1)+(2*n*p+3*n+1)*(d*b-2*a*e)*c*x^n,x]*
      (a+b*x^n+c*x^(2*n))^(p+1),x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1 && IntegerQ[p]


Int[(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(d+e*x^n)*(a+c*x^(2*n))^(p+1)/(2*a*n*(p+1)) + 
  1/(2*a*n*(p+1))*Int[(d*(2*n*p+2*n+1)+e*(2*n*p+3*n+1)*x^n)*(a+c*x^(2*n))^(p+1),x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n] && RationalQ[p] && p<-1 && IntegerQ[p]


Int[(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c]


Int[(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)*(a+c*x^(2*n))^p,x],x] /;
FreeQ[{a,c,d,e,n},x] && EqQ[n2-2*n]


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  c^p*x^(2*n*p-n+1)*(d+e*x^n)^(q+1)/(e*(2*n*p+n*q+1)) + 
  Int[(d+e*x^n)^q*ExpandToSum[(a+b*x^n+c*x^(2*n))^p-c^p*x^(2*n*p)-d*c^p*(2*n*p-n+1)*x^(2*n*p-n)/(e*(2*n*p+n*q+1)),x],x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[p] && 
  NeQ[2*n*p+n*q+1] && PositiveIntegerQ[n] && Not[PositiveIntegerQ[q]]


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  c^p*x^(2*n*p-n+1)*(d+e*x^n)^(q+1)/(e*(2*n*p+n*q+1)) + 
  Int[(d+e*x^n)^q*ExpandToSum[(a+c*x^(2*n))^p-c^p*x^(2*n*p)-d*c^p*(2*n*p-n+1)*x^(2*n*p-n)/(e*(2*n*p+n*q+1)),x],x] /;
FreeQ[{a,c,d,e,n,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[p] && 
  NeQ[2*n*p+n*q+1] && PositiveIntegerQ[n] && Not[PositiveIntegerQ[q]]


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && 
  (IntegersQ[p,q] && Not[IntegerQ[n]] || PositiveIntegerQ[p] || PositiveIntegerQ[q] && Not[IntegerQ[n]])


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q*(a+c*x^(2*n))^p,x],x] /;
FreeQ[{a,c,d,e,n,p,q},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && 
  (IntegersQ[p,q] && Not[IntegerQ[n]] || PositiveIntegerQ[p] || PositiveIntegerQ[q] && Not[IntegerQ[n]])


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(a+c*x^(2*n))^p,(d/(d^2-e^2*x^(2*n))-e*x^n/(d^2-e^2*x^(2*n)))^(-q),x],x] /;
FreeQ[{a,c,d,e,n,p},x] && EqQ[n2-2*n] && NeQ[c*d^2+a*e^2] && NegativeIntegerQ[q] && Not[IntegersQ[n,2*p]]


Int[(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Defer[Int][(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2-2*n] && Not[IntegersQ[n,q]]


Int[(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  Defer[Int][(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,n,p,q},x] && EqQ[n2-2*n] && Not[IntegersQ[n,q]]


Int[(d_+e_.*u_^n_)^q_.*(a_+b_.*u_^n_+c_.*u_^n2_)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x],x,u] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2-2*n] && LinearQ[u,x] && NeQ[u-x]


Int[(d_+e_.*u_^n_)^q_.*(a_+c_.*u_^n2_)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(d+e*x^n)^q*(a+c*x^(2*n))^p,x],x,u] /;
FreeQ[{a,c,d,e,n,p,q},x] && EqQ[n2-2*n] && LinearQ[u,x] && NeQ[u-x]


Int[(d_+e_.*x_^mn_.)^q_.*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(-n*q)*(e+d*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,p},x] && EqQ[n2,2*n] && EqQ[mn,-n] && IntegerQ[q]


Int[(d_+e_.*x_^mn_.)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(mn*q)*(e+d*x^(-mn))^q*(a+c*x^n2)^p,x] /;
FreeQ[{a,c,d,e,mn,p},x] && EqQ[n2,-2*mn] && IntegerQ[q]


Int[(d_+e_.*x_^mn_.)^q_*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(2*n*p)*(d+e*x^(-n))^q*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2,2*n] && EqQ[mn,-n] && Not[IntegerQ[q]] && IntegerQ[p]


Int[(d_+e_.*x_^mn_.)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(-2*mn*p)*(d+e*x^mn)^q*(c+a*x^(2*mn))^p,x] /;
FreeQ[{a,c,d,e,mn,q},x] && EqQ[n2,-2*mn] && Not[IntegerQ[q]] && IntegerQ[p]


Int[(d_+e_.*x_^mn_.)^q_*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  x^(n*FracPart[q])*(d+e*x^(-n))^FracPart[q]/(e+d*x^n)^FracPart[q]*Int[x^(-n*q)*(e+d*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[n2,2*n] && EqQ[mn,-n] && Not[IntegerQ[q]] && Not[IntegerQ[p]] && PosQ[n]


Int[(d_+e_.*x_^mn_.)^q_*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  x^(-mn*FracPart[q])*(d+e*x^mn)^FracPart[q]/(e+d*x^(-mn))^FracPart[q]*Int[x^(mn*q)*(e+d*x^(-mn))^q*(a+c*x^n2)^p,x] /;
FreeQ[{a,c,d,e,mn,p,q},x] && EqQ[n2,-2*mn] && Not[IntegerQ[q]] && Not[IntegerQ[p]] && PosQ[n2]


Int[(d_+e_.*x_^mn_.)^q_*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/(x^(2*n*FracPart[p])*(c+b*x^(-n)+a*x^(-2*n))^FracPart[p])*
    Int[x^(2*n*p)*(d+e*x^(-n))^q*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[n2,2*n] && EqQ[mn,-n] && Not[IntegerQ[q]] && Not[IntegerQ[p]] && NegQ[n]


Int[(d_+e_.*x_^mn_.)^q_*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+c*x^n2)^FracPart[p]/(x^(n2*FracPart[p])*(c+a*x^(2*mn))^FracPart[p])*
    Int[x^(n2*p)*(d+e*x^mn)^q*(c+a*x^(2*mn))^p,x] /;
FreeQ[{a,c,d,e,mn,q},x] && EqQ[n2,-2*mn] && Not[IntegerQ[q]] && Not[IntegerQ[p]] && NegQ[n2]


Int[(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  Int[x^(-n*p)*(d+e*x^n)^q*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,q},x] && EqQ[mn,-n] && IntegerQ[p]


Int[(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  x^(n*FracPart[p])*(a+b/x^n+c*x^n)^FracPart[p]/(b+a*x^n+c*x^(2*n))^FracPart[p]*
    Int[x^(-n*p)*(d+e*x^n)^q*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,n,p,q},x] && EqQ[mn,-n] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_.*(f_+g_.*x_^n_)^r_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x^n)^(2*FracPart[p]))*
    Int[(d+e*x^n)^q*(f+g*x^n)^r*(b+2*c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,d,e,f,g,n,p,q,r},x] && EqQ[n2-2*n] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_.*(f_+g_.*x_^n_)^r_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(d+e*x^n)^(p+q)*(f+g*x^n)^r*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,n,q,r},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^n_)^q_.*(f_+g_.*x_^n_)^r_.*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(d+e*x^n)^(p+q)*(f+g*x^n)^r*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,f,g,n,q,r},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && IntegerQ[p]


Int[(d_+e_.*x_^n_)^q_.*(f_+g_.*x_^n_)^r_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*
    Int[(d+e*x^n)^(p+q)*(f+g*x^n)^r*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,n,p,q,r},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(d_+e_.*x_^n_)^q_.*(f_+g_.*x_^n_)^r_.*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*
    Int[(d+e*x^n)^(p+q)*(f+g*x^n)^r*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,f,g,n,p,q,r},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[(f_.+g_.*x_^2)/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (2*c*f-g*(b-q))/(2*c*d-e*(b-q))*Int[1/Sqrt[a+b*x^2+c*x^4],x] - 
  (e*f-d*g)/(2*c*d-e*(b-q))*Int[(b-q+2*c*x^2)/((d+e*x^2)*Sqrt[a+b*x^2+c*x^4]),x] /;
 NeQ[2*c*f-g*(b-q)]] /;
FreeQ[{a,b,c,d,e,f,g},x] && PositiveQ[b^2-4*a*c] && NeQ[c*d^2-b*d*e+a*e^2] && Not[NegativeQ[c]]


Int[(f_+g_.*x_^2)/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  (c*f+g*q)/(c*d+e*q)*Int[1/Sqrt[a+c*x^4],x] + (e*f-d*g)/(c*d+e*q)*Int[(q-c*x^2)/((d+e*x^2)*Sqrt[a+c*x^4]),x] /;
 NeQ[c*f+g*q]] /;
FreeQ[{a,c,d,e,f,g},x] && PositiveQ[-a*c] && NeQ[c*d^2+a*e^2] && Not[NegativeQ[c]]


Int[(d1_+e1_.*x_^non2_.)^q_.*(d2_+e2_.*x_^non2_.)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(d1*d2+e1*e2*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d1,e1,d2,e2,n,p,q},x] && EqQ[n2-2*n] && EqQ[non2-n/2] && EqQ[d2*e1+d1*e2] && 
  (IntegerQ[q] || PositiveQ[d1] && PositiveQ[d2])


Int[(d1_+e1_.*x_^non2_.)^q_.*(d2_+e2_.*x_^non2_.)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (d1+e1*x^(n/2))^FracPart[q]*(d2+e2*x^(n/2))^FracPart[q]/(d1*d2+e1*e2*x^n)^FracPart[q]*
    Int[(d1*d2+e1*e2*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d1,e1,d2,e2,n,p,q},x] && EqQ[n2-2*n] && EqQ[non2-n/2] && EqQ[d2*e1+d1*e2]


Int[(A_+B_.*x_^m_.)*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  A*Int[(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] + B*Int[x^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,A,B,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[m-n+1]


Int[(A_+B_.*x_^m_.)*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  A*Int[(d+e*x^n)^q*(a+c*x^(2*n))^p,x] + B*Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,A,B,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[m-n+1]





(* ::Subsection::Closed:: *)
(*1.2.3.4 (f x)^m (d+e x^n)^q (a+b x^n+c x^(2 n))^p*)


Int[(f_.*x_)^m_.*(e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^m/(n*e^((m+1)/n-1))*Subst[Int[(e*x)^(q+(m+1)/n-1)*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && (IntegerQ[m] || PositiveQ[f]) && IntegerQ[Simplify[(m+1)/n]]


Int[(f_.*x_)^m_.*(e_.*x_^n_)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^m/(n*e^((m+1)/n-1))*Subst[Int[(e*x)^(q+(m+1)/n-1)*(a+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && (IntegerQ[m] || PositiveQ[f]) && IntegerQ[Simplify[(m+1)/n]]


Int[(f_.*x_)^m_.*(e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^m*e^IntPart[q]*(e*x^n)^FracPart[q]/x^(n*FracPart[q])*Int[x^(m+n*q)*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && (IntegerQ[m] || PositiveQ[f]) && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[(f_.*x_)^m_.*(e_.*x_^n_)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^m*e^IntPart[q]*(e*x^n)^FracPart[q]/x^(n*FracPart[q])*Int[x^(m+n*q)*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && (IntegerQ[m] || PositiveQ[f]) && Not[IntegerQ[Simplify[(m+1)/n]]]


Int[(f_*x_)^m_.*(e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && Not[IntegerQ[m]]


Int[(f_*x_)^m_.*(e_.*x_^n_)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,e,f,m,n,p,q},x] && EqQ[n2-2*n] && Not[IntegerQ[m]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[Simplify[m-n+1]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[(d+e*x)^q*(a+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[Simplify[m-n+1]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m+n*(2*p+q))*(e+d*x^(-n))^q*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n},x] && EqQ[n2-2*n] && IntegersQ[p,q] && NegQ[n]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m+n*(2*p+q))*(e+d*x^(-n))^q*(c+a*x^(-2*n))^p,x] /;
FreeQ[{a,c,d,e,m,n},x] && EqQ[n2-2*n] && IntegersQ[p,q] && NegQ[n]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/n*Subst[Int[x^((m+1)/n-1)*(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[n2-2*n] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]] && PositiveIntegerQ[m,n,(m+1)/n]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/(c^IntPart[p]*(b/2+c*x^n)^(2*FracPart[p]))*
    Int[(f*x)^m*(d+e*x^n)^q*(b/2+c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[b^2-4*a*c] && Not[IntegerQ[p]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(d+e*x)^q*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*(d+e*x)^q*(a+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[(m+1)/n]]


Int[(f_*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[(m+1)/n]]


Int[(f_*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[(m+1)/n]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(f*x)^m*(d+e*x^n)^(q+p)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(f*x)^m*(d+e*x^n)^(q+p)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,f,q,m,n,q},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*
    Int[(f*x)^m*(d+e*x^n)^(q+p)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && EqQ[c*d^2-b*d*e+a*e^2] && Not[IntegerQ[p]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  (a+c*x^(2*n))^FracPart[p]/((d+e*x^n)^FracPart[p]*(a/d+(c*x^n)/e)^FracPart[p])*Int[(f*x)^m*(d+e*x^n)^(q+p)*(a/d+c/e*x^n)^p,x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && EqQ[c*d^2+a*e^2] && Not[IntegerQ[p]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  (-d)^((m-Mod[m,n])/n-1)*(c*d^2-b*d*e+a*e^2)^p*x^(Mod[m,n]+1)*(d+e*x^n)^(q+1)/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)) + 
  1/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1))*Int[x^Mod[m,n]*(d+e*x^n)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^n)*(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)*x^(m-Mod[m,n])*(a+b*x^n+c*x^(2*n))^p-
      (-d)^((m-Mod[m,n])/n-1)*(c*d^2-b*d*e+a*e^2)^p*(d*(Mod[m,n]+1)+e*(Mod[m,n]+n*(q+1)+1)*x^n))],x],x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n,p] && IntegersQ[m,q] && q<-1 && m>0


Int[x_^m_.*(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  (-d)^((m-Mod[m,n])/n-1)*(c*d^2+a*e^2)^p*x^(Mod[m,n]+1)*(d+e*x^n)^(q+1)/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)) + 
  1/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1))*Int[x^Mod[m,n]*(d+e*x^n)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^n)*(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)*x^(m-Mod[m,n])*(a+c*x^(2*n))^p-
      (-d)^((m-Mod[m,n])/n-1)*(c*d^2+a*e^2)^p*(d*(Mod[m,n]+1)+e*(Mod[m,n]+n*(q+1)+1)*x^n))],x],x] /;
FreeQ[{a,c,d,e},x] && EqQ[n2-2*n] && PositiveIntegerQ[n,p] && IntegersQ[m,q] && q<-1 && m>0


Int[x_^m_*(d_+e_.*x_^n_)^q_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  (-d)^((m-Mod[m,n])/n-1)*(c*d^2-b*d*e+a*e^2)^p*x^(Mod[m,n]+1)*(d+e*x^n)^(q+1)/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)) + 
  (-d)^((m-Mod[m,n])/n-1)/(n*e^(2*p)*(q+1))*Int[x^m*(d+e*x^n)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^n)*(n*(-d)^(-(m-Mod[m,n])/n+1)*e^(2*p)*(q+1)*(a+b*x^n+c*x^(2*n))^p - 
  (e^(-(m-Mod[m,n])/n)*(c*d^2-b*d*e+a*e^2)^p*x^(-(m-Mod[m,n])))*(d*(Mod[m,n]+1)+e*(Mod[m,n]+n*(q+1)+1)*x^n))],x],x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n,p] && IntegersQ[m,q] && q<-1 && m<0


Int[x_^m_*(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  (-d)^((m-Mod[m,n])/n-1)*(c*d^2+a*e^2)^p*x^(Mod[m,n]+1)*(d+e*x^n)^(q+1)/(n*e^(2*p+(m-Mod[m,n])/n)*(q+1)) + 
  (-d)^((m-Mod[m,n])/n-1)/(n*e^(2*p)*(q+1))*Int[x^m*(d+e*x^n)^(q+1)*
    ExpandToSum[Together[1/(d+e*x^n)*(n*(-d)^(-(m-Mod[m,n])/n+1)*e^(2*p)*(q+1)*(a+c*x^(2*n))^p - 
  (e^(-(m-Mod[m,n])/n)*(c*d^2+a*e^2)^p*x^(-(m-Mod[m,n])))*(d*(Mod[m,n]+1)+e*(Mod[m,n]+n*(q+1)+1)*x^n))],x],x] /;
FreeQ[{a,c,d,e},x] && EqQ[n2-2*n] && PositiveIntegerQ[n,p] && IntegersQ[m,q] && q<-1 && m<0


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  c^p*(f*x)^(m+2*n*p-n+1)*(d+e*x^n)^(q+1)/(e*f^(2*n*p-n+1)*(m+2*n*p+n*q+1)) + 
  1/(e*(m+2*n*p+n*q+1))*Int[(f*x)^m*(d+e*x^n)^q*
    ExpandToSum[e*(m+2*n*p+n*q+1)*((a+b*x^n+c*x^(2*n))^p-c^p*x^(2*n*p))-d*c^p*(m+2*n*p-n+1)*x^(2*n*p-n),x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n,p] && 2*n*p>n-1 && 
  Not[IntegerQ[q]] && NeQ[m+2*n*p+n*q+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  c^p*(f*x)^(m+2*n*p-n+1)*(d+e*x^n)^(q+1)/(e*f^(2*n*p-n+1)*(m+2*n*p+n*q+1)) + 
  1/(e*(m+2*n*p+n*q+1))*Int[(f*x)^m*(d+e*x^n)^q*
    ExpandToSum[e*(m+2*n*p+n*q+1)*((a+c*x^(2*n))^p-c^p*x^(2*n*p))-d*c^p*(m+2*n*p-n+1)*x^(2*n*p-n),x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n,p] && 2*n*p>n-1 && 
  Not[IntegerQ[q]] && NeQ[m+2*n*p+n*q+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n,p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m(d+e*x^n)^q*(a+c*x^(2*n))^p,x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && EqQ[n2-2*n] && EqQ[n2-2*n] && PositiveIntegerQ[n,p]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(d+e*x^(n/k))^q*(a+b*x^(n/k)+c*x^(2*n/k))^p,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[m]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=GCD[m+1,n]},
  1/k*Subst[Int[x^((m+1)/k-1)*(d+e*x^(n/k))^q*(a+c*x^(2*n/k))^p,x],x,x^k] /;
 k!=1] /;
FreeQ[{a,c,d,e,p,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/f*Subst[Int[x^(k*(m+1)-1)*(d+e*x^(k*n)/f^n)^q*(a+b*x^(k*n)/f^n+c*x^(2*k*n)/f^(2*n))^p,x],x,(f*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && FractionQ[m] && IntegerQ[p]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/f*Subst[Int[x^(k*(m+1)-1)*(d+e*x^(k*n)/f)^q*(a+c*x^(2*k*n)/f)^p,x],x,(f*x)^(1/k)]] /;
FreeQ[{a,c,d,e,f,p,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && FractionQ[m] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+b*x^n+c*x^(2*n))^p*(d*(m+n*(2*p+1)+1)+e*(m+1)*x^n)/(f*(m+1)*(m+n*(2*p+1)+1)) + 
  n*p/(f^n*(m+1)*(m+n*(2*p+1)+1))*Int[(f*x)^(m+n)*(a+b*x^n+c*x^(2*n))^(p-1)*
      Simp[2*a*e*(m+1)-b*d*(m+n*(2*p+1)+1)+(b*e*(m+1)-2*c*d*(m+n*(2*p+1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-1 && 
  m+n*(2*p+1)+1!=0 && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+c*x^(2*n))^p*(d*(m+n*(2*p+1)+1)+e*(m+1)*x^n)/(f*(m+1)*(m+n*(2*p+1)+1)) + 
  2*n*p/(f^n*(m+1)*(m+n*(2*p+1)+1))*Int[(f*x)^(m+n)*(a+c*x^(2*n))^(p-1)*(a*e*(m+1)-c*d*(m+n*(2*p+1)+1)*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-1 && 
  m+n*(2*p+1)+1!=0 && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+b*x^n+c*x^(2*n))^p*(b*e*n*p+c*d*(m+n*(2*p+1)+1)+c*e*(2*n*p+m+1)*x^n)/
    (c*f*(2*n*p+m+1)*(m+n*(2*p+1)+1)) + 
  n*p/(c*(2*n*p+m+1)*(m+n*(2*p+1)+1))*Int[(f*x)^m*(a+b*x^n+c*x^(2*n))^(p-1)*
    Simp[2*a*c*d*(m+n*(2*p+1)+1)-a*b*e*(m+1)+(2*a*c*e*(2*n*p+m+1)+b*c*d*(m+n*(2*p+1)+1)-b^2*e*(m+n*p+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p>0 && 
  NeQ[2*n*p+m+1] && NeQ[m+n*(2*p+1)+1] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (f*x)^(m+1)*(a+c*x^(2*n))^p*(c*d*(m+n*(2*p+1)+1)+c*e*(2*n*p+m+1)*x^n)/(c*f*(2*n*p+m+1)*(m+n*(2*p+1)+1)) + 
  2*a*n*p/((2*n*p+m+1)*(m+n*(2*p+1)+1))*Int[(f*x)^m*(a+c*x^(2*n))^(p-1)*Simp[d*(m+n*(2*p+1)+1)+e*(2*n*p+m+1)*x^n,x],x] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[p] && p>0 && 
  NeQ[2*n*p+m+1] && NeQ[m+n*(2*p+1)+1] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  f^(n-1)*(f*x)^(m-n+1)*(a+b*x^n+c*x^(2*n))^(p+1)*(b*d-2*a*e-(b*e-2*c*d)*x^n)/(n*(p+1)*(b^2-4*a*c)) + 
  f^n/(n*(p+1)*(b^2-4*a*c))*Int[(f*x)^(m-n)*(a+b*x^n+c*x^(2*n))^(p+1)*
      Simp[(n-m-1)*(b*d-2*a*e)+(2*n*p+2*n+m+1)*(b*e-2*c*d)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p] && p<-1 && m>n-1 && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_.,x_Symbol] :=
  f^(n-1)*(f*x)^(m-n+1)*(a+c*x^(2*n))^(p+1)*(a*e-c*d*x^n)/(2*a*c*n*(p+1)) + 
  f^n/(2*a*c*n*(p+1))*Int[(f*x)^(m-n)*(a+c*x^(2*n))^(p+1)*(a*e*(n-m-1)+c*d*(2*n*p+2*n+m+1)*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>n-1 && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)*(d*(b^2-2*a*c)-a*b*e+(b*d-2*a*e)*c*x^n)/(a*f*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*Int[(f*x)^m*(a+b*x^n+c*x^(2*n))^(p+1)*
      Simp[d*(b^2*(m+n*(p+1)+1)-2*a*c*(m+2*n*(p+1)+1))-a*b*e*(m+1)+c*(m+n*(2*p+3)+1)*(b*d-2*a*e)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && 
  IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+c*x^(2*n))^(p+1)*(d+e*x^n)/(2*a*f*n*(p+1)) + 
  1/(2*a*n*(p+1))*Int[(f*x)^m*(a+c*x^(2*n))^(p+1)*Simp[d*(m+2*n*(p+1)+1)+e*(m+n*(2*p+3)+1)*x^n,x],x] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  e*f^(n-1)*(f*x)^(m-n+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(c*(m+n(2*p+1)+1)) - 
  f^n/(c*(m+n(2*p+1)+1))*
    Int[(f*x)^(m-n)*(a+b*x^n+c*x^(2*n))^p*Simp[a*e*(m-n+1)+(b*e*(m+n*p+1)-c*d*(m+n(2*p+1)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m>n-1 && 
  NeQ[m+n(2*p+1)+1] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  e*f^(n-1)*(f*x)^(m-n+1)*(a+c*x^(2*n))^(p+1)/(c*(m+n(2*p+1)+1)) - 
  f^n/(c*(m+n(2*p+1)+1))*Int[(f*x)^(m-n)*(a+c*x^(2*n))^p*(a*e*(m-n+1)-c*d*(m+n(2*p+1)+1)*x^n),x] /;
FreeQ[{a,c,d,e,f,p},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m] && m>n-1 && NeQ[m+n(2*p+1)+1] && IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  d*(f*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*f*(m+1)) + 
  1/(a*f^n*(m+1))*Int[(f*x)^(m+n)*(a+b*x^n+c*x^(2*n))^p*Simp[a*e*(m+1)-b*d*(m+n*(p+1)+1)-c*d*(m+2*n(p+1)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,p},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && 
  IntegerQ[p]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  d*(f*x)^(m+1)*(a+c*x^(2*n))^(p+1)/(a*f*(m+1)) + 
  1/(a*f^n*(m+1))*Int[(f*x)^(m+n)*(a+c*x^(2*n))^p*(a*e*(m+1)-c*d*(m+2*n(p+1)+1)*x^n),x] /;
FreeQ[{a,c,d,e,f,p},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && IntegerQ[p]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a*c,2]},
  With[{r=Rt[2*c*q-b*c,2]},
  c/(2*q*r)*Int[(f*x)^m*Simp[d*r-(c*d-e*q)*x^(n/2),x]/(q-r*x^(n/2)+c*x^n),x] + 
  c/(2*q*r)*Int[(f*x)^m*Simp[d*r+(c*d-e*q)*x^(n/2),x]/(q+r*x^(n/2)+c*x^n),x]] /;
 Not[NegativeQ[2*c*q-b*c]]] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NegativeQ[b^2-4*a*c] && IntegersQ[m,n/2] && 0<m<n && PosQ[a*c]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a*c,2]},
  With[{r=Rt[2*c*q,2]},
  c/(2*q*r)*Int[(f*x)^m*Simp[d*r-(c*d-e*q)*x^(n/2),x]/(q-r*x^(n/2)+c*x^n),x] + 
  c/(2*q*r)*Int[(f*x)^m*Simp[d*r+(c*d-e*q)*x^(n/2),x]/(q+r*x^(n/2)+c*x^n),x]] /;
 Not[NegativeQ[2*c*q]]] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveQ[a*c] && IntegersQ[m,n/2] && 0<m<n


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a*c,2]},
  With[{r=Rt[2*c*q-b*c,2]},
  c/(2*q*r)*Int[(f*x)^m*(d*r-(c*d-e*q)*x^(n/2))/(q-r*x^(n/2)+c*x^n),x] + 
  c/(2*q*r)*Int[(f*x)^m*(d*r+(c*d-e*q)*x^(n/2))/(q+r*x^(n/2)+c*x^n),x]] /;
 Not[NegativeQ[2*c*q-b*c]]] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NegativeQ[b^2-4*a*c] && IntegerQ[n/2] && n>2 && PosQ[a*c]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[a*c,2]},
  With[{r=Rt[2*c*q,2]},
  c/(2*q*r)*Int[(f*x)^m*(d*r-(c*d-e*q)*x^(n/2))/(q-r*x^(n/2)+c*x^n),x] + 
  c/(2*q*r)*Int[(f*x)^m*(d*r+(c*d-e*q)*x^(n/2))/(q+r*x^(n/2)+c*x^n),x]] /;
 Not[NegativeQ[2*c*q]]] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && IntegerQ[n/2] && n>2 && PositiveQ[a*c]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (e/2+(2*c*d-b*e)/(2*q))*Int[(f*x)^m/(b/2-q/2+c*x^n),x] + (e/2-(2*c*d-b*e)/(2*q))*Int[(f*x)^m/(b/2+q/2+c*x^n),x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)/(a_+c_.*x_^n2_),x_Symbol] :=
  With[{q=Rt[-a*c,2]},
  -(e/2+c*d/(2*q))*Int[(f*x)^m/(q-c*x^n),x] + (e/2-c*d/(2*q))*Int[(f*x)^m/(q+c*x^n),x]] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[q] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_./(a_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q/(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && IntegerQ[q] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_./(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m,(d+e*x^n)^q/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[q] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_./(a_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m,(d+e*x^n)^q/(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && IntegerQ[q] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  f^(2*n)/c^2*Int[(f*x)^(m-2*n)*(c*d-b*e+c*e*x^n)*(d+e*x^n)^(q-1),x] - 
  f^(2*n)/c^2*Int[(f*x)^(m-2*n)*(d+e*x^n)^(q-1)*Simp[a*(c*d-b*e)+(b*c*d-b^2*e+a*c*e)*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[m,q] && q>0 && m>2*n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  f^(2*n)/c*Int[(f*x)^(m-2*n)*(d+e*x^n)^q,x] - 
  a*f^(2*n)/c*Int[(f*x)^(m-2*n)*(d+e*x^n)^q/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[m] && m>2*n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  e*f^n/c*Int[(f*x)^(m-n)*(d+e*x^n)^(q-1),x] - 
  f^n/c*Int[(f*x)^(m-n)*(d+e*x^n)^(q-1)*Simp[a*e-(c*d-b*e)*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[m,q] && q>0 && n-1<m<=2n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  e*f^n/c*Int[(f*x)^(m-n)*(d+e*x^n)^(q-1),x] - 
  f^n/c*Int[(f*x)^(m-n)*(d+e*x^n)^(q-1)*Simp[a*e-c*d*x^n,x]/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && n-1<m<=2n-1


Int[(f_.*x_)^m_*(d_.+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  d/a*Int[(f*x)^m*(d+e*x^n)^(q-1),x] - 
  1/(a*f^n)*Int[(f*x)^(m+n)*(d+e*x^n)^(q-1)*Simp[b*d-a*e+c*d*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[m,q] && q>0 && m<0


Int[(f_.*x_)^m_*(d_.+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  d/a*Int[(f*x)^m*(d+e*x^n)^(q-1),x] + 
  1/(a*f^n)*Int[(f*x)^(m+n)*(d+e*x^n)^(q-1)*Simp[a*e-c*d*x^n,x]/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[m,q] && q>0 && m<0


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  d^2*f^(2*n)/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2*n)*(d+e*x^n)^q,x] - 
  f^(2*n)/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2*n)*(d+e*x^n)^(q+1)*Simp[a*d+(b*d-a*e)*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[m,q] && q<-1 && m>2*n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  d^2*f^(2*n)/(c*d^2+a*e^2)*Int[(f*x)^(m-2*n)*(d+e*x^n)^q,x] - 
  a*f^(2*n)/(c*d^2+a*e^2)*Int[(f*x)^(m-2*n)*(d+e*x^n)^(q+1)*(d-e*x^n)/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && m>2*n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  -d*e*f^n/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-n)*(d+e*x^n)^q,x] + 
  f^n/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-n)*(d+e*x^n)^(q+1)*Simp[a*e+c*d*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[m,q] && q<-1 && n-1<m<=2*n-1


Int[(f_.*x_)^m_.*(d_.+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  -d*e*f^n/(c*d^2+a*e^2)*Int[(f*x)^(m-n)*(d+e*x^n)^q,x] + 
  f^n/(c*d^2+a*e^2)*Int[(f*x)^(m-n)*(d+e*x^n)^(q+1)*Simp[a*e+c*d*x^n,x]/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[m,q] && q<-1 && n-1<m<=2*n-1


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_),x_Symbol] :=
  e^2/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^m*(d+e*x^n)^q,x] + 
  1/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^m*(d+e*x^n)^(q+1)*Simp[c*d-b*e-c*e*x^n,x]/(a+b*x^n+c*x^(2*n)),x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  RationalQ[q] && q<-1


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_),x_Symbol] :=
  e^2/(c*d^2+a*e^2)*Int[(f*x)^m*(d+e*x^n)^q,x] + 
  c/(c*d^2+a*e^2)*Int[(f*x)^m*(d+e*x^n)^(q+1)*(d-e*x^n)/(a+c*x^(2*n)),x] /;
FreeQ[{a,c,d,e,f,m},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && RationalQ[q] && q<-1


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q,(f*x)^m/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,f,q,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(d+e*x^n)^q,(f*x)^m/(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,f,q,n},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q,1/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,e,f,m,q,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && 
  Not[IntegerQ[m]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q,1/(a+c*x^(2*n)),x],x] /;
FreeQ[{a,c,d,e,f,m,q,n},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && Not[IntegerQ[q]] && Not[IntegerQ[m]]


Int[(f_.*x_)^m_*(a_.+b_.*x_^n_+c_.*x_^n2_.)^p_./(d_.+e_.*x_^n_),x_Symbol] :=
  1/d^2*Int[(f*x)^m*(a*d+(b*d-a*e)*x^n)*(a+b*x^n+c*x^(2*n))^(p-1),x] + 
  (c*d^2-b*d*e+a*e^2)/(d^2*f^(2*n))*Int[(f*x)^(m+2*n)*(a+b*x^n+c*x^(2*n))^(p-1)/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-n


Int[(f_.*x_)^m_*(a_+c_.*x_^n2_.)^p_./(d_.+e_.*x_^n_),x_Symbol] :=
  a/d^2*Int[(f*x)^m*(d-e*x^n)*(a+c*x^(2*n))^(p-1),x] + 
  (c*d^2+a*e^2)/(d^2*f^(2*n))*Int[(f*x)^(m+2*n)*(a+c*x^(2*n))^(p-1)/(d+e*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<-n


Int[(f_.*x_)^m_*(a_.+b_.*x_^n_+c_.*x_^n2_.)^p_./(d_.+e_.*x_^n_),x_Symbol] :=
  1/(d*e)*Int[(f*x)^m*(a*e+c*d*x^n)*(a+b*x^n+c*x^(2*n))^(p-1),x] - 
  (c*d^2-b*d*e+a*e^2)/(d*e*f^n)*Int[(f*x)^(m+n)*(a+b*x^n+c*x^(2*n))^(p-1)/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<0


Int[(f_.*x_)^m_*(a_+c_.*x_^n2_.)^p_./(d_.+e_.*x_^n_),x_Symbol] :=
  1/(d*e)*Int[(f*x)^m*(a*e+c*d*x^n)*(a+c*x^(2*n))^(p-1),x] - 
  (c*d^2+a*e^2)/(d*e*f^n)*Int[(f*x)^(m+n)*(a+c*x^(2*n))^(p-1)/(d+e*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m<0


Int[(f_.*x_)^m_.*(a_.+b_.*x_^n_+c_.*x_^n2_.)^p_/(d_.+e_.*x_^n_),x_Symbol] :=
  -f^(2*n)/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2*n)*(a*d+(b*d-a*e)*x^n)*(a+b*x^n+c*x^(2*n))^p,x] + 
  d^2*f^(2*n)/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-2*n)*(a+b*x^n+c*x^(2*n))^(p+1)/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>n


Int[(f_.*x_)^m_.*(a_+c_.*x_^n2_.)^p_/(d_.+e_.*x_^n_),x_Symbol] :=
  -a*f^(2*n)/(c*d^2+a*e^2)*Int[(f*x)^(m-2*n)*(d-e*x^n)*(a+c*x^(2*n))^p,x] + 
  d^2*f^(2*n)/(c*d^2+a*e^2)*Int[(f*x)^(m-2*n)*(a+c*x^(2*n))^(p+1)/(d+e*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>n


Int[(f_.*x_)^m_.*(a_.+b_.*x_^n_+c_.*x_^n2_.)^p_/(d_.+e_.*x_^n_),x_Symbol] :=
  f^n/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-n)*(a*e+c*d*x^n)*(a+b*x^n+c*x^(2*n))^p,x] - 
  d*e*f^n/(c*d^2-b*d*e+a*e^2)*Int[(f*x)^(m-n)*(a+b*x^n+c*x^(2*n))^(p+1)/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>0


Int[(f_.*x_)^m_.*(a_+c_.*x_^n2_.)^p_/(d_.+e_.*x_^n_),x_Symbol] :=
  f^n/(c*d^2+a*e^2)*Int[(f*x)^(m-n)*(a*e+c*d*x^n)*(a+c*x^(2*n))^p,x] - 
  d*e*f^n/(c*d^2+a*e^2)*Int[(f*x)^(m-n)*(a+c*x^(2*n))^(p+1)/(d+e*x^n),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && RationalQ[m,p] && p<-1 && m>0


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+b*x^n+c*x^(2*n))^p,(f*x)^m(d+e*x^n)^q,x],x] /;
FreeQ[{a,b,c,d,e,f,m,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && (PositiveIntegerQ[q] || IntegersQ[m,q])


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(a+c*x^(2*n))^p,(f*x)^m(d+e*x^n)^q,x],x] /;
FreeQ[{a,c,d,e,f,m,q},x] && EqQ[n2-2*n] && PositiveIntegerQ[n] && (PositiveIntegerQ[q] || IntegersQ[m,q])


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -Subst[Int[(d+e*x^(-n))^q*(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,e,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && IntegerQ[m]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -Subst[Int[(d+e*x^(-n))^q*(a+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,c,d,e,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[m]},
  -g/f*Subst[Int[(d+e*f^(-n)*x^(-g*n))^q*(a+b*f^(-n)*x^(-g*n)+c*f^(-2*n)*x^(-2*g*n))^p/x^(g*(m+1)+1),x],x,1/(f*x)^(1/g)]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && FractionQ[m]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[m]},
  -g/f*Subst[Int[(d+e*f^(-n)*x^(-g*n))^q*(a+c*f^(-2*n)*x^(-2*g*n))^p/x^(g*(m+1)+1),x],x,1/(f*x)^(1/g)]] /;
FreeQ[{a,c,d,e,f,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[n] && FractionQ[m]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -f^IntPart[m]*(f*x)^FracPart[m]*(x^(-1))^FracPart[m]*Subst[Int[(d+e*x^(-n))^q*(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  -f^IntPart[m]*(f*x)^FracPart[m]*(x^(-1))^FracPart[m]*Subst[Int[(d+e*x^(-n))^q*(a+c*x^(-2*n))^p/x^(m+2),x],x,1/x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g*(m+1)-1)*(d+e*x^(g*n))^q*(a+b*x^(g*n)+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,d,e,m,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g*(m+1)-1)*(d+e*x^(g*n))^q*(a+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,c,d,e,m,p,q},x] && EqQ[n2-2*n] && FractionQ[n]


Int[(f_*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[(f_*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && FractionQ[n]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(d+e*x^Simplify[n/(m+1)])^q*(a+b*x^Simplify[n/(m+1)]+c*x^Simplify[2*n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[(d+e*x^Simplify[n/(m+1)])^q*(a+c*x^Simplify[2*n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(f_*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(f_*x_)^m_*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,p,q},x] && EqQ[n2-2*n] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+b_.*x_^n_+c_.*x_^n2_.),x_Symbol] :=
  With[{r=Rt[b^2-4*a*c,2]},
  2*c/r*Int[(f*x)^m*(d+e*x^n)^q/(b-r+2*c*x^n),x] - 2*c/r*Int[(f*x)^m*(d+e*x^n)^q/(b+r+2*c*x^n),x]] /;
FreeQ[{a,b,c,d,e,f,m,n,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_/(a_+c_.*x_^n2_.),x_Symbol] :=
  With[{r=Rt[-a*c,2]},
  -c/(2*r)*Int[(f*x)^m*(d+e*x^n)^q/(r-c*x^n),x] - c/(2*r)*Int[(f*x)^m*(d+e*x^n)^q/(r+c*x^n),x]] /;
FreeQ[{a,c,d,e,f,m,n,q},x] && EqQ[n2-2*n]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)*(d*(b^2-2*a*c)-a*b*e+(b*d-2*a*e)*c*x^n)/(a*f*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*Int[(f*x)^m*(a+b*x^n+c*x^(2*n))^(p+1)*
      Simp[d*(b^2*(m+n*(p+1)+1)-2*a*c*(m+2*n*(p+1)+1))-a*b*e*(m+1)+(m+n*(2*p+3)+1)*(b*d-2*a*e)*c*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -(f*x)^(m+1)*(a+c*x^(2*n))^(p+1)*(d+e*x^n)/(2*a*f*n*(p+1)) + 
  1/(2*a*n*(p+1))*Int[(f*x)^m*(a+c*x^(2*n))^(p+1)*Simp[d*(m+2*n*(p+1)+1)+e*(m+n*(2*p+3)+1)*x^n,x],x] /;
FreeQ[{a,c,d,e,f,m,n},x] && EqQ[n2-2*n] && NegativeIntegerQ[p+1]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && (PositiveIntegerQ[p] || PositiveIntegerQ[q])


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(f*x)^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x],x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && (PositiveIntegerQ[p] || PositiveIntegerQ[q])


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  f^m*Int[ExpandIntegrand[x^m*(a+c*x^(2*n))^p,(d/(d^2-e^2*x^(2*n))-e*x^n/(d^2-e^2*x^(2*n)))^(-q),x],x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[q] && (IntegerQ[m] || PositiveQ[f])


Int[(f_.*x_)^m_*(d_+e_.*x_^n_)^q_*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  (f*x)^m/x^m*Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n] && NegativeIntegerQ[q] && Not[IntegerQ[m] || PositiveQ[f]]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Defer[Int][(f*x)^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n]


Int[(f_.*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Defer[Int][(f*x)^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,n,p,q},x] && EqQ[n2-2*n]


Int[u_^m_.*(d_+e_.*v_^n_)^q_.*(a_+b_.*v_^n_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(d+e*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x],x,v] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[n2-2*n] && LinearPairQ[u,v,x]


Int[u_^m_.*(d_+e_.*v_^n_)^q_.*(a_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*(d+e*x^n)^q*(a+c*x^(2*n))^p,x],x,v] /;
FreeQ[{a,c,d,e,m,n,p},x] && EqQ[n2-2*n] && LinearPairQ[u,v,x]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_.*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m-n*q)*(e+d*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n,p},x] && EqQ[n2,2*n] && EqQ[mn,-n] && IntegerQ[q]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_.*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m+mn*q)*(e+d*x^(-mn))^q*(a+c*x^n2)^p,x] /;
FreeQ[{a,c,d,e,m,mn,p},x] && EqQ[n2,-2*mn] && IntegerQ[q]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m+2*n*p)*(d+e*x^(-n))^q*(c+b*x^(-n)+a*x^(-2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n,q},x] && EqQ[n2,2*n] && EqQ[mn,-n] && Not[IntegerQ[q]] && IntegerQ[p]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_*(a_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[x^(m-2*mn*p)*(d+e*x^mn)^q*(c+a*x^(2*mn))^p,x] /;
FreeQ[{a,c,d,e,m,mn,q},x] && EqQ[n2,-2*mn] && Not[IntegerQ[q]] && IntegerQ[p]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  x^(n*FracPart[q])*(d+e*x^(-n))^FracPart[q]/(e+d*x^n)^FracPart[q]*Int[x^(m-n*q)*(e+d*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[n2,2*n] && EqQ[mn,-n] && Not[IntegerQ[q]] && Not[IntegerQ[p]]


Int[x_^m_.*(d_+e_.*x_^mn_.)^q_*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  x^(-mn*FracPart[q])*(d+e*x^mn)^FracPart[q]/(e+d*x^(-mn))^FracPart[q]*Int[x^(m+mn*q)*(e+d*x^(-mn))^q*(a+c*x^n2)^p,x] /;
FreeQ[{a,c,d,e,m,mn,p,q},x] && EqQ[n2,-2*mn] && Not[IntegerQ[q]] && Not[IntegerQ[p]]


Int[(f_*x_)^m_*(d_+e_.*x_^mn_.)^q_.*(a_.+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^mn)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[n2,2*n] && EqQ[mn,-n]


Int[(f_*x_)^m_*(d_+e_.*x_^mn_.)^q_.*(a_+c_.*x_^n2_.)^p_,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^mn)^q*(a+c*x^(2*n))^p,x] /;
FreeQ[{a,c,d,e,f,m,mn,p,q},x] && EqQ[n2,-2*mn]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  Int[x^(m-n*p)*(d+e*x^n)^q*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n,q},x] && EqQ[mn,-n] && IntegerQ[p]


Int[x_^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  x^(n*FracPart[p])*(a+b/x^n+c*x^n)^FracPart[p]/(b+a*x^n+c*x^(2*n))^FracPart[p]*
    Int[x^(m-n*p)*(d+e*x^n)^q*(b+a*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,e,m,n,p,q},x] && EqQ[mn,-n] && Not[IntegerQ[p]]


Int[(f_*x_)^m_.*(d_+e_.*x_^n_)^q_.*(a_+b_.*x_^mn_+c_.*x_^n_.)^p_.,x_Symbol] :=
  f^IntPart[m]*(f*x)^FracPart[m]/x^FracPart[m]*Int[x^m*(d+e*x^n)^q*(a+b*x^(-n)+c*x^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[mn,-n]


Int[(f_.*x_)^m_.*(d1_+e1_.*x_^non2_.)^q_.*(d2_+e2_.*x_^non2_.)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  Int[(f*x)^m*(d1*d2+e1*e2*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d1,e1,d2,e2,f,n,p,q},x] && EqQ[n2-2*n] && EqQ[non2-n/2] && EqQ[d2*e1+d1*e2] && 
  (IntegerQ[q] || PositiveQ[d1] && PositiveQ[d2])


Int[(f_.*x_)^m_.*(d1_+e1_.*x_^non2_.)^q_.*(d2_+e2_.*x_^non2_.)^q_.*(a_.+b_.*x_^n_+c_.*x_^n2_)^p_.,x_Symbol] :=
  (d1+e1*x^(n/2))^FracPart[q]*(d2+e2*x^(n/2))^FracPart[q]/(d1*d2+e1*e2*x^n)^FracPart[q]*
    Int[(f*x)^m*(d1*d2+e1*e2*x^n)^q*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d1,e1,d2,e2,f,n,p,q},x] && EqQ[n2-2*n] && EqQ[non2-n/2] && EqQ[d2*e1+d1*e2]





(* ::Subsection::Closed:: *)
(*1.1.3.7 (c x)^m Pq(x) (a+b x^n)^p*)


Int[x_^m_.*(e_+f_.*x_^q_.+g_.*x_^r_.+h_.*x_^n_.)/(a_+c_.*x_^n_.)^(3/2),x_Symbol] :=
  -(2*a*g+4*a*h*x^(n/4)-2*c*f*x^(n/2))/(a*c*n*Sqrt[a+c*x^n]) /;
FreeQ[{a,c,e,f,g,h,m,n},x] && EqQ[q-n/4] && EqQ[r-3*n/4] && EqQ[4*m-n+4] && EqQ[c*e+a*h]


Int[(d_*x_)^m_.*(e_+f_.*x_^q_.+g_.*x_^r_.+h_.*x_^n_.)/(a_+c_.*x_^n_.)^(3/2),x_Symbol] :=
  (d*x)^m/x^m*Int[x^m*(e+f*x^(n/4)+g*x^((3*n)/4)+h*x^n)/(a+c*x^n)^(3/2),x] /;
FreeQ[{a,c,d,e,f,g,h,m,n},x] && EqQ[4*m-n+4] && EqQ[q-n/4] && EqQ[r-3*n/4] && EqQ[c*e+a*h]


Int[(c_.*x_)^m_*Pq_*(a_+b_.*x_)^p_,x_Symbol] :=
  With[{n=Denominator[p]},
  n/b*Subst[Int[x^(n*p+n-1)*(-a*c/b+c*x^n/b)^m*ReplaceAll[Pq,x->-a/b+x^n/b],x],x,(a+b*x)^(1/n)]] /;
FreeQ[{a,b,c,m},x] && PolyQ[Pq,x] && FractionQ[p] && NegativeIntegerQ[m+1]


(* Int[Pq_*(a_+b_.*x_)^p_,x_Symbol] :=
  With[{n=Denominator[p]},
  n/b*Subst[Int[x^(n*p+n-1)*ReplaceAll[Pq,x->-a/b+x^n/b],x],x,(a+b*x)^(1/n)]] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && FractionQ[p] *)


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  1/(m+1)*Subst[Int[SubstFor[x^(m+1),Pq,x]*(a+b*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,m,n,p},x] && NeQ[m+1] && PositiveIntegerQ[Simplify[n/(m+1)]] && PolyQ[Pq,x^(m+1)]


Int[Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  Coeff[Pq,x,n-1]*(a+b*x^n)^(p+1)/(b*n*(p+1)) + 
  Int[ExpandToSum[Pq-Coeff[Pq,x,n-1]*x^(n-1),x]*(a+b*x^n)^p,x] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n,p] && NeQ[Coeff[Pq,x,n-1]]


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(c*x)^m*Pq*(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,c,m,n},x] && PolyQ[Pq,x] && (PositiveIntegerQ[p] || EqQ[n-1])


Int[Pq_*(a_+b_.*x_^n_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,n},x] && PolyQ[Pq,x] && (PositiveIntegerQ[p] || EqQ[n-1])


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*SubstFor[x^n,Pq,x]*(a+b*x)^p,x],x,x^n] /;
FreeQ[{a,b,m,n,p},x] && PolyQ[Pq,x^n] && IntegerQ[Simplify[(m+1)/n]]


Int[(c_*x_)^m_.*Pq_*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*Pq*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && PolyQ[Pq,x^n] && IntegerQ[Simplify[(m+1)/n]]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Pq*(a+b*x^n)^(p+1)/(b*n*(p+1)) - 
  1/(b*n*(p+1))*Int[D[Pq,x]*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b,m,n},x] && PolyQ[Pq,x] && EqQ[m-n+1] && RationalQ[p] && p<-1


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  1/d*Int[(d*x)^(m+1)*ExpandToSum[Pq/x,x]*(a+b*x^n)^p,x] /;
FreeQ[{a,b,d,m,n,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]]


Int[Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  Int[x*ExpandToSum[Pq/x,x]*(a+b*x^n)^p,x] /;
FreeQ[{a,b,n,p},x] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]] && SumQ[Pq]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  Module[{u=IntHide[x^m*Pq,x]},
  u*(a+b*x^n)^p - b*n*p*Int[x^(m+n)*(a+b*x^n)^(p-1)*ExpandToSum[u/x^(m+1),x],x]] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[m,p] && p>0 && m+Expon[Pq,x]+1<0


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],i},
  (c*x)^m*(a+b*x^n)^p*Sum[Coeff[Pq,x,i]*x^(i+1)/(m+n*p+i+1),{i,0,q}] + 
  a*n*p*Int[(c*x)^m*(a+b*x^n)^(p-1)*Sum[Coeff[Pq,x,i]*x^i/(m+n*p+i+1),{i,0,q}],x]] /;
FreeQ[{a,b,c,m},x] && PolyQ[Pq,x] && PositiveIntegerQ[(n-1)/2] && RationalQ[p] && p>0


Int[Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],i},
  (a+b*x^n)^p*Sum[Coeff[Pq,x,i]*x^(i+1)/(n*p+i+1),{i,0,q}] + 
  a*n*p*Int[(a+b*x^n)^(p-1)*Sum[Coeff[Pq,x,i]*x^i/(n*p+i+1),{i,0,q}],x]] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[(n-1)/2] && RationalQ[p] && p>0


Int[Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],i},
  (a*Coeff[Pq,x,q]-b*x*ExpandToSum[Pq-Coeff[Pq,x,q]*x^q,x])*(a+b*x^n)^(p+1)/(a*b*n*(p+1)) + 
  1/(a*n*(p+1))*Int[Sum[(n*(p+1)+i+1)*Coeff[Pq,x,i]*x^i,{i,0,q-1}]*(a+b*x^n)^(p+1),x] /;
 q==n-1] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  -x*Pq*(a+b*x^n)^(p+1)/(a*n*(p+1)) + 
  1/(a*n*(p+1))*Int[ExpandToSum[n*(p+1)*Pq+D[x*Pq,x],x]*(a+b*x^n)^(p+1),x] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && Expon[Pq,x]<n-1


Int[(d_+e_.*x_+f_.*x_^3+g_.*x_^4)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  -(2*a*f+4*a*g*x-2*b*e*x^2)/(4*a*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,d,e,f,g},x] && EqQ[b*d+a*g]


Int[(d_+f_.*x_^3+g_.*x_^4)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  -(f+2*g*x)/(2*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,d,f,g},x] && EqQ[b*d+a*g]


Int[(d_+e_.*x_+g_.*x_^4)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  -x*(2*a*g-b*e*x)/(2*a*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,d,e,g},x] && EqQ[b*d+a*g]


Int[x_^2*(e_.+f_.*x_+h_.*x_^4)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  -(f-2*h*x^3)/(2*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,e,f,h},x] && EqQ[b*e-3*a*h]


Int[x_^2*(e_.+h_.*x_^4)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  h*x^3/(b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,e,h},x] && EqQ[b*e-3*a*h]


Int[(d_+e_.*x_^2+f_.*x_^3+g_.*x_^4+h_.*x_^6)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  -(a*f-2*b*d*x-2*a*h*x^3)/(2*a*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,d,e,f,g,h},x] && EqQ[b*e-3*a*h] && EqQ[b*d+a*g]


Int[(d_+e_.*x_^2+g_.*x_^4+h_.*x_^6)/(a_+b_.*x_^4)^(3/2),x_Symbol] :=
  x*(b*d+a*h*x^2)/(a*b*Sqrt[a+b*x^4]) /;
FreeQ[{a,b,d,e,g,h},x] && EqQ[b*e-3*a*h] && EqQ[b*d+a*g]


Int[Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  Module[{Q=PolynomialQuotient[b^(Floor[(q-1)/n]+1)*Pq,a+b*x^n,x],R=PolynomialRemainder[b^(Floor[(q-1)/n]+1)*Pq,a+b*x^n,x],i},
  -x*R*(a+b*x^n)^(p+1)/(a*n*(p+1)*b^(Floor[(q-1)/n]+1)) + 
  1/(a*n*(p+1)*b^(Floor[(q-1)/n]+1))*Int[(a+b*x^n)^(p+1)*ExpandToSum[a*n*(p+1)*Q+n*(p+1)*R+D[x*R,x],x],x]] /;
 q>=n] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[x_^m_*Pq_*(a_+b_.*x_^n_.)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  Module[{Q=PolynomialQuotient[a*b^(Floor[(q-1)/n]+1)*x^m*Pq,a+b*x^n,x],
          R=PolynomialRemainder[a*b^(Floor[(q-1)/n]+1)*x^m*Pq,a+b*x^n,x],i},
  -x*R*(a+b*x^n)^(p+1)/(a^2*n*(p+1)*b^(Floor[(q-1)/n]+1)) + 
  1/(a*n*(p+1)*b^(Floor[(q-1)/n]+1))*Int[x^m*(a+b*x^n)^(p+1)*
    ExpandToSum[n*(p+1)*x^(-m)*Q+Sum[(n*(p+1)+i+1)/a*Coeff[R,x,i]*x^(i-m),{i,0,n-1}],x],x]]] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[p] && p<-1 && NegativeIntegerQ[m]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{g=GCD[m+1,n]},
  1/g*Subst[Int[x^((m+1)/g-1)*ReplaceAll[Pq,x->x^(1/g)]*(a+b*x^(n/g))^p,x],x,x^g] /;
 g!=1] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x^n] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(A_+B_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  B^3/b*Int[1/(A^2-A*B*x+B^2*x^2),x] /;
FreeQ[{a,b,A,B},x] && EqQ[a*B^3-b*A^3]


Int[(A_+B_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,3]], s=Denominator[Rt[a/b,3]]},
  -r*(B*r-A*s)/(3*a*s)*Int[1/(r+s*x),x] + 
  r/(3*a*s)*Int[(r*(B*r+2*A*s)+s*(B*r-A*s)*x)/(r^2-r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b,A,B},x] && NeQ[a*B^3-b*A^3] && PosQ[a/b]


Int[(A_+B_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,3]], s=Denominator[Rt[-a/b,3]]},
  r*(B*r+A*s)/(3*a*s)*Int[1/(r-s*x),x] - 
  r/(3*a*s)*Int[(r*(B*r-2*A*s)-s*(B*r+A*s)*x)/(r^2+r*s*x+s^2*x^2),x]] /;
FreeQ[{a,b,A,B},x] && NeQ[a*B^3-b*A^3] && NegQ[a/b]


Int[(A_+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  -C^2/b*Int[1/(B-C*x),x] /;
FreeQ[{a,b,A,B,C},x] && EqQ[B^2-A*C] && EqQ[b*B^3+a*C^3]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/b^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A*b^(2/3)-a^(1/3)*b^(1/3)*B-2*a^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/b^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[a^(1/3)*b^(1/3)*B+2*a^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/b^(1/3)},
  C/b*Int[1/(q+x),x] + C*q/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A*b^(2/3)-2*a^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/(-b)^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A*(-b)^(2/3)-(-a)^(1/3)*(-b)^(1/3)*B-2*(-a)^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/(-b)^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[(-a)^(1/3)*(-b)^(1/3)*B+2*(-a)^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/(-b)^(1/3)},
  C/b*Int[1/(q+x),x] + C*q/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A*(-b)^(2/3)-2*(-a)^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/b^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A*b^(2/3)+(-a)^(1/3)*b^(1/3)*B-2*(-a)^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/b^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[(-a)^(1/3)*b^(1/3)*B-2*(-a)^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a)^(1/3)/b^(1/3)},
  -C/b*Int[1/(q-x),x] - C*q/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A*b^(2/3)-2*(-a)^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/(-b)^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A*(-b)^(2/3)+a^(1/3)*(-b)^(1/3)*B-2*a^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/(-b)^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[a^(1/3)*(-b)^(1/3)*B-2*a^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=a^(1/3)/(-b)^(1/3)},
  -C/b*Int[1/(q-x),x] - C*q/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A*(-b)^(2/3)-2*a^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A-(a/b)^(1/3)*B-2*(a/b)^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[(a/b)^(1/3)*B+2*(a/b)^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  C/b*Int[1/(q+x),x] + C*q/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A-2*(a/b)^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[a/b,3]},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A-Rt[a/b,3]*B-2*Rt[a/b,3]^2*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[a/b,3]},
  C/b*Int[1/(q+x),x] + (B+C*q)/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[Rt[a/b,3]*B+2*Rt[a/b,3]^2*C]


Int[(A_.+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[a/b,3]},
  C/b*Int[1/(q+x),x] + C*q/b*Int[1/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A-2*Rt[a/b,3]^2*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A+(-a/b)^(1/3)*B-2*(-a/b)^(2/3)*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[(-a/b)^(1/3)*B-2*(-a/b)^(2/3)*C]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  -C/b*Int[1/(q-x),x] - C*q/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A-2*(-a/b)^(2/3)*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[-a/b,3]},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A+Rt[-a/b,3]*B-2*Rt[-a/b,3]^2*C]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[-a/b,3]},
  -C/b*Int[1/(q-x),x] + (B-C*q)/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[Rt[-a/b,3]*B-2*Rt[-a/b,3]^2*C]


Int[(A_.+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=Rt[-a/b,3]},
  -C/b*Int[1/(q-x),x] - C*q/b*Int[1/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A-2*Rt[-a/b,3]^2*C]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  Int[(A+B*x)/(a+b*x^3),x] + C*Int[x^2/(a+b*x^3),x] /;
FreeQ[{a,b,A,B,C},x] && (EqQ[a*B^3-b*A^3] || Not[RationalQ[a/b]])


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  B*Int[x/(a+b*x^3),x] + C*Int[x^2/(a+b*x^3),x] /;
FreeQ[{a,b,B,C},x] && Not[RationalQ[a/b]]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  A*Int[1/(a+b*x^3),x] + C*Int[x^2/(a+b*x^3),x] /;
FreeQ[{a,b,A,C},x] && Not[RationalQ[a,b,A,C]]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  q^2/a*Int[(A+C*q*x)/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A-B*(a/b)^(1/3)+C*(a/b)^(2/3)]


Int[x_*(B_.+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  C*q^3/a*Int[x/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[B*(a/b)^(1/3)-C*(a/b)^(2/3)]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  q^2/a*Int[(A+C*q*x)/(q^2-q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A+C*(a/b)^(2/3)]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  q/a*Int[(A*q+(A+B*q)*x)/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,B,C},x] && EqQ[A+B*(-a/b)^(1/3)+C*(-a/b)^(2/3)]


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  B*q^2/a*Int[x/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,B,C},x] && EqQ[B*(-a/b)^(1/3)+C*(-a/b)^(2/3)]


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  A*q/a*Int[(q+x)/(q^2+q*x+x^2),x]] /;
FreeQ[{a,b,A,C},x] && EqQ[A+C*(-a/b)^(2/3)]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  q*(A-B*q+C*q^2)/(3*a)*Int[1/(q+x),x] + 
  q/(3*a)*Int[(q*(2*A+B*q-C*q^2)-(A-B*q-2*C*q^2)*x)/(q^2-q*x+x^2),x] /;
 NeQ[A-B*q+C*q^2]] /;
FreeQ[{a,b,A,B,C},x] && NeQ[a*B^3-b*A^3] && RationalQ[a/b] && a/b>0


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  -q*(B*q-C*q^2)/(3*a)*Int[1/(q+x),x] + 
  q/(3*a)*Int[(q*(B*q-C*q^2)+(B*q+2*C*q^2)*x)/(q^2-q*x+x^2),x] /;
 NeQ[B*q-C*q^2]] /;
FreeQ[{a,b,B,C},x] && RationalQ[a/b] && a/b>0


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(a/b)^(1/3)},
  q*(A+C*q^2)/(3*a)*Int[1/(q+x),x] + 
  q/(3*a)*Int[(q*(2*A-C*q^2)-(A-2*C*q^2)*x)/(q^2-q*x+x^2),x] /;
 NeQ[A+C*q^2]] /;
FreeQ[{a,b,A,C},x] && RationalQ[a/b] && a/b>0


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  q*(A+B*q+C*q^2)/(3*a)*Int[1/(q-x),x] + 
  q/(3*a)*Int[(q*(2*A-B*q-C*q^2)+(A+B*q-2*C*q^2)*x)/(q^2+q*x+x^2),x] /;
 NeQ[A+B*q+C*q^2]] /;
FreeQ[{a,b,A,B,C},x] && NeQ[a*B^3-b*A^3] && RationalQ[a/b] && a/b<0


Int[x_*(B_+C_.*x_)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  q*(B*q+C*q^2)/(3*a)*Int[1/(q-x),x] + 
  q/(3*a)*Int[(-q*(B*q+C*q^2)+(B*q-2*C*q^2)*x)/(q^2+q*x+x^2),x] /;
 NeQ[B*q+C*q^2]] /;
FreeQ[{a,b,B,C},x] && RationalQ[a/b] && a/b<0


Int[(A_+C_.*x_^2)/(a_+b_.*x_^3),x_Symbol] :=
  With[{q=(-a/b)^(1/3)},
  q*(A+C*q^2)/(3*a)*Int[1/(q-x),x] + 
  q/(3*a)*Int[(q*(2*A-C*q^2)+(A-2*C*q^2)*x)/(q^2+q*x+x^2),x] /;
 NeQ[A+C*q^2]] /;
FreeQ[{a,b,A,C},x] && RationalQ[a/b] && a/b<0


Int[(c_.*x_)^m_.*Pq_/(a_+b_.*x_^n_),x_Symbol] :=
  With[{v=Sum[(c*x)^(m+ii)*(Coeff[Pq,x,ii]+Coeff[Pq,x,n/2+ii]*x^(n/2))/(c^ii*(a+b*x^n)),{ii,0,n/2-1}]},
  Int[v,x] /;
 SumQ[v]] /;
FreeQ[{a,b,c,m},x] && PolyQ[Pq,x] && PositiveIntegerQ[n/2] && Expon[Pq,x]<n


Int[Pq_/(a_+b_.*x_^n_),x_Symbol] :=
  With[{v=Sum[x^ii*(Coeff[Pq,x,ii]+Coeff[Pq,x,n/2+ii]*x^(n/2))/(a+b*x^n),{ii,0,n/2-1}]},
  Int[v,x] /;
 SumQ[v]] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n/2] && Expon[Pq,x]<n


(* Int[(c_+d_.*x_)/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{q=Rt[b/a,3]},
  2*d*Sqrt[a+b*x^3]/(a*q^2*(1+Sqrt[3]+q*x)) + 
  3^(1/4)*Sqrt[2-Sqrt[3]]*d*(1+q*x)*Sqrt[(1-q*x+q^2*x^2)/(1+Sqrt[3]+q*x)^2]/(q^2*Sqrt[a+b*x^3]*Sqrt[(1+q*x)/(1+Sqrt[3]+q*x)^2])*
    EllipticE[ArcSin[(-1+Sqrt[3]-q*x)/(1+Sqrt[3]+q*x)],-7-4*Sqrt[3]] /;
 EqQ[c*q-d*(1-Sqrt[3])]] /;
FreeQ[{a,b,c,d},x] && PosQ[a] *)


Int[(c_+d_.*x_)/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  2*d*s^3*Sqrt[a+b*x^3]/(a*r^2*((1+Sqrt[3])*s+r*x)) - 
  3^(1/4)*Sqrt[2-Sqrt[3]]*d*s*(s+r*x)*Sqrt[(s^2-r*s*x+r^2*x^2)/((1+Sqrt[3])*s+r*x)^2]/
    (r^2*Sqrt[a+b*x^3]*Sqrt[s*(s+r*x)/((1+Sqrt[3])*s+r*x)^2])*
    EllipticE[ArcSin[((1-Sqrt[3])*s+r*x)/((1+Sqrt[3])*s+r*x)],-7-4*Sqrt[3]]] /;
FreeQ[{a,b,c,d},x] && PosQ[a] && EqQ[c*Rt[b/a,3]-d*(1-Sqrt[3])]


Int[(c_+d_.*x_)/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  (c*r-(1-Sqrt[3])*d*s)/r*Int[1/Sqrt[a+b*x^3],x] + d/r*Int[((1-Sqrt[3])*s+r*x)/Sqrt[a+b*x^3],x]] /;
FreeQ[{a,b,c,d},x] && PosQ[a] && NeQ[c*Rt[b/a,3]-d*(1-Sqrt[3])]


Int[(c_+d_.*x_)/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  2*d*s^3*Sqrt[a+b*x^3]/(a*r^2*((1-Sqrt[3])*s+r*x)) + 
  3^(1/4)*Sqrt[2+Sqrt[3]]*d*s*(s+r*x)*Sqrt[(s^2-r*s*x+r^2*x^2)/((1-Sqrt[3])*s+r*x)^2]/
    (r^2*Sqrt[a+b*x^3]*Sqrt[-s*(s+r*x)/((1-Sqrt[3])*s+r*x)^2])*
    EllipticE[ArcSin[((1+Sqrt[3])*s+r*x)/((1-Sqrt[3])*s+r*x)],-7+4*Sqrt[3]]] /;
FreeQ[{a,b,c,d},x] && NegQ[a] && EqQ[c*Rt[b/a,3]-d*(1+Sqrt[3])]


Int[(c_+d_.*x_)/Sqrt[a_+b_.*x_^3],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  (c*r-(1+Sqrt[3])*d*s)/r*Int[1/Sqrt[a+b*x^3],x] + d/r*Int[((1+Sqrt[3])*s+r*x)/Sqrt[a+b*x^3],x]] /;
FreeQ[{a,b,c,d},x] && NegQ[a] && NeQ[c*Rt[b/a,3]-d*(1+Sqrt[3])]


Int[(c_+d_.*x_^4)/Sqrt[a_+b_.*x_^6],x_Symbol] :=
  With[{r=Numer[Rt[b/a,3]], s=Denom[Rt[b/a,3]]},
  (1+Sqrt[3])*d*s^3*x*Sqrt[a+b*x^6]/(2*a*r^2*(s+(1+Sqrt[3])*r*x^2)) - 
  3^(1/4)*d*s*x*(s+r*x^2)*Sqrt[(s^2-r*s*x^2+r^2*x^4)/(s+(1+Sqrt[3])*r*x^2)^2]/
    (2*r^2*Sqrt[(r*x^2*(s+r*x^2))/(s+(1+Sqrt[3])*r*x^2)^2]*Sqrt[a+b*x^6])*
    EllipticE[ArcCos[(s+(1-Sqrt[3])*r*x^2)/(s+(1+Sqrt[3])*r*x^2)],(2+Sqrt[3])/4]] /;
FreeQ[{a,b,c,d},x] && EqQ[2*Rt[b/a,3]^2*c-(1-Sqrt[3])*d]


Int[(c_+d_.*x_^4)/Sqrt[a_+b_.*x_^6],x_Symbol] :=
  With[{q=Rt[b/a,3]},
  (2*c*q^2-(1-Sqrt[3])*d)/(2*q^2)*Int[1/Sqrt[a+b*x^6],x] + d/(2*q^2)*Int[(1-Sqrt[3]+2*q^2*x^4)/Sqrt[a+b*x^6],x]] /;
FreeQ[{a,b,c,d},x] && NeQ[2*Rt[b/a,3]^2*c-(1-Sqrt[3])*d]


Int[(c_+d_.*x_^2)/Sqrt[a_+b_.*x_^8],x_Symbol] :=
  -c*d*x^3*Sqrt[-(c-d*x^2)^2/(c*d*x^2)]*Sqrt[-d^2*(a+b*x^8)/(b*c^2*x^4)]/(Sqrt[2+Sqrt[2]]*(c-d*x^2)*Sqrt[a+b*x^8])*
    EllipticF[ArcSin[1/2*Sqrt[(Sqrt[2]*c^2+2*c*d*x^2+Sqrt[2]*d^2*x^4)/(c*d*x^2)]],-2*(1-Sqrt[2])] /;
FreeQ[{a,b,c,d},x] && EqQ[b*c^4-a*d^4]


Int[(c_+d_.*x_^2)/Sqrt[a_+b_.*x_^8],x_Symbol] :=
  (d+Rt[b/a,4]*c)/(2*Rt[b/a,4])*Int[(1+Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] - 
  (d-Rt[b/a,4]*c)/(2*Rt[b/a,4])*Int[(1-Rt[b/a,4]*x^2)/Sqrt[a+b*x^8],x] /;
FreeQ[{a,b,c,d},x] && NeQ[b*c^4-a*d^4]


Int[Pq_/(x_*Sqrt[a_+b_.*x_^n_]),x_Symbol] :=
  Coeff[Pq,x,0]*Int[1/(x*Sqrt[a+b*x^n]),x] + 
  Int[ExpandToSum[(Pq-Coeff[Pq,x,0])/x,x]/Sqrt[a+b*x^n],x] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && NeQ[Coeff[Pq,x,0]]


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],j,k},
  Int[Sum[(c*x)^(m+j)/c^j*Sum[Coeff[Pq,x,j+k*n/2]*x^(k*n/2),{k,0,2*(q-j)/n+1}]*(a+b*x^n)^p,{j,0,n/2-1}],x]] /;
FreeQ[{a,b,c,m,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n/2] && Not[PolyQ[Pq,x^(n/2)]]


Int[Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],j,k},
  Int[Sum[x^j*Sum[Coeff[Pq,x,j+k*n/2]*x^(k*n/2),{k,0,2*(q-j)/n+1}]*(a+b*x^n)^p,{j,0,n/2-1}],x]] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n/2] && Not[PolyQ[Pq,x^(n/2)]]


Int[Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  Coeff[Pq,x,n-1]*Int[x^(n-1)*(a+b*x^n)^p,x] + 
  Int[ExpandToSum[Pq-Coeff[Pq,x,n-1]*x^(n-1),x]*(a+b*x^n)^p,x] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && Expon[Pq,x]==n-1


Int[(c_.*x_)^m_.*Pq_/(a_+b_.*x_^n_),x_Symbol] :=
  Int[ExpandIntegrand[(c*x)^m*Pq/(a+b*x^n),x],x] /;
FreeQ[{a,b,c,m},x] && PolyQ[Pq,x] && IntegerQ[n]


Int[Pq_/(a_+b_.*x_^n_),x_Symbol] :=
  Int[ExpandIntegrand[Pq/(a+b*x^n),x],x] /;
FreeQ[{a,b},x] && PolyQ[Pq,x] && IntegerQ[n]


Int[(c_.*x_)^m_*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{Pq0=Coeff[Pq,x,0]},
    Pq0*(c*x)^(m+1)*(a+b*x^n)^(p+1)/(a*c*(m+1)) + 
    1/(2*a*c*(m+1))*Int[(c*x)^(m+1)*ExpandToSum[2*a*(m+1)*(Pq-Pq0)/x-2*b*Pq0*(m+n*(p+1)+1)*x^(n-1),x]*(a+b*x^n)^p,x] /;
 NeQ[Pq0]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n] && RationalQ[m] && m<-1 && n-1<=Expon[Pq,x]


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    Pqq*(c*x)^(m+q-n+1)*(a+b*x^n)^(p+1)/(b*c^(q-n+1)*(m+q+n*p+1)) + 
    1/(b*(m+q+n*p+1))*Int[(c*x)^m*ExpandToSum[b*(m+q+n*p+1)*(Pq-Pqq*x^q)-a*Pqq*(m+q-n+1)*x^(q-n),x]*(a+b*x^n)^p,x]] /;
  NeQ[m+q+n*p+1] && q-n>=0 && (IntegerQ[2*p] || IntegerQ[p+(q+1)/(2*n)])] /;
FreeQ[{a,b,c,m,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n]


Int[Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    Pqq*x^(q-n+1)*(a+b*x^n)^(p+1)/(b*(q+n*p+1)) + 
    1/(b*(q+n*p+1))*Int[ExpandToSum[b*(q+n*p+1)*(Pq-Pqq*x^q)-a*Pqq*(q-n+1)*x^(q-n),x]*(a+b*x^n)^p,x]] /;
  NeQ[q+n*p+1] && q-n>=0 && (IntegerQ[2*p] || IntegerQ[p+(q+1)/(2*n)])] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x] && PositiveIntegerQ[n]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  -Subst[Int[ExpandToSum[x^q*ReplaceAll[Pq,x->x^(-1)],x]*(a+b*x^(-n))^p/x^(m+q+2),x],x,1/x]] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{g=Denominator[m],q=Expon[Pq,x]},
  -g/c*Subst[Int[ExpandToSum[x^(g*q)*ReplaceAll[Pq,x->c^(-1)*x^(-g)],x]*
    (a+b*c^(-n)*x^(-g*n))^p/x^(g*(m+q+1)+1),x],x,1/(c*x)^(1/g)]] /;
FreeQ[{a,b,c,p},x] && PolyQ[Pq,x] && NegativeIntegerQ[n] && FractionQ[m]


Int[(c_.*x_)^m_*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  -(c*x)^m*(x^(-1))^m*Subst[Int[ExpandToSum[x^q*ReplaceAll[Pq,x->x^(-1)],x]*(a+b*x^(-n))^p/x^(m+q+2),x],x,1/x]] /;
FreeQ[{a,b,c,m,p},x] && PolyQ[Pq,x] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g*(m+1)-1)*ReplaceAll[Pq,x->x^g]*(a+b*x^(g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,m,p},x] && PolyQ[Pq,x] && FractionQ[n]


Int[Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g-1)*ReplaceAll[Pq,x->x^g]*(a+b*x^(g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,p},x] && PolyQ[Pq,x] && FractionQ[n]


Int[(c_*x_)^m_*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*Pq*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,p},x] && PolyQ[Pq,x] && FractionQ[n]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[ReplaceAll[SubstFor[x^n,Pq,x],x->x^Simplify[n/(m+1)]]*(a+b*x^Simplify[n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,m,n,p},x] && PolyQ[Pq,x^n] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(c_*x_)^m_*Pq_*(a_+b_.*x_^n_)^p_,x_Symbol] :=
  c^IntPart[m]*(c*x)^FracPart[m]/x^FracPart[m]*Int[x^m*Pq*(a+b*x^n)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && PolyQ[Pq,x^n] && IntegerQ[Simplify[n/(m+1)]] && Not[IntegerQ[n]]


Int[(A_+B_.*x_^m_.)*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  A*Int[(a+b*x^n)^p,x] + B*Int[x^m*(a+b*x^n)^p,x] /;
FreeQ[{a,b,A,B,m,n,p},x] && EqQ[m-n+1]


Int[(c_.*x_)^m_.*Pq_*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(c*x)^m*Pq*(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,c,m,n,p},x] && (PolyQ[Pq,x] || PolyQ[Pq,x^n])


Int[Pq_*(a_+b_.*x_^n_)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x^n)^p,x],x] /;
FreeQ[{a,b,n,p},x] && (PolyQ[Pq,x] || PolyQ[Pq,x^n])


Int[u_^m_.*Pq_*(a_+b_.*v_^n_.)^p_,x_Symbol] :=
  u^m/(Coeff[v,x,1]*v^m)*Subst[Int[x^m*SubstFor[v,Pq,x]*(a+b*x^n)^p,x],x,v] /;
FreeQ[{a,b,m,n,p},x] && LinearPairQ[u,v,x] && PolyQ[Pq,v^n]


Int[Pq_*(a_+b_.*v_^n_.)^p_,x_Symbol] :=
  1/Coeff[v,x,1]*Subst[Int[SubstFor[v,Pq,x]*(a+b*x^n)^p,x],x,v] /;
FreeQ[{a,b,n,p},x] && LinearQ[v,x] && PolyQ[Pq,v^n]


Int[(c_.*x_)^m_.*Pq_*(a1_+b1_.*x_^n_.)^p_.*(a2_+b2_.*x_^n_.)^p_.,x_Symbol] :=
  Int[(c*x)^m*Pq*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && PolyQ[Pq,x] && EqQ[a2*b1+a1*b2] && (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[Pq_*(a1_+b1_.*x_^n_.)^p_.*(a2_+b2_.*x_^n_.)^p_.,x_Symbol] :=
  Int[Pq*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,n,p},x] && PolyQ[Pq,x] && EqQ[a2*b1+a1*b2] && (IntegerQ[p] || PositiveQ[a1] && PositiveQ[a2])


Int[(c_.*x_)^m_.*Pq_*(a1_+b1_.*x_^n_.)^p_.*(a2_+b2_.*x_^n_.)^p_.,x_Symbol] :=
  (a1+b1*x^n)^FracPart[p]*(a2+b2*x^n)^FracPart[p]/(a1*a2+b1*b2*x^(2*n))^FracPart[p]*
    Int[(c*x)^m*Pq*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,c,m,n,p},x] && PolyQ[Pq,x] && EqQ[a2*b1+a1*b2] && Not[EqQ[n,1] && LinearQ[Pq,x]]


Int[Pq_*(a1_+b1_.*x_^n_.)^p_.*(a2_+b2_.*x_^n_.)^p_.,x_Symbol] :=
  (a1+b1*x^n)^FracPart[p]*(a2+b2*x^n)^FracPart[p]/(a1*a2+b1*b2*x^(2*n))^FracPart[p]*
    Int[Pq*(a1*a2+b1*b2*x^(2*n))^p,x] /;
FreeQ[{a1,b1,a2,b2,n,p},x] && PolyQ[Pq,x] && EqQ[a2*b1+a1*b2] && Not[EqQ[n,1] && LinearQ[Pq,x]]


Int[(e_+f_.*x_^n_.+g_.*x_^n2_.)*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^n_.)^p_.,x_Symbol] :=
  e*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(p+1)/(a*c) /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[n2-2*n] && EqQ[a*c*f-e*(b*c+a*d)*(n*(p+1)+1)] && EqQ[a*c*g-b*d*e*(2*n*(p+1)+1)]


Int[(e_+g_.*x_^n2_.)*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^n_.)^p_.,x_Symbol] :=
  e*x*(a+b*x^n)^(p+1)*(c+d*x^n)^(p+1)/(a*c) /;
FreeQ[{a,b,c,d,e,g,n,p},x] && EqQ[n2-2*n] && EqQ[n*(p+1)+1] && EqQ[a*c*g-b*d*e*(2*n*(p+1)+1)]


Int[(h_.*x_)^m_.*(e_+f_.*x_^n_.+g_.*x_^n2_.)*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^n_.)^p_.,x_Symbol] :=
  e*(h*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(p+1)/(a*c*h*(m+1)) /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p},x] && EqQ[n2-2*n] && EqQ[a*c*f*(m+1)-e*(b*c+a*d)*(m+n*(p+1)+1)] && 
  EqQ[a*c*g*(m+1)-b*d*e*(m+2*n*(p+1)+1)] && NeQ[m+1]


Int[(h_.*x_)^m_.*(e_+g_.*x_^n2_.)*(a_+b_.*x_^n_.)^p_.*(c_+d_.*x_^n_.)^p_.,x_Symbol] :=
  e*(h*x)^(m+1)*(a+b*x^n)^(p+1)*(c+d*x^n)^(p+1)/(a*c*h*(m+1)) /;
FreeQ[{a,b,c,d,e,g,h,m,n,p},x] && EqQ[n2-2*n] && EqQ[m+n*(p+1)+1] && EqQ[a*c*g*(m+1)-b*d*e*(m+2*n*(p+1)+1)] && 
  NeQ[m+1]


Int[(A_+B_.*x_^m_.)*(a_.+b_.*x_^n_)^p_.*(c_+d_.*x_^n_)^q_.,x_Symbol] :=
  A*Int[(a+b*x^n)^p*(c+d*x^n)^q,x] + B*Int[x^m*(a+b*x^n)^p*(c+d*x^n)^q,x] /;
FreeQ[{a,b,c,d,A,B,m,n,p,q},x] && NeQ[b*c-a*d] && EqQ[m-n+1]


Int[Px_^q_.*(a_.+b_.*(c_+d_.*x_)^n_)^p_,x_Symbol] :=
  With[{k=Denominator[n]},
  k/d*Subst[Int[SimplifyIntegrand[x^(k-1)*ReplaceAll[Px,x->x^k/d-c/d]^q*(a+b*x^(k*n))^p,x],x],x,(c+d*x)^(1/k)]] /;
FreeQ[{a,b,c,d,p},x] && PolynomialQ[Px,x] && IntegerQ[q] && RationalQ[n]





(* ::Subsection::Closed:: *)
(*1.2.3.5 (d x)^m Pq(x) (a+b x^n+c x^(2 n))^p*)


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  1/n*Subst[Int[SubstFor[x^n,Pq,x]*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && EqQ[Simplify[m-n+1]]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*Pq*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && PositiveIntegerQ[p]


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && PositiveIntegerQ[p]


Int[(d_+e_.*x_^n_.+f_.*x_^n2_.)*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*x*(a+b*x^n+c*x^(2*n))^(p+1)/a /;
FreeQ[{a,b,c,d,e,f,n,p},x] && EqQ[n2-2*n] && EqQ[a*e-b*d*(n*(p+1)+1)] && EqQ[a*f-c*d*(2*n*(p+1)+1)]


Int[(d_+f_.*x_^n2_.)*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*x*(a+b*x^n+c*x^(2*n))^(p+1)/a /;
FreeQ[{a,b,c,d,f,n,p},x] && EqQ[n2-2*n] && EqQ[n*(p+1)+1] && EqQ[c*d+a*f]


Int[(g_.*x_)^m_.*(d_+e_.*x_^n_.+f_.*x_^n2_.)*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*(g*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*g*(m+1)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[n2-2*n] && EqQ[a*e*(m+1)-b*d*(m+n*(p+1)+1)] && EqQ[a*f*(m+1)-c*d*(m+2*n*(p+1)+1)] && 
  NeQ[m+1]


Int[(g_.*x_)^m_.*(d_+f_.*x_^n2_.)*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*(g*x)^(m+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*g*(m+1)) /;
FreeQ[{a,b,c,d,f,g,m,n,p},x] && EqQ[n2-2*n] && EqQ[m+n*(p+1)+1] && EqQ[c*d+a*f] && NeQ[m+1]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x^n)^(2*FracPart[p]))*Int[(d*x)^m*Pq*(b+2*c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && EqQ[b^2-4*a*c] && Not[IntegerQ[2*p]]


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  (a+b*x^n+c*x^(2*n))^FracPart[p]/((4*c)^IntPart[p]*(b+2*c*x^n)^(2*FracPart[p]))*Int[Pq*(b+2*c*x^n)^(2*p),x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && EqQ[b^2-4*a*c] && Not[IntegerQ[2*p]]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/n*Subst[Int[x^(Simplify[(m+1)/n]-1)*SubstFor[x^n,Pq,x]*(a+b*x+c*x^2)^p,x],x,x^n] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[(m+1)/n]]


Int[(d_*x_)^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^m/x^m*Int[x^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[(m+1)/n]]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/d*Int[(d*x)^(m+1)*ExpandToSum[Pq/x,x]*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]]


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  Int[x*ExpandToSum[Pq/x,x]*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && EqQ[Coeff[Pq,x,0]] && SumQ[Pq]


Int[(d_+e_.*x_^n_+f_.*x_^n2_.+g_.*x_^n3_.)*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  x*(a*d*(n+1)+(a*e-b*d*(n*(p+1)+1))*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a^2*(n+1)) /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && 
  EqQ[a^2*g*(n+1)-c*(n*(2*p+3)+1)*(a*e-b*d*(n*(p+1)+1))] && 
  EqQ[a^2*f*(n+1)-a*c*d*(n+1)*(2*n*(p+1)+1)-b*(n*(p+2)+1)*(a*e-b*d*(n*(p+1)+1))]


Int[(d_+f_.*x_^n2_.+g_.*x_^n3_.)*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*x*(a*(n+1)-b*(n*(p+1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a^2*(n+1)) /;
FreeQ[{a,b,c,d,f,g,n,p},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && 
  EqQ[a^2*g*(n+1)+c*b*d*(n*(2*p+3)+1)*(n*(p+1)+1)] && 
  EqQ[a^2*f*(n+1)-a*c*d*(n+1)*(2*n*(p+1)+1)+b^2*d*(n*(p+2)+1)*(n*(p+1)+1)]


Int[(d_+e_.*x_^n_+g_.*x_^n3_.)*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  x*(a*d*(n+1)+(a*e-b*d*(n*(p+1)+1))*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a^2*(n+1)) /;
FreeQ[{a,b,c,d,e,g,n,p},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && 
  EqQ[a^2*g*(n+1)-c*(n*(2*p+3)+1)*(a*e-b*d*(n*(p+1)+1))] && 
  EqQ[a*c*d*(n+1)*(2*n*(p+1)+1)+b*(n*(p+2)+1)*(a*e-b*d*(n*(p+1)+1))]


Int[(d_+g_.*x_^n3_.)*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_.,x_Symbol] :=
  d*x*(a*(n+1)-b*(n*(p+1)+1)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a^2*(n+1)) /;
FreeQ[{a,b,c,d,g,n,p},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && 
  EqQ[a^2*g*(n+1)+c*b*d*(n*(2*p+3)+1)*(n*(p+1)+1)] && 
  EqQ[a*c*d*(n+1)*(2*n*(p+1)+1)-b^2*d*(n*(p+2)+1)*(n*(p+1)+1)]


Int[x_^m_.*(e_+f_.*x_^q_.+g_.*x_^r_.+h_.*x_^s_.)/(a_+b_.*x_^n_.+c_.*x_^n2_.)^(3/2),x_Symbol] :=
  -(2*c*(b*f-2*a*g)+2*h*(b^2-4*a*c)*x^(n/2)+2*c*(2*c*f-b*g)*x^n)/(c*n*(b^2-4*a*c)*Sqrt[a+b*x^n+c*x^(2*n)]) /;
FreeQ[{a,b,c,e,f,g,h,m,n},x] && EqQ[n2-2*n] && EqQ[q-n/2] && EqQ[r-3*n/2] && EqQ[s-2*n] && 
  NeQ[b^2-4*a*c] && EqQ[2*m-n+2] && EqQ[c*e+a*h]


Int[(d_*x_)^m_.*(e_+f_.*x_^q_.+g_.*x_^r_.+h_.*x_^s_.)/(a_+b_.*x_^n_.+c_.*x_^n2_.)^(3/2),x_Symbol] :=
  (d*x)^m/x^m*Int[x^m*(e+f*x^(n/2)+g*x^((3*n)/2)+h*x^(2*n))/(a+b*x^n+c*x^(2*n))^(3/2),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n},x] && EqQ[n2-2*n] && EqQ[q-n/2] && EqQ[r-3*n/2] && EqQ[s-2*n] && 
  NeQ[b^2-4*a*c] && EqQ[2*m-n+2] && EqQ[c*e+a*h]


Int[Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],i},
  -x*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c))*
    Sum[((b^2-2*a*c)*Coeff[Pq,x,i]-a*b*Coeff[Pq,x,n+i])*x^i+
      c*(b*Coeff[Pq,x,i]-2*a*Coeff[Pq,x,n+i])*x^(n+i),{i,0,n-1}] + 
  1/(a*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Sum[((b^2*(n*(p+1)+i+1)-2*a*c*(2*n*(p+1)+i+1))*Coeff[Pq,x,i]-a*b*(i+1)*Coeff[Pq,x,n+i])*x^i+
      c*(n*(2*p+3)+i+1)*(b*Coeff[Pq,x,i]-2*a*Coeff[Pq,x,n+i])*x^(n+i),{i,0,n-1}],x] /;
 q<2*n] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  Module[{Q=PolynomialQuotient[(b*c)^(Floor[(q-1)/n]+1)*Pq,a+b*x^n+c*x^(2*n),x],
          R=PolynomialRemainder[(b*c)^(Floor[(q-1)/n]+1)*Pq,a+b*x^n+c*x^(2*n),x],i},
  -x*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c)*(b*c)^(Floor[(q-1)/n]+1))*
    Sum[((b^2-2*a*c)*Coeff[R,x,i]-a*b*Coeff[R,x,n+i])*x^i+
      c*(b*Coeff[R,x,i]-2*a*Coeff[R,x,n+i])*x^(n+i),{i,0,n-1}] + 
  1/(a*n*(p+1)*(b^2-4*a*c)*(b*c)^(Floor[(q-1)/n]+1))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*ExpandToSum[a*n*(p+1)*(b^2-4*a*c)*Q+
    Sum[((b^2*(n*(p+1)+i+1)-2*a*c*(2*n*(p+1)+i+1))*Coeff[R,x,i]-a*b*(i+1)*Coeff[R,x,n+i])*x^i+
     c*(n*(2*p+3)+i+1)*(b*Coeff[R,x,i]-2*a*Coeff[R,x,n+i])*x^(n+i),{i,0,n-1}],x],x]] /;
 q>=2*n] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && RationalQ[p] && p<-1


Int[x_^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x]},
  Module[{Q=PolynomialQuotient[a*(b*c)^(Floor[(q-1)/n]+1)*x^m*Pq,a+b*x^n+c*x^(2*n),x],
          R=PolynomialRemainder[a*(b*c)^(Floor[(q-1)/n]+1)*x^m*Pq,a+b*x^n+c*x^(2*n),x],i},
  -x*(a+b*x^n+c*x^(2*n))^(p+1)/(a^2*n*(p+1)*(b^2-4*a*c)*(b*c)^(Floor[(q-1)/n]+1))*
    Sum[((b^2-2*a*c)*Coeff[R,x,i]-a*b*Coeff[R,x,n+i])*x^i+
      c*(b*Coeff[R,x,i]-2*a*Coeff[R,x,n+i])*x^(n+i),{i,0,n-1}] + 
  1/(a*n*(p+1)*(b^2-4*a*c)*(b*c)^(Floor[(q-1)/n]+1))*Int[x^m*(a+b*x^n+c*x^(2*n))^(p+1)*
    ExpandToSum[n*(p+1)*(b^2-4*a*c)*x^(-m)*Q+
      Sum[((b^2*(n*(p+1)+i+1)/a-2*c*(2*n*(p+1)+i+1))*Coeff[R,x,i]-b*(i+1)*Coeff[R,x,n+i])*x^(i-m)+
       c*(n*(2*p+3)+i+1)*(b/a*Coeff[R,x,i]-2*Coeff[R,x,n+i])*x^(n+i-m),{i,0,n-1}],x],x]] /;
 q>=2*n] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[p] && p<-1 && NegativeIntegerQ[m]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  With[{g=GCD[m+1,n]},
  1/g*Subst[Int[x^((m+1)/g-1)*ReplaceAll[Pq,x->x^(1/g)]*(a+b*x^(n/g)+c*x^(2*n/g))^p,x],x,x^g] /;
 g!=1] /;
FreeQ[{a,b,c,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && IntegerQ[m]


Int[(d_.*x_)^m_.*Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*Pq/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && NiceSqrtQ[b^2-4*a*c]


Int[Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_),x_Symbol] :=
  Int[ExpandIntegrand[Pq/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  (NiceSqrtQ[b^2-4*a*c] || Expon[Pq,x]<n)


Int[Pq_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    c^p*Pqq*Log[a+b*x+c*x^2]/2 + 
    1/2*Int[ExpandToSum[2*Pq-c^p*Pqq*(b+2*c*x)/(a+b*x+c*x^2)^(p+1),x]*(a+b*x+c*x^2)^p,x]] /;
  q+2*p+1==0] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p]


Int[Pq_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    c^p*Pqq*ArcTanh[(b+2*c*x)/(2*Rt[c,2]*Sqrt[a+b*x+c*x^2])] + 
    Int[ExpandToSum[Pq-c^(p+1/2)*Pqq/(a+b*x+c*x^2)^(p+1/2),x]*(a+b*x+c*x^2)^p,x]] /;
  q+2*p+1==0] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1/2] && PosQ[c]


Int[Pq_*(a_+b_.*x_+c_.*x_^2)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    -(-c)^p*Pqq*ArcTan[(b+2*c*x)/(2*Rt[-c,2]*Sqrt[a+b*x+c*x^2])] + 
    Int[ExpandToSum[Pq-(-c)^(p+1/2)*Pqq/(a+b*x+c*x^2)^(p+1/2),x]*(a+b*x+c*x^2)^p,x]] /;
  q+2*p+1==0] /;
FreeQ[{a,b,c},x] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1/2] && NegQ[c]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    Pqq*(d*x)^(m+q-2*n+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(c*d^(q-2*n+1)*(m+q+2*n*p+1)) + 
    Int[(d*x)^m*ExpandToSum[Pq-Pqq*x^q-Pqq*(a*(m+q-2*n+1)*x^(q-2*n)+b*(m+q+n*(p-1)+1)*x^(q-n))/(c*(m+q+2*n*p+1)),x]*
      (a+b*x^n+c*x^(2*n))^p,x]] /;
  q>=2*n && m+q+2*n*p+1!=0 && (IntegerQ[2*p] || n==1 && IntegerQ[4*p] || IntegerQ[p+(q+1)/(2*n)])] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
    With[{Pqq=Coeff[Pq,x,q]},
    Pqq*x^(q-2*n+1)*(a+b*x^n+c*x^(2*n))^(p+1)/(c*(q+2*n*p+1)) + 
    Int[ExpandToSum[Pq-Pqq*x^q-Pqq*(a*(q-2*n+1)*x^(q-2*n)+b*(q+n*(p-1)+1)*x^(q-n))/(c*(q+2*n*p+1)),x]*(a+b*x^n+c*x^(2*n))^p,x]] /;
  q>=2*n && q+2*n*p+1!=0 && (IntegerQ[2*p] || n==1 && IntegerQ[4*p] || IntegerQ[p+(q+1)/(2*n)])] /;
FreeQ[{a,b,c,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],j,k},
  Int[Sum[1/d^j*(d*x)^(m+j)*Sum[Coeff[Pq,x,j+k*n]*x^(k*n),{k,0,(q-j)/n+1}]*(a+b*x^n+c*x^(2*n))^p,{j,0,n-1}],x]] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[PolyQ[Pq,x^n]]


Int[Pq_*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  Module[{q=Expon[Pq,x],j,k},
  Int[Sum[x^j*Sum[Coeff[Pq,x,j+k*n]*x^(k*n),{k,0,(q-j)/n+1}]*(a+b*x^n+c*x^(2*n))^p,{j,0,n-1}],x]] /;
FreeQ[{a,b,c,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && Not[PolyQ[Pq,x^n]]


Int[(d_.*x_)^m_.*Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_.),x_Symbol] :=
  Int[RationalFunctionExpand[(d*x)^m*Pq/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_.),x_Symbol] :=
  Int[RationalFunctionExpand[Pq/(a+b*x^n+c*x^(2*n)),x],x] /;
FreeQ[{a,b,c},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  -Subst[Int[ExpandToSum[x^q*ReplaceAll[Pq,x->x^(-1)],x]*(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+q+2),x],x,1/x]] /;
FreeQ[{a,b,c,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && IntegerQ[m]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[m],q=Expon[Pq,x]},
  -g/d*Subst[Int[ExpandToSum[x^(g*q)*ReplaceAll[Pq,x->d^(-1)*x^(-g)],x]*
    (a+b*d^(-n)*x^(-g*n)+c*d^(-2*n)*x^(-2*g*n))^p/x^(g*(m+q+1)+1),x],x,1/(d*x)^(1/g)]] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && FractionQ[m]


Int[(d_.*x_)^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{q=Expon[Pq,x]},
  -(d*x)^m*(x^(-1))^m*Subst[Int[ExpandToSum[x^q*ReplaceAll[Pq,x->x^(-1)],x]*(a+b*x^(-n)+c*x^(-2*n))^p/x^(m+q+2),x],x,1/x]] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && NegativeIntegerQ[n] && Not[RationalQ[m]]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g*(m+1)-1)*ReplaceAll[Pq,x->x^g]*(a+b*x^(g*n)+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  With[{g=Denominator[n]},
  g*Subst[Int[x^(g-1)*ReplaceAll[Pq,x->x^g]*(a+b*x^(g*n)+c*x^(2*g*n))^p,x],x,x^(1/g)]] /;
FreeQ[{a,b,c,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[(d_*x_)^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^(m-1/2)*Sqrt[d*x]/Sqrt[x]*Int[x^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && FractionQ[n] && PositiveIntegerQ[m+1/2]


Int[(d_*x_)^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  d^(m+1/2)*Sqrt[x]/Sqrt[d*x]*Int[x^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && FractionQ[n] && NegativeIntegerQ[m-1/2]


Int[(d_*x_)^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^m/x^m*Int[x^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c] && FractionQ[n]


Int[x_^m_.*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  1/(m+1)*Subst[Int[ReplaceAll[SubstFor[x^n,Pq,x],x->x^Simplify[n/(m+1)]]*(a+b*x^Simplify[n/(m+1)]+c*x^Simplify[2*n/(m+1)])^p,x],x,x^(m+1)] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && 
  Not[IntegerQ[n]]


Int[(d_*x_)^m_*Pq_*(a_+b_.*x_^n_+c_.*x_^n2_.)^p_,x_Symbol] :=
  (d*x)^m/x^m*Int[x^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,p},x] && EqQ[n2-2*n] && PolyQ[Pq,x^n] && NeQ[b^2-4*a*c] && IntegerQ[Simplify[n/(m+1)]] && 
  Not[IntegerQ[n]]


Int[(d_.*x_)^m_.*Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[(d*x)^m*Pq/(b-q+2*c*x^n),x] -
  2*c/q*Int[(d*x)^m*Pq/(b+q+2*c*x^n),x]] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c]


Int[Pq_/(a_+b_.*x_^n_.+c_.*x_^n2_.),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[Pq/(b-q+2*c*x^n),x] -
  2*c/q*Int[Pq/(b+q+2*c*x^n),x]] /;
FreeQ[{a,b,c,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NeQ[b^2-4*a*c]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(d*x)^m*Pq*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NegativeIntegerQ[p+1]


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_,x_Symbol] :=
  Int[ExpandIntegrand[Pq*(a+b*x^n+c*x^(2*n))^p,x],x] /;
FreeQ[{a,b,c,n},x] && EqQ[n2-2*n] && PolyQ[Pq,x] && NegativeIntegerQ[p+1]


Int[(d_.*x_)^m_.*Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Defer[Int][(d*x)^m*Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,d,m,n,p},x] && EqQ[n2-2*n] && (PolyQ[Pq,x] || PolyQ[Pq,x^n])


Int[Pq_*(a_+b_.*x_^n_.+c_.*x_^n2_.)^p_.,x_Symbol] :=
  Defer[Int][Pq*(a+b*x^n+c*x^(2*n))^p,x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2-2*n] && (PolyQ[Pq,x] || PolyQ[Pq,x^n])


Int[u_^m_.*Pq_*(a_+b_.*v_^n_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  u^m/(Coefficient[v,x,1]*v^m)*Subst[Int[x^m*SubstFor[v,Pq,x]*(a+b*x^n+c*x^(2*n))^p,x],x,v] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[n2-2*n] && LinearPairQ[u,v,x] && PolyQ[Pq,v^n]


Int[Pq_*(a_+b_.*v_^n_+c_.*v_^n2_.)^p_.,x_Symbol] :=
  1/Coefficient[v,x,1]*Subst[Int[SubstFor[v,Pq,x]*(a+b*x^n+c*x^(2*n))^p,x],x,v] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n2-2*n] && LinearQ[v,x] && PolyQ[Pq,v^n]



`)

func resourcesRubi123GeneralTrinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi123GeneralTrinomialProductsM, nil
}

func resourcesRubi123GeneralTrinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi123GeneralTrinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.2.3 General trinomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi124ImproperTrinomialProductsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.2.4 Improper Trinomial Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*1.2.4.1 (a x^q+b x^n+c x^(2 n-q))^p*)


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  Int[((a+b+c)*x^n)^p,x] /;
FreeQ[{a,b,c,n,p},x] && EqQ[n-q] && EqQ[r-n]


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  Int[x^(p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && IntegerQ[p]


Int[Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))])*
    Int[x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))],x] /;
FreeQ[{a,b,c,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q]


Int[1/Sqrt[a_.*x_^2+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  -2/(n-2)*Subst[Int[1/(4*a-x^2),x],x,x*(2*a+b*x^(n-2))/Sqrt[a*x^2+b*x^n+c*x^r]] /;
FreeQ[{a,b,c,n,r},x] && EqQ[r,2*n-2] && PosQ[n-2] && NeQ[b^2-4*a*c,0]


Int[1/Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[1/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]),x] /;
FreeQ[{a,b,c,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q]


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x*(a*x^q+b*x^n+c*x^(2*n-q))^p/(p*(2*n-q)+1) + 
  (n-q)*p/(p*(2*n-q)+1)*
    Int[x^q*(2*a+b*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && RationalQ[p] && p>0 && 
  NeQ[p*(2*n-q)+1]


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  -x^(-q+1)*(b^2-2*a*c+b*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(b^2-4*a*c)) + 
  1/(a*(n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(-q)*((p*q+1)*(b^2-2*a*c)+(n-q)*(p+1)*(b^2-4*a*c)+b*c*(p*q+(n-q)*(2*p+3)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  (a*x^q+b*x^n+c*x^(2*n-q))^p/(x^(p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p)*
    Int[x^(p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,n,p,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]]


Int[(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  Defer[Int][(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c,n,p,q},x] && EqQ[r-(2*n-q)]


Int[(a_.*u_^q_.+b_.*u_^n_.+c_.*u_^r_.)^p_,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(a*x^q+b*x^n+c*x^(2*n-q))^p,x],x,u] /;
FreeQ[{a,b,c,n,p,q},x] && EqQ[r-(2*n-q)] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.4.2 (d x)^m (a x^q+b x^n+c x^(2 n-q))^p*)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_.,x_Symbol] :=
  Int[x^m*((a+b+c)*x^n)^p,x] /;
FreeQ[{a,b,c,m,n,p},x] && EqQ[q-n] && EqQ[r-n]


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_.,x_Symbol] :=
  Int[x^(m+p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,m,n,q},x] && EqQ[r-(2*n-q)] && IntegerQ[p] && PosQ[n-q]


Int[x_^m_./Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  -2/(n-q)*Subst[Int[1/(4*a-x^2),x],x,x^(m+1)*(2*a+b*x^(n-q))/Sqrt[a*x^q+b*x^n+c*x^r]] /;
FreeQ[{a,b,c,m,n,q,r},x] && EqQ[r,2*n-q] && PosQ[n-q] && NeQ[b^2-4*a*c,0] && EqQ[m,q/2-1]


Int[x_^m_./Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[x^(m-q/2)/Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))],x] /;
FreeQ[{a,b,c,m,n,q},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && (EqQ[m-1] && EqQ[n-3] && EqQ[q-2]  ||  
  (EqQ[m+1/2] || EqQ[m-3/2] || EqQ[m-1/2] || EqQ[m-5/2]) && EqQ[n-3] && EqQ[q-1])


Int[x_^m_./(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^(3/2),x_Symbol] :=
  -2*x^((n-1)/2)*(b+2*c*x)/((b^2-4*a*c)*Sqrt[a*x^(n-1)+b*x^n+c*x^(n+1)]) /;
FreeQ[{a,b,c,n},x] && EqQ[m-3*(n-1)/2] && EqQ[q-n+1] && EqQ[r-n-1] && NeQ[b^2-4*a*c]


Int[x_^m_./(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^(3/2),x_Symbol] :=
  x^((n-1)/2)*(4*a+2*b*x)/((b^2-4*a*c)*Sqrt[a*x^(n-1)+b*x^n+c*x^(n+1)]) /;
FreeQ[{a,b,c,n},x] && EqQ[m-(3*n-1)/2] && EqQ[q-n+1] && EqQ[r-n-1] && NeQ[b^2-4*a*c]


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-n)*(a*x^(n-1)+b*x^n+c*x^(n+1))^(p+1)/(2*c*(p+1)) - 
  b/(2*c)*Int[x^(m-1)*(a*x^(n-1)+b*x^n+c*x^(n+1))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && m+p*(n-1)-1==0


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-n+q+1)*(b+2*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p/(2*c*(n-q)*(2*p+1)) - 
  p*(b^2-4*a*c)/(2*c*(2*p+1))*Int[x^(m+q)*(a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q+1==n-q


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-n+q+1)*(b*(n-q)*p+c*(m+p*q+(n-q)*(2*p-1)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p/(c*(m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p-1)+1)) + 
  (n-q)*p/(c*(m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p-1)+1))*
    Int[x^(m-(n-2*q))*
      Simp[-a*b*(m+p*q-n+q+1)+(2*a*c*(m+p*q+(n-q)*(2*p-1)+1)-b^2*(m+p*q+(n-q)*(p-1)+1))*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q+1>n-q && m+p*(2*n-q)+1!=0 && m+p*q+(n-q)*(2*p-1)+1!=0


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m+1)*(a*x^q+b*x^n+c*x^(2*n-q))^p/(m+p*q+1) - 
  (n-q)*p/(m+p*q+1)*Int[x^(m+n)*(b+2*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q+1<=-(n-q)+1 && NeQ[m+p*q+1]


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m+1)*(a*x^q+b*x^n+c*x^(2*n-q))^p/(m+p*(2*n-q)+1) + 
  (n-q)*p/(m+p*(2*n-q)+1)*Int[x^(m+q)*(2*a+b*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q+1>-(n-q) && m+p*(2*n-q)+1!=0


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  -x^(m-q+1)*(b^2-2*a*c+b*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(b^2-4*a*c)) + 
  (2*a*c-b^2*(p+2))/(a*(p+1)*(b^2-4*a*c))*
    Int[x^(m-q)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && m+p*q+1==-(n-q)*(2*p+3)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  -x^(m-2*n+q+1)*(2*a+b*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/((n-q)*(p+1)*(b^2-4*a*c)) + 
  1/((n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(m-2*n+q)*(2*a*(m+p*q-2*(n-q)+1)+b*(m+p*q+(n-q)*(2*p+1)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && m+p*q+1>2*(n-q)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  -x^(m-q+1)*(b^2-2*a*c+b*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(b^2-4*a*c)) + 
  1/(a*(n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(m-q)*
      (b^2*(m+p*q+(n-q)*(p+1)+1)-2*a*c*(m+p*q+2*(n-q)*(p+1)+1)+b*c*(m+p*q+(n-q)*(2*p+3)+1)*x^(n-q))*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && m+p*q+1<n-q


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-n+1)*(b+2*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/((n-q)*(p+1)*(b^2-4*a*c)) - 
  1/((n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(m-n)*(b*(m+p*q-n+q+1)+2*c*(m+p*q+2*(n-q)*(p+1)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && n-q<m+p*q+1<2*(n-q)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-2*n+q+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(2*c*(n-q)*(p+1)) - 
  b/(2*c)*Int[x^(m-n+q)*(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && -1<=p<0 && m+p*q+1==2*(n-q)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  -x^(m-q+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(2*a*(n-q)*(p+1)) - 
  b/(2*a)*Int[x^(m+n-q)*(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && -1<=p<0 && m+p*q+1==-2*(n-q)*(p+1)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-2*n+q+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(c*(m+p*q+2*(n-q)*p+1)) - 
  1/(c*(m+p*q+2*(n-q)*p+1))*
    Int[x^(m-2*(n-q))*(a*(m+p*q-2*(n-q)+1)+b*(m+p*q+(n-q)*(p-1)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && -1<=p<0 && m+p*q+1>2*(n-q)


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(m-q+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(m+p*q+1)) - 
  1/(a*(m+p*q+1))*
    Int[x^(m+n-q)*(b*(m+p*q+(n-q)*(p+1)+1)+c*(m+p*q+2*(n-q)*(p+1)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c},x] && EqQ[r-(2*n-q)] && PosQ[n-q] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && -1<=p<0 && m+p*q+1<0


Int[x_^m_.*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  (a*x^q+b*x^n+c*x^(2*n-q))^p/(x^(p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p)*
    Int[x^(m+p*q)*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,m,n,p,q},x] && EqQ[r-(2*n-q)] && Not[IntegerQ[p]] && PosQ[n-q]


Int[u_^m_.*(a_.*u_^q_.+b_.*u_^n_.+c_.*u_^r_.)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[x^m*(a*x^q+b*x^n+c*x^(2*n-q))^p,x],x,u] /;
FreeQ[{a,b,c,m,n,p,q},x] && EqQ[r-(2*n-q)] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.4.3 (d+e x^(n-q)) (a x^q+b x^n+c x^(2 n-q))^p*)


Int[(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  Int[x^(p*q)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,n,q},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && IntegerQ[p] && PosQ[n-q]


(* Int[(A_+B_.*x_^j_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))])*
    Int[x^(q*p)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PosQ[n-q] && PositiveIntegerQ[p+1/2] *)


(* Int[(A_+B_.*x_^j_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[x^(q*p)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PosQ[n-q] && NegativeIntegerQ[p-1/2] *)


(* Int[(A_+B_.*x_^j_.)*Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))])*
    Int[x^(q/2)*(A+B*x^(n-q))*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))],x] /;
FreeQ[{a,b,c,A,B,n,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PosQ[n-q] *)


Int[(A_+B_.*x_^j_.)/Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[(A+B*x^(n-q))/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]),x] /;
FreeQ[{a,b,c,A,B,n,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PosQ[n-q] && 
  EqQ[n-3] && EqQ[q-2]


Int[(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_,x_Symbol] :=
  x*(b*B*(n-q)*p+A*c*(p*q+(n-q)*(2*p+1)+1)+B*c*(p*(2*n-q)+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p/
    (c*(p*(2*n-q)+1)*(p*q+(n-q)*(2*p+1)+1)) + 
  (n-q)*p/(c*(p*(2*n-q)+1)*(p*q+(n-q)*(2*p+1)+1))*
    Int[x^q*
      (2*a*A*c*(p*q+(n-q)*(2*p+1)+1)-a*b*B*(p*q+1)+(2*a*B*c*(p*(2*n-q)+1)+A*b*c*(p*q+(n-q)*(2*p+1)+1)-b^2*B*(p*q+(n-q)*p+1))*x^(n-q))*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c,A,B,n,q},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && RationalQ[p] && p>0 && 
  NeQ[p*(2*n-q)+1] && NeQ[p*q+(n-q)*(2*p+1)+1]


Int[(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_,x_Symbol] :=
  With[{n=q+r},
  x*(A*(p*q+(n-q)*(2*p+1)+1)+B*(p*(2*n-q)+1)*x^(n-q))*(a*x^q+c*x^(2*n-q))^p/((p*(2*n-q)+1)*(p*q+(n-q)*(2*p+1)+1)) + 
  (n-q)*p/((p*(2*n-q)+1)*(p*q+(n-q)*(2*p+1)+1))*
    Int[x^q*(2*a*A*(p*q+(n-q)*(2*p+1)+1)+(2*a*B*(p*(2*n-q)+1))*x^(n-q))*(a*x^q+c*x^(2*n-q))^(p-1),x] /;
 EqQ[j-(2*n-q)] && NeQ[p*(2*n-q)+1] && NeQ[p*q+(n-q)*(2*p+1)+1]] /;
FreeQ[{a,c,A,B,q},x] && Not[IntegerQ[p]] && RationalQ[p] && p>0


Int[(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_,x_Symbol] :=
  -x^(-q+1)*(A*b^2-a*b*B-2*a*A*c+(A*b-2*a*B)*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(b^2-4*a*c)) + 
  1/(a*(n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(-q)*
      ((A*b^2*(p*q+(n-q)*(p+1)+1)-a*b*B*(p*q+1)-2*a*A*c*(p*q+2*(n-q)*(p+1)+1)+(p*q+(n-q)*(2*p+3)+1)*(A*b-2*a*B)*c*x^(n-q))*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p+1)),x] /;
FreeQ[{a,b,c,A,B,n,q},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && RationalQ[p] && p<-1


Int[(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_,x_Symbol] :=
  With[{n=q+r},
  -x^(-q+1)*(a*A*c+a*B*c*x^(n-q))*(a*x^q+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(2*a*c)) + 
  1/(a*(n-q)*(p+1)*(2*a*c))*
    Int[x^(-q)*((a*A*c*(p*q+2*(n-q)*(p+1)+1)+a*B*c*(p*q+(n-q)*(2*p+3)+1)*x^(n-q))*(a*x^q+c*x^(2*n-q))^(p+1)),x] /;
 EqQ[j-(2*n-q)]] /;
FreeQ[{a,c,A,B,q},x] && Not[IntegerQ[p]] && RationalQ[p] && p<-1


(* Int[(A_+B_.*x_^q_)*(a_.*x_^j_.+b_.*x_^k_.+c_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^k+c*x^n)^p/(x^(j*p)*(a+b*x^(k-j)+c*x^(2*(k-j)))^p)*
    Int[x^(j*p)*(A+B*x^(k-j))*(a+b*x^(k-j)+c*x^(2*(k-j)))^p,x] /;
FreeQ[{a,b,c,A,B,j,k,p},x] && EqQ[q-(k-j)] && EqQ[n-(2*k-j)] && PosQ[k-j] && Not[IntegerQ[p]] *)


Int[(A_+B_.*x_^j_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_.,x_Symbol] :=
  Defer[Int][(A+B*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c,A,B,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)]


Int[(A_+B_.*u_^j_.)*(a_.*u_^q_.+b_.*u_^n_.+c_.*u_^r_.)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[(A+B*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p,x],x,u] /;
FreeQ[{a,b,c,A,B,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && LinearQ[u,x] && NeQ[u-x]





(* ::Subsection::Closed:: *)
(*1.2.4.4 (f x)^m (d+e x^(n-q)) (a x^q+b x^n+c x^(2 n-q))^p*)


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  Int[x^(m+p*q)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,m,n,q},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && IntegerQ[p] && PosQ[n-q]


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  x^(m+1)*(A*(m+p*q+(n-q)*(2*p+1)+1)+B*(m+p*q+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p/((m+p*q+1)*(m+p*q+(n-q)*(2*p+1)+1)) + 
  (n-q)*p/((m+p*q+1)*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(n+m)*
      Simp[2*a*B*(m+p*q+1)-A*b*(m+p*q+(n-q)*(2*p+1)+1)+(b*B*(m+p*q+1)-2*A*c*(m+p*q+(n-q)*(2*p+1)+1))*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q<=-(n-q) && m+p*q+1!=0 && m+p*q+(n-q)*(2*p+1)+1!=0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  x^(m+1)*(A*(m+p*q+(n-q)*(2*p+1)+1)+B*(m+p*q+1)*x^(n-q))*(a*x^q+c*x^(2*n-q))^p/((m+p*q+1)*(m+p*q+(n-q)*(2*p+1)+1)) + 
  2*(n-q)*p/((m+p*q+1)*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(n+m)*Simp[a*B*(m+p*q+1)-A*c*(m+p*q+(n-q)*(2*p+1)+1)*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^(p-1),x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && m+p*q<=-(n-q) && m+p*q+1!=0 && m+p*q+(n-q)*(2*p+1)+1!=0] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q] && p>0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  x^(m-n+1)*(A*b-2*a*B-(b*B-2*A*c)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/((n-q)*(p+1)*(b^2-4*a*c)) + 
  1/((n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(m-n)*
      Simp[(m+p*q-n+q+1)*(2*a*B-A*b)+(m+p*q+2*(n-q)*(p+1)+1)*(b*B-2*A*c)*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && m+p*q>n-q-1


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  x^(m-n+1)*(a*B-A*c*x^(n-q))*(a*x^q+c*x^(2*n-q))^(p+1)/(2*a*c*(n-q)*(p+1)) - 
  1/(2*a*c*(n-q)*(p+1))*
    Int[x^(m-n)*Simp[a*B*(m+p*q-n+q+1)-A*c*(m+p*q+(n-q)*2*(p+1)+1)*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^(p+1),x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && m+p*q>n-q-1] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q] && p<-1


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  x^(m+1)*(b*B*(n-q)*p+A*c*(m+p*q+(n-q)*(2*p+1)+1)+B*c*(m+p*q+2*(n-q)*p+1)*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p/
    (c*(m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p+1)+1)) + 
  (n-q)*p/(c*(m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(m+q)*
      Simp[2*a*A*c*(m+p*q+(n-q)*(2*p+1)+1)-a*b*B*(m+p*q+1)+
        (2*a*B*c*(m+p*q+2*(n-q)*p+1)+A*b*c*(m+p*q+(n-q)*(2*p+1)+1)-b^2*B*(m+p*q+(n-q)*p+1))*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p-1),x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p>0 && m+p*q>-(n-q)-1 && m+p*(2*n-q)+1!=0 && m+p*q+(n-q)*(2*p+1)+1!=0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  x^(m+1)*(A*(m+p*q+(n-q)*(2*p+1)+1)+B*(m+p*q+2*(n-q)*p+1)*x^(n-q))*(a*x^q+c*x^(2*n-q))^p/
    ((m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p+1)+1)) + 
  (n-q)*p/((m+p*(2*n-q)+1)*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(m+q)*Simp[2*a*A*(m+p*q+(n-q)*(2*p+1)+1)+2*a*B*(m+p*q+2*(n-q)*p+1)*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^(p-1),x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && m+p*q>-(n-q) && m+p*q+2*(n-q)*p+1!=0 && m+p*q+(n-q)*(2*p+1)+1!=0 && m+1!=n] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q] && p>0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  -x^(m-q+1)*(A*b^2-a*b*B-2*a*A*c+(A*b-2*a*B)*c*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(n-q)*(p+1)*(b^2-4*a*c)) + 
  1/(a*(n-q)*(p+1)*(b^2-4*a*c))*
    Int[x^(m-q)*
      Simp[A*b^2*(m+p*q+(n-q)*(p+1)+1)-a*b*B*(m+p*q+1)-2*a*A*c*(m+p*q+2*(n-q)*(p+1)+1)+
        (m+p*q+(n-q)*(2*p+3)+1)*(A*b-2*a*B)*c*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^(p+1),x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && p<-1 && m+p*q<n-q-1


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  -x^(m-q+1)*(A*c+B*c*x^(n-q))*(a*x^q+c*x^(2*n-q))^(p+1)/(2*a*c*(n-q)*(p+1)) + 
  1/(2*a*c*(n-q)*(p+1))*
    Int[x^(m-q)*Simp[A*c*(m+p*q+2*(n-q)*(p+1)+1)+B*(m+p*q+(n-q)*(2*p+3)+1)*c*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^(p+1),x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && m+p*q<n-q-1] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q] && p<-1


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  B*x^(m-n+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(c*(m+p*q+(n-q)*(2*p+1)+1)) - 
  1/(c*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(m-n+q)*
      Simp[a*B*(m+p*q-n+q+1)+(b*B*(m+p*q+(n-q)*p+1)-A*c*(m+p*q+(n-q)*(2*p+1)+1))*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && -1<=p<0 && m+p*q>=n-q-1 && m+p*q+(n-q)*(2*p+1)+1!=0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  B*x^(m-n+1)*(a*x^q+c*x^(2*n-q))^(p+1)/(c*(m+p*q+(n-q)*(2*p+1)+1)) - 
  1/(c*(m+p*q+(n-q)*(2*p+1)+1))*
    Int[x^(m-n+q)*Simp[a*B*(m+p*q-n+q+1)-A*c*(m+p*q+(n-q)*(2*p+1)+1)*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^p,x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && m+p*q>=n-q-1 && m+p*q+(n-q)*(2*p+1)+1!=0] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q] && -1<=p<0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  A*x^(m-q+1)*(a*x^q+b*x^n+c*x^(2*n-q))^(p+1)/(a*(m+p*q+1)) + 
  1/(a*(m+p*q+1))*
    Int[x^(m+n-q)*
      Simp[a*B*(m+p*q+1)-A*b*(m+p*q+(n-q)*(p+1)+1)-A*c*(m+p*q+2*(n-q)*(p+1)+1)*x^(n-q),x]*
      (a*x^q+b*x^n+c*x^(2*n-q))^p,x] /;
FreeQ[{a,b,c,A,B},x] && EqQ[r-(n-q)] && EqQ[j-(2*n-q)] && Not[IntegerQ[p]] && NeQ[b^2-4*a*c] && PositiveIntegerQ[n] && 
  RationalQ[m,p,q] && (-1<=p<0 || m+p*q+(n-q)*(2*p+1)+1==0) && m+p*q<=-(n-q) && m+p*q+1!=0


Int[x_^m_.*(A_+B_.*x_^r_.)*(a_.*x_^q_.+c_.*x_^j_.)^p_.,x_Symbol] :=
  With[{n=q+r},
  A*x^(m-q+1)*(a*x^q+c*x^(2*n-q))^(p+1)/(a*(m+p*q+1)) + 
  1/(a*(m+p*q+1))*
    Int[x^(m+n-q)*Simp[a*B*(m+p*q+1)-A*c*(m+p*q+2*(n-q)*(p+1)+1)*x^(n-q),x]*(a*x^q+c*x^(2*n-q))^p,x] /;
 EqQ[j-(2*n-q)] && PositiveIntegerQ[n] && (-1<=p<0 || m+p*q+(n-q)*(2*p+1)+1==0) && m+p*q<=-(n-q) && m+p*q+1!=0] /;
FreeQ[{a,c,A,B},x] && Not[IntegerQ[p]] && RationalQ[m,p,q]


Int[x_^m_.*(A_+B_.*x_^j_.)/Sqrt[a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.],x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[x^(m-q/2)*(A+B*x^(n-q))/Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))],x] /;
FreeQ[{a,b,c,A,B,m,n,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PosQ[n-q] && 
	(EqQ[m-1/2] || EqQ[m+1/2]) && EqQ[n-3] && EqQ[q-1]


(* Int[x_^m_.*(A_+B_.*x_^j_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]/(x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))])*
    Int[x^(m+q*p)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,m,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && PositiveIntegerQ[p+1/2] && PosQ[n-q] *)


(* Int[x_^m_.*(A_+B_.*x_^j_.)*(a_.*x_^q_.+b_.*x_^n_.+c_.*x_^r_.)^p_,x_Symbol] :=
  x^(q/2)*Sqrt[a+b*x^(n-q)+c*x^(2*(n-q))]/Sqrt[a*x^q+b*x^n+c*x^(2*n-q)]*
    Int[x^(m+q*p)*(A+B*x^(n-q))*(a+b*x^(n-q)+c*x^(2*(n-q)))^p,x] /;
FreeQ[{a,b,c,A,B,m,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && NegativeIntegerQ[p-1/2] && PosQ[n-q] *)


Int[x_^m_.*(A_+B_.*x_^q_)*(a_.*x_^j_.+b_.*x_^k_.+c_.*x_^n_.)^p_,x_Symbol] :=
  (a*x^j+b*x^k+c*x^n)^p/(x^(j*p)*(a+b*x^(k-j)+c*x^(2*(k-j)))^p)*
    Int[x^(m+j*p)*(A+B*x^(k-j))*(a+b*x^(k-j)+c*x^(2*(k-j)))^p,x] /;
FreeQ[{a,b,c,A,B,j,k,m,p},x] && EqQ[q-(k-j)] && EqQ[n-(2*k-j)] && Not[IntegerQ[p]] && PosQ[k-j]


Int[u_^m_.*(A_+B_.*u_^j_.)*(a_.*u_^q_.+b_.*u_^n_.+c_.*u_^r_.)^p_.,x_Symbol] :=
  1/Coefficient[u,x,1]*Subst[Int[x^m*(A+B*x^(n-q))*(a*x^q+b*x^n+c*x^(2*n-q))^p,x],x,u] /;
FreeQ[{a,b,c,A,B,m,n,p,q},x] && EqQ[j-(n-q)] && EqQ[r-(2*n-q)] && LinearQ[u,x] && NeQ[u-x]



`)

func resourcesRubi124ImproperTrinomialProductsMBytes() ([]byte, error) {
	return _resourcesRubi124ImproperTrinomialProductsM, nil
}

func resourcesRubi124ImproperTrinomialProductsM() (*asset, error) {
	bytes, err := resourcesRubi124ImproperTrinomialProductsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.2.4 Improper trinomial products.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi13MiscellaneousAlgebraicFunctionsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*1.3 Miscellaneous Algebraic Function Rules*)


(* ::Subsection::Closed:: *)
(*1.3.1 u (a+b x+c x^2+d x^3)^p*)


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*a^(2*p))*Int[(3*a-b*x)^p*(3*a+2*b*x)^(2*p),x] /;
FreeQ[{a,b,d},x] && IntegerQ[p] && EqQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandToSum[(a+b*x+d*x^3)^p,x],x] /;
FreeQ[{a,b,d},x] && PositiveIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+b*x+d*x^3]},
  FreeFactors[u,x]^p*Int[DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,b,d},x] && NegativeIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*b^3*d+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p,x]] /;
FreeQ[{a,b,d},x] && NegativeIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  (a+b*x+d*x^3)^p/((3*a-b*x)^p*(3*a+2*b*x)^(2*p))*Int[(3*a-b*x)^p*(3*a+2*b*x)^(2*p),x] /;
FreeQ[{a,b,d,p},x] && Not[IntegerQ[p]] && EqQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+b*x+d*x^3],x]},
  (a+b*x+d*x^3)^p/DistributeDegree[u,p]*Int[DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,b,d,p},x] && Not[IntegerQ[p]] && NeQ[4*b^3+27*a^2*d]


Int[(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*b^3*d+27*a^2*d^2],3]},
  (a+b*x+d*x^3)^p/(((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p)*
    Int[((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p,x]] /;
FreeQ[{a,b,d,p},x] && Not[IntegerQ[p]] && NeQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*a^(2*p))*Int[(e+f*x)^m*(3*a-b*x)^p*(3*a+2*b*x)^(2*p),x] /;
FreeQ[{a,b,d,e,f,m},x] && IntegerQ[p] && EqQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(e+f*x)^m*(a+b*x+d*x^3)^p,x],x] /;
FreeQ[{a,b,d,e,f,m},x] && PositiveIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+b*x+d*x^3]},
  FreeFactors[u,x]^p*Int[(e+f*x)^m*DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,b,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*b^3*d+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[(e+f*x)^m*((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p,x]] /;
FreeQ[{a,b,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  (a+b*x+d*x^3)^p/((3*a-b*x)^p*(3*a+2*b*x)^(2*p))*Int[(e+f*x)^m*(3*a-b*x)^p*(3*a+2*b*x)^(2*p),x] /;
FreeQ[{a,b,d,e,f,m,p},x] && Not[IntegerQ[p]] && EqQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+b*x+d*x^3],x]},
  (a+b*x+d*x^3)^p/DistributeDegree[u,p]*Int[(e+f*x)^m*DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,b,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[4*b^3+27*a^2*d]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*b^3*d+27*a^2*d^2],3]},
  (a+b*x+d*x^3)^p/(((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p)*
    Int[(e+f*x)^m*((6*b*d-2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      ((6*(1+I*Sqrt[3])*b*d-2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p*
      ((6*(1-I*Sqrt[3])*b*d-2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)-3*d*x)^p,x]] /;
FreeQ[{a,b,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[4*b^3+27*a^2*d]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  -1/(3^(3*p)*d^(2*p))*Int[(c-3*d*x)^p*(2*c+3*d*x)^(2*p),x] /;
FreeQ[{a,c,d},x] && IntegerQ[p] && EqQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandToSum[(a+c*x^2+d*x^3)^p,x],x] /;
FreeQ[{a,c,d},x] && PositiveIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+c*x^2+d*x^3]},
  FreeFactors[u,x]^p*Int[DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,c,d},x] && NegativeIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*a*c^3+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[(c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,c,d},x] && NegativeIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  (a+c*x^2+d*x^3)^p/((c-3*d*x)^p*(2*c+3*d*x)^(2*p))*Int[(c-3*d*x)^p*(2*c+3*d*x)^(2*p),x] /;
FreeQ[{a,c,d,p},x] && Not[IntegerQ[p]] && EqQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+c*x^2+d*x^3],x]},
  (a+c*x^2+d*x^3)^p/DistributeDegree[u,p]*Int[DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,c,d,p},x] && Not[IntegerQ[p]] && NeQ[4*c^3+27*a*d^2]


Int[(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*a*c^3+27*a^2*d^2],3]},
  (a+c*x^2+d*x^3)^p/((c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p)*
    Int[(c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,c,d,p},x] && Not[IntegerQ[p]] && NeQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  -1/(3^(3*p)*d^(2*p))*Int[(e+f*x)^m*(c-3*d*x)^p*(2*c+3*d*x)^(2*p),x] /;
FreeQ[{a,c,d,e,f,m},x] && IntegerQ[p] && EqQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(e+f*x)^m*(a+c*x^2+d*x^3)^p,x],x] /;
FreeQ[{a,c,d,e,f,m},x] && PositiveIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+c*x^2+d*x^3]},
  FreeFactors[u,x]^p*Int[(e+f*x)^m*DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,c,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*a*c^3+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[(e+f*x)^m*(c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,c,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  (a+c*x^2+d*x^3)^p/((c-3*d*x)^p*(2*c+3*d*x)^(2*p))*Int[(e+f*x)^m*(c-3*d*x)^p*(2*c+3*d*x)^(2*p),x] /;
FreeQ[{a,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && EqQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+c*x^2+d*x^3],x]},
  (a+c*x^2+d*x^3)^p/DistributeDegree[u,p]*Int[(e+f*x)^m*DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[4*c^3+27*a*d^2]


Int[(e_.+f_.*x_)^m_.*(a_.+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3-27*a*d^2+3*Sqrt[3]*d*Sqrt[4*a*c^3+27*a^2*d^2],3]},
  (a+c*x^2+d*x^3)^p/((c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p)*
    Int[(e+f*x)^m*(c-(2*c^2+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2+2^(1/3)*(1-I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2+2^(1/3)*(1+I*Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[4*c^3+27*a*d^2]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^p*b^p*c^p)*Int[(b+c*x)^(3*p),x] /;
FreeQ[{a,b,c,d},x] && IntegerQ[p] && EqQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^p*b^p*c^p)*Subst[Int[(3*a*b*c-b^3+c^3*x^3)^p,x],x,x+c/(3*d)] /;
FreeQ[{a,b,c,d},x] && IntegerQ[p] && EqQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


(* Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[b^3-3*a*b*c,3]},
  1/(3^p*b^p*c^p)*Int[(b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p,x]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[p] && EqQ[c^2-3*b*d] && NeQ[b^2-3*a*c] *)


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[c^3-3*b*c*d,3]},
  1/(3^p*b^p*c^p)*Int[(b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p,x]] /;
FreeQ[{a,b,c,d},x] && IntegerQ[p] && NeQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandToSum[(a+b*x+c*x^2+d*x^3)^p,x],x] /;
FreeQ[{a,b,c,d},x] && PositiveIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+b*x+c*x^2+d*x^3]},
  FreeFactors[u,x]^p*Int[DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,b,c,d},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*d^(2*p))*Subst[Int[(2*c^3-9*b*c*d+27*a*d^2-9*d*(c^2-3*b*d)*x+27*d^3*x^3)^p,x],x,x+c/(3*d)] /;
FreeQ[{a,b,c,d},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


(* Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3+9*b*c*d-27*a*d^2+3*Sqrt[3]*d*Sqrt[-b^2*c^2+4*a*c^3+4*b^3*d-18*a*b*c*d+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[(c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,b,c,d},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c] *)


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  (a+b*x+c*x^2+d*x^3)^p/(b+c*x)^(3*p)*Int[(b+c*x)^(3*p),x] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] && EqQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[b^3-3*a*b*c,3]},
  (a+b*x+c*x^2+d*x^3)^p/((b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p)*
    Int[(b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p,x]] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] && EqQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[c^3-3*b*c*d,3]},
  (a+b*x+c*x^2+d*x^3)^p/((b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p)*
    Int[(b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p,x]] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+b*x+c*x^2+d*x^3],x]},
  (a+b*x+c*x^2+d*x^3)^p/DistributeDegree[u,p]*Int[DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


(* Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*d^(2*p))*Subst[Int[(2*c^3-9*b*c*d+27*a*d^2-9*d*(c^2-3*b*d)*x+27*d^3*x^3)^p,x],x,x+c/(3*d)] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] *)


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3+9*b*c*d-27*a*d^2+3*Sqrt[3]*d*Sqrt[-b^2*c^2+4*a*c^3+4*b^3*d-18*a*b*c*d+27*a^2*d^2],3]},
  (a+b*x+c*x^2+d*x^3)^p/
    ((c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p)*
    Int[(c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,b,c,d,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[u_^p_,x_Symbol] :=
  Int[ExpandToSum[u,x]^p,x] /;
FreeQ[p,x] && PolyQ[u,x,3] && Not[CubicMatchQ[u,x]]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^p*b^p*c^p)*Int[(e+f*x)^m*(b+c*x)^(3*p),x] /;
FreeQ[{a,b,c,d,e,f,m},x] && IntegerQ[p] && EqQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[b^3-3*a*b*c,3]},
  1/(3^p*b^p*c^p)*Int[(e+f*x)^m*(b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && IntegerQ[p] && EqQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[c^3-3*b*c*d,3]},
  1/(3^p*b^p*c^p)*Int[(e+f*x)^m*(b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && IntegerQ[p] && NeQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  Int[ExpandIntegrand[(e+f*x)^m*(a+b*x+c*x^2+d*x^3)^p,x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && PositiveIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=Factor[a+b*x+c*x^2+d*x^3]},
  FreeFactors[u,x]^p*Int[(e+f*x)^m*DistributeDegree[NonfreeFactors[u,x],p],x] /;
 ProductQ[NonfreeFactors[u,x]]] /;
FreeQ[{a,b,c,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*d^(2*p))*Subst[Int[(2*c^3-9*b*c*d+27*a*d^2-9*d*(c^2-3*b*d)*x+27*d^3*x^3)^p,x],x,x+c/(3*d)] /;
FreeQ[{a,b,c,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


(* Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3+9*b*c*d-27*a*d^2+3*Sqrt[3]*d*Sqrt[-b^2*c^2+4*a*c^3+4*b^3*d-18*a*b*c*d+27*a^2*d^2],3]},
  1/(3^(3*p)*d^(2*p))*
    Int[(e+f*x)^m*(c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && NegativeIntegerQ[p] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c] *)


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  (a+b*x+c*x^2+d*x^3)^p/(b+c*x)^(3*p)*Int[(e+f*x)^m*(b+c*x)^(3*p),x] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && EqQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[b^3-3*a*b*c,3]},
  (a+b*x+c*x^2+d*x^3)^p/((b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p)*
    Int[(e+f*x)^m*(b-r+c*x)^p*(b+(1-I*Sqrt[3])*r/2+c*x)^p*(b+(1+I*Sqrt[3])*r/2+c*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && EqQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[c^3-3*b*c*d,3]},
  (a+b*x+c*x^2+d*x^3)^p/((b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p)*
    Int[(e+f*x)^m*(b+(c-r)*x)^p*(b+(c+(1-I*Sqrt[3])*r/2)*x)^p*(b+(c+(1+I*Sqrt[3])*r/2)*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && EqQ[b^2-3*a*c]


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{u=NonfreeFactors[Factor[a+b*x+c*x^2+d*x^3],x]},
  (a+b*x+c*x^2+d*x^3)^p/DistributeDegree[u,p]*Int[(e+f*x)^m*DistributeDegree[u,p],x] /;
 ProductQ[u]] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


(* Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  1/(3^(3*p)*d^(2*p))*Subst[Int[(2*c^3-9*b*c*d+27*a*d^2-9*d*(c^2-3*b*d)*x+27*d^3*x^3)^p,x],x,x+c/(3*d)] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] *)


Int[(e_.+f_.*x_)^m_.*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3)^p_,x_Symbol] :=
  With[{r=Rt[-2*c^3+9*b*c*d-27*a*d^2+3*Sqrt[3]*d*Sqrt[-b^2*c^2+4*a*c^3+4*b^3*d-18*a*b*c*d+27*a^2*d^2],3]},
  (a+b*x+c*x^2+d*x^3)^p/
    ((c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p)*
    Int[(e+f*x)^m*(c-(2*c^2-6*b*d+2^(1/3)*r^2)/(2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1+I*Sqrt[3])*c^2-6*(1+I*Sqrt[3])*b*d-I*2^(1/3)*(I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p*
      (c+(2*(1-I*Sqrt[3])*c^2-6*(1-I*Sqrt[3])*b*d+I*2^(1/3)*(-I+Sqrt[3])*r^2)/(2*2^(2/3)*r)+3*d*x)^p,x]] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && Not[IntegerQ[p]] && NeQ[c^2-3*b*d] && NeQ[b^2-3*a*c]


Int[u_^m_.*v_^p_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*ExpandToSum[v,x]^p,x] /;
FreeQ[{m,p},x] && LinearQ[u,x] && PolyQ[v,x,3] && Not[LinearMatchQ[u,x] && CubicMatchQ[v,x]]





(* ::Subsection::Closed:: *)
(*1.3.2 u (a+b x+c x^2+d x^3+e x^4)^p*)


Int[(f_+g_.*x_^2)/((d_+e_.*x_+d_.*x_^2)*Sqrt[a_+b_.*x_+c_.*x_^2+b_.*x_^3+a_.*x_^4]),x_Symbol] :=
  a*f/(d*Rt[a^2*(2*a-c),2])*ArcTan[(a*b+(4*a^2+b^2-2*a*c)*x+a*b*x^2)/(2*Rt[a^2*(2*a-c),2]*Sqrt[a+b*x+c*x^2+b*x^3+a*x^4])] /;
FreeQ[{a,b,c,d,e,f,g},x] && EqQ[b*d-a*e] && EqQ[f+g] && PosQ[a^2*(2*a-c)]


Int[(f_+g_.*x_^2)/((d_+e_.*x_+d_.*x_^2)*Sqrt[a_+b_.*x_+c_.*x_^2+b_.*x_^3+a_.*x_^4]),x_Symbol] :=
  -a*f/(d*Rt[-a^2*(2*a-c),2])*ArcTanh[(a*b+(4*a^2+b^2-2*a*c)*x+a*b*x^2)/(2*Rt[-a^2*(2*a-c),2]*Sqrt[a+b*x+c*x^2+b*x^3+a*x^4])] /;
FreeQ[{a,b,c,d,e,f,g},x] && EqQ[b*d-a*e] && EqQ[f+g] && NegQ[a^2*(2*a-c)]


Int[(a_.+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4)^p_,x_Symbol] :=
  Subst[Int[SimplifyIntegrand[(a+d^4/(256*e^3)-b*d/(8*e)+(c-3*d^2/(8*e))*x^2+e*x^4)^p,x],x],x,d/(4*e)+x] /;
FreeQ[{a,b,c,d,e,p},x] && EqQ[d^3-4*c*d*e+8*b*e^2] && p=!=2 && p=!=3


Int[v_^p_,x_Symbol] :=
  With[{a=Coefficient[v,x,0],b=Coefficient[v,x,1],c=Coefficient[v,x,2],d=Coefficient[v,x,3],e=Coefficient[v,x,4]},
  Subst[Int[SimplifyIntegrand[(a+d^4/(256*e^3)-b*d/(8*e)+(c-3*d^2/(8*e))*x^2+e*x^4)^p,x],x],x,d/(4*e)+x] /;
 EqQ[d^3-4*c*d*e+8*b*e^2] && NeQ[d]] /;
FreeQ[p,x] && PolynomialQ[v,x] && Exponent[v,x]==4 && p=!=2 && p=!=3


Int[u_*(a_.+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4)^p_,x_Symbol] :=
  Subst[Int[SimplifyIntegrand[ReplaceAll[u,x->-d/(4*e)+x]*(a+d^4/(256*e^3)-b*d/(8*e)+(c-3*d^2/(8*e))*x^2+e*x^4)^p,x],x],x,d/(4*e)+x] /;
FreeQ[{a,b,c,d,e,p},x] && PolynomialQ[u,x] && EqQ[d^3-4*c*d*e+8*b*e^2] && Not[PositiveIntegerQ[p]]


Int[u_*v_^p_,x_Symbol] :=
  With[{a=Coefficient[v,x,0],b=Coefficient[v,x,1],c=Coefficient[v,x,2],d=Coefficient[v,x,3],e=Coefficient[v,x,4]},
  Subst[Int[SimplifyIntegrand[ReplaceAll[u,x->-d/(4*e)+x]*(a+d^4/(256*e^3)-b*d/(8*e)+(c-3*d^2/(8*e))*x^2+e*x^4)^p,x],x],x,d/(4*e)+x] /;
 EqQ[d^3-4*c*d*e+8*b*e^2] && NeQ[d]] /;
FreeQ[p,x] && PolynomialQ[u,x] && PolynomialQ[v,x] && Exponent[v,x]==4 && Not[PositiveIntegerQ[p]]


Int[(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4)^p_,x_Symbol] :=
  -16*a^2*Subst[
    Int[1/(b-4*a*x)^2*(a*(-3*b^4+16*a*b^2*c-64*a^2*b*d+256*a^3*e-32*a^2*(3*b^2-8*a*c)*x^2+256*a^4*x^4)/(b-4*a*x)^4)^p,x],x,b/(4*a)+1/x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[b^3-4*a*b*c+8*a^2*d] && IntegerQ[2*p]


Int[v_^p_,x_Symbol] :=
  With[{a=Coefficient[v,x,0],b=Coefficient[v,x,1],c=Coefficient[v,x,2],d=Coefficient[v,x,3],e=Coefficient[v,x,4]},
  -16*a^2*Subst[
    Int[1/(b-4*a*x)^2*(a*(-3*b^4+16*a*b^2*c-64*a^2*b*d+256*a^3*e-32*a^2*(3*b^2-8*a*c)*x^2+256*a^4*x^4)/(b-4*a*x)^4)^p,x],x,b/(4*a)+1/x] /;
 NeQ[a] && NeQ[b] && EqQ[b^3-4*a*b*c+8*a^2*d]] /;
FreeQ[p,x] && PolynomialQ[v,x] && Exponent[v,x]==4 && IntegerQ[2*p]


Int[(A_.+B_.*x_+C_.*x_^2+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Sqrt[8*a^2+b^2-4*a*c]},
  1/q*Int[(b*A-2*a*B+2*a*D+A*q+(2*a*A-2*a*C+b*D+D*q)*x)/(2*a+(b+q)*x+2*a*x^2),x] -
  1/q*Int[(b*A-2*a*B+2*a*D-A*q+(2*a*A-2*a*C+b*D-D*q)*x)/(2*a+(b-q)*x+2*a*x^2),x]] /;
FreeQ[{a,b,c,A,B,C,D},x] && EqQ[d-b] && EqQ[e-a] && SumQ[Factor[a+b*x+c*x^2+b*x^3+a*x^4]]


Int[(A_.+B_.*x_+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Sqrt[8*a^2+b^2-4*a*c]},
  1/q*Int[(b*A-2*a*B+2*a*D+A*q+(2*a*A+b*D+D*q)*x)/(2*a+(b+q)*x+2*a*x^2),x] -
  1/q*Int[(b*A-2*a*B+2*a*D-A*q+(2*a*A+b*D-D*q)*x)/(2*a+(b-q)*x+2*a*x^2),x]] /;
FreeQ[{a,b,c,A,B,D},x] && EqQ[d-b] && EqQ[e-a] && SumQ[Factor[a+b*x+c*x^2+b*x^3+a*x^4]]


Int[x_^m_.*(A_.+B_.*x_+C_.*x_^2+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Sqrt[8*a^2+b^2-4*a*c]},
  1/q*Int[x^m*(b*A-2*a*B+2*a*D+A*q+(2*a*A-2*a*C+b*D+D*q)*x)/(2*a+(b+q)*x+2*a*x^2),x] -
  1/q*Int[x^m*(b*A-2*a*B+2*a*D-A*q+(2*a*A-2*a*C+b*D-D*q)*x)/(2*a+(b-q)*x+2*a*x^2),x]] /;
FreeQ[{a,b,c,A,B,C,D,m},x] && EqQ[d-b] && EqQ[e-a] && SumQ[Factor[a+b*x+c*x^2+b*x^3+a*x^4]]


Int[x_^m_.*(A_.+B_.*x_+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Sqrt[8*a^2+b^2-4*a*c]},
  1/q*Int[x^m*(b*A-2*a*B+2*a*D+A*q+(2*a*A+b*D+D*q)*x)/(2*a+(b+q)*x+2*a*x^2),x] -
  1/q*Int[x^m*(b*A-2*a*B+2*a*D-A*q+(2*a*A+b*D-D*q)*x)/(2*a+(b-q)*x+2*a*x^2),x]] /;
FreeQ[{a,b,c,A,B,D,m},x] && EqQ[d-b] && EqQ[e-a] && SumQ[Factor[a+b*x+c*x^2+b*x^3+a*x^4]]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Rt[C*(2*e*(B*d-4*A*e)+C*(d^2-4*c*e)),2]},
  -2*C^2/q*ArcTanh[(C*d-B*e+2*C*e*x)/q] + 
  2*C^2/q*ArcTanh[C*(4*B*c*C-3*B^2*d-4*A*C*d+12*A*B*e+4*C*(2*c*C-B*d+2*A*e)*x+4*C*(2*C*d-B*e)*x^2+8*C^2*e*x^3)/(q*(B^2-4*A*C))]] /;
FreeQ[{a,b,c,d,e,A,B,C},x] && EqQ[B^2*d+2*C*(b*C+A*d)-2*B*(c*C+2*A*e)] && 
  EqQ[2*B^2*c*C-8*a*C^3-B^3*d-4*A*B*C*d+4*A*(B^2+2*A*C)*e] && PosQ[C*(2*e*(B*d-4*A*e)+C*(d^2-4*c*e))]


Int[(A_.+C_.*x_^2)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Rt[C*(-8*A*e^2+C*(d^2-4*c*e)),2]},
  -2*C^2/q*ArcTanh[C*(d+2*e*x)/q] + 2*C^2/q*ArcTanh[C*(A*d-2*(c*C+A*e)*x-2*C*d*x^2-2*C*e*x^3)/(A*q)]] /;
FreeQ[{a,b,c,d,e,A,C},x] && EqQ[b*C+A*d] && EqQ[a*C^2-A^2*e] && PosQ[C*(-8*A*e^2+C*(d^2-4*c*e))]


Int[(A_.+B_.*x_+C_.*x_^2)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Rt[-C*(2*e*(B*d-4*A*e)+C*(d^2-4*c*e)),2]},
  2*C^2/q*ArcTan[(C*d-B*e+2*C*e*x)/q] - 
  2*C^2/q*ArcTan[C*(4*B*c*C-3*B^2*d-4*A*C*d+12*A*B*e+4*C*(2*c*C-B*d+2*A*e)*x+4*C*(2*C*d-B*e)*x^2+8*C^2*e*x^3)/(q*(B^2-4*A*C))]] /;
FreeQ[{a,b,c,d,e,A,B,C},x] && EqQ[B^2*d+2*C*(b*C+A*d)-2*B*(c*C+2*A*e)] && 
  EqQ[2*B^2*c*C-8*a*C^3-B^3*d-4*A*B*C*d+4*A*(B^2+2*A*C)*e] && NegQ[C*(2*e*(B*d-4*A*e)+C*(d^2-4*c*e))]


Int[(A_.+C_.*x_^2)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  With[{q=Rt[-C*(-8*A*e^2+C*(d^2-4*c*e)),2]},
  2*C^2/q*ArcTan[(C*d+2*C*e*x)/q] - 2*C^2/q*ArcTan[-C*(-A*d+2*(c*C+A*e)*x+2*C*d*x^2+2*C*e*x^3)/(A*q)]] /;
FreeQ[{a,b,c,d,e,A,C},x] && EqQ[b*C+A*d] && EqQ[a*C^2-A^2*e] && NegQ[C*(-8*A*e^2+C*(d^2-4*c*e))]


Int[(A_.+B_.*x_+C_.*x_^2+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  D/(4*e)*Log[a+b*x+c*x^2+d*x^3+e*x^4] - 
  1/(4*e)*Int[(b*D-4*A*e+2*(c*D-2*B*e)*x+(3*d*D-4*C*e)*x^2)/(a+b*x+c*x^2+d*x^3+e*x^4),x] /;
FreeQ[{a,b,c,d,e,A,B,C,D},x] && 
  EqQ[4*d*(c*D-2*B*e)^2+8*(3*d*D-4*C*e)*(b*d*D-b*C*e-A*d*e)-4*(c*D-2*B*e)*(3*c*d*D-4*c*C*e+2*b*D*e-8*A*e^2)] && 
  EqQ[8*d*(c*D-2*B*e)^3+8*d*(b*D-4*A*e)*(c*D-2*B*e)*(3*d*D-4*C*e)+8*a*(3*d*D-4*C*e)^3-8*c*(c*D-2*B*e)^2*(3*d*D-4*C*e)-
    4*e*(b*D-4*A*e)*(4*(c*D-2*B*e)^2+2*(b*D-4*A*e)*(3*d*D-4*C*e))]


Int[(A_.+B_.*x_+D_.*x_^3)/(a_+b_.*x_+c_.*x_^2+d_.*x_^3+e_.*x_^4),x_Symbol] :=
  D/(4*e)*Log[a+b*x+c*x^2+d*x^3+e*x^4] - 
  1/(4*e)*Int[(b*D-4*A*e+2*(c*D-2*B*e)*x+(3*d*D)*x^2)/(a+b*x+c*x^2+d*x^3+e*x^4),x] /;
FreeQ[{a,b,c,d,e,A,B,D},x] && 
  EqQ[c^2*d*D^2+2*(3*d*D-4*C*e)*(b*d*D-b*C*e-A*d*e)-c*D*(3*c*d*D-4*c*C*e+2*b*D*e-8*A*e^2)] && 
  EqQ[54*a*d^3*D^3+6*d^2*D*(b*D-4*A*e)*(c*D-2*B*e)-6*c*d*D*(c*D-2*B*e)^2+2*d*(c*D-2*B*e)^3-
    e*(b*D-4*A*e)*(6*d*D*(b*D-4*A*e)+4*(c*D-2*B*e)^2)]





(* ::Subsection::Closed:: *)
(*1.3.3 Miscellaneous algebraic functions*)


Int[u_/(e_.*Sqrt[a_.+b_.*x_]+f_.*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  c/(e*(b*c-a*d))*Int[(u*Sqrt[a+b*x])/x,x] - a/(f*(b*c-a*d))*Int[(u*Sqrt[c+d*x])/x,x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a*e^2-c*f^2]


Int[u_/(e_.*Sqrt[a_.+b_.*x_]+f_.*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  -d/(e*(b*c-a*d))*Int[u*Sqrt[a+b*x],x] + b/(f*(b*c-a*d))*Int[u*Sqrt[c+d*x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[b*e^2-d*f^2]


Int[u_/(e_.*Sqrt[a_.+b_.*x_]+f_.*Sqrt[c_.+d_.*x_]),x_Symbol] :=
  e*Int[(u*Sqrt[a+b*x])/(a*e^2-c*f^2+(b*e^2-d*f^2)*x),x] - 
  f*Int[(u*Sqrt[c+d*x])/(a*e^2-c*f^2+(b*e^2-d*f^2)*x),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[a*e^2-c*f^2] && NeQ[b*e^2-d*f^2]


Int[u_./(d_.*x_^n_.+c_.*Sqrt[a_.+b_.*x_^p_.]),x_Symbol] :=
  -b/(a*d)*Int[u*x^n,x] + 1/(a*c)*Int[u*Sqrt[a+b*x^(2*n)],x] /;
FreeQ[{a,b,c,d,n},x] && EqQ[p-2*n] && EqQ[b*c^2-d^2]


Int[x_^m_./(d_.*x_^n_.+c_.*Sqrt[a_.+b_.*x_^p_.]),x_Symbol] :=
  -d*Int[x^(m+n)/(a*c^2+(b*c^2-d^2)*x^(2*n)),x] + 
  c*Int[(x^m*Sqrt[a+b*x^(2*n)])/(a*c^2+(b*c^2-d^2)*x^(2*n)),x] /;
FreeQ[{a,b,c,d,m,n},x] && EqQ[p-2*n] && NeQ[b*c^2-d^2]


Int[1/((a_+b_.*x_^3)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,3]], s=Denominator[Rt[a/b,3]]},
  r/(3*a)*Int[1/((r+s*x)*Sqrt[d+e*x+f*x^2]),x] +
  r/(3*a)*Int[(2*r-s*x)/((r^2-r*s*x+s^2*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,d,e,f},x] && PosQ[a/b]


Int[1/((a_+b_.*x_^3)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  With[{r=Numerator[Rt[a/b,3]], s=Denominator[Rt[a/b,3]]},
  r/(3*a)*Int[1/((r+s*x)*Sqrt[d+f*x^2]),x] +
  r/(3*a)*Int[(2*r-s*x)/((r^2-r*s*x+s^2*x^2)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,d,f},x] && PosQ[a/b]


Int[1/((a_+b_.*x_^3)*Sqrt[d_.+e_.*x_+f_.*x_^2]),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,3]], s=Denominator[Rt[-a/b,3]]},
  r/(3*a)*Int[1/((r-s*x)*Sqrt[d+e*x+f*x^2]),x] +
  r/(3*a)*Int[(2*r+s*x)/((r^2+r*s*x+s^2*x^2)*Sqrt[d+e*x+f*x^2]),x]] /;
FreeQ[{a,b,d,e,f},x] && NegQ[a/b]


Int[1/((a_+b_.*x_^3)*Sqrt[d_.+f_.*x_^2]),x_Symbol] :=
  With[{r=Numerator[Rt[-a/b,3]], s=Denominator[Rt[-a/b,3]]},
  r/(3*a)*Int[1/((r-s*x)*Sqrt[d+f*x^2]),x] +
  r/(3*a)*Int[(2*r+s*x)/((r^2+r*s*x+s^2*x^2)*Sqrt[d+f*x^2]),x]] /;
FreeQ[{a,b,d,f},x] && NegQ[a/b]


Int[1/((d_+e_.*x_)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  d*Int[1/((d^2-e^2*x^2)*Sqrt[a+b*x^2+c*x^4]),x] - e*Int[x/((d^2-e^2*x^2)*Sqrt[a+b*x^2+c*x^4]),x] /;
FreeQ[{a,b,c,d,e},x]


Int[1/((d_+e_.*x_)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  d*Int[1/((d^2-e^2*x^2)*Sqrt[a+c*x^4]),x] - e*Int[x/((d^2-e^2*x^2)*Sqrt[a+c*x^4]),x] /;
FreeQ[{a,c,d,e},x]


Int[1/((d_+e_.*x_)^2*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  -e^3*Sqrt[a+b*x^2+c*x^4]/((c*d^4+b*d^2*e^2+a*e^4)*(d+e*x)) - 
  c/(c*d^4+b*d^2*e^2+a*e^4)*Int[(d^2-e^2*x^2)/Sqrt[a+b*x^2+c*x^4],x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[c*d^4+b*d^2*e^2+a*e^4] && EqQ[2*c*d^3+b*d*e^2]


Int[1/((d_+e_.*x_)^2*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  -e^3*Sqrt[a+b*x^2+c*x^4]/((c*d^4+b*d^2*e^2+a*e^4)*(d+e*x)) - 
  c/(c*d^4+b*d^2*e^2+a*e^4)*Int[(d^2-e^2*x^2)/Sqrt[a+b*x^2+c*x^4],x] + 
  (2*c*d^3+b*d*e^2)/(c*d^4+b*d^2*e^2+a*e^4)*Int[1/((d+e*x)*Sqrt[a+b*x^2+c*x^4]),x] /;
FreeQ[{a,b,c,d,e},x] && NeQ[c*d^4+b*d^2*e^2+a*e^4] && NeQ[2*c*d^3+b*d*e^2]


Int[1/((d_+e_.*x_)^2*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  -e^3*Sqrt[a+c*x^4]/((c*d^4+a*e^4)*(d+e*x)) - 
  c/(c*d^4+a*e^4)*Int[(d^2-e^2*x^2)/Sqrt[a+c*x^4],x] + 
  2*c*d^3/(c*d^4+a*e^4)*Int[1/((d+e*x)*Sqrt[a+c*x^4]),x] /;
FreeQ[{a,c,d,e},x] && NeQ[c*d^4+a*e^4]


Int[(A_+B_.*x_^2)/((d_+e_.*x_^2)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  A*Subst[Int[1/(d-(b*d-2*a*e)*x^2),x],x,x/Sqrt[a+b*x^2+c*x^4]] /;
FreeQ[{a,b,c,d,e,A,B},x] && EqQ[B*d+A*e] && EqQ[c*d^2-a*e^2]


Int[(A_+B_.*x_^2)/((d_+e_.*x_^2)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  A*Subst[Int[1/(d+2*a*e*x^2),x],x,x/Sqrt[a+c*x^4]] /;
FreeQ[{a,c,d,e,A,B},x] && EqQ[B*d+A*e] && EqQ[c*d^2-a*e^2]


Int[(A_+B_.*x_^4)/((d_+e_.*x_^2+f_.*x_^4)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  A*Subst[Int[1/(d-(b*d-a*e)*x^2),x],x,x/Sqrt[a+b*x^2+c*x^4]] /;
FreeQ[{a,b,c,d,e,f,A,B},x] && EqQ[c*d-a*f] && EqQ[a*B+A*c]


Int[(A_+B_.*x_^4)/((d_+e_.*x_^2+f_.*x_^4)*Sqrt[a_+c_.*x_^4]),x_Symbol] :=
  A*Subst[Int[1/(d+a*e*x^2),x],x,x/Sqrt[a+c*x^4]] /;
FreeQ[{a,c,d,e,f,A,B},x] && EqQ[c*d-a*f] && EqQ[a*B+A*c]


Int[(A_+B_.*x_^4)/((d_+f_.*x_^4)*Sqrt[a_+b_.*x_^2+c_.*x_^4]),x_Symbol] :=
  A*Subst[Int[1/(d-b*d*x^2),x],x,x/Sqrt[a+b*x^2+c*x^4]] /;
FreeQ[{a,b,c,d,f,A,B},x] && EqQ[c*d-a*f] && EqQ[a*B+A*c]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/(d_+e_.*x_^4),x_Symbol] :=
  a/d*Subst[Int[1/(1-2*b*x^2+(b^2-4*a*c)*x^4),x],x,x/Sqrt[a+b*x^2+c*x^4]] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d+a*e] && PosQ[a*c]


Int[Sqrt[a_+b_.*x_^2+c_.*x_^4]/(d_+e_.*x_^4),x_Symbol] :=
  With[{q=Sqrt[b^2-4*a*c]},
  -a*Sqrt[b+q]/(2*Sqrt[2]*Rt[-a*c,2]*d)*ArcTan[Sqrt[b+q]*x*(b-q+2*c*x^2)/(2*Sqrt[2]*Rt[-a*c,2]*Sqrt[a+b*x^2+c*x^4])] + 
  a*Sqrt[-b+q]/(2*Sqrt[2]*Rt[-a*c,2]*d)*ArcTanh[Sqrt[-b+q]*x*(b+q+2*c*x^2)/(2*Sqrt[2]*Rt[-a*c,2]*Sqrt[a+b*x^2+c*x^4])]] /;
FreeQ[{a,b,c,d,e},x] && EqQ[c*d+a*e] && NegQ[a*c]


Int[1/((a_+b_.*x_)*Sqrt[c_+d_.*x_^2]*Sqrt[e_+f_.*x_^2]),x_Symbol] :=
  a*Int[1/((a^2-b^2*x^2)*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] - b*Int[x/((a^2-b^2*x^2)*Sqrt[c+d*x^2]*Sqrt[e+f*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x]


Int[(g_.+h_.*x_)*Sqrt[d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2]],x_Symbol] :=
  2*(f*(5*b*c*g^2-2*b^2*g*h-3*a*c*g*h+2*a*b*h^2)+c*f*(10*c*g^2-b*g*h+a*h^2)*x+9*c^2*f*g*h*x^2+3*c^2*f*h^2*x^3-
    (e*g-d*h)*(5*c*g-2*b*h+c*h*x)*Sqrt[a+b*x+c*x^2])/
  (15*c^2*f*(g+h*x))*Sqrt[d+e*x+f*Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h},x] && EqQ[(e*g-d*h)^2-f^2*(c*g^2-b*g*h+a*h^2)] && EqQ[2*e^2*g-2*d*e*h-f^2*(2*c*g-b*h)]


Int[(g_.+h_.*x_)^m_.*(u_+f_.*(j_.+k_.*Sqrt[v_]))^n_.,x_Symbol] :=
  Int[(g+h*x)^m*(ExpandToSum[u+f*j,x]+f*k*Sqrt[ExpandToSum[v,x]])^n,x] /;
FreeQ[{f,g,h,j,k,m,n},x] && LinearQ[u,x] && QuadraticQ[v,x] && 
  Not[LinearMatchQ[u,x] && QuadraticMatchQ[v,x] && (EqQ[j] || EqQ[f-1])] && 
  EqQ[(Coefficient[u,x,1]*g-h*(Coefficient[u,x,0]+f*j))^2-f^2*k^2*(Coefficient[v,x,2]*g^2-Coefficient[v,x,1]*g*h+Coefficient[v,x,0]*h^2)]


(* Int[1/(d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2]),x_Symbol] :=
  Int[(d+e*x)/(d^2-a*f^2+(2*d*e-b*f^2)*x),x] - 
  f*Int[Sqrt[a+b*x+c*x^2]/(d^2-a*f^2+(2*d*e-b*f^2)*x),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[e^2-c*f^2] *)


(* Int[1/(d_.+e_.*x_+f_.*Sqrt[a_.+c_.*x_^2]),x_Symbol] :=
  Int[(d+e*x)/(d^2-a*f^2+2*d*e*x),x] - 
  f*Int[Sqrt[a+c*x^2]/(d^2-a*f^2+2*d*e*x),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[e^2-c*f^2] *)


Int[(g_.+h_.*(d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2])^n_)^p_.,x_Symbol] :=
  2*Subst[Int[(g+h*x^n)^p*(d^2*e-(b*d-a*e)*f^2-(2*d*e-b*f^2)*x+e*x^2)/(-2*d*e+b*f^2+2*e*x)^2,x],x,d+e*x+f*Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h,n},x] && EqQ[e^2-c*f^2] && IntegerQ[p]


Int[(g_.+h_.*(d_.+e_.*x_+f_.*Sqrt[a_+c_.*x_^2])^n_)^p_.,x_Symbol] :=
  1/(2*e)*Subst[Int[(g+h*x^n)^p*(d^2+a*f^2-2*d*x+x^2)/(d-x)^2,x],x,d+e*x+f*Sqrt[a+c*x^2]] /;
FreeQ[{a,c,d,e,f,g,h,n},x] && EqQ[e^2-c*f^2] && IntegerQ[p]


Int[(g_.+h_.*(u_+f_. Sqrt[v_])^n_)^p_.,x_Symbol] :=
  Int[(g+h*(ExpandToSum[u,x]+f*Sqrt[ExpandToSum[v,x]])^n)^p,x] /;
FreeQ[{f,g,h,n},x] && LinearQ[u,x] && QuadraticQ[v,x] && Not[LinearMatchQ[u,x] && QuadraticMatchQ[v,x]] && 
  EqQ[Coefficient[u,x,1]^2-Coefficient[v,x,2]*f^2] && IntegerQ[p]


Int[(g_.+h_.*x_)^m_.*(e_.*x_+f_.*Sqrt[a_.+c_.*x_^2])^n_.,x_Symbol] :=
  1/(2^(m+1)*e^(m+1))*Subst[Int[x^(n-m-2)*(a*f^2+x^2)*(-a*f^2*h+2*e*g*x+h*x^2)^m,x],x,e*x+f*Sqrt[a+c*x^2]] /;
FreeQ[{a,c,e,f,g,h,n},x] && EqQ[e^2-c*f^2] && IntegerQ[m]


Int[x_^p_.*(g_+i_.*x_^2)^m_.*(e_.*x_+f_.*Sqrt[a_+c_.*x_^2])^n_.,x_Symbol] :=
  1/(2^(2*m+p+1)*e^(p+1)*f^(2*m))*(i/c)^m*Subst[Int[x^(n-2*m-p-2)*(-a*f^2+x^2)^p*(a*f^2+x^2)^(2*m+1),x],x,e*x+f*Sqrt[a+c*x^2]] /;
FreeQ[{a,c,e,f,g,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && IntegersQ[p,2*m] && (IntegerQ[m] || PositiveQ[i/c])


Int[(g_.+h_.*x_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2])^n_.,x_Symbol] :=
  2/f^(2*m)*(i/c)^m*
    Subst[Int[x^n*(d^2*e-(b*d-a*e)*f^2-(2*d*e-b*f^2)*x+e*x^2)^(2*m+1)/(-2*d*e+b*f^2+2*e*x)^(2*(m+1)),x],x,d+e*x+f*Sqrt[a+b*x+c*x^2]] /;
FreeQ[{a,b,c,d,e,f,g,h,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && EqQ[c*h-b*i] && IntegerQ[2*m] && (IntegerQ[m] || PositiveQ[i/c])


Int[(g_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_+c_.*x_^2])^n_.,x_Symbol] :=
  1/(2^(2*m+1)*e*f^(2*m))*(i/c)^m*
    Subst[Int[x^n*(d^2+a*f^2-2*d*x+x^2)^(2*m+1)/(-d+x)^(2*(m+1)),x],x,d+e*x+f*Sqrt[a+c*x^2]] /;
FreeQ[{a,c,d,e,f,g,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && IntegerQ[2*m] && (IntegerQ[m] || PositiveQ[i/c])


Int[(g_.+h_.*x_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2])^n_.,x_Symbol] :=
  (i/c)^(m-1/2)*Sqrt[g+h*x+i*x^2]/Sqrt[a+b*x+c*x^2]*Int[(a+b*x+c*x^2)^m*(d+e*x+f*Sqrt[a+b*x+c*x^2])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && EqQ[c*h-b*i] && PositiveIntegerQ[m+1/2] && Not[PositiveQ[i/c]]


Int[(g_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_+c_.*x_^2])^n_.,x_Symbol] :=
  (i/c)^(m-1/2)*Sqrt[g+i*x^2]/Sqrt[a+c*x^2]*Int[(a+c*x^2)^m*(d+e*x+f*Sqrt[a+c*x^2])^n,x] /;
FreeQ[{a,c,d,e,f,g,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && PositiveIntegerQ[m+1/2] && Not[PositiveQ[i/c]]


Int[(g_.+h_.*x_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2])^n_.,x_Symbol] :=
  (i/c)^(m+1/2)*Sqrt[a+b*x+c*x^2]/Sqrt[g+h*x+i*x^2]*Int[(a+b*x+c*x^2)^m*(d+e*x+f*Sqrt[a+b*x+c*x^2])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && EqQ[c*h-b*i] && NegativeIntegerQ[m-1/2] && Not[PositiveQ[i/c]]


Int[(g_+i_.*x_^2)^m_.*(d_.+e_.*x_+f_.*Sqrt[a_+c_.*x_^2])^n_.,x_Symbol] :=
  (i/c)^(m+1/2)*Sqrt[a+c*x^2]/Sqrt[g+i*x^2]*Int[(a+c*x^2)^m*(d+e*x+f*Sqrt[a+c*x^2])^n,x] /;
FreeQ[{a,c,d,e,f,g,i,n},x] && EqQ[e^2-c*f^2] && EqQ[c*g-a*i] && NegativeIntegerQ[m-1/2] && Not[PositiveQ[i/c]]


Int[w_^m_.*(u_+f_.*(j_.+k_.*Sqrt[v_]))^n_.,x_Symbol] :=
  Int[ExpandToSum[w,x]^m*(ExpandToSum[u+f*j,x]+f*k*Sqrt[ExpandToSum[v,x]])^n,x] /;
FreeQ[{f,j,k,m,n},x] && LinearQ[u,x] && QuadraticQ[{v,w},x] && 
  Not[LinearMatchQ[u,x] && QuadraticMatchQ[{v,w},x] && (EqQ[j] || EqQ[f-1])] && 
  EqQ[Coefficient[u,x,1]^2-Coefficient[v,x,2]*f^2*k^2]


Int[1/((a_+b_.*x_^n_.)*Sqrt[c_.*x_^2+d_.*(a_+b_.*x_^n_.)^p_.]),x_Symbol] :=
  1/a*Subst[Int[1/(1-c*x^2),x],x,x/Sqrt[c*x^2+d*(a+b*x^n)^(2/n)]] /;
FreeQ[{a,b,c,d,n},x] && EqQ[p-2/n]


Int[Sqrt[a_+b_.*Sqrt[c_+d_.*x_^2]],x_Symbol] :=
  2*b^2*d*x^3/(3*(a+b*Sqrt[c+d*x^2])^(3/2)) + 2*a*x/Sqrt[a+b*Sqrt[c+d*x^2]] /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2*c]


Int[Sqrt[a_.*x_^2+b_.*x_*Sqrt[c_+d_.*x_^2]]/(x_*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  Sqrt[2]*b/a*Subst[Int[1/Sqrt[1+x^2/a],x],x,a*x+b*Sqrt[c+d*x^2]] /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2*d] && EqQ[b^2*c+a]


Int[Sqrt[e_.*x_*(a_.*x_+b_.*Sqrt[c_+d_.*x_^2])]/(x_*Sqrt[c_+d_.*x_^2]),x_Symbol] :=
  Int[Sqrt[a*e*x^2+b*e*x*Sqrt[c+d*x^2]]/(x*Sqrt[c+d*x^2]),x] /;
FreeQ[{a,b,c,d,e},x] && EqQ[a^2-b^2*d] && EqQ[b^2*c*e+a]


Int[Sqrt[c_.*x_^2+d_.*Sqrt[a_+b_.*x_^4]]/Sqrt[a_+b_.*x_^4],x_Symbol] :=
  d*Subst[Int[1/(1-2*c*x^2),x],x,x/Sqrt[c*x^2+d*Sqrt[a+b*x^4]]] /;
FreeQ[{a,b,c,d},x] && EqQ[c^2-b*d^2]


Int[(c_.+d_.*x_)^m_.*Sqrt[b_.*x_^2+Sqrt[a_+e_.*x_^4]]/Sqrt[a_+e_.*x_^4],x_Symbol] :=
  (1-I)/2*Int[(c+d*x)^m/Sqrt[Sqrt[a]-I*b*x^2],x] +
  (1+I)/2*Int[(c+d*x)^m/Sqrt[Sqrt[a]+I*b*x^2],x] /;
FreeQ[{a,b,c,d,m},x] && EqQ[e-b^2] && PositiveQ[a]


Int[1/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -q/((1+Sqrt[3])*d-c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  d/((1+Sqrt[3])*d-c*q)*Int[(1+Sqrt[3]+q*x)/((c+d*x)*Sqrt[a+b*x^3]),x]] /;
FreeQ[{a,b,c,d},x] && PosQ[a] && PosQ[b]


Int[1/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  q/((1+Sqrt[3])*d+c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  d/((1+Sqrt[3])*d+c*q)*Int[(1+Sqrt[3]-q*x)/((c+d*x)*Sqrt[a+b*x^3]),x]] /;
FreeQ[{a,b,c,d},x] && PosQ[a] && NegQ[b]


Int[1/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  q/((1-Sqrt[3])*d+c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  d/((1-Sqrt[3])*d+c*q)*Int[(1-Sqrt[3]-q*x)/((c+d*x)*Sqrt[a+b*x^3]),x]] /;
FreeQ[{a,b,c,d},x] && NegQ[a] && PosQ[b]


Int[1/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -q/((1-Sqrt[3])*d-c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  d/((1-Sqrt[3])*d-c*q)*Int[(1-Sqrt[3]+q*x)/((c+d*x)*Sqrt[a+b*x^3]),x]] /;
FreeQ[{a,b,c,d},x] && NegQ[a] && NegQ[b]


Int[(e_+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  4*3^(1/4)*Sqrt[2-Sqrt[3]]*f*(1+q*x)*Sqrt[(1-q*x+q^2*x^2)/(1+Sqrt[3]+q*x)^2]/
    (q*Sqrt[a+b*x^3]*Sqrt[(1+q*x)/(1+Sqrt[3]+q*x)^2])*
    Subst[Int[1/(((1-Sqrt[3])*d-c*q+((1+Sqrt[3])*d-c*q)*x)*Sqrt[1-x^2]*Sqrt[7-4*Sqrt[3]+x^2]),x],x,(-1+Sqrt[3]-q*x)/(1+Sqrt[3]+q*x)] /;
 EqQ[(1+Sqrt[3])*f-e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[a] && PosQ[b]


Int[(e_.+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  ((1+Sqrt[3])*f-e*q)/((1+Sqrt[3])*d-c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  (d*e-c*f)/((1+Sqrt[3])*d-c*q)*Int[(1+Sqrt[3]+q*x)/((c+d*x)*Sqrt[a+b*x^3]),x] /;
 NeQ[(1+Sqrt[3])*f-e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[a] && PosQ[b]


Int[(e_+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  -4*3^(1/4)*Sqrt[2-Sqrt[3]]*f*(1-q*x)*Sqrt[(1+q*x+q^2*x^2)/(1+Sqrt[3]-q*x)^2]/
    (q*Sqrt[a+b*x^3]*Sqrt[(1-q*x)/(1+Sqrt[3]-q*x)^2])*
    Subst[Int[1/(((1-Sqrt[3])*d+c*q+((1+Sqrt[3])*d+c*q)*x)*Sqrt[1-x^2]*Sqrt[7-4*Sqrt[3]+x^2]),x],x,(-1+Sqrt[3]+q*x)/(1+Sqrt[3]-q*x)] /;
 EqQ[(1+Sqrt[3])*f+e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[a] && NegQ[b]


Int[(e_.+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  ((1+Sqrt[3])*f+e*q)/((1+Sqrt[3])*d+c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  (d*e-c*f)/((1+Sqrt[3])*d+c*q)*Int[(1+Sqrt[3]-q*x)/((c+d*x)*Sqrt[a+b*x^3]),x] /;
 NeQ[(1+Sqrt[3])*f+e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && PosQ[a] && NegQ[b]


Int[(e_+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  4*3^(1/4)*Sqrt[2+Sqrt[3]]*f*(1-q*x)*Sqrt[(1+q*x+q^2*x^2)/(1-Sqrt[3]-q*x)^2]/
    (q*Sqrt[a+b*x^3]*Sqrt[-(1-q*x)/(1-Sqrt[3]-q*x)^2])*
  Subst[Int[1/(((1+Sqrt[3])*d+c*q+((1-Sqrt[3])*d+c*q)*x)*Sqrt[1-x^2]*Sqrt[7+4*Sqrt[3]+x^2]),x],x,(1+Sqrt[3]-q*x)/(-1+Sqrt[3]+q*x)] /;
 EqQ[(1-Sqrt[3])*f+e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[a] && PosQ[b]


Int[(e_.+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[-b/a,3]},
  ((1-Sqrt[3])*f+e*q)/((1-Sqrt[3])*d+c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  (d*e-c*f)/((1-Sqrt[3])*d+c*q)*Int[(1-Sqrt[3]-q*x)/((c+d*x)*Sqrt[a+b*x^3]),x] /;
 NeQ[(1-Sqrt[3])*f+e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[a] && PosQ[b]


Int[(e_+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  -4*3^(1/4)*Sqrt[2+Sqrt[3]]*f*(1+q*x)*Sqrt[(1-q*x+q^2*x^2)/(1-Sqrt[3]+q*x)^2]/
   (q*Sqrt[a +b*x^3]*Sqrt[-(1+q*x)/(1-Sqrt[3]+q*x)^2])*
   Subst[Int[1/(((1+Sqrt[3])*d-c*q+((1-Sqrt[3])*d-c*q)*x)*Sqrt[1-x^2]*Sqrt[7+4*Sqrt[3]+x^2]),x],x,(1+Sqrt[3]+q*x)/(-1+Sqrt[3]-q*x)] /;
 EqQ[(1-Sqrt[3])*f-e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[a] && NegQ[b]


Int[(e_.+f_.*x_)/((c_+d_.*x_)*Sqrt[a_+b_.*x_^3]),x_Symbol] :=
  With[{q=Rt[b/a,3]},
  ((1-Sqrt[3])*f-e*q)/((1-Sqrt[3])*d-c*q)*Int[1/Sqrt[a+b*x^3],x] + 
  (d*e-c*f)/((1-Sqrt[3])*d-c*q)*Int[(1-Sqrt[3]+q*x)/((c+d*x)*Sqrt[a+b*x^3]),x] /;
 NeQ[(1-Sqrt[3])*f-e*q]] /;
FreeQ[{a,b,c,d,e,f},x] && NegQ[a] && NegQ[b]


Int[x_^m_./(c_+d_.*x_^n_+e_.*Sqrt[a_+b_.*x_^n_]),x_Symbol] :=
  1/n*Subst[Int[x^((m+1)/n-1)/(c+d*x+e*Sqrt[a+b*x]),x],x,x^n] /;
FreeQ[{a,b,c,d,e,m,n},x] && EqQ[b*c-a*d,0] && IntegerQ[(m+1)/n]


Int[u_./(c_+d_.*x_^n_+e_.*Sqrt[a_+b_.*x_^n_]),x_Symbol] :=
  c*Int[u/(c^2-a*e^2+c*d*x^n),x] - a*e*Int[u/((c^2-a*e^2+c*d*x^n)*Sqrt[a+b*x^n]),x] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[b*c-a*d,0]


Int[(A_+B_.*x_^n_)/(a_+b_.*x_^2+c_.*x_^n_+d_.*x_^n2_), x_Symbol] :=
  A^2*(n-1)*Subst[Int[1/(a+A^2*b*(n-1)^2*x^2),x],x,x/(A*(n-1)-B*x^n)] /;
FreeQ[{a,b,c,d,A,B,n},x] && EqQ[n2-2*n] && NeQ[n-2] && EqQ[a*B^2-A^2*d*(n-1)^2] && EqQ[B*c+2*A*d*(n-1)]


Int[x_^m_.*(A_+B_.*x_^n_.)/(a_+b_.*x_^k_.+c_.*x_^n_.+d_.*x_^n2_), x_Symbol] :=
  A^2*(m-n+1)/(m+1)*Subst[Int[1/(a+A^2*b*(m-n+1)^2*x^2),x],x,x^(m+1)/(A*(m-n+1)+B*(m+1)*x^n)] /;
FreeQ[{a,b,c,d,A,B,m,n},x] && EqQ[n2-2*n] && EqQ[k-2*(m+1)] && EqQ[a*B^2*(m+1)^2-A^2*d*(m-n+1)^2] && EqQ[B*c*(m+1)-2*A*d*(m-n+1)]


Int[(d_+e_.*x_^n_+f_.*x_^n2_+g_*x_^n3_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*c*d-2*a*c*(c*d-a*f)-a*b*(c*e+a*g)+(b*c*(c*d+a*f)-a*b^2*g-2*a*c*(c*e-a*g))*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(b^2-4*a*c)) - 
  1/(a*c*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[a*b*(c*e+a*g)-b^2*c*d*(n+n*p+1)-2*a*c*(a*f-c*d*(2*n*(p+1)+1))+
      (a*b^2*g*(n*(p+2)+1)-b*c*(c*d+a*f)*(n*(2*p+3)+1)-2*a*c*(a*g*(n+1)-c*e*(n*(2*p+3)+1)))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+e_.*x_^n_+f_.*x_^n2_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*d-2*a*(c*d-a*f)-a*b*e+(b*(c*d+a*f)-2*a*c*e)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c)) - 
  1/(a*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[a*b*e-b^2*d*(n+n*p+1)-2*a*(a*f-c*d*(2*n*(p+1)+1))-
      (b*(c*d+a*f)*(n*(2*p+3)+1)-2*a*c*e*(n*(2*p+3)+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+e_.*x_^n_+g_*x_^n3_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*c*d-2*a*c^2*d-a*b*(c*e+a*g)+(b*c^2*d-a*b^2*g-2*a*c*(c*e-a*g))*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(b^2-4*a*c)) - 
  1/(a*c*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[a*b*(c*e+a*g)-b^2*c*d*(n+n*p+1)+2*a*c^2*d*(2*n*(p+1)+1)+
      (a*b^2*g*(n*(p+2)+1)-b*c^2*d*(n*(2*p+3)+1)-2*a*c*(a*g*(n+1)-c*e*(n*(2*p+3)+1)))*x^n,x],x] /;
FreeQ[{a,b,c,d,e,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+f_.*x_^n2_+g_*x_^n3_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*c*d-2*a*c*(c*d-a*f)-a^2*b*g+(b*c*(c*d+a*f)-a*b^2*g+2*a^2*c*g)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(b^2-4*a*c)) - 
  1/(a*c*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[a^2*b*g-b^2*c*d*(n+n*p+1)-2*a*c*(a*f-c*d*(2*n*(p+1)+1))+
      (a*b^2*g*(n*(p+2)+1)-b*c*(c*d+a*f)*(n*(2*p+3)+1)-2*a^2*c*g*(n+1))*x^n,x],x] /;
FreeQ[{a,b,c,d,f,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+f_.*x_^n2_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*d-2*a*(c*d-a*f)+b*(c*d+a*f)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/(a*n*(p+1)*(b^2-4*a*c)) + 
  1/(a*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[b^2*d*(n+n*p+1)+2*a*(a*f-c*d*(2*n*(p+1)+1))+b*(c*d+a*f)*(n*(2*p+3)+1)*x^n,x],x] /;
FreeQ[{a,b,c,d,f,n},x] && EqQ[n2-2*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+g_*x_^n3_)*(a_+b_.*x_^n_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(b^2*c*d-2*a*c^2*d-a^2*b*g+(b*c^2*d-a*b^2*g+2*a^2*c*g)*x^n)*(a+b*x^n+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(b^2-4*a*c)) - 
  1/(a*c*n*(p+1)*(b^2-4*a*c))*Int[(a+b*x^n+c*x^(2*n))^(p+1)*
    Simp[a^2*b*g-b^2*c*d*(n+n*p+1)+2*a*c^2*d*(2*n*(p+1)+1)+
      (a*b^2*g*(n*(p+2)+1)-b*c^2*d*(n*(2*p+3)+1)-2*a*c*(a*g*(n+1)))*x^n,x],x] /;
FreeQ[{a,b,c,d,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NeQ[b^2-4*a*c] && NegativeIntegerQ[p+1]


Int[(d_+e_.*x_^n_+f_.*x_^n2_+g_*x_^n3_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(-2*a*c*(c*d-a*f)+(-2*a*c*(c*e-a*g))*x^n)*(a+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(-4*a*c)) - 
  1/(a*c*n*(p+1)*(-4*a*c))*Int[(a+c*x^(2*n))^(p+1)*
    Simp[-2*a*c*(a*f-c*d*(2*n*(p+1)+1))+
      (-2*a*c*(a*g*(n+1)-c*e*(n*(2*p+3)+1)))*x^n,x],x] /;
FreeQ[{a,c,d,e,f,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NegativeIntegerQ[p+1]


Int[(d_+e_.*x_^n_+f_.*x_^n2_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(-2*a*(c*d-a*f)+(-2*a*c*e)*x^n)*(a+c*x^(2*n))^(p+1)/(a*n*(p+1)*(-4*a*c)) - 
  1/(a*n*(p+1)*(-4*a*c))*Int[(a+c*x^(2*n))^(p+1)*
    Simp[-2*a*(a*f-c*d*(2*n*(p+1)+1))-
      (-2*a*c*e*(n*(2*p+3)+1))*x^n,x],x] /;
FreeQ[{a,c,d,e,f,n},x] && EqQ[n2-2*n] && NegativeIntegerQ[p+1]


Int[(d_+e_.*x_^n_+g_*x_^n3_)*(a_+c_.*x_^n2_)^p_,x_Symbol] :=
  -x*(-2*a*c^2*d+(-2*a*c*(c*e-a*g))*x^n)*(a+c*x^(2*n))^(p+1)/
    (a*c*n*(p+1)*(-4*a*c)) - 
  1/(a*c*n*(p+1)*(-4*a*c))*Int[(a+c*x^(2*n))^(p+1)*
    Simp[2*a*c^2*d*(2*n*(p+1)+1)+
      (-2*a*c*(a*g*(n+1)-c*e*(n*(2*p+3)+1)))*x^n,x],x] /;
FreeQ[{a,c,d,e,g,n},x] && EqQ[n2-2*n] && EqQ[n3-3*n] && NegativeIntegerQ[p+1]


Int[(a_.+b_.*x_^2+c_.*x_^4)/(d_+e_.*x_^2+f_.*x_^4+g_.*x_^6),x_Symbol] :=
  With[{q=Rt[(-a*c*f^2+12*a^2*g^2+f*(3*c^2*d-2*a*b*g))/(c*g*(3*c*d-a*f)),2],
        r=Rt[(a*c*f^2+4*g*(b*c*d+a^2*g)-f*(3*c^2*d+2*a*b*g))/(c*g*(3*c*d-a*f)),2]},
  c/(g*q)*ArcTan[(r+2*x)/q] - 
  c/(g*q)*ArcTan[(r-2*x)/q] - 
  c/(g*q)*ArcTan[(3*c*d-a*f)*x/(g*q*(b*c*d-2*a^2*g)*(b*c*d-a*b*f+4*a^2*g))*
    (b*c^2*d*f-a*b^2*f*g-2*a^2*c*f*g+6*a^2*b*g^2+c*(3*c^2*d*f-a*c*f^2-b*c*d*g+2*a^2*g^2)*x^2+c^2*g*(3*c*d-a*f)*x^4)]] /;
FreeQ[{a,b,c,d,e,f,g},x] && EqQ[9*c^3*d^2-c*(b^2+6*a*c)*d*f+a^2*c*f^2+2*a*b*(3*c*d+a*f)*g-12*a^3*g^2] && 
  EqQ[3*c^4*d^2*e-3*a^2*c^2*d*f*g+a^3*c*f^2*g+2*a^3*g^2*(b*f-6*a*g)-c^3*d*(2*b*d*f+a*e*f-12*a*d*g)] && 
  NeQ[3*c*d-a*f] && NeQ[b*c*d-2*a^2*g] && NeQ[b*c*d-a*b*f+4*a^2*g] && 
  PosQ[(-a*c*f^2+12*a^2*g^2+f*(3*c^2*d-2*a*b*g))/(c*g*(3*c*d-a*f))]


Int[(a_.+c_.*x_^4)/(d_+e_.*x_^2+f_.*x_^4+g_.*x_^6),x_Symbol] :=
  With[{q=Rt[(-a*c*f^2+12*a^2*g^2+3*f*c^2*d)/(c*g*(3*c*d-a*f)),2],
        r=Rt[(a*c*f^2+4*a^2*g^2-3*c^2*d*f)/(c*g*(3*c*d-a*f)),2]},
  c/(g*q)*ArcTan[(r+2*x)/q] - 
  c/(g*q)*ArcTan[(r-2*x)/q] - 
  c/(g*q)*ArcTan[(c*(3*c*d-a*f)*x*(2*a^2*f*g-(3*c^2*d*f-a*c*f^2+2*a^2*g^2)*x^2-c*(3*c*d-a*f)*g*x^4))/(8*a^4*g^3*q)]] /;
FreeQ[{a,c,d,e,f,g},x] && EqQ[9*c^3*d^2-6*a*c^2*d*f+a^2*c*f^2-12*a^3*g^2] && 
  EqQ[3*c^4*d^2*e-3*a^2*c^2*d*f*g+a^3*c*f^2*g-12*a^4*g^3-a*c^3*d*(e*f-12*d*g)] && 
  NeQ[3*c*d-a*f] && PosQ[(-a*c*f^2+12*a^2*g^2+3*c^2*d*f)/(c*g*(3*c*d-a*f))]


If[ShowSteps,

Int[u_*v_^p_,x_Symbol] :=
  With[{m=Exponent[u,x],n=Exponent[v,x]},
  Module[{c=Coefficient[u,x,m]/(Coefficient[v,x,n]*(m+1+n*p)),w},
  w=Apart[u-c*x^(m-n)*((m-n+1)*v+(p+1)*x*D[v,x]),x];
  If[EqQ[w],
    ShowStep["
If p>1, 1<n<=m+1, and m+1-n*p<0, let c=pm/(qn*(m+1-n*p)), then if (Pm[x]-c*x^(m-n)*((m-n+1)*Qn[x]+(1-p)*x*D[Qn[x],x]))==0,",
	  "Int[Pm[x]/Qn[x]^p,x]", "c*x^(m-n+1)/Qn[x]^(p-1)",
      Hold[c*x^(m-n+1)*v^(p+1)]],
  ShowStep["If p>1, 1<n<=m+1, and m+1-n*p<0, let c=pm/(qn*(m+1-n*p)), then",
	"Int[Pm[x]/Qn[x]^p,x]",
	"c*x^(m-n+1)/Qn[x]^(p-1)+Int[(Pm[x]-c*x^(m-n)*((m-n+1)*Qn[x]+(1-p)*x*D[Qn[x],x]))/Qn[x]^p,x]",
	Hold[c*x^(m-n+1)*v^(p+1) + Int[w*v^p,x]]]]] /;
 1<n<=m+1 && m+n*p<-1 && FalseQ[DerivativeDivides[v,u,x]]] /;
SimplifyFlag && RationalQ[p] && p<-1 && PolynomialQ[u,x] && PolynomialQ[v,x] && SumQ[v] && 
Not[MonomialQ[u,x] && BinomialQ[v,x]] && 
Not[EqQ[Coefficient[u,x,0]] && EqQ[Coefficient[v,x,0]]],

Int[u_*v_^p_,x_Symbol] :=
  With[{m=Exponent[u,x],n=Exponent[v,x]},
  Module[{c=Coefficient[u,x,m]/(Coefficient[v,x,n]*(m+1+n*p)),w},
  c=Coefficient[u,x,m]/(Coefficient[v,x,n]*(m+1+n*p));
  w=Apart[u-c*x^(m-n)*((m-n+1)*v+(p+1)*x*D[v,x]),x];
  If[EqQ[w],
    c*x^(m-n+1)*v^(p+1),
  c*x^(m-n+1)*v^(p+1) + Int[w*v^p,x]]] /;
 1<n<=m+1 && m+n*p<-1 && FalseQ[DerivativeDivides[v,u,x]]] /;
RationalQ[p] && p<-1 && PolynomialQ[u,x] && PolynomialQ[v,x] && SumQ[v] && 
Not[MonomialQ[u,x] && BinomialQ[v,x]] && 
Not[EqQ[Coefficient[u,x,0]] && EqQ[Coefficient[v,x,0]]]]



`)

func resourcesRubi13MiscellaneousAlgebraicFunctionsMBytes() ([]byte, error) {
	return _resourcesRubi13MiscellaneousAlgebraicFunctionsM, nil
}

func resourcesRubi13MiscellaneousAlgebraicFunctionsM() (*asset, error) {
	bytes, err := resourcesRubi13MiscellaneousAlgebraicFunctionsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/1.3 Miscellaneous algebraic functions.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi2ExponentialsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*Exponential Function Rules*)


(* ::Subsection::Closed:: *)
(*2.1 (c+d x)^m (a+b (F^(g (e+f x)))^n)^p*)


$UseGamma=False;


Int[(c_.+d_.*x_)^m_.*(b_.*F_^(g_.*(e_.+f_.*x_)))^n_.,x_Symbol] :=
  (c+d*x)^m*(b*F^(g*(e+f*x)))^n/(f*g*n*Log[F]) - 
  d*m/(f*g*n*Log[F])*Int[(c+d*x)^(m-1)*(b*F^(g*(e+f*x)))^n,x] /;
FreeQ[{F,b,c,d,e,f,g,n},x] && RationalQ[m] && m>0 && IntegerQ[2*m] && Not[$UseGamma===True]


Int[(c_.+d_.*x_)^m_*(b_.*F_^(g_.*(e_.+f_.*x_)))^n_.,x_Symbol] :=
  (c+d*x)^(m+1)*(b*F^(g*(e+f*x)))^n/(d*(m+1)) - 
  f*g*n*Log[F]/(d*(m+1))*Int[(c+d*x)^(m+1)*(b*F^(g*(e+f*x)))^n,x] /;
FreeQ[{F,b,c,d,e,f,g,n},x] && RationalQ[m] && m<-1 && IntegerQ[2*m] && Not[$UseGamma===True]


Int[F_^(g_.*(e_.+f_.*x_))/(c_.+d_.*x_),x_Symbol] :=
  F^(g*(e-c*f/d))/d*ExpIntegralEi[f*g*(c+d*x)*Log[F]/d] /;
FreeQ[{F,c,d,e,f,g},x] && Not[$UseGamma===True]


Int[(c_.+d_.*x_)^m_.*F_^(g_.*(e_.+f_.*x_)),x_Symbol] :=
  (-d)^m*F^(g*(e-c*f/d))/(f^(m+1)*g^(m+1)*Log[F]^(m+1))*Gamma[m+1,-f*g*Log[F]/d*(c+d*x)] /;
FreeQ[{F,c,d,e,f,g},x] && IntegerQ[m]


Int[F_^(g_.*(e_.+f_.*x_))/Sqrt[c_.+d_.*x_],x_Symbol] :=
  2/d*Subst[Int[F^(g*(e-c*f/d)+f*g*x^2/d),x],x,Sqrt[c+d*x]] /;
FreeQ[{F,c,d,e,f,g},x] && Not[$UseGamma===True]


Int[(c_.+d_.*x_)^m_*F_^(g_.*(e_.+f_.*x_)),x_Symbol] :=
  -F^(g*(e-c*f/d))*(c+d*x)^FracPart[m]/(d*(-f*g*Log[F]/d)^(IntPart[m]+1)*(-f*g*Log[F]*(c+d*x)/d)^FracPart[m])*
    Gamma[m+1,(-f*g*Log[F]/d)*(c+d*x)] /;
FreeQ[{F,c,d,e,f,g,m},x] && Not[IntegerQ[m]]


Int[(c_.+d_.*x_)^m_.*(b_.*F_^(g_.*(e_.+f_.*x_)))^n_,x_Symbol] :=
  (b*F^(g*(e+f*x)))^n/F^(g*n*(e+f*x))*Int[(c+d*x)^m*F^(g*n*(e+f*x)),x] /;
FreeQ[{F,b,c,d,e,f,g,m,n},x]


Int[(c_.+d_.*x_)^m_.*(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_.,x_Symbol] :=
  Int[ExpandIntegrand[(c+d*x)^m,(a+b*(F^(g*(e+f*x)))^n)^p,x],x] /;
FreeQ[{F,a,b,c,d,e,f,g,m,n},x] && PositiveIntegerQ[p]


Int[(c_.+d_.*x_)^m_./(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.),x_Symbol] :=
  -(c+d*x)^m/(a*f*g*n*Log[F])*Log[1+a/(b*(F^(g*(e+f*x)))^n)] + 
  d*m/(a*f*g*n*Log[F])*Int[(c+d*x)^(m-1)*Log[1+a/(b*(F^(g*(e+f*x)))^n)],x] /;
FreeQ[{F,a,b,c,d,e,f,g,n},x] && RationalQ[m] && m>0


Int[(c_.+d_.*x_)^m_.*(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_,x_Symbol] :=
  1/a*Int[(c+d*x)^m*(a+b*(F^(g*(e+f*x)))^n)^(p+1),x] - 
  b/a*Int[(c+d*x)^m*(F^(g*(e+f*x)))^n*(a+b*(F^(g*(e+f*x)))^n)^p,x] /;
FreeQ[{F,a,b,c,d,e,f,g,n},x] && NegativeIntegerQ[p] && PositiveIntegerQ[m]


Int[(c_.+d_.*x_)^m_.*(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_,x_Symbol] :=
  With[{u=IntHide[(a+b*(F^(g*(e+f*x)))^n)^p,x]},
  Dist[(c+d*x)^m,u,x] - d*m*Int[(c+d*x)^(m-1)*u,x]] /;
FreeQ[{F,a,b,c,d,e,f,g,n},x] && RationalQ[m,p] && m>0 && p<-1


Int[u_^m_.*(a_.+b_.*(F_^(g_.*v_))^n_.)^p_.,x_Symbol] :=
  Int[NormalizePowerOfLinear[u,x]^m*(a+b*(F^(g*ExpandToSum[v,x]))^n)^p,x] /;
FreeQ[{F,a,b,g,n,p},x] && LinearQ[v,x] && PowerOfLinearQ[u,x] && Not[LinearMatchQ[v,x] && PowerOfLinearMatchQ[u,x]] && IntegerQ[m]


Int[u_^m_.*(a_.+b_.*(F_^(g_.*v_))^n_.)^p_.,x_Symbol] :=
  Module[{uu=NormalizePowerOfLinear[u,x],z},
  z=If[PowerQ[uu] && FreeQ[uu[[2]],x], uu[[1]]^(m*uu[[2]]), uu^m];
  uu^m/z*Int[z*(a+b*(F^(g*ExpandToSum[v,x]))^n)^p,x]] /; 
FreeQ[{F,a,b,g,m,n,p},x] && LinearQ[v,x] && PowerOfLinearQ[u,x] && Not[LinearMatchQ[v,x] && PowerOfLinearMatchQ[u,x]] && 
  Not[IntegerQ[m]]


Int[(c_.+d_.*x_)^m_.*(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_.,x_Symbol] :=
  Defer[Int][(c+d*x)^m*(a+b*(F^(g*(e+f*x)))^n)^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x]





(* ::Subsection::Closed:: *)
(*2.2 (c+d x)^m (F^(g (e+f x)))^n (a+b (F^(g (e+f x)))^n)^p*)


Int[(c_.+d_.*x_)^m_.*(F_^(g_.*(e_.+f_.*x_)))^n_./(a_+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.),x_Symbol] :=
  (c+d*x)^m/(b*f*g*n*Log[F])*Log[1+b*(F^(g*(e+f*x)))^n/a] - 
  d*m/(b*f*g*n*Log[F])*Int[(c+d*x)^(m-1)*Log[1+b*(F^(g*(e+f*x)))^n/a],x] /;
FreeQ[{F,a,b,c,d,e,f,g,n},x] && RationalQ[m] && m>0


Int[(c_.+d_.*x_)^m_.*(F_^(g_.*(e_.+f_.*x_)))^n_.*(a_.+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_.,x_Symbol] :=
  (c+d*x)^m*(a+b*(F^(g*(e+f*x)))^n)^(p+1)/(b*f*g*n*(p+1)*Log[F]) - 
  d*m/(b*f*g*n*(p+1)*Log[F])*Int[(c+d*x)^(m-1)*(a+b*(F^(g*(e+f*x)))^n)^(p+1),x] /;
FreeQ[{F,a,b,c,d,e,f,g,m,n,p},x] && NeQ[p+1]


Int[(c_.+d_.*x_)^m_.*(F_^(g_.*(e_.+f_.*x_)))^n_.*(a_.+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_.,x_Symbol] :=
  Defer[Int][(c+d*x)^m*(F^(g*(e+f*x)))^n*(a+b*(F^(g*(e+f*x)))^n)^p,x] /;
FreeQ[{F,a,b,c,d,e,f,g,m,n,p},x]


Int[(c_.+d_.*x_)^m_.*(k_.*G_^(j_.*(h_.+i_.*x_)))^q_.*(a_.+b_.*(F_^(g_.*(e_.+f_.*x_)))^n_.)^p_.,x_Symbol] :=
  (k*G^(j*(h+i*x)))^q/(F^(g*(e+f*x)))^n*Int[(c+d*x)^m*(F^(g*(e+f*x)))^n*(a+b*(F^(g*(e+f*x)))^n)^p,x] /;
FreeQ[{F,a,b,c,d,e,f,g,h,i,j,k,m,n,p,q},x] && EqQ[f*g*n*Log[F]-i*j*q*Log[G]] && NeQ[(k*G^(j*(h+i*x)))^q-(F^(g*(e+f*x)))^n]





(* ::Subsection::Closed:: *)
(*2.3 Miscellaneous exponentials*)


Int[(F_^(c_.*(a_.+b_.*x_)))^n_.,x_Symbol] :=
  (F^(c*(a+b*x)))^n/(b*c*n*Log[F]) /;
FreeQ[{F,a,b,c,n},x]


Int[u_*F_^(c_.*v_),x_Symbol] :=
  Int[ExpandIntegrand[u*F^(c*ExpandToSum[v,x]),x],x] /;
FreeQ[{F,c},x] && PolynomialQ[u,x] && LinearQ[v,x] && $UseGamma===True


Int[u_*F_^(c_.*v_),x_Symbol] :=
  Int[ExpandIntegrand[F^(c*ExpandToSum[v,x]),u,x],x] /;
FreeQ[{F,c},x] && PolynomialQ[u,x] && LinearQ[v,x] && Not[$UseGamma===True]


Int[u_^m_.*F_^(c_.*v_)*w_,x_Symbol] :=
  Coefficient[w,x,1]*u^(m+1)*F^(c*v)/(Coefficient[v,x,1]*c*Coefficient[u,x,1]*Log[F]) /;
FreeQ[{F,c,m},x] && LinearQ[{u,v,w},x] && 
  EqQ[Coefficient[u,x,1]*Coefficient[w,x,1]*(m+1)-
    Coefficient[v,x,1]*c*(Coefficient[u,x,1]*Coefficient[w,x,0]-Coefficient[u,x,0]*Coefficient[w,x,1])*Log[F]]


Int[w_*u_^m_.*F_^(c_.*v_),x_Symbol] :=
  Int[ExpandIntegrand[w*NormalizePowerOfLinear[u,x]^m*F^(c*ExpandToSum[v,x]),x],x] /;
FreeQ[{F,c},x] && PolynomialQ[w,x] && LinearQ[v,x] && PowerOfLinearQ[u,x] && IntegerQ[m] && $UseGamma===True


Int[w_*u_^m_.*F_^(c_.*v_),x_Symbol] :=
  Int[ExpandIntegrand[F^(c*ExpandToSum[v,x]),w*NormalizePowerOfLinear[u,x]^m,x],x] /;
FreeQ[{F,c},x] && PolynomialQ[w,x] && LinearQ[v,x] && PowerOfLinearQ[u,x] && IntegerQ[m] && Not[$UseGamma===True]


Int[w_*u_^m_.*F_^(c_.*v_),x_Symbol] :=
  Module[{uu=NormalizePowerOfLinear[u,x],z},
  z=If[PowerQ[uu] && FreeQ[uu[[2]],x], uu[[1]]^(m*uu[[2]]), uu^m];
  uu^m/z*Int[ExpandIntegrand[w*z*F^(c*ExpandToSum[v,x]),x],x]] /;
FreeQ[{F,c,m},x] && PolynomialQ[w,x] && LinearQ[v,x] && PowerOfLinearQ[u,x] && Not[IntegerQ[m]]


Int[F_^(c_.*(a_.+b_.*x_))*Log[d_.*x_]^n_.*(e_+h_.*(f_.+g_.*x_)*Log[d_.*x_]),x_Symbol] :=
  e*x*F^(c*(a+b*x))*Log[d*x]^(n+1)/(n+1) /;
FreeQ[{F,a,b,c,d,e,f,g,h,n},x] && EqQ[e-f*h*(n+1)] && EqQ[g*h*(n+1)-b*c*e*Log[F]] && NeQ[n+1]


Int[x_^m_.*F_^(c_.*(a_.+b_.*x_))*Log[d_.*x_]^n_.*(e_+h_.*(f_.+g_.*x_)*Log[d_.*x_]),x_Symbol] :=
  e*x^(m+1)*F^(c*(a+b*x))*Log[d*x]^(n+1)/(n+1) /;
FreeQ[{F,a,b,c,d,e,f,g,h,m,n},x] && EqQ[e*(m+1)-f*h*(n+1)] && EqQ[g*h*(n+1)-b*c*e*Log[F]] && NeQ[n+1]


Int[F_^(a_.+b_.*(c_.+d_.*x_)),x_Symbol] :=
  F^(a+b*(c+d*x))/(b*d*Log[F]) /;
FreeQ[{F,a,b,c,d},x]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^2),x_Symbol] :=
  F^a*Sqrt[Pi]*Erfi[(c+d*x)*Rt[b*Log[F],2]]/(2*d*Rt[b*Log[F],2]) /;
FreeQ[{F,a,b,c,d},x] && PosQ[b]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^2),x_Symbol] :=
  F^a*Sqrt[Pi]*Erf[(c+d*x)*Rt[-b*Log[F],2]]/(2*d*Rt[-b*Log[F],2]) /;
FreeQ[{F,a,b,c,d},x] && NegQ[b]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (c+d*x)*F^(a+b*(c+d*x)^n)/d -
  b*n*Log[F]*Int[(c+d*x)^n*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d},x] && IntegerQ[2/n] && NegativeIntegerQ[n]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  With[{k=Denominator[n]},
  k/d*Subst[Int[x^(k-1)*F^(a+b*x^(k*n)),x],x,(c+d*x)^(1/k)]] /;
FreeQ[{F,a,b,c,d},x] && IntegerQ[2/n] && Not[IntegerQ[n]]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  -F^a*(c+d*x)*Gamma[1/n,-b*(c+d*x)^n*Log[F]]/(d*n*(-b*(c+d*x)^n*Log[F])^(1/n)) /;
FreeQ[{F,a,b,c,d,n},x] && Not[IntegerQ[2/n]]


Int[(e_.+f_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (e+f*x)^n*F^(a+b*(c+d*x)^n)/(b*f*n*(c+d*x)^n*Log[F]) /;
FreeQ[{F,a,b,c,d,e,f,n},x] && EqQ[m-(n-1)] && EqQ[d*e-c*f]


Int[F_^(a_.+b_.*(c_.+d_.*x_)^n_)/(e_.+f_.*x_),x_Symbol] :=
  F^a*ExpIntegralEi[b*(c+d*x)^n*Log[F]]/(f*n) /;
FreeQ[{F,a,b,c,d,e,f,n},x] && EqQ[d*e-c*f]


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  1/(d*(m+1))*Subst[Int[F^(a+b*x^2),x],x,(c+d*x)^(m+1)] /;
FreeQ[{F,a,b,c,d,m,n},x] && EqQ[n-2*(m+1)]


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (c+d*x)^(m-n+1)*F^(a+b*(c+d*x)^n)/(b*d*n*Log[F]) -
  (m-n+1)/(b*n*Log[F])*Int[(c+d*x)^(m-n)*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d},x] && RationalQ[m] && IntegerQ[2*(m+1)/n] && 0<(m+1)/n<5 && IntegerQ[n] && (0<n<m+1 || m<n<0)


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (c+d*x)^(m-n+1)*F^(a+b*(c+d*x)^n)/(b*d*n*Log[F]) -
  (m-n+1)/(b*n*Log[F])*Int[(c+d*x)^Simplify[m-n]*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d,m,n},x] && IntegerQ[2*Simplify[(m+1)/n]] && 0<Simplify[(m+1)/n]<5 && Not[RationalQ[m]] && SumSimplerQ[m,-n]


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (c+d*x)^(m+1)*F^(a+b*(c+d*x)^n)/(d*(m+1)) -
  b*n*Log[F]/(m+1)*Int[(c+d*x)^(m+n)*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d},x] && RationalQ[m] && IntegerQ[2*(m+1)/n] && -4<(m+1)/n<5 && IntegerQ[n] && (n>0 && m<-1 || 0<-n<=m+1)


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (c+d*x)^(m+1)*F^(a+b*(c+d*x)^n)/(d*(m+1)) -
  b*n*Log[F]/(m+1)*Int[(c+d*x)^Simplify[m+n]*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d,m,n},x] && IntegerQ[2*Simplify[(m+1)/n]] && -4<Simplify[(m+1)/n]<5 && Not[RationalQ[m]] && SumSimplerQ[m,n]


Int[(c_.+d_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  With[{k=Denominator[n]},
  k/d*Subst[Int[x^(k*(m+1)-1)*F^(a+b*x^(k*n)),x],x,(c+d*x)^(1/k)]] /;
FreeQ[{F,a,b,c,d},x] && RationalQ[m,n] && IntegerQ[2*(m+1)/n] && 0<(m+1)/n<5 && Not[IntegerQ[n]]


Int[(e_.+f_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (e+f*x)^m/(c+d*x)^m*Int[(c+d*x)^m*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d,e,f,m,n},x] && EqQ[d*e-c*f] && IntegerQ[2*Simplify[(m+1)/n]] && NeQ[f-d] && Not[IntegerQ[m]] && NeQ[c*e]


Int[(e_.+f_.*x_)^m_.*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
(*-F^a*(e+f*x)^(m+1)/(f*n)*ExpIntegralE[1-(m+1)/n,-b*(c+d*x)^n*Log[F]] *)
  -F^a*(e+f*x)^(m+1)/(f*n*(-b*(c+d*x)^n*Log[F])^((m+1)/n))*Gamma[(m+1)/n,-b*(c+d*x)^n*Log[F]] /;
FreeQ[{F,a,b,c,d,e,f,m,n},x] && EqQ[d*e-c*f]


Int[(e_.+f_.*x_)^m_*F_^(a_.+b_.*(c_.+d_.*x_)^2),x_Symbol] :=
  f*(e+f*x)^(m-1)*F^(a+b*(c+d*x)^2)/(2*b*d^2*Log[F]) + 
  (d*e-c*f)/d*Int[(e+f*x)^(m-1)*F^(a+b*(c+d*x)^2),x] - 
  (m-1)*f^2/(2*b*d^2*Log[F])*Int[(e+f*x)^(m-2)*F^(a+b*(c+d*x)^2),x] /;
FreeQ[{F,a,b,c,d,e,f},x] && NeQ[d*e-c*f] && FractionQ[m] && m>1


Int[(e_.+f_.*x_)^m_*F_^(a_.+b_.*(c_.+d_.*x_)^2),x_Symbol] :=
  f*(e+f*x)^(m+1)*F^(a+b*(c+d*x)^2)/((m+1)*f^2) + 
  2*b*d*(d*e-c*f)*Log[F]/(f^2*(m+1))*Int[(e+f*x)^(m+1)*F^(a+b*(c+d*x)^2),x] - 
  2*b*d^2*Log[F]/(f^2*(m+1))*Int[(e+f*x)^(m+2)*F^(a+b*(c+d*x)^2),x] /;
FreeQ[{F,a,b,c,d,e,f},x] && NeQ[d*e-c*f] && RationalQ[m] && m<-1


Int[(e_.+f_.*x_)^m_*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  (e+f*x)^(m+1)*F^(a+b*(c+d*x)^n)/(f*(m+1)) -
  b*d*n*Log[F]/(f*(m+1))*Int[(e+f*x)^(m+1)*(c+d*x)^(n-1)*F^(a+b*(c+d*x)^n),x] /;
FreeQ[{F,a,b,c,d,e,f},x] && NeQ[d*e-c*f] && IntegerQ[n] && n>2 && RationalQ[m] && m<-1


Int[F_^(a_.+b_./(c_.+d_.*x_))/(e_.+f_.*x_),x_Symbol] :=
  d/f*Int[F^(a+b/(c+d*x))/(c+d*x),x] - 
  (d*e-c*f)/f*Int[F^(a+b/(c+d*x))/((c+d*x)*(e+f*x)),x] /;
FreeQ[{F,a,b,c,d,e,f},x] && NeQ[d*e-c*f]


Int[(e_.+f_.*x_)^m_*F_^(a_.+b_./(c_.+d_.*x_)),x_Symbol] :=
  (e+f*x)^(m+1)*F^(a+b/(c+d*x))/(f*(m+1)) + 
  b*d*Log[F]/(f*(m+1))*Int[(e+f*x)^(m+1)*F^(a+b/(c+d*x))/(c+d*x)^2,x] /;
FreeQ[{F,a,b,c,d,e,f},x] && NeQ[d*e-c*f] && IntegerQ[m] && m<-1


Int[F_^(a_.+b_.*(c_.+d_.*x_)^n_)/(e_.+f_.*x_),x_Symbol] :=
  Defer[Int][F^(a+b*(c+d*x)^n)/(e+f*x),x] /;
FreeQ[{F,a,b,c,d,e,f,n},x] && NeQ[d*e-c*f]


Int[u_^m_.*F_^v_,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*F^ExpandToSum[v,x],x] /;
FreeQ[{F,m},x] && LinearQ[u,x] && BinomialQ[v,x] && Not[LinearMatchQ[u,x] && BinomialMatchQ[v,x]]


Int[u_*F_^(a_.+b_.*(c_.+d_.*x_)^n_),x_Symbol] :=
  Int[ExpandLinearProduct[F^(a+b*(c+d*x)^n),u,c,d,x],x] /;
FreeQ[{F,a,b,c,d,n},x] && PolynomialQ[u,x]


Int[u_.*F_^(a_.+b_.*v_),x_Symbol] :=
  Int[u*F^(a+b*NormalizePowerOfLinear[v,x]),x] /;
FreeQ[{F,a,b},x] && PolynomialQ[u,x] && PowerOfLinearQ[v,x] && Not[PowerOfLinearMatchQ[v,x]]


(* Int[u_.*F_^(a_.+b_.*v_^n_),x_Symbol] :=
  Int[u*F^(a+b*ExpandToSum[v,x]^n),x] /;
FreeQ[{F,a,b,n},x] && PolynomialQ[u,x] && LinearQ[v,x] && Not[LinearMatchQ[v,x]] *)


(* Int[u_.*F_^u_,x_Symbol] :=
  Int[u*F^ExpandToSum[u,x],x] /;
FreeQ[F,x] && PolynomialQ[u,x] && BinomialQ[u,x] && Not[BinomialMatchQ[u,x]] *)


Int[F_^(a_.+b_./(c_.+d_.*x_))/((e_.+f_.*x_)*(g_.+h_.*x_)),x_Symbol] :=
  -d/(f*(d*g-c*h))*Subst[Int[F^(a-b*h/(d*g-c*h)+d*b*x/(d*g-c*h))/x,x],x,(g+h*x)/(c+d*x)] /;
FreeQ[{F,a,b,c,d,e,f},x] && EqQ[d*e-c*f]


Int[(g_.+h_.*x_)^m_.*F_^(e_.+f_.*(a_.+b_.*x_)/(c_.+d_.*x_)),x_Symbol] :=
  F^(e+f*b/d)*Int[(g+h*x)^m,x] /;
FreeQ[{F,a,b,c,d,e,f,g,h,m},x] && EqQ[b*c-a*d]


Int[(g_.+h_.*x_)^m_.*F_^(e_.+f_.*(a_.+b_.*x_)/(c_.+d_.*x_)),x_Symbol] :=
  Int[(g+h*x)^m*F^((d*e+b*f)/d-f*(b*c-a*d)/(d*(c+d*x))),x] /;
FreeQ[{F,a,b,c,d,e,f,g,h,m},x] && NeQ[b*c-a*d] && EqQ[d*g-c*h]


Int[F_^(e_.+f_.*(a_.+b_.*x_)/(c_.+d_.*x_))/(g_.+h_.*x_),x_Symbol] :=
  d/h*Int[F^(e+f*(a+b*x)/(c+d*x))/(c+d*x),x] - 
  (d*g-c*h)/h*Int[F^(e+f*(a+b*x)/(c+d*x))/((c+d*x)*(g+h*x)),x] /;
FreeQ[{F,a,b,c,d,e,f,g,h},x] && NeQ[b*c-a*d] && NeQ[d*g-c*h]


Int[(g_.+h_.*x_)^m_*F_^(e_.+f_.*(a_.+b_.*x_)/(c_.+d_.*x_)),x_Symbol] :=
  (g+h*x)^(m+1)*F^(e+f*(a+b*x)/(c+d*x))/(h*(m+1)) - 
  f*(b*c-a*d)*Log[F]/(h*(m+1))*Int[(g+h*x)^(m+1)*F^(e+f*(a+b*x)/(c+d*x))/(c+d*x)^2,x] /;
FreeQ[{F,a,b,c,d,e,f,g,h},x] && NeQ[b*c-a*d] && NeQ[d*g-c*h] && IntegerQ[m] && m<-1


Int[F_^(e_.+f_.*(a_.+b_.*x_)/(c_.+d_.*x_))/((g_.+h_.*x_)*(i_.+j_.*x_)),x_Symbol] :=
  -d/(h*(d*i-c*j))*Subst[Int[F^(e+f*(b*i-a*j)/(d*i-c*j)-(b*c-a*d)*f*x/(d*i-c*j))/x,x],x,(i+j*x)/(c+d*x)] /;
FreeQ[{F,a,b,c,d,e,f,g,h},x] && EqQ[d*g-c*h]


Int[F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  F^(a-b^2/(4*c))*Int[F^((b+2*c*x)^2/(4*c)),x] /;
FreeQ[{F,a,b,c},x]


Int[F_^v_,x_Symbol] :=
  Int[F^ExpandToSum[v,x],x] /;
FreeQ[F,x] && QuadraticQ[v,x] && Not[QuadraticMatchQ[v,x]]


Int[(d_.+e_.*x_)*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*F^(a+b*x+c*x^2)/(2*c*Log[F]) /;
FreeQ[{F,a,b,c,d,e},x] && EqQ[b*e-2*c*d]


Int[(d_.+e_.*x_)^m_*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m-1)*F^(a+b*x+c*x^2)/(2*c*Log[F]) -
  (m-1)*e^2/(2*c*Log[F])*Int[(d+e*x)^(m-2)*F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e},x] && EqQ[b*e-2*c*d] && RationalQ[m] && m>1


Int[F_^(a_.+b_.*x_+c_.*x_^2)/(d_.+e_.*x_),x_Symbol] :=
  1/(2*e)*F^(a-b^2/(4*c))*ExpIntegralEi[(b+2*c*x)^2*Log[F]/(4*c)] /;
FreeQ[{F,a,b,c,d,e},x] && EqQ[b*e-2*c*d]


Int[(d_.+e_.*x_)^m_*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  (d+e*x)^(m+1)*F^(a+b*x+c*x^2)/(e*(m+1)) - 
  2*c*Log[F]/(e^2*(m+1))*Int[(d+e*x)^(m+2)*F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e},x] && EqQ[b*e-2*c*d] && RationalQ[m] && m<-1


Int[(d_.+e_.*x_)*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*F^(a+b*x+c*x^2)/(2*c*Log[F]) -
  (b*e-2*c*d)/(2*c)*Int[F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e},x] && NeQ[b*e-2*c*d]


Int[(d_.+e_.*x_)^m_*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  e*(d+e*x)^(m-1)*F^(a+b*x+c*x^2)/(2*c*Log[F]) -
  (b*e-2*c*d)/(2*c)*Int[(d+e*x)^(m-1)*F^(a+b*x+c*x^2),x] -
  (m-1)*e^2/(2*c*Log[F])*Int[(d+e*x)^(m-2)*F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e},x] && NeQ[b*e-2*c*d] && RationalQ[m] && m>1


Int[(d_.+e_.*x_)^m_*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  (d+e*x)^(m+1)*F^(a+b*x+c*x^2)/(e*(m+1)) -
  (b*e-2*c*d)*Log[F]/(e^2*(m+1))*Int[(d+e*x)^(m+1)*F^(a+b*x+c*x^2),x] -
  2*c*Log[F]/(e^2*(m+1))*Int[(d+e*x)^(m+2)*F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e},x] && NeQ[b*e-2*c*d] && RationalQ[m] && m<-1


Int[(d_.+e_.*x_)^m_.*F_^(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Defer[Int][(d+e*x)^m*F^(a+b*x+c*x^2),x] /;
FreeQ[{F,a,b,c,d,e,m},x]


Int[u_^m_.*F_^v_,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*F^ExpandToSum[v,x],x] /;
FreeQ[{F,m},x] && LinearQ[u,x] && QuadraticQ[v,x] && Not[LinearMatchQ[u,x] && QuadraticMatchQ[v,x]]


Int[x_^m_.*F_^(e_.*(c_.+d_.*x_))*(a_.+b_.*F_^v_)^p_,x_Symbol] :=
  With[{u=IntHide[F^(e*(c+d*x))*(a+b*F^v)^p,x]},
  Dist[x^m,u,x] - m*Int[x^(m-1)*u,x]] /;
FreeQ[{F,a,b,c,d,e},x] && EqQ[2*e*(c+d*x)-v] && RationalQ[m] && m>0 && NegativeIntegerQ[p]


Int[(F_^(e_.*(c_.+d_.*x_)))^n_.*(a_+b_.*(F_^(e_.*(c_.+d_.*x_)))^n_.)^p_.,x_Symbol] :=
  1/(d*e*n*Log[F])*Subst[Int[(a+b*x)^p,x],x,(F^(e*(c+d*x)))^n] /;
FreeQ[{F,a,b,c,d,e,n,p},x]


Int[(G_^(h_.(f_.+g_.*x_)))^m_.*(a_+b_.*(F_^(e_.*(c_.+d_.*x_)))^n_.)^p_.,x_Symbol] :=
  (G^(h*(f+g*x)))^m/(F^(e*(c+d*x)))^n*Int[(F^(e*(c+d*x)))^n*(a+b*(F^(e*(c+d*x)))^n)^p,x] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h,m,n,p},x] && EqQ[d*e*n*Log[F]-g*h*m*Log[G]]


Int[G_^(h_.(f_.+g_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  With[{m=FullSimplify[g*h*Log[G]/(d*e*Log[F])]},
  Denominator[m]*G^(f*h-c*g*h/d)/(d*e*Log[F])*Subst[Int[x^(Numerator[m]-1)*(a+b*x^Denominator[m])^p,x],x,F^(e*(c+d*x)/Denominator[m])] /;
 RationalQ[m] && Abs[m]>=1] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h,p},x]


Int[G_^(h_.(f_.+g_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  With[{m=FullSimplify[d*e*Log[F]/(g*h*Log[G])]},
  Denominator[m]/(g*h*Log[G])*Subst[Int[x^(Denominator[m]-1)*(a+b*F^(c*e-d*e*f/g)*x^Numerator[m])^p,x],x,G^(h*(f+g*x)/Denominator[m])] /;
 RationalQ[m] && Abs[m]>1] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h,p},x]


Int[G_^(h_.(f_.+g_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  Int[Expand[G^(h*(f+g*x))*(a+b*F^(e*(c+d*x)))^p,x],x] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h},x] && PositiveIntegerQ[p]


Int[G_^(h_.(f_.+g_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_,x_Symbol] :=
  a^p*G^(h*(f+g*x))/(g*h*Log[G])*Hypergeometric2F1[-p,g*h*Log[G]/(d*e*Log[F]),g*h*Log[G]/(d*e*Log[F])+1,Simplify[-b/a*F^(e*(c+d*x))]] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h,p},x] && (NegativeIntegerQ[p] || RationalQ[a] && a>0)


Int[G_^(h_.(f_.+g_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_,x_Symbol] :=
  (a+b*F^(e*(c+d*x)))^p/(1+(b/a)*F^(e*(c+d*x)))^p*Int[G^(h*(f+g*x))*(1+b/a*F^(e*(c+d*x)))^p,x] /;
FreeQ[{F,G,a,b,c,d,e,f,g,h,p},x] && Not[NegativeIntegerQ[p] || RationalQ[a] && a>0]


Int[G_^(h_. u_)*(a_+b_.*F_^(e_.*v_))^p_,x_Symbol] :=
  Int[G^(h*ExpandToSum[u,x])*(a+b*F^(e*ExpandToSum[v,x]))^p,x] /;
FreeQ[{F,G,a,b,e,h,p},x] && LinearQ[{u,v},x] && Not[LinearMatchQ[{u,v},x]]


Int[G_^(h_.(f_.+g_.*x_))*H_^(t_.(r_.+s_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  With[{m=FullSimplify[(g*h*Log[G]+s*t*Log[H])/(d*e*Log[F])]},
  Denominator[m]*G^(f*h-c*g*h/d)*H^(r*t-c*s*t/d)/(d*e*Log[F])*
    Subst[Int[x^(Numerator[m]-1)*(a+b*x^Denominator[m])^p,x],x,F^(e*(c+d*x)/Denominator[m])] /;
 RationalQ[m]] /;
FreeQ[{F,G,H,a,b,c,d,e,f,g,h,r,s,t,p},x]


Int[G_^(h_.(f_.+g_.*x_))*H_^(t_.(r_.+s_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  G^((f-c*g/d)*h)*Int[H^(t*(r+s*x))*(b+a*F^(-e*(c+d*x)))^p,x] /;
FreeQ[{F,G,H,a,b,c,d,e,f,g,h,r,s,t},x] && EqQ[d*e*p*Log[F]+g*h*Log[G]] && IntegerQ[p]


Int[G_^(h_.(f_.+g_.*x_))*H_^(t_.(r_.+s_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  Int[Expand[G^(h*(f+g*x))*H^(t*(r+s*x))*(a+b*F^(e*(c+d*x)))^p,x],x] /;
FreeQ[{F,G,H,a,b,c,d,e,f,g,h,r,s,t},x] && PositiveIntegerQ[p]


Int[G_^(h_.(f_.+g_.*x_))*H_^(t_.(r_.+s_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_,x_Symbol] :=
  a^p*G^(h*(f+g*x))*H^(t*(r+s*x))/(g*h*Log[G]+s*t*Log[H])*
    Hypergeometric2F1[-p,(g*h*Log[G]+s*t*Log[H])/(d*e*Log[F]),(g*h*Log[G]+s*t*Log[H])/(d*e*Log[F])+1,Simplify[-b/a*F^(e*(c+d*x))]] /;
FreeQ[{F,G,H,a,b,c,d,e,f,g,h,r,s,t},x] && NegativeIntegerQ[p]


Int[G_^(h_.(f_.+g_.*x_))*H_^(t_.(r_.+s_.*x_))*(a_+b_.*F_^(e_.*(c_.+d_.*x_)))^p_,x_Symbol] :=
  G^(h*(f+g*x))*H^(t*(r+s*x))*(a+b*F^(e*(c+d*x)))^p/((g*h*Log[G]+s*t*Log[H])*((a+b*F^(e*(c+d*x)))/a)^p)*
    Hypergeometric2F1[-p,(g*h*Log[G]+s*t*Log[H])/(d*e*Log[F]),(g*h*Log[G]+s*t*Log[H])/(d*e*Log[F])+1,Simplify[-b/a*F^(e*(c+d*x))]] /;
FreeQ[{F,G,H,a,b,c,d,e,f,g,h,r,s,t,p},x] && Not[IntegerQ[p]]


Int[G_^(h_. u_)*H_^(t_. w_)*(a_+b_.*F_^(e_.*v_))^p_,x_Symbol] :=
  Int[G^(h*ExpandToSum[u,x])*H^(t*ExpandToSum[w,x])*(a+b*F^(e*ExpandToSum[v,x]))^p,x] /;
FreeQ[{F,G,H,a,b,e,h,t,p},x] && LinearQ[{u,v,w},x] && Not[LinearMatchQ[{u,v,w},x]]


Int[F_^(e_.*(c_.+d_.*x_))*(a_.*x_^n_.+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  (a*x^n+b*F^(e*(c+d*x)))^(p+1)/(b*d*e*(p+1)*Log[F]) - 
  a*n/(b*d*e*Log[F])*Int[x^(n-1)*(a*x^n+b*F^(e*(c+d*x)))^p,x] /;
FreeQ[{F,a,b,c,d,e,n,p},x] && NeQ[p+1]


Int[x_^m_.*F_^(e_.*(c_.+d_.*x_))*(a_.*x_^n_.+b_.*F_^(e_.*(c_.+d_.*x_)))^p_.,x_Symbol] :=
  x^m*(a*x^n+b*F^(e*(c+d*x)))^(p+1)/(b*d*e*(p+1)*Log[F]) - 
  a*n/(b*d*e*Log[F])*Int[x^(m+n-1)*(a*x^n+b*F^(e*(c+d*x)))^p,x] - 
  m/(b*d*e*(p+1)*Log[F])*Int[x^(m-1)*(a*x^n+b*F^(e*(c+d*x)))^(p+1),x] /;
FreeQ[{F,a,b,c,d,e,m,n,p},x] && NeQ[p+1]


Int[(f_.+g_.*x_)^m_./(a_.+b_.*F_^u_+c_.*F_^v_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[(f+g*x)^m/(b-q+2*c*F^u),x] - 2*c/q*Int[(f+g*x)^m/(b+q+2*c*F^u),x]] /;
FreeQ[{F,a,b,c,f,g},x] && EqQ[v-2*u] && LinearQ[u,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[m]


Int[(f_.+g_.*x_)^m_.*F_^u_/(a_.+b_.*F_^u_+c_.*F_^v_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  2*c/q*Int[(f+g*x)^m*F^u/(b-q+2*c*F^u),x] - 2*c/q*Int[(f+g*x)^m*F^u/(b+q+2*c*F^u),x]] /;
FreeQ[{F,a,b,c,f,g},x] && EqQ[v-2*u] && LinearQ[u,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[m]


Int[(f_.+g_.*x_)^m_.*(h_+i_.*F_^u_)/(a_.+b_.*F_^u_+c_.*F_^v_),x_Symbol] :=
  With[{q=Rt[b^2-4*a*c,2]},
  (Simplify[(2*c*h-b*i)/q]+i)*Int[(f+g*x)^m/(b-q+2*c*F^u),x] - 
  (Simplify[(2*c*h-b*i)/q]-i)*Int[(f+g*x)^m/(b+q+2*c*F^u),x]] /;
FreeQ[{F,a,b,c,f,g,h,i},x] && EqQ[v-2*u] && LinearQ[u,x] && NeQ[b^2-4*a*c] && PositiveIntegerQ[m]


Int[x_^m_./(a_.*F_^(c_.+d_.*x_)+b_.*F_^v_),x_Symbol] :=
  With[{u=IntHide[1/(a*F^(c+d*x)+b*F^v),x]},
  x^m*u - m*Int[x^(m-1)*u,x]] /;
FreeQ[{F,a,b,c,d},x] && EqQ[(c+d*x)+v] && RationalQ[m] && m>0


Int[u_/(a_+b_.*F_^v_+c_.*F_^w_),x_Symbol] :=
  Int[u*F^v/(c+a*F^v+b*F^(2*v)),x] /;
FreeQ[{F,a,b,c},x] && LinearQ[v,x] && LinearQ[w,x] && EqQ[v+w] &&
  If[RationalQ[Coefficient[v,x,1]], Coefficient[v,x,1]>0, LeafCount[v]<LeafCount[w]]


Int[F_^(g_.*(d_.+e_.*x_)^n_.)/(a_.+b_.*x_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[F^(g*(d+e*x)^n),1/(a+b*x+c*x^2),x],x] /;
FreeQ[{F,a,b,c,d,e,g,n},x]


Int[F_^(g_.*(d_.+e_.*x_)^n_.)/(a_+c_.*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[F^(g*(d+e*x)^n),1/(a+c*x^2),x],x] /;
FreeQ[{F,a,c,d,e,g,n},x]


Int[u_^m_.*F_^(g_.*(d_.+e_.*x_)^n_.)/(a_.+b_.*x_+c_*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[F^(g*(d+e*x)^n),u^m/(a+b*x+c*x^2),x],x] /;
FreeQ[{F,a,b,c,d,e,g,n},x] && PolynomialQ[u,x] && IntegerQ[m]


Int[u_^m_.*F_^(g_.*(d_.+e_.*x_)^n_.)/(a_+c_*x_^2),x_Symbol] :=
  Int[ExpandIntegrand[F^(g*(d+e*x)^n),u^m/(a+c*x^2),x],x] /;
FreeQ[{F,a,c,d,e,g,n},x] && PolynomialQ[u,x] && IntegerQ[m]


Int[F_^((a_.+b_.*x_^4)/x_^2),x_Symbol] :=
  Sqrt[Pi]*Exp[2*Sqrt[-a*Log[F]]*Sqrt[-b*Log[F]]]*Erf[(Sqrt[-a*Log[F]]+Sqrt[-b*Log[F]]*x^2)/x]/
    (4*Sqrt[-b*Log[F]]) -
  Sqrt[Pi]*Exp[-2*Sqrt[-a*Log[F]]*Sqrt[-b*Log[F]]]*Erf[(Sqrt[-a*Log[F]]-Sqrt[-b*Log[F]]*x^2)/x]/
    (4*Sqrt[-b*Log[F]]) /;
FreeQ[{F,a,b},x]


Int[x_^m_.*(E^x_+x_^m_.)^n_,x_Symbol] :=
  -(E^x+x^m)^(n+1)/(n+1) +
  Int[(E^x+x^m)^(n+1),x] +
  m*Int[x^(m-1)*(E^x+x^m)^n,x] /;
RationalQ[m,n] && m>0 && n<0 && n!=-1


Int[Log[a_+b_.*(F_^(e_.*(c_.+d_.*x_)))^n_.],x_Symbol] :=
  1/(d*e*n*Log[F])*Subst[Int[Log[a+b*x]/x,x],x,(F^(e*(c+d*x)))^n] /;
FreeQ[{F,a,b,c,d,e,n},x] && PositiveQ[a]


Int[Log[a_+b_.*(F_^(e_.*(c_.+d_.*x_)))^n_.],x_Symbol] :=
  x*Log[a+b*(F^(e*(c+d*x)))^n] - b*d*e*n*Log[F]*Int[x*(F^(e*(c+d*x)))^n/(a+b*(F^(e*(c+d*x)))^n),x] /;
FreeQ[{F,a,b,c,d,e,n},x] && Not[PositiveQ[a]]


(* Int[u_.*(a_.*F_^v_)^n_,x_Symbol] :=
  a^n*Int[u*F^(n*v),x] /;
FreeQ[{F,a},x] && IntegerQ[n] *)


Int[u_.*(a_.*F_^v_)^n_,x_Symbol] :=
  (a*F^v)^n/F^(n*v)*Int[u*F^(n*v),x] /;
FreeQ[{F,a,n},x] && Not[IntegerQ[n]]


Int[u_,x_Symbol] :=
  With[{v=FunctionOfExponential[u,x]},
  v/D[v,x]*Subst[Int[FunctionOfExponentialFunction[u,x]/x,x],x,v]] /;
FunctionOfExponentialQ[u,x]


Int[u_.*(a_.*F_^v_+b_.*F_^w_)^n_,x_Symbol] :=
  Int[u*F^(n*v)*(a+b*F^ExpandToSum[w-v,x])^n,x] /;
FreeQ[{F,a,b,n},x] && NegativeIntegerQ[n] && LinearQ[{v,w},x]


Int[u_.*(a_.*F_^v_+b_.*G_^w_)^n_,x_Symbol] :=
  Int[u*F^(n*v)*(a+b*E^ExpandToSum[Log[G]*w-Log[F]*v,x])^n,x] /;
FreeQ[{F,G,a,b,n},x] && NegativeIntegerQ[n] && LinearQ[{v,w},x]


Int[u_.*(a_.*F_^v_+b_.*F_^w_)^n_,x_Symbol] :=
  (a*F^v+b*F^w)^n/(F^(n*v)*(a+b*F^ExpandToSum[w-v,x])^n)*Int[u*F^(n*v)*(a+b*F^ExpandToSum[w-v,x])^n,x] /;
FreeQ[{F,a,b,n},x] && Not[IntegerQ[n]] && LinearQ[{v,w},x]


Int[u_.*(a_.*F_^v_+b_.*G_^w_)^n_,x_Symbol] :=
  (a*F^v+b*G^w)^n/(F^(n*v)*(a+b*E^ExpandToSum[Log[G]*w-Log[F]*v,x])^n)*Int[u*F^(n*v)*(a+b*E^ExpandToSum[Log[G]*w-Log[F]*v,x])^n,x] /;
FreeQ[{F,G,a,b,n},x] && Not[IntegerQ[n]] && LinearQ[{v,w},x]


Int[u_.*F_^v_*G_^w_,x_Symbol] :=
  Int[u*NormalizeIntegrand[E^(v*Log[F]+w*Log[G]),x],x] /;
FreeQ[{F,G},x] && (BinomialQ[v+w,x] || PolynomialQ[v+w,x] && Exponent[v+w,x]<=2)


Int[F_^u_*(v_+w_)*y_.,x_Symbol] :=
  With[{z=v*y/(Log[F]*D[u,x])},
  F^u*z /;
 EqQ[D[z,x]-w*y]] /;
FreeQ[F,x]


Int[F_^u_*v_^n_.*w_,x_Symbol] :=
  With[{z=Log[F]*v*D[u,x]+(n+1)*D[v,x]},
  Coefficient[w,x,Exponent[w,x]]/Coefficient[z,x,Exponent[z,x]]*F^u*v^(n+1) /;
 Exponent[w,x]==Exponent[z,x] && EqQ[w*Coefficient[z,x,Exponent[z,x]]-z*Coefficient[w,x,Exponent[w,x]]]] /;
FreeQ[{F,n},x] && PolynomialQ[u,x] && PolynomialQ[v,x] && PolynomialQ[w,x]



`)

func resourcesRubi2ExponentialsMBytes() ([]byte, error) {
	return _resourcesRubi2ExponentialsM, nil
}

func resourcesRubi2ExponentialsM() (*asset, error) {
	bytes, err := resourcesRubi2ExponentialsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/2 Exponentials.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi3LogarithmsM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*Logarithm Function Rules*)


(* ::Subsection::Closed:: *)
(*3.1 u (a+b log(c (d (e+f x)^p)^q))^n*)


(* Int[(e_.+f_.*x_)^m_*Log[a_+b_.*x_]*(c_+d_.*x_)^n_.,x_Symbol] :=
  Int[ExpandIntegrand[Log[a+b*x],(e+f*x)^m*(c+d*x)^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && FractionQ[m] && IGtQ[n,0] *)


Int[(e_.+f_.*x_)^m_*Log[a_+b_.*x_]*(c_+d_.*x_)^n_,x_Symbol] :=
  With[{k=Denominator[m]},
  k/f*Subst[Int[x^(k*(m+1)-1)*Log[-(b*e-a*f)/f+b*x^k/f]*(-(d*e-c*f)/f+d*x^k/f)^n,x],x,(e+f*x)^(1/k)]] /;
FreeQ[{a,b,c,d,e,f,n},x] && FractionQ[m] && ILtQ[n,0]


Int[Log[g_.*(h_.*(b_.*x_)^p_.)^q_.]*Log[c_+d_.*x_]/x_,x_Symbol] :=
  -Log[g*(h*(b*x)^p)^q]*PolyLog[2,-d*x] + p*q*PolyLog[3,-d*x] /;
FreeQ[{b,c,d,g,h,p,q},x] && EqQ[c,1]


Int[Log[g_.*(h_.*(b_.*x_)^p_.)^q_.]*Log[cd_*(c_+d_.*x_)]/x_,x_Symbol] :=
  -Log[g*(h*(b*x)^p)^q]*PolyLog[2,-cd*d*x] + p*q*PolyLog[3,-cd*d*x] /;
FreeQ[{b,c,cd,d,g,h,p,q},x] && EqQ[cd*c,1]


Int[Log[g_.*(h_.*(b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_+d_.*x_)^r_.)^s_.]/x_,x_Symbol] :=
  r*s*Int[Log[g*(h*(b*x)^p)^q]*Log[1+d*x]/x,x] - 
  (r*s*Log[1+d*x]-Log[i*(j*(1+d*x)^r)^s])*Int[Log[g*(h*(b*x)^p)^q]/x,x]/;
FreeQ[{b,c,d,g,h,i,j,p,q,r,s},x] && EqQ[c,1] && NeQ[1+d*x,i*(j*(1+d*x)^r)^s]


Int[Log[g_.*(h_.*(b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.]/x_,x_Symbol] :=
  Log[g*(h*(b*x)^p)^q]^2*Log[i*(j*(c+d*x)^r)^s]/(2*p*q) - d*r*s/(2*p*q)*Int[Log[g*(h*(b*x)^p)^q]^2/(c+d*x),x]/;
FreeQ[{b,c,d,g,h,i,j,p,q,r,s},x] && NeQ[c,1]


Int[Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.]/x_,x_Symbol] :=
  Log[x]*Log[g*(h*(a+b*x)^p)^q]*Log[i*(j*(c+d*x)^r)^s] - 
  d*r*s*Int[Log[x]*Log[g*(h*(a+b*x)^p)^q]/(c+d*x),x] - 
  d*p*q*Int[Log[x]*Log[i*(j*(c+d*x)^r)^s]/(c+d*x),x]/;
FreeQ[{a,b,c,d,g,h,i,j,p,q,r,s},x] && EqQ[b*c-a*d,0]


(*Int[Log[a_+b_.*x_]*Log[c_+d_.*x_]/x_,x_Symbol] :=*)
  (*Log[-b*x/a]*Log[a+b*x]*Log[c+d*x] + *)
  (*1/2*Log[-b*x/a]*Log[a*(c+d*x)/(c*(a+b*x))]^2 + *)
  (*1/2*Log[-(b*c-a*d)/(d*(a+b*x))]*Log[a*(c+d*x)/(c*(a+b*x))]^2 - *)
  (*1/2*Log[a*(c+d*x)/(c*(a+b*x))]^2*Log[(b*c-a*d)*x/(c*(a+b*x))] - *)
  (*Log[-b*x/a]*Log[a+b*x]*Log[1+d*x/c] + *)
  (*Log[-(d*x/c)]*Log[a+b*x]*Log[1+d*x/c] - *)
  (*Log[-b*x/a]*Log[a*(c+d*x)/(c*(a+b*x))]*Log[1+d*x/c] + *)
  (*Log[-d*x/c]*Log[a*(c+d*x)/(c*(a+b*x))]*Log[1+d*x/c] + *)
  (*1/2*Log[-b*x/a]*Log[1+d*x/c]^2 - *)
  (*1/2*Log[-d*x/c]*Log[1+d*x/c]^2 + *)
  (*Log[c+d*x]*PolyLog[2,1+b*x/a] - *)
  (*Log[a*(c+d*x)/(c*(a+b*x))]*PolyLog[2,1+b*x/a] - *)
  (*Log[a*(c+d*x)/(c*(a+b*x))]*PolyLog[2,a*(c+d*x)/(c*(a+b*x))] + *)
  (*Log[a*(c+d*x)/(c*(a+b*x))]*PolyLog[2,b*(c+d*x)/(d*(a+b*x))] + *)
  (*Log[a+b*x]*PolyLog[2,1+d*x/c] + *)
  (*Log[a*(c+d*x)/(c*(a+b*x))]*PolyLog[2,1+d*x/c] - *)
  (*PolyLog[3,1+b*x/a] +*)
  (*PolyLog[3,a*(c+d*x)/(c*(a+b*x))] - *)
  (*PolyLog[3,b*(c+d*x)/(d*(a+b*x))] - *)
  (*PolyLog[3,1+d*x/c]/;*)
(*FreeQ[{a,b,c,d},x] && NeQ[b*c-a*d,0]*)


Int[Log[v_]*Log[w_]/x_,x_Symbol] :=
  Int[Log[ExpandToSum[v,x]]*Log[ExpandToSum[w,x]]/x,x] /;
LinearQ[{v,w},x] && Not[LinearMatchQ[{v,w},x]]


Int[Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.]/x_,x_Symbol] :=
  p*q*Int[Log[a+b*x]*Log[i*(j*(c+d*x)^r)^s]/x,x] - 
  (p*q*Log[a+b*x]-Log[g*(h*(a+b*x)^p)^q])*Int[Log[i*(j*(c+d*x)^r)^s]/x,x]/;
FreeQ[{a,b,c,d,g,h,i,j,p,q,r,s},x] && NeQ[b*c-a*d,0] && NeQ[a+b*x,g*(h*(a+b*x)^p)^q]


Int[Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.]/(e_+f_.*x_),x_Symbol] :=
  1/f*Subst[Int[Log[g*(h*Simp[-(b*e-a*f)/f+b*x/f,x]^p)^q]*Log[i*(j*Simp[-(d*e-c*f)/f+d*x/f,x]^r)^s]/x,x],x,e+f*x]/;
FreeQ[{a,b,c,d,e,f,g,h,i,j,p,q,r,s},x]


Int[(e_.+f_.*x_)^m_.*Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.],x_Symbol] :=
  (e+f*x)^(m+1)*Log[g*(h*(a+b*x)^p)^q]*Log[i*(j*(c+d*x)^r)^s]/(f*(m+1)) - 
  d*r*s/(f*(m+1))*Int[(e+f*x)^(m+1)*Log[g*(h*(a+b*x)^p)^q]/(c+d*x),x] - 
  b*p*q/(f*(m+1))*Int[(e+f*x)^(m+1)*Log[i*(j*(c+d*x)^r)^s]/(a+b*x),x]/;
FreeQ[{a,b,c,d,e,f,g,h,i,j,m,p,q,r,s},x] && m!=-1 && RationalQ[m]


Int[(e_.+f_.*x_)^m_.*Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.],x_Symbol] :=
  Defer[Int][(e+f*x)^m*Log[g*(h*(a+b*x)^p)^q]*Log[i*(j*(c+d*x)^r)^s],x]/;
FreeQ[{a,b,c,d,e,f,g,h,i,j,m,p,q,r,s},x]


Int[Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.],x_Symbol] :=
  (e+f*x)*Log[c*(d*(e+f*x)^p)^q]/f - p*q*x /;
FreeQ[{c,d,e,f,p,q},x]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/f - b*n*p*q*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && GtQ[n,0]


Int[1/Log[d_.*(e_.+f_.*x_)],x_Symbol] :=
  LogIntegral[d*(e+f*x)]/(d*f) /;
FreeQ[{d,e,f},x]


Int[1/(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]),x_Symbol] :=
  (e+f*x)/(b*f*p*q*E^(a/(b*p*q))*(c*(d*(e+f*x)^p)^q)^(1/(p*q)))*ExpIntegralEi[(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q)] /;
FreeQ[{a,b,c,d,e,f,p,q},x]


Int[1/Sqrt[a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]],x_Symbol] :=
  Sqrt[Pi]*Rt[b*p*q,2]*(e+f*x)/(b*f*p*q*E^(a/(b*p*q))*(c*(d*(e+f*x)^p)^q)^(1/(p*q)))*
    Erfi[Sqrt[a+b*Log[c*(d*(e+f*x)^p)^q]]/Rt[b*p*q,2]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && PosQ[b*p*q]


Int[1/Sqrt[a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]],x_Symbol] :=
  Sqrt[Pi]*Rt[-b*p*q,2]*(e+f*x)/(b*f*p*q*E^(a/(b*p*q))*(c*(d*(e+f*x)^p)^q)^(1/(p*q)))*
    Erf[Sqrt[a+b*Log[c*(d*(e+f*x)^p)^q]]/Rt[-b*p*q,2]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && NegQ[b*p*q]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(b*f*p*q*(n+1)) - 
  1/(b*p*q*(n+1))*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && LtQ[n,-1]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/
    (f*E^(a/(b*p*q))*(c*(d*(e+f*x)^p)^q)^(1/(p*q))*(-(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q))^n)*
    Gamma[n+1,-(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q)] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && Not[IntegerQ[2*n]]


Int[1/((g_.+h_.*x_)*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])),x_Symbol] :=
  Log[RemoveContent[a+b*Log[c*(d*(e+f*x)^p)^q],x]]/(b*h*p*q) /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && EqQ[f*g-e*h,0]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_./(g_.+h_.*x_),x_Symbol] :=
  (a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(b*h*p*q*(n+1)) /;
FreeQ[{a,b,c,d,e,f,g,h,n,p,q},x] && EqQ[f*g-e*h,0] && NeQ[n,-1]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  (g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/(h*(m+1)) - 
  b*n*p*q/(m+1)*Int[(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[f*g-e*h,0] && NeQ[m,-1] && GtQ[n,0]


Int[(g_.+h_.*x_)^m_./Log[d_.*(e_.+f_.*x_)^p_.],x_Symbol] :=
  (h/f)^(p-1)*LogIntegral[d*(e+f*x)^p]/(d*f*p) /;
FreeQ[{d,e,f,g,h,m,p},x] && EqQ[m-(p-1),0] && EqQ[f*g-e*h,0] && (IntegerQ[p] || PositiveQ[h/f])


Int[(g_.+h_.*x_)^m_/Log[d_.*(e_.+f_.*x_)^p_.],x_Symbol] :=
  (g+h*x)^(p-1)/(e+f*x)^(p-1)*Int[(e+f*x)^(p-1)/Log[d*(e+f*x)^p],x] /;
FreeQ[{d,e,f,g,h,m,p},x] && EqQ[m-(p-1),0] && EqQ[f*g-e*h,0] && Not[IntegerQ[p] || PositiveQ[h/f]]


Int[(g_.+h_.*x_)^m_./(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]),x_Symbol] :=
  (g+h*x)^(m+1)/(b*h*p*q*E^(a*(m+1)/(b*p*q))*(c*(d*(e+f*x)^p)^q)^((m+1)/(p*q)))*
    ExpIntegralEi[(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q)] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[f*g-e*h,0] && NeQ[m,-1]


Int[(g_.+h_.*x_)^m_./Sqrt[a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]],x_Symbol] :=
  Sqrt[Pi]*(g+h*x)^(m+1)/(b*h*p*q*Rt[(m+1)/(b*p*q),2]*E^(a*(m+1)/(b*p*q))*(c*(d*(e+f*x)^p)^q)^((m+1)/(p*q)))*
    Erfi[Rt[(m+1)/(b*p*q),2]*Sqrt[a+b*Log[c*(d*(e+f*x)^p)^q]]] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[f*g-e*h,0] && NeQ[m,-1] && PosQ[(m+1)/(b*p*q)]


Int[(g_.+h_.*x_)^m_./Sqrt[a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]],x_Symbol] :=
  Sqrt[Pi]*(g+h*x)^(m+1)/(b*h*p*q*Rt[-(m+1)/(b*p*q),2]*E^(a*(m+1)/(b*p*q))*(c*(d*(e+f*x)^p)^q)^((m+1)/(p*q)))*
    Erf[Rt[-(m+1)/(b*p*q),2]*Sqrt[a+b*Log[c*(d*(e+f*x)^p)^q]]] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[f*g-e*h,0] && NeQ[m,-1] && NegQ[(m+1)/(b*p*q)]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(b*h*p*q*(n+1)) - 
  (m+1)/(b*p*q*(n+1))*Int[(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && EqQ[f*g-e*h,0] && NeQ[m,-1] && LtQ[n,-1]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  (g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/
    (h*(m+1)*E^(a*(m+1)/(b*p*q))*(c*(d*(e+f*x)^p)^q)^((m+1)/(p*q))*(-(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q))^n)*
    Gamma[n+1,-(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])/(b*p*q)] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p},x] && EqQ[f*g-e*h,0] && NeQ[m,-1]


Int[Log[c_.*(e_.+f_.*x_)]/(g_.+h_.*x_),x_Symbol] :=
  -1/h*PolyLog[2,-Together[c*f/h]*(g+h*x)] /;
FreeQ[{c,e,f,g,h},x] && EqQ[h+c*(f*g-e*h),0]


Int[(a_.+b_.*Log[c_.*(e_.+f_.*x_)])/(g_.+h_.*x_),x_Symbol] :=
  (a+b*Log[c*(e-f*g/h)])*Log[g+h*x]/h + b*Int[Log[-h*(e+f*x)/(f*g-e*h)]/(g+h*x),x] /;
FreeQ[{a,b,c,e,f,g,h},x] && NeQ[h+c*(f*g-e*h),0] && PositiveQ[c*(e-f*g/h)]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_./(g_.+h_.*x_),x_Symbol] :=
  (a+b*Log[c*(d*(e+f*x)^p)^q])^n/h*Log[f*(g+h*x)/(f*g-e*h)] - 
  b*f*n*p*q/h*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1)*Log[f*(g+h*x)/(f*g-e*h)]/(e+f*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && NeQ[f*g-e*h,0] && PositiveIntegerQ[n]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]),x_Symbol] :=
  (g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])/(h*(m+1)) - 
  b*f*p*q/(h*(m+1))*Int[(g+h*x)^(m+1)/(e+f*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && NeQ[f*g-e*h,0] && NeQ[m,-1]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_/(g_.+h_.*x_)^2,x_Symbol] :=
  (e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/((f*g-e*h)*(g+h*x)) - 
  b*f*n*p*q/(f*g-e*h)*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1)/(g+h*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && NeQ[f*g-e*h,0] && GtQ[n,0]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/(h*(m+1)) - 
  b*f*n*p*q/(h*(m+1))*Int[(g+h*x)^(m+1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1)/(e+f*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q},x] && NeQ[f*g-e*h,0] && GtQ[n,0] && NeQ[m,-1] && IntegersQ[2*m,2*n] && 
  (n==1 || Not[PositiveIntegerQ[m]] || n==2 && NeQ[m,1])


Int[(g_.+h_.*x_)^m_./(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]),x_Symbol] :=
  Int[ExpandIntegrand[(g+h*x)^m/(a+b*Log[c*(d*(e+f*x)^p)^q]),x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && NeQ[f*g-e*h,0] && PositiveIntegerQ[m]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  (e+f*x)*(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(b*f*p*q*(n+1)) + 
  m*(f*g-e*h)/(b*f*p*q*(n+1))*Int[(g+h*x)^(m-1)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1),x] - 
  (m+1)/(b*p*q*(n+1))*Int[(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && NeQ[f*g-e*h,0] && LtQ[n,-1] && GtQ[m,0]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  Int[ExpandIntegrand[(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,h,n,p,q},x] && NeQ[f*g-e*h,0] && PositiveIntegerQ[m]


Int[u_^m_.*(a_.+b_.*Log[c_.*(d_.*v_^p_)^q_.])^n_.,x_Symbol] :=
  Int[ExpandToSum[u,x]^m*(a+b*Log[c*(d*ExpandToSum[v,x]^p)^q])^n,x] /;
FreeQ[{a,b,c,d,m,n,p,q},x] && LinearQ[{u,v},x] && Not[LinearMatchQ[{u,v},x]]


Int[(g_.+h_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  Defer[Int][(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p,q},x]


Int[Log[c_./(e_.+f_.*x_)]/((g_.+h_.*x_)*(i_.+j_.*x_)),x_Symbol] :=
  f/(h*(f*i-e*j))*PolyLog[2,Simplify[f*(i+j*x)/(j*(e+f*x))]] /;
FreeQ[{c,e,f,g,h,i,j},x] && EqQ[f*g-e*h,0] && EqQ[f*i+j*(c-e),0]


Int[(a_+b_.*Log[c_./(e_.+f_.*x_)])/((g_.+h_.*x_)*(i_.+j_.*x_)),x_Symbol] :=
  a*Int[1/((g+h*x)*(i+j*x)),x] + b*Int[Log[c/(e+f*x)]/((g+h*x)*(i+j*x)),x] /;
FreeQ[{a,b,c,e,f,g,h,i,j},x] && EqQ[f*g-e*h,0] && EqQ[f*i+j*(c-e),0]


Int[(i_.+j_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/(g_.+h_.*x_),x_Symbol] :=
  With[{u=IntHide[(i+j*x)^m/(g+h*x),x]},
  Dist[a+b*Log[c*(d*(e+f*x)^p)^q],u] - b*h*p*q*Int[SimplifyIntegrand[u/(g+h*x),x],x]] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,p,q},x] && EqQ[f*g-e*h,0] && IntegerQ[m+1/2]


Int[(i_.+j_.*x_)^m_.*(a_.+b_.*Log[c_.*(e_.+f_.*x_)])^n_./(g_.+h_.*x_),x_Symbol] :=
  1/(c^m*f^m*h)*Subst[Int[(a+b*x)^n*(c*f*i-c*e*j+j*E^x)^m,x],x,Log[c*(e+f*x)]] /;
FreeQ[{a,b,c,e,f,g,h,i,j,n},x] && EqQ[f*g-e*h,0] && PositiveIntegerQ[m] && (IntegerQ[n] || m>0)


Int[(i_.+j_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_./(g_.+h_.*x_),x_Symbol] :=
  With[{u=ExpandIntegrand[(a+b*Log[c*(d*(e+f*x)^p)^q])^n,(i+j*x)^m/(g+h*x),x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,p,q},x] && IntegerQ[m] && PositiveIntegerQ[n]


Int[(i_.+j_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_./(g_.+h_.*x_),x_Symbol] :=
  Defer[Int][(i+j*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^n/(g+h*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,m,n,p,q},x]


Int[Log[j_.*(k_.+m_.*x_)]/(g_.+h_.*x_)*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  -PolyLog[2,Together[1-j*(k+m*x)]]/h*(a+b*Log[c*(d*(e+f*x)^p)^q])^n + 
  b*f*n*p*q/h*Int[PolyLog[2,Together[1-j*(k+m*x)]]/(e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,j,k,m,p,q},x] && EqQ[h-h*j*k+g*j*m,0] && GtQ[n,0]


Int[Log[i_.*(j_.*(k_.+m_.*x_)^r_.)^s_.]*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_./(g_.+h_.*x_),x_Symbol] :=
  Log[i*(j*(k+m*x)^r)^s]*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(b*h*p*q*(n+1)) - 
  m*r*s/(b*h*p*q*(n+1))*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^(n+1)/(k+m*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,k,m,n,p,q,r,s},x] && EqQ[f*g-e*h,0] && NeQ[n,-1]


Int[Log[c_./(e_.+f_.*x_)]/(g_+h_.*x_^2),x_Symbol] :=
  -f/(2*e*h)*PolyLog[2,Simplify[(-e+f*x)/(e+f*x)]] /;
FreeQ[{c,e,f,g,h},x] && EqQ[f^2*g+e^2*h,0] && EqQ[c-2*e,0]


Int[(a_.+b_.*Log[c_./(e_.+f_.*x_)])/(g_+h_.*x_^2),x_Symbol] :=
  (a+b*Log[c/(2*e)])*Int[1/(g+h*x^2),x] + b*Int[Log[2*e/(e+f*x)]/(g+h*x^2),x] /;
FreeQ[{c,e,f,g,h},x] && EqQ[f^2*g+e^2*h,0] && PositiveQ[c/(2*e)] && (NeQ[c-2*e,0] || NeQ[a,0])


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/(g_.+h_.*x_+i_.*x_^2),x_Symbol] :=
  e*f*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])/((e+f*x)*(f*g+e*i*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,p,q},x] && EqQ[f^2*g-e*f*h+e^2*i,0]


Int[(a_.+b_.*Log[c_.*(d_.*(e_+f_.*x_)^p_.)^q_.])/(g_+i_.*x_^2),x_Symbol] :=
  e*f*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])/((e+f*x)*(f*g+e*i*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,i,p,q},x] && EqQ[f^2*g+e^2*i,0]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/Sqrt[g_+h_.*x_^2],x_Symbol] :=
  With[{u=IntHide[1/Sqrt[g+h*x^2],x]},  
  u*(a+b*Log[c*(d*(e+f*x)^p)^q]) - b*f*p*q*Int[SimplifyIntegrand[u/(e+f*x),x],x]] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && PositiveQ[g]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/(Sqrt[g1_+h1_.*x_]*Sqrt[g2_+h2_.*x_]),x_Symbol] :=
  With[{u=IntHide[1/Sqrt[g1*g2+h1*h2*x^2],x]},  
  u*(a+b*Log[c*(d*(e+f*x)^p)^q]) - b*f*p*q*Int[SimplifyIntegrand[u/(e+f*x),x],x]] /;
FreeQ[{a,b,c,d,e,f,g1,h1,g2,h2,p,q},x] && EqQ[g2*h1+g1*h2,0] && PositiveQ[g1] && PositiveQ[g2]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/Sqrt[g_+h_.*x_^2],x_Symbol] :=
  Sqrt[1+h/g*x^2]/Sqrt[g+h*x^2]*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])/Sqrt[1+h/g*x^2],x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && Not[PositiveQ[g]]


Int[(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])/(Sqrt[g1_+h1_.*x_]*Sqrt[g2_+h2_.*x_]),x_Symbol] :=
  Sqrt[1+h1*h2/(g1*g2)*x^2]/(Sqrt[g1+h1*x]*Sqrt[g2+h2*x])*Int[(a+b*Log[c*(d*(e+f*x)^p)^q])/Sqrt[1+h1*h2/(g1*g2)*x^2],x] /;
FreeQ[{a,b,c,d,e,f,g1,h1,g2,h2,p,q},x] && EqQ[g2*h1+g1*h2,0]


Int[Log[1+i_.*(j_.+k_.*x_)^m_.]/(g_.+h_.*x_)*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  -PolyLog[2,-i*(j+k*x)^m]/(h*m)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n + 
  b*f*n*p*q/(h*m)*Int[PolyLog[2,-i*(j+k*x)^m]/(e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,k,m,p,q},x] && GtQ[n,0] && EqQ[h*j-g*k,0]


Int[PolyLog[r_,i_.*(j_.+k_.*x_)^m_.]/(g_.+h_.*x_)*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  PolyLog[r+1,i*(j+k*x)^m]/(h*m)*(a+b*Log[c*(d*(e+f*x)^p)^q])^n - 
  b*f*n*p*q/(h*m)*Int[PolyLog[r+1,i*(j+k*x)^m]/(e+f*x)*(a+b*Log[c*(d*(e+f*x)^p)^q])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,k,m,p,q,r},x] && GtQ[n,0] && EqQ[h*j-g*k,0]


Int[Px_.*F_[g_.+h_.*x_]^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.]),x_Symbol] :=
  With[{u=IntHide[Px*F[g+h*x]^m,x]},
  Dist[(a+b*Log[c*(d*(e+f*x)^p)^q]),u,x] - b*f*p*q*Int[SimplifyIntegrand[u/(e+f*x),x],x]] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q},x] && PolynomialQ[Px,x] && PositiveIntegerQ[m] && 
  MemberQ[{Log,ArcSin,ArcCos,ArcTan,ArcCot,ArcSinh, ArcCosh,ArcTanh, ArcCoth},F]


Int[(a_.+b_.*Log[c_.*(d_.*(e_+f_.*x_^m_)^p_.)^q_.])^n_./x_,x_Symbol] :=
  1/m*Subst[Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^n/x,x],x,x^m] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && PositiveIntegerQ[n]


Int[(a_.+b_.*Log[c_.*(d_.*(x_^m_*(f_+e_.*x_^r_.))^p_.)^q_.])^n_./x_,x_Symbol] :=
  1/m*Subst[Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^n/x,x],x,x^m] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q},x] && EqQ[m+r,0] && PositiveIntegerQ[n]


Int[x_^r1_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_^r_)^p_.)^q_.])^n_.,x_Symbol] :=
  1/r*Subst[Int[(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x],x,x^r] /;
FreeQ[{a,b,c,d,e,f,n,p,q,r},x] && EqQ[r1-(r-1),0]


Int[x_^r1_.*(g_.+h_.*x_^r_)^m_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_^r_)^p_.)^q_.])^n_.,x_Symbol] :=
  1/r*Subst[Int[(g+h*x)^m*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x],x,x^r] /;
FreeQ[{a,b,c,d,e,f,g,h,m,n,p,q,r},x] && EqQ[r1-(r-1),0]


Int[(a_.+b_.*Log[c_.*x_^n_.])/(d_+e_.*x_^2),x_Symbol] :=
  With[{u=IntHide[1/(d+e*x^2),x]},  
  Dist[(a+b*Log[c*x^n]),u] - b*n*Int[u/x,x]] /;
FreeQ[{a,b,c,d,e,n},x]


Int[Log[c_.*(a_.+b_.*x_^mn_)]/(x_*(d_+e_.*x_^n_.)),x_Symbol] :=
  1/(d*n)*PolyLog[2,-Together[b*c*(d+e*x^n)/(d*x^n)]] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n+mn,0] && EqQ[d-a*c*d+b*c*e,0]


Int[Log[c_.*x_^mn_*(b_.+a_.*x_^n_.)]/(x_*(d_+e_.*x_^n_.)),x_Symbol] :=
  1/(d*n)*PolyLog[2,-Together[b*c*(d+e*x^n)/(d*x^n)]] /;
FreeQ[{a,b,c,d,e,n},x] && EqQ[n+mn,0] && EqQ[d-a*c*d+b*c*e,0]


Int[Px_*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  Int[ExpandIntegrand[Px*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x],x] /;
FreeQ[{a,b,c,d,e,f,n,p,q},x] && PolynomialQ[Px,x]


Int[RFx_*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  With[{u=ExpandIntegrand[(a+b*Log[c*(d*(e+f*x)^p)^q])^n,RFx,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && RationalFunctionQ[RFx,x] && PositiveIntegerQ[n]


Int[RFx_*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_.,x_Symbol] :=
  With[{u=ExpandIntegrand[RFx*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,d,e,f,p,q},x] && RationalFunctionQ[RFx,x] && PositiveIntegerQ[n]


Int[u_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_+g_.*x_^2)^p_.)^q_.])^n_.,x_Symbol] :=
  Int[u*(a+b*Log[c*(d*(f+2*g*x)^(2*p)/(4^p*g^p))^q])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,q,n},x] && EqQ[f^2-4*e*g,0] && IntegerQ[p]


Int[u_.*(a_.+b_.*Log[c_.*(d_.*v_^p_.)^q_.])^n_.,x_Symbol] :=
  Int[u*(a+b*Log[c*(d*ExpandToSum[v,x]^p)^q])^n,x] /;
FreeQ[{a,b,c,d,n,p,q},x] && LinearQ[v,x] && 
  Not[MatchQ[c*(d*v^p)^q, cc_.*(dd_.*(e_.+f_.*x)^pp_.)^qq_. /; FreeQ[{cc,dd,e,f,pp,qq},x]]]


Int[Log[a_.*(b_.*(c_.*x_^n_.)^p_)^q_]^r_.,x_Symbol] :=
  Subst[Int[Log[x^(n*p*q)]^r,x],x^(n*p*q),a*(b*(c*x^n)^p)^q] /;
FreeQ[{a,b,c,n,p,q,r},x]


Int[x_^m_.*Log[a_.*(b_.*(c_.*x_^n_.)^p_)^q_]^r_.,x_Symbol] :=
  Subst[Int[x^m*Log[x^(n*p*q)]^r,x],x^(n*p*q),a*(b*(c*x^n)^p)^q] /;
FreeQ[{a,b,c,m,n,p,q,r},x] && NeQ[m,-1] && Not[x^(n*p*q)===a*(b*(c*x^n)^p)^q]





(* ::Subsection::Closed:: *)
(*3.2 u log(e (f (a+b x)^p (c+d x)^q)^r)^s*)


Int[u_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  Int[u*Log[e*(b^p*f/d^p*(c+d*x)^(p+q))^r]^s,x] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && EqQ[b*c-a*d,0] && IntegerQ[p]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  (a+b*x)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/b - 
  r*s/b*Int[(b*c*p+a*d*q+b*d*(p+q)*x)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0]


Int[Log[e_.*(a_.+b_.*x_)/(c_.+d_.*x_)]/(g_.+h_.*x_),x_Symbol] :=
  1/h*PolyLog[2,Together[c-a*e]/(c+d*x)] /;
FreeQ[{a,b,c,d,e,g,h},x] && NeQ[b*c-a*d,0] && EqQ[d*g-c*h,0] && EqQ[d-b*e,0]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_./(g_.+h_.*x_),x_Symbol] :=
  -Log[-(b*c-a*d)/(d*(a+b*x))]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/h + 
  p*r*s (b*c-a*d)/h*Int[Log[-(b*c-a*d)/(d*(a+b*x))]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((a+b*x)*(c+d*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[b*g-a*h,0] && EqQ[p+q,0]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]/(g_.+h_.*x_),x_Symbol] :=
  Log[g+h*x]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]/h - 
  b*p*r/h*Int[Log[g+h*x]/(a+b*x),x] - 
  d*q*r/h*Int[Log[g+h*x]/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r},x] && NeQ[b*c-a*d,0]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_/(g_.+h_.*x_),x_Symbol] :=
  d/h*Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(c+d*x),x] - 
  (d*g-c*h)/h*Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/((c+d*x)*(g+h*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,1]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_./(g_.+h_.*x_)^2,x_Symbol] :=
  (a+b*x)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/((b*g-a*h)*(g+h*x)) - 
  p*r*s*(b*c-a*d)/(b*g-a*h)*Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((c+d*x)*(g+h*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[p+q,0] && NeQ[b*g-a*h,0]


Int[Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_/(g_.+h_.*x_)^3,x_Symbol] :=
  d/(d*g-c*h)*Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(g+h*x)^2,x] - 
  h/(d*g-c*h)*Int[(c+d*x)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(g+h*x)^3,x] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[p+q,0] && EqQ[b*g-a*h,0] && NeQ[d*g-c*h,0]


Int[(g_.+h_.*x_)^m_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  (g+h*x)^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(h*(m+1)) - 
  p*r*s*(b*c-a*d)/(h*(m+1))*Int[(g+h*x)^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((a+b*x)*(c+d*x)),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && NeQ[m,-1] && EqQ[p+q,0]


Int[(g_.+h_.*x_)^m_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  (g+h*x)^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(h*(m+1)) - 
  b*p*r*s/(h*(m+1))*Int[(g+h*x)^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/(a+b*x),x] - 
  d*q*r*s/(h*(m+1))*Int[(g+h*x)^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,g,h,m,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && NeQ[m,-1] && NeQ[p+q,0]


Int[1/((g_.+h_.*x_)^2*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]),x_Symbol] :=
  b*(c+d*x)*(e*(f*(a+b*x)^p*(c+d*x)^q)^r)^(1/(p*r))/(h*p*r*(b*c-a*d)*(g+h*x))*
    ExpIntegralEi[-1/(p*r)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]] /;
FreeQ[{a,b,c,d,e,f,g,h,p,q,r},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0] && EqQ[b*g-a*h,0]


Int[Log[i_.*(j_.*(h_.*x_)^t_.)^u_.]^m_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]/x_,x_Symbol] :=
  Log[i*(j*(h*x)^t)^u]^(m+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]/(t*u*(m+1)) - 
  b*p*r/(t*u*(m+1))*Int[Log[i*(j*(h*x)^t)^u]^(m+1)/(a+b*x),x] - 
  d*q*r/(t*u*(m+1))*Int[Log[i*(j*(h*x)^t)^u]^(m+1)/(c+d*x),x] /;
FreeQ[{a,b,c,d,e,f,h,i,j,m,p,q,r,t,u},x] && NeQ[b*c-a*d,0] && IGtQ[m,0]


Int[Log[i_.*(j_.*(h_.*x_)^t_.)^u_.]^m_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_./x_,x_Symbol] :=
  Defer[Int][Log[i*(j*(h*x)^t)^u]^m*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/x,x] /;
FreeQ[{a,b,c,d,e,f,h,i,j,m,p,q,r,s,t,u},x] && NeQ[b*c-a*d,0]


Int[u_*Log[e_.*(c_.+d_.*x_)/(a_.+b_.*x_)],x_Symbol] :=
  With[{g=Coeff[Simplify[1/(u*(a+b*x))],x,0],h=Coeff[Simplify[1/(u*(a+b*x))],x,1]},
  -(b-d*e)*PolyLog[2,(b-d*e)*(g+h*x)/(h*(a+b*x))]/(e*h*(b*c-a*d)) /;
 EqQ[g*(b-d*e)-h*(a-c*e),0]] /;
FreeQ[{a,b,c,d,e},x] && NeQ[b*c-a*d,0] && LinearQ[Simplify[1/(u*(a+b*x))],x]


Int[u_*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{g=Coeff[Simplify[1/(u*(a+b*x))],x,0],h=Coeff[Simplify[1/(u*(a+b*x))],x,1]},
  -Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(b*g-a*h)*Log[-(b*c-a*d)*(g+h*x)/((d*g-c*h)*(a+b*x))] + 
  p*r*s*(b*c-a*d)/(b*g-a*h)*
    Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((a+b*x)*(c+d*x))*Log[-(b*c-a*d)*(g+h*x)/((d*g-c*h)*(a+b*x))],x] /;
 NeQ[b*g-a*h,0] && NeQ[d*g-c*h,0]] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[p+q,0] && LinearQ[Simplify[1/(u*(a+b*x))],x]


Int[u_/Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.],x_Symbol] :=
  With[{h=Simplify[u*(a+b*x)*(c+d*x)]},
  h*Log[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]]/(p*r*(b*c-a*d)) /;
 FreeQ[h,x]] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0]


Int[u_*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{h=Simplify[u*(a+b*x)*(c+d*x)]},
  h*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s+1)/(p*r*(s+1)*(b*c-a*d)) /;
 FreeQ[h,x]] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0] && NeQ[s,-1]


Int[u_*Log[v_]*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{g=Simplify[(v-1)*(c+d*x)/(a+b*x)],h=Simplify[u*(a+b*x)*(c+d*x)]},
  -h*PolyLog[2,-g*(a+b*x)/(c+d*x)]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(b*c-a*d) + 
  h*p*r*s*Int[PolyLog[2,-g*(a+b*x)/(c+d*x)]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((a+b*x)*(c+d*x)),x] /;
 FreeQ[{g,h},x]] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[p+q,0]


Int[v_*Log[i_.*(j_.*(g_.+h_.*x_)^t_.)^u_.]*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{k=Simplify[v*(a+b*x)*(c+d*x)]},
  k*Log[i*(j*(g+h*x)^t)^u]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s+1)/(p*r*(s+1)*(b*c-a*d)) - 
  k*h*t*u/(p*r*(s+1)*(b*c-a*d))*Int[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s+1)/(g+h*x),x] /;
 FreeQ[k,x]] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,p,q,r,s,t,u},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0] && NeQ[s,-1]


Int[u_*PolyLog[n_,v_]*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{g=Simplify[v*(c+d*x)/(a+b*x)],h=Simplify[u*(a+b*x)*(c+d*x)]},
  h*PolyLog[n+1,g*(a+b*x)/(c+d*x)]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/(b*c-a*d) - 
  h*p*r*s*Int[PolyLog[n+1,g*(a+b*x)/(c+d*x)]*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1)/((a+b*x)*(c+d*x)),x] /;
 FreeQ[{g,h},x]] /;
FreeQ[{a,b,c,d,e,f,n,p,q,r,s},x] && NeQ[b*c-a*d,0] && IGtQ[s,0] && EqQ[p+q,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^(n+1)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s/((m+1)*(b*c-a*d)) - 
  p*r*s*(b*c-a*d)/((m+1)*(b*c-a*d))*Int[(a+b*x)^m*(c+d*x)^n*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^(s-1),x] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r,s},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0] && EqQ[m+n+2,0] && NeQ[m,-1] && IGtQ[s,0]


Int[(a_.+b_.*x_)^m_.*(c_.+d_.*x_)^n_./Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.],x_Symbol] :=
  (a+b*x)^(m+1)*(c+d*x)^(n+1)/(p*r*(b*c-a*d)*(e*(f*(a+b*x)^p*(c+d*x)^q)^r)^((m+1)/(p*r)))*
    ExpIntegralEi[(m+1)/(p*r)*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]] /;
FreeQ[{a,b,c,d,e,f,m,n,p,q,r},x] && NeQ[b*c-a*d,0] && EqQ[p+q,0] && EqQ[m+n+2,0] && NeQ[m,-1]


Int[RFx_.*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.],x_Symbol] :=
  p*r*Int[RFx*Log[a+b*x],x] + 
  q*r*Int[RFx*Log[c+d*x],x] - 
  (p*r*Log[a+b*x]+q*r*Log[c+d*x] - Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r])*Int[RFx,x] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && RationalFunctionQ[RFx,x] && NeQ[b*c-a*d,0] && 
  Not[MatchQ[RFx,u_.*(a+b*x)^m_.*(c+d*x)^n_. /; IntegersQ[m,n]]]


(* Int[RFx_*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.],x_Symbol] :=
  With[{u=IntHide[RFx,x]},  
  u*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r] - b*p*r*Int[u/(a+b*x),x] - d*q*r*Int[u/(c+d*x),x] /;
 NonsumQ[u]] /;
FreeQ[{a,b,c,d,e,f,p,q,r},x] && RationalFunctionQ[RFx,x] && NeQ[b*c-a*d,0] *)


Int[RFx_*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  With[{u=ExpandIntegrand[Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s,RFx,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && RationalFunctionQ[RFx,x] && IGtQ[s,0]


Int[RFx_*Log[e_.*(f_.*(a_.+b_.*x_)^p_.*(c_.+d_.*x_)^q_.)^r_.]^s_.,x_Symbol] :=
  Defer[Int][RFx*Log[e*(f*(a+b*x)^p*(c+d*x)^q)^r]^s,x] /;
FreeQ[{a,b,c,d,e,f,p,q,r,s},x] && RationalFunctionQ[RFx,x]


Int[u_.*Log[e_.*(f_.*v_^p_.*w_^q_.)^r_.]^s_.,x_Symbol] :=
  Int[u*Log[e*(f*ExpandToSum[v,x]^p*ExpandToSum[w,x]^q)^r]^s,x] /;
FreeQ[{e,f,p,q,r,s},x] && LinearQ[{v,w},x] && Not[LinearMatchQ[{v,w},x]]


Int[u_.*Log[e_.*(f_.*(g_+v_/w_))^r_.]^s_.,x_Symbol] :=
  Int[u*Log[e*(f*ExpandToSum[g*w+v,x]/ExpandToSum[w,x])^r]^s,x] /;
FreeQ[{e,f,g,r,s},x] && LinearQ[{v,w},x]


(* Int[Log[g_.*(h_.*(a_.+b_.*x_)^p_.)^q_.]*Log[i_.*(j_.*(c_.+d_.*x_)^r_.)^s_.]/(e_+f_.*x_),x_Symbol] :=
  1/f*Subst[Int[Log[g*(h*Simp[-(b*e-a*f)/f+b*x/f,x]^p)^q]*Log[i*(j*Simp[-(d*e-c*f)/f+d*x/f,x]^r)^s]/x,x],x,e+f*x] /;
FreeQ[{a,b,c,d,e,f,g,h,i,j,p,q,r,s},x] *)





(* ::Subsection::Closed:: *)
(*3.3 Miscellaneous logarithms*)


Int[Log[c_.*(a_.+b_.*x_^n_)^p_.],x_Symbol] :=
  x*Log[c*(a+b*x^n)^p] -
  b*n*p*Int[x^n/(a+b*x^n),x] /;
FreeQ[{a,b,c,n,p},x]


Int[Log[c_.*v_^p_.],x_Symbol] :=
  Int[Log[c*ExpandToSum[v,x]^p],x] /;
FreeQ[{c,p},x] && BinomialQ[v,x] && Not[BinomialMatchQ[v,x]]


Int[(a_.+b_.*Log[c_.*(d_.+e_.*x_^n_)^p_.])/(f_.+g_.*x_),x_Symbol] :=
  Log[f+g*x]*(a+b*Log[c*(d+e*x^n)^p])/g - 
  b*e*n*p/g*Int[x^(n-1)*Log[f+g*x]/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x]


Int[(f_.+g_.*x_)^m_.*(a_.+b_.*Log[c_.*(d_.+e_.*x_^n_)^p_.]),x_Symbol] :=
  (f+g*x)^(m+1)*(a+b*Log[c*(d+e*x^n)^p])/(g*(m+1)) - 
  b*e*n*p/(g*(m+1))*Int[x^(n-1)*(f+g*x)^(m+1)/(d+e*x^n),x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[m+1]


Int[u_^m_.*(a_.+b_.*Log[c_.*v_^p_.]),x_Symbol] :=
  Int[ExpandToSum[u,x]^m*(a+b*Log[c*ExpandToSum[v,x]^p]),x] /;
FreeQ[{a,b,c,m,p},x] && LinearQ[u,x] && BinomialQ[v,x] && Not[LinearMatchQ[u,x] && BinomialMatchQ[v,x]]


Int[ArcSin[f_.+g_.*x_]^m_.*(a_.+b_.*Log[c_.*(d_.+e_.*x_^n_)^p_.]),x_Symbol] :=
  With[{w=IntHide[ArcSin[f+g*x]^m,x]},  
  Dist[a+b*Log[c*(d+e*x^n)^p],w,x] - 
  b*e*n*p*Int[SimplifyIntegrand[x^(n-1)*w/(d+e*x^n),x],x]] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && PositiveIntegerQ[m]


Int[(a_.+b_.*Log[c_.*(d_.+e_.*x_^2)^p_.])/(f_.+g_.*x_^2),x_Symbol] :=
  With[{u=IntHide[1/(f+g*x^2),x]},  
  u*(a+b*Log[c*(d+e*x^2)^p]) - 2*b*e*p*Int[(x*u)/(d+e*x^2),x]] /;
FreeQ[{a,b,c,d,e,f,g,p},x]


Int[(a_.+b_.*Log[c_.*(d_+e_.*x_^2)^p_.])^n_,x_Symbol] :=
  x*(a+b*Log[c*(d+e*x^2)^p])^n - 
  2*b*e*n*p*Int[x^2*(a+b*Log[c*(d+e*x^2)^p])^(n-1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,p},x] && PositiveIntegerQ[n]


Int[x_^m_.*(a_.+b_.*Log[c_.*(d_+e_.*x_^2)^p_.])^n_,x_Symbol] :=
  1/2*Subst[Int[x^((m-1)/2)*(a+b*Log[c*(d+e*x)^p])^n,x],x,x^2] /;
FreeQ[{a,b,c,d,e,p},x] && PositiveIntegerQ[n] && IntegerQ[(m-1)/2]


Int[x_^m_.*(a_.+b_.*Log[c_.*(d_+e_.*x_^2)^p_.])^n_,x_Symbol] :=
  x^(m+1)*(a+b*Log[c*(d+e*x^2)^p])^n/(m+1) - 
  2*b*e*n*p/(m+1)*Int[x^(m+2)*(a+b*Log[c*(d+e*x^2)^p])^(n-1)/(d+e*x^2),x] /;
FreeQ[{a,b,c,d,e,m,p},x] && PositiveIntegerQ[n] && Not[IntegerQ[(m-1)/2]]


Int[u_*Log[v_],x_Symbol] :=
  With[{w=DerivativeDivides[v,u*(1-v),x]},
  w*PolyLog[2,Together[1-v]] /;
 Not[FalseQ[w]]]


Int[(a_.+b_.*Log[u_])*Log[v_]*w_,x_Symbol] :=
  With[{z=DerivativeDivides[v,w*(1-v),x]},
  z*(a+b*Log[u])*PolyLog[2,Together[1-v]] - 
  b*Int[SimplifyIntegrand[z*PolyLog[2,Together[1-v]]*D[u,x]/u,x],x] /;
 Not[FalseQ[z]]] /;
FreeQ[{a,b},x] && InverseFunctionFreeQ[u,x]


Int[Log[c_.*(a_+b_.*(d_.+e_.*x_)^n_)^p_.],x_Symbol] :=
  (d+e*x)*Log[c*(a+b*(d+e*x)^n)^p]/e -
  b*n*p*Int[1/(b+a*(d+e*x)^(-n)),x] /;
FreeQ[{a,b,c,d,e,p},x] && RationalQ[n] && n<0


Int[Log[c_.*(a_+b_.*(d_.+e_.*x_)^n_.)^p_.],x_Symbol] :=
  (d+e*x)*Log[c*(a+b*(d+e*x)^n)^p]/e - n*p*x +
  a*n*p*Int[1/(a+b*(d+e*x)^n),x] /;
FreeQ[{a,b,c,d,e,n,p},x] && Not[RationalQ[n] && n<0]


Int[(a_.+b_.*Log[c_.*(d_+e_./(f_.+g_.*x_))^p_.])^n_.,x_Symbol] :=
  (e+d*(f+g*x))*(a+b*Log[c*(d+e/(f+g*x))^p])^n/(d*g) - 
  b*e*n*p/(d*g)*Subst[Int[(a+b*Log[c*(d+e*x)^p])^(n-1)/x,x],x,1/(f+g*x)] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && PositiveIntegerQ[n]


Int[(a_.+b_.*Log[c_.*RFx_^p_.])^n_.,x_Symbol] :=
  x*(a+b*Log[c*RFx^p])^n - 
  b*n*p*Int[SimplifyIntegrand[x*(a+b*Log[c*RFx^p])^(n-1)*D[RFx,x]/RFx,x],x] /;
FreeQ[{a,b,c,p},x] && RationalFunctionQ[RFx,x] && PositiveIntegerQ[n]


Int[(a_.+b_.*Log[c_.*RFx_^p_.])^n_./(d_.+e_.*x_),x_Symbol] :=
  Log[d+e*x]*(a+b*Log[c*RFx^p])^n/e - 
  b*n*p/e*Int[Log[d+e*x]*(a+b*Log[c*RFx^p])^(n-1)*D[RFx,x]/RFx,x] /;
FreeQ[{a,b,c,d,e,p},x] && RationalFunctionQ[RFx,x] && PositiveIntegerQ[n]


Int[(d_.+e_.*x_)^m_.*(a_.+b_.*Log[c_.*RFx_^p_.])^n_.,x_Symbol] :=
  (d+e*x)^(m+1)*(a+b*Log[c*RFx^p])^n/(e*(m+1)) - 
  b*n*p/(e*(m+1))*Int[SimplifyIntegrand[(d+e*x)^(m+1)*(a+b*Log[c*RFx^p])^(n-1)*D[RFx,x]/RFx,x],x] /;
FreeQ[{a,b,c,d,e,m,p},x] && RationalFunctionQ[RFx,x] && PositiveIntegerQ[n] && (n==1 || IntegerQ[m]) && NeQ[m+1]


Int[Log[c_.*RFx_^n_.]/(d_+e_.*x_^2),x_Symbol] :=
  With[{u=IntHide[1/(d+e*x^2),x]},  
  u*Log[c*RFx^n] - n*Int[SimplifyIntegrand[u*D[RFx,x]/RFx,x],x]] /;
FreeQ[{c,d,e,n},x] && RationalFunctionQ[RFx,x] && Not[PolynomialQ[RFx,x]]


Int[Log[c_.*Px_^n_.]/Qx_,x_Symbol] :=
  With[{u=IntHide[1/Qx,x]},  
  u*Log[c*Px^n] - n*Int[SimplifyIntegrand[u*D[Px,x]/Px,x],x]] /;
FreeQ[{c,n},x] && QuadraticQ[{Qx,Px},x] && EqQ[D[Px/Qx,x]]


Int[RGx_*(a_.+b_.*Log[c_.*RFx_^p_.])^n_.,x_Symbol] :=
  With[{u=ExpandIntegrand[(a+b*Log[c*RFx^p])^n,RGx,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,p},x] && RationalFunctionQ[RFx,x] && RationalFunctionQ[RGx,x] && PositiveIntegerQ[n]


Int[RGx_*(a_.+b_.*Log[c_.*RFx_^p_.])^n_.,x_Symbol] :=
  With[{u=ExpandIntegrand[RGx*(a+b*Log[c*RFx^p])^n,x]},
  Int[u,x] /;
 SumQ[u]] /;
FreeQ[{a,b,c,p},x] && RationalFunctionQ[RFx,x] && RationalFunctionQ[RGx,x] && PositiveIntegerQ[n]


Int[RFx_*(a_.+b_.*Log[u_]),x_Symbol] :=
  With[{lst=SubstForFractionalPowerOfLinear[RFx*(a+b*Log[u]),x]},
  lst[[2]]*lst[[4]]*Subst[Int[lst[[1]],x],x,lst[[3]]^(1/lst[[2]])] /;
 Not[FalseQ[lst]]] /;
FreeQ[{a,b},x] && RationalFunctionQ[RFx,x]


Int[(f_.+g_.*x_)^m_.*Log[1+e_.*(F_^(c_.*(a_.+b_.*x_)))^n_.],x_Symbol] :=
  -(f+g*x)^m*PolyLog[2,-e*(F^(c*(a+b*x)))^n]/(b*c*n*Log[F]) + 
  g*m/(b*c*n*Log[F])*Int[(f+g*x)^(m-1)*PolyLog[2,-e*(F^(c*(a+b*x)))^n],x] /;
FreeQ[{F,a,b,c,e,f,g,n},x] && RationalQ[m] && m>0


Int[(f_.+g_.*x_)^m_.*Log[d_+e_.*(F_^(c_.*(a_.+b_.*x_)))^n_.],x_Symbol] :=
  (f+g*x)^(m+1)*Log[d+e*(F^(c*(a+b*x)))^n]/(g*(m+1)) - 
  (f+g*x)^(m+1)*Log[1+e/d*(F^(c*(a+b*x)))^n]/(g*(m+1)) + 
  Int[(f+g*x)^m*Log[1+e/d*(F^(c*(a+b*x)))^n],x] /;
FreeQ[{F,a,b,c,d,e,f,g,n},x] && RationalQ[m] && m>0 && NeQ[d-1]


Int[Log[d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2]],x_Symbol] :=
  x*Log[d+e*x+f*Sqrt[a+b*x+c*x^2]] + 
  f^2*(b^2-4*a*c)/2*Int[x/((2*d*e-b*f^2)*(a+b*x+c*x^2)-f*(b*d-2*a*e+(2*c*d-b*e)*x)*Sqrt[a+b*x+c*x^2]),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[e^2-c*f^2]


Int[Log[d_.+e_.*x_+f_.*Sqrt[a_.+c_.*x_^2]],x_Symbol] :=
  x*Log[d+e*x+f*Sqrt[a+c*x^2]] - 
  a*c*f^2*Int[x/(d*e*(a+c*x^2)+f*(a*e-c*d*x)*Sqrt[a+c*x^2]),x] /;
FreeQ[{a,c,d,e,f},x] && EqQ[e^2-c*f^2]


Int[(g_.*x_)^m_.*Log[d_.+e_.*x_+f_.*Sqrt[a_.+b_.*x_+c_.*x_^2]],x_Symbol] :=
  (g*x)^(m+1)*Log[d+e*x+f*Sqrt[a+b*x+c*x^2]]/(g*(m+1)) + 
  f^2*(b^2-4*a*c)/(2*g*(m+1))*Int[(g*x)^(m+1)/((2*d*e-b*f^2)*(a+b*x+c*x^2)-f*(b*d-2*a*e+(2*c*d-b*e)*x)*Sqrt[a+b*x+c*x^2]),x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && EqQ[e^2-c*f^2] && NeQ[m+1] && IntegerQ[2*m]


Int[(g_.*x_)^m_.*Log[d_.+e_.*x_+f_.*Sqrt[a_.+c_.*x_^2]],x_Symbol] :=
  (g*x)^(m+1)*Log[d+e*x+f*Sqrt[a+c*x^2]]/(g*(m+1)) - 
  a*c*f^2/(g*(m+1))*Int[(g*x)^(m+1)/(d*e*(a+c*x^2)+f*(a*e-c*d*x)*Sqrt[a+c*x^2]),x] /;
FreeQ[{a,c,d,e,f,g,m},x] && EqQ[e^2-c*f^2] && NeQ[m+1] && IntegerQ[2*m]


Int[v_.*Log[d_.+e_.*x_+f_.*Sqrt[u_]],x_Symbol] :=
  Int[v*Log[d+e*x+f*Sqrt[ExpandToSum[u,x]]],x] /;
FreeQ[{d,e,f},x] && QuadraticQ[u,x] && Not[QuadraticMatchQ[u,x]] && (EqQ[v-1] || MatchQ[v,(g_.*x)^m_. /; FreeQ[{g,m},x]])


Int[Log[u_],x_Symbol] :=
  x*Log[u] - Int[SimplifyIntegrand[x*D[u,x]/u,x],x] /;
InverseFunctionFreeQ[u,x]


Int[Log[u_]/(a_.+b_.*x_),x_Symbol] :=
  Log[a+b*x]*Log[u]/b -
  1/b*Int[SimplifyIntegrand[Log[a+b*x]*D[u,x]/u,x],x] /;
FreeQ[{a,b},x] && RationalFunctionQ[D[u,x]/u,x] && (NeQ[a] || Not[BinomialQ[u,x] && EqQ[BinomialDegree[u,x]^2-1]])


Int[(a_.+b_.*x_)^m_.*Log[u_],x_Symbol] :=
  (a+b*x)^(m+1)*Log[u]/(b*(m+1)) - 
  1/(b*(m+1))*Int[SimplifyIntegrand[(a+b*x)^(m+1)*D[u,x]/u,x],x] /;
FreeQ[{a,b,m},x] && InverseFunctionFreeQ[u,x] && NeQ[m+1] (* && Not[FunctionOfQ[x^(m+1),u,x]] && FalseQ[PowerVariableExpn[u,m+1,x]] *)


Int[Log[u_]/Qx_,x_Symbol] :=
  With[{v=IntHide[1/Qx,x]},  
  v*Log[u] - Int[SimplifyIntegrand[v*D[u,x]/u,x],x]] /;
QuadraticQ[Qx,x] && InverseFunctionFreeQ[u,x]


(* Int[x_^m_.*Px_.*Log[u_],x_Symbol] :=
  With[{v=IntHide[x^m*Px,x]},  
  Dist[Log[u],v] - Int[SimplifyIntegrand[v*D[u,x]/u,x],x]] /;
FreeQ[m,x] && PolynomialQ[Px,x] && InverseFunctionFreeQ[u,x] *)


Int[u_^(a_.*x_)*Log[u_],x_Symbol] :=
  u^(a*x)/a - Int[SimplifyIntegrand[x*u^(a*x-1)*D[u,x],x],x] /;
FreeQ[a,x] && InverseFunctionFreeQ[u,x]


Int[v_*Log[u_],x_Symbol] :=
  With[{w=IntHide[v,x]},  
  Dist[Log[u],w,x] - 
  Int[SimplifyIntegrand[w*D[u,x]/u,x],x] /;
 InverseFunctionFreeQ[w,x]] /;
InverseFunctionFreeQ[u,x]


Int[Log[v_]*Log[w_],x_Symbol] :=
  x*Log[v]*Log[w] - 
  Int[SimplifyIntegrand[x*Log[w]*D[v,x]/v,x],x] - 
  Int[SimplifyIntegrand[x*Log[v]*D[w,x]/w,x],x] /;
InverseFunctionFreeQ[v,x] && InverseFunctionFreeQ[w,x]


Int[u_*Log[v_]*Log[w_],x_Symbol] :=
  With[{z=IntHide[u,x]},  
  Dist[Log[v]*Log[w],z,x] - 
  Int[SimplifyIntegrand[z*Log[w]*D[v,x]/v,x],x] - 
  Int[SimplifyIntegrand[z*Log[v]*D[w,x]/w,x],x] /;
 InverseFunctionFreeQ[z,x]] /;
InverseFunctionFreeQ[v,x] && InverseFunctionFreeQ[w,x]


Int[Log[a_.*Log[b_.*x_^n_.]^p_.],x_Symbol] :=
  x*Log[a*Log[b*x^n]^p] - 
  n*p*Int[1/Log[b*x^n],x] /;
FreeQ[{a,b,n,p},x]


Int[Log[a_.*Log[b_.*x_^n_.]^p_.]/x_,x_Symbol] :=
  Log[b*x^n]*(-p+Log[a*Log[b*x^n]^p])/n /;
FreeQ[{a,b,n,p},x]


Int[x_^m_.*Log[a_.*Log[b_.*x_^n_.]^p_.],x_Symbol] :=
  x^(m+1)*Log[a*Log[b*x^n]^p]/(m+1) - 
  n*p/(m+1)*Int[x^m/Log[b*x^n],x] /;
FreeQ[{a,b,m,n,p},x] && NeQ[m+1]


Int[(A_.+B_.*Log[c_.+d_.*x_])/Sqrt[a_+b_.*Log[c_.+d_.*x_]],x_Symbol] :=
  (b*A-a*B)/b*Int[1/Sqrt[a+b*Log[c+d*x]],x] +
  B/b*Int[Sqrt[a+b*Log[c+d*x]],x] /;
FreeQ[{a,b,c,d,A,B},x] && NeQ[b*A-a*B]


Int[f_^(a_.*Log[u_]),x_Symbol] :=
  Int[u^(a*Log[f]),x] /;
FreeQ[{a,f},x]


(* If[ShowSteps,

Int[u_/x_,x_Symbol] :=
  With[{lst=FunctionOfLog[u,x]},
  ShowStep["","Int[F[Log[a*x^n]]/x,x]","Subst[Int[F[x],x],x,Log[a*x^n]]/n",Hold[
  1/lst[[3]]*Subst[Int[lst[[1]],x],x,Log[lst[[2]]]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag && NonsumQ[u],

Int[u_/x_,x_Symbol] :=
  With[{lst=FunctionOfLog[u,x]},
  1/lst[[3]]*Subst[Int[lst[[1]],x],x,Log[lst[[2]]]] /;
 Not[FalseQ[lst]]] /;
NonsumQ[u]] *)


If[ShowSteps,

Int[u_,x_Symbol] :=
  With[{lst=FunctionOfLog[Cancel[x*u],x]},
  ShowStep["","Int[F[Log[a*x^n]]/x,x]","Subst[Int[F[x],x],x,Log[a*x^n]]/n",Hold[
  1/lst[[3]]*Subst[Int[lst[[1]],x],x,Log[lst[[2]]]]]] /;
 Not[FalseQ[lst]]] /;
SimplifyFlag && NonsumQ[u],

Int[u_,x_Symbol] :=
  With[{lst=FunctionOfLog[Cancel[x*u],x]},
  1/lst[[3]]*Subst[Int[lst[[1]],x],x,Log[lst[[2]]]] /;
 Not[FalseQ[lst]]] /;
NonsumQ[u]]


Int[u_.*Log[Gamma[v_]],x_Symbol] :=
  (Log[Gamma[v]]-LogGamma[v])*Int[u,x] + Int[u*LogGamma[v],x]


Int[u_.*(a_. w_+b_. w_*Log[v_]^n_.)^p_.,x_Symbol] :=
  Int[u*w^p*(a+b*Log[v]^n)^p,x] /;
FreeQ[{a,b,n},x] && IntegerQ[p]


Int[u_.*(a_.+b_.*Log[c_.*(d_.*(e_.+f_.*x_)^p_.)^q_.])^n_,x_Symbol] :=
  Defer[Int][u*(a+b*Log[c*(d*(e+f*x)^p)^q])^n,x] /;
FreeQ[{a,b,c,d,e,f,n,p,q},x] && AlgebraicFunctionQ[u,x]



`)

func resourcesRubi3LogarithmsMBytes() ([]byte, error) {
	return _resourcesRubi3LogarithmsM, nil
}

func resourcesRubi3LogarithmsM() (*asset, error) {
	bytes, err := resourcesRubi3LogarithmsMBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "resources/rubi/3 Logarithms.m", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _resourcesRubi41SineM = []byte(`(* ::Package:: *)

(* ::Section:: *)
(*Trig Function Product Integration Rules*)


(* ::Subsection::Closed:: *)
(*4.1.0 (a sin)^m (b trg)^n*)


If[ShowSteps,

Int[u_,x_Symbol] :=
  Int[DeactivateTrig[u,x],x] /;
SimplifyFlag && FunctionOfTrigOfLinearQ[u,x],

Int[u_,x_Symbol] :=
  Int[DeactivateTrig[u,x],x] /;
FunctionOfTrigOfLinearQ[u,x]]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*cos[e_.+f_.*x_])^n_.,x_Symbol] :=
  (a*Sin[e+f*x])^(m+1)*(b*Cos[e+f*x])^(n+1)/(a*b*f*(m+1)) /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m+n+2,0] && NeQ[m,-1]


Int[(a_.*sin[e_.+f_.*x_])^m_.*cos[e_.+f_.*x_]^n_.,x_Symbol] :=
  1/(a*f)*Subst[Int[x^m*(1-x^2/a^2)^((n-1)/2),x],x,a*Sin[e+f*x]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n-1)/2] && Not[IntegerQ[(m-1)/2] && 0<m<n]


Int[(a_.*cos[e_.+f_.*x_])^m_.*sin[e_.+f_.*x_]^n_.,x_Symbol] :=
  -1/(a*f)*Subst[Int[x^m*(1-x^2/a^2)^((n-1)/2),x],x,a*Cos[e+f*x]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n-1)/2] && Not[IntegerQ[(m-1)/2] && 0<m<=n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  -a*(a*Sin[e+f*x])^(m-1)*(b*Cos[e+f*x])^(n+1)/(b*f*(n+1)) + 
  a^2*(m-1)/(b^2*(n+1))*Int[(a*Sin[e+f*x])^(m-2)*(b*Cos[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && GtQ[m,1] && LtQ[n,-1] && (IntegersQ[2*m,2*n] || EqQ[m+n,0])


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a*(a*Cos[e+f*x])^(m-1)*(b*Sin[e+f*x])^(n+1)/(b*f*(n+1)) + 
  a^2*(m-1)/(b^2*(n+1))*Int[(a*Cos[e+f*x])^(m-2)*(b*Sin[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && GtQ[m,1] && LtQ[n,-1] && (IntegersQ[2*m,2*n] || EqQ[m+n,0])


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  -a*(b*Cos[e+f*x])^(n+1)*(a*Sin[e+f*x])^(m-1)/(b*f*(m+n)) + 
  a^2*(m-1)/(m+n)*Int[(b*Cos[e+f*x])^n*(a*Sin[e+f*x])^(m-2),x] /;
FreeQ[{a,b,e,f,n},x] && GtQ[m,1] && NeQ[m+n,0] && IntegersQ[2*m,2*n]


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a*(b*Sin[e+f*x])^(n+1)*(a*Cos[e+f*x])^(m-1)/(b*f*(m+n)) + 
  a^2*(m-1)/(m+n)*Int[(b*Sin[e+f*x])^n*(a*Cos[e+f*x])^(m-2),x] /;
FreeQ[{a,b,e,f,n},x] && GtQ[m,1] && NeQ[m+n,0] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  (b*Cos[e+f*x])^(n+1)*(a*Sin[e+f*x])^(m+1)/(a*b*f*(m+1)) + 
  (m+n+2)/(a^2*(m+1))*Int[(b*Cos[e+f*x])^n*(a*Sin[e+f*x])^(m+2),x] /;
FreeQ[{a,b,e,f,n},x] && LtQ[m,-1] && IntegersQ[2*m,2*n]


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -(b*Sin[e+f*x])^(n+1)*(a*Cos[e+f*x])^(m+1)/(a*b*f*(m+1)) + 
  (m+n+2)/(a^2*(m+1))*Int[(b*Sin[e+f*x])^n*(a*Cos[e+f*x])^(m+2),x] /;
FreeQ[{a,b,e,f,n},x] && LtQ[m,-1] && IntegersQ[2*m,2*n]


Int[Sqrt[a_.*sin[e_.+f_.*x_]]*Sqrt[b_.*cos[e_.+f_.*x_]],x_Symbol] :=
  Sqrt[a*Sin[e+f*x]]*Sqrt[b*Cos[e+f*x]]/Sqrt[Sin[2*e+2*f*x]]*Int[Sqrt[Sin[2*e+2*f*x]],x] /;
FreeQ[{a,b,e,f},x]


Int[1/(Sqrt[a_.*sin[e_.+f_.*x_]]*Sqrt[b_.*cos[e_.+f_.*x_]]),x_Symbol] :=
  Sqrt[Sin[2*e+2*f*x]]/(Sqrt[a*Sin[e+f*x]]*Sqrt[b*Cos[e+f*x]])*Int[1/Sqrt[Sin[2*e+2*f*x]],x] /;
FreeQ[{a,b,e,f},x]


(* Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sin[e+f*x])^m*(b*Cos[e+f*x])^n/(a*Tan[e+f*x])^m*Int[(a*Tan[e+f*x])^m,x] /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m+n,0] *)


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  With[{k=Denominator[m]},
  k*a*b/f*Subst[Int[x^(k*(m+1)-1)/(a^2+b^2*x^(2*k)),x],x,(a*Sin[e+f*x])^(1/k)/(b*Cos[e+f*x])^(1/k)]] /;
FreeQ[{a,b,e,f},x] && EqQ[m+n,0] && GtQ[m,0] && LtQ[m,1]


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  With[{k=Denominator[m]},
  -k*a*b/f*Subst[Int[x^(k*(m+1)-1)/(a^2+b^2*x^(2*k)),x],x,(a*Cos[e+f*x])^(1/k)/(b*Sin[e+f*x])^(1/k)]] /;
FreeQ[{a,b,e,f},x] && EqQ[m+n,0] && GtQ[m,0] && LtQ[m,1]


(* Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  b^(2*IntPart[(n-1)/2]+1)*(b*Cos[e+f*x])^(2*FracPart[(n-1)/2])/(a*f*(Cos[e+f*x]^2)^FracPart[(n-1)/2])*
    Subst[Int[x^m*(1-x^2/a^2)^((n-1)/2),x],x,a*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m,n},x] && (RationalQ[n] || Not[RationalQ[m]] && (EqQ[b-1] || NeQ[a-1])) *)


(* Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^(2*IntPart[(n-1)/2]+1)*(b*Sin[e+f*x])^(2*FracPart[(n-1)/2])/(a*f*(Sin[e+f*x]^2)^FracPart[(n-1)/2])*
    Subst[Int[x^m*(1-x^2/a^2)^((n-1)/2),x],x,a*Cos[e+f*x]] /;
FreeQ[{a,b,e,f,m,n},x] *)


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^(2*IntPart[(n-1)/2]+1)*(b*Sin[e+f*x])^(2*FracPart[(n-1)/2])*(a*Cos[e+f*x])^(m+1)/(a*f*(m+1)*(Sin[e+f*x]^2)^FracPart[(n-1)/2])*
    Hypergeometric2F1[(1+m)/2,(1-n)/2,(3+m)/2,Cos[e+f*x]^2] /;
FreeQ[{a,b,e,f,m,n},x] && SimplerQ[n,m]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*cos[e_.+f_.*x_])^n_,x_Symbol] :=
  b^(2*IntPart[(n-1)/2]+1)*(b*Cos[e+f*x])^(2*FracPart[(n-1)/2])*(a*Sin[e+f*x])^(m+1)/(a*f*(m+1)*(Cos[e+f*x]^2)^FracPart[(n-1)/2])*
    Hypergeometric2F1[(1+m)/2,(1-n)/2,(3+m)/2,Sin[e+f*x]^2] /;
FreeQ[{a,b,e,f,m,n},x]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*sec[e_.+f_.*x_])^n_.,x_Symbol] :=
  b*(a*Sin[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n-1)/(a*f*(m+1)) /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m-n+2,0] && NeQ[m,1]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  a*b*(a*Sin[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n-1)/(f*(n-1)) - 
  a^2*b^2*(m-1)/(n-1)*Int[(a*Sin[e+f*x])^(m-2)*(b*Sec[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f},x] && GtQ[n,1] && GtQ[m,1] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sin[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n+1)/(a*b*f*(m-n)) - 
  (n+1)/(b^2*(m-n))*Int[(a*Sin[e+f*x])^m*(b*Sec[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f,m},x] && GtQ[n,1] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sin[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n+1)/(a*b*f*(m+1)) - 
  (n+1)/(a^2*b^2*(m+1))*Int[(a*Sin[e+f*x])^(m+2)*(b*Sec[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && LtQ[n,-1] && LtQ[m,-1] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sin[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n+1)/(a*b*f*(m-n)) - 
  (n+1)/(b^2*(m-n))*Int[(a*Sin[e+f*x])^m*(b*Sec[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f,m},x] && LtQ[n,-1] && NeQ[m-n,0] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  -a*b*(a*Sin[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n-1)/(f*(m-n)) + 
  a^2*(m-1)/(m-n)*Int[(a*Sin[e+f*x])^(m-2)*(b*Sec[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && GtQ[m,1] && NeQ[m-n,0] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Sin[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n-1)/(a*f*(m+1)) + 
  (m-n+2)/(a^2*(m+1))*Int[(a*Sin[e+f*x])^(m+2)*(b*Sec[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && LtQ[m,-1] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (b*Cos[e+f*x])^n*(b*Sec[e+f*x])^n*Int[(a*Sin[e+f*x])^m/(b*Cos[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && IntegerQ[m-1/2] && IntegerQ[n-1/2]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  1/b^2*(b*Cos[e+f*x])^(n+1)*(b*Sec[e+f*x])^(n+1)*Int[(a*Sin[e+f*x])^m/(b*Cos[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]] && LtQ[n,1]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  b^2*(b*Cos[e+f*x])^(n-1)*(b*Sec[e+f*x])^(n-1)*Int[(a*Sin[e+f*x])^m/(b*Cos[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*csc[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*b)^IntPart[n]*(a*Sin[e+f*x])^FracPart[n]*(b*Csc[e+f*x])^FracPart[n]*Int[(a*Sin[e+f*x])^(m-n),x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]





(* ::Subsection::Closed:: *)
(*4.2.0 (a trg)^m (b tan)^n*)


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  -b*(a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n-1)/(f*m) /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m+n-1]


Int[sin[e_.+f_.*x_]^m_.*tan[e_.+f_.*x_]^n_.,x_Symbol] :=
  -1/f*Subst[Int[(1-x^2)^((m+n-1)/2)/x^n,x],x,Cos[e+f*x]] /;
FreeQ[{e,f},x] && IntegersQ[m,n,(m+n-1)/2]


Int[sin[e_.+f_.*x_]^m_*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol] :=
  With[{ff=FreeFactors[Tan[e+f*x],x]},
  b*ff/f*Subst[Int[(ff*x)^(m+n)/(b^2+ff^2*x^2)^(m/2+1),x],x,b*Tan[e+f*x]/ff]] /;
FreeQ[{b,e,f,n},x] && IntegerQ[m/2]


Int[(a_.*sin[e_.+f_.*x_])^m_.*tan[e_.+f_.*x_]^n_.,x_Symbol] :=
  With[{ff=FreeFactors[Sin[e+f*x],x]},
  ff/f*Subst[Int[(ff*x)^(m+n)/(a^2-ff^2*x^2)^((n+1)/2),x],x,a*Sin[e+f*x]/ff]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n+1)/2]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Sin[e+f*x])^(m+2)*(b*Tan[e+f*x])^(n-1)/(a^2*f*(n-1)) - 
  b^2*(m+2)/(a^2*(n-1))*Int[(a*Sin[e+f*x])^(m+2)*(b*Tan[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f},x] && GtQ[n,1] && (LtQ[m,-1] || EqQ[m,-1] && EqQ[n,3/2]) && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n-1)/(f*(n-1)) - 
  b^2*(m+n-1)/(n-1)*Int[(a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f,m},x] && GtQ[n,1] && IntegersQ[2*m,2*n] && Not[GtQ[m,1] && Not[IntegerQ[(m-1)/2]]]


Int[Sqrt[a_.*sin[e_.+f_.*x_]]/(b_.*tan[e_.+f_.*x_])^(3/2),x_Symbol]:=
  2*Sqrt[a*Sin[e+f*x]]/(b*f*Sqrt[b*Tan[e+f*x]]) + a^2/b^2*Int[Sqrt[b*Tan[e+f*x]]/(a*Sin[e+f*x])^(3/2),x] /;
FreeQ[{a,b,e,f},x]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n+1)/(b*f*m) - 
  a^2*(n+1)/(b^2*m)*Int[(a*Sin[e+f*x])^(m-2)*(b*Tan[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && LtQ[n,-1] && GtQ[m,1] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  (a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n+1)/(b*f*(m+n+1)) - 
  (n+1)/(b^2*(m+n+1))*Int[(a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f,m},x] && LtQ[n,-1] && NeQ[m+n+1,0] && IntegersQ[2*m,2*n] && Not[n==-3/2 && EqQ[m,1]]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol]:=
  -b*(a*Sin[e+f*x])^m*(b*Tan[e+f*x])^(n-1)/(f*m) + 
  a^2*(m+n-1)/m*Int[(a*Sin[e+f*x])^(m-2)*(b*Tan[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && (GtQ[m,1] || EqQ[m,1] && EqQ[n,1/2]) && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol]:=
  b*(a*Sin[e+f*x])^(m+2)*(b*Tan[e+f*x])^(n-1)/(a^2*f*(m+n+1)) + 
  (m+2)/(a^2*(m+n+1))*Int[(a*Sin[e+f*x])^(m+2)*(b*Tan[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && LtQ[m,-1] && NeQ[m+n+1,0] && IntegersQ[2*m,2*n]


Int[(a_.*sin[e_.+f_.*x_])^m_*tan[e_.+f_.*x_]^n_,x_Symbol]:=
  1/a^n*Int[(a*Sin[e+f*x])^(m+n)/Cos[e+f*x]^n,x] /;
FreeQ[{a,e,f,m},x] && IntegerQ[n] && Not[IntegerQ[m]]


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  Cos[e+f*x]^n*(b*Tan[e+f*x])^n/(a*Sin[e+f*x])^n*Int[(a*Sin[e+f*x])^(m+n)/Cos[e+f*x]^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[n]] && (ILtQ[m,0] || EqQ[m,1] && EqQ[n,-1/2] || IntegersQ[m-1/2,n-1/2])


Int[(a_.*sin[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  a*Cos[e+f*x]^(n+1)*(b*Tan[e+f*x])^(n+1)/(b*(a*Sin[e+f*x])^(n+1))*Int[(a*Sin[e+f*x])^(m+n)/Cos[e+f*x]^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[n]]


Int[(a_.*cos[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Cos[e+f*x])^FracPart[m]*(Sec[e+f*x]/a)^FracPart[m]*Int[(b*Tan[e+f*x])^n/(Sec[e+f*x]/a)^m,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]


Int[(a_.*cot[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Cot[e+f*x])^m*(b*Tan[e+f*x])^m*Int[(b*Tan[e+f*x])^(n-m),x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol] :=
  -(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+1)/(b*f*m) /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m+n+1]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol] :=
  a/f*Subst[Int[(a*x)^(m-1)*(-1+x^2)^((n-1)/2),x],x,Sec[e+f*x]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n-1)/2] && Not[IntegerQ[m/2] && 0<m<n+1]


Int[sec[e_.+f_.*x_]^m_*(b_.*tan[e_.+f_.*x_])^n_.,x_Symbol] :=
  1/f*Subst[Int[(b*x)^n*(1+x^2)^(m/2-1),x],x,Tan[e+f*x]] /;
FreeQ[{b,e,f,n},x] && IntegerQ[m/2] && Not[IntegerQ[(n-1)/2] && 0<n<m-1]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  a^2*(a*Sec[e+f*x])^(m-2)*(b*Tan[e+f*x])^(n+1)/(b*f*(n+1)) - 
  a^2*(m-2)/(b^2*(n+1))*Int[(a*Sec[e+f*x])^(m-2)*(b*Tan[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && RationalQ[m,n] && n<-1 && (m>1 || m==1 && n==-3/2) && IntegersQ[2*m,2*n]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+1)/(b*f*(n+1)) - 
  (m+n+1)/(b^2*(n+1))*Int[(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f,m},x] && RationalQ[n] && n<-1 && IntegersQ[2*m,2*n]


Int[(a_.*sec[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n-1)/(f*m) - 
  b^2*(n-1)/(a^2*m)*Int[(a*Sec[e+f*x])^(m+2)*(b*Tan[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f},x] && RationalQ[m,n] && n>1 && (m<-1 || m==-1 && n==3/2) && IntegersQ[2*m,2*n]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n-1)/(f*(m+n-1)) - 
  b^2*(n-1)/(m+n-1)*Int[(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f,m},x] && RationalQ[n] && n>1 && NeQ[m+n-1] && IntegersQ[2*m,2*n]


Int[(a_.*sec[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  -(a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+1)/(b*f*m) + 
  (m+n+1)/(a^2*m)*Int[(a*Sec[e+f*x])^(m+2)*(b*Tan[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && RationalQ[m] && (m<-1 || m==-1 && RationalQ[n] && n==-1/2) && IntegersQ[2*m,2*n]


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  a^2*(a*Sec[e+f*x])^(m-2)*(b*Tan[e+f*x])^(n+1)/(b*f*(m+n-1)) + 
  a^2*(m-2)/(m+n-1)*Int[(a*Sec[e+f*x])^(m-2)*(b*Tan[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && RationalQ[m] && (m>1 || m==1 && RationalQ[n] && n==1/2) && NeQ[m+n-1] && IntegersQ[2*m,2*n]


Int[sec[e_.+f_.*x_]/Sqrt[b_.*tan[e_.+f_.*x_]],x_Symbol]:=
  Sqrt[Sin[e+f*x]]/(Sqrt[Cos[e+f*x]]*Sqrt[b*Tan[e+f*x]])*Int[1/(Sqrt[Cos[e+f*x]]*Sqrt[Sin[e+f*x]]),x] /;
FreeQ[{b,e,f},x]


Int[Sqrt[b_.*tan[e_.+f_.*x_]]/sec[e_.+f_.*x_],x_Symbol]:=
  Sqrt[Cos[e+f*x]]*Sqrt[b*Tan[e+f*x]]/Sqrt[Sin[e+f*x]]*Int[Sqrt[Cos[e+f*x]]*Sqrt[Sin[e+f*x]],x] /;
FreeQ[{b,e,f},x]


Int[(a_.*sec[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  a^(m+n)*(b*Tan[e+f*x])^n/((a*Sec[e+f*x])^n*(b*Sin[e+f*x])^n)*Int[(b*Sin[e+f*x])^n/Cos[e+f*x]^(m+n),x] /;
FreeQ[{a,b,e,f,m,n},x] && IntegerQ[n+1/2] && IntegerQ[m+1/2]


(* Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  (a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+1)*(Cos[e+f*x]^2)^((m+n+1)/2)/(b*f*(b*Sin[e+f*x])^(n+1))*
    Subst[Int[x^n/(1-x^2/b^2)^((m+n+1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[(n-1)/2]] && Not[IntegerQ[m/2]] *)


Int[(a_.*sec[e_.+f_.*x_])^m_.*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol]:=
  (a*Sec[e+f*x])^m*(b*Tan[e+f*x])^(n+1)*(Cos[e+f*x]^2)^((m+n+1)/2)/(b*f*(n+1))*
    Hypergeometric2F1[(n+1)/2,(m+n+1)/2,(n+3)/2,Sin[e+f*x]^2] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[(n-1)/2]] && Not[IntegerQ[m/2]]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*tan[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Csc[e+f*x])^FracPart[m]*(Sin[e+f*x]/a)^FracPart[m]*Int[(b*Tan[e+f*x])^n/(Sin[e+f*x]/a)^m,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[m]] && Not[IntegerQ[n]]





(* ::Subsection::Closed:: *)
(*4.3.0 (a csc)^m (b sec)^n*)


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  a*b*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n-1)/(f*(n-1)) /;
FreeQ[{a,b,e,f,m,n},x] && EqQ[m+n-2] && NeQ[n-1]


Int[csc[e_.+f_.*x_]^m_.*sec[e_.+f_.*x_]^n_.,x_Symbol] :=
  1/f*Subst[Int[(1+x^2)^((m+n)/2-1)/x^m,x],x,Tan[e+f*x]] /;
FreeQ[{e,f},x] && IntegersQ[m,n,(m+n)/2]


Int[(a_.*csc[e_.+f_.*x_])^m_*sec[e_.+f_.*x_]^n_.,x_Symbol] :=
  -1/(f*a^n)*Subst[Int[x^(m+n-1)/(-1+x^2/a^2)^((n+1)/2),x],x,a*Csc[e+f*x]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n+1)/2] && Not[IntegerQ[(m+1)/2] && 0<m<n]


Int[(a_.*sec[e_.+f_.*x_])^m_*csc[e_.+f_.*x_]^n_.,x_Symbol] :=
  1/(f*a^n)*Subst[Int[x^(m+n-1)/(-1+x^2/a^2)^((n+1)/2),x],x,a*Sec[e+f*x]] /;
FreeQ[{a,e,f,m},x] && IntegerQ[(n+1)/2] && Not[IntegerQ[(m+1)/2] && 0<m<n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  -a*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n+1)/(f*b*(m-1)) + 
  a^2*(n+1)/(b^2*(m-1))*Int[(a*Csc[e+f*x])^(m-2)*(b*Sec[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f},x] && RationalQ[m,n] && m>1 && n<-1 && IntegersQ[2*m,2*n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(a*Csc[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n-1)/(f*a*(n-1)) + 
  b^2*(m+1)/(a^2*(n-1))*Int[(a*Csc[e+f*x])^(m+2)*(b*Sec[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f},x] && RationalQ[m,n] && m<-1 && n>1 && IntegersQ[2*m,2*n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_.,x_Symbol] :=
  -a*b*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n-1)/(f*(m-1)) + 
  a^2*(m+n-2)/(m-1)*Int[(a*Csc[e+f*x])^(m-2)*(b*Sec[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && GtQ[m,1] && IntegersQ[2*m,2*n] && Not[n>m]


Int[(a_.*csc[e_.+f_.*x_])^m_.*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  a*b*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n-1)/(f*(n-1)) + 
  b^2*(m+n-2)/(n-1)*Int[(a*Csc[e+f*x])^m*(b*Sec[e+f*x])^(n-2),x] /;
FreeQ[{a,b,e,f,m},x] && GtQ[n,1] && IntegersQ[2*m,2*n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_.,x_Symbol] :=
  b*(a*Csc[e+f*x])^(m+1)*(b*Sec[e+f*x])^(n-1)/(a*f*(m+n)) + 
  (m+1)/(a^2*(m+n))*Int[(a*Csc[e+f*x])^(m+2)*(b*Sec[e+f*x])^n,x] /;
FreeQ[{a,b,e,f,n},x] && RationalQ[m] && m<-1 && NeQ[m+n] && IntegersQ[2*m,2*n]


Int[(a_.*csc[e_.+f_.*x_])^m_.*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  -a*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n+1)/(b*f*(m+n)) + 
  (n+1)/(b^2*(m+n))*Int[(a*Csc[e+f*x])^m*(b*Sec[e+f*x])^(n+2),x] /;
FreeQ[{a,b,e,f,m},x] && RationalQ[n] && n<-1 && NeQ[m+n] && IntegersQ[2*m,2*n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Csc[e+f*x])^m*(b*Sec[e+f*x])^n/Tan[e+f*x]^n*Int[Tan[e+f*x]^n,x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[IntegerQ[n]] && EqQ[m+n]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  (a*Csc[e+f*x])^m*(b*Sec[e+f*x])^n*(a*Sin[e+f*x])^m*(b*Cos[e+f*x])^n*Int[(a*Sin[e+f*x])^(-m)*(b*Cos[e+f*x])^(-n),x] /;
FreeQ[{a,b,e,f,m,n},x] && IntegerQ[m-1/2] && IntegerQ[n-1/2]


Int[(a_.*csc[e_.+f_.*x_])^m_*(b_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  a^2/b^2*(a*Csc[e+f*x])^(m-1)*(b*Sec[e+f*x])^(n+1)*(a*Sin[e+f*x])^(m-1)*(b*Cos[e+f*x])^(n+1)*
    Int[(a*Sin[e+f*x])^(-m)*(b*Cos[e+f*x])^(-n),x] /;
FreeQ[{a,b,e,f,m,n},x] && Not[SimplerQ[-m,-n]]


Int[(a_.*sec[e_.+f_.*x_])^m_*(b_.*csc[e_.+f_.*x_])^n_,x_Symbol] :=
  a^2/b^2*(a*Sec[e+f*x])^(m-1)*(b*Csc[e+f*x])^(n+1)*(a*Cos[e+f*x])^(m-1)*(b*Sin[e+f*x])^(n+1)*
    Int[(a*Cos[e+f*x])^(-m)*(b*Sin[e+f*x])^(-n),x] /;
FreeQ[{a,b,e,f,m,n},x]





(* ::Section:: *)
(*Sine Function Integration Rules*)


(* ::Subsection::Closed:: *)
(*4.1.1.1 (a+b sin)^n*)


Int[sin[c_.+d_.*x_]^n_,x_Symbol] :=
  -1/d*Subst[Int[Expand[(1-x^2)^((n-1)/2),x],x],x,Cos[c+d*x]] /;
FreeQ[{c,d},x] && PositiveIntegerQ[(n-1)/2]


Int[(b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
(* -Cot[c+d*x]*(c*Sin[c+d*x])^n/(d*n) + b^2*(n-1)/n*Int[(b*Sin[c+d*x])^(n-2),x] *)
  -b*Cos[c+d*x]*(b*Sin[c+d*x])^(n-1)/(d*n) + b^2*(n-1)/n*Int[(b*Sin[c+d*x])^(n-2),x] /;
FreeQ[{b,c,d},x] && IntegerQ[2*n] && n>1


Int[(b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  Cos[c+d*x]*(b*Sin[c+d*x])^(n+1)/(b*d*(n+1)) + 
  (n+2)/(b^2*(n+1))*Int[(b*Sin[c+d*x])^(n+2),x] /;
FreeQ[{b,c,d},x] && IntegerQ[2*n] && n<-1


Int[sin[c_.+Pi/2+d_.*x_],x_Symbol] :=
  Sin[c+d*x]/d /;
FreeQ[{c,d},x]


Int[sin[c_.+d_.*x_],x_Symbol] :=
  -Cos[c+d*x]/d /;
FreeQ[{c,d},x]


(* Int[1/sin[c_.+d_.*x_],x_Symbol] :=
  Int[Csc[c+d*x],x] /;
FreeQ[{c,d},x] *)


Int[Sqrt[sin[c_.+d_.*x_]],x_Symbol] :=
  2/d*EllipticE[1/2*(c-Pi/2+d*x),2] /;
FreeQ[{c,d},x]


Int[Sqrt[b_*sin[c_.+d_.*x_]],x_Symbol] :=
  Sqrt[b*Sin[c+d*x]]/Sqrt[Sin[c+d*x]]*Int[Sqrt[Sin[c+d*x]],x] /;
FreeQ[{b,c,d},x]


Int[1/Sqrt[sin[c_.+d_.*x_]],x_Symbol] :=
  2/d*EllipticF[1/2*(c-Pi/2+d*x),2] /;
FreeQ[{c,d},x]


Int[1/Sqrt[b_*sin[c_.+d_.*x_]],x_Symbol] :=
  Sqrt[Sin[c+d*x]]/Sqrt[b*Sin[c+d*x]]*Int[1/Sqrt[Sin[c+d*x]],x] /;
FreeQ[{b,c,d},x]


(* Int[(b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  Cos[c+d*x]/(b*d*Sqrt[Cos[c+d*x]^2])*Subst[Int[x^n/Sqrt[1-x^2/b^2],x],x,b*Sin[c+d*x]] /;
FreeQ[{b,c,d,n},x] && Not[IntegerQ[2*n]] *)


Int[(b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  Cos[c+d*x]*(b*Sin[c+d*x])^(n+1)/(b*d*(n+1)*Sqrt[Cos[c+d*x]^2])*Hypergeometric2F1[1/2,(n+1)/2,(n+3)/2,Sin[c+d*x]^2] /;
FreeQ[{b,c,d,n},x] && Not[IntegerQ[2*n]]


Int[(a_+b_.*sin[c_.+d_.*x_])^2,x_Symbol] :=
  (2*a^2+b^2)*x/2 - 2*a*b*Cos[c+d*x]/d - b^2*Cos[c+d*x]*Sin[c+d*x]/(2*d) /;
FreeQ[{a,b,c,d},x]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  Int[ExpandTrig[(a+b*sin[c+d*x])^n,x],x] /;
FreeQ[{a,b,c,d,n},x] && EqQ[a^2-b^2] && PositiveIntegerQ[n]


Int[Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  -2*b*Cos[c+d*x]/(d*Sqrt[a+b*Sin[c+d*x]]) /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  -b*Cos[c+d*x]*(a+b*Sin[c+d*x])^(n-1)/(d*n) +
  a*(2*n-1)/n*Int[(a+b*Sin[c+d*x])^(n-1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2] && PositiveIntegerQ[n-1/2]


Int[1/(a_+b_.*sin[c_.+d_.*x_]),x_Symbol] :=
  -Cos[c+d*x]/(d*(b+a*Sin[c+d*x])) /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2]


Int[1/Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  -2/d*Subst[Int[1/(2*a-x^2),x],x,b*Cos[c+d*x]/Sqrt[a+b*Sin[c+d*x]]] /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  b*Cos[c+d*x]*(a+b*Sin[c+d*x])^n/(a*d*(2*n+1)) +
  (n+1)/(a*(2*n+1))*Int[(a+b*Sin[c+d*x])^(n+1),x] /;
FreeQ[{a,b,c,d},x] && EqQ[a^2-b^2] && RationalQ[n] && n<-1 && IntegerQ[2*n]


(* Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  a^2*Cos[c+d*x]/(d*Sqrt[a+b*Sin[c+d*x]]*Sqrt[a-b*Sin[c+d*x]])*Subst[Int[(a+b*x)^(n-1/2)/Sqrt[a-b*x],x],x,Sin[c+d*x]] /;
FreeQ[{a,b,c,d,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[2*n]] *)


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  -2^(n+1/2)*a^(n-1/2)*b*Cos[c+d*x]/(d*Sqrt[a+b*Sin[c+d*x]])*Hypergeometric2F1[1/2,1/2-n,3/2,1/2*(1-b*Sin[c+d*x]/a)] /;
FreeQ[{a,b,c,d,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[2*n]] && PositiveQ[a]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  a^IntPart[n]*(a+b*Sin[c+d*x])^FracPart[n]/(1+b/a*Sin[c+d*x])^FracPart[n]*Int[(1+b/a*Sin[c+d*x])^n,x] /;
FreeQ[{a,b,c,d,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[2*n]] && Not[PositiveQ[a]]


Int[Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  2*Sqrt[a+b]/d*EllipticE[1/2*(c-Pi/2+d*x),2*b/(a+b)] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && PositiveQ[a+b]


Int[Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  2*Sqrt[a-b]/d*EllipticE[1/2*(c+Pi/2+d*x),-2*b/(a-b)] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && PositiveQ[a-b]


Int[Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  Sqrt[a+b*Sin[c+d*x]]/Sqrt[(a+b*Sin[c+d*x])/(a+b)]*Int[Sqrt[a/(a+b)+b/(a+b)*Sin[c+d*x]],x] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && Not[PositiveQ[a+b]]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  -b*Cos[c+d*x]*(a+b*Sin[c+d*x])^(n-1)/(d*n) + 
  1/n*Int[(a+b*Sin[c+d*x])^(n-2)*Simp[a^2*n+b^2*(n-1)+a*b*(2*n-1)*Sin[c+d*x],x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && RationalQ[n] && n>1 && IntegerQ[2*n]


Int[1/(a_+b_.*sin[c_.+d_.*x_]),x_Symbol] :=
  With[{q=Rt[a^2-b^2,2]},
  x/q + 2/(d*q)*ArcTan[b*Cos[c+d*x]/(a+q+b*Sin[c+d*x])]] /;
FreeQ[{a,b,c,d},x] && PositiveQ[a^2-b^2] && PosQ[a]


Int[1/(a_+b_.*sin[c_.+d_.*x_]),x_Symbol] :=
  With[{q=Rt[a^2-b^2,2]},
  -x/q - 2/(d*q)*ArcTan[b*Cos[c+d*x]/(a-q+b*Sin[c+d*x])]] /;
FreeQ[{a,b,c,d},x] && PositiveQ[a^2-b^2] && NegQ[a]


Int[1/(a_+b_.*sin[c_.+Pi/2+d_.*x_]),x_Symbol] :=
  With[{e=FreeFactors[Tan[(c+d*x)/2],x]},
  2*e/d*Subst[Int[1/(a+b+(a-b)*e^2*x^2),x],x,Tan[(c+d*x)/2]/e]] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2]


Int[1/(a_+b_.*sin[c_.+d_.*x_]),x_Symbol] :=
  With[{e=FreeFactors[Tan[(c+d*x)/2],x]},
  2*e/d*Subst[Int[1/(a+2*b*e*x+a*e^2*x^2),x],x,Tan[(c+d*x)/2]/e]] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2]


Int[1/Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  2/(d*Sqrt[a+b])*EllipticF[1/2*(c-Pi/2+d*x),2*b/(a+b)] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && PositiveQ[a+b]


Int[1/Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  2/(d*Sqrt[a-b])*EllipticF[1/2*(c+Pi/2+d*x),-2*b/(a-b)] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && PositiveQ[a-b]


Int[1/Sqrt[a_+b_.*sin[c_.+d_.*x_]],x_Symbol] :=
  Sqrt[(a+b*Sin[c+d*x])/(a+b)]/Sqrt[a+b*Sin[c+d*x]]*Int[1/Sqrt[a/(a+b)+b/(a+b)*Sin[c+d*x]],x] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && Not[PositiveQ[a+b]]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  -b*Cos[c+d*x]*(a+b*Sin[c+d*x])^(n+1)/(d*(n+1)*(a^2-b^2)) + 
  1/((n+1)*(a^2-b^2))*Int[(a+b*Sin[c+d*x])^(n+1)*Simp[a*(n+1)-b*(n+2)*Sin[c+d*x],x],x] /;
FreeQ[{a,b,c,d},x] && NeQ[a^2-b^2] && RationalQ[n] && n<-1 && IntegerQ[2*n]


Int[(a_+b_.*sin[c_.+d_.*x_])^n_,x_Symbol] :=
  Cos[c+d*x]/(d*Sqrt[1+Sin[c+d*x]]*Sqrt[1-Sin[c+d*x]])*Subst[Int[(a+b*x)^n/(Sqrt[1+x]*Sqrt[1-x]),x],x,Sin[c+d*x]] /;
FreeQ[{a,b,c,d,n},x] && NeQ[a^2-b^2] && Not[IntegerQ[2*n]]


Int[(a_+b_.*sin[c_.+d_.*x_]*cos[c_.+d_.*x_])^n_,x_Symbol] :=
  Int[(a+b*Sin[2*c+2*d*x]/2)^n,x] /;
FreeQ[{a,b,c,d,n},x]





(* ::Subsection::Closed:: *)
(*4.1.1.2 (g cos)^p (a+b sin)^m*)


Int[cos[e_.+f_.*x_]^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  1/(b^p*f)*Subst[Int[(a+x)^(m+(p-1)/2)*(a-x)^((p-1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m},x] && IntegerQ[(p-1)/2] && EqQ[a^2-b^2] && (p>=-1 || Not[IntegerQ[m+1/2] && EqQ[a^2-b^2]])


Int[cos[e_.+f_.*x_]^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  1/(b^p*f)*Subst[Int[(a+x)^m*(b^2-x^2)^((p-1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m},x] && IntegerQ[(p-1)/2] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)/(f*g*(p+1)) + a*Int[(g*Cos[e+f*x])^p,x] /;
FreeQ[{a,b,e,f,g,p},x] && (IntegerQ[2*p] || NeQ[a^2-b^2])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a/g)^(2*m)*Int[(g*Cos[e+f*x])^(2*m+p)/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && IntegerQ[m] && RationalQ[p] && p<-1 && 2*m+p>=0


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*m) /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && EqQ[Simplify[m+p+1]] && Not[NegativeIntegerQ[p]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*Simplify[2*m+p+1]) + 
  Simplify[m+p+1]/(a*Simplify[2*m+p+1])*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && NegativeIntegerQ[Simplify[m+p+1]] && NeQ[2*m+p+1] && Not[PositiveIntegerQ[m]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)/(f*g*(m-1)) /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && EqQ[2*m+p-1] && NeQ[m-1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)/(f*g*(m+p)) + 
  a*(2*m+p-1)/(m+p)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[Simplify[(2*m+p-1)/2]] && NeQ[m+p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*(p+1)) + 
  a*(m+p+1)/(g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[m,p] && m>0 && p<=-2*m && IntegersQ[m+1/2,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -2*b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)/(f*g*(p+1)) + 
  b^2*(2*m+p-1)/(g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-2),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[m,p] && m>1 && p<-1 && IntegersQ[2*m,2*p]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[g_.*cos[e_.+f_.*x_]],x_Symbol] :=
  a*Sqrt[1+Cos[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(a+a*Cos[e+f*x]+b*Sin[e+f*x])*Int[Sqrt[1+Cos[e+f*x]]/Sqrt[g*Cos[e+f*x]],x] + 
  b*Sqrt[1+Cos[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(a+a*Cos[e+f*x]+b*Sin[e+f*x])*Int[Sin[e+f*x]/(Sqrt[g*Cos[e+f*x]]*Sqrt[1+Cos[e+f*x]]),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)/(f*g*(m+p)) + 
  a*(2*m+p-1)/(m+p)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && RationalQ[m] && m>0 && NeQ[m+p] && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+p)) + 
  g^2*(p-1)/(a*(m+p))*Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[m,p] && m<-1 && p>1 && (m>-2 || EqQ[2*m+p+1] || m==-2 && IntegerQ[p]) && 
  NeQ[m+p] && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  2*g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)/(b*f*(2*m+p+1)) + 
  g^2*(p-1)/(b^2*(2*m+p+1))*Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^(m+2),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[m,p] && m<=-2 && p>1 && NeQ[2*m+p+1] && Not[NegativeIntegerQ[m+p+1]] && 
  IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*(2*m+p+1)) + 
  (m+p+1)/(a*(2*m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && RationalQ[m] && m<-1 && NeQ[2*m+p+1] && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)/(b*f*(p-1)) + g^2/a*Int[(g*Cos[e+f*x])^(p-2),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[p] && p>1 && IntegerQ[2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)/(a*f*g*(p-1)*(a+b*Sin[e+f*x])) + 
  p/(a*(p-1))*Int[(g*Cos[e+f*x])^p,x] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && Not[RationalQ[p] && p>=1] && IntegerQ[2*p]


Int[Sqrt[g_.*cos[e_.+f_.*x_]]/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  g*Sqrt[1+Cos[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(a+a*Cos[e+f*x]+b*Sin[e+f*x])*Int[Sqrt[1+Cos[e+f*x]]/Sqrt[g*Cos[e+f*x]],x] - 
  g*Sqrt[1+Cos[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(b+b*Cos[e+f*x]+a*Sin[e+f*x])*Int[Sin[e+f*x]/(Sqrt[g*Cos[e+f*x]]*Sqrt[1+Cos[e+f*x]]),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^(3/2)/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  g*Sqrt[g*Cos[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(b*f) + 
  g^2/(2*a)*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[g*Cos[e+f*x]],x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -2*b*(g*Cos[e+f*x])^(p+1)/(f*g*(2*p-1)*(a+b*Sin[e+f*x])^(3/2)) + 
  2*a*(p-2)/(2*p-1)*Int[(g*Cos[e+f*x])^p/(a+b*Sin[e+f*x])^(3/2),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[p] && p>2 && IntegerQ[2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)/(a*f*g*(p+1)*Sqrt[a+b*Sin[e+f*x]]) + 
  a*(2*p+1)/(2*g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)/(a+b*Sin[e+f*x])^(3/2),x] /;
FreeQ[{a,b,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[p] && p<-1 && IntegerQ[2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  a^m*(g*Cos[e+f*x])^(p+1)/(f*g*(1+Sin[e+f*x])^((p+1)/2)*(1-Sin[e+f*x])^((p+1)/2))*
    Subst[Int[(1+b/a*x)^(m+(p-1)/2)*(1-b/a*x)^((p-1)/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && IntegerQ[m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  a^2*(g*Cos[e+f*x])^(p+1)/(f*g*(a+b*Sin[e+f*x])^((p+1)/2)*(a-b*Sin[e+f*x])^((p+1)/2))*
    Subst[Int[(a+b*x)^(m+(p-1)/2)*(a-b*x)^((p-1)/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m*Sin[e+f*x]/(f*g*(p+1)) + 
  1/(g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1)*(a*(p+2)+b*(m+p+2)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m,p] && 0<m<1 && p<-1 && (IntegersQ[2*m,2*p] || IntegerQ[m])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(b+a*Sin[e+f*x])/(f*g*(p+1)) + 
  1/(g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-2)*(b^2*(m-1)+a^2*(p+2)+a*b*(m+p+1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m,p] && m>1 && p<-1 && (IntegersQ[2*m,2*p] || IntegerQ[m])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)/(f*g*(m+p)) + 
  1/(m+p)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-2)*(b^2*(m-1)+a^2*(m+p)+a*b*(2*m+p-1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,p},x] && NeQ[a^2-b^2] && RationalQ[m] && m>1 && NeQ[m+p] && (IntegersQ[2*m,2*p] || IntegerQ[m])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+1)) + 
  g^2*(p-1)/(b*(m+1))*Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^(m+1)*Sin[e+f*x],x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m,p] && m<-1 && p>1 && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(f*g*(a^2-b^2)*(m+1)) + 
  1/((a^2-b^2)*(m+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1)*(a*(m+1)-b*(m+p+2)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,p},x] && NeQ[a^2-b^2] && RationalQ[m] && m<-1 && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+p)) + 
  g^2*(p-1)/(b*(m+p))*Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^m*(b+a*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,m},x] && NeQ[a^2-b^2] && RationalQ[p] && p>1 && NeQ[m+p] && IntegersQ[2*m,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)*(b-a*Sin[e+f*x])/(f*g*(a^2-b^2)*(p+1)) + 
  1/(g^2*(a^2-b^2)*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m*(a^2*(p+2)-b^2*(m+p+2)+a*b*(m+p+3)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,m},x] && NeQ[a^2-b^2] && RationalQ[p] && p<-1 && IntegersQ[2*m,2*p]


Int[1/(Sqrt[g_.*cos[e_.+f_.*x_]]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  2*Sqrt[2]*Sqrt[g*Cos[e+f*x]]*Sqrt[(a+b*Sin[e+f*x])/((a-b)*(1-Sin[e+f*x]))]/
   (f*g*Sqrt[a+b*Sin[e+f*x]]*Sqrt[(1+Cos[e+f*x]+Sin[e+f*x])/(1+Cos[e+f*x]-Sin[e+f*x])])*
   Subst[Int[1/Sqrt[1+(a+b)*x^4/(a-b)],x],x,Sqrt[(1+Cos[e+f*x]+Sin[e+f*x])/(1+Cos[e+f*x]-Sin[e+f*x])]] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(1-Sin[e+f*x])*(a+b*Sin[e+f*x])^(m+1)*(-(a-b)*(1-Sin[e+f*x])/((a+b)*(1+Sin[e+f*x])))^(m/2)/
    (f*(a+b)*(m+1))*
    Hypergeometric2F1[m+1,m/2+1,m+2,2*(a+b*Sin[e+f*x])/((a+b)*(1+Sin[e+f*x]))] /;
FreeQ[{a,b,e,f,g,m,p},x] && NeQ[a^2-b^2] && EqQ[m+p+1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(f*g*(a-b)*(p+1)) + 
  a/(g^2*(a-b))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m/(1-Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && NeQ[a^2-b^2] && EqQ[m+p+2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(f*g*(a-b)*(p+1)) - 
  b*(m+p+2)/(g^2*(a-b)*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m,x] + 
  a/(g^2*(a-b))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m/(1-Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && NeQ[a^2-b^2] && NegativeIntegerQ[m+p+2]


Int[Sqrt[g_.*cos[e_.+f_.*x_]]/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  With[{q=Rt[-a^2+b^2,2]},
  a*g/(2*b)*Int[1/(Sqrt[g*Cos[e+f*x]]*(q+b*Cos[e+f*x])),x] - 
  a*g/(2*b)*Int[1/(Sqrt[g*Cos[e+f*x]]*(q-b*Cos[e+f*x])),x] + 
  b*g/f*Subst[Int[Sqrt[x]/(g^2*(a^2-b^2)+b^2*x^2),x],x,g*Cos[e+f*x]]] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[1/(Sqrt[g_.*cos[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  With[{q=Rt[-a^2+b^2,2]},
  -a/(2*q)*Int[1/(Sqrt[g*Cos[e+f*x]]*(q+b*Cos[e+f*x])),x] - 
  a/(2*q)*Int[1/(Sqrt[g*Cos[e+f*x]]*(q-b*Cos[e+f*x])),x] + 
  b*g/f*Subst[Int[1/(Sqrt[x]*(g^2*(a^2-b^2)+b^2*x^2)),x],x,g*Cos[e+f*x]]] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)/
    (b*f*(m+p)*(-b*(1-Sin[e+f*x])/(a+b*Sin[e+f*x]))^((p-1)/2)*(b*(1+Sin[e+f*x])/(a+b*Sin[e+f*x]))^((p-1)/2))*
  AppellF1[-p-m,(1-p)/2,(1-p)/2,1-p-m,(a+b)/(a+b*Sin[e+f*x]),(a-b)/(a+b*Sin[e+f*x])] /;
FreeQ[{a,b,e,f,g,p},x] && NeQ[a^2-b^2] && NegativeIntegerQ[m] && Not[PositiveIntegerQ[m+p+1]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)/(f*(1-(a+b*Sin[e+f*x])/(a-b))^((p-1)/2)*(1-(a+b*Sin[e+f*x])/(a+b))^((p-1)/2))*
    Subst[Int[(-b/(a-b)-b*x/(a-b))^((p-1)/2)*(b/(a+b)-b*x/(a+b))^((p-1)/2)*(a+b*x)^m,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,e,f,g,m,p},x] && NeQ[a^2-b^2] && Not[PositiveIntegerQ[m]]


Int[(g_.*sec[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  g^(2*IntPart[p])*(g*Cos[e+f*x])^FracPart[p]*(g*Sec[e+f*x])^FracPart[p]*Int[(a+b*Sin[e+f*x])^m/(g*Cos[e+f*x])^p,x] /;
FreeQ[{a,b,e,f,g,m,p},x] && Not[IntegerQ[p]]





(* ::Subsection::Closed:: *)
(*4.1.1.3 (g tan)^p (a+b sin)^m*)


Int[(g_.*tan[e_.+f_.*x_])^p_./(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  1/a*Int[Sec[e+f*x]^2*(g*Tan[e+f*x])^p,x] - 1/(b*g)*Int[Sec[e+f*x]*(g*Tan[e+f*x])^(p+1),x] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && NeQ[p+1]


Int[tan[e_.+f_.*x_]^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  1/f*Subst[Int[x^p*(a+x)^(m-(p+1)/2)/(a-x)^((p+1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && IntegerQ[(p+1)/2]


Int[tan[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  a^p*Int[Sin[e+f*x]^p/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && IntegersQ[m,p] && p==2*m


Int[tan[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a^p*Int[ExpandIntegrand[Sin[e+f*x]^p*(a+b*Sin[e+f*x])^(m-p/2)/(a-b*Sin[e+f*x])^(p/2),x],x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && IntegersQ[m,p/2] && (p<0 || m-p/2>0)


Int[(g_.*tan[e_.+f_.*x_])^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  Int[ExpandIntegrand[(g*Tan[e+f*x])^p,(a+b*Sin[e+f*x])^m,x],x] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[m]


Int[(g_.*tan[e_.+f_.*x_])^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a^(2*m)*Int[ExpandIntegrand[(g*Tan[e+f*x])^p*Sec[e+f*x]^(-m),(a*Sec[e+f*x]-b*Tan[e+f*x])^(-m),x],x] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && NegativeIntegerQ[m]


Int[tan[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(a+b*Sin[e+f*x])^m/(a*f*(2*m-1)*Cos[e+f*x]) - 
  1/(a^2*(2*m-1))*Int[(a+b*Sin[e+f*x])^(m+1)*(a*m-b*(2*m-1)*Sin[e+f*x])/Cos[e+f*x]^2,x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && RationalQ[m] && m<0


Int[tan[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -(a+b*Sin[e+f*x])^(m+1)/(b*f*m*Cos[e+f*x]) + 
  1/(b*m)*Int[(a+b*Sin[e+f*x])^m*(b*(m+1)+a*Sin[e+f*x])/Cos[e+f*x]^2,x] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && Not[RationalQ[m] && m<0]


Int[tan[e_.+f_.*x_]^4*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[(a+b*Sin[e+f*x])^m,x] - Int[(a+b*Sin[e+f*x])^m*(1-2*Sin[e+f*x]^2)/Cos[e+f*x]^4,x] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && IntegerQ[m-1/2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^2,x_Symbol] :=
  -(a+b*Sin[e+f*x])^(m+1)/(a*f*Tan[e+f*x]) + 
  1/b^2*Int[(a+b*Sin[e+f*x])^(m+1)*(b*m-a*(m+1)*Sin[e+f*x])/Sin[e+f*x],x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && IntegerQ[m-1/2] && m<-1


Int[(a_+b_.*sin[e_.+f_.*x_])^m_./tan[e_.+f_.*x_]^2,x_Symbol] :=
  -(a+b*Sin[e+f*x])^m/(f*Tan[e+f*x]) + 
  1/a*Int[(a+b*Sin[e+f*x])^m*(b*m-a*(m+1)*Sin[e+f*x])/Sin[e+f*x],x] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && IntegerQ[m-1/2] && Not[m<-1]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^4,x_Symbol] :=
  -2/(a*b)*Int[(a+b*Sin[e+f*x])^(m+2)/Sin[e+f*x]^3,x] + 
  1/a^2*Int[(a+b*Sin[e+f*x])^(m+2)*(1+Sin[e+f*x]^2)/Sin[e+f*x]^4,x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && IntegerQ[m-1/2] && m<-1


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^4,x_Symbol] :=
  Int[(a+b*Sin[e+f*x])^m,x] + Int[(a+b*Sin[e+f*x])^m*(1-2*Sin[e+f*x]^2)/Sin[e+f*x]^4,x] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && IntegerQ[m-1/2] && Not[m<-1]


Int[tan[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]]/(b*f*Cos[e+f*x])*
    Subst[Int[x^p*(a+x)^(m-(p+1)/2)/(a-x)^((p+1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && IntegerQ[p/2]


Int[(g_.*tan[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (g*Tan[e+f*x])^(p+1)*(a-b*Sin[e+f*x])^((p+1)/2)*(a+b*Sin[e+f*x])^((p+1)/2)/(f*g*(b*Sin[e+f*x])^(p+1))*
    Subst[Int[x^p*(a+x)^(m-(p+1)/2)/(a-x)^((p+1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && Not[IntegerQ[p]]


Int[tan[e_.+f_.*x_]^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  1/f*Subst[Int[(x^p*(a+x)^m)/(b^2-x^2)^((p+1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,m},x] && NeQ[a^2-b^2] && IntegerQ[(p+1)/2]


Int[(g_.*tan[e_.+f_.*x_])^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  Int[ExpandIntegrand[(g*Tan[e+f*x])^p,(a+b*Sin[e+f*x])^m,x],x] /;
FreeQ[{a,b,e,f,g,p},x] && NeQ[a^2-b^2] && PositiveIntegerQ[m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^2,x_Symbol] :=
  Int[(a+b*Sin[e+f*x])^m*(1-Sin[e+f*x]^2)/Sin[e+f*x]^2,x] /;
FreeQ[{a,b,e,f,m},x] && NeQ[a^2-b^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^4,x_Symbol] :=
  -Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(3*a*f*Sin[e+f*x]^3) - 
  (3*a^2+b^2*(m-2))*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(3*a^2*b*f*(m+1)*Sin[e+f*x]^2) - 
  1/(3*a^2*b*(m+1))*Int[(a+b*Sin[e+f*x])^(m+1)/Sin[e+f*x]^3*
    Simp[6*a^2-b^2*(m-1)*(m-2)+a*b*(m+1)*Sin[e+f*x]-(3*a^2-b^2*m*(m-2))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,e,f},x] && NeQ[a^2-b^2] && RationalQ[m] && m<-1 && IntegerQ[2*m]


(* Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^4,x_Symbol] :=
  -Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(3*a*f*Sin[e+f*x]^3) - 
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*m*Sin[e+f*x]^2) - 
  1/(3*a*b*m)*Int[(a+b*Sin[e+f*x])^m/Sin[e+f*x]^3*
    Simp[6*a^2-b^2*m*(m-2)+a*b*(m+3)*Sin[e+f*x]-(3*a^2-b^2*m*(m-1))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,e,f,m},x] && NeQ[a^2-b^2] && Not[RationalQ[m] && m<-1] && IntegerQ[2*m] *)


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^4,x_Symbol] :=
  -Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(3*a*f*Sin[e+f*x]^3) - 
  b*(m-2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(6*a^2*f*Sin[e+f*x]^2) - 
  1/(6*a^2)*Int[(a+b*Sin[e+f*x])^m/Sin[e+f*x]^2*
    Simp[8*a^2-b^2*(m-1)*(m-2)+a*b*m*Sin[e+f*x]-(6*a^2-b^2*m*(m-2))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,e,f,m},x] && NeQ[a^2-b^2] && Not[RationalQ[m] && m<-1] && IntegerQ[2*m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_/tan[e_.+f_.*x_]^6,x_Symbol] :=
  -Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(5*a*f*Sin[e+f*x]^5) - 
  b*(m-4)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(20*a^2*f*Sin[e+f*x]^4) + 
  a*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b^2*f*m*(m-1)*Sin[e+f*x]^3) + 
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*m*Sin[e+f*x]^2) + 
  1/(20*a^2*b^2*m*(m-1))*Int[(a+b*Sin[e+f*x])^m/Sin[e+f*x]^4*
    Simp[60*a^4-44*a^2*b^2*(m-1)*m+b^4*m*(m-1)*(m-3)*(m-4)+a*b*m*(20*a^2-b^2*m*(m-1))*Sin[e+f*x]-
      (40*a^4+b^4*m*(m-1)*(m-2)*(m-4)-20*a^2*b^2*(m-1)*(2*m+1))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,e,f,m},x] && NeQ[a^2-b^2] && NeQ[m-1] && IntegerQ[2*m]


Int[(g_.*tan[e_.+f_.*x_])^p_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  a/(a^2-b^2)*Int[(g*Tan[e+f*x])^p/Sin[e+f*x]^2,x] - 
  b*g/(a^2-b^2)*Int[(g*Tan[e+f*x])^(p-1)/Cos[e+f*x],x] - 
  a^2*g^2/(a^2-b^2)*Int[(g*Tan[e+f*x])^(p-2)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*p] && p>1


Int[(g_.*tan[e_.+f_.*x_])^p_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  1/a*Int[(g*Tan[e+f*x])^p/Cos[e+f*x]^2,x] - 
  b/(a^2*g)*Int[(g*Tan[e+f*x])^(p+1)/Cos[e+f*x],x] - 
  (a^2-b^2)/(a^2*g^2)*Int[(g*Tan[e+f*x])^(p+2)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*p] && p<-1


Int[Sqrt[g_.*tan[e_.+f_.*x_]]/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  Sqrt[Cos[e+f*x]]*Sqrt[g*Tan[e+f*x]]/Sqrt[Sin[e+f*x]]*Int[Sqrt[Sin[e+f*x]]/(Sqrt[Cos[e+f*x]]*(a+b*Sin[e+f*x])),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[1/(Sqrt[g_*tan[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  Sqrt[Sin[e+f*x]]/(Sqrt[Cos[e+f*x]]*Sqrt[g*Tan[e+f*x]])*Int[Sqrt[Cos[e+f*x]]/(Sqrt[Sin[e+f*x]]*(a+b*Sin[e+f*x])),x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[tan[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[ExpandIntegrand[Sin[e+f*x]^p*(a+b*Sin[e+f*x])^m/(1-Sin[e+f*x]^2)^(p/2),x],x] /;
FreeQ[{a,b,e,f},x] && NeQ[a^2-b^2] && IntegersQ[m,p/2]


Int[(g_.*tan[e_.+f_.*x_])^p_.*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  Defer[Int][(g*Tan[e+f*x])^p*(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,e,f,g,m,p},x]


Int[(g_.*cot[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.,x_Symbol] :=
  g^(2*IntPart[p])*(g*Cot[e+f*x])^FracPart[p]*(g*Tan[e+f*x])^FracPart[p]*Int[(a+b*Sin[e+f*x])^m/(g*Tan[e+f*x])^p,x] /;
FreeQ[{a,b,e,f,g,m,p},x] && Not[IntegerQ[p]]





(* ::Subsection::Closed:: *)
(*4.1.2.1 (a+b sin)^m (c+d sin)^n*)


Int[(a_+b_.*sin[e_.+f_.*x_])*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  (2*a*c+b*d)*x/2 - (b*c+a*d)*Cos[e+f*x]/f - b*d*Cos[e+f*x]*Sin[e+f*x]/(2*f) /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d]


Int[(a_.+b_.*sin[e_.+f_.*x_])/(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  b*x/d - (b*c-a*d)/d*Int[1/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^m*c^m*Int[Cos[e+f*x]^(2*m)*(c+d*Sin[e+f*x])^(n-m),x] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && IntegerQ[m] && Not[IntegerQ[n] && (m<0 && n>0 || 0<n<m || m<n<0)]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[c_+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  a*c*Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])*Int[Cos[e+f*x]/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -2*b*Cos[e+f*x]*(c+d*Sin[e+f*x])^n/(f*(2*n+1)*Sqrt[a+b*Sin[e+f*x]]) /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && NeQ[n+1/2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -2*b*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*(2*n+1)) - 
  b*(2*m-1)/(d*(2*n+1))*Int[(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && PositiveIntegerQ[m-1/2] && RationalQ[n] && n<-1 && 
  Not[NegativeIntegerQ[m+n] && 2*m+n+1>0]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*(m+n)) + 
  a*(2*m-1)/(m+n)*Int[(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && PositiveIntegerQ[m-1/2] && Not[RationalQ[n] && n<-1] && 
  Not[PositiveIntegerQ[n-1/2] && n<m] && Not[NegativeIntegerQ[m+n] && 2*m+n+1>0]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])*Int[1/Cos[e+f*x],x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*(2*m+1)) /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[m+n+1] && NeQ[m+1/2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*(2*m+1)) + 
  (m+n+1)/(a*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && NegativeIntegerQ[Simplify[m+n+1]] && NeQ[m+1/2] && 
  (SumSimplerQ[m,1] || Not[SumSimplerQ[n,1]])


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*(2*m+1)) + 
  (m+n+1)/(a*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && RationalQ[m] && m<-1 && 
  Not[RationalQ[n] && m<n<-1] && IntegersQ[2*m,2*n]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^IntPart[m]*c^IntPart[m]*(a+b*Sin[e+f*x])^FracPart[m]*(c+d*Sin[e+f*x])^FracPart[m]/Cos[e+f*x]^(2*FracPart[m])*
    Int[Cos[e+f*x]^(2*m)*(c+d*Sin[e+f*x])^(n-m),x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && (FractionQ[m] || Not[FractionQ[n]])


Int[(a_.+b_.*sin[e_.+f_.*x_])^2/(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -b^2*Cos[e+f*x]/(d*f) + 1/d*Int[Simp[a^2*d-b*(b*c-2*a*d)*Sin[e+f*x],x]/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d]


Int[1/((a_.+b_.*sin[e_.+f_.*x_])*(c_.+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  b/(b*c-a*d)*Int[1/(a+b*Sin[e+f*x]),x] - d/(b*c-a*d)*Int[1/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d]


Int[(b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  c*Int[(b*Sin[e+f*x])^m,x] + d/b*Int[(b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{b,c,d,e,f,m},x]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*Cos[e+f*x]*(a+b*Sin[e+f*x])^m/(f*(m+1)) /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && EqQ[a*d*m+b*c*(m+1)]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  (b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^m/(a*f*(2*m+1)) + 
  (a*d*m+b*c*(m+1))/(a*b*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && RationalQ[m] && m<-1/2


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*Cos[e+f*x]*(a+b*Sin[e+f*x])^m/(f*(m+1)) + 
  (a*d*m+b*c*(m+1))/(b*(m+1))*Int[(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && Not[RationalQ[m] && m<-1/2]


Int[(c_.+d_.*sin[e_.+f_.*x_])/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  (b*c-a*d)/b*Int[1/Sqrt[a+b*Sin[e+f*x]],x] + d/b*Int[Sqrt[a+b*Sin[e+f*x]],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*Cos[e+f*x]*(a+b*Sin[e+f*x])^m/(f*(m+1)) + 
  1/(m+1)*Int[(a+b*Sin[e+f*x])^(m-1)*Simp[b*d*m+a*c*(m+1)+(a*d*m+b*c*(m+1))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && RationalQ[m] && m>0 && IntegerQ[2*m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -(b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(f*(m+1)*(a^2-b^2)) + 
  1/((m+1)*(a^2-b^2))*Int[(a+b*Sin[e+f*x])^(m+1)*Simp[(a*c-b*d)*(m+1)-(b*c-a*d)*(m+2)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && RationalQ[m] && m<-1 && IntegerQ[2*m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  c*Cos[e+f*x]/(f*Sqrt[1+Sin[e+f*x]]*Sqrt[1-Sin[e+f*x]])*Subst[Int[(a+b*x)^m*Sqrt[1+d/c*x]/Sqrt[1-d/c*x],x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && Not[IntegerQ[2*m]] && EqQ[c^2-d^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  (b*c-a*d)/b*Int[(a+b*Sin[e+f*x])^m,x] + d/b*Int[(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_.*(d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  Int[ExpandTrig[(a+b*sin[e+f*x])^m*(d*sin[e+f*x])^n,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && EqQ[a^2-b^2] && PositiveIntegerQ[m] && RationalQ[n]


Int[sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*Cos[e+f*x]*(a+b*Sin[e+f*x])^m/(a*f*(2*m+1)) - 
  1/(a^2*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*(a*m-b*(2*m+1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f},x] && EqQ[a^2-b^2] && RationalQ[m] && m<-1/2


Int[sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+2)) + 
  1/(b*(m+2))*Int[(a+b*Sin[e+f*x])^m*(b*(m+1)-a*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,m},x] && EqQ[a^2-b^2] && Not[RationalQ[m] && m<-1/2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^2,x_Symbol] :=
  (b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])/(a*f*(2*m+1)) + 
  1/(a*b*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*Simp[a*c*d*(m-1)+b*(d^2+c^2*(m+1))+d*(a*d*(m-1)+b*c*(m+2))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && RationalQ[m] && m<-1


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^2,x_Symbol] :=
  -d^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+2)) + 
  1/(b*(m+2))*Int[(a+b*Sin[e+f*x])^m*Simp[b*(d^2*(m+1)+c^2*(m+2))-d*(a*d-2*b*c*(m+2))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && Not[RationalQ[m] && m<-1]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^2*(b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n+1)/(d*f*(n+1)*(b*c+a*d)) + 
  b^2/(d*(n+1)*(b*c+a*d))*Int[(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n+1)*
    Simp[a*c*(m-2)-b*d*(m-2*n-4)-(b*c*(m-1)-a*d*(m+2*n+1))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m>1 && n<-1 && 
  (IntegersQ[2*m,2*n] || IntegerQ[m+1/2] || IntegerQ[m] && EqQ[c])


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n+1)/(d*f*(m+n)) + 
  1/(d*(m+n))*Int[(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^n*
    Simp[a*b*c*(m-2)+b^2*d*(n+1)+a^2*d*(m+n)-b*(b*c*(m-1)-a*d*(3*m+2*n-2))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m] && m>1 && 
  Not[RationalQ[n] && n<-1] && (IntegersQ[2*m,2*n] || IntegerQ[m+1/2] || IntegerQ[m] && EqQ[c])


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*(2*m+1)) - 
  1/(a*b*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n-1)*Simp[a*d*n-b*c*(m+1)-b*d*(m+n+1)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m<-1 && 0<n<1 && 
  (IntegersQ[2*m,2*n] || IntegerQ[m] && EqQ[c])


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  (b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^(n-1)/(a*f*(2*m+1)) + 
  1/(a*b*(2*m+1))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n-2)*
    Simp[b*(c^2*(m+1)+d^2*(n-1))+a*c*d*(m-n+1)+d*(a*d*(m-n+1)+b*c*(m+n))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m<-1 && n>1 && 
  (IntegersQ[2*m,2*n] || IntegerQ[m] && EqQ[c])


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^(n+1)/(a*f*(2*m+1)*(b*c-a*d)) + 
  1/(a*(2*m+1)*(b*c-a*d))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n*
    Simp[b*c*(m+1)-a*d*(2*m+n+2)+b*d*(m+n+2)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m] && m<-1 && 
  Not[RationalQ[n] && n>0] && (IntegersQ[2*m,2*n] || IntegerQ[m] && EqQ[c])


Int[(c_.+d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -(b*c-a*d)*Cos[e+f*x]*(c+d*Sin[e+f*x])^(n-1)/(a*f*(a+b*Sin[e+f*x])) - 
  d/(a*b)*Int[(c+d*Sin[e+f*x])^(n-2)*Simp[b*d*(n-1)-a*c*n+(b*c*(n-1)-a*d*n)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n>1 && 
  (IntegerQ[2*n] || EqQ[c])


Int[(c_.+d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -b^2*Cos[e+f*x]*(c+d*Sin[e+f*x])^(n+1)/(a*f*(b*c-a*d)*(a+b*Sin[e+f*x])) + 
  d/(a*(b*c-a*d))*Int[(c+d*Sin[e+f*x])^n*(a*n-b*(n+1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n<0 && (IntegerQ[2*n] || EqQ[c])


Int[(c_.+d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -b*Cos[e+f*x]*(c+d*Sin[e+f*x])^n/(a*f*(a+b*Sin[e+f*x])) + 
  d*n/(a*b)*Int[(c+d*Sin[e+f*x])^(n-1)*(a-b*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && (IntegerQ[2*n] || EqQ[c])


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -2*b*Cos[e+f*x]*(c+d*Sin[e+f*x])^n/(f*(2*n+1)*Sqrt[a+b*Sin[e+f*x]]) + 
  2*n*(b*c+a*d)/(b*(2*n+1))*Int[Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])^(n-1),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n>0 && IntegerQ[2*n]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(c_.+d_.*sin[e_.+f_.*x_])^(3/2),x_Symbol] :=
  -2*b^2*Cos[e+f*x]/(f*(b*c+a*d)*Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]) /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  (b*c-a*d)*Cos[e+f*x]*(c+d*Sin[e+f*x])^(n+1)/(f*(n+1)*(c^2-d^2)*Sqrt[a+b*Sin[e+f*x]]) + 
  (2*n+3)*(b*c-a*d)/(2*b*(n+1)*(c^2-d^2))*Int[Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n<-1 && NeQ[2*n+3] && IntegerQ[2*n]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -2*b/f*Subst[Int[1/(b*c+a*d-d*x^2),x],x,b*Cos[e+f*x]/Sqrt[a+b*Sin[e+f*x]]] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -2/f*Subst[Int[1/Sqrt[1-x^2/a],x],x,b*Cos[e+f*x]/Sqrt[a+b*Sin[e+f*x]]] /;
FreeQ[{a,b,d,e,f},x] && EqQ[a^2-b^2] && EqQ[d-a/b]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[c_.+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -2*b/f*Subst[Int[1/(b+d*x^2),x],x,b*Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^2*Cos[e+f*x]/(f*Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]])*Subst[Int[(c+d*x)^n/Sqrt[a-b*x],x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && Not[IntegerQ[2*n]]


Int[Sqrt[c_.+d_.*sin[e_.+f_.*x_]]/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  d/b*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]],x] + 
  (b*c-a*d)/b*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(c_.+d_.*sin[e_.+f_.*x_])^n_/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -2*d*Cos[e+f*x]*(c+d*Sin[e+f*x])^(n-1)/(f*(2*n-1)*Sqrt[a+b*Sin[e+f*x]]) - 
  1/(b*(2*n-1))*Int[(c+d*Sin[e+f*x])^(n-2)/Sqrt[a+b*Sin[e+f*x]]*
    Simp[a*c*d-b*(2*d^2*(n-1)+c^2*(2*n-1))+d*(a*d-b*c*(4*n-3))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n>1 && IntegerQ[2*n]


Int[(c_.+d_.*sin[e_.+f_.*x_])^n_/Sqrt[a_+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -d*Cos[e+f*x]*(c+d*Sin[e+f*x])^(n+1)/(f*(n+1)*(c^2-d^2)*Sqrt[a+b*Sin[e+f*x]]) - 
  1/(2*b*(n+1)*(c^2-d^2))*Int[(c+d*Sin[e+f*x])^(n+1)*Simp[a*d-2*b*c*(n+1)+b*d*(2*n+3)*Sin[e+f*x],x]/Sqrt[a+b*Sin[e+f*x]],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n<-1 && IntegerQ[2*n]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_.+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  b/(b*c-a*d)*Int[1/Sqrt[a+b*Sin[e+f*x]],x] - d/(b*c-a*d)*Int[Sqrt[a+b*Sin[e+f*x]]/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -Sqrt[2]/(Sqrt[a]*f)*Subst[Int[1/Sqrt[1-x^2],x],x,b*Cos[e+f*x]/(a+b*Sin[e+f*x])] /;
FreeQ[{a,b,d,e,f},x] && EqQ[a^2-b^2] && EqQ[d-a/b] && PositiveQ[a]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_.+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*a/f*Subst[Int[1/(2*b^2-(a*c-b*d)*x^2),x],x,b*Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -d*Cos[e+f*x]*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^(n-1)/(f*(m+n)) + 
  1/(b*(m+n))*Int[(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^(n-2)*
    Simp[d*(a*c*m+b*d*(n-1))+b*c^2*(m+n)+d*(a*d*m+b*c*(m+2*n-1))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[n] && n>1 && IntegerQ[n]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^m*Cos[e+f*x]/(f*Sqrt[1+Sin[e+f*x]]*Sqrt[1-Sin[e+f*x]])*Subst[Int[(1+b/a*x)^(m-1/2)*(c+d*x)^n/Sqrt[1-b/a*x],x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && IntegerQ[m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*(d/b)^n*Cos[e+f*x]/(f*Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]])*
    Subst[Int[(a-x)^n*(2*a-x)^(m-1/2)/Sqrt[x],x],x,a-b*Sin[e+f*x]] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && PositiveQ[a] && PositiveQ[d/b]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  (d/b)^IntPart[n]*(d*Sin[e+f*x])^FracPart[n]/(b*Sin[e+f*x])^FracPart[n]*Int[(a+b*Sin[e+f*x])^m*(b*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && PositiveQ[a] && Not[PositiveQ[d/b]]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^IntPart[m]*(a+b*Sin[e+f*x])^FracPart[m]/(1+b/a*Sin[e+f*x])^FracPart[m]*
    Int[(1+b/a*Sin[e+f*x])^m*(d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]] && Not[PositiveQ[a]]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^2*Cos[e+f*x]/(f*Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]])*Subst[Int[(a+b*x)^(m-1/2)*(c+d*x)^n/Sqrt[a-b*x],x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && Not[IntegerQ[m]]


Int[(b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^2,x_Symbol] :=
  2*c*d/b*Int[(b*Sin[e+f*x])^(m+1),x] + Int[(b*Sin[e+f*x])^m*(c^2+d^2*Sin[e+f*x]^2),x] /;
FreeQ[{b,c,d,e,f,m},x]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^2,x_Symbol] :=
  -(b^2*c^2-2*a*b*c*d+a^2*d^2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+1)*(a^2-b^2)) - 
  1/(b*(m+1)*(a^2-b^2))*Int[(a+b*Sin[e+f*x])^(m+1)*
    Simp[b*(m+1)*(2*b*c*d-a*(c^2+d^2))+(a^2*d^2-2*a*b*c*d*(m+2)+b^2*(d^2*(m+1)+c^2*(m+2)))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && RationalQ[m] && m<-1


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^2,x_Symbol] :=
  -d^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b*f*(m+2)) + 
  1/(b*(m+2))*Int[(a+b*Sin[e+f*x])^m*Simp[b*(d^2*(m+1)+c^2*(m+2))-d*(a*d-2*b*c*(m+2))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,m},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && Not[RationalQ[m] && m<-1]


(* Int[(a_+b_.*sin[e_.+f_.*x_])^m_.*(d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  Int[ExpandTrig[(a+b*sin[e+f*x])^m*(d*sin[e+f*x])^n,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && NeQ[a^2-b^2] && PositiveIntegerQ[m] *)


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -(b^2*c^2-2*a*b*c*d+a^2*d^2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n+1)/(d*f*(n+1)*(c^2-d^2)) + 
  1/(d*(n+1)*(c^2-d^2))*Int[(a+b*Sin[e+f*x])^(m-3)*(c+d*Sin[e+f*x])^(n+1)*
    Simp[b*(m-2)*(b*c-a*d)^2+a*d*(n+1)*(c*(a^2+b^2)-2*a*b*d)+
      (b*(n+1)*(a*b*c^2+c*d*(a^2+b^2)-3*a*b*d^2)-a*(n+2)*(b*c-a*d)^2)*Sin[e+f*x]+
      b*(b^2*(c^2-d^2)-m*(b*c-a*d)^2+d*n*(2*a*b*c-d*(a^2+b^2)))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m>2 && n<-1 && 
  (IntegerQ[m] || IntegersQ[2*m,2*n])


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n+1)/(d*f*(m+n)) + 
  1/(d*(m+n))*Int[(a+b*Sin[e+f*x])^(m-3)*(c+d*Sin[e+f*x])^n*
    Simp[a^3*d*(m+n)+b^2*(b*c*(m-2)+a*d*(n+1))-
      b*(a*b*c-b^2*d*(m+n-1)-3*a^2*d*(m+n))*Sin[e+f*x]-
      b^2*(b*c*(m-1)-a*d*(3*m+2*n-2))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m] && m>2 && 
  (IntegerQ[m] || IntegersQ[2*m,2*n]) && Not[IntegerQ[n] && n>2 && (Not[IntegerQ[m]] || EqQ[a] && NeQ[c])]


Int[Sqrt[d_.*sin[e_.+f_.*x_]]/(a_+b_.*sin[e_.+f_.*x_])^(3/2),x_Symbol] :=
  -2*a*d*Cos[e+f*x]/(f*(a^2-b^2)*Sqrt[a+b*Sin[e+f*x]]*Sqrt[d*Sin[e+f*x]]) - 
  d^2/(a^2-b^2)*Int[Sqrt[a+b*Sin[e+f*x]]/(d*Sin[e+f*x])^(3/2),x] /; 
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2]


Int[Sqrt[c_+d_.*sin[e_.+f_.*x_]]/(a_.+b_.*sin[e_.+f_.*x_])^(3/2),x_Symbol] :=
  (c-d)/(a-b)*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] - 
  (b*c-a*d)/(a-b)*Int[(1+Sin[e+f*x])/((a+b*Sin[e+f*x])^(3/2)*Sqrt[c+d*Sin[e+f*x]]),x] /; 
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n/(f*(m+1)*(a^2-b^2)) + 
  1/((m+1)*(a^2-b^2))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n-1)*
    Simp[a*c*(m+1)+b*d*n+(a*d*(m+1)-b*c*(m+2))*Sin[e+f*x]-b*d*(m+n+2)*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m<-1 && 0<n<1 && 
  IntegersQ[2*m,2*n]


Int[(d_.*sin[e_.+f_.*x_])^(3/2)/(a_+b_.*sin[e_.+f_.*x_])^(3/2),x_Symbol] :=
  d/b*Int[Sqrt[d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]],x] - 
  a*d/b*Int[Sqrt[d*Sin[e+f*x]]/(a+b*Sin[e+f*x])^(3/2),x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2]


Int[(c_+d_.*sin[e_.+f_.*x_])^(3/2)/(a_.+b_.*sin[e_.+f_.*x_])^(3/2),x_Symbol] :=
  d^2/b^2*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]],x] + 
  (b*c-a*d)/b^2*Int[Simp[b*c+a*d+2*b*d*Sin[e+f*x],x]/((a+b*Sin[e+f*x])^(3/2)*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -(b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n-1)/(f*(m+1)*(a^2-b^2)) + 
  1/((m+1)*(a^2-b^2))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n-2)*
    Simp[c*(a*c-b*d)*(m+1)+d*(b*c-a*d)*(n-1)+(d*(a*c-b*d)*(m+1)-c*(b*c-a*d)*(m+2))*Sin[e+f*x]-d*(b*c-a*d)*(m+n+1)*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && m<-1 && 1<n<2 && 
  IntegersQ[2*m,2*n]


Int[1/((a_+b_.*sin[e_.+f_.*x_])^(3/2)*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  2*b*Cos[e+f*x]/(f*(a^2-b^2)*Sqrt[a+b*Sin[e+f*x]]*Sqrt[d*Sin[e+f*x]]) + 
  d/(a^2-b^2)*Int[(b+a*Sin[e+f*x])/(Sqrt[a+b*Sin[e+f*x]]*(d*Sin[e+f*x])^(3/2)),x] /; 
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2]


Int[1/((a_.+b_.*sin[e_.+f_.*x_])^(3/2)*Sqrt[c_.+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  1/(a-b)*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] - 
  b/(a-b)*Int[(1+Sin[e+f*x])/((a+b*Sin[e+f*x])^(3/2)*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b^2*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^(n+1)/(f*(m+1)*(b*c-a*d)*(a^2-b^2)) + 
  1/((m+1)*(b*c-a*d)*(a^2-b^2))*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n*
    Simp[a*(b*c-a*d)*(m+1)+b^2*d*(m+n+2)-(b^2*c+b*(b*c-a*d)*(m+1))*Sin[e+f*x]-b^2*d*(m+n+3)*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m] && m<-1 && 
  IntegersQ[2*m,2*n] && 
  (EqQ[a] && IntegerQ[m] && Not[IntegerQ[n]] || Not[IntegerQ[2*n] && n<-1 && (IntegerQ[n] && Not[IntegerQ[m]] || EqQ[a])])


Int[Sqrt[c_.+d_.*sin[e_.+f_.*x_]]/(a_.+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  d/b*Int[1/Sqrt[c+d*Sin[e+f*x]],x] + 
  (b*c-a*d)/b*Int[1/((a+b*Sin[e+f*x])*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[(a_.+b_.*sin[e_.+f_.*x_])^(3/2)/(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  b/d*Int[Sqrt[a+b*Sin[e+f*x]],x] - (b*c-a*d)/d*Int[Sqrt[a+b*Sin[e+f*x]]/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[1/((a_.+b_.*sin[e_.+f_.*x_])*Sqrt[c_.+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  2/(f*(a+b)*Sqrt[c+d])*EllipticPi[2*b/(a+b),1/2*(e-Pi/2+f*x),2*d/(c+d)] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && PositiveQ[c+d]


Int[1/((a_.+b_.*sin[e_.+f_.*x_])*Sqrt[c_.+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  2/(f*(a-b)*Sqrt[c-d])*EllipticPi[-2*b/(a-b),1/2*(e+Pi/2+f*x),-2*d/(c-d)] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && PositiveQ[c-d]


Int[1/((a_.+b_.*sin[e_.+f_.*x_])*Sqrt[c_.+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Sqrt[(c+d*Sin[e+f*x])/(c+d)]/Sqrt[c+d*Sin[e+f*x]]*Int[1/((a+b*Sin[e+f*x])*Sqrt[c/(c+d)+d/(c+d)*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && Not[PositiveQ[c+d]]


Int[Sqrt[b_.*sin[e_.+f_.*x_]]/Sqrt[c_+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  2*c*Rt[b*(c+d),2]*Tan[e+f*x]*Sqrt[1+Csc[e+f*x]]*Sqrt[1-Csc[e+f*x]]/(d*f*Sqrt[c^2-d^2])*
    EllipticPi[(c+d)/d,ArcSin[Sqrt[c+d*Sin[e+f*x]]/Sqrt[b*Sin[e+f*x]]/Rt[(c+d)/b,2]],-(c+d)/(c-d)] /;
FreeQ[{b,c,d,e,f},x] && PositiveQ[c^2-d^2] && PosQ[(c+d)/b] && PositiveQ[c^2]


Int[Sqrt[b_.*sin[e_.+f_.*x_]]/Sqrt[c_+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  2*b*Tan[e+f*x]/(d*f)*Rt[(c+d)/b,2]*Sqrt[c*(1+Csc[e+f*x])/(c-d)]*Sqrt[c*(1-Csc[e+f*x])/(c+d)]*
    EllipticPi[(c+d)/d,ArcSin[Sqrt[c+d*Sin[e+f*x]]/Sqrt[b*Sin[e+f*x]]/Rt[(c+d)/b,2]],-(c+d)/(c-d)] /;
FreeQ[{b,c,d,e,f},x] && NeQ[c^2-d^2] && PosQ[(c+d)/b]


Int[Sqrt[b_.*sin[e_.+f_.*x_]]/Sqrt[c_+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  Sqrt[b*Sin[e+f*x]]/Sqrt[-b*Sin[e+f*x]]*Int[Sqrt[-b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]],x] /;
FreeQ[{b,c,d,e,f},x] && NeQ[c^2-d^2] && NegQ[(c+d)/b]


(* Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  a*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[d*Sin[e+f*x]]),x] + 
  b/d*Int[Sqrt[d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]],x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] *)


(* Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  2*(a+b*Sin[e+f*x])/(d*f*Rt[(a+b)/d,2]*Cos[e+f*x])*Sqrt[a*(1-Sin[e+f*x])/(a+b*Sin[e+f*x])]*Sqrt[a*(1+Sin[e+f*x])/(a+b*Sin[e+f*x])]*
    EllipticPi[b/(a+b),ArcSin[Rt[(a+b)/d,2]*(Sqrt[d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]])],-(a-b)/(a+b)] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && PosQ[(a+b)/d] *)


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[c_.+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  2*(a+b*Sin[e+f*x])/(d*f*Rt[(a+b)/(c+d),2]*Cos[e+f*x])*
    Sqrt[(b*c-a*d)*(1+Sin[e+f*x])/((c-d)*(a+b*Sin[e+f*x]))]*
    Sqrt[-(b*c-a*d)*(1-Sin[e+f*x])/((c+d)*(a+b*Sin[e+f*x]))]*
    EllipticPi[b*(c+d)/(d*(a+b)),ArcSin[Rt[(a+b)/(c+d),2]*Sqrt[c+d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]]],(a-b)*(c+d)/((a+b)*(c-d))] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && PosQ[(a+b)/(c+d)]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/Sqrt[c_.+d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  Sqrt[-c-d*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]]*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[-c-d*Sin[e+f*x]],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && NegQ[(a+b)/(c+d)]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*d/(f*Sqrt[a+b*d])*EllipticF[ArcSin[Cos[e+f*x]/(1+d*Sin[e+f*x])],-(a-b*d)/(a+b*d)] /;
FreeQ[{a,b,d,e,f},x] && NegativeQ[a^2-b^2] && EqQ[d^2-1] && PositiveQ[b*d]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Sqrt[Sign[b]*Sin[e+f*x]]/Sqrt[d*Sin[e+f*x]]*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[Sign[b]*Sin[e+f*x]]),x] /;
FreeQ[{a,b,d,e,f},x] && NegativeQ[a^2-b^2] && PositiveQ[b^2] && Not[EqQ[d^2-1] && PositiveQ[b*d]]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*Sqrt[a^2]*Sqrt[-Cot[e+f*x]^2]/(a*f*Sqrt[a^2-b^2]*Cot[e+f*x])*Rt[(a+b)/d,2]*
    EllipticF[ArcSin[Sqrt[a+b*Sin[e+f*x]]/Sqrt[d*Sin[e+f*x]]/Rt[(a+b)/d,2]],-(a+b)/(a-b)] /;
FreeQ[{a,b,d,e,f},x] && PositiveQ[a^2-b^2] && PosQ[(a+b)/d] && PositiveQ[a^2]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*Tan[e+f*x]/(a*f)*Rt[(a+b)/d,2]*Sqrt[a*(1-Csc[e+f*x])/(a+b)]*Sqrt[a*(1+Csc[e+f*x])/(a-b)]*
    EllipticF[ArcSin[Sqrt[a+b*Sin[e+f*x]]/Sqrt[d*Sin[e+f*x]]/Rt[(a+b)/d,2]],-(a+b)/(a-b)] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && PosQ[(a+b)/d]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Sqrt[-d*Sin[e+f*x]]/Sqrt[d*Sin[e+f*x]]*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[-d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && NegQ[(a+b)/d]


Int[1/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  2*(c+d*Sin[e+f*x])/(f*(b*c-a*d)*Rt[(c+d)/(a+b),2]*Cos[e+f*x])*
    Sqrt[(b*c-a*d)*(1-Sin[e+f*x])/((a+b)*(c+d*Sin[e+f*x]))]*
    Sqrt[-(b*c-a*d)*(1+Sin[e+f*x])/((a-b)*(c+d*Sin[e+f*x]))]*
    EllipticF[ArcSin[Rt[(c+d)/(a+b),2]*(Sqrt[a+b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]])],(a+b)*(c-d)/((a-b)*(c+d))] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && PosQ[(c+d)/(a+b)]


Int[1/(Sqrt[a_.+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Sqrt[-a-b*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]]*Int[1/(Sqrt[-a-b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && NegQ[(c+d)/(a+b)]


Int[(d_.*sin[e_.+f_.*x_])^(3/2)/Sqrt[a_.+b_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -a*d/(2*b)*Int[Sqrt[d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]],x] + 
  d/(2*b)*Int[Sqrt[d*Sin[e+f*x]]*(a+2*b*Sin[e+f*x])/Sqrt[a+b*Sin[e+f*x]],x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2]


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*(m+n)) + 
  1/(d*(m+n))*Int[(a+b*Sin[e+f*x])^(m-2)*(c+d*Sin[e+f*x])^(n-1)*
    Simp[a^2*c*d*(m+n)+b*d*(b*c*(m-1)+a*d*n)+
      (a*d*(2*b*c+a*d)*(m+n)-b*d*(a*c-b*d*(m+n-1)))*Sin[e+f*x]+
      b*d*(b*c*n+a*d*(2*m+n-1))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2] && RationalQ[m,n] && 0<m<2 && -1<n<2 && 
  NeQ[m+n] && (IntegerQ[m] || IntegersQ[2*m,2*n])


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b/d*Int[(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^(n+1),x] - 
  (b*c-a*d)/d*Int[(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && NeQ[b*c-a*d] && PositiveIntegerQ[m]


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Defer[Int][(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


(* Int[(a_.+b_.*sin[e_.+f_.*x_])^m_.*(d_./sin[e_.+f_.*x_])^n_,x_Symbol] :=
  d^m*Int[(d*Csc[e+f*x])^(n-m)*(b+a*Csc[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,n},x] && Not[IntegerQ[n]] && IntegerQ[m] *)


(* Int[(a_.+b_.*cos[e_.+f_.*x_])^m_.*(d_./cos[e_.+f_.*x_])^n_,x_Symbol] :=
  d^m*Int[(d*Sec[e+f*x])^(n-m)*(b+a*Sec[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,n},x] && Not[IntegerQ[n]] && IntegerQ[m] *)


Int[(a_.+b_.*sin[e_.+f_.*x_])^m_.*(c_.*(d_.*sin[e_.+f_.*x_])^p_)^n_,x_Symbol] :=
  c^IntPart[n]*(c*(d*Sin[e + f*x])^p)^FracPart[n]/(d*Sin[e + f*x])^(p*FracPart[n])*
    Int[(a+b*Sin[e+f*x])^m*(d*Sin[e+f*x])^(n*p),x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && Not[IntegerQ[n]]


Int[(a_.+b_.*cos[e_.+f_.*x_])^m_.*(c_.*(d_.*cos[e_.+f_.*x_])^p_)^n_,x_Symbol] :=
  c^IntPart[n]*(c*(d*Cos[e + f*x])^p)^FracPart[n]/(d*Cos[e + f*x])^(p*FracPart[n])*
    Int[(a+b*Cos[e+f*x])^m*(d*Cos[e+f*x])^(n*p),x] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && Not[IntegerQ[n]]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*csc[e_.+f_.*x_])^n_.,x_Symbol] :=
  Int[(a+b*Sin[e+f*x])^m*(d+c*Sin[e+f*x])^n/Sin[e+f*x]^n,x] /;
FreeQ[{a,b,c,d,e,f,m},x] && IntegerQ[n]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*csc[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[(b+a*Csc[e+f*x])^m*(c+d*Csc[e+f*x])^n/Csc[e+f*x]^m,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && Not[IntegerQ[n]] && IntegerQ[m]


Int[(a_+b_.*cos[e_.+f_.*x_])^m_.*(c_+d_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[(b+a*Sec[e+f*x])^m*(c+d*Sec[e+f*x])^n/Sec[e+f*x]^m,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && Not[IntegerQ[n]] && IntegerQ[m]


Int[(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*csc[e_.+f_.*x_])^n_,x_Symbol] :=
  Sin[e+f*x]^n*(c+d*Csc[e+f*x])^n/(d+c*Sin[e+f*x])^n*Int[(a+b*Sin[e+f*x])^m*(d+c*Sin[e+f*x])^n/Sin[e+f*x]^n,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && Not[IntegerQ[n]] && Not[IntegerQ[m]]


Int[(a_+b_.*cos[e_.+f_.*x_])^m_*(c_+d_.*sec[e_.+f_.*x_])^n_,x_Symbol] :=
  Cos[e+f*x]^n*(c+d*Sec[e+f*x])^n/(d+c*Cos[e+f*x])^n*Int[(a+b*Cos[e+f*x])^m*(d+c*Cos[e+f*x])^n/Cos[e+f*x]^n,x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && Not[IntegerQ[n]] && Not[IntegerQ[m]]





(* ::Subsection::Closed:: *)
(*4.1.2.2 (g cos)^p (a+b sin)^m (c+d sin)^n*)


Int[cos[e_.+f_.*x_]*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  1/(b*f)*Subst[Int[(a+x)^m*(c+d/b*x)^n,x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,n},x]


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_.*(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  a*Int[Cos[e+f*x]^p*(d*Sin[e+f*x])^n,x] + b/d*Int[Cos[e+f*x]^p*(d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,d,e,f,n,p},x] && IntegerQ[(p-1)/2] && IntegerQ[n] && (p<0 && NeQ[a^2-b^2] || 0<n<p-1 || p+1<-n<2*p+1)


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_./(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  1/a*Int[Cos[e+f*x]^(p-2)*(d*Sin[e+f*x])^n,x] - 
  1/(b*d)*Int[Cos[e+f*x]^(p-2)*(d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,d,e,f,n,p},x] && IntegerQ[(p-1)/2] && EqQ[a^2-b^2] && IntegerQ[n] && (0<n<(p+1)/2 || p<=-n<2*p-3 || 0<n<=-p)


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  1/(b^p*f)*Subst[Int[(a+x)^(m+(p-1)/2)*(a-x)^((p-1)/2)*(c+d/b*x)^n,x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,e,f,c,d,m,n},x] && IntegerQ[(p-1)/2] && EqQ[a^2-b^2]


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  1/(b^p*f)*Subst[Int[(a+x)^m*(c+d/b*x)^n*(b^2-x^2)^((p-1)/2),x],x,b*Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && IntegerQ[(p-1)/2] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_.*(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  a*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^n,x] + b/d*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,d,e,f,g,n,p},x]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_./(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g^2/a*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n,x] - 
  g^2/(b*d)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,d,e,f,g,n,p},x] && EqQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^m*c^m/g^(2*m)*Int[(g*Cos[e+f*x])^(2*m+p)*(c+d*Sin[e+f*x])^(n-m),x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && IntegerQ[m] && Not[IntegerQ[n] && n^2<m^2]


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  1/(a^(p/2)*c^(p/2))*Int[(a+b*Sin[e+f*x])^(m+p/2)*(c+d*Sin[e+f*x])^(n+p/2),x] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && IntegerQ[p/2]


Int[(g_.*cos[e_.+f_.*x_])^p_/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  g*Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])*Int[(g*Cos[e+f*x])^(p-1),x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^IntPart[m]*c^IntPart[m]*(a+b*Sin[e+f*x])^FracPart[m]*(c+d*Sin[e+f*x])^FracPart[m]/
    (g^(2*IntPart[m])*(g*Cos[e+f*x])^(2*FracPart[m]))*Int[(g*Cos[e+f*x])^(2*m+p)/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[2*m+p-1] && EqQ[m-n-1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*g*(m-n-1)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[2*m+p-1] && NeQ[m-n-1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -2*b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*g*(2*n+p+1)) - 
  b*(2*m+p-1)/(d*(2*n+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && PositiveIntegerQ[Simplify[m+p/2-1/2]] && RationalQ[n] && n<-1 && 
  NeQ[2*n+p+1] && Not[NegativeIntegerQ[Simplify[m+n+p]] && Simplify[2*m+n+3*p/2+1]>0]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*g*(m+n+p)) + 
  a*(2*m+p-1)/(m+n+p)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && PositiveIntegerQ[Simplify[m+p/2-1/2]] && Not[RationalQ[n] && n<-1] && 
  Not[PositiveIntegerQ[Simplify[n+p/2-1/2]] && m-n>0] && Not[NegativeIntegerQ[Simplify[m+n+p]] && Simplify[2*m+n+3*p/2+1]>0]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a^IntPart[m]*c^IntPart[m]*(a+b*Sin[e+f*x])^FracPart[m]*(c+d*Sin[e+f*x])^FracPart[m]/
    (g^(2*IntPart[m])*(g*Cos[e+f*x])^(2*FracPart[m]))*Int[(g*Cos[e+f*x])^(2*m+p),x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[2*m+p+1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*g*(m-n)) /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[m+n+p+1] && NeQ[m-n]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*g*(2*m+p+1)) + 
  (m+n+p+1)/(a*(2*m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && NegativeIntegerQ[Simplify[m+n+p+1]] && NeQ[2*m+p+1] && 
  (SumSimplerQ[m,1] || Not[SumSimplerQ[n,1]])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -2*b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*g*(2*n+p+1)) - 
  b*(2*m+p-1)/(d*(2*n+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^(n+1),x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && RationalQ[m,n] && m>0 && n<-1 && NeQ[2*n+p+1] && 
  IntegersQ[2*m,2*n,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  -b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n/(f*g*(m+n+p)) + 
  a*(2*m+p-1)/(m+n+p)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && RationalQ[m] && m>0 && NeQ[m+n+p] && 
  Not[RationalQ[n] && 0<n<m] && IntegersQ[2*m,2*n,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(a*f*g*(2*m+p+1)) + 
  (m+n+p+1)/(a*(2*m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && RationalQ[m] && m<-1 && NeQ[2*m+p+1] && 
  Not[RationalQ[n] && m<n<-1] && IntegersQ[2*m,2*n,2*p]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^IntPart[m]*c^IntPart[m]*(a+b*Sin[e+f*x])^FracPart[m]*(c+d*Sin[e+f*x])^FracPart[m]/
    (g^(2*IntPart[m])*(g*Cos[e+f*x])^(2*FracPart[m]))*
    Int[(g*Cos[e+f*x])^(2*m+p)*(c+d*Sin[e+f*x])^(n-m),x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && (FractionQ[m] || Not[FractionQ[n]])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(f*g*(m+p+1)) /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[a^2-b^2] && EqQ[a*d*m+b*c*(m+p+1)]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -(b*c+a*d)*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*(p+1)) + 
  b*(a*d*m+b*c*(m+p+1))/(a*g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && EqQ[a^2-b^2] && RationalQ[m,p] && m>-1 && p<-1


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(f*g*(m+p+1)) + 
  (a*d*m+b*c*(m+p+1))/(b*(m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[Simplify[(2*m+p+1)/2]] && NeQ[m+p+1]


Int[cos[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  2*(b*c-a*d)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)/(b^2*f*(2*m+3)) + 
  1/(b^3*(2*m+3))*Int[(a+b*Sin[e+f*x])^(m+2)*(b*c+2*a*d*(m+1)-b*d*(2*m+3)*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[a^2-b^2] && RationalQ[m] && m<-3/2


Int[cos[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  d*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+2)/(b^2*f*(m+3)) - 
  1/(b^2*(m+3))*Int[(a+b*Sin[e+f*x])^(m+1)*(b*d*(m+2)-a*c*(m+3)+(b*c*(m+3)-a*d*(m+4))*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[a^2-b^2] && RationalQ[m] && -3/2<=m<0


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  (b*c-a*d)*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*(2*m+p+1)) + 
  (a*d*m+b*c*(m+p+1))/(a*b*(2*m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1),x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[a^2-b^2] && (RationalQ[m] && m<-1 || NegativeIntegerQ[Simplify[m+p]]) && NeQ[2*m+p+1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(f*g*(m+p+1)) + 
  (a*d*m+b*c*(m+p+1))/(b*(m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,c,d,e,f,g,m,p},x] && EqQ[a^2-b^2] && NeQ[m+p+1]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m*(d+c*Sin[e+f*x])/(f*g*(p+1)) + 
  1/(g^2*(p+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1)*Simp[a*c*(p+2)+b*d*m+b*c*(m+p+2)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m,p] && m>0 && p<-1 && IntegerQ[2*m] && 
  Not[m==1 && NeQ[c^2-d^2] && SimplerQ[c+d*x,a+b*x]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(f*g*(m+p+1)) + 
  1/(m+p+1)*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m-1)*Simp[a*c*(m+p+1)+b*d*m+(a*d*m+b*c*(m+p+1))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[a^2-b^2] && RationalQ[m] && m>0 && Not[RationalQ[p] && p<-1] && IntegerQ[2*m] && 
  Not[m==1 && NeQ[c^2-d^2] && SimplerQ[c+d*x,a+b*x]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)*(b*c*(m+p+1)-a*d*p+b*d*(m+1)*Sin[e+f*x])/(b^2*f*(m+1)*(m+p+1)) + 
  g^2*(p-1)/(b^2*(m+1)*(m+p+1))*
    Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^(m+1)*Simp[b*d*(m+1)+(b*c*(m+p+1)-a*d*p)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m,p] && m<-1 && p>1 && NeQ[m+p+1] && IntegerQ[2*m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -(b*c-a*d)*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(f*g*(a^2-b^2)*(m+1)) + 
  1/((a^2-b^2)*(m+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1)*Simp[(a*c-b*d)*(m+1)-(b*c-a*d)*(m+p+2)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[a^2-b^2] && RationalQ[m] && m<-1 && IntegerQ[2*m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)*(a+b*Sin[e+f*x])^(m+1)*(b*c*(m+p+1)-a*d*p+b*d*(m+p)*Sin[e+f*x])/(b^2*f*(m+p)*(m+p+1)) + 
  g^2*(p-1)/(b^2*(m+p)*(m+p+1))*
    Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^m*Simp[b*(a*d*m+b*c*(m+p+1))+(a*b*c*(m+p+1)-d*(a^2*p-b^2*(m+p)))*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[a^2-b^2] && RationalQ[p] && p>1 && NeQ[m+p] && NeQ[m+p+1] && IntegerQ[2*m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  (g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)*(b*c-a*d-(a*c-b*d)*Sin[e+f*x])/(f*g*(a^2-b^2)*(p+1)) + 
  1/(g^2*(a^2-b^2)*(p+1))*
    Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m*Simp[c*(a^2*(p+2)-b^2*(m+p+2))+a*b*d*m+b*(a*c-b*d)*(m+p+3)*Sin[e+f*x],x],x] /;
FreeQ[{a,b,c,d,e,f,g,m},x] && NeQ[a^2-b^2] && RationalQ[p] && p<-1 && IntegerQ[2*m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(c_.+d_.*sin[e_.+f_.*x_])/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  d/b*Int[(g*Cos[e+f*x])^p,x] + (b*c-a*d)/b*Int[(g*Cos[e+f*x])^p/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  c*g*(g*Cos[e+f*x])^(p-1)/(f*(1+Sin[e+f*x])^((p-1)/2)*(1-Sin[e+f*x])^((p-1)/2))*
    Subst[Int[(1+d/c*x)^((p+1)/2)*(1-d/c*x)^((p-1)/2)*(a+b*x)^m,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,p},x] && NeQ[a^2-b^2] && EqQ[c^2-d^2]


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^(2*m)*Int[(d*Sin[e+f*x])^n/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,n},x] && EqQ[a^2-b^2] && IntegersQ[m,p] && 2*m+p==0


Int[(g_.*cos[e_.+f_.*x_])^p_*sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(2*b*f*g*(m+1)) + 
  a/(2*g^2)*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && EqQ[m-p]


Int[(g_.*cos[e_.+f_.*x_])^p_*sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*m) - 
  1/g^2*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && EqQ[m+p+1]


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  1/a^p*Int[ExpandTrig[(d*sin[e+f*x])^n*(a-b*sin[e+f*x])^(p/2)*(a+b*sin[e+f*x])^(m+p/2),x],x] /;
FreeQ[{a,b,d,e,f},x] && EqQ[a^2-b^2] && IntegersQ[m,n,p/2] && (m>0 && p>0 && -m-p<n<-1 || m>2 && p<0 && m+p/2>0)


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p,(d*sin[e+f*x])^n*(a+b*sin[e+f*x])^m,x],x] /;
FreeQ[{a,b,d,e,f,g,n,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[m]


Int[cos[e_.+f_.*x_]^2*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  1/b^2*Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^(m+1)*(a-b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && (NegativeIntegerQ[m] || Not[PositiveIntegerQ[n]])


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a/g)^(2*m)*Int[(g*Cos[e+f*x])^(2*m+p)*(d*Sin[e+f*x])^n/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,g,n,p},x] && EqQ[a^2-b^2] && NegativeIntegerQ[m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a/g)^(2*m)*Int[(g*Cos[e+f*x])^(2*m+p)*(d*Sin[e+f*x])^n/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,g,n},x] && EqQ[a^2-b^2] && IntegerQ[m] && RationalQ[p] && (2*m+p==0 || 2*m+p>0 && p<-1)


Int[(g_.*cos[e_.+f_.*x_])^p_*sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  b*(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^m/(a*f*g*(2*m+p+1)) - 
  1/(a^2*(2*m+p+1))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^(m+1)*(a*m-b*(2*m+p+1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,p},x] && EqQ[a^2-b^2] && RationalQ[m] && m<=-1/2 && NeQ[2*m+p+1]


Int[(g_.*cos[e_.+f_.*x_])^p_*sin[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -(g*Cos[e+f*x])^(p+1)*(a+b*Sin[e+f*x])^(m+1)/(b*f*g*(m+p+2)) + 
  1/(b*(m+p+2))*Int[(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^m*(b*(m+1)-a*(p+1)*Sin[e+f*x]),x] /;
FreeQ[{a,b,e,f,g,m,p},x] && EqQ[a^2-b^2] && NeQ[m+p+2]


Int[cos[e_.+f_.*x_]^2*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  1/b^2*Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^(m+1)*(a-b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && IntegersQ[2*m,2*n]


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  -2/(a*b*d)*Int[(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+2),x] + 
  1/a^2*Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^(m+2)*(1+Sin[e+f*x]^2),x] /;
FreeQ[{a,b,d,e,f,n},x] && EqQ[a^2-b^2] && RationalQ[m] && m<-1


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  1/d^4*Int[(d*Sin[e+f*x])^(n+4)*(a+b*Sin[e+f*x])^m,x] + 
  Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^m*(1-2*Sin[e+f*x]^2),x] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && Not[PositiveIntegerQ[m]]


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a^m*Cos[e+f*x]/(f*Sqrt[1+Sin[e+f*x]]*Sqrt[1-Sin[e+f*x]])*
    Subst[Int[(d*x)^n*(1+b/a*x)^(m+(p-1)/2)*(1-b/a*x)^((p-1)/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,d,e,f,n},x] && EqQ[a^2-b^2] && IntegerQ[p/2] && IntegerQ[m]


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Cos[e+f*x]/(a^(p-2)*f*Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]])*
    Subst[Int[(d*x)^n(a+b*x)^(m+p/2-1/2)*(a-b*x)^(p/2-1/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,d,e,f,m,n},x] && EqQ[a^2-b^2] && IntegerQ[p/2] && Not[IntegerQ[m]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p,(d*sin[e+f*x])^n*(a+b*sin[e+f*x])^m,x],x] /;
FreeQ[{a,b,d,e,f,g,n,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[m] && (IntegerQ[p] || PositiveIntegerQ[n])


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a^m*g*(g*Cos[e+f*x])^(p-1)/(f*(1+Sin[e+f*x])^((p-1)/2)*(1-Sin[e+f*x])^((p-1)/2))*
    Subst[Int[(d*x)^n*(1+b/a*x)^(m+(p-1)/2)*(1-b/a*x)^((p-1)/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,d,e,f,n,p},x] && EqQ[a^2-b^2] && IntegerQ[m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)/(f*(a+b*Sin[e+f*x])^((p-1)/2)*(a-b*Sin[e+f*x])^((p-1)/2))*
    Subst[Int[(d*x)^n*(a+b*x)^(m+(p-1)/2)*(a-b*x)^((p-1)/2),x],x,Sin[e+f*x]] /;
FreeQ[{a,b,d,e,f,m,n,p},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_/Sqrt[d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  -g*(g*Cos[e+f*x])^(p-1)*Sqrt[d*Sin[e+f*x]]*(a+b*Sin[e+f*x])^(m+1)/(a*d*f*(m+1)) + 
  g^2*(2*m+3)/(2*a*(m+1))*Int[(g*Cos[e+f*x])^(p-2)*(a+b*Sin[e+f*x])^(m+1)/Sqrt[d*Sin[e+f*x]],x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m] && m<-1 && EqQ[m+p+1/2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_/Sqrt[d_.*sin[e_.+f_.*x_]],x_Symbol] :=
  2*(g*Cos[e+f*x])^(p+1)*Sqrt[d*Sin[e+f*x]]*(a+b*Sin[e+f*x])^m/(d*f*g*(2*m+1)) + 
  2*a*m/(g^2*(2*m+1))*Int[(g*Cos[e+f*x])^(p+2)*(a+b*Sin[e+f*x])^(m-1)/Sqrt[d*Sin[e+f*x]],x] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2] && RationalQ[m] && m>0 && EqQ[m+p+3/2]


Int[cos[e_.+f_.*x_]^2*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^m*(1-Sin[e+f*x]^2),x] /;
FreeQ[{a,b,d,e,f,m,n},x] && NeQ[a^2-b^2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n])


(* Int[cos[e_.+f_.*x_]^4*sin[e_.+f_.*x_]^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a^2-b^2)*Cos[e+f*x]*Sin[e+f*x]^(n+1)*(a+b*Sin[e+f*x])^(m+1)/(a*b^2*d*(m+1)) - 
  (a^2*(n+1)-b^2*(m+n+2))*Cos[e+f*x]*Sin[e+f*x]^(n+1)*(a+b*Sin[e+f*x])^(m+2)/(a^2*b^2*d*(n+1)*(m+1)) + 
  1/(a^2*b*(n+1)*(m+1))*Int[Sin[e+f*x]^(n+1)*(a+b*Sin[e+f*x])^(m+1)*
    Simp[a^2*(n+1)*(n+2)-b^2*(m+n+2)*(m+n+3)+a*b*(m+1)*Sin[e+f*x]-(a^2*(n+1)*(n+3)-b^2*(m+n+2)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n] && m<-1 && n<-1 *)


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Cos[e+f*x]*(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+1)/(a*d*f*(n+1)) - 
  (a^2*(n+1)-b^2*(m+n+2))*Cos[e+f*x]*(d*Sin[e+f*x])^(n+2)*(a+b*Sin[e+f*x])^(m+1)/(a^2*b*d^2*f*(n+1)*(m+1)) + 
  1/(a^2*b*d*(n+1)*(m+1))*Int[(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+1)*
    Simp[a^2*(n+1)*(n+2)-b^2*(m+n+2)*(m+n+3)+a*b*(m+1)*Sin[e+f*x]-(a^2*(n+1)*(n+3)-b^2*(m+n+2)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n] && m<-1 && n<-1


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a^2-b^2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+1)/(a*b^2*d*f*(m+1)) + 
  (a^2*(n-m+1)-b^2*(m+n+2))*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+2)*(d*Sin[e+f*x])^(n+1)/(a^2*b^2*d*f*(m+1)*(m+2)) - 
  1/(a^2*b^2*(m+1)*(m+2))*Int[(a+b*Sin[e+f*x])^(m+2)*(d*Sin[e+f*x])^n*
    Simp[a^2*(n+1)*(n+3)-b^2*(m+n+2)*(m+n+3)+a*b*(m+2)*Sin[e+f*x]-(a^2*(n+2)*(n+3)-b^2*(m+n+2)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n] && m<-1 && Not[n<-1] && (m<-2 || EqQ[m+n+4])


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  (a^2-b^2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+1)/(a*b^2*d*f*(m+1)) - 
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+2)*(d*Sin[e+f*x])^(n+1)/(b^2*d*f*(m+n+4)) - 
  1/(a*b^2*(m+1)*(m+n+4))*Int[(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^n*
    Simp[a^2*(n+1)*(n+3)-b^2*(m+n+2)*(m+n+4)+a*b*(m+1)*Sin[e+f*x]-(a^2*(n+2)*(n+3)-b^2*(m+n+3)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,n},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n] && m<-1 && Not[n<-1] && NeQ[m+n+4]


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+1)/(a*d*f*(n+1)) - 
  b*(m+n+2)*Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+2)/(a^2*d^2*f*(n+1)*(n+2)) - 
  1/(a^2*d^2*(n+1)*(n+2))*Int[(a+b*Sin[e+f*x])^m*(d*Sin[e+f*x])^(n+2)*
    Simp[a^2*n*(n+2)-b^2*(m+n+2)*(m+n+3)+a*b*m*Sin[e+f*x]-(a^2*(n+1)*(n+2)-b^2*(m+n+2)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,m},x] && NeQ[a^2-b^2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n]) && Not[m<-1] && RationalQ[n] && n<-1 && 
  (n<-2 || EqQ[m+n+4])


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+1)/(a*d*f*(n+1)) - 
  Cos[e+f*x]*(a+b*Sin[e+f*x])^(m+1)*(d*Sin[e+f*x])^(n+2)/(b*d^2*f*(m+n+4)) + 
  1/(a*b*d*(n+1)*(m+n+4))*Int[(a+b*Sin[e+f*x])^m*(d*Sin[e+f*x])^(n+1)*
    Simp[a^2*(n+1)*(n+2)-b^2*(m+n+2)*(m+n+4)+a*b*(m+3)*Sin[e+f*x]-(a^2*(n+1)*(n+3)-b^2*(m+n+3)*(m+n+4))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,m},x] && NeQ[a^2-b^2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n]) && Not[m<-1] && RationalQ[n] && n<-1 && 
  NeQ[m+n+4]


Int[cos[e_.+f_.*x_]^4*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  a*(n+3)*Cos[e+f*x]*(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+1)/(b^2*d*f*(m+n+3)*(m+n+4)) - 
  Cos[e+f*x]*(d*Sin[e+f*x])^(n+2)*(a+b*Sin[e+f*x])^(m+1)/(b*d^2*f*(m+n+4)) - 
  1/(b^2*(m+n+3)*(m+n+4))*Int[(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^m*
    Simp[a^2*(n+1)*(n+3)-b^2*(m+n+3)*(m+n+4)+a*b*m*Sin[e+f*x]-(a^2*(n+2)*(n+3)-b^2*(m+n+3)*(m+n+5))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,m,n},x] && NeQ[a^2-b^2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n]) && Not[m<-1] && Not[RationalQ[n] && n<-1] && 
  NeQ[m+n+3] && NeQ[m+n+4]


Int[cos[e_.+f_.*x_]^6*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Cos[e+f*x]*(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+1)/(a*d*f*(n+1)) - 
  b*(m+n+2)*Cos[e+f*x]*(d*Sin[e+f*x])^(n+2)*(a+b*Sin[e+f*x])^(m+1)/(a^2*d^2*f*(n+1)*(n+2)) - 
  a*(n+5)*Cos[e+f*x]*(d*Sin[e+f*x])^(n+3)*(a+b*Sin[e+f*x])^(m+1)/(b^2*d^3*f*(m+n+5)*(m+n+6)) + 
  Cos[e+f*x]*(d*Sin[e+f*x])^(n+4)*(a+b*Sin[e+f*x])^(m+1)/(b*d^4*f*(m+n+6)) + 
  1/(a^2*b^2*d^2*(n+1)*(n+2)*(m+n+5)*(m+n+6))*
    Int[(d*Sin[e+f*x])^(n+2)*(a+b*Sin[e+f*x])^m*
      Simp[a^4*(n+1)*(n+2)*(n+3)*(n+5)-a^2*b^2*(n+2)*(2*n+1)*(m+n+5)*(m+n+6)+b^4*(m+n+2)*(m+n+3)*(m+n+5)*(m+n+6) + 
        a*b*m*(a^2*(n+1)*(n+2)-b^2*(m+n+5)*(m+n+6))*Sin[e+f*x] - 
        (a^4*(n+1)*(n+2)*(4+n)*(n+5)+b^4*(m+n+2)*(m+n+4)*(m+n+5)*(m+n+6)-a^2*b^2*(n+1)*(n+2)*(m+n+5)*(2*n+2*m+13))*Sin[e+f*x]^2,x],x] /;
FreeQ[{a,b,d,e,f,m,n},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n] && NeQ[n+1] && NeQ[n+2] && NeQ[m+n+5] && 
  NeQ[m+n+6] && Not[PositiveIntegerQ[m]]


Int[cos[e_.+f_.*x_]^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[ExpandTrig[(d*sin[e+f*x])^n*(a+b*sin[e+f*x])^m*(1-sin[e+f*x]^2)^(p/2),x],x] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2] && IntegersQ[m,2*n,p/2] && (m<-1 || m==-1 && p>0)


Int[(g_.*cos[e_.+f_.*x_])^p_*sin[e_.+f_.*x_]^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p,sin[e+f*x]^n/(a+b*sin[e+f*x]),x],x] /;
FreeQ[{a,b,e,f,g,p},x] && NeQ[a^2-b^2] && IntegerQ[n] && (n<0 || PositiveIntegerQ[p+1/2])


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g^2/a*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n,x] - 
  b*g^2/(a^2*d)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+1),x] - 
  g^2*(a^2-b^2)/(a^2*d^2)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+2)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p>1 && (n<=-2 || n==-3/2 && p==3/2)


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g^2/(a*b)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n*(b-a*Sin[e+f*x]),x] + 
  g^2*(a^2-b^2)/(a*b*d)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+1)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p>1 && (n<-1 || p==3/2 && n==-1/2)


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g^2/b^2*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n*(a-b*Sin[e+f*x]),x] - 
  g^2*(a^2-b^2)/b^2*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p>1


(* Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g^2*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n/(a+b*Sin[e+f*x]),x] - 
  g^2/d^2*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+2)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p>1 *)


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  a*d^2/(a^2-b^2)*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n-2),x] - 
  b*d/(a^2-b^2)*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n-1),x] - 
  a^2*d^2/(g^2*(a^2-b^2))*Int[(g*Cos[e+f*x])^(p+2)*(d*Sin[e+f*x])^(n-2)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p<-1 && n>1


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  -d/(a^2-b^2)*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n-1)*(b-a*Sin[e+f*x]),x] + 
  a*b*d/(g^2*(a^2-b^2))*Int[(g*Cos[e+f*x])^(p+2)*(d*Sin[e+f*x])^(n-1)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p<-1 && n>0


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  1/(a^2-b^2)*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^n*(a-b*Sin[e+f*x]),x] - 
  b^2/(g^2*(a^2-b^2))*Int[(g*Cos[e+f*x])^(p+2)*(d*Sin[e+f*x])^n/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && p<-1


Int[Sqrt[g_.*cos[e_.+f_.*x_]]/(Sqrt[sin[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  -4*Sqrt[2]*g/f*Subst[Int[x^2/(((a+b)*g^2+(a-b)*x^4)*Sqrt[1-x^4/g^2]),x],x,Sqrt[g*Cos[e+f*x]]/Sqrt[1+Sin[e+f*x]]] /;
FreeQ[{a,b,e,f,g},x] && NeQ[a^2-b^2]


Int[Sqrt[g_.*cos[e_.+f_.*x_]]/(Sqrt[d_*sin[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  Sqrt[Sin[e+f*x]]/Sqrt[d*Sin[e+f*x]]*Int[Sqrt[g*Cos[e+f*x]]/(Sqrt[Sin[e+f*x]]*(a+b*Sin[e+f*x])),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2]


Int[Sqrt[d_.*sin[e_.+f_.*x_]]/(Sqrt[cos[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  With[{q=Rt[-a^2+b^2,2]},
  2*Sqrt[2]*d*(b+q)/(f*q)*Subst[Int[1/((d*(b+q)+a*x^2)*Sqrt[1-x^4/d^2]),x],x,Sqrt[d*Sin[e+f*x]]/Sqrt[1+Cos[e+f*x]]] - 
  2*Sqrt[2]*d*(b-q)/(f*q)*Subst[Int[1/((d*(b-q)+a*x^2)*Sqrt[1-x^4/d^2]),x],x,Sqrt[d*Sin[e+f*x]]/Sqrt[1+Cos[e+f*x]]]] /;
FreeQ[{a,b,d,e,f},x] && NeQ[a^2-b^2]


Int[Sqrt[d_.*sin[e_.+f_.*x_]]/(Sqrt[g_.*cos[e_.+f_.*x_]]*(a_+b_.*sin[e_.+f_.*x_])),x_Symbol] :=
  Sqrt[Cos[e+f*x]]/Sqrt[g*Cos[e+f*x]]*Int[Sqrt[d*Sin[e+f*x]]/(Sqrt[Cos[e+f*x]]*(a+b*Sin[e+f*x])),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2]


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  d/b*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n-1),x] - 
  a*d/b*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n-1)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && -1<p<1 && n>0


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_/(a_+b_.*sin[e_.+f_.*x_]),x_Symbol] :=
  1/a*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^n,x] - 
  b/(a*d)*Int[(g*Cos[e+f*x])^p*(d*Sin[e+f*x])^(n+1)/(a+b*Sin[e+f*x]),x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[2*n,2*p] && -1<p<1 && n<0


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p,(d*sin[e+f*x])^n*(a+b*sin[e+f*x])^m,x],x] /;
FreeQ[{a,b,d,e,f,g,n,p},x] && NeQ[a^2-b^2] && IntegerQ[m] && (m>0 || IntegerQ[n])


Int[(g_.*cos[e_.+f_.*x_])^p_*(d_.*sin[e_.+f_.*x_])^n_*(a_+b_.*sin[e_.+f_.*x_])^m_,x_Symbol] :=
  g^2/a*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^n*(a+b*Sin[e+f*x])^(m+1),x] - 
  b*g^2/(a^2*d)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+1)*(a+b*Sin[e+f*x])^(m+1),x] - 
  g^2*(a^2-b^2)/(a^2*d^2)*Int[(g*Cos[e+f*x])^(p-2)*(d*Sin[e+f*x])^(n+2)*(a+b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,d,e,f,g},x] && NeQ[a^2-b^2] && IntegersQ[m,2*n,2*p] && m<0 && p>1 && (n<=-2 || m==-1 && n==-3/2 && p==3/2)


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^(2*m)*Int[(c+d*Sin[e+f*x])^n/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[a^2-b^2] && IntegersQ[m,p] && 2*m+p==0


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  (a/g)^(2*m)*Int[(g*Cos[e+f*x])^(2*m+p)*(c+d*Sin[e+f*x])^n/(a-b*Sin[e+f*x])^m,x] /;
FreeQ[{a,b,c,d,e,f,g,n},x] && EqQ[a^2-b^2] && IntegerQ[m] && RationalQ[p] && (2*m+p==0 || 2*m+p>0 && p<-1)


Int[cos[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  1/b^2*Int[(a+b*Sin[e+f*x])^(m+1)*(c+d*Sin[e+f*x])^n*(a-b*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[a^2-b^2] && IntegersQ[2*m,2*n]


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^m*Cos[e+f*x]/(f*Sqrt[1+Sin[e+f*x]]*Sqrt[1-Sin[e+f*x]])*
    Subst[Int[(1+b/a*x)^(m+(p-1)/2)*(1-b/a*x)^((p-1)/2)*(c+d*x)^n,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,n},x] && EqQ[a^2-b^2] && IntegerQ[p/2] && IntegerQ[m]


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Cos[e+f*x]/(a^(p-2)*f*Sqrt[a+b*Sin[e+f*x]]*Sqrt[a-b*Sin[e+f*x]])*
    Subst[Int[(a+b*x)^(m+p/2-1/2)*(a-b*x)^(p/2-1/2)*(c+d*x)^n,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && EqQ[a^2-b^2] && IntegerQ[p/2] && Not[IntegerQ[m]]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p,(a+b*sin[e+f*x])^m*(c+d*sin[e+f*x])^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,n,p},x] && EqQ[a^2-b^2] && PositiveIntegerQ[m] && (IntegerQ[p] || PositiveIntegerQ[n])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  a^m*g*(g*Cos[e+f*x])^(p-1)/(f*(1+Sin[e+f*x])^((p-1)/2)*(1-Sin[e+f*x])^((p-1)/2))*
    Subst[Int[(1+b/a*x)^(m+(p-1)/2)*(1-b/a*x)^((p-1)/2)*(c+d*x)^n,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,n,p},x] && EqQ[a^2-b^2] && IntegerQ[m]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  g*(g*Cos[e+f*x])^(p-1)/(f*(a+b*Sin[e+f*x])^((p-1)/2)*(a-b*Sin[e+f*x])^((p-1)/2))*
    Subst[Int[(a+b*x)^(m+(p-1)/2)*(a-b*x)^((p-1)/2)*(c+d*x)^n,x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,m,n,p},x] && EqQ[a^2-b^2] && Not[IntegerQ[m]]


Int[cos[e_.+f_.*x_]^2*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n*(1-Sin[e+f*x]^2),x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && NeQ[a^2-b^2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n])


Int[cos[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[ExpandTrig[(a+b*sin[e+f*x])^m*(c+d*sin[e+f*x])^n*(1-sin[e+f*x]^2)^(p/2),x],x] /;
FreeQ[{a,b,c,d,e,f,m,n},x] && NeQ[a^2-b^2] && PositiveIntegerQ[p/2] && (PositiveIntegerQ[m] || IntegersQ[2*m,2*n])


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[ExpandTrig[(g*cos[e+f*x])^p*(a+b*sin[e+f*x])^m*(c+d*sin[e+f*x])^n,x],x] /;
FreeQ[{a,b,c,d,e,f,g,p},x] && NeQ[a^2-b^2] && IntegersQ[2*m,2*n]


Int[(g_.*cos[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  Defer[Int][(g*Cos[e+f*x])^p*(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[a^2-b^2]


Int[(g_.*sec[e_.+f_.*x_])^p_*(a_.+b_.*sin[e_.+f_.*x_])^m_.*(c_.+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  g^(2*IntPart[p])*(g*Cos[e+f*x])^FracPart[p]*(g*Sec[e+f*x])^FracPart[p]*
    Int[(a+b*Sin[e+f*x])^m*(c+d*Sin[e+f*x])^n/(g*Cos[e+f*x])^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && Not[IntegerQ[p]]


Int[(g_.*csc[e_.+f_.*x_])^p_*(a_.+b_.*cos[e_.+f_.*x_])^m_.*(c_.+d_.*cos[e_.+f_.*x_])^n_.,x_Symbol] :=
  g^(2*IntPart[p])*(g*Sin[e+f*x])^FracPart[p]*(g*Csc[e+f*x])^FracPart[p]*
    Int[(a+b*Cos[e+f*x])^m*(c+d*Cos[e+f*x])^n/(g*Sin[e+f*x])^p,x] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && Not[IntegerQ[p]]





(* ::Subsection::Closed:: *)
(*4.1.2.3 (g sin)^p (a+b sin)^m (c+d sin)^n*)


Int[Sqrt[g_.*sin[e_.+f_.*x_]]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  g/d*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[g*Sin[e+f*x]],x] - 
  c*g/d*Int[Sqrt[a+b*Sin[e+f*x]]/(Sqrt[g*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && (EqQ[a^2-b^2] || EqQ[c^2-d^2])


Int[Sqrt[g_.*sin[e_.+f_.*x_]]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(c_+d_.*sin[e_.+f_.*x_]),x_Symbol] :=
  b/d*Int[Sqrt[g*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]],x] - 
  (b*c-a*d)/d*Int[Sqrt[g*Sin[e+f*x]]/(Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(Sqrt[g_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  -2*b/f*Subst[Int[1/(b*c+a*d+c*g*x^2),x],x,b*Cos[e+f*x]/(Sqrt[g*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]])] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(Sqrt[sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  -Sqrt[a+b]/(c*f)*EllipticE[ArcSin[Cos[e+f*x]/(1+Sin[e+f*x])],-(a-b)/(a+b)] /;
FreeQ[{a,b,c,d,e,f},x] && EqQ[d-c] && PositiveQ[b^2-a^2] && PositiveQ[b]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(Sqrt[g_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  -Sqrt[a+b*Sin[e+f*x]]*Sqrt[d*Sin[e+f*x]/(c+d*Sin[e+f*x])]/
    (d*f*Sqrt[g*Sin[e+f*x]]*Sqrt[c^2*(a+b*Sin[e+f*x])/((a*c+b*d)*(c+d*Sin[e+f*x]))])*
    EllipticE[ArcSin[c*Cos[e+f*x]/(c+d*Sin[e+f*x])],(b*c-a*d)/(b*c+a*d)] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && EqQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(Sqrt[g_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  a/c*Int[1/(Sqrt[g*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]),x] + 
  (b*c-a*d)/(c*g)*Int[Sqrt[g*Sin[e+f*x]]/(Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  1/c*Int[Sqrt[a+b*Sin[e+f*x]]/Sin[e+f*x],x] - 
  d/c*Int[Sqrt[a+b*Sin[e+f*x]]/(c+d*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  a/c*Int[1/(Sin[e+f*x]*Sqrt[a+b*Sin[e+f*x]]),x] + 
  (b*c-a*d)/c*Int[1/(Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2]


Int[Sqrt[g_.*sin[e_.+f_.*x_]]/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  -a*g/(b*c-a*d)*Int[1/(Sqrt[g*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]),x] + 
  c*g/(b*c-a*d)*Int[Sqrt[a+b*Sin[e+f*x]]/(Sqrt[g*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && (EqQ[a^2-b^2] || EqQ[c^2-d^2])


Int[Sqrt[g_.*sin[e_.+f_.*x_]]/(Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  2*Sqrt[-Cot[e+f*x]^2]*Sqrt[g*Sin[e+f*x]]/(f*(c+d)*Cot[e+f*x]*Sqrt[a+b*Sin[e+f*x]])*Sqrt[(b+a*Csc[e+f*x])/(a+b)]*
    EllipticPi[2*c/(c+d),ArcSin[Sqrt[1-Csc[e+f*x]]/Sqrt[2]],2*a/(a+b)] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[1/(Sqrt[g_.*sin[e_.+f_.*x_]]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  b/(b*c-a*d)*Int[1/(Sqrt[g*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]),x] - 
  d/(b*c-a*d)*Int[Sqrt[a+b*Sin[e+f*x]]/(Sqrt[g*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && (EqQ[a^2-b^2] || EqQ[c^2-d^2])


Int[1/(Sqrt[g_.*sin[e_.+f_.*x_]]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  1/c*Int[1/(Sqrt[g*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]),x] - 
  d/(c*g)*Int[Sqrt[g*Sin[e+f*x]]/(Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f,g},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[1/(sin[e_.+f_.*x_]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  d^2/(c*(b*c-a*d))*Int[Sqrt[a+b*Sin[e+f*x]]/(c+d*Sin[e+f*x]),x] + 
  1/(c*(b*c-a*d))*Int[(b*c-a*d-b*d*Sin[e+f*x])/(Sin[e+f*x]*Sqrt[a+b*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2]


Int[1/(sin[e_.+f_.*x_]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*(c_+d_.*sin[e_.+f_.*x_])),x_Symbol] :=
  1/c*Int[1/(Sin[e+f*x]*Sqrt[a+b*Sin[e+f*x]]),x] - d/c*Int[1/(Sqrt[a+b*Sin[e+f*x]]*(c+d*Sin[e+f*x])),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -d/c*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]],x] + 
  1/c*Int[Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]/Sin[e+f*x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && EqQ[b*c+a*d]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*a/f*Subst[Int[1/(1-a*c*x^2),x],x,Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[b*c+a*d]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  (b*c-a*d)/c*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] + 
  a/c*Int[Sqrt[c+d*Sin[e+f*x]]/(Sin[e+f*x]*Sqrt[a+b*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && EqQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]/(sin[e_.+f_.*x_]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -2*(a+b*Sin[e+f*x])/(c*f*Rt[(a+b)/(c+d),2]*Cos[e+f*x])*
    Sqrt[-(b*c-a*d)*(1-Sin[e+f*x])/((c+d)*(a+b*Sin[e+f*x]))]*Sqrt[(b*c-a*d)*(1+Sin[e+f*x])/((c-d)*(a+b*Sin[e+f*x]))]*
    EllipticPi[a*(c+d)/(c*(a+b)),ArcSin[Rt[(a+b)/(c+d),2]*Sqrt[c+d*Sin[e+f*x]]/Sqrt[a+b*Sin[e+f*x]]],(a-b)*(c+d)/((a+b)*(c-d))] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && NeQ[a^2-b^2] && NeQ[c^2-d^2]


Int[1/(sin[e_.+f_.*x_]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  Cos[e+f*x]/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]])*Int[1/(Cos[e+f*x]*Sin[e+f*x]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && EqQ[c^2-d^2]


Int[1/(sin[e_.+f_.*x_]*Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]),x_Symbol] :=
  -b/a*Int[1/(Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]),x] + 
  1/a*Int[Sqrt[a+b*Sin[e+f*x]]/(Sin[e+f*x]*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && (NeQ[a^2-b^2] || NeQ[c^2-d^2])


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]/sin[e_.+f_.*x_],x_Symbol] :=
  Sqrt[a+b*Sin[e+f*x]]*Sqrt[c+d*Sin[e+f*x]]/Cos[e+f*x]*Int[Cot[e+f*x],x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && EqQ[c^2-d^2]


Int[Sqrt[a_+b_.*sin[e_.+f_.*x_]]*Sqrt[c_+d_.*sin[e_.+f_.*x_]]/sin[e_.+f_.*x_],x_Symbol] :=
  d*Int[Sqrt[a+b*Sin[e+f*x]]/Sqrt[c+d*Sin[e+f*x]],x] + 
  c*Int[Sqrt[a+b*Sin[e+f*x]]/(Sin[e+f*x]*Sqrt[c+d*Sin[e+f*x]]),x] /;
FreeQ[{a,b,c,d,e,f},x] && NeQ[b*c-a*d] && (NeQ[a^2-b^2] || NeQ[c^2-d^2])


Int[sin[e_.+f_.*x_]^p_*(a_+b_.*sin[e_.+f_.*x_])^m_.*(c_+d_.*sin[e_.+f_.*x_])^n_.,x_Symbol] :=
  a^n*c^n*Int[Tan[e+f*x]^p*(a+b*Sin[e+f*x])^(m-n),x] /;
FreeQ[{a,b,c,d,e,f,m},x] && EqQ[b*c+a*d] && EqQ[a^2-b^2] && EqQ[p+2*n] && IntegerQ[n]


Int[(g_.*sin[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Sqrt[a-b*Sin[e+f*x]]*Sqrt[a+b*Sin[e+f*x]]/(f*Cos[e+f*x])*
    Subst[Int[(g*x)^p*(a+b*x)^(m-1/2)*(c+d*x)^n/Sqrt[a-b*x],x],x,Sin[e+f*x]] /;
FreeQ[{a,b,c,d,e,f,g,m,n,p},x] && NeQ[b*c-a*d] && EqQ[a^2-b^2] && NeQ[c^2-d^2] && IntegerQ[m-1/2]


Int[(g_.*sin[e_.+f_.*x_])^p_*(a_+b_.*sin[e_.+f_.*x_])^m_*(c_+d_.*sin[e_.+f_.*x_])^n_,x_Symbol] :=
  Int[ExpandTrig[(g*sin[e+f*x])^p*(a+b*