package aegis

import (
	"testing"
)

// TestAESRound tests the AESRound routine.
//
// See [aegis] A.1.
func TestAESRound(t *testing.T) {
	for _, tc := range []struct {
		in  [16]byte
		rk  [16]byte
		out [16]byte
	}{
		{
			in: [16]byte{
				0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
				0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
			},
			rk: [16]byte{
				0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
				0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
			},
			out: [16]byte{
				0x7a, 0x7b, 0x4e, 0x56, 0x38, 0x78, 0x25, 0x46,
				0xa8, 0xc0, 0x47, 0x7a, 0x3b, 0x81, 0x3f, 0x43,
			},
		},
	} {
		var out [16]byte
		aesRound(&out, &tc.in, &tc.rk)
		if out != tc.out {
			t.Fatalf("expected %0.16x, got %0.16x", tc.out, out)
		}
	}
}
