// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package customtype

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/entc/integration/migrate/entv2/predicate"
)

// ID filters vertices based on their ID field.
func ID(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDEQ applies the EQ predicate on the ID field.
func IDEQ(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldID), id))
	})
}

// IDNEQ applies the NEQ predicate on the ID field.
func IDNEQ(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldID), id))
	})
}

// IDIn applies the In predicate on the ID field.
func IDIn(ids ...int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.In(s.C(FieldID), v...))
	})
}

// IDNotIn applies the NotIn predicate on the ID field.
func IDNotIn(ids ...int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(ids) == 0 {
			s.Where(sql.False())
			return
		}
		v := make([]interface{}, len(ids))
		for i := range v {
			v[i] = ids[i]
		}
		s.Where(sql.NotIn(s.C(FieldID), v...))
	})
}

// IDGT applies the GT predicate on the ID field.
func IDGT(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldID), id))
	})
}

// IDGTE applies the GTE predicate on the ID field.
func IDGTE(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldID), id))
	})
}

// IDLT applies the LT predicate on the ID field.
func IDLT(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldID), id))
	})
}

// IDLTE applies the LTE predicate on the ID field.
func IDLTE(id int) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldID), id))
	})
}

// Custom applies equality check predicate on the "custom" field. It's identical to CustomEQ.
func Custom(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCustom), v))
	})
}

// Tz0 applies equality check predicate on the "tz0" field. It's identical to Tz0EQ.
func Tz0(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTz0), v))
	})
}

// Tz3 applies equality check predicate on the "tz3" field. It's identical to Tz3EQ.
func Tz3(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTz3), v))
	})
}

// CustomEQ applies the EQ predicate on the "custom" field.
func CustomEQ(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldCustom), v))
	})
}

// CustomNEQ applies the NEQ predicate on the "custom" field.
func CustomNEQ(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldCustom), v))
	})
}

// CustomIn applies the In predicate on the "custom" field.
func CustomIn(vs ...string) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldCustom), v...))
	})
}

// CustomNotIn applies the NotIn predicate on the "custom" field.
func CustomNotIn(vs ...string) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldCustom), v...))
	})
}

// CustomGT applies the GT predicate on the "custom" field.
func CustomGT(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldCustom), v))
	})
}

// CustomGTE applies the GTE predicate on the "custom" field.
func CustomGTE(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldCustom), v))
	})
}

// CustomLT applies the LT predicate on the "custom" field.
func CustomLT(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldCustom), v))
	})
}

// CustomLTE applies the LTE predicate on the "custom" field.
func CustomLTE(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldCustom), v))
	})
}

// CustomContains applies the Contains predicate on the "custom" field.
func CustomContains(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.Contains(s.C(FieldCustom), v))
	})
}

// CustomHasPrefix applies the HasPrefix predicate on the "custom" field.
func CustomHasPrefix(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.HasPrefix(s.C(FieldCustom), v))
	})
}

// CustomHasSuffix applies the HasSuffix predicate on the "custom" field.
func CustomHasSuffix(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.HasSuffix(s.C(FieldCustom), v))
	})
}

// CustomIsNil applies the IsNil predicate on the "custom" field.
func CustomIsNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldCustom)))
	})
}

// CustomNotNil applies the NotNil predicate on the "custom" field.
func CustomNotNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldCustom)))
	})
}

// CustomEqualFold applies the EqualFold predicate on the "custom" field.
func CustomEqualFold(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EqualFold(s.C(FieldCustom), v))
	})
}

// CustomContainsFold applies the ContainsFold predicate on the "custom" field.
func CustomContainsFold(v string) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.ContainsFold(s.C(FieldCustom), v))
	})
}

// Tz0EQ applies the EQ predicate on the "tz0" field.
func Tz0EQ(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTz0), v))
	})
}

// Tz0NEQ applies the NEQ predicate on the "tz0" field.
func Tz0NEQ(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldTz0), v))
	})
}

// Tz0In applies the In predicate on the "tz0" field.
func Tz0In(vs ...time.Time) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldTz0), v...))
	})
}

// Tz0NotIn applies the NotIn predicate on the "tz0" field.
func Tz0NotIn(vs ...time.Time) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldTz0), v...))
	})
}

// Tz0GT applies the GT predicate on the "tz0" field.
func Tz0GT(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldTz0), v))
	})
}

// Tz0GTE applies the GTE predicate on the "tz0" field.
func Tz0GTE(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldTz0), v))
	})
}

// Tz0LT applies the LT predicate on the "tz0" field.
func Tz0LT(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldTz0), v))
	})
}

// Tz0LTE applies the LTE predicate on the "tz0" field.
func Tz0LTE(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldTz0), v))
	})
}

// Tz0IsNil applies the IsNil predicate on the "tz0" field.
func Tz0IsNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldTz0)))
	})
}

// Tz0NotNil applies the NotNil predicate on the "tz0" field.
func Tz0NotNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldTz0)))
	})
}

// Tz3EQ applies the EQ predicate on the "tz3" field.
func Tz3EQ(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.EQ(s.C(FieldTz3), v))
	})
}

// Tz3NEQ applies the NEQ predicate on the "tz3" field.
func Tz3NEQ(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NEQ(s.C(FieldTz3), v))
	})
}

// Tz3In applies the In predicate on the "tz3" field.
func Tz3In(vs ...time.Time) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.In(s.C(FieldTz3), v...))
	})
}

// Tz3NotIn applies the NotIn predicate on the "tz3" field.
func Tz3NotIn(vs ...time.Time) predicate.CustomType {
	v := make([]interface{}, len(vs))
	for i := range v {
		v[i] = vs[i]
	}
	return predicate.CustomType(func(s *sql.Selector) {
		// if not arguments were provided, append the FALSE constants,
		// since we can't apply "IN ()". This will make this predicate falsy.
		if len(v) == 0 {
			s.Where(sql.False())
			return
		}
		s.Where(sql.NotIn(s.C(FieldTz3), v...))
	})
}

// Tz3GT applies the GT predicate on the "tz3" field.
func Tz3GT(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GT(s.C(FieldTz3), v))
	})
}

// Tz3GTE applies the GTE predicate on the "tz3" field.
func Tz3GTE(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.GTE(s.C(FieldTz3), v))
	})
}

// Tz3LT applies the LT predicate on the "tz3" field.
func Tz3LT(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LT(s.C(FieldTz3), v))
	})
}

// Tz3LTE applies the LTE predicate on the "tz3" field.
func Tz3LTE(v time.Time) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.LTE(s.C(FieldTz3), v))
	})
}

// Tz3IsNil applies the IsNil predicate on the "tz3" field.
func Tz3IsNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.IsNull(s.C(FieldTz3)))
	})
}

// Tz3NotNil applies the NotNil predicate on the "tz3" field.
func Tz3NotNil() predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s.Where(sql.NotNull(s.C(FieldTz3)))
	})
}

// And groups predicates with the AND operator between them.
func And(predicates ...predicate.CustomType) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for _, p := range predicates {
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Or groups predicates with the OR operator between them.
func Or(predicates ...predicate.CustomType) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		s1 := s.Clone().SetP(nil)
		for i, p := range predicates {
			if i > 0 {
				s1.Or()
			}
			p(s1)
		}
		s.Where(s1.P())
	})
}

// Not applies the not operator on the given predicate.
func Not(p predicate.CustomType) predicate.CustomType {
	return predicate.CustomType(func(s *sql.Selector) {
		p(s.Not())
	})
}
