// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	"net"
	"net/http"
	"time"

	"entgo.io/ent/dialect/gremlin"
	"entgo.io/ent/dialect/gremlin/graph/dsl"
	"entgo.io/ent/dialect/gremlin/graph/dsl/__"
	"entgo.io/ent/dialect/gremlin/graph/dsl/g"
	"entgo.io/ent/entc/integration/ent/role"
	"entgo.io/ent/entc/integration/ent/schema"
	"entgo.io/ent/entc/integration/gremlin/ent/fieldtype"
	"entgo.io/ent/entc/integration/gremlin/ent/predicate"
	"github.com/google/uuid"
)

// FieldTypeUpdate is the builder for updating FieldType entities.
type FieldTypeUpdate struct {
	config
	hooks    []Hook
	mutation *FieldTypeMutation
}

// Where appends a list predicates to the FieldTypeUpdate builder.
func (ftu *FieldTypeUpdate) Where(ps ...predicate.FieldType) *FieldTypeUpdate {
	ftu.mutation.Where(ps...)
	return ftu
}

// SetInt sets the "int" field.
func (ftu *FieldTypeUpdate) SetInt(i int) *FieldTypeUpdate {
	ftu.mutation.ResetInt()
	ftu.mutation.SetInt(i)
	return ftu
}

// AddInt adds i to the "int" field.
func (ftu *FieldTypeUpdate) AddInt(i int) *FieldTypeUpdate {
	ftu.mutation.AddInt(i)
	return ftu
}

// SetInt8 sets the "int8" field.
func (ftu *FieldTypeUpdate) SetInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.ResetInt8()
	ftu.mutation.SetInt8(i)
	return ftu
}

// AddInt8 adds i to the "int8" field.
func (ftu *FieldTypeUpdate) AddInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.AddInt8(i)
	return ftu
}

// SetInt16 sets the "int16" field.
func (ftu *FieldTypeUpdate) SetInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.ResetInt16()
	ftu.mutation.SetInt16(i)
	return ftu
}

// AddInt16 adds i to the "int16" field.
func (ftu *FieldTypeUpdate) AddInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.AddInt16(i)
	return ftu
}

// SetInt32 sets the "int32" field.
func (ftu *FieldTypeUpdate) SetInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.ResetInt32()
	ftu.mutation.SetInt32(i)
	return ftu
}

// AddInt32 adds i to the "int32" field.
func (ftu *FieldTypeUpdate) AddInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.AddInt32(i)
	return ftu
}

// SetInt64 sets the "int64" field.
func (ftu *FieldTypeUpdate) SetInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.ResetInt64()
	ftu.mutation.SetInt64(i)
	return ftu
}

// AddInt64 adds i to the "int64" field.
func (ftu *FieldTypeUpdate) AddInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.AddInt64(i)
	return ftu
}

// SetOptionalInt sets the "optional_int" field.
func (ftu *FieldTypeUpdate) SetOptionalInt(i int) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalInt()
	ftu.mutation.SetOptionalInt(i)
	return ftu
}

// SetNillableOptionalInt sets the "optional_int" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalInt(i *int) *FieldTypeUpdate {
	if i != nil {
		ftu.SetOptionalInt(*i)
	}
	return ftu
}

// AddOptionalInt adds i to the "optional_int" field.
func (ftu *FieldTypeUpdate) AddOptionalInt(i int) *FieldTypeUpdate {
	ftu.mutation.AddOptionalInt(i)
	return ftu
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (ftu *FieldTypeUpdate) ClearOptionalInt() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalInt()
	return ftu
}

// SetOptionalInt8 sets the "optional_int8" field.
func (ftu *FieldTypeUpdate) SetOptionalInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalInt8()
	ftu.mutation.SetOptionalInt8(i)
	return ftu
}

// SetNillableOptionalInt8 sets the "optional_int8" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalInt8(i *int8) *FieldTypeUpdate {
	if i != nil {
		ftu.SetOptionalInt8(*i)
	}
	return ftu
}

// AddOptionalInt8 adds i to the "optional_int8" field.
func (ftu *FieldTypeUpdate) AddOptionalInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.AddOptionalInt8(i)
	return ftu
}

// ClearOptionalInt8 clears the value of the "optional_int8" field.
func (ftu *FieldTypeUpdate) ClearOptionalInt8() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalInt8()
	return ftu
}

// SetOptionalInt16 sets the "optional_int16" field.
func (ftu *FieldTypeUpdate) SetOptionalInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalInt16()
	ftu.mutation.SetOptionalInt16(i)
	return ftu
}

// SetNillableOptionalInt16 sets the "optional_int16" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalInt16(i *int16) *FieldTypeUpdate {
	if i != nil {
		ftu.SetOptionalInt16(*i)
	}
	return ftu
}

// AddOptionalInt16 adds i to the "optional_int16" field.
func (ftu *FieldTypeUpdate) AddOptionalInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.AddOptionalInt16(i)
	return ftu
}

// ClearOptionalInt16 clears the value of the "optional_int16" field.
func (ftu *FieldTypeUpdate) ClearOptionalInt16() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalInt16()
	return ftu
}

// SetOptionalInt32 sets the "optional_int32" field.
func (ftu *FieldTypeUpdate) SetOptionalInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalInt32()
	ftu.mutation.SetOptionalInt32(i)
	return ftu
}

// SetNillableOptionalInt32 sets the "optional_int32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalInt32(i *int32) *FieldTypeUpdate {
	if i != nil {
		ftu.SetOptionalInt32(*i)
	}
	return ftu
}

// AddOptionalInt32 adds i to the "optional_int32" field.
func (ftu *FieldTypeUpdate) AddOptionalInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.AddOptionalInt32(i)
	return ftu
}

// ClearOptionalInt32 clears the value of the "optional_int32" field.
func (ftu *FieldTypeUpdate) ClearOptionalInt32() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalInt32()
	return ftu
}

// SetOptionalInt64 sets the "optional_int64" field.
func (ftu *FieldTypeUpdate) SetOptionalInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalInt64()
	ftu.mutation.SetOptionalInt64(i)
	return ftu
}

// SetNillableOptionalInt64 sets the "optional_int64" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalInt64(i *int64) *FieldTypeUpdate {
	if i != nil {
		ftu.SetOptionalInt64(*i)
	}
	return ftu
}

// AddOptionalInt64 adds i to the "optional_int64" field.
func (ftu *FieldTypeUpdate) AddOptionalInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.AddOptionalInt64(i)
	return ftu
}

// ClearOptionalInt64 clears the value of the "optional_int64" field.
func (ftu *FieldTypeUpdate) ClearOptionalInt64() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalInt64()
	return ftu
}

// SetNillableInt sets the "nillable_int" field.
func (ftu *FieldTypeUpdate) SetNillableInt(i int) *FieldTypeUpdate {
	ftu.mutation.ResetNillableInt()
	ftu.mutation.SetNillableInt(i)
	return ftu
}

// SetNillableNillableInt sets the "nillable_int" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableInt(i *int) *FieldTypeUpdate {
	if i != nil {
		ftu.SetNillableInt(*i)
	}
	return ftu
}

// AddNillableInt adds i to the "nillable_int" field.
func (ftu *FieldTypeUpdate) AddNillableInt(i int) *FieldTypeUpdate {
	ftu.mutation.AddNillableInt(i)
	return ftu
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (ftu *FieldTypeUpdate) ClearNillableInt() *FieldTypeUpdate {
	ftu.mutation.ClearNillableInt()
	return ftu
}

// SetNillableInt8 sets the "nillable_int8" field.
func (ftu *FieldTypeUpdate) SetNillableInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.ResetNillableInt8()
	ftu.mutation.SetNillableInt8(i)
	return ftu
}

// SetNillableNillableInt8 sets the "nillable_int8" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableInt8(i *int8) *FieldTypeUpdate {
	if i != nil {
		ftu.SetNillableInt8(*i)
	}
	return ftu
}

// AddNillableInt8 adds i to the "nillable_int8" field.
func (ftu *FieldTypeUpdate) AddNillableInt8(i int8) *FieldTypeUpdate {
	ftu.mutation.AddNillableInt8(i)
	return ftu
}

// ClearNillableInt8 clears the value of the "nillable_int8" field.
func (ftu *FieldTypeUpdate) ClearNillableInt8() *FieldTypeUpdate {
	ftu.mutation.ClearNillableInt8()
	return ftu
}

// SetNillableInt16 sets the "nillable_int16" field.
func (ftu *FieldTypeUpdate) SetNillableInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.ResetNillableInt16()
	ftu.mutation.SetNillableInt16(i)
	return ftu
}

// SetNillableNillableInt16 sets the "nillable_int16" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableInt16(i *int16) *FieldTypeUpdate {
	if i != nil {
		ftu.SetNillableInt16(*i)
	}
	return ftu
}

// AddNillableInt16 adds i to the "nillable_int16" field.
func (ftu *FieldTypeUpdate) AddNillableInt16(i int16) *FieldTypeUpdate {
	ftu.mutation.AddNillableInt16(i)
	return ftu
}

// ClearNillableInt16 clears the value of the "nillable_int16" field.
func (ftu *FieldTypeUpdate) ClearNillableInt16() *FieldTypeUpdate {
	ftu.mutation.ClearNillableInt16()
	return ftu
}

// SetNillableInt32 sets the "nillable_int32" field.
func (ftu *FieldTypeUpdate) SetNillableInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.ResetNillableInt32()
	ftu.mutation.SetNillableInt32(i)
	return ftu
}

// SetNillableNillableInt32 sets the "nillable_int32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableInt32(i *int32) *FieldTypeUpdate {
	if i != nil {
		ftu.SetNillableInt32(*i)
	}
	return ftu
}

// AddNillableInt32 adds i to the "nillable_int32" field.
func (ftu *FieldTypeUpdate) AddNillableInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.AddNillableInt32(i)
	return ftu
}

// ClearNillableInt32 clears the value of the "nillable_int32" field.
func (ftu *FieldTypeUpdate) ClearNillableInt32() *FieldTypeUpdate {
	ftu.mutation.ClearNillableInt32()
	return ftu
}

// SetNillableInt64 sets the "nillable_int64" field.
func (ftu *FieldTypeUpdate) SetNillableInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.ResetNillableInt64()
	ftu.mutation.SetNillableInt64(i)
	return ftu
}

// SetNillableNillableInt64 sets the "nillable_int64" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableInt64(i *int64) *FieldTypeUpdate {
	if i != nil {
		ftu.SetNillableInt64(*i)
	}
	return ftu
}

// AddNillableInt64 adds i to the "nillable_int64" field.
func (ftu *FieldTypeUpdate) AddNillableInt64(i int64) *FieldTypeUpdate {
	ftu.mutation.AddNillableInt64(i)
	return ftu
}

// ClearNillableInt64 clears the value of the "nillable_int64" field.
func (ftu *FieldTypeUpdate) ClearNillableInt64() *FieldTypeUpdate {
	ftu.mutation.ClearNillableInt64()
	return ftu
}

// SetValidateOptionalInt32 sets the "validate_optional_int32" field.
func (ftu *FieldTypeUpdate) SetValidateOptionalInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.ResetValidateOptionalInt32()
	ftu.mutation.SetValidateOptionalInt32(i)
	return ftu
}

// SetNillableValidateOptionalInt32 sets the "validate_optional_int32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableValidateOptionalInt32(i *int32) *FieldTypeUpdate {
	if i != nil {
		ftu.SetValidateOptionalInt32(*i)
	}
	return ftu
}

// AddValidateOptionalInt32 adds i to the "validate_optional_int32" field.
func (ftu *FieldTypeUpdate) AddValidateOptionalInt32(i int32) *FieldTypeUpdate {
	ftu.mutation.AddValidateOptionalInt32(i)
	return ftu
}

// ClearValidateOptionalInt32 clears the value of the "validate_optional_int32" field.
func (ftu *FieldTypeUpdate) ClearValidateOptionalInt32() *FieldTypeUpdate {
	ftu.mutation.ClearValidateOptionalInt32()
	return ftu
}

// SetOptionalUint sets the "optional_uint" field.
func (ftu *FieldTypeUpdate) SetOptionalUint(u uint) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalUint()
	ftu.mutation.SetOptionalUint(u)
	return ftu
}

// SetNillableOptionalUint sets the "optional_uint" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUint(u *uint) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUint(*u)
	}
	return ftu
}

// AddOptionalUint adds u to the "optional_uint" field.
func (ftu *FieldTypeUpdate) AddOptionalUint(u int) *FieldTypeUpdate {
	ftu.mutation.AddOptionalUint(u)
	return ftu
}

// ClearOptionalUint clears the value of the "optional_uint" field.
func (ftu *FieldTypeUpdate) ClearOptionalUint() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUint()
	return ftu
}

// SetOptionalUint8 sets the "optional_uint8" field.
func (ftu *FieldTypeUpdate) SetOptionalUint8(u uint8) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalUint8()
	ftu.mutation.SetOptionalUint8(u)
	return ftu
}

// SetNillableOptionalUint8 sets the "optional_uint8" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUint8(u *uint8) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUint8(*u)
	}
	return ftu
}

// AddOptionalUint8 adds u to the "optional_uint8" field.
func (ftu *FieldTypeUpdate) AddOptionalUint8(u int8) *FieldTypeUpdate {
	ftu.mutation.AddOptionalUint8(u)
	return ftu
}

// ClearOptionalUint8 clears the value of the "optional_uint8" field.
func (ftu *FieldTypeUpdate) ClearOptionalUint8() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUint8()
	return ftu
}

// SetOptionalUint16 sets the "optional_uint16" field.
func (ftu *FieldTypeUpdate) SetOptionalUint16(u uint16) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalUint16()
	ftu.mutation.SetOptionalUint16(u)
	return ftu
}

// SetNillableOptionalUint16 sets the "optional_uint16" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUint16(u *uint16) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUint16(*u)
	}
	return ftu
}

// AddOptionalUint16 adds u to the "optional_uint16" field.
func (ftu *FieldTypeUpdate) AddOptionalUint16(u int16) *FieldTypeUpdate {
	ftu.mutation.AddOptionalUint16(u)
	return ftu
}

// ClearOptionalUint16 clears the value of the "optional_uint16" field.
func (ftu *FieldTypeUpdate) ClearOptionalUint16() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUint16()
	return ftu
}

// SetOptionalUint32 sets the "optional_uint32" field.
func (ftu *FieldTypeUpdate) SetOptionalUint32(u uint32) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalUint32()
	ftu.mutation.SetOptionalUint32(u)
	return ftu
}

// SetNillableOptionalUint32 sets the "optional_uint32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUint32(u *uint32) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUint32(*u)
	}
	return ftu
}

// AddOptionalUint32 adds u to the "optional_uint32" field.
func (ftu *FieldTypeUpdate) AddOptionalUint32(u int32) *FieldTypeUpdate {
	ftu.mutation.AddOptionalUint32(u)
	return ftu
}

// ClearOptionalUint32 clears the value of the "optional_uint32" field.
func (ftu *FieldTypeUpdate) ClearOptionalUint32() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUint32()
	return ftu
}

// SetOptionalUint64 sets the "optional_uint64" field.
func (ftu *FieldTypeUpdate) SetOptionalUint64(u uint64) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalUint64()
	ftu.mutation.SetOptionalUint64(u)
	return ftu
}

// SetNillableOptionalUint64 sets the "optional_uint64" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUint64(u *uint64) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUint64(*u)
	}
	return ftu
}

// AddOptionalUint64 adds u to the "optional_uint64" field.
func (ftu *FieldTypeUpdate) AddOptionalUint64(u int64) *FieldTypeUpdate {
	ftu.mutation.AddOptionalUint64(u)
	return ftu
}

// ClearOptionalUint64 clears the value of the "optional_uint64" field.
func (ftu *FieldTypeUpdate) ClearOptionalUint64() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUint64()
	return ftu
}

// SetState sets the "state" field.
func (ftu *FieldTypeUpdate) SetState(f fieldtype.State) *FieldTypeUpdate {
	ftu.mutation.SetState(f)
	return ftu
}

// SetNillableState sets the "state" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableState(f *fieldtype.State) *FieldTypeUpdate {
	if f != nil {
		ftu.SetState(*f)
	}
	return ftu
}

// ClearState clears the value of the "state" field.
func (ftu *FieldTypeUpdate) ClearState() *FieldTypeUpdate {
	ftu.mutation.ClearState()
	return ftu
}

// SetOptionalFloat sets the "optional_float" field.
func (ftu *FieldTypeUpdate) SetOptionalFloat(f float64) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalFloat()
	ftu.mutation.SetOptionalFloat(f)
	return ftu
}

// SetNillableOptionalFloat sets the "optional_float" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalFloat(f *float64) *FieldTypeUpdate {
	if f != nil {
		ftu.SetOptionalFloat(*f)
	}
	return ftu
}

// AddOptionalFloat adds f to the "optional_float" field.
func (ftu *FieldTypeUpdate) AddOptionalFloat(f float64) *FieldTypeUpdate {
	ftu.mutation.AddOptionalFloat(f)
	return ftu
}

// ClearOptionalFloat clears the value of the "optional_float" field.
func (ftu *FieldTypeUpdate) ClearOptionalFloat() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalFloat()
	return ftu
}

// SetOptionalFloat32 sets the "optional_float32" field.
func (ftu *FieldTypeUpdate) SetOptionalFloat32(f float32) *FieldTypeUpdate {
	ftu.mutation.ResetOptionalFloat32()
	ftu.mutation.SetOptionalFloat32(f)
	return ftu
}

// SetNillableOptionalFloat32 sets the "optional_float32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalFloat32(f *float32) *FieldTypeUpdate {
	if f != nil {
		ftu.SetOptionalFloat32(*f)
	}
	return ftu
}

// AddOptionalFloat32 adds f to the "optional_float32" field.
func (ftu *FieldTypeUpdate) AddOptionalFloat32(f float32) *FieldTypeUpdate {
	ftu.mutation.AddOptionalFloat32(f)
	return ftu
}

// ClearOptionalFloat32 clears the value of the "optional_float32" field.
func (ftu *FieldTypeUpdate) ClearOptionalFloat32() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalFloat32()
	return ftu
}

// SetText sets the "text" field.
func (ftu *FieldTypeUpdate) SetText(s string) *FieldTypeUpdate {
	ftu.mutation.SetText(s)
	return ftu
}

// SetNillableText sets the "text" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableText(s *string) *FieldTypeUpdate {
	if s != nil {
		ftu.SetText(*s)
	}
	return ftu
}

// ClearText clears the value of the "text" field.
func (ftu *FieldTypeUpdate) ClearText() *FieldTypeUpdate {
	ftu.mutation.ClearText()
	return ftu
}

// SetDatetime sets the "datetime" field.
func (ftu *FieldTypeUpdate) SetDatetime(t time.Time) *FieldTypeUpdate {
	ftu.mutation.SetDatetime(t)
	return ftu
}

// SetNillableDatetime sets the "datetime" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableDatetime(t *time.Time) *FieldTypeUpdate {
	if t != nil {
		ftu.SetDatetime(*t)
	}
	return ftu
}

// ClearDatetime clears the value of the "datetime" field.
func (ftu *FieldTypeUpdate) ClearDatetime() *FieldTypeUpdate {
	ftu.mutation.ClearDatetime()
	return ftu
}

// SetDecimal sets the "decimal" field.
func (ftu *FieldTypeUpdate) SetDecimal(f float64) *FieldTypeUpdate {
	ftu.mutation.ResetDecimal()
	ftu.mutation.SetDecimal(f)
	return ftu
}

// SetNillableDecimal sets the "decimal" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableDecimal(f *float64) *FieldTypeUpdate {
	if f != nil {
		ftu.SetDecimal(*f)
	}
	return ftu
}

// AddDecimal adds f to the "decimal" field.
func (ftu *FieldTypeUpdate) AddDecimal(f float64) *FieldTypeUpdate {
	ftu.mutation.AddDecimal(f)
	return ftu
}

// ClearDecimal clears the value of the "decimal" field.
func (ftu *FieldTypeUpdate) ClearDecimal() *FieldTypeUpdate {
	ftu.mutation.ClearDecimal()
	return ftu
}

// SetLinkOther sets the "link_other" field.
func (ftu *FieldTypeUpdate) SetLinkOther(s *schema.Link) *FieldTypeUpdate {
	ftu.mutation.SetLinkOther(s)
	return ftu
}

// ClearLinkOther clears the value of the "link_other" field.
func (ftu *FieldTypeUpdate) ClearLinkOther() *FieldTypeUpdate {
	ftu.mutation.ClearLinkOther()
	return ftu
}

// SetLinkOtherFunc sets the "link_other_func" field.
func (ftu *FieldTypeUpdate) SetLinkOtherFunc(s *schema.Link) *FieldTypeUpdate {
	ftu.mutation.SetLinkOtherFunc(s)
	return ftu
}

// ClearLinkOtherFunc clears the value of the "link_other_func" field.
func (ftu *FieldTypeUpdate) ClearLinkOtherFunc() *FieldTypeUpdate {
	ftu.mutation.ClearLinkOtherFunc()
	return ftu
}

// SetMAC sets the "mac" field.
func (ftu *FieldTypeUpdate) SetMAC(s schema.MAC) *FieldTypeUpdate {
	ftu.mutation.SetMAC(s)
	return ftu
}

// SetNillableMAC sets the "mac" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableMAC(s *schema.MAC) *FieldTypeUpdate {
	if s != nil {
		ftu.SetMAC(*s)
	}
	return ftu
}

// ClearMAC clears the value of the "mac" field.
func (ftu *FieldTypeUpdate) ClearMAC() *FieldTypeUpdate {
	ftu.mutation.ClearMAC()
	return ftu
}

// SetStringArray sets the "string_array" field.
func (ftu *FieldTypeUpdate) SetStringArray(s schema.Strings) *FieldTypeUpdate {
	ftu.mutation.SetStringArray(s)
	return ftu
}

// ClearStringArray clears the value of the "string_array" field.
func (ftu *FieldTypeUpdate) ClearStringArray() *FieldTypeUpdate {
	ftu.mutation.ClearStringArray()
	return ftu
}

// SetPassword sets the "password" field.
func (ftu *FieldTypeUpdate) SetPassword(s string) *FieldTypeUpdate {
	ftu.mutation.SetPassword(s)
	return ftu
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillablePassword(s *string) *FieldTypeUpdate {
	if s != nil {
		ftu.SetPassword(*s)
	}
	return ftu
}

// ClearPassword clears the value of the "password" field.
func (ftu *FieldTypeUpdate) ClearPassword() *FieldTypeUpdate {
	ftu.mutation.ClearPassword()
	return ftu
}

// SetStringScanner sets the "string_scanner" field.
func (ftu *FieldTypeUpdate) SetStringScanner(ss schema.StringScanner) *FieldTypeUpdate {
	ftu.mutation.SetStringScanner(ss)
	return ftu
}

// SetNillableStringScanner sets the "string_scanner" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableStringScanner(ss *schema.StringScanner) *FieldTypeUpdate {
	if ss != nil {
		ftu.SetStringScanner(*ss)
	}
	return ftu
}

// ClearStringScanner clears the value of the "string_scanner" field.
func (ftu *FieldTypeUpdate) ClearStringScanner() *FieldTypeUpdate {
	ftu.mutation.ClearStringScanner()
	return ftu
}

// SetDuration sets the "duration" field.
func (ftu *FieldTypeUpdate) SetDuration(t time.Duration) *FieldTypeUpdate {
	ftu.mutation.ResetDuration()
	ftu.mutation.SetDuration(t)
	return ftu
}

// AddDuration adds t to the "duration" field.
func (ftu *FieldTypeUpdate) AddDuration(t time.Duration) *FieldTypeUpdate {
	ftu.mutation.AddDuration(t)
	return ftu
}

// ClearDuration clears the value of the "duration" field.
func (ftu *FieldTypeUpdate) ClearDuration() *FieldTypeUpdate {
	ftu.mutation.ClearDuration()
	return ftu
}

// SetDir sets the "dir" field.
func (ftu *FieldTypeUpdate) SetDir(h http.Dir) *FieldTypeUpdate {
	ftu.mutation.SetDir(h)
	return ftu
}

// SetNillableDir sets the "dir" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableDir(h *http.Dir) *FieldTypeUpdate {
	if h != nil {
		ftu.SetDir(*h)
	}
	return ftu
}

// SetNdir sets the "ndir" field.
func (ftu *FieldTypeUpdate) SetNdir(h http.Dir) *FieldTypeUpdate {
	ftu.mutation.SetNdir(h)
	return ftu
}

// SetNillableNdir sets the "ndir" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNdir(h *http.Dir) *FieldTypeUpdate {
	if h != nil {
		ftu.SetNdir(*h)
	}
	return ftu
}

// ClearNdir clears the value of the "ndir" field.
func (ftu *FieldTypeUpdate) ClearNdir() *FieldTypeUpdate {
	ftu.mutation.ClearNdir()
	return ftu
}

// SetStr sets the "str" field.
func (ftu *FieldTypeUpdate) SetStr(ss sql.NullString) *FieldTypeUpdate {
	ftu.mutation.SetStr(ss)
	return ftu
}

// SetNillableStr sets the "str" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableStr(ss *sql.NullString) *FieldTypeUpdate {
	if ss != nil {
		ftu.SetStr(*ss)
	}
	return ftu
}

// ClearStr clears the value of the "str" field.
func (ftu *FieldTypeUpdate) ClearStr() *FieldTypeUpdate {
	ftu.mutation.ClearStr()
	return ftu
}

// SetNullStr sets the "null_str" field.
func (ftu *FieldTypeUpdate) SetNullStr(ss *sql.NullString) *FieldTypeUpdate {
	ftu.mutation.SetNullStr(ss)
	return ftu
}

// ClearNullStr clears the value of the "null_str" field.
func (ftu *FieldTypeUpdate) ClearNullStr() *FieldTypeUpdate {
	ftu.mutation.ClearNullStr()
	return ftu
}

// SetLink sets the "link" field.
func (ftu *FieldTypeUpdate) SetLink(s schema.Link) *FieldTypeUpdate {
	ftu.mutation.SetLink(s)
	return ftu
}

// SetNillableLink sets the "link" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableLink(s *schema.Link) *FieldTypeUpdate {
	if s != nil {
		ftu.SetLink(*s)
	}
	return ftu
}

// ClearLink clears the value of the "link" field.
func (ftu *FieldTypeUpdate) ClearLink() *FieldTypeUpdate {
	ftu.mutation.ClearLink()
	return ftu
}

// SetNullLink sets the "null_link" field.
func (ftu *FieldTypeUpdate) SetNullLink(s *schema.Link) *FieldTypeUpdate {
	ftu.mutation.SetNullLink(s)
	return ftu
}

// ClearNullLink clears the value of the "null_link" field.
func (ftu *FieldTypeUpdate) ClearNullLink() *FieldTypeUpdate {
	ftu.mutation.ClearNullLink()
	return ftu
}

// SetActive sets the "active" field.
func (ftu *FieldTypeUpdate) SetActive(s schema.Status) *FieldTypeUpdate {
	ftu.mutation.SetActive(s)
	return ftu
}

// SetNillableActive sets the "active" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableActive(s *schema.Status) *FieldTypeUpdate {
	if s != nil {
		ftu.SetActive(*s)
	}
	return ftu
}

// ClearActive clears the value of the "active" field.
func (ftu *FieldTypeUpdate) ClearActive() *FieldTypeUpdate {
	ftu.mutation.ClearActive()
	return ftu
}

// SetNullActive sets the "null_active" field.
func (ftu *FieldTypeUpdate) SetNullActive(s schema.Status) *FieldTypeUpdate {
	ftu.mutation.SetNullActive(s)
	return ftu
}

// SetNillableNullActive sets the "null_active" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNullActive(s *schema.Status) *FieldTypeUpdate {
	if s != nil {
		ftu.SetNullActive(*s)
	}
	return ftu
}

// ClearNullActive clears the value of the "null_active" field.
func (ftu *FieldTypeUpdate) ClearNullActive() *FieldTypeUpdate {
	ftu.mutation.ClearNullActive()
	return ftu
}

// SetDeleted sets the "deleted" field.
func (ftu *FieldTypeUpdate) SetDeleted(sb *sql.NullBool) *FieldTypeUpdate {
	ftu.mutation.SetDeleted(sb)
	return ftu
}

// ClearDeleted clears the value of the "deleted" field.
func (ftu *FieldTypeUpdate) ClearDeleted() *FieldTypeUpdate {
	ftu.mutation.ClearDeleted()
	return ftu
}

// SetDeletedAt sets the "deleted_at" field.
func (ftu *FieldTypeUpdate) SetDeletedAt(st *sql.NullTime) *FieldTypeUpdate {
	ftu.mutation.SetDeletedAt(st)
	return ftu
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (ftu *FieldTypeUpdate) ClearDeletedAt() *FieldTypeUpdate {
	ftu.mutation.ClearDeletedAt()
	return ftu
}

// SetRawData sets the "raw_data" field.
func (ftu *FieldTypeUpdate) SetRawData(b []byte) *FieldTypeUpdate {
	ftu.mutation.SetRawData(b)
	return ftu
}

// ClearRawData clears the value of the "raw_data" field.
func (ftu *FieldTypeUpdate) ClearRawData() *FieldTypeUpdate {
	ftu.mutation.ClearRawData()
	return ftu
}

// SetSensitive sets the "sensitive" field.
func (ftu *FieldTypeUpdate) SetSensitive(b []byte) *FieldTypeUpdate {
	ftu.mutation.SetSensitive(b)
	return ftu
}

// ClearSensitive clears the value of the "sensitive" field.
func (ftu *FieldTypeUpdate) ClearSensitive() *FieldTypeUpdate {
	ftu.mutation.ClearSensitive()
	return ftu
}

// SetIP sets the "ip" field.
func (ftu *FieldTypeUpdate) SetIP(n net.IP) *FieldTypeUpdate {
	ftu.mutation.SetIP(n)
	return ftu
}

// ClearIP clears the value of the "ip" field.
func (ftu *FieldTypeUpdate) ClearIP() *FieldTypeUpdate {
	ftu.mutation.ClearIP()
	return ftu
}

// SetNullInt64 sets the "null_int64" field.
func (ftu *FieldTypeUpdate) SetNullInt64(si *sql.NullInt64) *FieldTypeUpdate {
	ftu.mutation.SetNullInt64(si)
	return ftu
}

// ClearNullInt64 clears the value of the "null_int64" field.
func (ftu *FieldTypeUpdate) ClearNullInt64() *FieldTypeUpdate {
	ftu.mutation.ClearNullInt64()
	return ftu
}

// SetSchemaInt sets the "schema_int" field.
func (ftu *FieldTypeUpdate) SetSchemaInt(s schema.Int) *FieldTypeUpdate {
	ftu.mutation.ResetSchemaInt()
	ftu.mutation.SetSchemaInt(s)
	return ftu
}

// SetNillableSchemaInt sets the "schema_int" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableSchemaInt(s *schema.Int) *FieldTypeUpdate {
	if s != nil {
		ftu.SetSchemaInt(*s)
	}
	return ftu
}

// AddSchemaInt adds s to the "schema_int" field.
func (ftu *FieldTypeUpdate) AddSchemaInt(s schema.Int) *FieldTypeUpdate {
	ftu.mutation.AddSchemaInt(s)
	return ftu
}

// ClearSchemaInt clears the value of the "schema_int" field.
func (ftu *FieldTypeUpdate) ClearSchemaInt() *FieldTypeUpdate {
	ftu.mutation.ClearSchemaInt()
	return ftu
}

// SetSchemaInt8 sets the "schema_int8" field.
func (ftu *FieldTypeUpdate) SetSchemaInt8(s schema.Int8) *FieldTypeUpdate {
	ftu.mutation.ResetSchemaInt8()
	ftu.mutation.SetSchemaInt8(s)
	return ftu
}

// SetNillableSchemaInt8 sets the "schema_int8" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableSchemaInt8(s *schema.Int8) *FieldTypeUpdate {
	if s != nil {
		ftu.SetSchemaInt8(*s)
	}
	return ftu
}

// AddSchemaInt8 adds s to the "schema_int8" field.
func (ftu *FieldTypeUpdate) AddSchemaInt8(s schema.Int8) *FieldTypeUpdate {
	ftu.mutation.AddSchemaInt8(s)
	return ftu
}

// ClearSchemaInt8 clears the value of the "schema_int8" field.
func (ftu *FieldTypeUpdate) ClearSchemaInt8() *FieldTypeUpdate {
	ftu.mutation.ClearSchemaInt8()
	return ftu
}

// SetSchemaInt64 sets the "schema_int64" field.
func (ftu *FieldTypeUpdate) SetSchemaInt64(s schema.Int64) *FieldTypeUpdate {
	ftu.mutation.ResetSchemaInt64()
	ftu.mutation.SetSchemaInt64(s)
	return ftu
}

// SetNillableSchemaInt64 sets the "schema_int64" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableSchemaInt64(s *schema.Int64) *FieldTypeUpdate {
	if s != nil {
		ftu.SetSchemaInt64(*s)
	}
	return ftu
}

// AddSchemaInt64 adds s to the "schema_int64" field.
func (ftu *FieldTypeUpdate) AddSchemaInt64(s schema.Int64) *FieldTypeUpdate {
	ftu.mutation.AddSchemaInt64(s)
	return ftu
}

// ClearSchemaInt64 clears the value of the "schema_int64" field.
func (ftu *FieldTypeUpdate) ClearSchemaInt64() *FieldTypeUpdate {
	ftu.mutation.ClearSchemaInt64()
	return ftu
}

// SetSchemaFloat sets the "schema_float" field.
func (ftu *FieldTypeUpdate) SetSchemaFloat(s schema.Float64) *FieldTypeUpdate {
	ftu.mutation.ResetSchemaFloat()
	ftu.mutation.SetSchemaFloat(s)
	return ftu
}

// SetNillableSchemaFloat sets the "schema_float" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableSchemaFloat(s *schema.Float64) *FieldTypeUpdate {
	if s != nil {
		ftu.SetSchemaFloat(*s)
	}
	return ftu
}

// AddSchemaFloat adds s to the "schema_float" field.
func (ftu *FieldTypeUpdate) AddSchemaFloat(s schema.Float64) *FieldTypeUpdate {
	ftu.mutation.AddSchemaFloat(s)
	return ftu
}

// ClearSchemaFloat clears the value of the "schema_float" field.
func (ftu *FieldTypeUpdate) ClearSchemaFloat() *FieldTypeUpdate {
	ftu.mutation.ClearSchemaFloat()
	return ftu
}

// SetSchemaFloat32 sets the "schema_float32" field.
func (ftu *FieldTypeUpdate) SetSchemaFloat32(s schema.Float32) *FieldTypeUpdate {
	ftu.mutation.ResetSchemaFloat32()
	ftu.mutation.SetSchemaFloat32(s)
	return ftu
}

// SetNillableSchemaFloat32 sets the "schema_float32" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableSchemaFloat32(s *schema.Float32) *FieldTypeUpdate {
	if s != nil {
		ftu.SetSchemaFloat32(*s)
	}
	return ftu
}

// AddSchemaFloat32 adds s to the "schema_float32" field.
func (ftu *FieldTypeUpdate) AddSchemaFloat32(s schema.Float32) *FieldTypeUpdate {
	ftu.mutation.AddSchemaFloat32(s)
	return ftu
}

// ClearSchemaFloat32 clears the value of the "schema_float32" field.
func (ftu *FieldTypeUpdate) ClearSchemaFloat32() *FieldTypeUpdate {
	ftu.mutation.ClearSchemaFloat32()
	return ftu
}

// SetNullFloat sets the "null_float" field.
func (ftu *FieldTypeUpdate) SetNullFloat(sf *sql.NullFloat64) *FieldTypeUpdate {
	ftu.mutation.SetNullFloat(sf)
	return ftu
}

// ClearNullFloat clears the value of the "null_float" field.
func (ftu *FieldTypeUpdate) ClearNullFloat() *FieldTypeUpdate {
	ftu.mutation.ClearNullFloat()
	return ftu
}

// SetRole sets the "role" field.
func (ftu *FieldTypeUpdate) SetRole(r role.Role) *FieldTypeUpdate {
	ftu.mutation.SetRole(r)
	return ftu
}

// SetNillableRole sets the "role" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableRole(r *role.Role) *FieldTypeUpdate {
	if r != nil {
		ftu.SetRole(*r)
	}
	return ftu
}

// SetPriority sets the "priority" field.
func (ftu *FieldTypeUpdate) SetPriority(r role.Priority) *FieldTypeUpdate {
	ftu.mutation.SetPriority(r)
	return ftu
}

// SetNillablePriority sets the "priority" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillablePriority(r *role.Priority) *FieldTypeUpdate {
	if r != nil {
		ftu.SetPriority(*r)
	}
	return ftu
}

// ClearPriority clears the value of the "priority" field.
func (ftu *FieldTypeUpdate) ClearPriority() *FieldTypeUpdate {
	ftu.mutation.ClearPriority()
	return ftu
}

// SetOptionalUUID sets the "optional_uuid" field.
func (ftu *FieldTypeUpdate) SetOptionalUUID(u uuid.UUID) *FieldTypeUpdate {
	ftu.mutation.SetOptionalUUID(u)
	return ftu
}

// SetNillableOptionalUUID sets the "optional_uuid" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableOptionalUUID(u *uuid.UUID) *FieldTypeUpdate {
	if u != nil {
		ftu.SetOptionalUUID(*u)
	}
	return ftu
}

// ClearOptionalUUID clears the value of the "optional_uuid" field.
func (ftu *FieldTypeUpdate) ClearOptionalUUID() *FieldTypeUpdate {
	ftu.mutation.ClearOptionalUUID()
	return ftu
}

// SetNillableUUID sets the "nillable_uuid" field.
func (ftu *FieldTypeUpdate) SetNillableUUID(u uuid.UUID) *FieldTypeUpdate {
	ftu.mutation.SetNillableUUID(u)
	return ftu
}

// SetNillableNillableUUID sets the "nillable_uuid" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableNillableUUID(u *uuid.UUID) *FieldTypeUpdate {
	if u != nil {
		ftu.SetNillableUUID(*u)
	}
	return ftu
}

// ClearNillableUUID clears the value of the "nillable_uuid" field.
func (ftu *FieldTypeUpdate) ClearNillableUUID() *FieldTypeUpdate {
	ftu.mutation.ClearNillableUUID()
	return ftu
}

// SetStrings sets the "strings" field.
func (ftu *FieldTypeUpdate) SetStrings(s []string) *FieldTypeUpdate {
	ftu.mutation.SetStrings(s)
	return ftu
}

// ClearStrings clears the value of the "strings" field.
func (ftu *FieldTypeUpdate) ClearStrings() *FieldTypeUpdate {
	ftu.mutation.ClearStrings()
	return ftu
}

// SetPair sets the "pair" field.
func (ftu *FieldTypeUpdate) SetPair(s schema.Pair) *FieldTypeUpdate {
	ftu.mutation.SetPair(s)
	return ftu
}

// SetNillablePair sets the "pair" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillablePair(s *schema.Pair) *FieldTypeUpdate {
	if s != nil {
		ftu.SetPair(*s)
	}
	return ftu
}

// SetNilPair sets the "nil_pair" field.
func (ftu *FieldTypeUpdate) SetNilPair(s *schema.Pair) *FieldTypeUpdate {
	ftu.mutation.SetNilPair(s)
	return ftu
}

// ClearNilPair clears the value of the "nil_pair" field.
func (ftu *FieldTypeUpdate) ClearNilPair() *FieldTypeUpdate {
	ftu.mutation.ClearNilPair()
	return ftu
}

// SetVstring sets the "vstring" field.
func (ftu *FieldTypeUpdate) SetVstring(ss schema.VString) *FieldTypeUpdate {
	ftu.mutation.SetVstring(ss)
	return ftu
}

// SetNillableVstring sets the "vstring" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableVstring(ss *schema.VString) *FieldTypeUpdate {
	if ss != nil {
		ftu.SetVstring(*ss)
	}
	return ftu
}

// SetTriple sets the "triple" field.
func (ftu *FieldTypeUpdate) SetTriple(s schema.Triple) *FieldTypeUpdate {
	ftu.mutation.SetTriple(s)
	return ftu
}

// SetNillableTriple sets the "triple" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableTriple(s *schema.Triple) *FieldTypeUpdate {
	if s != nil {
		ftu.SetTriple(*s)
	}
	return ftu
}

// SetBigInt sets the "big_int" field.
func (ftu *FieldTypeUpdate) SetBigInt(si schema.BigInt) *FieldTypeUpdate {
	ftu.mutation.ResetBigInt()
	ftu.mutation.SetBigInt(si)
	return ftu
}

// SetNillableBigInt sets the "big_int" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillableBigInt(si *schema.BigInt) *FieldTypeUpdate {
	if si != nil {
		ftu.SetBigInt(*si)
	}
	return ftu
}

// AddBigInt adds si to the "big_int" field.
func (ftu *FieldTypeUpdate) AddBigInt(si schema.BigInt) *FieldTypeUpdate {
	ftu.mutation.AddBigInt(si)
	return ftu
}

// ClearBigInt clears the value of the "big_int" field.
func (ftu *FieldTypeUpdate) ClearBigInt() *FieldTypeUpdate {
	ftu.mutation.ClearBigInt()
	return ftu
}

// SetPasswordOther sets the "password_other" field.
func (ftu *FieldTypeUpdate) SetPasswordOther(s schema.Password) *FieldTypeUpdate {
	ftu.mutation.SetPasswordOther(s)
	return ftu
}

// SetNillablePasswordOther sets the "password_other" field if the given value is not nil.
func (ftu *FieldTypeUpdate) SetNillablePasswordOther(s *schema.Password) *FieldTypeUpdate {
	if s != nil {
		ftu.SetPasswordOther(*s)
	}
	return ftu
}

// ClearPasswordOther clears the value of the "password_other" field.
func (ftu *FieldTypeUpdate) ClearPasswordOther() *FieldTypeUpdate {
	ftu.mutation.ClearPasswordOther()
	return ftu
}

// Mutation returns the FieldTypeMutation object of the builder.
func (ftu *FieldTypeUpdate) Mutation() *FieldTypeMutation {
	return ftu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (ftu *FieldTypeUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	ftu.defaults()
	if len(ftu.hooks) == 0 {
		if err = ftu.check(); err != nil {
			return 0, err
		}
		affected, err = ftu.gremlinSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*FieldTypeMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = ftu.check(); err != nil {
				return 0, err
			}
			ftu.mutation = mutation
			affected, err = ftu.gremlinSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(ftu.hooks) - 1; i >= 0; i-- {
			if ftu.hooks[i] == nil {
				return 0, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ftu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, ftu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (ftu *FieldTypeUpdate) SaveX(ctx context.Context) int {
	affected, err := ftu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (ftu *FieldTypeUpdate) Exec(ctx context.Context) error {
	_, err := ftu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ftu *FieldTypeUpdate) ExecX(ctx context.Context) {
	if err := ftu.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ftu *FieldTypeUpdate) defaults() {
	if _, ok := ftu.mutation.Int64(); !ok {
		v := fieldtype.UpdateDefaultInt64()
		ftu.mutation.SetInt64(v)
	}
	if _, ok := ftu.mutation.Duration(); !ok && !ftu.mutation.DurationCleared() {
		v := fieldtype.UpdateDefaultDuration()
		ftu.mutation.SetDuration(v)
	}
	if _, ok := ftu.mutation.DeletedAt(); !ok && !ftu.mutation.DeletedAtCleared() {
		v := fieldtype.UpdateDefaultDeletedAt()
		ftu.mutation.SetDeletedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ftu *FieldTypeUpdate) check() error {
	if v, ok := ftu.mutation.ValidateOptionalInt32(); ok {
		if err := fieldtype.ValidateOptionalInt32Validator(v); err != nil {
			return &ValidationError{Name: "validate_optional_int32", err: fmt.Errorf(`ent: validator failed for field "FieldType.validate_optional_int32": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.State(); ok {
		if err := fieldtype.StateValidator(v); err != nil {
			return &ValidationError{Name: "state", err: fmt.Errorf(`ent: validator failed for field "FieldType.state": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.MAC(); ok {
		if err := fieldtype.MACValidator(v.String()); err != nil {
			return &ValidationError{Name: "mac", err: fmt.Errorf(`ent: validator failed for field "FieldType.mac": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.Ndir(); ok {
		if err := fieldtype.NdirValidator(string(v)); err != nil {
			return &ValidationError{Name: "ndir", err: fmt.Errorf(`ent: validator failed for field "FieldType.ndir": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.Link(); ok {
		if err := fieldtype.LinkValidator(v.String()); err != nil {
			return &ValidationError{Name: "link", err: fmt.Errorf(`ent: validator failed for field "FieldType.link": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.RawData(); ok {
		if err := fieldtype.RawDataValidator(v); err != nil {
			return &ValidationError{Name: "raw_data", err: fmt.Errorf(`ent: validator failed for field "FieldType.raw_data": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.IP(); ok {
		if err := fieldtype.IPValidator([]byte(v)); err != nil {
			return &ValidationError{Name: "ip", err: fmt.Errorf(`ent: validator failed for field "FieldType.ip": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.Role(); ok {
		if err := fieldtype.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf(`ent: validator failed for field "FieldType.role": %w`, err)}
		}
	}
	if v, ok := ftu.mutation.Priority(); ok {
		if err := fieldtype.PriorityValidator(v); err != nil {
			return &ValidationError{Name: "priority", err: fmt.Errorf(`ent: validator failed for field "FieldType.priority": %w`, err)}
		}
	}
	return nil
}

func (ftu *FieldTypeUpdate) gremlinSave(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := ftu.gremlin().Query()
	if err := ftu.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	if err, ok := isConstantError(res); ok {
		return 0, err
	}
	return res.ReadInt()
}

func (ftu *FieldTypeUpdate) gremlin() *dsl.Traversal {
	v := g.V().HasLabel(fieldtype.Label)
	for _, p := range ftu.mutation.predicates {
		p(v)
	}
	var (
		trs []*dsl.Traversal
	)
	if value, ok := ftu.mutation.Int(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt, value)
	}
	if value, ok := ftu.mutation.AddedInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt, __.Union(__.Values(fieldtype.FieldInt), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Int8(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt8, value)
	}
	if value, ok := ftu.mutation.AddedInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt8, __.Union(__.Values(fieldtype.FieldInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Int16(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt16, value)
	}
	if value, ok := ftu.mutation.AddedInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt16, __.Union(__.Values(fieldtype.FieldInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Int32(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt32, value)
	}
	if value, ok := ftu.mutation.AddedInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt32, __.Union(__.Values(fieldtype.FieldInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Int64(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt64, value)
	}
	if value, ok := ftu.mutation.AddedInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt64, __.Union(__.Values(fieldtype.FieldInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt, value)
	}
	if value, ok := ftu.mutation.AddedOptionalInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt, __.Union(__.Values(fieldtype.FieldOptionalInt), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt8, value)
	}
	if value, ok := ftu.mutation.AddedOptionalInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt8, __.Union(__.Values(fieldtype.FieldOptionalInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt16, value)
	}
	if value, ok := ftu.mutation.AddedOptionalInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt16, __.Union(__.Values(fieldtype.FieldOptionalInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt32, value)
	}
	if value, ok := ftu.mutation.AddedOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt32, __.Union(__.Values(fieldtype.FieldOptionalInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt64, value)
	}
	if value, ok := ftu.mutation.AddedOptionalInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt64, __.Union(__.Values(fieldtype.FieldOptionalInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NillableInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt, value)
	}
	if value, ok := ftu.mutation.AddedNillableInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt, __.Union(__.Values(fieldtype.FieldNillableInt), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NillableInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt8, value)
	}
	if value, ok := ftu.mutation.AddedNillableInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt8, __.Union(__.Values(fieldtype.FieldNillableInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NillableInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt16, value)
	}
	if value, ok := ftu.mutation.AddedNillableInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt16, __.Union(__.Values(fieldtype.FieldNillableInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NillableInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt32, value)
	}
	if value, ok := ftu.mutation.AddedNillableInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt32, __.Union(__.Values(fieldtype.FieldNillableInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NillableInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt64, value)
	}
	if value, ok := ftu.mutation.AddedNillableInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt64, __.Union(__.Values(fieldtype.FieldNillableInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.ValidateOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldValidateOptionalInt32, value)
	}
	if value, ok := ftu.mutation.AddedValidateOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldValidateOptionalInt32, __.Union(__.Values(fieldtype.FieldValidateOptionalInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalUint(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint, value)
	}
	if value, ok := ftu.mutation.AddedOptionalUint(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint, __.Union(__.Values(fieldtype.FieldOptionalUint), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalUint8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint8, value)
	}
	if value, ok := ftu.mutation.AddedOptionalUint8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint8, __.Union(__.Values(fieldtype.FieldOptionalUint8), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalUint16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint16, value)
	}
	if value, ok := ftu.mutation.AddedOptionalUint16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint16, __.Union(__.Values(fieldtype.FieldOptionalUint16), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalUint32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint32, value)
	}
	if value, ok := ftu.mutation.AddedOptionalUint32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint32, __.Union(__.Values(fieldtype.FieldOptionalUint32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalUint64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint64, value)
	}
	if value, ok := ftu.mutation.AddedOptionalUint64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint64, __.Union(__.Values(fieldtype.FieldOptionalUint64), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.State(); ok {
		v.Property(dsl.Single, fieldtype.FieldState, value)
	}
	if value, ok := ftu.mutation.OptionalFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat, value)
	}
	if value, ok := ftu.mutation.AddedOptionalFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat, __.Union(__.Values(fieldtype.FieldOptionalFloat), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.OptionalFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat32, value)
	}
	if value, ok := ftu.mutation.AddedOptionalFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat32, __.Union(__.Values(fieldtype.FieldOptionalFloat32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Text(); ok {
		v.Property(dsl.Single, fieldtype.FieldText, value)
	}
	if value, ok := ftu.mutation.Datetime(); ok {
		v.Property(dsl.Single, fieldtype.FieldDatetime, value)
	}
	if value, ok := ftu.mutation.Decimal(); ok {
		v.Property(dsl.Single, fieldtype.FieldDecimal, value)
	}
	if value, ok := ftu.mutation.AddedDecimal(); ok {
		v.Property(dsl.Single, fieldtype.FieldDecimal, __.Union(__.Values(fieldtype.FieldDecimal), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.LinkOther(); ok {
		v.Property(dsl.Single, fieldtype.FieldLinkOther, value)
	}
	if value, ok := ftu.mutation.LinkOtherFunc(); ok {
		v.Property(dsl.Single, fieldtype.FieldLinkOtherFunc, value)
	}
	if value, ok := ftu.mutation.MAC(); ok {
		v.Property(dsl.Single, fieldtype.FieldMAC, value)
	}
	if value, ok := ftu.mutation.StringArray(); ok {
		v.Property(dsl.Single, fieldtype.FieldStringArray, value)
	}
	if value, ok := ftu.mutation.Password(); ok {
		v.Property(dsl.Single, fieldtype.FieldPassword, value)
	}
	if value, ok := ftu.mutation.StringScanner(); ok {
		v.Property(dsl.Single, fieldtype.FieldStringScanner, value)
	}
	if value, ok := ftu.mutation.Duration(); ok {
		v.Property(dsl.Single, fieldtype.FieldDuration, value)
	}
	if value, ok := ftu.mutation.AddedDuration(); ok {
		v.Property(dsl.Single, fieldtype.FieldDuration, __.Union(__.Values(fieldtype.FieldDuration), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.Dir(); ok {
		v.Property(dsl.Single, fieldtype.FieldDir, value)
	}
	if value, ok := ftu.mutation.Ndir(); ok {
		v.Property(dsl.Single, fieldtype.FieldNdir, value)
	}
	if value, ok := ftu.mutation.Str(); ok {
		v.Property(dsl.Single, fieldtype.FieldStr, value)
	}
	if value, ok := ftu.mutation.NullStr(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullStr, value)
	}
	if value, ok := ftu.mutation.Link(); ok {
		v.Property(dsl.Single, fieldtype.FieldLink, value)
	}
	if value, ok := ftu.mutation.NullLink(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullLink, value)
	}
	if value, ok := ftu.mutation.Active(); ok {
		v.Property(dsl.Single, fieldtype.FieldActive, value)
	}
	if value, ok := ftu.mutation.NullActive(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullActive, value)
	}
	if value, ok := ftu.mutation.Deleted(); ok {
		v.Property(dsl.Single, fieldtype.FieldDeleted, value)
	}
	if value, ok := ftu.mutation.DeletedAt(); ok {
		v.Property(dsl.Single, fieldtype.FieldDeletedAt, value)
	}
	if value, ok := ftu.mutation.RawData(); ok {
		v.Property(dsl.Single, fieldtype.FieldRawData, value)
	}
	if value, ok := ftu.mutation.Sensitive(); ok {
		v.Property(dsl.Single, fieldtype.FieldSensitive, value)
	}
	if value, ok := ftu.mutation.IP(); ok {
		v.Property(dsl.Single, fieldtype.FieldIP, value)
	}
	if value, ok := ftu.mutation.NullInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullInt64, value)
	}
	if value, ok := ftu.mutation.SchemaInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt, value)
	}
	if value, ok := ftu.mutation.AddedSchemaInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt, __.Union(__.Values(fieldtype.FieldSchemaInt), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.SchemaInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt8, value)
	}
	if value, ok := ftu.mutation.AddedSchemaInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt8, __.Union(__.Values(fieldtype.FieldSchemaInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.SchemaInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt64, value)
	}
	if value, ok := ftu.mutation.AddedSchemaInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt64, __.Union(__.Values(fieldtype.FieldSchemaInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.SchemaFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat, value)
	}
	if value, ok := ftu.mutation.AddedSchemaFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat, __.Union(__.Values(fieldtype.FieldSchemaFloat), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.SchemaFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat32, value)
	}
	if value, ok := ftu.mutation.AddedSchemaFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat32, __.Union(__.Values(fieldtype.FieldSchemaFloat32), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.NullFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullFloat, value)
	}
	if value, ok := ftu.mutation.Role(); ok {
		v.Property(dsl.Single, fieldtype.FieldRole, value)
	}
	if value, ok := ftu.mutation.Priority(); ok {
		v.Property(dsl.Single, fieldtype.FieldPriority, value)
	}
	if value, ok := ftu.mutation.OptionalUUID(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUUID, value)
	}
	if value, ok := ftu.mutation.NillableUUID(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableUUID, value)
	}
	if value, ok := ftu.mutation.Strings(); ok {
		v.Property(dsl.Single, fieldtype.FieldStrings, value)
	}
	if value, ok := ftu.mutation.Pair(); ok {
		v.Property(dsl.Single, fieldtype.FieldPair, value)
	}
	if value, ok := ftu.mutation.NilPair(); ok {
		v.Property(dsl.Single, fieldtype.FieldNilPair, value)
	}
	if value, ok := ftu.mutation.Vstring(); ok {
		v.Property(dsl.Single, fieldtype.FieldVstring, value)
	}
	if value, ok := ftu.mutation.Triple(); ok {
		v.Property(dsl.Single, fieldtype.FieldTriple, value)
	}
	if value, ok := ftu.mutation.BigInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldBigInt, value)
	}
	if value, ok := ftu.mutation.AddedBigInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldBigInt, __.Union(__.Values(fieldtype.FieldBigInt), __.Constant(value)).Sum())
	}
	if value, ok := ftu.mutation.PasswordOther(); ok {
		v.Property(dsl.Single, fieldtype.FieldPasswordOther, value)
	}
	var properties []interface{}
	if ftu.mutation.OptionalIntCleared() {
		properties = append(properties, fieldtype.FieldOptionalInt)
	}
	if ftu.mutation.OptionalInt8Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt8)
	}
	if ftu.mutation.OptionalInt16Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt16)
	}
	if ftu.mutation.OptionalInt32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt32)
	}
	if ftu.mutation.OptionalInt64Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt64)
	}
	if ftu.mutation.NillableIntCleared() {
		properties = append(properties, fieldtype.FieldNillableInt)
	}
	if ftu.mutation.NillableInt8Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt8)
	}
	if ftu.mutation.NillableInt16Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt16)
	}
	if ftu.mutation.NillableInt32Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt32)
	}
	if ftu.mutation.NillableInt64Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt64)
	}
	if ftu.mutation.ValidateOptionalInt32Cleared() {
		properties = append(properties, fieldtype.FieldValidateOptionalInt32)
	}
	if ftu.mutation.OptionalUintCleared() {
		properties = append(properties, fieldtype.FieldOptionalUint)
	}
	if ftu.mutation.OptionalUint8Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint8)
	}
	if ftu.mutation.OptionalUint16Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint16)
	}
	if ftu.mutation.OptionalUint32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint32)
	}
	if ftu.mutation.OptionalUint64Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint64)
	}
	if ftu.mutation.StateCleared() {
		properties = append(properties, fieldtype.FieldState)
	}
	if ftu.mutation.OptionalFloatCleared() {
		properties = append(properties, fieldtype.FieldOptionalFloat)
	}
	if ftu.mutation.OptionalFloat32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalFloat32)
	}
	if ftu.mutation.TextCleared() {
		properties = append(properties, fieldtype.FieldText)
	}
	if ftu.mutation.DatetimeCleared() {
		properties = append(properties, fieldtype.FieldDatetime)
	}
	if ftu.mutation.DecimalCleared() {
		properties = append(properties, fieldtype.FieldDecimal)
	}
	if ftu.mutation.LinkOtherCleared() {
		properties = append(properties, fieldtype.FieldLinkOther)
	}
	if ftu.mutation.LinkOtherFuncCleared() {
		properties = append(properties, fieldtype.FieldLinkOtherFunc)
	}
	if ftu.mutation.MACCleared() {
		properties = append(properties, fieldtype.FieldMAC)
	}
	if ftu.mutation.StringArrayCleared() {
		properties = append(properties, fieldtype.FieldStringArray)
	}
	if ftu.mutation.PasswordCleared() {
		properties = append(properties, fieldtype.FieldPassword)
	}
	if ftu.mutation.StringScannerCleared() {
		properties = append(properties, fieldtype.FieldStringScanner)
	}
	if ftu.mutation.DurationCleared() {
		properties = append(properties, fieldtype.FieldDuration)
	}
	if ftu.mutation.NdirCleared() {
		properties = append(properties, fieldtype.FieldNdir)
	}
	if ftu.mutation.StrCleared() {
		properties = append(properties, fieldtype.FieldStr)
	}
	if ftu.mutation.NullStrCleared() {
		properties = append(properties, fieldtype.FieldNullStr)
	}
	if ftu.mutation.LinkCleared() {
		properties = append(properties, fieldtype.FieldLink)
	}
	if ftu.mutation.NullLinkCleared() {
		properties = append(properties, fieldtype.FieldNullLink)
	}
	if ftu.mutation.ActiveCleared() {
		properties = append(properties, fieldtype.FieldActive)
	}
	if ftu.mutation.NullActiveCleared() {
		properties = append(properties, fieldtype.FieldNullActive)
	}
	if ftu.mutation.DeletedCleared() {
		properties = append(properties, fieldtype.FieldDeleted)
	}
	if ftu.mutation.DeletedAtCleared() {
		properties = append(properties, fieldtype.FieldDeletedAt)
	}
	if ftu.mutation.RawDataCleared() {
		properties = append(properties, fieldtype.FieldRawData)
	}
	if ftu.mutation.SensitiveCleared() {
		properties = append(properties, fieldtype.FieldSensitive)
	}
	if ftu.mutation.IPCleared() {
		properties = append(properties, fieldtype.FieldIP)
	}
	if ftu.mutation.NullInt64Cleared() {
		properties = append(properties, fieldtype.FieldNullInt64)
	}
	if ftu.mutation.SchemaIntCleared() {
		properties = append(properties, fieldtype.FieldSchemaInt)
	}
	if ftu.mutation.SchemaInt8Cleared() {
		properties = append(properties, fieldtype.FieldSchemaInt8)
	}
	if ftu.mutation.SchemaInt64Cleared() {
		properties = append(properties, fieldtype.FieldSchemaInt64)
	}
	if ftu.mutation.SchemaFloatCleared() {
		properties = append(properties, fieldtype.FieldSchemaFloat)
	}
	if ftu.mutation.SchemaFloat32Cleared() {
		properties = append(properties, fieldtype.FieldSchemaFloat32)
	}
	if ftu.mutation.NullFloatCleared() {
		properties = append(properties, fieldtype.FieldNullFloat)
	}
	if ftu.mutation.PriorityCleared() {
		properties = append(properties, fieldtype.FieldPriority)
	}
	if ftu.mutation.OptionalUUIDCleared() {
		properties = append(properties, fieldtype.FieldOptionalUUID)
	}
	if ftu.mutation.NillableUUIDCleared() {
		properties = append(properties, fieldtype.FieldNillableUUID)
	}
	if ftu.mutation.StringsCleared() {
		properties = append(properties, fieldtype.FieldStrings)
	}
	if ftu.mutation.NilPairCleared() {
		properties = append(properties, fieldtype.FieldNilPair)
	}
	if ftu.mutation.BigIntCleared() {
		properties = append(properties, fieldtype.FieldBigInt)
	}
	if ftu.mutation.PasswordOtherCleared() {
		properties = append(properties, fieldtype.FieldPasswordOther)
	}
	if len(properties) > 0 {
		v.SideEffect(__.Properties(properties...).Drop())
	}
	v.Count()
	trs = append(trs, v)
	return dsl.Join(trs...)
}

// FieldTypeUpdateOne is the builder for updating a single FieldType entity.
type FieldTypeUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *FieldTypeMutation
}

// SetInt sets the "int" field.
func (ftuo *FieldTypeUpdateOne) SetInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.ResetInt()
	ftuo.mutation.SetInt(i)
	return ftuo
}

// AddInt adds i to the "int" field.
func (ftuo *FieldTypeUpdateOne) AddInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.AddInt(i)
	return ftuo
}

// SetInt8 sets the "int8" field.
func (ftuo *FieldTypeUpdateOne) SetInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.ResetInt8()
	ftuo.mutation.SetInt8(i)
	return ftuo
}

// AddInt8 adds i to the "int8" field.
func (ftuo *FieldTypeUpdateOne) AddInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.AddInt8(i)
	return ftuo
}

// SetInt16 sets the "int16" field.
func (ftuo *FieldTypeUpdateOne) SetInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.ResetInt16()
	ftuo.mutation.SetInt16(i)
	return ftuo
}

// AddInt16 adds i to the "int16" field.
func (ftuo *FieldTypeUpdateOne) AddInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.AddInt16(i)
	return ftuo
}

// SetInt32 sets the "int32" field.
func (ftuo *FieldTypeUpdateOne) SetInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetInt32()
	ftuo.mutation.SetInt32(i)
	return ftuo
}

// AddInt32 adds i to the "int32" field.
func (ftuo *FieldTypeUpdateOne) AddInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.AddInt32(i)
	return ftuo
}

// SetInt64 sets the "int64" field.
func (ftuo *FieldTypeUpdateOne) SetInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetInt64()
	ftuo.mutation.SetInt64(i)
	return ftuo
}

// AddInt64 adds i to the "int64" field.
func (ftuo *FieldTypeUpdateOne) AddInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.AddInt64(i)
	return ftuo
}

// SetOptionalInt sets the "optional_int" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalInt()
	ftuo.mutation.SetOptionalInt(i)
	return ftuo
}

// SetNillableOptionalInt sets the "optional_int" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalInt(i *int) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetOptionalInt(*i)
	}
	return ftuo
}

// AddOptionalInt adds i to the "optional_int" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalInt(i)
	return ftuo
}

// ClearOptionalInt clears the value of the "optional_int" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalInt() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalInt()
	return ftuo
}

// SetOptionalInt8 sets the "optional_int8" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalInt8()
	ftuo.mutation.SetOptionalInt8(i)
	return ftuo
}

// SetNillableOptionalInt8 sets the "optional_int8" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalInt8(i *int8) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetOptionalInt8(*i)
	}
	return ftuo
}

// AddOptionalInt8 adds i to the "optional_int8" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalInt8(i)
	return ftuo
}

// ClearOptionalInt8 clears the value of the "optional_int8" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalInt8() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalInt8()
	return ftuo
}

// SetOptionalInt16 sets the "optional_int16" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalInt16()
	ftuo.mutation.SetOptionalInt16(i)
	return ftuo
}

// SetNillableOptionalInt16 sets the "optional_int16" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalInt16(i *int16) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetOptionalInt16(*i)
	}
	return ftuo
}

// AddOptionalInt16 adds i to the "optional_int16" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalInt16(i)
	return ftuo
}

// ClearOptionalInt16 clears the value of the "optional_int16" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalInt16() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalInt16()
	return ftuo
}

// SetOptionalInt32 sets the "optional_int32" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalInt32()
	ftuo.mutation.SetOptionalInt32(i)
	return ftuo
}

// SetNillableOptionalInt32 sets the "optional_int32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalInt32(i *int32) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetOptionalInt32(*i)
	}
	return ftuo
}

// AddOptionalInt32 adds i to the "optional_int32" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalInt32(i)
	return ftuo
}

// ClearOptionalInt32 clears the value of the "optional_int32" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalInt32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalInt32()
	return ftuo
}

// SetOptionalInt64 sets the "optional_int64" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalInt64()
	ftuo.mutation.SetOptionalInt64(i)
	return ftuo
}

// SetNillableOptionalInt64 sets the "optional_int64" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalInt64(i *int64) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetOptionalInt64(*i)
	}
	return ftuo
}

// AddOptionalInt64 adds i to the "optional_int64" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalInt64(i)
	return ftuo
}

// ClearOptionalInt64 clears the value of the "optional_int64" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalInt64() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalInt64()
	return ftuo
}

// SetNillableInt sets the "nillable_int" field.
func (ftuo *FieldTypeUpdateOne) SetNillableInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.ResetNillableInt()
	ftuo.mutation.SetNillableInt(i)
	return ftuo
}

// SetNillableNillableInt sets the "nillable_int" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableInt(i *int) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetNillableInt(*i)
	}
	return ftuo
}

// AddNillableInt adds i to the "nillable_int" field.
func (ftuo *FieldTypeUpdateOne) AddNillableInt(i int) *FieldTypeUpdateOne {
	ftuo.mutation.AddNillableInt(i)
	return ftuo
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableInt() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableInt()
	return ftuo
}

// SetNillableInt8 sets the "nillable_int8" field.
func (ftuo *FieldTypeUpdateOne) SetNillableInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.ResetNillableInt8()
	ftuo.mutation.SetNillableInt8(i)
	return ftuo
}

// SetNillableNillableInt8 sets the "nillable_int8" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableInt8(i *int8) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetNillableInt8(*i)
	}
	return ftuo
}

// AddNillableInt8 adds i to the "nillable_int8" field.
func (ftuo *FieldTypeUpdateOne) AddNillableInt8(i int8) *FieldTypeUpdateOne {
	ftuo.mutation.AddNillableInt8(i)
	return ftuo
}

// ClearNillableInt8 clears the value of the "nillable_int8" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableInt8() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableInt8()
	return ftuo
}

// SetNillableInt16 sets the "nillable_int16" field.
func (ftuo *FieldTypeUpdateOne) SetNillableInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.ResetNillableInt16()
	ftuo.mutation.SetNillableInt16(i)
	return ftuo
}

// SetNillableNillableInt16 sets the "nillable_int16" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableInt16(i *int16) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetNillableInt16(*i)
	}
	return ftuo
}

// AddNillableInt16 adds i to the "nillable_int16" field.
func (ftuo *FieldTypeUpdateOne) AddNillableInt16(i int16) *FieldTypeUpdateOne {
	ftuo.mutation.AddNillableInt16(i)
	return ftuo
}

// ClearNillableInt16 clears the value of the "nillable_int16" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableInt16() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableInt16()
	return ftuo
}

// SetNillableInt32 sets the "nillable_int32" field.
func (ftuo *FieldTypeUpdateOne) SetNillableInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetNillableInt32()
	ftuo.mutation.SetNillableInt32(i)
	return ftuo
}

// SetNillableNillableInt32 sets the "nillable_int32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableInt32(i *int32) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetNillableInt32(*i)
	}
	return ftuo
}

// AddNillableInt32 adds i to the "nillable_int32" field.
func (ftuo *FieldTypeUpdateOne) AddNillableInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.AddNillableInt32(i)
	return ftuo
}

// ClearNillableInt32 clears the value of the "nillable_int32" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableInt32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableInt32()
	return ftuo
}

// SetNillableInt64 sets the "nillable_int64" field.
func (ftuo *FieldTypeUpdateOne) SetNillableInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetNillableInt64()
	ftuo.mutation.SetNillableInt64(i)
	return ftuo
}

// SetNillableNillableInt64 sets the "nillable_int64" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableInt64(i *int64) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetNillableInt64(*i)
	}
	return ftuo
}

// AddNillableInt64 adds i to the "nillable_int64" field.
func (ftuo *FieldTypeUpdateOne) AddNillableInt64(i int64) *FieldTypeUpdateOne {
	ftuo.mutation.AddNillableInt64(i)
	return ftuo
}

// ClearNillableInt64 clears the value of the "nillable_int64" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableInt64() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableInt64()
	return ftuo
}

// SetValidateOptionalInt32 sets the "validate_optional_int32" field.
func (ftuo *FieldTypeUpdateOne) SetValidateOptionalInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetValidateOptionalInt32()
	ftuo.mutation.SetValidateOptionalInt32(i)
	return ftuo
}

// SetNillableValidateOptionalInt32 sets the "validate_optional_int32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableValidateOptionalInt32(i *int32) *FieldTypeUpdateOne {
	if i != nil {
		ftuo.SetValidateOptionalInt32(*i)
	}
	return ftuo
}

// AddValidateOptionalInt32 adds i to the "validate_optional_int32" field.
func (ftuo *FieldTypeUpdateOne) AddValidateOptionalInt32(i int32) *FieldTypeUpdateOne {
	ftuo.mutation.AddValidateOptionalInt32(i)
	return ftuo
}

// ClearValidateOptionalInt32 clears the value of the "validate_optional_int32" field.
func (ftuo *FieldTypeUpdateOne) ClearValidateOptionalInt32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearValidateOptionalInt32()
	return ftuo
}

// SetOptionalUint sets the "optional_uint" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUint(u uint) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalUint()
	ftuo.mutation.SetOptionalUint(u)
	return ftuo
}

// SetNillableOptionalUint sets the "optional_uint" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUint(u *uint) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUint(*u)
	}
	return ftuo
}

// AddOptionalUint adds u to the "optional_uint" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalUint(u int) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalUint(u)
	return ftuo
}

// ClearOptionalUint clears the value of the "optional_uint" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUint() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUint()
	return ftuo
}

// SetOptionalUint8 sets the "optional_uint8" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUint8(u uint8) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalUint8()
	ftuo.mutation.SetOptionalUint8(u)
	return ftuo
}

// SetNillableOptionalUint8 sets the "optional_uint8" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUint8(u *uint8) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUint8(*u)
	}
	return ftuo
}

// AddOptionalUint8 adds u to the "optional_uint8" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalUint8(u int8) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalUint8(u)
	return ftuo
}

// ClearOptionalUint8 clears the value of the "optional_uint8" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUint8() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUint8()
	return ftuo
}

// SetOptionalUint16 sets the "optional_uint16" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUint16(u uint16) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalUint16()
	ftuo.mutation.SetOptionalUint16(u)
	return ftuo
}

// SetNillableOptionalUint16 sets the "optional_uint16" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUint16(u *uint16) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUint16(*u)
	}
	return ftuo
}

// AddOptionalUint16 adds u to the "optional_uint16" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalUint16(u int16) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalUint16(u)
	return ftuo
}

// ClearOptionalUint16 clears the value of the "optional_uint16" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUint16() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUint16()
	return ftuo
}

// SetOptionalUint32 sets the "optional_uint32" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUint32(u uint32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalUint32()
	ftuo.mutation.SetOptionalUint32(u)
	return ftuo
}

// SetNillableOptionalUint32 sets the "optional_uint32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUint32(u *uint32) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUint32(*u)
	}
	return ftuo
}

// AddOptionalUint32 adds u to the "optional_uint32" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalUint32(u int32) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalUint32(u)
	return ftuo
}

// ClearOptionalUint32 clears the value of the "optional_uint32" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUint32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUint32()
	return ftuo
}

// SetOptionalUint64 sets the "optional_uint64" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUint64(u uint64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalUint64()
	ftuo.mutation.SetOptionalUint64(u)
	return ftuo
}

// SetNillableOptionalUint64 sets the "optional_uint64" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUint64(u *uint64) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUint64(*u)
	}
	return ftuo
}

// AddOptionalUint64 adds u to the "optional_uint64" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalUint64(u int64) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalUint64(u)
	return ftuo
}

// ClearOptionalUint64 clears the value of the "optional_uint64" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUint64() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUint64()
	return ftuo
}

// SetState sets the "state" field.
func (ftuo *FieldTypeUpdateOne) SetState(f fieldtype.State) *FieldTypeUpdateOne {
	ftuo.mutation.SetState(f)
	return ftuo
}

// SetNillableState sets the "state" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableState(f *fieldtype.State) *FieldTypeUpdateOne {
	if f != nil {
		ftuo.SetState(*f)
	}
	return ftuo
}

// ClearState clears the value of the "state" field.
func (ftuo *FieldTypeUpdateOne) ClearState() *FieldTypeUpdateOne {
	ftuo.mutation.ClearState()
	return ftuo
}

// SetOptionalFloat sets the "optional_float" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalFloat(f float64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalFloat()
	ftuo.mutation.SetOptionalFloat(f)
	return ftuo
}

// SetNillableOptionalFloat sets the "optional_float" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalFloat(f *float64) *FieldTypeUpdateOne {
	if f != nil {
		ftuo.SetOptionalFloat(*f)
	}
	return ftuo
}

// AddOptionalFloat adds f to the "optional_float" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalFloat(f float64) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalFloat(f)
	return ftuo
}

// ClearOptionalFloat clears the value of the "optional_float" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalFloat() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalFloat()
	return ftuo
}

// SetOptionalFloat32 sets the "optional_float32" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalFloat32(f float32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetOptionalFloat32()
	ftuo.mutation.SetOptionalFloat32(f)
	return ftuo
}

// SetNillableOptionalFloat32 sets the "optional_float32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalFloat32(f *float32) *FieldTypeUpdateOne {
	if f != nil {
		ftuo.SetOptionalFloat32(*f)
	}
	return ftuo
}

// AddOptionalFloat32 adds f to the "optional_float32" field.
func (ftuo *FieldTypeUpdateOne) AddOptionalFloat32(f float32) *FieldTypeUpdateOne {
	ftuo.mutation.AddOptionalFloat32(f)
	return ftuo
}

// ClearOptionalFloat32 clears the value of the "optional_float32" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalFloat32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalFloat32()
	return ftuo
}

// SetText sets the "text" field.
func (ftuo *FieldTypeUpdateOne) SetText(s string) *FieldTypeUpdateOne {
	ftuo.mutation.SetText(s)
	return ftuo
}

// SetNillableText sets the "text" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableText(s *string) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetText(*s)
	}
	return ftuo
}

// ClearText clears the value of the "text" field.
func (ftuo *FieldTypeUpdateOne) ClearText() *FieldTypeUpdateOne {
	ftuo.mutation.ClearText()
	return ftuo
}

// SetDatetime sets the "datetime" field.
func (ftuo *FieldTypeUpdateOne) SetDatetime(t time.Time) *FieldTypeUpdateOne {
	ftuo.mutation.SetDatetime(t)
	return ftuo
}

// SetNillableDatetime sets the "datetime" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableDatetime(t *time.Time) *FieldTypeUpdateOne {
	if t != nil {
		ftuo.SetDatetime(*t)
	}
	return ftuo
}

// ClearDatetime clears the value of the "datetime" field.
func (ftuo *FieldTypeUpdateOne) ClearDatetime() *FieldTypeUpdateOne {
	ftuo.mutation.ClearDatetime()
	return ftuo
}

// SetDecimal sets the "decimal" field.
func (ftuo *FieldTypeUpdateOne) SetDecimal(f float64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetDecimal()
	ftuo.mutation.SetDecimal(f)
	return ftuo
}

// SetNillableDecimal sets the "decimal" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableDecimal(f *float64) *FieldTypeUpdateOne {
	if f != nil {
		ftuo.SetDecimal(*f)
	}
	return ftuo
}

// AddDecimal adds f to the "decimal" field.
func (ftuo *FieldTypeUpdateOne) AddDecimal(f float64) *FieldTypeUpdateOne {
	ftuo.mutation.AddDecimal(f)
	return ftuo
}

// ClearDecimal clears the value of the "decimal" field.
func (ftuo *FieldTypeUpdateOne) ClearDecimal() *FieldTypeUpdateOne {
	ftuo.mutation.ClearDecimal()
	return ftuo
}

// SetLinkOther sets the "link_other" field.
func (ftuo *FieldTypeUpdateOne) SetLinkOther(s *schema.Link) *FieldTypeUpdateOne {
	ftuo.mutation.SetLinkOther(s)
	return ftuo
}

// ClearLinkOther clears the value of the "link_other" field.
func (ftuo *FieldTypeUpdateOne) ClearLinkOther() *FieldTypeUpdateOne {
	ftuo.mutation.ClearLinkOther()
	return ftuo
}

// SetLinkOtherFunc sets the "link_other_func" field.
func (ftuo *FieldTypeUpdateOne) SetLinkOtherFunc(s *schema.Link) *FieldTypeUpdateOne {
	ftuo.mutation.SetLinkOtherFunc(s)
	return ftuo
}

// ClearLinkOtherFunc clears the value of the "link_other_func" field.
func (ftuo *FieldTypeUpdateOne) ClearLinkOtherFunc() *FieldTypeUpdateOne {
	ftuo.mutation.ClearLinkOtherFunc()
	return ftuo
}

// SetMAC sets the "mac" field.
func (ftuo *FieldTypeUpdateOne) SetMAC(s schema.MAC) *FieldTypeUpdateOne {
	ftuo.mutation.SetMAC(s)
	return ftuo
}

// SetNillableMAC sets the "mac" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableMAC(s *schema.MAC) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetMAC(*s)
	}
	return ftuo
}

// ClearMAC clears the value of the "mac" field.
func (ftuo *FieldTypeUpdateOne) ClearMAC() *FieldTypeUpdateOne {
	ftuo.mutation.ClearMAC()
	return ftuo
}

// SetStringArray sets the "string_array" field.
func (ftuo *FieldTypeUpdateOne) SetStringArray(s schema.Strings) *FieldTypeUpdateOne {
	ftuo.mutation.SetStringArray(s)
	return ftuo
}

// ClearStringArray clears the value of the "string_array" field.
func (ftuo *FieldTypeUpdateOne) ClearStringArray() *FieldTypeUpdateOne {
	ftuo.mutation.ClearStringArray()
	return ftuo
}

// SetPassword sets the "password" field.
func (ftuo *FieldTypeUpdateOne) SetPassword(s string) *FieldTypeUpdateOne {
	ftuo.mutation.SetPassword(s)
	return ftuo
}

// SetNillablePassword sets the "password" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillablePassword(s *string) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetPassword(*s)
	}
	return ftuo
}

// ClearPassword clears the value of the "password" field.
func (ftuo *FieldTypeUpdateOne) ClearPassword() *FieldTypeUpdateOne {
	ftuo.mutation.ClearPassword()
	return ftuo
}

// SetStringScanner sets the "string_scanner" field.
func (ftuo *FieldTypeUpdateOne) SetStringScanner(ss schema.StringScanner) *FieldTypeUpdateOne {
	ftuo.mutation.SetStringScanner(ss)
	return ftuo
}

// SetNillableStringScanner sets the "string_scanner" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableStringScanner(ss *schema.StringScanner) *FieldTypeUpdateOne {
	if ss != nil {
		ftuo.SetStringScanner(*ss)
	}
	return ftuo
}

// ClearStringScanner clears the value of the "string_scanner" field.
func (ftuo *FieldTypeUpdateOne) ClearStringScanner() *FieldTypeUpdateOne {
	ftuo.mutation.ClearStringScanner()
	return ftuo
}

// SetDuration sets the "duration" field.
func (ftuo *FieldTypeUpdateOne) SetDuration(t time.Duration) *FieldTypeUpdateOne {
	ftuo.mutation.ResetDuration()
	ftuo.mutation.SetDuration(t)
	return ftuo
}

// AddDuration adds t to the "duration" field.
func (ftuo *FieldTypeUpdateOne) AddDuration(t time.Duration) *FieldTypeUpdateOne {
	ftuo.mutation.AddDuration(t)
	return ftuo
}

// ClearDuration clears the value of the "duration" field.
func (ftuo *FieldTypeUpdateOne) ClearDuration() *FieldTypeUpdateOne {
	ftuo.mutation.ClearDuration()
	return ftuo
}

// SetDir sets the "dir" field.
func (ftuo *FieldTypeUpdateOne) SetDir(h http.Dir) *FieldTypeUpdateOne {
	ftuo.mutation.SetDir(h)
	return ftuo
}

// SetNillableDir sets the "dir" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableDir(h *http.Dir) *FieldTypeUpdateOne {
	if h != nil {
		ftuo.SetDir(*h)
	}
	return ftuo
}

// SetNdir sets the "ndir" field.
func (ftuo *FieldTypeUpdateOne) SetNdir(h http.Dir) *FieldTypeUpdateOne {
	ftuo.mutation.SetNdir(h)
	return ftuo
}

// SetNillableNdir sets the "ndir" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNdir(h *http.Dir) *FieldTypeUpdateOne {
	if h != nil {
		ftuo.SetNdir(*h)
	}
	return ftuo
}

// ClearNdir clears the value of the "ndir" field.
func (ftuo *FieldTypeUpdateOne) ClearNdir() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNdir()
	return ftuo
}

// SetStr sets the "str" field.
func (ftuo *FieldTypeUpdateOne) SetStr(ss sql.NullString) *FieldTypeUpdateOne {
	ftuo.mutation.SetStr(ss)
	return ftuo
}

// SetNillableStr sets the "str" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableStr(ss *sql.NullString) *FieldTypeUpdateOne {
	if ss != nil {
		ftuo.SetStr(*ss)
	}
	return ftuo
}

// ClearStr clears the value of the "str" field.
func (ftuo *FieldTypeUpdateOne) ClearStr() *FieldTypeUpdateOne {
	ftuo.mutation.ClearStr()
	return ftuo
}

// SetNullStr sets the "null_str" field.
func (ftuo *FieldTypeUpdateOne) SetNullStr(ss *sql.NullString) *FieldTypeUpdateOne {
	ftuo.mutation.SetNullStr(ss)
	return ftuo
}

// ClearNullStr clears the value of the "null_str" field.
func (ftuo *FieldTypeUpdateOne) ClearNullStr() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNullStr()
	return ftuo
}

// SetLink sets the "link" field.
func (ftuo *FieldTypeUpdateOne) SetLink(s schema.Link) *FieldTypeUpdateOne {
	ftuo.mutation.SetLink(s)
	return ftuo
}

// SetNillableLink sets the "link" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableLink(s *schema.Link) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetLink(*s)
	}
	return ftuo
}

// ClearLink clears the value of the "link" field.
func (ftuo *FieldTypeUpdateOne) ClearLink() *FieldTypeUpdateOne {
	ftuo.mutation.ClearLink()
	return ftuo
}

// SetNullLink sets the "null_link" field.
func (ftuo *FieldTypeUpdateOne) SetNullLink(s *schema.Link) *FieldTypeUpdateOne {
	ftuo.mutation.SetNullLink(s)
	return ftuo
}

// ClearNullLink clears the value of the "null_link" field.
func (ftuo *FieldTypeUpdateOne) ClearNullLink() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNullLink()
	return ftuo
}

// SetActive sets the "active" field.
func (ftuo *FieldTypeUpdateOne) SetActive(s schema.Status) *FieldTypeUpdateOne {
	ftuo.mutation.SetActive(s)
	return ftuo
}

// SetNillableActive sets the "active" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableActive(s *schema.Status) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetActive(*s)
	}
	return ftuo
}

// ClearActive clears the value of the "active" field.
func (ftuo *FieldTypeUpdateOne) ClearActive() *FieldTypeUpdateOne {
	ftuo.mutation.ClearActive()
	return ftuo
}

// SetNullActive sets the "null_active" field.
func (ftuo *FieldTypeUpdateOne) SetNullActive(s schema.Status) *FieldTypeUpdateOne {
	ftuo.mutation.SetNullActive(s)
	return ftuo
}

// SetNillableNullActive sets the "null_active" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNullActive(s *schema.Status) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetNullActive(*s)
	}
	return ftuo
}

// ClearNullActive clears the value of the "null_active" field.
func (ftuo *FieldTypeUpdateOne) ClearNullActive() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNullActive()
	return ftuo
}

// SetDeleted sets the "deleted" field.
func (ftuo *FieldTypeUpdateOne) SetDeleted(sb *sql.NullBool) *FieldTypeUpdateOne {
	ftuo.mutation.SetDeleted(sb)
	return ftuo
}

// ClearDeleted clears the value of the "deleted" field.
func (ftuo *FieldTypeUpdateOne) ClearDeleted() *FieldTypeUpdateOne {
	ftuo.mutation.ClearDeleted()
	return ftuo
}

// SetDeletedAt sets the "deleted_at" field.
func (ftuo *FieldTypeUpdateOne) SetDeletedAt(st *sql.NullTime) *FieldTypeUpdateOne {
	ftuo.mutation.SetDeletedAt(st)
	return ftuo
}

// ClearDeletedAt clears the value of the "deleted_at" field.
func (ftuo *FieldTypeUpdateOne) ClearDeletedAt() *FieldTypeUpdateOne {
	ftuo.mutation.ClearDeletedAt()
	return ftuo
}

// SetRawData sets the "raw_data" field.
func (ftuo *FieldTypeUpdateOne) SetRawData(b []byte) *FieldTypeUpdateOne {
	ftuo.mutation.SetRawData(b)
	return ftuo
}

// ClearRawData clears the value of the "raw_data" field.
func (ftuo *FieldTypeUpdateOne) ClearRawData() *FieldTypeUpdateOne {
	ftuo.mutation.ClearRawData()
	return ftuo
}

// SetSensitive sets the "sensitive" field.
func (ftuo *FieldTypeUpdateOne) SetSensitive(b []byte) *FieldTypeUpdateOne {
	ftuo.mutation.SetSensitive(b)
	return ftuo
}

// ClearSensitive clears the value of the "sensitive" field.
func (ftuo *FieldTypeUpdateOne) ClearSensitive() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSensitive()
	return ftuo
}

// SetIP sets the "ip" field.
func (ftuo *FieldTypeUpdateOne) SetIP(n net.IP) *FieldTypeUpdateOne {
	ftuo.mutation.SetIP(n)
	return ftuo
}

// ClearIP clears the value of the "ip" field.
func (ftuo *FieldTypeUpdateOne) ClearIP() *FieldTypeUpdateOne {
	ftuo.mutation.ClearIP()
	return ftuo
}

// SetNullInt64 sets the "null_int64" field.
func (ftuo *FieldTypeUpdateOne) SetNullInt64(si *sql.NullInt64) *FieldTypeUpdateOne {
	ftuo.mutation.SetNullInt64(si)
	return ftuo
}

// ClearNullInt64 clears the value of the "null_int64" field.
func (ftuo *FieldTypeUpdateOne) ClearNullInt64() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNullInt64()
	return ftuo
}

// SetSchemaInt sets the "schema_int" field.
func (ftuo *FieldTypeUpdateOne) SetSchemaInt(s schema.Int) *FieldTypeUpdateOne {
	ftuo.mutation.ResetSchemaInt()
	ftuo.mutation.SetSchemaInt(s)
	return ftuo
}

// SetNillableSchemaInt sets the "schema_int" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableSchemaInt(s *schema.Int) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetSchemaInt(*s)
	}
	return ftuo
}

// AddSchemaInt adds s to the "schema_int" field.
func (ftuo *FieldTypeUpdateOne) AddSchemaInt(s schema.Int) *FieldTypeUpdateOne {
	ftuo.mutation.AddSchemaInt(s)
	return ftuo
}

// ClearSchemaInt clears the value of the "schema_int" field.
func (ftuo *FieldTypeUpdateOne) ClearSchemaInt() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSchemaInt()
	return ftuo
}

// SetSchemaInt8 sets the "schema_int8" field.
func (ftuo *FieldTypeUpdateOne) SetSchemaInt8(s schema.Int8) *FieldTypeUpdateOne {
	ftuo.mutation.ResetSchemaInt8()
	ftuo.mutation.SetSchemaInt8(s)
	return ftuo
}

// SetNillableSchemaInt8 sets the "schema_int8" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableSchemaInt8(s *schema.Int8) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetSchemaInt8(*s)
	}
	return ftuo
}

// AddSchemaInt8 adds s to the "schema_int8" field.
func (ftuo *FieldTypeUpdateOne) AddSchemaInt8(s schema.Int8) *FieldTypeUpdateOne {
	ftuo.mutation.AddSchemaInt8(s)
	return ftuo
}

// ClearSchemaInt8 clears the value of the "schema_int8" field.
func (ftuo *FieldTypeUpdateOne) ClearSchemaInt8() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSchemaInt8()
	return ftuo
}

// SetSchemaInt64 sets the "schema_int64" field.
func (ftuo *FieldTypeUpdateOne) SetSchemaInt64(s schema.Int64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetSchemaInt64()
	ftuo.mutation.SetSchemaInt64(s)
	return ftuo
}

// SetNillableSchemaInt64 sets the "schema_int64" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableSchemaInt64(s *schema.Int64) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetSchemaInt64(*s)
	}
	return ftuo
}

// AddSchemaInt64 adds s to the "schema_int64" field.
func (ftuo *FieldTypeUpdateOne) AddSchemaInt64(s schema.Int64) *FieldTypeUpdateOne {
	ftuo.mutation.AddSchemaInt64(s)
	return ftuo
}

// ClearSchemaInt64 clears the value of the "schema_int64" field.
func (ftuo *FieldTypeUpdateOne) ClearSchemaInt64() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSchemaInt64()
	return ftuo
}

// SetSchemaFloat sets the "schema_float" field.
func (ftuo *FieldTypeUpdateOne) SetSchemaFloat(s schema.Float64) *FieldTypeUpdateOne {
	ftuo.mutation.ResetSchemaFloat()
	ftuo.mutation.SetSchemaFloat(s)
	return ftuo
}

// SetNillableSchemaFloat sets the "schema_float" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableSchemaFloat(s *schema.Float64) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetSchemaFloat(*s)
	}
	return ftuo
}

// AddSchemaFloat adds s to the "schema_float" field.
func (ftuo *FieldTypeUpdateOne) AddSchemaFloat(s schema.Float64) *FieldTypeUpdateOne {
	ftuo.mutation.AddSchemaFloat(s)
	return ftuo
}

// ClearSchemaFloat clears the value of the "schema_float" field.
func (ftuo *FieldTypeUpdateOne) ClearSchemaFloat() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSchemaFloat()
	return ftuo
}

// SetSchemaFloat32 sets the "schema_float32" field.
func (ftuo *FieldTypeUpdateOne) SetSchemaFloat32(s schema.Float32) *FieldTypeUpdateOne {
	ftuo.mutation.ResetSchemaFloat32()
	ftuo.mutation.SetSchemaFloat32(s)
	return ftuo
}

// SetNillableSchemaFloat32 sets the "schema_float32" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableSchemaFloat32(s *schema.Float32) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetSchemaFloat32(*s)
	}
	return ftuo
}

// AddSchemaFloat32 adds s to the "schema_float32" field.
func (ftuo *FieldTypeUpdateOne) AddSchemaFloat32(s schema.Float32) *FieldTypeUpdateOne {
	ftuo.mutation.AddSchemaFloat32(s)
	return ftuo
}

// ClearSchemaFloat32 clears the value of the "schema_float32" field.
func (ftuo *FieldTypeUpdateOne) ClearSchemaFloat32() *FieldTypeUpdateOne {
	ftuo.mutation.ClearSchemaFloat32()
	return ftuo
}

// SetNullFloat sets the "null_float" field.
func (ftuo *FieldTypeUpdateOne) SetNullFloat(sf *sql.NullFloat64) *FieldTypeUpdateOne {
	ftuo.mutation.SetNullFloat(sf)
	return ftuo
}

// ClearNullFloat clears the value of the "null_float" field.
func (ftuo *FieldTypeUpdateOne) ClearNullFloat() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNullFloat()
	return ftuo
}

// SetRole sets the "role" field.
func (ftuo *FieldTypeUpdateOne) SetRole(r role.Role) *FieldTypeUpdateOne {
	ftuo.mutation.SetRole(r)
	return ftuo
}

// SetNillableRole sets the "role" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableRole(r *role.Role) *FieldTypeUpdateOne {
	if r != nil {
		ftuo.SetRole(*r)
	}
	return ftuo
}

// SetPriority sets the "priority" field.
func (ftuo *FieldTypeUpdateOne) SetPriority(r role.Priority) *FieldTypeUpdateOne {
	ftuo.mutation.SetPriority(r)
	return ftuo
}

// SetNillablePriority sets the "priority" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillablePriority(r *role.Priority) *FieldTypeUpdateOne {
	if r != nil {
		ftuo.SetPriority(*r)
	}
	return ftuo
}

// ClearPriority clears the value of the "priority" field.
func (ftuo *FieldTypeUpdateOne) ClearPriority() *FieldTypeUpdateOne {
	ftuo.mutation.ClearPriority()
	return ftuo
}

// SetOptionalUUID sets the "optional_uuid" field.
func (ftuo *FieldTypeUpdateOne) SetOptionalUUID(u uuid.UUID) *FieldTypeUpdateOne {
	ftuo.mutation.SetOptionalUUID(u)
	return ftuo
}

// SetNillableOptionalUUID sets the "optional_uuid" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableOptionalUUID(u *uuid.UUID) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetOptionalUUID(*u)
	}
	return ftuo
}

// ClearOptionalUUID clears the value of the "optional_uuid" field.
func (ftuo *FieldTypeUpdateOne) ClearOptionalUUID() *FieldTypeUpdateOne {
	ftuo.mutation.ClearOptionalUUID()
	return ftuo
}

// SetNillableUUID sets the "nillable_uuid" field.
func (ftuo *FieldTypeUpdateOne) SetNillableUUID(u uuid.UUID) *FieldTypeUpdateOne {
	ftuo.mutation.SetNillableUUID(u)
	return ftuo
}

// SetNillableNillableUUID sets the "nillable_uuid" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableNillableUUID(u *uuid.UUID) *FieldTypeUpdateOne {
	if u != nil {
		ftuo.SetNillableUUID(*u)
	}
	return ftuo
}

// ClearNillableUUID clears the value of the "nillable_uuid" field.
func (ftuo *FieldTypeUpdateOne) ClearNillableUUID() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNillableUUID()
	return ftuo
}

// SetStrings sets the "strings" field.
func (ftuo *FieldTypeUpdateOne) SetStrings(s []string) *FieldTypeUpdateOne {
	ftuo.mutation.SetStrings(s)
	return ftuo
}

// ClearStrings clears the value of the "strings" field.
func (ftuo *FieldTypeUpdateOne) ClearStrings() *FieldTypeUpdateOne {
	ftuo.mutation.ClearStrings()
	return ftuo
}

// SetPair sets the "pair" field.
func (ftuo *FieldTypeUpdateOne) SetPair(s schema.Pair) *FieldTypeUpdateOne {
	ftuo.mutation.SetPair(s)
	return ftuo
}

// SetNillablePair sets the "pair" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillablePair(s *schema.Pair) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetPair(*s)
	}
	return ftuo
}

// SetNilPair sets the "nil_pair" field.
func (ftuo *FieldTypeUpdateOne) SetNilPair(s *schema.Pair) *FieldTypeUpdateOne {
	ftuo.mutation.SetNilPair(s)
	return ftuo
}

// ClearNilPair clears the value of the "nil_pair" field.
func (ftuo *FieldTypeUpdateOne) ClearNilPair() *FieldTypeUpdateOne {
	ftuo.mutation.ClearNilPair()
	return ftuo
}

// SetVstring sets the "vstring" field.
func (ftuo *FieldTypeUpdateOne) SetVstring(ss schema.VString) *FieldTypeUpdateOne {
	ftuo.mutation.SetVstring(ss)
	return ftuo
}

// SetNillableVstring sets the "vstring" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableVstring(ss *schema.VString) *FieldTypeUpdateOne {
	if ss != nil {
		ftuo.SetVstring(*ss)
	}
	return ftuo
}

// SetTriple sets the "triple" field.
func (ftuo *FieldTypeUpdateOne) SetTriple(s schema.Triple) *FieldTypeUpdateOne {
	ftuo.mutation.SetTriple(s)
	return ftuo
}

// SetNillableTriple sets the "triple" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableTriple(s *schema.Triple) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetTriple(*s)
	}
	return ftuo
}

// SetBigInt sets the "big_int" field.
func (ftuo *FieldTypeUpdateOne) SetBigInt(si schema.BigInt) *FieldTypeUpdateOne {
	ftuo.mutation.ResetBigInt()
	ftuo.mutation.SetBigInt(si)
	return ftuo
}

// SetNillableBigInt sets the "big_int" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillableBigInt(si *schema.BigInt) *FieldTypeUpdateOne {
	if si != nil {
		ftuo.SetBigInt(*si)
	}
	return ftuo
}

// AddBigInt adds si to the "big_int" field.
func (ftuo *FieldTypeUpdateOne) AddBigInt(si schema.BigInt) *FieldTypeUpdateOne {
	ftuo.mutation.AddBigInt(si)
	return ftuo
}

// ClearBigInt clears the value of the "big_int" field.
func (ftuo *FieldTypeUpdateOne) ClearBigInt() *FieldTypeUpdateOne {
	ftuo.mutation.ClearBigInt()
	return ftuo
}

// SetPasswordOther sets the "password_other" field.
func (ftuo *FieldTypeUpdateOne) SetPasswordOther(s schema.Password) *FieldTypeUpdateOne {
	ftuo.mutation.SetPasswordOther(s)
	return ftuo
}

// SetNillablePasswordOther sets the "password_other" field if the given value is not nil.
func (ftuo *FieldTypeUpdateOne) SetNillablePasswordOther(s *schema.Password) *FieldTypeUpdateOne {
	if s != nil {
		ftuo.SetPasswordOther(*s)
	}
	return ftuo
}

// ClearPasswordOther clears the value of the "password_other" field.
func (ftuo *FieldTypeUpdateOne) ClearPasswordOther() *FieldTypeUpdateOne {
	ftuo.mutation.ClearPasswordOther()
	return ftuo
}

// Mutation returns the FieldTypeMutation object of the builder.
func (ftuo *FieldTypeUpdateOne) Mutation() *FieldTypeMutation {
	return ftuo.mutation
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (ftuo *FieldTypeUpdateOne) Select(field string, fields ...string) *FieldTypeUpdateOne {
	ftuo.fields = append([]string{field}, fields...)
	return ftuo
}

// Save executes the query and returns the updated FieldType entity.
func (ftuo *FieldTypeUpdateOne) Save(ctx context.Context) (*FieldType, error) {
	var (
		err  error
		node *FieldType
	)
	ftuo.defaults()
	if len(ftuo.hooks) == 0 {
		if err = ftuo.check(); err != nil {
			return nil, err
		}
		node, err = ftuo.gremlinSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*FieldTypeMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = ftuo.check(); err != nil {
				return nil, err
			}
			ftuo.mutation = mutation
			node, err = ftuo.gremlinSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(ftuo.hooks) - 1; i >= 0; i-- {
			if ftuo.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = ftuo.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, ftuo.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (ftuo *FieldTypeUpdateOne) SaveX(ctx context.Context) *FieldType {
	node, err := ftuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (ftuo *FieldTypeUpdateOne) Exec(ctx context.Context) error {
	_, err := ftuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ftuo *FieldTypeUpdateOne) ExecX(ctx context.Context) {
	if err := ftuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (ftuo *FieldTypeUpdateOne) defaults() {
	if _, ok := ftuo.mutation.Int64(); !ok {
		v := fieldtype.UpdateDefaultInt64()
		ftuo.mutation.SetInt64(v)
	}
	if _, ok := ftuo.mutation.Duration(); !ok && !ftuo.mutation.DurationCleared() {
		v := fieldtype.UpdateDefaultDuration()
		ftuo.mutation.SetDuration(v)
	}
	if _, ok := ftuo.mutation.DeletedAt(); !ok && !ftuo.mutation.DeletedAtCleared() {
		v := fieldtype.UpdateDefaultDeletedAt()
		ftuo.mutation.SetDeletedAt(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (ftuo *FieldTypeUpdateOne) check() error {
	if v, ok := ftuo.mutation.ValidateOptionalInt32(); ok {
		if err := fieldtype.ValidateOptionalInt32Validator(v); err != nil {
			return &ValidationError{Name: "validate_optional_int32", err: fmt.Errorf(`ent: validator failed for field "FieldType.validate_optional_int32": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.State(); ok {
		if err := fieldtype.StateValidator(v); err != nil {
			return &ValidationError{Name: "state", err: fmt.Errorf(`ent: validator failed for field "FieldType.state": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.MAC(); ok {
		if err := fieldtype.MACValidator(v.String()); err != nil {
			return &ValidationError{Name: "mac", err: fmt.Errorf(`ent: validator failed for field "FieldType.mac": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.Ndir(); ok {
		if err := fieldtype.NdirValidator(string(v)); err != nil {
			return &ValidationError{Name: "ndir", err: fmt.Errorf(`ent: validator failed for field "FieldType.ndir": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.Link(); ok {
		if err := fieldtype.LinkValidator(v.String()); err != nil {
			return &ValidationError{Name: "link", err: fmt.Errorf(`ent: validator failed for field "FieldType.link": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.RawData(); ok {
		if err := fieldtype.RawDataValidator(v); err != nil {
			return &ValidationError{Name: "raw_data", err: fmt.Errorf(`ent: validator failed for field "FieldType.raw_data": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.IP(); ok {
		if err := fieldtype.IPValidator([]byte(v)); err != nil {
			return &ValidationError{Name: "ip", err: fmt.Errorf(`ent: validator failed for field "FieldType.ip": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.Role(); ok {
		if err := fieldtype.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf(`ent: validator failed for field "FieldType.role": %w`, err)}
		}
	}
	if v, ok := ftuo.mutation.Priority(); ok {
		if err := fieldtype.PriorityValidator(v); err != nil {
			return &ValidationError{Name: "priority", err: fmt.Errorf(`ent: validator failed for field "FieldType.priority": %w`, err)}
		}
	}
	return nil
}

func (ftuo *FieldTypeUpdateOne) gremlinSave(ctx context.Context) (*FieldType, error) {
	res := &gremlin.Response{}
	id, ok := ftuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "FieldType.id" for update`)}
	}
	query, bindings := ftuo.gremlin(id).Query()
	if err := ftuo.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	ft := &FieldType{config: ftuo.config}
	if err := ft.FromResponse(res); err != nil {
		return nil, err
	}
	return ft, nil
}

func (ftuo *FieldTypeUpdateOne) gremlin(id string) *dsl.Traversal {
	v := g.V(id)
	var (
		trs []*dsl.Traversal
	)
	if value, ok := ftuo.mutation.Int(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt, value)
	}
	if value, ok := ftuo.mutation.AddedInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt, __.Union(__.Values(fieldtype.FieldInt), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Int8(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt8, value)
	}
	if value, ok := ftuo.mutation.AddedInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt8, __.Union(__.Values(fieldtype.FieldInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Int16(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt16, value)
	}
	if value, ok := ftuo.mutation.AddedInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt16, __.Union(__.Values(fieldtype.FieldInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Int32(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt32, value)
	}
	if value, ok := ftuo.mutation.AddedInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt32, __.Union(__.Values(fieldtype.FieldInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Int64(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt64, value)
	}
	if value, ok := ftuo.mutation.AddedInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldInt64, __.Union(__.Values(fieldtype.FieldInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt, __.Union(__.Values(fieldtype.FieldOptionalInt), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt8, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt8, __.Union(__.Values(fieldtype.FieldOptionalInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt16, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt16, __.Union(__.Values(fieldtype.FieldOptionalInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt32, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt32, __.Union(__.Values(fieldtype.FieldOptionalInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt64, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalInt64, __.Union(__.Values(fieldtype.FieldOptionalInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NillableInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt, value)
	}
	if value, ok := ftuo.mutation.AddedNillableInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt, __.Union(__.Values(fieldtype.FieldNillableInt), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NillableInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt8, value)
	}
	if value, ok := ftuo.mutation.AddedNillableInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt8, __.Union(__.Values(fieldtype.FieldNillableInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NillableInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt16, value)
	}
	if value, ok := ftuo.mutation.AddedNillableInt16(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt16, __.Union(__.Values(fieldtype.FieldNillableInt16), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NillableInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt32, value)
	}
	if value, ok := ftuo.mutation.AddedNillableInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt32, __.Union(__.Values(fieldtype.FieldNillableInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NillableInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt64, value)
	}
	if value, ok := ftuo.mutation.AddedNillableInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableInt64, __.Union(__.Values(fieldtype.FieldNillableInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.ValidateOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldValidateOptionalInt32, value)
	}
	if value, ok := ftuo.mutation.AddedValidateOptionalInt32(); ok {
		v.Property(dsl.Single, fieldtype.FieldValidateOptionalInt32, __.Union(__.Values(fieldtype.FieldValidateOptionalInt32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalUint(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalUint(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint, __.Union(__.Values(fieldtype.FieldOptionalUint), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalUint8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint8, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalUint8(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint8, __.Union(__.Values(fieldtype.FieldOptionalUint8), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalUint16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint16, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalUint16(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint16, __.Union(__.Values(fieldtype.FieldOptionalUint16), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalUint32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint32, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalUint32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint32, __.Union(__.Values(fieldtype.FieldOptionalUint32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalUint64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint64, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalUint64(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUint64, __.Union(__.Values(fieldtype.FieldOptionalUint64), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.State(); ok {
		v.Property(dsl.Single, fieldtype.FieldState, value)
	}
	if value, ok := ftuo.mutation.OptionalFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat, __.Union(__.Values(fieldtype.FieldOptionalFloat), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.OptionalFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat32, value)
	}
	if value, ok := ftuo.mutation.AddedOptionalFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalFloat32, __.Union(__.Values(fieldtype.FieldOptionalFloat32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Text(); ok {
		v.Property(dsl.Single, fieldtype.FieldText, value)
	}
	if value, ok := ftuo.mutation.Datetime(); ok {
		v.Property(dsl.Single, fieldtype.FieldDatetime, value)
	}
	if value, ok := ftuo.mutation.Decimal(); ok {
		v.Property(dsl.Single, fieldtype.FieldDecimal, value)
	}
	if value, ok := ftuo.mutation.AddedDecimal(); ok {
		v.Property(dsl.Single, fieldtype.FieldDecimal, __.Union(__.Values(fieldtype.FieldDecimal), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.LinkOther(); ok {
		v.Property(dsl.Single, fieldtype.FieldLinkOther, value)
	}
	if value, ok := ftuo.mutation.LinkOtherFunc(); ok {
		v.Property(dsl.Single, fieldtype.FieldLinkOtherFunc, value)
	}
	if value, ok := ftuo.mutation.MAC(); ok {
		v.Property(dsl.Single, fieldtype.FieldMAC, value)
	}
	if value, ok := ftuo.mutation.StringArray(); ok {
		v.Property(dsl.Single, fieldtype.FieldStringArray, value)
	}
	if value, ok := ftuo.mutation.Password(); ok {
		v.Property(dsl.Single, fieldtype.FieldPassword, value)
	}
	if value, ok := ftuo.mutation.StringScanner(); ok {
		v.Property(dsl.Single, fieldtype.FieldStringScanner, value)
	}
	if value, ok := ftuo.mutation.Duration(); ok {
		v.Property(dsl.Single, fieldtype.FieldDuration, value)
	}
	if value, ok := ftuo.mutation.AddedDuration(); ok {
		v.Property(dsl.Single, fieldtype.FieldDuration, __.Union(__.Values(fieldtype.FieldDuration), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.Dir(); ok {
		v.Property(dsl.Single, fieldtype.FieldDir, value)
	}
	if value, ok := ftuo.mutation.Ndir(); ok {
		v.Property(dsl.Single, fieldtype.FieldNdir, value)
	}
	if value, ok := ftuo.mutation.Str(); ok {
		v.Property(dsl.Single, fieldtype.FieldStr, value)
	}
	if value, ok := ftuo.mutation.NullStr(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullStr, value)
	}
	if value, ok := ftuo.mutation.Link(); ok {
		v.Property(dsl.Single, fieldtype.FieldLink, value)
	}
	if value, ok := ftuo.mutation.NullLink(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullLink, value)
	}
	if value, ok := ftuo.mutation.Active(); ok {
		v.Property(dsl.Single, fieldtype.FieldActive, value)
	}
	if value, ok := ftuo.mutation.NullActive(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullActive, value)
	}
	if value, ok := ftuo.mutation.Deleted(); ok {
		v.Property(dsl.Single, fieldtype.FieldDeleted, value)
	}
	if value, ok := ftuo.mutation.DeletedAt(); ok {
		v.Property(dsl.Single, fieldtype.FieldDeletedAt, value)
	}
	if value, ok := ftuo.mutation.RawData(); ok {
		v.Property(dsl.Single, fieldtype.FieldRawData, value)
	}
	if value, ok := ftuo.mutation.Sensitive(); ok {
		v.Property(dsl.Single, fieldtype.FieldSensitive, value)
	}
	if value, ok := ftuo.mutation.IP(); ok {
		v.Property(dsl.Single, fieldtype.FieldIP, value)
	}
	if value, ok := ftuo.mutation.NullInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullInt64, value)
	}
	if value, ok := ftuo.mutation.SchemaInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt, value)
	}
	if value, ok := ftuo.mutation.AddedSchemaInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt, __.Union(__.Values(fieldtype.FieldSchemaInt), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.SchemaInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt8, value)
	}
	if value, ok := ftuo.mutation.AddedSchemaInt8(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt8, __.Union(__.Values(fieldtype.FieldSchemaInt8), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.SchemaInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt64, value)
	}
	if value, ok := ftuo.mutation.AddedSchemaInt64(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaInt64, __.Union(__.Values(fieldtype.FieldSchemaInt64), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.SchemaFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat, value)
	}
	if value, ok := ftuo.mutation.AddedSchemaFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat, __.Union(__.Values(fieldtype.FieldSchemaFloat), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.SchemaFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat32, value)
	}
	if value, ok := ftuo.mutation.AddedSchemaFloat32(); ok {
		v.Property(dsl.Single, fieldtype.FieldSchemaFloat32, __.Union(__.Values(fieldtype.FieldSchemaFloat32), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.NullFloat(); ok {
		v.Property(dsl.Single, fieldtype.FieldNullFloat, value)
	}
	if value, ok := ftuo.mutation.Role(); ok {
		v.Property(dsl.Single, fieldtype.FieldRole, value)
	}
	if value, ok := ftuo.mutation.Priority(); ok {
		v.Property(dsl.Single, fieldtype.FieldPriority, value)
	}
	if value, ok := ftuo.mutation.OptionalUUID(); ok {
		v.Property(dsl.Single, fieldtype.FieldOptionalUUID, value)
	}
	if value, ok := ftuo.mutation.NillableUUID(); ok {
		v.Property(dsl.Single, fieldtype.FieldNillableUUID, value)
	}
	if value, ok := ftuo.mutation.Strings(); ok {
		v.Property(dsl.Single, fieldtype.FieldStrings, value)
	}
	if value, ok := ftuo.mutation.Pair(); ok {
		v.Property(dsl.Single, fieldtype.FieldPair, value)
	}
	if value, ok := ftuo.mutation.NilPair(); ok {
		v.Property(dsl.Single, fieldtype.FieldNilPair, value)
	}
	if value, ok := ftuo.mutation.Vstring(); ok {
		v.Property(dsl.Single, fieldtype.FieldVstring, value)
	}
	if value, ok := ftuo.mutation.Triple(); ok {
		v.Property(dsl.Single, fieldtype.FieldTriple, value)
	}
	if value, ok := ftuo.mutation.BigInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldBigInt, value)
	}
	if value, ok := ftuo.mutation.AddedBigInt(); ok {
		v.Property(dsl.Single, fieldtype.FieldBigInt, __.Union(__.Values(fieldtype.FieldBigInt), __.Constant(value)).Sum())
	}
	if value, ok := ftuo.mutation.PasswordOther(); ok {
		v.Property(dsl.Single, fieldtype.FieldPasswordOther, value)
	}
	var properties []interface{}
	if ftuo.mutation.OptionalIntCleared() {
		properties = append(properties, fieldtype.FieldOptionalInt)
	}
	if ftuo.mutation.OptionalInt8Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt8)
	}
	if ftuo.mutation.OptionalInt16Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt16)
	}
	if ftuo.mutation.OptionalInt32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt32)
	}
	if ftuo.mutation.OptionalInt64Cleared() {
		properties = append(properties, fieldtype.FieldOptionalInt64)
	}
	if ftuo.mutation.NillableIntCleared() {
		properties = append(properties, fieldtype.FieldNillableInt)
	}
	if ftuo.mutation.NillableInt8Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt8)
	}
	if ftuo.mutation.NillableInt16Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt16)
	}
	if ftuo.mutation.NillableInt32Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt32)
	}
	if ftuo.mutation.NillableInt64Cleared() {
		properties = append(properties, fieldtype.FieldNillableInt64)
	}
	if ftuo.mutation.ValidateOptionalInt32Cleared() {
		properties = append(properties, fieldtype.FieldValidateOptionalInt32)
	}
	if ftuo.mutation.OptionalUintCleared() {
		properties = append(properties, fieldtype.FieldOptionalUint)
	}
	if ftuo.mutation.OptionalUint8Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint8)
	}
	if ftuo.mutation.OptionalUint16Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint16)
	}
	if ftuo.mutation.OptionalUint32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint32)
	}
	if ftuo.mutation.OptionalUint64Cleared() {
		properties = append(properties, fieldtype.FieldOptionalUint64)
	}
	if ftuo.mutation.StateCleared() {
		properties = append(properties, fieldtype.FieldState)
	}
	if ftuo.mutation.OptionalFloatCleared() {
		properties = append(properties, fieldtype.FieldOptionalFloat)
	}
	if ftuo.mutation.OptionalFloat32Cleared() {
		properties = append(properties, fieldtype.FieldOptionalFloat32)
	}
	if ftuo.mutation.TextCleared() {
		properties = append(properties, fieldtype.FieldText)
	}
	if ftuo.mutation.DatetimeCleared() {
		properties = append(properties, fieldtype.FieldDatetime)
	}
	if ftuo.mutation.DecimalCleared() {
		properties = append(properties, fieldtype.FieldDecimal)
	}
	if ftuo.mutation.LinkOtherCleared() {
		properties = append(properties, fieldtype.FieldLinkOther)
	}
	if ftuo.mutation.LinkOtherFuncCleared() {
		properties = append(properties, fieldtype.FieldLinkOtherFunc)
	}
	if ftuo.mutation.MACCleared() {
		properties = append(properties, fieldtype.FieldMAC)
	}
	if ftuo.mutation.StringArrayCleared() {
		properties = append(properties, fieldtype.FieldStringArray)
	}
	if ftuo.mutation.PasswordCleared() {
		properties = append(properties, fieldtype.FieldPassword)
	}
	if ftuo.mutation.StringScannerCleared() {
		properties = append(properties, fieldtype.FieldStringScanner)
	}
	if ftuo.mutation.DurationCleared() {
		properties = append(properties, fieldtype.FieldDuration)
	}
	if ftuo.mutation.NdirCleared() {
		properties = append(properties, fieldtype.FieldNdir)
	}
	if ftuo.mutation.StrCleared() {
		properties = append(properties, fieldtype.FieldStr)
	}
	if ftuo.mutation.NullStrCleared() {
		properties = append(properties, fieldtype.FieldNullStr)
	}
	if ftuo.mutation.LinkCleared() {
		properties = append(properties, fieldtype.FieldLink)
	}
	if ftuo.mutation.NullLinkCleared() {
		properties = append(properties, fieldtype.FieldNullLink)
	}
	if ftuo.mutation.ActiveCleared() {
		properties = append(properties, fieldtype.FieldActive)
	}
	if ftuo.mutation.NullActiveCleared() {
		properties = append(properties, fieldtype.FieldNullActive)
	}
	if ftuo.mutation.DeletedCleared() {
		properties = append(properties, fieldtype.FieldDeleted)
	}
	if ftuo.mutation.DeletedAtCleared() {
		properties = append(properties, fieldtype.FieldDeletedAt)
	}
	if ftuo.mutation.RawDataCleared() {
		properties = append(properties, fieldtype.FieldRawData)
	}
	if ftuo.mutation.SensitiveCleared() {
		properties = append(properties, fieldtype.FieldSensitive)
	}
	if ftuo.mutation.IPCleared() {
		properties = append(properties, fieldtype.FieldIP)
	}
	if ftuo.mutation.NullInt64Cleared() {
		properties = append(properties, fieldtype.FieldNullInt64)
	}
	if ftuo.mutation.SchemaIntCleared() {
		properties = append(properties, fieldtype.FieldSchemaInt)
	}
	if ftuo.mutation.SchemaInt8Cleared() {
		properties = append(properties, fieldtype.FieldSchemaInt8)
	}
	if ftuo.mutation.SchemaInt64Cleared() {
		properties = append(properties, fieldtype.FieldSchemaInt64)
	}
	if ftuo.mutation.SchemaFloatCleared() {
		properties = append(properties, fieldtype.FieldSchemaFloat)
	}
	if ftuo.mutation.SchemaFloat32Cleared() {
		properties = append(properties, fieldtype.FieldSchemaFloat32)
	}
	if ftuo.mutation.NullFloatCleared() {
		properties = append(properties, fieldtype.FieldNullFloat)
	}
	if ftuo.mutation.PriorityCleared() {
		properties = append(properties, fieldtype.FieldPriority)
	}
	if ftuo.mutation.OptionalUUIDCleared() {
		properties = append(properties, fieldtype.FieldOptionalUUID)
	}
	if ftuo.mutation.NillableUUIDCleared() {
		properties = append(properties, fieldtype.FieldNillableUUID)
	}
	if ftuo.mutation.StringsCleared() {
		properties = append(properties, fieldtype.FieldStrings)
	}
	if ftuo.mutation.NilPairCleared() {
		properties = append(properties, fieldtype.FieldNilPair)
	}
	if ftuo.mutation.BigIntCleared() {
		properties = append(properties, fieldtype.FieldBigInt)
	}
	if ftuo.mutation.PasswordOtherCleared() {
		properties = append(properties, fieldtype.FieldPasswordOther)
	}
	if len(properties) > 0 {
		v.SideEffect(__.Properties(properties...).Drop())
	}
	if len(ftuo.fields) > 0 {
		fields := make([]interface{}, 0, len(ftuo.fields)+1)
		fields = append(fields, true)
		for _, f := range ftuo.fields {
			fields = append(fields, f)
		}
		v.ValueMap(fields...)
	} else {
		v.ValueMap(true)
	}
	trs = append(trs, v)
	return dsl.Join(trs...)
}
