// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/entc/integration/ent/comment"
	"entgo.io/ent/schema/field"
)

// CommentCreate is the builder for creating a Comment entity.
type CommentCreate struct {
	config
	mutation *CommentMutation
	hooks    []Hook
	conflict []sql.ConflictOption
}

// SetUniqueInt sets the "unique_int" field.
func (cc *CommentCreate) SetUniqueInt(i int) *CommentCreate {
	cc.mutation.SetUniqueInt(i)
	return cc
}

// SetUniqueFloat sets the "unique_float" field.
func (cc *CommentCreate) SetUniqueFloat(f float64) *CommentCreate {
	cc.mutation.SetUniqueFloat(f)
	return cc
}

// SetNillableInt sets the "nillable_int" field.
func (cc *CommentCreate) SetNillableInt(i int) *CommentCreate {
	cc.mutation.SetNillableInt(i)
	return cc
}

// SetNillableNillableInt sets the "nillable_int" field if the given value is not nil.
func (cc *CommentCreate) SetNillableNillableInt(i *int) *CommentCreate {
	if i != nil {
		cc.SetNillableInt(*i)
	}
	return cc
}

// SetTable sets the "table" field.
func (cc *CommentCreate) SetTable(s string) *CommentCreate {
	cc.mutation.SetTable(s)
	return cc
}

// SetNillableTable sets the "table" field if the given value is not nil.
func (cc *CommentCreate) SetNillableTable(s *string) *CommentCreate {
	if s != nil {
		cc.SetTable(*s)
	}
	return cc
}

// Mutation returns the CommentMutation object of the builder.
func (cc *CommentCreate) Mutation() *CommentMutation {
	return cc.mutation
}

// Save creates the Comment in the database.
func (cc *CommentCreate) Save(ctx context.Context) (*Comment, error) {
	var (
		err  error
		node *Comment
	)
	if len(cc.hooks) == 0 {
		if err = cc.check(); err != nil {
			return nil, err
		}
		node, err = cc.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*CommentMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = cc.check(); err != nil {
				return nil, err
			}
			cc.mutation = mutation
			if node, err = cc.sqlSave(ctx); err != nil {
				return nil, err
			}
			mutation.id = &node.ID
			mutation.done = true
			return node, err
		})
		for i := len(cc.hooks) - 1; i >= 0; i-- {
			if cc.hooks[i] == nil {
				return nil, fmt.Errorf("ent: uninitialized hook (forgotten import ent/runtime?)")
			}
			mut = cc.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, cc.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (cc *CommentCreate) SaveX(ctx context.Context) *Comment {
	v, err := cc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (cc *CommentCreate) Exec(ctx context.Context) error {
	_, err := cc.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cc *CommentCreate) ExecX(ctx context.Context) {
	if err := cc.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (cc *CommentCreate) check() error {
	if _, ok := cc.mutation.UniqueInt(); !ok {
		return &ValidationError{Name: "unique_int", err: errors.New(`ent: missing required field "Comment.unique_int"`)}
	}
	if _, ok := cc.mutation.UniqueFloat(); !ok {
		return &ValidationError{Name: "unique_float", err: errors.New(`ent: missing required field "Comment.unique_float"`)}
	}
	return nil
}

func (cc *CommentCreate) sqlSave(ctx context.Context) (*Comment, error) {
	_node, _spec := cc.createSpec()
	if err := sqlgraph.CreateNode(ctx, cc.driver, _spec); err != nil {
		if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{err.Error(), err}
		}
		return nil, err
	}
	id := _spec.ID.Value.(int64)
	_node.ID = int(id)
	return _node, nil
}

func (cc *CommentCreate) createSpec() (*Comment, *sqlgraph.CreateSpec) {
	var (
		_node = &Comment{config: cc.config}
		_spec = &sqlgraph.CreateSpec{
			Table: comment.Table,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: comment.FieldID,
			},
		}
	)
	_spec.OnConflict = cc.conflict
	if value, ok := cc.mutation.UniqueInt(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: comment.FieldUniqueInt,
		})
		_node.UniqueInt = value
	}
	if value, ok := cc.mutation.UniqueFloat(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeFloat64,
			Value:  value,
			Column: comment.FieldUniqueFloat,
		})
		_node.UniqueFloat = value
	}
	if value, ok := cc.mutation.NillableInt(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeInt,
			Value:  value,
			Column: comment.FieldNillableInt,
		})
		_node.NillableInt = &value
	}
	if value, ok := cc.mutation.Table(); ok {
		_spec.Fields = append(_spec.Fields, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: comment.FieldTable,
		})
		_node.Table = value
	}
	return _node, _spec
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Comment.Create().
//		SetUniqueInt(v).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.CommentUpsert) {
//			SetUniqueInt(v+v).
//		}).
//		Exec(ctx)
//
func (cc *CommentCreate) OnConflict(opts ...sql.ConflictOption) *CommentUpsertOne {
	cc.conflict = opts
	return &CommentUpsertOne{
		create: cc,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Comment.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
//
func (cc *CommentCreate) OnConflictColumns(columns ...string) *CommentUpsertOne {
	cc.conflict = append(cc.conflict, sql.ConflictColumns(columns...))
	return &CommentUpsertOne{
		create: cc,
	}
}

type (
	// CommentUpsertOne is the builder for "upsert"-ing
	//  one Comment node.
	CommentUpsertOne struct {
		create *CommentCreate
	}

	// CommentUpsert is the "OnConflict" setter.
	CommentUpsert struct {
		*sql.UpdateSet
	}
)

// SetUniqueInt sets the "unique_int" field.
func (u *CommentUpsert) SetUniqueInt(v int) *CommentUpsert {
	u.Set(comment.FieldUniqueInt, v)
	return u
}

// UpdateUniqueInt sets the "unique_int" field to the value that was provided on create.
func (u *CommentUpsert) UpdateUniqueInt() *CommentUpsert {
	u.SetExcluded(comment.FieldUniqueInt)
	return u
}

// AddUniqueInt adds v to the "unique_int" field.
func (u *CommentUpsert) AddUniqueInt(v int) *CommentUpsert {
	u.Add(comment.FieldUniqueInt, v)
	return u
}

// SetUniqueFloat sets the "unique_float" field.
func (u *CommentUpsert) SetUniqueFloat(v float64) *CommentUpsert {
	u.Set(comment.FieldUniqueFloat, v)
	return u
}

// UpdateUniqueFloat sets the "unique_float" field to the value that was provided on create.
func (u *CommentUpsert) UpdateUniqueFloat() *CommentUpsert {
	u.SetExcluded(comment.FieldUniqueFloat)
	return u
}

// AddUniqueFloat adds v to the "unique_float" field.
func (u *CommentUpsert) AddUniqueFloat(v float64) *CommentUpsert {
	u.Add(comment.FieldUniqueFloat, v)
	return u
}

// SetNillableInt sets the "nillable_int" field.
func (u *CommentUpsert) SetNillableInt(v int) *CommentUpsert {
	u.Set(comment.FieldNillableInt, v)
	return u
}

// UpdateNillableInt sets the "nillable_int" field to the value that was provided on create.
func (u *CommentUpsert) UpdateNillableInt() *CommentUpsert {
	u.SetExcluded(comment.FieldNillableInt)
	return u
}

// AddNillableInt adds v to the "nillable_int" field.
func (u *CommentUpsert) AddNillableInt(v int) *CommentUpsert {
	u.Add(comment.FieldNillableInt, v)
	return u
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (u *CommentUpsert) ClearNillableInt() *CommentUpsert {
	u.SetNull(comment.FieldNillableInt)
	return u
}

// SetTable sets the "table" field.
func (u *CommentUpsert) SetTable(v string) *CommentUpsert {
	u.Set(comment.FieldTable, v)
	return u
}

// UpdateTable sets the "table" field to the value that was provided on create.
func (u *CommentUpsert) UpdateTable() *CommentUpsert {
	u.SetExcluded(comment.FieldTable)
	return u
}

// ClearTable clears the value of the "table" field.
func (u *CommentUpsert) ClearTable() *CommentUpsert {
	u.SetNull(comment.FieldTable)
	return u
}

// UpdateNewValues updates the mutable fields using the new values that were set on create.
// Using this option is equivalent to using:
//
//	client.Comment.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
//
func (u *CommentUpsertOne) UpdateNewValues() *CommentUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//  client.Comment.Create().
//      OnConflict(sql.ResolveWithIgnore()).
//      Exec(ctx)
//
func (u *CommentUpsertOne) Ignore() *CommentUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *CommentUpsertOne) DoNothing() *CommentUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the CommentCreate.OnConflict
// documentation for more info.
func (u *CommentUpsertOne) Update(set func(*CommentUpsert)) *CommentUpsertOne {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&CommentUpsert{UpdateSet: update})
	}))
	return u
}

// SetUniqueInt sets the "unique_int" field.
func (u *CommentUpsertOne) SetUniqueInt(v int) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.SetUniqueInt(v)
	})
}

// AddUniqueInt adds v to the "unique_int" field.
func (u *CommentUpsertOne) AddUniqueInt(v int) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.AddUniqueInt(v)
	})
}

// UpdateUniqueInt sets the "unique_int" field to the value that was provided on create.
func (u *CommentUpsertOne) UpdateUniqueInt() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateUniqueInt()
	})
}

// SetUniqueFloat sets the "unique_float" field.
func (u *CommentUpsertOne) SetUniqueFloat(v float64) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.SetUniqueFloat(v)
	})
}

// AddUniqueFloat adds v to the "unique_float" field.
func (u *CommentUpsertOne) AddUniqueFloat(v float64) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.AddUniqueFloat(v)
	})
}

// UpdateUniqueFloat sets the "unique_float" field to the value that was provided on create.
func (u *CommentUpsertOne) UpdateUniqueFloat() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateUniqueFloat()
	})
}

// SetNillableInt sets the "nillable_int" field.
func (u *CommentUpsertOne) SetNillableInt(v int) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.SetNillableInt(v)
	})
}

// AddNillableInt adds v to the "nillable_int" field.
func (u *CommentUpsertOne) AddNillableInt(v int) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.AddNillableInt(v)
	})
}

// UpdateNillableInt sets the "nillable_int" field to the value that was provided on create.
func (u *CommentUpsertOne) UpdateNillableInt() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateNillableInt()
	})
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (u *CommentUpsertOne) ClearNillableInt() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.ClearNillableInt()
	})
}

// SetTable sets the "table" field.
func (u *CommentUpsertOne) SetTable(v string) *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.SetTable(v)
	})
}

// UpdateTable sets the "table" field to the value that was provided on create.
func (u *CommentUpsertOne) UpdateTable() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateTable()
	})
}

// ClearTable clears the value of the "table" field.
func (u *CommentUpsertOne) ClearTable() *CommentUpsertOne {
	return u.Update(func(s *CommentUpsert) {
		s.ClearTable()
	})
}

// Exec executes the query.
func (u *CommentUpsertOne) Exec(ctx context.Context) error {
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for CommentCreate.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *CommentUpsertOne) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}

// Exec executes the UPSERT query and returns the inserted/updated ID.
func (u *CommentUpsertOne) ID(ctx context.Context) (id int, err error) {
	node, err := u.create.Save(ctx)
	if err != nil {
		return id, err
	}
	return node.ID, nil
}

// IDX is like ID, but panics if an error occurs.
func (u *CommentUpsertOne) IDX(ctx context.Context) int {
	id, err := u.ID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// CommentCreateBulk is the builder for creating many Comment entities in bulk.
type CommentCreateBulk struct {
	config
	builders []*CommentCreate
	conflict []sql.ConflictOption
}

// Save creates the Comment entities in the database.
func (ccb *CommentCreateBulk) Save(ctx context.Context) ([]*Comment, error) {
	specs := make([]*sqlgraph.CreateSpec, len(ccb.builders))
	nodes := make([]*Comment, len(ccb.builders))
	mutators := make([]Mutator, len(ccb.builders))
	for i := range ccb.builders {
		func(i int, root context.Context) {
			builder := ccb.builders[i]
			var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
				mutation, ok := m.(*CommentMutation)
				if !ok {
					return nil, fmt.Errorf("unexpected mutation type %T", m)
				}
				if err := builder.check(); err != nil {
					return nil, err
				}
				builder.mutation = mutation
				nodes[i], specs[i] = builder.createSpec()
				var err error
				if i < len(mutators)-1 {
					_, err = mutators[i+1].Mutate(root, ccb.builders[i+1].mutation)
				} else {
					spec := &sqlgraph.BatchCreateSpec{Nodes: specs}
					spec.OnConflict = ccb.conflict
					// Invoke the actual operation on the latest mutation in the chain.
					if err = sqlgraph.BatchCreate(ctx, ccb.driver, spec); err != nil {
						if sqlgraph.IsConstraintError(err) {
							err = &ConstraintError{err.Error(), err}
						}
					}
				}
				if err != nil {
					return nil, err
				}
				mutation.id = &nodes[i].ID
				mutation.done = true
				if specs[i].ID.Value != nil {
					id := specs[i].ID.Value.(int64)
					nodes[i].ID = int(id)
				}
				return nodes[i], nil
			})
			for i := len(builder.hooks) - 1; i >= 0; i-- {
				mut = builder.hooks[i](mut)
			}
			mutators[i] = mut
		}(i, ctx)
	}
	if len(mutators) > 0 {
		if _, err := mutators[0].Mutate(ctx, ccb.builders[0].mutation); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

// SaveX is like Save, but panics if an error occurs.
func (ccb *CommentCreateBulk) SaveX(ctx context.Context) []*Comment {
	v, err := ccb.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// Exec executes the query.
func (ccb *CommentCreateBulk) Exec(ctx context.Context) error {
	_, err := ccb.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (ccb *CommentCreateBulk) ExecX(ctx context.Context) {
	if err := ccb.Exec(ctx); err != nil {
		panic(err)
	}
}

// OnConflict allows configuring the `ON CONFLICT` / `ON DUPLICATE KEY` clause
// of the `INSERT` statement. For example:
//
//	client.Comment.CreateBulk(builders...).
//		OnConflict(
//			// Update the row with the new values
//			// the was proposed for insertion.
//			sql.ResolveWithNewValues(),
//		).
//		// Override some of the fields with custom
//		// update values.
//		Update(func(u *ent.CommentUpsert) {
//			SetUniqueInt(v+v).
//		}).
//		Exec(ctx)
//
func (ccb *CommentCreateBulk) OnConflict(opts ...sql.ConflictOption) *CommentUpsertBulk {
	ccb.conflict = opts
	return &CommentUpsertBulk{
		create: ccb,
	}
}

// OnConflictColumns calls `OnConflict` and configures the columns
// as conflict target. Using this option is equivalent to using:
//
//	client.Comment.Create().
//		OnConflict(sql.ConflictColumns(columns...)).
//		Exec(ctx)
//
func (ccb *CommentCreateBulk) OnConflictColumns(columns ...string) *CommentUpsertBulk {
	ccb.conflict = append(ccb.conflict, sql.ConflictColumns(columns...))
	return &CommentUpsertBulk{
		create: ccb,
	}
}

// CommentUpsertBulk is the builder for "upsert"-ing
// a bulk of Comment nodes.
type CommentUpsertBulk struct {
	create *CommentCreateBulk
}

// UpdateNewValues updates the mutable fields using the new values that
// were set on create. Using this option is equivalent to using:
//
//	client.Comment.Create().
//		OnConflict(
//			sql.ResolveWithNewValues(),
//		).
//		Exec(ctx)
//
func (u *CommentUpsertBulk) UpdateNewValues() *CommentUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithNewValues())
	return u
}

// Ignore sets each column to itself in case of conflict.
// Using this option is equivalent to using:
//
//	client.Comment.Create().
//		OnConflict(sql.ResolveWithIgnore()).
//		Exec(ctx)
//
func (u *CommentUpsertBulk) Ignore() *CommentUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWithIgnore())
	return u
}

// DoNothing configures the conflict_action to `DO NOTHING`.
// Supported only by SQLite and PostgreSQL.
func (u *CommentUpsertBulk) DoNothing() *CommentUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.DoNothing())
	return u
}

// Update allows overriding fields `UPDATE` values. See the CommentCreateBulk.OnConflict
// documentation for more info.
func (u *CommentUpsertBulk) Update(set func(*CommentUpsert)) *CommentUpsertBulk {
	u.create.conflict = append(u.create.conflict, sql.ResolveWith(func(update *sql.UpdateSet) {
		set(&CommentUpsert{UpdateSet: update})
	}))
	return u
}

// SetUniqueInt sets the "unique_int" field.
func (u *CommentUpsertBulk) SetUniqueInt(v int) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.SetUniqueInt(v)
	})
}

// AddUniqueInt adds v to the "unique_int" field.
func (u *CommentUpsertBulk) AddUniqueInt(v int) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.AddUniqueInt(v)
	})
}

// UpdateUniqueInt sets the "unique_int" field to the value that was provided on create.
func (u *CommentUpsertBulk) UpdateUniqueInt() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateUniqueInt()
	})
}

// SetUniqueFloat sets the "unique_float" field.
func (u *CommentUpsertBulk) SetUniqueFloat(v float64) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.SetUniqueFloat(v)
	})
}

// AddUniqueFloat adds v to the "unique_float" field.
func (u *CommentUpsertBulk) AddUniqueFloat(v float64) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.AddUniqueFloat(v)
	})
}

// UpdateUniqueFloat sets the "unique_float" field to the value that was provided on create.
func (u *CommentUpsertBulk) UpdateUniqueFloat() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateUniqueFloat()
	})
}

// SetNillableInt sets the "nillable_int" field.
func (u *CommentUpsertBulk) SetNillableInt(v int) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.SetNillableInt(v)
	})
}

// AddNillableInt adds v to the "nillable_int" field.
func (u *CommentUpsertBulk) AddNillableInt(v int) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.AddNillableInt(v)
	})
}

// UpdateNillableInt sets the "nillable_int" field to the value that was provided on create.
func (u *CommentUpsertBulk) UpdateNillableInt() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateNillableInt()
	})
}

// ClearNillableInt clears the value of the "nillable_int" field.
func (u *CommentUpsertBulk) ClearNillableInt() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.ClearNillableInt()
	})
}

// SetTable sets the "table" field.
func (u *CommentUpsertBulk) SetTable(v string) *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.SetTable(v)
	})
}

// UpdateTable sets the "table" field to the value that was provided on create.
func (u *CommentUpsertBulk) UpdateTable() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.UpdateTable()
	})
}

// ClearTable clears the value of the "table" field.
func (u *CommentUpsertBulk) ClearTable() *CommentUpsertBulk {
	return u.Update(func(s *CommentUpsert) {
		s.ClearTable()
	})
}

// Exec executes the query.
func (u *CommentUpsertBulk) Exec(ctx context.Context) error {
	for i, b := range u.create.builders {
		if len(b.conflict) != 0 {
			return fmt.Errorf("ent: OnConflict was set for builder %d. Set it on the CommentCreateBulk instead", i)
		}
	}
	if len(u.create.conflict) == 0 {
		return errors.New("ent: missing options for CommentCreateBulk.OnConflict")
	}
	return u.create.Exec(ctx)
}

// ExecX is like Exec, but panics if an error occurs.
func (u *CommentUpsertBulk) ExecX(ctx context.Context) {
	if err := u.create.Exec(ctx); err != nil {
		panic(err)
	}
}
