// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	. "github.com/aws/aws-sdk-go-v2/service/autoscaling"
)

// ASG provides an interface to the AWS ASG service.
type ASG interface {
	// Attaches one or more EC2 instances to the specified Auto Scaling group. When you
	// attach instances, Amazon EC2 Auto Scaling increases the desired capacity of the
	// group by the number of instances being attached. If the number of instances
	// being attached plus the desired capacity of the group exceeds the maximum size
	// of the group, the operation fails. If there is a Classic Load Balancer attached
	// to your Auto Scaling group, the instances are also registered with the load
	// balancer. If there are target groups attached to your Auto Scaling group, the
	// instances are also registered with the target groups. For more information, see
	// Attach EC2 instances to your Auto Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	AttachInstances(ctx context.Context, params *AttachInstancesInput, optFns ...func(*Options)) (*AttachInstancesOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (AttachTrafficSources) that can attach multiple traffic sources types. While we
	// continue to support AttachLoadBalancerTargetGroups, and you can use both the
	// original AttachLoadBalancerTargetGroups API call and the new
	// AttachTrafficSources API call on the same Auto Scaling group, we recommend using
	// the new "traffic sources" API call to simplify how you manage traffic sources.
	// Attaches one or more target groups to the specified Auto Scaling group. This
	// operation is used with the following load balancer types:
	//
	// * Application Load
	// Balancer - Operates at the application layer (layer 7) and supports HTTP and
	// HTTPS.
	//
	// * Network Load Balancer - Operates at the transport layer (layer 4) and
	// supports TCP, TLS, and UDP.
	//
	// * Gateway Load Balancer - Operates at the network
	// layer (layer 3).
	//
	// To describe the target groups for an Auto Scaling group, call
	// the DescribeLoadBalancerTargetGroups API. To detach the target group from the
	// Auto Scaling group, call the DetachLoadBalancerTargetGroups API. This operation
	// is additive and does not detach existing target groups or Classic Load Balancers
	// from the Auto Scaling group. For more information, see Use Elastic Load
	// Balancing to distribute traffic across the instances in your Auto Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	AttachLoadBalancerTargetGroups(ctx context.Context, params *AttachLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*AttachLoadBalancerTargetGroupsOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (AttachTrafficSources) that can attach multiple traffic sources types. While we
	// continue to support AttachLoadBalancers, and you can use both the original
	// AttachLoadBalancers API call and the new AttachTrafficSources API call on the
	// same Auto Scaling group, we recommend using the new "traffic sources" API call
	// to simplify how you manage traffic sources. Attaches one or more Classic Load
	// Balancers to the specified Auto Scaling group. Amazon EC2 Auto Scaling registers
	// the running instances with these Classic Load Balancers. To describe the load
	// balancers for an Auto Scaling group, call the DescribeLoadBalancers API. To
	// detach a load balancer from the Auto Scaling group, call the DetachLoadBalancers
	// API. This operation is additive and does not detach existing Classic Load
	// Balancers or target groups from the Auto Scaling group. For more information,
	// see Use Elastic Load Balancing to distribute traffic across the instances in
	// your Auto Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	AttachLoadBalancers(ctx context.Context, params *AttachLoadBalancersInput, optFns ...func(*Options)) (*AttachLoadBalancersOutput, error)
	// Attaches one or more traffic sources to the specified Auto Scaling group. You
	// can use any of the following as traffic sources for an Auto Scaling group:
	//
	// *
	// Application Load Balancer
	//
	// * Classic Load Balancer
	//
	// * Network Load Balancer
	//
	// *
	// Gateway Load Balancer
	//
	// * VPC Lattice
	//
	// This operation is additive and does not
	// detach existing traffic sources from the Auto Scaling group. After the operation
	// completes, use the DescribeTrafficSources API to return details about the state
	// of the attachments between traffic sources and your Auto Scaling group. To
	// detach a traffic source from the Auto Scaling group, call the
	// DetachTrafficSources API.
	AttachTrafficSources(ctx context.Context, params *AttachTrafficSourcesInput, optFns ...func(*Options)) (*AttachTrafficSourcesOutput, error)
	// Deletes one or more scheduled actions for the specified Auto Scaling group.
	BatchDeleteScheduledAction(ctx context.Context, params *BatchDeleteScheduledActionInput, optFns ...func(*Options)) (*BatchDeleteScheduledActionOutput, error)
	// Creates or updates one or more scheduled scaling actions for an Auto Scaling
	// group.
	BatchPutScheduledUpdateGroupAction(ctx context.Context, params *BatchPutScheduledUpdateGroupActionInput, optFns ...func(*Options)) (*BatchPutScheduledUpdateGroupActionOutput, error)
	// Cancels an instance refresh or rollback that is in progress. If an instance
	// refresh or rollback is not in progress, an ActiveInstanceRefreshNotFound error
	// occurs. This operation is part of the instance refresh feature
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
	// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
	// Scaling group after you make configuration changes. When you cancel an instance
	// refresh, this does not roll back any changes that it made. Use the
	// RollbackInstanceRefresh API to roll back instead.
	CancelInstanceRefresh(ctx context.Context, params *CancelInstanceRefreshInput, optFns ...func(*Options)) (*CancelInstanceRefreshOutput, error)
	// Completes the lifecycle action for the specified token or instance with the
	// specified result. This step is a part of the procedure for adding a lifecycle
	// hook to an Auto Scaling group:
	//
	// * (Optional) Create a launch template or launch
	// configuration with a user data script that runs while an instance is in a wait
	// state due to a lifecycle hook.
	//
	// * (Optional) Create a Lambda function and a rule
	// that allows Amazon EventBridge to invoke your Lambda function when an instance
	// is put into a wait state due to a lifecycle hook.
	//
	// * (Optional) Create a
	// notification target and an IAM role. The target can be either an Amazon SQS
	// queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish
	// lifecycle notifications to the target.
	//
	// * Create the lifecycle hook. Specify
	// whether the hook is used when the instances launch or terminate.
	//
	// * If you need
	// more time, record the lifecycle action heartbeat to keep the instance in a wait
	// state.
	//
	// * If you finish before the timeout period ends, send a callback by using
	// the CompleteLifecycleAction API call.
	//
	// For more information, see Amazon EC2 Auto
	// Scaling lifecycle hooks
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in
	// the Amazon EC2 Auto Scaling User Guide.
	CompleteLifecycleAction(ctx context.Context, params *CompleteLifecycleActionInput, optFns ...func(*Options)) (*CompleteLifecycleActionOutput, error)
	// We strongly recommend using a launch template when calling this operation to
	// ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2. Creates an
	// Auto Scaling group with the specified name and attributes. If you exceed your
	// maximum limit of Auto Scaling groups, the call fails. To query this limit, call
	// the DescribeAccountLimits API. For information about updating this limit, see
	// Quotas for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html)
	// in the Amazon EC2 Auto Scaling User Guide. For introductory exercises for
	// creating an Auto Scaling group, see Getting started with Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html)
	// and Tutorial: Set up a scaled and load-balanced application
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html)
	// in the Amazon EC2 Auto Scaling User Guide. For more information, see Auto
	// Scaling groups
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html) in
	// the Amazon EC2 Auto Scaling User Guide. Every Auto Scaling group has three size
	// properties (DesiredCapacity, MaxSize, and MinSize). Usually, you set these sizes
	// based on a specific number of instances. However, if you configure a mixed
	// instances policy that defines weights for the instance types, you must specify
	// these sizes with the same units that you use for weighting instances.
	CreateAutoScalingGroup(ctx context.Context, params *CreateAutoScalingGroupInput, optFns ...func(*Options)) (*CreateAutoScalingGroupOutput, error)
	// Creates a launch configuration. If you exceed your maximum limit of launch
	// configurations, the call fails. To query this limit, call the
	// DescribeAccountLimits API. For information about updating this limit, see Quotas
	// for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html)
	// in the Amazon EC2 Auto Scaling User Guide. For more information, see Launch
	// configurations
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html)
	// in the Amazon EC2 Auto Scaling User Guide. Amazon EC2 Auto Scaling configures
	// instances launched as part of an Auto Scaling group using either a launch
	// template or a launch configuration. We strongly recommend that you do not use
	// launch configurations. They do not provide full functionality for Amazon EC2
	// Auto Scaling or Amazon EC2. For information about using launch templates, see
	// Launch templates
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-templates.html) in
	// the Amazon EC2 Auto Scaling User Guide.
	CreateLaunchConfiguration(ctx context.Context, params *CreateLaunchConfigurationInput, optFns ...func(*Options)) (*CreateLaunchConfigurationOutput, error)
	// Creates or updates tags for the specified Auto Scaling group. When you specify a
	// tag with a key that already exists, the operation overwrites the previous tag
	// definition, and you do not get an error message. For more information, see Tag
	// Auto Scaling groups and instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	CreateOrUpdateTags(ctx context.Context, params *CreateOrUpdateTagsInput, optFns ...func(*Options)) (*CreateOrUpdateTagsOutput, error)
	// Deletes the specified Auto Scaling group. If the group has instances or scaling
	// activities in progress, you must specify the option to force the deletion in
	// order for it to succeed. The force delete operation will also terminate the EC2
	// instances. If the group has a warm pool, the force delete option also deletes
	// the warm pool. To remove instances from the Auto Scaling group before deleting
	// it, call the DetachInstances API with the list of instances and the option to
	// decrement the desired capacity. This ensures that Amazon EC2 Auto Scaling does
	// not launch replacement instances. To terminate all instances before deleting the
	// Auto Scaling group, call the UpdateAutoScalingGroup API and set the minimum size
	// and desired capacity of the Auto Scaling group to zero. If the group has scaling
	// policies, deleting the group deletes the policies, the underlying alarm actions,
	// and any alarm that no longer has an associated action. For more information, see
	// Delete your Auto Scaling infrastructure
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-process-shutdown.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DeleteAutoScalingGroup(ctx context.Context, params *DeleteAutoScalingGroupInput, optFns ...func(*Options)) (*DeleteAutoScalingGroupOutput, error)
	// Deletes the specified launch configuration. The launch configuration must not be
	// attached to an Auto Scaling group. When this call completes, the launch
	// configuration is no longer available for use.
	DeleteLaunchConfiguration(ctx context.Context, params *DeleteLaunchConfigurationInput, optFns ...func(*Options)) (*DeleteLaunchConfigurationOutput, error)
	// Deletes the specified lifecycle hook. If there are any outstanding lifecycle
	// actions, they are completed first (ABANDON for launching instances, CONTINUE for
	// terminating instances).
	DeleteLifecycleHook(ctx context.Context, params *DeleteLifecycleHookInput, optFns ...func(*Options)) (*DeleteLifecycleHookOutput, error)
	// Deletes the specified notification.
	DeleteNotificationConfiguration(ctx context.Context, params *DeleteNotificationConfigurationInput, optFns ...func(*Options)) (*DeleteNotificationConfigurationOutput, error)
	// Deletes the specified scaling policy. Deleting either a step scaling policy or a
	// simple scaling policy deletes the underlying alarm action, but does not delete
	// the alarm, even if it no longer has an associated action. For more information,
	// see Deleting a scaling policy
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DeletePolicy(ctx context.Context, params *DeletePolicyInput, optFns ...func(*Options)) (*DeletePolicyOutput, error)
	// Deletes the specified scheduled action.
	DeleteScheduledAction(ctx context.Context, params *DeleteScheduledActionInput, optFns ...func(*Options)) (*DeleteScheduledActionOutput, error)
	// Deletes the specified tags.
	DeleteTags(ctx context.Context, params *DeleteTagsInput, optFns ...func(*Options)) (*DeleteTagsOutput, error)
	// Deletes the warm pool for the specified Auto Scaling group. For more
	// information, see Warm pools for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DeleteWarmPool(ctx context.Context, params *DeleteWarmPoolInput, optFns ...func(*Options)) (*DeleteWarmPoolOutput, error)
	// Describes the current Amazon EC2 Auto Scaling resource quotas for your account.
	// When you establish an Amazon Web Services account, the account has initial
	// quotas on the maximum number of Auto Scaling groups and launch configurations
	// that you can create in a given Region. For more information, see Quotas for
	// Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-quotas.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeAccountLimits(ctx context.Context, params *DescribeAccountLimitsInput, optFns ...func(*Options)) (*DescribeAccountLimitsOutput, error)
	// Describes the available adjustment types for step scaling and simple scaling
	// policies. The following adjustment types are supported:
	//
	// * ChangeInCapacity
	//
	// *
	// ExactCapacity
	//
	// * PercentChangeInCapacity
	DescribeAdjustmentTypes(ctx context.Context, params *DescribeAdjustmentTypesInput, optFns ...func(*Options)) (*DescribeAdjustmentTypesOutput, error)
	// Gets information about the Auto Scaling groups in the account and Region. If you
	// specify Auto Scaling group names, the output includes information for only the
	// specified Auto Scaling groups. If you specify filters, the output includes
	// information for only those Auto Scaling groups that meet the filter criteria. If
	// you do not specify group names or filters, the output includes information for
	// all Auto Scaling groups. This operation also returns information about instances
	// in Auto Scaling groups. To retrieve information about the instances in a warm
	// pool, you must call the DescribeWarmPool API.
	DescribeAutoScalingGroups(ctx context.Context, params *DescribeAutoScalingGroupsInput, optFns ...func(*Options)) (*DescribeAutoScalingGroupsOutput, error)
	// Gets information about the Auto Scaling instances in the account and Region.
	DescribeAutoScalingInstances(ctx context.Context, params *DescribeAutoScalingInstancesInput, optFns ...func(*Options)) (*DescribeAutoScalingInstancesOutput, error)
	// Describes the notification types that are supported by Amazon EC2 Auto Scaling.
	DescribeAutoScalingNotificationTypes(ctx context.Context, params *DescribeAutoScalingNotificationTypesInput, optFns ...func(*Options)) (*DescribeAutoScalingNotificationTypesOutput, error)
	// Gets information about the instance refreshes for the specified Auto Scaling
	// group. This operation is part of the instance refresh feature
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
	// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
	// Scaling group after you make configuration changes. To help you determine the
	// status of an instance refresh, Amazon EC2 Auto Scaling returns information about
	// the instance refreshes you previously initiated, including their status, start
	// time, end time, the percentage of the instance refresh that is complete, and the
	// number of instances remaining to update before the instance refresh is complete.
	// If a rollback is initiated while an instance refresh is in progress, Amazon EC2
	// Auto Scaling also returns information about the rollback of the instance
	// refresh.
	DescribeInstanceRefreshes(ctx context.Context, params *DescribeInstanceRefreshesInput, optFns ...func(*Options)) (*DescribeInstanceRefreshesOutput, error)
	// Gets information about the launch configurations in the account and Region.
	DescribeLaunchConfigurations(ctx context.Context, params *DescribeLaunchConfigurationsInput, optFns ...func(*Options)) (*DescribeLaunchConfigurationsOutput, error)
	// Describes the available types of lifecycle hooks. The following hook types are
	// supported:
	//
	// * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	// *
	// autoscaling:EC2_INSTANCE_TERMINATING
	DescribeLifecycleHookTypes(ctx context.Context, params *DescribeLifecycleHookTypesInput, optFns ...func(*Options)) (*DescribeLifecycleHookTypesOutput, error)
	// Gets information about the lifecycle hooks for the specified Auto Scaling group.
	DescribeLifecycleHooks(ctx context.Context, params *DescribeLifecycleHooksInput, optFns ...func(*Options)) (*DescribeLifecycleHooksOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (DescribeTrafficSources) that can describe multiple traffic sources types. While
	// we continue to support DescribeLoadBalancerTargetGroups, and you can use both
	// the original DescribeLoadBalancerTargetGroups API call and the new
	// DescribeTrafficSources API call on the same Auto Scaling group, we recommend
	// using the new "traffic sources" API call to simplify how you manage traffic
	// sources. Gets information about the Elastic Load Balancing target groups for the
	// specified Auto Scaling group. To determine the attachment status of the target
	// group, use the State element in the response. When you attach a target group to
	// an Auto Scaling group, the initial State value is Adding. The state transitions
	// to Added after all Auto Scaling instances are registered with the target group.
	// If Elastic Load Balancing health checks are enabled for the Auto Scaling group,
	// the state transitions to InService after at least one Auto Scaling instance
	// passes the health check. When the target group is in the InService state, Amazon
	// EC2 Auto Scaling can terminate and replace any instances that are reported as
	// unhealthy. If no registered instances pass the health checks, the target group
	// doesn't enter the InService state. Target groups also have an InService state if
	// you attach them in the CreateAutoScalingGroup API call. If your target group
	// state is InService, but it is not working properly, check the scaling activities
	// by calling DescribeScalingActivities and take any corrective actions necessary.
	// For help with failed health checks, see Troubleshooting Amazon EC2 Auto Scaling:
	// Health checks
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html)
	// in the Amazon EC2 Auto Scaling User Guide. For more information, see Use Elastic
	// Load Balancing to distribute traffic across the instances in your Auto Scaling
	// group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide. You can use this operation to
	// describe target groups that were attached by using
	// AttachLoadBalancerTargetGroups, but not for target groups that were attached by
	// using AttachTrafficSources.
	DescribeLoadBalancerTargetGroups(ctx context.Context, params *DescribeLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*DescribeLoadBalancerTargetGroupsOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (DescribeTrafficSources) that can describe multiple traffic sources types. While
	// we continue to support DescribeLoadBalancers, and you can use both the original
	// DescribeLoadBalancers API call and the new DescribeTrafficSources API call on
	// the same Auto Scaling group, we recommend using the new "traffic sources" API
	// call to simplify how you manage traffic sources. Gets information about the load
	// balancers for the specified Auto Scaling group. This operation describes only
	// Classic Load Balancers. If you have Application Load Balancers, Network Load
	// Balancers, or Gateway Load Balancers, use the DescribeLoadBalancerTargetGroups
	// API instead. To determine the attachment status of the load balancer, use the
	// State element in the response. When you attach a load balancer to an Auto
	// Scaling group, the initial State value is Adding. The state transitions to Added
	// after all Auto Scaling instances are registered with the load balancer. If
	// Elastic Load Balancing health checks are enabled for the Auto Scaling group, the
	// state transitions to InService after at least one Auto Scaling instance passes
	// the health check. When the load balancer is in the InService state, Amazon EC2
	// Auto Scaling can terminate and replace any instances that are reported as
	// unhealthy. If no registered instances pass the health checks, the load balancer
	// doesn't enter the InService state. Load balancers also have an InService state
	// if you attach them in the CreateAutoScalingGroup API call. If your load balancer
	// state is InService, but it is not working properly, check the scaling activities
	// by calling DescribeScalingActivities and take any corrective actions necessary.
	// For help with failed health checks, see Troubleshooting Amazon EC2 Auto Scaling:
	// Health checks
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ts-as-healthchecks.html)
	// in the Amazon EC2 Auto Scaling User Guide. For more information, see Use Elastic
	// Load Balancing to distribute traffic across the instances in your Auto Scaling
	// group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeLoadBalancers(ctx context.Context, params *DescribeLoadBalancersInput, optFns ...func(*Options)) (*DescribeLoadBalancersOutput, error)
	// Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
	DescribeMetricCollectionTypes(ctx context.Context, params *DescribeMetricCollectionTypesInput, optFns ...func(*Options)) (*DescribeMetricCollectionTypesOutput, error)
	// Gets information about the Amazon SNS notifications that are configured for one
	// or more Auto Scaling groups.
	DescribeNotificationConfigurations(ctx context.Context, params *DescribeNotificationConfigurationsInput, optFns ...func(*Options)) (*DescribeNotificationConfigurationsOutput, error)
	// Gets information about the scaling policies in the account and Region.
	DescribePolicies(ctx context.Context, params *DescribePoliciesInput, optFns ...func(*Options)) (*DescribePoliciesOutput, error)
	// Gets information about the scaling activities in the account and Region. When
	// scaling events occur, you see a record of the scaling activity in the scaling
	// activities. For more information, see Verifying a scaling activity for an Auto
	// Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-verify-scaling-activity.html)
	// in the Amazon EC2 Auto Scaling User Guide. If the scaling event succeeds, the
	// value of the StatusCode element in the response is Successful. If an attempt to
	// launch instances failed, the StatusCode value is Failed or Cancelled and the
	// StatusMessage element in the response indicates the cause of the failure. For
	// help interpreting the StatusMessage, see Troubleshooting Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/CHAP_Troubleshooting.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeScalingActivities(ctx context.Context, params *DescribeScalingActivitiesInput, optFns ...func(*Options)) (*DescribeScalingActivitiesOutput, error)
	// Describes the scaling process types for use with the ResumeProcesses and
	// SuspendProcesses APIs.
	DescribeScalingProcessTypes(ctx context.Context, params *DescribeScalingProcessTypesInput, optFns ...func(*Options)) (*DescribeScalingProcessTypesOutput, error)
	// Gets information about the scheduled actions that haven't run or that have not
	// reached their end time. To describe the scaling activities for scheduled actions
	// that have already run, call the DescribeScalingActivities API.
	DescribeScheduledActions(ctx context.Context, params *DescribeScheduledActionsInput, optFns ...func(*Options)) (*DescribeScheduledActionsOutput, error)
	// Describes the specified tags. You can use filters to limit the results. For
	// example, you can query for the tags for a specific Auto Scaling group. You can
	// specify multiple values for a filter. A tag must match at least one of the
	// specified values for it to be included in the results. You can also specify
	// multiple filters. The result includes information for a particular tag only if
	// it matches all the filters. If there's no match, no special message is returned.
	// For more information, see Tag Auto Scaling groups and instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-tagging.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeTags(ctx context.Context, params *DescribeTagsInput, optFns ...func(*Options)) (*DescribeTagsOutput, error)
	// Describes the termination policies supported by Amazon EC2 Auto Scaling. For
	// more information, see Work with Amazon EC2 Auto Scaling termination policies
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-termination-policies.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeTerminationPolicyTypes(ctx context.Context, params *DescribeTerminationPolicyTypesInput, optFns ...func(*Options)) (*DescribeTerminationPolicyTypesOutput, error)
	// Gets information about the traffic sources for the specified Auto Scaling group.
	// You can optionally provide a traffic source type. If you provide a traffic
	// source type, then the results only include that traffic source type. If you do
	// not provide a traffic source type, then the results include all the traffic
	// sources for the specified Auto Scaling group.
	DescribeTrafficSources(ctx context.Context, params *DescribeTrafficSourcesInput, optFns ...func(*Options)) (*DescribeTrafficSourcesOutput, error)
	// Gets information about a warm pool and its instances. For more information, see
	// Warm pools for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DescribeWarmPool(ctx context.Context, params *DescribeWarmPoolInput, optFns ...func(*Options)) (*DescribeWarmPoolOutput, error)
	// Removes one or more instances from the specified Auto Scaling group. After the
	// instances are detached, you can manage them independent of the Auto Scaling
	// group. If you do not specify the option to decrement the desired capacity,
	// Amazon EC2 Auto Scaling launches instances to replace the ones that are
	// detached. If there is a Classic Load Balancer attached to the Auto Scaling
	// group, the instances are deregistered from the load balancer. If there are
	// target groups attached to the Auto Scaling group, the instances are deregistered
	// from the target groups. For more information, see Detach EC2 instances from your
	// Auto Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	DetachInstances(ctx context.Context, params *DetachInstancesInput, optFns ...func(*Options)) (*DetachInstancesOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (DetachTrafficSources) that can detach multiple traffic sources types. While we
	// continue to support DetachLoadBalancerTargetGroups, and you can use both the
	// original DetachLoadBalancerTargetGroups API call and the new
	// DetachTrafficSources API call on the same Auto Scaling group, we recommend using
	// the new "traffic sources" API call to simplify how you manage traffic sources.
	// Detaches one or more target groups from the specified Auto Scaling group. When
	// you detach a target group, it enters the Removing state while deregistering the
	// instances in the group. When all instances are deregistered, then you can no
	// longer describe the target group using the DescribeLoadBalancerTargetGroups API
	// call. The instances remain running. You can use this operation to detach target
	// groups that were attached by using AttachLoadBalancerTargetGroups, but not for
	// target groups that were attached by using AttachTrafficSources.
	DetachLoadBalancerTargetGroups(ctx context.Context, params *DetachLoadBalancerTargetGroupsInput, optFns ...func(*Options)) (*DetachLoadBalancerTargetGroupsOutput, error)
	// This API call has been replaced with a new "traffic sources" API call
	// (DetachTrafficSources) that can detach multiple traffic sources types. While we
	// continue to support DetachLoadBalancers, and you can use both the original
	// DetachLoadBalancers API call and the new DetachTrafficSources API call on the
	// same Auto Scaling group, we recommend using the new "traffic sources" API call
	// to simplify how you manage traffic sources. Detaches one or more Classic Load
	// Balancers from the specified Auto Scaling group. This operation detaches only
	// Classic Load Balancers. If you have Application Load Balancers, Network Load
	// Balancers, or Gateway Load Balancers, use the DetachLoadBalancerTargetGroups API
	// instead. When you detach a load balancer, it enters the Removing state while
	// deregistering the instances in the group. When all instances are deregistered,
	// then you can no longer describe the load balancer using the
	// DescribeLoadBalancers API call. The instances remain running.
	DetachLoadBalancers(ctx context.Context, params *DetachLoadBalancersInput, optFns ...func(*Options)) (*DetachLoadBalancersOutput, error)
	// Detaches one or more traffic sources from the specified Auto Scaling group. When
	// you detach a taffic, it enters the Removing state while deregistering the
	// instances in the group. When all instances are deregistered, then you can no
	// longer describe the traffic source using the DescribeTrafficSources API call.
	// The instances continue to run.
	DetachTrafficSources(ctx context.Context, params *DetachTrafficSourcesInput, optFns ...func(*Options)) (*DetachTrafficSourcesOutput, error)
	// Disables group metrics collection for the specified Auto Scaling group.
	DisableMetricsCollection(ctx context.Context, params *DisableMetricsCollectionInput, optFns ...func(*Options)) (*DisableMetricsCollectionOutput, error)
	// Enables group metrics collection for the specified Auto Scaling group. You can
	// use these metrics to track changes in an Auto Scaling group and to set alarms on
	// threshold values. You can view group metrics using the Amazon EC2 Auto Scaling
	// console or the CloudWatch console. For more information, see Monitor CloudWatch
	// metrics for your Auto Scaling groups and instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-cloudwatch-monitoring.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	EnableMetricsCollection(ctx context.Context, params *EnableMetricsCollectionInput, optFns ...func(*Options)) (*EnableMetricsCollectionOutput, error)
	// Moves the specified instances into the standby state. If you choose to decrement
	// the desired capacity of the Auto Scaling group, the instances can enter standby
	// as long as the desired capacity of the Auto Scaling group after the instances
	// are placed into standby is equal to or greater than the minimum capacity of the
	// group. If you choose not to decrement the desired capacity of the Auto Scaling
	// group, the Auto Scaling group launches new instances to replace the instances on
	// standby. For more information, see Temporarily removing instances from your Auto
	// Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	EnterStandby(ctx context.Context, params *EnterStandbyInput, optFns ...func(*Options)) (*EnterStandbyOutput, error)
	// Executes the specified policy. This can be useful for testing the design of your
	// scaling policy.
	ExecutePolicy(ctx context.Context, params *ExecutePolicyInput, optFns ...func(*Options)) (*ExecutePolicyOutput, error)
	// Moves the specified instances out of the standby state. After you put the
	// instances back in service, the desired capacity is incremented. For more
	// information, see Temporarily removing instances from your Auto Scaling group
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	ExitStandby(ctx context.Context, params *ExitStandbyInput, optFns ...func(*Options)) (*ExitStandbyOutput, error)
	// Retrieves the forecast data for a predictive scaling policy. Load forecasts are
	// predictions of the hourly load values using historical load data from CloudWatch
	// and an analysis of historical trends. Capacity forecasts are represented as
	// predicted values for the minimum capacity that is needed on an hourly basis,
	// based on the hourly load forecast. A minimum of 24 hours of data is required to
	// create the initial forecasts. However, having a full 14 days of historical data
	// results in more accurate forecasts. For more information, see Predictive scaling
	// for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	GetPredictiveScalingForecast(ctx context.Context, params *GetPredictiveScalingForecastInput, optFns ...func(*Options)) (*GetPredictiveScalingForecastOutput, error)
	// Creates or updates a lifecycle hook for the specified Auto Scaling group.
	// Lifecycle hooks let you create solutions that are aware of events in the Auto
	// Scaling instance lifecycle, and then perform a custom action on instances when
	// the corresponding lifecycle event occurs. This step is a part of the procedure
	// for adding a lifecycle hook to an Auto Scaling group:
	//
	// * (Optional) Create a
	// launch template or launch configuration with a user data script that runs while
	// an instance is in a wait state due to a lifecycle hook.
	//
	// * (Optional) Create a
	// Lambda function and a rule that allows Amazon EventBridge to invoke your Lambda
	// function when an instance is put into a wait state due to a lifecycle hook.
	//
	// *
	// (Optional) Create a notification target and an IAM role. The target can be
	// either an Amazon SQS queue or an Amazon SNS topic. The role allows Amazon EC2
	// Auto Scaling to publish lifecycle notifications to the target.
	//
	// * Create the
	// lifecycle hook. Specify whether the hook is used when the instances launch or
	// terminate.
	//
	// * If you need more time, record the lifecycle action heartbeat to
	// keep the instance in a wait state using the RecordLifecycleActionHeartbeat API
	// call.
	//
	// * If you finish before the timeout period ends, send a callback by using
	// the CompleteLifecycleAction API call.
	//
	// For more information, see Amazon EC2 Auto
	// Scaling lifecycle hooks
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in
	// the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of
	// lifecycle hooks, which by default is 50 per Auto Scaling group, the call fails.
	// You can view the lifecycle hooks for an Auto Scaling group using the
	// DescribeLifecycleHooks API call. If you are no longer using a lifecycle hook,
	// you can delete it by calling the DeleteLifecycleHook API.
	PutLifecycleHook(ctx context.Context, params *PutLifecycleHookInput, optFns ...func(*Options)) (*PutLifecycleHookOutput, error)
	// Configures an Auto Scaling group to send notifications when specified events
	// take place. Subscribers to the specified topic can have messages delivered to an
	// endpoint such as a web server or an email address. This configuration overwrites
	// any existing configuration. For more information, see Getting Amazon SNS
	// notifications when your Auto Scaling group scales
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html)
	// in the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of
	// SNS topics, which is 10 per Auto Scaling group, the call fails.
	PutNotificationConfiguration(ctx context.Context, params *PutNotificationConfigurationInput, optFns ...func(*Options)) (*PutNotificationConfigurationOutput, error)
	// Creates or updates a scaling policy for an Auto Scaling group. Scaling policies
	// are used to scale an Auto Scaling group based on configurable metrics. If no
	// policies are defined, the dynamic scaling and predictive scaling features are
	// not used. For more information about using dynamic scaling, see Target tracking
	// scaling policies
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
	// and Step and simple scaling policies
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
	// in the Amazon EC2 Auto Scaling User Guide. For more information about using
	// predictive scaling, see Predictive scaling for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-predictive-scaling.html)
	// in the Amazon EC2 Auto Scaling User Guide. You can view the scaling policies for
	// an Auto Scaling group using the DescribePolicies API call. If you are no longer
	// using a scaling policy, you can delete it by calling the DeletePolicy API.
	PutScalingPolicy(ctx context.Context, params *PutScalingPolicyInput, optFns ...func(*Options)) (*PutScalingPolicyOutput, error)
	// Creates or updates a scheduled scaling action for an Auto Scaling group. For
	// more information, see Scheduled scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html) in
	// the Amazon EC2 Auto Scaling User Guide. You can view the scheduled actions for
	// an Auto Scaling group using the DescribeScheduledActions API call. If you are no
	// longer using a scheduled action, you can delete it by calling the
	// DeleteScheduledAction API. If you try to schedule your action in the past,
	// Amazon EC2 Auto Scaling returns an error message.
	PutScheduledUpdateGroupAction(ctx context.Context, params *PutScheduledUpdateGroupActionInput, optFns ...func(*Options)) (*PutScheduledUpdateGroupActionOutput, error)
	// Creates or updates a warm pool for the specified Auto Scaling group. A warm pool
	// is a pool of pre-initialized EC2 instances that sits alongside the Auto Scaling
	// group. Whenever your application needs to scale out, the Auto Scaling group can
	// draw on the warm pool to meet its new desired capacity. For more information and
	// example configurations, see Warm pools for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-warm-pools.html)
	// in the Amazon EC2 Auto Scaling User Guide. This operation must be called from
	// the Region in which the Auto Scaling group was created. This operation cannot be
	// called on an Auto Scaling group that has a mixed instances policy or a launch
	// template or launch configuration that requests Spot Instances. You can view the
	// instances in the warm pool using the DescribeWarmPool API call. If you are no
	// longer using a warm pool, you can delete it by calling the DeleteWarmPool API.
	PutWarmPool(ctx context.Context, params *PutWarmPoolInput, optFns ...func(*Options)) (*PutWarmPoolOutput, error)
	// Records a heartbeat for the lifecycle action associated with the specified token
	// or instance. This extends the timeout by the length of time defined using the
	// PutLifecycleHook API call. This step is a part of the procedure for adding a
	// lifecycle hook to an Auto Scaling group:
	//
	// * (Optional) Create a launch template
	// or launch configuration with a user data script that runs while an instance is
	// in a wait state due to a lifecycle hook.
	//
	// * (Optional) Create a Lambda function
	// and a rule that allows Amazon EventBridge to invoke your Lambda function when an
	// instance is put into a wait state due to a lifecycle hook.
	//
	// * (Optional) Create
	// a notification target and an IAM role. The target can be either an Amazon SQS
	// queue or an Amazon SNS topic. The role allows Amazon EC2 Auto Scaling to publish
	// lifecycle notifications to the target.
	//
	// * Create the lifecycle hook. Specify
	// whether the hook is used when the instances launch or terminate.
	//
	// * If you need
	// more time, record the lifecycle action heartbeat to keep the instance in a wait
	// state.
	//
	// * If you finish before the timeout period ends, send a callback by using
	// the CompleteLifecycleAction API call.
	//
	// For more information, see Amazon EC2 Auto
	// Scaling lifecycle hooks
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in
	// the Amazon EC2 Auto Scaling User Guide.
	RecordLifecycleActionHeartbeat(ctx context.Context, params *RecordLifecycleActionHeartbeatInput, optFns ...func(*Options)) (*RecordLifecycleActionHeartbeatOutput, error)
	// Resumes the specified suspended auto scaling processes, or all suspended
	// process, for the specified Auto Scaling group. For more information, see
	// Suspending and resuming scaling processes
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	ResumeProcesses(ctx context.Context, params *ResumeProcessesInput, optFns ...func(*Options)) (*ResumeProcessesOutput, error)
	// Cancels an instance refresh that is in progress and rolls back any changes that
	// it made. Amazon EC2 Auto Scaling replaces any instances that were replaced
	// during the instance refresh. This restores your Auto Scaling group to the
	// configuration that it was using before the start of the instance refresh. This
	// operation is part of the instance refresh feature
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
	// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
	// Scaling group after you make configuration changes. A rollback is not supported
	// in the following situations:
	//
	// * There is no desired configuration specified for
	// the instance refresh.
	//
	// * The Auto Scaling group has a launch template that uses
	// an Amazon Web Services Systems Manager parameter instead of an AMI ID for the
	// ImageId property.
	//
	// * The Auto Scaling group uses the launch template's $Latest
	// or $Default version.
	//
	// When you receive a successful response from this
	// operation, Amazon EC2 Auto Scaling immediately begins replacing instances. You
	// can check the status of this operation through the DescribeInstanceRefreshes API
	// operation.
	RollbackInstanceRefresh(ctx context.Context, params *RollbackInstanceRefreshInput, optFns ...func(*Options)) (*RollbackInstanceRefreshOutput, error)
	// Sets the size of the specified Auto Scaling group. If a scale-in activity occurs
	// as a result of a new DesiredCapacity value that is lower than the current size
	// of the group, the Auto Scaling group uses its termination policy to determine
	// which instances to terminate. For more information, see Manual scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	SetDesiredCapacity(ctx context.Context, params *SetDesiredCapacityInput, optFns ...func(*Options)) (*SetDesiredCapacityOutput, error)
	// Sets the health status of the specified instance. For more information, see
	// Health checks for Auto Scaling instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html) in the
	// Amazon EC2 Auto Scaling User Guide.
	SetInstanceHealth(ctx context.Context, params *SetInstanceHealthInput, optFns ...func(*Options)) (*SetInstanceHealthOutput, error)
	// Updates the instance protection settings of the specified instances. This
	// operation cannot be called on instances in a warm pool. For more information
	// about preventing instances that are part of an Auto Scaling group from
	// terminating on scale in, see Using instance scale-in protection
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-instance-protection.html)
	// in the Amazon EC2 Auto Scaling User Guide. If you exceed your maximum limit of
	// instance IDs, which is 50 per Auto Scaling group, the call fails.
	SetInstanceProtection(ctx context.Context, params *SetInstanceProtectionInput, optFns ...func(*Options)) (*SetInstanceProtectionOutput, error)
	// Starts an instance refresh. During an instance refresh, Amazon EC2 Auto Scaling
	// performs a rolling update of instances in an Auto Scaling group. Instances are
	// terminated first and then replaced, which temporarily reduces the capacity
	// available within your Auto Scaling group. This operation is part of the instance
	// refresh feature
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html)
	// in Amazon EC2 Auto Scaling, which helps you update instances in your Auto
	// Scaling group. This feature is helpful, for example, when you have a new AMI or
	// a new user data script. You just need to create a new launch template that
	// specifies the new AMI or user data script. Then start an instance refresh to
	// immediately begin the process of updating instances in the group. If successful,
	// the request's response contains a unique ID that you can use to track the
	// progress of the instance refresh. To query its status, call the
	// DescribeInstanceRefreshes API. To describe the instance refreshes that have
	// already run, call the DescribeInstanceRefreshes API. To cancel an instance
	// refresh that is in progress, use the CancelInstanceRefresh API. An instance
	// refresh might fail for several reasons, such as EC2 launch failures,
	// misconfigured health checks, or not ignoring or allowing the termination of
	// instances that are in Standby state or protected from scale in. You can monitor
	// for failed EC2 launches using the scaling activities. To find the scaling
	// activities, call the DescribeScalingActivities API. If you enable auto rollback,
	// your Auto Scaling group will be rolled back automatically when the instance
	// refresh fails. You can enable this feature before starting an instance refresh
	// by specifying the AutoRollback property in the instance refresh preferences.
	// Otherwise, to roll back an instance refresh before it finishes, use the
	// RollbackInstanceRefresh API.
	StartInstanceRefresh(ctx context.Context, params *StartInstanceRefreshInput, optFns ...func(*Options)) (*StartInstanceRefreshOutput, error)
	// Suspends the specified auto scaling processes, or all processes, for the
	// specified Auto Scaling group. If you suspend either the Launch or Terminate
	// process types, it can prevent other process types from functioning properly. For
	// more information, see Suspending and resuming scaling processes
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
	// in the Amazon EC2 Auto Scaling User Guide. To resume processes that have been
	// suspended, call the ResumeProcesses API.
	SuspendProcesses(ctx context.Context, params *SuspendProcessesInput, optFns ...func(*Options)) (*SuspendProcessesOutput, error)
	// Terminates the specified instance and optionally adjusts the desired group size.
	// This operation cannot be called on instances in a warm pool. This call simply
	// makes a termination request. The instance is not terminated immediately. When an
	// instance is terminated, the instance status changes to terminated. You can't
	// connect to or start an instance after you've terminated it. If you do not
	// specify the option to decrement the desired capacity, Amazon EC2 Auto Scaling
	// launches instances to replace the ones that are terminated. By default, Amazon
	// EC2 Auto Scaling balances instances across all Availability Zones. If you
	// decrement the desired capacity, your Auto Scaling group can become unbalanced
	// between Availability Zones. Amazon EC2 Auto Scaling tries to rebalance the
	// group, and rebalancing might terminate instances in other zones. For more
	// information, see Rebalancing activities
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage)
	// in the Amazon EC2 Auto Scaling User Guide.
	TerminateInstanceInAutoScalingGroup(ctx context.Context, params *TerminateInstanceInAutoScalingGroupInput, optFns ...func(*Options)) (*TerminateInstanceInAutoScalingGroupOutput, error)
	// We strongly recommend that all Auto Scaling groups use launch templates to
	// ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2. Updates
	// the configuration for the specified Auto Scaling group. To update an Auto
	// Scaling group, specify the name of the group and the property that you want to
	// change. Any properties that you don't specify are not changed by this update
	// request. The new settings take effect on any scaling activities after this call
	// returns. If you associate a new launch configuration or template with an Auto
	// Scaling group, all new instances will get the updated configuration. Existing
	// instances continue to run with the configuration that they were originally
	// launched with. When you update a group to specify a mixed instances policy
	// instead of a launch configuration or template, existing instances may be
	// replaced to match the new purchasing options that you specified in the policy.
	// For example, if the group currently has 100% On-Demand capacity and the policy
	// specifies 50% Spot capacity, this means that half of your instances will be
	// gradually terminated and relaunched as Spot Instances. When replacing instances,
	// Amazon EC2 Auto Scaling launches new instances before terminating the old ones,
	// so that updating your group does not compromise the performance or availability
	// of your application. Note the following about changing DesiredCapacity, MaxSize,
	// or MinSize:
	//
	// * If a scale-in activity occurs as a result of a new
	// DesiredCapacity value that is lower than the current size of the group, the Auto
	// Scaling group uses its termination policy to determine which instances to
	// terminate.
	//
	// * If you specify a new value for MinSize without specifying a value
	// for DesiredCapacity, and the new MinSize is larger than the current size of the
	// group, this sets the group's DesiredCapacity to the new MinSize value.
	//
	// * If you
	// specify a new value for MaxSize without specifying a value for DesiredCapacity,
	// and the new MaxSize is smaller than the current size of the group, this sets the
	// group's DesiredCapacity to the new MaxSize value.
	//
	// To see which properties have
	// been set, call the DescribeAutoScalingGroups API. To view the scaling policies
	// for an Auto Scaling group, call the DescribePolicies API. If the group has
	// scaling policies, you can update them by calling the PutScalingPolicy API.
	UpdateAutoScalingGroup(ctx context.Context, params *UpdateAutoScalingGroupInput, optFns ...func(*Options)) (*UpdateAutoScalingGroupOutput, error)
}

