// GENERATED, DO NOT EDIT THIS FILE
package aws

import "github.com/zclconf/go-cty/cty"

const AwsDbInstanceResourceType = "aws_db_instance"

type AwsDbInstance struct {
	Address                            *string            `cty:"address" computed:"true"`
	AllocatedStorage                   *int               `cty:"allocated_storage" computed:"true"`
	AllowMajorVersionUpgrade           *bool              `cty:"allow_major_version_upgrade"`
	ApplyImmediately                   *bool              `cty:"apply_immediately" computed:"true"`
	Arn                                *string            `cty:"arn" computed:"true"`
	AutoMinorVersionUpgrade            *bool              `cty:"auto_minor_version_upgrade"`
	AvailabilityZone                   *string            `cty:"availability_zone" computed:"true"`
	BackupRetentionPeriod              *int               `cty:"backup_retention_period" computed:"true"`
	BackupWindow                       *string            `cty:"backup_window" computed:"true"`
	CaCertIdentifier                   *string            `cty:"ca_cert_identifier" computed:"true"`
	CharacterSetName                   *string            `cty:"character_set_name" computed:"true"`
	CopyTagsToSnapshot                 *bool              `cty:"copy_tags_to_snapshot"`
	DbSubnetGroupName                  *string            `cty:"db_subnet_group_name" computed:"true"`
	DeleteAutomatedBackups             *bool              `cty:"delete_automated_backups" diff:"-"`
	DeletionProtection                 *bool              `cty:"deletion_protection"`
	Domain                             *string            `cty:"domain"`
	DomainIamRoleName                  *string            `cty:"domain_iam_role_name"`
	EnabledCloudwatchLogsExports       *[]string          `cty:"enabled_cloudwatch_logs_exports"`
	Endpoint                           *string            `cty:"endpoint" computed:"true"`
	Engine                             *string            `cty:"engine" computed:"true"`
	EngineVersion                      *string            `cty:"engine_version" computed:"true"`
	FinalSnapshotIdentifier            *string            `cty:"final_snapshot_identifier" diff:"-"`
	HostedZoneId                       *string            `cty:"hosted_zone_id" computed:"true"`
	IamDatabaseAuthenticationEnabled   *bool              `cty:"iam_database_authentication_enabled"`
	Id                                 string             `cty:"id" computed:"true"`
	Identifier                         *string            `cty:"identifier" computed:"true"`
	IdentifierPrefix                   *string            `cty:"identifier_prefix" computed:"true"`
	InstanceClass                      *string            `cty:"instance_class"`
	Iops                               *int               `cty:"iops"`
	KmsKeyId                           *string            `cty:"kms_key_id" computed:"true"`
	LatestRestorableTime               *string            `cty:"latest_restorable_time" computed:"true" diff:"-"`
	LicenseModel                       *string            `cty:"license_model" computed:"true"`
	MaintenanceWindow                  *string            `cty:"maintenance_window" computed:"true"`
	MaxAllocatedStorage                *int               `cty:"max_allocated_storage"`
	MonitoringInterval                 *int               `cty:"monitoring_interval"`
	MonitoringRoleArn                  *string            `cty:"monitoring_role_arn" computed:"true"`
	MultiAz                            *bool              `cty:"multi_az" computed:"true"`
	Name                               *string            `cty:"name" computed:"true"`
	OptionGroupName                    *string            `cty:"option_group_name" computed:"true"`
	ParameterGroupName                 *string            `cty:"parameter_group_name" computed:"true"`
	Password                           *string            `cty:"password" diff:"-"`
	PerformanceInsightsEnabled         *bool              `cty:"performance_insights_enabled"`
	PerformanceInsightsKmsKeyId        *string            `cty:"performance_insights_kms_key_id" computed:"true"`
	PerformanceInsightsRetentionPeriod *int               `cty:"performance_insights_retention_period" computed:"true"`
	Port                               *int               `cty:"port" computed:"true"`
	PubliclyAccessible                 *bool              `cty:"publicly_accessible"`
	Replicas                           []string           `cty:"replicas" computed:"true"`
	ReplicateSourceDb                  *string            `cty:"replicate_source_db"`
	ResourceId                         *string            `cty:"resource_id" computed:"true"`
	SecurityGroupNames                 *[]string          `cty:"security_group_names"`
	SkipFinalSnapshot                  *bool              `cty:"skip_final_snapshot" diff:"-"`
	SnapshotIdentifier                 *string            `cty:"snapshot_identifier"`
	Status                             *string            `cty:"status" computed:"true"`
	StorageEncrypted                   *bool              `cty:"storage_encrypted"`
	StorageType                        *string            `cty:"storage_type" computed:"true"`
	Tags                               *map[string]string `cty:"tags"`
	Timezone                           *string            `cty:"timezone" computed:"true"`
	Username                           *string            `cty:"username" computed:"true"`
	VpcSecurityGroupIds                []string           `cty:"vpc_security_group_ids" computed:"true"`
	RestoreToPointInTime               *[]struct {
		RestoreTime                *string `cty:"restore_time"`
		SourceDbInstanceIdentifier *string `cty:"source_db_instance_identifier"`
		SourceDbiResourceId        *string `cty:"source_dbi_resource_id"`
		UseLatestRestorableTime    *bool   `cty:"use_latest_restorable_time"`
	} `cty:"restore_to_point_in_time"`
	S3Import *[]struct {
		BucketName          *string `cty:"bucket_name"`
		BucketPrefix        *string `cty:"bucket_prefix"`
		IngestionRole       *string `cty:"ingestion_role"`
		SourceEngine        *string `cty:"source_engine"`
		SourceEngineVersion *string `cty:"source_engine_version"`
	} `cty:"s3_import" diff:"-"`
	Timeouts *struct {
		Create *string `cty:"create"`
		Delete *string `cty:"delete"`
		Update *string `cty:"update"`
	} `cty:"timeouts" diff:"-"`
	CtyVal *cty.Value `diff:"-"`
}

func (r *AwsDbInstance) TerraformId() string {
	return r.Id
}

func (r *AwsDbInstance) TerraformType() string {
	return AwsDbInstanceResourceType
}

func (r *AwsDbInstance) CtyValue() *cty.Value {
	return r.CtyVal
}
