// Copyright 2024 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package schema

import (
	"github.com/dolthub/go-mysql-server/sql"
	"github.com/dolthub/go-mysql-server/sql/types"

	stypes "github.com/dolthub/dolt/go/store/types"
)

const StatsVersion int64 = 1

const (
	StatsQualifierColName     = "qualifier"
	StatsDbColName            = "database_name"
	StatsTableColName         = "table_name"
	StatsIndexColName         = "index_name"
	StatsPositionColName      = "position"
	StatsCommitHashColName    = "commit_hash"
	StatsRowCountColName      = "row_count"
	StatsDistinctCountColName = "distinct_count"
	StatsNullCountColName     = "null_count"
	StatsColumnsColName       = "columns"
	StatsTypesColName         = "types"
	StatsUpperBoundColName    = "upper_bound"
	StatsUpperBoundCntColName = "upper_bound_cnt"
	StatsCreatedAtColName     = "created_at"
	StatsMcv1ColName          = "mcv1"
	StatsMcv2ColName          = "mcv2"
	StatsMcv3ColName          = "mcv3"
	StatsMcv4ColName          = "mcv4"
	StatsMcvCountsColName     = "mcvCounts"
	StatsVersionColName       = "version"
)

const (
	StatsDbTag uint64 = iota
	StatsTableTag
	StatsIndexTag
	StatsPositionTag
	StatsVersionTag
	StatsCommitHashTag
	StatsRowCountTag
	StatsDistinctCountTag
	StatsNullCountTag
	StatsColumnsTag
	StatsTypesTag
	StatsUpperBoundTag
	StatsUpperBoundCntTag
	StatsCreatedAtTag
	StatsMcv1Tag
	StatsMcv2Tag
	StatsMcv3Tag
	StatsMcv4Tag
	StatsMcvCountsTag
)

var StatsTableSqlSchema = sql.PrimaryKeySchema{
	Schema: sql.Schema{
		&sql.Column{Name: StatsDbColName, Type: types.Text, PrimaryKey: true},
		&sql.Column{Name: StatsTableColName, Type: types.Text, PrimaryKey: true},
		&sql.Column{Name: StatsIndexColName, Type: types.Text, PrimaryKey: true},
		&sql.Column{Name: StatsPositionColName, Type: types.Int64, PrimaryKey: true},
		&sql.Column{Name: StatsVersionColName, Type: types.Int64},
		&sql.Column{Name: StatsCommitHashColName, Type: types.Text},
		&sql.Column{Name: StatsRowCountColName, Type: types.Int64},
		&sql.Column{Name: StatsDistinctCountColName, Type: types.Int64},
		&sql.Column{Name: StatsNullCountColName, Type: types.Int64},
		&sql.Column{Name: StatsColumnsColName, Type: types.Text},
		&sql.Column{Name: StatsTypesColName, Type: types.Text},
		&sql.Column{Name: StatsUpperBoundColName, Type: types.Text},
		&sql.Column{Name: StatsUpperBoundCntColName, Type: types.Int64},
		&sql.Column{Name: StatsCreatedAtColName, Type: types.Datetime},
		&sql.Column{Name: StatsMcv1ColName, Type: types.Text},
		&sql.Column{Name: StatsMcv2ColName, Type: types.Text},
		&sql.Column{Name: StatsMcv3ColName, Type: types.Text},
		&sql.Column{Name: StatsMcv4ColName, Type: types.Text},
		&sql.Column{Name: StatsMcvCountsColName, Type: types.Text},
	},
	PkOrdinals: []int{0, 1},
}

var StatsTableDoltSchema = StatsTableDoltSchemaGen()

func StatsTableDoltSchemaGen() Schema {
	colColl := NewColCollection(
		NewColumn(StatsDbColName, StatsDbTag, stypes.StringKind, true, NotNullConstraint{}),
		NewColumn(StatsTableColName, StatsTableTag, stypes.StringKind, true, NotNullConstraint{}),
		NewColumn(StatsIndexColName, StatsIndexTag, stypes.StringKind, true, NotNullConstraint{}),
		NewColumn(StatsPositionColName, StatsPositionTag, stypes.IntKind, true, NotNullConstraint{}),
		NewColumn(StatsVersionColName, StatsVersionTag, stypes.IntKind, false, NotNullConstraint{}),
		NewColumn(StatsCommitHashColName, StatsCommitHashTag, stypes.StringKind, false, NotNullConstraint{}),
		NewColumn(StatsRowCountColName, StatsRowCountTag, stypes.IntKind, false, NotNullConstraint{}),
		NewColumn(StatsDistinctCountColName, StatsDistinctCountTag, stypes.IntKind, false, NotNullConstraint{}),
		NewColumn(StatsNullCountColName, StatsNullCountTag, stypes.IntKind, false, NotNullConstraint{}),
		NewColumn(StatsColumnsColName, StatsColumnsTag, stypes.StringKind, false, NotNullConstraint{}),
		NewColumn(StatsTypesColName, StatsTypesTag, stypes.StringKind, false, NotNullConstraint{}),
		NewColumn(StatsUpperBoundColName, StatsUpperBoundTag, stypes.StringKind, false, NotNullConstraint{}),
		NewColumn(StatsUpperBoundCntColName, StatsUpperBoundCntTag, stypes.IntKind, false, NotNullConstraint{}),
		NewColumn(StatsCreatedAtColName, StatsCreatedAtTag, stypes.TimestampKind, false, NotNullConstraint{}),
		NewColumn(StatsMcv1ColName, StatsMcv1Tag, stypes.StringKind, false),
		NewColumn(StatsMcv2ColName, StatsMcv2Tag, stypes.StringKind, false),
		NewColumn(StatsMcv3ColName, StatsMcv3Tag, stypes.StringKind, false),
		NewColumn(StatsMcv4ColName, StatsMcv4Tag, stypes.StringKind, false),
		NewColumn(StatsMcvCountsColName, StatsMcvCountsTag, stypes.StringKind, false, NotNullConstraint{}),
	)
	return MustSchemaFromCols(colColl)
}
