// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package cluster

import (
	"github.com/dolthub/go-mysql-server/sql"
)

func newAssumeRoleProcedure(controller *Controller) sql.ExternalStoredProcedureDetails {
	return sql.ExternalStoredProcedureDetails{
		Name: "dolt_assume_cluster_role",
		Schema: sql.Schema{
			&sql.Column{
				Name:     "status",
				Type:     sql.Int64,
				Nullable: false,
			},
		},
		Function: func(ctx *sql.Context, role string, epoch int) (sql.RowIter, error) {
			err := controller.setRoleAndEpoch(role, epoch)
			if err != nil {
				return nil, err
			}
			return sql.RowsToRowIter(sql.Row{0}), nil
		},
	}
}
