// Copyright 2022 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package schema

import "github.com/dolthub/dolt/go/gen/fb/serial"

// Collation represents the collation of a string.
type Collation uint16

const (
	Collation_big5_chinese_ci             = Collation(serial.Collationbig5_chinese_ci)
	Collation_latin2_czech_cs             = Collation(serial.Collationlatin2_czech_cs)
	Collation_dec8_swedish_ci             = Collation(serial.Collationdec8_swedish_ci)
	Collation_cp850_general_ci            = Collation(serial.Collationcp850_general_ci)
	Collation_latin1_german1_ci           = Collation(serial.Collationlatin1_german1_ci)
	Collation_hp8_english_ci              = Collation(serial.Collationhp8_english_ci)
	Collation_koi8r_general_ci            = Collation(serial.Collationkoi8r_general_ci)
	Collation_latin1_swedish_ci           = Collation(serial.Collationlatin1_swedish_ci)
	Collation_latin2_general_ci           = Collation(serial.Collationlatin2_general_ci)
	Collation_swe7_swedish_ci             = Collation(serial.Collationswe7_swedish_ci)
	Collation_ascii_general_ci            = Collation(serial.Collationascii_general_ci)
	Collation_ujis_japanese_ci            = Collation(serial.Collationujis_japanese_ci)
	Collation_sjis_japanese_ci            = Collation(serial.Collationsjis_japanese_ci)
	Collation_cp1251_bulgarian_ci         = Collation(serial.Collationcp1251_bulgarian_ci)
	Collation_latin1_danish_ci            = Collation(serial.Collationlatin1_danish_ci)
	Collation_hebrew_general_ci           = Collation(serial.Collationhebrew_general_ci)
	Collation_tis620_thai_ci              = Collation(serial.Collationtis620_thai_ci)
	Collation_euckr_korean_ci             = Collation(serial.Collationeuckr_korean_ci)
	Collation_latin7_estonian_cs          = Collation(serial.Collationlatin7_estonian_cs)
	Collation_latin2_hungarian_ci         = Collation(serial.Collationlatin2_hungarian_ci)
	Collation_koi8u_general_ci            = Collation(serial.Collationkoi8u_general_ci)
	Collation_cp1251_ukrainian_ci         = Collation(serial.Collationcp1251_ukrainian_ci)
	Collation_gb2312_chinese_ci           = Collation(serial.Collationgb2312_chinese_ci)
	Collation_greek_general_ci            = Collation(serial.Collationgreek_general_ci)
	Collation_cp1250_general_ci           = Collation(serial.Collationcp1250_general_ci)
	Collation_latin2_croatian_ci          = Collation(serial.Collationlatin2_croatian_ci)
	Collation_gbk_chinese_ci              = Collation(serial.Collationgbk_chinese_ci)
	Collation_cp1257_lithuanian_ci        = Collation(serial.Collationcp1257_lithuanian_ci)
	Collation_latin5_turkish_ci           = Collation(serial.Collationlatin5_turkish_ci)
	Collation_latin1_german2_ci           = Collation(serial.Collationlatin1_german2_ci)
	Collation_armscii8_general_ci         = Collation(serial.Collationarmscii8_general_ci)
	Collation_utf8mb3_general_ci          = Collation(serial.Collationutf8mb3_general_ci)
	Collation_cp1250_czech_cs             = Collation(serial.Collationcp1250_czech_cs)
	Collation_ucs2_general_ci             = Collation(serial.Collationucs2_general_ci)
	Collation_cp866_general_ci            = Collation(serial.Collationcp866_general_ci)
	Collation_keybcs2_general_ci          = Collation(serial.Collationkeybcs2_general_ci)
	Collation_macce_general_ci            = Collation(serial.Collationmacce_general_ci)
	Collation_macroman_general_ci         = Collation(serial.Collationmacroman_general_ci)
	Collation_cp852_general_ci            = Collation(serial.Collationcp852_general_ci)
	Collation_latin7_general_ci           = Collation(serial.Collationlatin7_general_ci)
	Collation_latin7_general_cs           = Collation(serial.Collationlatin7_general_cs)
	Collation_macce_bin                   = Collation(serial.Collationmacce_bin)
	Collation_cp1250_croatian_ci          = Collation(serial.Collationcp1250_croatian_ci)
	Collation_utf8mb4_general_ci          = Collation(serial.Collationutf8mb4_general_ci)
	Collation_utf8mb4_bin                 = Collation(serial.Collationutf8mb4_bin)
	Collation_latin1_bin                  = Collation(serial.Collationlatin1_bin)
	Collation_latin1_general_ci           = Collation(serial.Collationlatin1_general_ci)
	Collation_latin1_general_cs           = Collation(serial.Collationlatin1_general_cs)
	Collation_cp1251_bin                  = Collation(serial.Collationcp1251_bin)
	Collation_cp1251_general_ci           = Collation(serial.Collationcp1251_general_ci)
	Collation_cp1251_general_cs           = Collation(serial.Collationcp1251_general_cs)
	Collation_macroman_bin                = Collation(serial.Collationmacroman_bin)
	Collation_utf16_general_ci            = Collation(serial.Collationutf16_general_ci)
	Collation_utf16_bin                   = Collation(serial.Collationutf16_bin)
	Collation_utf16le_general_ci          = Collation(serial.Collationutf16le_general_ci)
	Collation_cp1256_general_ci           = Collation(serial.Collationcp1256_general_ci)
	Collation_cp1257_bin                  = Collation(serial.Collationcp1257_bin)
	Collation_cp1257_general_ci           = Collation(serial.Collationcp1257_general_ci)
	Collation_utf32_general_ci            = Collation(serial.Collationutf32_general_ci)
	Collation_utf32_bin                   = Collation(serial.Collationutf32_bin)
	Collation_utf16le_bin                 = Collation(serial.Collationutf16le_bin)
	Collation_binary                      = Collation(serial.Collationbinary)
	Collation_armscii8_bin                = Collation(serial.Collationarmscii8_bin)
	Collation_ascii_bin                   = Collation(serial.Collationascii_bin)
	Collation_cp1250_bin                  = Collation(serial.Collationcp1250_bin)
	Collation_cp1256_bin                  = Collation(serial.Collationcp1256_bin)
	Collation_cp866_bin                   = Collation(serial.Collationcp866_bin)
	Collation_dec8_bin                    = Collation(serial.Collationdec8_bin)
	Collation_greek_bin                   = Collation(serial.Collationgreek_bin)
	Collation_hebrew_bin                  = Collation(serial.Collationhebrew_bin)
	Collation_hp8_bin                     = Collation(serial.Collationhp8_bin)
	Collation_keybcs2_bin                 = Collation(serial.Collationkeybcs2_bin)
	Collation_koi8r_bin                   = Collation(serial.Collationkoi8r_bin)
	Collation_koi8u_bin                   = Collation(serial.Collationkoi8u_bin)
	Collation_utf8mb3_tolower_ci          = Collation(serial.Collationutf8mb3_tolower_ci)
	Collation_latin2_bin                  = Collation(serial.Collationlatin2_bin)
	Collation_latin5_bin                  = Collation(serial.Collationlatin5_bin)
	Collation_latin7_bin                  = Collation(serial.Collationlatin7_bin)
	Collation_cp850_bin                   = Collation(serial.Collationcp850_bin)
	Collation_cp852_bin                   = Collation(serial.Collationcp852_bin)
	Collation_swe7_bin                    = Collation(serial.Collationswe7_bin)
	Collation_utf8mb3_bin                 = Collation(serial.Collationutf8mb3_bin)
	Collation_big5_bin                    = Collation(serial.Collationbig5_bin)
	Collation_euckr_bin                   = Collation(serial.Collationeuckr_bin)
	Collation_gb2312_bin                  = Collation(serial.Collationgb2312_bin)
	Collation_gbk_bin                     = Collation(serial.Collationgbk_bin)
	Collation_sjis_bin                    = Collation(serial.Collationsjis_bin)
	Collation_tis620_bin                  = Collation(serial.Collationtis620_bin)
	Collation_ucs2_bin                    = Collation(serial.Collationucs2_bin)
	Collation_ujis_bin                    = Collation(serial.Collationujis_bin)
	Collation_geostd8_general_ci          = Collation(serial.Collationgeostd8_general_ci)
	Collation_geostd8_bin                 = Collation(serial.Collationgeostd8_bin)
	Collation_latin1_spanish_ci           = Collation(serial.Collationlatin1_spanish_ci)
	Collation_cp932_japanese_ci           = Collation(serial.Collationcp932_japanese_ci)
	Collation_cp932_bin                   = Collation(serial.Collationcp932_bin)
	Collation_eucjpms_japanese_ci         = Collation(serial.Collationeucjpms_japanese_ci)
	Collation_eucjpms_bin                 = Collation(serial.Collationeucjpms_bin)
	Collation_cp1250_polish_ci            = Collation(serial.Collationcp1250_polish_ci)
	Collation_utf16_unicode_ci            = Collation(serial.Collationutf16_unicode_ci)
	Collation_utf16_icelandic_ci          = Collation(serial.Collationutf16_icelandic_ci)
	Collation_utf16_latvian_ci            = Collation(serial.Collationutf16_latvian_ci)
	Collation_utf16_romanian_ci           = Collation(serial.Collationutf16_romanian_ci)
	Collation_utf16_slovenian_ci          = Collation(serial.Collationutf16_slovenian_ci)
	Collation_utf16_polish_ci             = Collation(serial.Collationutf16_polish_ci)
	Collation_utf16_estonian_ci           = Collation(serial.Collationutf16_estonian_ci)
	Collation_utf16_spanish_ci            = Collation(serial.Collationutf16_spanish_ci)
	Collation_utf16_swedish_ci            = Collation(serial.Collationutf16_swedish_ci)
	Collation_utf16_turkish_ci            = Collation(serial.Collationutf16_turkish_ci)
	Collation_utf16_czech_ci              = Collation(serial.Collationutf16_czech_ci)
	Collation_utf16_danish_ci             = Collation(serial.Collationutf16_danish_ci)
	Collation_utf16_lithuanian_ci         = Collation(serial.Collationutf16_lithuanian_ci)
	Collation_utf16_slovak_ci             = Collation(serial.Collationutf16_slovak_ci)
	Collation_utf16_spanish2_ci           = Collation(serial.Collationutf16_spanish2_ci)
	Collation_utf16_roman_ci              = Collation(serial.Collationutf16_roman_ci)
	Collation_utf16_persian_ci            = Collation(serial.Collationutf16_persian_ci)
	Collation_utf16_esperanto_ci          = Collation(serial.Collationutf16_esperanto_ci)
	Collation_utf16_hungarian_ci          = Collation(serial.Collationutf16_hungarian_ci)
	Collation_utf16_sinhala_ci            = Collation(serial.Collationutf16_sinhala_ci)
	Collation_utf16_german2_ci            = Collation(serial.Collationutf16_german2_ci)
	Collation_utf16_croatian_ci           = Collation(serial.Collationutf16_croatian_ci)
	Collation_utf16_unicode_520_ci        = Collation(serial.Collationutf16_unicode_520_ci)
	Collation_utf16_vietnamese_ci         = Collation(serial.Collationutf16_vietnamese_ci)
	Collation_ucs2_unicode_ci             = Collation(serial.Collationucs2_unicode_ci)
	Collation_ucs2_icelandic_ci           = Collation(serial.Collationucs2_icelandic_ci)
	Collation_ucs2_latvian_ci             = Collation(serial.Collationucs2_latvian_ci)
	Collation_ucs2_romanian_ci            = Collation(serial.Collationucs2_romanian_ci)
	Collation_ucs2_slovenian_ci           = Collation(serial.Collationucs2_slovenian_ci)
	Collation_ucs2_polish_ci              = Collation(serial.Collationucs2_polish_ci)
	Collation_ucs2_estonian_ci            = Collation(serial.Collationucs2_estonian_ci)
	Collation_ucs2_spanish_ci             = Collation(serial.Collationucs2_spanish_ci)
	Collation_ucs2_swedish_ci             = Collation(serial.Collationucs2_swedish_ci)
	Collation_ucs2_turkish_ci             = Collation(serial.Collationucs2_turkish_ci)
	Collation_ucs2_czech_ci               = Collation(serial.Collationucs2_czech_ci)
	Collation_ucs2_danish_ci              = Collation(serial.Collationucs2_danish_ci)
	Collation_ucs2_lithuanian_ci          = Collation(serial.Collationucs2_lithuanian_ci)
	Collation_ucs2_slovak_ci              = Collation(serial.Collationucs2_slovak_ci)
	Collation_ucs2_spanish2_ci            = Collation(serial.Collationucs2_spanish2_ci)
	Collation_ucs2_roman_ci               = Collation(serial.Collationucs2_roman_ci)
	Collation_ucs2_persian_ci             = Collation(serial.Collationucs2_persian_ci)
	Collation_ucs2_esperanto_ci           = Collation(serial.Collationucs2_esperanto_ci)
	Collation_ucs2_hungarian_ci           = Collation(serial.Collationucs2_hungarian_ci)
	Collation_ucs2_sinhala_ci             = Collation(serial.Collationucs2_sinhala_ci)
	Collation_ucs2_german2_ci             = Collation(serial.Collationucs2_german2_ci)
	Collation_ucs2_croatian_ci            = Collation(serial.Collationucs2_croatian_ci)
	Collation_ucs2_unicode_520_ci         = Collation(serial.Collationucs2_unicode_520_ci)
	Collation_ucs2_vietnamese_ci          = Collation(serial.Collationucs2_vietnamese_ci)
	Collation_ucs2_general_mysql500_ci    = Collation(serial.Collationucs2_general_mysql500_ci)
	Collation_utf32_unicode_ci            = Collation(serial.Collationutf32_unicode_ci)
	Collation_utf32_icelandic_ci          = Collation(serial.Collationutf32_icelandic_ci)
	Collation_utf32_latvian_ci            = Collation(serial.Collationutf32_latvian_ci)
	Collation_utf32_romanian_ci           = Collation(serial.Collationutf32_romanian_ci)
	Collation_utf32_slovenian_ci          = Collation(serial.Collationutf32_slovenian_ci)
	Collation_utf32_polish_ci             = Collation(serial.Collationutf32_polish_ci)
	Collation_utf32_estonian_ci           = Collation(serial.Collationutf32_estonian_ci)
	Collation_utf32_spanish_ci            = Collation(serial.Collationutf32_spanish_ci)
	Collation_utf32_swedish_ci            = Collation(serial.Collationutf32_swedish_ci)
	Collation_utf32_turkish_ci            = Collation(serial.Collationutf32_turkish_ci)
	Collation_utf32_czech_ci              = Collation(serial.Collationutf32_czech_ci)
	Collation_utf32_danish_ci             = Collation(serial.Collationutf32_danish_ci)
	Collation_utf32_lithuanian_ci         = Collation(serial.Collationutf32_lithuanian_ci)
	Collation_utf32_slovak_ci             = Collation(serial.Collationutf32_slovak_ci)
	Collation_utf32_spanish2_ci           = Collation(serial.Collationutf32_spanish2_ci)
	Collation_utf32_roman_ci              = Collation(serial.Collationutf32_roman_ci)
	Collation_utf32_persian_ci            = Collation(serial.Collationutf32_persian_ci)
	Collation_utf32_esperanto_ci          = Collation(serial.Collationutf32_esperanto_ci)
	Collation_utf32_hungarian_ci          = Collation(serial.Collationutf32_hungarian_ci)
	Collation_utf32_sinhala_ci            = Collation(serial.Collationutf32_sinhala_ci)
	Collation_utf32_german2_ci            = Collation(serial.Collationutf32_german2_ci)
	Collation_utf32_croatian_ci           = Collation(serial.Collationutf32_croatian_ci)
	Collation_utf32_unicode_520_ci        = Collation(serial.Collationutf32_unicode_520_ci)
	Collation_utf32_vietnamese_ci         = Collation(serial.Collationutf32_vietnamese_ci)
	Collation_utf8mb3_unicode_ci          = Collation(serial.Collationutf8mb3_unicode_ci)
	Collation_utf8mb3_icelandic_ci        = Collation(serial.Collationutf8mb3_icelandic_ci)
	Collation_utf8mb3_latvian_ci          = Collation(serial.Collationutf8mb3_latvian_ci)
	Collation_utf8mb3_romanian_ci         = Collation(serial.Collationutf8mb3_romanian_ci)
	Collation_utf8mb3_slovenian_ci        = Collation(serial.Collationutf8mb3_slovenian_ci)
	Collation_utf8mb3_polish_ci           = Collation(serial.Collationutf8mb3_polish_ci)
	Collation_utf8mb3_estonian_ci         = Collation(serial.Collationutf8mb3_estonian_ci)
	Collation_utf8mb3_spanish_ci          = Collation(serial.Collationutf8mb3_spanish_ci)
	Collation_utf8mb3_swedish_ci          = Collation(serial.Collationutf8mb3_swedish_ci)
	Collation_utf8mb3_turkish_ci          = Collation(serial.Collationutf8mb3_turkish_ci)
	Collation_utf8mb3_czech_ci            = Collation(serial.Collationutf8mb3_czech_ci)
	Collation_utf8mb3_danish_ci           = Collation(serial.Collationutf8mb3_danish_ci)
	Collation_utf8mb3_lithuanian_ci       = Collation(serial.Collationutf8mb3_lithuanian_ci)
	Collation_utf8mb3_slovak_ci           = Collation(serial.Collationutf8mb3_slovak_ci)
	Collation_utf8mb3_spanish2_ci         = Collation(serial.Collationutf8mb3_spanish2_ci)
	Collation_utf8mb3_roman_ci            = Collation(serial.Collationutf8mb3_roman_ci)
	Collation_utf8mb3_persian_ci          = Collation(serial.Collationutf8mb3_persian_ci)
	Collation_utf8mb3_esperanto_ci        = Collation(serial.Collationutf8mb3_esperanto_ci)
	Collation_utf8mb3_hungarian_ci        = Collation(serial.Collationutf8mb3_hungarian_ci)
	Collation_utf8mb3_sinhala_ci          = Collation(serial.Collationutf8mb3_sinhala_ci)
	Collation_utf8mb3_german2_ci          = Collation(serial.Collationutf8mb3_german2_ci)
	Collation_utf8mb3_croatian_ci         = Collation(serial.Collationutf8mb3_croatian_ci)
	Collation_utf8mb3_unicode_520_ci      = Collation(serial.Collationutf8mb3_unicode_520_ci)
	Collation_utf8mb3_vietnamese_ci       = Collation(serial.Collationutf8mb3_vietnamese_ci)
	Collation_utf8mb3_general_mysql500_ci = Collation(serial.Collationutf8mb3_general_mysql500_ci)
	Collation_utf8mb4_unicode_ci          = Collation(serial.Collationutf8mb4_unicode_ci)
	Collation_utf8mb4_icelandic_ci        = Collation(serial.Collationutf8mb4_icelandic_ci)
	Collation_utf8mb4_latvian_ci          = Collation(serial.Collationutf8mb4_latvian_ci)
	Collation_utf8mb4_romanian_ci         = Collation(serial.Collationutf8mb4_romanian_ci)
	Collation_utf8mb4_slovenian_ci        = Collation(serial.Collationutf8mb4_slovenian_ci)
	Collation_utf8mb4_polish_ci           = Collation(serial.Collationutf8mb4_polish_ci)
	Collation_utf8mb4_estonian_ci         = Collation(serial.Collationutf8mb4_estonian_ci)
	Collation_utf8mb4_spanish_ci          = Collation(serial.Collationutf8mb4_spanish_ci)
	Collation_utf8mb4_swedish_ci          = Collation(serial.Collationutf8mb4_swedish_ci)
	Collation_utf8mb4_turkish_ci          = Collation(serial.Collationutf8mb4_turkish_ci)
	Collation_utf8mb4_czech_ci            = Collation(serial.Collationutf8mb4_czech_ci)
	Collation_utf8mb4_danish_ci           = Collation(serial.Collationutf8mb4_danish_ci)
	Collation_utf8mb4_lithuanian_ci       = Collation(serial.Collationutf8mb4_lithuanian_ci)
	Collation_utf8mb4_slovak_ci           = Collation(serial.Collationutf8mb4_slovak_ci)
	Collation_utf8mb4_spanish2_ci         = Collation(serial.Collationutf8mb4_spanish2_ci)
	Collation_utf8mb4_roman_ci            = Collation(serial.Collationutf8mb4_roman_ci)
	Collation_utf8mb4_persian_ci          = Collation(serial.Collationutf8mb4_persian_ci)
	Collation_utf8mb4_esperanto_ci        = Collation(serial.Collationutf8mb4_esperanto_ci)
	Collation_utf8mb4_hungarian_ci        = Collation(serial.Collationutf8mb4_hungarian_ci)
	Collation_utf8mb4_sinhala_ci          = Collation(serial.Collationutf8mb4_sinhala_ci)
	Collation_utf8mb4_german2_ci          = Collation(serial.Collationutf8mb4_german2_ci)
	Collation_utf8mb4_croatian_ci         = Collation(serial.Collationutf8mb4_croatian_ci)
	Collation_utf8mb4_unicode_520_ci      = Collation(serial.Collationutf8mb4_unicode_520_ci)
	Collation_utf8mb4_vietnamese_ci       = Collation(serial.Collationutf8mb4_vietnamese_ci)
	Collation_gb18030_chinese_ci          = Collation(serial.Collationgb18030_chinese_ci)
	Collation_gb18030_bin                 = Collation(serial.Collationgb18030_bin)
	Collation_gb18030_unicode_520_ci      = Collation(serial.Collationgb18030_unicode_520_ci)
	Collation_utf8mb4_0900_ai_ci          = Collation(serial.Collationutf8mb4_0900_ai_ci)
	Collation_utf8mb4_de_pb_0900_ai_ci    = Collation(serial.Collationutf8mb4_de_pb_0900_ai_ci)
	Collation_utf8mb4_is_0900_ai_ci       = Collation(serial.Collationutf8mb4_is_0900_ai_ci)
	Collation_utf8mb4_lv_0900_ai_ci       = Collation(serial.Collationutf8mb4_lv_0900_ai_ci)
	Collation_utf8mb4_ro_0900_ai_ci       = Collation(serial.Collationutf8mb4_ro_0900_ai_ci)
	Collation_utf8mb4_sl_0900_ai_ci       = Collation(serial.Collationutf8mb4_sl_0900_ai_ci)
	Collation_utf8mb4_pl_0900_ai_ci       = Collation(serial.Collationutf8mb4_pl_0900_ai_ci)
	Collation_utf8mb4_et_0900_ai_ci       = Collation(serial.Collationutf8mb4_et_0900_ai_ci)
	Collation_utf8mb4_es_0900_ai_ci       = Collation(serial.Collationutf8mb4_es_0900_ai_ci)
	Collation_utf8mb4_sv_0900_ai_ci       = Collation(serial.Collationutf8mb4_sv_0900_ai_ci)
	Collation_utf8mb4_tr_0900_ai_ci       = Collation(serial.Collationutf8mb4_tr_0900_ai_ci)
	Collation_utf8mb4_cs_0900_ai_ci       = Collation(serial.Collationutf8mb4_cs_0900_ai_ci)
	Collation_utf8mb4_da_0900_ai_ci       = Collation(serial.Collationutf8mb4_da_0900_ai_ci)
	Collation_utf8mb4_lt_0900_ai_ci       = Collation(serial.Collationutf8mb4_lt_0900_ai_ci)
	Collation_utf8mb4_sk_0900_ai_ci       = Collation(serial.Collationutf8mb4_sk_0900_ai_ci)
	Collation_utf8mb4_es_trad_0900_ai_ci  = Collation(serial.Collationutf8mb4_es_trad_0900_ai_ci)
	Collation_utf8mb4_la_0900_ai_ci       = Collation(serial.Collationutf8mb4_la_0900_ai_ci)
	Collation_utf8mb4_eo_0900_ai_ci       = Collation(serial.Collationutf8mb4_eo_0900_ai_ci)
	Collation_utf8mb4_hu_0900_ai_ci       = Collation(serial.Collationutf8mb4_hu_0900_ai_ci)
	Collation_utf8mb4_hr_0900_ai_ci       = Collation(serial.Collationutf8mb4_hr_0900_ai_ci)
	Collation_utf8mb4_vi_0900_ai_ci       = Collation(serial.Collationutf8mb4_vi_0900_ai_ci)
	Collation_utf8mb4_0900_as_cs          = Collation(serial.Collationutf8mb4_0900_as_cs)
	Collation_utf8mb4_de_pb_0900_as_cs    = Collation(serial.Collationutf8mb4_de_pb_0900_as_cs)
	Collation_utf8mb4_is_0900_as_cs       = Collation(serial.Collationutf8mb4_is_0900_as_cs)
	Collation_utf8mb4_lv_0900_as_cs       = Collation(serial.Collationutf8mb4_lv_0900_as_cs)
	Collation_utf8mb4_ro_0900_as_cs       = Collation(serial.Collationutf8mb4_ro_0900_as_cs)
	Collation_utf8mb4_sl_0900_as_cs       = Collation(serial.Collationutf8mb4_sl_0900_as_cs)
	Collation_utf8mb4_pl_0900_as_cs       = Collation(serial.Collationutf8mb4_pl_0900_as_cs)
	Collation_utf8mb4_et_0900_as_cs       = Collation(serial.Collationutf8mb4_et_0900_as_cs)
	Collation_utf8mb4_es_0900_as_cs       = Collation(serial.Collationutf8mb4_es_0900_as_cs)
	Collation_utf8mb4_sv_0900_as_cs       = Collation(serial.Collationutf8mb4_sv_0900_as_cs)
	Collation_utf8mb4_tr_0900_as_cs       = Collation(serial.Collationutf8mb4_tr_0900_as_cs)
	Collation_utf8mb4_cs_0900_as_cs       = Collation(serial.Collationutf8mb4_cs_0900_as_cs)
	Collation_utf8mb4_da_0900_as_cs       = Collation(serial.Collationutf8mb4_da_0900_as_cs)
	Collation_utf8mb4_lt_0900_as_cs       = Collation(serial.Collationutf8mb4_lt_0900_as_cs)
	Collation_utf8mb4_sk_0900_as_cs       = Collation(serial.Collationutf8mb4_sk_0900_as_cs)
	Collation_utf8mb4_es_trad_0900_as_cs  = Collation(serial.Collationutf8mb4_es_trad_0900_as_cs)
	Collation_utf8mb4_la_0900_as_cs       = Collation(serial.Collationutf8mb4_la_0900_as_cs)
	Collation_utf8mb4_eo_0900_as_cs       = Collation(serial.Collationutf8mb4_eo_0900_as_cs)
	Collation_utf8mb4_hu_0900_as_cs       = Collation(serial.Collationutf8mb4_hu_0900_as_cs)
	Collation_utf8mb4_hr_0900_as_cs       = Collation(serial.Collationutf8mb4_hr_0900_as_cs)
	Collation_utf8mb4_vi_0900_as_cs       = Collation(serial.Collationutf8mb4_vi_0900_as_cs)
	Collation_utf8mb4_ja_0900_as_cs       = Collation(serial.Collationutf8mb4_ja_0900_as_cs)
	Collation_utf8mb4_ja_0900_as_cs_ks    = Collation(serial.Collationutf8mb4_ja_0900_as_cs_ks)
	Collation_utf8mb4_0900_as_ci          = Collation(serial.Collationutf8mb4_0900_as_ci)
	Collation_utf8mb4_ru_0900_ai_ci       = Collation(serial.Collationutf8mb4_ru_0900_ai_ci)
	Collation_utf8mb4_ru_0900_as_cs       = Collation(serial.Collationutf8mb4_ru_0900_as_cs)
	Collation_utf8mb4_zh_0900_as_cs       = Collation(serial.Collationutf8mb4_zh_0900_as_cs)
	Collation_utf8mb4_0900_bin            = Collation(serial.Collationutf8mb4_0900_bin)

	Collation_Default = Collation_utf8mb4_0900_bin
	Collation_Invalid = Collation(serial.Collationinvalid)
)
