// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeMediumint(t *testing.T) {
	SkipByDefaultInCI(t)
	tests := []ModifyTypeTest{
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0)",
			[]interface{}{float64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0)",
			[]interface{}{"0.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0)",
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0)",
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0)",
			[]interface{}{uint64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0)",
			[]interface{}{"0"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0)",
			[]interface{}{int64(0)},
			false,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0)",
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0)",
			[]interface{}{""},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1)",
			[]interface{}{float64(0), float64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1)",
			[]interface{}{"0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1)",
			[]interface{}{uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1)",
			[]interface{}{"0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1)",
			[]interface{}{int64(0), int64(2001)},
			false,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1)",
			[]interface{}{"00:00:00", "00:00:01"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1)",
			[]interface{}{"", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1)",
			[]interface{}{"", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{int64(-1), int64(0), int64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{float64(-1), float64(0), float64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.0", "0.0", "1.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000", "0.000000000000000", "1.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(1)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{"-00:00:01", "00:00:00", "00:00:01"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-1), (1,0), (2,1)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{float64(0), float64(1), float64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2)",
			[]interface{}{int64(0), int64(2001), int64(2002)},
			false,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "B", "C"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "A", "B"},
			false,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2)",
			[]interface{}{"", "C", "A"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{int64(-2), int64(-1), int64(0), int64(1), int64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{float64(-2), float64(-1), float64(0), float64(1), float64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.0", "-1.0", "0.0", "1.0", "2.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-2", "-1", "0", "1", "2"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{"-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-2), (1,-1), (2,0), (3,1), (4,2)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{int64(0), int64(2001), int64(2002), int64(2015)},
			false,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-16", "-2", "-1", "0", "1", "2", "15"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{"-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-16), (1,-2), (2,-1), (3,0), (4,1), (5,2), (6,15)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-128", "-16", "-2", "-1", "0", "1", "2", "15", "127"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{"-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-128), (1,-16), (2,-2), (3,-1), (4,0), (5,1), (6,2), (7,15), (8,127)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{"00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{"-00:02:56", "-00:01:28", "-00:00:16", "-00:00:02", "-00:00:01", "00:00:00", "00:00:01", "00:00:02", "00:00:15", "00:01:27", "00:02:55"},
			false,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-256), (1,-128), (2,-16), (3,-2), (4,-1), (5,0), (6,1), (7,2), (8,15), (9,127), (10,255)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{"-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-4096), (1,-256), (2,-128), (3,-16), (4,-2), (5,-1), (6,0), (7,1), (8,2), (9,15), (10,127), (11,255), (12,4095)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{"-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-32768), (1,-4096), (2,-256), (3,-128), (4,-16), (5,-2), (6,-1), (7,0), (8,1), (9,2), (10,15), (11,127), (12,255), (13,4095), (14,32767)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{"-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-65536), (1,-32768), (2,-4096), (3,-256), (4,-128), (5,-16), (6,-2), (7,-1), (8,0), (9,1), (10,2), (11,15), (12,127), (13,255), (14,4095), (15,32767), (16,65535)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{"-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-1048576), (1,-65536), (2,-32768), (3,-4096), (4,-256), (5,-128), (6,-16), (7,-2), (8,-1), (9,0), (10,1), (11,2), (12,15), (13,127), (14,255), (15,4095), (16,32767), (17,65535), (18,1048575)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{"0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,0), (1,1), (2,2), (3,15), (4,127), (5,255), (6,4095), (7,32767), (8,65535), (9,1048575), (10,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TINYINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"BIGINT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{int64(-8388608), int64(-1048576), int64(-65536), int64(-32768), int64(-4096), int64(-256), int64(-128), int64(-16), int64(-2), int64(-1), int64(0), int64(1), int64(2), int64(15), int64(127), int64(255), int64(4095), int64(32767), int64(65535), int64(1048575), int64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SMALLINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"MEDIUMINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"INT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIGINT UNSIGNED",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"FLOAT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"DOUBLE",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{float64(-8388608), float64(-1048576), float64(-65536), float64(-32768), float64(-4096), float64(-256), float64(-128), float64(-16), float64(-2), float64(-1), float64(0), float64(1), float64(2), float64(15), float64(127), float64(255), float64(4095), float64(32767), float64(65535), float64(1048575), float64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,0)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(1,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.0", "-1048576.0", "-65536.0", "-32768.0", "-4096.0", "-256.0", "-128.0", "-16.0", "-2.0", "-1.0", "0.0", "1.0", "2.0", "15.0", "127.0", "255.0", "4095.0", "32767.0", "65535.0", "1048575.0", "8388607.0"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(15,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,15)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000", "-1048576.000000000000000", "-65536.000000000000000", "-32768.000000000000000", "-4096.000000000000000", "-256.000000000000000", "-128.000000000000000", "-16.000000000000000", "-2.000000000000000", "-1.000000000000000", "0.000000000000000", "1.000000000000000", "2.000000000000000", "15.000000000000000", "127.000000000000000", "255.000000000000000", "4095.000000000000000", "32767.000000000000000", "65535.000000000000000", "1048575.000000000000000", "8388607.000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"DECIMAL(30,30)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DECIMAL(65,30)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608.000000000000000000000000000000", "-1048576.000000000000000000000000000000", "-65536.000000000000000000000000000000", "-32768.000000000000000000000000000000", "-4096.000000000000000000000000000000", "-256.000000000000000000000000000000", "-128.000000000000000000000000000000", "-16.000000000000000000000000000000", "-2.000000000000000000000000000000", "-1.000000000000000000000000000000", "0.000000000000000000000000000000", "1.000000000000000000000000000000", "2.000000000000000000000000000000", "15.000000000000000000000000000000", "127.000000000000000000000000000000", "255.000000000000000000000000000000", "4095.000000000000000000000000000000", "32767.000000000000000000000000000000", "65535.000000000000000000000000000000", "1048575.000000000000000000000000000000", "8388607.000000000000000000000000000000"},
			false,
		},
		{
			"MEDIUMINT",
			"BIT(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(8)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(16)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(24)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(32)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(48)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BIT(64)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{uint64(18446744073701163008), uint64(18446744073708503040), uint64(18446744073709486080), uint64(18446744073709518848), uint64(18446744073709547520), uint64(18446744073709551360), uint64(18446744073709551488), uint64(18446744073709551600), uint64(18446744073709551614), uint64(18446744073709551615), uint64(0), uint64(1), uint64(2), uint64(15), uint64(127), uint64(255), uint64(4095), uint64(32767), uint64(65535), uint64(1048575), uint64(8388607)},
			false,
		},
		{
			"MEDIUMINT",
			"TINYBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"BLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGBLOB",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"TINYTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"TEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"MEDIUMTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"LONGTEXT",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"CHAR(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"CHAR(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"BINARY(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00", "-1048576\x00\x00", "-65536\x00\x00\x00\x00", "-32768\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00", "1048575\x00\x00\x00", "8388607\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"BINARY(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048576\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-65536\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-32768\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-4096\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-128\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-16\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "15\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "127\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "255\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "4095\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "32767\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "65535\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "8388607\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARCHAR(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(1023)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARCHAR(4095)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"VARBINARY(10)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(100)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(255)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(1023)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(4095)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"VARBINARY(16383)",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{"-8388608", "-1048576", "-65536", "-32768", "-4096", "-256", "-128", "-16", "-2", "-1", "0", "1", "2", "15", "127", "255", "4095", "32767", "65535", "1048575", "8388607"},
			false,
		},
		{
			"MEDIUMINT",
			"YEAR",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATE",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIME",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"TIMESTAMP",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"DATETIME",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('A','B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"ENUM('C','A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('A','B','C')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
		{
			"MEDIUMINT",
			"SET('C','A','B')",
			"(0,-8388608), (1,-1048576), (2,-65536), (3,-32768), (4,-4096), (5,-256), (6,-128), (7,-16), (8,-2), (9,-1), (10,0), (11,1), (12,2), (13,15), (14,127), (15,255), (16,4095), (17,32767), (18,65535), (19,1048575), (20,8388607)",
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
