#!/usr/bin/env bats
load $BATS_TEST_DIRNAME/helper/common.bash

setup() {
    setup_common
    TMPDIRS=$(pwd)/tmpdirs
    mkdir -p $TMPDIRS/{bac1,repo1}

    # repo1 -> bac1 -> repo2
    cd $TMPDIRS/repo1
    dolt init
    dolt branch feature
    dolt remote add backup1 file://../bac1
    cd $TMPDIRS
}

teardown() {
    teardown_common
    rm -rf $TMPDIRS
    cd $BATS_TMPDIR
}

@test "replication: default no replication" {
    cd repo1
    dolt sql -q "create table t1 (a int primary key)"
    dolt commit -am "cm"

    [ ! -d "../bac1/.dolt" ] || false
}

@test "replication: push on commit" {
    export DOLT_BACKUP_TO_REMOTE=backup1
    cd repo1
    dolt remote -v
    dolt sql -q "create table t1 (a int primary key)"
    dolt commit -am "cm"

    cd ..
    dolt clone file://./bac1 repo2
    export DOLT_BACKUP_TO_REMOTE=
    cd repo2
    run dolt ls
    [ "$status" -eq 0 ]
    [ "${#lines[@]}" -eq 2 ]
    [[ "$output" =~ "t1" ]] || false
}

@test "replication: no tags" {
    export DOLT_BACKUP_TO_REMOTE=backup1
    cd repo1
    dolt tag

    [ ! -d "../bac1/.dolt" ] || false
}
