#!/usr/bin/env bats
load $BATS_TEST_DIRNAME/helper/common.bash

setup() {
    setup_common
}

teardown() {
    assert_feature_version
    teardown_common
}

@test "regression-tests: dolt issue #1081" {
    dolt sql <<SQL
CREATE TABLE XA(YW VARCHAR(24) NOT NULL, XB VARCHAR(100), XC VARCHAR(2500),
  XD VARCHAR(2500), XE VARCHAR(100), XF VARCHAR(100), XG VARCHAR(100),
  XI VARCHAR(100), XJ VARCHAR(100), XK VARCHAR(100), XL VARCHAR(100),
  XM VARCHAR(1000), XN TEXT, XO TEXT, PRIMARY KEY (YW));
CREATE TABLE XP(YW VARCHAR(24) NOT NULL, XQ VARCHAR(100) NOT NULL,
  XR VARCHAR(1000), PRIMARY KEY (YW));
CREATE TABLE XS(YW VARCHAR(24) NOT NULL, XT VARCHAR(24) NOT NULL,
  XU VARCHAR(24), XV VARCHAR(100) NOT NULL, XW DOUBLE NOT NULL,
  XX DOUBLE NOT NULL, XY VARCHAR(100), XC VARCHAR(100), XZ VARCHAR(100) NOT NULL,
  YA DOUBLE, YB VARCHAR(24) NOT NULL, YC VARCHAR(1000), XO VARCHAR(1000),
  YD DOUBLE NOT NULL, YE DOUBLE NOT NULL, PRIMARY KEY (YW));
CREATE TABLE YF(YW VARCHAR(24) NOT NULL, XB VARCHAR(100) NOT NULL, YG VARCHAR(100),
  YH VARCHAR(100), XO TEXT, PRIMARY KEY (YW));
CREATE TABLE yp(YW VARCHAR(24) NOT NULL, XJ VARCHAR(100) NOT NULL, XL VARCHAR(100),
  XT VARCHAR(24) NOT NULL, YI INT NOT NULL, XO VARCHAR(1000), PRIMARY KEY (YW),
  FOREIGN KEY (XT) REFERENCES XP (YW));
INSERT INTO XS VALUES ('', '', NULL, 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC', 0, 0,
  NULL, NULL, '', NULL, '', NULL, NULL, 0, 0);
INSERT INTO YF VALUES ('', '', NULL, NULL, NULL);
INSERT INTO XA VALUES ('', '', '', '', '', 'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAC',
  '', '', '', '', '', '', '', '');
SQL
    run dolt sql -r=csv -q "
SELECT DISTINCT YM.YW AS YW, (SELECT YW FROM YF WHERE YF.XB = YM.XB) AS YF_YW,
  (SELECT YW FROM yp WHERE yp.XJ = YM.XJ AND (yp.XL = YM.XL OR (yp.XL IS NULL AND
  YM.XL IS NULL)) AND yp.XT = nd.XT) AS YJ, XE AS XE, XI AS YO, XK AS XK, XM AS XM,
  CASE WHEN YM.XO <> 'Z' THEN YM.XO ELSE NULL END AS XO FROM (SELECT YW, XB, XC, XE,
  XF, XI, XJ, XK, CASE WHEN XL = 'Z' OR XL = 'Z' THEN NULL ELSE XL END AS XL, XM,
  XO FROM XA) YM INNER JOIN XS nd ON nd.XV = XF WHERE XB IN (SELECT XB FROM YF) AND
  (XF IS NOT NULL AND XF <> 'Z') UNION SELECT DISTINCT YL.YW AS YW, (SELECT YW FROM
  YF WHERE YF.XB = YL.XB) AS YF_YW, (SELECT YW FROM yp WHERE yp.XJ = YL.XJ AND
  (yp.XL = YL.XL OR (yp.XL IS NULL AND YL.XL IS NULL)) AND yp.XT = YN.XT) AS YJ,
  XE AS XE, XI AS YO, XK AS XK, XM AS XM, CASE WHEN YL.XO <> 'Z' THEN YL.XO ELSE
  NULL END AS XO FROM (SELECT YW, XB, XC, XE, XF, XI, XJ, XK, CASE WHEN XL = 'Z' OR
  XL = 'Z' THEN NULL ELSE XL END AS XL, XM, XO FROM XA) YL INNER JOIN XS YN ON
  YN.XC = YL.XC WHERE XB IN (SELECT XB FROM YF) AND (XF IS NULL OR XF = 'Z');"
    [ "$status" -eq "0" ]
    [[ "$output" =~ "YW,YF_YW,YJ,XE,YO,XK,XM,XO" ]] || false
    [[ "$output" =~ '"","",,"","","","",""' ]] || false
    [[ "${#lines[@]}" = "2" ]] || false
}
