---
layout: default
title: How to edit the documentation
---

# Working with the docs

The website is a static website generated by [Jekyll](https://jekyllrb.com/docs/).

The website is generated from the files in `$GIT/dnscontrol/docs`.  If a file
has a `.md` extension, it will be turned into an HTML file. Otherwise it is
copied verbatium.

# Directory Hierarchy

* `docs`:  The root directory.  index.md is the homepage.
* `docs/_includes`: Functions and templates.
* `docs/css`:  CSS
* `docs/_functions/record`: Things that augment a record.
* `docs/_functions/domain`: Things inside a `D()`
* `docs/_functions/global`: Features at the global (file) level.
* `docs/_layouts`: Main layout
* `docs/public`: Static content
* `docs/_site`: The generated site (not in Git)
* `docs/assets`: Static files
* `docs/flattener`: The SPF flatter

# How to preview

The documentation can be viewed via Docker:

```bash
cd docs
./runDocker.sh
```

FYI: Alternative Docker command:

```bash
docker run --rm -it --volume="$PWD:/srv/jekyll" --volume="$PWD/vendor/bundle:/  usr/local/bundle" --env JEKYLL_ENV=production jekyll/jekyll:3.8 jekyll build -V
# Open docs/_site/index.html in your web browser to see the results.
# (Note: The preview isn't perfect. Links that use the site.github.url variable won't work.
```
