# Contributing

The general workflow for contributing to this project is outlined in this document.

## Create an Issue

If you find a bug in this project, have trouble following the documentation, or have a question about the project, create an issue! There’s nothing to it and whatever issue you’re having, you’re likely not the only one, so others will find your issue helpful, too. For more information on how issues work, check out GitHub's [Issues guide](https://docs.github.com/en/issues/tracking-your-work-with-issues/about-issues). Or there are lots of [other places for immediate support](https://ddev.readthedocs.io/en/stable/users/support/).

### Issues Pro Tips

- **Check existing issues** for your issue. Duplicating an issue is slower for both parties, so search through open and closed issues to see if what you’re running into has been addressed already.
- **Be clear** about what your problem is: What was the expected outcome? What happened instead? Detail how someone else can recreate the problem.
- **Link to examples** recreate or display the problem with screenshots, screencasts, or code examples using [The Go Playground](https://play.golang.org). The better you can demonstrate the problem, the more attention your issue is likely to get.
- **Include system details** like what the browser, library or operating system you’re using and its version.
- **Paste error output** or logs in your issue or in a [Gist](http://gist.github.com/). If pasting them in the issue, wrap it in three backticks: ` ``` ` so that it renders nicely.

## Stack Overflow Questions and Documentation

There are a number of situations where a particular approach to a DDEV solution can be stated more easily in [Stack Overflow](https://stackoverflow.com/tags/ddev) (use the "ddev" tag). We respond there quickly, but if you know the answer already, create the question there and then click the checkbox at the bottom "Answer your own question". Stack Overflow is often the best place to incubate documentation that affects only a few people or that needs time to get responses. And it's highly searchable on the web.

## Pull Request

If you’re able to patch the bug or add the feature yourself – fantastic, make a pull request with the code! Once you’ve submitted a pull request the maintainer(s) can compare your branch to the existing one and decide whether or not to incorporate (pull in) your changes.

Refer to [Building, Testing, and Contributing](docs/content/developers/building-contributing.md) for help with how to build and test the project and how to submit a pull request.
