package config_test

import (
	"testing"

	"github.com/danvergara/dblab/pkg/config"
	"github.com/stretchr/testify/assert"
)

func TestInit(t *testing.T) {
	type want struct {
		host   string
		port   string
		dbname string
		user   string
		pass   string
		driver string
		schema string
		limit  int
	}
	var tests = []struct {
		name  string
		input string
		want  want
	}{
		{
			name:  "empty config name",
			input: "",
			want: want{
				host:   "localhost",
				port:   "5432",
				dbname: "users",
				user:   "postgres",
				pass:   "password",
				driver: "postgres",
				schema: "public",
				limit:  50,
			},
		},
		{
			name:  "test config",
			input: "test",
			want: want{
				host:   "localhost",
				port:   "5432",
				dbname: "users",
				user:   "postgres",
				pass:   "password",
				driver: "postgres",
				schema: "public",
				limit:  50,
			},
		},
		{
			name:  "production config",
			input: "prod",
			want: want{
				host:   "mydb.123456789012.us-east-1.rds.amazonaws.com",
				port:   "5432",
				dbname: "users",
				user:   "postgres",
				pass:   "password",
				driver: "postgres",
				schema: "public",
				limit:  50,
			},
		},
	}

	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			opts, err := config.Init(tt.input)

			assert.NoError(t, err)
			assert.Equal(t, tt.want.host, opts.Host)
			assert.Equal(t, tt.want.port, opts.Port)
			assert.Equal(t, tt.want.dbname, opts.DBName)
			assert.Equal(t, tt.want.user, opts.User)
			assert.Equal(t, tt.want.pass, opts.Pass)
			assert.Equal(t, tt.want.driver, opts.Driver)
			assert.Equal(t, tt.want.schema, opts.Schema)
			assert.Equal(t, tt.want.limit, opts.Limit)
		})
	}
}
