/*
Daytona Server API

Daytona Server API

API version: v0.0.0-dev
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package apiclient

import (
	"bytes"
	"encoding/json"
	"fmt"
)

// checks if the ApiKey type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ApiKey{}

// ApiKey struct for ApiKey
type ApiKey struct {
	KeyHash string `json:"keyHash"`
	// Project or client name
	Name string           `json:"name"`
	Type ApikeyApiKeyType `json:"type"`
}

type _ApiKey ApiKey

// NewApiKey instantiates a new ApiKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewApiKey(keyHash string, name string, type_ ApikeyApiKeyType) *ApiKey {
	this := ApiKey{}
	this.KeyHash = keyHash
	this.Name = name
	this.Type = type_
	return &this
}

// NewApiKeyWithDefaults instantiates a new ApiKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewApiKeyWithDefaults() *ApiKey {
	this := ApiKey{}
	return &this
}

// GetKeyHash returns the KeyHash field value
func (o *ApiKey) GetKeyHash() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.KeyHash
}

// GetKeyHashOk returns a tuple with the KeyHash field value
// and a boolean to check if the value has been set.
func (o *ApiKey) GetKeyHashOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.KeyHash, true
}

// SetKeyHash sets field value
func (o *ApiKey) SetKeyHash(v string) {
	o.KeyHash = v
}

// GetName returns the Name field value
func (o *ApiKey) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *ApiKey) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *ApiKey) SetName(v string) {
	o.Name = v
}

// GetType returns the Type field value
func (o *ApiKey) GetType() ApikeyApiKeyType {
	if o == nil {
		var ret ApikeyApiKeyType
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *ApiKey) GetTypeOk() (*ApikeyApiKeyType, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *ApiKey) SetType(v ApikeyApiKeyType) {
	o.Type = v
}

func (o ApiKey) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ApiKey) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["keyHash"] = o.KeyHash
	toSerialize["name"] = o.Name
	toSerialize["type"] = o.Type
	return toSerialize, nil
}

func (o *ApiKey) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"keyHash",
		"name",
		"type",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varApiKey := _ApiKey{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varApiKey)

	if err != nil {
		return err
	}

	*o = ApiKey(varApiKey)

	return err
}

type NullableApiKey struct {
	value *ApiKey
	isSet bool
}

func (v NullableApiKey) Get() *ApiKey {
	return v.value
}

func (v *NullableApiKey) Set(val *ApiKey) {
	v.value = val
	v.isSet = true
}

func (v NullableApiKey) IsSet() bool {
	return v.isSet
}

func (v *NullableApiKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableApiKey(val *ApiKey) *NullableApiKey {
	return &NullableApiKey{value: val, isSet: true}
}

func (v NullableApiKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableApiKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
