#!/bin/sh
set -eu
cd -- "$(dirname "$0")/../.."
. ./ci/sub/lib.sh

sh_c chmod +w ./ci/release/template/scripts/lib.sh
sh_c cat >./ci/release/template/scripts/lib.sh <<EOF
#!/bin/sh

# *************
# DO NOT EDIT
#
# lib.sh was bundled together from
#
# - ./ci/sub/lib/rand.sh
# - ./ci/sub/lib/log.sh
#
# Generated by ./ci/release/gen_template_lib.sh.
# *************

EOF

# sed removes the sourcing dependency lines as we're bundled everything into a single
# script.
sh_c cat \
  ./ci/sub/lib/rand.sh \
  ./ci/sub/lib/log.sh \
  \| sed "-e'/^\. /d'" \>\>./ci/release/template/scripts/lib.sh
sh_c chmod -w ./ci/release/template/scripts/lib.sh
