// Code generated by go generate. DO NOT EDIT.

package cue

import (
	"bytes"
	"crypto/md5"
	"crypto/sha1"
	"crypto/sha256"
	"crypto/sha512"
	"encoding/base64"
	"encoding/csv"
	"encoding/hex"
	"encoding/json"
	"fmt"
	"html"
	"io"
	"math"
	"math/big"
	"math/bits"
	"net"
	"path"
	"regexp"
	"sort"
	"strconv"
	"strings"
	"text/tabwriter"
	"text/template"
	"time"
	"unicode"
	"unicode/utf8"

	"github.com/cockroachdb/apd/v2"
	"golang.org/x/net/idna"

	"cuelang.org/go/cue/errors"
	"cuelang.org/go/cue/literal"
	"cuelang.org/go/cue/parser"
	"cuelang.org/go/internal"
	cueyaml "cuelang.org/go/internal/encoding/yaml"
	"cuelang.org/go/internal/third_party/yaml"
)

func init() {
	initBuiltins(builtinPackages)
}

var _ io.Reader

var roundTruncContext = apd.Context{Rounding: apd.RoundDown}

var roundUpContext = apd.Context{Rounding: apd.RoundHalfUp}

var roundEvenContext = apd.Context{Rounding: apd.RoundHalfEven}

var mulContext = apd.BaseContext.WithPrecision(1)

var apdContext = apd.BaseContext.WithPrecision(24)

var zero = apd.New(0, 0)

var two = apd.New(2, 0)

var idnaProfile = idna.New(
	idna.ValidateLabels(true),
	idna.VerifyDNSLength(true),
	idna.StrictDomainName(true),
)

func netGetIP(ip Value) (goip net.IP) {
	switch ip.Kind() {
	case StringKind:
		s, err := ip.String()
		if err != nil {
			return nil
		}
		goip := net.ParseIP(s)
		if goip == nil {
			return nil
		}
		return goip

	case BytesKind:
		b, err := ip.Bytes()
		if err != nil {
			return nil
		}
		goip := net.ParseIP(string(b))
		if goip == nil {
			return nil
		}
		return goip

	case ListKind:
		iter, err := ip.List()
		if err != nil {
			return nil
		}
		for iter.Next() {
			v, err := iter.Value().Int64()
			if err != nil {
				return nil
			}
			if v < 0 || 255 < v {
				return nil
			}
			goip = append(goip, byte(v))
		}
		return goip

	default:

		return nil
	}
}

func netToList(ip net.IP) []uint {
	a := make([]uint, len(ip))
	for i, p := range ip {
		a[i] = uint(p)
	}
	return a
}

var split = path.Split

var pathClean = path.Clean

var pathExt = path.Ext

var pathBase = path.Base

var pathIsAbs = path.IsAbs

var pathDir = path.Dir

var errNoMatch = errors.New("no match")

var errNoNamedGroup = errors.New("no named groups")

func timeFormat(value, layout string) (bool, error) {
	_, err := time.Parse(layout, value)
	if err != nil {

		return false, fmt.Errorf("invalid time %q", value)
	}
	return true, nil
}

var builtinPackages = map[string]*builtinPkg{
	"": {
		native: []*builtin{},
	},
	"crypto/md5": {
		native: []*builtin{{
			Name:  "Size",
			Const: "16",
		}, {
			Name:  "BlockSize",
			Const: "64",
		}, {
			Name:   "Sum",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := md5.Sum(data)
						return a[:]
					}()
				}
			},
		}},
	},
	"crypto/sha1": {
		native: []*builtin{{
			Name:  "Size",
			Const: "20",
		}, {
			Name:  "BlockSize",
			Const: "64",
		}, {
			Name:   "Sum",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha1.Sum(data)
						return a[:]
					}()
				}
			},
		}},
	},
	"crypto/sha256": {
		native: []*builtin{{
			Name:  "Size",
			Const: "32",
		}, {
			Name:  "Size224",
			Const: "28",
		}, {
			Name:  "BlockSize",
			Const: "64",
		}, {
			Name:   "Sum256",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha256.Sum256(data)
						return a[:]
					}()
				}
			},
		}, {
			Name:   "Sum224",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha256.Sum224(data)
						return a[:]
					}()
				}
			},
		}},
	},
	"crypto/sha512": {
		native: []*builtin{{
			Name:  "Size",
			Const: "64",
		}, {
			Name:  "Size224",
			Const: "28",
		}, {
			Name:  "Size256",
			Const: "32",
		}, {
			Name:  "Size384",
			Const: "48",
		}, {
			Name:  "BlockSize",
			Const: "128",
		}, {
			Name:   "Sum512",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha512.Sum512(data)
						return a[:]
					}()
				}
			},
		}, {
			Name:   "Sum384",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha512.Sum384(data)
						return a[:]
					}()
				}
			},
		}, {
			Name:   "Sum512_224",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha512.Sum512_224(data)
						return a[:]
					}()
				}
			},
		}, {
			Name:   "Sum512_256",
			Params: []kind{bytesKind | stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						a := sha512.Sum512_256(data)
						return a[:]
					}()
				}
			},
		}},
	},
	"encoding/base64": {
		native: []*builtin{{
			Name:   "EncodedLen",
			Params: []kind{topKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				encoding, n := c.value(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if err := encoding.Null(); err != nil {
							return 0, fmt.Errorf("base64: unsupported encoding: %v", err)
						}
						return base64.StdEncoding.EncodedLen(n), nil
					}()
				}
			},
		}, {
			Name:   "DecodedLen",
			Params: []kind{topKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				encoding, x := c.value(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if err := encoding.Null(); err != nil {
							return 0, fmt.Errorf("base64: unsupported encoding: %v", err)
						}
						return base64.StdEncoding.DecodedLen(x), nil
					}()
				}
			},
		}, {
			Name:   "Encode",
			Params: []kind{topKind, bytesKind | stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				encoding, src := c.value(0), c.bytes(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if err := encoding.Null(); err != nil {
							return "", fmt.Errorf("base64: unsupported encoding: %v", err)
						}
						return base64.StdEncoding.EncodeToString(src), nil
					}()
				}
			},
		}, {
			Name:   "Decode",
			Params: []kind{topKind, stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				encoding, s := c.value(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if err := encoding.Null(); err != nil {
							return nil, fmt.Errorf("base64: unsupported encoding: %v", err)
						}
						return base64.StdEncoding.DecodeString(s)
					}()
				}
			},
		}},
	},
	"encoding/csv": {
		native: []*builtin{{
			Name:   "Encode",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				x := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						buf := &bytes.Buffer{}
						w := csv.NewWriter(buf)
						iter, err := x.List()
						if err != nil {
							return "", err
						}
						for iter.Next() {
							row, err := iter.Value().List()
							if err != nil {
								return "", err
							}
							a := []string{}
							for row.Next() {
								col := row.Value()
								if str, err := col.String(); err == nil {
									a = append(a, str)
								} else {
									b, err := col.MarshalJSON()
									if err != nil {
										return "", err
									}
									a = append(a, string(b))
								}
							}
							_ = w.Write(a)
						}
						w.Flush()
						return buf.String(), nil
					}()
				}
			},
		}, {
			Name:   "Decode",
			Params: []kind{bytesKind | stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				r := c.reader(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return csv.NewReader(r).ReadAll()
					}()
				}
			},
		}},
	},
	"encoding/hex": {
		native: []*builtin{{
			Name:   "EncodedLen",
			Params: []kind{intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				n := c.int(0)
				if c.do() {
					c.ret = func() interface{} {
						return hex.EncodedLen(n)
					}()
				}
			},
		}, {
			Name:   "DecodedLen",
			Params: []kind{intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x := c.int(0)
				if c.do() {
					c.ret = func() interface{} {
						return hex.DecodedLen(x)
					}()
				}
			},
		}, {
			Name:   "Decode",
			Params: []kind{stringKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return hex.DecodeString(s)
					}()
				}
			},
		}, {
			Name:   "Dump",
			Params: []kind{bytesKind | stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						return hex.Dump(data)
					}()
				}
			},
		}, {
			Name:   "Encode",
			Params: []kind{bytesKind | stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				src := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						return hex.EncodeToString(src)
					}()
				}
			},
		}},
	},
	"encoding/json": {
		native: []*builtin{{
			Name:   "Valid",
			Params: []kind{bytesKind | stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						return json.Valid(data)
					}()
				}
			},
		}, {
			Name:   "Compact",
			Params: []kind{bytesKind | stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				src := c.bytes(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						dst := bytes.Buffer{}
						if err := json.Compact(&dst, src); err != nil {
							return "", err
						}
						return dst.String(), nil
					}()
				}
			},
		}, {
			Name:   "Indent",
			Params: []kind{bytesKind | stringKind, stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				src, prefix, indent := c.bytes(0), c.string(1), c.string(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						dst := bytes.Buffer{}
						if err := json.Indent(&dst, src, prefix, indent); err != nil {
							return "", err
						}
						return dst.String(), nil
					}()
				}
			},
		}, {
			Name:   "HTMLEscape",
			Params: []kind{bytesKind | stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				src := c.bytes(0)
				if c.do() {
					c.ret = func() interface{} {
						dst := &bytes.Buffer{}
						json.HTMLEscape(dst, src)
						return dst.String()
					}()
				}
			},
		}, {
			Name:   "Marshal",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				v := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						b, err := json.Marshal(v)
						return string(b), err
					}()
				}
			},
		}, {
			Name:   "MarshalStream",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				v := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {

						iter, err := v.List()
						if err != nil {
							return "", err
						}
						buf := &bytes.Buffer{}
						for iter.Next() {
							b, err := json.Marshal(iter.Value())
							if err != nil {
								return "", err
							}
							buf.Write(b)
							buf.WriteByte('\n')
						}
						return buf.String(), nil
					}()
				}
			},
		}, {
			Name:   "Unmarshal",
			Params: []kind{bytesKind | stringKind},
			Result: topKind,
			Func: func(c *callCtxt) {
				b := c.bytes(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if !json.Valid(b) {
							return nil, fmt.Errorf("json: invalid JSON")
						}
						expr, err := parser.ParseExpr("json", b)
						if err != nil {

							return nil, fmt.Errorf("json: could not parse JSON: %v", err)
						}
						return expr, nil
					}()
				}
			},
		}, {
			Name:   "Validate",
			Params: []kind{bytesKind | stringKind, topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				b, v := c.bytes(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if !json.Valid(b) {
							return false, fmt.Errorf("json: invalid JSON")
						}
						r := internal.GetRuntime(v).(*Runtime)
						inst, err := r.Compile("json.Validate", b)
						if err != nil {
							return false, err
						}

						v = v.Unify(inst.Value())
						if v.Err() != nil {
							return false, v.Err()
						}
						return true, nil
					}()
				}
			},
		}},
	},
	"encoding/yaml": {
		native: []*builtin{{
			Name:   "Marshal",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				v := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if err := v.Validate(Concrete(true)); err != nil {
							if err := v.Validate(); err != nil {
								return "", err
							}
							return "", internal.ErrIncomplete
						}
						n := v.Syntax(Final(), Concrete(true))
						b, err := cueyaml.Encode(n)
						return string(b), err
					}()
				}
			},
		}, {
			Name:   "MarshalStream",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				v := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {

						iter, err := v.List()
						if err != nil {
							return "", err
						}
						buf := &bytes.Buffer{}
						for i := 0; iter.Next(); i++ {
							if i > 0 {
								buf.WriteString("---\n")
							}
							v := iter.Value()
							if err := v.Validate(Concrete(true)); err != nil {
								if err := v.Validate(); err != nil {
									return "", err
								}
								return "", internal.ErrIncomplete
							}
							n := v.Syntax(Final(), Concrete(true))
							b, err := cueyaml.Encode(n)
							if err != nil {
								return "", err
							}
							buf.Write(b)
						}
						return buf.String(), nil
					}()
				}
			},
		}, {
			Name:   "Unmarshal",
			Params: []kind{bytesKind | stringKind},
			Result: topKind,
			Func: func(c *callCtxt) {
				data := c.bytes(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return yaml.Unmarshal("", data)
					}()
				}
			},
		}, {
			Name:   "Validate",
			Params: []kind{bytesKind | stringKind, topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				b, v := c.bytes(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						d, err := yaml.NewDecoder("yaml.Validate", b)
						if err != nil {
							return false, err
						}
						r := internal.GetRuntime(v).(*Runtime)
						for {
							expr, err := d.Decode()
							if err != nil {
								if err == io.EOF {
									return true, nil
								}
								return false, err
							}

							inst, err := r.CompileExpr(expr)
							if err != nil {
								return false, err
							}

							x := v.Unify(inst.Value())
							if err := x.Err(); err != nil {
								return false, err
							}
							if err := x.Validate(Concrete(true)); err != nil {
								return false, err
							}

						}
					}()
				}
			},
		}, {
			Name:   "ValidatePartial",
			Params: []kind{bytesKind | stringKind, topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				b, v := c.bytes(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						d, err := yaml.NewDecoder("yaml.ValidatePartial", b)
						if err != nil {
							return false, err
						}
						r := internal.GetRuntime(v).(*Runtime)
						for {
							expr, err := d.Decode()
							if err != nil {
								if err == io.EOF {
									return true, nil
								}
								return false, err
							}

							inst, err := r.CompileExpr(expr)
							if err != nil {
								return false, err
							}

							if x := v.Unify(inst.Value()); x.Err() != nil {
								return false, x.Err()
							}
						}
					}()
				}
			},
		}},
	},
	"html": {
		native: []*builtin{{
			Name:   "Escape",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return html.EscapeString(s)
					}()
				}
			},
		}, {
			Name:   "Unescape",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return html.UnescapeString(s)
					}()
				}
			},
		}},
	},
	"list": {
		native: []*builtin{{
			Name:   "Drop",
			Params: []kind{listKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				x, n := c.list(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if n < 0 {
							return nil, fmt.Errorf("negative index")
						}

						if n > len(x) {
							return []Value{}, nil
						}

						return x[n:], nil
					}()
				}
			},
		}, {
			Name:   "FlattenN",
			Params: []kind{topKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				xs, depth := c.value(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var flattenN func(Value, int) ([]Value, error)
						flattenN = func(xs Value, depth int) ([]Value, error) {
							var res []Value
							iter, err := xs.List()
							if err != nil {
								return nil, err
							}
							for iter.Next() {
								val, _ := iter.Value().Default()
								if val.Kind() == ListKind && depth != 0 {
									d := depth - 1
									values, err := flattenN(val, d)
									if err != nil {
										return nil, err
									}
									res = append(res, values...)
								} else {
									res = append(res, val)
								}
							}
							return res, nil
						}
						return flattenN(xs, depth)
					}()
				}
			},
		}, {
			Name:   "Take",
			Params: []kind{listKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				x, n := c.list(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if n < 0 {
							return nil, fmt.Errorf("negative index")
						}

						if n > len(x) {
							return x, nil
						}

						return x[:n], nil
					}()
				}
			},
		}, {
			Name:   "Slice",
			Params: []kind{listKind, intKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				x, i, j := c.list(0), c.int(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if i < 0 {
							return nil, fmt.Errorf("negative index")
						}

						if i > j {
							return nil, fmt.Errorf("invalid index: %v > %v", i, j)
						}

						if i > len(x) {
							return nil, fmt.Errorf("slice bounds out of range")
						}

						if j > len(x) {
							return nil, fmt.Errorf("slice bounds out of range")
						}

						return x[i:j], nil
					}()
				}
			},
		}, {
			Name:   "MinItems",
			Params: []kind{listKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				a, n := c.list(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return len(a) >= n
					}()
				}
			},
		}, {
			Name:   "MaxItems",
			Params: []kind{listKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				a, n := c.list(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return len(a) <= n
					}()
				}
			},
		}, {
			Name:   "UniqueItems",
			Params: []kind{listKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				a := c.list(0)
				if c.do() {
					c.ret = func() interface{} {
						b := []string{}
						for _, v := range a {
							b = append(b, fmt.Sprint(v))
						}
						sort.Strings(b)
						for i := 1; i < len(b); i++ {
							if b[i-1] == b[i] {
								return false
							}
						}
						return true
					}()
				}
			},
		}, {
			Name:   "Contains",
			Params: []kind{listKind, topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				a, v := c.list(0), c.value(1)
				if c.do() {
					c.ret = func() interface{} {
						for _, w := range a {
							if v.Equals(w) {
								return true
							}
						}
						return false
					}()
				}
			},
		}, {
			Name:   "Avg",
			Params: []kind{listKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				xs := c.decimalList(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if 0 == len(xs) {
							return nil, fmt.Errorf("empty list")
						}

						s := apd.New(0, 0)
						for _, x := range xs {
							_, err := internal.BaseContext.Add(s, x, s)
							if err != nil {
								return nil, err
							}
						}

						var d apd.Decimal
						l := apd.New(int64(len(xs)), 0)
						_, err := internal.BaseContext.Quo(&d, s, l)
						if err != nil {
							return nil, err
						}
						return &d, nil
					}()
				}
			},
		}, {
			Name:   "Max",
			Params: []kind{listKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				xs := c.decimalList(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if 0 == len(xs) {
							return nil, fmt.Errorf("empty list")
						}

						max := xs[0]
						for _, x := range xs[1:] {
							if -1 == max.Cmp(x) {
								max = x
							}
						}
						return max, nil
					}()
				}
			},
		}, {
			Name:   "Min",
			Params: []kind{listKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				xs := c.decimalList(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if 0 == len(xs) {
							return nil, fmt.Errorf("empty list")
						}

						min := xs[0]
						for _, x := range xs[1:] {
							if +1 == min.Cmp(x) {
								min = x
							}
						}
						return min, nil
					}()
				}
			},
		}, {
			Name:   "Product",
			Params: []kind{listKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				xs := c.decimalList(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						d := apd.New(1, 0)
						for _, x := range xs {
							_, err := internal.BaseContext.Mul(d, x, d)
							if err != nil {
								return nil, err
							}
						}
						return d, nil
					}()
				}
			},
		}, {
			Name:   "Range",
			Params: []kind{numKind, numKind, numKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				start, limit, step := c.decimal(0), c.decimal(1), c.decimal(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if step.IsZero() {
							return nil, fmt.Errorf("step must be non zero")
						}

						if !step.Negative && +1 == start.Cmp(limit) {
							return nil, fmt.Errorf("end must be greater than start when step is positive")
						}

						if step.Negative && -1 == start.Cmp(limit) {
							return nil, fmt.Errorf("end must be less than start when step is negative")
						}

						var vals []*internal.Decimal
						num := start
						for {
							if !step.Negative && -1 != num.Cmp(limit) {
								break
							}

							if step.Negative && +1 != num.Cmp(limit) {
								break
							}

							vals = append(vals, num)
							d := apd.New(0, 0)
							_, err := internal.BaseContext.Add(d, step, num)
							if err != nil {
								return nil, err
							}
							num = d
						}
						return vals, nil
					}()
				}
			},
		}, {
			Name:   "Sum",
			Params: []kind{listKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				xs := c.decimalList(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						d := apd.New(0, 0)
						for _, x := range xs {
							_, err := internal.BaseContext.Add(d, x, d)
							if err != nil {
								return nil, err
							}
						}
						return d, nil
					}()
				}
			},
		}, {
			Name:   "Sort",
			Params: []kind{listKind, topKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				list, cmp := c.list(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						s := valueSorter{list, cmp, nil}

						sort.Sort(&s)
						return s.ret()
					}()
				}
			},
		}, {
			Name:   "SortStable",
			Params: []kind{listKind, topKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				list, cmp := c.list(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						s := valueSorter{list, cmp, nil}
						sort.Stable(&s)
						return s.ret()
					}()
				}
			},
		}, {
			Name:   "SortStrings",
			Params: []kind{listKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				a := c.strList(0)
				if c.do() {
					c.ret = func() interface{} {
						sort.Strings(a)
						return a
					}()
				}
			},
		}, {
			Name:   "IsSorted",
			Params: []kind{listKind, topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				list, cmp := c.list(0), c.value(1)
				if c.do() {
					c.ret = func() interface{} {
						s := valueSorter{list, cmp, nil}
						return sort.IsSorted(&s)
					}()
				}
			},
		}, {
			Name:   "IsSortedStrings",
			Params: []kind{listKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				a := c.strList(0)
				if c.do() {
					c.ret = func() interface{} {
						return sort.StringsAreSorted(a)
					}()
				}
			},
		}},
		cue: `{
	Comparer: {
		T:    _
		less: bool
		x:    T
		y:    T
	}
	Ascending: {
		T:    number | string
		less: true && x < y
		x:    T
		y:    T
		Comparer
	}
	Descending: {
		T:    number | string
		less: x > y
		x:    T
		y:    T
		Comparer
	}
}`,
	},
	"math": {
		native: []*builtin{{
			Name:  "MaxExp",
			Const: "2147483647",
		}, {
			Name:  "MinExp",
			Const: "-2147483648",
		}, {
			Name:  "MaxPrec",
			Const: "4294967295",
		}, {
			Name:  "ToNearestEven",
			Const: "0",
		}, {
			Name:  "ToNearestAway",
			Const: "1",
		}, {
			Name:  "ToZero",
			Const: "2",
		}, {
			Name:  "AwayFromZero",
			Const: "3",
		}, {
			Name:  "ToNegativeInf",
			Const: "4",
		}, {
			Name:  "ToPositiveInf",
			Const: "5",
		}, {
			Name:  "Below",
			Const: "-1",
		}, {
			Name:  "Exact",
			Const: "0",
		}, {
			Name:  "Above",
			Const: "1",
		}, {
			Name:   "Jacobi",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x, y := c.bigInt(0), c.bigInt(1)
				if c.do() {
					c.ret = func() interface{} {
						return big.Jacobi(x, y)
					}()
				}
			},
		}, {
			Name:  "MaxBase",
			Const: "62",
		}, {
			Name:   "Floor",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Floor(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Ceil",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Ceil(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Trunc",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := roundTruncContext.RoundToIntegralExact(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Round",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := roundUpContext.RoundToIntegralExact(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "RoundToEven",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := roundEvenContext.RoundToIntegralExact(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "MultipleOf",
			Params: []kind{numKind, numKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				x, y := c.decimal(0), c.decimal(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d apd.Decimal
						cond, err := mulContext.Quo(&d, x, y)
						return !cond.Inexact(), err
					}()
				}
			},
		}, {
			Name:   "Abs",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Abs(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Acosh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Acosh(x)
					}()
				}
			},
		}, {
			Name:   "Asin",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Asin(x)
					}()
				}
			},
		}, {
			Name:   "Acos",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Acos(x)
					}()
				}
			},
		}, {
			Name:   "Asinh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Asinh(x)
					}()
				}
			},
		}, {
			Name:   "Atan",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Atan(x)
					}()
				}
			},
		}, {
			Name:   "Atan2",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				y, x := c.float64(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Atan2(y, x)
					}()
				}
			},
		}, {
			Name:   "Atanh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Atanh(x)
					}()
				}
			},
		}, {
			Name:   "Cbrt",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Cbrt(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:  "E",
			Const: "2.71828182845904523536028747135266249775724709369995957496696763",
		}, {
			Name:  "Pi",
			Const: "3.14159265358979323846264338327950288419716939937510582097494459",
		}, {
			Name:  "Phi",
			Const: "1.61803398874989484820458683436563811772030917980576286213544861",
		}, {
			Name:  "Sqrt2",
			Const: "1.41421356237309504880168872420969807856967187537694807317667974",
		}, {
			Name:  "SqrtE",
			Const: "1.64872127070012814684865078781416357165377610071014801157507931",
		}, {
			Name:  "SqrtPi",
			Const: "1.77245385090551602729816748334114518279754945612238712821380779",
		}, {
			Name:  "SqrtPhi",
			Const: "1.27201964951406896425242246173749149171560804184009624861664038",
		}, {
			Name:  "Ln2",
			Const: "0.693147180559945309417232121458176568075500134360255254120680009",
		}, {
			Name:  "Log2E",
			Const: "1.442695040888963407359924681001892137426645954152985934135449408",
		}, {
			Name:  "Ln10",
			Const: "2.3025850929940456840179914546843642076011014886287729760333278",
		}, {
			Name:  "Log10E",
			Const: "0.43429448190325182765112891891660508229439700580366656611445378",
		}, {
			Name:   "Copysign",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x, y := c.decimal(0), c.decimal(1)
				if c.do() {
					c.ret = func() interface{} {
						var d internal.Decimal
						d.Set(x)
						d.Negative = y.Negative
						return &d
					}()
				}
			},
		}, {
			Name:   "Dim",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x, y := c.decimal(0), c.decimal(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Sub(&d, x, y)
						if err != nil {
							return nil, err
						}
						if d.Negative {
							return zero, nil
						}
						return &d, nil
					}()
				}
			},
		}, {
			Name:   "Erf",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Erf(x)
					}()
				}
			},
		}, {
			Name:   "Erfc",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Erfc(x)
					}()
				}
			},
		}, {
			Name:   "Erfinv",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Erfinv(x)
					}()
				}
			},
		}, {
			Name:   "Erfcinv",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Erfcinv(x)
					}()
				}
			},
		}, {
			Name:   "Exp",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Exp(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Exp2",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Pow(&d, two, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Expm1",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Expm1(x)
					}()
				}
			},
		}, {
			Name:   "Gamma",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Gamma(x)
					}()
				}
			},
		}, {
			Name:   "Hypot",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				p, q := c.float64(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Hypot(p, q)
					}()
				}
			},
		}, {
			Name:   "J0",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.J0(x)
					}()
				}
			},
		}, {
			Name:   "Y0",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Y0(x)
					}()
				}
			},
		}, {
			Name:   "J1",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.J1(x)
					}()
				}
			},
		}, {
			Name:   "Y1",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Y1(x)
					}()
				}
			},
		}, {
			Name:   "Jn",
			Params: []kind{intKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				n, x := c.int(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Jn(n, x)
					}()
				}
			},
		}, {
			Name:   "Yn",
			Params: []kind{intKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				n, x := c.int(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Yn(n, x)
					}()
				}
			},
		}, {
			Name:   "Ldexp",
			Params: []kind{numKind, intKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				frac, exp := c.float64(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Ldexp(frac, exp)
					}()
				}
			},
		}, {
			Name:   "Log",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Ln(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Log10",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Log10(&d, x)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Log2",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d, ln2 internal.Decimal
						_, _ = apdContext.Ln(&ln2, two)
						_, err := apdContext.Ln(&d, x)
						if err != nil {
							return &d, err
						}
						_, err = apdContext.Quo(&d, &d, &ln2)
						return &d, nil
					}()
				}
			},
		}, {
			Name:   "Log1p",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Log1p(x)
					}()
				}
			},
		}, {
			Name:   "Logb",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Logb(x)
					}()
				}
			},
		}, {
			Name:   "Ilogb",
			Params: []kind{numKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Ilogb(x)
					}()
				}
			},
		}, {
			Name:   "Mod",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x, y := c.float64(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Mod(x, y)
					}()
				}
			},
		}, {
			Name:   "Pow",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x, y := c.decimal(0), c.decimal(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var d internal.Decimal
						_, err := apdContext.Pow(&d, x, y)
						return &d, err
					}()
				}
			},
		}, {
			Name:   "Pow10",
			Params: []kind{intKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				n := c.int32(0)
				if c.do() {
					c.ret = func() interface{} {
						return apd.New(1, n)
					}()
				}
			},
		}, {
			Name:   "Remainder",
			Params: []kind{numKind, numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x, y := c.float64(0), c.float64(1)
				if c.do() {
					c.ret = func() interface{} {
						return math.Remainder(x, y)
					}()
				}
			},
		}, {
			Name:   "Signbit",
			Params: []kind{numKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				x := c.decimal(0)
				if c.do() {
					c.ret = func() interface{} {
						return x.Negative
					}()
				}
			},
		}, {
			Name:   "Cos",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Cos(x)
					}()
				}
			},
		}, {
			Name:   "Sin",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Sin(x)
					}()
				}
			},
		}, {
			Name:   "Sinh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Sinh(x)
					}()
				}
			},
		}, {
			Name:   "Cosh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Cosh(x)
					}()
				}
			},
		}, {
			Name:   "Sqrt",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Sqrt(x)
					}()
				}
			},
		}, {
			Name:   "Tan",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Tan(x)
					}()
				}
			},
		}, {
			Name:   "Tanh",
			Params: []kind{numKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				x := c.float64(0)
				if c.do() {
					c.ret = func() interface{} {
						return math.Tanh(x)
					}()
				}
			},
		}},
	},
	"math/bits": {
		native: []*builtin{{
			Name:   "Lsh",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x, n := c.bigInt(0), c.uint(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.Lsh(x, n)
						return &z
					}()
				}
			},
		}, {
			Name:   "Rsh",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x, n := c.bigInt(0), c.uint(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.Rsh(x, n)
						return &z
					}()
				}
			},
		}, {
			Name:   "At",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x, i := c.bigInt(0), c.uint(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if i > math.MaxInt32 {
							return 0, fmt.Errorf("bit index too large")
						}
						return x.Bit(int(i)), nil
					}()
				}
			},
		}, {
			Name:   "Set",
			Params: []kind{intKind, intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x, i, bit := c.bigInt(0), c.int(1), c.uint(2)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.SetBit(x, i, bit)
						return &z
					}()
				}
			},
		}, {
			Name:   "And",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				a, b := c.bigInt(0), c.bigInt(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.And(a, b)
						return &z
					}()
				}
			},
		}, {
			Name:   "Or",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				a, b := c.bigInt(0), c.bigInt(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.Or(a, b)
						return &z
					}()
				}
			},
		}, {
			Name:   "Xor",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				a, b := c.bigInt(0), c.bigInt(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.Xor(a, b)
						return &z
					}()
				}
			},
		}, {
			Name:   "Clear",
			Params: []kind{intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				a, b := c.bigInt(0), c.bigInt(1)
				if c.do() {
					c.ret = func() interface{} {
						var z big.Int
						z.AndNot(a, b)
						return &z
					}()
				}
			},
		}, {
			Name:   "OnesCount",
			Params: []kind{intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x := c.bigInt(0)
				if c.do() {
					c.ret = func() interface{} {
						var count int
						for _, w := range x.Bits() {
							count += bits.OnesCount64(uint64(w))
						}
						return count
					}()
				}
			},
		}, {
			Name:   "Len",
			Params: []kind{intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				x := c.bigInt(0)
				if c.do() {
					c.ret = func() interface{} {
						return x.BitLen()
					}()
				}
			},
		}},
	},
	"net": {
		native: []*builtin{{
			Name:   "SplitHostPort",
			Params: []kind{stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						host, port, err := net.SplitHostPort(s)
						if err != nil {
							return nil, err
						}
						return []string{host, port}, nil
					}()
				}
			},
		}, {
			Name:   "JoinHostPort",
			Params: []kind{topKind, topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				host, port := c.value(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						var err error
						hostStr := ""
						switch host.Kind() {
						case ListKind:
							ipdata := netGetIP(host)
							if len(ipdata) != 4 && len(ipdata) != 16 {
								err = fmt.Errorf("invalid host %q", host)
							}
							hostStr = ipdata.String()
						case BytesKind:
							var b []byte
							b, err = host.Bytes()
							hostStr = string(b)
						default:
							hostStr, err = host.String()
						}
						if err != nil {
							return "", err
						}

						portStr := ""
						switch port.Kind() {
						case StringKind:
							portStr, err = port.String()
						case BytesKind:
							var b []byte
							b, err = port.Bytes()
							portStr = string(b)
						default:
							var i int64
							i, err = port.Int64()
							portStr = strconv.Itoa(int(i))
						}
						if err != nil {
							return "", err
						}

						return net.JoinHostPort(hostStr, portStr), nil
					}()
				}
			},
		}, {
			Name:   "FQDN",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						for i := 0; i < len(s); i++ {
							if s[i] >= utf8.RuneSelf {
								return false
							}
						}
						_, err := idnaProfile.ToASCII(s)
						return err == nil
					}()
				}
			},
		}, {
			Name:  "IPv4len",
			Const: "4",
		}, {
			Name:  "IPv6len",
			Const: "16",
		}, {
			Name:   "ParseIP",
			Params: []kind{stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						goip := net.ParseIP(s)
						if goip == nil {
							return nil, fmt.Errorf("invalid IP address %q", s)
						}
						return netToList(goip), nil
					}()
				}
			},
		}, {
			Name:   "IPv4",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {

						return netGetIP(ip).To4() != nil
					}()
				}
			},
		}, {
			Name:   "IP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {

						return netGetIP(ip) != nil
					}()
				}
			},
		}, {
			Name:   "LoopbackIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsLoopback()
					}()
				}
			},
		}, {
			Name:   "MulticastIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsMulticast()
					}()
				}
			},
		}, {
			Name:   "InterfaceLocalMulticastIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsInterfaceLocalMulticast()
					}()
				}
			},
		}, {
			Name:   "LinkLocalMulticastIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsLinkLocalMulticast()
					}()
				}
			},
		}, {
			Name:   "LinkLocalUnicastIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsLinkLocalUnicast()
					}()
				}
			},
		}, {
			Name:   "GlobalUnicastIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsGlobalUnicast()
					}()
				}
			},
		}, {
			Name:   "UnspecifiedIP",
			Params: []kind{topKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret = func() interface{} {
						return netGetIP(ip).IsUnspecified()
					}()
				}
			},
		}, {
			Name:   "ToIP4",
			Params: []kind{topKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						ipdata := netGetIP(ip)
						if ipdata == nil {
							return nil, fmt.Errorf("invalid IP %q", ip)
						}
						ipv4 := ipdata.To4()
						if ipv4 == nil {
							return nil, fmt.Errorf("cannot convert %q to IPv4", ipdata)
						}
						return netToList(ipv4), nil
					}()
				}
			},
		}, {
			Name:   "ToIP16",
			Params: []kind{topKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						ipdata := netGetIP(ip)
						if ipdata == nil {
							return nil, fmt.Errorf("invalid IP %q", ip)
						}
						return netToList(ipdata), nil
					}()
				}
			},
		}, {
			Name:   "IPString",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				ip := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						ipdata := netGetIP(ip)
						if ipdata == nil {
							return "", fmt.Errorf("invalid IP %q", ip)
						}
						return ipdata.String(), nil
					}()
				}
			},
		}},
	},
	"path": {
		native: []*builtin{{
			Name:   "Split",
			Params: []kind{stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						file, dir := split(path)
						return []string{file, dir}
					}()
				}
			},
		}, {
			Name:   "Match",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				pattern, name := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return path.Match(pattern, name)
					}()
				}
			},
		}, {
			Name:   "Clean",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return pathClean(path)
					}()
				}
			},
		}, {
			Name:   "Ext",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return pathExt(path)
					}()
				}
			},
		}, {
			Name:   "Base",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return pathBase(path)
					}()
				}
			},
		}, {
			Name:   "IsAbs",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return pathIsAbs(path)
					}()
				}
			},
		}, {
			Name:   "Dir",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				path := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return pathDir(path)
					}()
				}
			},
		}},
	},
	"regexp": {
		native: []*builtin{{
			Name:   "Valid",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				pattern := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						_, err := regexp.Compile(pattern)
						return err == nil, err
					}()
				}
			},
		}, {
			Name:   "Find",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				pattern, s := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return "", err
						}
						m := re.FindStringIndex(s)
						if m == nil {
							return "", errNoMatch
						}
						return s[m[0]:m[1]], nil
					}()
				}
			},
		}, {
			Name:   "FindAll",
			Params: []kind{stringKind, stringKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				pattern, s, n := c.string(0), c.string(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return nil, err
						}
						m := re.FindAllString(s, n)
						if m == nil {
							return nil, errNoMatch
						}
						return m, nil
					}()
				}
			},
		}, {
			Name:   "FindSubmatch",
			Params: []kind{stringKind, stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				pattern, s := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return nil, err
						}
						m := re.FindStringSubmatch(s)
						if m == nil {
							return nil, errNoMatch
						}
						return m, nil
					}()
				}
			},
		}, {
			Name:   "FindAllSubmatch",
			Params: []kind{stringKind, stringKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				pattern, s, n := c.string(0), c.string(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return nil, err
						}
						m := re.FindAllStringSubmatch(s, n)
						if m == nil {
							return nil, errNoMatch
						}
						return m, nil
					}()
				}
			},
		}, {
			Name:   "FindNamedSubmatch",
			Params: []kind{stringKind, stringKind},
			Result: structKind,
			Func: func(c *callCtxt) {
				pattern, s := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return nil, err
						}
						names := re.SubexpNames()
						if len(names) == 0 {
							return nil, errNoNamedGroup
						}
						m := re.FindStringSubmatch(s)
						if m == nil {
							return nil, errNoMatch
						}
						r := make(map[string]string, len(names)-1)
						for k, name := range names {
							if name != "" {
								r[name] = m[k]
							}
						}
						return r, nil
					}()
				}
			},
		}, {
			Name:   "FindAllNamedSubmatch",
			Params: []kind{stringKind, stringKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				pattern, s, n := c.string(0), c.string(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						re, err := regexp.Compile(pattern)
						if err != nil {
							return nil, err
						}
						names := re.SubexpNames()
						if len(names) == 0 {
							return nil, errNoNamedGroup
						}
						m := re.FindAllStringSubmatch(s, n)
						if m == nil {
							return nil, errNoMatch
						}
						result := make([]map[string]string, len(m))
						for i, m := range m {
							r := make(map[string]string, len(names)-1)
							for k, name := range names {
								if name != "" {
									r[name] = m[k]
								}
							}
							result[i] = r
						}
						return result, nil
					}()
				}
			},
		}, {
			Name:   "Match",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				pattern, s := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return regexp.MatchString(pattern, s)
					}()
				}
			},
		}, {
			Name:   "QuoteMeta",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return regexp.QuoteMeta(s)
					}()
				}
			},
		}},
	},
	"strconv": {
		native: []*builtin{{
			Name:   "Unquote",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return literal.Unquote(s)
					}()
				}
			},
		}, {
			Name:   "ParseBool",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				str := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return strconv.ParseBool(str)
					}()
				}
			},
		}, {
			Name:   "FormatBool",
			Params: []kind{boolKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				b := c.bool(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.FormatBool(b)
					}()
				}
			},
		}, {
			Name:   "ParseFloat",
			Params: []kind{stringKind, intKind},
			Result: numKind,
			Func: func(c *callCtxt) {
				s, bitSize := c.string(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return strconv.ParseFloat(s, bitSize)
					}()
				}
			},
		}, {
			Name:  "IntSize",
			Const: "64",
		}, {
			Name:   "ParseUint",
			Params: []kind{stringKind, intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, base, bitSize := c.string(0), c.int(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return strconv.ParseUint(s, base, bitSize)
					}()
				}
			},
		}, {
			Name:   "ParseInt",
			Params: []kind{stringKind, intKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, base, bitSize := c.string(0), c.int(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return strconv.ParseInt(s, base, bitSize)
					}()
				}
			},
		}, {
			Name:   "Atoi",
			Params: []kind{stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return strconv.Atoi(s)
					}()
				}
			},
		}, {
			Name:   "FormatFloat",
			Params: []kind{numKind, intKind, intKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				f, fmt, prec, bitSize := c.float64(0), c.byte(1), c.int(2), c.int(3)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.FormatFloat(f, fmt, prec, bitSize)
					}()
				}
			},
		}, {
			Name:   "FormatUint",
			Params: []kind{intKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				i, base := c.uint64(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.FormatUint(i, base)
					}()
				}
			},
		}, {
			Name:   "FormatInt",
			Params: []kind{intKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				i, base := c.int64(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.FormatInt(i, base)
					}()
				}
			},
		}, {
			Name:   "Quote",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.Quote(s)
					}()
				}
			},
		}, {
			Name:   "QuoteToASCII",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.QuoteToASCII(s)
					}()
				}
			},
		}, {
			Name:   "QuoteToGraphic",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.QuoteToGraphic(s)
					}()
				}
			},
		}, {
			Name:   "QuoteRune",
			Params: []kind{intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				r := c.rune(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.QuoteRune(r)
					}()
				}
			},
		}, {
			Name:   "QuoteRuneToASCII",
			Params: []kind{intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				r := c.rune(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.QuoteRuneToASCII(r)
					}()
				}
			},
		}, {
			Name:   "QuoteRuneToGraphic",
			Params: []kind{intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				r := c.rune(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.QuoteRuneToGraphic(r)
					}()
				}
			},
		}, {
			Name:   "IsPrint",
			Params: []kind{intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				r := c.rune(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.IsPrint(r)
					}()
				}
			},
		}, {
			Name:   "IsGraphic",
			Params: []kind{intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				r := c.rune(0)
				if c.do() {
					c.ret = func() interface{} {
						return strconv.IsGraphic(r)
					}()
				}
			},
		}},
	},
	"strings": {
		native: []*builtin{{
			Name:   "ByteAt",
			Params: []kind{bytesKind | stringKind, intKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				b, i := c.bytes(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if i < 0 || i >= len(b) {
							return 0, fmt.Errorf("index out of range")
						}
						return b[i], nil
					}()
				}
			},
		}, {
			Name:   "ByteSlice",
			Params: []kind{bytesKind | stringKind, intKind, intKind},
			Result: bytesKind | stringKind,
			Func: func(c *callCtxt) {
				b, start, end := c.bytes(0), c.int(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if start < 0 || start > end || end > len(b) {
							return nil, fmt.Errorf("index out of range")
						}
						return b[start:end], nil
					}()
				}
			},
		}, {
			Name:   "Runes",
			Params: []kind{stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return []rune(s)
					}()
				}
			},
		}, {
			Name:   "MinRunes",
			Params: []kind{stringKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, min := c.string(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {

						return len([]rune(s)) >= min
					}()
				}
			},
		}, {
			Name:   "MaxRunes",
			Params: []kind{stringKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, max := c.string(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {

						return len([]rune(s)) <= max
					}()
				}
			},
		}, {
			Name:   "ToTitle",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {

						prev := ' '
						return strings.Map(
							func(r rune) rune {
								if unicode.IsSpace(prev) {
									prev = r
									return unicode.ToTitle(r)
								}
								prev = r
								return r
							},
							s)
					}()
				}
			},
		}, {
			Name:   "ToCamel",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {

						prev := ' '
						return strings.Map(
							func(r rune) rune {
								if unicode.IsSpace(prev) {
									prev = r
									return unicode.ToLower(r)
								}
								prev = r
								return r
							},
							s)
					}()
				}
			},
		}, {
			Name:   "SliceRunes",
			Params: []kind{stringKind, intKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, start, end := c.string(0), c.int(1), c.int(2)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						runes := []rune(s)
						if start < 0 || start > end || end > len(runes) {
							return "", fmt.Errorf("index out of range")
						}
						return string(runes[start:end]), nil
					}()
				}
			},
		}, {
			Name:   "Compare",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				a, b := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Compare(a, b)
					}()
				}
			},
		}, {
			Name:   "Count",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, substr := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Count(s, substr)
					}()
				}
			},
		}, {
			Name:   "Contains",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, substr := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Contains(s, substr)
					}()
				}
			},
		}, {
			Name:   "ContainsAny",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, chars := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.ContainsAny(s, chars)
					}()
				}
			},
		}, {
			Name:   "LastIndex",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, substr := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.LastIndex(s, substr)
					}()
				}
			},
		}, {
			Name:   "IndexAny",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, chars := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.IndexAny(s, chars)
					}()
				}
			},
		}, {
			Name:   "LastIndexAny",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, chars := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.LastIndexAny(s, chars)
					}()
				}
			},
		}, {
			Name:   "SplitN",
			Params: []kind{stringKind, stringKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s, sep, n := c.string(0), c.string(1), c.int(2)
				if c.do() {
					c.ret = func() interface{} {
						return strings.SplitN(s, sep, n)
					}()
				}
			},
		}, {
			Name:   "SplitAfterN",
			Params: []kind{stringKind, stringKind, intKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s, sep, n := c.string(0), c.string(1), c.int(2)
				if c.do() {
					c.ret = func() interface{} {
						return strings.SplitAfterN(s, sep, n)
					}()
				}
			},
		}, {
			Name:   "Split",
			Params: []kind{stringKind, stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s, sep := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Split(s, sep)
					}()
				}
			},
		}, {
			Name:   "SplitAfter",
			Params: []kind{stringKind, stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s, sep := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.SplitAfter(s, sep)
					}()
				}
			},
		}, {
			Name:   "Fields",
			Params: []kind{stringKind},
			Result: listKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Fields(s)
					}()
				}
			},
		}, {
			Name:   "Join",
			Params: []kind{listKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				elems, sep := c.strList(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Join(elems, sep)
					}()
				}
			},
		}, {
			Name:   "HasPrefix",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, prefix := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.HasPrefix(s, prefix)
					}()
				}
			},
		}, {
			Name:   "HasSuffix",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s, suffix := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.HasSuffix(s, suffix)
					}()
				}
			},
		}, {
			Name:   "Repeat",
			Params: []kind{stringKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, count := c.string(0), c.int(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Repeat(s, count)
					}()
				}
			},
		}, {
			Name:   "ToUpper",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strings.ToUpper(s)
					}()
				}
			},
		}, {
			Name:   "ToLower",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strings.ToLower(s)
					}()
				}
			},
		}, {
			Name:   "Trim",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, cutset := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Trim(s, cutset)
					}()
				}
			},
		}, {
			Name:   "TrimLeft",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, cutset := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.TrimLeft(s, cutset)
					}()
				}
			},
		}, {
			Name:   "TrimRight",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, cutset := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.TrimRight(s, cutset)
					}()
				}
			},
		}, {
			Name:   "TrimSpace",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return strings.TrimSpace(s)
					}()
				}
			},
		}, {
			Name:   "TrimPrefix",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, prefix := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.TrimPrefix(s, prefix)
					}()
				}
			},
		}, {
			Name:   "TrimSuffix",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, suffix := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.TrimSuffix(s, suffix)
					}()
				}
			},
		}, {
			Name:   "Replace",
			Params: []kind{stringKind, stringKind, stringKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s, old, new, n := c.string(0), c.string(1), c.string(2), c.int(3)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Replace(s, old, new, n)
					}()
				}
			},
		}, {
			Name:   "Index",
			Params: []kind{stringKind, stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s, substr := c.string(0), c.string(1)
				if c.do() {
					c.ret = func() interface{} {
						return strings.Index(s, substr)
					}()
				}
			},
		}},
	},
	"struct": {
		native: []*builtin{{
			Name:   "MinFields",
			Params: []kind{structKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				object, n := c.structVal(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						iter := object.Fields(Hidden(false), Optional(false))
						count := 0
						for iter.Next() {
							count++
						}
						return count >= n, nil
					}()
				}
			},
		}, {
			Name:   "MaxFields",
			Params: []kind{structKind, intKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				object, n := c.structVal(0), c.int(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						iter := object.Fields(Hidden(false), Optional(false))
						count := 0
						for iter.Next() {
							count++
						}
						return count <= n, nil
					}()
				}
			},
		}},
	},
	"text/tabwriter": {
		native: []*builtin{{
			Name:   "Write",
			Params: []kind{topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				data := c.value(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						buf := &bytes.Buffer{}
						tw := tabwriter.NewWriter(buf, 0, 4, 1, ' ', 0)

						write := func(v Value) error {
							b, err := v.Bytes()
							if err != nil {
								return err
							}
							_, err = tw.Write(b)
							if err != nil {
								return err
							}
							return nil
						}

						switch data.Kind() {
						case BytesKind, StringKind:
							if err := write(data); err != nil {
								return "", err
							}
						case ListKind:
							for i, _ := data.List(); i.Next(); {
								if err := write(i.Value()); err != nil {
									return "", err
								}
								_, _ = tw.Write([]byte{'\n'})
							}
						default:
							return "", fmt.Errorf("tabwriter.Write: unsupported type %v", data.Kind())
						}

						err := tw.Flush()
						return buf.String(), err
					}()
				}
			},
		}},
	},
	"text/template": {
		native: []*builtin{{
			Name:   "Execute",
			Params: []kind{stringKind, topKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				templ, data := c.string(0), c.value(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						t, err := template.New("").Parse(templ)
						if err != nil {
							return "", err
						}
						var x interface{}
						if err := data.Decode(&x); err != nil {
							return "", err
						}
						buf := &bytes.Buffer{}
						if err := t.Execute(buf, x); err != nil {
							return "", err
						}
						return buf.String(), nil
					}()
				}
			},
		}, {
			Name:   "HTMLEscape",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return template.HTMLEscapeString(s)
					}()
				}
			},
		}, {
			Name:   "JSEscape",
			Params: []kind{stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret = func() interface{} {
						return template.JSEscapeString(s)
					}()
				}
			},
		}},
	},
	"time": {
		native: []*builtin{{
			Name:  "Nanosecond",
			Const: "1",
		}, {
			Name:  "Microsecond",
			Const: "1000",
		}, {
			Name:  "Millisecond",
			Const: "1000000",
		}, {
			Name:  "Second",
			Const: "1000000000",
		}, {
			Name:  "Minute",
			Const: "60000000000",
		}, {
			Name:  "Hour",
			Const: "3600000000000",
		}, {
			Name:   "Duration",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						if _, err := time.ParseDuration(s); err != nil {
							return false, err
						}
						return true, nil
					}()
				}
			},
		}, {
			Name:   "ParseDuration",
			Params: []kind{stringKind},
			Result: intKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						d, err := time.ParseDuration(s)
						if err != nil {
							return 0, err
						}
						return int64(d), nil
					}()
				}
			},
		}, {
			Name:  "ANSIC",
			Const: "\"Mon Jan _2 15:04:05 2006\"",
		}, {
			Name:  "UnixDate",
			Const: "\"Mon Jan _2 15:04:05 MST 2006\"",
		}, {
			Name:  "RubyDate",
			Const: "\"Mon Jan 02 15:04:05 -0700 2006\"",
		}, {
			Name:  "RFC822",
			Const: "\"02 Jan 06 15:04 MST\"",
		}, {
			Name:  "RFC822Z",
			Const: "\"02 Jan 06 15:04 -0700\"",
		}, {
			Name:  "RFC850",
			Const: "\"Monday, 02-Jan-06 15:04:05 MST\"",
		}, {
			Name:  "RFC1123",
			Const: "\"Mon, 02 Jan 2006 15:04:05 MST\"",
		}, {
			Name:  "RFC1123Z",
			Const: "\"Mon, 02 Jan 2006 15:04:05 -0700\"",
		}, {
			Name:  "RFC3339",
			Const: "\"2006-01-02T15:04:05Z07:00\"",
		}, {
			Name:  "RFC3339Nano",
			Const: "\"2006-01-02T15:04:05.999999999Z07:00\"",
		}, {
			Name:  "RFC3339Date",
			Const: "\"2006-01-02\"",
		}, {
			Name:  "Kitchen",
			Const: "\"3:04PM\"",
		}, {
			Name:  "Kitchen24",
			Const: "\"15:04\"",
		}, {
			Name:  "January",
			Const: "1",
		}, {
			Name:  "February",
			Const: "2",
		}, {
			Name:  "March",
			Const: "3",
		}, {
			Name:  "April",
			Const: "4",
		}, {
			Name:  "May",
			Const: "5",
		}, {
			Name:  "June",
			Const: "6",
		}, {
			Name:  "July",
			Const: "7",
		}, {
			Name:  "August",
			Const: "8",
		}, {
			Name:  "September",
			Const: "9",
		}, {
			Name:  "October",
			Const: "10",
		}, {
			Name:  "November",
			Const: "11",
		}, {
			Name:  "December",
			Const: "12",
		}, {
			Name:  "Sunday",
			Const: "0",
		}, {
			Name:  "Monday",
			Const: "1",
		}, {
			Name:  "Tuesday",
			Const: "2",
		}, {
			Name:  "Wednesday",
			Const: "3",
		}, {
			Name:  "Thursday",
			Const: "4",
		}, {
			Name:  "Friday",
			Const: "5",
		}, {
			Name:  "Saturday",
			Const: "6",
		}, {
			Name:   "Time",
			Params: []kind{stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				s := c.string(0)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return timeFormat(s, time.RFC3339Nano)
					}()
				}
			},
		}, {
			Name:   "Format",
			Params: []kind{stringKind, stringKind},
			Result: boolKind,
			Func: func(c *callCtxt) {
				value, layout := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						return timeFormat(value, layout)
					}()
				}
			},
		}, {
			Name:   "Parse",
			Params: []kind{stringKind, stringKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				layout, value := c.string(0), c.string(1)
				if c.do() {
					c.ret, c.err = func() (interface{}, error) {
						t, err := time.Parse(layout, value)
						if err != nil {
							return "", err
						}
						return t.UTC().Format(time.RFC3339Nano), nil
					}()
				}
			},
		}, {
			Name:   "Unix",
			Params: []kind{intKind, intKind},
			Result: stringKind,
			Func: func(c *callCtxt) {
				sec, nsec := c.int64(0), c.int64(1)
				if c.do() {
					c.ret = func() interface{} {
						t := time.Unix(sec, nsec)
						return t.UTC().Format(time.RFC3339Nano)
					}()
				}
			},
		}},
	},
	"tool": {
		native: []*builtin{},
		cue: `{
	Command: {
		$usage?: string
		$short?: string
		$long?:  string
		Tasks
	}
	Tasks: Task | {
		[name=string]: Tasks
	}
	Task: {
		$type:   "tool.Task"
		$id:     =~"\\."
		$after?: Task | [...Task]
	}
	Name: =~"^\\PL([-](\\PL|\\PN))*$"
}`,
	},
	"tool/cli": {
		native: []*builtin{},
		cue: `{
	Print: {
		$id:  *"tool/cli.Print" | "print"
		text: string
	}
}`,
	},
	"tool/exec": {
		native: []*builtin{},
		cue: `{
	Run: {
		$id: *"tool/exec.Run" | "exec"
		cmd: string | [string, ...string]
		env: {
			[string]: string | [...=~"="]
		}
		stdout:  *null | string | bytes
		stderr:  *null | string | bytes
		stdin:   *null | string | bytes
		success: bool
	}
}`,
	},
	"tool/file": {
		native: []*builtin{},
		cue: `{
	Read: {
		$id:      "tool/file.Read"
		filename: !=""
		contents: *bytes | string
	}
	Create: {
		$id:         "tool/file.Create"
		filename:    !=""
		contents:    bytes | string
		permissions: int | *420
	}
	Append: {
		$id:         "tool/file.Append"
		filename:    !=""
		contents:    bytes | string
		permissions: int | *420
	}
	Glob: {
		$id:  "tool/file.Glob"
		glob: !=""
		files: [...string]
	}
}`,
	},
	"tool/http": {
		native: []*builtin{},
		cue: `{
	Get: Do & {
		method: "GET"
	}
	Do: {
		$id:    *"tool/http.Do" | "http"
		method: string
		response: {
			body: *bytes | string
			header: {
				[string]: string | [...string]
			}
			trailer: {
				[string]: string | [...string]
			}
			status:     string
			statusCode: int
		}
		url: string
		request: {
			body: *bytes | string
			header: {
				[string]: string | [...string]
			}
			trailer: {
				[string]: string | [...string]
			}
		}
	}
	Post: Do & {
		method: "POST"
	}
	Put: Do & {
		method: "PUT"
	}
	Delete: Do & {
		method: "DELETE"
	}
}`,
	},
	"tool/os": {
		native: []*builtin{},
		cue: `{
	Name:  !="" & !~"^[$]"
	Value: bool | number | *string | null
	Setenv: {
		$id: "tool/os.Setenv"
		{[Name]: Value}
	}
	Getenv: {
		$id: "tool/os.Getenv"
		{[Name]: Value}
	}
	Environ: {
		$id: "tool/os.Environ"
		{[Name]: Value}
	}
	Clearenv: {
		$id: "tool/os.Clearenv"
	}
}`,
	},
}
