// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package config

var preCache = `{"api":[{"description":"Creates VPC offering","isasync":true,"name":"createVPCOffering","params":[{"description":"the name of the vpc offering","length":255,"name":"name","required":true,"type":"string"},{"description":"services supported by the vpc offering","length":255,"name":"supportedservices","required":true,"type":"list"},{"description":"provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network","length":255,"name":"serviceproviderlist","required":false,"type":"map"},{"description":"the display text of the vpc offering","length":255,"name":"displaytext","required":true,"type":"string"},{"description":"desired service capabilities as part of vpc offering","length":255,"name":"servicecapabilitylist","required":false,"since":"4.4","type":"map"},{"description":"the ID of the service offering for the VPC router appliance","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":false,"type":"uuid"}],"related":"updateVPCOffering,listVPCOfferings","response":[{"description":"true if vpc offering is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the id of the vpc offering","name":"id","type":"string"},{"description":"the date this vpc offering was created","name":"created","type":"date"},{"description":"the list of supported services","name":"service","response":[{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"the provider name","name":"name","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"}],"type":"list"}],"type":"list"},{"description":"state of the vpc offering. Can be Disabled/Enabled","name":"state","type":"string"},{"description":" indicated if the offering can support region level vpc","name":"supportsregionLevelvpc","type":"boolean"},{"description":"an alternate display text of the vpc offering.","name":"displaytext","type":"string"},{"description":"the name of the vpc offering","name":"name","type":"string"},{"description":" indicates if the vpc offering supports distributed router for one-hop forwarding","name":"distributedvpcrouter","type":"boolean"}]},{"description":"Creates an account from an LDAP user","isasync":false,"name":"ldapCreateAccount","params":[{"description":"User UUID, required for adding account from external provisioning system","length":255,"name":"userid","required":false,"type":"string"},{"description":"Network domain for the account's networks","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"details for account used to store specific parameters","length":255,"name":"accountdetails","required":false,"type":"map"},{"description":"Creates the account under the specified role.","length":255,"name":"roleid","related":"createRole,listRoles,updateRole","required":false,"type":"uuid"},{"description":"Creates the user under the specified account. If no account is specified, the username will be used as the account name.","length":255,"name":"account","required":false,"type":"string"},{"description":"Type of the account. Specify 0 for user, 1 for root admin, and 2 for domain admin","length":255,"name":"accounttype","required":false,"type":"short"},{"description":"Unique username.","length":255,"name":"username","required":true,"type":"string"},{"description":"Creates the user under the specified domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.","length":255,"name":"timezone","required":false,"type":"string"},{"description":"Account UUID, required for adding account from external provisioning system","length":255,"name":"accountid","required":false,"type":"string"}],"related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,lockAccount,markDefaultZoneForAccount,disableAccount","response":[{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the total number of public ip addresses allocated for this account","name":"iptotal","type":"long"},{"description":"the total number of cpu cores the account can own","name":"cpulimit","type":"string"},{"description":"the total primary storage space (in GiB) the account can own","name":"primarystoragelimit","type":"string"},{"description":"the total number of vpcs the account can own","name":"vpclimit","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the total number of snapshots which can be stored by this account","name":"snapshotlimit","type":"string"},{"description":"details for the account","name":"accountdetails","type":"map"},{"description":"the total number of networks the account can own","name":"networklimit","type":"string"},{"description":"the total memory (in MB) available to be created for this account","name":"memoryavailable","type":"string"},{"description":"the list of acl groups that account belongs to","name":"groups","type":"list"},{"description":"the total memory (in MB) owned by account","name":"memorytotal","type":"long"},{"description":"the list of users associated with account","name":"user","response":[{"description":"the secret key of the user","name":"secretkey","type":"string"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the source type of the user in lowercase, such as native, ldap, saml2","name":"usersource","type":"string"},{"description":"the account ID of the user","name":"accountid","type":"string"},{"description":"the type of the role","name":"roletype","type":"string"},{"description":"true if user is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the timezone user was created in","name":"timezone","type":"string"},{"description":"the user ID","name":"id","type":"string"},{"description":"the user firstname","name":"firstname","type":"string"},{"description":"the domain ID of the user","name":"domainid","type":"string"},{"description":"the api key of the user","name":"apikey","type":"string"},{"description":"the account name of the user","name":"account","type":"string"},{"description":"the user name","name":"username","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the boolean value representing if the updating target is in caller's child domain","name":"iscallerchilddomain","type":"boolean"},{"description":"the user email address","name":"email","type":"string"},{"description":"the date and time the user account was created","name":"created","type":"date"},{"description":"the user state","name":"state","type":"string"},{"description":"the account type of the user","name":"accounttype","type":"short"},{"description":"the user lastname","name":"lastname","type":"string"},{"description":"the domain name of the user","name":"domain","type":"string"}],"type":"list"},{"description":"the total number of templates which can be created by this account","name":"templatelimit","type":"string"},{"description":"the total number of projects the account can own","name":"projectlimit","type":"string"},{"description":"the total number of virtual machines running for this account","name":"vmrunning","type":"integer"},{"description":"name of the Domain the account belongs too","name":"domain","type":"string"},{"description":"the total number of snapshots stored by this account","name":"snapshottotal","type":"long"},{"description":"the total number of templates which have been created by this account","name":"templatetotal","type":"long"},{"description":"the state of the account","name":"state","type":"string"},{"description":"the type of the role (Admin, ResourceAdmin, DomainAdmin, User)","name":"roletype","type":"string"},{"description":"account type (admin, domain-admin, user)","name":"accounttype","type":"short"},{"description":"the total number of vpcs owned by account","name":"vpctotal","type":"long"},{"description":"the total number of public ip addresses available for this account to acquire","name":"ipavailable","type":"string"},{"description":"the total number of projects being administrated by this account","name":"projecttotal","type":"long"},{"description":"the total number of cpu cores owned by account","name":"cputotal","type":"long"},{"description":"the total primary storage space (in GiB) owned by account","name":"primarystoragetotal","type":"long"},{"description":"the total number of vpcs available to be created for this account","name":"vpcavailable","type":"string"},{"description":"the total primary storage space (in GiB) available to be used for this account","name":"primarystorageavailable","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total number of public ip addresses this account can acquire","name":"iplimit","type":"string"},{"description":"the total number of cpu cores available to be created for this account","name":"cpuavailable","type":"string"},{"description":"the total number of templates available to be created by this account","name":"templateavailable","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this account","name":"secondarystorageavailable","type":"string"},{"description":"true if the account requires cleanup","name":"iscleanuprequired","type":"boolean"},{"description":"the total number of networks available to be created for this account","name":"networkavailable","type":"string"},{"description":"id of the Domain the account belongs too","name":"domainid","type":"string"},{"description":"the total number of network traffic bytes sent","name":"sentbytes","type":"long"},{"description":"the total number of virtual machines that can be deployed by this account","name":"vmlimit","type":"string"},{"description":"the total volume available for this account","name":"volumeavailable","type":"string"},{"description":"the total number of snapshots available for this account","name":"snapshotavailable","type":"string"},{"description":"the total number of networks owned by account","name":"networktotal","type":"long"},{"description":"the total number of virtual machines deployed by this account","name":"vmtotal","type":"long"},{"description":"the total number of projects available for administration by this account","name":"projectavailable","type":"string"},{"description":"true if account is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the total number of virtual machines available for this account to acquire","name":"vmavailable","type":"string"},{"description":"the id of the account","name":"id","type":"string"},{"description":"the default zone of the account","name":"defaultzoneid","type":"string"},{"description":"the total volume which can be used by this account","name":"volumelimit","type":"string"},{"description":"the total number of network traffic bytes received","name":"receivedbytes","type":"long"},{"description":"the total memory (in MB) the account can own","name":"memorylimit","type":"string"},{"description":"the total secondary storage space (in GiB) owned by account","name":"secondarystoragetotal","type":"float"},{"description":"the total volume being used by this account","name":"volumetotal","type":"long"},{"description":"the name of the account","name":"name","type":"string"},{"description":"the total number of virtual machines stopped for this account","name":"vmstopped","type":"integer"},{"description":"the total secondary storage space (in GiB) the account can own","name":"secondarystoragelimit","type":"string"}],"since":"4.2.0"},{"description":"Creates a new Pod.","isasync":false,"name":"createPod","params":[{"description":"Allocation state of this Pod for allocation of new resources","length":255,"name":"allocationstate","required":false,"type":"string"},{"description":"the ending IP address for the Pod","length":255,"name":"endip","required":false,"type":"string"},{"description":"the starting IP address for the Pod","length":255,"name":"startip","required":true,"type":"string"},{"description":"the Zone ID in which the Pod will be created","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"},{"description":"the netmask for the Pod","length":255,"name":"netmask","required":true,"type":"string"},{"description":"the gateway for the Pod","length":255,"name":"gateway","required":true,"type":"string"},{"description":"the name of the Pod","length":255,"name":"name","required":true,"type":"string"}],"related":"updatePod,createManagementNetworkIpRange,listPods","response":[{"description":"the ending IP for the Pod","name":"endip","type":"list"},{"description":"the Zone name of the Pod","name":"zonename","type":"string"},{"description":"the allocation state of the Pod","name":"allocationstate","type":"string"},{"description":"the netmask of the Pod","name":"netmask","type":"string"},{"description":"the starting IP for the Pod","name":"startip","type":"list"},{"description":"indicates if range is dedicated for CPVM and SSVM","name":"forsystemvms","type":"list"},{"description":"indicates Vlan ID for the range","name":"vlanid","type":"list"},{"description":"the capacity of the Pod","name":"capacity","response":[{"description":"the Zone ID","name":"zoneid","type":"string"},{"description":"the Zone name","name":"zonename","type":"string"},{"description":"the total capacity available","name":"capacitytotal","type":"long"},{"description":"the Cluster ID","name":"clusterid","type":"string"},{"description":"the Cluster name","name":"clustername","type":"string"},{"description":"the percentage of capacity currently in use","name":"percentused","type":"string"},{"description":"the Pod ID","name":"podid","type":"string"},{"description":"the capacity type","name":"type","type":"short"},{"description":"the capacity currently in use","name":"capacityused","type":"long"},{"description":"the capacity currently in allocated","name":"capacityallocated","type":"long"},{"description":"the capacity name","name":"name","type":"string"},{"description":"the Pod name","name":"podname","type":"string"}],"type":"list"},{"description":"the ID of the Pod","name":"id","type":"string"},{"description":"the name of the Pod","name":"name","type":"string"},{"description":"the Zone ID of the Pod","name":"zoneid","type":"string"},{"description":"the gateway of the Pod","name":"gateway","type":"string"}]},{"description":"Safely removes raw records from cloud_usage table","isasync":false,"name":"removeRawUsageRecords","params":[{"description":"Specify the number of days (greater than zero) to remove records that are older than those number of days from today. For example, specifying 10 would result in removing all the records created before 10 days from today","length":255,"name":"interval","required":true,"type":"integer"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.6.0"},{"description":"Copies an ISO from one zone to another.","isasync":true,"name":"copyIso","params":[{"description":"ID of the zone the template is currently hosted on. If not specified and template is cross-zone, then we will sync this template to region wide image store.","length":255,"name":"sourcezoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"Template ID.","length":255,"name":"id","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,copyIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":true,"type":"uuid"},{"description":"ID of the zone the template is being copied to.","length":255,"name":"destzoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"A list of IDs of the zones that the template needs to be copied to.Specify this list if the template needs to copied to multiple zones in one go. Do not specify destzoneid and destzoneids together, however one of them is required.","length":255,"name":"destzoneids","related":"listZones,listZones,createZone,updateZone","required":false,"type":"list"}],"related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","response":[{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"the template ID","name":"id","type":"string"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"the status of the template","name":"status","type":"string"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"the template name","name":"name","type":"string"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"the tag of this template","name":"templatetag","type":"string"},{"description":"the size of the template","name":"size","type":"long"}]},{"description":"Deletes a autoscale vm profile.","isasync":true,"name":"deleteAutoScaleVmProfile","params":[{"description":"the ID of the autoscale profile","length":255,"name":"id","related":"updateAutoScaleVmProfile,listAutoScaleVmProfiles,createAutoScaleVmProfile","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Issues and propagates client certificate on a connected host/agent using configured CA plugin","isasync":true,"name":"provisionCertificate","params":[{"description":"The host/agent uuid to which the certificate has to be provisioned (issued and propagated)","length":255,"name":"hostid","related":"addHost,reconnectHost,updateHost,listHosts,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"},{"description":"Name of the CA service provider, otherwise the default configured provider plugin will be used","length":255,"name":"provider","required":false,"type":"string"},{"description":"Whether to attempt reconnection with host/agent after successful deployment of certificate. When option is not provided, configured global setting is used","length":255,"name":"reconnect","required":false,"type":"boolean"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.11.0"},{"description":"Adds an external firewall appliance","isasync":false,"name":"addExternalFirewall","params":[{"description":"URL of the external firewall appliance.","length":255,"name":"url","required":true,"type":"string"},{"description":"Username of the external firewall appliance.","length":255,"name":"username","required":true,"type":"string"},{"description":"Zone in which to add the external firewall appliance.","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"},{"description":"Password of the external firewall appliance.","length":255,"name":"password","required":true,"type":"string"}],"related":"listExternalFirewalls","response":[{"description":"the usage interface of the external firewall","name":"usageinterface","type":"string"},{"description":"the management IP address of the external firewall","name":"ipaddress","type":"string"},{"description":"the private security zone of the external firewall","name":"privatezone","type":"string"},{"description":"the username that's used to log in to the external firewall","name":"username","type":"string"},{"description":"the number of times to retry requests to the external firewall","name":"numretries","type":"string"},{"description":"the timeout (in seconds) for requests to the external firewall","name":"timeout","type":"string"},{"description":"the ID of the external firewall","name":"id","type":"string"},{"description":"the zone ID of the external firewall","name":"zoneid","type":"string"},{"description":"the public security zone of the external firewall","name":"publiczone","type":"string"},{"description":"the private interface of the external firewall","name":"privateinterface","type":"string"},{"description":"the public interface of the external firewall","name":"publicinterface","type":"string"}]},{"description":"Deletes a F5 external load balancer appliance added in a zone.","isasync":false,"name":"deleteExternalLoadBalancer","params":[{"description":"Id of the external loadbalancer appliance.","length":255,"name":"id","related":"addHost,reconnectHost,updateHost,listHosts,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists VM metrics","isasync":false,"name":"listVirtualMachinesMetrics","params":[{"description":"the target hypervisor for the template","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list by network id","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"list by the service offering","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":false,"since":"4.4","type":"uuid"},{"description":"the storage ID where vm's volumes belong to","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,updateStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"the pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"state of the virtual machine. Possible values are: Running, Stopped, Present, Destroyed, Expunged. Present is used for the state equal not destroyed.","length":255,"name":"state","required":false,"type":"string"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"the user ID that created the VM and is under the account that owns the VM","length":255,"name":"userid","related":"lockUser,createUser,getUser,enableUser,disableUser,updateUser,listUsers","required":false,"type":"uuid"},{"description":"the availability zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the host ID","length":255,"name":"hostid","related":"addHost,reconnectHost,updateHost,listHosts,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list vms by iso","length":255,"name":"isoid","required":false,"type":"uuid"},{"description":"list vms by vpc","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"the storage ID where vm's volumes belong to","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,updateStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"list vms by template","length":255,"name":"templateid","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":false,"type":"uuid"},{"description":"the ID of the virtual machine","length":255,"name":"id","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"the group ID","length":255,"name":"groupid","related":"updateInstanceGroup,createInstanceGroup,listInstanceGroups","required":false,"type":"uuid"},{"description":"list vms by affinity group","length":255,"name":"affinitygroupid","related":"createAffinityGroup,listAffinityGroups","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list vms by ssh keypair name","length":255,"name":"keypair","required":false,"type":"string"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"displayvm","required":false,"since":"4.4","type":"boolean"},{"description":"comma separated list of host details requested, value can be a list of [all, group, nics, stats, secgrp, tmpl, servoff, diskoff, iso, volume, min, affgrp]. If no parameter is passed in, the details will be defaulted to all","length":255,"name":"details","required":false,"type":"list"},{"description":"list by network type; true if need to list vms using Virtual Network, false otherwise","length":255,"name":"forvirtualnetwork","required":false,"type":"boolean"},{"description":"the IDs of the virtual machines, mutually exclusive with id","length":255,"name":"ids","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"since":"4.4","type":"list"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"the host ID","length":255,"name":"hostid","related":"addHost,reconnectHost,updateHost,listHosts,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"name of the virtual machine (a substring match is made against the parameter value, data for all matching VMs will be returned)","length":255,"name":"name","required":false,"type":"string"}],"related":"","response":[{"description":"disk write in MiB","name":"diskwrite","type":"string"},{"description":"network read in MiB","name":"networkread","type":"string"},{"description":"the VM's primary IP address","name":"ipaddress","type":"string"},{"description":"the total memory capacity in GiB","name":"memorytotal","type":"string"},{"description":"disk read in MiB","name":"diskread","type":"string"},{"description":"network write in MiB","name":"networkwrite","type":"string"},{"description":"the total disk iops","name":"diskiopstotal","type":"long"},{"description":"the total cpu capacity in Ghz","name":"cputotal","type":"string"}],"since":"4.9.3"},{"description":"Lists hosts.","isasync":false,"name":"listHosts","params":[{"description":"list hosts by its out-of-band management interface's power state. Its value can be one of [On, Off, Unknown]","length":255,"name":"outofbandmanagementpowerstate","required":false,"type":"string"},{"description":"the Pod ID for the host","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"the name of the host","length":255,"name":"name","required":false,"type":"string"},{"description":"the state of the host","length":255,"name":"state","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"hypervisor type of host: XenServer,KVM,VMware,Hyperv,BareMetal,Simulator","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"list hosts by resource state. Resource state represents current state determined by admin of host, value can be one of [Enabled, Disabled, Unmanaged, PrepareForMaintenance, ErrorInMaintenance, Maintenance, Error]","length":255,"name":"resourcestate","required":false,"type":"string"},{"description":"list hosts for which out-of-band management is enabled","length":255,"name":"outofbandmanagementenabled","required":false,"type":"boolean"},{"description":"lists hosts in the same cluster as this VM and flag hosts with enough CPU/RAm to host this VM","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the id of the host","length":255,"name":"id","related":"addHost,reconnectHost,updateHost,listHosts,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"if true, list only hosts dedicated to HA","length":255,"name":"hahost","required":false,"type":"boolean"},{"description":"comma separated list of host details requested, value can be a list of [ min, all, capacity, events, stats]","length":255,"name":"details","required":false,"type":"list"},{"description":"the host type","length":255,"name":"type","required":false,"type":"string"},{"description":"the Zone ID for the host","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"lists hosts existing in particular cluster","length":255,"name":"clusterid","related":"addCluster,listClusters,updateCluster","required":false,"type":"uuid"}],"related":"addHost,reconnectHost,updateHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","response":[{"description":"the name of the host","name":"name","type":"string"},{"description":"the cluster type of the cluster that host belongs to","name":"clustertype","type":"string"},{"description":"capabilities of the host","name":"capabilities","type":"string"},{"description":"the host HA information information","name":"hostha","type":"hostharesponse"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the admin that annotated this host","name":"username","type":"string"},{"description":"the resource state of the host","name":"resourcestate","type":"string"},{"description":"the host out-of-band management information","name":"outofbandmanagement","type":"outofbandmanagementresponse"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"the host version","name":"version","type":"string"},{"description":"the ID of the host","name":"id","type":"string"},{"description":"the amount of the host's CPU after applying the cpu.overprovisioning.factor ","name":"cpuwithoverprovisioning","type":"string"},{"description":"the date and time the host was last pinged","name":"lastpinged","type":"date"},{"description":"the last annotation set on this host by an admin","name":"annotation","type":"string"},{"description":"the amount of the host's memory currently used","name":"memoryused","type":"long"},{"description":"the cluster name of the host","name":"clustername","type":"string"},{"description":"the Zone ID of the host","name":"zoneid","type":"string"},{"description":"the Pod ID of the host","name":"podid","type":"string"},{"description":"the OS category name of the host","name":"oscategoryname","type":"string"},{"description":"the state of the host","name":"state","type":"status"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"true if the host is disconnected. False otherwise.","name":"disconnected","type":"date"},{"description":"the cpu average load on the host","name":"averageload","type":"long"},{"description":"the cluster ID of the host","name":"clusterid","type":"string"},{"description":"the memory total of the host, this parameter is deprecated use memorywithoverprovisioning","name":"memorytotal","type":"long"},{"description":"the amount of the host's memory after applying the mem.overprovisioning.factor","name":"memorywithoverprovisioning","type":"string"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"Host details in key/value pairs.","name":"details","type":"map"},{"description":"the host type","name":"type","type":"type"},{"description":"the Zone name of the host","name":"zonename","type":"string"},{"description":"the incoming network traffic on the host","name":"networkkbsread","type":"long"},{"description":"the management server ID of the host","name":"managementserverid","type":"long"},{"description":"true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise","name":"hasenoughcapacity","type":"boolean"},{"description":"the host hypervisor","name":"hypervisor","type":"hypervisortype"},{"description":"true if the host is Ha host (dedicated to vms started by HA process; false otherwise","name":"hahost","type":"boolean"},{"description":"true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise","name":"suitableformigration","type":"boolean"},{"description":"the IP address of the host","name":"ipaddress","type":"string"},{"description":"the Pod name of the host","name":"podname","type":"string"},{"description":"events available for the host","name":"events","type":"string"},{"description":"GPU cards present in the host","name":"gpugroup","response":[{"description":"the list of enabled vGPUs","name":"vgpu","response":[{"description":"Maximum Y resolution per display","name":"maxresolutiony","type":"long"},{"description":"Video RAM for this vGPU type","name":"videoram","type":"long"},{"description":"Maximum vgpu can be created with this vgpu type on the given gpu group","name":"maxcapacity","type":"long"},{"description":"Model Name of vGPU","name":"vgputype","type":"string"},{"description":"Maximum no. of vgpu per gpu card (pgpu)","name":"maxvgpuperpgpu","type":"long"},{"description":"Maximum displays per user","name":"maxheads","type":"long"},{"description":"Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type","name":"remainingcapacity","type":"long"},{"description":"Maximum X resolution per display","name":"maxresolutionx","type":"long"}],"type":"list"},{"description":"GPU cards present in the host","name":"gpugroupname","type":"string"}],"type":"list"},{"description":"the total disk size of the host","name":"disksizetotal","type":"long"},{"description":"the CPU speed of the host","name":"cpuspeed","type":"long"},{"description":"the amount of the host's CPU currently allocated","name":"cpuallocated","type":"string"},{"description":"true if local storage is active, false otherwise","name":"islocalstorageactive","type":"boolean"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"comma-separated list of tags for the host","name":"hosttags","type":"string"},{"description":"the CPU number of the host","name":"cpunumber","type":"integer"},{"description":"the number of CPU sockets on the host","name":"cpusockets","type":"integer"},{"description":"the amount of the host's CPU currently used","name":"cpuused","type":"string"},{"description":"the last time this host was annotated","name":"lastannotated","type":"date"},{"description":"the amount of the host's memory currently allocated","name":"memoryallocated","type":"long"},{"description":"the OS category ID of the host","name":"oscategoryid","type":"string"}]},{"description":"Deletes a storage pool.","isasync":false,"name":"deleteStoragePool","params":[{"description":"Force destroy storage pool (force expunge volumes in Destroyed state as a part of pool removal)","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"Storage pool id","length":255,"name":"id","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,updateStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Updates a storage pool.","isasync":false,"name":"updateStoragePool","params":[{"description":"IOPS CloudStack can provision from this storage pool","length":255,"name":"capacityiops","required":false,"type":"long"},{"description":"bytes CloudStack can provision from this storage pool","length":255,"name":"capacitybytes","required":false,"type":"long"},{"description":"the Id of the storage pool","length":255,"name":"id","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,updateStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":true,"type":"uuid"},{"description":"false to disable the pool for allocation of new volumes, true to enable it back.","length":255,"name":"enabled","required":false,"type":"boolean"},{"description":"comma-separated list of tags for the storage pool","length":255,"name":"tags","required":false,"type":"list"}],"related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","response":[{"description":"the tags for the storage pool","name":"tags","type":"string"},{"description":"the name of the storage pool","name":"name","type":"string"},{"description":"the host's currently used disk size","name":"disksizeused","type":"long"},{"description":"the hypervisor type of the storage pool","name":"hypervisor","type":"string"},{"description":"the Pod ID of the storage pool","name":"podid","type":"string"},{"description":"the storage pool capabilities","name":"storagecapabilities","type":"map"},{"description":"the Pod name of the storage pool","name":"podname","type":"string"},{"description":"the date and time the storage pool was created","name":"created","type":"date"},{"description":"the IP address of the storage pool","name":"ipaddress","type":"string"},{"description":"IOPS CloudStack can provision from this storage pool","name":"capacityiops","type":"long"},{"description":"total min IOPS currently in use by volumes","name":"allocatediops","type":"long"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"the ID of the cluster for the storage pool","name":"clusterid","type":"string"},{"description":"the total disk size of the storage pool","name":"disksizetotal","type":"long"},{"description":"the scope of the storage pool","name":"scope","type":"string"},{"description":"the Zone name of the storage pool","name":"zonename","type":"string"},{"description":"the name of the cluster for the storage pool","name":"clustername","type":"string"},{"description":"the state of the storage pool","name":"state","type":"storagepoolstatus"},{"description":"the overprovisionfactor for the storage pool","name":"overprovisionfactor","type":"string"},{"description":"Storage provider for this pool","name":"provider","type":"string"},{"description":"the storage pool type","name":"type","type":"string"},{"description":"the storage pool path","name":"path","type":"string"},{"description":"the Zone ID of the storage pool","name":"zoneid","type":"string"},{"description":"the ID of the storage pool","name":"id","type":"string"},{"description":"true if this pool is suitable to migrate a volume, false otherwise","name":"suitableformigration","type":"boolean"}],"since":"3.0.0"},{"description":"Reboots a system VM.","isasync":true,"name":"rebootSystemVm","params":[{"description":"The ID of the system virtual machine","length":255,"name":"id","related":"rebootSystemVm,changeServiceForSystemVm,destroySystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm,scaleSystemVm","required":true,"type":"uuid"}],"related":"changeServiceForSystemVm,destroySystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm,scaleSystemVm","response":[{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the state of the system VM","name":"state","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"the gateway for the system VM","name":"gateway","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"}]},{"description":"Import LDAP users","isasync":false,"name":"importLdapUsers","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"Creates the account under the specified role.","length":255,"name":"roleid","related":"createRole,listRoles,updateRole","required":false,"type":"uuid"},{"description":"Type of the account.  Specify 0 for user, 1 for root admin, and 2 for domain admin","length":255,"name":"accounttype","required":false,"type":"short"},{"description":"Creates the user under the specified account. If no account is specified, the username will be used as the account name.","length":255,"name":"account","required":false,"type":"string"},{"description":"Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.","length":255,"name":"timezone","required":false,"type":"string"},{"description":"Specifies the domain to which the ldap users are to be imported. If no domain is specified, a domain will created using group parameter. If the group is also not specified, a domain name based on the OU information will be created. If no OU hierarchy exists, will be defaulted to ROOT domain","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"details for account used to store specific parameters","length":255,"name":"accountdetails","required":false,"type":"map"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"Specifies the group name from which the ldap users are to be imported. If no group is specified, all the users will be imported.","length":255,"name":"group","required":false,"type":"string"}],"related":"searchLdap,listLdapUsers","response":[{"description":"The user's firstname","name":"firstname","type":"string"},{"description":"The user's username","name":"username","type":"string"},{"description":"The user's principle","name":"principal","type":"string"},{"description":"The user's lastname","name":"lastname","type":"string"},{"description":"The user's email","name":"email","type":"string"},{"description":"The user's domain","name":"domain","type":"string"}],"since":"4.3.0"},{"description":"List dedicated zones.","isasync":false,"name":"listDedicatedZones","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the name of the account associated with the zone. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the ID of the domain associated with the zone","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"the ID of the Zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"list dedicated zones by affinity group","length":255,"name":"affinitygroupid","related":"createAffinityGroup,listAffinityGroups","required":false,"type":"uuid"}],"related":"dedicateZone","response":[{"description":"the Name of the Zone","name":"zonename","type":"string"},{"description":"the Account Id to which the Zone is dedicated","name":"accountid","type":"string"},{"description":"the Dedication Affinity Group ID of the zone","name":"affinitygroupid","type":"string"},{"description":"the ID of the dedicated resource","name":"id","type":"string"},{"description":"the ID of the Zone","name":"zoneid","type":"string"},{"description":"the domain ID to which the Zone is dedicated","name":"domainid","type":"string"}]},{"description":"Lists all available networks.","isasync":false,"name":"listNetworks","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"List networks by VPC","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"list networks available for VM deployment","length":255,"name":"canusefordeploy","required":false,"type":"boolean"},{"description":"list networks supporting certain services","length":255,"name":"supportedservices","required":false,"type":"list"},{"description":"list networks by ACL (access control list) type. Supported values are account and domain","length":255,"name":"acltype","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the type of the network. Supported values are: isolated and shared","length":255,"name":"type","required":false,"type":"string"},{"description":"list networks by physical network id","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork,listPhysicalNetworks","required":false,"type":"uuid"},{"description":"type of the traffic","length":255,"name":"traffictype","required":false,"type":"string"},{"description":"list networks by ID","length":255,"name":"id","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"the network belongs to VPC","length":255,"name":"forvpc","required":false,"type":"boolean"},{"description":"true if need to list only networks which support specifying IP ranges","length":255,"name":"specifyipranges","required":false,"type":"boolean"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"list networks by restartRequired","length":255,"name":"restartrequired","required":false,"type":"boolean"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"displaynetwork","required":false,"since":"4.4","type":"boolean"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"true if network is system, false otherwise","length":255,"name":"issystem","required":false,"type":"boolean"},{"description":"the zone ID of the network","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"}],"related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","response":[{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"the list of services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the provider name","name":"name","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"}],"type":"list"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability value","name":"value","type":"string"}],"type":"list"}],"type":"list"},{"description":"the name of the network","name":"name","type":"string"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"the id of the network","name":"id","type":"string"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"the type of the network","name":"type","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"state of the network","name":"state","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"}]},{"description":"Lists the pools of elastistor","isasync":false,"name":"listElastistorPool","params":[{"description":"the ID of the Pool","length":255,"name":"id","required":false,"type":"long"}],"related":"","response":[{"description":"the ID of the storage pool","name":"id","type":"string"},{"description":"available iops of the pool","name":"maxiops","type":"long"},{"description":"the name of the storage pool","name":"name","type":"string"},{"description":"controller of the pool","name":"controllerid","type":"string"},{"description":"the state of the storage pool","name":"state","type":"string"},{"description":"default gateway of the pool","name":"gateway","type":"string"},{"description":"the current available space of the pool","name":"size","type":"long"}]},{"description":"Updates firewall rule ","isasync":true,"name":"updateFirewallRule","params":[{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the ID of the firewall rule","length":255,"name":"id","related":"createPortForwardingRule,createIpForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"}],"related":"listEgressFirewallRules,updateEgressFirewallRule,listFirewallRules,createEgressFirewallRule,createFirewallRule","response":[{"description":"the state of the rule","name":"state","type":"string"},{"description":"the ID of the firewall rule","name":"id","type":"string"},{"description":"the public ip address id for the firewall rule","name":"ipaddressid","type":"string"},{"description":"the ending port of firewall rule's port range","name":"endport","type":"integer"},{"description":"the network id of the firewall rule","name":"networkid","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the protocol of the firewall rule","name":"protocol","type":"string"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"the starting port of firewall rule's port range","name":"startport","type":"integer"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"list"},{"description":"the public ip address for the firewall rule","name":"ipaddress","type":"string"},{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"the cidr list to forward traffic to","name":"destcidrlist","type":"string"}],"since":"4.4"},{"description":"Return true if the plugin is enabled","isasync":false,"name":"quotaIsEnabled","params":[],"related":"","response":[{"description":"is quota service enabled","name":"isenabled","type":"boolean"}],"since":"4.7.0"},{"description":"lists SRX firewall devices in a physical network","isasync":false,"name":"listSrxFirewalls","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork,listPhysicalNetworks","required":false,"type":"uuid"},{"description":"SRX firewall device ID","length":255,"name":"fwdeviceid","related":"addSrxFirewall,listSrxFirewalls,configureSrxFirewall","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"addSrxFirewall,configureSrxFirewall","response":[{"description":"the physical network to which this SRX firewall belongs to","name":"physicalnetworkid","type":"string"},{"description":"the usage interface of the external firewall","name":"usageinterface","type":"string"},{"description":"device name","name":"fwdevicename","type":"string"},{"description":"the private security zone of the external firewall","name":"privatezone","type":"string"},{"description":"device state","name":"fwdevicestate","type":"string"},{"description":"the zone ID of the external firewall","name":"zoneid","type":"string"},{"description":"the number of times to retry requests to the external firewall","name":"numretries","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"the timeout (in seconds) for requests to the external firewall","name":"timeout","type":"string"},{"description":"device capacity","name":"fwdevicecapacity","type":"long"},{"description":"the public interface of the external firewall","name":"publicinterface","type":"string"},{"description":"the private interface of the external firewall","name":"privateinterface","type":"string"},{"description":"device id of the SRX firewall","name":"fwdeviceid","type":"string"},{"description":"the username that's used to log in to the external firewall","name":"username","type":"string"},{"description":"the public security zone of the external firewall","name":"publiczone","type":"string"},{"description":"the management IP address of the external firewall","name":"ipaddress","type":"string"}]},{"description":"Deletes account from the project","isasync":true,"name":"deleteAccountFromProject","params":[{"description":"ID of the project to remove the account from","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":true,"type":"uuid"},{"description":"name of the account to be removed from the project","length":255,"name":"account","required":true,"type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"3.0.0"},{"description":"List hypervisors","isasync":false,"name":"listHypervisors","params":[{"description":"the zone id for listing hypervisors.","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"}],"related":"","response":[{"description":"Hypervisor name","name":"name","type":"string"}]},{"description":"Get the SF Volume Access Group ID","isasync":false,"name":"getSolidFireVolumeAccessGroupId","params":[{"description":"Cluster UUID","length":255,"name":"clusterid","required":true,"type":"string"},{"description":"Storage Pool UUID","length":255,"name":"storageid","required":true,"type":"string"}],"related":"","response":[{"description":"SolidFire Volume Access Group Id","name":"solidFireVolumeAccessGroupId","type":"long"}]},{"description":"Updates the information about Guest OS","isasync":true,"name":"updateGuestOs","params":[{"description":"UUID of the Guest OS","length":255,"name":"id","related":"updateGuestOs,addGuestOs,listOsTypes","required":true,"type":"uuid"},{"description":"Unique display name for Guest OS","length":255,"name":"osdisplayname","required":true,"type":"string"},{"description":"Map of (key/value pairs)","length":255,"name":"details","required":true,"type":"map"}],"related":"addGuestOs,listOsTypes","response":[{"description":"is the guest OS user defined","name":"isuserdefined","type":"boolean"},{"description":"the ID of the OS category","name":"oscategoryid","type":"string"},{"description":"the name/description of the OS type","name":"description","type":"string"},{"description":"the ID of the OS type","name":"id","type":"string"}],"since":"4.4.0"},{"description":"Updates resource limits for an account or domain.","isasync":false,"name":"updateResourceLimit","params":[{"description":"Update resource limits for project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"Type of resource to update. Values are 0, 1, 2, 3, 4, 6, 7, 8, 9, 10 and 11. 0 - Instance. Number of instances a user can create. 1 - IP. Number of public IP addresses a user can own. 2 - Volume. Number of disk volumes a user can create. 3 - Snapshot. Number of snapshots a user can create. 4 - Template. Number of templates that a user can register/create. 6 - Network. Number of guest network a user can create. 7 - VPC. Number of VPC a user can create. 8 - CPU. Total number of CPU cores a user can use. 9 - Memory. Total Memory (in MB) a user can use. 10 - PrimaryStorage. Total primary storage space (in GiB) a user can use. 11 - SecondaryStorage. Total secondary storage space (in GiB) a user can use. ","length":255,"name":"resourcetype","required":true,"type":"integer"},{"description":"Update resource limits for all accounts in specified domain. If used with the account parameter, updates resource limits for a specified account in specified domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"  Maximum resource limit.","length":255,"name":"max","required":false,"type":"long"},{"description":"Update resource for a specified account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"}],"related":"listResourceLimits","response":[{"description":"the account of the resource limit","name":"account","type":"string"},{"description":"the maximum number of the resource. A -1 means the resource currently has no limit.","name":"max","type":"long"},{"description":"the project name of the resource limit","name":"project","type":"string"},{"description":"the domain name of the resource limit","name":"domain","type":"string"},{"description":"the domain ID of the resource limit","name":"domainid","type":"string"},{"description":"resource type. Values include 0, 1, 2, 3, 4, 6, 7, 8, 9, 10, 11. See the resourceType parameter for more information on these values.","name":"resourcetype","type":"string"},{"description":"resource type name. Values include user_vm, public_ip, volume, snapshot, template, project, network, vpc, cpu, memory, primary_storage, secondary_storage.","name":"resourcetypename","type":"string"},{"description":"the project id of the resource limit","name":"projectid","type":"string"}]},{"description":"Lists hosts metrics","isasync":false,"name":"listHostsMetrics","params":[{"description":"list hosts by its out-of-band management interface's power state. Its value can be one of [On, Off, Unknown]","length":255,"name":"outofbandmanagementpowerstate","required":false,"type":"string"},{"description":"hypervisor type of host: XenServer,KVM,VMware,Hyperv,BareMetal,Simulator","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"the Zone ID for the host","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"lists hosts in the same cluster as this VM and flag hosts with enough CPU/RAm to host this VM","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"if true, list only hosts dedicated to HA","length":255,"name":"hahost","required":false,"type":"boolean"},{"description":"lists hosts existing in particular cluster","length":255,"name":"clusterid","related":"addCluster,listClusters,updateCluster","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list hosts by resource state. Resource state represents current state determined by admin of host, value can be one of [Enabled, Disabled, Unmanaged, PrepareForMaintenance, ErrorInMaintenance, Maintenance, Error]","length":255,"name":"resourcestate","required":false,"type":"string"},{"description":"comma separated list of host details requested, value can be a list of [ min, all, capacity, events, stats]","length":255,"name":"details","required":false,"type":"list"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the name of the host","length":255,"name":"name","required":false,"type":"string"},{"description":"the id of the host","length":255,"name":"id","related":"addHost,reconnectHost,updateHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"the host type","length":255,"name":"type","required":false,"type":"string"},{"description":"list hosts for which out-of-band management is enabled","length":255,"name":"outofbandmanagementenabled","required":false,"type":"boolean"},{"description":"the state of the host","length":255,"name":"state","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the Pod ID for the host","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"}],"related":"","response":[{"description":"the total cpu allocated in GiB","name":"memoryallocatedgb","type":"string"},{"description":"cpu allocated notification threshold exceeded","name":"cpuallocatedthreshold","type":"boolean"},{"description":"cpu usage notification threshold exceeded","name":"cputhreshold","type":"boolean"},{"description":"cpu allocated disable threshold exceeded","name":"cpuallocateddisablethreshold","type":"boolean"},{"description":"the total cpu used in Ghz","name":"cpuusedghz","type":"string"},{"description":"the total cpu capacity in GiB","name":"memorytotalgb","type":"string"},{"description":"the total cpu used in GiB","name":"memoryusedgb","type":"string"},{"description":"out-of-band management power state","name":"powerstate","type":"powerstate"},{"description":"instances on the host","name":"instances","type":"string"},{"description":"the total cpu allocated in Ghz","name":"cpuallocatedghz","type":"string"},{"description":"memory usage notification threshold exceeded","name":"memorythreshold","type":"boolean"},{"description":"memory allocated disable threshold exceeded","name":"memoryallocateddisablethreshold","type":"boolean"},{"description":"the total cpu capacity in Ghz","name":"cputotalghz","type":"string"},{"description":"network read in GiB","name":"networkread","type":"string"},{"description":"cpu usage disable threshold exceeded","name":"cpudisablethreshold","type":"boolean"},{"description":"memory allocated notification threshold exceeded","name":"memoryallocatedthreshold","type":"boolean"},{"description":"network write in GiB","name":"networkwrite","type":"string"},{"description":"memory usage disable threshold exceeded","name":"memorydisablethreshold","type":"boolean"}],"since":"4.9.3"},{"description":"Deletes a static route","isasync":true,"name":"deleteStaticRoute","params":[{"description":"the ID of the static route","length":255,"name":"id","related":"createStaticRoute,listStaticRoutes","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Release the dedication for the pod","isasync":true,"name":"releaseDedicatedPod","params":[{"description":"the ID of the Pod","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists affinity groups","isasync":false,"name":"listAffinityGroups","params":[{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"lists affinity groups by type","length":255,"name":"type","required":false,"type":"string"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"lists affinity groups by virtual machine ID","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list the affinity group by the ID provided","length":255,"name":"id","related":"createAffinityGroup,listAffinityGroups","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"lists affinity groups by name","length":255,"name":"name","required":false,"type":"string"}],"related":"createAffinityGroup","response":[{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"}]},{"description":"Register a public key in a keypair under a certain name","isasync":false,"name":"registerSSHKeyPair","params":[{"description":"Name of the keypair","length":255,"name":"name","required":true,"type":"string"},{"description":"an optional project for the ssh key","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"an optional account for the ssh key. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"an optional domainId for the ssh key. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"Public key material of the keypair","length":5120,"name":"publickey","required":true,"type":"string"}],"related":"listSSHKeyPairs","response":[{"description":"the owner of the keypair","name":"account","type":"string"},{"description":"the domain name of the keypair owner","name":"domain","type":"string"},{"description":"Fingerprint of the public key","name":"fingerprint","type":"string"},{"description":"Name of the keypair","name":"name","type":"string"},{"description":"the domain id of the keypair owner","name":"domainid","type":"string"}]},{"description":"Destroys a l2tp/ipsec remote access vpn","isasync":true,"name":"deleteRemoteAccessVpn","params":[{"description":"public ip address id of the vpn server","length":255,"name":"publicipid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Updates network ACL list","isasync":true,"name":"updateNetworkACLList","params":[{"description":"the ID of the network ACL","length":255,"name":"id","related":"createNetworkACLList,listNetworkACLLists","required":true,"type":"uuid"},{"description":"an optional field, whether to the display the list to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.4"},{"description":"Delete one or more events.","isasync":false,"name":"deleteEvents","params":[{"description":"start date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"startdate","required":false,"type":"date"},{"description":"the IDs of the events","length":255,"name":"ids","related":"listEvents","required":false,"type":"list"},{"description":"delete by event type","length":255,"name":"type","required":false,"type":"string"},{"description":"end date range to delete events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"enddate","required":false,"type":"date"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Restore a VM to original template/ISO or new template/ISO","isasync":true,"name":"restoreVirtualMachine","params":[{"description":"an optional template Id to restore vm from the new template. This can be an ISO id in case of restore vm deployed using ISO","length":255,"name":"templateid","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":false,"type":"uuid"},{"description":"Virtual Machine ID","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,restoreVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the type of the nic","name":"type","type":"string"}],"type":"set"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"}],"type":"set"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"set"},{"description":"security group name","name":"securitygroupname","type":"string"}],"type":"set"}],"type":"set"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the description of the affinity group","name":"description","type":"string"}],"type":"set"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"}],"since":"3.0.0"},{"description":" delete a nicira nvp device","isasync":true,"name":"deleteNiciraNvpDevice","params":[{"description":"Nicira device ID","length":255,"name":"nvpdeviceid","related":"addNiciraNvpDevice,listNiciraNvpDevices","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Notify provision has been done on a host. This api is for baremetal virtual router service, not for end user","isasync":true,"name":"notifyBaremetalProvisionDone","params":[{"description":"mac of the nic used for provision","length":255,"name":"mac","required":true,"type":"object"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"List ucs blades","isasync":false,"name":"listUcsBlades","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"ucs manager id","length":255,"name":"ucsmanagerid","related":"listUcsManagers,addUcsManager","required":true,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"associateUcsProfileToBlade","response":[{"description":"cloudstack host id this blade associates to","name":"hostid","type":"string"},{"description":"ucs blade id","name":"id","type":"string"},{"description":"associated ucs profile dn","name":"profiledn","type":"string"},{"description":"ucs manager id","name":"ucsmanagerid","type":"string"},{"description":"ucs blade dn","name":"bladedn","type":"string"}]},{"description":"Get Volume Snapshot Details","isasync":false,"name":"getVolumeSnapshotDetails","params":[{"description":"CloudStack Snapshot UUID","length":255,"name":"snapshotid","required":true,"type":"string"}],"related":"getVolumeiScsiName","response":[{"description":"Volume iSCSI Name","name":"volumeiScsiName","type":"string"}]},{"description":"Deletes an ISO file.","isasync":true,"name":"deleteIso","params":[{"description":"the ID of the ISO file","length":255,"name":"id","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":true,"type":"uuid"},{"description":"the ID of the zone of the ISO file. If not specified, the ISO will be deleted from all the zones","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Deletes an external firewall appliance.","isasync":false,"name":"deleteExternalFirewall","params":[{"description":"Id of the external firewall appliance.","length":255,"name":"id","related":"addHost,reconnectHost,updateHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Updates a host.","isasync":false,"name":"updateHost","params":[{"description":"Change resource state of host, valid values are [Enable, Disable]. Operation may failed if host in states not allowing Enable/Disable","length":255,"name":"allocationstate","required":false,"type":"string"},{"description":"Add an annotation to this host","length":255,"name":"annotation","required":false,"since":"4.11","type":"string"},{"description":"the new uri for the secondary storage: nfs://host/path","length":255,"name":"url","required":false,"type":"string"},{"description":"the id of Os category to update the host with","length":255,"name":"oscategoryid","related":"listOsCategories","required":false,"type":"uuid"},{"description":"list of tags to be added to the host","length":255,"name":"hosttags","required":false,"type":"list"},{"description":"the ID of the host to update","length":255,"name":"id","related":"addHost,reconnectHost,updateHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","response":[{"description":"true if the host is disconnected. False otherwise.","name":"disconnected","type":"date"},{"description":"the state of the host","name":"state","type":"status"},{"description":"the host HA information information","name":"hostha","type":"hostharesponse"},{"description":"the Zone name of the host","name":"zonename","type":"string"},{"description":"the host version","name":"version","type":"string"},{"description":"the amount of the host's CPU currently allocated","name":"cpuallocated","type":"string"},{"description":"the OS category name of the host","name":"oscategoryname","type":"string"},{"description":"the incoming network traffic on the host","name":"networkkbsread","type":"long"},{"description":"the last time this host was annotated","name":"lastannotated","type":"date"},{"description":"the management server ID of the host","name":"managementserverid","type":"long"},{"description":"the name of the host","name":"name","type":"string"},{"description":"the host hypervisor","name":"hypervisor","type":"hypervisortype"},{"description":"the amount of the host's CPU currently used","name":"cpuused","type":"string"},{"description":"the date and time the host was last pinged","name":"lastpinged","type":"date"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"capabilities of the host","name":"capabilities","type":"string"},{"description":"true if local storage is active, false otherwise","name":"islocalstorageactive","type":"boolean"},{"description":"the amount of the host's memory currently allocated","name":"memoryallocated","type":"long"},{"description":"the Pod ID of the host","name":"podid","type":"string"},{"description":"the amount of the host's CPU after applying the cpu.overprovisioning.factor ","name":"cpuwithoverprovisioning","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the CPU speed of the host","name":"cpuspeed","type":"long"},{"description":"the total disk size of the host","name":"disksizetotal","type":"long"},{"description":"the host type","name":"type","type":"type"},{"description":"the cluster ID of the host","name":"clusterid","type":"string"},{"description":"the admin that annotated this host","name":"username","type":"string"},{"description":"the cpu average load on the host","name":"averageload","type":"long"},{"description":"true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise","name":"suitableformigration","type":"boolean"},{"description":"true if the host is Ha host (dedicated to vms started by HA process; false otherwise","name":"hahost","type":"boolean"},{"description":"Host details in key/value pairs.","name":"details","type":"map"},{"description":"the IP address of the host","name":"ipaddress","type":"string"},{"description":"the amount of the host's memory after applying the mem.overprovisioning.factor","name":"memorywithoverprovisioning","type":"string"},{"description":"the memory total of the host, this parameter is deprecated use memorywithoverprovisioning","name":"memorytotal","type":"long"},{"description":"the cluster name of the host","name":"clustername","type":"string"},{"description":"events available for the host","name":"events","type":"string"},{"description":"comma-separated list of tags for the host","name":"hosttags","type":"string"},{"description":"the Pod name of the host","name":"podname","type":"string"},{"description":"the host out-of-band management information","name":"outofbandmanagement","type":"outofbandmanagementresponse"},{"description":"the CPU number of the host","name":"cpunumber","type":"integer"},{"description":"the resource state of the host","name":"resourcestate","type":"string"},{"description":"the OS category ID of the host","name":"oscategoryid","type":"string"},{"description":"GPU cards present in the host","name":"gpugroup","response":[{"description":"the list of enabled vGPUs","name":"vgpu","response":[{"description":"Maximum Y resolution per display","name":"maxresolutiony","type":"long"},{"description":"Maximum vgpu can be created with this vgpu type on the given gpu group","name":"maxcapacity","type":"long"},{"description":"Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type","name":"remainingcapacity","type":"long"},{"description":"Maximum no. of vgpu per gpu card (pgpu)","name":"maxvgpuperpgpu","type":"long"},{"description":"Model Name of vGPU","name":"vgputype","type":"string"},{"description":"Video RAM for this vGPU type","name":"videoram","type":"long"},{"description":"Maximum displays per user","name":"maxheads","type":"long"},{"description":"Maximum X resolution per display","name":"maxresolutionx","type":"long"}],"type":"list"},{"description":"GPU cards present in the host","name":"gpugroupname","type":"string"}],"type":"list"},{"description":"the last annotation set on this host by an admin","name":"annotation","type":"string"},{"description":"the amount of the host's memory currently used","name":"memoryused","type":"long"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the ID of the host","name":"id","type":"string"},{"description":"the number of CPU sockets on the host","name":"cpusockets","type":"integer"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"the Zone ID of the host","name":"zoneid","type":"string"},{"description":"the cluster type of the cluster that host belongs to","name":"clustertype","type":"string"},{"description":"true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise","name":"hasenoughcapacity","type":"boolean"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"}]},{"description":"Creates a egress firewall rule for a given network ","isasync":true,"name":"createEgressFirewallRule","params":[{"description":"the cidr list to forward traffic from","length":255,"name":"cidrlist","required":false,"type":"list"},{"description":"type of firewallrule: system/user","length":255,"name":"type","required":false,"type":"string"},{"description":"error code for this icmp message","length":255,"name":"icmpcode","required":false,"type":"integer"},{"description":"the ending port of firewall rule","length":255,"name":"endport","required":false,"type":"integer"},{"description":"the protocol for the firewall rule. Valid values are TCP/UDP/ICMP.","length":255,"name":"protocol","required":true,"type":"string"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the network id of the port forwarding rule","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":true,"type":"uuid"},{"description":"the cidr list to forward traffic to","length":255,"name":"destcidrlist","required":false,"type":"list"},{"description":"type of the icmp message being sent","length":255,"name":"icmptype","required":false,"type":"integer"},{"description":"the starting port of firewall rule","length":255,"name":"startport","required":false,"type":"integer"}],"related":"listEgressFirewallRules,updateEgressFirewallRule,listFirewallRules,createFirewallRule","response":[{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"list"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the cidr list to forward traffic to","name":"destcidrlist","type":"string"},{"description":"the ending port of firewall rule's port range","name":"endport","type":"integer"},{"description":"the ID of the firewall rule","name":"id","type":"string"},{"description":"the protocol of the firewall rule","name":"protocol","type":"string"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"the public ip address id for the firewall rule","name":"ipaddressid","type":"string"},{"description":"the starting port of firewall rule's port range","name":"startport","type":"integer"},{"description":"the network id of the firewall rule","name":"networkid","type":"string"},{"description":"the public ip address for the firewall rule","name":"ipaddress","type":"string"}]},{"description":"Get the SF volume size including Hypervisor Snapshot Reserve","isasync":false,"name":"getSolidFireVolumeSize","params":[{"description":"Volume UUID","length":255,"name":"volumeid","required":true,"type":"string"}],"related":"","response":[{"description":"SolidFire Volume Size Including Hypervisor Snapshot Reserve","name":"solidFireVolumeSize","type":"long"}]},{"description":"Lists VPC offerings","isasync":false,"name":"listVPCOfferings","params":[{"description":"true if need to list only default VPC offerings. Default value is false","length":255,"name":"isdefault","required":false,"type":"boolean"},{"description":"list VPC offerings by id","length":255,"name":"id","related":"updateVPCOffering,listVPCOfferings","required":false,"type":"uuid"},{"description":"list VPC offerings by state","length":255,"name":"state","required":false,"type":"string"},{"description":"list VPC offerings supporting certain services","length":255,"name":"supportedservices","required":false,"type":"list"},{"description":"list VPC offerings by display text","length":255,"name":"displaytext","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list VPC offerings by name","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"updateVPCOffering","response":[{"description":"true if vpc offering is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"state of the vpc offering. Can be Disabled/Enabled","name":"state","type":"string"},{"description":"an alternate display text of the vpc offering.","name":"displaytext","type":"string"},{"description":"the name of the vpc offering","name":"name","type":"string"},{"description":" indicated if the offering can support region level vpc","name":"supportsregionLevelvpc","type":"boolean"},{"description":"the id of the vpc offering","name":"id","type":"string"},{"description":"the date this vpc offering was created","name":"created","type":"date"},{"description":" indicates if the vpc offering supports distributed router for one-hop forwarding","name":"distributedvpcrouter","type":"boolean"},{"description":"the list of supported services","name":"service","response":[{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the provider name","name":"name","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"}],"type":"list"}],"type":"list"}]},{"description":"Uploads a data disk.","isasync":true,"name":"uploadVolume","params":[{"description":"Upload volume for the project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the format for the volume. Possible values include QCOW2, OVA, and VHD.","length":255,"name":"format","required":true,"type":"string"},{"description":"the checksum value of this volume. The parameter containing the checksum will be considered a MD5sum if it is not prefixed\n and just a plain ascii/utf8 representation of a hexadecimal string. If it is required to\n use another algorithm the hexadecimal string is to be prefixed with a string of the form,\n \"{\u003calgorithm\u003e}\", not including the double quotes. In this \u003calgorithm\u003e is the exact string\n representing the java supported algorithm, i.e. MD5 or SHA-256. Note that java does not\n contain an algorithm called SHA256 or one called sha-256, only SHA-256.","length":255,"name":"checksum","required":false,"type":"string"},{"description":"the name of the volume","length":255,"name":"name","required":true,"type":"string"},{"description":"the URL of where the volume is hosted. Possible URL include http:// and https://","length":2048,"name":"url","required":true,"type":"string"},{"description":"an optional accountName. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"the ID of the disk offering. This must be a custom sized offering since during uploadVolume volume size is unknown.","length":255,"name":"diskofferingid","related":"listDiskOfferings,updateDiskOffering,createDiskOffering","required":false,"type":"uuid"},{"description":"an optional domainId. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"Image store uuid","length":255,"name":"imagestoreuuid","required":false,"type":"string"},{"description":"the ID of the zone the volume is to be hosted on","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","response":[{"description":"the bytes alloaated","name":"physicalsize","type":"long"},{"description":"ID of the snapshot from which this volume was created","name":"snapshotid","type":"string"},{"description":"bytes write rate of the disk volume","name":"diskBytesWriteRate","type":"long"},{"description":"need quiesce vm or not when taking snapshot","name":"quiescevm","type":"boolean"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the account associated with the disk volume","name":"account","type":"string"},{"description":"name of the primary storage hosting the disk volume","name":"storage","type":"string"},{"description":"max iops of the disk volume","name":"maxiops","type":"long"},{"description":"the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.","name":"deviceid","type":"long"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the chain info of the volume","name":"chaininfo","type":"string"},{"description":"pod name of the volume","name":"podname","type":"string"},{"description":"the ID of the domain associated with the disk volume","name":"domainid","type":"string"},{"description":"name of the virtual machine","name":"vmname","type":"string"},{"description":"id of the primary storage hosting the disk volume; returned to admin user only","name":"storageid","type":"string"},{"description":"the date the volume was attached to a VM instance","name":"attached","type":"date"},{"description":"true if the volume is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"an optional field whether to the display the volume to the end user or not.","name":"displayvolume","type":"boolean"},{"description":"name of the service offering for root disk","name":"serviceofferingname","type":"string"},{"description":"the project name of the vpn","name":"project","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the disk utilization","name":"utilization","type":"string"},{"description":"io requests read rate of the disk volume","name":"diskIopsReadRate","type":"long"},{"description":"Hypervisor the volume belongs to","name":"hypervisor","type":"string"},{"description":"the boolean state of whether the volume is destroyed or not","name":"destroyed","type":"boolean"},{"description":"state of the virtual machine","name":"vmstate","type":"string"},{"description":"size of the disk volume","name":"size","type":"long"},{"description":"min iops of the disk volume","name":"miniops","type":"long"},{"description":"ID of the availability zone","name":"zoneid","type":"string"},{"description":"ID of the disk offering","name":"diskofferingid","type":"string"},{"description":"the display text of the service offering for root disk","name":"serviceofferingdisplaytext","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"cluster id of the volume","name":"clusterid","type":"string"},{"description":"the bytes actually consumed on disk","name":"virtualsize","type":"long"},{"description":"the display text of the disk offering","name":"diskofferingdisplaytext","type":"string"},{"description":"ID of the service offering for root disk","name":"serviceofferingid","type":"string"},{"description":"type of the disk volume (ROOT or DATADISK)","name":"type","type":"string"},{"description":"the project id of the vpn","name":"projectid","type":"string"},{"description":"io requests write rate of the disk volume","name":"diskIopsWriteRate","type":"long"},{"description":"id of the virtual machine","name":"virtualmachineid","type":"string"},{"description":"provisioning type used to create volumes.","name":"provisioningtype","type":"string"},{"description":"bytes read rate of the disk volume","name":"diskBytesReadRate","type":"long"},{"description":"the state of the disk volume","name":"state","type":"string"},{"description":"name of the disk volume","name":"name","type":"string"},{"description":"name of the availability zone","name":"zonename","type":"string"},{"description":"pod id of the volume","name":"podid","type":"string"},{"description":"the domain associated with the disk volume","name":"domain","type":"string"},{"description":"name of the disk offering","name":"diskofferingname","type":"string"},{"description":"the status of the volume","name":"status","type":"string"},{"description":"cluster name where the volume is allocated","name":"clustername","type":"string"},{"description":"the path of the volume","name":"path","type":"string"},{"description":"display name of the virtual machine","name":"vmdisplayname","type":"string"},{"description":"ID of the disk volume","name":"id","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the date the disk volume was created","name":"created","type":"date"},{"description":"shared or local storage","name":"storagetype","type":"string"}]},{"description":"Lists security groups","isasync":false,"name":"listSecurityGroups","params":[{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"lists security groups by name","length":255,"name":"securitygroupname","required":false,"type":"string"},{"description":"lists security groups by virtual machine id","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list the security group by the id provided","length":255,"name":"id","related":"listSecurityGroups,createSecurityGroup","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"}],"related":"createSecurityGroup","response":[{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"}],"type":"set"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"set"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"}],"type":"set"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the name of the security group","name":"name","type":"string"}]},{"description":"Configures a host's out-of-band management interface","isasync":false,"name":"configureOutOfBandManagement","params":[{"description":"the host management interface IP address","length":255,"name":"address","required":true,"type":"string"},{"description":"the host management interface port","length":255,"name":"port","required":true,"type":"string"},{"description":"the host management interface user","length":255,"name":"username","required":true,"type":"string"},{"description":"the host management interface driver, for example: ipmitool","length":255,"name":"driver","required":true,"type":"string"},{"description":"the host management interface password","length":255,"name":"password","required":true,"type":"string"},{"description":"the ID of the host","length":255,"name":"hostid","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"related":"enableOutOfBandManagementForCluster,disableOutOfBandManagementForZone,enableOutOfBandManagementForHost,issueOutOfBandManagementPowerAction,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,changeOutOfBandManagementPassword,disableOutOfBandManagementForHost","response":[{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"},{"description":"the out-of-band management interface address","name":"address","type":"string"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"the operation result description","name":"description","type":"string"},{"description":"the out-of-band management interface port","name":"port","type":"string"},{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"}],"since":"4.9.0"},{"description":"Delete Service Package","isasync":false,"name":"deleteServicePackageOffering","params":[{"description":"the service offering ID","length":255,"name":"id","related":"listRegisteredServicePackages,registerNetscalerServicePackage","required":true,"type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists storage tags","isasync":false,"name":"listStorageTags","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"","response":[{"description":"the name of the storage tag","name":"name","type":"string"},{"description":"the pool ID of the storage tag","name":"poolid","type":"long"},{"description":"the ID of the storage tag","name":"id","type":"string"}]},{"description":"List template visibility and all accounts that have permissions to view this template.","isasync":false,"name":"listTemplatePermissions","params":[{"description":"the template ID","length":255,"name":"id","related":"listTemplatePermissions,listTemplatePermissions,listIsoPermissions,listIsoPermissions","required":true,"type":"uuid"}],"related":"listTemplatePermissions,listIsoPermissions,listIsoPermissions","response":[{"description":"the template ID","name":"id","type":"string"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"the list of projects the template is available for","name":"projectids","type":"list"},{"description":"the list of accounts the template is available for","name":"account","type":"list"}]},{"description":"Lists annotations.","isasync":false,"name":"listAnnotations","params":[{"description":"the id of the annotation","length":255,"name":"id","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the entity type","length":255,"name":"entitytype","required":false,"type":"string"},{"description":"the id of the entity for which to show annotations","length":255,"name":"entityid","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"addAnnotation,removeAnnotation","response":[{"description":"The (uu)id of the user that entered the annotation","name":"userid","type":"string"},{"description":"the (uu)id of the annotation","name":"id","type":"string"},{"description":"the type of the annotated entity","name":"entitytype","type":"string"},{"description":"the removal timestamp for this annotation","name":"removed","type":"date"},{"description":"the creation timestamp for this annotation","name":"created","type":"date"},{"description":"the contents of the annotation","name":"annotation","type":"string"},{"description":"the (uu)id of the entitiy to which this annotation pertains","name":"entityid","type":"string"}],"since":"4.11"},{"description":"Destroyes a system virtual machine.","isasync":true,"name":"destroySystemVm","params":[{"description":"The ID of the system virtual machine","length":255,"name":"id","related":"changeServiceForSystemVm,destroySystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm,scaleSystemVm","required":true,"type":"uuid"}],"related":"changeServiceForSystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm,scaleSystemVm","response":[{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the state of the system VM","name":"state","type":"string"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the gateway for the system VM","name":"gateway","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"}]},{"description":"Archive one or more events.","isasync":false,"name":"archiveEvents","params":[{"description":"archive by event type","length":255,"name":"type","required":false,"type":"string"},{"description":"the IDs of the events","length":255,"name":"ids","related":"listEvents","required":false,"type":"list"},{"description":"end date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"enddate","required":false,"type":"date"},{"description":"start date range to archive events (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"startdate","required":false,"type":"date"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Adds Swift.","isasync":false,"name":"addSwift","params":[{"description":" key for the user for swift","length":255,"name":"key","required":false,"type":"string"},{"description":"the URL for swift","length":255,"name":"url","required":true,"type":"string"},{"description":"the username for swift","length":255,"name":"username","required":false,"type":"string"},{"description":"the account for swift","length":255,"name":"account","required":false,"type":"string"}],"related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3,createSecondaryStagingStore,listSecondaryStagingStores","response":[{"description":"the scope of the image store","name":"scope","type":"scopetype"},{"description":"the name of the image store","name":"name","type":"string"},{"description":"the url of the image store","name":"url","type":"string"},{"description":"the ID of the image store","name":"id","type":"string"},{"description":"the Zone name of the image store","name":"zonename","type":"string"},{"description":"the protocol of the image store","name":"protocol","type":"string"},{"description":"the provider name of the image store","name":"providername","type":"string"},{"description":"the Zone ID of the image store","name":"zoneid","type":"string"}],"since":"3.0.0"},{"description":"Deletes a secondary staging store .","isasync":false,"name":"deleteSecondaryStagingStore","params":[{"description":"the staging store ID","length":255,"name":"id","related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3,createSecondaryStagingStore,listSecondaryStagingStores","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.2.0"},{"description":"Adds a SRX firewall device","isasync":true,"name":"addSrxFirewall","params":[{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork,listPhysicalNetworks","required":true,"type":"uuid"},{"description":"URL of the SRX appliance.","length":255,"name":"url","required":true,"type":"string"},{"description":"Credentials to reach SRX firewall device","length":255,"name":"password","required":true,"type":"string"},{"description":"Credentials to reach SRX firewall device","length":255,"name":"username","required":true,"type":"string"},{"description":"supports only JuniperSRXFirewall","length":255,"name":"networkdevicetype","required":true,"type":"string"}],"related":"configureSrxFirewall","response":[{"description":"device name","name":"fwdevicename","type":"string"},{"description":"device state","name":"fwdevicestate","type":"string"},{"description":"the number of times to retry requests to the external firewall","name":"numretries","type":"string"},{"description":"the zone ID of the external firewall","name":"zoneid","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"device id of the SRX firewall","name":"fwdeviceid","type":"string"},{"description":"the public security zone of the external firewall","name":"publiczone","type":"string"},{"description":"the username that's used to log in to the external firewall","name":"username","type":"string"},{"description":"the private interface of the external firewall","name":"privateinterface","type":"string"},{"description":"the public interface of the external firewall","name":"publicinterface","type":"string"},{"description":"the physical network to which this SRX firewall belongs to","name":"physicalnetworkid","type":"string"},{"description":"the usage interface of the external firewall","name":"usageinterface","type":"string"},{"description":"the management IP address of the external firewall","name":"ipaddress","type":"string"},{"description":"the timeout (in seconds) for requests to the external firewall","name":"timeout","type":"string"},{"description":"device capacity","name":"fwdevicecapacity","type":"long"},{"description":"the private security zone of the external firewall","name":"privatezone","type":"string"}]},{"description":"Updates a load balancer","isasync":true,"name":"updateLoadBalancer","params":[{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"the ID of the load balancer","length":255,"name":"id","related":"createPortForwardingRule,createIpForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"}],"related":"listLoadBalancers,createLoadBalancer","response":[{"description":"the Load Balancer ID","name":"id","type":"string"},{"description":"the domain of the Load Balancer","name":"domain","type":"string"},{"description":"Load Balancer network id","name":"networkid","type":"string"},{"description":"the name of the Load Balancer","name":"name","type":"string"},{"description":"the project name of the Load Balancer","name":"project","type":"string"},{"description":"the load balancer algorithm (source, roundrobin, leastconn)","name":"algorithm","type":"string"},{"description":"Load Balancer source ip","name":"sourceipaddress","type":"string"},{"description":"the domain ID of the Load Balancer","name":"domainid","type":"string"},{"description":"the list of resource tags associated with the Load Balancer","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"list"},{"description":"Load Balancer source ip network id","name":"sourceipaddressnetworkid","type":"string"},{"description":"the description of the Load Balancer","name":"description","type":"string"},{"description":"the project id of the Load Balancer","name":"projectid","type":"string"},{"description":"the list of rules associated with the Load Balancer","name":"loadbalancerrule","response":[{"description":"source port of the load balancer rule","name":"sourceport","type":"integer"},{"description":"the state of the load balancer rule","name":"state","type":"string"},{"description":"instance port of the load balancer rule","name":"instanceport","type":"integer"}],"type":"list"},{"description":"the account of the Load Balancer","name":"account","type":"string"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the list of instances associated with the Load Balancer","name":"loadbalancerinstance","response":[{"description":"the name of the instance","name":"name","type":"string"},{"description":"the state of the instance","name":"state","type":"string"},{"description":"the instance ID","name":"id","type":"string"},{"description":"the ip address of the instance","name":"ipaddress","type":"string"}],"type":"list"}],"since":"4.4.0"},{"description":"Scale the service offering for a system vm (console proxy or secondary storage). The system vm must be in a \"Stopped\" state for this command to take effect.","isasync":true,"name":"scaleSystemVm","params":[{"description":"name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value","length":255,"name":"details","required":false,"type":"map"},{"description":"The ID of the system vm","length":255,"name":"id","related":"changeServiceForSystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm,scaleSystemVm","required":true,"type":"uuid"},{"description":"the service offering ID to apply to the system vm","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":true,"type":"uuid"}],"related":"changeServiceForSystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm","response":[{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"the gateway for the system VM","name":"gateway","type":"string"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"the state of the system VM","name":"state","type":"string"}]},{"description":"Lists snapshot policies.","isasync":false,"name":"listSnapshotPolicies","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the ID of the disk volume","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"type":"uuid"},{"description":"the ID of the snapshot policy","length":255,"name":"id","related":"createSnapshotPolicy,listSnapshotPolicies,updateSnapshotPolicy","required":false,"type":"uuid"}],"related":"createSnapshotPolicy,updateSnapshotPolicy","response":[{"description":"the time zone of the snapshot policy","name":"timezone","type":"string"},{"description":"the ID of the snapshot policy","name":"id","type":"string"},{"description":"is this policy for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the interval type of the snapshot policy","name":"intervaltype","type":"short"},{"description":"maximum number of snapshots retained","name":"maxsnaps","type":"int"},{"description":"time the snapshot is scheduled to be taken.","name":"schedule","type":"string"},{"description":"the ID of the disk volume","name":"volumeid","type":"string"}]},{"description":"Update site to site vpn customer gateway","isasync":true,"name":"updateVpnCustomerGateway","params":[{"description":"the domain ID associated with the gateway. If used with the account parameter returns the gateway associated with the account for the specified domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"Force encapsulation for Nat Traversal","length":255,"name":"forceencap","required":false,"type":"boolean"},{"description":"If DPD is enabled for VPN connection","length":255,"name":"dpd","required":false,"type":"boolean"},{"description":"IKE policy of the customer gateway","length":255,"name":"ikepolicy","required":true,"type":"string"},{"description":"ESP policy of the customer gateway","length":255,"name":"esppolicy","required":true,"type":"string"},{"description":"Lifetime of phase 1 VPN connection to the customer gateway, in seconds","length":255,"name":"ikelifetime","required":false,"type":"long"},{"description":"name of this customer gateway","length":255,"name":"name","required":false,"type":"string"},{"description":"guest cidr of the customer gateway","length":255,"name":"cidrlist","required":true,"type":"string"},{"description":"public ip address id of the customer gateway","length":255,"name":"gateway","required":true,"type":"string"},{"description":"the account associated with the gateway. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"id of customer gateway","length":255,"name":"id","related":"createVpnCustomerGateway,listVpnCustomerGateways,updateVpnCustomerGateway","required":true,"type":"uuid"},{"description":"IPsec Preshared-Key of the customer gateway. Cannot contain newline or double quotes.","length":255,"name":"ipsecpsk","required":true,"type":"string"},{"description":"Lifetime of phase 2 VPN connection to the customer gateway, in seconds","length":255,"name":"esplifetime","required":false,"type":"long"}],"related":"createVpnCustomerGateway,listVpnCustomerGateways","response":[{"description":"guest cidr list of the customer gateway","name":"cidrlist","type":"string"},{"description":"if DPD is enabled for customer gateway","name":"dpd","type":"boolean"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"public ip address id of the customer gateway","name":"gateway","type":"string"},{"description":"the owner","name":"account","type":"string"},{"description":"the vpn gateway ID","name":"id","type":"string"},{"description":"name of the customer gateway","name":"name","type":"string"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"the domain id of the owner","name":"domainid","type":"string"},{"description":"Lifetime of ESP SA of customer gateway","name":"esplifetime","type":"long"},{"description":"the project id","name":"projectid","type":"string"},{"description":"the project name","name":"project","type":"string"},{"description":"IPsec preshared-key of customer gateway","name":"ipsecpsk","type":"string"},{"description":"IKE policy of customer gateway","name":"ikepolicy","type":"string"},{"description":"IPsec policy of customer gateway","name":"esppolicy","type":"string"},{"description":"guest ip of the customer gateway","name":"ipaddress","type":"string"},{"description":"if Force NAT Encapsulation is enabled for customer gateway","name":"forceencap","type":"boolean"},{"description":"Lifetime of IKE SA of customer gateway","name":"ikelifetime","type":"long"}]},{"description":"Stops a router.","isasync":true,"name":"stopRouter","params":[{"description":"Force stop the VM. The caller knows the VM is stopped.","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"the ID of the router","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,startRouter,changeServiceForRouter,destroyRouter,stopRouter,startInternalLoadBalancerVM,rebootRouter,listRouters","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,startRouter,changeServiceForRouter,destroyRouter,startInternalLoadBalancerVM,rebootRouter,listRouters","response":[{"description":"the project name of the address","name":"project","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the type of the nic","name":"type","type":"string"}],"type":"set"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"}]},{"description":"This deprecated function used to locks an account. Look for the API DisableAccount instead","isasync":false,"name":"lockAccount","params":[{"description":"Locks the specified account.","length":255,"name":"account","required":true,"type":"string"},{"description":"Locks the specified account on this domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":true,"type":"uuid"}],"related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,markDefaultZoneForAccount,disableAccount","response":[{"description":"the type of the role (Admin, ResourceAdmin, DomainAdmin, User)","name":"roletype","type":"string"},{"description":"the total number of vpcs owned by account","name":"vpctotal","type":"long"},{"description":"the total number of templates which have been created by this account","name":"templatetotal","type":"long"},{"description":"the total number of vpcs available to be created for this account","name":"vpcavailable","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this account","name":"secondarystorageavailable","type":"string"},{"description":"the state of the account","name":"state","type":"string"},{"description":"the id of the account","name":"id","type":"string"},{"description":"id of the Domain the account belongs too","name":"domainid","type":"string"},{"description":"name of the Domain the account belongs too","name":"domain","type":"string"},{"description":"the total primary storage space (in GiB) available to be used for this account","name":"primarystorageavailable","type":"string"},{"description":"the default zone of the account","name":"defaultzoneid","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the total number of public ip addresses available for this account to acquire","name":"ipavailable","type":"string"},{"description":"the total volume being used by this account","name":"volumetotal","type":"long"},{"description":"the total number of cpu cores available to be created for this account","name":"cpuavailable","type":"string"},{"description":"the total memory (in MB) owned by account","name":"memorytotal","type":"long"},{"description":"the total primary storage space (in GiB) the account can own","name":"primarystoragelimit","type":"string"},{"description":"the total secondary storage space (in GiB) the account can own","name":"secondarystoragelimit","type":"string"},{"description":"the total number of projects available for administration by this account","name":"projectavailable","type":"string"},{"description":"the total memory (in MB) the account can own","name":"memorylimit","type":"string"},{"description":"the total primary storage space (in GiB) owned by account","name":"primarystoragetotal","type":"long"},{"description":"the total number of public ip addresses allocated for this account","name":"iptotal","type":"long"},{"description":"the total number of networks the account can own","name":"networklimit","type":"string"},{"description":"the total memory (in MB) available to be created for this account","name":"memoryavailable","type":"string"},{"description":"the total number of templates which can be created by this account","name":"templatelimit","type":"string"},{"description":"the total volume which can be used by this account","name":"volumelimit","type":"string"},{"description":"the total number of networks available to be created for this account","name":"networkavailable","type":"string"},{"description":"the total number of network traffic bytes received","name":"receivedbytes","type":"long"},{"description":"the total number of virtual machines stopped for this account","name":"vmstopped","type":"integer"},{"description":"the total number of projects the account can own","name":"projectlimit","type":"string"},{"description":"the total number of projects being administrated by this account","name":"projecttotal","type":"long"},{"description":"the total number of virtual machines that can be deployed by this account","name":"vmlimit","type":"string"},{"description":"the total number of snapshots which can be stored by this account","name":"snapshotlimit","type":"string"},{"description":"details for the account","name":"accountdetails","type":"map"},{"description":"the list of acl groups that account belongs to","name":"groups","type":"list"},{"description":"account type (admin, domain-admin, user)","name":"accounttype","type":"short"},{"description":"the total number of vpcs the account can own","name":"vpclimit","type":"string"},{"description":"the total number of virtual machines available for this account to acquire","name":"vmavailable","type":"string"},{"description":"the total number of snapshots available for this account","name":"snapshotavailable","type":"string"},{"description":"the total number of cpu cores the account can own","name":"cpulimit","type":"string"},{"description":"the total secondary storage space (in GiB) owned by account","name":"secondarystoragetotal","type":"float"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the total number of network traffic bytes sent","name":"sentbytes","type":"long"},{"description":"the total number of cpu cores owned by account","name":"cputotal","type":"long"},{"description":"the total number of virtual machines running for this account","name":"vmrunning","type":"integer"},{"description":"true if the account requires cleanup","name":"iscleanuprequired","type":"boolean"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"true if account is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the total number of public ip addresses this account can acquire","name":"iplimit","type":"string"},{"description":"the total volume available for this account","name":"volumeavailable","type":"string"},{"description":"the total number of snapshots stored by this account","name":"snapshottotal","type":"long"},{"description":"the list of users associated with account","name":"user","response":[{"description":"the date and time the user account was created","name":"created","type":"date"},{"description":"the domain ID of the user","name":"domainid","type":"string"},{"description":"the user firstname","name":"firstname","type":"string"},{"description":"the source type of the user in lowercase, such as native, ldap, saml2","name":"usersource","type":"string"},{"description":"the secret key of the user","name":"secretkey","type":"string"},{"description":"the domain name of the user","name":"domain","type":"string"},{"description":"the user lastname","name":"lastname","type":"string"},{"description":"the api key of the user","name":"apikey","type":"string"},{"description":"the account ID of the user","name":"accountid","type":"string"},{"description":"the boolean value representing if the updating target is in caller's child domain","name":"iscallerchilddomain","type":"boolean"},{"description":"true if user is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the user ID","name":"id","type":"string"},{"description":"the account type of the user","name":"accounttype","type":"short"},{"description":"the type of the role","name":"roletype","type":"string"},{"description":"the user name","name":"username","type":"string"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the account name of the user","name":"account","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the timezone user was created in","name":"timezone","type":"string"},{"description":"the user email address","name":"email","type":"string"},{"description":"the user state","name":"state","type":"string"}],"type":"list"},{"description":"the name of the account","name":"name","type":"string"},{"description":"the total number of virtual machines deployed by this account","name":"vmtotal","type":"long"},{"description":"the total number of templates available to be created by this account","name":"templateavailable","type":"string"},{"description":"the total number of networks owned by account","name":"networktotal","type":"long"}]},{"description":"Lists clusters.","isasync":false,"name":"listClusters","params":[{"description":"lists clusters by hypervisor type","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"lists clusters by the cluster name","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"lists clusters by allocation state","length":255,"name":"allocationstate","required":false,"type":"string"},{"description":"lists clusters by cluster type","length":255,"name":"clustertype","required":false,"type":"string"},{"description":"whether this cluster is managed by cloudstack","length":255,"name":"managedstate","required":false,"type":"string"},{"description":"lists clusters by Pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"lists clusters by the cluster ID","length":255,"name":"id","related":"addCluster,listClusters,updateCluster","required":false,"type":"uuid"},{"description":"lists clusters by Zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"flag to display the capacity of the clusters","length":255,"name":"showcapacities","required":false,"type":"boolean"}],"related":"addCluster,updateCluster","response":[{"description":"the cluster name","name":"name","type":"string"},{"description":"the capacity of the Cluster","name":"capacity","response":[{"description":"the Zone ID","name":"zoneid","type":"string"},{"description":"the percentage of capacity currently in use","name":"percentused","type":"string"},{"description":"the total capacity available","name":"capacitytotal","type":"long"},{"description":"the Cluster ID","name":"clusterid","type":"string"},{"description":"the Pod name","name":"podname","type":"string"},{"description":"the capacity currently in use","name":"capacityused","type":"long"},{"description":"the capacity type","name":"type","type":"short"},{"description":"the Pod ID","name":"podid","type":"string"},{"description":"the Zone name","name":"zonename","type":"string"},{"description":"the Cluster name","name":"clustername","type":"string"},{"description":"the capacity name","name":"name","type":"string"},{"description":"the capacity currently in allocated","name":"capacityallocated","type":"long"}],"type":"list"},{"description":"the Pod name of the cluster","name":"podname","type":"string"},{"description":"whether this cluster is managed by cloudstack","name":"managedstate","type":"string"},{"description":"the Zone ID of the cluster","name":"zoneid","type":"string"},{"description":"the cluster ID","name":"id","type":"string"},{"description":"Meta data associated with the zone (key/value pairs)","name":"resourcedetails","type":"map"},{"description":"the hypervisor type of the cluster","name":"hypervisortype","type":"string"},{"description":"the Zone name of the cluster","name":"zonename","type":"string"},{"description":"the type of the cluster","name":"clustertype","type":"string"},{"description":"The memory overcommit ratio of the cluster","name":"memoryovercommitratio","type":"string"},{"description":"the Pod ID of the cluster","name":"podid","type":"string"},{"description":"the allocation state of the cluster","name":"allocationstate","type":"string"},{"description":"The cpu overcommit ratio of the cluster","name":"cpuovercommitratio","type":"string"},{"description":"Ovm3 VIP to use for pooling and/or clustering","name":"ovm3vip","type":"string"}]},{"description":"Lists project invitations and provides detailed information for listed invitations","isasync":false,"name":"listProjectInvitations","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"list by project id","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list invitations by id","length":255,"name":"id","related":"listProjectInvitations","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list invitations by state","length":255,"name":"state","required":false,"type":"string"},{"description":"if true, list only active invitations - having Pending state and ones that are not timed out yet","length":255,"name":"activeonly","required":false,"type":"boolean"}],"related":"","response":[{"description":"the email the invitation was sent to","name":"email","type":"string"},{"description":"the domain name where the project belongs to","name":"domain","type":"string"},{"description":"the account name of the project's owner","name":"account","type":"string"},{"description":"the id of the project","name":"projectid","type":"string"},{"description":"the domain id the project belongs to","name":"domainid","type":"string"},{"description":"the invitation state","name":"state","type":"string"},{"description":"the name of the project","name":"project","type":"string"},{"description":"the id of the invitation","name":"id","type":"string"}],"since":"3.0.0"},{"description":"Deletes project invitation","isasync":true,"name":"deleteProjectInvitation","params":[{"description":"id of the invitation","length":255,"name":"id","related":"","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"3.0.0"},{"description":"Lists all egress firewall rules for network ID.","isasync":false,"name":"listEgressFirewallRules","params":[{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the network ID for the egress firewall services","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"Lists rule with the specified ID.","length":255,"name":"id","related":"createPortForwardingRule,createIpForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the ID of IP address of the firewall services","length":255,"name":"ipaddressid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"updateEgressFirewallRule,listFirewallRules,createFirewallRule","response":[{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the public ip address id for the firewall rule","name":"ipaddressid","type":"string"},{"description":"the starting port of firewall rule's port range","name":"startport","type":"integer"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the network id of the firewall rule","name":"networkid","type":"string"},{"description":"the public ip address for the firewall rule","name":"ipaddress","type":"string"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"the ID of the firewall rule","name":"id","type":"string"},{"description":"the protocol of the firewall rule","name":"protocol","type":"string"},{"description":"the ending port of firewall rule's port range","name":"endport","type":"integer"},{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"}],"type":"list"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the cidr list to forward traffic to","name":"destcidrlist","type":"string"}]},{"description":"Updates a region","isasync":false,"name":"updateRegion","params":[{"description":"Id of region to update","length":255,"name":"id","required":true,"type":"integer"},{"description":"updates region with this end point","length":255,"name":"endpoint","required":false,"type":"string"},{"description":"updates region with this name","length":255,"name":"name","required":false,"type":"string"}],"related":"listRegions,addRegion","response":[{"description":"true if security groups support is enabled, false otherwise","name":"portableipserviceenabled","type":"boolean"},{"description":"the end point of the region","name":"endpoint","type":"string"},{"description":"the ID of the region","name":"id","type":"integer"},{"description":"true if GSLB service is enabled in the region, false otherwise","name":"gslbserviceenabled","type":"boolean"},{"description":"the name of the region","name":"name","type":"string"}]},{"description":"Deletes traffic type of a physical network","isasync":true,"name":"deleteTrafficType","params":[{"description":"traffic type id","length":255,"name":"id","related":"addTrafficType,updateTrafficType","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"3.0.0"},{"description":"Lists clusters metrics","isasync":false,"name":"listClustersMetrics","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"lists clusters by allocation state","length":255,"name":"allocationstate","required":false,"type":"string"},{"description":"lists clusters by the cluster ID","length":255,"name":"id","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"lists clusters by cluster type","length":255,"name":"clustertype","required":false,"type":"string"},{"description":"lists clusters by hypervisor type","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"lists clusters by Zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"lists clusters by the cluster name","length":255,"name":"name","required":false,"type":"string"},{"description":"lists clusters by Pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"flag to display the capacity of the clusters","length":255,"name":"showcapacities","required":false,"type":"boolean"},{"description":"whether this cluster is managed by cloudstack","length":255,"name":"managedstate","required":false,"type":"string"}],"related":"","response":[{"description":"the maximum memory deviation","name":"memorymaxdeviation","type":"string"},{"description":"the total cpu allocated in GiB","name":"memoryallocated","type":"string"},{"description":"the total cpu allocated in Ghz","name":"cpuallocated","type":"string"},{"description":"memory usage notification threshold exceeded","name":"memorythreshold","type":"boolean"},{"description":"cpu usage disable threshold exceeded","name":"cpudisablethreshold","type":"boolean"},{"description":"the total cpu used in GiB","name":"memoryused","type":"string"},{"description":"cpu allocated notification threshold exceeded","name":"cpuallocatedthreshold","type":"boolean"},{"description":"memory allocated notification threshold exceeded","name":"memoryallocatedthreshold","type":"boolean"},{"description":"the total cpu capacity in Ghz","name":"cputotal","type":"string"},{"description":"the total cpu used in Ghz","name":"cpuused","type":"string"},{"description":"running / total hosts in the cluster","name":"hosts","type":"string"},{"description":"the total cpu capacity in GiB","name":"memorytotal","type":"string"},{"description":"state of the cluster","name":"state","type":"string"},{"description":"memory usage disable threshold exceeded","name":"memorydisablethreshold","type":"boolean"},{"description":"cpu allocated disable threshold exceeded","name":"cpuallocateddisablethreshold","type":"boolean"},{"description":"memory allocated disable threshold exceeded","name":"memoryallocateddisablethreshold","type":"boolean"},{"description":"the maximum cpu deviation","name":"cpumaxdeviation","type":"string"},{"description":"cpu usage notification threshold exceeded","name":"cputhreshold","type":"boolean"}],"since":"4.9.3"},{"description":"Lists all LDAP configurations","isasync":false,"name":"listLdapConfigurations","params":[{"description":"Port","length":255,"name":"port","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"linked domain","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"Hostname","length":255,"name":"hostname","required":false,"type":"string"}],"related":"deleteLdapConfiguration,addLdapConfiguration","response":[{"description":"port teh ldap server is running on","name":"port","type":"int"},{"description":"name of the host running the ldap server","name":"hostname","type":"string"},{"description":"linked domain","name":"domainid","type":"string"}],"since":"4.2.0"},{"description":"Lists secondary staging stores.","isasync":false,"name":"listSecondaryStagingStores","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the staging store provider","length":255,"name":"provider","required":false,"type":"string"},{"description":"the staging store protocol","length":255,"name":"protocol","required":false,"type":"string"},{"description":"the name of the staging store","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the ID of the staging store","length":255,"name":"id","related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3,createSecondaryStagingStore,listSecondaryStagingStores","required":false,"type":"uuid"},{"description":"the Zone ID for the staging store","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"}],"related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3,createSecondaryStagingStore","response":[{"description":"the Zone ID of the image store","name":"zoneid","type":"string"},{"description":"the Zone name of the image store","name":"zonename","type":"string"},{"description":"the scope of the image store","name":"scope","type":"scopetype"},{"description":"the name of the image store","name":"name","type":"string"},{"description":"the url of the image store","name":"url","type":"string"},{"description":"the ID of the image store","name":"id","type":"string"},{"description":"the protocol of the image store","name":"protocol","type":"string"},{"description":"the provider name of the image store","name":"providername","type":"string"}],"since":"4.2.0"},{"description":"Creates a l2tp/ipsec remote access vpn","isasync":true,"name":"createRemoteAccessVpn","params":[{"description":"an optional field, whether to the display the vpn to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the range of ip addresses to allocate to vpn clients. The first ip in the range will be taken by the vpn server","length":255,"name":"iprange","required":false,"type":"string"},{"description":"if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitely. Has value true by default","length":255,"name":"openfirewall","required":false,"type":"boolean"},{"description":"an optional account for the VPN. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"an optional domainId for the VPN. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"public ip address id of the vpn server","length":255,"name":"publicipid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":true,"type":"uuid"}],"related":"updateRemoteAccessVpn,listRemoteAccessVpns","response":[{"description":"the account of the remote access vpn","name":"account","type":"string"},{"description":"the public ip address of the vpn server","name":"publicip","type":"string"},{"description":"the range of ips to allocate to the clients","name":"iprange","type":"string"},{"description":"the project name of the vpn","name":"project","type":"string"},{"description":"the public ip address of the vpn server","name":"publicipid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the domain id of the account of the remote access vpn","name":"domainid","type":"string"},{"description":"the id of the remote access vpn","name":"id","type":"string"},{"description":"the ipsec preshared key","name":"presharedkey","type":"string"},{"description":"the domain name of the account of the remote access vpn","name":"domain","type":"string"},{"description":"the project id of the vpn","name":"projectid","type":"string"},{"description":"is vpn for display to the regular user","name":"fordisplay","type":"boolean"}]},{"description":"Changes the service offering for a virtual machine. The virtual machine must be in a \"Stopped\" state for this command to take effect.","isasync":false,"name":"changeServiceForVirtualMachine","params":[{"description":"name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value","length":255,"name":"details","required":false,"type":"map"},{"description":"the service offering ID to apply to the virtual machine","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":true,"type":"uuid"},{"description":"The ID of the virtual machine","length":255,"name":"id","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,changeServiceForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"}],"type":"set"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"set"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"}],"type":"set"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"set"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"}],"type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"}],"type":"set"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"}],"type":"set"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"}]},{"description":"Starts a router.","isasync":true,"name":"startRouter","params":[{"description":"the ID of the router","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,startRouter,changeServiceForRouter,destroyRouter,startInternalLoadBalancerVM,rebootRouter,listRouters","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,changeServiceForRouter,destroyRouter,startInternalLoadBalancerVM,rebootRouter,listRouters","response":[{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"}],"type":"set"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"}]},{"description":"List all public, private, and privileged templates.","isasync":false,"name":"listTemplates","params":[{"description":"the template ID","length":255,"name":"id","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"show removed templates as well","length":255,"name":"showremoved","required":false,"type":"boolean"},{"description":"the template name","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"the hypervisor for which to restrict the search","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"the IDs of the templates, mutually exclusive with id","length":255,"name":"ids","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":false,"since":"4.9","type":"list"},{"description":"possible values are \"featured\", \"self\", \"selfexecutable\",\"sharedexecutable\",\"executable\", and \"community\". * featured : templates that have been marked as featured and public. * self : templates that have been registered or created by the calling user. * selfexecutable : same as self, but only returns templates that can be used to deploy a new VM. * sharedexecutable : templates ready to be deployed that have been granted to the calling user by another user. * executable : templates that are owned by the calling user, or public templates, that can be used to deploy a VM. * community : templates that have been marked as public but not featured. * all : all templates (only usable by admins).","length":255,"name":"templatefilter","required":true,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list datadisk templates by parent template id","length":255,"name":"parenttemplateid","related":"copyTemplate,listTemplates,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":false,"since":"4.4","type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list templates by zoneId","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"}],"related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","response":[{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the size of the template","name":"size","type":"long"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the template name","name":"name","type":"string"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"the tag of this template","name":"templatetag","type":"string"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"the template ID","name":"id","type":"string"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"}]},{"description":"Lists all available OS mappings for given hypervisor","isasync":false,"name":"listGuestOsMapping","params":[{"description":"list mapping by its UUID","length":255,"name":"id","related":"addGuestOsMapping,listGuestOsMapping,updateGuestOsMapping","required":false,"type":"uuid"},{"description":"list Guest OS mapping by hypervisor","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list Guest OS mapping by hypervisor version. Must be used with hypervisor parameter","length":255,"name":"hypervisorversion","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list mapping by Guest OS Type UUID","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"addGuestOsMapping,updateGuestOsMapping","response":[{"description":"version of the hypervisor for mapping","name":"hypervisorversion","type":"string"},{"description":"hypervisor specific name for the Guest OS","name":"osnameforhypervisor","type":"string"},{"description":"the hypervisor","name":"hypervisor","type":"string"},{"description":"the ID of the Guest OS mapping","name":"id","type":"string"},{"description":"the ID of the Guest OS type","name":"ostypeid","type":"string"},{"description":"is the mapping user defined","name":"isuserdefined","type":"string"},{"description":"standard display name for the Guest OS","name":"osdisplayname","type":"string"}],"since":"4.4.0"},{"description":"Creates an autoscale policy for a provision or deprovision action, the action is taken when the all the conditions evaluates to true for the specified duration. The policy is in effect once it is attached to a autscale vm group.","isasync":true,"name":"createAutoScalePolicy","params":[{"description":"the cool down period for which the policy should not be evaluated after the action has been taken","length":255,"name":"quiettime","required":false,"type":"integer"},{"description":"the list of IDs of the conditions that are being evaluated on every interval","length":255,"name":"conditionids","related":"createCondition,listConditions","required":true,"type":"list"},{"description":"the action to be executed if all the conditions evaluate to true for the specified duration.","length":255,"name":"action","required":true,"type":"string"},{"description":"the duration for which the conditions have to be true before action is taken","length":255,"name":"duration","required":true,"type":"integer"}],"related":"updateAutoScalePolicy,listAutoScalePolicies","response":[{"description":"the cool down period for which the policy should not be evaluated after the action has been taken","name":"quiettime","type":"integer"},{"description":"the account owning the autoscale policy","name":"account","type":"string"},{"description":"the list of IDs of the conditions that are being evaluated on every interval","name":"conditions","type":"list"},{"description":"the domain name of the autoscale policy","name":"domain","type":"string"},{"description":"the autoscale policy ID","name":"id","type":"string"},{"description":"the action to be executed if all the conditions evaluate to true for the specified duration.","name":"action","type":"string"},{"description":"the project name of the autoscale policy","name":"project","type":"string"},{"description":"the domain ID of the autoscale policy","name":"domainid","type":"string"},{"description":"the duration for which the conditions have to be true before action is taken","name":"duration","type":"integer"},{"description":"the project id autoscale policy","name":"projectid","type":"string"}]},{"description":"Removes stratosphere ssp server","isasync":false,"name":"deleteStratosphereSsp","params":[{"description":"the host ID of ssp server","length":255,"name":"hostid","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists physical networks","isasync":false,"name":"listPhysicalNetworks","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the Zone ID for the physical network","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"search by name","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list physical network by id","length":255,"name":"id","related":"updatePhysicalNetwork,createPhysicalNetwork,listPhysicalNetworks","required":false,"type":"uuid"}],"related":"updatePhysicalNetwork,createPhysicalNetwork","response":[{"description":"name of the physical network","name":"name","type":"string"},{"description":"zone id of the physical network","name":"zoneid","type":"string"},{"description":"comma separated tag","name":"tags","type":"string"},{"description":"Broadcast domain range of the physical network","name":"broadcastdomainrange","type":"string"},{"description":"state of the physical network","name":"state","type":"string"},{"description":"the vlan of the physical network","name":"vlan","type":"string"},{"description":"isolation methods","name":"isolationmethods","type":"string"},{"description":"the speed of the physical network","name":"networkspeed","type":"string"},{"description":"the uuid of the physical network","name":"id","type":"string"},{"description":"the domain id of the physical network owner","name":"domainid","type":"string"}],"since":"3.0.0"},{"description":"Enables HA for a zone","isasync":true,"name":"enableHAForZone","params":[{"description":"ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.11"},{"description":" delete a Brocade VCS Switch","isasync":true,"name":"deleteBrocadeVcsDevice","params":[{"description":"Brocade Switch ID","length":255,"name":"vcsdeviceid","related":"listBrocadeVcsDevices,addBrocadeVcsDevice","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Cleanups VM reservations in the database.","isasync":true,"name":"cleanVMReservations","params":[],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists all firewall rules for an IP address.","isasync":false,"name":"listFirewallRules","params":[{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the ID of IP address of the firewall services","length":255,"name":"ipaddressid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list firewall rules for certain network","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"since":"4.3","type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"Lists rule with the specified ID.","length":255,"name":"id","related":"createPortForwardingRule,createIpForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"}],"related":"updateEgressFirewallRule,createFirewallRule","response":[{"description":"the state of the rule","name":"state","type":"string"},{"description":"the starting port of firewall rule's port range","name":"startport","type":"integer"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the network id of the firewall rule","name":"networkid","type":"string"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"the protocol of the firewall rule","name":"protocol","type":"string"},{"description":"the cidr list to forward traffic to","name":"destcidrlist","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"list"},{"description":"the ending port of firewall rule's port range","name":"endport","type":"integer"},{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"the public ip address for the firewall rule","name":"ipaddress","type":"string"},{"description":"the public ip address id for the firewall rule","name":"ipaddressid","type":"string"},{"description":"the ID of the firewall rule","name":"id","type":"string"}]},{"description":"Extracts an ISO","isasync":true,"name":"extractIso","params":[{"description":"the URL to which the ISO would be extracted","length":2048,"name":"url","required":false,"type":"string"},{"description":"the ID of the ISO file","length":255,"name":"id","related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":true,"type":"uuid"},{"description":"the ID of the zone where the ISO is originally located","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the mode of extraction - HTTP_DOWNLOAD or FTP_UPLOAD","length":255,"name":"mode","required":true,"type":"string"}],"related":"extractTemplate,extractVolume","response":[{"description":"the state of the extracted object","name":"state","type":"string"},{"description":"the name of the extracted object","name":"name","type":"string"},{"description":"the status of the extraction","name":"status","type":"string"},{"description":"zone ID the object was extracted from","name":"zoneid","type":"string"},{"description":"if mode = upload then url of the uploaded entity. if mode = download the url from which the entity can be downloaded","name":"url","type":"string"},{"description":"the upload id of extracted object","name":"extractId","type":"string"},{"description":"the percentage of the entity uploaded to the specified location","name":"uploadpercentage","type":"integer"},{"description":"the mode of extraction - upload or download","name":"extractMode","type":"string"},{"description":"the time and date the object was created","name":"created","type":"date"},{"description":"zone name the object was extracted from","name":"zonename","type":"string"},{},{"description":"the account id to which the extracted object belongs","name":"accountid","type":"string"},{"description":"type of the storage","name":"storagetype","type":"string"},{"description":"","name":"resultstring","type":"string"},{"description":"the id of extracted object","name":"id","type":"string"}]},{"description":"Creates an affinity/anti-affinity group","isasync":true,"name":"createAffinityGroup","params":[{"description":"domainId of the account owning the affinity group","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"Type of the affinity group from the available affinity/anti-affinity group types","length":255,"name":"type","required":true,"type":"string"},{"description":"optional description of the affinity group","length":255,"name":"description","required":false,"type":"string"},{"description":"create affinity group for project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"name of the affinity group","length":255,"name":"name","required":true,"type":"string"},{"description":"an account for the affinity group. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"}],"related":"","response":[{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"}]},{"description":"create secondary staging store.","isasync":false,"name":"createSecondaryStagingStore","params":[{"description":"the scope of the staging store: zone only for now","length":255,"name":"scope","required":false,"type":"string"},{"description":"the Zone ID for the staging store","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the details for the staging store","length":255,"name":"details","required":false,"type":"map"},{"description":"the staging store provider name","length":255,"name":"provider","required":false,"type":"string"},{"description":"the URL for the staging store","length":2048,"name":"url","required":true,"type":"string"}],"related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3","response":[{"description":"the provider name of the image store","name":"providername","type":"string"},{"description":"the scope of the image store","name":"scope","type":"scopetype"},{"description":"the ID of the image store","name":"id","type":"string"},{"description":"the name of the image store","name":"name","type":"string"},{"description":"the Zone name of the image store","name":"zonename","type":"string"},{"description":"the protocol of the image store","name":"protocol","type":"string"},{"description":"the Zone ID of the image store","name":"zoneid","type":"string"},{"description":"the url of the image store","name":"url","type":"string"}]},{"description":"Remove a VMware datacenter from a zone.","isasync":false,"name":"removeVmwareDc","params":[{"description":"The id of Zone from which VMware datacenter has to be removed.","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists all available Internal Load Balancer elements.","isasync":false,"name":"listInternalLoadBalancerElements","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list internal load balancer elements by enabled state","length":255,"name":"enabled","required":false,"type":"boolean"},{"description":"list internal load balancer elements by id","length":255,"name":"id","related":"createInternalLoadBalancerElement,configureInternalLoadBalancerElement,listInternalLoadBalancerElements","required":false,"type":"uuid"},{"description":"list internal load balancer elements by network service provider id","length":255,"name":"nspid","related":"updateNetworkServiceProvider,listTrafficTypes,addNetworkServiceProvider,listNetworkServiceProviders","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"createInternalLoadBalancerElement,configureInternalLoadBalancerElement","response":[{"description":"Enabled/Disabled the element","name":"enabled","type":"boolean"},{"description":"the id of the internal load balancer element","name":"id","type":"string"},{"description":"the physical network service provider id of the element","name":"nspid","type":"string"}],"since":"4.2.0"},{"description":"Updates load balancer health check policy","isasync":true,"name":"updateLBHealthCheckPolicy","params":[{"description":"an optional field, whether to the display the policy to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"ID of load balancer health check policy","length":255,"name":"id","related":"updateLBHealthCheckPolicy,listLBHealthCheckPolicies,createLBHealthCheckPolicy","required":true,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"}],"related":"listLBHealthCheckPolicies,createLBHealthCheckPolicy","response":[{"description":"the list of healthcheckpolicies","name":"healthcheckpolicy","response":[{"description":"the LB HealthCheck policy ID","name":"id","type":"string"},{"description":"the pingpath  of the healthcheck policy","name":"pingpath","type":"string"},{"description":"Amount of time between health checks","name":"healthcheckinterval","type":"int"},{"description":"Number of consecutive health check success before declaring an instance healthy","name":"healthcheckthresshold","type":"int"},{"description":"is policy for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the state of the policy","name":"state","type":"string"},{"description":"Number of consecutive health check failures before declaring an instance unhealthy.","name":"unhealthcheckthresshold","type":"int"},{"description":"Time to wait when receiving a response from the health check","name":"responsetime","type":"int"},{"description":"the description of the healthcheck policy","name":"description","type":"string"}],"type":"list"},{"description":"the account of the HealthCheck policy","name":"account","type":"string"},{"description":"the id of the zone the HealthCheck policy belongs to","name":"zoneid","type":"string"},{"description":"the LB rule ID","name":"lbruleid","type":"string"},{"description":"the domain of the HealthCheck policy","name":"domain","type":"string"},{"description":"the domain ID of the HealthCheck policy","name":"domainid","type":"string"}],"since":"4.4"},{"description":"Reboots a virtual machine.","isasync":true,"name":"rebootVirtualMachine","params":[{"description":"The ID of the virtual machine","length":255,"name":"id","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,rebootVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"}],"type":"set"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"}],"type":"set"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"}],"type":"set"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"}],"type":"set"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"}],"type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"}],"type":"set"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the group name of the virtual machine","name":"group","type":"string"}]},{"description":"Enables HA cluster-wide","isasync":true,"name":"enableHAForCluster","params":[{"description":"ID of the cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.11"},{"description":"Creates a load balancer rule","isasync":true,"name":"createLoadBalancerRule","params":[{"description":"the account associated with the load balancer. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the CIDR list to forward traffic from","length":255,"name":"cidrlist","required":false,"type":"list"},{"description":"the private port of the private IP address/virtual machine where the network traffic will be load balanced to","length":255,"name":"privateport","required":true,"type":"integer"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"public IP address ID from where the network traffic will be load balanced from","length":255,"name":"publicipid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"},{"description":"the description of the load balancer rule","length":4096,"name":"description","required":false,"type":"string"},{"description":"if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitely. If not specified 1) defaulted to false when LB rule is being created for VPC guest network 2) in all other cases defaulted to true","length":255,"name":"openfirewall","required":false,"type":"boolean"},{"description":"The guest network this rule will be created for. Required when public Ip address is not associated with any Guest network yet (VPC case)","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"load balancer algorithm (source, roundrobin, leastconn)","length":255,"name":"algorithm","required":true,"type":"string"},{"description":"The protocol for the LB","length":255,"name":"protocol","required":false,"type":"string"},{"description":"the public port from where the network traffic will be load balanced from","length":255,"name":"publicport","required":true,"type":"integer"},{"description":"zone where the load balancer is going to be created. This parameter is required when LB service provider is ElasticLoadBalancerVm","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"name of the load balancer rule","length":255,"name":"name","required":true,"type":"string"},{"description":"the domain ID associated with the load balancer","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"}],"related":"updateLoadBalancerRule,listLoadBalancerRules","response":[{"description":"the public ip address","name":"publicip","type":"string"},{"description":"the project name of the load balancer","name":"project","type":"string"},{"description":"the public port","name":"publicport","type":"string"},{"description":"the account of the load balancer rule","name":"account","type":"string"},{"description":"the domain ID of the load balancer rule","name":"domainid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the id of the guest network the lb rule belongs to","name":"networkid","type":"string"},{"description":"the id of the zone the rule belongs to","name":"zoneid","type":"string"},{"description":"the public ip address id","name":"publicipid","type":"string"},{"description":"the name of the load balancer","name":"name","type":"string"},{"description":"the protocol of the loadbalanacer rule","name":"protocol","type":"string"},{"description":"the private port","name":"privateport","type":"string"},{"description":"the list of resource tags associated with load balancer","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"list"},{"description":"the description of the load balancer","name":"description","type":"string"},{"description":"the load balancer rule ID","name":"id","type":"string"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the load balancer algorithm (source, roundrobin, leastconn)","name":"algorithm","type":"string"},{"description":"the project id of the load balancer","name":"projectid","type":"string"},{"description":"the domain of the load balancer rule","name":"domain","type":"string"},{"description":"the name of the zone the load balancer rule belongs to","name":"zonename","type":"string"}]},{"description":"Lists Nuage VSP domain templates","isasync":false,"name":"listNuageVspDomainTemplates","params":[{"description":"the zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the domain ID","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"the physical network ID","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork","required":false,"type":"uuid"},{"description":"filters the domain templates which contain the keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"listNuageVspGlobalDomainTemplate,upgradeRouterTemplate","response":[{"description":"the UUID of the latest async job acting on this object","name":"jobid","type":"string"},{},{},{"description":"the current status of the latest async job acting on this object","name":"jobstatus","type":"integer"}],"since":"4.11.0"},{"description":"Adds a guest OS name to hypervisor OS name mapping","isasync":true,"name":"addGuestOsMapping","params":[{"description":"Hypervisor version to create the mapping for. Use 'default' for default versions","length":255,"name":"hypervisorversion","required":true,"type":"string"},{"description":"Display Name of Guest OS standard type. Either Display Name or UUID must be passed","length":255,"name":"osdisplayname","required":false,"type":"string"},{"description":"Hypervisor type. One of : XenServer, KVM, VMWare","length":255,"name":"hypervisor","required":true,"type":"string"},{"description":"OS name specific to the hypervisor","length":255,"name":"osnameforhypervisor","required":true,"type":"string"},{"description":"UUID of Guest OS type. Either the UUID or Display Name must be passed","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"}],"related":"updateGuestOsMapping","response":[{"description":"the ID of the Guest OS type","name":"ostypeid","type":"string"},{"description":"version of the hypervisor for mapping","name":"hypervisorversion","type":"string"},{"description":"hypervisor specific name for the Guest OS","name":"osnameforhypervisor","type":"string"},{"description":"the ID of the Guest OS mapping","name":"id","type":"string"},{"description":"standard display name for the Guest OS","name":"osdisplayname","type":"string"},{"description":"is the mapping user defined","name":"isuserdefined","type":"string"},{"description":"the hypervisor","name":"hypervisor","type":"string"}],"since":"4.4.0"},{"description":"Disables out-of-band management for a zone","isasync":true,"name":"disableOutOfBandManagementForZone","params":[{"description":"the ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"enableOutOfBandManagementForCluster,enableOutOfBandManagementForHost,issueOutOfBandManagementPowerAction,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,changeOutOfBandManagementPassword,disableOutOfBandManagementForHost","response":[{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"},{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the operation result description","name":"description","type":"string"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"the out-of-band management interface port","name":"port","type":"string"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"},{"description":"the out-of-band management interface address","name":"address","type":"string"}],"since":"4.9.0"},{"description":"configures a F5 load balancer device","isasync":true,"name":"configureF5LoadBalancer","params":[{"description":"F5 load balancer device ID","length":255,"name":"lbdeviceid","related":"listF5LoadBalancers,addF5LoadBalancer,configureF5LoadBalancer","required":true,"type":"uuid"},{"description":"capacity of the device, Capacity will be interpreted as number of networks device can handle","length":255,"name":"lbdevicecapacity","required":false,"type":"long"}],"related":"listF5LoadBalancers,addF5LoadBalancer","response":[{"description":"the physical network to which this F5 device belongs to","name":"physicalnetworkid","type":"string"},{"description":"the private interface of the load balancer","name":"privateinterface","type":"string"},{"description":"true if device is dedicated for an account","name":"lbdevicededicated","type":"boolean"},{"description":"device id of the F5 load balancer","name":"lbdeviceid","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"device state","name":"lbdevicestate","type":"string"},{"description":"the management IP address of the external load balancer","name":"ipaddress","type":"string"},{"description":"device capacity","name":"lbdevicecapacity","type":"long"},{"description":"the public interface of the load balancer","name":"publicinterface","type":"string"},{"description":"device name","name":"lbdevicename","type":"string"}]},{"description":"Updates a network offering.","isasync":false,"name":"updateNetworkOffering","params":[{"description":"update state for the network offering","length":255,"name":"state","required":false,"type":"string"},{"description":"the tags for the network offering.","length":4096,"name":"tags","required":false,"type":"string"},{"description":"the id of the network offering","length":255,"name":"id","related":"createNetworkOffering,updateNetworkOffering,listNetworkOfferings","required":false,"type":"uuid"},{"description":"if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.","length":255,"name":"keepaliveenabled","required":false,"type":"boolean"},{"description":"the display text of the network offering","length":255,"name":"displaytext","required":false,"type":"string"},{"description":"the name of the network offering","length":255,"name":"name","required":false,"type":"string"},{"description":"maximum number of concurrent connections supported by the network offering","length":255,"name":"maxconnections","required":false,"type":"integer"},{"description":"sort key of the network offering, integer","length":255,"name":"sortkey","required":false,"type":"integer"},{"description":"the availability of network offering. Default value is Required for Guest Virtual network offering; Optional for Guest Direct network offering","length":255,"name":"availability","required":false,"type":"string"}],"related":"createNetworkOffering,listNetworkOfferings","response":[{"description":"true if network offering is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the date this network offering was created","name":"created","type":"date"},{"description":"an alternate display text of the network offering.","name":"displaytext","type":"string"},{"description":"availability of the network offering","name":"availability","type":"string"},{"description":"additional key/value details tied with network offering","name":"details","type":"map"},{"description":"true if network offering supports public access for guest networks","name":"supportspublicaccess","type":"boolean"},{"description":"data transfer rate in megabits per second allowed.","name":"networkrate","type":"integer"},{"description":"the ID of the service offering used by virtual router provider","name":"serviceofferingid","type":"string"},{"description":"true if network offering can be used by VPC networks only","name":"forvpc","type":"boolean"},{"description":"the id of the network offering","name":"id","type":"string"},{"description":"the tags for the network offering","name":"tags","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"conservemode","type":"boolean"},{"description":"true if network offering supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"the list of supported services","name":"service","response":[{"description":"the service provider name","name":"provider","response":[{"description":"state of the network provider","name":"state","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"the provider name","name":"name","type":"string"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability name","name":"name","type":"string"},{"description":"the capability value","name":"value","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"}],"type":"list"},{"description":"state of the network offering. Can be Disabled/Enabled/Inactive","name":"state","type":"string"},{"description":"maximum number of concurrents connections to be handled by lb","name":"maxconnections","type":"integer"},{"description":"true if network offering supports persistent networks, false otherwise","name":"ispersistent","type":"boolean"},{"description":"the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.","name":"traffictype","type":"string"},{"description":"true if network offering supports vlans, false otherwise","name":"specifyvlan","type":"boolean"},{"description":"true if network offering supports network that span multiple zones","name":"supportsstrechedl2subnet","type":"boolean"},{"description":"the name of the network offering","name":"name","type":"string"},{"description":"guest type of the network offering, can be Shared or Isolated","name":"guestiptype","type":"string"},{"description":"true if guest network default egress policy is allow; false if default egress policy is deny","name":"egressdefaultpolicy","type":"boolean"}]},{"description":"Deletes an egress firewall rule","isasync":true,"name":"deleteEgressFirewallRule","params":[{"description":"the ID of the firewall rule","length":255,"name":"id","related":"createPortForwardingRule,createIpForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Updates a VPC","isasync":true,"name":"updateVPC","params":[{"description":"an optional field, whether to the display the vpc to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the id of the VPC","length":255,"name":"id","related":"restartVPC,createVPC,createVPC,updateVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":true,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"the name of the VPC","length":255,"name":"name","required":false,"type":"string"},{"description":"the display text of the VPC","length":255,"name":"displaytext","required":false,"type":"string"}],"related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","response":[{"description":"an alternate display text of the VPC.","name":"displaytext","type":"string"},{"description":"the date this VPC was created","name":"created","type":"date"},{"description":"the name of the VPC","name":"name","type":"string"},{"description":"the project id of the VPC","name":"projectid","type":"string"},{"description":"if this VPC has redundant router","name":"redundantvpcrouter","type":"boolean"},{"description":"true if VPC is region level","name":"regionlevelvpc","type":"boolean"},{"description":"is VPC uses distributed router for one hop forwarding and host based network ACL's","name":"distributedvpcrouter","type":"boolean"},{"description":"the list of resource tags associated with the project","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"},{"description":"the list of supported services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the provider name","name":"name","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"uuid of the network provider","name":"id","type":"string"}],"type":"list"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability name","name":"name","type":"string"}],"type":"list"}],"type":"list"},{"description":"the project name of the VPC","name":"project","type":"string"},{"description":"vpc offering id the VPC is created from","name":"vpcofferingid","type":"string"},{"description":"the id of the VPC","name":"id","type":"string"},{"description":"true VPC requires restart","name":"restartrequired","type":"boolean"},{"description":"the name of the zone the VPC belongs to","name":"zonename","type":"string"},{"description":"zone id of the vpc","name":"zoneid","type":"string"},{"description":"the list of networks belongign to the VPC","name":"network","response":[{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"the id of the network","name":"id","type":"string"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"state of the network","name":"state","type":"string"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"the type of the network","name":"type","type":"string"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"the list of services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the provider name","name":"name","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"}],"type":"list"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability name","name":"name","type":"string"}],"type":"list"}],"type":"list"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"the name of the network","name":"name","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"}],"type":"list"},{"description":"the owner of the VPC","name":"account","type":"string"},{"description":"state of the VPC. Can be Inactive/Enabled","name":"state","type":"string"},{"description":"the cidr the VPC","name":"cidr","type":"string"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"the network domain of the VPC","name":"networkdomain","type":"string"},{"description":"is vpc for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the domain id of the VPC owner","name":"domainid","type":"string"}]},{"description":"Stops a system VM.","isasync":true,"name":"stopSystemVm","params":[{"description":"Force stop the VM.  The caller knows the VM is stopped.","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"The ID of the system virtual machine","length":255,"name":"id","related":"changeServiceForSystemVm,startSystemVm,listSystemVms,stopSystemVm,migrateSystemVm","required":true,"type":"uuid"}],"related":"changeServiceForSystemVm,startSystemVm,listSystemVms,migrateSystemVm","response":[{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"},{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"},{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the state of the system VM","name":"state","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"},{"description":"the gateway for the system VM","name":"gateway","type":"string"}]},{"description":"Changes out-of-band management interface password on the host and updates the interface configuration in CloudStack if the operation succeeds, else reverts the old password","isasync":true,"name":"changeOutOfBandManagementPassword","params":[{"description":"the ID of the host","length":255,"name":"hostid","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"},{"description":"the new host management interface password of maximum length 16, if none is provided a random password would be used","length":255,"name":"password","required":false,"type":"string"}],"related":"enableOutOfBandManagementForCluster,enableOutOfBandManagementForHost,issueOutOfBandManagementPowerAction,disableOutOfBandManagementForCluster,enableOutOfBandManagementForZone,disableOutOfBandManagementForHost","response":[{"description":"the out-of-band management interface address","name":"address","type":"string"},{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"},{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"the out-of-band management interface port","name":"port","type":"string"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"},{"description":"the operation result description","name":"description","type":"string"}],"since":"4.9.0"},{"description":"List resource detail(s)","isasync":false,"name":"listResourceDetails","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list by resource type","length":255,"name":"resourcetype","required":true,"type":"string"},{"description":"list by key, value. Needs to be passed only along with key","length":255,"name":"value","required":false,"since":"4.4","type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list by key","length":255,"name":"key","required":false,"type":"string"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list by resource id","length":255,"name":"resourceid","required":false,"type":"string"},{"description":"if set to true, only details marked with display=true, are returned. False by default","length":255,"name":"fordisplay","required":false,"since":"4.3","type":"boolean"}],"related":"listTags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"since":"4.2"},{"description":"enable Nuage underlay on vlan ip range","isasync":false,"name":"listNuageUnderlayVlanIpRanges","params":[{"description":"true to list only underlay enabled, false if not, empty for all","length":255,"name":"underlay","required":false,"type":"boolean"},{"description":"the Pod ID of the VLAN IP range","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"physical network id of the VLAN IP range","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork","required":false,"type":"uuid"},{"description":"the account with which the VLAN IP range is associated. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the Zone ID of the VLAN IP range","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the ID or VID of the VLAN. Default is an \"untagged\" VLAN.","length":255,"name":"vlan","required":false,"type":"string"},{"description":"project who will own the VLAN","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"network id of the VLAN IP range","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"true if VLAN is of Virtual type, false if Direct","length":255,"name":"forvirtualnetwork","required":false,"type":"boolean"},{"description":"the ID of the VLAN IP range","length":255,"name":"id","related":"listVlanIpRanges,dedicatePublicIpRange,createVlanIpRange","required":false,"type":"uuid"},{"description":"the domain ID with which the VLAN IP range is associated.  If used with the account parameter, returns all VLAN IP ranges for that account in the specified domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"}],"related":"","response":[{"description":"true if Nuage underlay enabled, false if not","name":"underlay","type":"boolean"}],"since":"4.10"},{"description":"Creates a network offering.","isasync":false,"name":"createNetworkOffering","params":[{"description":"desired service capabilities as part of network offering","length":255,"name":"servicecapabilitylist","required":false,"type":"map"},{"description":"maximum number of concurrent connections supported by the network offering","length":255,"name":"maxconnections","required":false,"type":"integer"},{"description":"if true keepalive will be turned on in the loadbalancer. At the time of writing this has only an effect on haproxy; the mode http and httpclose options are unset in the haproxy conf file.","length":255,"name":"keepaliveenabled","required":false,"type":"boolean"},{"description":"the service offering ID used by virtual router provider","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":false,"type":"uuid"},{"description":"true if network offering supports vlans","length":255,"name":"specifyvlan","required":false,"type":"boolean"},{"description":"the traffic type for the network offering. Supported type in current release is GUEST only","length":255,"name":"traffictype","required":true,"type":"string"},{"description":"true if guest network default egress policy is allow; false if default egress policy is deny","length":255,"name":"egressdefaultpolicy","required":false,"type":"boolean"},{"description":"the availability of network offering. Default value is Optional","length":255,"name":"availability","required":false,"type":"string"},{"description":"the display text of the network offering","length":255,"name":"displaytext","required":true,"type":"string"},{"description":"Network offering details in key/value pairs. Supported keys are internallbprovider/publiclbprovider with service provider as a value, and promiscuousmode/macaddresschanges/forgedtransmits with true/false as value to accept/reject the security settings if available for a nic/portgroup","length":255,"name":"details","required":false,"since":"4.2.0","type":"map"},{"description":"guest type of the network offering: Shared or Isolated","length":255,"name":"guestiptype","required":true,"type":"string"},{"description":"true if the network offering is IP conserve mode enabled","length":255,"name":"conservemode","required":false,"type":"boolean"},{"description":"true if network offering is meant to be used for VPC, false otherwise.","length":255,"name":"forvpc","required":false,"type":"boolean"},{"description":"services supported by the network offering","length":255,"name":"supportedservices","required":true,"type":"list"},{"description":"true if network offering supports persistent networks; defaulted to false if not specified","length":255,"name":"ispersistent","required":false,"type":"boolean"},{"description":"true if network offering supports specifying ip ranges; defaulted to false if not specified","length":255,"name":"specifyipranges","required":false,"type":"boolean"},{"description":"provider to service mapping. If not specified, the provider for the service will be mapped to the default provider on the physical network","length":255,"name":"serviceproviderlist","required":false,"type":"map"},{"description":"the tags for the network offering.","length":4096,"name":"tags","required":false,"type":"string"},{"description":"data transfer rate in megabits per second allowed","length":255,"name":"networkrate","required":false,"type":"integer"},{"description":"the name of the network offering","length":255,"name":"name","required":true,"type":"string"}],"related":"listNetworkOfferings","response":[{"description":"true if network offering is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"true if guest network default egress policy is allow; false if default egress policy is deny","name":"egressdefaultpolicy","type":"boolean"},{"description":"true if network offering can be used by VPC networks only","name":"forvpc","type":"boolean"},{"description":"an alternate display text of the network offering.","name":"displaytext","type":"string"},{"description":"the date this network offering was created","name":"created","type":"date"},{"description":"maximum number of concurrents connections to be handled by lb","name":"maxconnections","type":"integer"},{"description":"guest type of the network offering, can be Shared or Isolated","name":"guestiptype","type":"string"},{"description":"additional key/value details tied with network offering","name":"details","type":"map"},{"description":"true if network offering is ip conserve mode enabled","name":"conservemode","type":"boolean"},{"description":"the ID of the service offering used by virtual router provider","name":"serviceofferingid","type":"string"},{"description":"the id of the network offering","name":"id","type":"string"},{"description":"the traffic type for the network offering, supported types are Public, Management, Control, Guest, Vlan or Storage.","name":"traffictype","type":"string"},{"description":"state of the network offering. Can be Disabled/Enabled/Inactive","name":"state","type":"string"},{"description":"the name of the network offering","name":"name","type":"string"},{"description":"true if network offering supports network that span multiple zones","name":"supportsstrechedl2subnet","type":"boolean"},{"description":"data transfer rate in megabits per second allowed.","name":"networkrate","type":"integer"},{"description":"the list of supported services","name":"service","response":[{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the provider name","name":"name","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"}],"type":"list"}],"type":"list"},{"description":"true if network offering supports public access for guest networks","name":"supportspublicaccess","type":"boolean"},{"description":"availability of the network offering","name":"availability","type":"string"},{"description":"true if network offering supports persistent networks, false otherwise","name":"ispersistent","type":"boolean"},{"description":"the tags for the network offering","name":"tags","type":"string"},{"description":"true if network offering supports vlans, false otherwise","name":"specifyvlan","type":"boolean"},{"description":"true if network offering supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"}],"since":"3.0.0"},{"description":"Dedicate an existing cluster","isasync":true,"name":"dedicateCluster","params":[{"description":"the ID of the Cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":true,"type":"uuid"},{"description":"the ID of the containing domain","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":true,"type":"uuid"},{"description":"the name of the account which needs dedication. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"}],"related":"listDedicatedClusters","response":[{"description":"the Dedication Affinity Group ID of the cluster","name":"affinitygroupid","type":"string"},{"description":"the ID of the cluster","name":"clusterid","type":"string"},{"description":"the domain ID of the cluster","name":"domainid","type":"string"},{"description":"the Account ID of the cluster","name":"accountid","type":"string"},{"description":"the name of the cluster","name":"clustername","type":"string"},{"description":"the ID of the dedicated resource","name":"id","type":"string"}]},{"description":"Creates an IP forwarding rule","isasync":true,"name":"createIpForwardingRule","params":[{"description":"the public IP address ID of the forwarding rule, already associated via associateIp","length":255,"name":"ipaddressid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":true,"type":"uuid"},{"description":"the end port for the rule","length":255,"name":"endport","required":false,"type":"integer"},{"description":"if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. Has value true by default","length":255,"name":"openfirewall","required":false,"type":"boolean"},{"description":"the protocol for the rule. Valid values are TCP or UDP.","length":255,"name":"protocol","required":true,"type":"string"},{"description":"the start port for the rule","length":255,"name":"startport","required":true,"type":"integer"},{"description":"the CIDR list to forward traffic from","length":255,"name":"cidrlist","required":false,"type":"list"}],"related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","response":[{"description":"the ending port of port forwarding rule's private port range","name":"privateendport","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"the ID of the port forwarding rule","name":"id","type":"string"},{"description":"is firewall for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the starting port of port forwarding rule's private port range","name":"privateport","type":"string"},{"description":"the public ip address id for the port forwarding rule","name":"ipaddressid","type":"string"},{"description":"the id of the guest network the port forwarding rule belongs to","name":"networkid","type":"string"},{"description":"the starting port of port forwarding rule's public port range","name":"publicport","type":"string"},{"description":"the VM ID for the port forwarding rule","name":"virtualmachineid","type":"string"},{"description":"the VM display name for the port forwarding rule","name":"virtualmachinedisplayname","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"publicendport","type":"string"},{"description":"the VM name for the port forwarding rule","name":"virtualmachinename","type":"string"},{"description":"the public ip address for the port forwarding rule","name":"ipaddress","type":"string"},{"description":"the protocol of the port forwarding rule","name":"protocol","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the vm ip address for the port forwarding rule","name":"vmguestip","type":"string"},{"description":"the state of the rule","name":"state","type":"string"}]},{"description":"Lists the network Interfaces of elastistor","isasync":false,"name":"listElastistorInterface","params":[{"description":"controller id","length":255,"name":"controllerid","required":false,"type":"string"}],"related":"listElastistorVolume","response":[{"description":"syncronization","name":"sync","type":"string"},{"description":"deduplication","name":"deduplication","type":"string"},{"description":"the id of the volume","name":"id","type":"string"},{"description":"graceallowed","name":"graceallowed","type":"string"},{"description":"the name of the volume","name":"name","type":"string"},{"description":"compression","name":"compression","type":"string"}]},{"description":"Lists volume metrics","isasync":false,"name":"listVolumesMetrics","params":[{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"displayvolume","required":false,"since":"4.4","type":"boolean"},{"description":"the ID of the virtual machine","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,updateVmNicIp,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the pod id the disk volume belongs to","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"the ID of the disk volume","length":255,"name":"id","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"type":"uuid"},{"description":"the name of the disk volume","length":255,"name":"name","required":false,"type":"string"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"the ID of the storage pool, available to ROOT admin only","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"since":"4.3","type":"string"},{"description":"list volumes on specified host","length":255,"name":"hostid","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"the IDs of the volumes, mutually exclusive with id","length":255,"name":"ids","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"since":"4.9","type":"list"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list volumes by disk offering","length":255,"name":"diskofferingid","related":"listDiskOfferings,updateDiskOffering,createDiskOffering","required":false,"since":"4.4","type":"uuid"},{"description":"the ID of the availability zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the cluster id the disk volume belongs to","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"the type of disk volume","length":255,"name":"type","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"","response":[{"description":"disk size in GiB","name":"sizegb","type":"string"}],"since":"4.9.3"},{"description":"Lists SSL certificates","isasync":false,"name":"listSslCerts","params":[{"description":"Project that owns the SSL certificate","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"Account ID","length":255,"name":"accountid","related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,markDefaultZoneForAccount,disableAccount","required":false,"type":"uuid"},{"description":"Load balancer rule ID","length":255,"name":"lbruleid","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":false,"type":"uuid"},{"description":"ID of SSL certificate","length":255,"name":"certid","related":"listSslCerts,uploadSslCert","required":false,"type":"uuid"}],"related":"uploadSslCert","response":[{"description":"certificate fingerprint","name":"fingerprint","type":"string"},{"description":"certificate","name":"certificate","type":"string"},{"description":"certificate chain","name":"certchain","type":"string"},{"description":"SSL certificate ID","name":"id","type":"string"},{"description":"the project name of the certificate","name":"project","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"List of loabalancers this certificate is bound to","name":"loadbalancerrulelist","type":"list"},{"description":"account for the certificate","name":"account","type":"string"},{"description":"the project id of the certificate","name":"projectid","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"name","name":"name","type":"string"}]},{"description":"Update the default Ip of a VM Nic","isasync":true,"name":"updateVmNicIp","params":[{"description":"the ID of the nic to which you want to assign private IP","length":255,"name":"nicid","related":"listNics","required":true,"type":"uuid"},{"description":"Secondary IP Address","length":255,"name":"ipaddress","required":false,"type":"string"}],"related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"set"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"}],"type":"set"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"}],"type":"set"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"}],"type":"set"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"}],"type":"set"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"}],"type":"set"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"}]},{"description":"List private gateways","isasync":false,"name":"listPrivateGateways","params":[{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list gateways by vpc","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list gateways by ip address","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list gateways by state","length":255,"name":"state","required":false,"type":"string"},{"description":"list private gateway by id","length":255,"name":"id","related":"createPrivateGateway,listPrivateGateways","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list gateways by vlan","length":255,"name":"vlan","required":false,"type":"string"}],"related":"createPrivateGateway","response":[{"description":"the project id of the private gateway","name":"projectid","type":"string"},{"description":"State of the gateway, can be Creating, Ready, Deleting","name":"state","type":"string"},{"description":"zone id of the private gateway","name":"zoneid","type":"string"},{"description":"VPC the private gateaway belongs to","name":"vpcid","type":"string"},{"description":"the ID of the domain associated with the private gateway","name":"domainid","type":"string"},{"description":"the account associated with the private gateway","name":"account","type":"string"},{"description":"the private gateway's ip address","name":"ipaddress","type":"string"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"the gateway","name":"gateway","type":"string"},{"description":"the name of the zone the private gateway belongs to","name":"zonename","type":"string"},{"description":"the project name of the private gateway","name":"project","type":"string"},{"description":"the id of the private gateway","name":"id","type":"string"},{"description":"Souce Nat enable status","name":"sourcenatsupported","type":"boolean"},{"description":"the private gateway's netmask","name":"netmask","type":"string"},{"description":"the domain associated with the private gateway","name":"domain","type":"string"},{"description":"ACL Id set for private gateway","name":"aclid","type":"string"},{"description":"the network implementation uri for the private gateway","name":"vlan","type":"string"}]},{"description":"Updates load balancer stickiness policy","isasync":true,"name":"updateLBStickinessPolicy","params":[{"description":"id of lb stickiness policy","length":255,"name":"id","related":"createLBStickinessPolicy,updateLBStickinessPolicy,listLBStickinessPolicies","required":true,"type":"uuid"},{"description":"an optional field, whether to the display the policy to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"}],"related":"createLBStickinessPolicy,listLBStickinessPolicies","response":[{"description":"the account of the Stickiness policy","name":"account","type":"string"},{"description":"the list of stickinesspolicies","name":"stickinesspolicy","response":[{"description":"the name of the Stickiness policy","name":"name","type":"string"},{"description":"the description of the Stickiness policy","name":"description","type":"string"},{"description":"the method name of the Stickiness policy","name":"methodname","type":"string"},{"description":"the LB Stickiness policy ID","name":"id","type":"string"},{"description":"the state of the policy","name":"state","type":"string"},{"description":"is policy for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the params of the policy","name":"params","type":"map"}],"type":"list"},{"description":"the id of the zone the Stickiness policy belongs to","name":"zoneid","type":"string"},{"description":"the domain ID of the Stickiness policy","name":"domainid","type":"string"},{"description":"the description of the Stickiness policy","name":"description","type":"string"},{"description":"the LB rule ID","name":"lbruleid","type":"string"},{"description":"the name of the Stickiness policy","name":"name","type":"string"},{"description":"the domain of the Stickiness policy","name":"domain","type":"string"},{"description":"the state of the policy","name":"state","type":"string"}],"since":"4.4"},{"description":"Starts an existing internal lb vm.","isasync":true,"name":"startInternalLoadBalancerVM","params":[{"description":"the ID of the internal lb vm","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,changeServiceForRouter,destroyRouter,startInternalLoadBalancerVM,rebootRouter,listRouters","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,changeServiceForRouter,destroyRouter,rebootRouter,listRouters","response":[{"description":"the version of template","name":"version","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"}],"type":"set"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"}]},{"description":"Lists all Pods.","isasync":false,"name":"listPods","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list Pods by ID","length":255,"name":"id","related":"updatePod,createManagementNetworkIpRange,listPods","required":false,"type":"uuid"},{"description":"list pods by allocation state","length":255,"name":"allocationstate","required":false,"type":"string"},{"description":"list Pods by name","length":255,"name":"name","required":false,"type":"string"},{"description":"list Pods by Zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"flag to display the capacity of the pods","length":255,"name":"showcapacities","required":false,"type":"boolean"}],"related":"updatePod,createManagementNetworkIpRange","response":[{"description":"the capacity of the Pod","name":"capacity","response":[{"description":"the Zone ID","name":"zoneid","type":"string"},{"description":"the Pod ID","name":"podid","type":"string"},{"description":"the percentage of capacity currently in use","name":"percentused","type":"string"},{"description":"the capacity type","name":"type","type":"short"},{"description":"the Pod name","name":"podname","type":"string"},{"description":"the capacity currently in allocated","name":"capacityallocated","type":"long"},{"description":"the Zone name","name":"zonename","type":"string"},{"description":"the capacity name","name":"name","type":"string"},{"description":"the total capacity available","name":"capacitytotal","type":"long"},{"description":"the Cluster ID","name":"clusterid","type":"string"},{"description":"the Cluster name","name":"clustername","type":"string"},{"description":"the capacity currently in use","name":"capacityused","type":"long"}],"type":"list"},{"description":"the allocation state of the Pod","name":"allocationstate","type":"string"},{"description":"the netmask of the Pod","name":"netmask","type":"string"},{"description":"the ID of the Pod","name":"id","type":"string"},{"description":"the name of the Pod","name":"name","type":"string"},{"description":"indicates Vlan ID for the range","name":"vlanid","type":"list"},{"description":"indicates if range is dedicated for CPVM and SSVM","name":"forsystemvms","type":"list"},{"description":"the Zone name of the Pod","name":"zonename","type":"string"},{"description":"the ending IP for the Pod","name":"endip","type":"list"},{"description":"the Zone ID of the Pod","name":"zoneid","type":"string"},{"description":"the gateway of the Pod","name":"gateway","type":"string"},{"description":"the starting IP for the Pod","name":"startip","type":"list"}]},{"description":"Updates a disk offering.","isasync":false,"name":"updateDiskOffering","params":[{"description":"updates alternate display text of the disk offering with this value","length":4096,"name":"displaytext","required":false,"type":"string"},{"description":"updates name of the disk offering with this value","length":255,"name":"name","required":false,"type":"string"},{"description":"sort key of the disk offering, integer","length":255,"name":"sortkey","required":false,"type":"integer"},{"description":"an optional field, whether to display the offering to the end user or not.","length":255,"name":"displayoffering","required":false,"type":"boolean"},{"description":"ID of the disk offering","length":255,"name":"id","related":"listDiskOfferings,updateDiskOffering,createDiskOffering","required":true,"type":"uuid"}],"related":"listDiskOfferings,createDiskOffering","response":[{"description":"unique ID of the disk offering","name":"id","type":"string"},{"description":"the min iops of the disk offering","name":"miniops","type":"long"},{"description":"Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)","name":"hypervisorsnapshotreserve","type":"integer"},{"description":"io requests write rate of the disk offering","name":"diskIopsWriteRate","type":"long"},{"description":"an alternate display text of the disk offering.","name":"displaytext","type":"string"},{"description":"provisioning type used to create volumes. Valid values are thin, sparse, fat.","name":"provisioningtype","type":"string"},{"description":"bytes write rate of the disk offering","name":"diskBytesWriteRate","type":"long"},{"description":"the name of the disk offering","name":"name","type":"string"},{"description":"the size of the disk offering in GB","name":"disksize","type":"long"},{"description":"the tags for the disk offering","name":"tags","type":"string"},{"description":"io requests read rate of the disk offering","name":"diskIopsReadRate","type":"long"},{"description":"true if disk offering uses custom iops, false otherwise","name":"iscustomizediops","type":"boolean"},{"description":"the date this disk offering was created","name":"created","type":"date"},{"description":"the domain name this disk offering belongs to. Ignore this information as it is not currently applicable.","name":"domain","type":"string"},{"description":"the domain ID this disk offering belongs to. Ignore this information as it is not currently applicable.","name":"domainid","type":"string"},{"description":"whether to display the offering to the end user or not.","name":"displayoffering","type":"boolean"},{"description":"the storage type for this disk offering","name":"storagetype","type":"string"},{"description":"the cache mode to use for this disk offering. none, writeback or writethrough","name":"cacheMode","type":"string"},{"description":"the max iops of the disk offering","name":"maxiops","type":"long"},{"description":"true if disk offering uses custom size, false otherwise","name":"iscustomized","type":"boolean"},{"description":"bytes read rate of the disk offering","name":"diskBytesReadRate","type":"long"}]},{"description":" delete a SRX firewall device","isasync":true,"name":"deleteSrxFirewall","params":[{"description":"srx firewall device ID","length":255,"name":"fwdeviceid","related":"configureSrxFirewall","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"disable Nuage underlay on vlan ip range","isasync":true,"name":"disableNuageUnderlayVlanIpRange","params":[{"description":"VLAN IP Range ID","length":255,"name":"id","related":"listVlanIpRanges,dedicatePublicIpRange,createVlanIpRange","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.10"},{"description":"Lists all available snapshots for the account.","isasync":false,"name":"listSnapshots","params":[{"description":"the IDs of the snapshots, mutually exclusive with id","length":255,"name":"ids","related":"createSnapshot,createSnapshotFromVMSnapshot,listSnapshots,revertSnapshot","required":false,"since":"4.9","type":"list"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list snapshots by zone id","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the ID of the disk volume","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"valid values are HOURLY, DAILY, WEEKLY, and MONTHLY.","length":255,"name":"intervaltype","required":false,"type":"string"},{"description":"lists snapshot by snapshot ID","length":255,"name":"id","related":"createSnapshot,createSnapshotFromVMSnapshot,listSnapshots,revertSnapshot","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"lists snapshot by snapshot name","length":255,"name":"name","required":false,"type":"string"},{"description":"valid values are MANUAL or RECURRING.","length":255,"name":"snapshottype","required":false,"type":"string"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"}],"related":"createSnapshot,createSnapshotFromVMSnapshot,revertSnapshot","response":[{"description":"id of the os on volume","name":"ostypeid","type":"string"},{"description":"the project name of the snapshot","name":"project","type":"string"},{"description":"type of the disk volume","name":"volumetype","type":"string"},{"description":"name of the snapshot","name":"name","type":"string"},{"description":"virtual size of backedup snapshot on image store","name":"virtualsize","type":"long"},{"description":"the domain name of the snapshot's account","name":"domain","type":"string"},{"description":"the type of the snapshot","name":"snapshottype","type":"string"},{"description":"the account associated with the snapshot","name":"account","type":"string"},{"description":"the domain ID of the snapshot's account","name":"domainid","type":"string"},{"description":"ID of the snapshot","name":"id","type":"string"},{"description":"  the date the snapshot was created","name":"created","type":"date"},{"description":"display name of the os on volume","name":"osdisplayname","type":"string"},{"description":"valid types are hourly, daily, weekly, monthy, template, and none.","name":"intervaltype","type":"string"},{"description":"name of the disk volume","name":"volumename","type":"string"},{"description":"the list of resource tags associated with snapshot","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"list"},{"description":"indicates whether the underlying storage supports reverting the volume to this snapshot","name":"revertable","type":"boolean"},{"description":"id of the availability zone","name":"zoneid","type":"string"},{"description":"valid location types are primary and secondary.","name":"locationtype","type":"string"},{"description":"the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage","name":"state","type":"state"},{"description":"physical size of backedup snapshot on image store","name":"physicalsize","type":"long"},{"description":"the project id of the snapshot","name":"projectid","type":"string"},{"description":"ID of the disk volume","name":"volumeid","type":"string"}]},{"description":"Adds account to a project","isasync":true,"name":"addAccountToProject","params":[{"description":"email to which invitation to the project is going to be sent","length":255,"name":"email","required":false,"type":"string"},{"description":"name of the account to be added to the project","length":255,"name":"account","required":false,"type":"string"},{"description":"ID of the project to add the account to","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"3.0.0"},{"description":"Reset site to site vpn connection","isasync":true,"name":"resetVpnConnection","params":[{"description":"an optional domainId for connection. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"an optional account for connection. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"id of vpn connection","length":255,"name":"id","related":"resetVpnConnection,updateVpnConnection,listVpnConnections,createVpnConnection","required":true,"type":"uuid"}],"related":"updateVpnConnection,listVpnConnections,createVpnConnection","response":[{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the public IP address","name":"publicip","type":"string"},{"description":"the owner","name":"account","type":"string"},{"description":"State of vpn connection","name":"state","type":"string"},{"description":"the domain id of the owner","name":"domainid","type":"string"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"Lifetime of ESP SA of customer gateway","name":"esplifetime","type":"long"},{"description":"public ip address id of the customer gateway","name":"gateway","type":"string"},{"description":"IPsec Preshared-Key of the customer gateway","name":"ipsecpsk","type":"string"},{"description":"State of vpn connection","name":"passive","type":"boolean"},{"description":"the project id","name":"projectid","type":"string"},{"description":"ESP policy of the customer gateway","name":"esppolicy","type":"string"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the vpn gateway ID","name":"s2svpngatewayid","type":"string"},{"description":"guest cidr list of the customer gateway","name":"cidrlist","type":"string"},{"description":"IKE policy of the customer gateway","name":"ikepolicy","type":"string"},{"description":"the connection ID","name":"id","type":"string"},{"description":"is connection for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"if DPD is enabled for customer gateway","name":"dpd","type":"boolean"},{"description":"Lifetime of IKE SA of customer gateway","name":"ikelifetime","type":"long"},{"description":"if Force NAT Encapsulation is enabled for customer gateway","name":"forceencap","type":"boolean"},{"description":"the project name","name":"project","type":"string"},{"description":"the customer gateway ID","name":"s2scustomergatewayid","type":"string"}]},{"description":"Deletes a keypair by name","isasync":false,"name":"deleteSSHKeyPair","params":[{"description":"the project associated with keypair","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"Name of the keypair","length":255,"name":"name","required":true,"type":"string"},{"description":"the account associated with the keypair. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the domain ID associated with the keypair","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Creates and automatically starts a virtual machine based on a service offering, disk offering, and template.","isasync":true,"name":"createAutoScaleVmGroup","params":[{"description":"the frequency at which the conditions have to be evaluated","length":255,"name":"interval","required":false,"type":"integer"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","length":255,"name":"minmembers","required":true,"type":"integer"},{"description":"list of scaleup autoscale policies","length":255,"name":"scaleuppolicyids","related":"updateAutoScalePolicy,listAutoScalePolicies","required":true,"type":"list"},{"description":"the autoscale profile that contains information about the vms in the vm group.","length":255,"name":"vmprofileid","related":"updateAutoScaleVmProfile,listAutoScaleVmProfiles,createAutoScaleVmProfile","required":true,"type":"uuid"},{"description":"an optional field, whether to the display the group to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","length":255,"name":"maxmembers","required":true,"type":"integer"},{"description":"the ID of the load balancer rule","length":255,"name":"lbruleid","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"},{"description":"list of scaledown autoscale policies","length":255,"name":"scaledownpolicyids","related":"updateAutoScalePolicy,listAutoScalePolicies","required":true,"type":"list"}],"related":"updateAutoScaleVmGroup,enableAutoScaleVmGroup,listAutoScaleVmGroups,disableAutoScaleVmGroup","response":[{"description":"the load balancer rule ID","name":"lbruleid","type":"string"},{"description":"the domain name of the vm profile","name":"domain","type":"string"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","name":"maxmembers","type":"int"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"is group for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the autoscale profile that contains information about the vms in the vm group.","name":"vmprofileid","type":"string"},{"description":"the project name of the vm profile","name":"project","type":"string"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","name":"minmembers","type":"int"},{"description":"list of scaleup autoscale policies","name":"scaleuppolicies","type":"list"},{"description":"the autoscale vm group ID","name":"id","type":"string"},{"description":"the frequency at which the conditions have to be evaluated","name":"interval","type":"int"},{"description":"the current state of the AutoScale Vm Group","name":"state","type":"string"},{"description":"the project id vm profile","name":"projectid","type":"string"},{"description":"list of scaledown autoscale policies","name":"scaledownpolicies","type":"list"},{"description":"the domain ID of the vm profile","name":"domainid","type":"string"}]},{"description":"Searches LDAP based on the username attribute","isasync":false,"name":"searchLdap","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"query to search using","length":255,"name":"query","related":"searchLdap,listLdapUsers","required":true,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"listLdapUsers","response":[{"description":"The user's username","name":"username","type":"string"},{"description":"The user's principle","name":"principal","type":"string"},{"description":"The user's firstname","name":"firstname","type":"string"},{"description":"The user's lastname","name":"lastname","type":"string"},{"description":"The user's domain","name":"domain","type":"string"},{"description":"The user's email","name":"email","type":"string"}],"since":"4.2.0"},{"description":"add a baremetal ping pxe server","isasync":true,"name":"addBaremetalPxePingServer","params":[{"description":"Username of PING storage server","length":255,"name":"pingcifsusername","required":false,"type":"string"},{"description":"Pod Id","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"type of pxe device","length":255,"name":"pxeservertype","required":true,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork","required":true,"type":"uuid"},{"description":"Credentials to reach external pxe device","length":255,"name":"username","required":true,"type":"string"},{"description":"Root directory on PING storage server","length":255,"name":"pingdir","required":true,"type":"string"},{"description":"Credentials to reach external pxe device","length":255,"name":"password","required":true,"type":"string"},{"description":"URL of the external pxe device","length":255,"name":"url","required":true,"type":"string"},{"description":"Password of PING storage server","length":255,"name":"pingcifspassword","required":false,"type":"string"},{"description":"Tftp root directory of PXE server","length":255,"name":"tftpdir","required":true,"type":"string"},{"description":"PING storage server ip","length":255,"name":"pingstorageserverip","required":true,"type":"string"}],"related":"","response":[{"description":"Tftp root directory of PXE server","name":"tftpdir","type":"string"},{"description":"PING storage server ip","name":"pingstorageserverip","type":"string"},{"description":"Root directory on PING storage server","name":"pingdir","type":"string"}]},{"description":"Deletes a load balancer rule.","isasync":true,"name":"deleteLoadBalancerRule","params":[{"description":"the ID of the load balancer rule","length":255,"name":"id","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"list portable IP ranges","isasync":false,"name":"listPortableIpRanges","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"Id of the portable ip range","length":255,"name":"id","related":"listPortableIpRanges,createPortableIpRange","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"Id of a Region","length":255,"name":"regionid","required":false,"type":"integer"}],"related":"createPortableIpRange","response":[{"description":"the ID or VID of the VLAN.","name":"vlan","type":"string"},{"description":"the netmask of the VLAN IP range","name":"netmask","type":"string"},{"description":"the end ip of the portable IP range","name":"endip","type":"string"},{"description":"the start ip of the portable IP range","name":"startip","type":"string"},{"description":"List of portable IP and association with zone/network/vpc details that are part of GSLB rule","name":"portableipaddress","response":[{"description":"public IP address","name":"ipaddress","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the domain ID the portable IP address is associated with","name":"domainid","type":"string"},{"description":"Region Id in which global load balancer is created","name":"regionid","type":"integer"},{"description":"State of the ip address. Can be: Allocatin, Allocated and Releasing","name":"state","type":"string"},{"description":"date the portal IP address was acquired","name":"allocated","type":"date"},{"description":"the account ID the portable IP address is associated with","name":"accountid","type":"string"},{"description":"the ID of the zone the public IP address belongs to","name":"zoneid","type":"string"},{"description":"the ID of the Network where ip belongs to","name":"networkid","type":"string"},{"description":"VPC the ip belongs to","name":"vpcid","type":"string"}],"type":"list"},{"description":"portable IP range ID","name":"id","type":"string"},{"description":"Region Id in which portable ip range is provisioned","name":"regionid","type":"integer"},{"description":"the gateway of the VLAN IP range","name":"gateway","type":"string"}]},{"description":"Returns user data associated with the VM","isasync":false,"name":"getVirtualMachineUserData","params":[{"description":"The ID of the virtual machine","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"","response":[{"description":"Base 64 encoded VM user data","name":"userdata","type":"string"},{"description":"the ID of the virtual machine","name":"virtualmachineid","type":"string"}],"since":"4.4"},{"description":"Lists all configurations.","isasync":false,"name":"listConfigurations","params":[{"description":"the ID of the Domain to update the parameter value for corresponding domain","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"the ID of the Image Store to update the parameter value for corresponding image store","length":255,"name":"imagestoreuuid","related":"listImageStores,updateCloudToUseObjectStore,addImageStore,listSwifts,addSecondaryStorage,addImageStoreS3","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"lists configurations by category","length":255,"name":"category","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the ID of the Account to update the parameter value for corresponding account","length":255,"name":"accountid","related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,markDefaultZoneForAccount,disableAccount","required":false,"type":"uuid"},{"description":"the ID of the Cluster to update the parameter value for corresponding cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"the ID of the Storage pool to update the parameter value for corresponding storage pool","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"lists configuration by name","length":255,"name":"name","required":false,"type":"string"},{"description":"the ID of the Zone to update the parameter value for corresponding zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"updateConfiguration","response":[{"description":"the name of the configuration","name":"name","type":"string"},{"description":"the category of the configuration","name":"category","type":"string"},{"description":"the value of the configuration","name":"value","type":"string"},{"description":"the value of the configuration","name":"id","type":"long"},{"description":"the description of the configuration","name":"description","type":"string"},{"description":"scope(zone/cluster/pool/account) of the parameter that needs to be updated","name":"scope","type":"string"}]},{"description":"Disables static rule for given IP address","isasync":true,"name":"disableStaticNat","params":[{"description":"the public IP address ID for which static NAT feature is being disabled","length":255,"name":"ipaddressid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Assigns secondary IP to NIC","isasync":true,"name":"addIpToNic","params":[{"description":"Secondary IP Address","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"the ID of the nic to which you want to assign private IP","length":255,"name":"nicid","related":"listNics","required":true,"type":"uuid"}],"related":"","response":[{"description":"the ID of the network","name":"networkid","type":"string"},{"description":"the list of Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the ID of the nic","name":"nicid","type":"string"},{"description":"the ID of the vm","name":"virtualmachineid","type":"string"},{"description":"Secondary IP address","name":"ipaddress","type":"string"},{"description":"the ID of the secondary private IP addr","name":"id","type":"string"}]},{"description":"Stops a NetScalervm.","isasync":true,"name":"stopNetScalerVpx","params":[{"description":"Force stop the VM. The caller knows the VM is stopped.","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"the ID of the NetScaler vm","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,stopNetScalerVpx,changeServiceForRouter,destroyRouter,rebootRouter,listRouters","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,changeServiceForRouter,destroyRouter,rebootRouter,listRouters","response":[{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"}],"type":"set"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the project name of the address","name":"project","type":"string"}]},{"description":"Delete a Ucs manager","isasync":false,"name":"deleteUcsManager","params":[{"description":"ucs manager id","length":255,"name":"ucsmanagerid","related":"listUcsManagers,addUcsManager","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Deletes a host.","isasync":false,"name":"deleteHost","params":[{"description":"the host ID","length":255,"name":"id","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"},{"description":"Force delete the host. All HA enabled vms running on the host will be put to HA; HA disabled ones will be stopped","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"Force destroy local storage on this host. All VMs created on this local storage will be destroyed","length":255,"name":"forcedestroylocalstorage","required":false,"type":"boolean"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Deletes a vm group","isasync":false,"name":"deleteInstanceGroup","params":[{"description":"the ID of the instance group","length":255,"name":"id","related":"updateInstanceGroup,createInstanceGroup,listInstanceGroups","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists capabilities","isasync":false,"name":"listCapabilities","params":[],"related":"","response":[{"description":"version of the cloud stack","name":"cloudstackversion","type":"string"},{"description":"true if region supports elastic load balancer on basic zones","name":"supportELB","type":"string"},{"description":"true if user and domain admins can set templates to be shared, false otherwise","name":"userpublictemplateenabled","type":"boolean"},{"description":"true if region wide secondary is enabled, false otherwise","name":"regionsecondaryenabled","type":"boolean"},{"description":"minimum size that can be specified when create disk from disk offering with custom size","name":"customdiskofferingminsize","type":"long"},{"description":"true if the user can recover and expunge virtualmachines, false otherwise","name":"allowuserexpungerecovervm","type":"boolean"},{"description":"If invitation confirmation is required when add account to project","name":"projectinviterequired","type":"boolean"},{"description":"true if dynamic role-based api checker is enabled, false otherwise","name":"dynamicrolesenabled","type":"boolean"},{"description":"true if snapshot is supported for KVM host, false otherwise","name":"kvmsnapshotenabled","type":"boolean"},{"description":"true if regular user is allowed to create projects","name":"allowusercreateprojects","type":"boolean"},{"description":"true if the user is allowed to view destroyed virtualmachines, false otherwise","name":"allowuserviewdestroyedvm","type":"boolean"},{"description":"maximum size that can be specified when create disk from disk offering with custom size","name":"customdiskofferingmaxsize","type":"long"},{"description":"time interval (in seconds) to reset api count","name":"apilimitinterval","type":"integer"},{"description":"Max allowed number of api requests within the specified interval","name":"apilimitmax","type":"integer"},{"description":"true if security groups support is enabled, false otherwise","name":"securitygroupsenabled","type":"boolean"}]},{"description":"Updates traffic type of a physical network","isasync":true,"name":"updateTrafficType","params":[{"description":"traffic type id","length":255,"name":"id","related":"addTrafficType,updateTrafficType","required":true,"type":"uuid"},{"description":"The network name label of the physical device dedicated to this traffic on a Hyperv host","length":255,"name":"hypervnetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a KVM host","length":255,"name":"kvmnetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a VMware host","length":255,"name":"vmwarenetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a XenServer host","length":255,"name":"xennetworklabel","required":false,"type":"string"},{"description":"The network name of the physical device dedicated to this traffic on an OVM3 host","length":255,"name":"ovm3networklabel","required":false,"type":"string"}],"related":"addTrafficType","response":[{"description":"The network name label of the physical device dedicated to this traffic on a HyperV host","name":"hypervnetworklabel","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"The network name of the physical device dedicated to this traffic on an OVM3 host","name":"ovm3networklabel","type":"string"},{"description":"id of the network provider","name":"id","type":"string"},{"description":"the trafficType to be added to the physical network","name":"traffictype","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a XenServer host","name":"xennetworklabel","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a VMware host","name":"vmwarenetworklabel","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a KVM host","name":"kvmnetworklabel","type":"string"}],"since":"3.0.0"},{"description":"Release dedication of zone","isasync":true,"name":"releaseDedicatedZone","params":[{"description":"the ID of the Zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"List Conditions for the specific user","isasync":false,"name":"listConditions","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"ID of the Condition.","length":255,"name":"id","related":"createCondition,listConditions","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"Counter-id of the condition.","length":255,"name":"counterid","related":"listCounters,createCounter","required":false,"type":"uuid"},{"description":"the ID of the policy","length":255,"name":"policyid","related":"updateAutoScalePolicy,listAutoScalePolicies","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"createCondition","response":[{"description":"Relational Operator to be used with threshold.","name":"relationaloperator","type":"string"},{"description":"the owner of the Condition.","name":"account","type":"string"},{"description":"Threshold Value for the counter.","name":"threshold","type":"long"},{"description":"Details of the Counter.","name":"counter","type":"list"},{"description":"the domain id of the Condition owner","name":"domainid","type":"string"},{"description":"zone id of counter","name":"zoneid","type":"string"},{"description":"the project id of the Condition.","name":"projectid","type":"string"},{"description":"the id of the Condition","name":"id","type":"string"},{"description":"the project name of the Condition","name":"project","type":"string"},{"description":"the domain name of the owner.","name":"domain","type":"string"}]},{"description":"Updates a network serviceProvider of a physical network","isasync":true,"name":"updateNetworkServiceProvider","params":[{"description":"Enabled/Disabled/Shutdown the physical network service provider","length":255,"name":"state","required":false,"type":"string"},{"description":"network service provider id","length":255,"name":"id","related":"updateNetworkServiceProvider,listTrafficTypes,addNetworkServiceProvider,listNetworkServiceProviders","required":true,"type":"uuid"},{"description":"the list of services to be enabled for this physical network service provider","length":255,"name":"servicelist","required":false,"type":"list"}],"related":"listTrafficTypes,addNetworkServiceProvider,listNetworkServiceProviders","response":[{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"the provider name","name":"name","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"state of the network provider","name":"state","type":"string"}],"since":"3.0.0"},{"description":"Adds a Nuage VSP device","isasync":true,"name":"addNuageVspDevice","params":[{"description":"the version of the API to use to communicate to Nuage VSD","length":255,"name":"apiversion","required":false,"type":"string"},{"description":"the password of CMS user in Nuage VSD","length":255,"name":"password","required":true,"type":"string"},{"description":"the time to wait after failure before retrying to communicate to Nuage VSD","length":255,"name":"retryinterval","required":false,"type":"long"},{"description":"the user name of the CMS user in Nuage VSD","length":255,"name":"username","required":true,"type":"string"},{"description":"the hostname of the Nuage VSD","length":255,"name":"hostname","required":true,"type":"string"},{"description":"the port to communicate to Nuage VSD","length":255,"name":"port","required":true,"type":"integer"},{"description":"the number of retries on failure to communicate to Nuage VSD","length":255,"name":"retrycount","required":false,"type":"integer"},{"description":"the ID of the physical network in to which Nuage VSP is added","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork","required":true,"type":"uuid"}],"related":"listNuageVspDevices,updateNuageVspDevice","response":[{"description":"the CMS ID generated by the Nuage VSD","name":"cmsid","type":"string"},{"description":"the device id of the Nuage VSD","name":"vspdeviceid","type":"string"},{"description":"the port to communicate to Nuage VSD","name":"port","type":"int"},{"description":"the version of the API to use to communicate to Nuage VSD","name":"apiversion","type":"string"},{"description":"the ID of the physical network to which this Nuage VSP belongs to","name":"physicalnetworkid","type":"string"},{"description":"the service provider name corresponding to this Nuage VSP device","name":"provider","type":"string"},{"description":"the number of retries on failure to communicate to Nuage VSD","name":"retrycount","type":"int"},{"description":"the time to wait after failure before retrying to communicate to Nuage VSD","name":"retryinterval","type":"long"},{"description":"the name of the Nuage VSP device","name":"nuagedevicename","type":"string"},{"description":"the hostname of the Nuage VSD","name":"hostname","type":"string"}],"since":"4.5"},{"description":"Removes a virtual machine or a list of virtual machines from a load balancer rule.","isasync":true,"name":"removeFromLoadBalancerRule","params":[{"description":"The ID of the load balancer rule","length":255,"name":"id","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"},{"description":"VM ID and IP map, vmidipmap[0].vmid=1 vmidipmap[0].ip=10.1.1.75","length":255,"name":"vmidipmap","required":false,"since":"4.4","type":"map"},{"description":"the list of IDs of the virtual machines that are being removed from the load balancer rule (i.e. virtualMachineIds=1,2,3)","length":255,"name":"virtualmachineids","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"list"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists vm groups","isasync":false,"name":"listInstanceGroups","params":[{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list instance groups by ID","length":255,"name":"id","related":"updateInstanceGroup,createInstanceGroup,listInstanceGroups","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,createProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list instance groups by name","length":255,"name":"name","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"updateInstanceGroup,createInstanceGroup","response":[{"description":"the project name of the instance group","name":"project","type":"string"},{"description":"time and date the instance group was created","name":"created","type":"date"},{"description":"the domain ID of the instance group","name":"domainid","type":"string"},{"description":"the ID of the instance group","name":"id","type":"string"},{"description":"the name of the instance group","name":"name","type":"string"},{"description":"the domain name of the instance group","name":"domain","type":"string"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"the project ID of the instance group","name":"projectid","type":"string"}]},{"description":"Creates a static route","isasync":true,"name":"createStaticRoute","params":[{"description":"the gateway id we are creating static route for","length":255,"name":"gatewayid","related":"createPrivateGateway","required":true,"type":"uuid"},{"description":"static route cidr","length":255,"name":"cidr","required":true,"type":"string"}],"related":"listStaticRoutes","response":[{"description":"the project name of the static route","name":"project","type":"string"},{"description":"the project id of the static route","name":"projectid","type":"string"},{"description":"the list of resource tags associated with static route","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"list"},{"description":"the account associated with the static route","name":"account","type":"string"},{"description":"static route CIDR","name":"cidr","type":"string"},{"description":"the ID of the domain associated with the static route","name":"domainid","type":"string"},{"description":"the state of the static route","name":"state","type":"string"},{"description":"VPC gateway the route is created for","name":"gatewayid","type":"string"},{"description":"the ID of static route","name":"id","type":"string"},{"description":"VPC the static route belongs to","name":"vpcid","type":"string"},{"description":"the domain associated with the static route","name":"domain","type":"string"}]},{"description":"Adds traffic type to a physical network","isasync":true,"name":"addTrafficType","params":[{"description":"The network name of the physical device dedicated to this traffic on an OVM3 host","length":255,"name":"ovm3networklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a VMware host","length":255,"name":"vmwarenetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a Hyperv host","length":255,"name":"hypervnetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a XenServer host","length":255,"name":"xennetworklabel","required":false,"type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a KVM host","length":255,"name":"kvmnetworklabel","required":false,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"updatePhysicalNetwork,createPhysicalNetwork","required":true,"type":"uuid"},{"description":"the trafficType to be added to the physical network","length":255,"name":"traffictype","required":true,"type":"string"},{"description":"Used if physical network has multiple isolation types and traffic type is public. Choose which isolation method. Valid options currently 'vlan' or 'vxlan', defaults to 'vlan'.","length":255,"name":"isolationmethod","required":false,"type":"string"},{"description":"The VLAN id to be used for Management traffic by VMware host","length":255,"name":"vlan","required":false,"type":"string"}],"related":"","response":[{"description":"The network name label of the physical device dedicated to this traffic on a VMware host","name":"vmwarenetworklabel","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a KVM host","name":"kvmnetworklabel","type":"string"},{"description":"The network name of the physical device dedicated to this traffic on an OVM3 host","name":"ovm3networklabel","type":"string"},{"description":"the trafficType to be added to the physical network","name":"traffictype","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a XenServer host","name":"xennetworklabel","type":"string"},{"description":"The network name label of the physical device dedicated to this traffic on a HyperV host","name":"hypervnetworklabel","type":"string"},{"description":"id of the network provider","name":"id","type":"string"}],"since":"3.0.0"},{"description":"Deletes a Private gateway","isasync":true,"name":"deletePrivateGateway","params":[{"description":"the ID of the private gateway","length":255,"name":"id","related":"createPrivateGateway","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"List all virtual machine instances that are assigned to a load balancer rule.","isasync":false,"name":"listLoadBalancerRuleInstances","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"true if load balancer rule VM IP information to be included; default is false","length":255,"name":"lbvmips","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the ID of the load balancer rule","length":255,"name":"id","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"true if listing all virtual machines currently applied to the load balancer rule; default is true","length":255,"name":"applied","required":false,"type":"boolean"}],"related":"listLoadBalancerRuleInstances","response":[{"description":"IP addresses of the vm set of lb rule","name":"lbvmipaddresses","type":"list"},{"description":"the user vm set for lb rule","name":"loadbalancerruleinstance","type":"uservmresponse"}]},{"description":"Removes a condition","isasync":true,"name":"deleteCondition","params":[{"description":"the ID of the condition.","length":255,"name":"id","related":"createCondition","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Updates a domain with a new name","isasync":false,"name":"updateDomain","params":[{"description":"Network domain for the domain's networks; empty string will update domainName with NULL value","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"ID of domain to update","length":255,"name":"id","related":"createDomain,listDomains,listDomains,updateDomain,listDomainChildren","required":true,"type":"uuid"},{"description":"updates domain with this name","length":255,"name":"name","required":false,"type":"string"}],"related":"createDomain,listDomains,listDomains,listDomainChildren","response":[{"description":"the total number of templates available to be created by this domain","name":"templateavailable","type":"string"},{"description":"the total volume which can be used by this domain","name":"volumelimit","type":"string"},{"description":"the state of the domain","name":"state","type":"string"},{"description":"the total number of networks the domain can own","name":"networklimit","type":"string"},{"description":"the total number of public ip addresses this domain can acquire","name":"iplimit","type":"string"},{"description":"the total memory (in MB) available to be created for this domain","name":"memoryavailable","type":"string"},{"description":"the total number of virtual machines deployed by this domain","name":"vmtotal","type":"long"},{"description":"the total number of public ip addresses available for this domain to acquire","name":"ipavailable","type":"string"},{"description":"the total number of projects being administrated by this domain","name":"projecttotal","type":"long"},{"description":"the total primary storage space (in GiB) the domain can own","name":"primarystoragelimit","type":"string"},{"description":"the domain ID of the parent domain","name":"parentdomainid","type":"string"},{"description":"the ID of the domain","name":"id","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this domain","name":"secondarystorageavailable","type":"string"},{"description":"the total number of cpu cores owned by domain","name":"cputotal","type":"long"},{"description":"the total secondary storage space (in GiB) owned by domain","name":"secondarystoragetotal","type":"float"},{"description":"the total primary storage space (in GiB) available to be used for this domain","name":"primarystorageavailable","type":"string"},{"description":"the domain name of the parent domain","name":"parentdomainname","type":"string"},{"description":"the total memory (in MB) the domain can own","name":"memorylimit","type":"string"},{"description":"the total memory (in MB) owned by domain","name":"memorytotal","type":"long"},{"description":"the total number of vpcs the domain can own","name":"vpclimit","type":"string"},{"description":"the path of the domain","name":"path","type":"string"},{"description":"the total number of vpcs owned by domain","name":"vpctotal","type":"long"},{"description":"the total number of projects available for administration by this domain","name":"projectavailable","type":"string"},{"description":"the total volume available for this domain","name":"volumeavailable","type":"string"},{"description":"the total number of cpu cores available to be created for this domain","name":"cpuavailable","type":"string"},{"description":"the total number of snapshots available for this domain","name":"snapshotavailable","type":"string"},{"description":"the level of the domain","name":"level","type":"integer"},{"description":"whether the domain has one or more sub-domains","name":"haschild","type":"boolean"},{"description":"the total number of networks owned by domain","name":"networktotal","type":"long"},{"description":"the total number of virtual machines available for this domain to acquire","name":"vmavailable","type":"string"},{"description":"the total number of snapshots stored by this domain","name":"snapshottotal","type":"long"},{"description":"the total volume being used by this domain","name":"volumetotal","type":"long"},{"description":"the total number of templates which have been created by this domain","name":"templatetotal","type":"long"},{"description":"the total secondary storage space (in GiB) the domain can own","name":"secondarystoragelimit","type":"string"},{"description":"the total number of vpcs available to be created for this domain","name":"vpcavailable","type":"string"},{"description":"the total primary storage space (in GiB) owned by domain","name":"primarystoragetotal","type":"long"},{"description":"the name of the domain","name":"name","type":"string"},{"description":"the total number of virtual machines that can be deployed by this domain","name":"vmlimit","type":"string"},{"description":"the total number of projects the domain can own","name":"projectlimit","type":"string"},{"description":"the total number of snapshots which can be stored by this domain","name":"snapshotlimit","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total number of public ip addresses allocated for this domain","name":"iptotal","type":"long"},{"description":"the total number of networks available to be created for this domain","name":"networkavailable","type":"string"},{"description":"the total number of cpu cores the domain can own","name":"cpulimit","type":"string"},{"description":"the total number of templates which can be created by this domain","name":"templatelimit","type":"string"}]},{"description":"Updates a physical network","isasync":true,"name":"updatePhysicalNetwork","params":[{"description":"Enabled/Disabled","length":255,"name":"state","required":false,"type":"string"},{"description":"Tag the physical network","length":255,"name":"tags","required":false,"type":"list"},{"description":"the VLAN for the physical network","length":255,"name":"vlan","required":false,"type":"string"},{"description":"physical network id","length":255,"name":"id","related":"updatePhysicalNetwork,createPhysicalNetwork","required":true,"type":"uuid"},{"description":"the speed for the physical network[1G/10G]","length":255,"name":"networkspeed","required":false,"type":"string"}],"related":"createPhysicalNetwork","response":[{"description":"the vlan of the physical network","name":"vlan","type":"string"},{"description":"name of the physical network","name":"name","type":"string"},{"description":"the domain id of the physical network owner","name":"domainid","type":"string"},{"description":"the uuid of the physical network","name":"id","type":"string"},{"description":"the speed of the physical network","name":"networkspeed","type":"string"},{"description":"Broadcast domain range of the physical network","name":"broadcastdomainrange","type":"string"},{"description":"comma separated tag","name":"tags","type":"string"},{"description":"zone id of the physical network","name":"zoneid","type":"string"},{"description":"state of the physical network","name":"state","type":"string"},{"description":"isolation methods","name":"isolationmethods","type":"string"}],"since":"3.0.0"},{"description":"Disables an AutoScale Vm Group","isasync":true,"name":"disableAutoScaleVmGroup","params":[{"description":"the ID of the autoscale group","length":255,"name":"id","related":"updateAutoScaleVmGroup,enableAutoScaleVmGroup,listAutoScaleVmGroups,disableAutoScaleVmGroup","required":true,"type":"uuid"}],"related":"updateAutoScaleVmGroup,enableAutoScaleVmGroup,listAutoScaleVmGroups","response":[{"description":"the load balancer rule ID","name":"lbruleid","type":"string"},{"description":"list of scaleup autoscale policies","name":"scaleuppolicies","type":"list"},{"description":"the project id vm profile","name":"projectid","type":"string"},{"description":"the domain ID of the vm profile","name":"domainid","type":"string"},{"description":"the autoscale vm group ID","name":"id","type":"string"},{"description":"the autoscale profile that contains information about the vms in the vm group.","name":"vmprofileid","type":"string"},{"description":"the project name of the vm profile","name":"project","type":"string"},{"description":"list of scaledown autoscale policies","name":"scaledownpolicies","type":"list"},{"description":"is group for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the current state of the AutoScale Vm Group","name":"state","type":"string"},{"description":"the domain name of the vm profile","name":"domain","type":"string"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","name":"maxmembers","type":"int"},{"description":"the frequency at which the conditions have to be evaluated","name":"interval","type":"int"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","name":"minmembers","type":"int"}]},{"description":"Creates a snapshot policy for the account.","isasync":false,"name":"createSnapshotPolicy","params":[{"description":"an optional field, whether to the display the policy to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"time the snapshot is scheduled to be taken. Format is:* if HOURLY, MM* if DAILY, MM:HH* if WEEKLY, MM:HH:DD (1-7)* if MONTHLY, MM:HH:DD (1-28)","length":255,"name":"schedule","required":true,"type":"string"},{"description":"the ID of the disk volume","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":true,"type":"uuid"},{"description":"Specifies a timezone for this command. For more information on the timezone parameter, see Time Zone Format.","length":255,"name":"timezone","required":true,"type":"string"},{"description":"valid values are HOURLY, DAILY, WEEKLY, and MONTHLY","length":255,"name":"intervaltype","required":true,"type":"string"},{"description":"maximum number of snapshots to retain","length":255,"name":"maxsnaps","required":true,"type":"integer"}],"related":"updateSnapshotPolicy","response":[{"description":"the time zone of the snapshot policy","name":"timezone","type":"string"},{"description":"the ID of the disk volume","name":"volumeid","type":"string"},{"description":"time the snapshot is scheduled to be taken.","name":"schedule","type":"string"},{"description":"the ID of the snapshot policy","name":"id","type":"string"},{"description":"maximum number of snapshots retained","name":"maxsnaps","type":"int"},{"description":"the interval type of the snapshot policy","name":"intervaltype","type":"short"},{"description":"is this policy for display to the regular user","name":"fordisplay","type":"boolean"}]},{"description":"Disables HA for a zone","isasync":true,"name":"disableHAForZone","params":[{"description":"ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.11"},{"description":"delete a nuage vsp device","isasync":true,"name":"deleteNuageVspDevice","params":[{"description":"Nuage device ID","length":255,"name":"vspdeviceid","related":"listNuageVspDevices,updateNuageVspDevice","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.5"},{"description":"List system virtual machines.","isasync":false,"name":"listSystemVms","params":[{"description":"the host ID of the system VM","length":255,"name":"hostid","related":"addHost,reconnectHost,listExternalLoadBalancers,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"the ID of the system VM","length":255,"name":"id","related":"changeServiceForSystemVm,startSystemVm,listSystemVms,migrateSystemVm","required":false,"type":"uuid"},{"description":"the Pod ID of the system VM","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"the state of the system VM","length":255,"name":"state","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the storage ID where vm's volumes belong to","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"since":"3.0.1","type":"uuid"},{"description":"the Zone ID of the system VM","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the name of the system VM","length":255,"name":"name","required":false,"type":"string"},{"description":"the system VM type. Possible types are \"consoleproxy\" and \"secondarystoragevm\".","length":255,"name":"systemvmtype","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"changeServiceForSystemVm,startSystemVm,migrateSystemVm","response":[{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"the state of the system VM","name":"state","type":"string"},{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the gateway for the system VM","name":"gateway","type":"string"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"}]},{"description":"Adds a API permission to a role","isasync":false,"name":"createRolePermission","params":[{"description":"ID of the role","length":255,"name":"roleid","related":"createRole,listRoles,updateRole","required":true,"type":"uuid"},{"description":"The API name or wildcard rule such as list*","length":255,"name":"rule","required":true,"type":"string"},{"description":"The description of the role permission","length":255,"name":"description","required":false,"type":"string"},{"description":"The rule permission, allow or deny. Default: deny.","length":255,"name":"permission","required":true,"type":"string"}],"related":"listRolePermissions","response":[{"description":"the name of the role to which the role permission belongs","name":"rolename","type":"string"},{"description":"the description of the role permission","name":"description","type":"string"},{"description":"the api name or wildcard rule","name":"rule","type":"string"},{"description":"the ID of the role permission","name":"id","type":"string"},{"description":"the ID of the role to which the role permission belongs","name":"roleid","type":"string"},{"description":"the permission type of the api name or wildcard rule, allow/deny","name":"permission","type":"string"}],"since":"4.9.0"},{"description":"Creates a project","isasync":true,"name":"createProject","params":[{"description":"domain ID of the account owning a project","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"name of the project","length":255,"name":"name","required":true,"type":"string"},{"description":"account who will be Admin for the project","length":255,"name":"account","required":false,"type":"string"},{"description":"display text of the project","length":255,"name":"displaytext","required":true,"type":"string"}],"related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","response":[{"description":"the total number of virtual machines available for this project to acquire","name":"vmavailable","type":"string"},{"description":"the total number of vpcs available to be created for this project","name":"vpcavailable","type":"string"},{"description":"the total primary storage space (in GiB) the project can own","name":"primarystoragelimit","type":"string"},{"description":"the total secondary storage space (in GiB) owned by project","name":"secondarystoragetotal","type":"float"},{"description":"the total number of snapshots which can be stored by this project","name":"snapshotlimit","type":"string"},{"description":"the displaytext of the project","name":"displaytext","type":"string"},{"description":"the domain name where the project belongs to","name":"domain","type":"string"},{"description":"the name of the project","name":"name","type":"string"},{"description":"the total number of networks owned by project","name":"networktotal","type":"long"},{"description":"the total secondary storage space (in GiB) the project can own","name":"secondarystoragelimit","type":"string"},{"description":"the account name of the project's owner","name":"account","type":"string"},{"description":"the total number of networks available to be created for this project","name":"networkavailable","type":"string"},{"description":"the list of resource tags associated with vm","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"list"},{"description":"the total volume being used by this project","name":"volumetotal","type":"long"},{"description":"the total number of snapshots stored by this project","name":"snapshottotal","type":"long"},{"description":"the total number of virtual machines stopped for this project","name":"vmstopped","type":"integer"},{"description":"the id of the project","name":"id","type":"string"},{"description":"the total memory (in MB) available to be created for this project","name":"memoryavailable","type":"string"},{"description":"the total number of virtual machines deployed by this project","name":"vmtotal","type":"long"},{"description":"the total number of templates available to be created by this project","name":"templateavailable","type":"string"},{"description":"the total number of public ip addresses available for this project to acquire","name":"ipavailable","type":"string"},{"description":"the total volume available for this project","name":"volumeavailable","type":"string"},{"description":"the total number of vpcs the project can own","name":"vpclimit","type":"string"},{"description":"the total number of cpu cores owned by project","name":"cputotal","type":"long"},{"description":"the total volume which can be used by this project","name":"volumelimit","type":"string"},{"description":"the total number of templates which have been created by this project","name":"templatetotal","type":"long"},{"description":"the total number of snapshots available for this project","name":"snapshotavailable","type":"string"},{"description":"the total primary storage space (in GiB) owned by project","name":"primarystoragetotal","type":"long"},{"description":"the total number of networks the project can own","name":"networklimit","type":"string"},{"description":"the total memory (in MB) owned by project","name":"memorytotal","type":"long"},{"description":"the total number of virtual machines that can be deployed by this project","name":"vmlimit","type":"string"},{"description":"the total number of vpcs owned by project","name":"vpctotal","type":"long"},{"description":"the total secondary storage space (in GiB) available to be used for this project","name":"secondarystorageavailable","type":"string"},{"description":"the total number of cpu cores the project can own","name":"cpulimit","type":"string"},{"description":"the total memory (in MB) the project can own","name":"memorylimit","type":"string"},{"description":"the total number of public ip addresses this project can acquire","name":"iplimit","type":"string"},{"description":"the total number of public ip addresses allocated for this project","name":"iptotal","type":"long"},{"description":"the total primary storage space (in GiB) available to be used for this project","name":"primarystorageavailable","type":"string"},{"description":"the project account name of the project","name":"projectaccountname","type":"string"},{"description":"the total number of templates which can be created by this project","name":"templatelimit","type":"string"},{"description":"the total number of cpu cores available to be created for this project","name":"cpuavailable","type":"string"},{"description":"the total number of virtual machines running for this project","name":"vmrunning","type":"integer"},{"description":"the domain id the project belongs to","name":"domainid","type":"string"},{"description":"the state of the project","name":"state","type":"string"}],"since":"3.0.0"},{"description":"Assigns a certificate to a load balancer rule","isasync":true,"name":"assignCertToLoadBalancer","params":[{"description":"the ID of the certificate","length":255,"name":"certid","related":"uploadSslCert","required":true,"type":"uuid"},{"description":"the ID of the load balancer rule","length":255,"name":"lbruleid","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Adds a Cisco Vnmc Controller","isasync":false,"name":"addCiscoVnmcResource","params":[{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"},{"description":"Credentials to access the Cisco VNMC Controller API","length":255,"name":"password","required":true,"type":"string"},{"description":"Credentials to access the Cisco VNMC Controller API","length":255,"name":"username","required":true,"type":"string"},{"description":"Hostname or ip address of the Cisco VNMC Controller.","length":255,"name":"hostname","required":true,"type":"string"}],"related":"listCiscoVnmcResources","response":[{},{},{},{},{}]},{"description":"Replaces ACL associated with a network or private gateway","isasync":true,"name":"replaceNetworkACLList","params":[{"description":"the ID of the private gateway","length":255,"name":"gatewayid","related":"createPrivateGateway","required":false,"type":"uuid"},{"description":"the ID of the network","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"the ID of the network ACL","length":255,"name":"aclid","related":"createNetworkACLList,listNetworkACLLists","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Detaches a disk volume from a virtual machine.","isasync":true,"name":"detachVolume","params":[{"description":"the ID of the virtual machine where the volume is detached from","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"the device ID on the virtual machine where volume is detached from","length":255,"name":"deviceid","required":false,"type":"long"},{"description":"the ID of the disk volume","length":255,"name":"id","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"type":"uuid"}],"related":"createVolume,attachVolume,listVolumes,listVolumes,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","response":[{"description":"name of the disk offering","name":"diskofferingname","type":"string"},{"description":"the display text of the service offering for root disk","name":"serviceofferingdisplaytext","type":"string"},{"description":"the ID of the domain associated with the disk volume","name":"domainid","type":"string"},{"description":"an optional field whether to the display the volume to the end user or not.","name":"displayvolume","type":"boolean"},{"description":"ID of the disk offering","name":"diskofferingid","type":"string"},{"description":"the date the disk volume was created","name":"created","type":"date"},{"description":"the project id of the vpn","name":"projectid","type":"string"},{"description":"name of the availability zone","name":"zonename","type":"string"},{"description":"bytes read rate of the disk volume","name":"diskBytesReadRate","type":"long"},{"description":"pod id of the volume","name":"podid","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"state of the virtual machine","name":"vmstate","type":"string"},{"description":"io requests write rate of the disk volume","name":"diskIopsWriteRate","type":"long"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"name of the primary storage hosting the disk volume","name":"storage","type":"string"},{"description":"cluster name where the volume is allocated","name":"clustername","type":"string"},{"description":"min iops of the disk volume","name":"miniops","type":"long"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"name of the service offering for root disk","name":"serviceofferingname","type":"string"},{"description":"the state of the disk volume","name":"state","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the bytes actually consumed on disk","name":"virtualsize","type":"long"},{"description":"Hypervisor the volume belongs to","name":"hypervisor","type":"string"},{"description":"the chain info of the volume","name":"chaininfo","type":"string"},{"description":"provisioning type used to create volumes.","name":"provisioningtype","type":"string"},{"description":"need quiesce vm or not when taking snapshot","name":"quiescevm","type":"boolean"},{"description":"the status of the volume","name":"status","type":"string"},{"description":"the path of the volume","name":"path","type":"string"},{"description":"shared or local storage","name":"storagetype","type":"string"},{"description":"the boolean state of whether the volume is destroyed or not","name":"destroyed","type":"boolean"},{"description":"io requests read rate of the disk volume","name":"diskIopsReadRate","type":"long"},{"description":"name of the disk volume","name":"name","type":"string"},{"description":"the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.","name":"deviceid","type":"long"},{"description":"bytes write rate of the disk volume","name":"diskBytesWriteRate","type":"long"},{"description":"type of the disk volume (ROOT or DATADISK)","name":"type","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"cluster id of the volume","name":"clusterid","type":"string"},{"description":"display name of the virtual machine","name":"vmdisplayname","type":"string"},{"description":"id of the primary storage hosting the disk volume; returned to admin user only","name":"storageid","type":"string"},{"description":"ID of the service offering for root disk","name":"serviceofferingid","type":"string"},{"description":"the disk utilization","name":"utilization","type":"string"},{"description":"max iops of the disk volume","name":"maxiops","type":"long"},{"description":"the date the volume was attached to a VM instance","name":"attached","type":"date"},{"description":"the bytes alloaated","name":"physicalsize","type":"long"},{"description":"pod name of the volume","name":"podname","type":"string"},{"description":"size of the disk volume","name":"size","type":"long"},{"description":"ID of the snapshot from which this volume was created","name":"snapshotid","type":"string"},{"description":"name of the virtual machine","name":"vmname","type":"string"},{"description":"the account associated with the disk volume","name":"account","type":"string"},{"description":"true if the volume is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the display text of the disk offering","name":"diskofferingdisplaytext","type":"string"},{"description":"ID of the disk volume","name":"id","type":"string"},{"description":"the domain associated with the disk volume","name":"domain","type":"string"},{"description":"the project name of the vpn","name":"project","type":"string"},{"description":"id of the virtual machine","name":"virtualmachineid","type":"string"},{"description":"ID of the availability zone","name":"zoneid","type":"string"}]},{"description":"Enables out-of-band management for a zone","isasync":true,"name":"enableOutOfBandManagementForZone","params":[{"description":"the ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"enableOutOfBandManagementForCluster,enableOutOfBandManagementForHost,issueOutOfBandManagementPowerAction,disableOutOfBandManagementForCluster,disableOutOfBandManagementForHost","response":[{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"},{"description":"the out-of-band management interface address","name":"address","type":"string"},{"description":"the out-of-band management interface port","name":"port","type":"string"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"the operation result description","name":"description","type":"string"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"}],"since":"4.9.0"},{"description":"Lists all LDAP Users","isasync":false,"name":"listLdapUsers","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"Determines whether all ldap users are returned or just non-cloudstack users","length":255,"name":"listtype","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"","response":[{"description":"The user's email","name":"email","type":"string"},{"description":"The user's firstname","name":"firstname","type":"string"},{"description":"The user's lastname","name":"lastname","type":"string"},{"description":"The user's domain","name":"domain","type":"string"},{"description":"The user's username","name":"username","type":"string"},{"description":"The user's principle","name":"principal","type":"string"}],"since":"4.2.0"},{"description":"Marks a default zone for this account","isasync":true,"name":"markDefaultZoneForAccount","params":[{"description":"Name of the account that is to be marked.","length":255,"name":"account","related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,markDefaultZoneForAccount,disableAccount","required":true,"type":"string"},{"description":"Marks the account that belongs to the specified domain.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":true,"type":"uuid"},{"description":"The Zone ID with which the account is to be marked.","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,disableAccount","response":[{"description":"the total number of virtual machines available for this account to acquire","name":"vmavailable","type":"string"},{"description":"the total number of templates which have been created by this account","name":"templatetotal","type":"long"},{"description":"the total primary storage space (in GiB) the account can own","name":"primarystoragelimit","type":"string"},{"description":"the total number of vpcs the account can own","name":"vpclimit","type":"string"},{"description":"the total volume being used by this account","name":"volumetotal","type":"long"},{"description":"id of the Domain the account belongs too","name":"domainid","type":"string"},{"description":"the total number of virtual machines stopped for this account","name":"vmstopped","type":"integer"},{"description":"account type (admin, domain-admin, user)","name":"accounttype","type":"short"},{"description":"the total number of projects available for administration by this account","name":"projectavailable","type":"string"},{"description":"the total number of networks the account can own","name":"networklimit","type":"string"},{"description":"the total number of virtual machines that can be deployed by this account","name":"vmlimit","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this account","name":"secondarystorageavailable","type":"string"},{"description":"the total memory (in MB) owned by account","name":"memorytotal","type":"long"},{"description":"the id of the account","name":"id","type":"string"},{"description":"name of the Domain the account belongs too","name":"domain","type":"string"},{"description":"the total number of templates available to be created by this account","name":"templateavailable","type":"string"},{"description":"true if the account requires cleanup","name":"iscleanuprequired","type":"boolean"},{"description":"the total memory (in MB) the account can own","name":"memorylimit","type":"string"},{"description":"the total volume available for this account","name":"volumeavailable","type":"string"},{"description":"the total number of snapshots available for this account","name":"snapshotavailable","type":"string"},{"description":"the total number of snapshots which can be stored by this account","name":"snapshotlimit","type":"string"},{"description":"the total number of vpcs owned by account","name":"vpctotal","type":"long"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the total number of projects the account can own","name":"projectlimit","type":"string"},{"description":"the total memory (in MB) available to be created for this account","name":"memoryavailable","type":"string"},{"description":"the total number of projects being administrated by this account","name":"projecttotal","type":"long"},{"description":"the total number of network traffic bytes received","name":"receivedbytes","type":"long"},{"description":"the total volume which can be used by this account","name":"volumelimit","type":"string"},{"description":"the total number of networks owned by account","name":"networktotal","type":"long"},{"description":"the total secondary storage space (in GiB) the account can own","name":"secondarystoragelimit","type":"string"},{"description":"the total number of cpu cores the account can own","name":"cpulimit","type":"string"},{"description":"the state of the account","name":"state","type":"string"},{"description":"the total secondary storage space (in GiB) owned by account","name":"secondarystoragetotal","type":"float"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the total number of snapshots stored by this account","name":"snapshottotal","type":"long"},{"description":"the total number of templates which can be created by this account","name":"templatelimit","type":"string"},{"description":"the total number of public ip addresses available for this account to acquire","name":"ipavailable","type":"string"},{"description":"the default zone of the account","name":"defaultzoneid","type":"string"},{"description":"the type of the role (Admin, ResourceAdmin, DomainAdmin, User)","name":"roletype","type":"string"},{"description":"the total number of cpu cores available to be created for this account","name":"cpuavailable","type":"string"},{"description":"the total primary storage space (in GiB) available to be used for this account","name":"primarystorageavailable","type":"string"},{"description":"the list of users associated with account","name":"user","response":[{"description":"the source type of the user in lowercase, such as native, ldap, saml2","name":"usersource","type":"string"},{"description":"the api key of the user","name":"apikey","type":"string"},{"description":"the secret key of the user","name":"secretkey","type":"string"},{"description":"the user state","name":"state","type":"string"},{"description":"the domain name of the user","name":"domain","type":"string"},{"description":"the timezone user was created in","name":"timezone","type":"string"},{"description":"the user ID","name":"id","type":"string"},{"description":"the domain ID of the user","name":"domainid","type":"string"},{"description":"the type of the role","name":"roletype","type":"string"},{"description":"true if user is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the account ID of the user","name":"accountid","type":"string"},{"description":"the account type of the user","name":"accounttype","type":"short"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the boolean value representing if the updating target is in caller's child domain","name":"iscallerchilddomain","type":"boolean"},{"description":"the account name of the user","name":"account","type":"string"},{"description":"the user name","name":"username","type":"string"},{"description":"the date and time the user account was created","name":"created","type":"date"},{"description":"the user firstname","name":"firstname","type":"string"},{"description":"the user lastname","name":"lastname","type":"string"},{"description":"the user email address","name":"email","type":"string"}],"type":"list"},{"description":"the total number of cpu cores owned by account","name":"cputotal","type":"long"},{"description":"details for the account","name":"accountdetails","type":"map"},{"description":"the total number of public ip addresses allocated for this account","name":"iptotal","type":"long"},{"description":"the total number of virtual machines running for this account","name":"vmrunning","type":"integer"},{"description":"the name of the account","name":"name","type":"string"},{"description":"the total number of public ip addresses this account can acquire","name":"iplimit","type":"string"},{"description":"the total primary storage space (in GiB) owned by account","name":"primarystoragetotal","type":"long"},{"description":"the total number of virtual machines deployed by this account","name":"vmtotal","type":"long"},{"description":"the total number of networks available to be created for this account","name":"networkavailable","type":"string"},{"description":"true if account is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the list of acl groups that account belongs to","name":"groups","type":"list"},{"description":"the total number of vpcs available to be created for this account","name":"vpcavailable","type":"string"},{"description":"the total number of network traffic bytes sent","name":"sentbytes","type":"long"}],"since":"4.0"},{"description":"Revokes certificate using configured CA plugin","isasync":true,"name":"revokeCertificate","params":[{"description":"Name of the CA service provider, otherwise the default configured provider plugin will be used","length":255,"name":"provider","required":false,"type":"string"},{"description":"The certificate CN","length":255,"name":"cn","required":false,"type":"string"},{"description":"The certificate serial number, as a hex value","length":255,"name":"serial","required":true,"type":"string"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.11.0"},{"description":"Changes the service offering for a system vm (console proxy or secondary storage). The system vm must be in a \"Stopped\" state for this command to take effect.","isasync":false,"name":"changeServiceForSystemVm","params":[{"description":"name value pairs of custom parameters for cpu, memory and cpunumber. example details[i].name=value","length":255,"name":"details","required":false,"type":"map"},{"description":"the service offering ID to apply to the system vm","length":255,"name":"serviceofferingid","related":"createServiceOffering,updateServiceOffering,listServiceOfferings","required":true,"type":"uuid"},{"description":"The ID of the system vm","length":255,"name":"id","related":"changeServiceForSystemVm,startSystemVm,migrateSystemVm","required":true,"type":"uuid"}],"related":"startSystemVm,migrateSystemVm","response":[{"description":"the state of the system VM","name":"state","type":"string"},{"description":"the hostname for the system VM","name":"hostname","type":"string"},{"description":"the public MAC address for the system VM","name":"publicmacaddress","type":"string"},{"description":"the name of the system VM","name":"name","type":"string"},{"description":"the Pod ID for the system VM","name":"podid","type":"string"},{"description":"the job ID associated with the system VM. This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobid","type":"string"},{"description":"the network domain for the system VM","name":"networkdomain","type":"string"},{"description":"the number of active console sessions for the console proxy system vm","name":"activeviewersessions","type":"integer"},{"description":"the system VM type","name":"systemvmtype","type":"string"},{"description":"the template ID for the system VM","name":"templateid","type":"string"},{"description":"guest vlan range","name":"guestvlan","type":"string"},{"description":"the link local MAC address for the system vm","name":"linklocalmacaddress","type":"string"},{"description":"the first DNS for the system VM","name":"dns1","type":"string"},{"description":"the host ID for the system VM","name":"hostid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the public netmask for the system VM","name":"publicnetmask","type":"string"},{"description":"the private MAC address for the system VM","name":"privatemacaddress","type":"string"},{"description":"the private netmask for the system VM","name":"privatenetmask","type":"string"},{"description":"the public IP address for the system VM","name":"publicip","type":"string"},{"description":"the ID of the system VM","name":"id","type":"string"},{"description":"the second DNS for the system VM","name":"dns2","type":"string"},{"description":"the gateway for the system VM","name":"gateway","type":"string"},{"description":"the Zone ID for the system VM","name":"zoneid","type":"string"},{"description":"public vlan range","name":"publicvlan","type":"list"},{"description":"the job status associated with the system VM.  This is only displayed if the router listed is part of a currently running asynchronous job.","name":"jobstatus","type":"integer"},{"description":"the private IP address for the system VM","name":"privateip","type":"string"},{"description":"the link local IP address for the system vm","name":"linklocalip","type":"string"},{"description":"the date and time the system VM was created","name":"created","type":"date"},{"description":"the Zone name for the system VM","name":"zonename","type":"string"},{"description":"the link local netmask for the system vm","name":"linklocalnetmask","type":"string"}]},{"description":"Update SIOC info","isasync":false,"name":"updateSiocInfo","params":[{"description":"Storage Pool ID","length":255,"name":"storageid","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":true,"type":"uuid"},{"description":"Limit IOPS per GB","length":255,"name":"limitiopspergb","required":true,"type":"integer"},{"description":"Notify if IOPS above this value","length":255,"name":"iopsnotifythreshold","required":true,"type":"integer"},{"description":"Zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"},{"description":"Shares per GB","length":255,"name":"sharespergb","required":true,"type":"integer"}],"related":"","response":[{"description":"The return message from the operation ('Success' if successful)","name":"msg","type":"string"}],"since":"4.11.0"},{"description":"enable Nuage underlay on vlan ip range","isasync":true,"name":"enableNuageUnderlayVlanIpRange","params":[{"description":"VLAN IP Range ID","length":255,"name":"id","related":"listVlanIpRanges,dedicatePublicIpRange,createVlanIpRange","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.10"},{"description":"List the IP forwarding rules","isasync":false,"name":"listIpForwardingRules","params":[{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"Lists rule with the specified ID.","length":255,"name":"id","related":"createPortForwardingRule,updatePortForwardingRule,listIpForwardingRules,listPortForwardingRules","required":false,"type":"uuid"},{"description":"Lists all rules applied to the specified VM.","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list the rule belonging to this public IP address","length":255,"name":"ipaddressid","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"}],"related":"createPortForwardingRule,updatePortForwardingRule,listPortForwardingRules","response":[{"description":"the VM ID for the port forwarding rule","name":"virtualmachineid","type":"string"},{"description":"the public ip address for the port forwarding rule","name":"ipaddress","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the starting port of port forwarding rule's private port range","name":"privateport","type":"string"},{"description":"the starting port of port forwarding rule's public port range","name":"publicport","type":"string"},{"description":"the VM name for the port forwarding rule","name":"virtualmachinename","type":"string"},{"description":"the protocol of the port forwarding rule","name":"protocol","type":"string"},{"description":"the vm ip address for the port forwarding rule","name":"vmguestip","type":"string"},{"description":"is firewall for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the ID of the port forwarding rule","name":"id","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"publicendport","type":"string"},{"description":"the VM display name for the port forwarding rule","name":"virtualmachinedisplayname","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"the ending port of port forwarding rule's private port range","name":"privateendport","type":"string"},{"description":"the public ip address id for the port forwarding rule","name":"ipaddressid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the id of the guest network the port forwarding rule belongs to","name":"networkid","type":"string"}]},{"description":"Creates an instant snapshot of a volume.","isasync":true,"name":"createSnapshot","params":[{"description":"The account of the snapshot. The account parameter must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"The domain ID of the snapshot. If used with the account parameter, specifies a domain for the account associated with the disk volume.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"policy id of the snapshot, if this is null, then use MANUAL_POLICY.","length":255,"name":"policyid","related":"updateSnapshotPolicy","required":false,"type":"uuid"},{"description":"asynchronous backup if true","length":255,"name":"asyncbackup","required":false,"type":"boolean"},{"description":"the name of the snapshot","length":255,"name":"name","required":false,"type":"string"},{"description":"Currently applicable only for managed storage. Valid location types: 'primary', 'secondary'. Default = 'primary'.","length":255,"name":"locationtype","required":false,"type":"string"},{"description":"The ID of the disk volume","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":true,"type":"uuid"},{"description":"quiesce vm if true","length":255,"name":"quiescevm","required":false,"type":"boolean"}],"related":"createSnapshotFromVMSnapshot,revertSnapshot","response":[{"description":"valid location types are primary and secondary.","name":"locationtype","type":"string"},{"description":"the project name of the snapshot","name":"project","type":"string"},{"description":"the account associated with the snapshot","name":"account","type":"string"},{"description":"virtual size of backedup snapshot on image store","name":"virtualsize","type":"long"},{"description":"ID of the disk volume","name":"volumeid","type":"string"},{"description":"ID of the snapshot","name":"id","type":"string"},{"description":"  the date the snapshot was created","name":"created","type":"date"},{"description":"name of the snapshot","name":"name","type":"string"},{"description":"indicates whether the underlying storage supports reverting the volume to this snapshot","name":"revertable","type":"boolean"},{"description":"valid types are hourly, daily, weekly, monthy, template, and none.","name":"intervaltype","type":"string"},{"description":"the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage","name":"state","type":"state"},{"description":"the type of the snapshot","name":"snapshottype","type":"string"},{"description":"the domain name of the snapshot's account","name":"domain","type":"string"},{"description":"the domain ID of the snapshot's account","name":"domainid","type":"string"},{"description":"the project id of the snapshot","name":"projectid","type":"string"},{"description":"physical size of backedup snapshot on image store","name":"physicalsize","type":"long"},{"description":"display name of the os on volume","name":"osdisplayname","type":"string"},{"description":"id of the availability zone","name":"zoneid","type":"string"},{"description":"id of the os on volume","name":"ostypeid","type":"string"},{"description":"type of the disk volume","name":"volumetype","type":"string"},{"description":"name of the disk volume","name":"volumename","type":"string"},{"description":"the list of resource tags associated with snapshot","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"}]},{"description":"Deletes a vmsnapshot.","isasync":true,"name":"deleteVMSnapshot","params":[{"description":"The ID of the VM snapshot","length":255,"name":"vmsnapshotid","related":"listVMSnapshot,createVMSnapshot","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.2.0"},{"description":"Lists storage pool metrics","isasync":false,"name":"listStoragePoolsMetrics","params":[{"description":"the ID of the storage pool","length":255,"name":"id","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"list storage pools belongig to the specific cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the ID of the storage pool","length":255,"name":"scope","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the name of the storage pool","length":255,"name":"name","required":false,"type":"string"},{"description":"the IP address for the storage pool","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"the Zone ID for the storage pool","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the Pod ID for the storage pool","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"the storage pool path","length":255,"name":"path","required":false,"type":"string"}],"related":"","response":[{"description":"disk size unallocated in GiB","name":"disksizeunallocatedgb","type":"string"},{"description":"disk size in GiB","name":"disksizetotalgb","type":"string"},{"description":"storage usage disable threshold exceeded","name":"storageusagedisablethreshold","type":"boolean"},{"description":"storage allocated disable threshold exceeded","name":"storageallocateddisablethreshold","type":"boolean"},{"description":"storage allocated notification threshold exceeded","name":"storageallocatedthreshold","type":"boolean"},{"description":"disk size used in GiB","name":"disksizeusedgb","type":"string"},{"description":"disk size allocated in GiB","name":"disksizeallocatedgb","type":"string"},{"description":"storage usage notification threshold exceeded","name":"storageusagethreshold","type":"boolean"}],"since":"4.9.3"},{"description":"list the vm nics  IP to NIC","isasync":false,"name":"listNics","params":[{"description":"the ID of the nic to to list IPs","length":255,"name":"nicid","related":"listNics","required":false,"type":"uuid"},{"description":"the ID of the vm","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"list nic of the specific vm's network","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"","response":[{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"}]},{"description":"Starts a router.","isasync":true,"name":"rebootRouter","params":[{"description":"the ID of the router","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,changeServiceForRouter,destroyRouter,rebootRouter,listRouters","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,changeServiceForRouter,destroyRouter,listRouters","response":[{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"}],"type":"set"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"}]},{"description":"Create a new keypair and returns the private key","isasync":false,"name":"createSSHKeyPair","params":[{"description":"Name of the keypair","length":255,"name":"name","required":true,"type":"string"},{"description":"an optional domainId for the ssh key. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"an optional account for the ssh key. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"an optional project for the ssh key","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"}],"related":"","response":[{"description":"Private key","name":"privatekey","type":"string"}]},{"description":"Creates an instant snapshot of a volume from existing vm snapshot.","isasync":true,"name":"createSnapshotFromVMSnapshot","params":[{"description":"The ID of the VM snapshot","length":255,"name":"vmsnapshotid","related":"listVMSnapshot,createVMSnapshot","required":true,"type":"uuid"},{"description":"the name of the snapshot","length":255,"name":"name","required":false,"type":"string"},{"description":"The ID of the disk volume","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":true,"type":"uuid"}],"related":"revertSnapshot","response":[{"description":"display name of the os on volume","name":"osdisplayname","type":"string"},{"description":"ID of the disk volume","name":"volumeid","type":"string"},{"description":"the domain ID of the snapshot's account","name":"domainid","type":"string"},{"description":"ID of the snapshot","name":"id","type":"string"},{"description":"the domain name of the snapshot's account","name":"domain","type":"string"},{"description":"valid types are hourly, daily, weekly, monthy, template, and none.","name":"intervaltype","type":"string"},{"description":"the account associated with the snapshot","name":"account","type":"string"},{"description":"name of the snapshot","name":"name","type":"string"},{"description":"type of the disk volume","name":"volumetype","type":"string"},{"description":"id of the os on volume","name":"ostypeid","type":"string"},{"description":"virtual size of backedup snapshot on image store","name":"virtualsize","type":"long"},{"description":"valid location types are primary and secondary.","name":"locationtype","type":"string"},{"description":"id of the availability zone","name":"zoneid","type":"string"},{"description":"the type of the snapshot","name":"snapshottype","type":"string"},{"description":"physical size of backedup snapshot on image store","name":"physicalsize","type":"long"},{"description":"the project id of the snapshot","name":"projectid","type":"string"},{"description":"the list of resource tags associated with snapshot","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"list"},{"description":"name of the disk volume","name":"volumename","type":"string"},{"description":"  the date the snapshot was created","name":"created","type":"date"},{"description":"the project name of the snapshot","name":"project","type":"string"},{"description":"the state of the snapshot. BackedUp means that snapshot is ready to be used; Creating - the snapshot is being allocated on the primary storage; BackingUp - the snapshot is being backed up on secondary storage","name":"state","type":"state"},{"description":"indicates whether the underlying storage supports reverting the volume to this snapshot","name":"revertable","type":"boolean"}],"since":"4.10.0"},{"description":"Authorizes a particular egress rule for this security group","isasync":true,"name":"authorizeSecurityGroupEgress","params":[{"description":"TCP is default. UDP is the other supported protocol","length":255,"name":"protocol","required":false,"type":"string"},{"description":"the cidr list associated","length":255,"name":"cidrlist","required":false,"type":"list"},{"description":"user to security group mapping","length":255,"name":"usersecuritygrouplist","required":false,"type":"map"},{"description":"an optional domainId for the security group. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"start port for this egress rule","length":255,"name":"startport","required":false,"type":"integer"},{"description":"The name of the security group. Mutually exclusive with securityGroupId parameter","length":255,"name":"securitygroupname","required":false,"type":"string"},{"description":"error code for this icmp message","length":255,"name":"icmpcode","required":false,"type":"integer"},{"description":"type of the icmp message being sent","length":255,"name":"icmptype","required":false,"type":"integer"},{"description":"an optional account for the security group. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"end port for this egress rule","length":255,"name":"endport","required":false,"type":"integer"},{"description":"an optional project of the security group","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"The ID of the security group. Mutually exclusive with securityGroupName parameter","length":255,"name":"securitygroupid","related":"createSecurityGroup","required":false,"type":"uuid"}],"related":"authorizeSecurityGroupIngress","response":[{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"}],"type":"set"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"}],"since":"3.0.0"},{"description":"Lists storage pools.","isasync":false,"name":"listStoragePools","params":[{"description":"the storage pool path","length":255,"name":"path","required":false,"type":"string"},{"description":"the IP address for the storage pool","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the ID of the storage pool","length":255,"name":"scope","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the Zone ID for the storage pool","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"list storage pools belongig to the specific cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"the name of the storage pool","length":255,"name":"name","required":false,"type":"string"},{"description":"the ID of the storage pool","length":255,"name":"id","related":"listStoragePools,findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"the Pod ID for the storage pool","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"}],"related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","response":[{"description":"the name of the storage pool","name":"name","type":"string"},{"description":"the IP address of the storage pool","name":"ipaddress","type":"string"},{"description":"the overprovisionfactor for the storage pool","name":"overprovisionfactor","type":"string"},{"description":"the storage pool type","name":"type","type":"string"},{"description":"the storage pool capabilities","name":"storagecapabilities","type":"map"},{"description":"the Zone name of the storage pool","name":"zonename","type":"string"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"IOPS CloudStack can provision from this storage pool","name":"capacityiops","type":"long"},{"description":"the Pod ID of the storage pool","name":"podid","type":"string"},{"description":"the ID of the cluster for the storage pool","name":"clusterid","type":"string"},{"description":"the name of the cluster for the storage pool","name":"clustername","type":"string"},{"description":"Storage provider for this pool","name":"provider","type":"string"},{"description":"the date and time the storage pool was created","name":"created","type":"date"},{"description":"the Zone ID of the storage pool","name":"zoneid","type":"string"},{"description":"the storage pool path","name":"path","type":"string"},{"description":"the hypervisor type of the storage pool","name":"hypervisor","type":"string"},{"description":"the ID of the storage pool","name":"id","type":"string"},{"description":"the state of the storage pool","name":"state","type":"storagepoolstatus"},{"description":"the total disk size of the storage pool","name":"disksizetotal","type":"long"},{"description":"the host's currently used disk size","name":"disksizeused","type":"long"},{"description":"the tags for the storage pool","name":"tags","type":"string"},{"description":"the Pod name of the storage pool","name":"podname","type":"string"},{"description":"total min IOPS currently in use by volumes","name":"allocatediops","type":"long"},{"description":"true if this pool is suitable to migrate a volume, false otherwise","name":"suitableformigration","type":"boolean"},{"description":"the scope of the storage pool","name":"scope","type":"string"}]},{"description":"Enable a Cisco Nexus VSM device","isasync":true,"name":"enableCiscoNexusVSM","params":[{"description":"Id of the Cisco Nexus 1000v VSM device to be enabled","length":255,"name":"id","related":"enableCiscoNexusVSM,disableCiscoNexusVSM,listCiscoNexusVSMs","required":true,"type":"uuid"}],"related":"disableCiscoNexusVSM,listCiscoNexusVSMs","response":[{"description":"The VSM is a switch supervisor. This is the VSM's switch domain id","name":"vsmdomainid","type":"string"},{"description":"packet vlan id of the VSM","name":"vsmpktvlanid","type":"int"},{"description":"The Device State (Enabled/Disabled) of the VSM","name":"vsmdevicestate","type":"string"},{"description":"device id of the Cisco N1KV VSM device","name":"vsmdeviceid","type":"string"},{"description":"storage vlan id of the VSM","name":"vsmstoragevlanid","type":"int"},{"description":"device state","name":"vsmdevicestate","type":"string"},{"description":"The mode of the VSM (standalone/HA)","name":"vsmconfigmode","type":"string"},{"description":"the management IP address of the external Cisco Nexus 1000v Virtual Supervisor Module","name":"ipaddress","type":"string"},{"description":"control vlan id of the VSM","name":"vsmctrlvlanid","type":"int"},{"description":"device name","name":"vsmdevicename","type":"string"},{"description":"management vlan id of the VSM","name":"vsmmgmtvlanid","type":"string"},{"description":"The Config State (Primary/Standby) of the VSM","name":"vsmconfigstate","type":"string"}]},{"description":"Find hosts suitable for migrating a virtual machine.","isasync":false,"name":"findHostsForMigration","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"find hosts to which this VM can be migrated and flag the hosts with enough CPU/RAM to host the VM","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"","response":[{"description":"the Pod ID of the host","name":"podid","type":"string"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the host hypervisor","name":"hypervisor","type":"hypervisortype"},{"description":"the cluster ID of the host","name":"clusterid","type":"string"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"true if the host is disconnected. False otherwise.","name":"disconnected","type":"date"},{"description":"the cluster type of the cluster that host belongs to","name":"clustertype","type":"string"},{"description":"true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise","name":"suitableformigration","type":"boolean"},{"description":"the IP address of the host","name":"ipaddress","type":"string"},{"description":"the cpu average load on the host","name":"averageload","type":"long"},{"description":"the amount of the host's memory after applying the mem.overprovisioning.factor ","name":"memorywithoverprovisioning","type":"string"},{"description":"the date and time the host was last pinged","name":"lastpinged","type":"date"},{"description":"comma-separated list of tags for the host","name":"hosttags","type":"string"},{"description":"the state of the host","name":"state","type":"status"},{"description":"the memory total of the host, this parameter is deprecated use memorywithoverprovisioning","name":"memorytotal","type":"long"},{"description":"the ID of the host","name":"id","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"true if the host is Ha host (dedicated to vms started by HA process; false otherwise","name":"hahost","type":"boolean"},{"description":"events available for the host","name":"events","type":"string"},{"description":"the amount of the host's CPU currently allocated","name":"cpuallocated","type":"string"},{"description":"the name of the host","name":"name","type":"string"},{"description":"the amount of the host's CPU currently used","name":"cpuused","type":"string"},{"description":"the Zone name of the host","name":"zonename","type":"string"},{"description":"the CPU number of the host","name":"cpunumber","type":"integer"},{"description":"the Pod name of the host","name":"podname","type":"string"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"the total disk size of the host","name":"disksizetotal","type":"long"},{"description":"the host version","name":"version","type":"string"},{"description":"true if migrating a vm to this host requires storage motion, false otherwise","name":"requiresStorageMotion","type":"boolean"},{"description":"the incoming network traffic on the host","name":"networkkbsread","type":"long"},{"description":"the OS category ID of the host","name":"oscategoryid","type":"string"},{"description":"the Zone ID of the host","name":"zoneid","type":"string"},{"description":"the amount of the host's memory currently allocated","name":"memoryallocated","type":"string"},{"description":"the CPU speed of the host","name":"cpuspeed","type":"long"},{"description":"capabilities of the host","name":"capabilities","type":"string"},{"description":"true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise","name":"hasenoughcapacity","type":"boolean"},{"description":"the management server ID of the host","name":"managementserverid","type":"long"},{"description":"the host type","name":"type","type":"type"},{"description":"the amount of the host's memory currently used","name":"memoryused","type":"long"},{"description":"the resource state of the host","name":"resourcestate","type":"string"},{"description":"true if local storage is active, false otherwise","name":"islocalstorageactive","type":"boolean"},{"description":"the OS category name of the host","name":"oscategoryname","type":"string"},{"description":"the cluster name of the host","name":"clustername","type":"string"},{"description":"the amount of the host's CPU after applying the cpu.overprovisioning.factor ","name":"cpuwithoverprovisioning","type":"string"}]},{"description":"Updates a hypervisor capabilities.","isasync":false,"name":"updateHypervisorCapabilities","params":[{"description":"the max number of Guest VMs per host for this hypervisor.","length":255,"name":"maxguestslimit","required":false,"type":"long"},{"description":"ID of the hypervisor capability","length":255,"name":"id","related":"updateHypervisorCapabilities,listHypervisorCapabilities","required":false,"type":"uuid"},{"description":"set true to enable security group for this hypervisor.","length":255,"name":"securitygroupenabled","required":false,"type":"boolean"}],"related":"listHypervisorCapabilities","response":[{"description":"true if security group is supported","name":"securitygroupenabled","type":"boolean"},{"description":"the maximum number of Data Volumes that can be attached for this hypervisor","name":"maxdatavolumeslimit","type":"integer"},{"description":"the maximum number of Hosts per cluster for this hypervisor","name":"maxhostspercluster","type":"integer"},{"description":"the ID of the hypervisor capabilities row","name":"id","type":"string"},{"description":"the hypervisor type","name":"hypervisor","type":"hypervisortype"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"true if storage motion is supported","name":"storagemotionenabled","type":"boolean"},{"description":"the maximum number of guest vms recommended for this hypervisor","name":"maxguestslimit","type":"long"}],"since":"3.0.0"},{"description":"Dedicates a guest vlan range to an account","isasync":false,"name":"dedicateGuestVlanRange","params":[{"description":"guest vlan range to be dedicated","length":255,"name":"vlanrange","required":true,"type":"string"},{"description":"account who will own the VLAN","length":255,"name":"account","required":false,"type":"string"},{"description":"physical network ID of the vlan","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"},{"description":"domain ID of the account owning a VLAN","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"project who will own the VLAN","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"}],"related":"listDedicatedGuestVlanRanges","response":[{"description":"the ID of the guest VLAN range","name":"id","type":"string"},{"description":"the project name of the guest vlan range","name":"project","type":"string"},{"description":"the account of the guest VLAN range","name":"account","type":"string"},{"description":"the domain ID of the guest VLAN range","name":"domainid","type":"string"},{"description":"the guest VLAN range","name":"guestvlanrange","type":"string"},{"description":"the project id of the guest vlan range","name":"projectid","type":"string"},{"description":"the physical network of the guest vlan range","name":"physicalnetworkid","type":"long"},{"description":"the zone of the guest vlan range","name":"zoneid","type":"long"},{"description":"the domain name of the guest VLAN range","name":"domain","type":"string"}]},{"description":"Adds VM to specified network by creating a NIC","isasync":true,"name":"addNicToVirtualMachine","params":[{"description":"Network ID","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":true,"type":"uuid"},{"description":"IP Address for the new network","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"Virtual Machine ID","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,addNicToVirtualMachine,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"Mac Address for the new network","length":255,"name":"macaddress","required":false,"type":"string"},{"description":"DHCP options which are passed to the nic Example: dhcpoptions[0].dhcp:114=url\u0026dhcpoptions[0].dhcp:66=www.test.com","length":255,"name":"dhcpoptions","required":false,"type":"map"}],"related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"}],"type":"set"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"}],"type":"set"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"set"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"set"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"}],"type":"set"},{"description":"the project name of the group","name":"project","type":"string"}],"type":"set"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"}],"type":"set"}]},{"description":"Lists all static routes","isasync":false,"name":"listStaticRoutes","params":[{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list static route by id","length":255,"name":"id","related":"listStaticRoutes","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list static routes by gateway id","length":255,"name":"gatewayid","related":"createPrivateGateway","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"list static routes by vpc id","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"}],"related":"","response":[{"description":"the ID of static route","name":"id","type":"string"},{"description":"the project name of the static route","name":"project","type":"string"},{"description":"the ID of the domain associated with the static route","name":"domainid","type":"string"},{"description":"the domain associated with the static route","name":"domain","type":"string"},{"description":"the state of the static route","name":"state","type":"string"},{"description":"the account associated with the static route","name":"account","type":"string"},{"description":"the list of resource tags associated with static route","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"}],"type":"list"},{"description":"static route CIDR","name":"cidr","type":"string"},{"description":"VPC gateway the route is created for","name":"gatewayid","type":"string"},{"description":"VPC the static route belongs to","name":"vpcid","type":"string"},{"description":"the project id of the static route","name":"projectid","type":"string"}]},{"description":"Lists all public ip addresses","isasync":false,"name":"listPublicIpAddresses","params":[{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"limits search results to allocated public IP addresses","length":255,"name":"allocatedonly","required":false,"type":"boolean"},{"description":"lists all public IP addresses by state","length":255,"name":"state","required":false,"type":"string"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the virtual network for the IP address","length":255,"name":"forvirtualnetwork","required":false,"type":"boolean"},{"description":"lists all public IP addresses by physical network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"List IPs belonging to the VPC","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"lists IP address by ID","length":255,"name":"id","related":"associateIpAddress,listPublicIpAddresses,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list only static NAT IP addresses","length":255,"name":"isstaticnat","required":false,"type":"boolean"},{"description":"list only source NAT IP addresses","length":255,"name":"issourcenat","required":false,"type":"boolean"},{"description":"list only IPs used for load balancing","length":255,"name":"forloadbalancing","required":false,"type":"boolean"},{"description":"lists all public IP addresses by zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"lists the specified IP address","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"lists all public IP addresses associated to the network specified","length":255,"name":"associatednetworkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"lists all public IP addresses by VLAN ID","length":255,"name":"vlanid","related":"listVlanIpRanges,dedicatePublicIpRange,createVlanIpRange","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"}],"related":"associateIpAddress,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","response":[{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the domain ID the public IP address is associated with","name":"domainid","type":"string"},{"description":"the ID of the zone the public IP address belongs to","name":"zoneid","type":"string"},{"description":"the name of the Network associated with the IP address","name":"associatednetworkname","type":"string"},{"description":"true if the IP address is a source nat address, false otherwise","name":"issourcenat","type":"boolean"},{"description":"the domain the public IP address is associated with","name":"domain","type":"string"},{"description":"the VLAN associated with the IP address","name":"vlanname","type":"string"},{"description":"true if this ip is system ip (was allocated as a part of deployVm or createLbRule)","name":"issystem","type":"boolean"},{"description":"public IP address","name":"ipaddress","type":"string"},{"description":"the virtual network for the IP address","name":"forvirtualnetwork","type":"boolean"},{"description":"virtual machine name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinename","type":"string"},{"description":"the list of resource tags associated with ip address","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"list"},{"description":"the account the public IP address is associated with","name":"account","type":"string"},{"description":"public IP address id","name":"id","type":"string"},{"description":"VPC the ip belongs to","name":"vpcid","type":"string"},{"description":"the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only","name":"vlanid","type":"string"},{"description":"virtual machine id the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachineid","type":"string"},{"description":"virtual machine display name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinedisplayname","type":"string"},{"description":"date the public IP address was acquired","name":"allocated","type":"date"},{"description":"the ID of the Network associated with the IP address","name":"associatednetworkid","type":"string"},{"description":"State of the ip address. Can be: Allocatin, Allocated and Releasing","name":"state","type":"string"},{"description":"true if this ip is for static nat, false otherwise","name":"isstaticnat","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"virtual machine (dnat) ip address (not null only for static nat Ip)","name":"vmipaddress","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"is public IP portable across the zones","name":"isportable","type":"boolean"},{"description":"the name of the zone the public IP address belongs to","name":"zonename","type":"string"},{"description":"is public ip for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value","name":"purpose","type":"string"},{"description":"the ID of the Network where ip belongs to","name":"networkid","type":"string"}]},{"description":"lists F5 load balancer devices","isasync":false,"name":"listF5LoadBalancers","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"f5 load balancer device ID","length":255,"name":"lbdeviceid","related":"listF5LoadBalancers,addF5LoadBalancer","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"addF5LoadBalancer","response":[{"description":"device capacity","name":"lbdevicecapacity","type":"long"},{"description":"device name","name":"lbdevicename","type":"string"},{"description":"the management IP address of the external load balancer","name":"ipaddress","type":"string"},{"description":"the public interface of the load balancer","name":"publicinterface","type":"string"},{"description":"true if device is dedicated for an account","name":"lbdevicededicated","type":"boolean"},{"description":"the physical network to which this F5 device belongs to","name":"physicalnetworkid","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"device state","name":"lbdevicestate","type":"string"},{"description":"device id of the F5 load balancer","name":"lbdeviceid","type":"string"},{"description":"the private interface of the load balancer","name":"privateinterface","type":"string"}]},{"description":"Lists OpenDyalight controllers","isasync":false,"name":"listOpenDaylightControllers","params":[{"description":"the ID of a OpenDaylight Controller","length":255,"name":"id","related":"listOpenDaylightControllers,addOpenDaylightController,deleteOpenDaylightController","required":false,"type":"uuid"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"}],"related":"addOpenDaylightController,deleteOpenDaylightController","response":[{"description":"device id of the controller","name":"id","type":"string"},{"description":"the name assigned to the controller","name":"name","type":"string"},{"description":"the url of the controller api","name":"url","type":"string"},{"description":"the physical network to which this controller belongs to","name":"physicalnetworkid","type":"string"},{"description":"the username to authenticate to the controller","name":"username","type":"string"}]},{"description":"Lists F5 external load balancer appliances added in a zone.","isasync":false,"name":"listExternalLoadBalancers","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"zone Id","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","response":[{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the IP address of the host","name":"ipaddress","type":"string"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the CPU number of the host","name":"cpunumber","type":"integer"},{"description":"the OS category name of the host","name":"oscategoryname","type":"string"},{"description":"the CPU speed of the host","name":"cpuspeed","type":"long"},{"description":"true if the host is disconnected. False otherwise.","name":"disconnected","type":"date"},{"description":"the amount of the host's CPU after applying the cpu.overprovisioning.factor ","name":"cpuwithoverprovisioning","type":"string"},{"description":"events available for the host","name":"events","type":"string"},{"description":"the last annotation set on this host by an admin","name":"annotation","type":"string"},{"description":"the OS category ID of the host","name":"oscategoryid","type":"string"},{"description":"the number of CPU sockets on the host","name":"cpusockets","type":"integer"},{"description":"the memory total of the host, this parameter is deprecated use memorywithoverprovisioning","name":"memorytotal","type":"long"},{"description":"the state of the host","name":"state","type":"status"},{"description":"the ID of the host","name":"id","type":"string"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"the cluster ID of the host","name":"clusterid","type":"string"},{"description":"the last time this host was annotated","name":"lastannotated","type":"date"},{"description":"Host details in key/value pairs.","name":"details","type":"map"},{"description":"the total disk size of the host","name":"disksizetotal","type":"long"},{"description":"capabilities of the host","name":"capabilities","type":"string"},{"description":"the Zone name of the host","name":"zonename","type":"string"},{"description":"the amount of the host's memory currently allocated","name":"memoryallocated","type":"long"},{"description":"the management server ID of the host","name":"managementserverid","type":"long"},{"description":"true if the host is Ha host (dedicated to vms started by HA process; false otherwise","name":"hahost","type":"boolean"},{"description":"the incoming network traffic on the host","name":"networkkbsread","type":"long"},{"description":"the host hypervisor","name":"hypervisor","type":"hypervisortype"},{"description":"true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise","name":"hasenoughcapacity","type":"boolean"},{"description":"the date and time the host was last pinged","name":"lastpinged","type":"date"},{"description":"the host out-of-band management information","name":"outofbandmanagement","type":"outofbandmanagementresponse"},{"description":"the cluster name of the host","name":"clustername","type":"string"},{"description":"the amount of the host's CPU currently used","name":"cpuused","type":"string"},{"description":"the amount of the host's CPU currently allocated","name":"cpuallocated","type":"string"},{"description":"the cluster type of the cluster that host belongs to","name":"clustertype","type":"string"},{"description":"the amount of the host's memory currently used","name":"memoryused","type":"long"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"the host HA information information","name":"hostha","type":"hostharesponse"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the amount of the host's memory after applying the mem.overprovisioning.factor","name":"memorywithoverprovisioning","type":"string"},{"description":"the Pod name of the host","name":"podname","type":"string"},{"description":"the name of the host","name":"name","type":"string"},{"description":"comma-separated list of tags for the host","name":"hosttags","type":"string"},{"description":"the host version","name":"version","type":"string"},{"description":"the admin that annotated this host","name":"username","type":"string"},{"description":"GPU cards present in the host","name":"gpugroup","response":[{"description":"GPU cards present in the host","name":"gpugroupname","type":"string"},{"description":"the list of enabled vGPUs","name":"vgpu","response":[{"description":"Maximum vgpu can be created with this vgpu type on the given gpu group","name":"maxcapacity","type":"long"},{"description":"Video RAM for this vGPU type","name":"videoram","type":"long"},{"description":"Maximum X resolution per display","name":"maxresolutionx","type":"long"},{"description":"Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type","name":"remainingcapacity","type":"long"},{"description":"Maximum Y resolution per display","name":"maxresolutiony","type":"long"},{"description":"Maximum displays per user","name":"maxheads","type":"long"},{"description":"Maximum no. of vgpu per gpu card (pgpu)","name":"maxvgpuperpgpu","type":"long"},{"description":"Model Name of vGPU","name":"vgputype","type":"string"}],"type":"list"}],"type":"list"},{"description":"the resource state of the host","name":"resourcestate","type":"string"},{"description":"true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise","name":"suitableformigration","type":"boolean"},{"description":"the Zone ID of the host","name":"zoneid","type":"string"},{"description":"true if local storage is active, false otherwise","name":"islocalstorageactive","type":"boolean"},{"description":"the Pod ID of the host","name":"podid","type":"string"},{"description":"the cpu average load on the host","name":"averageload","type":"long"},{"description":"the host type","name":"type","type":"type"}]},{"description":"Updates an ISO file.","isasync":false,"name":"updateIso","params":[{"description":"the display text of the image","length":4096,"name":"displaytext","required":false,"type":"string"},{"description":"Details in key/value pairs using format details[i].keyname=keyvalue. Example: details[0].hypervisortoolsversion=xenserver61","length":255,"name":"details","required":false,"type":"map"},{"description":"the format for the image","length":255,"name":"format","required":false,"type":"string"},{"description":"true if the image supports the password reset feature; default is false","length":255,"name":"passwordenabled","required":false,"type":"boolean"},{"description":"the name of the image file","length":255,"name":"name","required":false,"type":"string"},{"description":"sort key of the template, integer","length":255,"name":"sortkey","required":false,"type":"integer"},{"description":"true if the template requres HVM, false otherwise; available only for updateTemplate API","length":255,"name":"requireshvm","required":false,"type":"boolean"},{"description":"true if the template type is routing i.e., if template is used to deploy router","length":255,"name":"isrouting","required":false,"type":"boolean"},{"description":"true if image is bootable, false otherwise; available only for updateIso API","length":255,"name":"bootable","required":false,"type":"boolean"},{"description":"the ID of the OS type that best represents the OS of this image.","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"},{"description":"optional boolean field, which indicates if details should be cleaned up or not (if set to true, details removed for this resource, details field ignored; if false or not set, no action)","length":255,"name":"cleanupdetails","required":false,"type":"boolean"},{"description":"true if template/ISO contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","length":255,"name":"isdynamicallyscalable","required":false,"type":"boolean"},{"description":"the ID of the image file","length":255,"name":"id","related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,updateIso,prepareTemplate,createTemplate","required":true,"type":"uuid"}],"related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,prepareTemplate,createTemplate","response":[{"description":"the size of the template","name":"size","type":"long"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the template ID","name":"id","type":"string"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"the template name","name":"name","type":"string"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"the tag of this template","name":"templatetag","type":"string"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the account name to which the template belongs","name":"account","type":"string"}]},{"description":"Adds a BigSwitch BCF Controller device","isasync":true,"name":"addBigSwitchBcfDevice","params":[{"description":"Password of the BigSwitch BCF Controller.","length":255,"name":"password","required":true,"type":"string"},{"description":"NAT support of the BigSwitch BCF Controller.","length":255,"name":"nat","required":true,"type":"boolean"},{"description":"Hostname of ip address of the BigSwitch BCF Controller.","length":255,"name":"hostname","required":true,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"},{"description":"Username of the BigSwitch BCF Controller.","length":255,"name":"username","required":true,"type":"string"}],"related":"listBigSwitchBcfDevices","response":[{"description":"device name","name":"bigswitchdevicename","type":"string"},{"description":"the controller Ip address","name":"hostname","type":"string"},{"description":"the controller username","name":"username","type":"string"},{"description":"NAT support","name":"nat","type":"boolean"},{"description":"the physical network to which this BigSwitch BCF segment belongs to","name":"physicalnetworkid","type":"string"},{"description":"device id of the BigSwitch BCF Controller","name":"bcfdeviceid","type":"string"},{"description":"the controller password","name":"password","type":"string"},{"description":"name of the provider","name":"provider","type":"string"}],"since":"4.6.0"},{"description":"Deletes a counter","isasync":true,"name":"deleteCounter","params":[{"description":"the ID of the counter","length":255,"name":"id","related":"listCounters,createCounter","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Changes the default NIC on a VM","isasync":true,"name":"updateDefaultNicForVirtualMachine","params":[{"description":"NIC ID","length":255,"name":"nicid","related":"","required":true,"type":"uuid"},{"description":"Virtual Machine ID","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,updateDefaultNicForVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"}],"type":"set"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"}],"type":"set"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the project name of the vm","name":"project","type":"string"},{},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"}],"type":"set"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"}],"type":"set"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"}],"type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"}],"type":"set"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"}]},{"description":"Deletes a user for an account","isasync":false,"name":"deleteUser","params":[{"description":"id of the user to be deleted","length":255,"name":"id","related":"lockUser,createUser,getUser,enableUser,disableUser,updateUser,listUsers","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Initiates the specified power action to the host's out-of-band management interface","isasync":true,"name":"issueOutOfBandManagementPowerAction","params":[{"description":"out-of-band management power actions, valid actions are: ON, OFF, CYCLE, RESET, SOFT, STATUS","length":255,"name":"action","required":true,"type":"string"},{"description":"the ID of the host","length":255,"name":"hostid","related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"},{"description":"optional operation timeout in seconds that overrides the global or cluster-level out-of-band management timeout setting","length":255,"name":"timeout","required":false,"type":"long"}],"related":"enableOutOfBandManagementForCluster,enableOutOfBandManagementForHost,disableOutOfBandManagementForCluster,disableOutOfBandManagementForHost","response":[{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the out-of-band management interface address","name":"address","type":"string"},{"description":"the out-of-band management interface port","name":"port","type":"string"},{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the operation result description","name":"description","type":"string"}],"since":"4.9.0"},{"description":"Issues a client certificate using configured or provided CA plugin","isasync":true,"name":"issueCertificate","params":[{"description":"Certificate validity duration in number of days, when not provided the default configured value will be used","length":255,"name":"duration","required":false,"type":"integer"},{"description":"Comma separated list of domains, the certificate should be issued for. When csr is not provided, the first domain is used as a subject/CN","length":255,"name":"domain","required":false,"type":"string"},{"description":"Comma separated list of IP addresses, the certificate should be issued for","length":255,"name":"ipaddress","required":false,"type":"string"},{"description":"Name of the CA service provider, otherwise the default configured provider plugin will be used","length":255,"name":"provider","required":false,"type":"string"},{"description":"The certificate signing request (in pem format), if CSR is not provided then configured/provided options are considered","length":65535,"name":"csr","required":false,"type":"string"}],"related":"listCaCertificate","response":[{"description":"The CA certificate(s)","name":"cacertificates","type":"string"},{"description":"The client certificate","name":"certificate","type":"string"},{"description":"Private key for the certificate","name":"privatekey","type":"string"}],"since":"4.11.0"},{"description":"Deletes network device.","isasync":false,"name":"deleteNetworkDevice","params":[{"description":"Id of network device to delete","length":255,"name":"id","related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Creates a port forwarding rule","isasync":true,"name":"createPortForwardingRule","params":[{"description":"if true, firewall rule for source/end public port is automatically created; if false - firewall rule has to be created explicitly. If not specified 1) defaulted to false when PF rule is being created for VPC guest network 2) in all other cases defaulted to true","length":255,"name":"openfirewall","required":false,"type":"boolean"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the starting port of port forwarding rule's private port range","length":255,"name":"privateport","required":true,"type":"integer"},{"description":"the starting port of port forwarding rule's public port range","length":255,"name":"publicport","required":true,"type":"integer"},{"description":"VM guest nic secondary IP address for the port forwarding rule","length":255,"name":"vmguestip","required":false,"type":"string"},{"description":"the cidr list to forward traffic from","length":255,"name":"cidrlist","required":false,"type":"list"},{"description":"the ending port of port forwarding rule's private port range","length":255,"name":"privateendport","required":false,"type":"integer"},{"description":"the IP address id of the port forwarding rule","length":255,"name":"ipaddressid","related":"associateIpAddress,associateIpAddress,restartNetwork,listPublicIpAddresses,updateIpAddress","required":true,"type":"uuid"},{"description":"the network of the virtual machine the port forwarding rule will be created for. Required when public IP address is not associated with any guest network yet (VPC case).","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"the ending port of port forwarding rule's private port range","length":255,"name":"publicendport","required":false,"type":"integer"},{"description":"the ID of the virtual machine for the port forwarding rule","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"the protocol for the port forwarding rule. Valid values are TCP or UDP.","length":255,"name":"protocol","required":true,"type":"string"}],"related":"updatePortForwardingRule,listPortForwardingRules","response":[{"description":"the starting port of port forwarding rule's public port range","name":"publicport","type":"string"},{"description":"the VM display name for the port forwarding rule","name":"virtualmachinedisplayname","type":"string"},{"description":"the VM name for the port forwarding rule","name":"virtualmachinename","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"publicendport","type":"string"},{"description":"the id of the guest network the port forwarding rule belongs to","name":"networkid","type":"string"},{"description":"the ID of the port forwarding rule","name":"id","type":"string"},{"description":"the VM ID for the port forwarding rule","name":"virtualmachineid","type":"string"},{"description":"the public ip address for the port forwarding rule","name":"ipaddress","type":"string"},{"description":"the protocol of the port forwarding rule","name":"protocol","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"privateendport","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"is firewall for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the public ip address id for the port forwarding rule","name":"ipaddressid","type":"string"},{"description":"the vm ip address for the port forwarding rule","name":"vmguestip","type":"string"},{"description":"the starting port of port forwarding rule's private port range","name":"privateport","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"}],"type":"list"}]},{"description":"Dedicates a zones.","isasync":true,"name":"dedicateZone","params":[{"description":"the name of the account which needs dedication. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"the ID of the containing domain","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":true,"type":"uuid"},{"description":"the ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"","response":[{"description":"the Dedication Affinity Group ID of the zone","name":"affinitygroupid","type":"string"},{"description":"the Name of the Zone","name":"zonename","type":"string"},{"description":"the Account Id to which the Zone is dedicated","name":"accountid","type":"string"},{"description":"the ID of the dedicated resource","name":"id","type":"string"},{"description":"the domain ID to which the Zone is dedicated","name":"domainid","type":"string"},{"description":"the ID of the Zone","name":"zoneid","type":"string"}]},{"description":"load template into primary storage","isasync":false,"name":"prepareTemplate","params":[{"description":"zone ID of the template to be prepared in primary storage(s).","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"},{"description":"template ID of the template to be prepared in primary storage(s).","length":255,"name":"templateid","related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,prepareTemplate,createTemplate","required":true,"type":"uuid"},{"description":"storage pool ID of the primary storage pool to which the template should be prepared. If it is not provided the template is prepared on all the available primary storage pools.","length":255,"name":"storageid","related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"}],"related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","response":[{"description":"the template name","name":"name","type":"string"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"the size of the template","name":"size","type":"long"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"the template ID","name":"id","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"the tag of this template","name":"templatetag","type":"string"}]},{"description":"Assigns virtual machine or a list of virtual machines to a load balancer rule.","isasync":true,"name":"assignToLoadBalancerRule","params":[{"description":"the list of IDs of the virtual machine that are being assigned to the load balancer rule(i.e. virtualMachineIds=1,2,3)","length":255,"name":"virtualmachineids","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":false,"type":"list"},{"description":"the ID of the load balancer rule","length":255,"name":"id","related":"updatePortForwardingRule,listPortForwardingRules","required":true,"type":"uuid"},{"description":"VM ID and IP map, vmidipmap[0].vmid=1 vmidipmap[0].ip=10.1.1.75","length":255,"name":"vmidipmap","required":false,"since":"4.4","type":"map"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Archive one or more alerts.","isasync":false,"name":"archiveAlerts","params":[{"description":"start date range to archive alerts (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"startdate","required":false,"type":"date"},{"description":"end date range to archive alerts (including) this date (use format \"yyyy-MM-dd\" or the new format \"yyyy-MM-ddThh:mm:ss\")","length":255,"name":"enddate","required":false,"type":"date"},{"description":"archive by alert type","length":255,"name":"type","required":false,"type":"string"},{"description":"the IDs of the alerts","length":255,"name":"ids","related":"listAlerts","required":false,"type":"list"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists all pending asynchronous jobs for the account.","isasync":false,"name":"listAsyncJobs","params":[{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the start date of the async job","length":255,"name":"startdate","required":false,"type":"tzdate"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"queryAsyncJobResult","response":[{"description":"the account that executed the async command","name":"accountid","type":"string"},{"description":"the user that executed the async command","name":"userid","type":"string"},{"description":"the current job status-should be 0 for PENDING","name":"jobstatus","type":"integer"},{"description":"the result code for the job","name":"jobresultcode","type":"integer"},{"description":"the result type","name":"jobresulttype","type":"string"},{"description":"the result reason","name":"jobresult","type":"responseobject"},{"description":"  the created date of the job","name":"created","type":"date"},{"description":"the progress information of the PENDING job","name":"jobprocstatus","type":"integer"},{"description":"the instance/entity object related to the job","name":"jobinstancetype","type":"string"},{"description":"the async command executed","name":"cmd","type":"string"},{"description":"the unique ID of the instance/entity object related to the job","name":"jobinstanceid","type":"string"}]},{"description":"Deletes a Cisco Vnmc controller","isasync":false,"name":"deleteCiscoVnmcResource","params":[{"description":"Cisco Vnmc resource ID","length":255,"name":"resourceid","related":"listCiscoVnmcResources","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Stops an Internal LB vm.","isasync":true,"name":"stopInternalLoadBalancerVM","params":[{"description":"the ID of the internal lb vm","length":255,"name":"id","related":"listInternalLoadBalancerVMs,stopInternalLoadBalancerVM,changeServiceForRouter,destroyRouter,listRouters","required":true,"type":"uuid"},{"description":"Force stop the VM. The caller knows the VM is stopped.","length":255,"name":"forced","required":false,"type":"boolean"}],"related":"listInternalLoadBalancerVMs,changeServiceForRouter,destroyRouter,listRouters","response":[{"description":"the name of the router","name":"name","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"}],"type":"set"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"}]},{"description":"Adds a Brocade VCS Switch","isasync":true,"name":"addBrocadeVcsDevice","params":[{"description":"Credentials to access the Brocade VCS Switch API","length":255,"name":"username","required":true,"type":"string"},{"description":"Credentials to access the Brocade VCS Switch API","length":255,"name":"password","required":true,"type":"string"},{"description":"Hostname of ip address of the Brocade VCS Switch.","length":255,"name":"hostname","required":true,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"}],"related":"listBrocadeVcsDevices","response":[{"description":"device name","name":"brocadedevicename","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"device id of the Brocade Vcs","name":"vcsdeviceid","type":"string"},{"description":"the physical Network to which this Brocade VCS belongs to","name":"physicalnetworkid","type":"string"},{"description":"the principal switch Ip address","name":"hostname","type":"string"}]},{"description":"Creates a domain","isasync":false,"name":"createDomain","params":[{"description":"Network domain for networks in the domain","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"creates domain with this name","length":255,"name":"name","required":true,"type":"string"},{"description":"assigns new domain a parent domain by domain ID of the parent.  If no parent domain is specied, the ROOT domain is assumed.","length":255,"name":"parentdomainid","related":"createDomain,listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"Domain UUID, required for adding domain from another Region","length":255,"name":"domainid","required":false,"type":"string"}],"related":"listDomains,listDomains,listDomainChildren","response":[{"description":"the total primary storage space (in GiB) available to be used for this domain","name":"primarystorageavailable","type":"string"},{"description":"the total number of projects the domain can own","name":"projectlimit","type":"string"},{"description":"the total primary storage space (in GiB) the domain can own","name":"primarystoragelimit","type":"string"},{"description":"the total number of public ip addresses available for this domain to acquire","name":"ipavailable","type":"string"},{"description":"the total number of snapshots stored by this domain","name":"snapshottotal","type":"long"},{"description":"the total number of public ip addresses allocated for this domain","name":"iptotal","type":"long"},{"description":"whether the domain has one or more sub-domains","name":"haschild","type":"boolean"},{"description":"the total number of virtual machines deployed by this domain","name":"vmtotal","type":"long"},{"description":"the total number of snapshots available for this domain","name":"snapshotavailable","type":"string"},{"description":"the total secondary storage space (in GiB) the domain can own","name":"secondarystoragelimit","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total volume available for this domain","name":"volumeavailable","type":"string"},{"description":"the domain ID of the parent domain","name":"parentdomainid","type":"string"},{"description":"the total number of public ip addresses this domain can acquire","name":"iplimit","type":"string"},{"description":"the total memory (in MB) the domain can own","name":"memorylimit","type":"string"},{"description":"the ID of the domain","name":"id","type":"string"},{"description":"the domain name of the parent domain","name":"parentdomainname","type":"string"},{"description":"the state of the domain","name":"state","type":"string"},{"description":"the total volume which can be used by this domain","name":"volumelimit","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this domain","name":"secondarystorageavailable","type":"string"},{"description":"the total number of cpu cores the domain can own","name":"cpulimit","type":"string"},{"description":"the total volume being used by this domain","name":"volumetotal","type":"long"},{"description":"the total number of cpu cores owned by domain","name":"cputotal","type":"long"},{"description":"the total number of networks the domain can own","name":"networklimit","type":"string"},{"description":"the path of the domain","name":"path","type":"string"},{"description":"the total number of templates which can be created by this domain","name":"templatelimit","type":"string"},{"description":"the total memory (in MB) available to be created for this domain","name":"memoryavailable","type":"string"},{"description":"the total number of vpcs owned by domain","name":"vpctotal","type":"long"},{"description":"the total number of templates available to be created by this domain","name":"templateavailable","type":"string"},{"description":"the total number of virtual machines available for this domain to acquire","name":"vmavailable","type":"string"},{"description":"the total number of networks owned by domain","name":"networktotal","type":"long"},{"description":"the total memory (in MB) owned by domain","name":"memorytotal","type":"long"},{"description":"the total number of vpcs available to be created for this domain","name":"vpcavailable","type":"string"},{"description":"the total number of templates which have been created by this domain","name":"templatetotal","type":"long"},{"description":"the total number of projects available for administration by this domain","name":"projectavailable","type":"string"},{"description":"the total number of virtual machines that can be deployed by this domain","name":"vmlimit","type":"string"},{"description":"the total number of projects being administrated by this domain","name":"projecttotal","type":"long"},{"description":"the total number of cpu cores available to be created for this domain","name":"cpuavailable","type":"string"},{"description":"the name of the domain","name":"name","type":"string"},{"description":"the total number of vpcs the domain can own","name":"vpclimit","type":"string"},{"description":"the total secondary storage space (in GiB) owned by domain","name":"secondarystoragetotal","type":"float"},{"description":"the total number of snapshots which can be stored by this domain","name":"snapshotlimit","type":"string"},{"description":"the level of the domain","name":"level","type":"integer"},{"description":"the total number of networks available to be created for this domain","name":"networkavailable","type":"string"},{"description":"the total primary storage space (in GiB) owned by domain","name":"primarystoragetotal","type":"long"}]},{"description":"Deleting resource tag(s)","isasync":true,"name":"deleteTags","params":[{"description":"Delete tags matching key/value pairs","length":255,"name":"tags","required":false,"type":"map"},{"description":"Delete tags for resource id(s)","length":255,"name":"resourceids","required":true,"type":"list"},{"description":"Delete tag by resource type","length":255,"name":"resourcetype","required":true,"type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.0.0"},{"description":"List external firewall appliances.","isasync":false,"name":"listExternalFirewalls","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"zone Id","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"","response":[{"description":"the public security zone of the external firewall","name":"publiczone","type":"string"},{"description":"the private security zone of the external firewall","name":"privatezone","type":"string"},{"description":"the timeout (in seconds) for requests to the external firewall","name":"timeout","type":"string"},{"description":"the ID of the external firewall","name":"id","type":"string"},{"description":"the username that's used to log in to the external firewall","name":"username","type":"string"},{"description":"the zone ID of the external firewall","name":"zoneid","type":"string"},{"description":"the management IP address of the external firewall","name":"ipaddress","type":"string"},{"description":"the public interface of the external firewall","name":"publicinterface","type":"string"},{"description":"the private interface of the external firewall","name":"privateinterface","type":"string"},{"description":"the usage interface of the external firewall","name":"usageinterface","type":"string"},{"description":"the number of times to retry requests to the external firewall","name":"numretries","type":"string"}]},{"description":"Restarts the network; includes 1) restarting network elements - virtual routers, DHCP servers 2) reapplying all public IPs 3) reapplying loadBalancing/portForwarding rules","isasync":true,"name":"restartNetwork","params":[{"description":"If cleanup old network elements","length":255,"name":"cleanup","required":false,"type":"boolean"},{"description":"Turn the network into a network with redundant routers.","length":255,"name":"makeredundant","required":false,"since":"4.11.1","type":"boolean"},{"description":"The ID of the network to restart.","length":255,"name":"id","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":true,"type":"uuid"}],"related":"associateIpAddress,associateIpAddress,listPublicIpAddresses,updateIpAddress","response":[{"description":"the VLAN associated with the IP address","name":"vlanname","type":"string"},{"description":"public IP address id","name":"id","type":"string"},{"description":"is public ip for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the name of the zone the public IP address belongs to","name":"zonename","type":"string"},{"description":"the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only","name":"vlanid","type":"string"},{"description":"true if this ip is for static nat, false otherwise","name":"isstaticnat","type":"boolean"},{"description":"virtual machine (dnat) ip address (not null only for static nat Ip)","name":"vmipaddress","type":"string"},{"description":"the list of resource tags associated with ip address","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"public IP address","name":"ipaddress","type":"string"},{"description":"the domain the public IP address is associated with","name":"domain","type":"string"},{"description":"true if this ip is system ip (was allocated as a part of deployVm or createLbRule)","name":"issystem","type":"boolean"},{"description":"purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value","name":"purpose","type":"string"},{"description":"virtual machine name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinename","type":"string"},{"description":"the ID of the zone the public IP address belongs to","name":"zoneid","type":"string"},{"description":"date the public IP address was acquired","name":"allocated","type":"date"},{"description":"the ID of the Network where ip belongs to","name":"networkid","type":"string"},{"description":"the account the public IP address is associated with","name":"account","type":"string"},{"description":"the ID of the Network associated with the IP address","name":"associatednetworkid","type":"string"},{"description":"the domain ID the public IP address is associated with","name":"domainid","type":"string"},{"description":"the virtual network for the IP address","name":"forvirtualnetwork","type":"boolean"},{"description":"State of the ip address. Can be: Allocatin, Allocated and Releasing","name":"state","type":"string"},{"description":"VPC the ip belongs to","name":"vpcid","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"is public IP portable across the zones","name":"isportable","type":"boolean"},{"description":"virtual machine id the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachineid","type":"string"},{"description":"virtual machine display name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinedisplayname","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"true if the IP address is a source nat address, false otherwise","name":"issourcenat","type":"boolean"},{"description":"the name of the Network associated with the IP address","name":"associatednetworkname","type":"string"},{"description":"the project name of the address","name":"project","type":"string"}]},{"description":"Logs a user into the CloudStack. A successful login attempt will generate a JSESSIONID cookie value that can be passed in subsequent Query command calls until the \"logout\" command has been issued or the session has expired.","isasync":false,"name":"login","params":[{"description":"Username","length":255,"name":"username","required":true,"type":"string"},{"description":"Hashed password (Default is MD5). If you wish to use any other hashing algorithm, you would need to write a custom authentication adapter See Docs section.","length":255,"name":"password","required":true,"type":"string"},{"description":"Path of the domain that the user belongs to. Example: domain=/com/cloud/internal. If no domain is passed in, the ROOT (/) domain is assumed.","length":255,"name":"domain","required":false,"type":"string"},{"description":"The id of the domain that the user belongs to. If both domain and domainId are passed in, \"domainId\" parameter takes precendence","length":255,"name":"domainId","required":false,"type":"long"}],"related":"","response":[{"description":"the account type (admin, domain-admin, read-only-admin, user)","name":"type","type":"string"},{"description":"Username","name":"username","type":"string"},{"description":"the time period before the session has expired","name":"timeout","type":"integer"},{"description":"User ID","name":"userid","type":"string"},{"description":"Is user registered","name":"registered","type":"string"},{"description":"first name of the user","name":"firstname","type":"string"},{"description":"user time zone","name":"timezone","type":"string"},{"description":"user time zoneoffset","name":"timezoneoffset","type":"string"},{"description":"the account name the user belongs to","name":"account","type":"string"},{"description":"last name of the user","name":"lastname","type":"string"},{"description":"Domain ID that the user belongs to","name":"domainid","type":"string"},{"description":"Session key that can be passed in subsequent Query command calls","name":"sessionkey","type":"string"}]},{"description":"Adds backup image store.","isasync":false,"name":"addImageStore","params":[{"description":"the Zone ID for the image store","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the URL for the image store","length":2048,"name":"url","required":false,"type":"string"},{"description":"the image store provider name","length":255,"name":"provider","required":true,"type":"string"},{"description":"the details for the image store. Example: details[0].key=accesskey\u0026details[0].value=s389ddssaa\u0026details[1].key=secretkey\u0026details[1].value=8dshfsss","length":255,"name":"details","required":false,"type":"map"},{"description":"the name for the image store","length":255,"name":"name","required":false,"type":"string"}],"related":"listImageStores,updateCloudToUseObjectStore,listSwifts,addSecondaryStorage,addImageStoreS3","response":[{"description":"the protocol of the image store","name":"protocol","type":"string"},{"description":"the provider name of the image store","name":"providername","type":"string"},{"description":"the ID of the image store","name":"id","type":"string"},{"description":"the Zone ID of the image store","name":"zoneid","type":"string"},{"description":"the Zone name of the image store","name":"zonename","type":"string"},{"description":"the name of the image store","name":"name","type":"string"},{"description":"the scope of the image store","name":"scope","type":"scopetype"},{"description":"the url of the image store","name":"url","type":"string"}],"since":"4.2.0"},{"description":"Lists all hypervisor capabilities.","isasync":false,"name":"listHypervisorCapabilities","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"ID of the hypervisor capability","length":255,"name":"id","related":"listHypervisorCapabilities","required":false,"type":"uuid"},{"description":"the hypervisor for which to restrict the search","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"","response":[{"description":"the maximum number of guest vms recommended for this hypervisor","name":"maxguestslimit","type":"long"},{"description":"true if storage motion is supported","name":"storagemotionenabled","type":"boolean"},{"description":"the maximum number of Data Volumes that can be attached for this hypervisor","name":"maxdatavolumeslimit","type":"integer"},{"description":"the ID of the hypervisor capabilities row","name":"id","type":"string"},{"description":"the maximum number of Hosts per cluster for this hypervisor","name":"maxhostspercluster","type":"integer"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"true if security group is supported","name":"securitygroupenabled","type":"boolean"},{"description":"the hypervisor type","name":"hypervisor","type":"hypervisortype"}],"since":"3.0.0"},{"description":"Get SolidFire Account ID","isasync":false,"name":"getSolidFireAccountId","params":[{"description":"CloudStack Account UUID","length":255,"name":"accountid","required":true,"type":"string"},{"description":"Storage Pool UUID","length":255,"name":"storageid","required":true,"type":"string"}],"related":"","response":[{"description":"SolidFire Account ID","name":"solidFireAccountId","type":"long"}]},{"description":"Lists role permissions","isasync":false,"name":"listRolePermissions","params":[{"description":"ID of the role","length":255,"name":"roleid","related":"createRole,listRoles,updateRole","required":false,"type":"uuid"}],"related":"","response":[{"description":"the api name or wildcard rule","name":"rule","type":"string"},{"description":"the permission type of the api name or wildcard rule, allow/deny","name":"permission","type":"string"},{"description":"the ID of the role to which the role permission belongs","name":"roleid","type":"string"},{"description":"the ID of the role permission","name":"id","type":"string"},{"description":"the name of the role to which the role permission belongs","name":"rolename","type":"string"},{"description":"the description of the role permission","name":"description","type":"string"}],"since":"4.9.0"},{"description":"Lists all network services provided by CloudStack or for the given Provider.","isasync":false,"name":"listSupportedNetworkServices","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"network service provider name","length":255,"name":"provider","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"network service name to list providers and capabilities of","length":255,"name":"service","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"","response":[{"description":"the service provider name","name":"provider","response":[{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the provider name","name":"name","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"}],"since":"3.0.0"},{"description":"Deletes a particular ingress rule from this security group","isasync":true,"name":"revokeSecurityGroupIngress","params":[{"description":"The ID of the ingress rule","length":255,"name":"id","related":"authorizeSecurityGroupIngress","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Lists dedicated guest vlan ranges","isasync":false,"name":"listDedicatedGuestVlanRanges","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"zone of the guest VLAN range","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the dedicated guest vlan range","length":255,"name":"guestvlanrange","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"physical network id of the guest VLAN range","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"project who will own the guest VLAN range","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the account with which the guest VLAN range is associated. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list dedicated guest vlan ranges by id","length":255,"name":"id","related":"listDedicatedGuestVlanRanges","required":false,"type":"uuid"},{"description":"the domain ID with which the guest VLAN range is associated.  If used with the account parameter, returns all guest VLAN ranges for that account in the specified domain.","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"}],"related":"","response":[{"description":"the domain ID of the guest VLAN range","name":"domainid","type":"string"},{"description":"the account of the guest VLAN range","name":"account","type":"string"},{"description":"the domain name of the guest VLAN range","name":"domain","type":"string"},{"description":"the guest VLAN range","name":"guestvlanrange","type":"string"},{"description":"the physical network of the guest vlan range","name":"physicalnetworkid","type":"long"},{"description":"the ID of the guest VLAN range","name":"id","type":"string"},{"description":"the project id of the guest vlan range","name":"projectid","type":"string"},{"description":"the zone of the guest vlan range","name":"zoneid","type":"long"},{"description":"the project name of the guest vlan range","name":"project","type":"string"}]},{"description":"Lists all network ACL items","isasync":false,"name":"listNetworkACLs","params":[{"description":"list network ACL items by action","length":255,"name":"action","required":false,"type":"string"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"list network ACL items by protocol","length":255,"name":"protocol","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"Lists network ACL Item with the specified ID","length":255,"name":"id","related":"listNetworkACLs,createNetworkACL,updateNetworkACLItem","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list network ACL items by traffic type - ingress or egress","length":255,"name":"traffictype","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"list network ACL items by network ID","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork,listNiciraNvpDeviceNetworks","required":false,"type":"uuid"},{"description":"list network ACL items by ACL ID","length":255,"name":"aclid","related":"createNetworkACLList,listNetworkACLLists","required":false,"type":"uuid"}],"related":"createNetworkACL,updateNetworkACLItem","response":[{"description":"the ID of the ACL Item","name":"id","type":"string"},{"description":"the ID of the ACL this item belongs to","name":"aclid","type":"string"},{"description":"the protocol of the ACL","name":"protocol","type":"string"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"the starting port of ACL's port range","name":"startport","type":"string"},{"description":"the traffic type for the ACL","name":"traffictype","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the list of resource tags associated with the network ACLs","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"list"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"Number of the ACL Item","name":"number","type":"integer"},{"description":"Action of ACL Item. Allow/Deny","name":"action","type":"string"},{"description":"the ending port of ACL's port range","name":"endport","type":"string"}]},{"description":"Adds a network serviceProvider to a physical network","isasync":true,"name":"addNetworkServiceProvider","params":[{"description":"the Physical Network ID to add the provider to","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"},{"description":"the name for the physical network service provider","length":255,"name":"name","required":true,"type":"string"},{"description":"the destination Physical Network ID to bridge to","length":255,"name":"destinationphysicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"the list of services to be enabled for this physical network service provider","length":255,"name":"servicelist","required":false,"type":"list"}],"related":"listTrafficTypes,listNetworkServiceProviders","response":[{"description":"the provider name","name":"name","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"}],"since":"3.0.0"},{"description":"Delete site to site vpn gateway","isasync":true,"name":"deleteVpnGateway","params":[{"description":"id of customer gateway","length":255,"name":"id","related":"updateVpnGateway,createVpnGateway,listVpnGateways","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Copies a template from one zone to another.","isasync":true,"name":"copyTemplate","params":[{"description":"Template ID.","length":255,"name":"id","related":"copyTemplate,registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","required":true,"type":"uuid"},{"description":"A list of IDs of the zones that the template needs to be copied to.Specify this list if the template needs to copied to multiple zones in one go. Do not specify destzoneid and destzoneids together, however one of them is required.","length":255,"name":"destzoneids","related":"listZones,listZones,createZone,updateZone","required":false,"type":"list"},{"description":"ID of the zone the template is being copied to.","length":255,"name":"destzoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"ID of the zone the template is currently hosted on. If not specified and template is cross-zone, then we will sync this template to region wide image store.","length":255,"name":"sourcezoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"}],"related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","response":[{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the tag of this template","name":"templatetag","type":"string"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"the size of the template","name":"size","type":"long"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the template ID","name":"id","type":"string"},{"description":"the template name","name":"name","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"}]},{"description":"Creates a service offering.","isasync":false,"name":"createServiceOffering","params":[{"description":"true if the virtual machine needs to be volatile so that on every reboot of VM, original root disk is dettached then destroyed and a fresh root disk is created and attached to VM","length":255,"name":"isvolatile","required":false,"type":"boolean"},{"description":"the name of the service offering","length":255,"name":"name","required":true,"type":"string"},{"description":"io requests write rate of the disk offering","length":255,"name":"iopswriterate","required":false,"type":"long"},{"description":"max iops of the compute offering","length":255,"name":"maxiops","required":false,"since":"4.4","type":"long"},{"description":"the CPU speed of the service offering in MHz.","length":255,"name":"cpuspeed","required":false,"type":"integer"},{"description":"io requests read rate of the disk offering","length":255,"name":"iopsreadrate","required":false,"type":"long"},{"description":"the total memory of the service offering in MB","length":255,"name":"memory","required":false,"type":"integer"},{"description":"data transfer rate in megabits per second allowed. Supported only for non-System offering and system offerings having \"domainrouter\" systemvmtype","length":255,"name":"networkrate","required":false,"type":"integer"},{"description":"details for planner, used to store specific parameters","length":255,"name":"serviceofferingdetails","required":false,"type":"map"},{"description":"bytes write rate of the disk offering","length":255,"name":"byteswriterate","required":false,"type":"long"},{"description":"is this a system vm offering","length":255,"name":"issystem","required":false,"type":"boolean"},{"description":"provisioning type used to create volumes. Valid values are thin, sparse, fat.","length":255,"name":"provisioningtype","required":false,"type":"string"},{"description":"the tags for this service offering.","length":255,"name":"tags","required":false,"type":"string"},{"description":"the system VM type. Possible types are \"domainrouter\", \"consoleproxy\" and \"secondarystoragevm\".","length":255,"name":"systemvmtype","required":false,"type":"string"},{"description":"The deployment planner heuristics used to deploy a VM of this offering. If null, value of global config vm.deployment.planner is used","length":255,"name":"deploymentplanner","required":false,"type":"string"},{"description":"the ID of the containing domain, null for public offerings","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"restrict the CPU usage to committed service offering","length":255,"name":"limitcpuuse","required":false,"type":"boolean"},{"description":"min iops of the compute offering","length":255,"name":"miniops","required":false,"since":"4.4","type":"long"},{"description":"the HA for the service offering","length":255,"name":"offerha","required":false,"type":"boolean"},{"description":"whether compute offering iops is custom or not","length":255,"name":"customizediops","required":false,"since":"4.4","type":"boolean"},{"description":"bytes read rate of the disk offering","length":255,"name":"bytesreadrate","required":false,"type":"long"},{"description":"the CPU number of the service offering","length":255,"name":"cpunumber","required":false,"type":"integer"},{"description":"Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)","length":255,"name":"hypervisorsnapshotreserve","required":false,"since":"4.4","type":"integer"},{"description":"the storage type of the service offering. Values are local and shared.","length":255,"name":"storagetype","required":false,"type":"string"},{"description":"the host tag for this service offering.","length":255,"name":"hosttags","required":false,"type":"string"},{"description":"the display text of the service offering","length":255,"name":"displaytext","required":true,"type":"string"}],"related":"updateServiceOffering,listServiceOfferings","response":[{"description":"provisioning type used to create volumes. Valid values are thin, sparse, fat.","name":"provisioningtype","type":"string"},{"description":"true if disk offering uses custom iops, false otherwise","name":"iscustomizediops","type":"boolean"},{"description":"bytes write rate of the service offering","name":"diskBytesWriteRate","type":"long"},{"description":"the max iops of the disk offering","name":"maxiops","type":"long"},{"description":"the name of the service offering","name":"name","type":"string"},{"description":"is this a system vm offering","name":"issystem","type":"boolean"},{"description":"the min iops of the disk offering","name":"miniops","type":"long"},{"description":"the clock rate CPU speed in Mhz","name":"cpuspeed","type":"integer"},{"description":"Domain name for the offering","name":"domain","type":"string"},{"description":"the domain id of the service offering","name":"domainid","type":"string"},{"description":"io requests write rate of the service offering","name":"diskIopsWriteRate","type":"long"},{"description":"the tags for the service offering","name":"tags","type":"string"},{"description":"an alternate display text of the service offering.","name":"displaytext","type":"string"},{"description":"is true if the offering is customized","name":"iscustomized","type":"boolean"},{"description":"io requests read rate of the service offering","name":"diskIopsReadRate","type":"long"},{"description":"the number of CPU","name":"cpunumber","type":"integer"},{"description":"restrict the CPU usage to committed service offering","name":"limitcpuuse","type":"boolean"},{"description":"is this a  default system vm offering","name":"defaultuse","type":"boolean"},{"description":"additional key/value details tied with this service offering","name":"serviceofferingdetails","type":"map"},{"description":"the storage type for this service offering","name":"storagetype","type":"string"},{"description":"bytes read rate of the service offering","name":"diskBytesReadRate","type":"long"},{"description":"Hypervisor snapshot reserve space as a percent of a volume (for managed storage using Xen or VMware)","name":"hypervisorsnapshotreserve","type":"integer"},{"description":"the memory in MB","name":"memory","type":"integer"},{"description":"the ha support in the service offering","name":"offerha","type":"boolean"},{"description":"deployment strategy used to deploy VM.","name":"deploymentplanner","type":"string"},{"description":"the date this service offering was created","name":"created","type":"date"},{"description":"the host tag for the service offering","name":"hosttags","type":"string"},{"description":"data transfer rate in megabits per second allowed.","name":"networkrate","type":"integer"},{"description":"is this a the systemvm type for system vm offering","name":"systemvmtype","type":"string"},{"description":"the id of the service offering","name":"id","type":"string"},{"description":"true if the vm needs to be volatile, i.e., on every reboot of vm from API root disk is discarded and creates a new root disk","name":"isvolatile","type":"boolean"}]},{"description":"lists network that are using a nicira nvp device","isasync":false,"name":"listNiciraNvpDeviceNetworks","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"nicira nvp device ID","length":255,"name":"nvpdeviceid","related":"addNiciraNvpDevice,listNiciraNvpDevices","required":true,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","response":[{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"the name of the network","name":"name","type":"string"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"the list of services","name":"service","response":[{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability name","name":"name","type":"string"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"the provider name","name":"name","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"}],"type":"list"}],"type":"list"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"the id of the network","name":"id","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"the type of the network","name":"type","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"state of the network","name":"state","type":"string"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"}]},{"description":"Change ownership of a VM from one account to another. This API is available for Basic zones with security groups and Advanced zones with guest networks. A root administrator can reassign a VM from any account to any other account in any domain. A domain administrator can reassign a VM to any account in the same domain.","isasync":false,"name":"assignVirtualMachine","params":[{"description":"domain id of the new VM owner.","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"account name of the new VM owner.","length":255,"name":"account","required":false,"type":"string"},{"description":"an optional project for the new VM owner.","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list of security group ids to be applied on the virtual machine. In case no security groups are provided the VM is part of the default security group.","length":255,"name":"securitygroupids","related":"createSecurityGroup","required":false,"type":"list"},{"description":"id of the VM to be moved","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,assignVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"list of new network ids in which the moved VM will participate. In case no network ids are provided the VM will be part of the default network for that zone. In case there is no network yet created for the new account the default network will be created.","length":255,"name":"networkids","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"list"}],"related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the description of the security group","name":"description","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"}],"type":"set"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"}],"type":"set"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"}],"type":"set"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"}],"type":"set"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"}],"type":"set"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"}],"type":"set"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"}],"type":"set"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"}],"since":"3.0.0"},{"description":" delete a BigSwitch BCF Controller device","isasync":true,"name":"deleteBigSwitchBcfDevice","params":[{"description":"BigSwitch device ID","length":255,"name":"bcfdeviceid","related":"listBigSwitchBcfDevices","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"4.6.0"},{"description":"configures a netscaler load balancer device","isasync":true,"name":"configureNetscalerLoadBalancer","params":[{"description":"Used when NetScaler device is provider of EIP service. This parameter represents the list of pod's, for which there exists a policy based route on datacenter L3 router to route pod's subnet IP to a NetScaler device.","length":255,"name":"podids","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"list"},{"description":"true if netscaler load balancer is intended to be used in in-line with firewall, false if netscaler load balancer will side-by-side with firewall","length":255,"name":"inline","required":false,"type":"boolean"},{"description":"true if this netscaler device to dedicated for a account, false if the netscaler device will be shared by multiple accounts","length":255,"name":"lbdevicededicated","required":false,"type":"boolean"},{"description":"Netscaler load balancer device ID","length":255,"name":"lbdeviceid","related":"deployNetscalerVpx,configureNetscalerLoadBalancer,addNetscalerLoadBalancer,listNetscalerLoadBalancers,registerNetscalerControlCenter","required":true,"type":"uuid"},{"description":"capacity of the device, Capacity will be interpreted as number of networks device can handle","length":255,"name":"lbdevicecapacity","required":false,"type":"long"}],"related":"deployNetscalerVpx,addNetscalerLoadBalancer,listNetscalerLoadBalancers,registerNetscalerControlCenter","response":[{"description":"name of the provider","name":"provider","type":"string"},{"description":"private IP of the NetScaler representing GSLB site","name":"gslbproviderprivateip","type":"string"},{"description":"true if NetScaler device is provisioned exclusively to be a GSLB service provider","name":"isexclusivegslbprovider","type":"boolean"},{"description":"the private interface of the load balancer","name":"privateinterface","type":"string"},{"description":"true if device is dedicated for an account","name":"lbdevicededicated","type":"boolean"},{"description":"the management IP address of the external load balancer","name":"ipaddress","type":"string"},{"description":"Used when NetScaler device is provider of EIP service. This parameter represents the list of pod's, for which there exists a policy based route on datacenter L3 router to route pod's subnet IP to a NetScaler device.","name":"podids","type":"list"},{"description":"device id of the netscaler load balancer","name":"lbdeviceid","type":"string"},{"description":"public IP of the NetScaler representing GSLB site","name":"gslbproviderpublicip","type":"string"},{"description":"device name","name":"lbdevicename","type":"string"},{"description":"the public interface of the load balancer","name":"publicinterface","type":"string"},{"description":"device state","name":"lbdevicestate","type":"string"},{"description":"device capacity","name":"lbdevicecapacity","type":"long"},{"description":"the physical network to which this netscaler device belongs to","name":"physicalnetworkid","type":"string"},{"description":"true if NetScaler device is provisioned to be a GSLB service provider","name":"gslbprovider","type":"boolean"}]},{"description":"Lists all available ovs elements.","isasync":false,"name":"listOvsElements","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list ovs elements by id","length":255,"name":"id","related":"configureOvsElement,listOvsElements","required":false,"type":"uuid"},{"description":"list network offerings by enabled state","length":255,"name":"enabled","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list ovs elements by network service provider id","length":255,"name":"nspid","related":"listTrafficTypes,listNetworkServiceProviders","required":false,"type":"uuid"}],"related":"configureOvsElement","response":[{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"Enabled/Disabled the service provider","name":"enabled","type":"boolean"},{"description":"the account associated with the provider","name":"account","type":"string"},{"description":"the domain associated with the provider","name":"domain","type":"string"},{"description":"the domain ID associated with the provider","name":"domainid","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the id of the ovs","name":"id","type":"string"},{"description":"the physical network service provider id of the provider","name":"nspid","type":"string"}]},{"description":"associate a profile to a blade","isasync":true,"name":"associateUcsProfileToBlade","params":[{"description":"profile dn","length":255,"name":"profiledn","required":true,"type":"string"},{"description":"blade id","length":255,"name":"bladeid","related":"associateUcsProfileToBlade","required":true,"type":"uuid"},{"description":"ucs manager id","length":255,"name":"ucsmanagerid","related":"listUcsManagers,addUcsManager","required":true,"type":"uuid"}],"related":"","response":[{"description":"ucs blade dn","name":"bladedn","type":"string"},{"description":"associated ucs profile dn","name":"profiledn","type":"string"},{"description":"ucs manager id","name":"ucsmanagerid","type":"string"},{"description":"cloudstack host id this blade associates to","name":"hostid","type":"string"},{"description":"ucs blade id","name":"id","type":"string"}]},{"description":"list control center","isasync":false,"name":"listNetscalerControlCenter","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"","response":[{"description":"uuid","name":"uuid","type":"string"},{"description":"id","name":"id","type":"string"},{"description":"ncc_ip","name":"ipaddress","type":"string"},{"description":"num_retries","name":"numretries","type":"string"},{"description":"username","name":"username","type":"string"}]},{"description":"Resizes a volume","isasync":true,"name":"resizeVolume","params":[{"description":"Verify OK to Shrink","length":255,"name":"shrinkok","required":false,"type":"boolean"},{"description":"New maximum number of IOPS","length":255,"name":"maxiops","required":false,"type":"long"},{"description":"New minimum number of IOPS","length":255,"name":"miniops","required":false,"type":"long"},{"description":"new disk offering id","length":255,"name":"diskofferingid","related":"listDiskOfferings,createDiskOffering","required":false,"type":"uuid"},{"description":"New volume size in GB","length":255,"name":"size","required":false,"type":"long"},{"description":"the ID of the disk volume","length":255,"name":"id","related":"createVolume,attachVolume,listVolumes,listVolumes,resizeVolume,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":true,"type":"uuid"}],"related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","response":[{"description":"the display text of the disk offering","name":"diskofferingdisplaytext","type":"string"},{"description":"name of the disk offering","name":"diskofferingname","type":"string"},{"description":"ID of the disk volume","name":"id","type":"string"},{"description":"name of the disk volume","name":"name","type":"string"},{"description":"name of the primary storage hosting the disk volume","name":"storage","type":"string"},{"description":"the project id of the vpn","name":"projectid","type":"string"},{"description":"ID of the availability zone","name":"zoneid","type":"string"},{"description":"io requests write rate of the disk volume","name":"diskIopsWriteRate","type":"long"},{"description":"the display text of the service offering for root disk","name":"serviceofferingdisplaytext","type":"string"},{"description":"the date the disk volume was created","name":"created","type":"date"},{"description":"the ID of the domain associated with the disk volume","name":"domainid","type":"string"},{"description":"bytes write rate of the disk volume","name":"diskBytesWriteRate","type":"long"},{"description":"name of the service offering for root disk","name":"serviceofferingname","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"pod id of the volume","name":"podid","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"state of the virtual machine","name":"vmstate","type":"string"},{"description":"ID of the snapshot from which this volume was created","name":"snapshotid","type":"string"},{"description":"an optional field whether to the display the volume to the end user or not.","name":"displayvolume","type":"boolean"},{"description":"the status of the volume","name":"status","type":"string"},{"description":"the bytes alloaated","name":"physicalsize","type":"long"},{"description":"id of the virtual machine","name":"virtualmachineid","type":"string"},{"description":"name of the availability zone","name":"zonename","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the disk utilization","name":"utilization","type":"string"},{"description":"the account associated with the disk volume","name":"account","type":"string"},{"description":"shared or local storage","name":"storagetype","type":"string"},{"description":"io requests read rate of the disk volume","name":"diskIopsReadRate","type":"long"},{"description":"cluster id of the volume","name":"clusterid","type":"string"},{"description":"max iops of the disk volume","name":"maxiops","type":"long"},{"description":"cluster name where the volume is allocated","name":"clustername","type":"string"},{"description":"size of the disk volume","name":"size","type":"long"},{"description":"min iops of the disk volume","name":"miniops","type":"long"},{"description":"id of the primary storage hosting the disk volume; returned to admin user only","name":"storageid","type":"string"},{"description":"Hypervisor the volume belongs to","name":"hypervisor","type":"string"},{"description":"name of the virtual machine","name":"vmname","type":"string"},{"description":"the project name of the vpn","name":"project","type":"string"},{"description":"the date the volume was attached to a VM instance","name":"attached","type":"date"},{"description":"the boolean state of whether the volume is destroyed or not","name":"destroyed","type":"boolean"},{"description":"type of the disk volume (ROOT or DATADISK)","name":"type","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"display name of the virtual machine","name":"vmdisplayname","type":"string"},{"description":"the bytes actually consumed on disk","name":"virtualsize","type":"long"},{"description":"pod name of the volume","name":"podname","type":"string"},{"description":"the chain info of the volume","name":"chaininfo","type":"string"},{"description":"ID of the service offering for root disk","name":"serviceofferingid","type":"string"},{"description":"true if the volume is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"the domain associated with the disk volume","name":"domain","type":"string"},{"description":"ID of the disk offering","name":"diskofferingid","type":"string"},{"description":"provisioning type used to create volumes.","name":"provisioningtype","type":"string"},{"description":"the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.","name":"deviceid","type":"long"},{"description":"the state of the disk volume","name":"state","type":"string"},{"description":"bytes read rate of the disk volume","name":"diskBytesReadRate","type":"long"},{"description":"need quiesce vm or not when taking snapshot","name":"quiescevm","type":"boolean"},{"description":"the path of the volume","name":"path","type":"string"}]},{"description":"Deletes affinity group","isasync":true,"name":"deleteAffinityGroup","params":[{"description":"The name of the affinity group. Mutually exclusive with ID parameter","length":255,"name":"name","required":false,"type":"string"},{"description":"The ID of the affinity group. Mutually exclusive with name parameter","length":255,"name":"id","related":"","required":false,"type":"uuid"},{"description":"the domain ID of account owning the affinity group","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the account of the affinity group. Must be specified with domain ID","length":255,"name":"account","required":false,"type":"string"},{"description":"the project of the affinity group","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Deletes a Network Service Provider.","isasync":true,"name":"deleteNetworkServiceProvider","params":[{"description":"the ID of the network service provider","length":255,"name":"id","related":"listTrafficTypes,listNetworkServiceProviders","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"3.0.0"},{"description":"Deletes a network offering.","isasync":false,"name":"deleteNetworkOffering","params":[{"description":"the ID of the network offering","length":255,"name":"id","related":"listNetworkOfferings","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}],"since":"3.0.0"},{"description":"Update a Storage network IP range, only allowed when no IPs in this range have been allocated.","isasync":true,"name":"updateStorageNetworkIpRange","params":[{"description":"the netmask for storage network","length":255,"name":"netmask","required":false,"type":"string"},{"description":"the beginning IP address","length":255,"name":"startip","required":false,"type":"string"},{"description":"UUID of storage network ip range","length":255,"name":"id","related":"listStorageNetworkIpRange,updateStorageNetworkIpRange,createStorageNetworkIpRange","required":true,"type":"uuid"},{"description":"Optional. the vlan the ip range sits on","length":255,"name":"vlan","required":false,"type":"integer"},{"description":"the ending IP address","length":255,"name":"endip","required":false,"type":"string"}],"related":"listStorageNetworkIpRange,createStorageNetworkIpRange","response":[{"description":"the gateway of the storage network IP range","name":"gateway","type":"string"},{"description":"the Pod uuid for the storage network IP range","name":"podid","type":"string"},{"description":"the network uuid of storage network IP range","name":"networkid","type":"string"},{"description":"the Zone uuid of the storage network IP range","name":"zoneid","type":"string"},{"description":"the uuid of storage network IP range.","name":"id","type":"string"},{"description":"the end ip of the storage network IP range","name":"endip","type":"string"},{"description":"the start ip of the storage network IP range","name":"startip","type":"string"},{"description":"the ID or VID of the VLAN.","name":"vlan","type":"integer"},{"description":"the netmask of the storage network IP range","name":"netmask","type":"string"}],"since":"3.0.0"},{"description":"Dedicates a Pod.","isasync":true,"name":"dedicatePod","params":[{"description":"the ID of the Pod","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":true,"type":"uuid"},{"description":"the name of the account which needs dedication. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"the ID of the containing domain","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":true,"type":"uuid"}],"related":"listDedicatedPods","response":[{"description":"the ID of the Pod","name":"podid","type":"string"},{"description":"the domain ID to which the Pod is dedicated","name":"domainid","type":"string"},{"description":"the Account Id to which the Pod is dedicated","name":"accountid","type":"string"},{"description":"the Name of the Pod","name":"podname","type":"string"},{"description":"the ID of the dedicated resource","name":"id","type":"string"},{"description":"the Dedication Affinity Group ID of the pod","name":"affinitygroupid","type":"string"}]},{"description":"List network devices","isasync":false,"name":"listNetworkDevice","params":[{"description":"parameters for network device","length":255,"name":"networkdeviceparameterlist","required":false,"type":"map"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"Network device type, now supports ExternalDhcp, PxeServer, NetscalerMPXLoadBalancer, NetscalerVPXLoadBalancer, NetscalerSDXLoadBalancer, F5BigIpLoadBalancer, JuniperSRXFirewall, PaloAltoFirewall","length":255,"name":"networkdevicetype","required":false,"type":"string"}],"related":"addNetworkDevice","response":[{"description":"the ID of the network device","name":"id","type":"string"}]},{"description":"Removes an OpenDyalight controler","isasync":true,"name":"deleteOpenDaylightController","params":[{"description":"OpenDaylight Controller ID","length":255,"name":"id","related":"addOpenDaylightController,deleteOpenDaylightController","required":true,"type":"uuid"}],"related":"addOpenDaylightController","response":[{"description":"the url of the controller api","name":"url","type":"string"},{"description":"the username to authenticate to the controller","name":"username","type":"string"},{"description":"device id of the controller","name":"id","type":"string"},{"description":"the physical network to which this controller belongs to","name":"physicalnetworkid","type":"string"},{"description":"the name assigned to the controller","name":"name","type":"string"}]},{"description":"Updates attributes of a template.","isasync":false,"name":"updateTemplate","params":[{"description":"the ID of the image file","length":255,"name":"id","related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,updateTemplate,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","required":true,"type":"uuid"},{"description":"the ID of the OS type that best represents the OS of this image.","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"},{"description":"the display text of the image","length":4096,"name":"displaytext","required":false,"type":"string"},{"description":"sort key of the template, integer","length":255,"name":"sortkey","required":false,"type":"integer"},{"description":"true if template/ISO contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","length":255,"name":"isdynamicallyscalable","required":false,"type":"boolean"},{"description":"true if the template requres HVM, false otherwise; available only for updateTemplate API","length":255,"name":"requireshvm","required":false,"type":"boolean"},{"description":"true if the template type is routing i.e., if template is used to deploy router","length":255,"name":"isrouting","required":false,"type":"boolean"},{"description":"true if the image supports the password reset feature; default is false","length":255,"name":"passwordenabled","required":false,"type":"boolean"},{"description":"the format for the image","length":255,"name":"format","required":false,"type":"string"},{"description":"optional boolean field, which indicates if details should be cleaned up or not (if set to true, details removed for this resource, details field ignored; if false or not set, no action)","length":255,"name":"cleanupdetails","required":false,"type":"boolean"},{"description":"true if image is bootable, false otherwise; available only for updateIso API","length":255,"name":"bootable","required":false,"type":"boolean"},{"description":"the name of the image file","length":255,"name":"name","required":false,"type":"string"},{"description":"Details in key/value pairs using format details[i].keyname=keyvalue. Example: details[0].hypervisortoolsversion=xenserver61","length":255,"name":"details","required":false,"type":"map"}],"related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","response":[{"description":"the date this template was created","name":"created","type":"date"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"the size of the template","name":"size","type":"long"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the template name","name":"name","type":"string"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"the template ID","name":"id","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"the tag of this template","name":"templatetag","type":"string"}]},{"description":"Updates site to site vpn connection","isasync":true,"name":"updateVpnConnection","params":[{"description":"id of vpn connection","length":255,"name":"id","related":"updateVpnConnection,listVpnConnections,createVpnConnection","required":true,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"an optional field, whether to the display the vpn to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"}],"related":"listVpnConnections,createVpnConnection","response":[{"description":"the customer gateway ID","name":"s2scustomergatewayid","type":"string"},{"description":"public ip address id of the customer gateway","name":"gateway","type":"string"},{"description":"the connection ID","name":"id","type":"string"},{"description":"IKE policy of the customer gateway","name":"ikepolicy","type":"string"},{"description":"Lifetime of IKE SA of customer gateway","name":"ikelifetime","type":"long"},{"description":"the public IP address","name":"publicip","type":"string"},{"description":"IPsec Preshared-Key of the customer gateway","name":"ipsecpsk","type":"string"},{"description":"State of vpn connection","name":"state","type":"string"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"if DPD is enabled for customer gateway","name":"dpd","type":"boolean"},{"description":"is connection for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the vpn gateway ID","name":"s2svpngatewayid","type":"string"},{"description":"the project id","name":"projectid","type":"string"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the domain id of the owner","name":"domainid","type":"string"},{"description":"if Force NAT Encapsulation is enabled for customer gateway","name":"forceencap","type":"boolean"},{"description":"ESP policy of the customer gateway","name":"esppolicy","type":"string"},{"description":"State of vpn connection","name":"passive","type":"boolean"},{"description":"the project name","name":"project","type":"string"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"Lifetime of ESP SA of customer gateway","name":"esplifetime","type":"long"},{"description":"guest cidr list of the customer gateway","name":"cidrlist","type":"string"},{"description":"the owner","name":"account","type":"string"}],"since":"4.4"},{"description":"Creates a VLAN IP range.","isasync":false,"name":"createVlanIpRange","params":[{"description":"account who will own the VLAN. If VLAN is Zone wide, this parameter should be ommited","length":255,"name":"account","required":false,"type":"string"},{"description":"the ending IP address in the VLAN IP range","length":255,"name":"endip","required":false,"type":"string"},{"description":"optional parameter. Have to be specified for Direct Untagged vlan only.","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"the beginning IP address in the VLAN IP range","length":255,"name":"startip","required":false,"type":"string"},{"description":"the gateway of the VLAN IP range","length":255,"name":"gateway","required":false,"type":"string"},{"description":"the network id","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listPaloAltoFirewallNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"the gateway of the IPv6 network. Required for Shared networks and Isolated networks when it belongs to VPC","length":255,"name":"ip6gateway","required":false,"type":"string"},{"description":"the Zone ID of the VLAN IP range","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the CIDR of IPv6 network, must be at least /64","length":255,"name":"ip6cidr","required":false,"type":"string"},{"description":"the netmask of the VLAN IP range","length":255,"name":"netmask","required":false,"type":"string"},{"description":"project who will own the VLAN. If VLAN is Zone wide, this parameter should be ommited","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"true if VLAN is of Virtual type, false if Direct","length":255,"name":"forvirtualnetwork","required":false,"type":"boolean"},{"description":"the physical network id","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"true if IP range is set to system vms, false if not","length":255,"name":"forsystemvms","required":false,"type":"boolean"},{"description":"the beginning IPv6 address in the IPv6 network range","length":255,"name":"startipv6","required":false,"type":"string"},{"description":"the ID or VID of the VLAN. If not specified, will be defaulted to the vlan of the network or if vlan of the network is null - to Untagged","length":255,"name":"vlan","required":false,"type":"string"},{"description":"domain ID of the account owning a VLAN","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the ending IPv6 address in the IPv6 network range","length":255,"name":"endipv6","required":false,"type":"string"}],"related":"listVlanIpRanges,dedicatePublicIpRange","response":[{"description":"the virtual network for the VLAN IP range","name":"forvirtualnetwork","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the network id of vlan range","name":"networkid","type":"string"},{"description":"indicates whether VLAN IP range is dedicated to system vms or not","name":"forsystemvms","type":"boolean"},{"description":"the Pod name for the VLAN IP range","name":"podname","type":"string"},{"description":"the end ipv6 of the VLAN IP range","name":"endipv6","type":"string"},{"description":"the description of the VLAN IP range","name":"description","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the account of the VLAN IP range","name":"account","type":"string"},{"description":"the netmask of the VLAN IP range","name":"netmask","type":"string"},{"description":"the ID of the VLAN IP range","name":"id","type":"string"},{"description":"the ID or VID of the VLAN.","name":"vlan","type":"string"},{"description":"the Pod ID for the VLAN IP range","name":"podid","type":"string"},{"description":"the start ipv6 of the VLAN IP range","name":"startipv6","type":"string"},{"description":"the domain ID of the VLAN IP range","name":"domainid","type":"string"},{"description":"the domain name of the VLAN IP range","name":"domain","type":"string"},{"description":"the start ip of the VLAN IP range","name":"startip","type":"string"},{"description":"the end ip of the VLAN IP range","name":"endip","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the Zone ID of the VLAN IP range","name":"zoneid","type":"string"},{"description":"the gateway of the VLAN IP range","name":"gateway","type":"string"},{"description":"the project name of the vlan range","name":"project","type":"string"},{"description":"the project id of the vlan range","name":"projectid","type":"string"}]},{"description":"lists network that are using Palo Alto firewall device","isasync":false,"name":"listPaloAltoFirewallNetworks","params":[{"description":"palo alto balancer device ID","length":255,"name":"lbdeviceid","related":"configurePaloAltoFirewall,listPaloAltoFirewalls,addPaloAltoFirewall","required":true,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","response":[{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"the type of the network","name":"type","type":"string"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the list of services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the provider name","name":"name","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"}],"type":"list"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability value","name":"value","type":"string"}],"type":"list"}],"type":"list"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"the id of the network","name":"id","type":"string"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"state of the network","name":"state","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"the name of the network","name":"name","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"}]},{"description":"Get the path associated with the provided volume UUID","isasync":false,"name":"getPathForVolume","params":[{"description":"CloudStack Volume UUID","length":255,"name":"volumeid","required":true,"type":"string"}],"related":"","response":[{"description":"The path field for the volume","name":"path","type":"string"}]},{"description":"Updates a vm group","isasync":false,"name":"updateInstanceGroup","params":[{"description":"new instance group name","length":255,"name":"name","required":false,"type":"string"},{"description":"Instance group ID","length":255,"name":"id","related":"updateInstanceGroup,createInstanceGroup","required":true,"type":"uuid"}],"related":"createInstanceGroup","response":[{"description":"the domain ID of the instance group","name":"domainid","type":"string"},{"description":"the name of the instance group","name":"name","type":"string"},{"description":"the ID of the instance group","name":"id","type":"string"},{"description":"time and date the instance group was created","name":"created","type":"date"},{"description":"the project ID of the instance group","name":"projectid","type":"string"},{"description":"the project name of the instance group","name":"project","type":"string"},{"description":"the domain name of the instance group","name":"domain","type":"string"},{"description":"the account owning the instance group","name":"account","type":"string"}]},{"description":"List ucs manager","isasync":false,"name":"listUcsManagers","params":[{"description":"the zone id","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the ID of the ucs manager","length":255,"name":"id","related":"listUcsManagers,addUcsManager","required":false,"type":"uuid"}],"related":"addUcsManager","response":[{"description":"the zone ID of ucs manager","name":"zoneid","type":"string"},{"description":"the name of ucs manager","name":"name","type":"string"},{"description":"the url of ucs manager","name":"url","type":"string"},{"description":"the ID of the ucs manager","name":"id","type":"string"}]},{"description":"Remove an Ldap Configuration","isasync":false,"name":"deleteLdapConfiguration","params":[{"description":"port","length":255,"name":"port","required":false,"type":"integer"},{"description":"linked domain","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"Hostname","length":255,"name":"hostname","required":true,"type":"string"}],"related":"addLdapConfiguration","response":[{"description":"name of the host running the ldap server","name":"hostname","type":"string"},{"description":"port teh ldap server is running on","name":"port","type":"int"},{"description":"linked domain","name":"domainid","type":"string"}],"since":"4.2.0"},{"description":"Upgrades domain router to a new service offering","isasync":false,"name":"changeServiceForRouter","params":[{"description":"The ID of the router","length":255,"name":"id","related":"listInternalLoadBalancerVMs,changeServiceForRouter,destroyRouter,listRouters","required":true,"type":"uuid"},{"description":"the service offering ID to apply to the domain router","length":255,"name":"serviceofferingid","related":"updateServiceOffering,listServiceOfferings","required":true,"type":"uuid"}],"related":"listInternalLoadBalancerVMs,destroyRouter,listRouters","response":[{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"}],"type":"set"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"role of the domain router","name":"role","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the name of the router","name":"name","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"}]},{"description":"Updates the volume.","isasync":true,"name":"updateVolume","params":[{"description":"the ID of the disk volume","length":255,"name":"id","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,updateVolume,migrateVolume,updateVolume","required":false,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"The path of the volume","length":255,"name":"path","required":false,"type":"string"},{"description":"an optional field, whether to the display the volume to the end user or not.","length":255,"name":"displayvolume","required":false,"type":"boolean"},{"description":"The state of the volume","length":255,"name":"state","required":false,"since":"4.3","type":"string"},{"description":"Destination storage pool UUID for the volume","length":255,"name":"storageid","related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"since":"4.3","type":"uuid"},{"description":"The chain info of the volume","length":255,"name":"chaininfo","required":false,"since":"4.4","type":"string"}],"related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,migrateVolume,updateVolume","response":[{"description":"min iops of the disk volume","name":"miniops","type":"long"},{"description":"provisioning type used to create volumes.","name":"provisioningtype","type":"string"},{"description":"the date the disk volume was created","name":"created","type":"date"},{"description":"type of the disk volume (ROOT or DATADISK)","name":"type","type":"string"},{"description":"the ID of the domain associated with the disk volume","name":"domainid","type":"string"},{"description":"the chain info of the volume","name":"chaininfo","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"size of the disk volume","name":"size","type":"long"},{"description":"bytes read rate of the disk volume","name":"diskBytesReadRate","type":"long"},{"description":"the status of the volume","name":"status","type":"string"},{"description":"the bytes actually consumed on disk","name":"virtualsize","type":"long"},{"description":"cluster id of the volume","name":"clusterid","type":"string"},{"description":"the ID of the device on user vm the volume is attahed to. This tag is not returned when the volume is detached.","name":"deviceid","type":"long"},{"description":"Hypervisor the volume belongs to","name":"hypervisor","type":"string"},{"description":"the display text of the disk offering","name":"diskofferingdisplaytext","type":"string"},{"description":"the state of the disk volume","name":"state","type":"string"},{"description":"io requests read rate of the disk volume","name":"diskIopsReadRate","type":"long"},{"description":"true if the volume is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"the project id of the vpn","name":"projectid","type":"string"},{"description":"need quiesce vm or not when taking snapshot","name":"quiescevm","type":"boolean"},{"description":"name of the availability zone","name":"zonename","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"shared or local storage","name":"storagetype","type":"string"},{"description":"io requests write rate of the disk volume","name":"diskIopsWriteRate","type":"long"},{"description":"id of the primary storage hosting the disk volume; returned to admin user only","name":"storageid","type":"string"},{"description":"ID of the availability zone","name":"zoneid","type":"string"},{"description":"ID of the disk offering","name":"diskofferingid","type":"string"},{"description":"ID of the service offering for root disk","name":"serviceofferingid","type":"string"},{"description":"the date the volume was attached to a VM instance","name":"attached","type":"date"},{"description":"the bytes alloaated","name":"physicalsize","type":"long"},{"description":"name of the disk offering","name":"diskofferingname","type":"string"},{"description":"pod id of the volume","name":"podid","type":"string"},{"description":"the disk utilization","name":"utilization","type":"string"},{"description":"name of the service offering for root disk","name":"serviceofferingname","type":"string"},{"description":"ID of the disk volume","name":"id","type":"string"},{"description":"the domain associated with the disk volume","name":"domain","type":"string"},{"description":"display name of the virtual machine","name":"vmdisplayname","type":"string"},{"description":"name of the primary storage hosting the disk volume","name":"storage","type":"string"},{"description":"the boolean state of whether the volume is destroyed or not","name":"destroyed","type":"boolean"},{"description":"max iops of the disk volume","name":"maxiops","type":"long"},{"description":"the project name of the vpn","name":"project","type":"string"},{"description":"cluster name where the volume is allocated","name":"clustername","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the path of the volume","name":"path","type":"string"},{"description":"the account associated with the disk volume","name":"account","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"an optional field whether to the display the volume to the end user or not.","name":"displayvolume","type":"boolean"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"ID of the snapshot from which this volume was created","name":"snapshotid","type":"string"},{"description":"state of the virtual machine","name":"vmstate","type":"string"},{"description":"name of the virtual machine","name":"vmname","type":"string"},{"description":"the display text of the service offering for root disk","name":"serviceofferingdisplaytext","type":"string"},{"description":"bytes write rate of the disk volume","name":"diskBytesWriteRate","type":"long"},{"description":"id of the virtual machine","name":"virtualmachineid","type":"string"},{"description":"pod name of the volume","name":"podname","type":"string"},{"description":"name of the disk volume","name":"name","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"}]},{"description":"Lists traffic types of a given physical network.","isasync":false,"name":"listTrafficTypes","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":true,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"listNetworkServiceProviders","response":[{"description":"state of the network provider","name":"state","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the provider name","name":"name","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"}],"since":"3.0.0"},{"description":"Updates account information for the authenticated user","isasync":false,"name":"updateAccount","params":[{"description":"details for account used to store specific parameters","length":255,"name":"accountdetails","required":false,"type":"map"},{"description":"the current account name","length":255,"name":"account","required":false,"type":"string"},{"description":"Account id","length":255,"name":"id","related":"listAccounts,updateAccount,enableAccount,listAccounts,createAccount,disableAccount","required":false,"type":"uuid"},{"description":"Network domain for the account's networks; empty string will update domainName with NULL value","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"the ID of the domain where the account exists","length":255,"name":"domainid","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"new name for the account","length":255,"name":"newname","required":true,"type":"string"}],"related":"listAccounts,enableAccount,listAccounts,createAccount,disableAccount","response":[{"description":"the total number of templates available to be created by this account","name":"templateavailable","type":"string"},{"description":"the total memory (in MB) available to be created for this account","name":"memoryavailable","type":"string"},{"description":"the total number of cpu cores the account can own","name":"cpulimit","type":"string"},{"description":"account type (admin, domain-admin, user)","name":"accounttype","type":"short"},{"description":"details for the account","name":"accountdetails","type":"map"},{"description":"the total number of projects available for administration by this account","name":"projectavailable","type":"string"},{"description":"the total number of projects being administrated by this account","name":"projecttotal","type":"long"},{"description":"the total number of snapshots stored by this account","name":"snapshottotal","type":"long"},{"description":"name of the Domain the account belongs too","name":"domain","type":"string"},{"description":"the type of the role (Admin, ResourceAdmin, DomainAdmin, User)","name":"roletype","type":"string"},{"description":"the total volume available for this account","name":"volumeavailable","type":"string"},{"description":"the total number of vpcs available to be created for this account","name":"vpcavailable","type":"string"},{"description":"the total primary storage space (in GiB) the account can own","name":"primarystoragelimit","type":"string"},{"description":"the total number of public ip addresses this account can acquire","name":"iplimit","type":"string"},{"description":"the total number of projects the account can own","name":"projectlimit","type":"string"},{"description":"the total number of network traffic bytes sent","name":"sentbytes","type":"long"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the total volume being used by this account","name":"volumetotal","type":"long"},{"description":"the total number of cpu cores available to be created for this account","name":"cpuavailable","type":"string"},{"description":"id of the Domain the account belongs too","name":"domainid","type":"string"},{"description":"the total number of virtual machines that can be deployed by this account","name":"vmlimit","type":"string"},{"description":"the total number of networks owned by account","name":"networktotal","type":"long"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the total number of snapshots available for this account","name":"snapshotavailable","type":"string"},{"description":"the total number of virtual machines deployed by this account","name":"vmtotal","type":"long"},{"description":"the total volume which can be used by this account","name":"volumelimit","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total primary storage space (in GiB) owned by account","name":"primarystoragetotal","type":"long"},{"description":"the total secondary storage space (in GiB) available to be used for this account","name":"secondarystorageavailable","type":"string"},{"description":"true if account is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the total number of templates which have been created by this account","name":"templatetotal","type":"long"},{"description":"true if the account requires cleanup","name":"iscleanuprequired","type":"boolean"},{"description":"the total number of snapshots which can be stored by this account","name":"snapshotlimit","type":"string"},{"description":"the total memory (in MB) the account can own","name":"memorylimit","type":"string"},{"description":"the list of users associated with account","name":"user","response":[{"description":"the boolean value representing if the updating target is in caller's child domain","name":"iscallerchilddomain","type":"boolean"},{"description":"the timezone user was created in","name":"timezone","type":"string"},{"description":"the user ID","name":"id","type":"string"},{"description":"the user email address","name":"email","type":"string"},{"description":"the account ID of the user","name":"accountid","type":"string"},{"description":"the user lastname","name":"lastname","type":"string"},{"description":"the domain ID of the user","name":"domainid","type":"string"},{"description":"the secret key of the user","name":"secretkey","type":"string"},{"description":"the user name","name":"username","type":"string"},{"description":"true if user is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the account name of the user","name":"account","type":"string"},{"description":"the api key of the user","name":"apikey","type":"string"},{"description":"the date and time the user account was created","name":"created","type":"date"},{"description":"the user state","name":"state","type":"string"},{"description":"the user firstname","name":"firstname","type":"string"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the type of the role","name":"roletype","type":"string"},{"description":"the domain name of the user","name":"domain","type":"string"},{"description":"the account type of the user","name":"accounttype","type":"short"},{"description":"the source type of the user in lowercase, such as native, ldap, saml2","name":"usersource","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"}],"type":"list"},{"description":"the state of the account","name":"state","type":"string"},{"description":"the total number of virtual machines stopped for this account","name":"vmstopped","type":"integer"},{"description":"the total number of network traffic bytes received","name":"receivedbytes","type":"long"},{"description":"the total number of virtual machines running for this account","name":"vmrunning","type":"integer"},{"description":"the total number of vpcs the account can own","name":"vpclimit","type":"string"},{"description":"the id of the account","name":"id","type":"string"},{"description":"the total number of vpcs owned by account","name":"vpctotal","type":"long"},{"description":"the total number of public ip addresses allocated for this account","name":"iptotal","type":"long"},{"description":"the total number of templates which can be created by this account","name":"templatelimit","type":"string"},{"description":"the total memory (in MB) owned by account","name":"memorytotal","type":"long"},{"description":"the total secondary storage space (in GiB) owned by account","name":"secondarystoragetotal","type":"float"},{"description":"the total number of networks available to be created for this account","name":"networkavailable","type":"string"},{"description":"the total number of public ip addresses available for this account to acquire","name":"ipavailable","type":"string"},{"description":"the total number of cpu cores owned by account","name":"cputotal","type":"long"},{"description":"the name of the account","name":"name","type":"string"},{"description":"the total primary storage space (in GiB) available to be used for this account","name":"primarystorageavailable","type":"string"},{"description":"the total number of virtual machines available for this account to acquire","name":"vmavailable","type":"string"},{"description":"the total number of networks the account can own","name":"networklimit","type":"string"},{"description":"the total secondary storage space (in GiB) the account can own","name":"secondarystoragelimit","type":"string"},{"description":"the list of acl groups that account belongs to","name":"groups","type":"list"},{"description":"the default zone of the account","name":"defaultzoneid","type":"string"}]},{"description":"Updates properties of a virtual machine. The VM has to be stopped and restarted for the new properties to take effect. UpdateVirtualMachine does not first check whether the VM is stopped. Therefore, stop the VM manually before issuing this call.","isasync":false,"name":"updateVirtualMachine","params":[{"description":"optional boolean field, which indicates if details should be cleaned up or not (if set to true, details removed for this resource, details field ignored; if false or not set, no action)","length":255,"name":"cleanupdetails","required":false,"type":"boolean"},{"description":"instance name of the user vm","length":255,"name":"instancename","required":false,"since":"4.4","type":"string"},{"description":"list of security group ids to be applied on the virtual machine.","length":255,"name":"securitygroupids","related":"createSecurityGroup","required":false,"type":"list"},{"description":"an optional binary data that can be sent to the virtual machine upon a successful deployment. This binary data must be base64 encoded before adding it to the request. Using HTTP GET (via querystring), you can send up to 2KB of data after base64 encoding. Using HTTP POST(via POST body), you can send up to 32K of data after base64 encoding.","length":32768,"name":"userdata","required":false,"type":"string"},{"description":"comma separated list of security groups names that going to be applied to the virtual machine. Should be passed only when vm is created from a zone with Basic Network support. Mutually exclusive with securitygroupids parameter","length":255,"name":"securitygroupnames","related":"createSecurityGroup","required":false,"type":"list"},{"description":"true if VM contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","length":255,"name":"isdynamicallyscalable","required":false,"type":"boolean"},{"description":"an optional field, whether to the display the vm to the end user or not.","length":255,"name":"displayvm","required":false,"type":"boolean"},{"description":"Details in key/value pairs.","length":255,"name":"details","required":false,"type":"map"},{"description":"new host name of the vm. The VM has to be stopped/started for this update to take affect","length":255,"name":"name","required":false,"since":"4.4","type":"string"},{"description":"The ID of the virtual machine","length":255,"name":"id","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,updateVirtualMachine,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"DHCP options which are passed to the VM on start up Example: dhcpoptionsnetworklist[0].dhcp:114=url\u0026dhcpoptionsetworklist[0].networkid=networkid\u0026dhcpoptionsetworklist[0].dhcp:66=www.test.com","length":255,"name":"dhcpoptionsnetworklist","required":false,"type":"map"},{"description":"true if high-availability is enabled for the virtual machine, false otherwise","length":255,"name":"haenable","required":false,"type":"boolean"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"the ID of the OS type that best represents this VM.","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"},{"description":"user generated name","length":255,"name":"displayname","required":false,"type":"string"},{"description":"group of the virtual machine","length":255,"name":"group","required":false,"type":"string"}],"related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","response":[{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"set"}],"type":"set"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"}],"type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the domain ID of the security group","name":"domainid","type":"string"}],"type":"set"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"}],"type":"set"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"}],"type":"set"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"}]},{"description":"Adds secondary storage.","isasync":false,"name":"addSecondaryStorage","params":[{"description":"the Zone ID for the secondary storage","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the URL for the secondary storage","length":255,"name":"url","required":true,"type":"string"}],"related":"listImageStores,updateCloudToUseObjectStore,listSwifts,addImageStoreS3","response":[{"description":"the Zone ID of the image store","name":"zoneid","type":"string"},{"description":"the name of the image store","name":"name","type":"string"},{"description":"the provider name of the image store","name":"providername","type":"string"},{"description":"the url of the image store","name":"url","type":"string"},{"description":"the scope of the image store","name":"scope","type":"scopetype"},{"description":"the Zone name of the image store","name":"zonename","type":"string"},{"description":"the protocol of the image store","name":"protocol","type":"string"},{"description":"the ID of the image store","name":"id","type":"string"}]},{"description":"Lists domains and provides detailed information for listed domains","isasync":false,"name":"listDomains","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"comma separated list of domain details requested, value can be a list of [ all, resource, min]","length":255,"name":"details","required":false,"type":"list"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"List domains by domain level.","length":255,"name":"level","required":false,"type":"integer"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List domain by domain ID.","length":255,"name":"id","related":"listDomains,listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"List domain by domain name.","length":255,"name":"name","required":false,"type":"string"}],"related":"listDomains,listDomainChildren","response":[{"description":"the total number of vpcs available to be created for this domain","name":"vpcavailable","type":"string"},{"description":"the total number of public ip addresses allocated for this domain","name":"iptotal","type":"long"},{"description":"the total memory (in MB) owned by domain","name":"memorytotal","type":"long"},{"description":"the total number of snapshots which can be stored by this domain","name":"snapshotlimit","type":"string"},{"description":"the domain name of the parent domain","name":"parentdomainname","type":"string"},{"description":"the total primary storage space (in GiB) owned by domain","name":"primarystoragetotal","type":"long"},{"description":"the total volume available for this domain","name":"volumeavailable","type":"string"},{"description":"the total memory (in MB) available to be created for this domain","name":"memoryavailable","type":"string"},{"description":"the level of the domain","name":"level","type":"integer"},{"description":"the total primary storage space (in GiB) the domain can own","name":"primarystoragelimit","type":"string"},{"description":"the total number of networks owned by domain","name":"networktotal","type":"long"},{"description":"the total secondary storage space (in GiB) the domain can own","name":"secondarystoragelimit","type":"string"},{"description":"the total number of vpcs owned by domain","name":"vpctotal","type":"long"},{"description":"the name of the domain","name":"name","type":"string"},{"description":"the total number of cpu cores available to be created for this domain","name":"cpuavailable","type":"string"},{"description":"the total memory (in MB) the domain can own","name":"memorylimit","type":"string"},{"description":"the total number of projects available for administration by this domain","name":"projectavailable","type":"string"},{"description":"the total number of virtual machines deployed by this domain","name":"vmtotal","type":"long"},{"description":"the total number of cpu cores the domain can own","name":"cpulimit","type":"string"},{"description":"the total number of projects the domain can own","name":"projectlimit","type":"string"},{"description":"the total number of projects being administrated by this domain","name":"projecttotal","type":"long"},{"description":"the state of the domain","name":"state","type":"string"},{"description":"the total primary storage space (in GiB) available to be used for this domain","name":"primarystorageavailable","type":"string"},{"description":"the total number of public ip addresses available for this domain to acquire","name":"ipavailable","type":"string"},{"description":"whether the domain has one or more sub-domains","name":"haschild","type":"boolean"},{"description":"the total number of public ip addresses this domain can acquire","name":"iplimit","type":"string"},{"description":"the domain ID of the parent domain","name":"parentdomainid","type":"string"},{"description":"the total volume which can be used by this domain","name":"volumelimit","type":"string"},{"description":"the ID of the domain","name":"id","type":"string"},{"description":"the total number of templates which have been created by this domain","name":"templatetotal","type":"long"},{"description":"the total number of snapshots stored by this domain","name":"snapshottotal","type":"long"},{"description":"the total number of virtual machines available for this domain to acquire","name":"vmavailable","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total secondary storage space (in GiB) owned by domain","name":"secondarystoragetotal","type":"float"},{"description":"the total volume being used by this domain","name":"volumetotal","type":"long"},{"description":"the total number of snapshots available for this domain","name":"snapshotavailable","type":"string"},{"description":"the path of the domain","name":"path","type":"string"},{"description":"the total number of networks available to be created for this domain","name":"networkavailable","type":"string"},{"description":"the total number of templates which can be created by this domain","name":"templatelimit","type":"string"},{"description":"the total number of vpcs the domain can own","name":"vpclimit","type":"string"},{"description":"the total number of virtual machines that can be deployed by this domain","name":"vmlimit","type":"string"},{"description":"the total number of templates available to be created by this domain","name":"templateavailable","type":"string"},{"description":"the total number of networks the domain can own","name":"networklimit","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this domain","name":"secondarystorageavailable","type":"string"},{"description":"the total number of cpu cores owned by domain","name":"cputotal","type":"long"}]},{"description":"Disables an account","isasync":true,"name":"disableAccount","params":[{"description":"If true, only lock the account; else disable the account","length":255,"name":"lock","required":true,"type":"boolean"},{"description":"Account id","length":255,"name":"id","related":"listAccounts,enableAccount,listAccounts,createAccount,disableAccount","required":false,"type":"uuid"},{"description":"Disables specified account in this domain.","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"Disables specified account.","length":255,"name":"account","required":false,"type":"string"}],"related":"listAccounts,enableAccount,listAccounts,createAccount","response":[{"description":"id of the Domain the account belongs too","name":"domainid","type":"string"},{"description":"the total number of virtual machines deployed by this account","name":"vmtotal","type":"long"},{"description":"the total number of projects available for administration by this account","name":"projectavailable","type":"string"},{"description":"the list of users associated with account","name":"user","response":[{"description":"the domain name of the user","name":"domain","type":"string"},{"description":"the user name","name":"username","type":"string"},{"description":"the account ID of the user","name":"accountid","type":"string"},{"description":"the user lastname","name":"lastname","type":"string"},{"description":"the secret key of the user","name":"secretkey","type":"string"},{"description":"the user firstname","name":"firstname","type":"string"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"the user email address","name":"email","type":"string"},{"description":"the account type of the user","name":"accounttype","type":"short"},{"description":"the timezone user was created in","name":"timezone","type":"string"},{"description":"the type of the role","name":"roletype","type":"string"},{"description":"the date and time the user account was created","name":"created","type":"date"},{"description":"the account name of the user","name":"account","type":"string"},{"description":"the source type of the user in lowercase, such as native, ldap, saml2","name":"usersource","type":"string"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the boolean value representing if the updating target is in caller's child domain","name":"iscallerchilddomain","type":"boolean"},{"description":"the user state","name":"state","type":"string"},{"description":"the user ID","name":"id","type":"string"},{"description":"the api key of the user","name":"apikey","type":"string"},{"description":"true if user is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the domain ID of the user","name":"domainid","type":"string"}],"type":"list"},{"description":"the name of the role","name":"rolename","type":"string"},{"description":"details for the account","name":"accountdetails","type":"map"},{"description":"the total number of snapshots which can be stored by this account","name":"snapshotlimit","type":"string"},{"description":"the total memory (in MB) available to be created for this account","name":"memoryavailable","type":"string"},{"description":"the total number of networks owned by account","name":"networktotal","type":"long"},{"description":"the state of the account","name":"state","type":"string"},{"description":"the total number of public ip addresses allocated for this account","name":"iptotal","type":"long"},{"description":"the total number of projects being administrated by this account","name":"projecttotal","type":"long"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the total volume which can be used by this account","name":"volumelimit","type":"string"},{"description":"the total secondary storage space (in GiB) the account can own","name":"secondarystoragelimit","type":"string"},{"description":"true if account is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the total number of networks the account can own","name":"networklimit","type":"string"},{"description":"the total number of templates available to be created by this account","name":"templateavailable","type":"string"},{"description":"the total memory (in MB) owned by account","name":"memorytotal","type":"long"},{"description":"the total number of projects the account can own","name":"projectlimit","type":"string"},{"description":"the total number of network traffic bytes received","name":"receivedbytes","type":"long"},{"description":"the total number of vpcs owned by account","name":"vpctotal","type":"long"},{"description":"the name of the account","name":"name","type":"string"},{"description":"the total volume available for this account","name":"volumeavailable","type":"string"},{"description":"the total number of cpu cores the account can own","name":"cpulimit","type":"string"},{"description":"the total memory (in MB) the account can own","name":"memorylimit","type":"string"},{"description":"the total primary storage space (in GiB) owned by account","name":"primarystoragetotal","type":"long"},{"description":"name of the Domain the account belongs too","name":"domain","type":"string"},{"description":"the total number of public ip addresses available for this account to acquire","name":"ipavailable","type":"string"},{"description":"the list of acl groups that account belongs to","name":"groups","type":"list"},{"description":"the total number of vpcs the account can own","name":"vpclimit","type":"string"},{"description":"the total number of templates which can be created by this account","name":"templatelimit","type":"string"},{"description":"the total number of virtual machines running for this account","name":"vmrunning","type":"integer"},{"description":"the total number of network traffic bytes sent","name":"sentbytes","type":"long"},{"description":"the total number of snapshots available for this account","name":"snapshotavailable","type":"string"},{"description":"the total primary storage space (in GiB) the account can own","name":"primarystoragelimit","type":"string"},{"description":"the total secondary storage space (in GiB) available to be used for this account","name":"secondarystorageavailable","type":"string"},{"description":"the total number of templates which have been created by this account","name":"templatetotal","type":"long"},{"description":"the type of the role (Admin, ResourceAdmin, DomainAdmin, User)","name":"roletype","type":"string"},{"description":"the total number of snapshots stored by this account","name":"snapshottotal","type":"long"},{"description":"the total primary storage space (in GiB) available to be used for this account","name":"primarystorageavailable","type":"string"},{"description":"the id of the account","name":"id","type":"string"},{"description":"the total number of vpcs available to be created for this account","name":"vpcavailable","type":"string"},{"description":"the total number of virtual machines available for this account to acquire","name":"vmavailable","type":"string"},{"description":"the total volume being used by this account","name":"volumetotal","type":"long"},{"description":"the default zone of the account","name":"defaultzoneid","type":"string"},{"description":"account type (admin, domain-admin, user)","name":"accounttype","type":"short"},{"description":"the total number of public ip addresses this account can acquire","name":"iplimit","type":"string"},{"description":"the total number of networks available to be created for this account","name":"networkavailable","type":"string"},{"description":"true if the account requires cleanup","name":"iscleanuprequired","type":"boolean"},{"description":"the total number of virtual machines that can be deployed by this account","name":"vmlimit","type":"string"},{"description":"the total number of cpu cores owned by account","name":"cputotal","type":"long"},{"description":"the ID of the role","name":"roleid","type":"string"},{"description":"the total number of virtual machines stopped for this account","name":"vmstopped","type":"integer"},{"description":"the total number of cpu cores available to be created for this account","name":"cpuavailable","type":"string"},{"description":"the total secondary storage space (in GiB) owned by account","name":"secondarystoragetotal","type":"float"}]},{"description":"Updates a network","isasync":true,"name":"updateNetwork","params":[{"description":"Setting this to true will cause a forced network update,","length":255,"name":"forced","required":false,"type":"boolean"},{"description":"network domain","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"the new name for the network","length":255,"name":"name","required":false,"type":"string"},{"description":"if true, we will update the routers one after the other. applicable only for redundant router based networks using virtual router as provider","length":255,"name":"updateinsequence","required":false,"type":"boolean"},{"description":"an optional field, whether to the display the network to the end user or not.","length":255,"name":"displaynetwork","required":false,"type":"boolean"},{"description":"the ID of the network","length":255,"name":"id","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,updateNetwork,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":true,"type":"uuid"},{"description":"network offering ID","length":255,"name":"networkofferingid","related":"listNetworkOfferings","required":false,"type":"uuid"},{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"Force update even if CIDR type is different","length":255,"name":"changecidr","required":false,"type":"boolean"},{"description":"CIDR for guest VMs, CloudStack allocates IPs to guest VMs only from this CIDR","length":255,"name":"guestvmcidr","required":false,"type":"string"},{"description":"the new display text for the network","length":255,"name":"displaytext","required":false,"type":"string"}],"related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","response":[{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"the name of the network","name":"name","type":"string"},{"description":"the type of the network","name":"type","type":"string"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"list"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"the id of the network","name":"id","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"the list of services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability value","name":"value","type":"string"}],"type":"list"},{"description":"the service provider name","name":"provider","response":[{"description":"the provider name","name":"name","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"}],"type":"list"}],"type":"list"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"state of the network","name":"state","type":"string"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"the owner of the network","name":"account","type":"string"}]},{"description":"List Usage Types","isasync":false,"name":"listUsageTypes","params":[],"related":"","response":[{"description":"usage type","name":"usagetypeid","type":"integer"},{"description":"description of usage type","name":"description","type":"string"}]},{"description":"Lists all network ACLs","isasync":false,"name":"listNetworkACLLists","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list network ACLs by specified name","length":255,"name":"name","required":false,"type":"string"},{"description":"list network ACLs by network ID","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list network ACLs by VPC ID","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"Lists network ACL with the specified ID.","length":255,"name":"id","related":"createNetworkACLList,listNetworkACLLists","required":false,"type":"uuid"}],"related":"createNetworkACLList","response":[{"description":"is ACL for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"Id of the VPC this ACL is associated with","name":"vpcid","type":"string"},{"description":"the ID of the ACL","name":"id","type":"string"},{"description":"the Name of the ACL","name":"name","type":"string"},{"description":"Description of the ACL","name":"description","type":"string"}]},{"description":"Deletes a template from the system. All virtual machines using the deleted template will not be affected.","isasync":true,"name":"deleteTemplate","params":[{"description":"the ID of zone of the template","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"the ID of the template","length":255,"name":"id","related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,createTemplate,listIsos,copyTemplate,copyIso,createTemplate","required":true,"type":"uuid"},{"description":"Force delete a template.","length":255,"name":"forced","required":false,"since":"4.9+","type":"boolean"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Deletes a VPC","isasync":true,"name":"deleteVPC","params":[{"description":"the ID of the VPC","length":255,"name":"id","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Updates site to site vpn local gateway","isasync":true,"name":"updateVpnGateway","params":[{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"an optional field, whether to the display the vpn to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"id of customer gateway","length":255,"name":"id","related":"updateVpnGateway,createVpnGateway,listVpnGateways","required":true,"type":"uuid"}],"related":"createVpnGateway,listVpnGateways","response":[{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"the project id","name":"projectid","type":"string"},{"description":"the domain id of the owner","name":"domainid","type":"string"},{"description":"is vpn gateway for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the vpn gateway ID","name":"id","type":"string"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the owner","name":"account","type":"string"},{"description":"the vpc id of this gateway","name":"vpcid","type":"string"},{"description":"the public IP address","name":"publicip","type":"string"},{"description":"the project name","name":"project","type":"string"}],"since":"4.4"},{"description":"Releases a dedicated guest vlan range to the system","isasync":true,"name":"releaseDedicatedGuestVlanRange","params":[{"description":"the ID of the dedicated guest vlan range","length":255,"name":"id","related":"","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Deletes security group","isasync":false,"name":"deleteSecurityGroup","params":[{"description":"The ID of the security group. Mutually exclusive with name parameter","length":255,"name":"id","related":"createSecurityGroup","required":false,"type":"uuid"},{"description":"The ID of the security group. Mutually exclusive with id parameter","length":255,"name":"name","required":false,"type":"string"},{"description":"the domain ID of account owning the security group","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the account of the security group. Must be specified with domain ID","length":255,"name":"account","required":false,"type":"string"},{"description":"the project of the security group","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Attempts Migration of a VM to a different host or Root volume of the vm to a different storage pool","isasync":true,"name":"migrateVirtualMachine","params":[{"description":"Destination Host ID to migrate VM to. Required for live migrating a VM from host to host","length":255,"name":"hostid","related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"Destination storage pool ID to migrate VM volumes to. Required for migrating the root disk volume","length":255,"name":"storageid","related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"the ID of the virtual machine","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,migrateVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","response":[{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"}],"type":"set"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"}],"type":"set"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"}],"type":"set"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"}],"type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"}],"type":"set"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"}],"type":"set"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"}]},{"description":"list baremetal rack configuration","isasync":false,"name":"listBaremetalRct","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"addBaremetalRct","response":[{"description":"url","name":"url","type":"string"},{"description":"id of rct","name":"id","type":"string"}]},{"description":"Creates a template of a virtual machine. The virtual machine must be in a STOPPED state. A template created from this command is automatically designated as a private template visible to the account that created it.","isasync":true,"name":"createTemplate","params":[{"description":"the display text of the template. This is usually used for display purposes.","length":4096,"name":"displaytext","required":true,"type":"string"},{"description":"the name of the template","length":255,"name":"name","required":true,"type":"string"},{"description":"the ID of the disk volume the template is being created from. Either this parameter, or snapshotId has to be passed in","length":255,"name":"volumeid","related":"createVolume,attachVolume,listVolumes,listVolumes,detachVolume,resizeVolume,createVolume,migrateVolume,attachVolume,uploadVolume,migrateVolume,updateVolume","required":false,"type":"uuid"},{"description":"the ID of the OS Type that best represents the OS of this template.","length":255,"name":"ostypeid","related":"addGuestOs,listOsTypes","required":true,"type":"uuid"},{"description":"true if this template is a public template, false otherwise","length":255,"name":"ispublic","required":false,"type":"boolean"},{"description":"Template details in key/value pairs using format details[i].keyname=keyvalue. Example: details[0].hypervisortoolsversion=xenserver61","length":255,"name":"details","required":false,"type":"map"},{"description":"true if this template is a featured template, false otherwise","length":255,"name":"isfeatured","required":false,"type":"boolean"},{"description":"the tag for this template.","length":255,"name":"templatetag","required":false,"type":"string"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","length":255,"name":"isdynamicallyscalable","required":false,"type":"boolean"},{"description":"the ID of the snapshot the template is being created from. Either this parameter, or volumeId has to be passed in","length":255,"name":"snapshotid","related":"revertSnapshot","required":false,"type":"uuid"},{"description":"Optional, VM ID. If this presents, it is going to create a baremetal template for VM this ID refers to. This is only for VM whose hypervisor type is BareMetal","length":255,"name":"virtualmachineid","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"Optional, only for baremetal hypervisor. The directory name where template stored on CIFS server","length":2048,"name":"url","required":false,"type":"string"},{"description":"true if the template supports the password reset feature; default is false","length":255,"name":"passwordenabled","required":false,"type":"boolean"},{"description":"32 or 64 bit","length":255,"name":"bits","required":false,"type":"integer"},{"description":"true if the template requres HVM, false otherwise","length":255,"name":"requireshvm","required":false,"type":"boolean"},{"description":"create template for the project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"}],"related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,listIsos,copyTemplate,copyIso,createTemplate","response":[{"description":"true if the ISO is bootable, false otherwise","name":"bootable","type":"boolean"},{"description":"true if template contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory","name":"isdynamicallyscalable","type":"boolean"},{"description":"true if the reset password feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the format of the template.","name":"format","type":"imageformat"},{"description":"true if the template is managed across all Zones, false otherwise","name":"crossZones","type":"boolean"},{"description":"the account name to which the template belongs","name":"account","type":"string"},{"description":"the type of the template","name":"templatetype","type":"string"},{"description":"checksum of the template","name":"checksum","type":"string"},{"description":"the template display text","name":"displaytext","type":"string"},{"description":"the ID of the domain to which the template belongs","name":"domainid","type":"string"},{"description":"the account id to which the template belongs","name":"accountid","type":"string"},{"description":"the name of the secondary storage host for the template","name":"hostname","type":"string"},{"description":"if Datadisk template, then id of the root disk template this template belongs to","name":"parenttemplateid","type":"string"},{"description":"the size of the template","name":"size","type":"long"},{"description":"true if the template is extractable, false otherwise","name":"isextractable","type":"boolean"},{"description":"true if this template is a featured template, false otherwise","name":"isfeatured","type":"boolean"},{"description":"the template ID of the parent template if present","name":"sourcetemplateid","type":"string"},{"description":"the date this template was removed","name":"removed","type":"date"},{"description":"the ID of the OS type for this template.","name":"ostypeid","type":"string"},{"description":"the status of the template","name":"status","type":"string"},{"description":"the tag of this template","name":"templatetag","type":"string"},{"description":"true if this template is a public template, false otherwise","name":"ispublic","type":"boolean"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the processor bit size","name":"bits","type":"int"},{"description":"the physical size of the template","name":"physicalsize","type":"long"},{"description":"the name of the domain to which the template belongs","name":"domain","type":"string"},{"description":"true if template is sshkey enabled, false otherwise","name":"sshkeyenabled","type":"boolean"},{"description":"additional key/value details tied with template","name":"details","type":"map"},{"description":"if root disk template, then ids of the datas disk templates this template owns","name":"childtemplates","type":"set"},{"description":"the name of the OS type for this template.","name":"ostypename","type":"string"},{"description":"the project id of the template","name":"projectid","type":"string"},{"description":"the template ID","name":"id","type":"string"},{"description":"the template name","name":"name","type":"string"},{"description":"the ID of the zone for this template","name":"zoneid","type":"string"},{"description":"the ID of the secondary storage host for the template","name":"hostid","type":"string"},{"description":"the name of the zone for this template","name":"zonename","type":"string"},{"description":"the date this template was created","name":"created","type":"date"},{"description":"the project name of the template","name":"project","type":"string"},{"description":"true if the template is ready to be deployed from, false otherwise.","name":"isready","type":"boolean"},{"description":"KVM Only: true if template is directly downloaded to Primary Storage bypassing Secondary Storage","name":"directdownload","type":"boolean"}]},{"description":"Uploads a custom certificate for the console proxy VMs to use for SSL. Can be used to upload a single certificate signed by a known CA. Can also be used, through multiple calls, to upload a chain of certificates from CA to the custom certificate itself.","isasync":true,"name":"uploadCustomCertificate","params":[{"description":"An integer providing the location in a chain that the certificate will hold. Usually, this can be left empty. When creating a chain, the top level certificate should have an ID of 1, with each step in the chain incrementing by one. Example, CA with id = 1, Intermediate CA with id = 2, Site certificate with ID = 3","length":255,"name":"id","required":false,"type":"integer"},{"description":"The private key for the attached certificate.","length":65535,"name":"privatekey","required":false,"type":"string"},{"description":"DNS domain suffix that the certificate is granted for.","length":255,"name":"domainsuffix","required":true,"type":"string"},{"description":"The certificate to be uploaded.","length":65535,"name":"certificate","required":true,"type":"string"},{"description":"A name / alias for the certificate.","length":255,"name":"name","required":false,"type":"string"}],"related":"","response":[{"description":"message of the certificate upload operation","name":"message","type":"string"}]},{"description":"Lists dedicated clusters.","isasync":false,"name":"listDedicatedClusters","params":[{"description":"the name of the account associated with the cluster. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"the ID of the cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list dedicated clusters by affinity group","length":255,"name":"affinitygroupid","related":"","required":false,"type":"uuid"},{"description":"the ID of the domain associated with the cluster","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"","response":[{"description":"the ID of the cluster","name":"clusterid","type":"string"},{"description":"the ID of the dedicated resource","name":"id","type":"string"},{"description":"the domain ID of the cluster","name":"domainid","type":"string"},{"description":"the name of the cluster","name":"clustername","type":"string"},{"description":"the Dedication Affinity Group ID of the cluster","name":"affinitygroupid","type":"string"},{"description":"the Account ID of the cluster","name":"accountid","type":"string"}]},{"description":"Lists available certificate authority providers in CloudStack","isasync":false,"name":"listCAProviders","params":[{"description":"List CA service provider by name","length":255,"name":"name","required":false,"type":"string"}],"related":"","response":[{"description":"the CA service provider name","name":"name","type":"string"},{"description":"the description of the CA service provider","name":"description","type":"string"}],"since":"4.11.0"},{"description":"Delete site to site vpn customer gateway","isasync":true,"name":"deleteVpnCustomerGateway","params":[{"description":"id of customer gateway","length":255,"name":"id","related":"createVpnCustomerGateway,listVpnCustomerGateways","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Enables out-of-band management for a cluster","isasync":true,"name":"enableOutOfBandManagementForCluster","params":[{"description":"the ID of the cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":true,"type":"uuid"}],"related":"enableOutOfBandManagementForHost,disableOutOfBandManagementForCluster,disableOutOfBandManagementForHost","response":[{"description":"the out-of-band management interface username","name":"username","type":"string"},{"description":"the out-of-band management interface password","name":"password","type":"string"},{"description":"the operation result description","name":"description","type":"string"},{"description":"the out-of-band management action (if issued)","name":"action","type":"string"},{"description":"the out-of-band management interface address","name":"address","type":"string"},{"description":"the out-of-band management driver for the host","name":"driver","type":"string"},{"description":"the ID of the host","name":"hostid","type":"string"},{"description":"the out-of-band management interface powerState of the host","name":"powerstate","type":"powerstate"},{"description":"the operation result","name":"status","type":"boolean"},{"description":"true if out-of-band management is enabled for the host","name":"enabled","type":"boolean"},{"description":"the out-of-band management interface port","name":"port","type":"string"}],"since":"4.9.0"},{"description":"Allocates IP addresses in respective Pod of a Zone","isasync":false,"name":"acquirePodIpAddress","params":[{"description":"Pod ID","length":255,"name":"podid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"string"},{"description":"the ID of the zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"string"}],"related":"","response":[{"description":"CIDR of the Pod","name":"cidr","type":"string"},{"description":"the ID of the pod the  IP address","name":"id","type":"long"},{"description":"Gateway for Pod ","name":"gateway","type":"string"},{"description":"MAC address of the pod the  IP","name":"hostmac","type":"long"},{"description":"Allocated IP address","name":"ipaddress","type":"string"},{"description":"the ID of the nic","name":"nicid","type":"long"},{"description":"the ID of the pod the  IP address belongs to","name":"podid","type":"long"}]},{"description":"Lists all port forwarding rules for an IP address.","isasync":false,"name":"listPortForwardingRules","params":[{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"Lists rule with the specified ID.","length":255,"name":"id","related":"updatePortForwardingRule,listPortForwardingRules","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"the ID of IP address of the port forwarding services","length":255,"name":"ipaddressid","related":"associateIpAddress,associateIpAddress,listPublicIpAddresses,updateIpAddress","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"list port forwarding rules for certain network","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"since":"4.3","type":"uuid"}],"related":"updatePortForwardingRule","response":[{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the VM name for the port forwarding rule","name":"virtualmachinename","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"privateendport","type":"string"},{"description":"the VM display name for the port forwarding rule","name":"virtualmachinedisplayname","type":"string"},{"description":"the public ip address id for the port forwarding rule","name":"ipaddressid","type":"string"},{"description":"the public ip address for the port forwarding rule","name":"ipaddress","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"publicendport","type":"string"},{"description":"is firewall for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the protocol of the port forwarding rule","name":"protocol","type":"string"},{"description":"the vm ip address for the port forwarding rule","name":"vmguestip","type":"string"},{"description":"the ID of the port forwarding rule","name":"id","type":"string"},{"description":"the VM ID for the port forwarding rule","name":"virtualmachineid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the starting port of port forwarding rule's private port range","name":"privateport","type":"string"},{"description":"the starting port of port forwarding rule's public port range","name":"publicport","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"list"},{"description":"the id of the guest network the port forwarding rule belongs to","name":"networkid","type":"string"}]},{"description":"Updates a template visibility permissions. A public template is visible to all accounts within the same domain. A private template is visible only to the owner of the template. A priviledged template is a private template with account permissions added. Only accounts specified under the template permissions are visible to them.","isasync":false,"name":"updateTemplatePermissions","params":[{"description":"permission operator (add, remove, reset)","length":255,"name":"op","required":false,"type":"string"},{"description":"a comma delimited list of projects. If specified, \"op\" parameter has to be passed in.","length":255,"name":"projectids","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"list"},{"description":"a comma delimited list of accounts. If specified, \"op\" parameter has to be passed in.","length":255,"name":"accounts","required":false,"type":"list"},{"description":"the template ID","length":255,"name":"id","related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,listIsos,copyTemplate,copyIso,createTemplate","required":true,"type":"uuid"},{"description":"true for featured template/iso, false otherwise","length":255,"name":"isfeatured","required":false,"type":"boolean"},{"description":"true for public template/iso, false for private templates/isos","length":255,"name":"ispublic","required":false,"type":"boolean"},{"description":"true if the template/iso is extractable, false other wise. Can be set only by root admin","length":255,"name":"isextractable","required":false,"type":"boolean"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"List traffic monitor Hosts.","isasync":false,"name":"listTrafficMonitors","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"zone Id","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"addTrafficMonitor","response":[{"description":"the management IP address of the external firewall","name":"ipaddress","type":"string"},{"description":"the zone ID of the external firewall","name":"zoneid","type":"string"},{"description":"the ID of the external firewall","name":"id","type":"string"},{"description":"the timeout (in seconds) for requests to the external firewall","name":"timeout","type":"string"},{"description":"the number of times to retry requests to the external firewall","name":"numretries","type":"string"}]},{"description":"Resets the password for virtual machine. The virtual machine must be in a \"Stopped\" state and the template must already support this feature for this command to take effect. [async]","isasync":true,"name":"resetPasswordForVirtualMachine","params":[{"description":"The ID of the virtual machine","length":255,"name":"id","related":"resetPasswordForVirtualMachine,attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","response":[{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"}],"type":"set"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"}],"type":"set"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"}],"type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"set"},{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"security group name","name":"securitygroupname","type":"string"}],"type":"set"}],"type":"set"}]},{"description":"Updates a port forwarding rule. Only the private port and the virtual machine can be updated.","isasync":true,"name":"updatePortForwardingRule","params":[{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the private start port of the port forwarding rule","length":255,"name":"privateport","required":false,"type":"integer"},{"description":"VM guest nic Secondary ip address for the port forwarding rule","length":255,"name":"vmguestip","required":false,"since":"4.5","type":"string"},{"description":"the ID of the port forwarding rule","length":255,"name":"id","related":"updatePortForwardingRule","required":true,"since":"4.4","type":"uuid"},{"description":"the ID of the virtual machine for the port forwarding rule","length":255,"name":"virtualmachineid","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"the private end port of the port forwarding rule","length":255,"name":"privateendport","required":false,"type":"integer"}],"related":"","response":[{"description":"the ID of the port forwarding rule","name":"id","type":"string"},{"description":"the VM ID for the port forwarding rule","name":"virtualmachineid","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"privateendport","type":"string"},{"description":"the ending port of port forwarding rule's private port range","name":"publicendport","type":"string"},{"description":"the id of the guest network the port forwarding rule belongs to","name":"networkid","type":"string"},{"description":"the protocol of the port forwarding rule","name":"protocol","type":"string"},{"description":"the VM name for the port forwarding rule","name":"virtualmachinename","type":"string"},{"description":"the starting port of port forwarding rule's private port range","name":"privateport","type":"string"},{"description":"the public ip address id for the port forwarding rule","name":"ipaddressid","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"list"},{"description":"the VM display name for the port forwarding rule","name":"virtualmachinedisplayname","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"is firewall for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the public ip address for the port forwarding rule","name":"ipaddress","type":"string"},{"description":"the vm ip address for the port forwarding rule","name":"vmguestip","type":"string"},{"description":"the starting port of port forwarding rule's public port range","name":"publicport","type":"string"},{"description":"the state of the rule","name":"state","type":"string"}]},{"description":"Lists Brocade VCS Switches","isasync":false,"name":"listBrocadeVcsDevices","params":[{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"Brocade VCS switch ID","length":255,"name":"vcsdeviceid","related":"listBrocadeVcsDevices","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"","response":[{"description":"the physical Network to which this Brocade VCS belongs to","name":"physicalnetworkid","type":"string"},{"description":"device id of the Brocade Vcs","name":"vcsdeviceid","type":"string"},{"description":"name of the provider","name":"provider","type":"string"},{"description":"the principal switch Ip address","name":"hostname","type":"string"},{"description":"device name","name":"brocadedevicename","type":"string"}]},{"description":"link an existing cloudstack domain to group or OU in ldap","isasync":false,"name":"linkDomainToLdap","params":[{"description":"type of the ldap name. GROUP or OU","length":255,"name":"type","required":true,"type":"string"},{"description":"The id of the domain which has to be linked to LDAP.","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":true,"type":"uuid"},{"description":"name of the group or OU in LDAP","length":255,"name":"name","required":false,"type":"string"},{"description":"domain admin username in LDAP ","length":255,"name":"admin","required":false,"type":"string"},{"description":"name of the group or OU in LDAP","length":255,"name":"ldapdomain","required":false,"type":"string"},{"description":"Type of the account to auto import. Specify 0 for user and 2 for domain admin","length":255,"name":"accounttype","required":true,"type":"short"}],"related":"linkAccountToLdap","response":[{"description":"name of the group or OU in LDAP which is linked to the domain","name":"name","type":"string"},{"description":"type of the name in LDAP which is linke to the domain","name":"type","type":"string"},{"description":"name of the group or OU in LDAP which is linked to the domain","name":"ldapdomain","type":"string"},{"description":"Domain Admin accountId that is created","name":"accountid","type":"string"},{"description":"id of the Domain which is linked to LDAP","name":"domainid","type":"string"},{"description":"Type of the account to auto import","name":"accounttype","type":"short"}],"since":"4.6.0"},{"description":"Acquires and associates a public IP to an account. Either of the parameters are required, i.e. either zoneId, or networkId, or vpcId  ","isasync":true,"name":"associateIpAddress","params":[{"description":"the account to associate with this IP address","length":255,"name":"account","required":false,"type":"string"},{"description":"region ID from where portable IP is to be associated.","length":255,"name":"regionid","related":"listRegions,addRegion","required":false,"type":"integer"},{"description":"the VPC you want the IP address to be associated with","length":255,"name":"vpcid","related":"restartVPC,createVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"Deploy VM for the project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"an optional field, whether to the display the IP to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the ID of the domain to associate with this IP address","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"The network this IP address should be associated to.","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"the ID of the availability zone you want to acquire an public IP address from","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"should be set to true if public IP is required to be transferable across zones, if not specified defaults to false","length":255,"name":"isportable","required":false,"type":"boolean"}],"related":"associateIpAddress,listPublicIpAddresses,updateIpAddress","response":[{"description":"true if the IP address is a source nat address, false otherwise","name":"issourcenat","type":"boolean"},{"description":"the virtual network for the IP address","name":"forvirtualnetwork","type":"boolean"},{"description":"purpose of the IP address. In Acton this value is not null for Ips with isSystem=true, and can have either StaticNat or LB value","name":"purpose","type":"string"},{"description":"VPC the ip belongs to","name":"vpcid","type":"string"},{"description":"State of the ip address. Can be: Allocatin, Allocated and Releasing","name":"state","type":"string"},{"description":"public IP address","name":"ipaddress","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the ID of the VLAN associated with the IP address. This parameter is visible to ROOT admins only","name":"vlanid","type":"string"},{"description":"the domain the public IP address is associated with","name":"domain","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the name of the zone the public IP address belongs to","name":"zonename","type":"string"},{"description":"true if this ip is system ip (was allocated as a part of deployVm or createLbRule)","name":"issystem","type":"boolean"},{"description":"the ID of the Network associated with the IP address","name":"associatednetworkid","type":"string"},{"description":"virtual machine display name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinedisplayname","type":"string"},{"description":"virtual machine (dnat) ip address (not null only for static nat Ip)","name":"vmipaddress","type":"string"},{"description":"virtual machine name the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachinename","type":"string"},{"description":"the ID of the Network where ip belongs to","name":"networkid","type":"string"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the list of resource tags associated with ip address","name":"tags","response":[{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"}],"type":"list"},{"description":"is public ip for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"virtual machine id the ip address is assigned to (not null only for static nat Ip)","name":"virtualmachineid","type":"string"},{"description":"the name of the Network associated with the IP address","name":"associatednetworkname","type":"string"},{"description":"true if this ip is for static nat, false otherwise","name":"isstaticnat","type":"boolean"},{"description":"the account the public IP address is associated with","name":"account","type":"string"},{"description":"is public IP portable across the zones","name":"isportable","type":"boolean"},{"description":"the ID of the zone the public IP address belongs to","name":"zoneid","type":"string"},{"description":"the domain ID the public IP address is associated with","name":"domainid","type":"string"},{"description":"the VLAN associated with the IP address","name":"vlanname","type":"string"},{"description":"date the public IP address was acquired","name":"allocated","type":"date"},{"description":"public IP address id","name":"id","type":"string"}]},{"description":"Delete site to site vpn connection","isasync":true,"name":"deleteVpnConnection","params":[{"description":"id of vpn connection","length":255,"name":"id","related":"listVpnConnections,createVpnConnection","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":" delete a F5 load balancer device","isasync":true,"name":"deleteF5LoadBalancer","params":[{"description":"netscaler load balancer device ID","length":255,"name":"lbdeviceid","related":"addF5LoadBalancer","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Creates a ACL rule in the given network (the network has to belong to VPC)","isasync":true,"name":"createNetworkACL","params":[{"description":"type of the ICMP message being sent","length":255,"name":"icmptype","required":false,"type":"integer"},{"description":"the ending port of ACL","length":255,"name":"endport","required":false,"type":"integer"},{"description":"the CIDR list to allow traffic from/to","length":255,"name":"cidrlist","required":false,"type":"list"},{"description":"The network of the VM the ACL will be created for","length":255,"name":"aclid","related":"createNetworkACLList","required":false,"type":"uuid"},{"description":"The network of the VM the ACL will be created for","length":255,"name":"number","required":false,"type":"integer"},{"description":"an optional field, whether to the display the rule to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the starting port of ACL","length":255,"name":"startport","required":false,"type":"integer"},{"description":"the protocol for the ACL rule. Valid values are TCP/UDP/ICMP/ALL or valid protocol number","length":255,"name":"protocol","required":true,"type":"string"},{"description":"the traffic type for the ACL,can be ingress or egress, defaulted to ingress if not specified","length":255,"name":"traffictype","required":false,"type":"string"},{"description":"error code for this ICMP message","length":255,"name":"icmpcode","required":false,"type":"integer"},{"description":"The network of the VM the ACL will be created for","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"scl entry action, allow or deny","length":255,"name":"action","required":false,"type":"string"}],"related":"updateNetworkACLItem","response":[{"description":"the state of the rule","name":"state","type":"string"},{"description":"the ID of the ACL Item","name":"id","type":"string"},{"description":"Action of ACL Item. Allow/Deny","name":"action","type":"string"},{"description":"the traffic type for the ACL","name":"traffictype","type":"string"},{"description":"the protocol of the ACL","name":"protocol","type":"string"},{"description":"error code for this icmp message","name":"icmpcode","type":"integer"},{"description":"type of the icmp message being sent","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the network ACLs","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"tag value","name":"value","type":"string"}],"type":"list"},{"description":"the starting port of ACL's port range","name":"startport","type":"string"},{"description":"the ending port of ACL's port range","name":"endport","type":"string"},{"description":"the ID of the ACL this item belongs to","name":"aclid","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"Number of the ACL Item","name":"number","type":"integer"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"}]},{"description":"Lists site to site vpn customer gateways","isasync":false,"name":"listVpnCustomerGateways","params":[{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"id of the customer gateway","length":255,"name":"id","related":"createVpnCustomerGateway,listVpnCustomerGateways","required":false,"type":"uuid"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"}],"related":"createVpnCustomerGateway","response":[{"description":"guest ip of the customer gateway","name":"ipaddress","type":"string"},{"description":"IPsec policy of customer gateway","name":"esppolicy","type":"string"},{"description":"the owner","name":"account","type":"string"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the project id","name":"projectid","type":"string"},{"description":"name of the customer gateway","name":"name","type":"string"},{"description":"if Force NAT Encapsulation is enabled for customer gateway","name":"forceencap","type":"boolean"},{"description":"Lifetime of ESP SA of customer gateway","name":"esplifetime","type":"long"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"the domain id of the owner","name":"domainid","type":"string"},{"description":"if DPD is enabled for customer gateway","name":"dpd","type":"boolean"},{"description":"guest cidr list of the customer gateway","name":"cidrlist","type":"string"},{"description":"Lifetime of IKE SA of customer gateway","name":"ikelifetime","type":"long"},{"description":"the project name","name":"project","type":"string"},{"description":"the vpn gateway ID","name":"id","type":"string"},{"description":"IPsec preshared-key of customer gateway","name":"ipsecpsk","type":"string"},{"description":"public ip address id of the customer gateway","name":"gateway","type":"string"},{"description":"IKE policy of customer gateway","name":"ikepolicy","type":"string"}]},{"description":"Resets the SSH Key for virtual machine. The virtual machine must be in a \"Stopped\" state. [async]","isasync":true,"name":"resetSSHKeyForVirtualMachine","params":[{"description":"an optional project for the ssh key","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"an optional account for the ssh key. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"The ID of the virtual machine","length":255,"name":"id","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,resetSSHKeyForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"},{"description":"an optional domainId for the virtual machine. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"name of the ssh key pair used to login to the virtual machine","length":255,"name":"keypair","required":true,"type":"string"}],"related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","response":[{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"}],"type":"set"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the ID of the affinity group","name":"id","type":"string"}],"type":"set"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"}],"type":"set"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"}],"type":"set"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"}],"type":"set"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"account owning the security group rule","name":"account","type":"string"}],"type":"set"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"set"}],"type":"set"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"}]},{"description":"Deletes a management network IP range. This action is only allowed when no IPs in this range are allocated.","isasync":true,"name":"deleteManagementNetworkIpRange","params":[{"description":"The ending IP address.","length":255,"name":"endip","required":true,"type":"string"},{"description":"The starting IP address.","length":255,"name":"startip","required":true,"type":"string"},{"description":"UUID of POD, where the IP range belongs to.","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":true,"type":"uuid"},{"description":"The vlan id the ip range sits on","length":255,"name":"vlan","required":true,"type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.11.0.0"},{"description":"Creates a global load balancer rule","isasync":true,"name":"createGlobalLoadBalancerRule","params":[{"description":"region where the global load balancer is going to be created.","length":255,"name":"regionid","related":"listRegions,addRegion","required":true,"type":"integer"},{"description":"the domain ID associated with the load balancer","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the account associated with the global load balancer. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"session sticky method (sourceip) if not specified defaults to sourceip","length":255,"name":"gslbstickysessionmethodname","required":false,"type":"string"},{"description":"load balancer algorithm (roundrobin, leastconn, proximity) that method is used to distribute traffic across the zones participating in global server load balancing, if not specified defaults to 'round robin'","length":255,"name":"gslblbmethod","required":false,"type":"string"},{"description":"name of the load balancer rule","length":255,"name":"name","required":true,"type":"string"},{"description":"domain name for the GSLB service.","length":255,"name":"gslbdomainname","required":true,"type":"string"},{"description":"GSLB service type (tcp, udp, http)","length":255,"name":"gslbservicetype","required":true,"type":"string"},{"description":"the description of the load balancer rule","length":4096,"name":"description","required":false,"type":"string"}],"related":"updateGlobalLoadBalancerRule,listGlobalLoadBalancerRules","response":[{"description":"name of the global load balancer rule","name":"name","type":"string"},{"description":"session persistence method used for the global load balancer","name":"gslbstickysessionmethodname","type":"string"},{"description":"the account of the load balancer rule","name":"account","type":"string"},{"description":"the project id of the load balancer","name":"projectid","type":"string"},{"description":"Region Id in which global load balancer is created","name":"regionid","type":"integer"},{"description":"DNS domain name given for the global load balancer","name":"gslbdomainname","type":"string"},{"description":"the description of the global load balancer rule","name":"description","type":"string"},{"description":"the domain of the load balancer rule","name":"domain","type":"string"},{"description":"the project name of the load balancer","name":"project","type":"string"},{"description":"global load balancer rule ID","name":"id","type":"string"},{"description":"GSLB service type","name":"gslbservicetype","type":"string"},{"description":"the domain ID of the load balancer rule","name":"domainid","type":"string"},{"description":"Load balancing method used for the global load balancer","name":"gslblbmethod","type":"string"},{"description":"List of load balancer rules that are part of GSLB rule","name":"loadbalancerrule","response":[{"description":"the domain ID of the load balancer rule","name":"domainid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the private port","name":"privateport","type":"string"},{"description":"the description of the load balancer","name":"description","type":"string"},{"description":"the public ip address id","name":"publicipid","type":"string"},{"description":"the load balancer rule ID","name":"id","type":"string"},{"description":"the public port","name":"publicport","type":"string"},{"description":"the id of the guest network the lb rule belongs to","name":"networkid","type":"string"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the protocol of the loadbalanacer rule","name":"protocol","type":"string"},{"description":"the domain of the load balancer rule","name":"domain","type":"string"},{"description":"the list of resource tags associated with load balancer","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"the project name of the load balancer","name":"project","type":"string"},{"description":"the load balancer algorithm (source, roundrobin, leastconn)","name":"algorithm","type":"string"},{"description":"the account of the load balancer rule","name":"account","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the id of the zone the rule belongs to","name":"zoneid","type":"string"},{"description":"the name of the zone the load balancer rule belongs to","name":"zonename","type":"string"},{"description":"the name of the load balancer","name":"name","type":"string"},{"description":"the public ip address","name":"publicip","type":"string"},{"description":"the project id of the load balancer","name":"projectid","type":"string"}],"type":"list"}]},{"description":" delete a netscaler load balancer device","isasync":true,"name":"deleteNetscalerLoadBalancer","params":[{"description":"netscaler load balancer device ID","length":255,"name":"lbdeviceid","related":"deployNetscalerVpx,addNetscalerLoadBalancer,listNetscalerLoadBalancers,registerNetscalerControlCenter","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists load balancer rules.","isasync":false,"name":"listGlobalLoadBalancerRules","params":[{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"region ID","length":255,"name":"regionid","related":"listRegions,addRegion","required":false,"type":"integer"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"the ID of the global load balancer rule","length":255,"name":"id","related":"updateGlobalLoadBalancerRule,listGlobalLoadBalancerRules","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"}],"related":"updateGlobalLoadBalancerRule","response":[{"description":"the domain of the load balancer rule","name":"domain","type":"string"},{"description":"DNS domain name given for the global load balancer","name":"gslbdomainname","type":"string"},{"description":"global load balancer rule ID","name":"id","type":"string"},{"description":"session persistence method used for the global load balancer","name":"gslbstickysessionmethodname","type":"string"},{"description":"the project name of the load balancer","name":"project","type":"string"},{"description":"the description of the global load balancer rule","name":"description","type":"string"},{"description":"Region Id in which global load balancer is created","name":"regionid","type":"integer"},{"description":"name of the global load balancer rule","name":"name","type":"string"},{"description":"the domain ID of the load balancer rule","name":"domainid","type":"string"},{"description":"List of load balancer rules that are part of GSLB rule","name":"loadbalancerrule","response":[{"description":"the domain of the load balancer rule","name":"domain","type":"string"},{"description":"the public ip address id","name":"publicipid","type":"string"},{"description":"the public port","name":"publicport","type":"string"},{"description":"the cidr list to forward traffic from","name":"cidrlist","type":"string"},{"description":"the domain ID of the load balancer rule","name":"domainid","type":"string"},{"description":"is rule for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the list of resource tags associated with load balancer","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"}],"type":"list"},{"description":"the project name of the load balancer","name":"project","type":"string"},{"description":"the project id of the load balancer","name":"projectid","type":"string"},{"description":"the load balancer algorithm (source, roundrobin, leastconn)","name":"algorithm","type":"string"},{"description":"the description of the load balancer","name":"description","type":"string"},{"description":"the public ip address","name":"publicip","type":"string"},{"description":"the load balancer rule ID","name":"id","type":"string"},{"description":"the id of the zone the rule belongs to","name":"zoneid","type":"string"},{"description":"the state of the rule","name":"state","type":"string"},{"description":"the protocol of the loadbalanacer rule","name":"protocol","type":"string"},{"description":"the account of the load balancer rule","name":"account","type":"string"},{"description":"the name of the zone the load balancer rule belongs to","name":"zonename","type":"string"},{"description":"the name of the load balancer","name":"name","type":"string"},{"description":"the id of the guest network the lb rule belongs to","name":"networkid","type":"string"},{"description":"the private port","name":"privateport","type":"string"}],"type":"list"},{"description":"the account of the load balancer rule","name":"account","type":"string"},{"description":"Load balancing method used for the global load balancer","name":"gslblbmethod","type":"string"},{"description":"GSLB service type","name":"gslbservicetype","type":"string"},{"description":"the project id of the load balancer","name":"projectid","type":"string"}]},{"description":"List resource tag(s)","isasync":false,"name":"listTags","params":[{"description":"list by key","length":255,"name":"key","required":false,"type":"string"},{"description":"list by customer name","length":255,"name":"customer","required":false,"type":"string"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list by value","length":255,"name":"value","required":false,"type":"string"},{"description":"list by resource type","length":255,"name":"resourcetype","required":false,"type":"string"},{"description":"list by resource id","length":255,"name":"resourceid","required":false,"type":"string"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"}],"related":"","response":[{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"}],"since":"4.0.0"},{"description":"Updates a disk offering.","isasync":false,"name":"deleteDiskOffering","params":[{"description":"ID of the disk offering","length":255,"name":"id","related":"listDiskOfferings,createDiskOffering","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Release the dedication for cluster","isasync":true,"name":"releaseDedicatedCluster","params":[{"description":"the ID of the Cluster","length":255,"name":"clusterid","related":"addCluster,updateCluster","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Create a virtual router element.","isasync":true,"name":"createVirtualRouterElement","params":[{"description":"The provider type. Supported types are VirtualRouter (default) and VPCVirtualRouter","length":255,"name":"providertype","related":"listNetworkServiceProviders","required":false,"type":"uuid"},{"description":"the network service provider ID of the virtual router element","length":255,"name":"nspid","related":"listNetworkServiceProviders","required":true,"type":"uuid"}],"related":"listVirtualRouterElements,configureVirtualRouterElement","response":[{"description":"the domain associated with the provider","name":"domain","type":"string"},{"description":"Enabled/Disabled the service provider","name":"enabled","type":"boolean"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the physical network service provider id of the provider","name":"nspid","type":"string"},{"description":"the account associated with the provider","name":"account","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the id of the router","name":"id","type":"string"},{"description":"the domain ID associated with the provider","name":"domainid","type":"string"}]},{"description":"Creates a VPC","isasync":true,"name":"createVPC","params":[{"description":"the display text of the VPC","length":255,"name":"displaytext","required":true,"type":"string"},{"description":"an optional field, whether to the display the vpc to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"If set to false, the VPC won't start (VPC VR will not get allocated) until its first network gets implemented. True by default.","length":255,"name":"start","required":false,"since":"4.3","type":"boolean"},{"description":"the ID of the VPC offering","length":255,"name":"vpcofferingid","related":"updateVPCOffering","required":true,"type":"uuid"},{"description":"VPC network domain. All networks inside the VPC will belong to this domain","length":255,"name":"networkdomain","required":false,"type":"string"},{"description":"the cidr of the VPC. All VPC guest networks' cidrs should be within this CIDR","length":255,"name":"cidr","required":true,"type":"string"},{"description":"the domain ID associated with the VPC. If used with the account parameter returns the VPC associated with the account for the specified domain.","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the name of the VPC","length":255,"name":"name","required":true,"type":"string"},{"description":"the account associated with the VPC. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"create VPC for the project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the ID of the availability zone","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"}],"related":"restartVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","response":[{"description":"the project id of the VPC","name":"projectid","type":"string"},{"description":"the domain id of the VPC owner","name":"domainid","type":"string"},{"description":"zone id of the vpc","name":"zoneid","type":"string"},{"description":"the cidr the VPC","name":"cidr","type":"string"},{"description":"state of the VPC. Can be Inactive/Enabled","name":"state","type":"string"},{"description":"the date this VPC was created","name":"created","type":"date"},{"description":"the list of resource tags associated with the project","name":"tags","response":[{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"list"},{"description":"the name of the VPC","name":"name","type":"string"},{"description":"an alternate display text of the VPC.","name":"displaytext","type":"string"},{"description":"the list of supported services","name":"service","response":[{"description":"the service provider name","name":"provider","response":[{"description":"state of the network provider","name":"state","type":"string"},{"description":"the provider name","name":"name","type":"string"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"}],"type":"list"},{"description":"true VPC requires restart","name":"restartrequired","type":"boolean"},{"description":"vpc offering id the VPC is created from","name":"vpcofferingid","type":"string"},{"description":"the domain name of the owner","name":"domain","type":"string"},{"description":"is vpc for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the owner of the VPC","name":"account","type":"string"},{"description":"if this VPC has redundant router","name":"redundantvpcrouter","type":"boolean"},{"description":"the name of the zone the VPC belongs to","name":"zonename","type":"string"},{"description":"the list of networks belongign to the VPC","name":"network","response":[{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"the name of the network","name":"name","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"the id of the network","name":"id","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"the domain name of the network owner","name":"domain","type":"string"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"}],"type":"list"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the list of services","name":"service","response":[{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"},{"description":"the capability value","name":"value","type":"string"}],"type":"list"},{"description":"the service name","name":"name","type":"string"},{"description":"the service provider name","name":"provider","response":[{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the provider name","name":"name","type":"string"}],"type":"list"}],"type":"list"},{"description":"the type of the network","name":"type","type":"string"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"state of the network","name":"state","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"}],"type":"list"},{"description":"is VPC uses distributed router for one hop forwarding and host based network ACL's","name":"distributedvpcrouter","type":"boolean"},{"description":"the project name of the VPC","name":"project","type":"string"},{"description":"the id of the VPC","name":"id","type":"string"},{"description":"the network domain of the VPC","name":"networkdomain","type":"string"},{"description":"true if VPC is region level","name":"regionlevelvpc","type":"boolean"}]},{"description":"Deletes a autoscale policy.","isasync":true,"name":"deleteAutoScalePolicy","params":[{"description":"the ID of the autoscale policy","length":255,"name":"id","related":"updateAutoScalePolicy,listAutoScalePolicies","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Deletes a role","isasync":false,"name":"deleteRole","params":[{"description":"ID of the role","length":255,"name":"id","related":"createRole,listRoles,updateRole","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.9.0"},{"description":" delete a Cisco Nexus VSM device","isasync":true,"name":"deleteCiscoNexusVSM","params":[{"description":"Id of the Cisco Nexus 1000v VSM device to be deleted","length":255,"name":"id","related":"disableCiscoNexusVSM,listCiscoNexusVSMs","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"List internal LB VMs.","isasync":false,"name":"listInternalLoadBalancerVMs","params":[{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolean"},{"description":"the name of the Internal LB VM","length":255,"name":"name","required":false,"type":"string"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"list by network id","length":255,"name":"networkid","related":"listSrxFirewallNetworks,listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the ID of the Internal LB VM","length":255,"name":"id","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"List Internal LB VMs by VPC","length":255,"name":"vpcid","related":"restartVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"the host ID of the Internal LB VM","length":255,"name":"hostid","related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"the state of the Internal LB VM","length":255,"name":"state","required":false,"type":"string"},{"description":"if true is passed for this parameter, list only VPC Internal LB VMs","length":255,"name":"forvpc","required":false,"type":"boolean"},{"description":"the Pod ID of the Internal LB VM","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"the Zone ID of the Internal LB VM","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"}],"related":"destroyRouter,listRouters","response":[{"description":"role of the domain router","name":"role","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"the account associated with the router","name":"account","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the link local netmask for the router","name":"linklocalnetmask","type":"string"},{"description":"the gateway for the router","name":"gateway","type":"string"},{"description":"the public MAC address for the router","name":"publicmacaddress","type":"string"},{"description":"the public IP address for the router","name":"publicip","type":"string"},{"description":"the guest IP address for the router","name":"guestipaddress","type":"string"},{"description":"VPC the router belongs to","name":"vpcid","type":"string"},{"description":"the name of VPC the router belongs to","name":"vpcname","type":"string"},{"description":"the link local MAC address for the router","name":"linklocalmacaddress","type":"string"},{"description":"the link local IP address for the router","name":"linklocalip","type":"string"},{"description":"true if the router template requires upgrader","name":"requiresupgrade","type":"boolean"},{"description":"the first DNS for the router","name":"dns1","type":"string"},{"description":"the guest netmask for the router","name":"guestnetmask","type":"string"},{"description":"the state of the router","name":"state","type":"state"},{"description":"the public netmask for the router","name":"publicnetmask","type":"string"},{"description":"the domain ID associated with the router","name":"domainid","type":"string"},{"description":"the first IPv6 DNS for the router","name":"ip6dns1","type":"string"},{"description":"the second DNS for the router","name":"dns2","type":"string"},{"description":"the guest MAC address for the router","name":"guestmacaddress","type":"string"},{"description":"the version of scripts","name":"scriptsversion","type":"string"},{"description":"the Pod ID for the router","name":"podid","type":"string"},{"description":"the domain associated with the router","name":"domain","type":"string"},{"description":"the template ID for the router","name":"templateid","type":"string"},{"description":"the list of nics associated with the router","name":"nic","response":[{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"}],"type":"set"},{"description":"the Zone ID for the router","name":"zoneid","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{"description":"the host ID for the router","name":"hostid","type":"string"},{"description":"the ID of the corresponding link local network","name":"linklocalnetworkid","type":"string"},{"description":"the name of the corresponding guest network","name":"guestnetworkname","type":"string"},{"description":"the Zone name for the router","name":"zonename","type":"string"},{"description":"the network domain for the router","name":"networkdomain","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the ID of the corresponding public network","name":"publicnetworkid","type":"string"},{"description":"the hostname for the router","name":"hostname","type":"string"},{"description":"the version of template","name":"version","type":"string"},{"description":"the second IPv6 DNS for the router","name":"ip6dns2","type":"string"},{"description":"the ID of the corresponding guest network","name":"guestnetworkid","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the state of redundant virtual router","name":"redundantstate","type":"string"},{"description":"the date and time the router was created","name":"created","type":"date"},{"description":"the id of the router","name":"id","type":"string"},{"description":"if this router is an redundant virtual router","name":"isredundantrouter","type":"boolean"},{"description":"the name of the router","name":"name","type":"string"}]},{"description":"Lists Cisco VNMC controllers","isasync":false,"name":"listCiscoVnmcResources","params":[{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"the Physical Network ID","length":255,"name":"physicalnetworkid","related":"createPhysicalNetwork","required":false,"type":"uuid"},{"description":"Cisco VNMC resource ID","length":255,"name":"resourceid","related":"listCiscoVnmcResources","required":false,"type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"","response":[{},{},{},{},{}]},{"description":"Removes detail for the Resource.","isasync":true,"name":"removeResourceDetail","params":[{"description":"Delete details matching key/value pairs","length":255,"name":"key","required":false,"type":"string"},{"description":"Delete details for resource id","length":255,"name":"resourceid","required":true,"type":"string"},{"description":"Delete detail by resource type","length":255,"name":"resourcetype","required":true,"type":"string"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists all supported OS types for this cloud.","isasync":false,"name":"listOsTypes","params":[{"description":"list os by description","length":255,"name":"description","required":false,"since":"3.0.1","type":"string"},{"description":"list by Os Category id","length":255,"name":"oscategoryid","related":"listOsCategories","required":false,"type":"uuid"},{"description":"list by Os type Id","length":255,"name":"id","related":"addGuestOs,listOsTypes","required":false,"type":"uuid"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"addGuestOs","response":[{"description":"the name/description of the OS type","name":"description","type":"string"},{"description":"the ID of the OS type","name":"id","type":"string"},{"description":"the ID of the OS category","name":"oscategoryid","type":"string"},{"description":"is the guest OS user defined","name":"isuserdefined","type":"boolean"}]},{"description":"Deletes a particular egress rule from this security group","isasync":true,"name":"revokeSecurityGroupEgress","params":[{"description":"The ID of the egress rule","length":255,"name":"id","related":"authorizeSecurityGroupIngress","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"3.0.0"},{"description":"lists network that are using SRX firewall device","isasync":false,"name":"listSrxFirewallNetworks","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"netscaler load balancer device ID","length":255,"name":"lbdeviceid","related":"configureSrxFirewall","required":true,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"}],"related":"listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","response":[{"description":"true if network is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"If the network has redundant routers enabled","name":"redundantrouter","type":"boolean"},{"description":"state of the network","name":"state","type":"string"},{"description":"the first DNS for the network","name":"dns1","type":"string"},{"description":"true if network can span multiple zones","name":"strechedl2subnet","type":"boolean"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the list of services","name":"service","response":[{"description":"the service name","name":"name","type":"string"},{"description":"the list of capabilities","name":"capability","response":[{"description":"the capability value","name":"value","type":"string"},{"description":"the capability name","name":"name","type":"string"},{"description":"can this service capability value can be choosable while creatine network offerings","name":"canchooseservicecapability","type":"boolean"}],"type":"list"},{"description":"the service provider name","name":"provider","response":[{"description":"services for this provider","name":"servicelist","type":"list"},{"description":"the provider name","name":"name","type":"string"},{"description":"uuid of the network provider","name":"id","type":"string"},{"description":"the destination physical network","name":"destinationphysicalnetworkid","type":"string"},{"description":"true if individual services can be enabled/disabled","name":"canenableindividualservice","type":"boolean"},{"description":"the physical network this belongs to","name":"physicalnetworkid","type":"string"},{"description":"state of the network provider","name":"state","type":"string"}],"type":"list"}],"type":"list"},{"description":"The vlan of the network. This parameter is visible to ROOT admins only","name":"vlan","type":"string"},{"description":"VPC the network belongs to","name":"vpcid","type":"string"},{"description":"list networks that are persistent","name":"ispersistent","type":"boolean"},{"description":"related to what other network configuration","name":"related","type":"string"},{"description":"network offering id the network is created from","name":"networkofferingid","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the displaytext of the network","name":"displaytext","type":"string"},{"description":"the name of the zone the network belongs to","name":"zonename","type":"string"},{"description":"the project id of the ipaddress","name":"projectid","type":"string"},{"description":"the list of resource tags associated with network","name":"tags","response":[{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"list"},{"description":"true if network supports specifying ip ranges, false otherwise","name":"specifyipranges","type":"boolean"},{"description":"ACL Id associated with the VPC network","name":"aclid","type":"string"},{"description":"the type of the network","name":"type","type":"string"},{"description":"The external id of the network","name":"externalid","type":"string"},{"description":"Cloudstack managed address space, all CloudStack managed VMs get IP address from CIDR","name":"cidr","type":"string"},{"description":"the network's netmask","name":"netmask","type":"string"},{"description":"display text of the network offering the network is created from","name":"networkofferingdisplaytext","type":"string"},{"description":"availability of the network offering the network is created from","name":"networkofferingavailability","type":"string"},{"description":"true if network is system, false otherwise","name":"issystem","type":"boolean"},{"description":"the domain id of the network owner","name":"domainid","type":"string"},{"description":"an optional field, whether to the display the network to the end user or not.","name":"displaynetwork","type":"boolean"},{"description":"If a network is enabled for 'streched l2 subnet' then represents zones on which network currently spans","name":"zonesnetworkspans","type":"set"},{"description":"the name of the network","name":"name","type":"string"},{"description":"true if users from subdomains can access the domain level network","name":"subdomainaccess","type":"boolean"},{"description":"Broadcast domain type of the network","name":"broadcastdomaintype","type":"string"},{"description":"the network domain","name":"networkdomain","type":"string"},{"description":"the network CIDR of the guest network configured with IP reservation. It is the summation of CIDR and RESERVED_IP_RANGE","name":"networkcidr","type":"string"},{"description":"the network's IP range not to be used by CloudStack guest VMs and can be used for non CloudStack purposes","name":"reservediprange","type":"string"},{"description":"zone id of the network","name":"zoneid","type":"string"},{"description":"true if network offering is ip conserve mode enabled","name":"networkofferingconservemode","type":"boolean"},{"description":"the physical network id","name":"physicalnetworkid","type":"string"},{"description":"the second DNS for the network","name":"dns2","type":"string"},{"description":"the network's gateway","name":"gateway","type":"string"},{"description":"the id of the network","name":"id","type":"string"},{"description":"name of the network offering the network is created from","name":"networkofferingname","type":"string"},{"description":"the owner of the network","name":"account","type":"string"},{"description":"list networks available for vm deployment","name":"canusefordeploy","type":"boolean"},{"description":"the traffic type of the network","name":"traffictype","type":"string"},{"description":"broadcast uri of the network. This parameter is visible to ROOT admins only","name":"broadcasturi","type":"string"},{"description":"the project name of the address","name":"project","type":"string"},{"description":"true network requires restart","name":"restartrequired","type":"boolean"},{"description":"acl type - access type to the network","name":"acltype","type":"string"},{"description":"the domain name of the network owner","name":"domain","type":"string"}]},{"description":"Removes a Guest OS from listing.","isasync":true,"name":"removeGuestOs","params":[{"description":"ID of the guest OS","length":255,"name":"id","related":"addGuestOs","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}],"since":"4.4.0"},{"description":"Detaches any ISO file (if any) currently attached to a virtual machine.","isasync":true,"name":"detachIso","params":[{"description":"The ID of the virtual machine","length":255,"name":"virtualmachineid","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,detachIso,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":true,"type":"uuid"}],"related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","response":[{"description":"list of affinity groups associated with the virtual machine","name":"affinitygroup","response":[{"description":"the ID of the affinity group","name":"id","type":"string"},{"description":"the name of the affinity group","name":"name","type":"string"},{"description":"the description of the affinity group","name":"description","type":"string"},{"description":"the account owning the affinity group","name":"account","type":"string"},{"description":"the project ID of the affinity group","name":"projectid","type":"string"},{"description":"the type of the affinity group","name":"type","type":"string"},{"description":"the domain name of the affinity group","name":"domain","type":"string"},{"description":"virtual machine IDs associated with this affinity group","name":"virtualmachineIds","type":"list"},{"description":"the domain ID of the affinity group","name":"domainid","type":"string"},{"description":"the project name of the affinity group","name":"project","type":"string"}],"type":"set"},{"description":"true if vm contains XS/VMWare tools inorder to support dynamic scaling of VM cpu/memory.","name":"isdynamicallyscalable","type":"boolean"},{"description":"the name of the availability zone for the virtual machine","name":"zonename","type":"string"},{"description":"user generated name. The name of the virtual machine is returned if no displayname exists.","name":"displayname","type":"string"},{"description":"ssh key-pair","name":"keypair","type":"string"},{"description":"the target memory in vm","name":"memorytargetkbs","type":"long"},{"description":"list of security groups associated with the virtual machine","name":"securitygroup","response":[{"description":"the ID of the security group","name":"id","type":"string"},{"description":"the domain name of the security group","name":"domain","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"}],"type":"set"},{"description":"the description of the security group","name":"description","type":"string"},{"description":"the number of virtualmachines associated with this securitygroup","name":"virtualmachinecount","type":"integer"},{"description":"the account owning the security group","name":"account","type":"string"},{"description":"the project name of the group","name":"project","type":"string"},{"description":"the list of egress rules associated with the security group","name":"egressrule","response":[{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"tag key name","name":"key","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"}],"type":"set"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"},{"description":"the id of the security group rule","name":"ruleid","type":"string"}],"type":"set"},{"description":"the name of the security group","name":"name","type":"string"},{"description":"the project id of the group","name":"projectid","type":"string"},{"description":"the domain ID of the security group","name":"domainid","type":"string"},{"description":"the list of ingress rules associated with the security group","name":"ingressrule","response":[{"description":"the ending IP of the security group rule ","name":"endport","type":"integer"},{"description":"the type of the ICMP message response","name":"icmptype","type":"integer"},{"description":"the id of the security group rule","name":"ruleid","type":"string"},{"description":"the list of resource tags associated with the rule","name":"tags","response":[{"description":"tag key name","name":"key","type":"string"},{"description":"resource type","name":"resourcetype","type":"string"},{"description":"the account associated with the tag","name":"account","type":"string"},{"description":"the project id the tag belongs to","name":"projectid","type":"string"},{"description":"the ID of the domain associated with the tag","name":"domainid","type":"string"},{"description":"tag value","name":"value","type":"string"},{"description":"id of the resource","name":"resourceid","type":"string"},{"description":"the domain associated with the tag","name":"domain","type":"string"},{"description":"customer associated with the tag","name":"customer","type":"string"},{"description":"the project name where tag belongs to","name":"project","type":"string"}],"type":"set"},{"description":"the CIDR notation for the base IP address of the security group rule","name":"cidr","type":"string"},{"description":"the starting IP of the security group rule","name":"startport","type":"integer"},{"description":"the code for the ICMP message response","name":"icmpcode","type":"integer"},{"description":"security group name","name":"securitygroupname","type":"string"},{"description":"the protocol of the security group rule","name":"protocol","type":"string"},{"description":"account owning the security group rule","name":"account","type":"string"}],"type":"set"},{"description":"the list of virtualmachine ids associated with this securitygroup","name":"virtualmachineids","type":"set"}],"type":"set"},{"description":"the read (io) of disk on the vm","name":"diskioread","type":"long"},{"description":"the name of the host for the virtual machine","name":"hostname","type":"string"},{"description":"the hypervisor on which the template runs","name":"hypervisor","type":"string"},{},{"description":"the group name of the virtual machine","name":"group","type":"string"},{"description":"the user's name who deployed the virtual machine","name":"username","type":"string"},{"description":"the ID of the domain in which the virtual machine exists","name":"domainid","type":"string"},{"description":"the speed of each cpu","name":"cpuspeed","type":"integer"},{"description":"the account associated with the virtual machine","name":"account","type":"string"},{"description":"the ID of the service offering of the virtual machine","name":"serviceofferingid","type":"string"},{"description":"the date when this virtual machine was created","name":"created","type":"date"},{"description":"the list of nics associated with vm","name":"nic","response":[{"description":"the IPv6 address of network","name":"ip6address","type":"string"},{"description":"the ip address of the nic","name":"ipaddress","type":"string"},{"description":"Id of the NSX Logical Switch Port (if NSX based), null otherwise","name":"nsxlogicalswitchport","type":"string"},{"description":"true if nic is default, false otherwise","name":"isdefault","type":"boolean"},{"description":"the broadcast uri of the nic","name":"broadcasturi","type":"string"},{"description":"the type of the nic","name":"type","type":"string"},{"description":"true if nic is default, false otherwise","name":"macaddress","type":"string"},{"description":"the gateway of IPv6 network","name":"ip6gateway","type":"string"},{"description":"the extra dhcp options on the nic","name":"extradhcpoption","type":"list"},{"description":"the traffic type of the nic","name":"traffictype","type":"string"},{"description":"the gateway of the nic","name":"gateway","type":"string"},{"description":"the isolation uri of the nic","name":"isolationuri","type":"string"},{"description":"Id of the vm to which the nic belongs","name":"virtualmachineid","type":"string"},{"description":"Id of the NSX Logical Switch (if NSX based), null otherwise","name":"nsxlogicalswitch","type":"string"},{"description":"the ID of the nic","name":"id","type":"string"},{"description":"the netmask of the nic","name":"netmask","type":"string"},{"description":"device id for the network when plugged into the virtual machine","name":"deviceid","type":"string"},{"description":"the name of the corresponding network","name":"networkname","type":"string"},{"description":"the cidr of IPv6 network","name":"ip6cidr","type":"string"},{"description":"the ID of the corresponding network","name":"networkid","type":"string"},{"description":"the Secondary ipv4 addr of nic","name":"secondaryip","type":"list"}],"type":"set"},{"description":"the ID of the disk offering of the virtual machine","name":"diskofferingid","type":"string"},{"description":"the name of the domain in which the virtual machine exists","name":"domain","type":"string"},{"description":"the amount of the vm's CPU currently used","name":"cpuused","type":"string"},{"description":"the project id of the vm","name":"projectid","type":"string"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicipid","type":"string"},{"description":"device type of the root volume","name":"rootdevicetype","type":"string"},{"description":"the name of the virtual machine","name":"name","type":"string"},{"description":"the name of the service offering of the virtual machine","name":"serviceofferingname","type":"string"},{"description":"the name of the disk offering of the virtual machine","name":"diskofferingname","type":"string"},{"description":"the ID of the host for the virtual machine","name":"hostid","type":"string"},{"description":"the number of cpu this virtual machine is running with","name":"cpunumber","type":"integer"},{"description":"the incoming network traffic on the vm","name":"networkkbsread","type":"long"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the write (bytes) of disk on the vm","name":"diskkbswrite","type":"long"},{"description":"the memory allocated for the virtual machine","name":"memory","type":"integer"},{"description":"State of the Service from LB rule","name":"servicestate","type":"string"},{"description":"Vm details in key/value pairs.","name":"details","type":"map"},{"description":"the ID of the virtual machine","name":"id","type":"string"},{"description":"the ID of the ISO attached to the virtual machine","name":"isoid","type":"string"},{"description":"OS type id of the vm","name":"ostypeid","type":"long"},{"description":"the internal memory thats free in vm","name":"memoryintfreekbs","type":"long"},{"description":"the virtual network for the service offering","name":"forvirtualnetwork","type":"boolean"},{"description":"public IP address id associated with vm via Static nat rule","name":"publicip","type":"string"},{"description":"the read (bytes) of disk on the vm","name":"diskkbsread","type":"long"},{"description":"the memory used by the vm","name":"memorykbs","type":"long"},{"description":"the name of the ISO attached to the virtual machine","name":"isoname","type":"string"},{"description":"device ID of the root volume","name":"rootdeviceid","type":"long"},{"description":"the ID of the availablility zone for the virtual machine","name":"zoneid","type":"string"},{"description":"the ID of the template for the virtual machine. A -1 is returned if the virtual machine was created from an ISO file.","name":"templateid","type":"string"},{"description":"Os type ID of the virtual machine","name":"guestosid","type":"string"},{"description":" an alternate display text of the template for the virtual machine","name":"templatedisplaytext","type":"string"},{"description":"true if high-availability is enabled, false otherwise","name":"haenable","type":"boolean"},{"description":"the group ID of the virtual machine","name":"groupid","type":"string"},{"description":"instance name of the user vm; this parameter is returned to the ROOT admin only","name":"instancename","type":"string"},{"description":"the project name of the vm","name":"project","type":"string"},{"description":"true if the password rest feature is enabled, false otherwise","name":"passwordenabled","type":"boolean"},{"description":"an optional field whether to the display the vm to the end user or not.","name":"displayvm","type":"boolean"},{"description":"an alternate display text of the ISO attached to the virtual machine","name":"isodisplaytext","type":"string"},{"description":"the user's ID who deployed the virtual machine","name":"userid","type":"string"},{"description":"the name of the template for the virtual machine","name":"templatename","type":"string"},{"description":"the write (io) of disk on the vm","name":"diskiowrite","type":"long"},{"description":"the vgpu type used by the virtual machine","name":"vgpu","type":"string"},{"description":"the password (if exists) of the virtual machine","name":"password","type":"string"},{"description":"the state of the virtual machine","name":"state","type":"string"}]},{"description":" delete a Palo Alto firewall device","isasync":true,"name":"deletePaloAltoFirewall","params":[{"description":"Palo Alto firewall device ID","length":255,"name":"fwdeviceid","related":"configurePaloAltoFirewall,listPaloAltoFirewalls,addPaloAltoFirewall","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Deletes a Pod.","isasync":false,"name":"deletePod","params":[{"description":"the ID of the Pod","length":255,"name":"id","related":"updatePod,createManagementNetworkIpRange","required":true,"type":"uuid"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Lists all DeploymentPlanners available.","isasync":false,"name":"listDeploymentPlanners","params":[{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"","length":255,"name":"page","required":false,"type":"integer"}],"related":"","response":[{"description":"Deployment Planner name","name":"name","type":"string"}]},{"description":"Creates a role","isasync":false,"name":"createRole","params":[{"description":"The type of the role, valid options are: Admin, ResourceAdmin, DomainAdmin, User","length":255,"name":"type","required":true,"type":"string"},{"description":"The description of the role","length":255,"name":"description","required":false,"type":"string"},{"description":"creates a role with this unique name","length":255,"name":"name","required":true,"type":"string"}],"related":"listRoles,updateRole","response":[{"description":"the name of the role","name":"name","type":"string"},{"description":"the ID of the role","name":"id","type":"string"},{"description":"the type of the role","name":"type","type":"string"},{"description":"the description of the role","name":"description","type":"string"}],"since":"4.9.0"},{"description":"Prepares a host for maintenance.","isasync":true,"name":"prepareHostForMaintenance","params":[{"description":"the host ID","length":255,"name":"id","related":"addHost,reconnectHost,addBaremetalHost,prepareHostForMaintenance,cancelHostMaintenance","required":true,"type":"uuid"}],"related":"addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance","response":[{"description":"the Pod name of the host","name":"podname","type":"string"},{"description":"the cluster ID of the host","name":"clusterid","type":"string"},{"description":"events available for the host","name":"events","type":"string"},{"description":"the host version","name":"version","type":"string"},{"description":"the Zone name of the host","name":"zonename","type":"string"},{"description":"the Zone ID of the host","name":"zoneid","type":"string"},{"description":"the memory total of the host, this parameter is deprecated use memorywithoverprovisioning","name":"memorytotal","type":"long"},{"description":"the cpu average load on the host","name":"averageload","type":"long"},{"description":"the outgoing network traffic on the host","name":"networkkbswrite","type":"long"},{"description":"the hypervisor version","name":"hypervisorversion","type":"string"},{"description":"the host's currently allocated disk size","name":"disksizeallocated","type":"long"},{"description":"Host details in key/value pairs.","name":"details","type":"map"},{"description":"the incoming network traffic on the host","name":"networkkbsread","type":"long"},{"description":"the last annotation set on this host by an admin","name":"annotation","type":"string"},{"description":"true if this host is suitable(has enough capacity and satisfies all conditions like hosttags, max guests vm limit etc) to migrate a VM to it , false otherwise","name":"suitableformigration","type":"boolean"},{"description":"the ID of the host","name":"id","type":"string"},{"description":"the host hypervisor","name":"hypervisor","type":"hypervisortype"},{"description":"true if local storage is active, false otherwise","name":"islocalstorageactive","type":"boolean"},{"description":"true if the host is Ha host (dedicated to vms started by HA process; false otherwise","name":"hahost","type":"boolean"},{"description":"the cluster type of the cluster that host belongs to","name":"clustertype","type":"string"},{"description":"the CPU speed of the host","name":"cpuspeed","type":"long"},{"description":"the amount of the host's memory after applying the mem.overprovisioning.factor","name":"memorywithoverprovisioning","type":"string"},{"description":"the last time this host was annotated","name":"lastannotated","type":"date"},{"description":"the cluster name of the host","name":"clustername","type":"string"},{"description":"the total disk size of the host","name":"disksizetotal","type":"long"},{"description":"the management server ID of the host","name":"managementserverid","type":"long"},{"description":"capabilities of the host","name":"capabilities","type":"string"},{"description":"the state of the host","name":"state","type":"status"},{"description":"GPU cards present in the host","name":"gpugroup","response":[{"description":"GPU cards present in the host","name":"gpugroupname","type":"string"},{"description":"the list of enabled vGPUs","name":"vgpu","response":[{"description":"Maximum vgpu can be created with this vgpu type on the given gpu group","name":"maxcapacity","type":"long"},{"description":"Maximum X resolution per display","name":"maxresolutionx","type":"long"},{"description":"Model Name of vGPU","name":"vgputype","type":"string"},{"description":"Video RAM for this vGPU type","name":"videoram","type":"long"},{"description":"Maximum no. of vgpu per gpu card (pgpu)","name":"maxvgpuperpgpu","type":"long"},{"description":"Remaining capacity in terms of no. of more VMs that can be deployped with this vGPU type","name":"remainingcapacity","type":"long"},{"description":"Maximum displays per user","name":"maxheads","type":"long"},{"description":"Maximum Y resolution per display","name":"maxresolutiony","type":"long"}],"type":"list"}],"type":"list"},{"description":"the admin that annotated this host","name":"username","type":"string"},{"description":"comma-separated list of tags for the host","name":"hosttags","type":"string"},{"description":"the host HA information information","name":"hostha","type":"hostharesponse"},{"description":"the OS category name of the host","name":"oscategoryname","type":"string"},{"description":"true if this host has enough CPU and RAM capacity to migrate a VM to it, false otherwise","name":"hasenoughcapacity","type":"boolean"},{"description":"the CPU number of the host","name":"cpunumber","type":"integer"},{"description":"the host out-of-band management information","name":"outofbandmanagement","type":"outofbandmanagementresponse"},{"description":"the amount of the host's memory currently allocated","name":"memoryallocated","type":"long"},{"description":"the date and time the host was last pinged","name":"lastpinged","type":"date"},{"description":"the number of CPU sockets on the host","name":"cpusockets","type":"integer"},{"description":"the amount of the host's CPU currently allocated","name":"cpuallocated","type":"string"},{"description":"the amount of the host's CPU currently used","name":"cpuused","type":"string"},{"description":"true if the host is disconnected. False otherwise.","name":"disconnected","type":"date"},{"description":"the amount of the host's memory currently used","name":"memoryused","type":"long"},{"description":"the host type","name":"type","type":"type"},{"description":"the amount of the host's CPU after applying the cpu.overprovisioning.factor ","name":"cpuwithoverprovisioning","type":"string"},{"description":"the date and time the host was removed","name":"removed","type":"date"},{"description":"the Pod ID of the host","name":"podid","type":"string"},{"description":"the date and time the host was created","name":"created","type":"date"},{"description":"the name of the host","name":"name","type":"string"},{"description":"the IP address of the host","name":"ipaddress","type":"string"},{"description":"the OS category ID of the host","name":"oscategoryid","type":"string"},{"description":"the resource state of the host","name":"resourcestate","type":"string"}]},{"description":"Deletes a cluster.","isasync":false,"name":"deleteCluster","params":[{"description":"the cluster ID","length":255,"name":"id","related":"addCluster,updateCluster","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"Removes specified region","isasync":false,"name":"removeRegion","params":[{"description":"ID of the region to delete","length":255,"name":"id","required":true,"type":"integer"}],"response":[{"description":"true if operation is executed successfully","name":"success","type":"boolean"},{"description":"any text associated with the success or failure","name":"displaytext","type":"string"}]},{"description":"Get Volume's iSCSI Name","isasync":false,"name":"getVolumeiScsiName","params":[{"description":"CloudStack Volume UUID","length":255,"name":"volumeid","required":true,"type":"string"}],"related":"","response":[{"description":"Volume iSCSI Name","name":"volumeiScsiName","type":"string"}]},{"description":"Upload a data disk to the cloudstack cloud.","isasync":false,"name":"getUploadParamsForVolume","params":[{"description":"the checksum value of this volume/template The parameter containing the checksum will be considered a MD5sum if it is not prefixed\n and just a plain ascii/utf8 representation of a hexadecimal string. If it is required to\n use another algorithm the hexadecimal string is to be prefixed with a string of the form,\n \"{\u003calgorithm\u003e}\", not including the double quotes. In this \u003calgorithm\u003e is the exact string\n representing the java supported algorithm, i.e. MD5 or SHA-256. Note that java does not\n contain an algorithm called SHA256 or one called sha-256, only SHA-256.","length":255,"name":"checksum","required":false,"type":"string"},{"description":"Upload volume/template for the project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"an optional domainId. If the account parameter is used, domainId must also be used.","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"Image store uuid","length":255,"name":"imagestoreuuid","required":false,"type":"string"},{"description":"the ID of the zone the volume/template is to be hosted on","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":true,"type":"uuid"},{"description":"an optional accountName. Must be used with domainId.","length":255,"name":"account","required":false,"type":"string"},{"description":"the format for the volume/template. Possible values include QCOW2, OVA, and VHD.","length":255,"name":"format","required":true,"type":"string"},{"description":"the ID of the disk offering. This must be a custom sized offering since during upload of volume/template size is unknown.","length":255,"name":"diskofferingid","related":"listDiskOfferings,createDiskOffering","required":false,"type":"uuid"},{"description":"the name of the volume/template","length":255,"name":"name","required":true,"type":"string"}],"related":"getUploadParamsForTemplate","response":[{"description":"signature to be sent in the POST request.","name":"signature","type":"string"},{"description":"POST url to upload the file to","name":"postURL","type":"url"},{"description":"the template/volume ID","name":"id","type":"uuid"},{"description":"the timestamp after which the signature expires","name":"expires","type":"string"},{"description":"encrypted data to be sent in the POST request.","name":"metadata","type":"string"}],"since":"4.6.0"},{"description":"Updates an existing autoscale vm group.","isasync":true,"name":"updateAutoScaleVmGroup","params":[{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"the frequency at which the conditions have to be evaluated","length":255,"name":"interval","required":false,"type":"integer"},{"description":"the ID of the autoscale group","length":255,"name":"id","related":"updateAutoScaleVmGroup,enableAutoScaleVmGroup,listAutoScaleVmGroups","required":true,"type":"uuid"},{"description":"list of scaleup autoscale policies","length":255,"name":"scaleuppolicyids","related":"updateAutoScalePolicy,listAutoScalePolicies","required":false,"type":"list"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","length":255,"name":"maxmembers","required":false,"type":"integer"},{"description":"list of scaledown autoscale policies","length":255,"name":"scaledownpolicyids","related":"updateAutoScalePolicy,listAutoScalePolicies","required":false,"type":"list"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","length":255,"name":"minmembers","required":false,"type":"integer"},{"description":"an optional field, whether to the display the group to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"}],"related":"enableAutoScaleVmGroup,listAutoScaleVmGroups","response":[{"description":"the domain name of the vm profile","name":"domain","type":"string"},{"description":"the load balancer rule ID","name":"lbruleid","type":"string"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","name":"minmembers","type":"int"},{"description":"list of scaledown autoscale policies","name":"scaledownpolicies","type":"list"},{"description":"list of scaleup autoscale policies","name":"scaleuppolicies","type":"list"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"the autoscale profile that contains information about the vms in the vm group.","name":"vmprofileid","type":"string"},{"description":"the frequency at which the conditions have to be evaluated","name":"interval","type":"int"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","name":"maxmembers","type":"int"},{"description":"the current state of the AutoScale Vm Group","name":"state","type":"string"},{"description":"is group for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the project id vm profile","name":"projectid","type":"string"},{"description":"the autoscale vm group ID","name":"id","type":"string"},{"description":"the project name of the vm profile","name":"project","type":"string"},{"description":"the domain ID of the vm profile","name":"domainid","type":"string"}]},{"description":"Updates an existing autoscale vm profile.","isasync":true,"name":"updateAutoScaleVmProfile","params":[{"description":"an optional field, in case you want to set a custom id to the resource. Allowed to Root Admins only","length":255,"name":"customid","required":false,"since":"4.4","type":"string"},{"description":"the time allowed for existing connections to get closed before a vm is destroyed","length":255,"name":"destroyvmgraceperiod","required":false,"type":"integer"},{"description":"an optional field, whether to the display the profile to the end user or not","length":255,"name":"fordisplay","required":false,"since":"4.4","type":"boolean"},{"description":"the ID of the autoscale vm profile","length":255,"name":"id","related":"updateAutoScaleVmProfile,listAutoScaleVmProfiles,createAutoScaleVmProfile","required":true,"type":"uuid"},{"description":"counterparam list. Example: counterparam[0].name=snmpcommunity\u0026counterparam[0].value=public\u0026counterparam[1].name=snmpport\u0026counterparam[1].value=161","length":255,"name":"counterparam","required":false,"type":"map"},{"description":"the template of the auto deployed virtual machine","length":255,"name":"templateid","related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,listIsos,copyTemplate,copyIso,createTemplate","required":false,"type":"uuid"},{"description":"the ID of the user used to launch and destroy the VMs","length":255,"name":"autoscaleuserid","related":"lockUser,createUser,getUser,enableUser,disableUser,updateUser,listUsers","required":false,"type":"uuid"}],"related":"listAutoScaleVmProfiles,createAutoScaleVmProfile","response":[{"description":"is profile for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the domain name of the vm profile","name":"domain","type":"string"},{"description":"the project id vm profile","name":"projectid","type":"string"},{"description":"parameters other than zoneId/serviceOfferringId/templateId to be used while deploying a virtual machine","name":"otherdeployparams","type":"string"},{"description":"the project name of the vm profile","name":"project","type":"string"},{},{"description":"the service offering to be used while deploying a virtual machine","name":"serviceofferingid","type":"string"},{"description":"the template to be used while deploying a virtual machine","name":"templateid","type":"string"},{"description":"the domain ID of the vm profile","name":"domainid","type":"string"},{"description":"the autoscale vm profile ID","name":"id","type":"string"},{"description":"the time allowed for existing connections to get closed before a vm is destroyed","name":"destroyvmgraceperiod","type":"integer"},{"description":"the ID of the user used to launch and destroy the VMs","name":"autoscaleuserid","type":"string"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"the availability zone to be used while deploying a virtual machine","name":"zoneid","type":"string"},{}]},{"description":"Enables an AutoScale Vm Group","isasync":true,"name":"enableAutoScaleVmGroup","params":[{"description":"the ID of the autoscale group","length":255,"name":"id","related":"enableAutoScaleVmGroup,listAutoScaleVmGroups","required":true,"type":"uuid"}],"related":"listAutoScaleVmGroups","response":[{"description":"the autoscale profile that contains information about the vms in the vm group.","name":"vmprofileid","type":"string"},{"description":"the project id vm profile","name":"projectid","type":"string"},{"description":"the minimum number of members in the vmgroup, the number of instances in the vm group will be equal to or more than this number.","name":"minmembers","type":"int"},{"description":"the autoscale vm group ID","name":"id","type":"string"},{"description":"the account owning the instance group","name":"account","type":"string"},{"description":"the project name of the vm profile","name":"project","type":"string"},{"description":"is group for display to the regular user","name":"fordisplay","type":"boolean"},{"description":"the maximum number of members in the vmgroup, The number of instances in the vm group will be equal to or less than this number.","name":"maxmembers","type":"int"},{"description":"the frequency at which the conditions have to be evaluated","name":"interval","type":"int"},{"description":"list of scaledown autoscale policies","name":"scaledownpolicies","type":"list"},{"description":"list of scaleup autoscale policies","name":"scaleuppolicies","type":"list"},{"description":"the domain ID of the vm profile","name":"domainid","type":"string"},{"description":"the domain name of the vm profile","name":"domain","type":"string"},{"description":"the current state of the AutoScale Vm Group","name":"state","type":"string"},{"description":"the load balancer rule ID","name":"lbruleid","type":"string"}]},{"description":"Deletes a snapshot of a disk volume.","isasync":true,"name":"deleteSnapshot","params":[{"description":"The ID of the snapshot","length":255,"name":"id","related":"revertSnapshot","required":true,"type":"uuid"}],"response":[{"description":"any text associated with the success or failure","name":"displaytext","type":"string"},{"description":"true if operation is executed successfully","name":"success","type":"boolean"}]},{"description":"List the virtual machines owned by the account.","isasync":false,"name":"listVirtualMachines","params":[{"description":"list by network type; true if need to list vms using Virtual Network, false otherwise","length":255,"name":"forvirtualnetwork","required":false,"type":"boolean"},{"description":"the host ID","length":255,"name":"hostid","related":"addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"list by network id","length":255,"name":"networkid","related":"listBrocadeVcsDeviceNetworks,listF5LoadBalancerNetworks,migrateNetwork,listNetworks,createNetwork,listNetscalerLoadBalancerNetworks,createNetwork,updateNetwork","required":false,"type":"uuid"},{"description":"list objects by project","length":255,"name":"projectid","related":"updateProject,activateProject,listProjects,suspendProject,listProjectAccounts","required":false,"type":"uuid"},{"description":"the storage ID where vm's volumes belong to","length":255,"name":"storageid","related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"state of the virtual machine. Possible values are: Running, Stopped, Present, Destroyed, Expunged. Present is used for the state equal not destroyed.","length":255,"name":"state","required":false,"type":"string"},{"description":"list by the service offering","length":255,"name":"serviceofferingid","related":"updateServiceOffering,listServiceOfferings","required":false,"since":"4.4","type":"uuid"},{"description":"","length":255,"name":"pagesize","required":false,"type":"integer"},{"description":"list resources by account. Must be used with the domainId parameter.","length":255,"name":"account","required":false,"type":"string"},{"description":"comma separated list of host details requested, value can be a list of [all, group, nics, stats, secgrp, tmpl, servoff, diskoff, iso, volume, min, affgrp]. If no parameter is passed in, the details will be defaulted to all","length":255,"name":"details","required":false,"type":"list"},{"description":"the group ID","length":255,"name":"groupid","related":"createInstanceGroup","required":false,"type":"uuid"},{"description":"name of the virtual machine (a substring match is made against the parameter value, data for all matching VMs will be returned)","length":255,"name":"name","required":false,"type":"string"},{"description":"the storage ID where vm's volumes belong to","length":255,"name":"storageid","related":"findStoragePoolsForMigration,createStoragePool,cancelStorageMaintenance,enableStorageMaintenance","required":false,"type":"uuid"},{"description":"list vms by ssh keypair name","length":255,"name":"keypair","required":false,"type":"string"},{"description":"the pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"the ID of the virtual machine","length":255,"name":"id","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":false,"type":"uuid"},{"description":"list resources by display flag; only ROOT admin is eligible to pass this parameter","length":255,"name":"displayvm","required":false,"since":"4.4","type":"boolean"},{"description":"List resources by tags (key/value pairs)","length":255,"name":"tags","required":false,"type":"map"},{"description":"defaults to false, but if true, lists all resources from the parent specified by the domainId till leaves.","length":255,"name":"isrecursive","required":false,"type":"boolean"},{"description":"List by keyword","length":255,"name":"keyword","required":false,"type":"string"},{"description":"list vms by vpc","length":255,"name":"vpcid","related":"restartVPC,createVPC,updateVPC,listVPCs,migrateVPC,listVPCs","required":false,"type":"uuid"},{"description":"the target hypervisor for the template","length":255,"name":"hypervisor","required":false,"type":"string"},{"description":"the availability zone ID","length":255,"name":"zoneid","related":"listZones,listZones,createZone,updateZone","required":false,"type":"uuid"},{"description":"list vms by affinity group","length":255,"name":"affinitygroupid","related":"","required":false,"type":"uuid"},{"description":"list vms by iso","length":255,"name":"isoid","required":false,"type":"uuid"},{"description":"the host ID","length":255,"name":"hostid","related":"addHost,reconnectHost,addBaremetalHost,cancelHostMaintenance","required":false,"type":"uuid"},{"description":"list vms by template","length":255,"name":"templateid","related":"registerTemplate,listTemplates,listIsos,registerTemplate,registerIso,registerIso,listIsos,copyTemplate,copyIso,createTemplate","required":false,"type":"uuid"},{"description":"the user ID that created the VM and is under the account that owns the VM","length":255,"name":"userid","related":"lockUser,createUser,getUser,enableUser,disableUser,updateUser,listUsers","required":false,"type":"uuid"},{"description":"the pod ID","length":255,"name":"podid","related":"updatePod,createManagementNetworkIpRange","required":false,"type":"uuid"},{"description":"","length":255,"name":"page","required":false,"type":"integer"},{"description":"list only resources belonging to the domain specified","length":255,"name":"domainid","related":"listDomains,listDomainChildren","required":false,"type":"uuid"},{"description":"the IDs of the virtual machines, mutually exclusive with id","length":255,"name":"ids","related":"attachIso,destroyVirtualMachine,updateVMAffinityGroup,deployVirtualMachine,stopVirtualMachine,resetPasswordForVirtualMachine,migrateVirtualMachineWithVolume,removeNicFromVirtualMachine,recoverVirtualMachine,updateVMAffinityGroup,addNicToVirtualMachine,removeNicFromVirtualMachine,startVirtualMachine,revertToVMSnapshot,attachIso,restoreVirtualMachine,updateDefaultNicForVirtualMachine,updateVirtualMachine,rebootVirtualMachine,listVirtualMachines,resetSSHKeyForVirtualMachine,revertToVMSnapshot,detachIso,changeServiceForVirtualMachine,startVirtualMachine,listVirtualMachines,stopVirtualMachine,deployVirtualMachine,destroyVirtualMachine","required":false,"since":"4.4","type":"list"},{"description":"If set to false, list only resources belonging to the command's caller; if set to true - list resources that the caller is authorized to see. Default value is false","length":255,"name":"listall","required":false,"type":"boolea