// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package grafeas_go_proto

import (
	context "context"
	empty "github.com/golang/protobuf/ptypes/empty"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion7

// GrafeasClient is the client API for Grafeas service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GrafeasClient interface {
	// Gets the specified occurrence.
	GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Gets the specified note.
	GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error)
}

type grafeasClient struct {
	cc grpc.ClientConnInterface
}

func NewGrafeasClient(cc grpc.ClientConnInterface) GrafeasClient {
	return &grafeasClient{cc}
}

func (c *grafeasClient) GetOccurrence(ctx context.Context, in *GetOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListOccurrences(ctx context.Context, in *ListOccurrencesRequest, opts ...grpc.CallOption) (*ListOccurrencesResponse, error) {
	out := new(ListOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) DeleteOccurrence(ctx context.Context, in *DeleteOccurrenceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/DeleteOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) CreateOccurrence(ctx context.Context, in *CreateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/CreateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) BatchCreateOccurrences(ctx context.Context, in *BatchCreateOccurrencesRequest, opts ...grpc.CallOption) (*BatchCreateOccurrencesResponse, error) {
	out := new(BatchCreateOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/BatchCreateOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) UpdateOccurrence(ctx context.Context, in *UpdateOccurrenceRequest, opts ...grpc.CallOption) (*Occurrence, error) {
	out := new(Occurrence)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/UpdateOccurrence", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) GetOccurrenceNote(ctx context.Context, in *GetOccurrenceNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetOccurrenceNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) GetNote(ctx context.Context, in *GetNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/GetNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListNotes(ctx context.Context, in *ListNotesRequest, opts ...grpc.CallOption) (*ListNotesResponse, error) {
	out := new(ListNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) DeleteNote(ctx context.Context, in *DeleteNoteRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/DeleteNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) CreateNote(ctx context.Context, in *CreateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/CreateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) BatchCreateNotes(ctx context.Context, in *BatchCreateNotesRequest, opts ...grpc.CallOption) (*BatchCreateNotesResponse, error) {
	out := new(BatchCreateNotesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/BatchCreateNotes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) UpdateNote(ctx context.Context, in *UpdateNoteRequest, opts ...grpc.CallOption) (*Note, error) {
	out := new(Note)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/UpdateNote", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *grafeasClient) ListNoteOccurrences(ctx context.Context, in *ListNoteOccurrencesRequest, opts ...grpc.CallOption) (*ListNoteOccurrencesResponse, error) {
	out := new(ListNoteOccurrencesResponse)
	err := c.cc.Invoke(ctx, "/grafeas.v1.Grafeas/ListNoteOccurrences", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GrafeasServer is the server API for Grafeas service.
// All implementations should embed UnimplementedGrafeasServer
// for forward compatibility
type GrafeasServer interface {
	// Gets the specified occurrence.
	GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error)
	// Lists occurrences for the specified project.
	ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error)
	// Deletes the specified occurrence. For example, use this method to delete an
	// occurrence when the occurrence is no longer applicable for the given
	// resource.
	DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*empty.Empty, error)
	// Creates a new occurrence.
	CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error)
	// Creates new occurrences in batch.
	BatchCreateOccurrences(context.Context, *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error)
	// Updates the specified occurrence.
	UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error)
	// Gets the note attached to the specified occurrence. Consumer projects can
	// use this method to get a note that belongs to a provider project.
	GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error)
	// Gets the specified note.
	GetNote(context.Context, *GetNoteRequest) (*Note, error)
	// Lists notes for the specified project.
	ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error)
	// Deletes the specified note.
	DeleteNote(context.Context, *DeleteNoteRequest) (*empty.Empty, error)
	// Creates a new note.
	CreateNote(context.Context, *CreateNoteRequest) (*Note, error)
	// Creates new notes in batch.
	BatchCreateNotes(context.Context, *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error)
	// Updates the specified note.
	UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error)
	// Lists occurrences referencing the specified note. Provider projects can use
	// this method to get all occurrences across consumer projects referencing the
	// specified note.
	ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error)
}

// UnimplementedGrafeasServer should be embedded to have forward compatible implementations.
type UnimplementedGrafeasServer struct {
}

func (UnimplementedGrafeasServer) GetOccurrence(context.Context, *GetOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrence not implemented")
}
func (UnimplementedGrafeasServer) ListOccurrences(context.Context, *ListOccurrencesRequest) (*ListOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOccurrences not implemented")
}
func (UnimplementedGrafeasServer) DeleteOccurrence(context.Context, *DeleteOccurrenceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOccurrence not implemented")
}
func (UnimplementedGrafeasServer) CreateOccurrence(context.Context, *CreateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOccurrence not implemented")
}
func (UnimplementedGrafeasServer) BatchCreateOccurrences(context.Context, *BatchCreateOccurrencesRequest) (*BatchCreateOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateOccurrences not implemented")
}
func (UnimplementedGrafeasServer) UpdateOccurrence(context.Context, *UpdateOccurrenceRequest) (*Occurrence, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOccurrence not implemented")
}
func (UnimplementedGrafeasServer) GetOccurrenceNote(context.Context, *GetOccurrenceNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOccurrenceNote not implemented")
}
func (UnimplementedGrafeasServer) GetNote(context.Context, *GetNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNote not implemented")
}
func (UnimplementedGrafeasServer) ListNotes(context.Context, *ListNotesRequest) (*ListNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotes not implemented")
}
func (UnimplementedGrafeasServer) DeleteNote(context.Context, *DeleteNoteRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNote not implemented")
}
func (UnimplementedGrafeasServer) CreateNote(context.Context, *CreateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNote not implemented")
}
func (UnimplementedGrafeasServer) BatchCreateNotes(context.Context, *BatchCreateNotesRequest) (*BatchCreateNotesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateNotes not implemented")
}
func (UnimplementedGrafeasServer) UpdateNote(context.Context, *UpdateNoteRequest) (*Note, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNote not implemented")
}
func (UnimplementedGrafeasServer) ListNoteOccurrences(context.Context, *ListNoteOccurrencesRequest) (*ListNoteOccurrencesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNoteOccurrences not implemented")
}

// UnsafeGrafeasServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GrafeasServer will
// result in compilation errors.
type UnsafeGrafeasServer interface {
	mustEmbedUnimplementedGrafeasServer()
}

func RegisterGrafeasServer(s grpc.ServiceRegistrar, srv GrafeasServer) {
	s.RegisterService(&_Grafeas_serviceDesc, srv)
}

func _Grafeas_GetOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetOccurrence(ctx, req.(*GetOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListOccurrences(ctx, req.(*ListOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_DeleteOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).DeleteOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/DeleteOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).DeleteOccurrence(ctx, req.(*DeleteOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_CreateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).CreateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/CreateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).CreateOccurrence(ctx, req.(*CreateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_BatchCreateOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).BatchCreateOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/BatchCreateOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).BatchCreateOccurrences(ctx, req.(*BatchCreateOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_UpdateOccurrence_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOccurrenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).UpdateOccurrence(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/UpdateOccurrence",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).UpdateOccurrence(ctx, req.(*UpdateOccurrenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_GetOccurrenceNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOccurrenceNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetOccurrenceNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetOccurrenceNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetOccurrenceNote(ctx, req.(*GetOccurrenceNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_GetNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).GetNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/GetNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).GetNote(ctx, req.(*GetNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListNotes(ctx, req.(*ListNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_DeleteNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).DeleteNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/DeleteNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).DeleteNote(ctx, req.(*DeleteNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_CreateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).CreateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/CreateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).CreateNote(ctx, req.(*CreateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_BatchCreateNotes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateNotesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).BatchCreateNotes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/BatchCreateNotes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).BatchCreateNotes(ctx, req.(*BatchCreateNotesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_UpdateNote_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNoteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).UpdateNote(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/UpdateNote",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).UpdateNote(ctx, req.(*UpdateNoteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Grafeas_ListNoteOccurrences_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNoteOccurrencesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GrafeasServer).ListNoteOccurrences(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/grafeas.v1.Grafeas/ListNoteOccurrences",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GrafeasServer).ListNoteOccurrences(ctx, req.(*ListNoteOccurrencesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Grafeas_serviceDesc = grpc.ServiceDesc{
	ServiceName: "grafeas.v1.Grafeas",
	HandlerType: (*GrafeasServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOccurrence",
			Handler:    _Grafeas_GetOccurrence_Handler,
		},
		{
			MethodName: "ListOccurrences",
			Handler:    _Grafeas_ListOccurrences_Handler,
		},
		{
			MethodName: "DeleteOccurrence",
			Handler:    _Grafeas_DeleteOccurrence_Handler,
		},
		{
			MethodName: "CreateOccurrence",
			Handler:    _Grafeas_CreateOccurrence_Handler,
		},
		{
			MethodName: "BatchCreateOccurrences",
			Handler:    _Grafeas_BatchCreateOccurrences_Handler,
		},
		{
			MethodName: "UpdateOccurrence",
			Handler:    _Grafeas_UpdateOccurrence_Handler,
		},
		{
			MethodName: "GetOccurrenceNote",
			Handler:    _Grafeas_GetOccurrenceNote_Handler,
		},
		{
			MethodName: "GetNote",
			Handler:    _Grafeas_GetNote_Handler,
		},
		{
			MethodName: "ListNotes",
			Handler:    _Grafeas_ListNotes_Handler,
		},
		{
			MethodName: "DeleteNote",
			Handler:    _Grafeas_DeleteNote_Handler,
		},
		{
			MethodName: "CreateNote",
			Handler:    _Grafeas_CreateNote_Handler,
		},
		{
			MethodName: "BatchCreateNotes",
			Handler:    _Grafeas_BatchCreateNotes_Handler,
		},
		{
			MethodName: "UpdateNote",
			Handler:    _Grafeas_UpdateNote_Handler,
		},
		{
			MethodName: "ListNoteOccurrences",
			Handler:    _Grafeas_ListNoteOccurrences_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "proto/v1/grafeas.proto",
}
