// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/monitoring/v3/alert.proto

package monitoring

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Operators for combining conditions.
type AlertPolicy_ConditionCombinerType int32

const (
	// An unspecified combiner.
	AlertPolicy_COMBINE_UNSPECIFIED AlertPolicy_ConditionCombinerType = 0
	// Combine conditions using the logical `AND` operator. An
	// incident is created only if all the conditions are met
	// simultaneously. This combiner is satisfied if all conditions are
	// met, even if they are met on completely different resources.
	AlertPolicy_AND AlertPolicy_ConditionCombinerType = 1
	// Combine conditions using the logical `OR` operator. An incident
	// is created if any of the listed conditions is met.
	AlertPolicy_OR AlertPolicy_ConditionCombinerType = 2
	// Combine conditions using logical `AND` operator, but unlike the regular
	// `AND` option, an incident is created only if all conditions are met
	// simultaneously on at least one resource.
	AlertPolicy_AND_WITH_MATCHING_RESOURCE AlertPolicy_ConditionCombinerType = 3
)

// Enum value maps for AlertPolicy_ConditionCombinerType.
var (
	AlertPolicy_ConditionCombinerType_name = map[int32]string{
		0: "COMBINE_UNSPECIFIED",
		1: "AND",
		2: "OR",
		3: "AND_WITH_MATCHING_RESOURCE",
	}
	AlertPolicy_ConditionCombinerType_value = map[string]int32{
		"COMBINE_UNSPECIFIED":        0,
		"AND":                        1,
		"OR":                         2,
		"AND_WITH_MATCHING_RESOURCE": 3,
	}
)

func (x AlertPolicy_ConditionCombinerType) Enum() *AlertPolicy_ConditionCombinerType {
	p := new(AlertPolicy_ConditionCombinerType)
	*p = x
	return p
}

func (x AlertPolicy_ConditionCombinerType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AlertPolicy_ConditionCombinerType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_v3_alert_proto_enumTypes[0].Descriptor()
}

func (AlertPolicy_ConditionCombinerType) Type() protoreflect.EnumType {
	return &file_google_monitoring_v3_alert_proto_enumTypes[0]
}

func (x AlertPolicy_ConditionCombinerType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AlertPolicy_ConditionCombinerType.Descriptor instead.
func (AlertPolicy_ConditionCombinerType) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 0}
}

// A description of the conditions under which some aspect of your system is
// considered to be "unhealthy" and the ways to notify people or services about
// this state. For an overview of alert policies, see
// [Introduction to Alerting](https://cloud.google.com/monitoring/alerts/).
type AlertPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required if the policy exists. The resource name for this policy. The
	// format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[ALERT_POLICY_ID]
	//
	// `[ALERT_POLICY_ID]` is assigned by Stackdriver Monitoring when the policy
	// is created.  When calling the
	// [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
	// method, do not include the `name` field in the alerting policy passed as
	// part of the request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A short name or phrase used to identify the policy in dashboards,
	// notifications, and incidents. To avoid confusion, don't use the same
	// display name for multiple policies in the same project. The name is
	// limited to 512 Unicode characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Documentation that is included with notifications and incidents related to
	// this policy. Best practice is for the documentation to include information
	// to help responders understand, mitigate, escalate, and correct the
	// underlying problems detected by the alerting policy. Notification channels
	// that have limited capacity might not show this documentation.
	Documentation *AlertPolicy_Documentation `protobuf:"bytes,13,opt,name=documentation,proto3" json:"documentation,omitempty"`
	// User-supplied key/value data to be used for organizing and
	// identifying the `AlertPolicy` objects.
	//
	// The field can contain up to 64 entries. Each key and value is limited to
	// 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
	// values can contain only lowercase letters, numerals, underscores, and
	// dashes. Keys must begin with a letter.
	UserLabels map[string]string `protobuf:"bytes,16,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A list of conditions for the policy. The conditions are combined by AND or
	// OR according to the `combiner` field. If the combined conditions evaluate
	// to true, then an incident is created. A policy can have from one to six
	// conditions.
	// If `condition_time_series_query_language` is present, it must be the only
	// `condition`.
	Conditions []*AlertPolicy_Condition `protobuf:"bytes,12,rep,name=conditions,proto3" json:"conditions,omitempty"`
	// How to combine the results of multiple conditions to determine if an
	// incident should be opened.
	// If `condition_time_series_query_language` is present, this must be
	// `COMBINE_UNSPECIFIED`.
	Combiner AlertPolicy_ConditionCombinerType `protobuf:"varint,6,opt,name=combiner,proto3,enum=google.monitoring.v3.AlertPolicy_ConditionCombinerType" json:"combiner,omitempty"`
	// Whether or not the policy is enabled. On write, the default interpretation
	// if unset is that the policy is enabled. On read, clients should not make
	// any assumption about the state if it has not been populated. The
	// field should always be populated on List and Get operations, unless
	// a field projection has been specified that strips it out.
	Enabled *wrapperspb.BoolValue `protobuf:"bytes,17,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Read-only description of how the alert policy is invalid. OK if the alert
	// policy is valid. If not OK, the alert policy will not generate incidents.
	Validity *status.Status `protobuf:"bytes,18,opt,name=validity,proto3" json:"validity,omitempty"`
	// Identifies the notification channels to which notifications should be sent
	// when incidents are opened or closed or when new violations occur on
	// an already opened incident. Each element of this array corresponds to
	// the `name` field in each of the
	// [`NotificationChannel`][google.monitoring.v3.NotificationChannel]
	// objects that are returned from the [`ListNotificationChannels`]
	// [google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
	// method. The format of the entries in this field is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/notificationChannels/[CHANNEL_ID]
	NotificationChannels []string `protobuf:"bytes,14,rep,name=notification_channels,json=notificationChannels,proto3" json:"notification_channels,omitempty"`
	// A read-only record of the creation of the alerting policy. If provided
	// in a call to create or update, this field will be ignored.
	CreationRecord *MutationRecord `protobuf:"bytes,10,opt,name=creation_record,json=creationRecord,proto3" json:"creation_record,omitempty"`
	// A read-only record of the most recent change to the alerting policy. If
	// provided in a call to create or update, this field will be ignored.
	MutationRecord *MutationRecord `protobuf:"bytes,11,opt,name=mutation_record,json=mutationRecord,proto3" json:"mutation_record,omitempty"`
}

func (x *AlertPolicy) Reset() {
	*x = AlertPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy) ProtoMessage() {}

func (x *AlertPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy.ProtoReflect.Descriptor instead.
func (*AlertPolicy) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0}
}

func (x *AlertPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlertPolicy) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AlertPolicy) GetDocumentation() *AlertPolicy_Documentation {
	if x != nil {
		return x.Documentation
	}
	return nil
}

func (x *AlertPolicy) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *AlertPolicy) GetConditions() []*AlertPolicy_Condition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *AlertPolicy) GetCombiner() AlertPolicy_ConditionCombinerType {
	if x != nil {
		return x.Combiner
	}
	return AlertPolicy_COMBINE_UNSPECIFIED
}

func (x *AlertPolicy) GetEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

func (x *AlertPolicy) GetValidity() *status.Status {
	if x != nil {
		return x.Validity
	}
	return nil
}

func (x *AlertPolicy) GetNotificationChannels() []string {
	if x != nil {
		return x.NotificationChannels
	}
	return nil
}

func (x *AlertPolicy) GetCreationRecord() *MutationRecord {
	if x != nil {
		return x.CreationRecord
	}
	return nil
}

func (x *AlertPolicy) GetMutationRecord() *MutationRecord {
	if x != nil {
		return x.MutationRecord
	}
	return nil
}

// A content string and a MIME type that describes the content string's
// format.
type AlertPolicy_Documentation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text of the documentation, interpreted according to `mime_type`.
	// The content may not exceed 8,192 Unicode characters and may not exceed
	// more than 10,240 bytes when encoded in UTF-8 format, whichever is
	// smaller.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// The format of the `content` field. Presently, only the value
	// `"text/markdown"` is supported. See
	// [Markdown](https://en.wikipedia.org/wiki/Markdown) for more information.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *AlertPolicy_Documentation) Reset() {
	*x = AlertPolicy_Documentation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy_Documentation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy_Documentation) ProtoMessage() {}

func (x *AlertPolicy_Documentation) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy_Documentation.ProtoReflect.Descriptor instead.
func (*AlertPolicy_Documentation) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AlertPolicy_Documentation) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *AlertPolicy_Documentation) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// A condition is a true/false test that determines when an alerting policy
// should open an incident. If a condition evaluates to true, it signifies
// that something is wrong.
type AlertPolicy_Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required if the condition exists. The unique resource name for this
	// condition. Its format is:
	//
	//     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
	//
	// `[CONDITION_ID]` is assigned by Stackdriver Monitoring when the
	// condition is created as part of a new or updated alerting policy.
	//
	// When calling the
	// [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
	// method, do not include the `name` field in the conditions of the
	// requested alerting policy. Stackdriver Monitoring creates the
	// condition identifiers and includes them in the new policy.
	//
	// When calling the
	// [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
	// method to update a policy, including a condition `name` causes the
	// existing condition to be updated. Conditions without names are added to
	// the updated policy. Existing conditions are deleted if they are not
	// updated.
	//
	// Best practice is to preserve `[CONDITION_ID]` if you make only small
	// changes, such as those to condition thresholds, durations, or trigger
	// values.  Otherwise, treat the change as a new condition and let the
	// existing condition be deleted.
	Name string `protobuf:"bytes,12,opt,name=name,proto3" json:"name,omitempty"`
	// A short name or phrase used to identify the condition in dashboards,
	// notifications, and incidents. To avoid confusion, don't use the same
	// display name for multiple conditions in the same policy.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Only one of the following condition types will be specified.
	//
	// Types that are assignable to Condition:
	//	*AlertPolicy_Condition_ConditionThreshold
	//	*AlertPolicy_Condition_ConditionAbsent
	Condition isAlertPolicy_Condition_Condition `protobuf_oneof:"condition"`
}

func (x *AlertPolicy_Condition) Reset() {
	*x = AlertPolicy_Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy_Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy_Condition) ProtoMessage() {}

func (x *AlertPolicy_Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy_Condition.ProtoReflect.Descriptor instead.
func (*AlertPolicy_Condition) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AlertPolicy_Condition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AlertPolicy_Condition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *AlertPolicy_Condition) GetCondition() isAlertPolicy_Condition_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (x *AlertPolicy_Condition) GetConditionThreshold() *AlertPolicy_Condition_MetricThreshold {
	if x, ok := x.GetCondition().(*AlertPolicy_Condition_ConditionThreshold); ok {
		return x.ConditionThreshold
	}
	return nil
}

func (x *AlertPolicy_Condition) GetConditionAbsent() *AlertPolicy_Condition_MetricAbsence {
	if x, ok := x.GetCondition().(*AlertPolicy_Condition_ConditionAbsent); ok {
		return x.ConditionAbsent
	}
	return nil
}

type isAlertPolicy_Condition_Condition interface {
	isAlertPolicy_Condition_Condition()
}

type AlertPolicy_Condition_ConditionThreshold struct {
	// A condition that compares a time series against a threshold.
	ConditionThreshold *AlertPolicy_Condition_MetricThreshold `protobuf:"bytes,1,opt,name=condition_threshold,json=conditionThreshold,proto3,oneof"`
}

type AlertPolicy_Condition_ConditionAbsent struct {
	// A condition that checks that a time series continues to
	// receive new data points.
	ConditionAbsent *AlertPolicy_Condition_MetricAbsence `protobuf:"bytes,2,opt,name=condition_absent,json=conditionAbsent,proto3,oneof"`
}

func (*AlertPolicy_Condition_ConditionThreshold) isAlertPolicy_Condition_Condition() {}

func (*AlertPolicy_Condition_ConditionAbsent) isAlertPolicy_Condition_Condition() {}

// Specifies how many time series must fail a predicate to trigger a
// condition. If not specified, then a `{count: 1}` trigger is used.
type AlertPolicy_Condition_Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A type of trigger.
	//
	// Types that are assignable to Type:
	//	*AlertPolicy_Condition_Trigger_Count
	//	*AlertPolicy_Condition_Trigger_Percent
	Type isAlertPolicy_Condition_Trigger_Type `protobuf_oneof:"type"`
}

func (x *AlertPolicy_Condition_Trigger) Reset() {
	*x = AlertPolicy_Condition_Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy_Condition_Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy_Condition_Trigger) ProtoMessage() {}

func (x *AlertPolicy_Condition_Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy_Condition_Trigger.ProtoReflect.Descriptor instead.
func (*AlertPolicy_Condition_Trigger) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (m *AlertPolicy_Condition_Trigger) GetType() isAlertPolicy_Condition_Trigger_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AlertPolicy_Condition_Trigger) GetCount() int32 {
	if x, ok := x.GetType().(*AlertPolicy_Condition_Trigger_Count); ok {
		return x.Count
	}
	return 0
}

func (x *AlertPolicy_Condition_Trigger) GetPercent() float64 {
	if x, ok := x.GetType().(*AlertPolicy_Condition_Trigger_Percent); ok {
		return x.Percent
	}
	return 0
}

type isAlertPolicy_Condition_Trigger_Type interface {
	isAlertPolicy_Condition_Trigger_Type()
}

type AlertPolicy_Condition_Trigger_Count struct {
	// The absolute number of time series that must fail
	// the predicate for the condition to be triggered.
	Count int32 `protobuf:"varint,1,opt,name=count,proto3,oneof"`
}

type AlertPolicy_Condition_Trigger_Percent struct {
	// The percentage of time series that must fail the
	// predicate for the condition to be triggered.
	Percent float64 `protobuf:"fixed64,2,opt,name=percent,proto3,oneof"`
}

func (*AlertPolicy_Condition_Trigger_Count) isAlertPolicy_Condition_Trigger_Type() {}

func (*AlertPolicy_Condition_Trigger_Percent) isAlertPolicy_Condition_Trigger_Type() {}

// A condition type that compares a collection of time series
// against a threshold.
type AlertPolicy_Condition_MetricThreshold struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies which time series should be compared with the threshold.
	//
	// The filter is similar to the one that is specified in the
	// [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
	// (that call is useful to verify the time series that will be retrieved /
	// processed) and must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the alignment of data points in individual time series as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resrouces). Multiple aggregations
	// are applied in the order specified.
	//
	// This field is similar to the one in the [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	// It is advisable to use the `ListTimeSeries` method when debugging this
	// field.
	Aggregations []*Aggregation `protobuf:"bytes,8,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies a time series that should be used as the denominator of a
	// ratio that will be compared with the threshold. If a
	// `denominator_filter` is specified, the time series specified by the
	// `filter` field will be used as the numerator.
	//
	// The filter must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	DenominatorFilter string `protobuf:"bytes,9,opt,name=denominator_filter,json=denominatorFilter,proto3" json:"denominator_filter,omitempty"`
	// Specifies the alignment of data points in individual time series
	// selected by `denominatorFilter` as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resources).
	//
	// When computing ratios, the `aggregations` and
	// `denominator_aggregations` fields must use the same alignment period
	// and produce time series that have the same periodicity and labels.
	DenominatorAggregations []*Aggregation `protobuf:"bytes,10,rep,name=denominator_aggregations,json=denominatorAggregations,proto3" json:"denominator_aggregations,omitempty"`
	// The comparison to apply between the time series (indicated by `filter`
	// and `aggregation`) and the threshold (indicated by `threshold_value`).
	// The comparison is applied on each time series, with the time series
	// on the left-hand side and the threshold on the right-hand side.
	//
	// Only `COMPARISON_LT` and `COMPARISON_GT` are supported currently.
	Comparison ComparisonType `protobuf:"varint,4,opt,name=comparison,proto3,enum=google.monitoring.v3.ComparisonType" json:"comparison,omitempty"`
	// A value against which to compare the time series.
	ThresholdValue float64 `protobuf:"fixed64,5,opt,name=threshold_value,json=thresholdValue,proto3" json:"threshold_value,omitempty"`
	// The amount of time that a time series must violate the
	// threshold to be considered failing. Currently, only values
	// that are a multiple of a minute--e.g., 0, 60, 120, or 300
	// seconds--are supported. If an invalid value is given, an
	// error will be returned. When choosing a duration, it is useful to
	// keep in mind the frequency of the underlying time series data
	// (which may also be affected by any alignments specified in the
	// `aggregations` field); a good duration is long enough so that a single
	// outlier does not generate spurious alerts, but short enough that
	// unhealthy states are detected and alerted on quickly.
	Duration *durationpb.Duration `protobuf:"bytes,6,opt,name=duration,proto3" json:"duration,omitempty"`
	// The number/percent of time series for which the comparison must hold
	// in order for the condition to trigger. If unspecified, then the
	// condition will trigger if the comparison is true for any of the
	// time series that have been identified by `filter` and `aggregations`,
	// or by the ratio, if `denominator_filter` and `denominator_aggregations`
	// are specified.
	Trigger *AlertPolicy_Condition_Trigger `protobuf:"bytes,7,opt,name=trigger,proto3" json:"trigger,omitempty"`
}

func (x *AlertPolicy_Condition_MetricThreshold) Reset() {
	*x = AlertPolicy_Condition_MetricThreshold{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy_Condition_MetricThreshold) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy_Condition_MetricThreshold) ProtoMessage() {}

func (x *AlertPolicy_Condition_MetricThreshold) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy_Condition_MetricThreshold.ProtoReflect.Descriptor instead.
func (*AlertPolicy_Condition_MetricThreshold) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *AlertPolicy_Condition_MetricThreshold) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *AlertPolicy_Condition_MetricThreshold) GetAggregations() []*Aggregation {
	if x != nil {
		return x.Aggregations
	}
	return nil
}

func (x *AlertPolicy_Condition_MetricThreshold) GetDenominatorFilter() string {
	if x != nil {
		return x.DenominatorFilter
	}
	return ""
}

func (x *AlertPolicy_Condition_MetricThreshold) GetDenominatorAggregations() []*Aggregation {
	if x != nil {
		return x.DenominatorAggregations
	}
	return nil
}

func (x *AlertPolicy_Condition_MetricThreshold) GetComparison() ComparisonType {
	if x != nil {
		return x.Comparison
	}
	return ComparisonType_COMPARISON_UNSPECIFIED
}

func (x *AlertPolicy_Condition_MetricThreshold) GetThresholdValue() float64 {
	if x != nil {
		return x.ThresholdValue
	}
	return 0
}

func (x *AlertPolicy_Condition_MetricThreshold) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *AlertPolicy_Condition_MetricThreshold) GetTrigger() *AlertPolicy_Condition_Trigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

// A condition type that checks that monitored resources
// are reporting data. The configuration defines a metric and
// a set of monitored resources. The predicate is considered in violation
// when a time series for the specified metric of a monitored
// resource does not include any data in the specified `duration`.
type AlertPolicy_Condition_MetricAbsence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A [filter](https://cloud.google.com/monitoring/api/v3/filters) that
	// identifies which time series should be compared with the threshold.
	//
	// The filter is similar to the one that is specified in the
	// [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list)
	// (that call is useful to verify the time series that will be retrieved /
	// processed) and must specify the metric type and optionally may contain
	// restrictions on resource type, resource labels, and metric labels.
	// This field may not exceed 2048 Unicode characters in length.
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specifies the alignment of data points in individual time series as
	// well as how to combine the retrieved time series together (such as
	// when aggregating multiple streams on each resource to a single
	// stream for each resource or when aggregating streams across all
	// members of a group of resrouces). Multiple aggregations
	// are applied in the order specified.
	//
	// This field is similar to the one in the [`ListTimeSeries`
	// request](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.timeSeries/list).
	// It is advisable to use the `ListTimeSeries` method when debugging this
	// field.
	Aggregations []*Aggregation `protobuf:"bytes,5,rep,name=aggregations,proto3" json:"aggregations,omitempty"`
	// The amount of time that a time series must fail to report new
	// data to be considered failing. Currently, only values that
	// are a multiple of a minute--e.g.  60, 120, or 300
	// seconds--are supported. If an invalid value is given, an
	// error will be returned. The `Duration.nanos` field is
	// ignored.
	Duration *durationpb.Duration `protobuf:"bytes,2,opt,name=duration,proto3" json:"duration,omitempty"`
	// The number/percent of time series for which the comparison must hold
	// in order for the condition to trigger. If unspecified, then the
	// condition will trigger if the comparison is true for any of the
	// time series that have been identified by `filter` and `aggregations`.
	Trigger *AlertPolicy_Condition_Trigger `protobuf:"bytes,3,opt,name=trigger,proto3" json:"trigger,omitempty"`
}

func (x *AlertPolicy_Condition_MetricAbsence) Reset() {
	*x = AlertPolicy_Condition_MetricAbsence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_v3_alert_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AlertPolicy_Condition_MetricAbsence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlertPolicy_Condition_MetricAbsence) ProtoMessage() {}

func (x *AlertPolicy_Condition_MetricAbsence) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_v3_alert_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlertPolicy_Condition_MetricAbsence.ProtoReflect.Descriptor instead.
func (*AlertPolicy_Condition_MetricAbsence) Descriptor() ([]byte, []int) {
	return file_google_monitoring_v3_alert_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (x *AlertPolicy_Condition_MetricAbsence) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *AlertPolicy_Condition_MetricAbsence) GetAggregations() []*Aggregation {
	if x != nil {
		return x.Aggregations
	}
	return nil
}

func (x *AlertPolicy_Condition_MetricAbsence) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *AlertPolicy_Condition_MetricAbsence) GetTrigger() *AlertPolicy_Condition_Trigger {
	if x != nil {
		return x.Trigger
	}
	return nil
}

var File_google_monitoring_v3_alert_proto protoreflect.FileDescriptor

var file_google_monitoring_v3_alert_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x14, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x33, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x13, 0x0a, 0x0b,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x55, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x0b, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4b, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x08, 0x63, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65,
	0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x72, 0x12,
	0x34, 0x0a, 0x07, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x07, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x08, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x69, 0x74,
	0x79, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x08, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x69, 0x74, 0x79, 0x12, 0x33, 0x0a, 0x15, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x0e,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x4d, 0x0a, 0x0f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0e, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x4d, 0x0a, 0x0f, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0e, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x1a, 0x46, 0x0a, 0x0d, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65,
	0x1a, 0xf4, 0x0a, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x48,
	0x00, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x66, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x41, 0x62, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x62, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x45, 0x0a,
	0x07, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1a, 0x0a, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x48, 0x00, 0x52, 0x07, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x42, 0x06, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x1a, 0xf2, 0x03, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x45, 0x0a, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x64, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x18, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x6e, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e,
	0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x64, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x44, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x01, 0x52, 0x0e, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x07, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x1a, 0xf4, 0x01, 0x0a, 0x0d, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x41, 0x62, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x0c, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x67,
	0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x4d, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x33, 0x2e, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x52, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x3a, 0x97, 0x02, 0xea, 0x41, 0x93, 0x02, 0x0a, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12,
	0x50, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x6c,
	0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65,
	0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x12, 0x44, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x12, 0x01, 0x2a, 0x42, 0x0b, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x61, 0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4d, 0x42, 0x49, 0x4e, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4e, 0x44, 0x10,
	0x01, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x52, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x4e, 0x44,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x03, 0x3a, 0xc9, 0x01, 0xea, 0x41, 0xc5, 0x01,
	0x0a, 0x25, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72,
	0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x12, 0x39, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x7d, 0x12, 0x2d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x7d, 0x12, 0x01, 0x2a, 0x42, 0xc2, 0x01, 0x0a, 0x18, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x33, 0x42, 0x0a, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x33, 0x3b, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x33, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_monitoring_v3_alert_proto_rawDescOnce sync.Once
	file_google_monitoring_v3_alert_proto_rawDescData = file_google_monitoring_v3_alert_proto_rawDesc
)

func file_google_monitoring_v3_alert_proto_rawDescGZIP() []byte {
	file_google_monitoring_v3_alert_proto_rawDescOnce.Do(func() {
		file_google_monitoring_v3_alert_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_v3_alert_proto_rawDescData)
	})
	return file_google_monitoring_v3_alert_proto_rawDescData
}

var file_google_monitoring_v3_alert_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_monitoring_v3_alert_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_monitoring_v3_alert_proto_goTypes = []interface{}{
	(AlertPolicy_ConditionCombinerType)(0),        // 0: google.monitoring.v3.AlertPolicy.ConditionCombinerType
	(*AlertPolicy)(nil),                           // 1: google.monitoring.v3.AlertPolicy
	(*AlertPolicy_Documentation)(nil),             // 2: google.monitoring.v3.AlertPolicy.Documentation
	(*AlertPolicy_Condition)(nil),                 // 3: google.monitoring.v3.AlertPolicy.Condition
	nil,                                           // 4: google.monitoring.v3.AlertPolicy.UserLabelsEntry
	(*AlertPolicy_Condition_Trigger)(nil),         // 5: google.monitoring.v3.AlertPolicy.Condition.Trigger
	(*AlertPolicy_Condition_MetricThreshold)(nil), // 6: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
	(*AlertPolicy_Condition_MetricAbsence)(nil),   // 7: google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
	(*wrapperspb.BoolValue)(nil),                  // 8: google.protobuf.BoolValue
	(*status.Status)(nil),                         // 9: google.rpc.Status
	(*MutationRecord)(nil),                        // 10: google.monitoring.v3.MutationRecord
	(*Aggregation)(nil),                           // 11: google.monitoring.v3.Aggregation
	(ComparisonType)(0),                           // 12: google.monitoring.v3.ComparisonType
	(*durationpb.Duration)(nil),                   // 13: google.protobuf.Duration
}
var file_google_monitoring_v3_alert_proto_depIdxs = []int32{
	2,  // 0: google.monitoring.v3.AlertPolicy.documentation:type_name -> google.monitoring.v3.AlertPolicy.Documentation
	4,  // 1: google.monitoring.v3.AlertPolicy.user_labels:type_name -> google.monitoring.v3.AlertPolicy.UserLabelsEntry
	3,  // 2: google.monitoring.v3.AlertPolicy.conditions:type_name -> google.monitoring.v3.AlertPolicy.Condition
	0,  // 3: google.monitoring.v3.AlertPolicy.combiner:type_name -> google.monitoring.v3.AlertPolicy.ConditionCombinerType
	8,  // 4: google.monitoring.v3.AlertPolicy.enabled:type_name -> google.protobuf.BoolValue
	9,  // 5: google.monitoring.v3.AlertPolicy.validity:type_name -> google.rpc.Status
	10, // 6: google.monitoring.v3.AlertPolicy.creation_record:type_name -> google.monitoring.v3.MutationRecord
	10, // 7: google.monitoring.v3.AlertPolicy.mutation_record:type_name -> google.monitoring.v3.MutationRecord
	6,  // 8: google.monitoring.v3.AlertPolicy.Condition.condition_threshold:type_name -> google.monitoring.v3.AlertPolicy.Condition.MetricThreshold
	7,  // 9: google.monitoring.v3.AlertPolicy.Condition.condition_absent:type_name -> google.monitoring.v3.AlertPolicy.Condition.MetricAbsence
	11, // 10: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.aggregations:type_name -> google.monitoring.v3.Aggregation
	11, // 11: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.denominator_aggregations:type_name -> google.monitoring.v3.Aggregation
	12, // 12: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.comparison:type_name -> google.monitoring.v3.ComparisonType
	13, // 13: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.duration:type_name -> google.protobuf.Duration
	5,  // 14: google.monitoring.v3.AlertPolicy.Condition.MetricThreshold.trigger:type_name -> google.monitoring.v3.AlertPolicy.Condition.Trigger
	11, // 15: google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.aggregations:type_name -> google.monitoring.v3.Aggregation
	13, // 16: google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.duration:type_name -> google.protobuf.Duration
	5,  // 17: google.monitoring.v3.AlertPolicy.Condition.MetricAbsence.trigger:type_name -> google.monitoring.v3.AlertPolicy.Condition.Trigger
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_monitoring_v3_alert_proto_init() }
func file_google_monitoring_v3_alert_proto_init() {
	if File_google_monitoring_v3_alert_proto != nil {
		return
	}
	file_google_monitoring_v3_common_proto_init()
	file_google_monitoring_v3_mutation_record_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_v3_alert_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_alert_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy_Documentation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_alert_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy_Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_alert_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy_Condition_Trigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_alert_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy_Condition_MetricThreshold); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_v3_alert_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AlertPolicy_Condition_MetricAbsence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_monitoring_v3_alert_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*AlertPolicy_Condition_ConditionThreshold)(nil),
		(*AlertPolicy_Condition_ConditionAbsent)(nil),
	}
	file_google_monitoring_v3_alert_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*AlertPolicy_Condition_Trigger_Count)(nil),
		(*AlertPolicy_Condition_Trigger_Percent)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_v3_alert_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_v3_alert_proto_goTypes,
		DependencyIndexes: file_google_monitoring_v3_alert_proto_depIdxs,
		EnumInfos:         file_google_monitoring_v3_alert_proto_enumTypes,
		MessageInfos:      file_google_monitoring_v3_alert_proto_msgTypes,
	}.Build()
	File_google_monitoring_v3_alert_proto = out.File
	file_google_monitoring_v3_alert_proto_rawDesc = nil
	file_google_monitoring_v3_alert_proto_goTypes = nil
	file_google_monitoring_v3_alert_proto_depIdxs = nil
}
