/*
Copyright 2020 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/tektoncd/pipeline/pkg/apis/pipeline/v1alpha1"
	scheme "github.com/tektoncd/pipeline/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// RunsGetter has a method to return a RunInterface.
// A group's client should implement this interface.
type RunsGetter interface {
	Runs(namespace string) RunInterface
}

// RunInterface has methods to work with Run resources.
type RunInterface interface {
	Create(*v1alpha1.Run) (*v1alpha1.Run, error)
	Update(*v1alpha1.Run) (*v1alpha1.Run, error)
	UpdateStatus(*v1alpha1.Run) (*v1alpha1.Run, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Run, error)
	List(opts v1.ListOptions) (*v1alpha1.RunList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Run, err error)
	RunExpansion
}

// runs implements RunInterface
type runs struct {
	client rest.Interface
	ns     string
}

// newRuns returns a Runs
func newRuns(c *TektonV1alpha1Client, namespace string) *runs {
	return &runs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the run, and returns the corresponding run object, and an error if there is any.
func (c *runs) Get(name string, options v1.GetOptions) (result *v1alpha1.Run, err error) {
	result = &v1alpha1.Run{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("runs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Runs that match those selectors.
func (c *runs) List(opts v1.ListOptions) (result *v1alpha1.RunList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.RunList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("runs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested runs.
func (c *runs) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("runs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a run and creates it.  Returns the server's representation of the run, and an error, if there is any.
func (c *runs) Create(run *v1alpha1.Run) (result *v1alpha1.Run, err error) {
	result = &v1alpha1.Run{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("runs").
		Body(run).
		Do().
		Into(result)
	return
}

// Update takes the representation of a run and updates it. Returns the server's representation of the run, and an error, if there is any.
func (c *runs) Update(run *v1alpha1.Run) (result *v1alpha1.Run, err error) {
	result = &v1alpha1.Run{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("runs").
		Name(run.Name).
		Body(run).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *runs) UpdateStatus(run *v1alpha1.Run) (result *v1alpha1.Run, err error) {
	result = &v1alpha1.Run{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("runs").
		Name(run.Name).
		SubResource("status").
		Body(run).
		Do().
		Into(result)
	return
}

// Delete takes name of the run and deletes it. Returns an error if one occurs.
func (c *runs) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("runs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *runs) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("runs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched run.
func (c *runs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Run, err error) {
	result = &v1alpha1.Run{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("runs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
