# cidr
[![Release](https://github.com/bschaatsbergen/cidr/actions/workflows/goreleaser.yaml/badge.svg)](https://github.com/bschaatsbergen/cidr/actions/workflows/goreleaser.yaml) ![GitHub release (latest SemVer)](https://img.shields.io/github/v/release/bschaatsbergen/cidr) ![GitHub commits since latest release (by SemVer)](https://img.shields.io/github/commits-since/bschaatsbergen/cidr/latest) [![Go Reference](https://pkg.go.dev/badge/github.com/bschaatsbergen/cidr.svg)](https://pkg.go.dev/github.com/bschaatsbergen/cidr)

CLI to perform various actions on CIDR ranges

## Brew
To install cidr using brew, simply run:

```sh
brew install cidr
```

## Binaries
You can download the [latest binary](https://github.com/bschaatsbergen/cidr/releases/latest) for Linux, MacOS, and Windows.


## Examples

Using `cidr` is very simple.

### Explain a CIDR range

To get more information on a CIDR range:

```
$ cidr explain 10.0.0.0/16
Base Address:            10.0.0.0
Usable Address Range:    10.0.0.1 to 10.0.255.254
Broadcast Address:       10.0.255.255
Address Count:           65,534
Netmask:                 255.255.0.0 (/16 bits)
```

This also works with IPv6 CIDR ranges, for example:

```
$ cidr explain 2001:db8:1234:1a00::/64
Base Address:            2001:db8:1234:1a00::
Usable Address Range:    2001:db8:1234:1a00:: to 2001:db8:1234:1a00:ffff:ffff:ffff:ffff
Address Count:           18,446,744,073,709,551,614
Netmask:                 ffff:ffff:ffff:ffff:: (/64 bits)
```

### Check whether an address belongs to a CIDR range

To check if a CIDR range contains an IP:

```
$ cidr contains 10.0.0.0/16 10.0.14.5
true
```

This also works with IPv6 addresses, for example:

```
$ cidr contains 2001:db8:1234:1a00::/106 2001:db8:1234:1a00::
true
```

### Count distinct host addresses

To get all distinct host addresses part of a given CIDR range:

```
$ cidr count 10.0.0.0/16
65534
```

This also works with a IPv6 CIDR range, for example:

```
$ cidr count 2001:db8:1234:1a00::/106
4194302
```

Or with a large prefix like a point-to-point link CIDR range:

```
$ cidr count 172.16.18.0/31
2
```

### CIDR range intersection

To check if a CIDR range overlaps with another CIDR range:

```
$ cidr overlaps 10.0.0.0/16 10.0.14.0/22
true
```

This also works with IPv6 CIDR ranges, for example:

```
$ cidr overlaps 2001:db8:1111:2222:1::/80 2001:db8:1111:2222:1:1::/96
true
```

## Contributing

Contributions are highly appreciated and always welcome.
Have a look through existing [Issues](https://github.com/bschaatsbergen/cidr/issues) and [Pull Requests](https://github.com/bschaatsbergen/cidr/pulls) that you could help with.
