# macOS

## Use `brew bundle` to manage your brews and casks

Homebrew's [`brew bundle` subcommand][bundle] allows you to specify a list of
brews and casks to be installed. You can integrate this with chezmoi by creating
a `run_onchange_` script. For example, create a file in your source directory
called `run_onchange_before_install-packages-darwin.sh.tmpl` containing:

```text
{{- if eq .chezmoi.os "darwin" -}}
#!/bin/bash

brew bundle --file=/dev/stdin <<EOF
brew "git"
cask "google-chrome"
EOF
{{ end -}}
```

!!! note

    The `Brewfile` is embedded directly in the script with a bash here
    document. chezmoi will run this script whenever its contents change, i.e.
    when you add or remove brews or casks.

## Determine the hostname

The result of the `hostname` command on macOS depends on the network that the
machine is connected to. For a stable result, use the `scutil` command:

```text
{{ $computerName := output "scutil" "--get" "ComputerName" | trim }}
```

## Run script after every macOS update

You can automate a script to run after each macOS update by creating
a `run_onchange_` script and using the `output` template function to run `sw_vers`:

```text
# MacOS build version: {{ output "sw_vers" "--buildVersion" }}
```

[bundle]: https://docs.brew.sh/Manpage#bundle-subcommand
