# `onepasswordDetailsFields` *uuid* [*vault-uuid* [*account-name*]]

`onepasswordDetailsFields` returns structured data from
[1Password](https://1password.com/) using the [1Password
CLI](https://support.1password.com/command-line-getting-started/) (`op`).
*uuid* is passed to `op get item <uuid>`, the output from `op` is parsed as
JSON, and elements of `details.fields` are returned as a map indexed by each
field's `designation`. If there is no valid session in the environment, by
default you will be interactively prompted to sign in.

The output from `op` is cached so calling `onepasswordDetailsFields` multiple
times with the same *uuid* will only invoke `op` once.  If the optional
*vault-uuid* is supplied, it will be passed along to the `op get` call, which
can significantly improve performance. If the optional *account-name* is
supplied, it will be passed along to the `op get` call, which will help it look
in the right account, in case you have multiple accounts (eg. personal and work
accounts).

!!! example

    ```
    {{ (onepasswordDetailsFields "<uuid>").password.value }}
    {{ (onepasswordDetailsFields "<uuid>" "<vault-uuid>").password.value }}
    {{ (onepasswordDetailsFields "<uuid>" "<vault-uuid>" "<account-name>").password.value }}
    {{ (onepasswordDetailsFields "<uuid>" "" "<account-name>").password.value }}
    ```

!!! example

    Given the output from `op`:

    ```json
    {
        "uuid": "<uuid>",
        "details": {
            "fields": [
                {
                    "designation": "username",
                    "name": "username",
                    "type": "T",
                    "value": "exampleuser"
                },
                {
                    "designation": "password",
                    "name": "password",
                    "type": "P",
                    "value": "examplepassword"
                }
            ]
        }
    }
    ```

    the return value of `onepasswordDetailsFields` will be the map:

    ```json
    {
        "username": {
            "designation": "username",
            "name": "username",
            "type": "T",
            "value": "exampleuser"
        },
        "password": {
            "designation": "password",
            "name": "password",
            "type": "P",
            "value": "examplepassword"
        }
    }
    ```
